/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.validation.internal.constraintvalidators;

import io.xlate.validation.constraints.Expression;
import io.xlate.validation.internal.constraintvalidators.BooleanExpression;
import jakarta.el.ELManager;
import jakarta.el.ELProcessor;
import jakarta.el.ImportHandler;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.util.Arrays;
import java.util.function.Predicate;

@SupportedValidationTarget(value={ValidationTarget.ANNOTATED_ELEMENT, ValidationTarget.PARAMETERS})
public class ExpressionValidator
implements BooleanExpression,
ConstraintValidator<Expression, Object> {
    private Expression annotation;

    public void initialize(Expression constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(Object target, ConstraintValidatorContext context) {
        ELProcessor processor = this.buildProcessor(target);
        if (!this.evaluate(processor, this.annotation.when(), null)) {
            return true;
        }
        if (!this.evaluate(processor, this.annotation.value(), this.annotation.exceptionalValue().booleanValue())) {
            String[] node = (String[])Arrays.stream(this.annotation.node()).filter(Predicate.not(String::isEmpty)).toArray(String[]::new);
            if (node.length > 0) {
                context.disableDefaultConstraintViolation();
                ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext builder = context.buildConstraintViolationWithTemplate(this.annotation.message()).addPropertyNode(node[0]);
                for (int n = 1; n < node.length; ++n) {
                    builder = builder.addPropertyNode(node[n]);
                }
                builder.addConstraintViolation();
            }
            return false;
        }
        return true;
    }

    ELProcessor buildProcessor(Object target) {
        ELProcessor processor = new ELProcessor();
        ELManager manager = processor.getELManager();
        ImportHandler imports = manager.getELContext().getImportHandler();
        String targetName = this.annotation.targetName();
        manager.addBeanNameResolver(this.newNameResolver(target, targetName));
        Arrays.stream(this.annotation.packageImports()).forEach(arg_0 -> ((ImportHandler)imports).importPackage(arg_0));
        Arrays.stream(this.annotation.classImports()).forEach(arg_0 -> ((ImportHandler)imports).importClass(arg_0));
        Arrays.stream(this.annotation.staticImports()).forEach(arg_0 -> ((ImportHandler)imports).importStatic(arg_0));
        return processor;
    }
}

