/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.validation.internal.constraintvalidators;

import io.xlate.validation.constraints.JdbcStatement;
import io.xlate.validation.internal.constraintvalidators.BooleanExpression;
import jakarta.el.ELManager;
import jakarta.el.ELProcessor;
import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ValidationException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JdbcStatementValidator
implements BooleanExpression,
ConstraintValidator<JdbcStatement, Object> {
    JdbcStatement annotation;
    DataSource dataSource;

    public void initialize(JdbcStatement constraintAnnotation) {
        this.annotation = constraintAnnotation;
        this.dataSource = JdbcStatementValidator.getDataSource(this.annotation.dataSourceLookup());
    }

    public boolean isValid(Object target, ConstraintValidatorContext context) {
        boolean valid;
        ELProcessor processor;
        String sql = this.annotation.value();
        String[] parameters = this.annotation.parameters();
        String when = this.annotation.when();
        if (!when.isEmpty() || parameters.length > 0) {
            processor = new ELProcessor();
            ELManager manager = processor.getELManager();
            manager.addBeanNameResolver(this.newNameResolver(target, "self"));
            if (!this.evaluate(processor, when, null)) {
                return true;
            }
        } else {
            processor = null;
        }
        if (!(valid = this.executeQuery(processor, sql, parameters))) {
            this.updateValidationContext(context, this.annotation.node(), this.annotation.message());
        }
        return valid;
    }

    static DataSource getDataSource(String dataSourceLookup) {
        DataSource source;
        try {
            source = dataSourceLookup.isEmpty() ? (DataSource)InitialContext.doLookup("java:comp/DefaultDataSource") : (DataSource)InitialContext.doLookup(dataSourceLookup);
        }
        catch (NamingException e) {
            throw new ValidationException("DataSource not found", (Throwable)e);
        }
        return source;
    }

    boolean executeQuery(ELProcessor processor, String sql, String[] parameters) {
        boolean valid;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            this.setParameters(processor, parameters, statement);
            try (ResultSet results = statement.executeQuery();){
                valid = results.next();
            }
        }
        catch (SQLException e) {
            throw new ValidationException((Throwable)e);
        }
        return valid;
    }

    void setParameters(ELProcessor processor, String[] parameters, PreparedStatement statement) {
        if (parameters.length == 0) {
            return;
        }
        int p = 0;
        for (String parameterExpression : parameters) {
            Object parameter;
            try {
                parameter = processor.eval(parameterExpression);
            }
            catch (Exception e) {
                throw new ConstraintDeclarationException((Throwable)e);
            }
            try {
                statement.setObject(++p, parameter);
            }
            catch (SQLException e) {
                String msg = "Expression `" + parameterExpression + "` does not evaluate to a valid JDBC parameter for marker #" + p;
                throw new ConstraintDeclarationException(msg, (Throwable)e);
            }
        }
    }

    void updateValidationContext(ConstraintValidatorContext context, String nodeName, String message) {
        if (nodeName.isEmpty()) {
            return;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(message).addPropertyNode(nodeName).addConstraintViolation();
    }
}

