/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.resolver;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;
import org.apache.maven.plugin.logging.Log;

public class CpResolver
implements ResourceResolver {
    private final Pattern protocolPattern;
    private final Log log;

    public CpResolver(Log log) {
        this.log = log;
        this.protocolPattern = Pattern.compile("^[\\w\\d]+:/.*");
    }

    public Source resolve(ResourceRequest resourceRequest) throws XPathException {
        String href = resourceRequest.uri;
        String base = resourceRequest.baseUri;
        Source ret = this.isCpProtocol(href, base) ? this.resolveToClasspath(href, base) : null;
        return ret;
    }

    private boolean isCpProtocol(String href, String base) {
        return href != null && href.startsWith("cp:/") || base != null && base.startsWith("cp:/");
    }

    private Source resolveToClasspath(String href, String base) {
        String fullUrl = this.isAbsolute(href) ? href : base + href;
        String path = this.removeCpPrefix(fullUrl);
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        StreamSource ret = new StreamSource(is);
        String systemId = this.getClass().getResource(path).toExternalForm();
        ret.setSystemId(this.normalizeUrl(systemId));
        return ret;
    }

    private boolean isAbsolute(String href) {
        return this.protocolPattern.matcher(href).matches();
    }

    private String removeCpPrefix(String fullUrl) {
        return fullUrl.substring(3);
    }

    private String normalizeUrl(String systemId) {
        try {
            URL url = new URL(systemId);
            String protocol = url.getProtocol();
            String path = url.getPath();
            String host = url.getHost();
            return new URL(protocol, host, path.replaceAll("\\/\\/", "/")).toExternalForm();
        }
        catch (MalformedURLException ex) {
            return systemId;
        }
    }
}

