/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.resolver;

import io.xspec.maven.xspecMavenPlugin.resolver.CpResolver;
import java.io.File;
import java.util.Collections;
import java.util.StringJoiner;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.CatalogResourceResolver;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;
import org.apache.maven.plugin.logging.Log;
import org.xmlresolver.ResolverFeature;

public class XSpecResourceResolver
implements ResourceResolver {
    private final CpResolver first;
    private final CatalogResourceResolver second;
    private final ResourceResolver third;
    private final Log logger;

    public XSpecResourceResolver(Configuration configuration, File catalog, Log logger) {
        this.logger = logger;
        this.first = new CpResolver(logger);
        this.second = new CatalogResourceResolver();
        this.second.setFeature(ResolverFeature.CATALOG_FILES, Collections.singletonList(catalog.toURI().toString()));
        this.third = new DirectResourceResolver(configuration);
        configuration.setResourceResolver((ResourceResolver)this);
    }

    public Source resolve(ResourceRequest resourceRequest) throws XPathException {
        this.logger.debug((CharSequence)("resolve(" + this.toString(resourceRequest) + ")"));
        Source ret = this.first.resolve(resourceRequest);
        if (ret != null) {
            this.logger.debug((CharSequence)("   resolved by CP -> " + ret.getSystemId()));
            return ret;
        }
        ret = this.second.resolve(resourceRequest);
        if (ret != null) {
            this.logger.debug((CharSequence)("   resolved by catalog -> " + ret.getSystemId()));
            return ret;
        }
        ret = this.third.resolve(resourceRequest);
        if (ret != null) {
            this.logger.debug((CharSequence)("   resolved by direct -> " + ret.getSystemId()));
            return ret;
        }
        this.outputRequest(resourceRequest);
        this.logger.error((CharSequence)"Dans le cul !");
        return null;
    }

    private String toString(ResourceRequest resourceRequest) {
        StringJoiner j = new StringJoiner(",", "{", "}");
        if (resourceRequest.uri != null) {
            j.add("uri: " + resourceRequest.uri);
        }
        if (resourceRequest.baseUri != null) {
            j.add("baseUri: " + resourceRequest.baseUri);
        }
        if (resourceRequest.relativeUri != null) {
            j.add("relativeUri: " + resourceRequest.relativeUri);
        }
        if (resourceRequest.publicId != null) {
            j.add("publicId: " + resourceRequest.publicId);
        }
        if (resourceRequest.entityName != null) {
            j.add("entityName: " + resourceRequest.entityName);
        }
        if (resourceRequest.nature != null) {
            j.add("nature: " + resourceRequest.nature);
        }
        if (resourceRequest.purpose != null) {
            j.add("purpose: " + resourceRequest.purpose);
        }
        return j.toString();
    }

    public static ResourceRequest buildRequest(String href, String base) {
        ResourceRequest resourceRequest = new ResourceRequest();
        resourceRequest.uri = href;
        resourceRequest.baseUri = base;
        return resourceRequest;
    }

    private void outputRequest(ResourceRequest resourceRequest) {
        Object ret = "resourceRequest:\n";
        ret = (String)ret + "   uri:            " + resourceRequest.uri + "\n";
        ret = (String)ret + "   baseUri:        " + resourceRequest.baseUri + "\n";
        ret = (String)ret + "   relativeUri:    " + resourceRequest.relativeUri + "\n";
        ret = (String)ret + "   publicId:       " + resourceRequest.publicId + "\n";
        ret = (String)ret + "   entityName:     " + resourceRequest.entityName + "\n";
        ret = (String)ret + "   nature:         " + resourceRequest.nature + "\n";
        ret = (String)ret + "   purpose:        " + resourceRequest.purpose + "\n";
        ret = (String)ret + "   uriIsNamespace: " + resourceRequest.uriIsNamespace + "\n";
        this.logger.debug((CharSequence)ret);
    }
}

