/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import io.xspec.maven.xspecMavenPlugin.utils.XSpecPluginException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.plexus.util.StringUtils;

public class CatalogWriter {
    public CatalogWriter(ClassLoader cl) throws XSpecPluginException {
    }

    public File writeCatalog(String userCatalogFilename, Properties environment, boolean keepGeneratedCatalog) throws XSpecPluginException, IOException, IllegalArgumentException {
        if (userCatalogFilename != null && environment == null) {
            throw new IllegalArgumentException("If you specify a userCatalogFilename, you must provide a non null environment.");
        }
        File tmpCatalog = File.createTempFile("tmp", "-catalog.xml");
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpCatalog), Charset.forName("UTF-8"));){
            XMLStreamWriter xmlWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(osw);
            xmlWriter = new IndentingXMLStreamWriter(xmlWriter);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("catalog");
            xmlWriter.setDefaultNamespace("urn:oasis:names:tc:entity:xmlns:xml:catalog");
            xmlWriter.writeNamespace("", "urn:oasis:names:tc:entity:xmlns:xml:catalog");
            if (userCatalogFilename != null) {
                xmlWriter.writeEmptyElement("nextCatalog");
                String catalogFilename = StringUtils.interpolate((String)userCatalogFilename, (Map)environment);
                try {
                    URI uri = new URI(catalogFilename);
                    if (uri.isAbsolute()) {
                        xmlWriter.writeAttribute("catalog", uri.toString());
                    } else {
                        xmlWriter.writeAttribute("catalog", new File(catalogFilename).toURI().toURL().toExternalForm());
                    }
                }
                catch (MalformedURLException | URISyntaxException | XMLStreamException ex) {
                    xmlWriter.writeAttribute("catalog", new File(catalogFilename).toURI().toURL().toExternalForm());
                }
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            osw.flush();
        }
        catch (XMLStreamException ex) {
            System.err.println("while creating catalog, exception thrown: " + ex.getClass().getName());
            throw new XSpecPluginException("while creating catalog", ex);
        }
        catch (NullPointerException ex) {
            System.err.println("while creating catalog, NPE thrown: " + ex.getClass().getName());
            throw new XSpecPluginException("while creating catalog", ex);
        }
        if (!keepGeneratedCatalog) {
            tmpCatalog.deleteOnExit();
        }
        return tmpCatalog;
    }
}

