/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class FileFinder {
    private final File directoryToSearch;
    private final String matchPattern;
    private final List<String> excludes;
    private final Log log;

    public FileFinder(File directoryToSearch, String matchPattern, List<String> excludes, Log log) {
        this.directoryToSearch = directoryToSearch;
        this.matchPattern = matchPattern;
        this.excludes = excludes != null ? excludes : Collections.emptyList();
        this.log = log;
    }

    public List<Path> search() throws IOException {
        Path rootPath = this.directoryToSearch.toPath();
        PathMatcher matcher = rootPath.getFileSystem().getPathMatcher(this.getSyntaxAndPattern(this.matchPattern));
        List<Path> found = Files.find(rootPath, Integer.MAX_VALUE, (p, a) -> matcher.matches((Path)p) && !a.isDirectory(), new FileVisitOption[0]).collect(Collectors.toList());
        for (String exclude : this.excludes) {
            PathMatcher pmex = rootPath.getFileSystem().getPathMatcher(this.getSyntaxAndPattern(exclude));
            for (int i = found.size() - 1; i >= 0; --i) {
                Path p2 = found.get(i);
                if (!pmex.matches(p2)) continue;
                found.remove(i);
            }
        }
        return found;
    }

    private String getSyntaxAndPattern(String pattern) {
        Object syntaxAndPattern;
        Object object = syntaxAndPattern = pattern.contains(":") ? pattern : "glob:" + pattern;
        if ("\\".equals(File.pathSeparator)) {
            syntaxAndPattern = ((String)syntaxAndPattern).replaceAll("/", "\\");
        }
        String prefix = ((String)syntaxAndPattern).substring(0, ((String)syntaxAndPattern).indexOf(":") + 1);
        String pp = ((String)syntaxAndPattern).substring(prefix.length());
        if (!((String)syntaxAndPattern).substring(((String)syntaxAndPattern).indexOf(":")).contains("*")) {
            this.getLog().warn((CharSequence)("Pattern " + pp + " does not contain wildchar. If it's an exclude pattern, it may not match some regular files. "));
        }
        return syntaxAndPattern;
    }

    public Log getLog() {
        return this.log;
    }
}

