/*
 * Decompiled with CFR 0.152.
 */
package io.xspec.maven.xspecMavenPlugin.utils;

import io.xspec.maven.xspecMavenPlugin.utils.ProcessedFile;
import io.xspec.maven.xspecMavenPlugin.utils.RunnerOptions;
import io.xspec.maven.xspecMavenPlugin.utils.XSpecPluginException;
import io.xspec.maven.xspecMavenPlugin.utils.XmlStuff;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;

public class IndexGenerator {
    protected final RunnerOptions options;
    protected final List<ProcessedFile> processedFiles;
    protected final XmlStuff stuff;

    public IndexGenerator(RunnerOptions options, List<ProcessedFile> processedFiles, XmlStuff stuff) {
        this.options = options;
        this.processedFiles = processedFiles;
        this.stuff = stuff;
    }

    public void generateIndex() throws XSpecPluginException {
        File index = new File(this.options.reportDir, "index.html");
        try {
            if (!this.options.reportDir.exists()) {
                this.options.reportDir.mkdirs();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter sw = XMLOutputFactory.newInstance().createXMLStreamWriter(baos, "UTF-8");
            sw.writeStartDocument("UTF-8", "1.0");
            sw.writeStartElement("html");
            sw.writeStartElement("head");
            sw.writeStartElement("style");
            sw.writeAttribute("type", "text/css");
            sw.writeCharacters("\n\ttable {border: solid black 1px; border-collapse: collapse; }\n");
            sw.writeCharacters("\ttr.error {background-color: red; color: white; }\n");
            sw.writeCharacters("\ttr.error td a { color: white;}\n");
            sw.writeCharacters("\ttr.title {background-color: lightgrey; }\n");
            sw.writeCharacters("\ttd,th {border: solid black 1px; }\n");
            sw.writeCharacters("\ttd:not(:first-child) {text-align: right; }\n");
            sw.writeEndElement();
            sw.writeEmptyElement("link");
            sw.writeAttribute("rel", "stylesheet");
            sw.writeAttribute("href", "resources/test-report.css");
            sw.writeAttribute("type", "text/css");
            sw.writeStartElement("title");
            sw.writeCharacters("XSpec results");
            sw.writeEndElement();
            sw.writeStartElement("meta");
            sw.writeAttribute("name", "date");
            sw.writeAttribute("content", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            sw.writeEndElement();
            sw.writeEndElement();
            sw.writeStartElement("body");
            sw.writeStartElement("h1");
            sw.writeCharacters("XSpec results");
            sw.writeEndElement();
            this.writeTable(sw);
            sw.writeEndElement();
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.flush();
            baos.flush();
            baos.close();
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            StreamSource source = new StreamSource(is);
            XdmNode tree = this.stuff.getDocumentBuilder().build((Source)source);
            FileOutputStream fos = new FileOutputStream(index);
            Serializer ser = this.stuff.newSerializer(fos);
            ser.setOutputProperty(Serializer.Property.INDENT, "true");
            ser.setOutputProperty(Serializer.Property.METHOD, "html");
            ser.setOutputProperty(Serializer.Property.VERSION, "5.0");
            ser.setOutputProperty(Serializer.Property.ENCODING, "UTF-8");
            this.stuff.getProcessor().writeXdmValue((XdmValue)tree, (Destination)ser);
            fos.flush();
            fos.close();
        }
        catch (IOException | IllegalArgumentException | XMLStreamException | SaxonApiException ex) {
            throw new XSpecPluginException("while generating index: " + index.getAbsolutePath(), ex);
        }
    }

    private void writeTable(XMLStreamWriter sw) throws XMLStreamException {
        sw.writeStartElement("table");
        sw.writeStartElement("colgroup");
        sw.writeEmptyElement("col");
        sw.writeEmptyElement("col");
        sw.writeAttribute("class", "successful");
        sw.writeEmptyElement("col");
        sw.writeAttribute("class", "pending");
        sw.writeEmptyElement("col");
        sw.writeAttribute("class", "failed");
        sw.writeEmptyElement("col");
        sw.writeAttribute("class", "missed");
        if (this.options.coverage.booleanValue()) {
            sw.writeEmptyElement("col");
        }
        sw.writeEmptyElement("col");
        sw.writeEndElement();
        sw.writeStartElement("thead");
        sw.writeStartElement("tr");
        this.writeCell(sw, "th", "XSpec file");
        this.writeCell(sw, "th", "Passed");
        this.writeCell(sw, "th", "Pending");
        this.writeCell(sw, "th", "Failed");
        this.writeCell(sw, "th", "Missed");
        if (this.options.coverage.booleanValue()) {
            this.writeCell(sw, "th", "Coverage");
        }
        this.writeCell(sw, "th", "Total");
        sw.writeEndElement();
        sw.writeEndElement();
        sw.writeStartElement("tbody");
        String lastRootDir = "";
        for (ProcessedFile pf : this.processedFiles) {
            String rootDir = pf.getRootSourceDir().toString();
            if (!lastRootDir.equals(rootDir)) {
                sw.writeStartElement("tr");
                sw.writeAttribute("class", "title");
                sw.writeStartElement("td");
                sw.writeAttribute("colspan", this.options.coverage != false ? "7" : "6");
                sw.writeCharacters(rootDir);
                sw.writeEndElement();
                sw.writeEndElement();
                lastRootDir = rootDir;
            }
            int errorCount = pf.getFailed() + pf.getMissed();
            sw.writeStartElement("tr");
            if (errorCount != 0) {
                sw.writeAttribute("class", "error");
            }
            sw.writeStartElement("td");
            sw.writeStartElement("a");
            sw.writeAttribute("href", pf.getReportFile().toUri().toString());
            sw.writeCharacters(pf.getRelativeSourcePath());
            sw.writeEndElement();
            sw.writeEndElement();
            this.writeTd(sw, pf.getPassed());
            this.writeTd(sw, pf.getPending());
            this.writeTd(sw, pf.getFailed());
            this.writeTd(sw, pf.getMissed());
            if (this.options.coverage.booleanValue()) {
                if (pf.getCoverageFile() != null) {
                    sw.writeStartElement("td");
                    sw.writeStartElement("a");
                    sw.writeAttribute("href", this.options.reportDir.toPath().relativize(pf.getCoverageFile()).toString());
                    sw.writeCharacters("Coverage report");
                    sw.writeEndElement();
                    sw.writeEndElement();
                } else {
                    sw.writeEmptyElement("td");
                }
            }
            sw.writeStartElement("td");
            sw.writeCharacters(Integer.toString(pf.getTotal()));
            sw.writeEndElement();
            sw.writeEndElement();
        }
        sw.writeEndElement();
        sw.writeEndElement();
    }

    private void writeTd(XMLStreamWriter sw, int count) throws XMLStreamException {
        sw.writeStartElement("td");
        if (count == 0) {
            sw.writeAttribute("class", "zero");
        }
        sw.writeCharacters(Integer.toString(count));
        sw.writeEndElement();
    }

    private void writeCell(XMLStreamWriter sw, String cellName, String value) throws XMLStreamException {
        sw.writeStartElement(cellName);
        sw.writeCharacters(value);
        sw.writeEndElement();
    }
}

