/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.authenticate;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.authenticate.AbstractAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.constant.AuthConstants;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.plugin.auth.impl.token.TokenManagerDelegate;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetails;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetailsServiceImpl;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LdapAuthenticationManager
extends AbstractAuthenticationManager {
    private final String filterPrefix;
    private final boolean caseSensitive;
    private final LdapTemplate ldapTemplate;

    public LdapAuthenticationManager(LdapTemplate ldapTemplate, NacosUserDetailsServiceImpl userDetailsService, TokenManagerDelegate jwtTokenManager, NacosRoleServiceImpl roleService, String filterPrefix, boolean caseSensitive) {
        super(userDetailsService, jwtTokenManager, roleService);
        this.ldapTemplate = ldapTemplate;
        this.filterPrefix = filterPrefix;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public NacosUser authenticate(String username, String rawPassword) throws AccessException {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new AccessException("user not found!");
        }
        if (!this.caseSensitive) {
            username = username.toLowerCase();
        }
        try {
            return super.authenticate(username, rawPassword);
        }
        catch (AccessException | UsernameNotFoundException ignored) {
            UserDetails userDetails;
            if (Loggers.AUTH.isWarnEnabled()) {
                Loggers.AUTH.warn("try login with LDAP, user: {}", (Object)username);
            }
            try {
                if (!this.ldapLogin(username, rawPassword)) {
                    throw new AccessException("LDAP login failed.");
                }
                userDetails = this.userDetailsService.loadUserByUsername("LDAP_" + username);
            }
            catch (UsernameNotFoundException exception) {
                String ldapUsername = "LDAP_" + username;
                this.userDetailsService.createUser(ldapUsername, AuthConstants.LDAP_DEFAULT_ENCODED_PASSWORD);
                User user = new User();
                user.setUsername(ldapUsername);
                user.setPassword(AuthConstants.LDAP_DEFAULT_ENCODED_PASSWORD);
                userDetails = new NacosUserDetails(user);
            }
            catch (Exception e) {
                Loggers.AUTH.error("[LDAP-LOGIN] failed", (Throwable)e);
                throw new AccessException("user not found");
            }
            return new NacosUser(userDetails.getUsername(), this.jwtTokenManager.createToken(userDetails.getUsername()));
        }
    }

    private boolean ldapLogin(String username, String password) {
        return this.ldapTemplate.authenticate("", new EqualsFilter(this.filterPrefix, username).toString(), password);
    }
}

