/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.paramcheck;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.core.paramcheck.AbstractHttpParamExtractor;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ConfigListenerHttpParamExtractor
extends AbstractHttpParamExtractor {
    static final char WORD_SEPARATOR_CHAR = '\u0002';
    static final char LINE_SEPARATOR_CHAR = '\u0001';

    public List<ParamInfo> extractParam(HttpServletRequest request) throws NacosRuntimeException {
        String[] lines;
        ArrayList<ParamInfo> paramInfos = new ArrayList<ParamInfo>();
        String listenConfigs = request.getParameter("Listening-Configs");
        if (StringUtils.isBlank((CharSequence)listenConfigs)) {
            return paramInfos;
        }
        try {
            listenConfigs = URLDecoder.decode(listenConfigs, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new NacosRuntimeException(ErrorCode.UnKnowError.getCode(), (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)listenConfigs)) {
            return paramInfos;
        }
        for (String line : lines = listenConfigs.split(Character.toString('\u0001'))) {
            ParamInfo paramInfo = new ParamInfo();
            String[] words = line.split(Character.toString('\u0002'));
            if (words.length < 2 || words.length > 4) {
                throw new IllegalArgumentException("invalid probeModify");
            }
            paramInfo.setDataId(words[0]);
            paramInfo.setGroup(words[1]);
            if (words.length == 4) {
                paramInfo.setNamespaceId(words[3]);
            }
            paramInfos.add(paramInfo);
        }
        return paramInfos;
    }
}

