/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.util;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.core.utils.ClassUtils;
import com.alibaba.nacos.istio.IstioApp;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class IstioExecutor {
    private static final ScheduledExecutorService NACOS_RESOURCE_WATCHER = ExecutorFactory.Managed.newScheduledExecutorService((String)ClassUtils.getCanonicalName(IstioApp.class), (int)EnvUtil.getAvailableProcessors((int)2), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.istio.resource.watcher"));
    private static final ExecutorService EVENT_HANDLE_EXECUTOR = ExecutorFactory.Managed.newSingleExecutorService((String)ClassUtils.getCanonicalName(IstioApp.class), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.istio.event.handle"));

    public static void registerNacosResourceWatcher(Runnable watcher, long initialDelay, long period) {
        NACOS_RESOURCE_WATCHER.scheduleAtFixedRate(watcher, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public static <V> Future<V> asyncHandleEvent(Callable<V> task) {
        return EVENT_HANDLE_EXECUTOR.submit(task);
    }
}

