/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.index;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManagerDelegate;
import com.alibaba.nacos.naming.core.v2.index.ClientServiceIndexesManager;
import com.alibaba.nacos.naming.core.v2.metadata.InstanceMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.pojo.BatchInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.utils.InstanceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

@Component
public class ServiceStorage {
    private final ClientServiceIndexesManager serviceIndexesManager;
    private final ClientManager clientManager;
    private final SwitchDomain switchDomain;
    private final NamingMetadataManager metadataManager;
    private final ConcurrentMap<Service, ServiceInfo> serviceDataIndexes;
    private final ConcurrentMap<Service, Set<String>> serviceClusterIndex;

    public ServiceStorage(ClientServiceIndexesManager serviceIndexesManager, ClientManagerDelegate clientManager, SwitchDomain switchDomain, NamingMetadataManager metadataManager) {
        this.serviceIndexesManager = serviceIndexesManager;
        this.clientManager = clientManager;
        this.switchDomain = switchDomain;
        this.metadataManager = metadataManager;
        this.serviceDataIndexes = new ConcurrentHashMap<Service, ServiceInfo>();
        this.serviceClusterIndex = new ConcurrentHashMap<Service, Set<String>>();
    }

    public Set<String> getClusters(Service service) {
        return this.serviceClusterIndex.getOrDefault(service, new HashSet());
    }

    public ServiceInfo getData(Service service) {
        return this.serviceDataIndexes.containsKey(service) ? (ServiceInfo)this.serviceDataIndexes.get(service) : this.getPushData(service);
    }

    public ServiceInfo getPushData(Service service) {
        ServiceInfo result = this.emptyServiceInfo(service);
        if (!ServiceManager.getInstance().containSingleton(service)) {
            return result;
        }
        Service singleton = ServiceManager.getInstance().getSingleton(service);
        result.setHosts(this.getAllInstancesFromIndex(singleton));
        this.serviceDataIndexes.put(singleton, result);
        return result;
    }

    public void removeData(Service service) {
        this.serviceDataIndexes.remove(service);
        this.serviceClusterIndex.remove(service);
    }

    private ServiceInfo emptyServiceInfo(Service service) {
        ServiceInfo result = new ServiceInfo();
        result.setName(service.getName());
        result.setGroupName(service.getGroup());
        result.setLastRefTime(System.currentTimeMillis());
        result.setCacheMillis(this.switchDomain.getDefaultPushCacheMillis());
        return result;
    }

    private List<Instance> getAllInstancesFromIndex(Service service) {
        HashSet<Instance> result = new HashSet<Instance>();
        HashSet<String> clusters = new HashSet<String>();
        for (String each : this.serviceIndexesManager.getAllClientsRegisteredService(service)) {
            Optional<InstancePublishInfo> instancePublishInfo = this.getInstanceInfo(each, service);
            if (!instancePublishInfo.isPresent()) continue;
            InstancePublishInfo publishInfo = instancePublishInfo.get();
            if (publishInfo instanceof BatchInstancePublishInfo) {
                BatchInstancePublishInfo batchInstancePublishInfo = (BatchInstancePublishInfo)publishInfo;
                List<Instance> batchInstance = this.parseBatchInstance(service, batchInstancePublishInfo, clusters);
                result.addAll(batchInstance);
                continue;
            }
            Instance instance = this.parseInstance(service, instancePublishInfo.get());
            result.add(instance);
            clusters.add(instance.getClusterName());
        }
        this.serviceClusterIndex.put(service, clusters);
        return new LinkedList<Instance>(result);
    }

    private List<Instance> parseBatchInstance(Service service, BatchInstancePublishInfo batchInstancePublishInfo, Set<String> clusters) {
        ArrayList<Instance> resultInstanceList = new ArrayList<Instance>();
        List<InstancePublishInfo> instancePublishInfos = batchInstancePublishInfo.getInstancePublishInfos();
        for (InstancePublishInfo instancePublishInfo : instancePublishInfos) {
            Instance instance = this.parseInstance(service, instancePublishInfo);
            resultInstanceList.add(instance);
            clusters.add(instance.getClusterName());
        }
        return resultInstanceList;
    }

    private Optional<InstancePublishInfo> getInstanceInfo(String clientId, Service service) {
        Client client = this.clientManager.getClient(clientId);
        if (null == client) {
            return Optional.empty();
        }
        return Optional.ofNullable(client.getInstancePublishInfo(service));
    }

    private Instance parseInstance(Service service, InstancePublishInfo instanceInfo) {
        Instance result = InstanceUtil.parseToApiInstance(service, instanceInfo);
        Optional<InstanceMetadata> metadata = this.metadataManager.getInstanceMetadata(service, instanceInfo.getMetadataId());
        metadata.ifPresent(instanceMetadata -> InstanceUtil.updateInstanceMetadata(result, instanceMetadata));
        return result;
    }
}

