/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.pojo.instance;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.builder.InstanceBuilder;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.pojo.instance.InstanceExtensionHandler;
import com.alibaba.nacos.naming.pojo.instance.InstanceIdGeneratorManager;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

public class BeatInfoInstanceBuilder {
    private final InstanceBuilder actualBuilder = InstanceBuilder.newBuilder();
    private final Collection<InstanceExtensionHandler> handlers = NacosServiceLoader.newServiceInstances(InstanceExtensionHandler.class);

    private BeatInfoInstanceBuilder() {
    }

    public static BeatInfoInstanceBuilder newBuilder() {
        return new BeatInfoInstanceBuilder();
    }

    public Instance build() {
        Instance result = this.actualBuilder.build();
        for (InstanceExtensionHandler each : this.handlers) {
            each.handleExtensionInfo(result);
        }
        this.setInstanceId(result);
        return result;
    }

    public BeatInfoInstanceBuilder setRequest(HttpServletRequest request) {
        for (InstanceExtensionHandler each : this.handlers) {
            each.configExtensionInfoFromRequest(request);
        }
        return this;
    }

    public BeatInfoInstanceBuilder setServiceName(String serviceName) {
        this.actualBuilder.setServiceName(serviceName);
        return this;
    }

    public BeatInfoInstanceBuilder setBeatInfo(RsInfo beatInfo) {
        this.setAttributesToBuilder(beatInfo);
        return this;
    }

    private void setAttributesToBuilder(RsInfo beatInfo) {
        this.actualBuilder.setPort(Integer.valueOf(beatInfo.getPort()));
        this.actualBuilder.setIp(beatInfo.getIp());
        this.actualBuilder.setWeight(Double.valueOf(beatInfo.getWeight()));
        this.actualBuilder.setMetadata(beatInfo.getMetadata());
        this.actualBuilder.setClusterName(beatInfo.getCluster());
        this.actualBuilder.setEphemeral(Boolean.valueOf(beatInfo.isEphemeral()));
    }

    private void setInstanceId(Instance instance) {
        instance.setInstanceId(InstanceIdGeneratorManager.generateInstanceId(instance));
    }
}

