(function(){
'use strict';
/* Scala.js runtime support
 * Copyright 2013 LAMP/EPFL
 * Author: Sébastien Doeraene
 */

/* ---------------------------------- *
 * The top-level Scala.js environment *
 * ---------------------------------- */





// Get the environment info
var $env = (typeof __ScalaJSEnv === "object" && __ScalaJSEnv) ? __ScalaJSEnv : {};

// Global scope
var $g =
  (typeof $env["global"] === "object" && $env["global"])
    ? $env["global"]
    : ((typeof global === "object" && global && global["Object"] === Object) ? global : this);
$env["global"] = $g;

// Where to send exports



var $e =
  (typeof $env["exportsNamespace"] === "object" && $env["exportsNamespace"])
    ? $env["exportsNamespace"] : $g;

$env["exportsNamespace"] = $e;

// Freeze the environment info
$g["Object"]["freeze"]($env);

// Linking info - must be in sync with scala.scalajs.runtime.LinkingInfo
var $linkingInfo = {
  "envInfo": $env,
  "semantics": {




    "asInstanceOfs": 1,








    "arrayIndexOutOfBounds": 1,










    "moduleInit": 2,





    "strictFloats": false,




    "productionMode": false

  },



  "assumingES6": false,

  "linkerVersion": "0.6.25",
  "globalThis": this
};
$g["Object"]["freeze"]($linkingInfo);
$g["Object"]["freeze"]($linkingInfo["semantics"]);

// Snapshots of builtins and polyfills






var $imul = $g["Math"]["imul"] || (function(a, b) {
  // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/imul
  var ah = (a >>> 16) & 0xffff;
  var al = a & 0xffff;
  var bh = (b >>> 16) & 0xffff;
  var bl = b & 0xffff;
  // the shift by 0 fixes the sign on the high part
  // the final |0 converts the unsigned value into a signed value
  return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0) | 0);
});

var $fround = $g["Math"]["fround"] ||









  (function(v) {
    return +v;
  });


var $clz32 = $g["Math"]["clz32"] || (function(i) {
  // See Hacker's Delight, Section 5-3
  if (i === 0) return 32;
  var r = 1;
  if ((i & 0xffff0000) === 0) { i <<= 16; r += 16; };
  if ((i & 0xff000000) === 0) { i <<= 8; r += 8; };
  if ((i & 0xf0000000) === 0) { i <<= 4; r += 4; };
  if ((i & 0xc0000000) === 0) { i <<= 2; r += 2; };
  return r + (i >> 31);
});


// Other fields




















var $lastIDHash = 0; // last value attributed to an id hash code



var $idHashCodeMap = $g["WeakMap"] ? new $g["WeakMap"]() : null;



// Core mechanism

var $makeIsArrayOfPrimitive = function(primitiveData) {
  return function(obj, depth) {
    return !!(obj && obj.$classData &&
      (obj.$classData.arrayDepth === depth) &&
      (obj.$classData.arrayBase === primitiveData));
  }
};


var $makeAsArrayOfPrimitive = function(isInstanceOfFunction, arrayEncodedName) {
  return function(obj, depth) {
    if (isInstanceOfFunction(obj, depth) || (obj === null))
      return obj;
    else
      $throwArrayCastException(obj, arrayEncodedName, depth);
  }
};


/** Encode a property name for runtime manipulation
  *  Usage:
  *    env.propertyName({someProp:0})
  *  Returns:
  *    "someProp"
  *  Useful when the property is renamed by a global optimizer (like Closure)
  *  but we must still get hold of a string of that name for runtime
  * reflection.
  */
var $propertyName = function(obj) {
  for (var prop in obj)
    return prop;
};

// Runtime functions

var $isScalaJSObject = function(obj) {
  return !!(obj && obj.$classData);
};


var $throwClassCastException = function(instance, classFullName) {




  throw new $c_sjsr_UndefinedBehaviorError().init___jl_Throwable(
    new $c_jl_ClassCastException().init___T(
      instance + " is not an instance of " + classFullName));

};

var $throwArrayCastException = function(instance, classArrayEncodedName, depth) {
  for (; depth; --depth)
    classArrayEncodedName = "[" + classArrayEncodedName;
  $throwClassCastException(instance, classArrayEncodedName);
};



var $throwArrayIndexOutOfBoundsException = function(i) {
  var msg = (i === null) ? null : ("" + i);



  throw new $c_sjsr_UndefinedBehaviorError().init___jl_Throwable(
    new $c_jl_ArrayIndexOutOfBoundsException().init___T(msg));

};


var $noIsInstance = function(instance) {
  throw new $g["TypeError"](
    "Cannot call isInstance() on a Class representing a raw JS trait/object");
};

var $makeNativeArrayWrapper = function(arrayClassData, nativeArray) {
  return new arrayClassData.constr(nativeArray);
};

var $newArrayObject = function(arrayClassData, lengths) {
  return $newArrayObjectInternal(arrayClassData, lengths, 0);
};

var $newArrayObjectInternal = function(arrayClassData, lengths, lengthIndex) {
  var result = new arrayClassData.constr(lengths[lengthIndex]);

  if (lengthIndex < lengths.length-1) {
    var subArrayClassData = arrayClassData.componentData;
    var subLengthIndex = lengthIndex+1;
    var underlying = result.u;
    for (var i = 0; i < underlying.length; i++) {
      underlying[i] = $newArrayObjectInternal(
        subArrayClassData, lengths, subLengthIndex);
    }
  }

  return result;
};

var $objectToString = function(instance) {
  if (instance === void 0)
    return "undefined";
  else
    return instance.toString();
};

var $objectGetClass = function(instance) {
  switch (typeof instance) {
    case "string":
      return $d_T.getClassOf();
    case "number": {
      var v = instance | 0;
      if (v === instance) { // is the value integral?
        if ($isByte(v))
          return $d_jl_Byte.getClassOf();
        else if ($isShort(v))
          return $d_jl_Short.getClassOf();
        else
          return $d_jl_Integer.getClassOf();
      } else {
        if ($isFloat(instance))
          return $d_jl_Float.getClassOf();
        else
          return $d_jl_Double.getClassOf();
      }
    }
    case "boolean":
      return $d_jl_Boolean.getClassOf();
    case "undefined":
      return $d_sr_BoxedUnit.getClassOf();
    default:
      if (instance === null)
        return instance.getClass__jl_Class();
      else if ($is_sjsr_RuntimeLong(instance))
        return $d_jl_Long.getClassOf();
      else if ($isScalaJSObject(instance))
        return instance.$classData.getClassOf();
      else
        return null; // Exception?
  }
};

var $objectClone = function(instance) {
  if ($isScalaJSObject(instance) || (instance === null))
    return instance.clone__O();
  else
    throw new $c_jl_CloneNotSupportedException().init___();
};

var $objectNotify = function(instance) {
  // final and no-op in java.lang.Object
  if (instance === null)
    instance.notify__V();
};

var $objectNotifyAll = function(instance) {
  // final and no-op in java.lang.Object
  if (instance === null)
    instance.notifyAll__V();
};

var $objectFinalize = function(instance) {
  if ($isScalaJSObject(instance) || (instance === null))
    instance.finalize__V();
  // else no-op
};

var $objectEquals = function(instance, rhs) {
  if ($isScalaJSObject(instance) || (instance === null))
    return instance.equals__O__Z(rhs);
  else if (typeof instance === "number")
    return typeof rhs === "number" && $numberEquals(instance, rhs);
  else
    return instance === rhs;
};

var $numberEquals = function(lhs, rhs) {
  return (lhs === rhs) ? (
    // 0.0.equals(-0.0) must be false
    lhs !== 0 || 1/lhs === 1/rhs
  ) : (
    // are they both NaN?
    (lhs !== lhs) && (rhs !== rhs)
  );
};

var $objectHashCode = function(instance) {
  switch (typeof instance) {
    case "string":
      return $m_sjsr_RuntimeString$().hashCode__T__I(instance);
    case "number":
      return $m_sjsr_Bits$().numberHashCode__D__I(instance);
    case "boolean":
      return instance ? 1231 : 1237;
    case "undefined":
      return 0;
    default:
      if ($isScalaJSObject(instance) || instance === null)
        return instance.hashCode__I();

      else if ($idHashCodeMap === null)
        return 42;

      else
        return $systemIdentityHashCode(instance);
  }
};

var $comparableCompareTo = function(instance, rhs) {
  switch (typeof instance) {
    case "string":

      $as_T(rhs);

      return instance === rhs ? 0 : (instance < rhs ? -1 : 1);
    case "number":

      $as_jl_Number(rhs);

      return $m_jl_Double$().compare__D__D__I(instance, rhs);
    case "boolean":

      $asBoolean(rhs);

      return instance - rhs; // yes, this gives the right result
    default:
      return instance.compareTo__O__I(rhs);
  }
};

var $charSequenceLength = function(instance) {
  if (typeof(instance) === "string")

    return $uI(instance["length"]);



  else
    return instance.length__I();
};

var $charSequenceCharAt = function(instance, index) {
  if (typeof(instance) === "string")

    return $uI(instance["charCodeAt"](index)) & 0xffff;



  else
    return instance.charAt__I__C(index);
};

var $charSequenceSubSequence = function(instance, start, end) {
  if (typeof(instance) === "string")

    return $as_T(instance["substring"](start, end));



  else
    return instance.subSequence__I__I__jl_CharSequence(start, end);
};

var $booleanBooleanValue = function(instance) {
  if (typeof instance === "boolean") return instance;
  else                               return instance.booleanValue__Z();
};

var $numberByteValue = function(instance) {
  if (typeof instance === "number") return (instance << 24) >> 24;
  else                              return instance.byteValue__B();
};
var $numberShortValue = function(instance) {
  if (typeof instance === "number") return (instance << 16) >> 16;
  else                              return instance.shortValue__S();
};
var $numberIntValue = function(instance) {
  if (typeof instance === "number") return instance | 0;
  else                              return instance.intValue__I();
};
var $numberLongValue = function(instance) {
  if (typeof instance === "number")
    return $m_sjsr_RuntimeLong$().fromDouble__D__sjsr_RuntimeLong(instance);
  else
    return instance.longValue__J();
};
var $numberFloatValue = function(instance) {
  if (typeof instance === "number") return $fround(instance);
  else                              return instance.floatValue__F();
};
var $numberDoubleValue = function(instance) {
  if (typeof instance === "number") return instance;
  else                              return instance.doubleValue__D();
};

var $isNaN = function(instance) {
  return instance !== instance;
};

var $isInfinite = function(instance) {
  return !$g["isFinite"](instance) && !$isNaN(instance);
};

var $doubleToInt = function(x) {
  return (x > 2147483647) ? (2147483647) : ((x < -2147483648) ? -2147483648 : (x | 0));
};

/** Instantiates a JS object with variadic arguments to the constructor. */
var $newJSObjectWithVarargs = function(ctor, args) {
  // This basically emulates the ECMAScript specification for 'new'.
  var instance = $g["Object"]["create"](ctor.prototype);
  var result = ctor["apply"](instance, args);
  switch (typeof result) {
    case "string": case "number": case "boolean": case "undefined": case "symbol":
      return instance;
    default:
      return result === null ? instance : result;
  }
};

var $resolveSuperRef = function(initialProto, propName) {
  var getPrototypeOf = $g["Object"]["getPrototypeOf"];
  var getOwnPropertyDescriptor = $g["Object"]["getOwnPropertyDescriptor"];

  var superProto = getPrototypeOf(initialProto);
  while (superProto !== null) {
    var desc = getOwnPropertyDescriptor(superProto, propName);
    if (desc !== void 0)
      return desc;
    superProto = getPrototypeOf(superProto);
  }

  return void 0;
};

var $superGet = function(initialProto, self, propName) {
  var desc = $resolveSuperRef(initialProto, propName);
  if (desc !== void 0) {
    var getter = desc["get"];
    if (getter !== void 0)
      return getter["call"](self);
    else
      return desc["value"];
  }
  return void 0;
};

var $superSet = function(initialProto, self, propName, value) {
  var desc = $resolveSuperRef(initialProto, propName);
  if (desc !== void 0) {
    var setter = desc["set"];
    if (setter !== void 0) {
      setter["call"](self, value);
      return void 0;
    }
  }
  throw new $g["TypeError"]("super has no setter '" + propName + "'.");
};







var $propertiesOf = function(obj) {
  var result = [];
  for (var prop in obj)
    result["push"](prop);
  return result;
};

var $systemArraycopy = function(src, srcPos, dest, destPos, length) {
  var srcu = src.u;
  var destu = dest.u;


  if (srcPos < 0 || destPos < 0 || length < 0 ||
      (srcPos > ((srcu.length - length) | 0)) ||
      (destPos > ((destu.length - length) | 0))) {
    $throwArrayIndexOutOfBoundsException(null);
  }


  if (srcu !== destu || destPos < srcPos || (((srcPos + length) | 0) < destPos)) {
    for (var i = 0; i < length; i = (i + 1) | 0)
      destu[(destPos + i) | 0] = srcu[(srcPos + i) | 0];
  } else {
    for (var i = (length - 1) | 0; i >= 0; i = (i - 1) | 0)
      destu[(destPos + i) | 0] = srcu[(srcPos + i) | 0];
  }
};

var $systemIdentityHashCode =

  ($idHashCodeMap !== null) ?

  (function(obj) {
    switch (typeof obj) {
      case "string": case "number": case "boolean": case "undefined":
        return $objectHashCode(obj);
      default:
        if (obj === null) {
          return 0;
        } else {
          var hash = $idHashCodeMap["get"](obj);
          if (hash === void 0) {
            hash = ($lastIDHash + 1) | 0;
            $lastIDHash = hash;
            $idHashCodeMap["set"](obj, hash);
          }
          return hash;
        }
    }

  }) :
  (function(obj) {
    if ($isScalaJSObject(obj)) {
      var hash = obj["$idHashCode$0"];
      if (hash !== void 0) {
        return hash;
      } else if (!$g["Object"]["isSealed"](obj)) {
        hash = ($lastIDHash + 1) | 0;
        $lastIDHash = hash;
        obj["$idHashCode$0"] = hash;
        return hash;
      } else {
        return 42;
      }
    } else if (obj === null) {
      return 0;
    } else {
      return $objectHashCode(obj);
    }

  });

// is/as for hijacked boxed classes (the non-trivial ones)

var $isByte = function(v) {
  return typeof v === "number" && (v << 24 >> 24) === v && 1/v !== 1/-0;
};

var $isShort = function(v) {
  return typeof v === "number" && (v << 16 >> 16) === v && 1/v !== 1/-0;
};

var $isInt = function(v) {
  return typeof v === "number" && (v | 0) === v && 1/v !== 1/-0;
};

var $isFloat = function(v) {



  return typeof v === "number";

};


var $asUnit = function(v) {
  if (v === void 0 || v === null)
    return v;
  else
    $throwClassCastException(v, "scala.runtime.BoxedUnit");
};

var $asBoolean = function(v) {
  if (typeof v === "boolean" || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Boolean");
};

var $asByte = function(v) {
  if ($isByte(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Byte");
};

var $asShort = function(v) {
  if ($isShort(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Short");
};

var $asInt = function(v) {
  if ($isInt(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Integer");
};

var $asFloat = function(v) {
  if ($isFloat(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Float");
};

var $asDouble = function(v) {
  if (typeof v === "number" || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Double");
};


// Unboxes


var $uZ = function(value) {
  return !!$asBoolean(value);
};
var $uB = function(value) {
  return $asByte(value) | 0;
};
var $uS = function(value) {
  return $asShort(value) | 0;
};
var $uI = function(value) {
  return $asInt(value) | 0;
};
var $uJ = function(value) {
  return null === value ? $m_sjsr_RuntimeLong$().Zero$1
                        : $as_sjsr_RuntimeLong(value);
};
var $uF = function(value) {
  /* Here, it is fine to use + instead of fround, because asFloat already
   * ensures that the result is either null or a float.
   */
  return +$asFloat(value);
};
var $uD = function(value) {
  return +$asDouble(value);
};






// TypeArray conversions

var $byteArray2TypedArray = function(value) { return new $g["Int8Array"](value.u); };
var $shortArray2TypedArray = function(value) { return new $g["Int16Array"](value.u); };
var $charArray2TypedArray = function(value) { return new $g["Uint16Array"](value.u); };
var $intArray2TypedArray = function(value) { return new $g["Int32Array"](value.u); };
var $floatArray2TypedArray = function(value) { return new $g["Float32Array"](value.u); };
var $doubleArray2TypedArray = function(value) { return new $g["Float64Array"](value.u); };

var $typedArray2ByteArray = function(value) {
  var arrayClassData = $d_B.getArrayOf();
  return new arrayClassData.constr(new $g["Int8Array"](value));
};
var $typedArray2ShortArray = function(value) {
  var arrayClassData = $d_S.getArrayOf();
  return new arrayClassData.constr(new $g["Int16Array"](value));
};
var $typedArray2CharArray = function(value) {
  var arrayClassData = $d_C.getArrayOf();
  return new arrayClassData.constr(new $g["Uint16Array"](value));
};
var $typedArray2IntArray = function(value) {
  var arrayClassData = $d_I.getArrayOf();
  return new arrayClassData.constr(new $g["Int32Array"](value));
};
var $typedArray2FloatArray = function(value) {
  var arrayClassData = $d_F.getArrayOf();
  return new arrayClassData.constr(new $g["Float32Array"](value));
};
var $typedArray2DoubleArray = function(value) {
  var arrayClassData = $d_D.getArrayOf();
  return new arrayClassData.constr(new $g["Float64Array"](value));
};

// TypeData class


/** @constructor */
var $TypeData = function() {




  // Runtime support
  this.constr = void 0;
  this.parentData = void 0;
  this.ancestors = null;
  this.componentData = null;
  this.arrayBase = null;
  this.arrayDepth = 0;
  this.zero = null;
  this.arrayEncodedName = "";
  this._classOf = void 0;
  this._arrayOf = void 0;
  this.isArrayOf = void 0;

  // java.lang.Class support
  this["name"] = "";
  this["isPrimitive"] = false;
  this["isInterface"] = false;
  this["isArrayClass"] = false;
  this["isRawJSType"] = false;
  this["isInstance"] = void 0;
};


$TypeData.prototype.initPrim = function(



    zero, arrayEncodedName, displayName) {
  // Runtime support
  this.ancestors = {};
  this.componentData = null;
  this.zero = zero;
  this.arrayEncodedName = arrayEncodedName;
  this.isArrayOf = function(obj, depth) { return false; };

  // java.lang.Class support
  this["name"] = displayName;
  this["isPrimitive"] = true;
  this["isInstance"] = function(obj) { return false; };

  return this;
};


$TypeData.prototype.initClass = function(



    internalNameObj, isInterface, fullName,
    ancestors, isRawJSType, parentData, isInstance, isArrayOf) {
  var internalName = $propertyName(internalNameObj);

  isInstance = isInstance || function(obj) {
    return !!(obj && obj.$classData && obj.$classData.ancestors[internalName]);
  };

  isArrayOf = isArrayOf || function(obj, depth) {
    return !!(obj && obj.$classData && (obj.$classData.arrayDepth === depth)
      && obj.$classData.arrayBase.ancestors[internalName])
  };

  // Runtime support
  this.parentData = parentData;
  this.ancestors = ancestors;
  this.arrayEncodedName = "L"+fullName+";";
  this.isArrayOf = isArrayOf;

  // java.lang.Class support
  this["name"] = fullName;
  this["isInterface"] = isInterface;
  this["isRawJSType"] = !!isRawJSType;
  this["isInstance"] = isInstance;

  return this;
};


$TypeData.prototype.initArray = function(



    componentData) {
  // The constructor

  var componentZero0 = componentData.zero;

  // The zero for the Long runtime representation
  // is a special case here, since the class has not
  // been defined yet, when this file is read
  var componentZero = (componentZero0 == "longZero")
    ? $m_sjsr_RuntimeLong$().Zero$1
    : componentZero0;


  /** @constructor */
  var ArrayClass = function(arg) {
    if (typeof(arg) === "number") {
      // arg is the length of the array
      this.u = new Array(arg);
      for (var i = 0; i < arg; i++)
        this.u[i] = componentZero;
    } else {
      // arg is a native array that we wrap
      this.u = arg;
    }
  }
  ArrayClass.prototype = new $h_O;
  ArrayClass.prototype.constructor = ArrayClass;


  ArrayClass.prototype.get = function(i) {
    if (i < 0 || i >= this.u.length)
      $throwArrayIndexOutOfBoundsException(i);
    return this.u[i];
  };
  ArrayClass.prototype.set = function(i, v) {
    if (i < 0 || i >= this.u.length)
      $throwArrayIndexOutOfBoundsException(i);
    this.u[i] = v;
  };


  ArrayClass.prototype.clone__O = function() {
    if (this.u instanceof Array)
      return new ArrayClass(this.u["slice"](0));
    else
      // The underlying Array is a TypedArray
      return new ArrayClass(new this.u.constructor(this.u));
  };






































  ArrayClass.prototype.$classData = this;

  // Don't generate reflective call proxies. The compiler special cases
  // reflective calls to methods on scala.Array

  // The data

  var encodedName = "[" + componentData.arrayEncodedName;
  var componentBase = componentData.arrayBase || componentData;
  var arrayDepth = componentData.arrayDepth + 1;

  var isInstance = function(obj) {
    return componentBase.isArrayOf(obj, arrayDepth);
  }

  // Runtime support
  this.constr = ArrayClass;
  this.parentData = $d_O;
  this.ancestors = {O: 1, jl_Cloneable: 1, Ljava_io_Serializable: 1};
  this.componentData = componentData;
  this.arrayBase = componentBase;
  this.arrayDepth = arrayDepth;
  this.zero = null;
  this.arrayEncodedName = encodedName;
  this._classOf = undefined;
  this._arrayOf = undefined;
  this.isArrayOf = undefined;

  // java.lang.Class support
  this["name"] = encodedName;
  this["isPrimitive"] = false;
  this["isInterface"] = false;
  this["isArrayClass"] = true;
  this["isInstance"] = isInstance;

  return this;
};


$TypeData.prototype.getClassOf = function() {



  if (!this._classOf)
    this._classOf = new $c_jl_Class().init___jl_ScalaJSClassData(this);
  return this._classOf;
};


$TypeData.prototype.getArrayOf = function() {



  if (!this._arrayOf)
    this._arrayOf = new $TypeData().initArray(this);
  return this._arrayOf;
};

// java.lang.Class support


$TypeData.prototype["getFakeInstance"] = function() {



  if (this === $d_T)
    return "some string";
  else if (this === $d_jl_Boolean)
    return false;
  else if (this === $d_jl_Byte ||
           this === $d_jl_Short ||
           this === $d_jl_Integer ||
           this === $d_jl_Float ||
           this === $d_jl_Double)
    return 0;
  else if (this === $d_jl_Long)
    return $m_sjsr_RuntimeLong$().Zero$1;
  else if (this === $d_sr_BoxedUnit)
    return void 0;
  else
    return {$classData: this};
};


$TypeData.prototype["getSuperclass"] = function() {



  return this.parentData ? this.parentData.getClassOf() : null;
};


$TypeData.prototype["getComponentType"] = function() {



  return this.componentData ? this.componentData.getClassOf() : null;
};


$TypeData.prototype["newArrayOfThisClass"] = function(lengths) {



  var arrayClassData = this;
  for (var i = 0; i < lengths.length; i++)
    arrayClassData = arrayClassData.getArrayOf();
  return $newArrayObject(arrayClassData, lengths);
};




// Create primitive types

var $d_V = new $TypeData().initPrim(undefined, "V", "void");
var $d_Z = new $TypeData().initPrim(false, "Z", "boolean");
var $d_C = new $TypeData().initPrim(0, "C", "char");
var $d_B = new $TypeData().initPrim(0, "B", "byte");
var $d_S = new $TypeData().initPrim(0, "S", "short");
var $d_I = new $TypeData().initPrim(0, "I", "int");
var $d_J = new $TypeData().initPrim("longZero", "J", "long");
var $d_F = new $TypeData().initPrim(0.0, "F", "float");
var $d_D = new $TypeData().initPrim(0.0, "D", "double");

// Instance tests for array of primitives

var $isArrayOf_Z = $makeIsArrayOfPrimitive($d_Z);
$d_Z.isArrayOf = $isArrayOf_Z;

var $isArrayOf_C = $makeIsArrayOfPrimitive($d_C);
$d_C.isArrayOf = $isArrayOf_C;

var $isArrayOf_B = $makeIsArrayOfPrimitive($d_B);
$d_B.isArrayOf = $isArrayOf_B;

var $isArrayOf_S = $makeIsArrayOfPrimitive($d_S);
$d_S.isArrayOf = $isArrayOf_S;

var $isArrayOf_I = $makeIsArrayOfPrimitive($d_I);
$d_I.isArrayOf = $isArrayOf_I;

var $isArrayOf_J = $makeIsArrayOfPrimitive($d_J);
$d_J.isArrayOf = $isArrayOf_J;

var $isArrayOf_F = $makeIsArrayOfPrimitive($d_F);
$d_F.isArrayOf = $isArrayOf_F;

var $isArrayOf_D = $makeIsArrayOfPrimitive($d_D);
$d_D.isArrayOf = $isArrayOf_D;


// asInstanceOfs for array of primitives
var $asArrayOf_Z = $makeAsArrayOfPrimitive($isArrayOf_Z, "Z");
var $asArrayOf_C = $makeAsArrayOfPrimitive($isArrayOf_C, "C");
var $asArrayOf_B = $makeAsArrayOfPrimitive($isArrayOf_B, "B");
var $asArrayOf_S = $makeAsArrayOfPrimitive($isArrayOf_S, "S");
var $asArrayOf_I = $makeAsArrayOfPrimitive($isArrayOf_I, "I");
var $asArrayOf_J = $makeAsArrayOfPrimitive($isArrayOf_J, "J");
var $asArrayOf_F = $makeAsArrayOfPrimitive($isArrayOf_F, "F");
var $asArrayOf_D = $makeAsArrayOfPrimitive($isArrayOf_D, "D");

function $is_F0(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.F0)))
}
function $as_F0(obj) {
  return (($is_F0(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.Function0"))
}
function $isArrayOf_F0(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.F0)))
}
function $asArrayOf_F0(obj, depth) {
  return (($isArrayOf_F0(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.Function0;", depth))
}
function $f_F1__compose__F1__F1($thiz, g) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, g$1) {
    return (function(x$2) {
      return $this.apply__O__O(g$1.apply__O__O(x$2))
    })
  })($thiz, g))
}
function $is_F1(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.F1)))
}
function $as_F1(obj) {
  return (($is_F1(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.Function1"))
}
function $isArrayOf_F1(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.F1)))
}
function $asArrayOf_F1(obj, depth) {
  return (($isArrayOf_F1(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.Function1;", depth))
}
function $f_F2__tupled__F1($thiz) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$1$2) {
      var x0$1 = $as_T2(x0$1$2);
      if ((x0$1 !== null)) {
        var x1$2 = x0$1.$$und1__O();
        var x2 = x0$1.$$und2__O();
        return $this.apply__O__O__O(x1$2, x2)
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })($thiz))
}
function $f_Lcats_instances_ListInstancesBinCompat0__$$init$__V($thiz) {
  $thiz.catsStdTraverseFilterForList$1 = new $c_Lcats_instances_ListInstancesBinCompat0$$anon$3().init___Lcats_instances_ListInstancesBinCompat0($thiz)
}
function $is_Lio_circe_CursorOp$Selection(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_circe_CursorOp$Selection)))
}
function $as_Lio_circe_CursorOp$Selection(obj) {
  return (($is_Lio_circe_CursorOp$Selection(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.circe.CursorOp$Selection"))
}
function $isArrayOf_Lio_circe_CursorOp$Selection(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_circe_CursorOp$Selection)))
}
function $asArrayOf_Lio_circe_CursorOp$Selection(obj, depth) {
  return (($isArrayOf_Lio_circe_CursorOp$Selection(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.circe.CursorOp$Selection;", depth))
}
function $f_Lio_youi_ErrorSupport__error__jl_Throwable__V($thiz, t) {
  var this$1 = $m_Lio_youi_ErrorSupport$().error$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, t$1) {
    return (function() {
      return t$1
    })
  })($thiz, t));
  this$1.set__F0__V(value)
}
function $is_Lio_youi_MessageException(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_MessageException)))
}
function $as_Lio_youi_MessageException(obj) {
  return (($is_Lio_youi_MessageException(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.MessageException"))
}
function $isArrayOf_Lio_youi_MessageException(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_MessageException)))
}
function $asArrayOf_Lio_youi_MessageException(obj, depth) {
  return (($isArrayOf_Lio_youi_MessageException(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.MessageException;", depth))
}
function $f_Lio_youi_Modifiable__modified__Lreactify_Var($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $is_Lio_youi_Modifiable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_Modifiable)))
}
function $as_Lio_youi_Modifiable(obj) {
  return (($is_Lio_youi_Modifiable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.Modifiable"))
}
function $isArrayOf_Lio_youi_Modifiable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_Modifiable)))
}
function $asArrayOf_Lio_youi_Modifiable(obj, depth) {
  return (($isArrayOf_Lio_youi_Modifiable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.Modifiable;", depth))
}
function $is_Lio_youi_Updatable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_Updatable)))
}
function $as_Lio_youi_Updatable(obj) {
  return (($is_Lio_youi_Updatable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.Updatable"))
}
function $isArrayOf_Lio_youi_Updatable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_Updatable)))
}
function $asArrayOf_Lio_youi_Updatable(obj, depth) {
  return (($isArrayOf_Lio_youi_Updatable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.Updatable;", depth))
}
function $f_Lio_youi_app_screen_Screen__activate__s_concurrent_Future($thiz) {
  var this$1 = $m_Lio_youi_ui$().title__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $this.title__T()
    })
  })($thiz));
  this$1.set__F0__V(value);
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
}
function $f_Lio_youi_app_screen_Screen__$$init$__V($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_Lio_youi_app_screen_ScreenState$New$()
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  $thiz.io$youi$app$screen$Screen$$undsetter$und$currentState$und$eq__Lreactify_Var__V(new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name));
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      var v = this$2$1.currentState__Lreactify_Var();
      return $as_Lio_youi_app_screen_ScreenState(v.state__Lreactify_State().value__O())
    })
  })($thiz));
  var name$1 = $m_s_None$();
  $thiz.io$youi$app$screen$Screen$$undsetter$und$state$und$eq__Lreactify_Val__V(new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$1));
  var this$7 = $m_Lio_youi_app_screen_ScreenManager$().apply__Lio_youi_app_screen_ScreenManager();
  $f_Lio_youi_app_screen_ScreenManager__addScreen__Lio_youi_app_screen_Screen__V(this$7, $thiz)
}
function $is_Lio_youi_app_screen_Screen(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_screen_Screen)))
}
function $as_Lio_youi_app_screen_Screen(obj) {
  return (($is_Lio_youi_app_screen_Screen(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.screen.Screen"))
}
function $isArrayOf_Lio_youi_app_screen_Screen(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_screen_Screen)))
}
function $asArrayOf_Lio_youi_app_screen_Screen(obj, depth) {
  return (($isArrayOf_Lio_youi_app_screen_Screen(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.screen.Screen;", depth))
}
function $f_Lio_youi_app_screen_ScreenManager__addScreen__Lio_youi_app_screen_Screen__V($thiz, screen) {
  var this$6 = $thiz.io$youi$app$screen$ScreenManager$$allScreens$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, screen$1) {
    return (function() {
      var this$1 = $this.io$youi$app$screen$ScreenManager$$allScreens$1;
      var x$10 = $as_sci_List(this$1.state__Lreactify_State().value__O());
      $m_sci_List$();
      var array = [screen$1];
      var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
      var this$5 = $m_sci_List$();
      var cbf = this$5.ReusableCBFInstance$2;
      return $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)).$$colon$colon$colon__sci_List__sci_List(x$10)
    })
  })($thiz, screen));
  this$6.set__F0__V(value)
}
function $f_Lio_youi_app_screen_ScreenManager__screenChange__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__V($thiz, oldScreen, newScreen) {
  if ($thiz.io$youi$app$screen$ScreenManager$$managerFuture$1.isCompleted__Z()) {
    $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1 = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
  };
  var jsx$1 = $m_Lscribe_package$();
  var level = $m_Lscribe_Level$Debug$();
  var value = $m_Lscribe_Level$Debug$().value$1;
  var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, oldScreen$1, newScreen$1) {
    return (function() {
      return (((("Screen change from " + oldScreen$1) + " to ") + newScreen$1) + "...")
    })
  })($thiz, oldScreen, newScreen));
  var loggable = $m_Lscribe_Loggable$StringLoggable$();
  var throwable = $m_s_None$();
  var methodName = new $c_s_Some().init___O("screenChange");
  var line = new $c_s_Some().init___O(42);
  var column = new $c_s_Some().init___O(17);
  var thread = $m_jl_Thread$().SingleThread$1;
  var this$3 = $m_Lscribe_util_Time$();
  var this$4 = this$3.function$1;
  var t = $uJ(this$4.apply__O());
  var lo = t.lo$2;
  var hi = t.hi$2;
  jsx$1.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/app/js/src/main/scala/io/youi/app/screen/ScreenManager.scala", "io.youi.app.screen.ScreenManager", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
  var this$6 = $thiz.loaded$1;
  if ((!$uZ(this$6.state__Lreactify_State().value__O()))) {
    var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
    var this$10 = $thiz.loaded$1;
    var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, promise$1) {
      return (function(x$4$2) {
        $uZ(x$4$2);
        $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$1, (void 0))
      })
    })($thiz, promise));
    var this$8 = $thiz.loaded$1;
    var condition = $f_Lreactify_Reactive__once$default$2__F1(this$8);
    var priority = $m_Lreactify_Priority$().Normal$1;
    $f_Lreactify_Reactive__once__F1__F1__D__Lreactify_reaction_Reaction(this$10, f, condition, priority);
    $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1 = $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1.flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, promise$2) {
      return (function(x$5$2) {
        $asUnit(x$5$2);
        return promise$2
      })
    })($thiz, promise)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
  };
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1 = $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1.flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1, oldScreen$2, newScreen$2) {
    return (function(x$6$2) {
      $asUnit(x$6$2);
      return $f_Lio_youi_app_screen_LoadingTransitionSupport__beforeScreenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future(this$4$1, oldScreen$2, newScreen$2)
    })
  })($thiz, oldScreen, newScreen)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1 = $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1.flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$5$1, oldScreen$3) {
    return (function(x$7$2) {
      $asUnit(x$7$2);
      return $f_Lio_youi_app_screen_ScreenManager__deactivate__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future(this$5$1, oldScreen$3)
    })
  })($thiz, oldScreen)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1 = $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1.flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$6$1, newScreen$3) {
    return (function(x$8$2) {
      $asUnit(x$8$2);
      return $f_Lio_youi_app_screen_ScreenManager__activate__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future(this$6$1, newScreen$3)
    })
  })($thiz, newScreen)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1 = $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1.flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$7$1, oldScreen$4, newScreen$4) {
    return (function(x$9$2) {
      $asUnit(x$9$2);
      return $f_Lio_youi_app_screen_LoadingTransitionSupport__afterScreenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future(this$7$1, oldScreen$4, newScreen$4)
    })
  })($thiz, oldScreen, newScreen)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1.failed__s_concurrent_Future().foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$8$1) {
    return (function(throwable$2) {
      var throwable$1 = $as_jl_Throwable(throwable$2);
      var this$11 = $m_Lio_youi_app_YouIApplication$().apply__Lio_youi_app_YouIApplication();
      $f_Lio_youi_ErrorSupport__error__jl_Throwable__V(this$11, throwable$1)
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $f_Lio_youi_app_screen_ScreenManager__$$init$__V($thiz) {
  $m_Lio_youi_app_screen_ScreenManager$().io$youi$app$screen$ScreenManager$$instance$1 = new $c_s_Some().init___O($thiz);
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1 = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_sci_Nil$()
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  $thiz.io$youi$app$screen$ScreenManager$$allScreens$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  $thiz.screens$1 = $thiz.io$youi$app$screen$ScreenManager$$allScreens$1;
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      return $m_Lio_youi_app_screen_EmptyScreen$()
    })
  })($thiz));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  $thiz.active$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      return false
    })
  })($thiz));
  var mode$2 = $m_Lreactify_Var$Mode$Normal$();
  var name$2 = $m_s_None$();
  $thiz.loaded$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$2, name$2);
  $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0)).foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
    return (function(x$1$2) {
      $asUnit(x$1$2);
      $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().addEventListener("load", (function(arg$outer) {
        return (function(arg1$2) {
          $f_Lio_youi_app_screen_ScreenManager__io$youi$app$screen$ScreenManager$$$anonfun$$init$$2__Lorg_scalajs_dom_raw_Event__V(arg$outer, arg1$2)
        })
      })(this$4$1))
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
  var this$11 = $thiz.active$1;
  var f = new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function(this$5$1) {
    return (function(x0$1$2, x1$1$2) {
      var x0$1 = $as_Lio_youi_app_screen_Screen(x0$1$2);
      var x1$1 = $as_Lio_youi_app_screen_Screen(x1$1$2);
      $f_Lio_youi_app_screen_ScreenManager__screenChange__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__V(this$5$1, x0$1, x1$1)
    })
  })($thiz));
  var priority = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__changes__F2__D__Lreactify_reaction_Reaction(this$11, f, priority)
}
function $f_Lio_youi_app_screen_ScreenManager__activate__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, screen) {
  var elem = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
  var elem$1 = null;
  elem$1 = elem;
  var this$2 = screen.state__Lreactify_Val();
  var state = $as_Lio_youi_app_screen_ScreenState(this$2.state__Lreactify_State().value__O());
  var applying = $m_Lio_youi_app_screen_ScreenState$Initializing$();
  var applied = $m_Lio_youi_app_screen_ScreenState$Initialized$();
  var call = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, screen$1) {
    return (function() {
      return screen$1.init__s_concurrent_Future()
    })
  })($thiz, screen));
  var array = [$m_Lio_youi_app_screen_ScreenState$New$(), $m_Lio_youi_app_screen_ScreenState$Disposing$(), $m_Lio_youi_app_screen_ScreenState$Disposed$()];
  var i = 0;
  while (true) {
    if ((i < $uI(array.length))) {
      var index = i;
      var arg1 = array[index];
      var jsx$1 = ($m_sr_BoxesRunTime$().equals__O__O__Z(arg1, state) === false)
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      i = ((1 + i) | 0)
    } else {
      break
    }
  };
  if ((i !== $uI(array.length))) {
    elem$1 = $as_s_concurrent_Future(elem$1).flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1, screen$4, applying$1, applied$1, call$1) {
      return (function(x$14$2) {
        $asUnit(x$14$2);
        var this$6 = screen$4.currentState__Lreactify_Var();
        var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$2, applying$2) {
          return (function() {
            return applying$2
          })
        })($this$1, applying$1));
        this$6.set__F0__V(value);
        return $as_s_concurrent_Future(call$1.apply__O()).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, screen$4$1, applied$2) {
          return (function(x$15$2) {
            $asUnit(x$15$2);
            var this$7 = screen$4$1.currentState__Lreactify_Var();
            var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$3, applied$2$1) {
              return (function() {
                return applied$2$1
              })
            })(this$2$1, applied$2));
            this$7.set__F0__V(value$1)
          })
        })($this$1, screen$4, applied$1)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
      })
    })($thiz, screen, applying, applied, call)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
  };
  var applying$3 = $m_Lio_youi_app_screen_ScreenState$Loading$();
  var applied$3 = $m_Lio_youi_app_screen_ScreenState$Loaded$();
  var call$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$2, screen$2) {
    return (function() {
      return screen$2.load__s_concurrent_Future()
    })
  })($thiz, screen));
  var array$1 = [$m_Lio_youi_app_screen_ScreenState$New$(), $m_Lio_youi_app_screen_ScreenState$Disposing$(), $m_Lio_youi_app_screen_ScreenState$Disposed$(), $m_Lio_youi_app_screen_ScreenState$Initializing$(), $m_Lio_youi_app_screen_ScreenState$Initialized$()];
  var i$1 = 0;
  while (true) {
    if ((i$1 < $uI(array$1.length))) {
      var index$1 = i$1;
      var arg1$1 = array$1[index$1];
      var jsx$2 = ($m_sr_BoxesRunTime$().equals__O__O__Z(arg1$1, state) === false)
    } else {
      var jsx$2 = false
    };
    if (jsx$2) {
      i$1 = ((1 + i$1) | 0)
    } else {
      break
    }
  };
  if ((i$1 !== $uI(array$1.length))) {
    elem$1 = $as_s_concurrent_Future(elem$1).flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$4, screen$4$2, applying$4, applied$4, call$3) {
      return (function(x$14$2$1) {
        $asUnit(x$14$2$1);
        var this$11 = screen$4$2.currentState__Lreactify_Var();
        var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$5, applying$2$1) {
          return (function() {
            return applying$2$1
          })
        })($this$4, applying$4));
        this$11.set__F0__V(value$2);
        return $as_s_concurrent_Future(call$3.apply__O()).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$3, screen$4$3, applied$2$2) {
          return (function(x$15$2$1) {
            $asUnit(x$15$2$1);
            var this$12 = screen$4$3.currentState__Lreactify_Var();
            var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$6, applied$2$3) {
              return (function() {
                return applied$2$3
              })
            })(this$2$3, applied$2$2));
            this$12.set__F0__V(value$3)
          })
        })($this$4, screen$4$2, applied$4)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
      })
    })($thiz, screen, applying$3, applied$3, call$2)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
  };
  var applying$5 = $m_Lio_youi_app_screen_ScreenState$Activating$();
  var applied$5 = $m_Lio_youi_app_screen_ScreenState$Activated$();
  var call$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, screen$3) {
    return (function() {
      return screen$3.activate__s_concurrent_Future()
    })
  })($thiz, screen));
  var array$2 = [$m_Lio_youi_app_screen_ScreenState$New$(), $m_Lio_youi_app_screen_ScreenState$Disposing$(), $m_Lio_youi_app_screen_ScreenState$Disposed$(), $m_Lio_youi_app_screen_ScreenState$Initializing$(), $m_Lio_youi_app_screen_ScreenState$Initialized$(), $m_Lio_youi_app_screen_ScreenState$Deactivating$(), $m_Lio_youi_app_screen_ScreenState$Deactivated$()];
  var i$2 = 0;
  while (true) {
    if ((i$2 < $uI(array$2.length))) {
      var index$2 = i$2;
      var arg1$2 = array$2[index$2];
      var jsx$3 = ($m_sr_BoxesRunTime$().equals__O__O__Z(arg1$2, state) === false)
    } else {
      var jsx$3 = false
    };
    if (jsx$3) {
      i$2 = ((1 + i$2) | 0)
    } else {
      break
    }
  };
  if ((i$2 !== $uI(array$2.length))) {
    elem$1 = $as_s_concurrent_Future(elem$1).flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$7, screen$4$4, applying$6, applied$6, call$5) {
      return (function(x$14$2$2) {
        $asUnit(x$14$2$2);
        var this$16 = screen$4$4.currentState__Lreactify_Var();
        var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$8, applying$2$2) {
          return (function() {
            return applying$2$2
          })
        })($this$7, applying$6));
        this$16.set__F0__V(value$4);
        return $as_s_concurrent_Future(call$5.apply__O()).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$4, screen$4$5, applied$2$4) {
          return (function(x$15$2$2) {
            $asUnit(x$15$2$2);
            var this$17 = screen$4$5.currentState__Lreactify_Var();
            var value$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$9, applied$2$5) {
              return (function() {
                return applied$2$5
              })
            })(this$2$4, applied$2$4));
            this$17.set__F0__V(value$5)
          })
        })($this$7, screen$4$4, applied$6)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
      })
    })($thiz, screen, applying$5, applied$5, call$4)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
  };
  var jsx$4 = $as_s_concurrent_Future(elem$1).failed__s_concurrent_Future();
  var eta$0$2 = $m_Lio_youi_app_YouIApplication$().apply__Lio_youi_app_YouIApplication();
  jsx$4.foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1, eta$0$2$1) {
    return (function(t$2) {
      var t = $as_jl_Throwable(t$2);
      $f_Lio_youi_ErrorSupport__error__jl_Throwable__V(eta$0$2$1, t)
    })
  })($thiz, eta$0$2)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1 = $as_s_concurrent_Future(elem$1);
  return $as_s_concurrent_Future(elem$1)
}
function $f_Lio_youi_app_screen_ScreenManager__deactivate__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, screen) {
  var this$1 = screen.state__Lreactify_Val();
  var x = this$1.state__Lreactify_State().value__O();
  var x$2 = $m_Lio_youi_app_screen_ScreenState$Activated$();
  if (((x !== null) && $objectEquals(x, x$2))) {
    var this$2 = screen.currentState__Lreactify_Var();
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_Lio_youi_app_screen_ScreenState$Deactivating$()
      })
    })($thiz));
    this$2.set__F0__V(value);
    var future = screen.deactivate__s_concurrent_Future().map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, screen$1) {
      return (function(x$16$2) {
        $asUnit(x$16$2);
        var this$4 = screen$1.currentState__Lreactify_Var();
        var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
          return (function() {
            return $m_Lio_youi_app_screen_ScreenState$Deactivated$()
          })
        })(this$2$1));
        this$4.set__F0__V(value$1)
      })
    })($thiz, screen)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
    var jsx$1 = future.failed__s_concurrent_Future();
    var eta$0$3 = $m_Lio_youi_app_YouIApplication$().apply__Lio_youi_app_YouIApplication();
    jsx$1.foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, eta$0$3$1) {
      return (function(t$2) {
        var t = $as_jl_Throwable(t$2);
        $f_Lio_youi_ErrorSupport__error__jl_Throwable__V(eta$0$3$1, t)
      })
    })($thiz, eta$0$3)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
    $thiz.io$youi$app$screen$ScreenManager$$managerFuture$1 = future;
    return future
  } else {
    return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
  }
}
function $f_Lio_youi_app_screen_ScreenManager__io$youi$app$screen$ScreenManager$$$anonfun$$init$$2__Lorg_scalajs_dom_raw_Event__V($thiz, x$2) {
  $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0)).foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$3$2) {
      $asUnit(x$3$2);
      var this$1 = $as_Lreactify_Var($this.loaded$1);
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
        return (function() {
          return true
        })
      })($this));
      this$1.set__F0__V(value)
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $is_Lio_youi_app_screen_ScreenManager(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_screen_ScreenManager)))
}
function $as_Lio_youi_app_screen_ScreenManager(obj) {
  return (($is_Lio_youi_app_screen_ScreenManager(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.screen.ScreenManager"))
}
function $isArrayOf_Lio_youi_app_screen_ScreenManager(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_screen_ScreenManager)))
}
function $asArrayOf_Lio_youi_app_screen_ScreenManager(obj, depth) {
  return (($isArrayOf_Lio_youi_app_screen_ScreenManager(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.screen.ScreenManager;", depth))
}
function $f_Lio_youi_component_extras_ComponentSize__center__Lreactify_Val($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var v = $this.width__Lreactify_Var();
      return ($uD(v.state__Lreactify_State().value__O()) / 2.0)
    })
  })($thiz));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
}
function $f_Lio_youi_component_extras_ComponentSize__middle__Lreactify_Val($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var v = $this.height__Lreactify_Var();
      return ($uD(v.state__Lreactify_State().value__O()) / 2.0)
    })
  })($thiz));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
}
function $f_Lio_youi_component_extras_ComponentSize__width__Lreactify_Var($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $f_Lio_youi_component_extras_ComponentSize__height__Lreactify_Var($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $f_Lio_youi_component_extras_ComponentSize__reset__Z__Z__V($thiz, width, height) {
  if (width) {
    $thiz.width__Lreactify_Var().set__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$1 = $this.measured__Lio_youi_component_extras_ComponentSize$measured$().width__Lreactify_Var();
        return $uD(this$1.state__Lreactify_State().value__O())
      })
    })($thiz)))
  };
  if (height) {
    $thiz.height__Lreactify_Var().set__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
      return (function() {
        var this$3 = this$2.measured__Lio_youi_component_extras_ComponentSize$measured$().height__Lreactify_Var();
        return $uD(this$3.state__Lreactify_State().value__O())
      })
    })($thiz)))
  }
}
function $f_Lio_youi_component_extras_ComponentSize__$$colon$eq__F0__V($thiz, size) {
  var this$1 = $thiz.width__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, size$1) {
    return (function() {
      return $as_Lio_youi_spatial_Size(size$1.apply__O()).width$1
    })
  })($thiz, size));
  this$1.set__F0__V(value);
  var this$3 = $thiz.height__Lreactify_Var();
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, size$2) {
    return (function() {
      return $as_Lio_youi_spatial_Size(size$2.apply__O()).height$1
    })
  })($thiz, size));
  this$3.set__F0__V(value$1)
}
function $is_Lio_youi_easing_Easing(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_easing_Easing)))
}
function $as_Lio_youi_easing_Easing(obj) {
  return (($is_Lio_youi_easing_Easing(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.easing.Easing"))
}
function $isArrayOf_Lio_youi_easing_Easing(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_easing_Easing)))
}
function $asArrayOf_Lio_youi_easing_Easing(obj, depth) {
  return (($isArrayOf_Lio_youi_easing_Easing(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.easing.Easing;", depth))
}
function $f_Lio_youi_event_EventSupport__link__Lio_youi_net_URL__V($thiz, url) {
  $thiz.component$1.cursor__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_Lio_youi_Cursor$Pointer$()
    })
  })($thiz)));
  var this$3 = $thiz.click__Lreactify_Channel();
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, url$1) {
    return (function() {
      $m_Lio_youi_History$().push__Lio_youi_net_URL__sjs_js_Any__V(url$1, ($m_Lio_youi_History$(), null))
    })
  })($thiz, url));
  $thiz.click__Lreactify_Channel();
  var priority = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__on__F0__D__Lreactify_reaction_Reaction(this$3, f, priority)
}
function $f_Lio_youi_event_EventSupport__link__T__V($thiz, path) {
  var this$1 = $m_Lio_youi_History$().url$1;
  var url = $as_Lio_youi_net_URL(this$1.state__Lreactify_State().value__O()).withPart__T__Lio_youi_net_URL(path);
  $f_Lio_youi_event_EventSupport__link__Lio_youi_net_URL__V($thiz, url)
}
function $is_Lio_youi_font_GoogleFont(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_font_GoogleFont)))
}
function $as_Lio_youi_font_GoogleFont(obj) {
  return (($is_Lio_youi_font_GoogleFont(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.font.GoogleFont"))
}
function $isArrayOf_Lio_youi_font_GoogleFont(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_font_GoogleFont)))
}
function $asArrayOf_Lio_youi_font_GoogleFont(obj, depth) {
  return (($isArrayOf_Lio_youi_font_GoogleFont(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.font.GoogleFont;", depth))
}
function $f_Lio_youi_layout_GridLayout$Config__prop__F1__Lreactify_Var($thiz, lookup) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, lookup$1) {
    return (function() {
      var jsx$1 = $this.parents__sci_List();
      var this$1 = $m_sci_List$();
      var this$2 = $as_sc_TraversableOnce(jsx$1.map__F1__scg_CanBuildFrom__O(lookup$1, this$1.ReusableCBFInstance$2));
      var pf = new $c_Lio_youi_layout_GridLayout$Config$$anonfun$$nestedInanonfun$prop$1$1().init___Lio_youi_layout_GridLayout$Config($this);
      return $f_sc_TraversableOnce__collectFirst__s_PartialFunction__s_Option(this$2, pf)
    })
  })($thiz, lookup));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  var v = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      this$2$1.io$youi$layout$GridLayout$Config$$$outer__Lio_youi_layout_GridLayout().updateAll__V()
    })
  })($thiz));
  var priority = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__on__F0__D__Lreactify_reaction_Reaction(v, f, priority);
  return v
}
function $is_Lio_youi_layout_GridLayout$Config(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_layout_GridLayout$Config)))
}
function $as_Lio_youi_layout_GridLayout$Config(obj) {
  return (($is_Lio_youi_layout_GridLayout$Config(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.layout.GridLayout$Config"))
}
function $isArrayOf_Lio_youi_layout_GridLayout$Config(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_layout_GridLayout$Config)))
}
function $asArrayOf_Lio_youi_layout_GridLayout$Config(obj, depth) {
  return (($isArrayOf_Lio_youi_layout_GridLayout$Config(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.layout.GridLayout$Config;", depth))
}
function $is_Lio_youi_layout_Layout(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_layout_Layout)))
}
function $as_Lio_youi_layout_Layout(obj) {
  return (($is_Lio_youi_layout_Layout(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.layout.Layout"))
}
function $isArrayOf_Lio_youi_layout_Layout(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_layout_Layout)))
}
function $asArrayOf_Lio_youi_layout_Layout(obj, depth) {
  return (($isArrayOf_Lio_youi_layout_Layout(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.layout.Layout;", depth))
}
function $is_Lio_youi_net_PathPart(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_net_PathPart)))
}
function $as_Lio_youi_net_PathPart(obj) {
  return (($is_Lio_youi_net_PathPart(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.net.PathPart"))
}
function $isArrayOf_Lio_youi_net_PathPart(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_net_PathPart)))
}
function $asArrayOf_Lio_youi_net_PathPart(obj, depth) {
  return (($isArrayOf_Lio_youi_net_PathPart(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.net.PathPart;", depth))
}
function $f_Lio_youi_paint_Border__height__D($thiz) {
  return ($thiz.stroke$1.lineWidth$1 + $thiz.stroke$1.lineWidth$1)
}
function $f_Lio_youi_paint_Border__width__D($thiz) {
  return ($thiz.stroke$1.lineWidth$1 + $thiz.stroke$1.lineWidth$1)
}
function $is_Lio_youi_paint_Border(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_paint_Border)))
}
function $as_Lio_youi_paint_Border(obj) {
  return (($is_Lio_youi_paint_Border(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.paint.Border"))
}
function $isArrayOf_Lio_youi_paint_Border(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_paint_Border)))
}
function $asArrayOf_Lio_youi_paint_Border(obj, depth) {
  return (($isArrayOf_Lio_youi_paint_Border(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.paint.Border;", depth))
}
function $is_Lio_youi_style_Position(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_Position)))
}
function $as_Lio_youi_style_Position(obj) {
  return (($is_Lio_youi_style_Position(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.Position"))
}
function $isArrayOf_Lio_youi_style_Position(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_Position)))
}
function $asArrayOf_Lio_youi_style_Position(obj, depth) {
  return (($isArrayOf_Lio_youi_style_Position(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.Position;", depth))
}
function $f_Lio_youi_task_Task__andThen__Lio_youi_task_Task__Lio_youi_task_Task($thiz, that) {
  $m_sci_List$();
  var array = [$thiz, that];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var this$4 = $m_sci_List$();
  var cbf = this$4.ReusableCBFInstance$2;
  return new $c_Lio_youi_task_Sequential().init___sci_List($as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)))
}
function $is_Lio_youi_task_Task(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_task_Task)))
}
function $as_Lio_youi_task_Task(obj) {
  return (($is_Lio_youi_task_Task(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.task.Task"))
}
function $isArrayOf_Lio_youi_task_Task(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_task_Task)))
}
function $asArrayOf_Lio_youi_task_Task(obj, depth) {
  return (($isArrayOf_Lio_youi_task_Task(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.task.Task;", depth))
}
function $f_Lio_youi_theme_StringifyImplicits__stringifyBoolean__Lio_youi_theme_Stringify($thiz) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(b$2) {
      var b = $uZ(b$2);
      return new $c_s_Some().init___O(("" + b))
    })
  })($thiz));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(x0$1$2) {
      var x0$1 = $as_T(x0$1$2);
      return ((x0$1 === "true") ? new $c_s_Some().init___O(true) : ((x0$1 === "false") ? new $c_s_Some().init___O(false) : $m_s_None$()))
    })
  })($thiz));
  return new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from)
}
function $f_Lio_youi_theme_StringifyImplicits__$$init$__V($thiz) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(c$2) {
      var t = $as_Lio_youi_Color(c$2).value$1;
      var lo = t.lo$2;
      var hi = t.hi$2;
      var this$3 = new $c_Lio_youi_paint_ColorPaint().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo, hi));
      return new $c_s_Some().init___O($m_Lio_youi_Color$().toRGBA$extension__J__T(this$3.color$1))
    })
  })($thiz));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(value$2) {
      var value = $as_T(value$2);
      return $m_Lio_youi_Color$().unapply__T__s_Option(value)
    })
  })($thiz));
  $thiz.io$youi$theme$StringifyImplicits$$undsetter$und$stringifyColor$und$eq__Lio_youi_theme_Stringify__V(new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from))
}
function $f_Lio_youi_theme_StringifyImplicits__stringifyDouble__Lio_youi_theme_Stringify($thiz) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(d$2) {
      var d = $uD(d$2);
      return new $c_s_Some().init___O(("" + d))
    })
  })($thiz));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(s$2) {
      var s = $as_T(s$2);
      try {
        var this$4 = new $c_sci_StringOps().init___T(s);
        var jsx$1 = $m_jl_Double$();
        var $$this = this$4.repr$1;
        return new $c_s_Some().init___O(jsx$1.parseDouble__T__D($$this))
      } catch (e) {
        var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
        if ((e$2 !== null)) {
          return $m_s_None$()
        } else {
          throw e
        }
      }
    })
  })($thiz));
  return new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from)
}
function $f_Lio_youi_theme_StringifyImplicits__stringifyString__Lio_youi_theme_Stringify($thiz) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      var x$1 = $as_T(x$1$2);
      return new $c_s_Some().init___O(x$1)
    })
  })($thiz));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(x$2$2) {
      var x$2 = $as_T(x$2$2);
      return new $c_s_Some().init___O(x$2)
    })
  })($thiz));
  return new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from)
}
function $f_Lio_youi_theme_StringifyImplicits__pixels__Lio_youi_theme_Stringify($thiz) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(d$2) {
      var d = $uD(d$2);
      return new $c_s_Some().init___O((d + "px"))
    })
  })($thiz));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(s$2) {
      var s = $as_T(s$2);
      try {
        var this$3 = new $c_sci_StringOps().init___T(s);
        var $$this = this$3.repr$1;
        var x = $as_T($$this.split("px").join(""));
        var this$8 = new $c_sci_StringOps().init___T(x);
        var jsx$1 = $m_jl_Double$();
        var $$this$1 = this$8.repr$1;
        return new $c_s_Some().init___O(jsx$1.parseDouble__T__D($$this$1))
      } catch (e) {
        var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
        if ((e$2 !== null)) {
          return $m_s_None$()
        } else {
          throw e
        }
      }
    })
  })($thiz));
  return new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from)
}
function $is_Lio_youi_theme_StyleConnect(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_theme_StyleConnect)))
}
function $as_Lio_youi_theme_StyleConnect(obj) {
  return (($is_Lio_youi_theme_StyleConnect(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.theme.StyleConnect"))
}
function $isArrayOf_Lio_youi_theme_StyleConnect(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_theme_StyleConnect)))
}
function $asArrayOf_Lio_youi_theme_StyleConnect(obj, depth) {
  return (($isArrayOf_Lio_youi_theme_StyleConnect(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.theme.StyleConnect;", depth))
}
function $f_Lio_youi_util_ObjectPool__get__s_Option($thiz) {
  var this$1 = $thiz.io$youi$util$ObjectPool$$cached$1;
  if ($f_sc_TraversableOnce__nonEmpty__Z(this$1)) {
    try {
      var this$2 = $thiz.io$youi$util$ObjectPool$$cached$1;
      return $f_sc_TraversableLike__headOption__s_Option(this$2)
    } finally {
      $thiz.io$youi$util$ObjectPool$$cached$1 = $as_sci_List($thiz.io$youi$util$ObjectPool$$cached$1.tail__O())
    }
  } else {
    return $m_s_None$()
  }
}
function $f_Lio_youi_util_ObjectPool__restore__O__V($thiz, t) {
  var this$1 = $thiz.io$youi$util$ObjectPool$$cached$1;
  $thiz.io$youi$util$ObjectPool$$cached$1 = new $c_sci_$colon$colon().init___O__sci_List(t, this$1)
}
function $f_Lio_youi_util_ObjectPool__$$init$__V($thiz) {
  $thiz.io$youi$util$ObjectPool$$created$1 = 0;
  $thiz.io$youi$util$ObjectPool$$cached$1 = ($m_sci_List$(), $m_sci_Nil$())
}
function $f_Lio_youi_util_ObjectPool__apply__O($thiz) {
  var this$1 = $f_Lio_youi_util_ObjectPool__get__s_Option($thiz);
  if (this$1.isEmpty__Z()) {
    $thiz.io$youi$util$ObjectPool$$created$1 = ((1 + $thiz.io$youi$util$ObjectPool$$created$1) | 0);
    return $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("canvas")
  } else {
    return this$1.get__O()
  }
}
function $is_Lio_youi_virtual_VirtualMode(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_virtual_VirtualMode)))
}
function $as_Lio_youi_virtual_VirtualMode(obj) {
  return (($is_Lio_youi_virtual_VirtualMode(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.virtual.VirtualMode"))
}
function $isArrayOf_Lio_youi_virtual_VirtualMode(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_virtual_VirtualMode)))
}
function $asArrayOf_Lio_youi_virtual_VirtualMode(obj, depth) {
  return (($isArrayOf_Lio_youi_virtual_VirtualMode(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.virtual.VirtualMode;", depth))
}
function $f_Lio_youi_virtual_VirtualSizeSupport__$$init$__V($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 1024.0
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  $thiz.virtualWidth$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      return 768.0
    })
  })($thiz));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  $thiz.virtualHeight$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      return $m_Lio_youi_virtual_VirtualMode$Bars$()
    })
  })($thiz));
  var mode$2 = $m_Lreactify_Var$Mode$Normal$();
  var name$2 = $m_s_None$();
  $thiz.virtualMode$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$2, name$2);
  $thiz.virtual$1 = new $c_Lio_youi_virtual_VirtualSize().init___Lio_youi_virtual_VirtualSizeSupport($thiz)
}
function $f_Lperfolation_CrossDate__T__T($thiz) {
  var fresh$macro$6 = $m_Lperfolation_NumberFormatUtil$().$int__I__I__T($thiz.hour24__I(), 2);
  var fresh$macro$7 = $m_Lperfolation_NumberFormatUtil$().$int__I__I__T($thiz.minuteOfHour__I(), 2);
  var fresh$macro$8 = $m_Lperfolation_NumberFormatUtil$().$int__I__I__T($thiz.secondOfMinute__I(), 2);
  var this$1 = $m_Lperfolation_package$().stringBuilder__jl_StringBuilder();
  this$1.java$lang$StringBuilder$$content$f = (("" + this$1.java$lang$StringBuilder$$content$f) + fresh$macro$6);
  var this$2 = this$1.append__C__jl_StringBuilder(58);
  this$2.java$lang$StringBuilder$$content$f = (("" + this$2.java$lang$StringBuilder$$content$f) + fresh$macro$7);
  var this$3 = this$2.append__C__jl_StringBuilder(58);
  this$3.java$lang$StringBuilder$$content$f = (("" + this$3.java$lang$StringBuilder$$content$f) + fresh$macro$8);
  return this$3.java$lang$StringBuilder$$content$f
}
function $f_Lperfolation_CrossDate__m__T($thiz) {
  return $m_Lperfolation_NumberFormatUtil$().$int__I__I__T(((1 + $thiz.month__I()) | 0), 2)
}
function $is_Lperfolation_CrossDate(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lperfolation_CrossDate)))
}
function $as_Lperfolation_CrossDate(obj) {
  return (($is_Lperfolation_CrossDate(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "perfolation.CrossDate"))
}
function $isArrayOf_Lperfolation_CrossDate(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lperfolation_CrossDate)))
}
function $asArrayOf_Lperfolation_CrossDate(obj, depth) {
  return (($isArrayOf_Lperfolation_CrossDate(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lperfolation.CrossDate;", depth))
}
function $f_Lprofig_ProfigPath__get__s_Option($thiz) {
  var this$1 = $thiz.path__sci_List();
  if ($f_sc_TraversableOnce__nonEmpty__Z(this$1)) {
    if ($as_sc_SeqLike($thiz.path__sci_List().tail__O()).isEmpty__Z()) {
      var this$2 = $thiz.instance__Lprofig_Profig().json__Lio_circe_Json();
      var x1 = new $c_Lio_circe_cursor_TopCursor().init___Lio_circe_Json__Lio_circe_HCursor__Lio_circe_CursorOp(this$2, null, null).get__T__Lio_circe_Decoder__s_util_Either($as_T($thiz.path__sci_List().head__O()), $m_Lio_circe_Decoder$().decodeJson$1);
      if ($is_s_util_Left(x1)) {
        return $m_s_None$()
      } else if ($is_s_util_Right(x1)) {
        var x4 = $as_s_util_Right(x1);
        var value = $as_Lio_circe_Json(x4.value$2);
        return new $c_s_Some().init___O(value)
      } else {
        throw new $c_s_MatchError().init___O(x1)
      }
    } else {
      var path = $as_sci_List($thiz.path__sci_List().tail__O());
      var this$4 = $thiz.instance__Lprofig_Profig().json__Lio_circe_Json();
      var cursor = new $c_Lio_circe_cursor_TopCursor().init___Lio_circe_Json__Lio_circe_HCursor__Lio_circe_CursorOp(this$4, null, null).downField__T__Lio_circe_ACursor($as_T($thiz.path__sci_List().head__O()));
      return $f_Lprofig_ProfigPath__find$1__pLprofig_ProfigPath__sci_List__Lio_circe_ACursor__s_Option($thiz, path, cursor)
    }
  } else {
    return new $c_s_Some().init___O($thiz.instance__Lprofig_Profig().json__Lio_circe_Json())
  }
}
function $f_Lprofig_ProfigPath__apply__sc_Seq__Lprofig_ProfigPath($thiz, path) {
  var this$2 = path.toList__sci_List();
  var f = (function($this) {
    return (function(path$2$2) {
      var path$2 = $as_T(path$2$2);
      return $f_Lprofig_ProfigPath__path2List__pLprofig_ProfigPath__T__sci_List($this, path$2)
    })
  })($thiz);
  var this$1 = $m_sci_List$();
  var bf = this$1.ReusableCBFInstance$2;
  if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
    if ((this$2 === $m_sci_Nil$())) {
      var jsx$1 = $m_sci_Nil$()
    } else {
      var rest = this$2;
      var found = new $c_sr_BooleanRef().init___Z(false);
      var h = new $c_sr_ObjectRef().init___O(null);
      var t = new $c_sr_ObjectRef().init___O(null);
      while ((rest !== $m_sci_Nil$())) {
        var arg1 = rest.head__O();
        $as_sc_GenTraversableOnce(f(arg1)).seq__sc_TraversableOnce().foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1, found$1, h$1, t$1) {
          return (function(b$2) {
            if ((!found$1.elem$1)) {
              h$1.elem$1 = new $c_sci_$colon$colon().init___O__sci_List(b$2, $m_sci_Nil$());
              t$1.elem$1 = $as_sci_$colon$colon(h$1.elem$1);
              found$1.elem$1 = true
            } else {
              var nx = new $c_sci_$colon$colon().init___O__sci_List(b$2, $m_sci_Nil$());
              $as_sci_$colon$colon(t$1.elem$1).tl$5 = nx;
              t$1.elem$1 = nx
            }
          })
        })(this$2, found, h, t)));
        rest = $as_sci_List(rest.tail__O())
      };
      var jsx$1 = ((!found.elem$1) ? $m_sci_Nil$() : $as_sci_$colon$colon(h.elem$1))
    }
  } else {
    $m_sci_List$();
    var b = new $c_scm_ListBuffer().init___();
    var these = this$2;
    while ((!these.isEmpty__Z())) {
      var arg1$1 = these.head__O();
      var xs = $as_sc_GenTraversableOnce(f(arg1$1)).seq__sc_TraversableOnce();
      b.$$plus$plus$eq__sc_TraversableOnce__scm_ListBuffer(xs);
      these = $as_sci_List(these.tail__O())
    };
    var jsx$1 = b.toList__sci_List()
  };
  var list = $as_sci_List(jsx$1);
  var instance = $thiz.instance__Lprofig_Profig();
  var x$1 = $thiz.path__sci_List();
  var path$1 = list.$$colon$colon$colon__sci_List__sci_List(x$1);
  return new $c_Lprofig_ProfigPath$ProfigSubPath().init___Lprofig_Profig__sci_List(instance, path$1)
}
function $f_Lprofig_ProfigPath__find$1__pLprofig_ProfigPath__sci_List__Lio_circe_ACursor__s_Option($thiz, path, cursor) {
  _find: while (true) {
    if ($as_sc_SeqLike(path.tail__O()).isEmpty__Z()) {
      var x1 = cursor.get__T__Lio_circe_Decoder__s_util_Either($as_T(path.head__O()), $m_Lio_circe_Decoder$().decodeJson$1);
      if ($is_s_util_Left(x1)) {
        return $m_s_None$()
      } else if ($is_s_util_Right(x1)) {
        var x4 = $as_s_util_Right(x1);
        var value = $as_Lio_circe_Json(x4.value$2);
        return new $c_s_Some().init___O(value)
      } else {
        throw new $c_s_MatchError().init___O(x1)
      }
    } else {
      var temp$path = $as_sci_List(path.tail__O());
      var temp$cursor = cursor.downField__T__Lio_circe_ACursor($as_T(path.head__O()));
      path = temp$path;
      cursor = temp$cursor;
      continue _find
    }
  }
}
function $f_Lprofig_ProfigPath__combine__Lio_circe_Json__Z__V($thiz, json, defaults) {
  var this$1 = $thiz.path__sci_List();
  if ($f_sc_TraversableOnce__nonEmpty__Z(this$1)) {
    var jsx$1 = $m_Lprofig_ProfigUtil$();
    var this$2 = $thiz.path__sci_List();
    var updated = jsx$1.createJson__T__Lio_circe_Json__Lio_circe_Json($f_sc_TraversableOnce__mkString__T__T__T__T(this$2, "", ".", ""), json);
    if (defaults) {
      var this$3 = $thiz.instance__Lprofig_Profig();
      var arg1 = this$3.$$undlocal$1;
      this$3.$$undlocal$1 = updated.deepMerge__Lio_circe_Json__Lio_circe_Json(arg1);
      this$3.updateGlobal__p1__V();
      this$3.$$undlastModified$1 = $m_jl_System$().currentTimeMillis__J()
    } else {
      var this$4 = $thiz.instance__Lprofig_Profig();
      var arg1$1 = this$4.$$undlocal$1;
      this$4.$$undlocal$1 = arg1$1.deepMerge__Lio_circe_Json__Lio_circe_Json(updated);
      this$4.updateGlobal__p1__V();
      this$4.$$undlastModified$1 = $m_jl_System$().currentTimeMillis__J()
    }
  } else if (defaults) {
    var this$5 = $thiz.instance__Lprofig_Profig();
    var arg1$2 = this$5.$$undlocal$1;
    this$5.$$undlocal$1 = json.deepMerge__Lio_circe_Json__Lio_circe_Json(arg1$2);
    this$5.updateGlobal__p1__V();
    this$5.$$undlastModified$1 = $m_jl_System$().currentTimeMillis__J()
  } else {
    var this$6 = $thiz.instance__Lprofig_Profig();
    var arg1$3 = this$6.$$undlocal$1;
    this$6.$$undlocal$1 = arg1$3.deepMerge__Lio_circe_Json__Lio_circe_Json(json);
    this$6.updateGlobal__p1__V();
    this$6.$$undlastModified$1 = $m_jl_System$().currentTimeMillis__J()
  }
}
function $f_Lprofig_ProfigPath__path2List__pLprofig_ProfigPath__T__sci_List($thiz, path) {
  var this$2 = new $c_sci_StringOps().init___T(path);
  var xs = $f_sci_StringLike__split__C__AT(this$2, 46);
  var this$4 = $m_sci_List$();
  var cbf = this$4.ReusableCBFInstance$2;
  var b = cbf.apply__scm_Builder();
  var x1 = xs.u.length;
  switch (x1) {
    case (-1): {
      break
    }
    default: {
      b.sizeHint__I__V(x1)
    }
  };
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs));
  return $as_sci_List(b.result__O())
}
function $f_Lreactify_Reactive__fireInternal__pLreactify_Reactive__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus($thiz, value, previous, reactions) {
  _fireInternal: while (true) {
    var this$1 = reactions;
    if (($f_sc_TraversableOnce__nonEmpty__Z(this$1) && $as_s_Option($thiz.reactify$Reactive$$$undstatus__jl_ThreadLocal().get__O()).contains__O__Z($m_Lreactify_reaction_ReactionStatus$Continue$()))) {
      var reaction = $as_Lreactify_reaction_Reaction(reactions.head__O());
      var status = reaction.apply__O__s_Option__Lreactify_reaction_ReactionStatus(value, previous);
      var x$3 = $m_Lreactify_reaction_ReactionStatus$Continue$();
      if ((((status !== null) && (status === x$3)) && $as_s_Option($thiz.reactify$Reactive$$$undstatus__jl_ThreadLocal().get__O()).contains__O__Z($m_Lreactify_reaction_ReactionStatus$Continue$()))) {
        reactions = $as_sci_List(reactions.tail__O());
        continue _fireInternal
      } else {
        return $m_Lreactify_reaction_ReactionStatus$Stop$()
      }
    } else {
      var this$2 = $as_s_Option($thiz.reactify$Reactive$$$undstatus__jl_ThreadLocal().get__O());
      if (this$2.isEmpty__Z()) {
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("Status not set"))
      };
      return $as_Lreactify_reaction_ReactionStatus(this$2.get__O())
    }
  }
}
function $f_Lreactify_Reactive__once__F1__F1__D__Lreactify_reaction_Reaction($thiz, f, condition, priority) {
  var reaction = new $c_sr_ObjectRef().init___O(null);
  var $function = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1, condition$1, reaction$1) {
    return (function(t$2) {
      if ($uZ(condition$1.apply__O__O(t$2))) {
        $this.reactions__Lreactify_reaction_Reactions().$$minus$eq__Lreactify_reaction_Reaction__Z($as_Lreactify_reaction_Reaction(reaction$1.elem$1));
        f$1.apply__O__O(t$2)
      }
    })
  })($thiz, f, condition, reaction));
  reaction.elem$1 = new $c_Lreactify_reaction_FunctionReaction().init___F1__D($function, priority);
  $thiz.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction($as_Lreactify_reaction_Reaction(reaction.elem$1));
  return $as_Lreactify_reaction_Reaction(reaction.elem$1)
}
function $f_Lreactify_Reactive__on__F0__D__Lreactify_reaction_Reaction($thiz, f, priority) {
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1) {
    return (function(x$1$2) {
      f$1.apply__O()
    })
  })($thiz, f));
  return $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction($thiz, f$2, priority)
}
function $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction($thiz, f, priority) {
  return $thiz.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(new $c_Lreactify_reaction_FunctionReaction().init___F1__D(f, priority))
}
function $f_Lreactify_Reactive__once$default$2__F1($thiz) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$2$2) {
      return true
    })
  })($thiz))
}
function $f_Lreactify_Reactive__fire__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus($thiz, value, previous, reactions) {
  $thiz.reactify$Reactive$$$undstatus__jl_ThreadLocal().set__O__V(new $c_s_Some().init___O($m_Lreactify_reaction_ReactionStatus$Continue$()));
  try {
    var reactions$1 = reactions;
    return $f_Lreactify_Reactive__fireInternal__pLreactify_Reactive__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus($thiz, value, previous, reactions$1)
  } finally {
    $thiz.reactify$Reactive$$$undstatus__jl_ThreadLocal().remove__V()
  }
}
function $f_Lreactify_Reactive__changes__F2__D__Lreactify_reaction_Reaction($thiz, f, priority) {
  return $thiz.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(new $c_Lreactify_reaction_ChangeFunctionReaction().init___F2__D(f, priority))
}
function $is_Lreactify_Reactive(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_Reactive)))
}
function $as_Lreactify_Reactive(obj) {
  return (($is_Lreactify_Reactive(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.Reactive"))
}
function $isArrayOf_Lreactify_Reactive(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_Reactive)))
}
function $asArrayOf_Lreactify_Reactive(obj, depth) {
  return (($isArrayOf_Lreactify_Reactive(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.Reactive;", depth))
}
function $is_Lreactify_reaction_ReactionStatus(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_reaction_ReactionStatus)))
}
function $as_Lreactify_reaction_ReactionStatus(obj) {
  return (($is_Lreactify_reaction_ReactionStatus(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.reaction.ReactionStatus"))
}
function $isArrayOf_Lreactify_reaction_ReactionStatus(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_reaction_ReactionStatus)))
}
function $asArrayOf_Lreactify_reaction_ReactionStatus(obj, depth) {
  return (($isArrayOf_Lreactify_reaction_ReactionStatus(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.reaction.ReactionStatus;", depth))
}
function $is_Lscribe_LogRecord(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lscribe_LogRecord)))
}
function $as_Lscribe_LogRecord(obj) {
  return (($is_Lscribe_LogRecord(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scribe.LogRecord"))
}
function $isArrayOf_Lscribe_LogRecord(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lscribe_LogRecord)))
}
function $asArrayOf_Lscribe_LogRecord(obj, depth) {
  return (($isArrayOf_Lscribe_LogRecord(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscribe.LogRecord;", depth))
}
function $is_Lscribe_format_FormatBlock(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lscribe_format_FormatBlock)))
}
function $as_Lscribe_format_FormatBlock(obj) {
  return (($is_Lscribe_format_FormatBlock(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scribe.format.FormatBlock"))
}
function $isArrayOf_Lscribe_format_FormatBlock(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lscribe_format_FormatBlock)))
}
function $asArrayOf_Lscribe_format_FormatBlock(obj, depth) {
  return (($isArrayOf_Lscribe_format_FormatBlock(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscribe.format.FormatBlock;", depth))
}
function $is_Lscribe_output_LogOutput(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lscribe_output_LogOutput)))
}
function $as_Lscribe_output_LogOutput(obj) {
  return (($is_Lscribe_output_LogOutput(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scribe.output.LogOutput"))
}
function $isArrayOf_Lscribe_output_LogOutput(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lscribe_output_LogOutput)))
}
function $asArrayOf_Lscribe_output_LogOutput(obj, depth) {
  return (($isArrayOf_Lscribe_output_LogOutput(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscribe.output.LogOutput;", depth))
}
function $f_Lshapeless_Nats__$$init$__V($thiz) {
  $thiz.$$und1$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und2$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und3$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und4$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und5$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und6$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und7$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und8$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und9$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und10$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und11$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und12$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und13$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und14$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und15$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und16$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und17$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und18$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und19$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und20$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und21$1 = new $c_Lshapeless_Succ().init___();
  $thiz.$$und22$1 = new $c_Lshapeless_Succ().init___()
}
/** @constructor */
function $c_O() {
  /*<skip>*/
}
/** @constructor */
function $h_O() {
  /*<skip>*/
}
$h_O.prototype = $c_O.prototype;
$c_O.prototype.init___ = (function() {
  return this
});
$c_O.prototype.equals__O__Z = (function(that) {
  return (this === that)
});
$c_O.prototype.toString__T = (function() {
  var jsx$2 = $objectGetClass(this).getName__T();
  var i = this.hashCode__I();
  var x = $uD((i >>> 0));
  var jsx$1 = x.toString(16);
  return ((jsx$2 + "@") + $as_T(jsx$1))
});
$c_O.prototype.hashCode__I = (function() {
  return $systemIdentityHashCode(this)
});
$c_O.prototype.toString = (function() {
  return this.toString__T()
});
function $is_O(obj) {
  return (obj !== null)
}
function $as_O(obj) {
  return obj
}
function $isArrayOf_O(obj, depth) {
  var data = (obj && obj.$classData);
  if ((!data)) {
    return false
  } else {
    var arrayDepth = (data.arrayDepth || 0);
    return ((!(arrayDepth < depth)) && ((arrayDepth > depth) || (!data.arrayBase.isPrimitive)))
  }
}
function $asArrayOf_O(obj, depth) {
  return (($isArrayOf_O(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Object;", depth))
}
var $d_O = new $TypeData().initClass({
  O: 0
}, false, "java.lang.Object", {
  O: 1
}, (void 0), (void 0), $is_O, $isArrayOf_O);
$c_O.prototype.$classData = $d_O;
function $is_jl_Comparable(obj) {
  return (!(!(((((obj && obj.$classData) && obj.$classData.ancestors.jl_Comparable) || ((typeof obj) === "string")) || ((typeof obj) === "number")) || ((typeof obj) === "boolean"))))
}
function $as_jl_Comparable(obj) {
  return (($is_jl_Comparable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Comparable"))
}
function $isArrayOf_jl_Comparable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Comparable)))
}
function $asArrayOf_jl_Comparable(obj, depth) {
  return (($isArrayOf_jl_Comparable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Comparable;", depth))
}
function $is_jl_Runnable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.jl_Runnable)))
}
function $as_jl_Runnable(obj) {
  return (($is_jl_Runnable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Runnable"))
}
function $isArrayOf_jl_Runnable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Runnable)))
}
function $asArrayOf_jl_Runnable(obj, depth) {
  return (($isArrayOf_jl_Runnable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Runnable;", depth))
}
function $is_ju_Formattable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_Formattable)))
}
function $as_ju_Formattable(obj) {
  return (($is_ju_Formattable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.Formattable"))
}
function $isArrayOf_ju_Formattable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_Formattable)))
}
function $asArrayOf_ju_Formattable(obj, depth) {
  return (($isArrayOf_ju_Formattable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.Formattable;", depth))
}
function $f_ju_HashMap$AbstractMapView__size__I($thiz) {
  return $thiz.$$outer$3.java$util$HashMap$$inner$f.size__I()
}
function $is_ju_Map(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_Map)))
}
function $as_ju_Map(obj) {
  return (($is_ju_Map(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.Map"))
}
function $isArrayOf_ju_Map(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_Map)))
}
function $asArrayOf_ju_Map(obj, depth) {
  return (($isArrayOf_ju_Map(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.Map;", depth))
}
function $is_ju_Map$Entry(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_Map$Entry)))
}
function $as_ju_Map$Entry(obj) {
  return (($is_ju_Map$Entry(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.Map$Entry"))
}
function $isArrayOf_ju_Map$Entry(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_Map$Entry)))
}
function $asArrayOf_ju_Map$Entry(obj, depth) {
  return (($isArrayOf_ju_Map$Entry(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.Map$Entry;", depth))
}
function $is_ju_regex_GroupStartMap$NodeType(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_regex_GroupStartMap$NodeType)))
}
function $as_ju_regex_GroupStartMap$NodeType(obj) {
  return (($is_ju_regex_GroupStartMap$NodeType(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.regex.GroupStartMap$NodeType"))
}
function $isArrayOf_ju_regex_GroupStartMap$NodeType(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_regex_GroupStartMap$NodeType)))
}
function $asArrayOf_ju_regex_GroupStartMap$NodeType(obj, depth) {
  return (($isArrayOf_ju_regex_GroupStartMap$NodeType(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.regex.GroupStartMap$NodeType;", depth))
}
function $is_ju_regex_GroupStartMap$OriginalRegex(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_regex_GroupStartMap$OriginalRegex)))
}
function $as_ju_regex_GroupStartMap$OriginalRegex(obj) {
  return (($is_ju_regex_GroupStartMap$OriginalRegex(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.regex.GroupStartMap$OriginalRegex"))
}
function $isArrayOf_ju_regex_GroupStartMap$OriginalRegex(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_regex_GroupStartMap$OriginalRegex)))
}
function $asArrayOf_ju_regex_GroupStartMap$OriginalRegex(obj, depth) {
  return (($isArrayOf_ju_regex_GroupStartMap$OriginalRegex(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.regex.GroupStartMap$OriginalRegex;", depth))
}
function $f_s_Proxy__equals__O__Z($thiz, that) {
  return ((that !== null) && (((that === $thiz) || (that === $thiz.self__O())) || $objectEquals(that, $thiz.self__O())))
}
function $f_s_Proxy__toString__T($thiz) {
  return ("" + $thiz.self__O())
}
function $is_s_concurrent_BlockContext(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_concurrent_BlockContext)))
}
function $as_s_concurrent_BlockContext(obj) {
  return (($is_s_concurrent_BlockContext(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.concurrent.BlockContext"))
}
function $isArrayOf_s_concurrent_BlockContext(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_concurrent_BlockContext)))
}
function $asArrayOf_s_concurrent_BlockContext(obj, depth) {
  return (($isArrayOf_s_concurrent_BlockContext(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.concurrent.BlockContext;", depth))
}
function $is_s_concurrent_OnCompleteRunnable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_concurrent_OnCompleteRunnable)))
}
function $as_s_concurrent_OnCompleteRunnable(obj) {
  return (($is_s_concurrent_OnCompleteRunnable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.concurrent.OnCompleteRunnable"))
}
function $isArrayOf_s_concurrent_OnCompleteRunnable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_concurrent_OnCompleteRunnable)))
}
function $asArrayOf_s_concurrent_OnCompleteRunnable(obj, depth) {
  return (($isArrayOf_s_concurrent_OnCompleteRunnable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.concurrent.OnCompleteRunnable;", depth))
}
function $f_s_concurrent_Promise__failure__jl_Throwable__s_concurrent_Promise($thiz, cause) {
  var result = new $c_s_util_Failure().init___jl_Throwable(cause);
  return $f_s_concurrent_Promise__complete__s_util_Try__s_concurrent_Promise($thiz, result)
}
function $f_s_concurrent_Promise__tryCompleteWith__s_concurrent_Future__s_concurrent_Promise($thiz, other) {
  if ((other !== $thiz)) {
    other.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
      return (function(x$1$2) {
        var x$1 = $as_s_util_Try(x$1$2);
        return $this.tryComplete__s_util_Try__Z(x$1)
      })
    })($thiz)), $m_s_concurrent_Future$InternalCallbackExecutor$())
  };
  return $thiz
}
function $f_s_concurrent_Promise__complete__s_util_Try__s_concurrent_Promise($thiz, result) {
  if ($thiz.tryComplete__s_util_Try__Z(result)) {
    return $thiz
  } else {
    throw new $c_jl_IllegalStateException().init___T("Promise already completed.")
  }
}
function $f_s_concurrent_Promise__success__O__s_concurrent_Promise($thiz, value) {
  var result = new $c_s_util_Success().init___O(value);
  return $f_s_concurrent_Promise__complete__s_util_Try__s_concurrent_Promise($thiz, result)
}
function $f_s_math_ScalaNumericAnyConversions__unifiedPrimitiveEquals__O__Z($thiz, x) {
  if ($is_jl_Character(x)) {
    if ((x === null)) {
      var x2 = 0
    } else {
      var this$2 = $as_jl_Character(x);
      var x2 = this$2.value$1
    };
    return ($thiz.isValidChar__Z() && ($thiz.intValue__I() === x2))
  } else if ($isByte(x)) {
    var x3 = $uB(x);
    return ($thiz.isValidByte__Z() && ($thiz.byteValue__B() === x3))
  } else if ($isShort(x)) {
    var x4 = $uS(x);
    return ($thiz.isValidShort__Z() && ($thiz.shortValue__S() === x4))
  } else if ($isInt(x)) {
    var x5 = $uI(x);
    return ($thiz.isValidInt__Z() && ($thiz.intValue__I() === x5))
  } else if ($is_sjsr_RuntimeLong(x)) {
    var t = $uJ(x);
    var lo = t.lo$2;
    var hi = t.hi$2;
    var t$1 = $thiz.longValue__J();
    var lo$1 = t$1.lo$2;
    var hi$1 = t$1.hi$2;
    return ((lo$1 === lo) && (hi$1 === hi))
  } else if ($isFloat(x)) {
    var x7 = $uF(x);
    return ($thiz.floatValue__F() === x7)
  } else if (((typeof x) === "number")) {
    var x8 = $uD(x);
    return ($thiz.doubleValue__D() === x8)
  } else {
    return false
  }
}
function $f_s_math_ScalaNumericAnyConversions__unifiedPrimitiveHashcode__I($thiz) {
  var t = $thiz.longValue__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  return ((((hi === (-1)) ? (((-2147483648) ^ lo) >= 0) : (hi > (-1))) && ((hi === 0) ? (((-2147483648) ^ lo) <= (-1)) : (hi < 0))) ? lo : $m_sr_Statics$().longHash__J__I(new $c_sjsr_RuntimeLong().init___I__I(lo, hi)))
}
function $f_s_util_control_NoStackTrace__fillInStackTrace__jl_Throwable($thiz) {
  var this$1 = $m_s_util_control_NoStackTrace$();
  if (this$1.$$undnoSuppression$1) {
    return $c_jl_Throwable.prototype.fillInStackTrace__jl_Throwable.call($thiz)
  } else {
    return $as_jl_Throwable($thiz)
  }
}
function $f_s_util_matching_Regex$MatchData__matched__T($thiz) {
  return (($thiz.start__I() >= 0) ? $objectToString($charSequenceSubSequence($thiz.source__jl_CharSequence(), $thiz.start__I(), $thiz.end__I())) : null)
}
function $f_s_util_matching_Regex$MatchData__group__I__T($thiz, i) {
  return (($thiz.start__I__I(i) >= 0) ? $objectToString($charSequenceSubSequence($thiz.source__jl_CharSequence(), $thiz.start__I__I(i), $thiz.end__I__I(i))) : null)
}
function $f_s_util_matching_Regex$Replacement__replaced__T($thiz) {
  var newsb = new $c_jl_StringBuffer().init___jl_CharSequence($thiz.scala$util$matching$Regex$Replacement$$sb$2);
  $thiz.matcher__ju_regex_Matcher().appendTail__jl_StringBuffer__jl_StringBuffer(newsb);
  return newsb.toString__T()
}
function $is_sc_GenTraversableOnce(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.sc_GenTraversableOnce)))
}
function $as_sc_GenTraversableOnce(obj) {
  return (($is_sc_GenTraversableOnce(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.collection.GenTraversableOnce"))
}
function $isArrayOf_sc_GenTraversableOnce(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.sc_GenTraversableOnce)))
}
function $asArrayOf_sc_GenTraversableOnce(obj, depth) {
  return (($isArrayOf_sc_GenTraversableOnce(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.collection.GenTraversableOnce;", depth))
}
function $f_sc_convert_AsJavaConverters__mutableMapAsJavaMap__scm_Map__ju_Map($thiz, m) {
  if ((m === null)) {
    return null
  } else if (($is_sc_convert_Wrappers$JMapWrapper(m) && ($as_sc_convert_Wrappers$JMapWrapper(m).$$outer$5 === $m_sc_convert_Wrappers$()))) {
    var x2 = $as_sc_convert_Wrappers$JMapWrapper(m);
    var wrapped = x2.underlying$5;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$MutableMapWrapper().init___sc_convert_Wrappers__scm_Map($m_sc_convert_Wrappers$(), m)
  }
}
function $f_sc_convert_AsJavaConverters__mutableSetAsJavaSet__scm_Set__ju_Set($thiz, s) {
  if ((s === null)) {
    return null
  } else if (($is_sc_convert_Wrappers$JSetWrapper(s) && ($as_sc_convert_Wrappers$JSetWrapper(s).$$outer$5 === $m_sc_convert_Wrappers$()))) {
    var x2 = $as_sc_convert_Wrappers$JSetWrapper(s);
    var wrapped = x2.underlying$5;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$MutableSetWrapper().init___sc_convert_Wrappers__scm_Set($m_sc_convert_Wrappers$(), s)
  }
}
function $f_sc_convert_AsJavaConverters__setAsJavaSet__sc_Set__ju_Set($thiz, s) {
  if ((s === null)) {
    return null
  } else if (($is_sc_convert_Wrappers$JSetWrapper(s) && ($as_sc_convert_Wrappers$JSetWrapper(s).$$outer$5 === $m_sc_convert_Wrappers$()))) {
    var x2 = $as_sc_convert_Wrappers$JSetWrapper(s);
    var wrapped = x2.underlying$5;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$SetWrapper().init___sc_convert_Wrappers__sc_Set($m_sc_convert_Wrappers$(), s)
  }
}
function $f_sc_convert_AsScalaConverters__mapAsScalaMap__ju_Map__scm_Map($thiz, m) {
  if ((m === null)) {
    return null
  } else if (($is_sc_convert_Wrappers$MutableMapWrapper(m) && ($as_sc_convert_Wrappers$MutableMapWrapper(m).$$outer$2 === $m_sc_convert_Wrappers$()))) {
    var x2 = $as_sc_convert_Wrappers$MutableMapWrapper(m);
    var wrapped = x2.underlying$3;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$JMapWrapper().init___sc_convert_Wrappers__ju_Map($m_sc_convert_Wrappers$(), m)
  }
}
function $f_sc_convert_AsScalaConverters__propertiesAsScalaMap__ju_Properties__scm_Map($thiz, p) {
  return ((p === null) ? null : new $c_sc_convert_Wrappers$JPropertiesWrapper().init___sc_convert_Wrappers__ju_Properties($m_sc_convert_Wrappers$(), p))
}
function $f_sc_convert_AsScalaConverters__asScalaSet__ju_Set__scm_Set($thiz, s) {
  if ((s === null)) {
    return null
  } else if (($is_sc_convert_Wrappers$MutableSetWrapper(s) && ($as_sc_convert_Wrappers$MutableSetWrapper(s).$$outer$3 === $m_sc_convert_Wrappers$()))) {
    var x2 = $as_sc_convert_Wrappers$MutableSetWrapper(s);
    var wrapped = x2.underlying$4;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$JSetWrapper().init___sc_convert_Wrappers__ju_Set($m_sc_convert_Wrappers$(), s)
  }
}
function $f_sc_convert_AsScalaConverters__asScalaBuffer__ju_List__scm_Buffer($thiz, l) {
  if ((l === null)) {
    return null
  } else if (($is_sc_convert_Wrappers$MutableBufferWrapper(l) && ($as_sc_convert_Wrappers$MutableBufferWrapper(l).scala$collection$convert$Wrappers$MutableBufferWrapper$$$outer__sc_convert_Wrappers() === $m_sc_convert_Wrappers$()))) {
    var x2 = $as_sc_convert_Wrappers$MutableBufferWrapper(l);
    var wrapped = x2.underlying__scm_Buffer();
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$JListWrapper().init___sc_convert_Wrappers__ju_List($m_sc_convert_Wrappers$(), l)
  }
}
function $f_sc_convert_AsScalaConverters__asScalaIterator__ju_Iterator__sc_Iterator($thiz, i) {
  if ((i === null)) {
    return null
  } else if (($is_sc_convert_Wrappers$IteratorWrapper(i) && ($as_sc_convert_Wrappers$IteratorWrapper(i).scala$collection$convert$Wrappers$IteratorWrapper$$$outer__sc_convert_Wrappers() === $m_sc_convert_Wrappers$()))) {
    var x2 = $as_sc_convert_Wrappers$IteratorWrapper(i);
    var wrapped = x2.underlying__sc_Iterator();
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$JIteratorWrapper().init___sc_convert_Wrappers__ju_Iterator($m_sc_convert_Wrappers$(), i)
  }
}
function $f_sc_convert_LowPriorityWrapAsScala__asScalaIterator__ju_Iterator__sc_Iterator($thiz, it) {
  if ((it === null)) {
    return null
  } else if (($is_sc_convert_Wrappers$IteratorWrapper(it) && ($as_sc_convert_Wrappers$IteratorWrapper(it).scala$collection$convert$Wrappers$IteratorWrapper$$$outer__sc_convert_Wrappers() === $m_sc_convert_Wrappers$()))) {
    var x2 = $as_sc_convert_Wrappers$IteratorWrapper(it);
    var wrapped = x2.underlying__sc_Iterator();
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$JIteratorWrapper().init___sc_convert_Wrappers__ju_Iterator($m_sc_convert_Wrappers$(), it)
  }
}
function $f_sci_VectorPointer__copyOf__AO__AO($thiz, a) {
  var copy = $newArrayObject($d_O.getArrayOf(), [a.u.length]);
  $systemArraycopy(a, 0, copy, 0, a.u.length);
  return copy
}
function $f_sci_VectorPointer__gotoNextBlockStart__I__I__V($thiz, index, xor) {
  if ((xor < 1024)) {
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
  } else if ((xor < 32768)) {
    $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get(0), 1))
  } else if ((xor < 1048576)) {
    $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1));
    $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get(0), 1));
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get(0), 1))
  } else if ((xor < 33554432)) {
    $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((index >>> 20) | 0))), 1));
    $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get(0), 1));
    $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get(0), 1));
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get(0), 1))
  } else if ((xor < 1073741824)) {
    $thiz.display4$und$eq__AO__V($asArrayOf_O($thiz.display5__AO().get((31 & ((index >>> 25) | 0))), 1));
    $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get(0), 1));
    $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get(0), 1));
    $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get(0), 1));
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get(0), 1))
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $f_sci_VectorPointer__gotoFreshPosWritable1__I__I__I__V($thiz, oldIndex, newIndex, xor) {
  $f_sci_VectorPointer__stabilize__I__V($thiz, oldIndex);
  $f_sci_VectorPointer__gotoFreshPosWritable0__I__I__I__V($thiz, oldIndex, newIndex, xor)
}
function $f_sci_VectorPointer__getElem__I__I__O($thiz, index, xor) {
  if ((xor < 32)) {
    return $thiz.display0__AO().get((31 & index))
  } else if ((xor < 1024)) {
    return $asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else if ((xor < 32768)) {
    return $asArrayOf_O($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1).get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else if ((xor < 1048576)) {
    return $asArrayOf_O($asArrayOf_O($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1).get((31 & ((index >>> 10) | 0))), 1).get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else if ((xor < 33554432)) {
    return $asArrayOf_O($asArrayOf_O($asArrayOf_O($asArrayOf_O($thiz.display4__AO().get((31 & ((index >>> 20) | 0))), 1).get((31 & ((index >>> 15) | 0))), 1).get((31 & ((index >>> 10) | 0))), 1).get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else if ((xor < 1073741824)) {
    return $asArrayOf_O($asArrayOf_O($asArrayOf_O($asArrayOf_O($asArrayOf_O($thiz.display5__AO().get((31 & ((index >>> 25) | 0))), 1).get((31 & ((index >>> 20) | 0))), 1).get((31 & ((index >>> 15) | 0))), 1).get((31 & ((index >>> 10) | 0))), 1).get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $f_sci_VectorPointer__gotoFreshPosWritable0__I__I__I__V($thiz, oldIndex, newIndex, xor) {
  if ((xor >= 32)) {
    if ((xor < 1024)) {
      if (($thiz.depth__I() === 1)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 32768)) {
      if (($thiz.depth__I() === 2)) {
        $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((newIndex >>> 10) | 0))), 1));
      if (($thiz.display1__AO() === null)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 1048576)) {
      if (($thiz.depth__I() === 3)) {
        $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display3__AO().set((31 & ((oldIndex >>> 15) | 0)), $thiz.display2__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((newIndex >>> 15) | 0))), 1));
      if (($thiz.display2__AO() === null)) {
        $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((newIndex >>> 10) | 0))), 1));
      if (($thiz.display1__AO() === null)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 33554432)) {
      if (($thiz.depth__I() === 4)) {
        $thiz.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display4__AO().set((31 & ((oldIndex >>> 20) | 0)), $thiz.display3__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((newIndex >>> 20) | 0))), 1));
      if (($thiz.display3__AO() === null)) {
        $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((newIndex >>> 15) | 0))), 1));
      if (($thiz.display2__AO() === null)) {
        $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((newIndex >>> 10) | 0))), 1));
      if (($thiz.display1__AO() === null)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 1073741824)) {
      if (($thiz.depth__I() === 5)) {
        $thiz.display5$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display5__AO().set((31 & ((oldIndex >>> 25) | 0)), $thiz.display4__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display4$und$eq__AO__V($asArrayOf_O($thiz.display5__AO().get((31 & ((newIndex >>> 25) | 0))), 1));
      if (($thiz.display4__AO() === null)) {
        $thiz.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((newIndex >>> 20) | 0))), 1));
      if (($thiz.display3__AO() === null)) {
        $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((newIndex >>> 15) | 0))), 1));
      if (($thiz.display2__AO() === null)) {
        $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((newIndex >>> 10) | 0))), 1));
      if (($thiz.display1__AO() === null)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else {
      throw new $c_jl_IllegalArgumentException().init___()
    }
  }
}
function $f_sci_VectorPointer__gotoPosWritable1__I__I__I__V($thiz, oldIndex, newIndex, xor) {
  if ((xor < 32)) {
    var a = $thiz.display0__AO();
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a))
  } else if ((xor < 1024)) {
    var a$1 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$1));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    var array = $thiz.display1__AO();
    var index = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array, index))
  } else if ((xor < 32768)) {
    var a$2 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$2));
    var a$3 = $thiz.display2__AO();
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$3));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
    var array$1 = $thiz.display2__AO();
    var index$1 = (31 & ((newIndex >>> 10) | 0));
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$1, index$1));
    var array$2 = $thiz.display1__AO();
    var index$2 = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$2, index$2))
  } else if ((xor < 1048576)) {
    var a$4 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$4));
    var a$5 = $thiz.display2__AO();
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$5));
    var a$6 = $thiz.display3__AO();
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$6));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((oldIndex >>> 15) | 0)), $thiz.display2__AO());
    var array$3 = $thiz.display3__AO();
    var index$3 = (31 & ((newIndex >>> 15) | 0));
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$3, index$3));
    var array$4 = $thiz.display2__AO();
    var index$4 = (31 & ((newIndex >>> 10) | 0));
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$4, index$4));
    var array$5 = $thiz.display1__AO();
    var index$5 = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$5, index$5))
  } else if ((xor < 33554432)) {
    var a$7 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$7));
    var a$8 = $thiz.display2__AO();
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$8));
    var a$9 = $thiz.display3__AO();
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$9));
    var a$10 = $thiz.display4__AO();
    $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$10));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((oldIndex >>> 15) | 0)), $thiz.display2__AO());
    $thiz.display4__AO().set((31 & ((oldIndex >>> 20) | 0)), $thiz.display3__AO());
    var array$6 = $thiz.display4__AO();
    var index$6 = (31 & ((newIndex >>> 20) | 0));
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$6, index$6));
    var array$7 = $thiz.display3__AO();
    var index$7 = (31 & ((newIndex >>> 15) | 0));
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$7, index$7));
    var array$8 = $thiz.display2__AO();
    var index$8 = (31 & ((newIndex >>> 10) | 0));
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$8, index$8));
    var array$9 = $thiz.display1__AO();
    var index$9 = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$9, index$9))
  } else if ((xor < 1073741824)) {
    var a$11 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$11));
    var a$12 = $thiz.display2__AO();
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$12));
    var a$13 = $thiz.display3__AO();
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$13));
    var a$14 = $thiz.display4__AO();
    $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$14));
    var a$15 = $thiz.display5__AO();
    $thiz.display5$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$15));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((oldIndex >>> 15) | 0)), $thiz.display2__AO());
    $thiz.display4__AO().set((31 & ((oldIndex >>> 20) | 0)), $thiz.display3__AO());
    $thiz.display5__AO().set((31 & ((oldIndex >>> 25) | 0)), $thiz.display4__AO());
    var array$10 = $thiz.display5__AO();
    var index$10 = (31 & ((newIndex >>> 25) | 0));
    $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$10, index$10));
    var array$11 = $thiz.display4__AO();
    var index$11 = (31 & ((newIndex >>> 20) | 0));
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$11, index$11));
    var array$12 = $thiz.display3__AO();
    var index$12 = (31 & ((newIndex >>> 15) | 0));
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$12, index$12));
    var array$13 = $thiz.display2__AO();
    var index$13 = (31 & ((newIndex >>> 10) | 0));
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$13, index$13));
    var array$14 = $thiz.display1__AO();
    var index$14 = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$14, index$14))
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $f_sci_VectorPointer__copyRange__AO__I__I__AO($thiz, array, oldLeft, newLeft) {
  var elems = $newArrayObject($d_O.getArrayOf(), [32]);
  $systemArraycopy(array, oldLeft, elems, newLeft, ((32 - ((newLeft > oldLeft) ? newLeft : oldLeft)) | 0));
  return elems
}
function $f_sci_VectorPointer__gotoPos__I__I__V($thiz, index, xor) {
  if ((xor >= 32)) {
    if ((xor < 1024)) {
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else if ((xor < 32768)) {
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else if ((xor < 1048576)) {
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1));
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else if ((xor < 33554432)) {
      $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((index >>> 20) | 0))), 1));
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1));
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else if ((xor < 1073741824)) {
      $thiz.display4$und$eq__AO__V($asArrayOf_O($thiz.display5__AO().get((31 & ((index >>> 25) | 0))), 1));
      $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((index >>> 20) | 0))), 1));
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1));
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else {
      throw new $c_jl_IllegalArgumentException().init___()
    }
  }
}
function $f_sci_VectorPointer__gotoPosWritable0__I__I__V($thiz, newIndex, xor) {
  var x1 = (((-1) + $thiz.depth__I()) | 0);
  switch (x1) {
    case 5: {
      var a = $thiz.display5__AO();
      $thiz.display5$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a));
      var array = $thiz.display5__AO();
      var index = (31 & ((newIndex >>> 25) | 0));
      $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array, index));
      var array$1 = $thiz.display4__AO();
      var index$1 = (31 & ((newIndex >>> 20) | 0));
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$1, index$1));
      var array$2 = $thiz.display3__AO();
      var index$2 = (31 & ((newIndex >>> 15) | 0));
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$2, index$2));
      var array$3 = $thiz.display2__AO();
      var index$3 = (31 & ((newIndex >>> 10) | 0));
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$3, index$3));
      var array$4 = $thiz.display1__AO();
      var index$4 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$4, index$4));
      break
    }
    case 4: {
      var a$1 = $thiz.display4__AO();
      $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$1));
      var array$5 = $thiz.display4__AO();
      var index$5 = (31 & ((newIndex >>> 20) | 0));
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$5, index$5));
      var array$6 = $thiz.display3__AO();
      var index$6 = (31 & ((newIndex >>> 15) | 0));
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$6, index$6));
      var array$7 = $thiz.display2__AO();
      var index$7 = (31 & ((newIndex >>> 10) | 0));
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$7, index$7));
      var array$8 = $thiz.display1__AO();
      var index$8 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$8, index$8));
      break
    }
    case 3: {
      var a$2 = $thiz.display3__AO();
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$2));
      var array$9 = $thiz.display3__AO();
      var index$9 = (31 & ((newIndex >>> 15) | 0));
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$9, index$9));
      var array$10 = $thiz.display2__AO();
      var index$10 = (31 & ((newIndex >>> 10) | 0));
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$10, index$10));
      var array$11 = $thiz.display1__AO();
      var index$11 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$11, index$11));
      break
    }
    case 2: {
      var a$3 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$3));
      var array$12 = $thiz.display2__AO();
      var index$12 = (31 & ((newIndex >>> 10) | 0));
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$12, index$12));
      var array$13 = $thiz.display1__AO();
      var index$13 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$13, index$13));
      break
    }
    case 1: {
      var a$4 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$4));
      var array$14 = $thiz.display1__AO();
      var index$14 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$14, index$14));
      break
    }
    case 0: {
      var a$5 = $thiz.display0__AO();
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$5));
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $f_sci_VectorPointer__stabilize__I__V($thiz, index) {
  var x1 = (((-1) + $thiz.depth__I()) | 0);
  switch (x1) {
    case 5: {
      var a = $thiz.display5__AO();
      $thiz.display5$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a));
      var a$1 = $thiz.display4__AO();
      $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$1));
      var a$2 = $thiz.display3__AO();
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$2));
      var a$3 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$3));
      var a$4 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$4));
      $thiz.display5__AO().set((31 & ((index >>> 25) | 0)), $thiz.display4__AO());
      $thiz.display4__AO().set((31 & ((index >>> 20) | 0)), $thiz.display3__AO());
      $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
      $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 4: {
      var a$5 = $thiz.display4__AO();
      $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$5));
      var a$6 = $thiz.display3__AO();
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$6));
      var a$7 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$7));
      var a$8 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$8));
      $thiz.display4__AO().set((31 & ((index >>> 20) | 0)), $thiz.display3__AO());
      $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
      $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 3: {
      var a$9 = $thiz.display3__AO();
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$9));
      var a$10 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$10));
      var a$11 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$11));
      $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
      $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 2: {
      var a$12 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$12));
      var a$13 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$13));
      $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 1: {
      var a$14 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$14));
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 0: {
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array, index) {
  var x = array.get(index);
  array.set(index, null);
  var a = $asArrayOf_O(x, 1);
  return $f_sci_VectorPointer__copyOf__AO__AO($thiz, a)
}
function $f_sci_VectorPointer__initFrom__sci_VectorPointer__I__V($thiz, that, depth) {
  $thiz.depth$und$eq__I__V(depth);
  var x1 = (((-1) + depth) | 0);
  switch (x1) {
    case (-1): {
      break
    }
    case 0: {
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 1: {
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 2: {
      $thiz.display2$und$eq__AO__V(that.display2__AO());
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 3: {
      $thiz.display3$und$eq__AO__V(that.display3__AO());
      $thiz.display2$und$eq__AO__V(that.display2__AO());
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 4: {
      $thiz.display4$und$eq__AO__V(that.display4__AO());
      $thiz.display3$und$eq__AO__V(that.display3__AO());
      $thiz.display2$und$eq__AO__V(that.display2__AO());
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 5: {
      $thiz.display5$und$eq__AO__V(that.display5__AO());
      $thiz.display4$und$eq__AO__V(that.display4__AO());
      $thiz.display3$und$eq__AO__V(that.display3__AO());
      $thiz.display2$und$eq__AO__V(that.display2__AO());
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $f_sci_VectorPointer__gotoNextBlockStartWritable__I__I__V($thiz, index, xor) {
  if ((xor < 1024)) {
    if (($thiz.depth__I() === 1)) {
      $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display1__AO().set(0, $thiz.display0__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO())
  } else if ((xor < 32768)) {
    if (($thiz.depth__I() === 2)) {
      $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display2__AO().set(0, $thiz.display1__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO())
  } else if ((xor < 1048576)) {
    if (($thiz.depth__I() === 3)) {
      $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display3__AO().set(0, $thiz.display2__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO())
  } else if ((xor < 33554432)) {
    if (($thiz.depth__I() === 4)) {
      $thiz.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display4__AO().set(0, $thiz.display3__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
    $thiz.display4__AO().set((31 & ((index >>> 20) | 0)), $thiz.display3__AO())
  } else if ((xor < 1073741824)) {
    if (($thiz.depth__I() === 5)) {
      $thiz.display5$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display5__AO().set(0, $thiz.display4__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
    $thiz.display4__AO().set((31 & ((index >>> 20) | 0)), $thiz.display3__AO());
    $thiz.display5__AO().set((31 & ((index >>> 25) | 0)), $thiz.display4__AO())
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $f_scm_FlatHashTable$HashUtils__elemToEntry__O__O($thiz, elem) {
  return ((elem === null) ? $m_scm_FlatHashTable$NullSentinel$() : elem)
}
function $f_scm_FlatHashTable$HashUtils__entryToElem__O__O($thiz, entry) {
  return ((entry === $m_scm_FlatHashTable$NullSentinel$()) ? null : entry)
}
function $f_scm_FlatHashTable$HashUtils__improve__I__I__I($thiz, hcode, seed) {
  var i = $m_s_util_hashing_package$().byteswap32__I__I(hcode);
  return (((i >>> seed) | 0) | (i << ((-seed) | 0)))
}
function $is_scm_HashEntry(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.scm_HashEntry)))
}
function $as_scm_HashEntry(obj) {
  return (($is_scm_HashEntry(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.collection.mutable.HashEntry"))
}
function $isArrayOf_scm_HashEntry(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.scm_HashEntry)))
}
function $asArrayOf_scm_HashEntry(obj, depth) {
  return (($isArrayOf_scm_HashEntry(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.collection.mutable.HashEntry;", depth))
}
var $d_scm_HashEntry = new $TypeData().initClass({
  scm_HashEntry: 0
}, true, "scala.collection.mutable.HashEntry", {
  scm_HashEntry: 1
});
function $f_scm_HashTable$HashUtils__improve__I__I__I($thiz, hcode, seed) {
  var i = $m_s_util_hashing_package$().byteswap32__I__I(hcode);
  return (((i >>> seed) | 0) | (i << ((-seed) | 0)))
}
/** @constructor */
function $c_Lcats_data_ValidatedInstances2() {
  $c_O.call(this)
}
$c_Lcats_data_ValidatedInstances2.prototype = new $h_O();
$c_Lcats_data_ValidatedInstances2.prototype.constructor = $c_Lcats_data_ValidatedInstances2;
/** @constructor */
function $h_Lcats_data_ValidatedInstances2() {
  /*<skip>*/
}
$h_Lcats_data_ValidatedInstances2.prototype = $c_Lcats_data_ValidatedInstances2.prototype;
/** @constructor */
function $c_Lcats_kernel_EqFunctions() {
  $c_O.call(this)
}
$c_Lcats_kernel_EqFunctions.prototype = new $h_O();
$c_Lcats_kernel_EqFunctions.prototype.constructor = $c_Lcats_kernel_EqFunctions;
/** @constructor */
function $h_Lcats_kernel_EqFunctions() {
  /*<skip>*/
}
$h_Lcats_kernel_EqFunctions.prototype = $c_Lcats_kernel_EqFunctions.prototype;
/** @constructor */
function $c_Lcats_kernel_SemigroupFunctions() {
  $c_O.call(this)
}
$c_Lcats_kernel_SemigroupFunctions.prototype = new $h_O();
$c_Lcats_kernel_SemigroupFunctions.prototype.constructor = $c_Lcats_kernel_SemigroupFunctions;
/** @constructor */
function $h_Lcats_kernel_SemigroupFunctions() {
  /*<skip>*/
}
$h_Lcats_kernel_SemigroupFunctions.prototype = $c_Lcats_kernel_SemigroupFunctions.prototype;
/** @constructor */
function $c_Lcats_package$() {
  $c_O.call(this);
  this.catsInstancesForId$1 = null;
  this.catsRepresentableForId$1 = null;
  this.catsParallelForId$1 = null;
  this.Eq$1 = null;
  this.PartialOrder$1 = null;
  this.Order$1 = null;
  this.Comparison$1 = null;
  this.Hash$1 = null;
  this.Semigroup$1 = null;
  this.Monoid$1 = null;
  this.Group$1 = null
}
$c_Lcats_package$.prototype = new $h_O();
$c_Lcats_package$.prototype.constructor = $c_Lcats_package$;
/** @constructor */
function $h_Lcats_package$() {
  /*<skip>*/
}
$h_Lcats_package$.prototype = $c_Lcats_package$.prototype;
$c_Lcats_package$.prototype.init___ = (function() {
  $n_Lcats_package$ = this;
  this.catsInstancesForId$1 = new $c_Lcats_package$$anon$1().init___();
  this.catsRepresentableForId$1 = new $c_Lcats_package$$anon$2().init___();
  var evidence$17 = this.catsInstancesForId$1;
  this.catsParallelForId$1 = new $c_Lcats_Parallel$$anon$2().init___Lcats_Monad(evidence$17);
  this.Eq$1 = $m_Lcats_kernel_Eq$();
  this.PartialOrder$1 = $m_Lcats_kernel_PartialOrder$();
  this.Order$1 = $m_Lcats_kernel_Order$();
  this.Comparison$1 = $m_Lcats_kernel_Comparison$();
  this.Hash$1 = $m_Lcats_kernel_Hash$();
  this.Semigroup$1 = $m_Lcats_kernel_Semigroup$();
  this.Monoid$1 = $m_Lcats_kernel_Monoid$();
  this.Group$1 = $m_Lcats_kernel_Group$();
  return this
});
var $d_Lcats_package$ = new $TypeData().initClass({
  Lcats_package$: 0
}, false, "cats.package$", {
  Lcats_package$: 1,
  O: 1
});
$c_Lcats_package$.prototype.$classData = $d_Lcats_package$;
var $n_Lcats_package$ = (void 0);
function $m_Lcats_package$() {
  if ((!$n_Lcats_package$)) {
    $n_Lcats_package$ = new $c_Lcats_package$().init___()
  };
  return $n_Lcats_package$
}
function $f_Lio_circe_Decoder__tryDecode__Lio_circe_ACursor__s_util_Either($thiz, c) {
  if ($is_Lio_circe_HCursor(c)) {
    var x2 = $as_Lio_circe_HCursor(c);
    return $thiz.apply__Lio_circe_HCursor__s_util_Either(x2)
  } else {
    $m_s_package$();
    $m_Lio_circe_DecodingFailure$();
    var ops = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, c$1) {
      return (function() {
        return c$1.history__sci_List()
      })
    })($thiz, c));
    var value = new $c_Lio_circe_DecodingFailure$$anon$2().init___T__F0("Attempt to decode value on failed cursor", ops);
    return new $c_s_util_Left().init___O(value)
  }
}
function $f_Lio_circe_Decoder__decodeJson__Lio_circe_Json__s_util_Either($thiz, j) {
  return $thiz.apply__Lio_circe_HCursor__s_util_Either(new $c_Lio_circe_cursor_TopCursor().init___Lio_circe_Json__Lio_circe_HCursor__Lio_circe_CursorOp(j, null, null))
}
function $is_Lio_circe_Decoder(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_circe_Decoder)))
}
function $as_Lio_circe_Decoder(obj) {
  return (($is_Lio_circe_Decoder(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.circe.Decoder"))
}
function $isArrayOf_Lio_circe_Decoder(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_circe_Decoder)))
}
function $asArrayOf_Lio_circe_Decoder(obj, depth) {
  return (($isArrayOf_Lio_circe_Decoder(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.circe.Decoder;", depth))
}
/** @constructor */
function $c_Lio_circe_Printer$SizePredictor() {
  $c_O.call(this)
}
$c_Lio_circe_Printer$SizePredictor.prototype = new $h_O();
$c_Lio_circe_Printer$SizePredictor.prototype.constructor = $c_Lio_circe_Printer$SizePredictor;
/** @constructor */
function $h_Lio_circe_Printer$SizePredictor() {
  /*<skip>*/
}
$h_Lio_circe_Printer$SizePredictor.prototype = $c_Lio_circe_Printer$SizePredictor.prototype;
/** @constructor */
function $c_Lio_circe_generic_extras_util_RecordToMap() {
  $c_O.call(this)
}
$c_Lio_circe_generic_extras_util_RecordToMap.prototype = new $h_O();
$c_Lio_circe_generic_extras_util_RecordToMap.prototype.constructor = $c_Lio_circe_generic_extras_util_RecordToMap;
/** @constructor */
function $h_Lio_circe_generic_extras_util_RecordToMap() {
  /*<skip>*/
}
$h_Lio_circe_generic_extras_util_RecordToMap.prototype = $c_Lio_circe_generic_extras_util_RecordToMap.prototype;
/** @constructor */
function $c_Lio_circe_generic_extras_util_RecordToMap$() {
  $c_O.call(this);
  this.hnilRecordToMap$1 = null
}
$c_Lio_circe_generic_extras_util_RecordToMap$.prototype = new $h_O();
$c_Lio_circe_generic_extras_util_RecordToMap$.prototype.constructor = $c_Lio_circe_generic_extras_util_RecordToMap$;
/** @constructor */
function $h_Lio_circe_generic_extras_util_RecordToMap$() {
  /*<skip>*/
}
$h_Lio_circe_generic_extras_util_RecordToMap$.prototype = $c_Lio_circe_generic_extras_util_RecordToMap$.prototype;
$c_Lio_circe_generic_extras_util_RecordToMap$.prototype.init___ = (function() {
  $n_Lio_circe_generic_extras_util_RecordToMap$ = this;
  this.hnilRecordToMap$1 = new $c_Lio_circe_generic_extras_util_RecordToMap$$anon$1().init___();
  return this
});
var $d_Lio_circe_generic_extras_util_RecordToMap$ = new $TypeData().initClass({
  Lio_circe_generic_extras_util_RecordToMap$: 0
}, false, "io.circe.generic.extras.util.RecordToMap$", {
  Lio_circe_generic_extras_util_RecordToMap$: 1,
  O: 1
});
$c_Lio_circe_generic_extras_util_RecordToMap$.prototype.$classData = $d_Lio_circe_generic_extras_util_RecordToMap$;
var $n_Lio_circe_generic_extras_util_RecordToMap$ = (void 0);
function $m_Lio_circe_generic_extras_util_RecordToMap$() {
  if ((!$n_Lio_circe_generic_extras_util_RecordToMap$)) {
    $n_Lio_circe_generic_extras_util_RecordToMap$ = new $c_Lio_circe_generic_extras_util_RecordToMap$().init___()
  };
  return $n_Lio_circe_generic_extras_util_RecordToMap$
}
/** @constructor */
function $c_Lio_circe_jawn_JawnParser() {
  $c_O.call(this)
}
$c_Lio_circe_jawn_JawnParser.prototype = new $h_O();
$c_Lio_circe_jawn_JawnParser.prototype.constructor = $c_Lio_circe_jawn_JawnParser;
/** @constructor */
function $h_Lio_circe_jawn_JawnParser() {
  /*<skip>*/
}
$h_Lio_circe_jawn_JawnParser.prototype = $c_Lio_circe_jawn_JawnParser.prototype;
$c_Lio_circe_jawn_JawnParser.prototype.init___ = (function() {
  return this
});
var $d_Lio_circe_jawn_JawnParser = new $TypeData().initClass({
  Lio_circe_jawn_JawnParser: 0
}, false, "io.circe.jawn.JawnParser", {
  Lio_circe_jawn_JawnParser: 1,
  O: 1
});
$c_Lio_circe_jawn_JawnParser.prototype.$classData = $d_Lio_circe_jawn_JawnParser;
/** @constructor */
function $c_Lio_circe_scalajs_package$() {
  $c_O.call(this);
  this.toJsAnyFolder$1 = null
}
$c_Lio_circe_scalajs_package$.prototype = new $h_O();
$c_Lio_circe_scalajs_package$.prototype.constructor = $c_Lio_circe_scalajs_package$;
/** @constructor */
function $h_Lio_circe_scalajs_package$() {
  /*<skip>*/
}
$h_Lio_circe_scalajs_package$.prototype = $c_Lio_circe_scalajs_package$.prototype;
$c_Lio_circe_scalajs_package$.prototype.init___ = (function() {
  $n_Lio_circe_scalajs_package$ = this;
  this.toJsAnyFolder$1 = new $c_Lio_circe_scalajs_package$$anon$1().init___();
  return this
});
$c_Lio_circe_scalajs_package$.prototype.convertAnyToJsonUnsafe__p1__O__Lio_circe_Json = (function(input) {
  if ($is_T(input)) {
    var x2 = $as_T(input);
    $m_Lio_circe_Json$();
    return new $c_Lio_circe_Json$JString().init___T(x2)
  } else if (((typeof input) === "number")) {
    var x3 = $uD(input);
    return $m_Lio_circe_Json$().fromDoubleOrNull__D__Lio_circe_Json(x3)
  } else if ($m_sr_BoxesRunTime$().equals__O__O__Z(true, input)) {
    return $m_Lio_circe_Json$().True$1
  } else if ($m_sr_BoxesRunTime$().equals__O__O__Z(false, input)) {
    return $m_Lio_circe_Json$().False$1
  } else if ((input === null)) {
    return $m_Lio_circe_Json$().Null$1
  } else if ($uZ((input instanceof $g.Array))) {
    $m_Lio_circe_Json$();
    var array = [];
    var x1 = $uI(input.length);
    switch (x1) {
      case (-1): {
        break
      }
    };
    var i = 0;
    var len = $uI(input.length);
    while ((i < len)) {
      var index = i;
      var arg1 = input[index];
      var elem = $m_Lio_circe_scalajs_package$().convertAnyToJsonUnsafe__p1__O__Lio_circe_Json(arg1);
      array.push(elem);
      i = ((1 + i) | 0)
    };
    var values = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
    $m_sci_Vector$();
    var cbf = $m_sc_IndexedSeq$().ReusableCBF$6;
    return new $c_Lio_circe_Json$JArray().init___sci_Vector($as_sci_Vector($f_sc_TraversableLike__to__scg_CanBuildFrom__O(values, cbf)))
  } else if ($uZ((input instanceof $g.Object))) {
    var jsx$1 = $m_Lio_circe_Json$();
    var this$8 = new $c_sjs_js_WrappedDictionary().init___sjs_js_Dictionary(input);
    var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
      return (function(input$2$2) {
        return $m_Lio_circe_scalajs_package$().convertAnyToJsonUnsafe__p1__O__Lio_circe_Json(input$2$2)
      })
    })(this));
    var this$9 = new $c_sc_MapLike$MappedValues().init___sc_MapLike__F1(this$8, f);
    return jsx$1.fromFields__sc_Iterable__Lio_circe_Json($f_sc_MapLike__toSeq__sc_Seq(this$9))
  } else if ((input === (void 0))) {
    return $m_Lio_circe_Json$().Null$1
  } else {
    throw new $c_s_MatchError().init___O(input)
  }
});
$c_Lio_circe_scalajs_package$.prototype.convertJsToJson__sjs_js_Any__s_util_Either = (function(input) {
  try {
    $m_s_package$();
    var value = this.convertAnyToJsonUnsafe__p1__O__Lio_circe_Json(input);
    return new $c_s_util_Right().init___O(value)
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
      if ((!o11.isEmpty__Z())) {
        var exception = $as_jl_Throwable(o11.get__O());
        $m_s_package$();
        return new $c_s_util_Left().init___O(exception)
      };
      throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
    } else {
      throw e
    }
  }
});
var $d_Lio_circe_scalajs_package$ = new $TypeData().initClass({
  Lio_circe_scalajs_package$: 0
}, false, "io.circe.scalajs.package$", {
  Lio_circe_scalajs_package$: 1,
  O: 1
});
$c_Lio_circe_scalajs_package$.prototype.$classData = $d_Lio_circe_scalajs_package$;
var $n_Lio_circe_scalajs_package$ = (void 0);
function $m_Lio_circe_scalajs_package$() {
  if ((!$n_Lio_circe_scalajs_package$)) {
    $n_Lio_circe_scalajs_package$ = new $c_Lio_circe_scalajs_package$().init___()
  };
  return $n_Lio_circe_scalajs_package$
}
/** @constructor */
function $c_Lio_youi_Cache$() {
  $c_O.call(this);
  this.implementation$1 = null
}
$c_Lio_youi_Cache$.prototype = new $h_O();
$c_Lio_youi_Cache$.prototype.constructor = $c_Lio_youi_Cache$;
/** @constructor */
function $h_Lio_youi_Cache$() {
  /*<skip>*/
}
$h_Lio_youi_Cache$.prototype = $c_Lio_youi_Cache$.prototype;
$c_Lio_youi_Cache$.prototype.init___ = (function() {
  return this
});
var $d_Lio_youi_Cache$ = new $TypeData().initClass({
  Lio_youi_Cache$: 0
}, false, "io.youi.Cache$", {
  Lio_youi_Cache$: 1,
  O: 1
});
$c_Lio_youi_Cache$.prototype.$classData = $d_Lio_youi_Cache$;
var $n_Lio_youi_Cache$ = (void 0);
function $m_Lio_youi_Cache$() {
  if ((!$n_Lio_youi_Cache$)) {
    $n_Lio_youi_Cache$ = new $c_Lio_youi_Cache$().init___()
  };
  return $n_Lio_youi_Cache$
}
/** @constructor */
function $c_Lio_youi_Color() {
  $c_O.call(this);
  this.value$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_Lio_youi_Color.prototype = new $h_O();
$c_Lio_youi_Color.prototype.constructor = $c_Lio_youi_Color;
/** @constructor */
function $h_Lio_youi_Color() {
  /*<skip>*/
}
$h_Lio_youi_Color.prototype = $c_Lio_youi_Color.prototype;
$c_Lio_youi_Color.prototype.init___J = (function(value) {
  this.value$1 = value;
  return this
});
$c_Lio_youi_Color.prototype.equals__O__Z = (function(x$1) {
  return $m_Lio_youi_Color$().equals$extension__J__O__Z(this.value$1, x$1)
});
$c_Lio_youi_Color.prototype.toString__T = (function() {
  return $m_Lio_youi_Color$().toString$extension__J__T(this.value$1)
});
$c_Lio_youi_Color.prototype.hashCode__I = (function() {
  $m_Lio_youi_Color$();
  var t = this.value$1;
  var lo = t.lo$2;
  var hi = t.hi$2;
  return (lo ^ hi)
});
function $is_Lio_youi_Color(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_Color)))
}
function $as_Lio_youi_Color(obj) {
  return (($is_Lio_youi_Color(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.Color"))
}
function $isArrayOf_Lio_youi_Color(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_Color)))
}
function $asArrayOf_Lio_youi_Color(obj, depth) {
  return (($isArrayOf_Lio_youi_Color(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.Color;", depth))
}
var $d_Lio_youi_Color = new $TypeData().initClass({
  Lio_youi_Color: 0
}, false, "io.youi.Color", {
  Lio_youi_Color: 1,
  O: 1
});
$c_Lio_youi_Color.prototype.$classData = $d_Lio_youi_Color;
/** @constructor */
function $c_Lio_youi_Color$() {
  $c_O.call(this);
  this.Clear$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.AliceBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.AntiqueWhite$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Aqua$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Aquamarine$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Azure$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Beige$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Bisque$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Black$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.BlanchedAlmond$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Blue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.BlueViolet$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Brown$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.BurlyWood$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.CadetBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Chartreuse$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Chocolate$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Coral$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.CornflowerBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Cornsilk$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Crimson$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Cyan$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkCyan$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkGoldenRod$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkKhaki$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkMagenta$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkOliveGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkOrange$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkOrchid$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkSalmon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkSeaGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkSlateBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkSlateGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkTurquoise$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkViolet$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DeepPink$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DeepSkyBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DimGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DodgerBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.FireBrick$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.FloralWhite$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.ForestGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Fuchsia$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Gainsboro$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.GhostWhite$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Gold$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.GoldenRod$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Gray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Green$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.GreenYellow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.HoneyDew$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.HotPink$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.IndianRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Indigo$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Ivory$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Khaki$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Lavender$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LavenderBlush$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LawnGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LemonChiffon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightCoral$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightCyan$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightGoldenRodYellow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightPink$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSalmon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSeaGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSkyBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSlateGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSteelBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightYellow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Lime$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LimeGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Linen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Magenta$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Maroon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumAquaMarine$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumOrchid$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumPurple$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumSeaGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumSlateBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumSpringGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumTurquoise$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumVioletRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MidnightBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MintCream$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MistyRose$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Moccasin$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.NavajoWhite$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Navy$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.OldLace$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Olive$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.OliveDrab$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Orange$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.OrangeRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Orchid$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PaleGoldenRod$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PaleGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PaleTurquoise$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PaleVioletRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PapayaWhip$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PeachPuff$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Peru$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Pink$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Plum$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PowderBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Purple$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.RebeccaPurple$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Red$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.RosyBrown$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.RoyalBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SaddleBrown$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Salmon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SandyBrown$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SeaGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SeaShell$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Sienna$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Silver$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SkyBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SlateBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SlateGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Snow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SpringGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SteelBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Tan$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Teal$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Thistle$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Tomato$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Turquoise$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Violet$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Wheat$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.White$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.WhiteSmoke$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Yellow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.YellowGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Hex3Regex$1 = null;
  this.Hex6Regex$1 = null;
  this.RGBARegex$1 = null
}
$c_Lio_youi_Color$.prototype = new $h_O();
$c_Lio_youi_Color$.prototype.constructor = $c_Lio_youi_Color$;
/** @constructor */
function $h_Lio_youi_Color$() {
  /*<skip>*/
}
$h_Lio_youi_Color$.prototype = $c_Lio_youi_Color$.prototype;
$c_Lio_youi_Color$.prototype.init___ = (function() {
  $n_Lio_youi_Color$ = this;
  this.Clear$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.AliceBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-252116993), (-1));
  this.AntiqueWhite$1 = new $c_sjsr_RuntimeLong().init___I__I((-85207041), (-1));
  this.Aqua$1 = new $c_sjsr_RuntimeLong().init___I__I(16777215, 0);
  this.Aquamarine$1 = new $c_sjsr_RuntimeLong().init___I__I(2147472639, 0);
  this.Azure$1 = new $c_sjsr_RuntimeLong().init___I__I((-251658241), (-1));
  this.Beige$1 = new $c_sjsr_RuntimeLong().init___I__I((-168436481), (-1));
  this.Bisque$1 = new $c_sjsr_RuntimeLong().init___I__I((-1784577), (-1));
  this.Black$1 = new $c_sjsr_RuntimeLong().init___I__I(255, 0);
  this.BlanchedAlmond$1 = new $c_sjsr_RuntimeLong().init___I__I((-1323521), (-1));
  this.Blue$1 = new $c_sjsr_RuntimeLong().init___I__I(65535, 0);
  this.BlueViolet$1 = new $c_sjsr_RuntimeLong().init___I__I((-1976835329), (-1));
  this.Brown$1 = new $c_sjsr_RuntimeLong().init___I__I((-1523963137), (-1));
  this.BurlyWood$1 = new $c_sjsr_RuntimeLong().init___I__I((-558331905), (-1));
  this.CadetBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1604231423, 0);
  this.Chartreuse$1 = new $c_sjsr_RuntimeLong().init___I__I(2147418367, 0);
  this.Chocolate$1 = new $c_sjsr_RuntimeLong().init___I__I((-764862721), (-1));
  this.Coral$1 = new $c_sjsr_RuntimeLong().init___I__I((-8433409), (-1));
  this.CornflowerBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1687547391, 0);
  this.Cornsilk$1 = new $c_sjsr_RuntimeLong().init___I__I((-467713), (-1));
  this.Crimson$1 = new $c_sjsr_RuntimeLong().init___I__I((-602653441), (-1));
  this.Cyan$1 = new $c_sjsr_RuntimeLong().init___I__I(16777215, 0);
  this.DarkBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(35839, 0);
  this.DarkCyan$1 = new $c_sjsr_RuntimeLong().init___I__I(9145343, 0);
  this.DarkGoldenRod$1 = new $c_sjsr_RuntimeLong().init___I__I((-1199174657), (-1));
  this.DarkGray$1 = new $c_sjsr_RuntimeLong().init___I__I((-1448498689), (-1));
  this.DarkGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(6553855, 0);
  this.DarkKhaki$1 = new $c_sjsr_RuntimeLong().init___I__I((-1112052737), (-1));
  this.DarkMagenta$1 = new $c_sjsr_RuntimeLong().init___I__I((-1962898433), (-1));
  this.DarkOliveGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(1433087999, 0);
  this.DarkOrange$1 = new $c_sjsr_RuntimeLong().init___I__I((-7601921), (-1));
  this.DarkOrchid$1 = new $c_sjsr_RuntimeLong().init___I__I((-1724723969), (-1));
  this.DarkRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-1962934017), (-1));
  this.DarkSalmon$1 = new $c_sjsr_RuntimeLong().init___I__I((-376014081), (-1));
  this.DarkSeaGreen$1 = new $c_sjsr_RuntimeLong().init___I__I((-1883467777), (-1));
  this.DarkSlateBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1211993087, 0);
  this.DarkSlateGray$1 = new $c_sjsr_RuntimeLong().init___I__I(793726975, 0);
  this.DarkTurquoise$1 = new $c_sjsr_RuntimeLong().init___I__I(13554175, 0);
  this.DarkViolet$1 = new $c_sjsr_RuntimeLong().init___I__I((-1811885057), (-1));
  this.DeepPink$1 = new $c_sjsr_RuntimeLong().init___I__I((-15428609), (-1));
  this.DeepSkyBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(12582911, 0);
  this.DimGray$1 = new $c_sjsr_RuntimeLong().init___I__I(1768516095, 0);
  this.DodgerBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(512819199, 0);
  this.FireBrick$1 = new $c_sjsr_RuntimeLong().init___I__I((-1306385665), (-1));
  this.FloralWhite$1 = new $c_sjsr_RuntimeLong().init___I__I((-331521), (-1));
  this.ForestGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(579543807, 0);
  this.Fuchsia$1 = new $c_sjsr_RuntimeLong().init___I__I((-16711681), (-1));
  this.Gainsboro$1 = new $c_sjsr_RuntimeLong().init___I__I((-589505281), (-1));
  this.GhostWhite$1 = new $c_sjsr_RuntimeLong().init___I__I((-117899265), (-1));
  this.Gold$1 = new $c_sjsr_RuntimeLong().init___I__I((-2686721), (-1));
  this.GoldenRod$1 = new $c_sjsr_RuntimeLong().init___I__I((-626712321), (-1));
  this.Gray$1 = new $c_sjsr_RuntimeLong().init___I__I((-2139062017), (-1));
  this.Green$1 = new $c_sjsr_RuntimeLong().init___I__I(8388863, 0);
  this.GreenYellow$1 = new $c_sjsr_RuntimeLong().init___I__I((-1375784961), (-1));
  this.HoneyDew$1 = new $c_sjsr_RuntimeLong().init___I__I((-251662081), (-1));
  this.HotPink$1 = new $c_sjsr_RuntimeLong().init___I__I((-9849601), (-1));
  this.IndianRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-849584897), (-1));
  this.Indigo$1 = new $c_sjsr_RuntimeLong().init___I__I(1258324735, 0);
  this.Ivory$1 = new $c_sjsr_RuntimeLong().init___I__I((-3841), (-1));
  this.Khaki$1 = new $c_sjsr_RuntimeLong().init___I__I((-253326081), (-1));
  this.Lavender$1 = new $c_sjsr_RuntimeLong().init___I__I((-421070081), (-1));
  this.LavenderBlush$1 = new $c_sjsr_RuntimeLong().init___I__I((-985601), (-1));
  this.LawnGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(2096890111, 0);
  this.LemonChiffon$1 = new $c_sjsr_RuntimeLong().init___I__I((-340481), (-1));
  this.LightBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-1378294017), (-1));
  this.LightCoral$1 = new $c_sjsr_RuntimeLong().init___I__I((-260013825), (-1));
  this.LightCyan$1 = new $c_sjsr_RuntimeLong().init___I__I((-520093697), (-1));
  this.LightGoldenRodYellow$1 = new $c_sjsr_RuntimeLong().init___I__I((-84225281), (-1));
  this.LightGray$1 = new $c_sjsr_RuntimeLong().init___I__I((-741092353), (-1));
  this.LightGreen$1 = new $c_sjsr_RuntimeLong().init___I__I((-1863413505), (-1));
  this.LightPink$1 = new $c_sjsr_RuntimeLong().init___I__I((-4800001), (-1));
  this.LightSalmon$1 = new $c_sjsr_RuntimeLong().init___I__I((-6259969), (-1));
  this.LightSeaGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(548580095, 0);
  this.LightSkyBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-2016478465), (-1));
  this.LightSlateGray$1 = new $c_sjsr_RuntimeLong().init___I__I(2005441023, 0);
  this.LightSteelBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-1329275137), (-1));
  this.LightYellow$1 = new $c_sjsr_RuntimeLong().init___I__I((-7937), (-1));
  this.Lime$1 = new $c_sjsr_RuntimeLong().init___I__I(16711935, 0);
  this.LimeGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(852308735, 0);
  this.Linen$1 = new $c_sjsr_RuntimeLong().init___I__I((-84875521), (-1));
  this.Magenta$1 = new $c_sjsr_RuntimeLong().init___I__I((-16711681), (-1));
  this.Maroon$1 = new $c_sjsr_RuntimeLong().init___I__I((-2147483393), (-1));
  this.MediumAquaMarine$1 = new $c_sjsr_RuntimeLong().init___I__I(1724754687, 0);
  this.MediumBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(52735, 0);
  this.MediumOrchid$1 = new $c_sjsr_RuntimeLong().init___I__I((-1168780289), (-1));
  this.MediumPurple$1 = new $c_sjsr_RuntimeLong().init___I__I((-1821320193), (-1));
  this.MediumSeaGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(1018393087, 0);
  this.MediumSlateBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(2070474495, 0);
  this.MediumSpringGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(16423679, 0);
  this.MediumTurquoise$1 = new $c_sjsr_RuntimeLong().init___I__I(1221709055, 0);
  this.MediumVioletRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-954890753), (-1));
  this.MidnightBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(421097727, 0);
  this.MintCream$1 = new $c_sjsr_RuntimeLong().init___I__I((-167773441), (-1));
  this.MistyRose$1 = new $c_sjsr_RuntimeLong().init___I__I((-1777153), (-1));
  this.Moccasin$1 = new $c_sjsr_RuntimeLong().init___I__I((-1788417), (-1));
  this.NavajoWhite$1 = new $c_sjsr_RuntimeLong().init___I__I((-2183681), (-1));
  this.Navy$1 = new $c_sjsr_RuntimeLong().init___I__I(33023, 0);
  this.OldLace$1 = new $c_sjsr_RuntimeLong().init___I__I((-34216193), (-1));
  this.Olive$1 = new $c_sjsr_RuntimeLong().init___I__I((-2139094785), (-1));
  this.OliveDrab$1 = new $c_sjsr_RuntimeLong().init___I__I(1804477439, 0);
  this.Orange$1 = new $c_sjsr_RuntimeLong().init___I__I((-5963521), (-1));
  this.OrangeRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-12254977), (-1));
  this.Orchid$1 = new $c_sjsr_RuntimeLong().init___I__I((-630139137), (-1));
  this.PaleGoldenRod$1 = new $c_sjsr_RuntimeLong().init___I__I((-286741761), (-1));
  this.PaleGreen$1 = new $c_sjsr_RuntimeLong().init___I__I((-1728341761), (-1));
  this.PaleTurquoise$1 = new $c_sjsr_RuntimeLong().init___I__I((-1343295745), (-1));
  this.PaleVioletRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-613379073), (-1));
  this.PapayaWhip$1 = new $c_sjsr_RuntimeLong().init___I__I((-1059329), (-1));
  this.PeachPuff$1 = new $c_sjsr_RuntimeLong().init___I__I((-2442753), (-1));
  this.Peru$1 = new $c_sjsr_RuntimeLong().init___I__I((-846905345), (-1));
  this.Pink$1 = new $c_sjsr_RuntimeLong().init___I__I((-4142081), (-1));
  this.Plum$1 = new $c_sjsr_RuntimeLong().init___I__I((-576659969), (-1));
  this.PowderBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-1327438081), (-1));
  this.Purple$1 = new $c_sjsr_RuntimeLong().init___I__I((-2147450625), (-1));
  this.RebeccaPurple$1 = new $c_sjsr_RuntimeLong().init___I__I(1714657791, 0);
  this.Red$1 = new $c_sjsr_RuntimeLong().init___I__I((-16776961), (-1));
  this.RosyBrown$1 = new $c_sjsr_RuntimeLong().init___I__I((-1131442177), (-1));
  this.RoyalBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1097458175, 0);
  this.SaddleBrown$1 = new $c_sjsr_RuntimeLong().init___I__I((-1958407169), (-1));
  this.Salmon$1 = new $c_sjsr_RuntimeLong().init___I__I((-92245249), (-1));
  this.SandyBrown$1 = new $c_sjsr_RuntimeLong().init___I__I((-190553857), (-1));
  this.SeaGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(780883967, 0);
  this.SeaShell$1 = new $c_sjsr_RuntimeLong().init___I__I((-659713), (-1));
  this.Sienna$1 = new $c_sjsr_RuntimeLong().init___I__I((-1605227009), (-1));
  this.Silver$1 = new $c_sjsr_RuntimeLong().init___I__I((-1061109505), (-1));
  this.SkyBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-2016482305), (-1));
  this.SlateBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1784335871, 0);
  this.SlateGray$1 = new $c_sjsr_RuntimeLong().init___I__I(1887473919, 0);
  this.Snow$1 = new $c_sjsr_RuntimeLong().init___I__I((-328961), (-1));
  this.SpringGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(16744447, 0);
  this.SteelBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1182971135, 0);
  this.Tan$1 = new $c_sjsr_RuntimeLong().init___I__I((-759919361), (-1));
  this.Teal$1 = new $c_sjsr_RuntimeLong().init___I__I(8421631, 0);
  this.Thistle$1 = new $c_sjsr_RuntimeLong().init___I__I((-658515713), (-1));
  this.Tomato$1 = new $c_sjsr_RuntimeLong().init___I__I((-10270721), (-1));
  this.Turquoise$1 = new $c_sjsr_RuntimeLong().init___I__I(1088475391, 0);
  this.Violet$1 = new $c_sjsr_RuntimeLong().init___I__I((-293409025), (-1));
  this.Wheat$1 = new $c_sjsr_RuntimeLong().init___I__I((-169954305), (-1));
  this.White$1 = new $c_sjsr_RuntimeLong().init___I__I((-1), (-1));
  this.WhiteSmoke$1 = new $c_sjsr_RuntimeLong().init___I__I((-168430081), (-1));
  this.Yellow$1 = new $c_sjsr_RuntimeLong().init___I__I((-65281), (-1));
  this.YellowGreen$1 = new $c_sjsr_RuntimeLong().init___I__I((-1697828097), (-1));
  var this$2 = new $c_sci_StringOps().init___T("#?([\\w\\d])([\\w\\d])([\\w\\d])");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  this.Hex3Regex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames);
  var this$5 = new $c_sci_StringOps().init___T("#?([\\w\\d]{2})([\\w\\d]{2})([\\w\\d]{2})");
  var groupNames$1 = $m_sci_Nil$();
  var $$this$1 = this$5.repr$1;
  this.Hex6Regex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$1, groupNames$1);
  var this$8 = new $c_sci_StringOps().init___T("rgba\\((\\d+), (\\d+), (\\d+), ([\\d.]+)\\)");
  var groupNames$2 = $m_sci_Nil$();
  var $$this$2 = this$8.repr$1;
  this.RGBARegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$2, groupNames$2);
  return this
});
$c_Lio_youi_Color$.prototype.fromHex__T__J = (function(value) {
  _fromHex: while (true) {
    var thiz = value;
    var x1 = $uI(thiz.length);
    var thiz$1 = value;
    if ((($uI(thiz$1.length) >= 0) && ($as_T(thiz$1.substring(0, $uI("#".length))) === "#"))) {
      var thiz$2 = value;
      value = $as_T(thiz$2.substring(1));
      continue _fromHex
    } else if ((x1 === 1)) {
      var value$1 = value;
      $m_sci_IndexedSeq$();
      $m_sc_IndexedSeq$();
      $m_sci_IndexedSeq$();
      $m_sci_Vector$();
      var b = new $c_sci_VectorBuilder().init___();
      var i = 0;
      while (true) {
        var arg1 = i;
        b.$$plus$eq__O__sci_VectorBuilder(value$1);
        if ((i === 7)) {
          break
        };
        i = ((1 + i) | 0)
      };
      var this$15 = b.result__sci_Vector();
      value = $f_sc_TraversableOnce__mkString__T__T__T__T(this$15, "", "", "");
      continue _fromHex
    } else if ((x1 === 2)) {
      var value$2 = value;
      $m_sci_IndexedSeq$();
      $m_sc_IndexedSeq$();
      $m_sci_IndexedSeq$();
      $m_sci_Vector$();
      var b$1 = new $c_sci_VectorBuilder().init___();
      var i$1 = 0;
      while (true) {
        var arg1$1 = i$1;
        b$1.$$plus$eq__O__sci_VectorBuilder(value$2);
        if ((i$1 === 3)) {
          break
        };
        i$1 = ((1 + i$1) | 0)
      };
      var this$22 = b$1.result__sci_Vector();
      value = $f_sc_TraversableOnce__mkString__T__T__T__T(this$22, "", "", "");
      continue _fromHex
    } else if ((x1 === 3)) {
      var thiz$3 = value;
      var r = (65535 & $uI(thiz$3.charCodeAt(0)));
      var thiz$4 = value;
      var g = (65535 & $uI(thiz$4.charCodeAt(1)));
      var thiz$5 = value;
      var b$2 = (65535 & $uI(thiz$5.charCodeAt(2)));
      value = ((((((("" + new $c_jl_Character().init___C(r)) + new $c_jl_Character().init___C(r)) + new $c_jl_Character().init___C(g)) + new $c_jl_Character().init___C(g)) + new $c_jl_Character().init___C(b$2)) + new $c_jl_Character().init___C(b$2)) + "ff");
      continue _fromHex
    } else if ((x1 === 4)) {
      var thiz$6 = value;
      var r$2 = (65535 & $uI(thiz$6.charCodeAt(0)));
      var thiz$7 = value;
      var g$2 = (65535 & $uI(thiz$7.charCodeAt(1)));
      var thiz$8 = value;
      var b$2$1 = (65535 & $uI(thiz$8.charCodeAt(2)));
      var thiz$9 = value;
      var a = (65535 & $uI(thiz$9.charCodeAt(3)));
      value = (((((((("" + new $c_jl_Character().init___C(r$2)) + new $c_jl_Character().init___C(r$2)) + new $c_jl_Character().init___C(g$2)) + new $c_jl_Character().init___C(g$2)) + new $c_jl_Character().init___C(b$2$1)) + new $c_jl_Character().init___C(b$2$1)) + new $c_jl_Character().init___C(a)) + new $c_jl_Character().init___C(a));
      continue _fromHex
    } else if ((x1 === 6)) {
      value = (value + "ff");
      continue _fromHex
    } else if ((x1 === 8)) {
      var t = $m_jl_Long$().parseLong__T__I__J(value, 16);
      var lo = t.lo$2;
      var hi = t.hi$2;
      return new $c_sjsr_RuntimeLong().init___I__I(lo, hi)
    } else {
      throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T((((("Unsupported hex length (" + x1) + ") for ") + value) + ".")))
    }
  }
});
$c_Lio_youi_Color$.prototype.hexify__p1__D__T = (function(value) {
  var x = (255.0 * value);
  return this.hexify__p1__I__T($doubleToInt($uD($g.Math.floor(x))))
});
$c_Lio_youi_Color$.prototype.equals$extension__J__O__Z = (function($$this, x$1) {
  if ($is_Lio_youi_Color(x$1)) {
    var t = $as_Lio_youi_Color(x$1).value$1;
    var lo = t.lo$2;
    var hi = t.hi$2;
    return (($$this.lo$2 === lo) && ($$this.hi$2 === hi))
  } else {
    return false
  }
});
$c_Lio_youi_Color$.prototype.greenHex$extension__J__T = (function($$this) {
  return $m_Lio_youi_Color$().hexify__p1__I__T($m_Lio_youi_Color$().greenInt$extension__J__I($$this))
});
$c_Lio_youi_Color$.prototype.toRGBA$extension__J__T = (function($$this) {
  return (((((((("rgba(" + $m_Lio_youi_Color$().redInt$extension__J__I($$this)) + ", ") + $m_Lio_youi_Color$().greenInt$extension__J__I($$this)) + ", ") + $m_Lio_youi_Color$().blueInt$extension__J__I($$this)) + ", ") + $m_Lio_youi_Color$().alpha$extension__J__D($$this)) + ")")
});
$c_Lio_youi_Color$.prototype.toString$extension__J__T = (function($$this) {
  return (((((((("Color(red: " + $m_Lio_youi_Color$().red$extension__J__D($$this)) + ", green: ") + $m_Lio_youi_Color$().green$extension__J__D($$this)) + ", blue: ") + $m_Lio_youi_Color$().blue$extension__J__D($$this)) + ", alpha: ") + $m_Lio_youi_Color$().alpha$extension__J__D($$this)) + ")")
});
$c_Lio_youi_Color$.prototype.alphaInt$extension__J__I = (function($$this) {
  var lo = (255 & $$this.lo$2);
  return lo
});
$c_Lio_youi_Color$.prototype.withAlpha$extension__J__D__J = (function($$this, alpha) {
  return $m_Lio_youi_Color$().fromHex__T__J((((("" + $m_Lio_youi_Color$().redHex$extension__J__T($$this)) + $m_Lio_youi_Color$().greenHex$extension__J__T($$this)) + $m_Lio_youi_Color$().blueHex$extension__J__T($$this)) + $m_Lio_youi_Color$().hexify__p1__D__T(alpha)))
});
$c_Lio_youi_Color$.prototype.greenInt$extension__J__I = (function($$this) {
  var lo = ((($$this.lo$2 >>> 16) | 0) | ($$this.hi$2 << 16));
  var lo$1 = (255 & lo);
  return lo$1
});
$c_Lio_youi_Color$.prototype.redHex$extension__J__T = (function($$this) {
  return $m_Lio_youi_Color$().hexify__p1__I__T($m_Lio_youi_Color$().redInt$extension__J__I($$this))
});
$c_Lio_youi_Color$.prototype.withRed$extension__J__D__J = (function($$this, red) {
  return $m_Lio_youi_Color$().fromHex__T__J((((("" + $m_Lio_youi_Color$().hexify__p1__D__T(red)) + $m_Lio_youi_Color$().greenHex$extension__J__T($$this)) + $m_Lio_youi_Color$().blueHex$extension__J__T($$this)) + $m_Lio_youi_Color$().alphaHex$extension__J__T($$this)))
});
$c_Lio_youi_Color$.prototype.blueHex$extension__J__T = (function($$this) {
  return $m_Lio_youi_Color$().hexify__p1__I__T($m_Lio_youi_Color$().blueInt$extension__J__I($$this))
});
$c_Lio_youi_Color$.prototype.redInt$extension__J__I = (function($$this) {
  var lo = ((($$this.lo$2 >>> 24) | 0) | ($$this.hi$2 << 8));
  var lo$1 = (255 & lo);
  return lo$1
});
$c_Lio_youi_Color$.prototype.unapply__T__s_Option = (function(value) {
  if (((value === null) || (value === ""))) {
    return $m_s_None$()
  };
  var o16 = this.Hex3Regex$1.unapplySeq__jl_CharSequence__s_Option(value);
  if ((!o16.isEmpty__Z())) {
    if ((o16.get__O() !== null)) {
      var this$1 = $as_sc_LinearSeqOptimized(o16.get__O());
      var jsx$1 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$1, 3) === 0)
    } else {
      var jsx$1 = false
    }
  } else {
    var jsx$1 = false
  };
  if (jsx$1) {
    var this$2 = $as_sc_LinearSeqOptimized(o16.get__O());
    var r = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$2, 0));
    var this$3 = $as_sc_LinearSeqOptimized(o16.get__O());
    var g = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$3, 1));
    var this$4 = $as_sc_LinearSeqOptimized(o16.get__O());
    var b = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$4, 2));
    var t = $m_jl_Long$().parseLong__T__I__J(((((((("" + r) + r) + g) + g) + b) + b) + "ff"), 16);
    var lo = t.lo$2;
    var hi = t.hi$2;
    return new $c_s_Some().init___O(new $c_Lio_youi_Color().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo, hi)))
  };
  var o18 = this.Hex6Regex$1.unapplySeq__jl_CharSequence__s_Option(value);
  if ((!o18.isEmpty__Z())) {
    if ((o18.get__O() !== null)) {
      var this$5 = $as_sc_LinearSeqOptimized(o18.get__O());
      var jsx$2 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$5, 3) === 0)
    } else {
      var jsx$2 = false
    }
  } else {
    var jsx$2 = false
  };
  if (jsx$2) {
    var this$6 = $as_sc_LinearSeqOptimized(o18.get__O());
    var r$2 = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$6, 0));
    var this$7 = $as_sc_LinearSeqOptimized(o18.get__O());
    var g$2 = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$7, 1));
    var this$8 = $as_sc_LinearSeqOptimized(o18.get__O());
    var b$2 = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$8, 2));
    var t$1 = $m_jl_Long$().parseLong__T__I__J((((("" + r$2) + g$2) + b$2) + "ff"), 16);
    var lo$1 = t$1.lo$2;
    var hi$1 = t$1.hi$2;
    return new $c_s_Some().init___O(new $c_Lio_youi_Color().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1)))
  };
  var o20 = this.RGBARegex$1.unapplySeq__jl_CharSequence__s_Option(value);
  if ((!o20.isEmpty__Z())) {
    if ((o20.get__O() !== null)) {
      var this$9 = $as_sc_LinearSeqOptimized(o20.get__O());
      var jsx$3 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$9, 4) === 0)
    } else {
      var jsx$3 = false
    }
  } else {
    var jsx$3 = false
  };
  if (jsx$3) {
    var this$10 = $as_sc_LinearSeqOptimized(o20.get__O());
    var r$3 = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$10, 0));
    var this$11 = $as_sc_LinearSeqOptimized(o20.get__O());
    var g$3 = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$11, 1));
    var this$12 = $as_sc_LinearSeqOptimized(o20.get__O());
    var b$3 = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$12, 2));
    var this$13 = $as_sc_LinearSeqOptimized(o20.get__O());
    var a = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$13, 3));
    var this$15 = new $c_sci_StringOps().init___T(r$3);
    var this$17 = $m_jl_Integer$();
    var $$this = this$15.repr$1;
    var red = this.hexify__p1__I__T(this$17.parseInt__T__I__I($$this, 10));
    var this$19 = new $c_sci_StringOps().init___T(g$3);
    var this$21 = $m_jl_Integer$();
    var $$this$1 = this$19.repr$1;
    var green = this.hexify__p1__I__T(this$21.parseInt__T__I__I($$this$1, 10));
    var this$23 = new $c_sci_StringOps().init___T(b$3);
    var this$25 = $m_jl_Integer$();
    var $$this$2 = this$23.repr$1;
    var blue = this.hexify__p1__I__T(this$25.parseInt__T__I__I($$this$2, 10));
    var this$27 = new $c_sci_StringOps().init___T(a);
    var jsx$4 = $m_jl_Double$();
    var $$this$3 = this$27.repr$1;
    var alpha = this.hexify__p1__D__T(jsx$4.parseDouble__T__D($$this$3));
    var t$2 = $m_jl_Long$().parseLong__T__I__J((((("" + red) + green) + blue) + alpha), 16);
    var lo$2 = t$2.lo$2;
    var hi$2 = t$2.hi$2;
    return new $c_s_Some().init___O(new $c_Lio_youi_Color().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo$2, hi$2)))
  };
  var jsx$5 = $m_Lscribe_package$();
  var level = $m_Lscribe_Level$Warn$();
  var value$2 = $m_Lscribe_Level$Warn$().value$1;
  var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, value$1) {
    return (function() {
      return ("Unknown conversion for color value from String: " + value$1)
    })
  })(this, value));
  var loggable = $m_Lscribe_Loggable$StringLoggable$();
  var throwable = $m_s_None$();
  var methodName = new $c_s_Some().init___O("unapply");
  var line = new $c_s_Some().init___O(239);
  var column = new $c_s_Some().init___O(18);
  var thread = $m_jl_Thread$().SingleThread$1;
  var this$31 = $m_Lscribe_util_Time$();
  var this$32 = this$31.function$1;
  var t$3 = $uJ(this$32.apply__O());
  var lo$3 = t$3.lo$2;
  var hi$3 = t$3.hi$2;
  jsx$5.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value$2, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/core/shared/src/main/scala/io/youi/Color.scala", "io.youi.Color", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo$3, hi$3)));
  return $m_s_None$()
});
$c_Lio_youi_Color$.prototype.hexify__p1__I__T = (function(value) {
  var this$3 = new $c_sci_StringOps().init___T("%02x");
  var array = [value];
  var jsx$2 = $m_sjsr_RuntimeString$();
  var $$this = this$3.repr$1;
  $m_sc_Seq$();
  $m_sjs_js_WrappedArray$();
  var array$1 = [];
  var x1 = $uI(array.length);
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = $uI(array.length);
  while ((i < len)) {
    var index = i;
    var arg1 = array[index];
    var elem = $f_sci_StringLike__unwrapArg__psci_StringLike__O__O(this$3, arg1);
    array$1.push(elem);
    i = ((1 + i) | 0)
  };
  $m_s_reflect_ManifestFactory$ObjectManifest$();
  var len$1 = $uI(array$1.length);
  var result = $newArrayObject($d_O.getArrayOf(), [len$1]);
  var len$2 = result.u.length;
  var i$1 = 0;
  var j = 0;
  var x = $uI(array$1.length);
  var x$1 = ((x < len$2) ? x : len$2);
  var that = result.u.length;
  var end = ((x$1 < that) ? x$1 : that);
  while ((i$1 < end)) {
    var jsx$1 = j;
    var index$1 = i$1;
    result.set(jsx$1, array$1[index$1]);
    i$1 = ((1 + i$1) | 0);
    j = ((1 + j) | 0)
  };
  return jsx$2.format__T__AO__T($$this, result)
});
$c_Lio_youi_Color$.prototype.green$extension__J__D = (function($$this) {
  return ($m_Lio_youi_Color$().greenInt$extension__J__I($$this) / 255.0)
});
$c_Lio_youi_Color$.prototype.red$extension__J__D = (function($$this) {
  return ($m_Lio_youi_Color$().redInt$extension__J__I($$this) / 255.0)
});
$c_Lio_youi_Color$.prototype.alphaHex$extension__J__T = (function($$this) {
  return $m_Lio_youi_Color$().hexify__p1__I__T($m_Lio_youi_Color$().alphaInt$extension__J__I($$this))
});
$c_Lio_youi_Color$.prototype.blueInt$extension__J__I = (function($$this) {
  var lo = ((($$this.lo$2 >>> 8) | 0) | ($$this.hi$2 << 24));
  var lo$1 = (255 & lo);
  return lo$1
});
$c_Lio_youi_Color$.prototype.alpha$extension__J__D = (function($$this) {
  return ($m_Lio_youi_Color$().alphaInt$extension__J__I($$this) / 255.0)
});
$c_Lio_youi_Color$.prototype.blue$extension__J__D = (function($$this) {
  return ($m_Lio_youi_Color$().blueInt$extension__J__I($$this) / 255.0)
});
var $d_Lio_youi_Color$ = new $TypeData().initClass({
  Lio_youi_Color$: 0
}, false, "io.youi.Color$", {
  Lio_youi_Color$: 1,
  O: 1
});
$c_Lio_youi_Color$.prototype.$classData = $d_Lio_youi_Color$;
var $n_Lio_youi_Color$ = (void 0);
function $m_Lio_youi_Color$() {
  if ((!$n_Lio_youi_Color$)) {
    $n_Lio_youi_Color$ = new $c_Lio_youi_Color$().init___()
  };
  return $n_Lio_youi_Color$
}
/** @constructor */
function $c_Lio_youi_Cursor() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_Cursor.prototype = new $h_O();
$c_Lio_youi_Cursor.prototype.constructor = $c_Lio_youi_Cursor;
/** @constructor */
function $h_Lio_youi_Cursor() {
  /*<skip>*/
}
$h_Lio_youi_Cursor.prototype = $c_Lio_youi_Cursor.prototype;
$c_Lio_youi_Cursor.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_Cursor(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_Cursor)))
}
function $as_Lio_youi_Cursor(obj) {
  return (($is_Lio_youi_Cursor(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.Cursor"))
}
function $isArrayOf_Lio_youi_Cursor(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_Cursor)))
}
function $asArrayOf_Lio_youi_Cursor(obj, depth) {
  return (($isArrayOf_Lio_youi_Cursor(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.Cursor;", depth))
}
/** @constructor */
function $c_Lio_youi_ErrorSupport$() {
  $c_O.call(this);
  this.error$1 = null;
  this.defaultHandler$1 = null
}
$c_Lio_youi_ErrorSupport$.prototype = new $h_O();
$c_Lio_youi_ErrorSupport$.prototype.constructor = $c_Lio_youi_ErrorSupport$;
/** @constructor */
function $h_Lio_youi_ErrorSupport$() {
  /*<skip>*/
}
$h_Lio_youi_ErrorSupport$.prototype = $c_Lio_youi_ErrorSupport$.prototype;
$c_Lio_youi_ErrorSupport$.prototype.init___ = (function() {
  $n_Lio_youi_ErrorSupport$ = this;
  this.error$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  var this$24 = this.error$1;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$1$2) {
      var x0$1 = $as_jl_Throwable(x0$1$2);
      var rc7 = false;
      var x2 = new $c_sr_ObjectRef().init___O(null);
      matchEnd8: {
        if ($is_Ljava_io_IOException(x0$1)) {
          rc7 = true;
          x2.elem$1 = $as_Ljava_io_IOException(x0$1);
          if (($as_Ljava_io_IOException(x2.elem$1).getMessage__T() === "Connection reset by peer")) {
            var jsx$1 = $m_Lscribe_package$();
            var level = $m_Lscribe_Level$Warn$();
            var value = $m_Lscribe_Level$Warn$().value$1;
            var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, x2$1) {
              return (function() {
                return $as_Ljava_io_IOException(x2$1.elem$1).getMessage__T()
              })
            })($this, x2));
            var loggable = $m_Lscribe_Loggable$StringLoggable$();
            var throwable = $m_s_None$();
            var methodName = $m_s_None$();
            var line = new $c_s_Some().init___O(25);
            var column = new $c_s_Some().init___O(89);
            var thread = $m_jl_Thread$().SingleThread$1;
            var this$5 = $m_Lscribe_util_Time$();
            var this$6 = this$5.function$1;
            var t = $uJ(this$6.apply__O());
            var lo = t.lo$2;
            var hi = t.hi$2;
            jsx$1.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/core/shared/src/main/scala/io/youi/ErrorSupport.scala", "io.youi.ErrorSupport.defaultHandler", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
            break matchEnd8
          }
        };
        if ((rc7 && ($as_Ljava_io_IOException(x2.elem$1).getMessage__T() === "Broken pipe"))) {
          var jsx$2 = $m_Lscribe_package$();
          var level$1 = $m_Lscribe_Level$Warn$();
          var value$1 = $m_Lscribe_Level$Warn$().value$1;
          var messageFunction$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, x2$2) {
            return (function() {
              return $as_Ljava_io_IOException(x2$2.elem$1).getMessage__T()
            })
          })($this, x2));
          var loggable$1 = $m_Lscribe_Loggable$StringLoggable$();
          var throwable$1 = $m_s_None$();
          var methodName$1 = $m_s_None$();
          var line$1 = new $c_s_Some().init___O(26);
          var column$1 = new $c_s_Some().init___O(76);
          var thread$1 = $m_jl_Thread$().SingleThread$1;
          var this$10 = $m_Lscribe_util_Time$();
          var this$11 = this$10.function$1;
          var t$1 = $uJ(this$11.apply__O());
          var lo$1 = t$1.lo$2;
          var hi$1 = t$1.hi$2;
          jsx$2.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level$1, value$1, messageFunction$1, loggable$1, throwable$1, "/home/mhicks/projects/open/youi/core/shared/src/main/scala/io/youi/ErrorSupport.scala", "io.youi.ErrorSupport.defaultHandler", methodName$1, line$1, column$1, thread$1, new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1)));
          break matchEnd8
        };
        if ($is_Lio_youi_MessageException(x0$1)) {
          var jsx$3 = $m_Lscribe_package$();
          var level$2 = $m_Lscribe_Level$Error$();
          var value$2 = $m_Lscribe_Level$Error$().value$1;
          var messageFunction$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, x4) {
            return (function() {
              return $as_Lio_youi_MessageException(x4).message__T()
            })
          })($this, x0$1));
          var loggable$2 = $m_Lscribe_Loggable$StringLoggable$();
          var throwable$2 = $m_s_None$();
          var methodName$2 = $m_s_None$();
          var line$2 = new $c_s_Some().init___O(27);
          var column$2 = new $c_s_Some().init___O(47);
          var thread$2 = $m_jl_Thread$().SingleThread$1;
          var this$15 = $m_Lscribe_util_Time$();
          var this$16 = this$15.function$1;
          var t$2 = $uJ(this$16.apply__O());
          var lo$2 = t$2.lo$2;
          var hi$2 = t$2.hi$2;
          jsx$3.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level$2, value$2, messageFunction$2, loggable$2, throwable$2, "/home/mhicks/projects/open/youi/core/shared/src/main/scala/io/youi/ErrorSupport.scala", "io.youi.ErrorSupport.defaultHandler", methodName$2, line$2, column$2, thread$2, new $c_sjsr_RuntimeLong().init___I__I(lo$2, hi$2)));
          break matchEnd8
        };
        if ((x0$1 !== null)) {
          var jsx$4 = $m_Lscribe_package$();
          var level$3 = $m_Lscribe_Level$Error$();
          var value$3 = $m_Lscribe_Level$Error$().value$1;
          var messageFunction$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, x5) {
            return (function() {
              return x5
            })
          })($this, x0$1));
          var loggable$3 = $m_Lscribe_Loggable$ThrowableLoggable$();
          var throwable$3 = $m_s_None$();
          var methodName$3 = $m_s_None$();
          var line$3 = new $c_s_Some().init___O(28);
          var column$3 = new $c_s_Some().init___O(38);
          var thread$3 = $m_jl_Thread$().SingleThread$1;
          var this$20 = $m_Lscribe_util_Time$();
          var this$21 = this$20.function$1;
          var t$3 = $uJ(this$21.apply__O());
          var lo$3 = t$3.lo$2;
          var hi$3 = t$3.hi$2;
          jsx$4.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level$3, value$3, messageFunction$3, loggable$3, throwable$3, "/home/mhicks/projects/open/youi/core/shared/src/main/scala/io/youi/ErrorSupport.scala", "io.youi.ErrorSupport.defaultHandler", methodName$3, line$3, column$3, thread$3, new $c_sjsr_RuntimeLong().init___I__I(lo$3, hi$3)));
          break matchEnd8
        };
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })(this));
  var priority = $m_Lreactify_Priority$().Normal$1;
  this.defaultHandler$1 = $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$24, f, priority);
  return this
});
var $d_Lio_youi_ErrorSupport$ = new $TypeData().initClass({
  Lio_youi_ErrorSupport$: 0
}, false, "io.youi.ErrorSupport$", {
  Lio_youi_ErrorSupport$: 1,
  O: 1
});
$c_Lio_youi_ErrorSupport$.prototype.$classData = $d_Lio_youi_ErrorSupport$;
var $n_Lio_youi_ErrorSupport$ = (void 0);
function $m_Lio_youi_ErrorSupport$() {
  if ((!$n_Lio_youi_ErrorSupport$)) {
    $n_Lio_youi_ErrorSupport$ = new $c_Lio_youi_ErrorSupport$().init___()
  };
  return $n_Lio_youi_ErrorSupport$
}
/** @constructor */
function $c_Lio_youi_ExtendedElement() {
  $c_O.call(this);
  this.element$1 = null
}
$c_Lio_youi_ExtendedElement.prototype = new $h_O();
$c_Lio_youi_ExtendedElement.prototype.constructor = $c_Lio_youi_ExtendedElement;
/** @constructor */
function $h_Lio_youi_ExtendedElement() {
  /*<skip>*/
}
$h_Lio_youi_ExtendedElement.prototype = $c_Lio_youi_ExtendedElement.prototype;
$c_Lio_youi_ExtendedElement.prototype.bySelector__T__sci_Vector = (function(selectors) {
  return $m_Lio_youi_dom$().bySelector__T__s_Option__sci_Vector(selectors, this.element$1)
});
$c_Lio_youi_ExtendedElement.prototype.firstBySelector__T__s_Option = (function(selectors) {
  return $m_Lio_youi_dom$().firstBySelector__T__s_Option__s_Option(selectors, this.element$1)
});
$c_Lio_youi_ExtendedElement.prototype.getById__T__s_Option = (function(id) {
  return this.firstBySelector__T__s_Option(("#" + id))
});
$c_Lio_youi_ExtendedElement.prototype.byId__T__Lorg_scalajs_dom_raw_Element = (function(id) {
  return this.oneBySelector__T__Lorg_scalajs_dom_raw_Element(("#" + id))
});
$c_Lio_youi_ExtendedElement.prototype.init___s_Option = (function(element) {
  this.element$1 = element;
  return this
});
$c_Lio_youi_ExtendedElement.prototype.oneBySelector__T__Lorg_scalajs_dom_raw_Element = (function(selectors) {
  return $m_Lio_youi_dom$().oneBySelector__T__s_Option__Lorg_scalajs_dom_raw_Element(selectors, this.element$1)
});
/** @constructor */
function $c_Lio_youi_History$() {
  $c_O.call(this);
  this.alwaysReload$1 = null;
  this.currentURL$1 = null;
  this.url$1 = null;
  this.stateChange$1 = null
}
$c_Lio_youi_History$.prototype = new $h_O();
$c_Lio_youi_History$.prototype.constructor = $c_Lio_youi_History$;
/** @constructor */
function $h_Lio_youi_History$() {
  /*<skip>*/
}
$h_Lio_youi_History$.prototype = $c_Lio_youi_History$.prototype;
$c_Lio_youi_History$.prototype.init___ = (function() {
  $n_Lio_youi_History$ = this;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return false
    })
  })(this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.alwaysReload$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      var this$4 = $m_Lio_youi_net_URL$();
      var url = $as_T($m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().location.href);
      return this$4.apply__T__Z__Lio_youi_net_URL(url, true)
    })
  })(this));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.currentURL$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      var v = $m_Lio_youi_History$().currentURL$1;
      return $as_Lio_youi_net_URL(v.state__Lreactify_State().value__O())
    })
  })(this));
  var name$2 = $m_s_None$();
  this.url$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$2, name$2);
  this.stateChange$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().addEventListener("popstate", (function(arg1$2) {
    return $m_Lio_youi_History$().io$youi$History$$$anonfun$new$1__Lorg_scalajs_dom_raw_PopStateEvent__O(arg1$2)
  }));
  return this
});
$c_Lio_youi_History$.prototype.reload__Z__V = (function(force) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.reload(force)
});
$c_Lio_youi_History$.prototype.replace__Lio_youi_net_URL__sjs_js_Any__V = (function(url, state) {
  var this$1 = this.alwaysReload$1;
  if ($uZ(this$1.state__Lreactify_State().value__O())) {
    this.set__Lio_youi_net_URL__V(url)
  } else {
    var this$2 = this.url$1;
    var x$2 = this$2.state__Lreactify_State().value__O();
    if ((!((url === null) ? (x$2 === null) : url.equals__O__Z(x$2)))) {
      var urlString = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
      $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.replaceState(state, urlString, urlString);
      var this$3 = this.currentURL$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, url$1) {
        return (function() {
          return url$1
        })
      })(this, url));
      this$3.set__F0__V(value);
      var this$4 = this.stateChange$1;
      var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, url$2, state$1) {
        return (function() {
          return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url$2, $m_Lio_youi_StateType$Replace$(), state$1)
        })
      })(this, url, state));
      this$4.set__F0__V(value$1)
    }
  }
});
$c_Lio_youi_History$.prototype.back__I__V = (function(delta) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.go(((-delta) | 0))
});
$c_Lio_youi_History$.prototype.update__Lio_youi_HistoryStateChange__V = (function(change) {
  var x1 = change.stateType$1;
  var x = $m_Lio_youi_StateType$Push$();
  if ((x === x1)) {
    this.push__Lio_youi_net_URL__sjs_js_Any__V(change.url$1, change.state$1)
  } else {
    var x$3 = $m_Lio_youi_StateType$Replace$();
    if ((x$3 === x1)) {
      this.replace__Lio_youi_net_URL__sjs_js_Any__V(change.url$1, change.state$1)
    } else {
      var x$5 = $m_Lio_youi_StateType$Set$();
      if ((x$5 === x1)) {
        this.set__Lio_youi_net_URL__V(change.url$1)
      } else {
        var x$7 = $m_Lio_youi_StateType$Pop$();
        if ((x$7 === x1)) {
          this.back__I__V(1)
        } else {
          throw new $c_s_MatchError().init___O(x1)
        }
      }
    }
  }
});
$c_Lio_youi_History$.prototype.push__Lio_youi_net_URL__sjs_js_Any__V = (function(url, state) {
  var this$1 = this.alwaysReload$1;
  if ($uZ(this$1.state__Lreactify_State().value__O())) {
    this.set__Lio_youi_net_URL__V(url)
  } else {
    var this$2 = this.url$1;
    var x$2 = this$2.state__Lreactify_State().value__O();
    if ((!((url === null) ? (x$2 === null) : url.equals__O__Z(x$2)))) {
      var urlString = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
      $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.pushState(state, urlString, urlString);
      var this$3 = this.currentURL$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, url$1) {
        return (function() {
          return url$1
        })
      })(this, url));
      this$3.set__F0__V(value);
      var this$4 = this.stateChange$1;
      var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, url$2, state$1) {
        return (function() {
          return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url$2, $m_Lio_youi_StateType$Push$(), state$1)
        })
      })(this, url, state));
      this$4.set__F0__V(value$1)
    }
  }
});
$c_Lio_youi_History$.prototype.set__Lio_youi_net_URL__V = (function(url) {
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().location.href = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
  var this$1 = this.stateChange$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, url$1) {
    return (function() {
      return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url$1, $m_Lio_youi_StateType$Set$(), null)
    })
  })(this, url));
  this$1.set__F0__V(value)
});
$c_Lio_youi_History$.prototype.io$youi$History$$$anonfun$new$1__Lorg_scalajs_dom_raw_PopStateEvent__O = (function(evt) {
  var urlString = $as_T($m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().location.href);
  var this$1 = $m_Lio_youi_net_URL$();
  var newURL = this$1.apply__T__Z__Lio_youi_net_URL(urlString, true);
  var this$2 = $m_Lio_youi_History$().url$1;
  var x$2 = this$2.state__Lreactify_State().value__O();
  if ((!((newURL === null) ? (x$2 === null) : newURL.equals__O__Z(x$2)))) {
    var this$3 = $m_Lio_youi_History$().currentURL$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, newURL$1) {
      return (function() {
        return newURL$1
      })
    })(this, newURL));
    this$3.set__F0__V(value);
    var this$4 = $m_Lio_youi_History$().stateChange$1;
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, newURL$2, evt$1) {
      return (function() {
        return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(newURL$2, $m_Lio_youi_StateType$Pop$(), evt$1.state)
      })
    })(this, newURL, evt));
    this$4.set__F0__V(value$1);
    return (void 0)
  } else {
    return (void 0)
  }
});
var $d_Lio_youi_History$ = new $TypeData().initClass({
  Lio_youi_History$: 0
}, false, "io.youi.History$", {
  Lio_youi_History$: 1,
  O: 1
});
$c_Lio_youi_History$.prototype.$classData = $d_Lio_youi_History$;
var $n_Lio_youi_History$ = (void 0);
function $m_Lio_youi_History$() {
  if ((!$n_Lio_youi_History$)) {
    $n_Lio_youi_History$ = new $c_Lio_youi_History$().init___()
  };
  return $n_Lio_youi_History$
}
/** @constructor */
function $c_Lio_youi_LazyUpdate() {
  $c_O.call(this);
  this.f$1 = null;
  this.maxFrequency$1 = null;
  this.lastUpdate$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.dirty$1 = null
}
$c_Lio_youi_LazyUpdate.prototype = new $h_O();
$c_Lio_youi_LazyUpdate.prototype.constructor = $c_Lio_youi_LazyUpdate;
/** @constructor */
function $h_Lio_youi_LazyUpdate() {
  /*<skip>*/
}
$h_Lio_youi_LazyUpdate.prototype = $c_Lio_youi_LazyUpdate.prototype;
$c_Lio_youi_LazyUpdate.prototype.isReady__Z = (function() {
  var t = $m_jl_System$().currentTimeMillis__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  var b = this.lastUpdate$1;
  var bhi = b.hi$2;
  var lo$1 = ((lo - b.lo$2) | 0);
  var hi$1 = ((((-2147483648) ^ lo$1) > ((-2147483648) ^ lo)) ? (((-1) + ((hi - bhi) | 0)) | 0) : ((hi - bhi) | 0));
  var this$2 = this.maxFrequency$1;
  var b$1 = this$2.unit$2.toMillis__J__J(this$2.length$2);
  var bhi$1 = b$1.hi$2;
  return ((hi$1 === bhi$1) ? (((-2147483648) ^ lo$1) >= ((-2147483648) ^ b$1.lo$2)) : (hi$1 > bhi$1))
});
$c_Lio_youi_LazyUpdate.prototype.update__Z__V = (function(force) {
  if (((this.isReady__Z() && this.dirty$1.compareAndSet__Z__Z__Z(true, false)) || force)) {
    try {
      var this$1 = this.f$1;
      this$1.apply__O()
    } finally {
      this.lastUpdate$1 = $m_jl_System$().currentTimeMillis__J()
    }
  }
});
$c_Lio_youi_LazyUpdate.prototype.init___F0__s_concurrent_duration_FiniteDuration = (function(f, maxFrequency) {
  this.f$1 = f;
  this.maxFrequency$1 = maxFrequency;
  this.lastUpdate$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.dirty$1 = new $c_ju_concurrent_atomic_AtomicBoolean().init___Z(false);
  return this
});
var $d_Lio_youi_LazyUpdate = new $TypeData().initClass({
  Lio_youi_LazyUpdate: 0
}, false, "io.youi.LazyUpdate", {
  Lio_youi_LazyUpdate: 1,
  O: 1
});
$c_Lio_youi_LazyUpdate.prototype.$classData = $d_Lio_youi_LazyUpdate;
/** @constructor */
function $c_Lio_youi_LazyUpdate$() {
  $c_O.call(this)
}
$c_Lio_youi_LazyUpdate$.prototype = new $h_O();
$c_Lio_youi_LazyUpdate$.prototype.constructor = $c_Lio_youi_LazyUpdate$;
/** @constructor */
function $h_Lio_youi_LazyUpdate$() {
  /*<skip>*/
}
$h_Lio_youi_LazyUpdate$.prototype = $c_Lio_youi_LazyUpdate$.prototype;
$c_Lio_youi_LazyUpdate$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_LazyUpdate$.prototype.apply$default$2__s_concurrent_duration_FiniteDuration = (function() {
  var this$2 = new $c_s_concurrent_duration_package$DurationInt().init___I(0);
  var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
  return $m_s_concurrent_duration_package$DurationInt$().durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration(this$2.scala$concurrent$duration$DurationInt$$n$1, unit)
});
var $d_Lio_youi_LazyUpdate$ = new $TypeData().initClass({
  Lio_youi_LazyUpdate$: 0
}, false, "io.youi.LazyUpdate$", {
  Lio_youi_LazyUpdate$: 1,
  O: 1
});
$c_Lio_youi_LazyUpdate$.prototype.$classData = $d_Lio_youi_LazyUpdate$;
var $n_Lio_youi_LazyUpdate$ = (void 0);
function $m_Lio_youi_LazyUpdate$() {
  if ((!$n_Lio_youi_LazyUpdate$)) {
    $n_Lio_youi_LazyUpdate$ = new $c_Lio_youi_LazyUpdate$().init___()
  };
  return $n_Lio_youi_LazyUpdate$
}
/** @constructor */
function $c_Lio_youi_Unique$() {
  $c_O.call(this);
  this.LettersLower$1 = null;
  this.LettersUpper$1 = null;
  this.Numbers$1 = null;
  this.Readable$1 = null;
  this.LettersAndNumbers$1 = null;
  this.AllLettersAndNumbers$1 = null
}
$c_Lio_youi_Unique$.prototype = new $h_O();
$c_Lio_youi_Unique$.prototype.constructor = $c_Lio_youi_Unique$;
/** @constructor */
function $h_Lio_youi_Unique$() {
  /*<skip>*/
}
$h_Lio_youi_Unique$.prototype = $c_Lio_youi_Unique$.prototype;
$c_Lio_youi_Unique$.prototype.init___ = (function() {
  $n_Lio_youi_Unique$ = this;
  this.LettersLower$1 = "abcdefghijklmnopqrstuvwxyz";
  this.LettersUpper$1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  this.Numbers$1 = "0123456789";
  this.Readable$1 = "ABCDEFGHJKLMNPQRSTWXYZ23456789";
  this.LettersAndNumbers$1 = (("" + this.LettersLower$1) + this.Numbers$1);
  this.AllLettersAndNumbers$1 = ((("" + this.LettersLower$1) + this.LettersUpper$1) + this.Numbers$1);
  return this
});
$c_Lio_youi_Unique$.prototype.apply__I__T__T = (function(length, characters) {
  var charMax = $uI(characters.length);
  var isEmpty$4 = (length <= 0);
  if (isEmpty$4) {
    var scala$collection$immutable$Range$$numRangeElements$4 = 0
  } else {
    var hi = (length >> 31);
    var scala$collection$immutable$Range$$numRangeElements$4 = (((hi === 0) ? (((-2147483648) ^ length) > (-1)) : (hi > 0)) ? (-1) : length)
  };
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + length) | 0);
  $m_sci_IndexedSeq$();
  $m_sc_IndexedSeq$();
  $m_sci_IndexedSeq$();
  $m_sci_Vector$();
  var b = new $c_sci_VectorBuilder().init___();
  if ((scala$collection$immutable$Range$$numRangeElements$4 < 0)) {
    $m_sci_Range$().scala$collection$immutable$Range$$fail__I__I__I__Z__sr_Nothing$(0, length, 1, false)
  };
  switch (scala$collection$immutable$Range$$numRangeElements$4) {
    case (-1): {
      break
    }
  };
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var arg1 = i;
      $m_Lio_youi_Unique$();
      var this$9 = $m_ju_concurrent_ThreadLocalRandom$();
      var index = this$9.$$undcurrent$1.nextInt__I__I(charMax);
      var c = (65535 & $uI(characters.charCodeAt(index)));
      var elem = new $c_jl_Character().init___C(c);
      b.$$plus$eq__O__sci_VectorBuilder(elem);
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  var this$13 = b.result__sci_Vector();
  return $f_sc_TraversableOnce__mkString__T__T__T__T(this$13, "", "", "")
});
var $d_Lio_youi_Unique$ = new $TypeData().initClass({
  Lio_youi_Unique$: 0
}, false, "io.youi.Unique$", {
  Lio_youi_Unique$: 1,
  O: 1
});
$c_Lio_youi_Unique$.prototype.$classData = $d_Lio_youi_Unique$;
var $n_Lio_youi_Unique$ = (void 0);
function $m_Lio_youi_Unique$() {
  if ((!$n_Lio_youi_Unique$)) {
    $n_Lio_youi_Unique$ = new $c_Lio_youi_Unique$().init___()
  };
  return $n_Lio_youi_Unique$
}
function $f_Lio_youi_Updates__update__D__V($thiz, delta) {
  var this$1 = $thiz.delta__Lreactify_Channel();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, delta$1) {
    return (function() {
      return delta$1
    })
  })($thiz, delta));
  this$1.set__F0__V(value)
}
function $f_Lio_youi_Updates__rateLimited__s_concurrent_duration_FiniteDuration__s_concurrent_duration_FiniteDuration__F0__Lio_youi_LazyUpdate($thiz, maxFrequency, frequency, f) {
  var lu = new $c_Lio_youi_LazyUpdate().init___F0__s_concurrent_duration_FiniteDuration(f, maxFrequency);
  var until = $m_s_None$();
  var f$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, lu$1) {
    return (function() {
      lu$1.update__Z__V(false)
    })
  })($thiz, lu));
  $f_Lio_youi_Updates__every__s_concurrent_duration_FiniteDuration__s_Option__F0__V($thiz, frequency, until, f$1);
  return lu
}
function $f_Lio_youi_Updates__once__s_concurrent_duration_FiniteDuration__F0__V($thiz, delay, f) {
  var until = new $c_s_Some().init___O(delay);
  $f_Lio_youi_Updates__every__s_concurrent_duration_FiniteDuration__s_Option__F0__V($thiz, delay, until, f)
}
function $f_Lio_youi_Updates__every__s_concurrent_duration_FiniteDuration__s_Option__F0__V($thiz, delay, until, f) {
  var t = delay.unit$2.toMillis__J__J(delay.length$2);
  var lo = t.lo$2;
  var hi = t.hi$2;
  var timeout = ($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo, hi) / 1000.0);
  if (until.isEmpty__Z()) {
    var untilTimeout = $m_s_None$()
  } else {
    var arg1 = until.get__O();
    var x$2 = $as_s_concurrent_duration_FiniteDuration(arg1);
    var t$1 = x$2.unit$2.toMillis__J__J(x$2.length$2);
    var lo$1 = t$1.lo$2;
    var hi$1 = t$1.hi$2;
    var untilTimeout = new $c_s_Some().init___O(($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo$1, hi$1) / 1000.0))
  };
  var elapsed = new $c_sr_DoubleRef().init___D(0.0);
  var totalElapsed = new $c_sr_DoubleRef().init___D(0.0);
  var reaction = new $c_sr_ObjectRef().init___O(null);
  var this$5 = $thiz.delta__Lreactify_Channel();
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, f$1, timeout$1, untilTimeout$1, elapsed$1, totalElapsed$1, reaction$1) {
    return (function(d$2) {
      var d = $uD(d$2);
      elapsed$1.elem$1 = (elapsed$1.elem$1 + d);
      totalElapsed$1.elem$1 = (totalElapsed$1.elem$1 + d);
      if ((elapsed$1.elem$1 >= timeout$1)) {
        elapsed$1.elem$1 = 0.0;
        f$1.apply__O();
        if ((!untilTimeout$1.isEmpty__Z())) {
          var arg1$1 = untilTimeout$1.get__O();
          var total = $uD(arg1$1);
          if ((totalElapsed$1.elem$1 >= total)) {
            this$2$1.delta__Lreactify_Channel().reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction($as_Lreactify_reaction_Reaction(reaction$1.elem$1))
          }
        }
      }
    })
  })($thiz, f, timeout, untilTimeout, elapsed, totalElapsed, reaction));
  $thiz.delta__Lreactify_Channel();
  var priority = $m_Lreactify_Priority$().Normal$1;
  reaction.elem$1 = $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$5, f$2, priority)
}
function $f_Lio_youi_Updates__rateLimited$default$2__s_concurrent_duration_FiniteDuration($thiz) {
  var this$2 = new $c_s_concurrent_duration_package$DurationInt().init___I(0);
  var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
  return $m_s_concurrent_duration_package$DurationInt$().durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration(this$2.scala$concurrent$duration$DurationInt$$n$1, unit)
}
/** @constructor */
function $c_Lio_youi_ajax_AjaxRequest() {
  $c_O.call(this);
  this.data$1 = null;
  this.req$1 = null;
  this.promise$1 = null;
  this.loaded$1 = null;
  this.total$1 = null;
  this.percentage$1 = null;
  this.cancelled$1 = null
}
$c_Lio_youi_ajax_AjaxRequest.prototype = new $h_O();
$c_Lio_youi_ajax_AjaxRequest.prototype.constructor = $c_Lio_youi_ajax_AjaxRequest;
/** @constructor */
function $h_Lio_youi_ajax_AjaxRequest() {
  /*<skip>*/
}
$h_Lio_youi_ajax_AjaxRequest.prototype = $c_Lio_youi_ajax_AjaxRequest.prototype;
$c_Lio_youi_ajax_AjaxRequest.prototype.io$youi$ajax$AjaxRequest$$$anonfun$new$1__Lorg_scalajs_dom_raw_Event__O = (function(x$1) {
  if (($uI(this.req$1.readyState) === 4)) {
    if (((($uI(this.req$1.status) >= 200) && ($uI(this.req$1.status) < 300)) || ($uI(this.req$1.status) === 304))) {
      var this$1 = this.promise$1;
      var value = this.req$1;
      return $f_s_concurrent_Promise__success__O__s_concurrent_Promise(this$1, value)
    } else {
      var this$2 = this.promise$1;
      var cause = new $c_Lorg_scalajs_dom_ext_AjaxException().init___Lorg_scalajs_dom_raw_XMLHttpRequest(this.req$1);
      return $f_s_concurrent_Promise__failure__jl_Throwable__s_concurrent_Promise(this$2, cause)
    }
  } else {
    return (void 0)
  }
});
$c_Lio_youi_ajax_AjaxRequest.prototype.send__s_concurrent_Future = (function() {
  var x1 = this.data$1;
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var formData = x2.value$2;
    this.req$1.send(formData)
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      this.req$1.send()
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  };
  var this$1 = this.promise$1;
  return this$1
});
$c_Lio_youi_ajax_AjaxRequest.prototype.io$youi$ajax$AjaxRequest$$$anonfun$new$2__Lorg_scalajs_dom_raw_ProgressEvent__V = (function(evt) {
  var this$1 = $as_Lreactify_Var(this.total$1);
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, evt$1) {
    return (function() {
      return $uD(evt$1.total)
    })
  })(this, evt));
  this$1.set__F0__V(value);
  var this$3 = $as_Lreactify_Var(this.loaded$1);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, evt$2) {
    return (function() {
      return $uD(evt$2.loaded)
    })
  })(this, evt));
  this$3.set__F0__V(value$1);
  var x = (100 * ($uD(evt.loaded) / $uD(evt.total)));
  var x$1 = $uD($g.Math.floor(x));
  var this$8 = $m_sjsr_RuntimeLong$();
  var value$2 = $uD($g.Math.round(x$1));
  var lo = this$8.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I(value$2);
  var this$9 = $as_Lreactify_Var(this.percentage$1);
  var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, p) {
    return (function() {
      return p
    })
  })(this, lo));
  this$9.set__F0__V(value$3)
});
$c_Lio_youi_ajax_AjaxRequest.prototype.init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T = (function(url, data, timeout, headers, withCredentials, responseType) {
  this.data$1 = data;
  this.req$1 = new $g.XMLHttpRequest();
  this.promise$1 = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })(this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.loaded$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      return 0.0
    })
  })(this));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.total$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      return 0
    })
  })(this));
  var mode$2 = $m_Lreactify_Var$Mode$Normal$();
  var name$2 = $m_s_None$();
  this.percentage$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$2, name$2);
  var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1) {
    return (function() {
      return false
    })
  })(this));
  var mode$3 = $m_Lreactify_Var$Mode$Normal$();
  var name$3 = $m_s_None$();
  this.cancelled$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$3, mode$3, name$3);
  this.req$1.onreadystatechange = (function(arg$outer) {
    return (function(arg1$2) {
      return arg$outer.io$youi$ajax$AjaxRequest$$$anonfun$new$1__Lorg_scalajs_dom_raw_Event__O(arg1$2)
    })
  })(this);
  var qual$1 = this.req$1.upload;
  var x$3 = (function(arg$outer$1) {
    return (function(arg1$2$1) {
      arg$outer$1.io$youi$ajax$AjaxRequest$$$anonfun$new$2__Lorg_scalajs_dom_raw_ProgressEvent__V(arg1$2$1)
    })
  })(this);
  qual$1.addEventListener("progress", x$3);
  this.req$1.open("POST", url.encoded__Lio_youi_net_URL$URLParts().asString__T());
  this.req$1.responseType = responseType;
  this.req$1.timeout = timeout;
  this.req$1.withCredentials = withCredentials;
  headers.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$5$1) {
    return (function(x$4) {
      var x = $as_T2(x$4);
      this$5$1.req$1.setRequestHeader($as_T(x.$$und1__O()), $as_T(x.$$und2__O()))
    })
  })(this)));
  return this
});
var $d_Lio_youi_ajax_AjaxRequest = new $TypeData().initClass({
  Lio_youi_ajax_AjaxRequest: 0
}, false, "io.youi.ajax.AjaxRequest", {
  Lio_youi_ajax_AjaxRequest: 1,
  O: 1
});
$c_Lio_youi_ajax_AjaxRequest.prototype.$classData = $d_Lio_youi_ajax_AjaxRequest;
/** @constructor */
function $c_Lio_youi_app_ApplicationConnectivity() {
  $c_O.call(this);
  this.application$1 = null;
  this.path$1 = null;
  this.autoConnect$1 = false;
  this.activeConnections$1 = null;
  this.connections$1 = null;
  this.communicationManagers$1 = null
}
$c_Lio_youi_app_ApplicationConnectivity.prototype = new $h_O();
$c_Lio_youi_app_ApplicationConnectivity.prototype.constructor = $c_Lio_youi_app_ApplicationConnectivity;
/** @constructor */
function $h_Lio_youi_app_ApplicationConnectivity() {
  /*<skip>*/
}
$h_Lio_youi_app_ApplicationConnectivity.prototype = $c_Lio_youi_app_ApplicationConnectivity.prototype;
$c_Lio_youi_app_ApplicationConnectivity.prototype.registerCommunicationManager__Lio_youi_app_CommunicationManager__V = (function(communicationManager) {
  var this$2 = $as_Lreactify_Var(this.communicationManagers$1);
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, communicationManager$1) {
    return (function() {
      var this$1 = $this.communicationManagers$1;
      return $as_sci_Set($as_sc_SetLike(this$1.state__Lreactify_State().value__O()).$$plus__O__sc_Set(communicationManager$1))
    })
  })(this, communicationManager));
  this$2.set__F0__V(value)
});
$c_Lio_youi_app_ApplicationConnectivity.prototype.init___Lio_youi_app_YouIApplication__T__Z = (function(application, path, autoConnect) {
  this.application$1 = application;
  this.path$1 = path;
  this.autoConnect$1 = autoConnect;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_sci_Set$EmptySet$()
    })
  })(this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.activeConnections$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      var v = this$2$1.activeConnections$1;
      return $as_sci_Set(v.state__Lreactify_State().value__O())
    })
  })(this));
  var name$1 = $m_s_None$();
  this.connections$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      return $m_sci_Set$EmptySet$()
    })
  })(this));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$2 = $m_s_None$();
  this.communicationManagers$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$1, name$2);
  if ((application === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  var this$12 = application.connectivityEntries$1;
  var entries = $as_sci_Set(this$12.state__Lreactify_State().value__O());
  var this$13 = application.connectivityEntries$1;
  var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, entries$1) {
    return (function() {
      return $as_sci_Set(entries$1.$$plus__O__sc_Set(this$4$1))
    })
  })(this, entries));
  this$13.set__F0__V(value$3);
  return this
});
function $is_Lio_youi_app_ApplicationConnectivity(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_ApplicationConnectivity)))
}
function $as_Lio_youi_app_ApplicationConnectivity(obj) {
  return (($is_Lio_youi_app_ApplicationConnectivity(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.ApplicationConnectivity"))
}
function $isArrayOf_Lio_youi_app_ApplicationConnectivity(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_ApplicationConnectivity)))
}
function $asArrayOf_Lio_youi_app_ApplicationConnectivity(obj, depth) {
  return (($isArrayOf_Lio_youi_app_ApplicationConnectivity(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.ApplicationConnectivity;", depth))
}
var $d_Lio_youi_app_ApplicationConnectivity = new $TypeData().initClass({
  Lio_youi_app_ApplicationConnectivity: 0
}, false, "io.youi.app.ApplicationConnectivity", {
  Lio_youi_app_ApplicationConnectivity: 1,
  O: 1
});
$c_Lio_youi_app_ApplicationConnectivity.prototype.$classData = $d_Lio_youi_app_ApplicationConnectivity;
/** @constructor */
function $c_Lio_youi_app_ClientApplication$() {
  $c_O.call(this);
  this.logWriter$1 = null;
  this.io$youi$app$ClientApplication$$instance$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_app_ClientApplication$.prototype = new $h_O();
$c_Lio_youi_app_ClientApplication$.prototype.constructor = $c_Lio_youi_app_ClientApplication$;
/** @constructor */
function $h_Lio_youi_app_ClientApplication$() {
  /*<skip>*/
}
$h_Lio_youi_app_ClientApplication$.prototype = $c_Lio_youi_app_ClientApplication$.prototype;
$c_Lio_youi_app_ClientApplication$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_app_ClientApplication$.prototype.logWriter$lzycompute__p1__Lscribe_writer_Writer = (function() {
  if ((!this.bitmap$0$1)) {
    this.logWriter$1 = new $c_Lio_youi_app_ClientApplication$$anon$15().init___();
    this.bitmap$0$1 = true
  };
  return this.logWriter$1
});
$c_Lio_youi_app_ClientApplication$.prototype.sendLog__Lio_youi_JavaScriptLog__s_concurrent_Future = (function(log) {
  var formData = new $g.FormData();
  var customConfig = $m_Lio_circe_generic_extras_Configuration$().default$1.withDefaults__Lio_circe_generic_extras_Configuration();
  $m_Lio_circe_Encoder$();
  var inst$macro$186 = new $c_Lio_youi_app_ClientApplication$anon$importedEncoder$macro$185$1().init___Lio_circe_generic_extras_Configuration(customConfig).inst$macro$175__Lio_circe_generic_extras_encoding_ConfiguredObjectEncoder();
  var t = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, inst$macro$186$1) {
    return (function() {
      return inst$macro$186$1
    })
  })(this, inst$macro$186));
  var lv = new $c_Lshapeless_Lazy$$anon$1().init___F0(t);
  var exported = $as_Lio_circe_ObjectEncoder(lv.value__O());
  var this$5 = $f_Lio_circe_ObjectEncoder__apply__O__Lio_circe_Json(exported, log);
  var p = $m_Lio_circe_Printer$().noSpaces$1;
  var jsonString = p.pretty__Lio_circe_Json__T(this$5);
  formData.append("message", jsonString);
  var this$8 = $m_Lio_youi_History$().url$1;
  var request = new $c_Lio_youi_ajax_AjaxRequest().init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T($as_Lio_youi_net_URL(this$8.state__Lreactify_State().value__O()).replacePathAndParams__T__Lio_youi_net_URL(this.io$youi$app$ClientApplication$$instance$1.logPath$1), new $c_s_Some().init___O(formData), 0, $m_sci_Map$EmptyMap$(), true, "");
  return request.send__s_concurrent_Future()
});
$c_Lio_youi_app_ClientApplication$.prototype.logWriter__Lscribe_writer_Writer = (function() {
  return ((!this.bitmap$0$1) ? this.logWriter$lzycompute__p1__Lscribe_writer_Writer() : this.logWriter$1)
});
$c_Lio_youi_app_ClientApplication$.prototype.sendError__jl_Throwable__s_concurrent_Future = (function(throwable) {
  return $m_Lio_youi_app_sourceMap_ErrorTrace$().toError__jl_Throwable__s_concurrent_Future(throwable).flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(error$2) {
      var error = $as_Lio_youi_JavaScriptError(error$2);
      return $m_Lio_youi_app_ClientApplication$().sendError__Lio_youi_JavaScriptError__s_concurrent_Future(error)
    })
  })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
$c_Lio_youi_app_ClientApplication$.prototype.sendError__Lorg_scalajs_dom_raw_ErrorEvent__s_concurrent_Future = (function(event) {
  return $m_Lio_youi_app_sourceMap_ErrorTrace$().toError__Lorg_scalajs_dom_raw_ErrorEvent__s_concurrent_Future(event).flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(error$2) {
      var error = $as_Lio_youi_JavaScriptError(error$2);
      return $m_Lio_youi_app_ClientApplication$().sendError__Lio_youi_JavaScriptError__s_concurrent_Future(error)
    })
  })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
$c_Lio_youi_app_ClientApplication$.prototype.sendError__Lio_youi_JavaScriptError__s_concurrent_Future = (function(error) {
  var formData = new $g.FormData();
  var customConfig = $m_Lio_circe_generic_extras_Configuration$().default$1.withDefaults__Lio_circe_generic_extras_Configuration();
  $m_Lio_circe_Encoder$();
  var inst$macro$174 = new $c_Lio_youi_app_ClientApplication$anon$importedEncoder$macro$173$1().init___Lio_circe_generic_extras_Configuration(customConfig).inst$macro$1__Lio_circe_generic_extras_encoding_ConfiguredObjectEncoder();
  var t = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, inst$macro$174$1) {
    return (function() {
      return inst$macro$174$1
    })
  })(this, inst$macro$174));
  var lv = new $c_Lshapeless_Lazy$$anon$1().init___F0(t);
  var exported = $as_Lio_circe_ObjectEncoder(lv.value__O());
  var this$5 = $f_Lio_circe_ObjectEncoder__apply__O__Lio_circe_Json(exported, error);
  var p = $m_Lio_circe_Printer$().noSpaces$1;
  var jsonString = p.pretty__Lio_circe_Json__T(this$5);
  formData.append("error", jsonString);
  var this$8 = $m_Lio_youi_History$().url$1;
  var request = new $c_Lio_youi_ajax_AjaxRequest().init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T($as_Lio_youi_net_URL(this$8.state__Lreactify_State().value__O()).replacePathAndParams__T__Lio_youi_net_URL(this.io$youi$app$ClientApplication$$instance$1.logPath$1), new $c_s_Some().init___O(formData), 0, $m_sci_Map$EmptyMap$(), true, "");
  return request.send__s_concurrent_Future()
});
var $d_Lio_youi_app_ClientApplication$ = new $TypeData().initClass({
  Lio_youi_app_ClientApplication$: 0
}, false, "io.youi.app.ClientApplication$", {
  Lio_youi_app_ClientApplication$: 1,
  O: 1
});
$c_Lio_youi_app_ClientApplication$.prototype.$classData = $d_Lio_youi_app_ClientApplication$;
var $n_Lio_youi_app_ClientApplication$ = (void 0);
function $m_Lio_youi_app_ClientApplication$() {
  if ((!$n_Lio_youi_app_ClientApplication$)) {
    $n_Lio_youi_app_ClientApplication$ = new $c_Lio_youi_app_ClientApplication$().init___()
  };
  return $n_Lio_youi_app_ClientApplication$
}
/** @constructor */
function $c_Lio_youi_app_ClientConnectivity() {
  $c_O.call(this);
  this.connectivity$1 = null;
  this.application$1 = null;
  this.connection$1 = null;
  this.webSocket$1 = null
}
$c_Lio_youi_app_ClientConnectivity.prototype = new $h_O();
$c_Lio_youi_app_ClientConnectivity.prototype.constructor = $c_Lio_youi_app_ClientConnectivity;
/** @constructor */
function $h_Lio_youi_app_ClientConnectivity() {
  /*<skip>*/
}
$h_Lio_youi_app_ClientConnectivity.prototype = $c_Lio_youi_app_ClientConnectivity.prototype;
$c_Lio_youi_app_ClientConnectivity.prototype.init___Lio_youi_app_ApplicationConnectivity__Lio_youi_app_ClientApplication = (function(connectivity, application) {
  this.connectivity$1 = connectivity;
  this.application$1 = application;
  this.connection$1 = new $c_Lio_youi_http_Connection().init___();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_s_None$()
    })
  })(this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.webSocket$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var this$6 = this.connection$1.receive$1.text$1;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(x0$1$2) {
      var x0$1 = $as_T(x0$1$2);
      if ((x0$1 === "PING")) {
        var this$4 = this$2$1.connection$1.send$1.text$1;
        var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
          return (function() {
            return "PONG"
          })
        })(this$2$1));
        this$4.set__F0__V(value$1)
      }
    })
  })(this));
  var priority = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$6, f, priority);
  if (connectivity.autoConnect$1) {
    this.connect__V()
  };
  var this$9 = this.connection$1.connected$1;
  var f$1 = new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function(this$3$1) {
    return (function(x0$2$2, x1$1$2) {
      var x0$2 = $uZ(x0$2$2);
      var x1$1 = $uZ(x1$1$2);
      if ((x0$2 && (!x1$1))) {
        this$3$1.attemptReload__p1__I__V(0)
      }
    })
  })(this));
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__changes__F2__D__Lreactify_reaction_Reaction(this$9, f$1, priority$1);
  return this
});
$c_Lio_youi_app_ClientConnectivity.prototype.io$youi$app$ClientConnectivity$$$anonfun$attemptReload$2__I__O = (function(attempt$1) {
  this.attemptReload__p1__I__V(((1 + attempt$1) | 0))
});
$c_Lio_youi_app_ClientConnectivity.prototype.attemptReload__p1__I__V = (function(attempt) {
  var jsx$1 = $m_Lio_youi_stream_StreamURL$();
  var this$1 = $m_Lio_youi_History$().url$1;
  jsx$1.stream__Lio_youi_net_URL__s_Option__I__sci_Map__Z__T__s_concurrent_Future($as_Lio_youi_net_URL(this$1.state__Lreactify_State().value__O()), $m_s_None$(), 0, $m_sci_Map$EmptyMap$(), true, "").onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, attempt$1) {
    return (function(x0$3$2) {
      var x0$3 = $as_s_util_Try(x0$3$2);
      if ($is_s_util_Success(x0$3)) {
        $m_Lio_youi_History$().reload__Z__V(true);
        return (void 0)
      } else if ($is_s_util_Failure(x0$3)) {
        var x4 = $as_s_util_Failure(x0$3);
        var exception = x4.exception$2;
        if ($is_Lorg_scalajs_dom_ext_AjaxException(exception)) {
          var x2 = $as_Lorg_scalajs_dom_ext_AjaxException(exception);
          if (($uI(x2.xhr$3.status) > 0)) {
            $m_Lio_youi_History$().reload__Z__V(true);
            return (void 0)
          }
        };
        var timeout = ((attempt$1 < 10) ? 2500 : ((attempt$1 < 25) ? 5000 : ((attempt$1 < 100) ? 10000 : 30000)));
        return $uI($m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().setTimeout((function(arg$outer, attempt$1$1) {
          return (function() {
            return arg$outer.io$youi$app$ClientConnectivity$$$anonfun$attemptReload$2__I__O(attempt$1$1)
          })
        })($this, attempt$1), timeout))
      } else {
        throw new $c_s_MatchError().init___O(x0$3)
      }
    })
  })(this, attempt)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
$c_Lio_youi_app_ClientConnectivity.prototype.connect__V = (function() {
  var this$4 = this.connectivity$1.activeConnections$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var array = [$this.connection$1];
      if (($uI(array.length) === 0)) {
        var jsx$1 = $m_sci_Set$EmptySet$()
      } else {
        var b = new $c_scm_SetBuilder().init___sc_Set($m_sci_Set$EmptySet$());
        var i = 0;
        var len = $uI(array.length);
        while ((i < len)) {
          var index = i;
          var arg1 = array[index];
          b.$$plus$eq__O__scm_SetBuilder(arg1);
          i = ((1 + i) | 0)
        };
        var jsx$1 = b.elems$1
      };
      return $as_sci_Set(jsx$1)
    })
  })(this));
  this$4.set__F0__V(value);
  this.disconnect__V();
  var protocol = (($as_T($m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.protocol) === "https:") ? "wss" : "ws");
  var this$5 = $m_Lio_youi_net_URL$();
  var url = (((protocol + "://") + $as_T($m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.host)) + this.connectivity$1.path$1);
  var url$1 = this$5.apply__T__Z__Lio_youi_net_URL(url, true);
  var this$6 = this.webSocket$1;
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, url$2) {
    return (function() {
      return new $c_s_Some().init___O($m_Lio_youi_http_WebSocketUtil$().connect__Lio_youi_net_URL__Lio_youi_http_Connection__Lorg_scalajs_dom_raw_WebSocket(url$2, this$2$1.connection$1))
    })
  })(this, url$1));
  this$6.set__F0__V(value$1)
});
$c_Lio_youi_app_ClientConnectivity.prototype.disconnect__V = (function() {
  var this$1 = this.webSocket$1;
  var this$2 = $as_s_Option(this$1.state__Lreactify_State().value__O());
  if ((!this$2.isEmpty__Z())) {
    var arg1 = this$2.get__O();
    if (($uI(arg1.readyState) === $uI($m_Lorg_scalajs_dom_package$().WebSocket__Lorg_scalajs_dom_raw_WebSocket$().OPEN))) {
      arg1.close()
    };
    var this$3 = this.webSocket$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_s_None$()
      })
    })(this));
    this$3.set__F0__V(value)
  }
});
function $is_Lio_youi_app_ClientConnectivity(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_ClientConnectivity)))
}
function $as_Lio_youi_app_ClientConnectivity(obj) {
  return (($is_Lio_youi_app_ClientConnectivity(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.ClientConnectivity"))
}
function $isArrayOf_Lio_youi_app_ClientConnectivity(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_ClientConnectivity)))
}
function $asArrayOf_Lio_youi_app_ClientConnectivity(obj, depth) {
  return (($isArrayOf_Lio_youi_app_ClientConnectivity(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.ClientConnectivity;", depth))
}
var $d_Lio_youi_app_ClientConnectivity = new $TypeData().initClass({
  Lio_youi_app_ClientConnectivity: 0
}, false, "io.youi.app.ClientConnectivity", {
  Lio_youi_app_ClientConnectivity: 1,
  O: 1
});
$c_Lio_youi_app_ClientConnectivity.prototype.$classData = $d_Lio_youi_app_ClientConnectivity;
/** @constructor */
function $c_Lio_youi_app_CommunicationManager() {
  $c_O.call(this);
  this.connectivity$1 = null;
  this.create$1 = null;
  this.id$1 = 0;
  this.instances$1 = null
}
$c_Lio_youi_app_CommunicationManager.prototype = new $h_O();
$c_Lio_youi_app_CommunicationManager.prototype.constructor = $c_Lio_youi_app_CommunicationManager;
/** @constructor */
function $h_Lio_youi_app_CommunicationManager() {
  /*<skip>*/
}
$h_Lio_youi_app_CommunicationManager.prototype = $c_Lio_youi_app_CommunicationManager.prototype;
$c_Lio_youi_app_CommunicationManager.prototype.byConnection__Lio_youi_http_Connection__s_Option = (function(connection) {
  var v = this.instances$1;
  return $as_sc_IterableLike(v.state__Lreactify_State().value__O()).find__F1__s_Option(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, connection$1) {
    return (function(x$1$2) {
      var x$1 = $as_Lio_youi_communication_Communication(x$1$2);
      return (x$1.connection__Lio_youi_http_Connection() === connection$1)
    })
  })(this, connection)))
});
$c_Lio_youi_app_CommunicationManager.prototype.init___Lio_youi_app_ApplicationConnectivity__F1 = (function(connectivity, create) {
  this.connectivity$1 = connectivity;
  this.create$1 = create;
  var this$1 = $m_Lio_youi_app_CommunicationManager$().io$youi$app$CommunicationManager$$increment$1;
  var old = this$1.java$util$concurrent$atomic$AtomicInteger$$value$f;
  this$1.java$util$concurrent$atomic$AtomicInteger$$value$f = ((1 + old) | 0);
  this.id$1 = old;
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var this$2 = $this.connectivity$1.connections$1;
      var this$5 = $as_sc_SetLike(this$2.state__Lreactify_State().value__O());
      var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
        return (function(connection$2) {
          var connection = $as_Lio_youi_http_Connection(connection$2);
          var this$3 = connection.store$1;
          var key = ("communicationManager" + $this$1.id$1);
          var x1 = this$3.map$1.get__O__s_Option(key);
          if ($is_s_Some(x1)) {
            var x2 = $as_s_Some(x1);
            var value = x2.value$2;
            var jsx$1 = value
          } else {
            var x = $m_s_None$();
            if ((!(x === x1))) {
              throw new $c_s_MatchError().init___O(x1)
            };
            var value$2 = $as_Lio_youi_communication_Communication($this$1.create$1.apply__O__O(connection));
            this$3.update__T__O__V(key, value$2);
            var jsx$1 = value$2
          };
          return $as_Lio_youi_communication_Communication(jsx$1)
        })
      })($this));
      var this$4 = $m_sci_Set$();
      var bf = new $c_scg_GenSetFactory$$anon$1().init___scg_GenSetFactory(this$4);
      return $as_sci_Set($f_sc_TraversableLike__map__F1__scg_CanBuildFrom__O(this$5, f, bf))
    })
  })(this));
  var name = $m_s_None$();
  this.instances$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name);
  connectivity.registerCommunicationManager__Lio_youi_app_CommunicationManager__V(this);
  return this
});
$c_Lio_youi_app_CommunicationManager.prototype.apply__Lio_youi_http_Connection__Lio_youi_communication_Communication = (function(connection) {
  var this$1 = this.byConnection__Lio_youi_http_Connection__s_Option(connection);
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("No CommunicationManager found for connection!"))
  };
  return $as_Lio_youi_communication_Communication(this$1.get__O())
});
var $d_Lio_youi_app_CommunicationManager = new $TypeData().initClass({
  Lio_youi_app_CommunicationManager: 0
}, false, "io.youi.app.CommunicationManager", {
  Lio_youi_app_CommunicationManager: 1,
  O: 1
});
$c_Lio_youi_app_CommunicationManager.prototype.$classData = $d_Lio_youi_app_CommunicationManager;
/** @constructor */
function $c_Lio_youi_app_CommunicationManager$() {
  $c_O.call(this);
  this.io$youi$app$CommunicationManager$$increment$1 = null
}
$c_Lio_youi_app_CommunicationManager$.prototype = new $h_O();
$c_Lio_youi_app_CommunicationManager$.prototype.constructor = $c_Lio_youi_app_CommunicationManager$;
/** @constructor */
function $h_Lio_youi_app_CommunicationManager$() {
  /*<skip>*/
}
$h_Lio_youi_app_CommunicationManager$.prototype = $c_Lio_youi_app_CommunicationManager$.prototype;
$c_Lio_youi_app_CommunicationManager$.prototype.init___ = (function() {
  $n_Lio_youi_app_CommunicationManager$ = this;
  this.io$youi$app$CommunicationManager$$increment$1 = new $c_ju_concurrent_atomic_AtomicInteger().init___I(0);
  return this
});
var $d_Lio_youi_app_CommunicationManager$ = new $TypeData().initClass({
  Lio_youi_app_CommunicationManager$: 0
}, false, "io.youi.app.CommunicationManager$", {
  Lio_youi_app_CommunicationManager$: 1,
  O: 1
});
$c_Lio_youi_app_CommunicationManager$.prototype.$classData = $d_Lio_youi_app_CommunicationManager$;
var $n_Lio_youi_app_CommunicationManager$ = (void 0);
function $m_Lio_youi_app_CommunicationManager$() {
  if ((!$n_Lio_youi_app_CommunicationManager$)) {
    $n_Lio_youi_app_CommunicationManager$ = new $c_Lio_youi_app_CommunicationManager$().init___()
  };
  return $n_Lio_youi_app_CommunicationManager$
}
/** @constructor */
function $c_Lio_youi_app_YouIApplication$() {
  $c_O.call(this);
  this.io$youi$app$YouIApplication$$instance$1 = null
}
$c_Lio_youi_app_YouIApplication$.prototype = new $h_O();
$c_Lio_youi_app_YouIApplication$.prototype.constructor = $c_Lio_youi_app_YouIApplication$;
/** @constructor */
function $h_Lio_youi_app_YouIApplication$() {
  /*<skip>*/
}
$h_Lio_youi_app_YouIApplication$.prototype = $c_Lio_youi_app_YouIApplication$.prototype;
$c_Lio_youi_app_YouIApplication$.prototype.init___ = (function() {
  $n_Lio_youi_app_YouIApplication$ = this;
  this.io$youi$app$YouIApplication$$instance$1 = $m_s_None$();
  return this
});
$c_Lio_youi_app_YouIApplication$.prototype.apply__Lio_youi_app_YouIApplication = (function() {
  var this$1 = this.io$youi$app$YouIApplication$$instance$1;
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("No YouIApplication is initialized!"))
  };
  return $as_Lio_youi_app_YouIApplication(this$1.get__O())
});
var $d_Lio_youi_app_YouIApplication$ = new $TypeData().initClass({
  Lio_youi_app_YouIApplication$: 0
}, false, "io.youi.app.YouIApplication$", {
  Lio_youi_app_YouIApplication$: 1,
  O: 1
});
$c_Lio_youi_app_YouIApplication$.prototype.$classData = $d_Lio_youi_app_YouIApplication$;
var $n_Lio_youi_app_YouIApplication$ = (void 0);
function $m_Lio_youi_app_YouIApplication$() {
  if ((!$n_Lio_youi_app_YouIApplication$)) {
    $n_Lio_youi_app_YouIApplication$ = new $c_Lio_youi_app_YouIApplication$().init___()
  };
  return $n_Lio_youi_app_YouIApplication$
}
function $f_Lio_youi_app_screen_LoadingTransitionSupport__afterScreenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, oldScreen, newScreen) {
  return $m_s_concurrent_Future$().apply__F0__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $this.loadingElement$1.classList.add("hidden")
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $f_Lio_youi_app_screen_LoadingTransitionSupport__beforeScreenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, oldScreen, newScreen) {
  return $m_s_concurrent_Future$().apply__F0__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $this.loadingElement$1.classList.remove("hidden")
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
/** @constructor */
function $c_Lio_youi_app_screen_ScreenManager$() {
  $c_O.call(this);
  this.io$youi$app$screen$ScreenManager$$instance$1 = null
}
$c_Lio_youi_app_screen_ScreenManager$.prototype = new $h_O();
$c_Lio_youi_app_screen_ScreenManager$.prototype.constructor = $c_Lio_youi_app_screen_ScreenManager$;
/** @constructor */
function $h_Lio_youi_app_screen_ScreenManager$() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_ScreenManager$.prototype = $c_Lio_youi_app_screen_ScreenManager$.prototype;
$c_Lio_youi_app_screen_ScreenManager$.prototype.init___ = (function() {
  $n_Lio_youi_app_screen_ScreenManager$ = this;
  this.io$youi$app$screen$ScreenManager$$instance$1 = $m_s_None$();
  return this
});
$c_Lio_youi_app_screen_ScreenManager$.prototype.apply__Lio_youi_app_screen_ScreenManager = (function() {
  var this$1 = this.io$youi$app$screen$ScreenManager$$instance$1;
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("No ScreenManager is initialized!"))
  };
  return $as_Lio_youi_app_screen_ScreenManager(this$1.get__O())
});
var $d_Lio_youi_app_screen_ScreenManager$ = new $TypeData().initClass({
  Lio_youi_app_screen_ScreenManager$: 0
}, false, "io.youi.app.screen.ScreenManager$", {
  Lio_youi_app_screen_ScreenManager$: 1,
  O: 1
});
$c_Lio_youi_app_screen_ScreenManager$.prototype.$classData = $d_Lio_youi_app_screen_ScreenManager$;
var $n_Lio_youi_app_screen_ScreenManager$ = (void 0);
function $m_Lio_youi_app_screen_ScreenManager$() {
  if ((!$n_Lio_youi_app_screen_ScreenManager$)) {
    $n_Lio_youi_app_screen_ScreenManager$ = new $c_Lio_youi_app_screen_ScreenManager$().init___()
  };
  return $n_Lio_youi_app_screen_ScreenManager$
}
/** @constructor */
function $c_Lio_youi_app_screen_ScreenState() {
  $c_O.call(this);
  this.index$1 = 0;
  this.working$1 = false
}
$c_Lio_youi_app_screen_ScreenState.prototype = new $h_O();
$c_Lio_youi_app_screen_ScreenState.prototype.constructor = $c_Lio_youi_app_screen_ScreenState;
/** @constructor */
function $h_Lio_youi_app_screen_ScreenState() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_ScreenState.prototype = $c_Lio_youi_app_screen_ScreenState.prototype;
$c_Lio_youi_app_screen_ScreenState.prototype.init___I__Z = (function(index, working) {
  this.index$1 = index;
  this.working$1 = working;
  return this
});
function $is_Lio_youi_app_screen_ScreenState(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_screen_ScreenState)))
}
function $as_Lio_youi_app_screen_ScreenState(obj) {
  return (($is_Lio_youi_app_screen_ScreenState(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.screen.ScreenState"))
}
function $isArrayOf_Lio_youi_app_screen_ScreenState(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_screen_ScreenState)))
}
function $asArrayOf_Lio_youi_app_screen_ScreenState(obj, depth) {
  return (($isArrayOf_Lio_youi_app_screen_ScreenState(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.screen.ScreenState;", depth))
}
function $f_Lio_youi_app_screen_URLActivation__activate__s_concurrent_Future($thiz) {
  return $f_Lio_youi_app_screen_Screen__activate__s_concurrent_Future($thiz).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      $asUnit(x$1$2);
      var this$1 = $m_Lio_youi_History$().url$1;
      var currentURL = $as_Lio_youi_net_URL(this$1.state__Lreactify_State().value__O());
      var this$2 = $f_Lio_youi_app_screen_PathActivation__updateURL__Lio_youi_net_URL__s_Option($this, currentURL);
      if ((!this$2.isEmpty__Z())) {
        var arg1 = this$2.get__O();
        var change = $as_Lio_youi_HistoryStateChange(arg1);
        $m_Lio_youi_History$().update__Lio_youi_HistoryStateChange__V(change)
      }
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $f_Lio_youi_app_screen_URLActivation__$$init$__V($thiz) {
  var this$2 = $m_Lio_youi_History$().url$1;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(url$2) {
      var url = $as_Lio_youi_net_URL(url$2);
      $f_Lio_youi_app_screen_URLActivation__validateURL__pLio_youi_app_screen_URLActivation__Lio_youi_net_URL__V($this, url)
    })
  })($thiz));
  $m_Lio_youi_History$();
  var priority = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$2, f, priority);
  var this$3 = $m_Lio_youi_History$().url$1;
  var url$1 = $as_Lio_youi_net_URL(this$3.state__Lreactify_State().value__O());
  $f_Lio_youi_app_screen_URLActivation__validateURL__pLio_youi_app_screen_URLActivation__Lio_youi_net_URL__V($thiz, url$1)
}
function $f_Lio_youi_app_screen_URLActivation__validateURL__pLio_youi_app_screen_URLActivation__Lio_youi_net_URL__V($thiz, url) {
  if ($thiz.matcher__Lio_youi_net_URLMatcher().matches__Lio_youi_net_URL__Z(url)) {
    var this$1 = $thiz.state__Lreactify_Val();
    var x = this$1.state__Lreactify_State().value__O();
    var x$2 = $m_Lio_youi_app_screen_ScreenState$Activated$();
    if ((!((x !== null) && $objectEquals(x, x$2)))) {
      var this$2 = $m_Lio_youi_app_screen_ScreenManager$().apply__Lio_youi_app_screen_ScreenManager().active$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
        return (function() {
          return $this
        })
      })($thiz));
      this$2.set__F0__V(value)
    }
  }
}
function $f_Lio_youi_communication_Communication__$$init$__V($thiz) {
  $thiz.io$youi$communication$Communication$$undsetter$und$comm$und$eq__Lio_youi_communication_CommunicationInternal__V(new $c_Lio_youi_communication_CommunicationInternal().init___Lio_youi_communication_Communication($thiz));
  $thiz.comm__Lio_youi_communication_CommunicationInternal().init__V()
}
function $is_Lio_youi_communication_Communication(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_communication_Communication)))
}
function $as_Lio_youi_communication_Communication(obj) {
  return (($is_Lio_youi_communication_Communication(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.communication.Communication"))
}
function $isArrayOf_Lio_youi_communication_Communication(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_communication_Communication)))
}
function $asArrayOf_Lio_youi_communication_Communication(obj, depth) {
  return (($isArrayOf_Lio_youi_communication_Communication(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.communication.Communication;", depth))
}
/** @constructor */
function $c_Lio_youi_communication_CommunicationInternal() {
  $c_O.call(this);
  this.communication$1 = null;
  this.increment$1 = null;
  this.queue$1 = null;
  this.endPoints$1 = null;
  this.send$1 = null;
  this.receive$1 = null
}
$c_Lio_youi_communication_CommunicationInternal.prototype = new $h_O();
$c_Lio_youi_communication_CommunicationInternal.prototype.constructor = $c_Lio_youi_communication_CommunicationInternal;
/** @constructor */
function $h_Lio_youi_communication_CommunicationInternal() {
  /*<skip>*/
}
$h_Lio_youi_communication_CommunicationInternal.prototype = $c_Lio_youi_communication_CommunicationInternal.prototype;
$c_Lio_youi_communication_CommunicationInternal.prototype.init___Lio_youi_communication_Communication = (function(communication) {
  this.communication$1 = communication;
  this.increment$1 = new $c_ju_concurrent_atomic_AtomicInteger().init___I(0);
  this.queue$1 = $m_sci_Map$EmptyMap$();
  this.endPoints$1 = $m_sci_Map$EmptyMap$();
  this.send$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  this.receive$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  return this
});
$c_Lio_youi_communication_CommunicationInternal.prototype.init__V = (function() {
  var this$22 = this.receive$1;
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(message$2) {
      var message = $as_Lio_youi_communication_CommunicationMessage(message$2);
      var jsx$1 = $m_Lscribe_package$();
      var level = $m_Lscribe_Level$Debug$();
      var value = $m_Lscribe_Level$Debug$().value$1;
      var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, message$1) {
        return (function() {
          return (("Received: " + message$1.messageType$1) + "...")
        })
      })($this, message));
      var loggable = $m_Lscribe_Loggable$StringLoggable$();
      var throwable = $m_s_None$();
      var methodName = new $c_s_Some().init___O("init");
      var line = new $c_s_Some().init___O(82);
      var column = new $c_s_Some().init___O(19);
      var thread = $m_jl_Thread$().SingleThread$1;
      var this$3 = $m_Lscribe_util_Time$();
      var this$4 = this$3.function$1;
      var t = $uJ(this$4.apply__O());
      var lo = t.lo$2;
      var hi = t.hi$2;
      jsx$1.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/communication/shared/src/main/scala/io/youi/communication/Communication.scala", "io.youi.communication.CommunicationInternal", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
      if ((message.messageType$1 === $m_Lio_youi_communication_CommunicationMessage$().MethodResponse$1)) {
        var f = $this.queue$1.get__O__s_Option(message.invocationId$1);
        $this.queue$1 = $as_sci_Map($this.queue$1.$$minus__O__sc_Map(message.invocationId$1));
        if ($is_s_Some(f)) {
          var x2 = $as_s_Some(f);
          var f$2 = $as_F1(x2.value$2);
          $asUnit(f$2.apply__O__O(message))
        } else {
          var x = $m_s_None$();
          if ((x === f)) {
            var jsx$5 = $m_Lscribe_package$();
            var level$1 = $m_Lscribe_Level$Debug$();
            var value$1 = $m_Lscribe_Level$Debug$().value$1;
            var messageFunction$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, message$3) {
              return (function() {
                var jsx$4 = message$3.endPoint$1;
                var jsx$3 = message$3.invocationId$1;
                var jsx$2 = message$3.content$1;
                var this$6 = this$2$1.queue$1;
                var this$7 = new $c_sci_MapLike$ImmutableDefaultKeySet().init___sci_MapLike(this$6);
                return (((((((("No entry found for endPoint: " + jsx$4) + ", invocationId: ") + jsx$3) + ", content: ") + jsx$2) + ", queue: ") + $f_sc_TraversableOnce__mkString__T__T__T__T(this$7, "", ", ", "")) + ".")
              })
            })($this, message));
            var loggable$1 = $m_Lscribe_Loggable$StringLoggable$();
            var throwable$1 = $m_s_None$();
            var methodName$1 = new $c_s_Some().init___O("init");
            var line$1 = new $c_s_Some().init___O(92);
            var column$1 = new $c_s_Some().init___O(25);
            var thread$1 = $m_jl_Thread$().SingleThread$1;
            var this$10 = $m_Lscribe_util_Time$();
            var this$11 = this$10.function$1;
            var t$1 = $uJ(this$11.apply__O());
            var lo$1 = t$1.lo$2;
            var hi$1 = t$1.hi$2;
            jsx$5.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level$1, value$1, messageFunction$1, loggable$1, throwable$1, "/home/mhicks/projects/open/youi/communication/shared/src/main/scala/io/youi/communication/Communication.scala", "io.youi.communication.CommunicationInternal", methodName$1, line$1, column$1, thread$1, new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1)))
          } else {
            throw new $c_s_MatchError().init___O(f)
          }
        }
      } else if ((message.messageType$1 === $m_Lio_youi_communication_CommunicationMessage$().MethodRequest$1)) {
        var this$13 = $this.endPoints$1.get__O__s_Option(message.endPoint$1);
        if ((!this$13.isEmpty__Z())) {
          var arg1 = this$13.get__O();
          var endPoint = $as_F1(arg1);
          $as_s_concurrent_Future(endPoint.apply__O__O(message)).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$2, message$2$1) {
            return (function(content$2) {
              var content = $as_T(content$2);
              var this$18 = $this$2.send$1;
              var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$3, message$2$2, content$1) {
                return (function() {
                  var jsx$8 = $m_Lio_youi_communication_CommunicationMessage$().MethodResponse$1;
                  var jsx$7 = message$2$2.endPoint$1;
                  var jsx$6 = message$2$2.invocationId$1;
                  $m_sci_List$();
                  var array = [content$1];
                  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
                  var this$17 = $m_sci_List$();
                  var cbf = this$17.ReusableCBFInstance$2;
                  return new $c_Lio_youi_communication_CommunicationMessage().init___I__T__I__sci_List__s_Option(jsx$8, jsx$7, jsx$6, $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)), $m_s_None$())
                })
              })($this$2, message$2$1, content));
              this$18.set__F0__V(value$2)
            })
          })($this, message)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext()).failed__s_concurrent_Future().foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$2, message$2$3) {
            return (function(t$2) {
              var t$3 = $as_jl_Throwable(t$2);
              var this$19 = this$2$2.send$1;
              var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$4, message$2$4, t$4) {
                return (function() {
                  return new $c_Lio_youi_communication_CommunicationMessage().init___I__T__I__sci_List__s_Option($m_Lio_youi_communication_CommunicationMessage$().MethodResponse$1, message$2$4.endPoint$1, message$2$4.invocationId$1, $m_sci_Nil$(), new $c_s_Some().init___O(t$4.getMessage__T()))
                })
              })(this$2$2, message$2$3, t$3));
              this$19.set__F0__V(value$3);
              var this$20 = this$2$2.communication$1;
              $f_Lio_youi_ErrorSupport__error__jl_Throwable__V(this$20, t$3)
            })
          })($this, message)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
        }
      }
    })
  })(this));
  var priority = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$22, f$1, priority);
  var qual$1 = this.communication$1.connection__Lio_youi_http_Connection().receive$1.text$1;
  var x$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$3) {
    return (function(x0$1$2) {
      var x0$1 = $as_T(x0$1$2);
      matchEnd4: {
        var o7 = $m_Lio_youi_communication_CommunicationMessage$().unapply__T__s_Option(x0$1);
        if ((!o7.isEmpty__Z())) {
          var message$4 = $as_Lio_youi_communication_CommunicationMessage(o7.get__O());
          var this$23 = this$2$3.receive$1;
          var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$5, message$5) {
            return (function() {
              return message$5
            })
          })(this$2$3, message$4));
          this$23.set__F0__V(value$4);
          break matchEnd4
        }
      }
    })
  })(this));
  var x$3 = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(qual$1, x$2, x$3);
  var this$26 = this.send$1;
  var f$3 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1) {
    return (function(message$3$2) {
      var message$3$1 = $as_Lio_youi_communication_CommunicationMessage(message$3$2);
      var this$24 = this$3$1.communication$1.connection__Lio_youi_http_Connection().send$1.text$1;
      var value$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$6, message$6) {
        return (function() {
          return message$6.parsableString__T()
        })
      })(this$3$1, message$3$1));
      this$24.set__F0__V(value$5)
    })
  })(this));
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$26, f$3, priority$1)
});
$c_Lio_youi_communication_CommunicationInternal.prototype.onEndPoint__T__F1__V = (function(endPoint, f) {
  this.endPoints$1 = this.endPoints$1.$$plus__T2__sci_Map(new $c_T2().init___O__O(endPoint, f))
});
$c_Lio_youi_communication_CommunicationInternal.prototype.onInvocation__I__F1__s_concurrent_Future = (function(invocationId, f) {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var handler = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, invocationId$1, f$1, promise$1) {
    return (function(m$2) {
      var m = $as_Lio_youi_communication_CommunicationMessage(m$2);
      var jsx$1 = $m_Lscribe_package$();
      var level = $m_Lscribe_Level$Debug$();
      var value = $m_Lscribe_Level$Debug$().value$1;
      var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, invocationId$1$1) {
        return (function() {
          return ("Received communication message for handler! " + invocationId$1$1)
        })
      })($this, invocationId$1));
      var loggable = $m_Lscribe_Loggable$StringLoggable$();
      var throwable = $m_s_None$();
      var methodName = $m_s_None$();
      var line = new $c_s_Some().init___O(127);
      var column = new $c_s_Some().init___O(19);
      var thread = $m_jl_Thread$().SingleThread$1;
      var this$4 = $m_Lscribe_util_Time$();
      var this$5 = this$4.function$1;
      var t = $uJ(this$5.apply__O());
      var lo = t.lo$2;
      var hi = t.hi$2;
      jsx$1.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/communication/shared/src/main/scala/io/youi/communication/Communication.scala", "io.youi.communication.CommunicationInternal.handler", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
      var x1 = m.error$1;
      if ($is_s_Some(x1)) {
        var x2 = $as_s_Some(x1);
        var error = $as_T(x2.value$2);
        var cause = new $c_Lio_youi_communication_CommunicationException().init___T(error);
        $f_s_concurrent_Promise__failure__jl_Throwable__s_concurrent_Promise(promise$1, cause)
      } else {
        var x = $m_s_None$();
        if ((x === x1)) {
          try {
            var value$1 = f$1.apply__O__O(m);
            $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$1, value$1)
          } catch (e) {
            var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
            if ((e$2 !== null)) {
              $f_s_concurrent_Promise__failure__jl_Throwable__s_concurrent_Promise(promise$1, e$2)
            } else {
              throw e
            }
          }
        } else {
          throw new $c_s_MatchError().init___O(x1)
        }
      }
    })
  })(this, invocationId, f, promise));
  var qual$2 = this.communication$1.connection__Lio_youi_http_Connection().connected$1;
  var x$4 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, promise$2) {
    return (function(b$2) {
      var b = $uZ(b$2);
      if (((!b) && (!promise$2.isCompleted__Z()))) {
        var cause$1 = new $c_jl_RuntimeException().init___T("Connection was closed");
        $f_s_concurrent_Promise__failure__jl_Throwable__s_concurrent_Promise(promise$2, cause$1)
      }
    })
  })(this, promise));
  var x$5 = $m_Lreactify_Priority$().Normal$1;
  var connectionMonitor = $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(qual$2, x$4, x$5);
  this.queue$1 = this.queue$1.$$plus__T2__sci_Map(new $c_T2().init___O__O(invocationId, handler));
  promise.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, connectionMonitor$1) {
    return (function(x$1$2) {
      $as_s_util_Try(x$1$2);
      return this$3$1.communication$1.connection__Lio_youi_http_Connection().connected$1.reactions__Lreactify_reaction_Reactions().$$minus$eq__Lreactify_reaction_Reaction__Z(connectionMonitor$1)
    })
  })(this, connectionMonitor)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
  return promise
});
var $d_Lio_youi_communication_CommunicationInternal = new $TypeData().initClass({
  Lio_youi_communication_CommunicationInternal: 0
}, false, "io.youi.communication.CommunicationInternal", {
  Lio_youi_communication_CommunicationInternal: 1,
  O: 1
});
$c_Lio_youi_communication_CommunicationInternal.prototype.$classData = $d_Lio_youi_communication_CommunicationInternal;
/** @constructor */
function $c_Lio_youi_component_Component$sibling$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_component_Component$sibling$.prototype = new $h_O();
$c_Lio_youi_component_Component$sibling$.prototype.constructor = $c_Lio_youi_component_Component$sibling$;
/** @constructor */
function $h_Lio_youi_component_Component$sibling$() {
  /*<skip>*/
}
$h_Lio_youi_component_Component$sibling$.prototype = $c_Lio_youi_component_Component$sibling$.prototype;
$c_Lio_youi_component_Component$sibling$.prototype.init___Lio_youi_component_Component = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_Component$sibling$.prototype.previous__s_Option = (function() {
  var this$1 = this.$$outer$1.parent__Lreactify_Var();
  var this$2 = $as_s_Option(this$1.state__Lreactify_State().value__O());
  if (this$2.isEmpty__Z()) {
    return $m_s_None$()
  } else {
    var arg1 = this$2.get__O();
    var p = $as_Lio_youi_component_Component(arg1);
    var children = p.childComponents__sci_Vector();
    var elem = this.$$outer$1;
    var index = $f_sc_GenSeqLike__indexOf__O__I__I(children, elem, 0);
    return ((index > 0) ? new $c_s_Some().init___O(children.apply__I__O((((-1) + index) | 0))) : $m_s_None$())
  }
});
var $d_Lio_youi_component_Component$sibling$ = new $TypeData().initClass({
  Lio_youi_component_Component$sibling$: 0
}, false, "io.youi.component.Component$sibling$", {
  Lio_youi_component_Component$sibling$: 1,
  O: 1
});
$c_Lio_youi_component_Component$sibling$.prototype.$classData = $d_Lio_youi_component_Component$sibling$;
/** @constructor */
function $c_Lio_youi_component_bootstrap_ButtonSize() {
  $c_O.call(this);
  this.io$youi$component$bootstrap$ButtonSize$$className$1 = null
}
$c_Lio_youi_component_bootstrap_ButtonSize.prototype = new $h_O();
$c_Lio_youi_component_bootstrap_ButtonSize.prototype.constructor = $c_Lio_youi_component_bootstrap_ButtonSize;
/** @constructor */
function $h_Lio_youi_component_bootstrap_ButtonSize() {
  /*<skip>*/
}
$h_Lio_youi_component_bootstrap_ButtonSize.prototype = $c_Lio_youi_component_bootstrap_ButtonSize.prototype;
$c_Lio_youi_component_bootstrap_ButtonSize.prototype.init___T = (function(key) {
  this.io$youi$component$bootstrap$ButtonSize$$className$1 = ("btn-" + key);
  return this
});
function $is_Lio_youi_component_bootstrap_ButtonSize(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_component_bootstrap_ButtonSize)))
}
function $as_Lio_youi_component_bootstrap_ButtonSize(obj) {
  return (($is_Lio_youi_component_bootstrap_ButtonSize(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.component.bootstrap.ButtonSize"))
}
function $isArrayOf_Lio_youi_component_bootstrap_ButtonSize(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_component_bootstrap_ButtonSize)))
}
function $asArrayOf_Lio_youi_component_bootstrap_ButtonSize(obj, depth) {
  return (($isArrayOf_Lio_youi_component_bootstrap_ButtonSize(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.component.bootstrap.ButtonSize;", depth))
}
/** @constructor */
function $c_Lio_youi_component_bootstrap_ButtonType() {
  $c_O.call(this);
  this.io$youi$component$bootstrap$ButtonType$$className$1 = null
}
$c_Lio_youi_component_bootstrap_ButtonType.prototype = new $h_O();
$c_Lio_youi_component_bootstrap_ButtonType.prototype.constructor = $c_Lio_youi_component_bootstrap_ButtonType;
/** @constructor */
function $h_Lio_youi_component_bootstrap_ButtonType() {
  /*<skip>*/
}
$h_Lio_youi_component_bootstrap_ButtonType.prototype = $c_Lio_youi_component_bootstrap_ButtonType.prototype;
$c_Lio_youi_component_bootstrap_ButtonType.prototype.init___T = (function(key) {
  this.io$youi$component$bootstrap$ButtonType$$className$1 = ("btn-" + key);
  return this
});
function $is_Lio_youi_component_bootstrap_ButtonType(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_component_bootstrap_ButtonType)))
}
function $as_Lio_youi_component_bootstrap_ButtonType(obj) {
  return (($is_Lio_youi_component_bootstrap_ButtonType(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.component.bootstrap.ButtonType"))
}
function $isArrayOf_Lio_youi_component_bootstrap_ButtonType(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_component_bootstrap_ButtonType)))
}
function $asArrayOf_Lio_youi_component_bootstrap_ButtonType(obj, depth) {
  return (($isArrayOf_Lio_youi_component_bootstrap_ButtonType(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.component.bootstrap.ButtonType;", depth))
}
function $f_Lio_youi_component_extras_ComponentPosition__z__Lreactify_Var($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $f_Lio_youi_component_extras_ComponentPosition__right__Lreactify_Dep($thiz) {
  var owner = $thiz.left__Lreactify_Var();
  var r2T = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$3$2) {
      var x$3 = $uD(x$3$2);
      var this$1 = $this.component$1;
      var v = this$1.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      return (x$3 + $uD(v.state__Lreactify_State().value__O()))
    })
  })($thiz));
  var t2R = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(x$4$2) {
      var x$4 = $uD(x$4$2);
      var this$3 = this$2$1.component$1;
      var v$1 = this$3.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      return (x$4 - $uD(v$1.state__Lreactify_State().value__O()))
    })
  })($thiz));
  return new $c_Lreactify_standard_StandardDep().init___s_Option__Lreactify_Var__F1__F1($m_s_None$(), owner, r2T, t2R)
}
function $f_Lio_youi_component_extras_ComponentPosition__y__Lreactify_Var($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $f_Lio_youi_component_extras_ComponentPosition__center__Lreactify_Dep($thiz) {
  var owner = $thiz.left__Lreactify_Var();
  var r2T = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      var x$1 = $uD(x$1$2);
      var this$1 = $this.component$1;
      var v = this$1.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      return (x$1 + ($uD(v.state__Lreactify_State().value__O()) / 2.0))
    })
  })($thiz));
  var t2R = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(x$2$2) {
      var x$2 = $uD(x$2$2);
      var this$3 = this$2$1.component$1;
      var v$1 = this$3.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      return (x$2 - ($uD(v$1.state__Lreactify_State().value__O()) / 2.0))
    })
  })($thiz));
  return new $c_Lreactify_standard_StandardDep().init___s_Option__Lreactify_Var__F1__F1($m_s_None$(), owner, r2T, t2R)
}
function $f_Lio_youi_component_extras_ComponentPosition__bottom__Lreactify_Dep($thiz) {
  var owner = $thiz.top__Lreactify_Var();
  var r2T = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$7$2) {
      var x$7 = $uD(x$7$2);
      var this$1 = $this.component$1;
      var v = this$1.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      return (x$7 + $uD(v.state__Lreactify_State().value__O()))
    })
  })($thiz));
  var t2R = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(x$8$2) {
      var x$8 = $uD(x$8$2);
      var this$3 = this$2$1.component$1;
      var v$1 = this$3.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      return (x$8 - $uD(v$1.state__Lreactify_State().value__O()))
    })
  })($thiz));
  return new $c_Lreactify_standard_StandardDep().init___s_Option__Lreactify_Var__F1__F1($m_s_None$(), owner, r2T, t2R)
}
function $f_Lio_youi_component_extras_ComponentPosition__x__Lreactify_Var($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $f_Lio_youi_component_extras_ComponentPosition__middle__Lreactify_Dep($thiz) {
  var owner = $thiz.top__Lreactify_Var();
  var r2T = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$5$2) {
      var x$5 = $uD(x$5$2);
      var this$1 = $this.component$1;
      var v = this$1.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      return (x$5 + ($uD(v.state__Lreactify_State().value__O()) / 2.0))
    })
  })($thiz));
  var t2R = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(x$6$2) {
      var x$6 = $uD(x$6$2);
      var this$3 = this$2$1.component$1;
      var v$1 = this$3.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      return (x$6 - ($uD(v$1.state__Lreactify_State().value__O()) / 2.0))
    })
  })($thiz));
  return new $c_Lreactify_standard_StandardDep().init___s_Option__Lreactify_Var__F1__F1($m_s_None$(), owner, r2T, t2R)
}
/** @constructor */
function $c_Lio_youi_component_extras_ComponentSize$measured$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype = new $h_O();
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.constructor = $c_Lio_youi_component_extras_ComponentSize$measured$;
/** @constructor */
function $h_Lio_youi_component_extras_ComponentSize$measured$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_ComponentSize$measured$.prototype = $c_Lio_youi_component_extras_ComponentSize$measured$.prototype;
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.width$lzycompute__p1__Lreactify_Var = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var mode = $m_Lreactify_Var$Mode$Normal$();
    var name = $m_s_None$();
    this.width$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.width$1
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.init___Lio_youi_component_extras_ComponentSize = (function($$outer) {
  return this
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.height$lzycompute__p1__Lreactify_Var = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var mode = $m_Lreactify_Var$Mode$Normal$();
    var name = $m_s_None$();
    this.height$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.width__Lreactify_Var = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.width$lzycompute__p1__Lreactify_Var() : this.width$1)
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.height__Lreactify_Var = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.height$lzycompute__p1__Lreactify_Var() : this.height$1)
});
var $d_Lio_youi_component_extras_ComponentSize$measured$ = new $TypeData().initClass({
  Lio_youi_component_extras_ComponentSize$measured$: 0
}, false, "io.youi.component.extras.ComponentSize$measured$", {
  Lio_youi_component_extras_ComponentSize$measured$: 1,
  O: 1
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.$classData = $d_Lio_youi_component_extras_ComponentSize$measured$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.max$module$1 = null;
  this.percent$module$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentPosition$scroll$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype;
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.max__Lio_youi_component_extras_HTMLComponentPosition$scroll$max$ = (function() {
  if ((this.max$module$1 === null)) {
    this.max$lzycompute$1__p1__V()
  };
  return this.max$module$1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.io$youi$component$extras$HTMLComponentPosition$scroll$$real__D__D = (function(d) {
  return ((((d === Infinity) || (d === (-Infinity))) || (d !== d)) ? 0.0 : d)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.init___Lio_youi_component_extras_HTMLComponentPosition = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.y__Lreactify_Var = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.y$lzycompute__p1__Lreactify_Var() : this.y$1)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.y$lzycompute__p1__Lreactify_Var = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.y$1 = this.prop__p1__F0__F1__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$1 = $this.$$outer$1;
        $m_Lio_youi_component_extras_HTMLComponent$();
        var component = this$1.component$1;
        var jsx$2 = component.element__Lorg_scalajs_dom_raw_HTMLElement().getBoundingClientRect();
        var jsx$1 = jsx$2.top;
        return $uD(jsx$1)
      })
    })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
      return (function(x$2$2) {
        var x$2 = $uD(x$2$2);
        var this$3 = this$2$1.$$outer$1;
        $m_Lio_youi_component_extras_HTMLComponent$();
        var component$1 = this$3.component$1;
        component$1.element__Lorg_scalajs_dom_raw_HTMLElement().scrollTop = x$2
      })
    })(this)));
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.max$lzycompute$1__p1__V = (function() {
  if ((this.max$module$1 === null)) {
    this.max$module$1 = new $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$().init___Lio_youi_component_extras_HTMLComponentPosition$scroll$(this)
  }
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.percent__Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$ = (function() {
  if ((this.percent$module$1 === null)) {
    this.percent$lzycompute$1__p1__V()
  };
  return this.percent$module$1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.percent$lzycompute$1__p1__V = (function() {
  if ((this.percent$module$1 === null)) {
    this.percent$module$1 = new $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$().init___Lio_youi_component_extras_HTMLComponentPosition$scroll$(this)
  }
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.prop__p1__F0__F1__Lreactify_Var = (function(get, set) {
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  var v = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(get, mode, name);
  var updating = new $c_sr_BooleanRef().init___Z(false);
  var this$6 = this.$$outer$1.component$1.delta__Lreactify_Channel();
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, get$1, v$1, updating$1) {
    return (function() {
      updating$1.elem$1 = true;
      try {
        var value = $uD(get$1.apply__O());
        $f_Lreactify_Var__$static__O__V(v$1, value)
      } finally {
        updating$1.elem$1 = false
      }
    })
  })(this, get, v, updating));
  this.$$outer$1.component$1.delta__Lreactify_Channel();
  var priority = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__on__F0__D__Lreactify_reaction_Reaction(this$6, f, priority);
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, set$1, updating$2) {
    return (function(d$2) {
      var d = $uD(d$2);
      if ((!updating$2.elem$1)) {
        set$1.apply$mcVD$sp__D__V(d)
      }
    })
  })(this, set, updating));
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(v, f$1, priority$1);
  return v
});
var $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentPosition$scroll$: 0
}, false, "io.youi.component.extras.HTMLComponentPosition$scroll$", {
  Lio_youi_component_extras_HTMLComponentPosition$scroll$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype;
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.init___Lio_youi_component_extras_HTMLComponentPosition$scroll$ = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.y__Lreactify_Val = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.y$lzycompute__p1__Lreactify_Val() : this.y$1)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.y$lzycompute__p1__Lreactify_Val = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var jsx$2 = $this.$$outer$1;
        var v = $this.$$outer$1.$$outer$1.component$1.size__Lio_youi_component_extras_HTMLComponentSize().scroll__Lio_youi_component_extras_HTMLComponentSize$scroll$().height__Lreactify_Val();
        var jsx$1 = $uD(v.state__Lreactify_State().value__O());
        var v$1 = $this.$$outer$1.$$outer$1.component$1.size__Lio_youi_component_extras_HTMLComponentSize().view__Lio_youi_component_extras_HTMLComponentSize$view$().height__Lreactify_Val();
        return jsx$2.io$youi$component$extras$HTMLComponentPosition$scroll$$real__D__D((jsx$1 - $uD(v$1.state__Lreactify_State().value__O())))
      })
    })(this));
    var name = $m_s_None$();
    this.y$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
var $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentPosition$scroll$max$: 0
}, false, "io.youi.component.extras.HTMLComponentPosition$scroll$max$", {
  Lio_youi_component_extras_HTMLComponentPosition$scroll$max$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype;
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.init___Lio_youi_component_extras_HTMLComponentPosition$scroll$ = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.y__Lreactify_Val = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.y$lzycompute__p1__Lreactify_Val() : this.y$1)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.y$lzycompute__p1__Lreactify_Val = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var v = $this.$$outer$1.$$outer$1.scroll__Lio_youi_component_extras_HTMLComponentPosition$scroll$().y__Lreactify_Var();
        var jsx$1 = $uD(v.state__Lreactify_State().value__O());
        var v$1 = $this.$$outer$1.max__Lio_youi_component_extras_HTMLComponentPosition$scroll$max$().y__Lreactify_Val();
        var x = (jsx$1 / $uD(v$1.state__Lreactify_State().value__O()));
        return $uD($g.Math.abs(x))
      })
    })(this));
    var name = $m_s_None$();
    this.y$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
var $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$: 0
}, false, "io.youi.component.extras.HTMLComponentPosition$scroll$percent$", {
  Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentSize$scroll$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentSize$scroll$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentSize$scroll$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype = $c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype;
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.height__Lreactify_Val = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.height$lzycompute__p1__Lreactify_Val() : this.height$1)
});
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.height$lzycompute__p1__Lreactify_Val = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.height$1 = this.$$outer$1.io$youi$component$extras$HTMLComponentSize$$prop__F0__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$1 = $this.$$outer$1;
        $m_Lio_youi_component_extras_HTMLComponent$();
        var component = this$1.component$1;
        var jsx$2 = $as_Lio_youi_component_extras_HTMLComponent(component).element__Lorg_scalajs_dom_raw_HTMLElement().getBoundingClientRect();
        var jsx$1 = jsx$2.height;
        return $uD(jsx$1)
      })
    })(this)));
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.init___Lio_youi_component_extras_HTMLComponentSize = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_component_extras_HTMLComponentSize$scroll$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentSize$scroll$: 0
}, false, "io.youi.component.extras.HTMLComponentSize$scroll$", {
  Lio_youi_component_extras_HTMLComponentSize$scroll$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentSize$scroll$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentSize$view$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentSize$view$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentSize$view$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentSize$view$.prototype = $c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype;
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.height__Lreactify_Val = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.height$lzycompute__p1__Lreactify_Val() : this.height$1)
});
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.height$lzycompute__p1__Lreactify_Val = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.height$1 = this.$$outer$1.io$youi$component$extras$HTMLComponentSize$$prop__F0__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$1 = $this.$$outer$1;
        $m_Lio_youi_component_extras_HTMLComponent$();
        var component = this$1.component$1;
        var jsx$1 = $as_Lio_youi_component_extras_HTMLComponent(component).element__Lorg_scalajs_dom_raw_HTMLElement().clientHeight;
        return $uI(jsx$1)
      })
    })(this)));
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.init___Lio_youi_component_extras_HTMLComponentSize = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_component_extras_HTMLComponentSize$view$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentSize$view$: 0
}, false, "io.youi.component.extras.HTMLComponentSize$view$", {
  Lio_youi_component_extras_HTMLComponentSize$view$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentSize$view$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLExtras() {
  $c_O.call(this);
  this.element$1 = null
}
$c_Lio_youi_component_extras_HTMLExtras.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLExtras.prototype.constructor = $c_Lio_youi_component_extras_HTMLExtras;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLExtras() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLExtras.prototype = $c_Lio_youi_component_extras_HTMLExtras.prototype;
$c_Lio_youi_component_extras_HTMLExtras.prototype.init___Lorg_scalajs_dom_raw_HTMLElement = (function(element) {
  this.element$1 = element;
  return this
});
var $d_Lio_youi_component_extras_HTMLExtras = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLExtras: 0
}, false, "io.youi.component.extras.HTMLExtras", {
  Lio_youi_component_extras_HTMLExtras: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLExtras.prototype.$classData = $d_Lio_youi_component_extras_HTMLExtras;
/** @constructor */
function $c_Lio_youi_drawable_Composite() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_drawable_Composite.prototype = new $h_O();
$c_Lio_youi_drawable_Composite.prototype.constructor = $c_Lio_youi_drawable_Composite;
/** @constructor */
function $h_Lio_youi_drawable_Composite() {
  /*<skip>*/
}
$h_Lio_youi_drawable_Composite.prototype = $c_Lio_youi_drawable_Composite.prototype;
$c_Lio_youi_drawable_Composite.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
/** @constructor */
function $c_Lio_youi_drawable_Context() {
  $c_O.call(this);
  this.canvas$1 = null;
  this.$$undratio$1 = null;
  this.adjustScaleX$1 = 0.0;
  this.adjustScaleY$1 = 0.0;
  this.fillStyle$1 = null;
  this.strokeStyle$1 = null
}
$c_Lio_youi_drawable_Context.prototype = new $h_O();
$c_Lio_youi_drawable_Context.prototype.constructor = $c_Lio_youi_drawable_Context;
/** @constructor */
function $h_Lio_youi_drawable_Context() {
  /*<skip>*/
}
$h_Lio_youi_drawable_Context.prototype = $c_Lio_youi_drawable_Context.prototype;
$c_Lio_youi_drawable_Context.prototype.drawCanvas__Lorg_scalajs_dom_raw_HTMLCanvasElement__D__D__D__D__V = (function(canvas, x, y, width, height) {
  var qual$2 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
  var x$11 = (x * this.ratioX__D());
  var x$12 = (y * this.ratioY__D());
  var x$13 = (width * this.ratioX__D());
  var x$14 = (height * this.ratioY__D());
  qual$2.drawImage(canvas, x$11, x$12, x$13, x$14)
});
$c_Lio_youi_drawable_Context.prototype.rotate__D__V = (function(angle) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().rotate(angle)
});
$c_Lio_youi_drawable_Context.prototype.reset__V = (function() {
  this.composite__Lio_youi_drawable_Composite__V($m_Lio_youi_drawable_Composite$SourceOver$());
  this.fillStyle$1 = $m_Lio_youi_paint_NoPaint$();
  this.strokeStyle$1 = $m_Lio_youi_paint_Stroke$().none__Lio_youi_paint_Stroke();
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().fillStyle = "";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().strokeStyle = "";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineCap = "";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineDashOffset = 0.0;
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineJoin = "";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineWidth = 0.0;
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().setLineDash([]);
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().globalAlpha = 1.0;
  this.transform__Lio_youi_spatial_Matrix3__V($m_Lio_youi_spatial_Matrix3$().Identity__Lio_youi_spatial_Matrix3())
});
$c_Lio_youi_drawable_Context.prototype.composite__Lio_youi_drawable_Composite__V = (function(composite) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().globalCompositeOperation = composite.value$1
});
$c_Lio_youi_drawable_Context.prototype.drawVideo__Lorg_scalajs_dom_raw_HTMLVideoElement__D__D__D__D__V = (function(video, x, y, width, height) {
  var qual$3 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
  var x$20 = (x * this.ratioX__D());
  var x$21 = (y * this.ratioY__D());
  var x$22 = (width * this.ratioX__D());
  var x$23 = (height * this.ratioY__D());
  qual$3.drawImage(video, x$20, x$21, x$22, x$23)
});
$c_Lio_youi_drawable_Context.prototype.bezierCurveTo__D__D__D__D__D__D__V = (function(cp1x, cp1y, cp2x, cp2y, x, y) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().bezierCurveTo((cp1x * this.ratioX__D()), (cp1y * this.ratioY__D()), (cp2x * this.ratioX__D()), (cp2y * this.ratioY__D()), (x * this.ratioX__D()), (y * this.ratioY__D()))
});
$c_Lio_youi_drawable_Context.prototype.lineTo__D__D__V = (function(x, y) {
  var value = (x * this.ratioX__D());
  var value$1 = (y * this.ratioY__D());
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineTo(value, value$1)
});
$c_Lio_youi_drawable_Context.prototype.rect__D__D__D__D__Z__Z__V = (function(x, y, width, height, begin, close) {
  if (begin) {
    this.begin__V()
  };
  var jsx$1 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
  var value = (x * this.ratioX__D());
  var value$1 = (y * this.ratioY__D());
  jsx$1.rect(value, value$1, (width * this.ratioX__D()), (height * this.ratioY__D()));
  if (close) {
    this.close__V()
  }
});
$c_Lio_youi_drawable_Context.prototype.strokeText__T__D__D__D__V = (function(text, x, y, maxWidth) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().strokeText(text, (x * this.ratioX__D()), (y * this.ratioY__D()), (maxWidth * this.ratioX__D()))
});
$c_Lio_youi_drawable_Context.prototype.stroke__Lio_youi_paint_Paint__D__sci_List__D__Lio_youi_paint_LineCap__Lio_youi_paint_LineJoin__Z__V = (function(paint, lineWidth, lineDash, lineDashOffset, lineCap, lineJoin, apply) {
  if ($f_Lio_youi_paint_Paint__nonEmpty__Z(paint)) {
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().strokeStyle = paint.asJS__Lio_youi_drawable_Context__sjs_js_Any(this);
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineWidth = (lineWidth * this.ratioX__D());
    var jsx$2 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
    if ($is_sjs_js_ArrayOps(lineDash)) {
      var x2 = $as_sjs_js_ArrayOps(lineDash);
      var jsx$1 = x2.scala$scalajs$js$ArrayOps$$array$f
    } else if ($is_sjs_js_WrappedArray(lineDash)) {
      var x3 = $as_sjs_js_WrappedArray(lineDash);
      var jsx$1 = x3.array$6
    } else {
      var result = [];
      var these = lineDash;
      while ((!these.isEmpty__Z())) {
        var arg1 = these.head__O();
        $uI(result.push(arg1));
        these = $as_sci_List(these.tail__O())
      };
      var jsx$1 = result
    };
    jsx$2.setLineDash(jsx$1);
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineDashOffset = (lineDashOffset * this.ratioX__D());
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineCap = lineCap.value$1;
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineJoin = lineJoin.value$1;
    if (apply) {
      this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().stroke()
    }
  }
});
$c_Lio_youi_drawable_Context.prototype.ratioX__D = (function() {
  var this$1 = this.$$undratio$1;
  return ($uD(this$1.apply__O()) * this.adjustScaleX$1)
});
$c_Lio_youi_drawable_Context.prototype.restore__V = (function() {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().restore()
});
$c_Lio_youi_drawable_Context.prototype.quadraticCurveTo__D__D__D__D__V = (function(cpx, cpy, x, y) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().quadraticCurveTo((cpx * this.ratioX__D()), (cpy * this.ratioY__D()), (x * this.ratioX__D()), (y * this.ratioY__D()))
});
$c_Lio_youi_drawable_Context.prototype.fillText__T__D__D__D__V = (function(text, x, y, maxWidth) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().textBaseline = "top";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().fillText(text, (x * this.ratioX__D()), (y * this.ratioY__D()), (maxWidth * this.ratioX__D()))
});
$c_Lio_youi_drawable_Context.prototype.roundedRect__D__D__D__D__D__V = (function(x, y, width, height, radius) {
  this.begin__V();
  this.moveTo__D__D__V((x + radius), y);
  this.lineTo__D__D__V(((x + width) - radius), y);
  this.quadraticCurveTo__D__D__D__D__V((x + width), y, (x + width), (y + radius));
  this.lineTo__D__D__V((x + width), ((y + height) - radius));
  this.quadraticCurveTo__D__D__D__D__V((x + width), (y + height), ((x + width) - radius), (y + height));
  this.lineTo__D__D__V((x + radius), (y + height));
  this.quadraticCurveTo__D__D__D__D__V(x, (y + height), x, ((y + height) - radius));
  this.lineTo__D__D__V(x, (y + radius));
  this.quadraticCurveTo__D__D__D__D__V(x, y, (x + radius), y);
  this.close__V()
});
$c_Lio_youi_drawable_Context.prototype.save__V = (function() {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().save()
});
$c_Lio_youi_drawable_Context.prototype.transform__Lio_youi_spatial_Matrix3__V = (function(matrix) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().setTransform(matrix.m00$1, matrix.m01$1, matrix.m10$1, matrix.m11$1, matrix.m02$1, matrix.m12$1)
});
$c_Lio_youi_drawable_Context.prototype.begin__V = (function() {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().beginPath()
});
$c_Lio_youi_drawable_Context.prototype.init___Lorg_scalajs_dom_raw_HTMLCanvasElement__F0 = (function(canvas, _ratio) {
  this.canvas$1 = canvas;
  this.$$undratio$1 = _ratio;
  this.adjustScaleX$1 = 1.0;
  this.adjustScaleY$1 = 1.0;
  this.fillStyle$1 = $m_Lio_youi_paint_NoPaint$();
  this.strokeStyle$1 = $m_Lio_youi_paint_Stroke$().none__Lio_youi_paint_Stroke();
  return this
});
$c_Lio_youi_drawable_Context.prototype.translate__D__D__V = (function(x, y) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().translate((x * this.ratioX__D()), (y * this.ratioY__D()))
});
$c_Lio_youi_drawable_Context.prototype.moveTo__D__D__V = (function(x, y) {
  var value = (x * this.ratioX__D());
  var value$1 = (y * this.ratioY__D());
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().moveTo(value, value$1)
});
$c_Lio_youi_drawable_Context.prototype.setFont__T__D__T__T__T__V = (function(family, size, style, variant, weight) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().font = ((((((((style + " ") + variant) + " ") + weight) + " ") + (size * this.ratioX__D())) + "px ") + family)
});
$c_Lio_youi_drawable_Context.prototype.drawImage__Lorg_scalajs_dom_raw_HTMLImageElement__D__D__D__D__V = (function(image, x, y, width, height) {
  var qual$1 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
  var x$2 = (x * this.ratioX__D());
  var x$3 = (y * this.ratioY__D());
  var x$4 = (width * this.ratioX__D());
  var x$5 = (height * this.ratioY__D());
  qual$1.drawImage(image, x$2, x$3, x$4, x$5)
});
$c_Lio_youi_drawable_Context.prototype.close__V = (function() {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().closePath()
});
$c_Lio_youi_drawable_Context.prototype.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D = (function() {
  var canvas = this.canvas$1;
  return new $c_Lio_youi_package$ExtendedCanvas().init___Lorg_scalajs_dom_raw_HTMLCanvasElement(canvas).context__Lorg_scalajs_dom_raw_CanvasRenderingContext2D()
});
$c_Lio_youi_drawable_Context.prototype.ratioY__D = (function() {
  var this$1 = this.$$undratio$1;
  return ($uD(this$1.apply__O()) * this.adjustScaleY$1)
});
$c_Lio_youi_drawable_Context.prototype.stroke__Lio_youi_paint_Stroke__Z__V = (function(stroke, apply) {
  if (stroke.nonEmpty__Z()) {
    this.strokeStyle$1 = stroke;
    this.stroke__Lio_youi_paint_Paint__D__sci_List__D__Lio_youi_paint_LineCap__Lio_youi_paint_LineJoin__Z__V(stroke.paint$1, stroke.lineWidth$1, stroke.lineDash$1, stroke.lineDashOffset$1, stroke.lineCap$1, stroke.lineJoin$1, apply)
  }
});
$c_Lio_youi_drawable_Context.prototype.fill__Lio_youi_paint_Paint__Z__V = (function(paint, apply) {
  if ($f_Lio_youi_paint_Paint__nonEmpty__Z(paint)) {
    this.fillStyle$1 = paint;
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().fillStyle = paint.asJS__Lio_youi_drawable_Context__sjs_js_Any(this);
    if (apply) {
      this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().fill()
    }
  }
});
var $d_Lio_youi_drawable_Context = new $TypeData().initClass({
  Lio_youi_drawable_Context: 0
}, false, "io.youi.drawable.Context", {
  Lio_youi_drawable_Context: 1,
  O: 1
});
$c_Lio_youi_drawable_Context.prototype.$classData = $d_Lio_youi_drawable_Context;
function $is_Lio_youi_drawable_Drawable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_drawable_Drawable)))
}
function $as_Lio_youi_drawable_Drawable(obj) {
  return (($is_Lio_youi_drawable_Drawable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.drawable.Drawable"))
}
function $isArrayOf_Lio_youi_drawable_Drawable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_drawable_Drawable)))
}
function $asArrayOf_Lio_youi_drawable_Drawable(obj, depth) {
  return (($isArrayOf_Lio_youi_drawable_Drawable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.drawable.Drawable;", depth))
}
/** @constructor */
function $c_Lio_youi_drawable_Transformation$() {
  $c_O.call(this)
}
$c_Lio_youi_drawable_Transformation$.prototype = new $h_O();
$c_Lio_youi_drawable_Transformation$.prototype.constructor = $c_Lio_youi_drawable_Transformation$;
/** @constructor */
function $h_Lio_youi_drawable_Transformation$() {
  /*<skip>*/
}
$h_Lio_youi_drawable_Transformation$.prototype = $c_Lio_youi_drawable_Transformation$.prototype;
$c_Lio_youi_drawable_Transformation$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_drawable_Transformation$.prototype.apply__D__D__D__D__D__Lio_youi_drawable_Drawable__Lio_youi_drawable_Transformation = (function(x, y, pivotX, pivotY, rotation, drawable) {
  return new $c_Lio_youi_drawable_Transformation$$anon$1().init___D__D__D__D__D__Lio_youi_drawable_Drawable(x, y, pivotX, pivotY, rotation, drawable)
});
var $d_Lio_youi_drawable_Transformation$ = new $TypeData().initClass({
  Lio_youi_drawable_Transformation$: 0
}, false, "io.youi.drawable.Transformation$", {
  Lio_youi_drawable_Transformation$: 1,
  O: 1
});
$c_Lio_youi_drawable_Transformation$.prototype.$classData = $d_Lio_youi_drawable_Transformation$;
var $n_Lio_youi_drawable_Transformation$ = (void 0);
function $m_Lio_youi_drawable_Transformation$() {
  if ((!$n_Lio_youi_drawable_Transformation$)) {
    $n_Lio_youi_drawable_Transformation$ = new $c_Lio_youi_drawable_Transformation$().init___()
  };
  return $n_Lio_youi_drawable_Transformation$
}
/** @constructor */
function $c_Lio_youi_easing_Bounce$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Bounce$.prototype = new $h_O();
$c_Lio_youi_easing_Bounce$.prototype.constructor = $c_Lio_youi_easing_Bounce$;
/** @constructor */
function $h_Lio_youi_easing_Bounce$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Bounce$.prototype = $c_Lio_youi_easing_Bounce$.prototype;
$c_Lio_youi_easing_Bounce$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Bounce$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  return ((time < (duration / 2.0)) ? ((0.5 * this.easeIn__D__D__D__D__D((2.0 * time), 0.0, change, duration)) + start) : (((0.5 * this.easeOut__D__D__D__D__D(((2.0 * time) - duration), 0.0, change, duration)) + (0.5 * change)) + start))
});
$c_Lio_youi_easing_Bounce$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  if ((t < 0.36363636363636365)) {
    return ((change * ((7.5625 * t) * t)) + start)
  } else if ((t < 0.7272727272727273)) {
    var t2 = ((-0.5454545454545454) + t);
    return ((change * (0.75 + ((7.5625 * t2) * t2))) + start)
  } else if ((t < 0.9090909090909091)) {
    var t3 = ((-0.8181818181818182) + t);
    return ((change * (0.9375 + ((7.5625 * t3) * t3))) + start)
  } else {
    var t4 = ((-0.9545454545454546) + t);
    return ((change * (0.984375 + ((7.5625 * t4) * t4))) + start)
  }
});
$c_Lio_youi_easing_Bounce$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  return ((change - this.easeOut__D__D__D__D__D((duration - time), 0.0, change, duration)) + start)
});
var $d_Lio_youi_easing_Bounce$ = new $TypeData().initClass({
  Lio_youi_easing_Bounce$: 0
}, false, "io.youi.easing.Bounce$", {
  Lio_youi_easing_Bounce$: 1,
  O: 1
});
$c_Lio_youi_easing_Bounce$.prototype.$classData = $d_Lio_youi_easing_Bounce$;
var $n_Lio_youi_easing_Bounce$ = (void 0);
function $m_Lio_youi_easing_Bounce$() {
  if ((!$n_Lio_youi_easing_Bounce$)) {
    $n_Lio_youi_easing_Bounce$ = new $c_Lio_youi_easing_Bounce$().init___()
  };
  return $n_Lio_youi_easing_Bounce$
}
/** @constructor */
function $c_Lio_youi_easing_Circular$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Circular$.prototype = new $h_O();
$c_Lio_youi_easing_Circular$.prototype.constructor = $c_Lio_youi_easing_Circular$;
/** @constructor */
function $h_Lio_youi_easing_Circular$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Circular$.prototype = $c_Lio_youi_easing_Circular$.prototype;
$c_Lio_youi_easing_Circular$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Circular$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2));
  if ((t < 1)) {
    var x = (1.0 - (t * t));
    return ((((-change) / 2.0) * ((-1.0) + $uD($g.Math.sqrt(x)))) + start)
  } else {
    var t2 = ((-2.0) + t);
    var x$1 = (1.0 - (t2 * t2));
    return (((change / 2.0) * (1.0 + $uD($g.Math.sqrt(x$1)))) + start)
  }
});
$c_Lio_youi_easing_Circular$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  var x = (1.0 - (t * t));
  return ((change * $uD($g.Math.sqrt(x))) + start)
});
$c_Lio_youi_easing_Circular$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  var x = (1.0 - (t * t));
  return (((-change) * ((-1.0) + $uD($g.Math.sqrt(x)))) + start)
});
var $d_Lio_youi_easing_Circular$ = new $TypeData().initClass({
  Lio_youi_easing_Circular$: 0
}, false, "io.youi.easing.Circular$", {
  Lio_youi_easing_Circular$: 1,
  O: 1
});
$c_Lio_youi_easing_Circular$.prototype.$classData = $d_Lio_youi_easing_Circular$;
var $n_Lio_youi_easing_Circular$ = (void 0);
function $m_Lio_youi_easing_Circular$() {
  if ((!$n_Lio_youi_easing_Circular$)) {
    $n_Lio_youi_easing_Circular$ = new $c_Lio_youi_easing_Circular$().init___()
  };
  return $n_Lio_youi_easing_Circular$
}
/** @constructor */
function $c_Lio_youi_easing_Cubic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Cubic$.prototype = new $h_O();
$c_Lio_youi_easing_Cubic$.prototype.constructor = $c_Lio_youi_easing_Cubic$;
/** @constructor */
function $h_Lio_youi_easing_Cubic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Cubic$.prototype = $c_Lio_youi_easing_Cubic$.prototype;
$c_Lio_youi_easing_Cubic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Cubic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return (((((change / 2.0) * t) * t) * t) + start)
  } else {
    var t2 = ((-2.0) + t);
    return (((change / 2.0) * (2.0 + ((t2 * t2) * t2))) + start)
  }
});
$c_Lio_youi_easing_Cubic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  return ((change * (1.0 + ((t * t) * t))) + start)
});
$c_Lio_youi_easing_Cubic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return ((((change * t) * t) * t) + start)
});
var $d_Lio_youi_easing_Cubic$ = new $TypeData().initClass({
  Lio_youi_easing_Cubic$: 0
}, false, "io.youi.easing.Cubic$", {
  Lio_youi_easing_Cubic$: 1,
  O: 1
});
$c_Lio_youi_easing_Cubic$.prototype.$classData = $d_Lio_youi_easing_Cubic$;
var $n_Lio_youi_easing_Cubic$ = (void 0);
function $m_Lio_youi_easing_Cubic$() {
  if ((!$n_Lio_youi_easing_Cubic$)) {
    $n_Lio_youi_easing_Cubic$ = new $c_Lio_youi_easing_Cubic$().init___()
  };
  return $n_Lio_youi_easing_Cubic$
}
/** @constructor */
function $c_Lio_youi_easing_Easing$() {
  $c_O.call(this);
  this.map$1 = null;
  this.all$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_easing_Easing$.prototype = new $h_O();
$c_Lio_youi_easing_Easing$.prototype.constructor = $c_Lio_youi_easing_Easing$;
/** @constructor */
function $h_Lio_youi_easing_Easing$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Easing$.prototype = $c_Lio_youi_easing_Easing$.prototype;
$c_Lio_youi_easing_Easing$.prototype.cubicInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Cubic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.map__sci_Map = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.map$lzycompute__p1__sci_Map() : this.map$1)
});
$c_Lio_youi_easing_Easing$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Easing$.prototype.cubicOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Cubic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.exponentialIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Exponential$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.sineIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Sine$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.exponentialOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Exponential$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quarticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quartic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.circularIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Circular$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quinticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quintic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quadraticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quadratic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.bounceIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Bounce$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quinticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quintic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.sineOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Sine$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.elasticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Elastic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.circularInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Circular$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.sineInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Sine$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.elasticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Elastic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quadraticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quadratic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quarticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quartic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.exponentialInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Exponential$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.bounceOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Bounce$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.bounceInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Bounce$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.circularOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Circular$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quarticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quartic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quadraticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quadratic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.cubicIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Cubic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quinticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quintic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.elasticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Elastic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.map$lzycompute__p1__sci_Map = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var y = new $c_Lio_youi_easing_BackIn().init___D(1.70158);
    var jsx$30 = new $c_T2().init___O__O("BackIn", y);
    var y$1 = new $c_Lio_youi_easing_BackOut().init___D(1.70158);
    var jsx$29 = new $c_T2().init___O__O("BackOut", y$1);
    var y$2 = new $c_Lio_youi_easing_BackInOut().init___D(1.70158);
    var jsx$28 = new $c_T2().init___O__O("BackInOut", y$2);
    var y$3 = $m_Lio_youi_easing_Linear$();
    var jsx$27 = new $c_T2().init___O__O("Linear", y$3);
    var y$4 = $m_Lio_youi_easing_Easing$().bounceIn__Lio_youi_easing_Easing();
    var jsx$26 = new $c_T2().init___O__O("BounceIn", y$4);
    var y$5 = $m_Lio_youi_easing_Easing$().bounceOut__Lio_youi_easing_Easing();
    var jsx$25 = new $c_T2().init___O__O("BounceOut", y$5);
    var y$6 = $m_Lio_youi_easing_Easing$().bounceInOut__Lio_youi_easing_Easing();
    var jsx$24 = new $c_T2().init___O__O("BounceInOut", y$6);
    var y$7 = $m_Lio_youi_easing_Easing$().circularIn__Lio_youi_easing_Easing();
    var jsx$23 = new $c_T2().init___O__O("CircularIn", y$7);
    var y$8 = $m_Lio_youi_easing_Easing$().circularOut__Lio_youi_easing_Easing();
    var jsx$22 = new $c_T2().init___O__O("CircularOut", y$8);
    var y$9 = $m_Lio_youi_easing_Easing$().circularInOut__Lio_youi_easing_Easing();
    var jsx$21 = new $c_T2().init___O__O("CircularInOut", y$9);
    var y$10 = $m_Lio_youi_easing_Easing$().cubicIn__Lio_youi_easing_Easing();
    var jsx$20 = new $c_T2().init___O__O("CubicIn", y$10);
    var y$11 = $m_Lio_youi_easing_Easing$().cubicOut__Lio_youi_easing_Easing();
    var jsx$19 = new $c_T2().init___O__O("CubicOut", y$11);
    var y$12 = $m_Lio_youi_easing_Easing$().cubicInOut__Lio_youi_easing_Easing();
    var jsx$18 = new $c_T2().init___O__O("CubicInOut", y$12);
    var y$13 = $m_Lio_youi_easing_Easing$().elasticIn__Lio_youi_easing_Easing();
    var jsx$17 = new $c_T2().init___O__O("ElasticIn", y$13);
    var y$14 = $m_Lio_youi_easing_Easing$().elasticOut__Lio_youi_easing_Easing();
    var jsx$16 = new $c_T2().init___O__O("ElasticOut", y$14);
    var y$15 = $m_Lio_youi_easing_Easing$().elasticInOut__Lio_youi_easing_Easing();
    var jsx$15 = new $c_T2().init___O__O("ElasticInOut", y$15);
    var y$16 = $m_Lio_youi_easing_Easing$().exponentialIn__Lio_youi_easing_Easing();
    var jsx$14 = new $c_T2().init___O__O("ExponentialIn", y$16);
    var y$17 = $m_Lio_youi_easing_Easing$().exponentialOut__Lio_youi_easing_Easing();
    var jsx$13 = new $c_T2().init___O__O("ExponentialOut", y$17);
    var y$18 = $m_Lio_youi_easing_Easing$().exponentialInOut__Lio_youi_easing_Easing();
    var jsx$12 = new $c_T2().init___O__O("ExponentialInOut", y$18);
    var y$19 = $m_Lio_youi_easing_Easing$().quadraticIn__Lio_youi_easing_Easing();
    var jsx$11 = new $c_T2().init___O__O("QuadraticIn", y$19);
    var y$20 = $m_Lio_youi_easing_Easing$().quadraticOut__Lio_youi_easing_Easing();
    var jsx$10 = new $c_T2().init___O__O("QuadraticOut", y$20);
    var y$21 = $m_Lio_youi_easing_Easing$().quadraticInOut__Lio_youi_easing_Easing();
    var jsx$9 = new $c_T2().init___O__O("QuadraticInOut", y$21);
    var y$22 = $m_Lio_youi_easing_Easing$().quarticIn__Lio_youi_easing_Easing();
    var jsx$8 = new $c_T2().init___O__O("QuarticIn", y$22);
    var y$23 = $m_Lio_youi_easing_Easing$().quarticOut__Lio_youi_easing_Easing();
    var jsx$7 = new $c_T2().init___O__O("QuarticOut", y$23);
    var y$24 = $m_Lio_youi_easing_Easing$().quarticInOut__Lio_youi_easing_Easing();
    var jsx$6 = new $c_T2().init___O__O("QuarticInOut", y$24);
    var y$25 = $m_Lio_youi_easing_Easing$().quinticIn__Lio_youi_easing_Easing();
    var jsx$5 = new $c_T2().init___O__O("QuinticIn", y$25);
    var y$26 = $m_Lio_youi_easing_Easing$().quinticOut__Lio_youi_easing_Easing();
    var jsx$4 = new $c_T2().init___O__O("QuinticOut", y$26);
    var y$27 = $m_Lio_youi_easing_Easing$().quinticInOut__Lio_youi_easing_Easing();
    var jsx$3 = new $c_T2().init___O__O("QuinticInOut", y$27);
    var y$28 = $m_Lio_youi_easing_Easing$().sineIn__Lio_youi_easing_Easing();
    var jsx$2 = new $c_T2().init___O__O("SineIn", y$28);
    var y$29 = $m_Lio_youi_easing_Easing$().sineOut__Lio_youi_easing_Easing();
    var jsx$1 = new $c_T2().init___O__O("SineOut", y$29);
    var y$30 = $m_Lio_youi_easing_Easing$().sineInOut__Lio_youi_easing_Easing();
    var array = [jsx$30, jsx$29, jsx$28, jsx$27, jsx$26, jsx$25, jsx$24, jsx$23, jsx$22, jsx$21, jsx$20, jsx$19, jsx$18, jsx$17, jsx$16, jsx$15, jsx$14, jsx$13, jsx$12, jsx$11, jsx$10, jsx$9, jsx$8, jsx$7, jsx$6, jsx$5, jsx$4, jsx$3, jsx$2, jsx$1, new $c_T2().init___O__O("SineInOut", y$30)];
    var this$70 = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
    var i = 0;
    var len = $uI(array.length);
    while ((i < len)) {
      var index = i;
      var arg1 = array[index];
      this$70.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1));
      i = ((1 + i) | 0)
    };
    this.map$1 = $as_sci_Map(this$70.elems$1);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.map$1
});
var $d_Lio_youi_easing_Easing$ = new $TypeData().initClass({
  Lio_youi_easing_Easing$: 0
}, false, "io.youi.easing.Easing$", {
  Lio_youi_easing_Easing$: 1,
  O: 1
});
$c_Lio_youi_easing_Easing$.prototype.$classData = $d_Lio_youi_easing_Easing$;
var $n_Lio_youi_easing_Easing$ = (void 0);
function $m_Lio_youi_easing_Easing$() {
  if ((!$n_Lio_youi_easing_Easing$)) {
    $n_Lio_youi_easing_Easing$ = new $c_Lio_youi_easing_Easing$().init___()
  };
  return $n_Lio_youi_easing_Easing$
}
/** @constructor */
function $c_Lio_youi_easing_Elastic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Elastic$.prototype = new $h_O();
$c_Lio_youi_easing_Elastic$.prototype.constructor = $c_Lio_youi_easing_Elastic$;
/** @constructor */
function $h_Lio_youi_easing_Elastic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Elastic$.prototype = $c_Lio_youi_easing_Elastic$.prototype;
$c_Lio_youi_easing_Elastic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Elastic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((time === 0.0)) {
    return start
  } else if ((t === 2.0)) {
    return (start + change)
  } else {
    var period = (0.44999999999999996 * duration);
    var s = (period / 4.0);
    var t2 = ((-1.0) + t);
    if ((t < 1.0)) {
      var y = (10.0 * t2);
      var jsx$1 = $uD($g.Math.pow(2.0, y));
      var x = ((6.283185307179586 * ((t2 * duration) - s)) / period);
      return (((-0.5) * ((change * jsx$1) * $uD($g.Math.sin(x)))) + start)
    } else {
      var y$1 = ((-10.0) * t2);
      var jsx$2 = $uD($g.Math.pow(2.0, y$1));
      var x$1 = ((6.283185307179586 * ((t2 * duration) - s)) / period);
      return (((0.5 * ((change * jsx$2) * $uD($g.Math.sin(x$1)))) + change) + start)
    }
  }
});
$c_Lio_youi_easing_Elastic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  if ((time === 0.0)) {
    return start
  } else if ((t === 1.0)) {
    return (start + change)
  } else {
    var period = (0.3 * duration);
    var s = (period / 4.0);
    var y = ((-10.0) * t);
    var jsx$1 = $uD($g.Math.pow(2.0, y));
    var x = ((6.283185307179586 * ((t * duration) - s)) / period);
    return ((((change * jsx$1) * $uD($g.Math.sin(x))) + change) + start)
  }
});
$c_Lio_youi_easing_Elastic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  if ((time === 0.0)) {
    return start
  } else if ((t === 1.0)) {
    return (start + change)
  } else {
    var period = (0.3 * duration);
    var s = (period / 4.0);
    var t2 = ((-1.0) + t);
    var y = (10.0 * t2);
    var jsx$1 = $uD($g.Math.pow(2.0, y));
    var x = ((6.283185307179586 * ((t2 * duration) - s)) / period);
    return ((-((change * jsx$1) * $uD($g.Math.sin(x)))) + start)
  }
});
var $d_Lio_youi_easing_Elastic$ = new $TypeData().initClass({
  Lio_youi_easing_Elastic$: 0
}, false, "io.youi.easing.Elastic$", {
  Lio_youi_easing_Elastic$: 1,
  O: 1
});
$c_Lio_youi_easing_Elastic$.prototype.$classData = $d_Lio_youi_easing_Elastic$;
var $n_Lio_youi_easing_Elastic$ = (void 0);
function $m_Lio_youi_easing_Elastic$() {
  if ((!$n_Lio_youi_easing_Elastic$)) {
    $n_Lio_youi_easing_Elastic$ = new $c_Lio_youi_easing_Elastic$().init___()
  };
  return $n_Lio_youi_easing_Elastic$
}
/** @constructor */
function $c_Lio_youi_easing_Exponential$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Exponential$.prototype = new $h_O();
$c_Lio_youi_easing_Exponential$.prototype.constructor = $c_Lio_youi_easing_Exponential$;
/** @constructor */
function $h_Lio_youi_easing_Exponential$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Exponential$.prototype = $c_Lio_youi_easing_Exponential$.prototype;
$c_Lio_youi_easing_Exponential$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Exponential$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((time === 0.0)) {
    return start
  } else if ((time === duration)) {
    return (start + change)
  } else if ((t < 1.0)) {
    var y = (10.0 * ((-1.0) + t));
    return (((change / 2.0) * $uD($g.Math.pow(2.0, y))) + start)
  } else {
    var y$1 = ((-10.0) * ((-1.0) + t));
    return (((change / 2.0) * (2.0 - $uD($g.Math.pow(2.0, y$1)))) + start)
  }
});
$c_Lio_youi_easing_Exponential$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  if ((time === duration)) {
    return (start + change)
  } else {
    var y = (((-10.0) * time) / duration);
    return ((change * (1.0 - $uD($g.Math.pow(2.0, y)))) + start)
  }
});
$c_Lio_youi_easing_Exponential$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  if ((time === 0.0)) {
    return start
  } else {
    var y = (10.0 * ((-1.0) + (time / duration)));
    return ((change * $uD($g.Math.pow(2.0, y))) + start)
  }
});
var $d_Lio_youi_easing_Exponential$ = new $TypeData().initClass({
  Lio_youi_easing_Exponential$: 0
}, false, "io.youi.easing.Exponential$", {
  Lio_youi_easing_Exponential$: 1,
  O: 1
});
$c_Lio_youi_easing_Exponential$.prototype.$classData = $d_Lio_youi_easing_Exponential$;
var $n_Lio_youi_easing_Exponential$ = (void 0);
function $m_Lio_youi_easing_Exponential$() {
  if ((!$n_Lio_youi_easing_Exponential$)) {
    $n_Lio_youi_easing_Exponential$ = new $c_Lio_youi_easing_Exponential$().init___()
  };
  return $n_Lio_youi_easing_Exponential$
}
/** @constructor */
function $c_Lio_youi_easing_Quadratic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Quadratic$.prototype = new $h_O();
$c_Lio_youi_easing_Quadratic$.prototype.constructor = $c_Lio_youi_easing_Quadratic$;
/** @constructor */
function $h_Lio_youi_easing_Quadratic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Quadratic$.prototype = $c_Lio_youi_easing_Quadratic$.prototype;
$c_Lio_youi_easing_Quadratic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Quadratic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return ((((change / 2.0) * t) * t) + start)
  } else {
    var t2 = ((-1.0) + t);
    return ((((-change) / 2.0) * ((-1.0) + (t2 * ((-2.0) + t2)))) + start)
  }
});
$c_Lio_youi_easing_Quadratic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return ((((-change) * t) * ((-2.0) + t)) + start)
});
$c_Lio_youi_easing_Quadratic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return (((change * t) * t) + start)
});
var $d_Lio_youi_easing_Quadratic$ = new $TypeData().initClass({
  Lio_youi_easing_Quadratic$: 0
}, false, "io.youi.easing.Quadratic$", {
  Lio_youi_easing_Quadratic$: 1,
  O: 1
});
$c_Lio_youi_easing_Quadratic$.prototype.$classData = $d_Lio_youi_easing_Quadratic$;
var $n_Lio_youi_easing_Quadratic$ = (void 0);
function $m_Lio_youi_easing_Quadratic$() {
  if ((!$n_Lio_youi_easing_Quadratic$)) {
    $n_Lio_youi_easing_Quadratic$ = new $c_Lio_youi_easing_Quadratic$().init___()
  };
  return $n_Lio_youi_easing_Quadratic$
}
/** @constructor */
function $c_Lio_youi_easing_Quartic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Quartic$.prototype = new $h_O();
$c_Lio_youi_easing_Quartic$.prototype.constructor = $c_Lio_youi_easing_Quartic$;
/** @constructor */
function $h_Lio_youi_easing_Quartic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Quartic$.prototype = $c_Lio_youi_easing_Quartic$.prototype;
$c_Lio_youi_easing_Quartic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Quartic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return ((((((change / 2.0) * t) * t) * t) * t) + start)
  } else {
    var t2 = ((-2.0) + t);
    return ((((-change) / 2.0) * ((-2.0) + (((t2 * t2) * t2) * t2))) + start)
  }
});
$c_Lio_youi_easing_Quartic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  return (((-change) * ((-1.0) + (((t * t) * t) * t))) + start)
});
$c_Lio_youi_easing_Quartic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return (((((change * t) * t) * t) * t) + start)
});
var $d_Lio_youi_easing_Quartic$ = new $TypeData().initClass({
  Lio_youi_easing_Quartic$: 0
}, false, "io.youi.easing.Quartic$", {
  Lio_youi_easing_Quartic$: 1,
  O: 1
});
$c_Lio_youi_easing_Quartic$.prototype.$classData = $d_Lio_youi_easing_Quartic$;
var $n_Lio_youi_easing_Quartic$ = (void 0);
function $m_Lio_youi_easing_Quartic$() {
  if ((!$n_Lio_youi_easing_Quartic$)) {
    $n_Lio_youi_easing_Quartic$ = new $c_Lio_youi_easing_Quartic$().init___()
  };
  return $n_Lio_youi_easing_Quartic$
}
/** @constructor */
function $c_Lio_youi_easing_Quintic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Quintic$.prototype = new $h_O();
$c_Lio_youi_easing_Quintic$.prototype.constructor = $c_Lio_youi_easing_Quintic$;
/** @constructor */
function $h_Lio_youi_easing_Quintic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Quintic$.prototype = $c_Lio_youi_easing_Quintic$.prototype;
$c_Lio_youi_easing_Quintic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Quintic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return (((((((change / 2.0) * t) * t) * t) * t) * t) + start)
  } else {
    var t2 = ((-2.0) + t);
    return (((change / 2.0) * (2.0 + ((((t2 * t2) * t2) * t2) * t2))) + start)
  }
});
$c_Lio_youi_easing_Quintic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  return ((change * (1.0 + ((((t * t) * t) * t) * t))) + start)
});
$c_Lio_youi_easing_Quintic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return ((((((change * t) * t) * t) * t) * t) + start)
});
var $d_Lio_youi_easing_Quintic$ = new $TypeData().initClass({
  Lio_youi_easing_Quintic$: 0
}, false, "io.youi.easing.Quintic$", {
  Lio_youi_easing_Quintic$: 1,
  O: 1
});
$c_Lio_youi_easing_Quintic$.prototype.$classData = $d_Lio_youi_easing_Quintic$;
var $n_Lio_youi_easing_Quintic$ = (void 0);
function $m_Lio_youi_easing_Quintic$() {
  if ((!$n_Lio_youi_easing_Quintic$)) {
    $n_Lio_youi_easing_Quintic$ = new $c_Lio_youi_easing_Quintic$().init___()
  };
  return $n_Lio_youi_easing_Quintic$
}
/** @constructor */
function $c_Lio_youi_easing_Sine$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Sine$.prototype = new $h_O();
$c_Lio_youi_easing_Sine$.prototype.constructor = $c_Lio_youi_easing_Sine$;
/** @constructor */
function $h_Lio_youi_easing_Sine$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Sine$.prototype = $c_Lio_youi_easing_Sine$.prototype;
$c_Lio_youi_easing_Sine$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Sine$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var x = ((3.141592653589793 * time) / duration);
  return ((((-change) / 2.0) * ((-1.0) + $uD($g.Math.cos(x)))) + start)
});
$c_Lio_youi_easing_Sine$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var x = (1.5707963267948966 * (time / duration));
  return ((change * $uD($g.Math.sin(x))) + start)
});
$c_Lio_youi_easing_Sine$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var x = (1.5707963267948966 * (time / duration));
  return ((((-change) * $uD($g.Math.cos(x))) + change) + start)
});
var $d_Lio_youi_easing_Sine$ = new $TypeData().initClass({
  Lio_youi_easing_Sine$: 0
}, false, "io.youi.easing.Sine$", {
  Lio_youi_easing_Sine$: 1,
  O: 1
});
$c_Lio_youi_easing_Sine$.prototype.$classData = $d_Lio_youi_easing_Sine$;
var $n_Lio_youi_easing_Sine$ = (void 0);
function $m_Lio_youi_easing_Sine$() {
  if ((!$n_Lio_youi_easing_Sine$)) {
    $n_Lio_youi_easing_Sine$ = new $c_Lio_youi_easing_Sine$().init___()
  };
  return $n_Lio_youi_easing_Sine$
}
/** @constructor */
function $c_Lio_youi_event_Event$() {
  $c_O.call(this);
  this.threadLocal$1 = null
}
$c_Lio_youi_event_Event$.prototype = new $h_O();
$c_Lio_youi_event_Event$.prototype.constructor = $c_Lio_youi_event_Event$;
/** @constructor */
function $h_Lio_youi_event_Event$() {
  /*<skip>*/
}
$h_Lio_youi_event_Event$.prototype = $c_Lio_youi_event_Event$.prototype;
$c_Lio_youi_event_Event$.prototype.init___ = (function() {
  $n_Lio_youi_event_Event$ = this;
  this.threadLocal$1 = new $c_Lio_youi_event_Event$$anon$1().init___();
  return this
});
$c_Lio_youi_event_Event$.prototype.io$youi$event$Event$$stopPropagation__Lio_youi_event_Event__V = (function(event) {
  var map = $as_sci_Map(this.threadLocal$1.get__O());
  var eventStatus = $as_Lio_youi_event_EventStatus(map.getOrElse__O__F0__O(event, new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return new $c_Lio_youi_event_EventStatus().init___Z(true)
    })
  })(this))));
  this.threadLocal$1.set__O__V(map.$$plus__T2__sci_Map(new $c_T2().init___O__O(event, eventStatus)))
});
var $d_Lio_youi_event_Event$ = new $TypeData().initClass({
  Lio_youi_event_Event$: 0
}, false, "io.youi.event.Event$", {
  Lio_youi_event_Event$: 1,
  O: 1
});
$c_Lio_youi_event_Event$.prototype.$classData = $d_Lio_youi_event_Event$;
var $n_Lio_youi_event_Event$ = (void 0);
function $m_Lio_youi_event_Event$() {
  if ((!$n_Lio_youi_event_Event$)) {
    $n_Lio_youi_event_Event$ = new $c_Lio_youi_event_Event$().init___()
  };
  return $n_Lio_youi_event_Event$
}
/** @constructor */
function $c_Lio_youi_event_EventSupport$pointer$() {
  $c_O.call(this);
  this.move$1 = null;
  this.enter$1 = null;
  this.exit$1 = null;
  this.down$1 = null;
  this.up$1 = null;
  this.cancel$1 = null;
  this.wheel$1 = null;
  this.x$1$1 = null;
  this.x$1 = null;
  this.y$1 = null;
  this.overState$1 = null;
  this.downState$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_event_EventSupport$pointer$.prototype = new $h_O();
$c_Lio_youi_event_EventSupport$pointer$.prototype.constructor = $c_Lio_youi_event_EventSupport$pointer$;
/** @constructor */
function $h_Lio_youi_event_EventSupport$pointer$() {
  /*<skip>*/
}
$h_Lio_youi_event_EventSupport$pointer$.prototype = $c_Lio_youi_event_EventSupport$pointer$.prototype;
$c_Lio_youi_event_EventSupport$pointer$.prototype.overState__Lreactify_Val = (function() {
  return (((1024 & this.bitmap$0$1) === 0) ? this.overState$lzycompute__p1__Lreactify_Val() : this.overState$1)
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.enter__Lreactify_Channel = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.enter$lzycompute__p1__Lreactify_Channel() : this.enter$1)
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.move$lzycompute__p1__Lreactify_Channel = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.move$1 = this.$$outer$1.pointerChannel__Lio_youi_event_PointerEvent$Type__Lreactify_Channel($m_Lio_youi_event_PointerEvent$Type$Move$());
    this.bitmap$0$1 = (1 | this.bitmap$0$1)
  };
  return this.move$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.move__Lreactify_Channel = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.move$lzycompute__p1__Lreactify_Channel() : this.move$1)
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.init___Lio_youi_event_EventSupport = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.exit$lzycompute__p1__Lreactify_Channel = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.exit$1 = this.$$outer$1.pointerChannel__Lio_youi_event_PointerEvent$Type__Lreactify_Channel($m_Lio_youi_event_PointerEvent$Type$Exit$());
    this.bitmap$0$1 = (4 | this.bitmap$0$1)
  };
  return this.exit$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.exit__Lreactify_Channel = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.exit$lzycompute__p1__Lreactify_Channel() : this.exit$1)
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.overState$lzycompute__p1__Lreactify_Val = (function() {
  if (((1024 & this.bitmap$0$1) === 0)) {
    this.overState$1 = $as_Lreactify_Val(this.x$1__p1__T3().$$und3$1);
    this.bitmap$0$1 = (1024 | this.bitmap$0$1)
  };
  return this.overState$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.enter$lzycompute__p1__Lreactify_Channel = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.enter$1 = this.$$outer$1.pointerChannel__Lio_youi_event_PointerEvent$Type__Lreactify_Channel($m_Lio_youi_event_PointerEvent$Type$Enter$());
    this.bitmap$0$1 = (2 | this.bitmap$0$1)
  };
  return this.enter$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.x$1$lzycompute__p1__T3 = (function() {
  if (((128 & this.bitmap$0$1) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var mode = $m_Lreactify_Var$Mode$Normal$();
    var name = $m_s_None$();
    var px = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
      return (function() {
        return 0.0
      })
    })(this));
    var mode$1 = $m_Lreactify_Var$Mode$Normal$();
    var name$1 = $m_s_None$();
    var py = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
    var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
      return (function() {
        return false
      })
    })(this));
    var mode$2 = $m_Lreactify_Var$Mode$Normal$();
    var name$2 = $m_s_None$();
    var o = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$2, name$2);
    var this$11 = this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().enter__Lreactify_Channel();
    var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, o$1) {
      return (function() {
        var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
          return (function() {
            return true
          })
        })(this$4$1));
        o$1.set__F0__V(value$3)
      })
    })(this, o));
    this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().enter__Lreactify_Channel();
    var priority = $m_Lreactify_Priority$().Normal$1;
    $f_Lreactify_Reactive__on__F0__D__Lreactify_reaction_Reaction(this$11, f, priority);
    var this$13 = this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().exit__Lreactify_Channel();
    var f$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1, o$2) {
      return (function() {
        var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$2) {
          return (function() {
            return false
          })
        })(this$5$1));
        o$2.set__F0__V(value$4)
      })
    })(this, o));
    this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().exit__Lreactify_Channel();
    var priority$1 = $m_Lreactify_Priority$().Normal$1;
    $f_Lreactify_Reactive__on__F0__D__Lreactify_reaction_Reaction(this$13, f$1, priority$1);
    var this$15 = this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().move__Lreactify_Channel();
    var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$6$1, px$1, py$1) {
      return (function(evt$2) {
        var evt = $as_Lio_youi_event_PointerEvent(evt$2);
        var value$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$3, evt$1) {
          return (function() {
            return evt$1.local__Lio_youi_spatial_Point().x$1
          })
        })(this$6$1, evt));
        px$1.set__F0__V(value$5);
        var value$6 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$2, evt$3) {
          return (function() {
            return evt$3.local__Lio_youi_spatial_Point().y$1
          })
        })(this$6$1, evt));
        py$1.set__F0__V(value$6)
      })
    })(this, px, py));
    this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().move__Lreactify_Channel();
    var priority$2 = $m_Lreactify_Priority$().Normal$1;
    $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$15, f$2, priority$2);
    var jsx$1;
    var jsx$1 = new $c_T3().init___O__O__O(px, py, o);
    this.x$1$1 = jsx$1;
    this.bitmap$0$1 = (128 | this.bitmap$0$1)
  };
  return this.x$1$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.x$1__p1__T3 = (function() {
  return (((128 & this.bitmap$0$1) === 0) ? this.x$1$lzycompute__p1__T3() : this.x$1$1)
});
var $d_Lio_youi_event_EventSupport$pointer$ = new $TypeData().initClass({
  Lio_youi_event_EventSupport$pointer$: 0
}, false, "io.youi.event.EventSupport$pointer$", {
  Lio_youi_event_EventSupport$pointer$: 1,
  O: 1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.$classData = $d_Lio_youi_event_EventSupport$pointer$;
/** @constructor */
function $c_Lio_youi_event_HTMLEvents$() {
  $c_O.call(this);
  this.hasPointerSupport$1 = false;
  this.hasTouchSupport$1 = false;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_event_HTMLEvents$.prototype = new $h_O();
$c_Lio_youi_event_HTMLEvents$.prototype.constructor = $c_Lio_youi_event_HTMLEvents$;
/** @constructor */
function $h_Lio_youi_event_HTMLEvents$() {
  /*<skip>*/
}
$h_Lio_youi_event_HTMLEvents$.prototype = $c_Lio_youi_event_HTMLEvents$.prototype;
$c_Lio_youi_event_HTMLEvents$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_event_HTMLEvents$.prototype.hasPointerSupport$lzycompute__p1__Z = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.hasPointerSupport$1 = ($as_T((typeof $g.PointerEvent)) !== "undefined");
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.hasPointerSupport$1
});
$c_Lio_youi_event_HTMLEvents$.prototype.hasPointerSupport__Z = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.hasPointerSupport$lzycompute__p1__Z() : this.hasPointerSupport$1)
});
var $d_Lio_youi_event_HTMLEvents$ = new $TypeData().initClass({
  Lio_youi_event_HTMLEvents$: 0
}, false, "io.youi.event.HTMLEvents$", {
  Lio_youi_event_HTMLEvents$: 1,
  O: 1
});
$c_Lio_youi_event_HTMLEvents$.prototype.$classData = $d_Lio_youi_event_HTMLEvents$;
var $n_Lio_youi_event_HTMLEvents$ = (void 0);
function $m_Lio_youi_event_HTMLEvents$() {
  if ((!$n_Lio_youi_event_HTMLEvents$)) {
    $n_Lio_youi_event_HTMLEvents$ = new $c_Lio_youi_event_HTMLEvents$().init___()
  };
  return $n_Lio_youi_event_HTMLEvents$
}
/** @constructor */
function $c_Lio_youi_event_PointerEvent$Type() {
  $c_O.call(this);
  this.htmlTypeString$1 = null;
  this.type$1 = null;
  this.includePrefix$1 = false;
  this.bitmap$0$1 = false
}
$c_Lio_youi_event_PointerEvent$Type.prototype = new $h_O();
$c_Lio_youi_event_PointerEvent$Type.prototype.constructor = $c_Lio_youi_event_PointerEvent$Type;
/** @constructor */
function $h_Lio_youi_event_PointerEvent$Type() {
  /*<skip>*/
}
$h_Lio_youi_event_PointerEvent$Type.prototype = $c_Lio_youi_event_PointerEvent$Type.prototype;
$c_Lio_youi_event_PointerEvent$Type.prototype.htmlTypeString__T = (function() {
  return ((!this.bitmap$0$1) ? this.htmlTypeString$lzycompute__p1__T() : this.htmlTypeString$1)
});
$c_Lio_youi_event_PointerEvent$Type.prototype.htmlType__Lio_youi_event_HTMLEventType = (function() {
  var x1 = this.htmlTypeString__T();
  return ((($uI(x1.length) >= 0) && ($as_T(x1.substring(0, $uI("pointer".length))) === "pointer")) ? $m_Lio_youi_event_HTMLEventType$Pointer$() : ((($uI(x1.length) >= 0) && ($as_T(x1.substring(0, $uI("touch".length))) === "touch")) ? $m_Lio_youi_event_HTMLEventType$Touch$() : $m_Lio_youi_event_HTMLEventType$Mouse$()))
});
$c_Lio_youi_event_PointerEvent$Type.prototype.htmlTypeString$lzycompute__p1__T = (function() {
  if ((!this.bitmap$0$1)) {
    if (this.includePrefix$1) {
      var prefix = ($m_Lio_youi_event_HTMLEvents$().hasPointerSupport__Z() ? "pointer" : "mouse");
      var jsx$1 = (prefix + this.type$1)
    } else {
      var jsx$1 = this.type$1
    };
    this.htmlTypeString$1 = jsx$1;
    this.bitmap$0$1 = true
  };
  return this.htmlTypeString$1
});
$c_Lio_youi_event_PointerEvent$Type.prototype.init___T__Z = (function(type, includePrefix) {
  this.type$1 = type;
  this.includePrefix$1 = includePrefix;
  return this
});
/** @constructor */
function $c_Lio_youi_example_ClientExampleApplication$colors$blue$() {
  $c_O.call(this);
  this.dark$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.light$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype = new $h_O();
$c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype.constructor = $c_Lio_youi_example_ClientExampleApplication$colors$blue$;
/** @constructor */
function $h_Lio_youi_example_ClientExampleApplication$colors$blue$() {
  /*<skip>*/
}
$h_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype = $c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype;
$c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype.init___ = (function() {
  $n_Lio_youi_example_ClientExampleApplication$colors$blue$ = this;
  this.dark$1 = ($m_Lio_youi_Color$(), new $c_sjsr_RuntimeLong().init___I__I(375494399, 0));
  this.light$1 = ($m_Lio_youi_Color$(), new $c_sjsr_RuntimeLong().init___I__I(1672801791, 0));
  return this
});
var $d_Lio_youi_example_ClientExampleApplication$colors$blue$ = new $TypeData().initClass({
  Lio_youi_example_ClientExampleApplication$colors$blue$: 0
}, false, "io.youi.example.ClientExampleApplication$colors$blue$", {
  Lio_youi_example_ClientExampleApplication$colors$blue$: 1,
  O: 1
});
$c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype.$classData = $d_Lio_youi_example_ClientExampleApplication$colors$blue$;
var $n_Lio_youi_example_ClientExampleApplication$colors$blue$ = (void 0);
function $m_Lio_youi_example_ClientExampleApplication$colors$blue$() {
  if ((!$n_Lio_youi_example_ClientExampleApplication$colors$blue$)) {
    $n_Lio_youi_example_ClientExampleApplication$colors$blue$ = new $c_Lio_youi_example_ClientExampleApplication$colors$blue$().init___()
  };
  return $n_Lio_youi_example_ClientExampleApplication$colors$blue$
}
/** @constructor */
function $c_Lio_youi_example_screen_BootstrapComponent() {
  $c_O.call(this);
  this.element$1 = null
}
$c_Lio_youi_example_screen_BootstrapComponent.prototype = new $h_O();
$c_Lio_youi_example_screen_BootstrapComponent.prototype.constructor = $c_Lio_youi_example_screen_BootstrapComponent;
/** @constructor */
function $h_Lio_youi_example_screen_BootstrapComponent() {
  /*<skip>*/
}
$h_Lio_youi_example_screen_BootstrapComponent.prototype = $c_Lio_youi_example_screen_BootstrapComponent.prototype;
$c_Lio_youi_example_screen_BootstrapComponent.prototype.content__T__Lio_youi_example_screen_BootstrapComponent = (function(value) {
  this.element$1.innerHTML = value;
  return this
});
$c_Lio_youi_example_screen_BootstrapComponent.prototype.init___Lorg_scalajs_dom_raw_HTMLElement = (function(element) {
  this.element$1 = element;
  return this
});
/** @constructor */
function $c_Lio_youi_example_screen_UIExampleScreen$() {
  $c_O.call(this);
  this.header$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_example_screen_UIExampleScreen$.prototype = new $h_O();
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.constructor = $c_Lio_youi_example_screen_UIExampleScreen$;
/** @constructor */
function $h_Lio_youi_example_screen_UIExampleScreen$() {
  /*<skip>*/
}
$h_Lio_youi_example_screen_UIExampleScreen$.prototype = $c_Lio_youi_example_screen_UIExampleScreen$.prototype;
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.header$lzycompute__p1__Lio_youi_example_ui_component_Header = (function() {
  if ((!this.bitmap$0$1)) {
    var h = new $c_Lio_youi_example_ui_component_Header().init___();
    var v = $m_Lio_youi_ui$().children__Lreactify_Var();
    new $c_Lreactify_package$VectorVar().init___Lreactify_Var(v).$$plus$eq__O__V(h);
    this.header$1 = h;
    this.bitmap$0$1 = true
  };
  return this.header$1
});
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.header__Lio_youi_example_ui_component_Header = (function() {
  return ((!this.bitmap$0$1) ? this.header$lzycompute__p1__Lio_youi_example_ui_component_Header() : this.header$1)
});
var $d_Lio_youi_example_screen_UIExampleScreen$ = new $TypeData().initClass({
  Lio_youi_example_screen_UIExampleScreen$: 0
}, false, "io.youi.example.screen.UIExampleScreen$", {
  Lio_youi_example_screen_UIExampleScreen$: 1,
  O: 1
});
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.$classData = $d_Lio_youi_example_screen_UIExampleScreen$;
var $n_Lio_youi_example_screen_UIExampleScreen$ = (void 0);
function $m_Lio_youi_example_screen_UIExampleScreen$() {
  if ((!$n_Lio_youi_example_screen_UIExampleScreen$)) {
    $n_Lio_youi_example_screen_UIExampleScreen$ = new $c_Lio_youi_example_screen_UIExampleScreen$().init___()
  };
  return $n_Lio_youi_example_screen_UIExampleScreen$
}
/** @constructor */
function $c_Lio_youi_example_screen_bootstrap$() {
  $c_O.call(this)
}
$c_Lio_youi_example_screen_bootstrap$.prototype = new $h_O();
$c_Lio_youi_example_screen_bootstrap$.prototype.constructor = $c_Lio_youi_example_screen_bootstrap$;
/** @constructor */
function $h_Lio_youi_example_screen_bootstrap$() {
  /*<skip>*/
}
$h_Lio_youi_example_screen_bootstrap$.prototype = $c_Lio_youi_example_screen_bootstrap$.prototype;
$c_Lio_youi_example_screen_bootstrap$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_example_screen_bootstrap$.prototype.button__Lio_youi_example_screen_Button = (function() {
  var b = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("button");
  b.classList.add("btn");
  b.classList.add("btn-primary");
  return new $c_Lio_youi_example_screen_Button().init___Lorg_scalajs_dom_raw_HTMLButtonElement(b)
});
var $d_Lio_youi_example_screen_bootstrap$ = new $TypeData().initClass({
  Lio_youi_example_screen_bootstrap$: 0
}, false, "io.youi.example.screen.bootstrap$", {
  Lio_youi_example_screen_bootstrap$: 1,
  O: 1
});
$c_Lio_youi_example_screen_bootstrap$.prototype.$classData = $d_Lio_youi_example_screen_bootstrap$;
var $n_Lio_youi_example_screen_bootstrap$ = (void 0);
function $m_Lio_youi_example_screen_bootstrap$() {
  if ((!$n_Lio_youi_example_screen_bootstrap$)) {
    $n_Lio_youi_example_screen_bootstrap$ = new $c_Lio_youi_example_screen_bootstrap$().init___()
  };
  return $n_Lio_youi_example_screen_bootstrap$
}
/** @constructor */
function $c_Lio_youi_example_ui_GridLayoutExample$Box$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype = new $h_O();
$c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype.constructor = $c_Lio_youi_example_ui_GridLayoutExample$Box$;
/** @constructor */
function $h_Lio_youi_example_ui_GridLayoutExample$Box$() {
  /*<skip>*/
}
$h_Lio_youi_example_ui_GridLayoutExample$Box$.prototype = $c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype;
$c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype.init___Lio_youi_example_ui_GridLayoutExample = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_example_ui_GridLayoutExample$Box$ = new $TypeData().initClass({
  Lio_youi_example_ui_GridLayoutExample$Box$: 0
}, false, "io.youi.example.ui.GridLayoutExample$Box$", {
  Lio_youi_example_ui_GridLayoutExample$Box$: 1,
  O: 1
});
$c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype.$classData = $d_Lio_youi_example_ui_GridLayoutExample$Box$;
/** @constructor */
function $c_Lio_youi_example_ui_SnapExample$Box$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_example_ui_SnapExample$Box$.prototype = new $h_O();
$c_Lio_youi_example_ui_SnapExample$Box$.prototype.constructor = $c_Lio_youi_example_ui_SnapExample$Box$;
/** @constructor */
function $h_Lio_youi_example_ui_SnapExample$Box$() {
  /*<skip>*/
}
$h_Lio_youi_example_ui_SnapExample$Box$.prototype = $c_Lio_youi_example_ui_SnapExample$Box$.prototype;
$c_Lio_youi_example_ui_SnapExample$Box$.prototype.init___Lio_youi_example_ui_SnapExample = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_example_ui_SnapExample$Box$ = new $TypeData().initClass({
  Lio_youi_example_ui_SnapExample$Box$: 0
}, false, "io.youi.example.ui.SnapExample$Box$", {
  Lio_youi_example_ui_SnapExample$Box$: 1,
  O: 1
});
$c_Lio_youi_example_ui_SnapExample$Box$.prototype.$classData = $d_Lio_youi_example_ui_SnapExample$Box$;
/** @constructor */
function $c_Lio_youi_example_ui_VerticalLayoutExample$Box$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype = new $h_O();
$c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype.constructor = $c_Lio_youi_example_ui_VerticalLayoutExample$Box$;
/** @constructor */
function $h_Lio_youi_example_ui_VerticalLayoutExample$Box$() {
  /*<skip>*/
}
$h_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype = $c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype;
$c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype.init___Lio_youi_example_ui_VerticalLayoutExample = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_example_ui_VerticalLayoutExample$Box$ = new $TypeData().initClass({
  Lio_youi_example_ui_VerticalLayoutExample$Box$: 0
}, false, "io.youi.example.ui.VerticalLayoutExample$Box$", {
  Lio_youi_example_ui_VerticalLayoutExample$Box$: 1,
  O: 1
});
$c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype.$classData = $d_Lio_youi_example_ui_VerticalLayoutExample$Box$;
/** @constructor */
function $c_Lio_youi_font_GoogleFont$() {
  $c_O.call(this);
  this.io$youi$font$GoogleFont$$base$1 = null
}
$c_Lio_youi_font_GoogleFont$.prototype = new $h_O();
$c_Lio_youi_font_GoogleFont$.prototype.constructor = $c_Lio_youi_font_GoogleFont$;
/** @constructor */
function $h_Lio_youi_font_GoogleFont$() {
  /*<skip>*/
}
$h_Lio_youi_font_GoogleFont$.prototype = $c_Lio_youi_font_GoogleFont$.prototype;
$c_Lio_youi_font_GoogleFont$.prototype.init___ = (function() {
  this.io$youi$font$GoogleFont$$base$1 = "https://fonts.gstatic.com/s";
  return this
});
var $d_Lio_youi_font_GoogleFont$ = new $TypeData().initClass({
  Lio_youi_font_GoogleFont$: 0
}, false, "io.youi.font.GoogleFont$", {
  Lio_youi_font_GoogleFont$: 1,
  O: 1
});
$c_Lio_youi_font_GoogleFont$.prototype.$classData = $d_Lio_youi_font_GoogleFont$;
var $n_Lio_youi_font_GoogleFont$ = (void 0);
function $m_Lio_youi_font_GoogleFont$() {
  if ((!$n_Lio_youi_font_GoogleFont$)) {
    $n_Lio_youi_font_GoogleFont$ = new $c_Lio_youi_font_GoogleFont$().init___()
  };
  return $n_Lio_youi_font_GoogleFont$
}
/** @constructor */
function $c_Lio_youi_http_Connection() {
  $c_O.call(this);
  this.$$undconnected$1 = null;
  this.connected$1 = null;
  this.send$1 = null;
  this.receive$1 = null;
  this.error$1 = null;
  this.store$1 = null;
  this.io$youi$http$Connection$$backlog$1 = null
}
$c_Lio_youi_http_Connection.prototype = new $h_O();
$c_Lio_youi_http_Connection.prototype.constructor = $c_Lio_youi_http_Connection;
/** @constructor */
function $h_Lio_youi_http_Connection() {
  /*<skip>*/
}
$h_Lio_youi_http_Connection.prototype = $c_Lio_youi_http_Connection.prototype;
$c_Lio_youi_http_Connection.prototype.init___ = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return false
    })
  })(this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.$$undconnected$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      var v = this$2$1.$$undconnected$1;
      return $uZ(v.state__Lreactify_State().value__O())
    })
  })(this));
  var name$1 = $m_s_None$();
  this.connected$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$1);
  this.send$1 = new $c_Lio_youi_http_WebSocketChannels().init___();
  this.receive$1 = new $c_Lio_youi_http_WebSocketChannels().init___();
  this.error$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  this.store$1 = new $c_Lio_youi_MapStore().init___sci_Map($m_sci_Map$EmptyMap$());
  $m_scm_ListBuffer$();
  var this$11 = new $c_scm_GrowingBuilder().init___scg_Growable(new $c_scm_ListBuffer().init___());
  this.io$youi$http$Connection$$backlog$1 = $as_scm_ListBuffer($as_sc_GenTraversable(this$11.elems$1));
  this.init__p1__V();
  return this
});
$c_Lio_youi_http_Connection.prototype.init__p1__V = (function() {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(t$2) {
      var t = $as_T(t$2);
      $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V($this, t)
    })
  })(this));
  var priority = $m_Lreactify_Priority$().Normal$1;
  var textReaction = new $c_Lreactify_reaction_FunctionReaction().init___F1__D(f, priority);
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(b$2) {
      var b = $asArrayOf_Ljava_nio_ByteBuffer(b$2, 1);
      $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V(this$2$1, b)
    })
  })(this));
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  var binaryReaction = new $c_Lreactify_reaction_FunctionReaction().init___F1__D(f$1, priority$1);
  this.send$1.text$1.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(textReaction);
  this.send$1.binary$1.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(binaryReaction);
  var this$11 = this.send$1.text$1;
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1) {
    return (function(s$2) {
      var s = $as_T(s$2);
      if ($m_Lio_youi_http_Connection$().debug$1) {
        var jsx$1 = $m_Lscribe_package$();
        var level = $m_Lscribe_Level$Info$();
        var value = $m_Lscribe_Level$Info$().value$1;
        var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, s$1) {
          return (function() {
            return ("Send: " + s$1)
          })
        })(this$3$1, s));
        var loggable = $m_Lscribe_Loggable$StringLoggable$();
        var throwable = $m_s_None$();
        var methodName = new $c_s_Some().init___O("init");
        var line = new $c_s_Some().init___O(36);
        var column = new $c_s_Some().init___O(40);
        var thread = $m_jl_Thread$().SingleThread$1;
        var this$7 = $m_Lscribe_util_Time$();
        var this$8 = this$7.function$1;
        var t$1 = $uJ(this$8.apply__O());
        var lo = t$1.lo$2;
        var hi = t$1.hi$2;
        jsx$1.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/core/shared/src/main/scala/io/youi/http/Connection.scala", "io.youi.http.Connection", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi)))
      }
    })
  })(this));
  var priority$2 = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$11, f$2, priority$2);
  var this$18 = this.receive$1.text$1;
  var f$3 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
    return (function(s$3$2) {
      var s$3 = $as_T(s$3$2);
      if ($m_Lio_youi_http_Connection$().debug$1) {
        var jsx$2 = $m_Lscribe_package$();
        var level$1 = $m_Lscribe_Level$Info$();
        var value$1 = $m_Lscribe_Level$Info$().value$1;
        var messageFunction$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$2, s$4) {
          return (function() {
            return ("Receive: " + s$4)
          })
        })(this$4$1, s$3));
        var loggable$1 = $m_Lscribe_Loggable$StringLoggable$();
        var throwable$1 = $m_s_None$();
        var methodName$1 = new $c_s_Some().init___O("init");
        var line$1 = new $c_s_Some().init___O(39);
        var column$1 = new $c_s_Some().init___O(40);
        var thread$1 = $m_jl_Thread$().SingleThread$1;
        var this$14 = $m_Lscribe_util_Time$();
        var this$15 = this$14.function$1;
        var t$3 = $uJ(this$15.apply__O());
        var lo$1 = t$3.lo$2;
        var hi$1 = t$3.hi$2;
        jsx$2.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level$1, value$1, messageFunction$1, loggable$1, throwable$1, "/home/mhicks/projects/open/youi/core/shared/src/main/scala/io/youi/http/Connection.scala", "io.youi.http.Connection", methodName$1, line$1, column$1, thread$1, new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1)))
      }
    })
  })(this));
  var priority$3 = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$18, f$3, priority$3);
  var this$21 = this.send$1.close$1;
  var f$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1) {
    return (function() {
      var this$19 = this$5$1.$$undconnected$1;
      var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$3) {
        return (function() {
          return false
        })
      })(this$5$1));
      this$19.set__F0__V(value$2)
    })
  })(this));
  var priority$4 = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__on__F0__D__Lreactify_reaction_Reaction(this$21, f$4, priority$4);
  var this$24 = this.receive$1.close$1;
  var f$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$6$1) {
    return (function() {
      var this$22 = this$6$1.$$undconnected$1;
      var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$4) {
        return (function() {
          return false
        })
      })(this$6$1));
      this$22.set__F0__V(value$3)
    })
  })(this));
  var priority$5 = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__on__F0__D__Lreactify_reaction_Reaction(this$24, f$5, priority$5);
  var this$30 = this.connected$1;
  var f$6 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$7$1, textReaction$1, binaryReaction$1) {
    return (function(b$3$2) {
      var b$3 = $uZ(b$3$2);
      this$7$1.send$1.text$1.reactions__Lreactify_reaction_Reactions().$$minus$eq__Lreactify_reaction_Reaction__Z(textReaction$1);
      this$7$1.send$1.binary$1.reactions__Lreactify_reaction_Reactions().$$minus$eq__Lreactify_reaction_Reaction__Z(binaryReaction$1);
      if (b$3) {
        var this$25 = this$7$1.io$youi$http$Connection$$backlog$1;
        var this$26 = this$25.scala$collection$mutable$ListBuffer$$start$6;
        var these = this$26;
        while ((!these.isEmpty__Z())) {
          var arg1 = these.head__O();
          if ($is_T(arg1)) {
            var x2 = $as_T(arg1);
            var this$27 = this$7$1.send$1.text$1;
            var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$5, x2$1) {
              return (function() {
                return x2$1
              })
            })(this$7$1, x2));
            this$27.set__F0__V(value$4)
          } else if ($isArrayOf_Ljava_nio_ByteBuffer(arg1, 1)) {
            var x3 = $asArrayOf_Ljava_nio_ByteBuffer(arg1, 1);
            var this$28 = this$7$1.send$1.binary$1;
            var value$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$2, x3$1) {
              return (function() {
                return x3$1
              })
            })(this$7$1, x3));
            this$28.set__F0__V(value$5)
          } else {
            throw new $c_s_MatchError().init___O(arg1)
          };
          these = $as_sci_List(these.tail__O())
        };
        this$7$1.io$youi$http$Connection$$backlog$1.clear__V()
      } else {
        this$7$1.send$1.text$1.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(textReaction$1);
        this$7$1.send$1.binary$1.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(binaryReaction$1)
      }
    })
  })(this, textReaction, binaryReaction));
  var priority$6 = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$30, f$6, priority$6)
});
$c_Lio_youi_http_Connection.prototype.close__V = (function() {
  var this$1 = this.connected$1;
  if ($uZ(this$1.state__Lreactify_State().value__O())) {
    var this$2 = this.send$1.close$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return (void 0)
      })
    })(this));
    this$2.set__F0__V(value);
    var this$3 = this.$$undconnected$1;
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
      return (function() {
        return false
      })
    })(this));
    this$3.set__F0__V(value$1)
  }
});
function $is_Lio_youi_http_Connection(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_http_Connection)))
}
function $as_Lio_youi_http_Connection(obj) {
  return (($is_Lio_youi_http_Connection(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.http.Connection"))
}
function $isArrayOf_Lio_youi_http_Connection(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_http_Connection)))
}
function $asArrayOf_Lio_youi_http_Connection(obj, depth) {
  return (($isArrayOf_Lio_youi_http_Connection(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.http.Connection;", depth))
}
var $d_Lio_youi_http_Connection = new $TypeData().initClass({
  Lio_youi_http_Connection: 0
}, false, "io.youi.http.Connection", {
  Lio_youi_http_Connection: 1,
  O: 1
});
$c_Lio_youi_http_Connection.prototype.$classData = $d_Lio_youi_http_Connection;
/** @constructor */
function $c_Lio_youi_http_Connection$() {
  $c_O.call(this);
  this.debug$1 = false;
  this.key$1 = null
}
$c_Lio_youi_http_Connection$.prototype = new $h_O();
$c_Lio_youi_http_Connection$.prototype.constructor = $c_Lio_youi_http_Connection$;
/** @constructor */
function $h_Lio_youi_http_Connection$() {
  /*<skip>*/
}
$h_Lio_youi_http_Connection$.prototype = $c_Lio_youi_http_Connection$.prototype;
$c_Lio_youi_http_Connection$.prototype.init___ = (function() {
  this.debug$1 = false;
  this.key$1 = "webSocketConnection";
  return this
});
$c_Lio_youi_http_Connection$.prototype.backlog__Lio_youi_http_Connection__O__V = (function(listener, message) {
  if ((listener === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  listener.io$youi$http$Connection$$backlog$1.$$plus$eq__O__scm_ListBuffer(message)
});
var $d_Lio_youi_http_Connection$ = new $TypeData().initClass({
  Lio_youi_http_Connection$: 0
}, false, "io.youi.http.Connection$", {
  Lio_youi_http_Connection$: 1,
  O: 1
});
$c_Lio_youi_http_Connection$.prototype.$classData = $d_Lio_youi_http_Connection$;
var $n_Lio_youi_http_Connection$ = (void 0);
function $m_Lio_youi_http_Connection$() {
  if ((!$n_Lio_youi_http_Connection$)) {
    $n_Lio_youi_http_Connection$ = new $c_Lio_youi_http_Connection$().init___()
  };
  return $n_Lio_youi_http_Connection$
}
/** @constructor */
function $c_Lio_youi_http_WebSocketChannels() {
  $c_O.call(this);
  this.text$1 = null;
  this.binary$1 = null;
  this.close$1 = null
}
$c_Lio_youi_http_WebSocketChannels.prototype = new $h_O();
$c_Lio_youi_http_WebSocketChannels.prototype.constructor = $c_Lio_youi_http_WebSocketChannels;
/** @constructor */
function $h_Lio_youi_http_WebSocketChannels() {
  /*<skip>*/
}
$h_Lio_youi_http_WebSocketChannels.prototype = $c_Lio_youi_http_WebSocketChannels.prototype;
$c_Lio_youi_http_WebSocketChannels.prototype.init___ = (function() {
  this.text$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  this.binary$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  this.close$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  return this
});
var $d_Lio_youi_http_WebSocketChannels = new $TypeData().initClass({
  Lio_youi_http_WebSocketChannels: 0
}, false, "io.youi.http.WebSocketChannels", {
  Lio_youi_http_WebSocketChannels: 1,
  O: 1
});
$c_Lio_youi_http_WebSocketChannels.prototype.$classData = $d_Lio_youi_http_WebSocketChannels;
/** @constructor */
function $c_Lio_youi_http_WebSocketUtil$() {
  $c_O.call(this)
}
$c_Lio_youi_http_WebSocketUtil$.prototype = new $h_O();
$c_Lio_youi_http_WebSocketUtil$.prototype.constructor = $c_Lio_youi_http_WebSocketUtil$;
/** @constructor */
function $h_Lio_youi_http_WebSocketUtil$() {
  /*<skip>*/
}
$h_Lio_youi_http_WebSocketUtil$.prototype = $c_Lio_youi_http_WebSocketUtil$.prototype;
$c_Lio_youi_http_WebSocketUtil$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_http_WebSocketUtil$.prototype.connect__Lio_youi_net_URL__Lio_youi_http_Connection__Lorg_scalajs_dom_raw_WebSocket = (function(socketURL, listener) {
  var ws = new $g.WebSocket(socketURL.encoded__Lio_youi_net_URL$URLParts().asString__T());
  var this$2 = listener.send$1.text$1;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, listener$1, ws$1) {
    return (function(message$2) {
      var message = $as_T(message$2);
      if (($uI(ws$1.readyState) >= $uI($m_Lorg_scalajs_dom_package$().WebSocket__Lorg_scalajs_dom_raw_WebSocket$().CLOSING))) {
        listener$1.close__V();
        $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V(listener$1, message)
      } else if (($uI(ws$1.readyState) === $uI($m_Lorg_scalajs_dom_package$().WebSocket__Lorg_scalajs_dom_raw_WebSocket$().OPEN))) {
        ws$1.send(message)
      } else {
        $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V(listener$1, message)
      }
    })
  })(this, listener, ws));
  var priority = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$2, f, priority);
  ws.onopen = (function(listener$1$1) {
    return (function(arg1$2) {
      $m_Lio_youi_http_WebSocketUtil$().io$youi$http$WebSocketUtil$$$anonfun$connect$2__Lorg_scalajs_dom_raw_Event__Lio_youi_http_Connection__V(arg1$2, listener$1$1)
    })
  })(listener);
  ws.onerror = (function(listener$1$2) {
    return (function(arg1$2$1) {
      $m_Lio_youi_http_WebSocketUtil$().io$youi$http$WebSocketUtil$$$anonfun$connect$4__Lorg_scalajs_dom_raw_Event__Lio_youi_http_Connection__V(arg1$2$1, listener$1$2)
    })
  })(listener);
  ws.onclose = (function(listener$1$3) {
    return (function(arg1$2$2) {
      listener$1$3.close__V()
    })
  })(listener);
  ws.onmessage = (function(listener$1$4) {
    return (function(arg1$2$3) {
      $m_Lio_youi_http_WebSocketUtil$().io$youi$http$WebSocketUtil$$$anonfun$connect$7__Lorg_scalajs_dom_raw_MessageEvent__Lio_youi_http_Connection__V(arg1$2$3, listener$1$4)
    })
  })(listener);
  return ws
});
$c_Lio_youi_http_WebSocketUtil$.prototype.io$youi$http$WebSocketUtil$$$anonfun$connect$7__Lorg_scalajs_dom_raw_MessageEvent__Lio_youi_http_Connection__V = (function(evt, listener$1) {
  var message = $objectToString(evt.data);
  var this$1 = listener$1.receive$1.text$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, message$1) {
    return (function() {
      return message$1
    })
  })(this, message));
  this$1.set__F0__V(value)
});
$c_Lio_youi_http_WebSocketUtil$.prototype.io$youi$http$WebSocketUtil$$$anonfun$connect$4__Lorg_scalajs_dom_raw_Event__Lio_youi_http_Connection__V = (function(evt, listener$1) {
  var this$1 = listener$1.error$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return new $c_jl_RuntimeException().init___T("WebSocket error!")
    })
  })(this));
  this$1.set__F0__V(value);
  listener$1.close__V()
});
$c_Lio_youi_http_WebSocketUtil$.prototype.io$youi$http$WebSocketUtil$$$anonfun$connect$2__Lorg_scalajs_dom_raw_Event__Lio_youi_http_Connection__V = (function(evt, listener$1) {
  var this$1 = listener$1.$$undconnected$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return true
    })
  })(this));
  this$1.set__F0__V(value)
});
var $d_Lio_youi_http_WebSocketUtil$ = new $TypeData().initClass({
  Lio_youi_http_WebSocketUtil$: 0
}, false, "io.youi.http.WebSocketUtil$", {
  Lio_youi_http_WebSocketUtil$: 1,
  O: 1
});
$c_Lio_youi_http_WebSocketUtil$.prototype.$classData = $d_Lio_youi_http_WebSocketUtil$;
var $n_Lio_youi_http_WebSocketUtil$ = (void 0);
function $m_Lio_youi_http_WebSocketUtil$() {
  if ((!$n_Lio_youi_http_WebSocketUtil$)) {
    $n_Lio_youi_http_WebSocketUtil$ = new $c_Lio_youi_http_WebSocketUtil$().init___()
  };
  return $n_Lio_youi_http_WebSocketUtil$
}
/** @constructor */
function $c_Lio_youi_image_HTMLImage$() {
  $c_O.call(this)
}
$c_Lio_youi_image_HTMLImage$.prototype = new $h_O();
$c_Lio_youi_image_HTMLImage$.prototype.constructor = $c_Lio_youi_image_HTMLImage$;
/** @constructor */
function $h_Lio_youi_image_HTMLImage$() {
  /*<skip>*/
}
$h_Lio_youi_image_HTMLImage$.prototype = $c_Lio_youi_image_HTMLImage$.prototype;
$c_Lio_youi_image_HTMLImage$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_image_HTMLImage$.prototype.apply__Lorg_scalajs_dom_raw_HTMLImageElement__s_concurrent_Future = (function(img) {
  if ((($uI(img.width) > 0) && ($uI(img.height) > 0))) {
    return $m_s_concurrent_Future$().successful__O__s_concurrent_Future(new $c_Lio_youi_image_HTMLImage().init___Lorg_scalajs_dom_raw_HTMLImageElement(img))
  } else {
    var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
    var listener = (function(img$1, promise$1) {
      return (function(arg1$2) {
        return $m_Lio_youi_image_HTMLImage$().io$youi$image$HTMLImage$$$anonfun$apply$1__Lorg_scalajs_dom_raw_Event__Lorg_scalajs_dom_raw_HTMLImageElement__s_concurrent_Promise__s_concurrent_Promise(arg1$2, img$1, promise$1)
      })
    })(img, promise);
    img.addEventListener("load", listener);
    promise.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, img$2, listener$1) {
      return (function(x$2$2) {
        $as_s_util_Try(x$2$2);
        img$2.removeEventListener("load", listener$1)
      })
    })(this, img, listener)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
    return promise
  }
});
$c_Lio_youi_image_HTMLImage$.prototype.apply__Lio_youi_net_URL__s_concurrent_Future = (function(url) {
  var img = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("img");
  img.src = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
  return this.apply__Lorg_scalajs_dom_raw_HTMLImageElement__s_concurrent_Future(img)
});
$c_Lio_youi_image_HTMLImage$.prototype.io$youi$image$HTMLImage$$$anonfun$apply$1__Lorg_scalajs_dom_raw_Event__Lorg_scalajs_dom_raw_HTMLImageElement__s_concurrent_Promise__s_concurrent_Promise = (function(x$1, img$1, promise$1) {
  var value = new $c_Lio_youi_image_HTMLImage().init___Lorg_scalajs_dom_raw_HTMLImageElement(img$1);
  return $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$1, value)
});
var $d_Lio_youi_image_HTMLImage$ = new $TypeData().initClass({
  Lio_youi_image_HTMLImage$: 0
}, false, "io.youi.image.HTMLImage$", {
  Lio_youi_image_HTMLImage$: 1,
  O: 1
});
$c_Lio_youi_image_HTMLImage$.prototype.$classData = $d_Lio_youi_image_HTMLImage$;
var $n_Lio_youi_image_HTMLImage$ = (void 0);
function $m_Lio_youi_image_HTMLImage$() {
  if ((!$n_Lio_youi_image_HTMLImage$)) {
    $n_Lio_youi_image_HTMLImage$ = new $c_Lio_youi_image_HTMLImage$().init___()
  };
  return $n_Lio_youi_image_HTMLImage$
}
/** @constructor */
function $c_Lio_youi_image_Image$() {
  $c_O.call(this)
}
$c_Lio_youi_image_Image$.prototype = new $h_O();
$c_Lio_youi_image_Image$.prototype.constructor = $c_Lio_youi_image_Image$;
/** @constructor */
function $h_Lio_youi_image_Image$() {
  /*<skip>*/
}
$h_Lio_youi_image_Image$.prototype = $c_Lio_youi_image_Image$.prototype;
$c_Lio_youi_image_Image$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_image_Image$.prototype.apply__Lio_youi_net_URL__s_concurrent_Future = (function(url) {
  var jsx$1 = $m_sjsr_RuntimeString$();
  var thiz = url.path$1.encoded__T();
  if (jsx$1.endsWith__T__T__Z($as_T(thiz.toLowerCase()), ".svg")) {
    return $m_Lio_youi_image_SVGImage$().apply__Lio_youi_net_URL__s_concurrent_Future(url)
  } else {
    return $m_Lio_youi_image_HTMLImage$().apply__Lio_youi_net_URL__s_concurrent_Future(url)
  }
});
$c_Lio_youi_image_Image$.prototype.apply__T__s_concurrent_Future = (function(source) {
  if (($uI(source.indexOf("<svg")) !== (-1))) {
    return $m_Lio_youi_image_SVGImage$().apply__T__s_concurrent_Future(source)
  } else if (((($uI(source.length) >= 0) && ($as_T(source.substring(0, $uI("data:image/".length))) === "data:image/")) || (($uI(source.length) >= 0) && ($as_T(source.substring(0, $uI("blob:".length))) === "blob:")))) {
    var img = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("img");
    img.src = source;
    return $m_Lio_youi_image_HTMLImage$().apply__Lorg_scalajs_dom_raw_HTMLImageElement__s_concurrent_Future(img)
  } else {
    var v = $m_Lio_youi_History$().url$1;
    return this.apply__Lio_youi_net_URL__s_concurrent_Future($as_Lio_youi_net_URL(v.state__Lreactify_State().value__O()).withPart__T__Lio_youi_net_URL(source))
  }
});
var $d_Lio_youi_image_Image$ = new $TypeData().initClass({
  Lio_youi_image_Image$: 0
}, false, "io.youi.image.Image$", {
  Lio_youi_image_Image$: 1,
  O: 1
});
$c_Lio_youi_image_Image$.prototype.$classData = $d_Lio_youi_image_Image$;
var $n_Lio_youi_image_Image$ = (void 0);
function $m_Lio_youi_image_Image$() {
  if ((!$n_Lio_youi_image_Image$)) {
    $n_Lio_youi_image_Image$ = new $c_Lio_youi_image_Image$().init___()
  };
  return $n_Lio_youi_image_Image$
}
/** @constructor */
function $c_Lio_youi_image_SVGImage$() {
  $c_O.call(this)
}
$c_Lio_youi_image_SVGImage$.prototype = new $h_O();
$c_Lio_youi_image_SVGImage$.prototype.constructor = $c_Lio_youi_image_SVGImage$;
/** @constructor */
function $h_Lio_youi_image_SVGImage$() {
  /*<skip>*/
}
$h_Lio_youi_image_SVGImage$.prototype = $c_Lio_youi_image_SVGImage$.prototype;
$c_Lio_youi_image_SVGImage$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_image_SVGImage$.prototype.measure__Lorg_scalajs_dom_raw_SVGSVGElement__Z__Z__Lio_youi_spatial_BoundingBox = (function(svg, applyDimension, force) {
  var viewBox = (((svg.viewBox !== null) && (svg.viewBox.animVal !== null)) ? new $c_Lio_youi_image_SVGImage$ViewBox().init___D__D($uD(svg.viewBox.animVal.width), $uD(svg.viewBox.animVal.height)) : new $c_Lio_youi_image_SVGImage$ViewBox().init___D__D(0.0, 0.0));
  var definedWidth = (($uI(svg.width.animVal.unitType) === $uI($g.SVGLength.SVG_LENGTHTYPE_NUMBER)) ? new $c_s_Some().init___O($uD(svg.width.animVal.value)) : ((viewBox.width$1 > 0.0) ? new $c_s_Some().init___O(viewBox.width$1) : $m_s_None$()));
  var definedHeight = (($uI(svg.height.animVal.unitType) === $uI($g.SVGLength.SVG_LENGTHTYPE_NUMBER)) ? new $c_s_Some().init___O($uD(svg.height.animVal.value)) : ((viewBox.height$1 > 0.0) ? new $c_s_Some().init___O(viewBox.height$1) : $m_s_None$()));
  if (((definedWidth.isEmpty__Z() || definedHeight.isEmpty__Z()) || force)) {
    var minX = new $c_sr_DoubleRef().init___D(0.0);
    var minY = new $c_sr_DoubleRef().init___D(0.0);
    var maxX = new $c_sr_DoubleRef().init___D(0.0);
    var maxY = new $c_sr_DoubleRef().init___D(0.0);
    $m_Lio_youi_dom$();
    var list = svg.children;
    var this$6 = new $c_Lio_youi_dom$$anon$1().init___Lorg_scalajs_dom_raw_DOMList(list);
    while (this$6.hasNext__Z()) {
      var arg1 = this$6.next__O();
      this.measureInternal$1__p1__Lorg_scalajs_dom_raw_Element__D__D__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__V(arg1, 0.0, 0.0, minX, minY, maxX, maxY)
    };
    $m_Lio_youi_spatial_BoundingBox$();
    var x1 = minX.elem$1;
    var y1 = minY.elem$1;
    var x2 = maxX.elem$1;
    var y2 = maxY.elem$1;
    var bb = new $c_Lio_youi_spatial_ImmutableBoundingBox().init___D__D__D__D(x1, y1, x2, y2)
  } else {
    $m_Lio_youi_spatial_BoundingBox$();
    var x2$1 = $uD(definedWidth.get__O());
    var y2$1 = $uD(definedHeight.get__O());
    var bb = new $c_Lio_youi_spatial_ImmutableBoundingBox().init___D__D__D__D(0.0, 0.0, x2$1, y2$1)
  };
  if (applyDimension) {
    var this$9 = $f_Lio_youi_spatial_BoundingBox__width__D(bb);
    svg.setAttribute("width", ("" + this$9));
    var this$11 = $f_Lio_youi_spatial_BoundingBox__height__D(bb);
    svg.setAttribute("height", ("" + this$11))
  };
  return bb
});
$c_Lio_youi_image_SVGImage$.prototype.apply__Lorg_scalajs_dom_raw_SVGSVGElement__s_concurrent_Future = (function(svg) {
  var this$1 = this.measure__Lorg_scalajs_dom_raw_SVGSVGElement__Z__Z__Lio_youi_spatial_BoundingBox(svg, true, false);
  var width = $f_Lio_youi_spatial_BoundingBox__width__D(this$1);
  var height = $f_Lio_youi_spatial_BoundingBox__height__D(this$1);
  var size = new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width, height);
  return this.apply__Lorg_scalajs_dom_raw_SVGSVGElement__D__D__s_concurrent_Future(svg, size.width$1, size.height$1)
});
$c_Lio_youi_image_SVGImage$.prototype.apply__Lio_youi_net_URL__s_concurrent_Future = (function(url) {
  var stream = $m_Lio_youi_stream_StreamURL$().stream__Lio_youi_net_URL__s_Option__I__sci_Map__Z__T__s_concurrent_Future(url, $m_s_None$(), 0, $m_sci_Map$EmptyMap$(), true, "");
  return stream.flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(svgString$2) {
      var svgString = $as_T(svgString$2);
      return $m_Lio_youi_image_SVGImage$().apply__T__s_concurrent_Future(svgString)
    })
  })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
$c_Lio_youi_image_SVGImage$.prototype.measureInternal$1__p1__Lorg_scalajs_dom_raw_Element__D__D__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__V = (function(e, offsetX, offsetY, minX$1, minY$1, maxX$1, maxY$1) {
  if ($uZ((e instanceof $g.SVGGElement))) {
    var elem$1 = 0.0;
    elem$1 = offsetX;
    var elem$1$1 = 0.0;
    elem$1$1 = offsetY;
    var end = $uI(e.transform.baseVal.numberOfItems);
    var isEmpty$4 = (end <= 0);
    var scala$collection$immutable$Range$$lastElement$4 = (((-1) + end) | 0);
    if ((!isEmpty$4)) {
      var i = 0;
      while (true) {
        var v1 = i;
        var transform = e.transform.baseVal.getItem(v1);
        if (($uI(transform.type) === $uI($g.SVGTransform.SVG_TRANSFORM_TRANSLATE))) {
          elem$1 = (elem$1 + $uD(transform.matrix.e));
          elem$1$1 = (elem$1$1 + $uD(transform.matrix.f))
        };
        if ((i === scala$collection$immutable$Range$$lastElement$4)) {
          break
        };
        i = ((1 + i) | 0)
      }
    };
    $m_Lio_youi_dom$();
    var list = e.children;
    var this$7 = new $c_Lio_youi_dom$$anon$1().init___Lorg_scalajs_dom_raw_DOMList(list);
    while (this$7.hasNext__Z()) {
      var arg1 = this$7.next__O();
      this.measureInternal$1__p1__Lorg_scalajs_dom_raw_Element__D__D__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__V(arg1, elem$1, elem$1$1, minX$1, minY$1, maxX$1, maxY$1)
    }
  } else if ($uZ((e instanceof $g.SVGCircleElement))) {
    var x = minX$1.elem$1;
    var y = (offsetX + ($uD(e.cx.baseVal.value) - $uD(e.r.baseVal.value)));
    minX$1.elem$1 = $uD($g.Math.min(x, y));
    var x$1 = minY$1.elem$1;
    var y$1 = (offsetY + ($uD(e.cy.baseVal.value) - $uD(e.r.baseVal.value)));
    minY$1.elem$1 = $uD($g.Math.min(x$1, y$1));
    var x$2 = maxX$1.elem$1;
    var y$2 = (offsetX + ($uD(e.cx.baseVal.value) + $uD(e.r.baseVal.value)));
    maxX$1.elem$1 = $uD($g.Math.max(x$2, y$2));
    var x$3 = maxY$1.elem$1;
    var y$3 = (offsetY + ($uD(e.cy.baseVal.value) + $uD(e.r.baseVal.value)));
    maxY$1.elem$1 = $uD($g.Math.max(x$3, y$3))
  } else if ($uZ((e instanceof $g.SVGEllipseElement))) {
    var x$4 = minX$1.elem$1;
    var y$4 = (offsetX + ($uD(e.cx.baseVal.value) - $uD(e.rx.baseVal.value)));
    minX$1.elem$1 = $uD($g.Math.min(x$4, y$4));
    var x$5 = minY$1.elem$1;
    var y$5 = (offsetY + ($uD(e.cy.baseVal.value) - $uD(e.ry.baseVal.value)));
    minY$1.elem$1 = $uD($g.Math.min(x$5, y$5));
    var x$6 = maxX$1.elem$1;
    var y$6 = (offsetX + ($uD(e.cx.baseVal.value) + $uD(e.rx.baseVal.value)));
    maxX$1.elem$1 = $uD($g.Math.max(x$6, y$6));
    var x$7 = maxY$1.elem$1;
    var y$7 = (offsetY + ($uD(e.cy.baseVal.value) + $uD(e.ry.baseVal.value)));
    maxY$1.elem$1 = $uD($g.Math.max(x$7, y$7))
  } else if ($uZ((e instanceof $g.SVGRectElement))) {
    var x$8 = minX$1.elem$1;
    var y$8 = (offsetX + $uD(e.x.baseVal.value));
    minX$1.elem$1 = $uD($g.Math.min(x$8, y$8));
    var x$9 = minY$1.elem$1;
    var y$9 = (offsetY + $uD(e.y.baseVal.value));
    minY$1.elem$1 = $uD($g.Math.min(x$9, y$9));
    var x$10 = maxX$1.elem$1;
    var y$10 = ((offsetX + $uD(e.x.baseVal.value)) + $uD(e.width.baseVal.value));
    maxX$1.elem$1 = $uD($g.Math.max(x$10, y$10));
    var x$11 = maxY$1.elem$1;
    var y$11 = ((offsetY + $uD(e.y.baseVal.value)) + $uD(e.height.baseVal.value));
    maxY$1.elem$1 = $uD($g.Math.max(x$11, y$11))
  } else if ($uZ((e instanceof $g.SVGImageElement))) {
    var x$12 = minX$1.elem$1;
    var y$12 = (offsetX + $uD(e.x.baseVal.value));
    minX$1.elem$1 = $uD($g.Math.min(x$12, y$12));
    var x$13 = minY$1.elem$1;
    var y$13 = (offsetY + $uD(e.y.baseVal.value));
    minY$1.elem$1 = $uD($g.Math.min(x$13, y$13));
    var x$14 = maxX$1.elem$1;
    var y$14 = ((offsetX + $uD(e.x.baseVal.value)) + $uD(e.width.baseVal.value));
    maxX$1.elem$1 = $uD($g.Math.max(x$14, y$14));
    var x$15 = maxY$1.elem$1;
    var y$15 = ((offsetY + $uD(e.y.baseVal.value)) + $uD(e.height.baseVal.value));
    maxY$1.elem$1 = $uD($g.Math.max(x$15, y$15))
  } else if ($uZ((e instanceof $g.SVGLinearGradientElement))) {
    var x$16 = minX$1.elem$1;
    var y$16 = (offsetX + $uD(e.x1.baseVal.value));
    minX$1.elem$1 = $uD($g.Math.min(x$16, y$16));
    var x$17 = minY$1.elem$1;
    var y$17 = (offsetY + $uD(e.y1.baseVal.value));
    minY$1.elem$1 = $uD($g.Math.min(x$17, y$17));
    var x$18 = maxX$1.elem$1;
    var y$18 = (offsetX + $uD(e.x2.baseVal.value));
    maxX$1.elem$1 = $uD($g.Math.max(x$18, y$18));
    var x$19 = maxY$1.elem$1;
    var y$19 = (offsetY + $uD(e.y2.baseVal.value));
    maxY$1.elem$1 = $uD($g.Math.max(x$19, y$19))
  } else if ($uZ((e instanceof $g.SVGPolygonElement))) {
    var end$1 = $uI(e.points.numberOfItems);
    var isEmpty$4$1 = (end$1 <= 0);
    var scala$collection$immutable$Range$$lastElement$4$1 = (((-1) + end$1) | 0);
    if ((!isEmpty$4$1)) {
      var i$1 = 0;
      while (true) {
        var v1$1 = i$1;
        var point = e.points.getItem(v1$1);
        var x$20 = minX$1.elem$1;
        var y$20 = (offsetX + $uD(point.x));
        minX$1.elem$1 = $uD($g.Math.min(x$20, y$20));
        var x$21 = minY$1.elem$1;
        var y$21 = (offsetY + $uD(point.y));
        minY$1.elem$1 = $uD($g.Math.min(x$21, y$21));
        var x$22 = maxX$1.elem$1;
        var y$22 = (offsetX + $uD(point.x));
        maxX$1.elem$1 = $uD($g.Math.max(x$22, y$22));
        var x$23 = maxY$1.elem$1;
        var y$23 = (offsetY + $uD(point.y));
        maxY$1.elem$1 = $uD($g.Math.max(x$23, y$23));
        if ((i$1 === scala$collection$immutable$Range$$lastElement$4$1)) {
          break
        };
        i$1 = ((1 + i$1) | 0)
      }
    }
  } else if ($uZ((e instanceof $g.SVGPathElement))) {
    var path = $m_Lio_youi_path_Path$().apply__T__Lio_youi_path_Path($as_T(e.getAttribute("d")));
    var x$24 = minX$1.elem$1;
    var y$24 = (offsetX + path.boundingBox__Lio_youi_spatial_BoundingBox().x1__D());
    minX$1.elem$1 = $uD($g.Math.min(x$24, y$24));
    var x$25 = minY$1.elem$1;
    var y$25 = (offsetY + path.boundingBox__Lio_youi_spatial_BoundingBox().y1__D());
    minY$1.elem$1 = $uD($g.Math.min(x$25, y$25));
    var x$26 = maxX$1.elem$1;
    var y$26 = (offsetX + path.boundingBox__Lio_youi_spatial_BoundingBox().x2__D());
    maxX$1.elem$1 = $uD($g.Math.max(x$26, y$26));
    var x$27 = maxY$1.elem$1;
    var y$27 = (offsetY + path.boundingBox__Lio_youi_spatial_BoundingBox().y2__D());
    maxY$1.elem$1 = $uD($g.Math.max(x$27, y$27))
  } else if ((!$uZ((e instanceof $g.SVGStyleElement)))) {
    var jsx$1 = $m_Lscribe_package$();
    var level = $m_Lscribe_Level$Warn$();
    var value = $m_Lscribe_Level$Warn$().value$1;
    var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, e$1) {
      return (function() {
        return (("Unsupported SVG node: " + e$1) + ".")
      })
    })(this, e));
    var loggable = $m_Lscribe_Loggable$StringLoggable$();
    var throwable = $m_s_None$();
    var methodName = new $c_s_Some().init___O("measureInternal");
    var line = new $c_s_Some().init___O(184);
    var column = new $c_s_Some().init___O(30);
    var thread = $m_jl_Thread$().SingleThread$1;
    var this$69 = $m_Lscribe_util_Time$();
    var this$70 = this$69.function$1;
    var t = $uJ(this$70.apply__O());
    var lo = t.lo$2;
    var hi$4 = t.hi$2;
    jsx$1.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/ui/js/src/main/scala/io/youi/image/SVGImage.scala", "io.youi.image.SVGImage.bb", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi$4)))
  }
});
$c_Lio_youi_image_SVGImage$.prototype.apply__Lorg_scalajs_dom_raw_SVGSVGElement__D__D__s_concurrent_Future = (function(svg, width, height) {
  var this$1 = this.measure__Lorg_scalajs_dom_raw_SVGSVGElement__Z__Z__Lio_youi_spatial_BoundingBox(svg, true, false);
  var width$1 = $f_Lio_youi_spatial_BoundingBox__width__D(this$1);
  var height$1 = $f_Lio_youi_spatial_BoundingBox__height__D(this$1);
  var size = new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width$1, height$1);
  var canvas = $m_Lio_youi_util_CanvasPool$().apply__D__D__D__Lorg_scalajs_dom_raw_HTMLCanvasElement(width, height, ($m_Lio_youi_util_CanvasPool$(), 1.0));
  return this.drawToCanvas__Lorg_scalajs_dom_raw_HTMLCanvasElement__Lorg_scalajs_dom_raw_SVGSVGElement__D__D__D__D__s_concurrent_Future(canvas, svg, 0.0, 0.0, width, height).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, svg$1, size$1, canvas$1) {
    return (function(x$4$2) {
      $asUnit(x$4$2);
      return new $c_Lio_youi_image_SVGImage().init___Lorg_scalajs_dom_raw_SVGSVGElement__Lorg_scalajs_dom_raw_HTMLCanvasElement__Lio_youi_spatial_Size(svg$1, canvas$1, size$1)
    })
  })(this, svg, size, canvas)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
$c_Lio_youi_image_SVGImage$.prototype.drawToCanvas__Lorg_scalajs_dom_raw_HTMLCanvasElement__Lorg_scalajs_dom_raw_SVGSVGElement__D__D__D__D__s_concurrent_Future = (function(canvas, svg, x, y, width, height) {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var callback = (function($this, promise$1) {
    return (function() {
      return $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$1, (void 0))
    })
  })(this, promise);
  var jsx$2 = $g;
  var jsx$1 = $as_T(svg.outerHTML);
  var this$2$1 = {};
  this$2$1.ignoreMouse = true;
  this$2$1.ignoreAnimation = true;
  this$2$1.ignoreDimensions = true;
  this$2$1.ignoreClear = true;
  var this$11 = $m_sjsr_RuntimeLong$();
  var value = $uD($g.Math.round(x));
  var lo = this$11.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I(value);
  this$2$1.offsetX = lo;
  var this$15 = $m_sjsr_RuntimeLong$();
  var value$1 = $uD($g.Math.round(y));
  var lo$1 = this$15.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I(value$1);
  this$2$1.offsetY = lo$1;
  var value$2 = $doubleToInt($uD($g.Math.ceil(width)));
  this$2$1.scaleWidth = value$2;
  var value$3 = $doubleToInt($uD($g.Math.ceil(height)));
  this$2$1.scaleHeight = value$3;
  this$2$1.renderCallback = callback;
  jsx$2.canvg(canvas, jsx$1, this$2$1);
  return promise
});
$c_Lio_youi_image_SVGImage$.prototype.apply__T__s_concurrent_Future = (function(svgString) {
  try {
    var div = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("div");
    div.innerHTML = svgString;
    $m_Lio_youi_dom$();
    var this$2 = new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(div);
    var svg = this$2.oneBySelector__T__Lorg_scalajs_dom_raw_Element("svg");
    return this.apply__Lorg_scalajs_dom_raw_SVGSVGElement__s_concurrent_Future(svg)
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      var jsx$1 = $m_Lscribe_package$();
      var level = $m_Lscribe_Level$Error$();
      var value = $m_Lscribe_Level$Error$().value$1;
      var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, t) {
        return (function() {
          return t
        })
      })(this, e$2));
      var loggable = $m_Lscribe_Loggable$ThrowableLoggable$();
      var throwable = $m_s_None$();
      var methodName = new $c_s_Some().init___O("apply");
      var line = new $c_s_Some().init___O(61);
      var column = new $c_s_Some().init___O(19);
      var thread = $m_jl_Thread$().SingleThread$1;
      var this$5 = $m_Lscribe_util_Time$();
      var this$6 = this$5.function$1;
      var t$1 = $uJ(this$6.apply__O());
      var lo = t$1.lo$2;
      var hi = t$1.hi$2;
      jsx$1.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/ui/js/src/main/scala/io/youi/image/SVGImage.scala", "io.youi.image.SVGImage", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
      throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
    } else {
      throw e
    }
  }
});
var $d_Lio_youi_image_SVGImage$ = new $TypeData().initClass({
  Lio_youi_image_SVGImage$: 0
}, false, "io.youi.image.SVGImage$", {
  Lio_youi_image_SVGImage$: 1,
  O: 1
});
$c_Lio_youi_image_SVGImage$.prototype.$classData = $d_Lio_youi_image_SVGImage$;
var $n_Lio_youi_image_SVGImage$ = (void 0);
function $m_Lio_youi_image_SVGImage$() {
  if ((!$n_Lio_youi_image_SVGImage$)) {
    $n_Lio_youi_image_SVGImage$ = new $c_Lio_youi_image_SVGImage$().init___()
  };
  return $n_Lio_youi_image_SVGImage$
}
/** @constructor */
function $c_Lio_youi_layout_GridLayout$Config$alignment$() {
  $c_O.call(this);
  this.horizontal$1 = null;
  this.vertical$1 = null
}
$c_Lio_youi_layout_GridLayout$Config$alignment$.prototype = new $h_O();
$c_Lio_youi_layout_GridLayout$Config$alignment$.prototype.constructor = $c_Lio_youi_layout_GridLayout$Config$alignment$;
/** @constructor */
function $h_Lio_youi_layout_GridLayout$Config$alignment$() {
  /*<skip>*/
}
$h_Lio_youi_layout_GridLayout$Config$alignment$.prototype = $c_Lio_youi_layout_GridLayout$Config$alignment$.prototype;
$c_Lio_youi_layout_GridLayout$Config$alignment$.prototype.init___Lio_youi_layout_GridLayout$Config = (function($$outer) {
  var lookup = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$7$2) {
      var x$7 = $as_Lio_youi_layout_GridLayout$Config(x$7$2);
      return x$7.alignment__Lio_youi_layout_GridLayout$Config$alignment$().horizontal$1
    })
  })(this));
  this.horizontal$1 = $f_Lio_youi_layout_GridLayout$Config__prop__F1__Lreactify_Var($$outer, lookup);
  var lookup$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(x$8$2) {
      var x$8 = $as_Lio_youi_layout_GridLayout$Config(x$8$2);
      return x$8.alignment__Lio_youi_layout_GridLayout$Config$alignment$().vertical$1
    })
  })(this));
  this.vertical$1 = $f_Lio_youi_layout_GridLayout$Config__prop__F1__Lreactify_Var($$outer, lookup$1);
  return this
});
var $d_Lio_youi_layout_GridLayout$Config$alignment$ = new $TypeData().initClass({
  Lio_youi_layout_GridLayout$Config$alignment$: 0
}, false, "io.youi.layout.GridLayout$Config$alignment$", {
  Lio_youi_layout_GridLayout$Config$alignment$: 1,
  O: 1
});
$c_Lio_youi_layout_GridLayout$Config$alignment$.prototype.$classData = $d_Lio_youi_layout_GridLayout$Config$alignment$;
/** @constructor */
function $c_Lio_youi_layout_GridLayout$Config$margin$() {
  $c_O.call(this);
  this.left$1 = null;
  this.right$1 = null;
  this.top$1 = null;
  this.bottom$1 = null
}
$c_Lio_youi_layout_GridLayout$Config$margin$.prototype = new $h_O();
$c_Lio_youi_layout_GridLayout$Config$margin$.prototype.constructor = $c_Lio_youi_layout_GridLayout$Config$margin$;
/** @constructor */
function $h_Lio_youi_layout_GridLayout$Config$margin$() {
  /*<skip>*/
}
$h_Lio_youi_layout_GridLayout$Config$margin$.prototype = $c_Lio_youi_layout_GridLayout$Config$margin$.prototype;
$c_Lio_youi_layout_GridLayout$Config$margin$.prototype.init___Lio_youi_layout_GridLayout$Config = (function($$outer) {
  var lookup = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      var x$1 = $as_Lio_youi_layout_GridLayout$Config(x$1$2);
      return x$1.margin__Lio_youi_layout_GridLayout$Config$margin$().left$1
    })
  })(this));
  this.left$1 = $f_Lio_youi_layout_GridLayout$Config__prop__F1__Lreactify_Var($$outer, lookup);
  var lookup$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(x$2$2) {
      var x$2 = $as_Lio_youi_layout_GridLayout$Config(x$2$2);
      return x$2.margin__Lio_youi_layout_GridLayout$Config$margin$().right$1
    })
  })(this));
  this.right$1 = $f_Lio_youi_layout_GridLayout$Config__prop__F1__Lreactify_Var($$outer, lookup$1);
  var lookup$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3) {
    return (function(x$3$2) {
      var x$3 = $as_Lio_youi_layout_GridLayout$Config(x$3$2);
      return x$3.margin__Lio_youi_layout_GridLayout$Config$margin$().top$1
    })
  })(this));
  this.top$1 = $f_Lio_youi_layout_GridLayout$Config__prop__F1__Lreactify_Var($$outer, lookup$2);
  var lookup$3 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4) {
    return (function(x$4$2) {
      var x$4 = $as_Lio_youi_layout_GridLayout$Config(x$4$2);
      return x$4.margin__Lio_youi_layout_GridLayout$Config$margin$().bottom$1
    })
  })(this));
  this.bottom$1 = $f_Lio_youi_layout_GridLayout$Config__prop__F1__Lreactify_Var($$outer, lookup$3);
  return this
});
var $d_Lio_youi_layout_GridLayout$Config$margin$ = new $TypeData().initClass({
  Lio_youi_layout_GridLayout$Config$margin$: 0
}, false, "io.youi.layout.GridLayout$Config$margin$", {
  Lio_youi_layout_GridLayout$Config$margin$: 1,
  O: 1
});
$c_Lio_youi_layout_GridLayout$Config$margin$.prototype.$classData = $d_Lio_youi_layout_GridLayout$Config$margin$;
/** @constructor */
function $c_Lio_youi_layout_GridLayout$Config$span$() {
  $c_O.call(this);
  this.columns$1 = null;
  this.rows$1 = null
}
$c_Lio_youi_layout_GridLayout$Config$span$.prototype = new $h_O();
$c_Lio_youi_layout_GridLayout$Config$span$.prototype.constructor = $c_Lio_youi_layout_GridLayout$Config$span$;
/** @constructor */
function $h_Lio_youi_layout_GridLayout$Config$span$() {
  /*<skip>*/
}
$h_Lio_youi_layout_GridLayout$Config$span$.prototype = $c_Lio_youi_layout_GridLayout$Config$span$.prototype;
$c_Lio_youi_layout_GridLayout$Config$span$.prototype.init___Lio_youi_layout_GridLayout$Config = (function($$outer) {
  var lookup = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$5$2) {
      var x$5 = $as_Lio_youi_layout_GridLayout$Config(x$5$2);
      return x$5.span__Lio_youi_layout_GridLayout$Config$span$().columns$1
    })
  })(this));
  this.columns$1 = $f_Lio_youi_layout_GridLayout$Config__prop__F1__Lreactify_Var($$outer, lookup);
  var lookup$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(x$6$2) {
      var x$6 = $as_Lio_youi_layout_GridLayout$Config(x$6$2);
      return x$6.span__Lio_youi_layout_GridLayout$Config$span$().rows$1
    })
  })(this));
  this.rows$1 = $f_Lio_youi_layout_GridLayout$Config__prop__F1__Lreactify_Var($$outer, lookup$1);
  return this
});
var $d_Lio_youi_layout_GridLayout$Config$span$ = new $TypeData().initClass({
  Lio_youi_layout_GridLayout$Config$span$: 0
}, false, "io.youi.layout.GridLayout$Config$span$", {
  Lio_youi_layout_GridLayout$Config$span$: 1,
  O: 1
});
$c_Lio_youi_layout_GridLayout$Config$span$.prototype.$classData = $d_Lio_youi_layout_GridLayout$Config$span$;
/** @constructor */
function $c_Lio_youi_layout_GridLayout$config$() {
  $c_O.call(this);
  this.default$1 = null;
  this.rows$1 = null;
  this.columns$1 = null;
  this.$$outer$1 = null
}
$c_Lio_youi_layout_GridLayout$config$.prototype = new $h_O();
$c_Lio_youi_layout_GridLayout$config$.prototype.constructor = $c_Lio_youi_layout_GridLayout$config$;
/** @constructor */
function $h_Lio_youi_layout_GridLayout$config$() {
  /*<skip>*/
}
$h_Lio_youi_layout_GridLayout$config$.prototype = $c_Lio_youi_layout_GridLayout$config$.prototype;
$c_Lio_youi_layout_GridLayout$config$.prototype.row__I__Lio_youi_layout_GridLayout$RowConfig = (function(rowIndex) {
  var this$1 = this.rows$1;
  var x1 = $as_sc_MapLike(this$1.state__Lreactify_State().value__O()).get__O__s_Option(rowIndex);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var c = $as_Lio_youi_layout_GridLayout$RowConfig(x2.value$2);
    return c
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var c$2 = new $c_Lio_youi_layout_GridLayout$RowConfig().init___Lio_youi_layout_GridLayout__I(this.$$outer$1, rowIndex);
      var this$5 = this.rows$1;
      var this$2 = this.rows$1;
      var value = $as_sci_Map(this$2.state__Lreactify_State().value__O()).$$plus__T2__sci_Map(new $c_T2().init___O__O(rowIndex, c$2));
      $f_Lreactify_Var__$static__O__V(this$5, value);
      return c$2
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
$c_Lio_youi_layout_GridLayout$config$.prototype.column__I__Lio_youi_layout_GridLayout$ColumnConfig = (function(columnIndex) {
  var this$1 = this.columns$1;
  var x1 = $as_sc_MapLike(this$1.state__Lreactify_State().value__O()).get__O__s_Option(columnIndex);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var c = $as_Lio_youi_layout_GridLayout$ColumnConfig(x2.value$2);
    return c
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var c$2 = new $c_Lio_youi_layout_GridLayout$ColumnConfig().init___Lio_youi_layout_GridLayout__I(this.$$outer$1, columnIndex);
      var this$5 = this.columns$1;
      var this$2 = this.columns$1;
      var value = $as_sci_Map(this$2.state__Lreactify_State().value__O()).$$plus__T2__sci_Map(new $c_T2().init___O__O(columnIndex, c$2));
      $f_Lreactify_Var__$static__O__V(this$5, value);
      return c$2
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
$c_Lio_youi_layout_GridLayout$config$.prototype.init___Lio_youi_layout_GridLayout = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  this.default$1 = new $c_Lio_youi_layout_GridLayout$config$$anon$1().init___Lio_youi_layout_GridLayout$config$(this);
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_sci_Map$EmptyMap$()
    })
  })(this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.rows$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      return $m_sci_Map$EmptyMap$()
    })
  })(this));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.columns$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  return this
});
$c_Lio_youi_layout_GridLayout$config$.prototype.cell__I__I__Lio_youi_layout_GridLayout$CellConfig = (function(row, column) {
  return this.row__I__Lio_youi_layout_GridLayout$RowConfig(row).cell__I__Lio_youi_layout_GridLayout$CellConfig(column)
});
var $d_Lio_youi_layout_GridLayout$config$ = new $TypeData().initClass({
  Lio_youi_layout_GridLayout$config$: 0
}, false, "io.youi.layout.GridLayout$config$", {
  Lio_youi_layout_GridLayout$config$: 1,
  O: 1
});
$c_Lio_youi_layout_GridLayout$config$.prototype.$classData = $d_Lio_youi_layout_GridLayout$config$;
/** @constructor */
function $c_Lio_youi_net_ArgumentPathPart$() {
  $c_O.call(this)
}
$c_Lio_youi_net_ArgumentPathPart$.prototype = new $h_O();
$c_Lio_youi_net_ArgumentPathPart$.prototype.constructor = $c_Lio_youi_net_ArgumentPathPart$;
/** @constructor */
function $h_Lio_youi_net_ArgumentPathPart$() {
  /*<skip>*/
}
$h_Lio_youi_net_ArgumentPathPart$.prototype = $c_Lio_youi_net_ArgumentPathPart$.prototype;
$c_Lio_youi_net_ArgumentPathPart$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_net_ArgumentPathPart$.prototype.equals$extension__T__O__Z = (function($$this, x$1) {
  if ($is_Lio_youi_net_ArgumentPathPart(x$1)) {
    var ArgumentPathPart$1 = ((x$1 === null) ? null : $as_Lio_youi_net_ArgumentPathPart(x$1).name$1);
    return ($$this === ArgumentPathPart$1)
  } else {
    return false
  }
});
$c_Lio_youi_net_ArgumentPathPart$.prototype.value$extension__T__T = (function($$this) {
  return (":" + $$this)
});
var $d_Lio_youi_net_ArgumentPathPart$ = new $TypeData().initClass({
  Lio_youi_net_ArgumentPathPart$: 0
}, false, "io.youi.net.ArgumentPathPart$", {
  Lio_youi_net_ArgumentPathPart$: 1,
  O: 1
});
$c_Lio_youi_net_ArgumentPathPart$.prototype.$classData = $d_Lio_youi_net_ArgumentPathPart$;
var $n_Lio_youi_net_ArgumentPathPart$ = (void 0);
function $m_Lio_youi_net_ArgumentPathPart$() {
  if ((!$n_Lio_youi_net_ArgumentPathPart$)) {
    $n_Lio_youi_net_ArgumentPathPart$ = new $c_Lio_youi_net_ArgumentPathPart$().init___()
  };
  return $n_Lio_youi_net_ArgumentPathPart$
}
/** @constructor */
function $c_Lio_youi_net_LiteralPathPart$() {
  $c_O.call(this)
}
$c_Lio_youi_net_LiteralPathPart$.prototype = new $h_O();
$c_Lio_youi_net_LiteralPathPart$.prototype.constructor = $c_Lio_youi_net_LiteralPathPart$;
/** @constructor */
function $h_Lio_youi_net_LiteralPathPart$() {
  /*<skip>*/
}
$h_Lio_youi_net_LiteralPathPart$.prototype = $c_Lio_youi_net_LiteralPathPart$.prototype;
$c_Lio_youi_net_LiteralPathPart$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_net_LiteralPathPart$.prototype.equals$extension__T__O__Z = (function($$this, x$1) {
  if ($is_Lio_youi_net_LiteralPathPart(x$1)) {
    var LiteralPathPart$1 = ((x$1 === null) ? null : $as_Lio_youi_net_LiteralPathPart(x$1).value$1);
    return ($$this === LiteralPathPart$1)
  } else {
    return false
  }
});
var $d_Lio_youi_net_LiteralPathPart$ = new $TypeData().initClass({
  Lio_youi_net_LiteralPathPart$: 0
}, false, "io.youi.net.LiteralPathPart$", {
  Lio_youi_net_LiteralPathPart$: 1,
  O: 1
});
$c_Lio_youi_net_LiteralPathPart$.prototype.$classData = $d_Lio_youi_net_LiteralPathPart$;
var $n_Lio_youi_net_LiteralPathPart$ = (void 0);
function $m_Lio_youi_net_LiteralPathPart$() {
  if ((!$n_Lio_youi_net_LiteralPathPart$)) {
    $n_Lio_youi_net_LiteralPathPart$ = new $c_Lio_youi_net_LiteralPathPart$().init___()
  };
  return $n_Lio_youi_net_LiteralPathPart$
}
/** @constructor */
function $c_Lio_youi_net_PathPart$() {
  $c_O.call(this);
  this.ArgumentPartRegex$1 = null
}
$c_Lio_youi_net_PathPart$.prototype = new $h_O();
$c_Lio_youi_net_PathPart$.prototype.constructor = $c_Lio_youi_net_PathPart$;
/** @constructor */
function $h_Lio_youi_net_PathPart$() {
  /*<skip>*/
}
$h_Lio_youi_net_PathPart$.prototype = $c_Lio_youi_net_PathPart$.prototype;
$c_Lio_youi_net_PathPart$.prototype.init___ = (function() {
  $n_Lio_youi_net_PathPart$ = this;
  var this$2 = new $c_sci_StringOps().init___T("[:](.+)");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  this.ArgumentPartRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames);
  return this
});
$c_Lio_youi_net_PathPart$.prototype.equals__Lio_youi_net_PathPart__Lio_youi_net_PathPart__Z = (function(p1, p2) {
  return (((p1 === null) ? (p2 === null) : p1.equals__O__Z(p2)) || ($is_Lio_youi_net_LiteralPathPart(p1) ? $is_Lio_youi_net_ArgumentPathPart(p2) : ($is_Lio_youi_net_ArgumentPathPart(p1) && $is_Lio_youi_net_LiteralPathPart(p2))))
});
$c_Lio_youi_net_PathPart$.prototype.apply__T__s_Option = (function(value) {
  if (((value === null) || (value === ""))) {
    return $m_s_None$()
  };
  if ((value === "..")) {
    return new $c_s_Some().init___O($m_Lio_youi_net_UpLevelPathPart$())
  };
  if ((value === ".")) {
    return new $c_s_Some().init___O($m_Lio_youi_net_SameLevelPathPart$())
  };
  var o18 = this.ArgumentPartRegex$1.unapplySeq__jl_CharSequence__s_Option(value);
  if ((!o18.isEmpty__Z())) {
    if ((o18.get__O() !== null)) {
      var this$1 = $as_sc_LinearSeqOptimized(o18.get__O());
      var jsx$1 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$1, 1) === 0)
    } else {
      var jsx$1 = false
    }
  } else {
    var jsx$1 = false
  };
  if (jsx$1) {
    var this$2 = $as_sc_LinearSeqOptimized(o18.get__O());
    var name = $as_T($f_sc_LinearSeqOptimized__apply__I__O(this$2, 0));
    return new $c_s_Some().init___O(new $c_Lio_youi_net_ArgumentPathPart().init___T(name))
  };
  return new $c_s_Some().init___O(new $c_Lio_youi_net_LiteralPathPart().init___T(value))
});
var $d_Lio_youi_net_PathPart$ = new $TypeData().initClass({
  Lio_youi_net_PathPart$: 0
}, false, "io.youi.net.PathPart$", {
  Lio_youi_net_PathPart$: 1,
  O: 1
});
$c_Lio_youi_net_PathPart$.prototype.$classData = $d_Lio_youi_net_PathPart$;
var $n_Lio_youi_net_PathPart$ = (void 0);
function $m_Lio_youi_net_PathPart$() {
  if ((!$n_Lio_youi_net_PathPart$)) {
    $n_Lio_youi_net_PathPart$ = new $c_Lio_youi_net_PathPart$().init___()
  };
  return $n_Lio_youi_net_PathPart$
}
/** @constructor */
function $c_Lio_youi_net_URL$URLParts() {
  $c_O.call(this);
  this.pathAndArgs$1 = null;
  this.asString$1 = null;
  this.encoded$1 = false;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_net_URL$URLParts.prototype = new $h_O();
$c_Lio_youi_net_URL$URLParts.prototype.constructor = $c_Lio_youi_net_URL$URLParts;
/** @constructor */
function $h_Lio_youi_net_URL$URLParts() {
  /*<skip>*/
}
$h_Lio_youi_net_URL$URLParts.prototype = $c_Lio_youi_net_URL$URLParts.prototype;
$c_Lio_youi_net_URL$URLParts.prototype.asString__T = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.asString$lzycompute__p1__T() : this.asString$1)
});
$c_Lio_youi_net_URL$URLParts.prototype.toString__T = (function() {
  return this.asString__T()
});
$c_Lio_youi_net_URL$URLParts.prototype.pathAndArgs__T = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.pathAndArgs$lzycompute__p1__T() : this.pathAndArgs$1)
});
$c_Lio_youi_net_URL$URLParts.prototype.asString$lzycompute__p1__T = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.asString$1 = (("" + this.$$outer$1.base__T()) + this.pathAndArgs__T());
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.asString$1
});
$c_Lio_youi_net_URL$URLParts.prototype.init___Lio_youi_net_URL__Z = (function($$outer, encoded) {
  this.encoded$1 = encoded;
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_net_URL$URLParts.prototype.pathAndArgs$lzycompute__p1__T = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var b = new $c_scm_StringBuilder().init___();
    b.append__O__scm_StringBuilder(this.$$outer$1.path$1);
    b.append__T__scm_StringBuilder((this.encoded$1 ? this.$$outer$1.parameters$1.encoded__T() : this.$$outer$1.parameters$1.decoded__T()));
    var this$1 = this.$$outer$1.fragment$1;
    if ((!this$1.isEmpty__Z())) {
      var arg1 = this$1.get__O();
      var f = $as_T(arg1);
      b.append__C__scm_StringBuilder(35);
      b.append__T__scm_StringBuilder(f)
    };
    this.pathAndArgs$1 = b.underlying$5.java$lang$StringBuilder$$content$f;
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.pathAndArgs$1
});
var $d_Lio_youi_net_URL$URLParts = new $TypeData().initClass({
  Lio_youi_net_URL$URLParts: 0
}, false, "io.youi.net.URL$URLParts", {
  Lio_youi_net_URL$URLParts: 1,
  O: 1
});
$c_Lio_youi_net_URL$URLParts.prototype.$classData = $d_Lio_youi_net_URL$URLParts;
/** @constructor */
function $c_Lio_youi_package$() {
  $c_O.call(this);
  this.ppi$1 = 0.0;
  this.bitmap$0$1 = false
}
$c_Lio_youi_package$.prototype = new $h_O();
$c_Lio_youi_package$.prototype.constructor = $c_Lio_youi_package$;
/** @constructor */
function $h_Lio_youi_package$() {
  /*<skip>*/
}
$h_Lio_youi_package$.prototype = $c_Lio_youi_package$.prototype;
$c_Lio_youi_package$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_package$.prototype.ppi__D = (function() {
  return ((!this.bitmap$0$1) ? this.ppi$lzycompute__p1__D() : this.ppi$1)
});
$c_Lio_youi_package$.prototype.ppi$lzycompute__p1__D = (function() {
  if ((!this.bitmap$0$1)) {
    var div = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("div");
    div.style.width = "1in";
    $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(div);
    try {
      var jsx$1 = $uD(div.offsetWidth)
    } finally {
      $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.removeChild(div)
    };
    this.ppi$1 = jsx$1;
    this.bitmap$0$1 = true
  };
  return this.ppi$1
});
var $d_Lio_youi_package$ = new $TypeData().initClass({
  Lio_youi_package$: 0
}, false, "io.youi.package$", {
  Lio_youi_package$: 1,
  O: 1
});
$c_Lio_youi_package$.prototype.$classData = $d_Lio_youi_package$;
var $n_Lio_youi_package$ = (void 0);
function $m_Lio_youi_package$() {
  if ((!$n_Lio_youi_package$)) {
    $n_Lio_youi_package$ = new $c_Lio_youi_package$().init___()
  };
  return $n_Lio_youi_package$
}
/** @constructor */
function $c_Lio_youi_package$ExtendedCanvas() {
  $c_O.call(this);
  this.canvas$1 = null
}
$c_Lio_youi_package$ExtendedCanvas.prototype = new $h_O();
$c_Lio_youi_package$ExtendedCanvas.prototype.constructor = $c_Lio_youi_package$ExtendedCanvas;
/** @constructor */
function $h_Lio_youi_package$ExtendedCanvas() {
  /*<skip>*/
}
$h_Lio_youi_package$ExtendedCanvas.prototype = $c_Lio_youi_package$ExtendedCanvas.prototype;
$c_Lio_youi_package$ExtendedCanvas.prototype.init___Lorg_scalajs_dom_raw_HTMLCanvasElement = (function(canvas) {
  this.canvas$1 = canvas;
  return this
});
$c_Lio_youi_package$ExtendedCanvas.prototype.context__Lorg_scalajs_dom_raw_CanvasRenderingContext2D = (function() {
  return this.canvas$1.getContext("2d")
});
var $d_Lio_youi_package$ExtendedCanvas = new $TypeData().initClass({
  Lio_youi_package$ExtendedCanvas: 0
}, false, "io.youi.package$ExtendedCanvas", {
  Lio_youi_package$ExtendedCanvas: 1,
  O: 1
});
$c_Lio_youi_package$ExtendedCanvas.prototype.$classData = $d_Lio_youi_package$ExtendedCanvas;
/** @constructor */
function $c_Lio_youi_package$ExtendedGoogleFont() {
  $c_O.call(this);
  this.io$youi$ExtendedGoogleFont$$font$f = null
}
$c_Lio_youi_package$ExtendedGoogleFont.prototype = new $h_O();
$c_Lio_youi_package$ExtendedGoogleFont.prototype.constructor = $c_Lio_youi_package$ExtendedGoogleFont;
/** @constructor */
function $h_Lio_youi_package$ExtendedGoogleFont() {
  /*<skip>*/
}
$h_Lio_youi_package$ExtendedGoogleFont.prototype = $c_Lio_youi_package$ExtendedGoogleFont.prototype;
$c_Lio_youi_package$ExtendedGoogleFont.prototype.io$youi$ExtendedGoogleFont$$$anonfun$load$1__s_concurrent_Promise__V = (function(promise$1) {
  var value = this.io$youi$ExtendedGoogleFont$$font$f;
  $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$1, value)
});
$c_Lio_youi_package$ExtendedGoogleFont.prototype.load__s_concurrent_Future = (function() {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var f = (function(arg$outer, promise$1) {
    return (function() {
      arg$outer.io$youi$ExtendedGoogleFont$$$anonfun$load$1__s_concurrent_Promise__V(promise$1)
    })
  })(this, promise);
  var jsx$1 = $g.WebFont;
  var $this = {};
  $this.$$outer$2 = null;
  $this.$$outer$2 = this;
  var $this$1 = {};
  var value = [$s_Lio_youi_package$ExtendedGoogleFont$$anon$1__io$youi$ExtendedGoogleFont$$anon$$$outer__Lio_youi_package$ExtendedGoogleFont$$anon$1__Lio_youi_package$ExtendedGoogleFont($this).io$youi$ExtendedGoogleFont$$font$f.family__T()];
  $this$1.families = value;
  $this.google = $this$1;
  $this.active = f;
  jsx$1.load($this);
  return promise
});
$c_Lio_youi_package$ExtendedGoogleFont.prototype.init___Lio_youi_font_GoogleFont = (function(font) {
  this.io$youi$ExtendedGoogleFont$$font$f = font;
  return this
});
function $is_Lio_youi_package$ExtendedGoogleFont(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_package$ExtendedGoogleFont)))
}
function $as_Lio_youi_package$ExtendedGoogleFont(obj) {
  return (($is_Lio_youi_package$ExtendedGoogleFont(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.package$ExtendedGoogleFont"))
}
function $isArrayOf_Lio_youi_package$ExtendedGoogleFont(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_package$ExtendedGoogleFont)))
}
function $asArrayOf_Lio_youi_package$ExtendedGoogleFont(obj, depth) {
  return (($isArrayOf_Lio_youi_package$ExtendedGoogleFont(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.package$ExtendedGoogleFont;", depth))
}
var $d_Lio_youi_package$ExtendedGoogleFont = new $TypeData().initClass({
  Lio_youi_package$ExtendedGoogleFont: 0
}, false, "io.youi.package$ExtendedGoogleFont", {
  Lio_youi_package$ExtendedGoogleFont: 1,
  O: 1
});
$c_Lio_youi_package$ExtendedGoogleFont.prototype.$classData = $d_Lio_youi_package$ExtendedGoogleFont;
function $s_Lio_youi_package$ExtendedGoogleFont$$anon$1__io$youi$ExtendedGoogleFont$$anon$$$outer__Lio_youi_package$ExtendedGoogleFont$$anon$1__Lio_youi_package$ExtendedGoogleFont($this) {
  return $as_Lio_youi_package$ExtendedGoogleFont($this.$$outer$2)
}
/** @constructor */
function $c_Lio_youi_package$ExtendedGoogleFontWeight() {
  $c_O.call(this);
  this.io$youi$ExtendedGoogleFontWeight$$weight$f = null
}
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype = new $h_O();
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype.constructor = $c_Lio_youi_package$ExtendedGoogleFontWeight;
/** @constructor */
function $h_Lio_youi_package$ExtendedGoogleFontWeight() {
  /*<skip>*/
}
$h_Lio_youi_package$ExtendedGoogleFontWeight.prototype = $c_Lio_youi_package$ExtendedGoogleFontWeight.prototype;
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype.init___Lio_youi_font_GoogleFontWeight = (function(weight) {
  this.io$youi$ExtendedGoogleFontWeight$$weight$f = weight;
  return this
});
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype.io$youi$ExtendedGoogleFontWeight$$$anonfun$load$2__s_concurrent_Promise__V = (function(promise$2) {
  var value = this.io$youi$ExtendedGoogleFontWeight$$weight$f;
  $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$2, value)
});
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype.load__s_concurrent_Future = (function() {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var f = (function(arg$outer, promise$2) {
    return (function() {
      arg$outer.io$youi$ExtendedGoogleFontWeight$$$anonfun$load$2__s_concurrent_Promise__V(promise$2)
    })
  })(this, promise);
  var jsx$1 = $g.WebFont;
  var $this = {};
  $this.$$outer$2 = null;
  $this.$$outer$2 = this;
  var $this$1 = {};
  var value = [(($s_Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__io$youi$ExtendedGoogleFontWeight$$anon$$$outer__Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__Lio_youi_package$ExtendedGoogleFontWeight($this).io$youi$ExtendedGoogleFontWeight$$weight$f.font$1.family__T() + ":") + $s_Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__io$youi$ExtendedGoogleFontWeight$$anon$$$outer__Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__Lio_youi_package$ExtendedGoogleFontWeight($this).io$youi$ExtendedGoogleFontWeight$$weight$f.name$1)];
  $this$1.families = value;
  $this.google = $this$1;
  $this.active = f;
  jsx$1.load($this);
  return promise
});
function $is_Lio_youi_package$ExtendedGoogleFontWeight(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_package$ExtendedGoogleFontWeight)))
}
function $as_Lio_youi_package$ExtendedGoogleFontWeight(obj) {
  return (($is_Lio_youi_package$ExtendedGoogleFontWeight(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.package$ExtendedGoogleFontWeight"))
}
function $isArrayOf_Lio_youi_package$ExtendedGoogleFontWeight(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_package$ExtendedGoogleFontWeight)))
}
function $asArrayOf_Lio_youi_package$ExtendedGoogleFontWeight(obj, depth) {
  return (($isArrayOf_Lio_youi_package$ExtendedGoogleFontWeight(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.package$ExtendedGoogleFontWeight;", depth))
}
var $d_Lio_youi_package$ExtendedGoogleFontWeight = new $TypeData().initClass({
  Lio_youi_package$ExtendedGoogleFontWeight: 0
}, false, "io.youi.package$ExtendedGoogleFontWeight", {
  Lio_youi_package$ExtendedGoogleFontWeight: 1,
  O: 1
});
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype.$classData = $d_Lio_youi_package$ExtendedGoogleFontWeight;
function $s_Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__io$youi$ExtendedGoogleFontWeight$$anon$$$outer__Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__Lio_youi_package$ExtendedGoogleFontWeight($this) {
  return $as_Lio_youi_package$ExtendedGoogleFontWeight($this.$$outer$2)
}
/** @constructor */
function $c_Lio_youi_package$StylePropWorkflowDouble() {
  $c_O.call(this);
  this.prop$1 = null
}
$c_Lio_youi_package$StylePropWorkflowDouble.prototype = new $h_O();
$c_Lio_youi_package$StylePropWorkflowDouble.prototype.constructor = $c_Lio_youi_package$StylePropWorkflowDouble;
/** @constructor */
function $h_Lio_youi_package$StylePropWorkflowDouble() {
  /*<skip>*/
}
$h_Lio_youi_package$StylePropWorkflowDouble.prototype = $c_Lio_youi_package$StylePropWorkflowDouble.prototype;
$c_Lio_youi_package$StylePropWorkflowDouble.prototype.init___Lio_youi_theme_StyleProp = (function(prop) {
  this.prop$1 = prop;
  return this
});
$c_Lio_youi_package$StylePropWorkflowDouble.prototype.to__F0__Lio_youi_task_PartialAnimate = (function(destination) {
  return new $c_Lio_youi_task_PartialAnimate().init___F0__F1__F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var this$1 = $this.prop$1;
      var this$2 = this$1.value$1;
      return $uD(this$2.state__Lreactify_State().value__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(d$2) {
      var d = $uD(d$2);
      this$2$1.prop$1.$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, d$1) {
        return (function() {
          return d$1
        })
      })(this$2$1, d)))
    })
  })(this)), destination)
});
var $d_Lio_youi_package$StylePropWorkflowDouble = new $TypeData().initClass({
  Lio_youi_package$StylePropWorkflowDouble: 0
}, false, "io.youi.package$StylePropWorkflowDouble", {
  Lio_youi_package$StylePropWorkflowDouble: 1,
  O: 1
});
$c_Lio_youi_package$StylePropWorkflowDouble.prototype.$classData = $d_Lio_youi_package$StylePropWorkflowDouble;
/** @constructor */
function $c_Lio_youi_package$UINumericSize() {
  $c_O.call(this);
  this.d$1 = 0.0
}
$c_Lio_youi_package$UINumericSize.prototype = new $h_O();
$c_Lio_youi_package$UINumericSize.prototype.constructor = $c_Lio_youi_package$UINumericSize;
/** @constructor */
function $h_Lio_youi_package$UINumericSize() {
  /*<skip>*/
}
$h_Lio_youi_package$UINumericSize.prototype = $c_Lio_youi_package$UINumericSize.prototype;
$c_Lio_youi_package$UINumericSize.prototype.init___O__s_math_Numeric = (function(t, n) {
  var x = $uI(t);
  this.d$1 = x;
  return this
});
$c_Lio_youi_package$UINumericSize.prototype.$in__D = (function() {
  return (this.d$1 * $m_Lio_youi_package$().ppi__D())
});
$c_Lio_youi_package$UINumericSize.prototype.pt__D = (function() {
  return (this.$in__D() / 72.0)
});
var $d_Lio_youi_package$UINumericSize = new $TypeData().initClass({
  Lio_youi_package$UINumericSize: 0
}, false, "io.youi.package$UINumericSize", {
  Lio_youi_package$UINumericSize: 1,
  O: 1
});
$c_Lio_youi_package$UINumericSize.prototype.$classData = $d_Lio_youi_package$UINumericSize;
/** @constructor */
function $c_Lio_youi_paint_Border$() {
  $c_O.call(this);
  this.empty$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_paint_Border$.prototype = new $h_O();
$c_Lio_youi_paint_Border$.prototype.constructor = $c_Lio_youi_paint_Border$;
/** @constructor */
function $h_Lio_youi_paint_Border$() {
  /*<skip>*/
}
$h_Lio_youi_paint_Border$.prototype = $c_Lio_youi_paint_Border$.prototype;
$c_Lio_youi_paint_Border$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_paint_Border$.prototype.empty$lzycompute__p1__Lio_youi_paint_Border = (function() {
  if ((!this.bitmap$0$1)) {
    var stroke = $m_Lio_youi_paint_Stroke$().none__Lio_youi_paint_Stroke();
    this.empty$1 = new $c_Lio_youi_paint_RectangleBorder().init___Lio_youi_paint_Stroke__D(stroke, 0.0);
    this.bitmap$0$1 = true
  };
  return this.empty$1
});
$c_Lio_youi_paint_Border$.prototype.empty__Lio_youi_paint_Border = (function() {
  return ((!this.bitmap$0$1) ? this.empty$lzycompute__p1__Lio_youi_paint_Border() : this.empty$1)
});
var $d_Lio_youi_paint_Border$ = new $TypeData().initClass({
  Lio_youi_paint_Border$: 0
}, false, "io.youi.paint.Border$", {
  Lio_youi_paint_Border$: 1,
  O: 1
});
$c_Lio_youi_paint_Border$.prototype.$classData = $d_Lio_youi_paint_Border$;
var $n_Lio_youi_paint_Border$ = (void 0);
function $m_Lio_youi_paint_Border$() {
  if ((!$n_Lio_youi_paint_Border$)) {
    $n_Lio_youi_paint_Border$ = new $c_Lio_youi_paint_Border$().init___()
  };
  return $n_Lio_youi_paint_Border$
}
/** @constructor */
function $c_Lio_youi_paint_LineCap() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_paint_LineCap.prototype = new $h_O();
$c_Lio_youi_paint_LineCap.prototype.constructor = $c_Lio_youi_paint_LineCap;
/** @constructor */
function $h_Lio_youi_paint_LineCap() {
  /*<skip>*/
}
$h_Lio_youi_paint_LineCap.prototype = $c_Lio_youi_paint_LineCap.prototype;
$c_Lio_youi_paint_LineCap.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
/** @constructor */
function $c_Lio_youi_paint_LineJoin() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_paint_LineJoin.prototype = new $h_O();
$c_Lio_youi_paint_LineJoin.prototype.constructor = $c_Lio_youi_paint_LineJoin;
/** @constructor */
function $h_Lio_youi_paint_LineJoin() {
  /*<skip>*/
}
$h_Lio_youi_paint_LineJoin.prototype = $c_Lio_youi_paint_LineJoin.prototype;
$c_Lio_youi_paint_LineJoin.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $f_Lio_youi_spatial_BoundingBox__height__D($thiz) {
  return ($thiz.y2__D() - $thiz.y1__D())
}
function $f_Lio_youi_spatial_BoundingBox__adjustX__D($thiz) {
  return (-$thiz.x1__D())
}
function $f_Lio_youi_spatial_BoundingBox__toString__T($thiz) {
  return (((((((((((((((("BoundingBox(x1: " + $thiz.x1__D()) + ", y1: ") + $thiz.y1__D()) + ", x2: ") + $thiz.x2__D()) + ", y2: ") + $thiz.y2__D()) + ", adjustX: ") + $f_Lio_youi_spatial_BoundingBox__adjustX__D($thiz)) + ", adjustY: ") + $f_Lio_youi_spatial_BoundingBox__adjustY__D($thiz)) + ", width: ") + $f_Lio_youi_spatial_BoundingBox__width__D($thiz)) + ", height: ") + $f_Lio_youi_spatial_BoundingBox__height__D($thiz)) + ")")
}
function $f_Lio_youi_spatial_BoundingBox__adjustY__D($thiz) {
  return ($f_Lio_youi_spatial_BoundingBox__height__D($thiz) - $thiz.y2__D())
}
function $f_Lio_youi_spatial_BoundingBox__width__D($thiz) {
  return ($thiz.x2__D() - $thiz.x1__D())
}
/** @constructor */
function $c_Lio_youi_spatial_BoundingBox$() {
  $c_O.call(this);
  this.zero$1 = null;
  this.temp$1 = null
}
$c_Lio_youi_spatial_BoundingBox$.prototype = new $h_O();
$c_Lio_youi_spatial_BoundingBox$.prototype.constructor = $c_Lio_youi_spatial_BoundingBox$;
/** @constructor */
function $h_Lio_youi_spatial_BoundingBox$() {
  /*<skip>*/
}
$h_Lio_youi_spatial_BoundingBox$.prototype = $c_Lio_youi_spatial_BoundingBox$.prototype;
$c_Lio_youi_spatial_BoundingBox$.prototype.init___ = (function() {
  $n_Lio_youi_spatial_BoundingBox$ = this;
  $m_Lio_youi_spatial_BoundingBox$();
  $m_Lio_youi_spatial_BoundingBox$();
  var x1 = 0.0;
  $m_Lio_youi_spatial_BoundingBox$();
  var y1 = 0.0;
  $m_Lio_youi_spatial_BoundingBox$();
  var x2 = 0.0;
  $m_Lio_youi_spatial_BoundingBox$();
  var y2 = 0.0;
  this.zero$1 = new $c_Lio_youi_spatial_ImmutableBoundingBox().init___D__D__D__D(x1, y1, x2, y2);
  this.temp$1 = new $c_Lio_youi_spatial_MutableBoundingBox().init___D__D__D__D(0.0, 0.0, 0.0, 0.0);
  return this
});
var $d_Lio_youi_spatial_BoundingBox$ = new $TypeData().initClass({
  Lio_youi_spatial_BoundingBox$: 0
}, false, "io.youi.spatial.BoundingBox$", {
  Lio_youi_spatial_BoundingBox$: 1,
  O: 1
});
$c_Lio_youi_spatial_BoundingBox$.prototype.$classData = $d_Lio_youi_spatial_BoundingBox$;
var $n_Lio_youi_spatial_BoundingBox$ = (void 0);
function $m_Lio_youi_spatial_BoundingBox$() {
  if ((!$n_Lio_youi_spatial_BoundingBox$)) {
    $n_Lio_youi_spatial_BoundingBox$ = new $c_Lio_youi_spatial_BoundingBox$().init___()
  };
  return $n_Lio_youi_spatial_BoundingBox$
}
/** @constructor */
function $c_Lio_youi_spatial_Matrix3$() {
  $c_O.call(this);
  this.Identity$1 = null;
  this.Empty$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_spatial_Matrix3$.prototype = new $h_O();
$c_Lio_youi_spatial_Matrix3$.prototype.constructor = $c_Lio_youi_spatial_Matrix3$;
/** @constructor */
function $h_Lio_youi_spatial_Matrix3$() {
  /*<skip>*/
}
$h_Lio_youi_spatial_Matrix3$.prototype = $c_Lio_youi_spatial_Matrix3$.prototype;
$c_Lio_youi_spatial_Matrix3$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_spatial_Matrix3$.prototype.Identity__Lio_youi_spatial_Matrix3 = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.Identity$lzycompute__p1__Lio_youi_spatial_Matrix3() : this.Identity$1)
});
$c_Lio_youi_spatial_Matrix3$.prototype.Identity$lzycompute__p1__Lio_youi_spatial_Matrix3 = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.Identity$1 = new $c_Lio_youi_spatial_ImmutableMatrix3().init___D__D__D__D__D__D__D__D__D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.Identity$1
});
var $d_Lio_youi_spatial_Matrix3$ = new $TypeData().initClass({
  Lio_youi_spatial_Matrix3$: 0
}, false, "io.youi.spatial.Matrix3$", {
  Lio_youi_spatial_Matrix3$: 1,
  O: 1
});
$c_Lio_youi_spatial_Matrix3$.prototype.$classData = $d_Lio_youi_spatial_Matrix3$;
var $n_Lio_youi_spatial_Matrix3$ = (void 0);
function $m_Lio_youi_spatial_Matrix3$() {
  if ((!$n_Lio_youi_spatial_Matrix3$)) {
    $n_Lio_youi_spatial_Matrix3$ = new $c_Lio_youi_spatial_Matrix3$().init___()
  };
  return $n_Lio_youi_spatial_Matrix3$
}
function $f_Lio_youi_spatial_Point__equals__O__Z($thiz, obj) {
  if ($is_Lio_youi_spatial_Point(obj)) {
    var x2 = $as_Lio_youi_spatial_Point(obj);
    var d = $thiz.x$1;
    var other = x2.x$1;
    var this$3 = $m_Lio_youi_spatial_package$().tolerance__F2();
    if ($uZ(this$3.apply__O__O__O(d, other))) {
      var d$1 = $thiz.y$1;
      var other$1 = x2.y$1;
      var this$6 = $m_Lio_youi_spatial_package$().tolerance__F2();
      return $uZ(this$6.apply__O__O__O(d$1, other$1))
    } else {
      return false
    }
  } else {
    return false
  }
}
function $f_Lio_youi_spatial_Point__toString__T($thiz) {
  return (((("Point(x: " + $thiz.x$1) + ", y: ") + $thiz.y$1) + ")")
}
function $is_Lio_youi_spatial_Point(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_spatial_Point)))
}
function $as_Lio_youi_spatial_Point(obj) {
  return (($is_Lio_youi_spatial_Point(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.spatial.Point"))
}
function $isArrayOf_Lio_youi_spatial_Point(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_spatial_Point)))
}
function $asArrayOf_Lio_youi_spatial_Point(obj, depth) {
  return (($isArrayOf_Lio_youi_spatial_Point(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.spatial.Point;", depth))
}
function $f_Lio_youi_spatial_Size__equals__O__Z($thiz, obj) {
  if ($is_Lio_youi_spatial_Size(obj)) {
    var x2 = $as_Lio_youi_spatial_Size(obj);
    return (($thiz.width$1 === x2.width$1) && ($thiz.height$1 === x2.height$1))
  } else {
    return false
  }
}
function $f_Lio_youi_spatial_Size__toString__T($thiz) {
  return (((("Size(width: " + $thiz.width$1) + ", height: ") + $thiz.height$1) + ")")
}
function $is_Lio_youi_spatial_Size(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_spatial_Size)))
}
function $as_Lio_youi_spatial_Size(obj) {
  return (($is_Lio_youi_spatial_Size(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.spatial.Size"))
}
function $isArrayOf_Lio_youi_spatial_Size(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_spatial_Size)))
}
function $asArrayOf_Lio_youi_spatial_Size(obj, depth) {
  return (($isArrayOf_Lio_youi_spatial_Size(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.spatial.Size;", depth))
}
/** @constructor */
function $c_Lio_youi_spatial_package$() {
  $c_O.call(this);
  this.tolerance$1 = null;
  this.precision$1 = 0.0;
  this.bitmap$0$1 = false
}
$c_Lio_youi_spatial_package$.prototype = new $h_O();
$c_Lio_youi_spatial_package$.prototype.constructor = $c_Lio_youi_spatial_package$;
/** @constructor */
function $h_Lio_youi_spatial_package$() {
  /*<skip>*/
}
$h_Lio_youi_spatial_package$.prototype = $c_Lio_youi_spatial_package$.prototype;
$c_Lio_youi_spatial_package$.prototype.init___ = (function() {
  this.precision$1 = 0.001;
  return this
});
$c_Lio_youi_spatial_package$.prototype.tolerantEquals__D__D__D__Z = (function(precision, d1, d2) {
  var a = (d1 - d2);
  return ($uD($g.Math.abs(a)) <= precision)
});
$c_Lio_youi_spatial_package$.prototype.tolerance$lzycompute__p1__F2 = (function() {
  if ((!this.bitmap$0$1)) {
    this.tolerance$1 = new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this) {
      return (function(d1$2, d2$2) {
        var d1 = $uD(d1$2);
        var d2 = $uD(d2$2);
        return $m_Lio_youi_spatial_package$().tolerantEquals__D__D__D__Z($m_Lio_youi_spatial_package$().precision$1, d1, d2)
      })
    })(this));
    this.bitmap$0$1 = true
  };
  return this.tolerance$1
});
$c_Lio_youi_spatial_package$.prototype.tolerance__F2 = (function() {
  return ((!this.bitmap$0$1) ? this.tolerance$lzycompute__p1__F2() : this.tolerance$1)
});
var $d_Lio_youi_spatial_package$ = new $TypeData().initClass({
  Lio_youi_spatial_package$: 0
}, false, "io.youi.spatial.package$", {
  Lio_youi_spatial_package$: 1,
  O: 1
});
$c_Lio_youi_spatial_package$.prototype.$classData = $d_Lio_youi_spatial_package$;
var $n_Lio_youi_spatial_package$ = (void 0);
function $m_Lio_youi_spatial_package$() {
  if ((!$n_Lio_youi_spatial_package$)) {
    $n_Lio_youi_spatial_package$ = new $c_Lio_youi_spatial_package$().init___()
  };
  return $n_Lio_youi_spatial_package$
}
/** @constructor */
function $c_Lio_youi_stream_StreamURL$() {
  $c_O.call(this)
}
$c_Lio_youi_stream_StreamURL$.prototype = new $h_O();
$c_Lio_youi_stream_StreamURL$.prototype.constructor = $c_Lio_youi_stream_StreamURL$;
/** @constructor */
function $h_Lio_youi_stream_StreamURL$() {
  /*<skip>*/
}
$h_Lio_youi_stream_StreamURL$.prototype = $c_Lio_youi_stream_StreamURL$.prototype;
$c_Lio_youi_stream_StreamURL$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_stream_StreamURL$.prototype.stream__Lio_youi_net_URL__s_Option__I__sci_Map__Z__T__s_concurrent_Future = (function(url, data, timeout, headers, withCredentials, responseType) {
  var request = new $c_Lio_youi_ajax_AjaxRequest().init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T(url, data, timeout, headers.$$plus__T2__sci_Map(new $c_T2().init___O__O("streaming", "true")), withCredentials, responseType);
  var future = request.send__s_concurrent_Future();
  return future.map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      return $as_T(x$1$2.responseText)
    })
  })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
var $d_Lio_youi_stream_StreamURL$ = new $TypeData().initClass({
  Lio_youi_stream_StreamURL$: 0
}, false, "io.youi.stream.StreamURL$", {
  Lio_youi_stream_StreamURL$: 1,
  O: 1
});
$c_Lio_youi_stream_StreamURL$.prototype.$classData = $d_Lio_youi_stream_StreamURL$;
var $n_Lio_youi_stream_StreamURL$ = (void 0);
function $m_Lio_youi_stream_StreamURL$() {
  if ((!$n_Lio_youi_stream_StreamURL$)) {
    $n_Lio_youi_stream_StreamURL$ = new $c_Lio_youi_stream_StreamURL$().init___()
  };
  return $n_Lio_youi_stream_StreamURL$
}
/** @constructor */
function $c_Lio_youi_style_FontFamily() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_FontFamily.prototype = new $h_O();
$c_Lio_youi_style_FontFamily.prototype.constructor = $c_Lio_youi_style_FontFamily;
/** @constructor */
function $h_Lio_youi_style_FontFamily() {
  /*<skip>*/
}
$h_Lio_youi_style_FontFamily.prototype = $c_Lio_youi_style_FontFamily.prototype;
$c_Lio_youi_style_FontFamily.prototype.equals__O__Z = (function(x$1) {
  return $m_Lio_youi_style_FontFamily$().equals$extension__T__O__Z(this.value$1, x$1)
});
$c_Lio_youi_style_FontFamily.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
$c_Lio_youi_style_FontFamily.prototype.hashCode__I = (function() {
  var $$this = this.value$1;
  return $m_sjsr_RuntimeString$().hashCode__T__I($$this)
});
function $is_Lio_youi_style_FontFamily(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_FontFamily)))
}
function $as_Lio_youi_style_FontFamily(obj) {
  return (($is_Lio_youi_style_FontFamily(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.FontFamily"))
}
function $isArrayOf_Lio_youi_style_FontFamily(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_FontFamily)))
}
function $asArrayOf_Lio_youi_style_FontFamily(obj, depth) {
  return (($isArrayOf_Lio_youi_style_FontFamily(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.FontFamily;", depth))
}
var $d_Lio_youi_style_FontFamily = new $TypeData().initClass({
  Lio_youi_style_FontFamily: 0
}, false, "io.youi.style.FontFamily", {
  Lio_youi_style_FontFamily: 1,
  O: 1
});
$c_Lio_youi_style_FontFamily.prototype.$classData = $d_Lio_youi_style_FontFamily;
/** @constructor */
function $c_Lio_youi_style_FontWeight() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_FontWeight.prototype = new $h_O();
$c_Lio_youi_style_FontWeight.prototype.constructor = $c_Lio_youi_style_FontWeight;
/** @constructor */
function $h_Lio_youi_style_FontWeight() {
  /*<skip>*/
}
$h_Lio_youi_style_FontWeight.prototype = $c_Lio_youi_style_FontWeight.prototype;
$c_Lio_youi_style_FontWeight.prototype.equals__O__Z = (function(x$1) {
  return $m_Lio_youi_style_FontWeight$().equals$extension__T__O__Z(this.value$1, x$1)
});
$c_Lio_youi_style_FontWeight.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
$c_Lio_youi_style_FontWeight.prototype.hashCode__I = (function() {
  var $$this = this.value$1;
  return $m_sjsr_RuntimeString$().hashCode__T__I($$this)
});
function $is_Lio_youi_style_FontWeight(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_FontWeight)))
}
function $as_Lio_youi_style_FontWeight(obj) {
  return (($is_Lio_youi_style_FontWeight(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.FontWeight"))
}
function $isArrayOf_Lio_youi_style_FontWeight(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_FontWeight)))
}
function $asArrayOf_Lio_youi_style_FontWeight(obj, depth) {
  return (($isArrayOf_Lio_youi_style_FontWeight(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.FontWeight;", depth))
}
var $d_Lio_youi_style_FontWeight = new $TypeData().initClass({
  Lio_youi_style_FontWeight: 0
}, false, "io.youi.style.FontWeight", {
  Lio_youi_style_FontWeight: 1,
  O: 1
});
$c_Lio_youi_style_FontWeight.prototype.$classData = $d_Lio_youi_style_FontWeight;
/** @constructor */
function $c_Lio_youi_style_HTMLBorderStyle() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_HTMLBorderStyle.prototype = new $h_O();
$c_Lio_youi_style_HTMLBorderStyle.prototype.constructor = $c_Lio_youi_style_HTMLBorderStyle;
/** @constructor */
function $h_Lio_youi_style_HTMLBorderStyle() {
  /*<skip>*/
}
$h_Lio_youi_style_HTMLBorderStyle.prototype = $c_Lio_youi_style_HTMLBorderStyle.prototype;
$c_Lio_youi_style_HTMLBorderStyle.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
/** @constructor */
function $c_Lio_youi_style_Overflow() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_Overflow.prototype = new $h_O();
$c_Lio_youi_style_Overflow.prototype.constructor = $c_Lio_youi_style_Overflow;
/** @constructor */
function $h_Lio_youi_style_Overflow() {
  /*<skip>*/
}
$h_Lio_youi_style_Overflow.prototype = $c_Lio_youi_style_Overflow.prototype;
$c_Lio_youi_style_Overflow.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_style_Overflow(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_Overflow)))
}
function $as_Lio_youi_style_Overflow(obj) {
  return (($is_Lio_youi_style_Overflow(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.Overflow"))
}
function $isArrayOf_Lio_youi_style_Overflow(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_Overflow)))
}
function $asArrayOf_Lio_youi_style_Overflow(obj, depth) {
  return (($isArrayOf_Lio_youi_style_Overflow(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.Overflow;", depth))
}
/** @constructor */
function $c_Lio_youi_style_Visibility() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_Visibility.prototype = new $h_O();
$c_Lio_youi_style_Visibility.prototype.constructor = $c_Lio_youi_style_Visibility;
/** @constructor */
function $h_Lio_youi_style_Visibility() {
  /*<skip>*/
}
$h_Lio_youi_style_Visibility.prototype = $c_Lio_youi_style_Visibility.prototype;
$c_Lio_youi_style_Visibility.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_style_Visibility(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_Visibility)))
}
function $as_Lio_youi_style_Visibility(obj) {
  return (($is_Lio_youi_style_Visibility(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.Visibility"))
}
function $isArrayOf_Lio_youi_style_Visibility(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_Visibility)))
}
function $asArrayOf_Lio_youi_style_Visibility(obj, depth) {
  return (($isArrayOf_Lio_youi_style_Visibility(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.Visibility;", depth))
}
/** @constructor */
function $c_Lio_youi_style_WhiteSpace() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_WhiteSpace.prototype = new $h_O();
$c_Lio_youi_style_WhiteSpace.prototype.constructor = $c_Lio_youi_style_WhiteSpace;
/** @constructor */
function $h_Lio_youi_style_WhiteSpace() {
  /*<skip>*/
}
$h_Lio_youi_style_WhiteSpace.prototype = $c_Lio_youi_style_WhiteSpace.prototype;
$c_Lio_youi_style_WhiteSpace.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_style_WhiteSpace(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_WhiteSpace)))
}
function $as_Lio_youi_style_WhiteSpace(obj) {
  return (($is_Lio_youi_style_WhiteSpace(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.WhiteSpace"))
}
function $isArrayOf_Lio_youi_style_WhiteSpace(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_WhiteSpace)))
}
function $asArrayOf_Lio_youi_style_WhiteSpace(obj, depth) {
  return (($isArrayOf_Lio_youi_style_WhiteSpace(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.WhiteSpace;", depth))
}
function $f_Lio_youi_task_DurationTask__update__D__Z__Lio_youi_task_Conclusion($thiz, delta, reset) {
  if (reset) {
    $thiz.io$youi$task$DurationTask$$elapsed$und$eq__D__V(0.0)
  };
  $thiz.io$youi$task$DurationTask$$elapsed$und$eq__D__V(($thiz.io$youi$task$DurationTask$$elapsed__D() + delta));
  var this$1 = $thiz.time__s_concurrent_duration_FiniteDuration();
  var t = this$1.unit$2.toMillis__J__J(this$1.length$2);
  var lo = t.lo$2;
  var hi = t.hi$2;
  var duration = ($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo, hi) / 1000.0);
  var x = ($thiz.io$youi$task$DurationTask$$elapsed__D() / duration);
  var progress = $uD($g.Math.min(x, 1.0));
  $thiz.act__D__D__D__Z__V(delta, $thiz.io$youi$task$DurationTask$$elapsed__D(), progress, reset);
  return (($thiz.io$youi$task$DurationTask$$elapsed__D() >= duration) ? $m_Lio_youi_task_Conclusion$Finished$() : $m_Lio_youi_task_Conclusion$Continue$())
}
/** @constructor */
function $c_Lio_youi_task_TaskInstance() {
  $c_O.call(this);
  this.task$1 = null;
  this.updates$1 = null;
  this.promise$1 = null;
  this.reaction$1 = null;
  this.first$1 = false;
  this.elapsed$1 = 0.0;
  this.paused$1 = false;
  this.step$1 = 0.0;
  this.future$1 = null
}
$c_Lio_youi_task_TaskInstance.prototype = new $h_O();
$c_Lio_youi_task_TaskInstance.prototype.constructor = $c_Lio_youi_task_TaskInstance;
/** @constructor */
function $h_Lio_youi_task_TaskInstance() {
  /*<skip>*/
}
$h_Lio_youi_task_TaskInstance.prototype = $c_Lio_youi_task_TaskInstance.prototype;
$c_Lio_youi_task_TaskInstance.prototype.init___Lio_youi_task_Task__Lio_youi_Updates = (function(task, updates) {
  this.task$1 = task;
  this.updates$1 = updates;
  this.promise$1 = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  this.first$1 = true;
  this.elapsed$1 = 0.0;
  this.paused$1 = false;
  this.step$1 = 0.0;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(delta$2) {
      var delta = $uD(delta$2);
      var x1 = $this.updates$1;
      if ((!$is_Lio_youi_task_TaskSupport(x1))) {
        var updateTask = true
      } else {
        var x2 = $as_Lio_youi_task_TaskSupport(x1);
        var updateTask = x2.updateTasks__Z()
      };
      if (((!$this.paused$1) && updateTask)) {
        $this.elapsed$1 = ($this.elapsed$1 + delta);
        if (($this.step$1 >= 0.0)) {
          $this.step$1 = 0.0;
          var x1$2 = $this.task$1.update__D__Z__Lio_youi_task_Conclusion(delta, $this.first$1);
          var x = $m_Lio_youi_task_Conclusion$Continue$();
          if ((!(x === x1$2))) {
            var x$3 = $m_Lio_youi_task_Conclusion$Finished$();
            if ((x$3 === x1$2)) {
              $this.updates$1.delta__Lreactify_Channel().reactions__Lreactify_reaction_Reactions().$$minus$eq__Lreactify_reaction_Reaction__Z($this.reaction$1);
              var this$3 = $this.promise$1;
              var value = $this.elapsed$1;
              $f_s_concurrent_Promise__success__O__s_concurrent_Promise(this$3, value)
            } else {
              throw new $c_s_MatchError().init___O(x1$2)
            }
          };
          $this.first$1 = false
        }
      }
    })
  })(this));
  var priority = $m_Lreactify_Priority$().Normal$1;
  this.reaction$1 = new $c_Lreactify_reaction_FunctionReaction().init___F1__D(f, priority);
  var this$6 = this.promise$1;
  this.future$1 = this$6;
  return this
});
$c_Lio_youi_task_TaskInstance.prototype.start__s_concurrent_Future = (function() {
  this.updates$1.delta__Lreactify_Channel().reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(this.reaction$1);
  return this.future$1
});
var $d_Lio_youi_task_TaskInstance = new $TypeData().initClass({
  Lio_youi_task_TaskInstance: 0
}, false, "io.youi.task.TaskInstance", {
  Lio_youi_task_TaskInstance: 1,
  O: 1
});
$c_Lio_youi_task_TaskInstance.prototype.$classData = $d_Lio_youi_task_TaskInstance;
/** @constructor */
function $c_Lio_youi_task_package$() {
  $c_O.call(this)
}
$c_Lio_youi_task_package$.prototype = new $h_O();
$c_Lio_youi_task_package$.prototype.constructor = $c_Lio_youi_task_package$;
/** @constructor */
function $h_Lio_youi_task_package$() {
  /*<skip>*/
}
$h_Lio_youi_task_package$.prototype = $c_Lio_youi_task_package$.prototype;
$c_Lio_youi_task_package$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_task_package$.prototype.synchronous__F0__Lio_youi_task_Action = (function(f) {
  var f$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, f$1) {
    return (function() {
      f$1.apply__O();
      $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
    })
  })(this, f));
  return new $c_Lio_youi_task_Action().init___F0(f$2)
});
var $d_Lio_youi_task_package$ = new $TypeData().initClass({
  Lio_youi_task_package$: 0
}, false, "io.youi.task.package$", {
  Lio_youi_task_package$: 1,
  O: 1
});
$c_Lio_youi_task_package$.prototype.$classData = $d_Lio_youi_task_package$;
var $n_Lio_youi_task_package$ = (void 0);
function $m_Lio_youi_task_package$() {
  if ((!$n_Lio_youi_task_package$)) {
    $n_Lio_youi_task_package$ = new $c_Lio_youi_task_package$().init___()
  };
  return $n_Lio_youi_task_package$
}
/** @constructor */
function $c_Lio_youi_task_package$StateChannelWorkflowDouble() {
  $c_O.call(this);
  this.state$1 = null
}
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype = new $h_O();
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype.constructor = $c_Lio_youi_task_package$StateChannelWorkflowDouble;
/** @constructor */
function $h_Lio_youi_task_package$StateChannelWorkflowDouble() {
  /*<skip>*/
}
$h_Lio_youi_task_package$StateChannelWorkflowDouble.prototype = $c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype;
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype.init___Lreactify_Var = (function(state) {
  this.state$1 = state;
  return this
});
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype.to__F0__Lio_youi_task_PartialAnimate = (function(destination) {
  return new $c_Lio_youi_task_PartialAnimate().init___F0__F1__F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var this$1 = $this.state$1;
      return $uD(this$1.state__Lreactify_State().value__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(d$2) {
      var d = $uD(d$2);
      var this$3 = this$2.state$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, d$1) {
        return (function() {
          return d$1
        })
      })(this$2, d));
      this$3.set__F0__V(value)
    })
  })(this)), destination)
});
var $d_Lio_youi_task_package$StateChannelWorkflowDouble = new $TypeData().initClass({
  Lio_youi_task_package$StateChannelWorkflowDouble: 0
}, false, "io.youi.task.package$StateChannelWorkflowDouble", {
  Lio_youi_task_package$StateChannelWorkflowDouble: 1,
  O: 1
});
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype.$classData = $d_Lio_youi_task_package$StateChannelWorkflowDouble;
/** @constructor */
function $c_Lio_youi_theme_ComponentTheme$padding$() {
  $c_O.call(this);
  this.left$1 = null;
  this.right$1 = null;
  this.top$1 = null;
  this.bottom$1 = null;
  this.width$1 = null;
  this.height$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_theme_ComponentTheme$padding$.prototype = new $h_O();
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.constructor = $c_Lio_youi_theme_ComponentTheme$padding$;
/** @constructor */
function $h_Lio_youi_theme_ComponentTheme$padding$() {
  /*<skip>*/
}
$h_Lio_youi_theme_ComponentTheme$padding$.prototype = $c_Lio_youi_theme_ComponentTheme$padding$.prototype;
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.right__Lio_youi_theme_StyleProp = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.right$lzycompute__p1__Lio_youi_theme_StyleProp() : this.right$1)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.bottom$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((8 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($f_Lio_youi_theme_StringifyImplicits__stringifyDouble__Lio_youi_theme_Stringify(this$1));
    this.bottom$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "padding.bottom", $default, connect, false, false, false);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottom$1
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.bottom__Lio_youi_theme_StyleProp = (function() {
  return (((((8 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.bottom$lzycompute__p1__Lio_youi_theme_StyleProp() : this.bottom$1)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.left__Lio_youi_theme_StyleProp = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.left$lzycompute__p1__Lio_youi_theme_StyleProp() : this.left$1)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.top$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((4 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($f_Lio_youi_theme_StringifyImplicits__stringifyDouble__Lio_youi_theme_Stringify(this$1));
    this.top$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "padding.top", $default, connect, false, false, false);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.top$1
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.right$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($f_Lio_youi_theme_StringifyImplicits__stringifyDouble__Lio_youi_theme_Stringify(this$1));
    this.right$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "padding.right", $default, connect, false, false, false);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.right$1
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.set__F0__V = (function(f) {
  this.left__Lio_youi_theme_StyleProp().set__F0__V(f);
  this.right__Lio_youi_theme_StyleProp().set__F0__V(f);
  this.top__Lio_youi_theme_StyleProp().set__F0__V(f);
  this.bottom__Lio_youi_theme_StyleProp().set__F0__V(f)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.top__Lio_youi_theme_StyleProp = (function() {
  return (((((4 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.top$lzycompute__p1__Lio_youi_theme_StyleProp() : this.top$1)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.init___Lio_youi_theme_ComponentTheme = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.left$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$7 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var n = $m_s_math_Numeric$IntIsIntegral$();
        var this$2 = new $c_Lio_youi_package$UINumericSize().init___O__s_math_Numeric(0, n);
        return this$2.d$1
      })
    })(this));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$3 = this.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($f_Lio_youi_theme_StringifyImplicits__stringifyDouble__Lio_youi_theme_Stringify(this$3));
    this.left$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$7, "padding.left", $default, connect, false, false, false);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.left$1
});
var $d_Lio_youi_theme_ComponentTheme$padding$ = new $TypeData().initClass({
  Lio_youi_theme_ComponentTheme$padding$: 0
}, false, "io.youi.theme.ComponentTheme$padding$", {
  Lio_youi_theme_ComponentTheme$padding$: 1,
  O: 1
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.$classData = $d_Lio_youi_theme_ComponentTheme$padding$;
/** @constructor */
function $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$() {
  $c_O.call(this);
  this.top$1 = null;
  this.bottom$1 = null;
  this.left$1 = null;
  this.right$1 = null;
  this.radius$module$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype = new $h_O();
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.constructor = $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$;
/** @constructor */
function $h_Lio_youi_theme_HTMLComponentTheme$htmlBorder$() {
  /*<skip>*/
}
$h_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype = $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype;
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.right__Lio_youi_theme_StyleProp = (function() {
  return (((((8 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.right$lzycompute__p1__Lio_youi_theme_StyleProp() : this.right$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.bottom$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_Lio_youi_style_HTMLBorder$().empty__Lio_youi_style_HTMLBorder()
      })
    })(this));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_HTMLBorder$());
    this.bottom$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-bottom", $default, connect, false, false, false);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottom$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.bottom__Lio_youi_theme_StyleProp = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.bottom$lzycompute__p1__Lio_youi_theme_StyleProp() : this.bottom$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.radius__Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$ = (function() {
  if ((this.radius$module$1 === null)) {
    this.radius$lzycompute$1__p1__V()
  };
  return this.radius$module$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.init___Lio_youi_theme_HTMLComponentTheme = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.top$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_Lio_youi_style_HTMLBorder$().empty__Lio_youi_style_HTMLBorder()
      })
    })(this));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_HTMLBorder$());
    this.top$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-top", $default, connect, false, false, false);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.top$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.left__Lio_youi_theme_StyleProp = (function() {
  return (((((4 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.left$lzycompute__p1__Lio_youi_theme_StyleProp() : this.left$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.right$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((8 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_Lio_youi_style_HTMLBorder$().empty__Lio_youi_style_HTMLBorder()
      })
    })(this));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_HTMLBorder$());
    this.right$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-right", $default, connect, false, false, false);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.right$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.top__Lio_youi_theme_StyleProp = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.top$lzycompute__p1__Lio_youi_theme_StyleProp() : this.top$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.$$colon$eq__F0__V = (function(border) {
  this.top__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(border);
  this.bottom__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(border);
  this.left__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(border);
  this.right__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(border)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.left$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((4 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_Lio_youi_style_HTMLBorder$().empty__Lio_youi_style_HTMLBorder()
      })
    })(this));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_HTMLBorder$());
    this.left$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-left", $default, connect, false, false, false);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.left$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.radius$lzycompute$1__p1__V = (function() {
  if ((this.radius$module$1 === null)) {
    this.radius$module$1 = new $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$().init___Lio_youi_theme_HTMLComponentTheme$htmlBorder$(this)
  }
});
var $d_Lio_youi_theme_HTMLComponentTheme$htmlBorder$ = new $TypeData().initClass({
  Lio_youi_theme_HTMLComponentTheme$htmlBorder$: 0
}, false, "io.youi.theme.HTMLComponentTheme$htmlBorder$", {
  Lio_youi_theme_HTMLComponentTheme$htmlBorder$: 1,
  O: 1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.$classData = $d_Lio_youi_theme_HTMLComponentTheme$htmlBorder$;
/** @constructor */
function $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$() {
  $c_O.call(this);
  this.topLeft$1 = null;
  this.topRight$1 = null;
  this.bottomLeft$1 = null;
  this.bottomRight$1 = null;
  this.top$module$1 = null;
  this.bottom$module$1 = null;
  this.left$module$1 = null;
  this.right$module$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype = new $h_O();
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.constructor = $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$;
/** @constructor */
function $h_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$() {
  /*<skip>*/
}
$h_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype = $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype;
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.bottomRight$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((8 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($f_Lio_youi_theme_StringifyImplicits__pixels__Lio_youi_theme_Stringify(this$1));
    this.bottomRight$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-bottom-right-radius", $default, connect, false, false, false);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottomRight$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.bottomLeft__Lio_youi_theme_StyleProp = (function() {
  return (((((4 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.bottomLeft$lzycompute__p1__Lio_youi_theme_StyleProp() : this.bottomLeft$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.init___Lio_youi_theme_HTMLComponentTheme$htmlBorder$ = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.topLeft$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($f_Lio_youi_theme_StringifyImplicits__pixels__Lio_youi_theme_Stringify(this$1));
    this.topLeft$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-top-left-radius", $default, connect, false, false, false);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.topLeft$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.topLeft__Lio_youi_theme_StyleProp = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.topLeft$lzycompute__p1__Lio_youi_theme_StyleProp() : this.topLeft$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.topRight$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($f_Lio_youi_theme_StringifyImplicits__pixels__Lio_youi_theme_Stringify(this$1));
    this.topRight$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-top-right-radius", $default, connect, false, false, false);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.topRight$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.bottomRight__Lio_youi_theme_StyleProp = (function() {
  return (((((8 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.bottomRight$lzycompute__p1__Lio_youi_theme_StyleProp() : this.bottomRight$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.$$colon$eq__F0__V = (function(value) {
  this.topLeft__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(value);
  this.topRight__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(value);
  this.bottomLeft__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(value);
  this.bottomRight__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(value)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.bottomLeft$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((4 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($f_Lio_youi_theme_StringifyImplicits__pixels__Lio_youi_theme_Stringify(this$1));
    this.bottomLeft$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-bottom-left-radius", $default, connect, false, false, false);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottomLeft$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.topRight__Lio_youi_theme_StyleProp = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.topRight$lzycompute__p1__Lio_youi_theme_StyleProp() : this.topRight$1)
});
var $d_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$ = new $TypeData().initClass({
  Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$: 0
}, false, "io.youi.theme.HTMLComponentTheme$htmlBorder$radius$", {
  Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$: 1,
  O: 1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.$classData = $d_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$;
/** @constructor */
function $c_Lio_youi_theme_HTMLComponentTheme$overflow$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype = new $h_O();
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.constructor = $c_Lio_youi_theme_HTMLComponentTheme$overflow$;
/** @constructor */
function $h_Lio_youi_theme_HTMLComponentTheme$overflow$() {
  /*<skip>*/
}
$h_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype = $c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype;
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.init___Lio_youi_theme_HTMLComponentTheme = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.y__Lio_youi_theme_StyleProp = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.y$lzycompute__p1__Lio_youi_theme_StyleProp() : this.y$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.x__Lio_youi_theme_StyleProp = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.x$lzycompute__p1__Lio_youi_theme_StyleProp() : this.x$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.y$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_Lio_youi_style_Overflow$Visible$()
      })
    })(this));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_Overflow$());
    this.y$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "overflow-y", $default, connect, false, false, false);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.$$colon$eq__F0__V = (function(overflow) {
  this.x__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(overflow);
  this.y__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(overflow)
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.x$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_Lio_youi_style_Overflow$Visible$()
      })
    })(this));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_Overflow$());
    this.x$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "overflow-x", $default, connect, false, false, false);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.x$1
});
var $d_Lio_youi_theme_HTMLComponentTheme$overflow$ = new $TypeData().initClass({
  Lio_youi_theme_HTMLComponentTheme$overflow$: 0
}, false, "io.youi.theme.HTMLComponentTheme$overflow$", {
  Lio_youi_theme_HTMLComponentTheme$overflow$: 1,
  O: 1
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.$classData = $d_Lio_youi_theme_HTMLComponentTheme$overflow$;
/** @constructor */
function $c_Lio_youi_theme_StyleConnect$() {
  $c_O.call(this)
}
$c_Lio_youi_theme_StyleConnect$.prototype = new $h_O();
$c_Lio_youi_theme_StyleConnect$.prototype.constructor = $c_Lio_youi_theme_StyleConnect$;
/** @constructor */
function $h_Lio_youi_theme_StyleConnect$() {
  /*<skip>*/
}
$h_Lio_youi_theme_StyleConnect$.prototype = $c_Lio_youi_theme_StyleConnect$.prototype;
$c_Lio_youi_theme_StyleConnect$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_theme_StyleConnect$.prototype.style__F1__Lio_youi_theme_Stringify__s_Option = (function(modifier, stringify) {
  return new $c_s_Some().init___O(new $c_Lio_youi_theme_StyleConnect$$anon$2().init___F1__Lio_youi_theme_Stringify(modifier, stringify))
});
$c_Lio_youi_theme_StyleConnect$.prototype.style__Lio_youi_theme_Stringify__s_Option = (function(stringify) {
  return this.style__F1__Lio_youi_theme_Stringify__s_Option(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(t$2) {
      return t$2
    })
  })(this)), stringify)
});
$c_Lio_youi_theme_StyleConnect$.prototype.flag__s_Option__s_Option__s_Option = (function(on, off) {
  return new $c_s_Some().init___O(new $c_Lio_youi_theme_StyleConnect$$anon$5().init___s_Option__s_Option(on, off))
});
$c_Lio_youi_theme_StyleConnect$.prototype.content__Lio_youi_theme_Stringify__s_Option = (function(stringify) {
  return new $c_s_Some().init___O(new $c_Lio_youi_theme_StyleConnect$$anon$3().init___Lio_youi_theme_Stringify(stringify))
});
$c_Lio_youi_theme_StyleConnect$.prototype.classify__Lio_youi_theme_Stringify__s_Option = (function(stringify) {
  return new $c_s_Some().init___O(new $c_Lio_youi_theme_StyleConnect$$anon$4().init___Lio_youi_theme_Stringify(stringify))
});
var $d_Lio_youi_theme_StyleConnect$ = new $TypeData().initClass({
  Lio_youi_theme_StyleConnect$: 0
}, false, "io.youi.theme.StyleConnect$", {
  Lio_youi_theme_StyleConnect$: 1,
  O: 1
});
$c_Lio_youi_theme_StyleConnect$.prototype.$classData = $d_Lio_youi_theme_StyleConnect$;
var $n_Lio_youi_theme_StyleConnect$ = (void 0);
function $m_Lio_youi_theme_StyleConnect$() {
  if ((!$n_Lio_youi_theme_StyleConnect$)) {
    $n_Lio_youi_theme_StyleConnect$ = new $c_Lio_youi_theme_StyleConnect$().init___()
  };
  return $n_Lio_youi_theme_StyleConnect$
}
/** @constructor */
function $c_Lio_youi_theme_StyleProp() {
  $c_O.call(this);
  this.name$1 = null;
  this.parent$1 = null;
  this.default$1 = null;
  this.option$1 = null;
  this.value$1 = null
}
$c_Lio_youi_theme_StyleProp.prototype = new $h_O();
$c_Lio_youi_theme_StyleProp.prototype.constructor = $c_Lio_youi_theme_StyleProp;
/** @constructor */
function $h_Lio_youi_theme_StyleProp() {
  /*<skip>*/
}
$h_Lio_youi_theme_StyleProp.prototype = $c_Lio_youi_theme_StyleProp.prototype;
$c_Lio_youi_theme_StyleProp.prototype.init___T__Lreactify_Var__F0 = (function(name, parent, $default) {
  this.name$1 = name;
  this.parent$1 = parent;
  this.default$1 = $default;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_s_None$()
    })
  })(this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.option$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name$1);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      var this$4 = this$2$1.option$1;
      var this$5 = $as_s_Option(this$4.state__Lreactify_State().value__O());
      if (this$5.isEmpty__Z()) {
        var this$6 = this$2$1.parent$1;
        var this$7 = $as_Lio_youi_theme_Theme(this$6.state__Lreactify_State().value__O());
        var name$2 = this$2$1.name$1;
        var this$8 = $f_Lio_youi_theme_Theme__get__T__s_Option(this$7, name$2);
        if (this$8.isEmpty__Z()) {
          var this$10 = $m_s_None$()
        } else {
          var arg1 = this$8.get__O();
          var x$1 = $as_Lio_youi_theme_StyleProp(arg1);
          var this$9 = x$1.value$1;
          var this$10 = new $c_s_Some().init___O(this$9.state__Lreactify_State().value__O())
        }
      } else {
        var this$10 = this$5
      };
      var $default$1 = this$2$1.default$1;
      return (this$10.isEmpty__Z() ? $default$1.apply__O() : this$10.get__O())
    })
  })(this));
  var name$3 = $m_s_None$();
  this.value$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$3);
  return this
});
$c_Lio_youi_theme_StyleProp.prototype.set__F0__V = (function(value) {
  var this$1 = this.option$1;
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, value$1) {
    return (function() {
      return $m_s_Option$().apply__O__s_Option(value$1.apply__O())
    })
  })(this, value));
  this$1.set__F0__V(value$2)
});
$c_Lio_youi_theme_StyleProp.prototype.$$colon$eq__F0__V = (function(value) {
  var this$1 = this.option$1;
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, value$1) {
    return (function() {
      return $m_s_Option$().apply__O__s_Option(value$1.apply__O())
    })
  })(this, value));
  this$1.set__F0__V(value$2)
});
$c_Lio_youi_theme_StyleProp.prototype.attachAndFire__F1__Lreactify_reaction_Reaction = (function(f) {
  var this$2 = this.value$1;
  var priority = $m_Lreactify_Priority$().Normal$1;
  return $f_Lreactify_Val__attachAndFire__F1__D__Lreactify_reaction_Reaction(this$2, f, priority)
});
function $is_Lio_youi_theme_StyleProp(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_theme_StyleProp)))
}
function $as_Lio_youi_theme_StyleProp(obj) {
  return (($is_Lio_youi_theme_StyleProp(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.theme.StyleProp"))
}
function $isArrayOf_Lio_youi_theme_StyleProp(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_theme_StyleProp)))
}
function $asArrayOf_Lio_youi_theme_StyleProp(obj, depth) {
  return (($isArrayOf_Lio_youi_theme_StyleProp(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.theme.StyleProp;", depth))
}
var $d_Lio_youi_theme_StyleProp = new $TypeData().initClass({
  Lio_youi_theme_StyleProp: 0
}, false, "io.youi.theme.StyleProp", {
  Lio_youi_theme_StyleProp: 1,
  O: 1
});
$c_Lio_youi_theme_StyleProp.prototype.$classData = $d_Lio_youi_theme_StyleProp;
function $f_Lio_youi_theme_Theme__$$init$__V($thiz) {
  $thiz.io$youi$theme$Theme$$undsetter$und$io$youi$theme$Theme$$store$und$eq__Lio_youi_MapStore__V(new $c_Lio_youi_MapStore().init___sci_Map($m_sci_Map$EmptyMap$()))
}
function $f_Lio_youi_theme_Theme__get__T__s_Option($thiz, name) {
  var x$2 = $m_Lio_youi_theme_Theme$();
  if (($thiz === x$2)) {
    var this$1 = $thiz.io$youi$theme$Theme$$store__Lio_youi_MapStore();
    return this$1.map$1.get__O__s_Option(name)
  } else {
    var this$2 = $thiz.io$youi$theme$Theme$$store__Lio_youi_MapStore();
    var this$3 = this$2.map$1.get__O__s_Option(name);
    if (this$3.isEmpty__Z()) {
      var this$4 = $thiz.parentTheme__Lreactify_Var();
      var this$5 = $as_Lio_youi_theme_Theme(this$4.state__Lreactify_State().value__O());
      return $f_Lio_youi_theme_Theme__get__T__s_Option(this$5, name)
    } else {
      return this$3
    }
  }
}
function $f_Lio_youi_theme_Theme__parentTheme__Lreactify_Var($thiz) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $this.defaultParentTheme__Lio_youi_theme_Theme()
    })
  })($thiz));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($thiz, name, $default, connect, updatesTransform, updatesRendering, ignoreParent) {
  var prop = new $c_Lio_youi_theme_StyleProp().init___T__Lreactify_Var__F0(name, $thiz.parentTheme__Lreactify_Var(), $default);
  $thiz.io$youi$theme$Theme$$store__Lio_youi_MapStore().update__T__O__V(name, prop);
  if ((!connect.isEmpty__Z())) {
    var arg1 = connect.get__O();
    var x$1 = $as_Lio_youi_theme_StyleConnect(arg1);
    x$1.init__Lio_youi_theme_Theme__Lio_youi_theme_StyleProp__T__V($thiz, prop, name)
  };
  if ((updatesTransform || updatesRendering)) {
    var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2, updatesTransform$1, updatesRendering$1) {
      return (function(x$2$2) {
        if (updatesTransform$1) {
          this$2.invalidateTransform__V()
        };
        if (updatesRendering$1) {
          this$2.invalidateRendering__V()
        }
      })
    })($thiz, updatesTransform, updatesRendering));
    var priority = $m_Lreactify_Priority$().Normal$1;
    var this$1 = prop.value$1;
    $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction(this$1, f, priority)
  };
  return prop
}
function $is_Lio_youi_theme_Theme(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_theme_Theme)))
}
function $as_Lio_youi_theme_Theme(obj) {
  return (($is_Lio_youi_theme_Theme(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.theme.Theme"))
}
function $isArrayOf_Lio_youi_theme_Theme(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_theme_Theme)))
}
function $asArrayOf_Lio_youi_theme_Theme(obj, depth) {
  return (($isArrayOf_Lio_youi_theme_Theme(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.theme.Theme;", depth))
}
/** @constructor */
function $c_Lio_youi_theme_mixins_HTMLFontTheme$font$() {
  $c_O.call(this);
  this.family$1 = null;
  this.weight$1 = null;
  this.size$1 = null
}
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype = new $h_O();
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.constructor = $c_Lio_youi_theme_mixins_HTMLFontTheme$font$;
/** @constructor */
function $h_Lio_youi_theme_mixins_HTMLFontTheme$font$() {
  /*<skip>*/
}
$h_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype = $c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype;
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.$$colon$eq__Lio_youi_font_GoogleFont__V = (function(gf) {
  this.family$1.$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, gf$1) {
    return (function() {
      var value = gf$1.family__T();
      return new $c_Lio_youi_style_FontFamily().init___T(value)
    })
  })(this, gf)));
  this.weight$1.$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      return new $c_Lio_youi_style_FontWeight().init___T($m_Lio_youi_style_FontWeight$().default$1)
    })
  })(this)))
});
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.$$colon$eq__Lio_youi_font_GoogleFontWeight__V = (function(gfw) {
  this.family$1.$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, gfw$1) {
    return (function() {
      var value = gfw$1.font$1.family__T();
      return new $c_Lio_youi_style_FontFamily().init___T(value)
    })
  })(this, gfw)));
  this.weight$1.$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, gfw$2) {
    return (function() {
      var value$1 = gfw$2.name$1;
      return new $c_Lio_youi_style_FontWeight().init___T(value$1)
    })
  })(this, gfw)))
});
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.init___Lio_youi_theme_mixins_HTMLFontTheme = (function($$outer) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return new $c_Lio_youi_style_FontFamily().init___T($m_Lio_youi_style_FontFamily$().default$1)
    })
  })(this));
  var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_FontFamily$());
  this.family$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$outer, "font-family", $default, connect, true, false, false);
  var $default$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      return new $c_Lio_youi_style_FontWeight().init___T($m_Lio_youi_style_FontWeight$().default$1)
    })
  })(this));
  var connect$1 = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_FontWeight$());
  this.weight$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$outer, "font-weight", $default$1, connect$1, true, false, false);
  var $default$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3) {
    return (function() {
      return 12.0
    })
  })(this));
  var connect$2 = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($f_Lio_youi_theme_StringifyImplicits__stringifyDouble__Lio_youi_theme_Stringify($$outer));
  this.size$1 = $f_Lio_youi_theme_Theme__style__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$outer, "font-size", $default$2, connect$2, true, false, false);
  return this
});
var $d_Lio_youi_theme_mixins_HTMLFontTheme$font$ = new $TypeData().initClass({
  Lio_youi_theme_mixins_HTMLFontTheme$font$: 0
}, false, "io.youi.theme.mixins.HTMLFontTheme$font$", {
  Lio_youi_theme_mixins_HTMLFontTheme$font$: 1,
  O: 1
});
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.$classData = $d_Lio_youi_theme_mixins_HTMLFontTheme$font$;
/** @constructor */
function $c_Lio_youi_util_LazyFuture() {
  $c_O.call(this);
  this.f$1 = null;
  this.maxFrequency$1 = null;
  this.automatic$1 = false;
  this.lastUpdate$1 = null;
  this.dirty$1 = null;
  this.future$1 = null
}
$c_Lio_youi_util_LazyFuture.prototype = new $h_O();
$c_Lio_youi_util_LazyFuture.prototype.constructor = $c_Lio_youi_util_LazyFuture;
/** @constructor */
function $h_Lio_youi_util_LazyFuture() {
  /*<skip>*/
}
$h_Lio_youi_util_LazyFuture.prototype = $c_Lio_youi_util_LazyFuture.prototype;
$c_Lio_youi_util_LazyFuture.prototype.init___F0__s_concurrent_duration_FiniteDuration__Z = (function(f, maxFrequency, automatic) {
  this.f$1 = f;
  this.maxFrequency$1 = maxFrequency;
  this.automatic$1 = automatic;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
    })
  })(this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.lastUpdate$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  this.dirty$1 = new $c_ju_concurrent_atomic_AtomicBoolean().init___Z(false);
  this.future$1 = $m_s_None$();
  return this
});
$c_Lio_youi_util_LazyFuture.prototype.isReady__Z = (function() {
  var t = this.delay__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  return ((lo === 0) && (hi === 0))
});
$c_Lio_youi_util_LazyFuture.prototype.elapsed__J = (function() {
  var t = $m_jl_System$().currentTimeMillis__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  var v = this.lastUpdate$1;
  var b = $uJ(v.state__Lreactify_State().value__O());
  var bhi = b.hi$2;
  var lo$1 = ((lo - b.lo$2) | 0);
  var hi$1 = ((((-2147483648) ^ lo$1) > ((-2147483648) ^ lo)) ? (((-1) + ((hi - bhi) | 0)) | 0) : ((hi - bhi) | 0));
  return new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1)
});
$c_Lio_youi_util_LazyFuture.prototype.delay__J = (function() {
  var this$1 = this.maxFrequency$1;
  var t = this$1.unit$2.toMillis__J__J(this$1.length$2);
  var lo = t.lo$2;
  var hi = t.hi$2;
  var b = this.elapsed__J();
  var bhi = b.hi$2;
  var lo$1 = ((lo - b.lo$2) | 0);
  var hi$1 = ((((-2147483648) ^ lo$1) > ((-2147483648) ^ lo)) ? (((-1) + ((hi - bhi) | 0)) | 0) : ((hi - bhi) | 0));
  return ((hi$1 < 0) ? $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong() : new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1))
});
$c_Lio_youi_util_LazyFuture.prototype.update__Z__V = (function(force) {
  var this$1 = this.future$1;
  if (this$1.isEmpty__Z()) {
    var finished = true
  } else {
    var arg1 = this$1.get__O();
    var x$2 = $as_s_concurrent_Future(arg1);
    var finished = x$2.isCompleted__Z()
  };
  if (finished) {
    var this$2 = this.future$1;
    if (this$2.isDefined__Z()) {
      this.future$1 = $m_s_None$();
      var this$3 = this.lastUpdate$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
        return (function() {
          return $m_jl_System$().currentTimeMillis__J()
        })
      })(this));
      this$3.set__F0__V(value)
    };
    if (((this.isReady__Z() && this.dirty$1.compareAndSet__Z__Z__Z(true, false)) || force)) {
      var future = $as_s_concurrent_Future(this.f$1.apply__O());
      future.failed__s_concurrent_Future().foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1) {
        return (function(t$2) {
          var t = $as_jl_Throwable(t$2);
          var jsx$1 = $m_Lscribe_package$();
          var level = $m_Lscribe_Level$Error$();
          var value$1 = $m_Lscribe_Level$Error$().value$1;
          var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, t$1) {
            return (function() {
              return t$1
            })
          })(this$3$1, t));
          var loggable = $m_Lscribe_Loggable$ThrowableLoggable$();
          var throwable = $m_s_None$();
          var methodName = new $c_s_Some().init___O("update");
          var line = new $c_s_Some().init___O(47);
          var column = new $c_s_Some().init___O(48);
          var thread = $m_jl_Thread$().SingleThread$1;
          var this$6 = $m_Lscribe_util_Time$();
          var this$7 = this$6.function$1;
          var t$3 = $uJ(this$7.apply__O());
          var lo = t$3.lo$2;
          var hi = t$3.hi$2;
          jsx$1.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value$1, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/ui/js/src/main/scala/io/youi/util/LazyFuture.scala", "io.youi.util.LazyFuture", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi)))
        })
      })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
      if (this.automatic$1) {
        future.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
          return (function(x$3$2) {
            $as_s_util_Try(x$3$2);
            this$4$1.update__Z__V(false)
          })
        })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
      };
      this.future$1 = new $c_s_Some().init___O(future)
    }
  }
});
$c_Lio_youi_util_LazyFuture.prototype.flag__s_concurrent_Future = (function() {
  if (this.dirty$1.compareAndSet__Z__Z__Z(false, true)) {
    if (this.automatic$1) {
      if (this.isReady__Z()) {
        this.update__Z__V(false)
      } else {
        var this$5 = $m_Lio_youi_AnimationFrame$();
        var t = this.delay__J();
        var lo = t.lo$2;
        var hi = t.hi$2;
        var this$2 = new $c_s_concurrent_duration_package$DurationLong().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo, hi));
        var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
        var t$1 = this$2.scala$concurrent$duration$DurationLong$$n$1;
        var lo$1 = t$1.lo$2;
        var hi$1 = t$1.hi$2;
        $m_s_concurrent_duration_Duration$();
        var delay = new $c_s_concurrent_duration_FiniteDuration().init___J__ju_concurrent_TimeUnit(new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1), unit);
        var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
          return (function() {
            $this.update__Z__V(false)
          })
        })(this));
        $f_Lio_youi_Updates__once__s_concurrent_duration_FiniteDuration__F0__V(this$5, delay, f)
      }
    }
  };
  var p = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var this$9 = this.lastUpdate$1;
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, p$1) {
    return (function(x$1$2) {
      var t$2 = $uJ(x$1$2);
      $f_s_concurrent_Promise__success__O__s_concurrent_Promise(p$1, (void 0))
    })
  })(this, p));
  var this$7 = this.lastUpdate$1;
  var condition = $f_Lreactify_Reactive__once$default$2__F1(this$7);
  var priority = $m_Lreactify_Priority$().Normal$1;
  $f_Lreactify_Reactive__once__F1__F1__D__Lreactify_reaction_Reaction(this$9, f$1, condition, priority);
  return p
});
var $d_Lio_youi_util_LazyFuture = new $TypeData().initClass({
  Lio_youi_util_LazyFuture: 0
}, false, "io.youi.util.LazyFuture", {
  Lio_youi_util_LazyFuture: 1,
  O: 1
});
$c_Lio_youi_util_LazyFuture.prototype.$classData = $d_Lio_youi_util_LazyFuture;
/** @constructor */
function $c_Lio_youi_util_LazyFuture$() {
  $c_O.call(this)
}
$c_Lio_youi_util_LazyFuture$.prototype = new $h_O();
$c_Lio_youi_util_LazyFuture$.prototype.constructor = $c_Lio_youi_util_LazyFuture$;
/** @constructor */
function $h_Lio_youi_util_LazyFuture$() {
  /*<skip>*/
}
$h_Lio_youi_util_LazyFuture$.prototype = $c_Lio_youi_util_LazyFuture$.prototype;
$c_Lio_youi_util_LazyFuture$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_util_LazyFuture$.prototype.apply$default$2__s_concurrent_duration_FiniteDuration = (function() {
  var this$2 = new $c_s_concurrent_duration_package$DurationInt().init___I(0);
  var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
  return $m_s_concurrent_duration_package$DurationInt$().durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration(this$2.scala$concurrent$duration$DurationInt$$n$1, unit)
});
var $d_Lio_youi_util_LazyFuture$ = new $TypeData().initClass({
  Lio_youi_util_LazyFuture$: 0
}, false, "io.youi.util.LazyFuture$", {
  Lio_youi_util_LazyFuture$: 1,
  O: 1
});
$c_Lio_youi_util_LazyFuture$.prototype.$classData = $d_Lio_youi_util_LazyFuture$;
var $n_Lio_youi_util_LazyFuture$ = (void 0);
function $m_Lio_youi_util_LazyFuture$() {
  if ((!$n_Lio_youi_util_LazyFuture$)) {
    $n_Lio_youi_util_LazyFuture$ = new $c_Lio_youi_util_LazyFuture$().init___()
  };
  return $n_Lio_youi_util_LazyFuture$
}
/** @constructor */
function $c_Lio_youi_util_Measurer$() {
  $c_O.call(this);
  this.container$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_util_Measurer$.prototype = new $h_O();
$c_Lio_youi_util_Measurer$.prototype.constructor = $c_Lio_youi_util_Measurer$;
/** @constructor */
function $h_Lio_youi_util_Measurer$() {
  /*<skip>*/
}
$h_Lio_youi_util_Measurer$.prototype = $c_Lio_youi_util_Measurer$.prototype;
$c_Lio_youi_util_Measurer$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_util_Measurer$.prototype.container__p1__Lorg_scalajs_dom_raw_HTMLSpanElement = (function() {
  return ((!this.bitmap$0$1) ? this.container$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLSpanElement() : this.container$1)
});
$c_Lio_youi_util_Measurer$.prototype.measure__Lorg_scalajs_dom_raw_HTMLElement__Lio_youi_spatial_Size = (function(element) {
  return this.measure__T__Lio_youi_spatial_Size($as_T(element.outerHTML))
});
$c_Lio_youi_util_Measurer$.prototype.measure__T__Lio_youi_spatial_Size = (function(htmlString) {
  this.container__p1__Lorg_scalajs_dom_raw_HTMLSpanElement().innerHTML = htmlString;
  var e = this.container__p1__Lorg_scalajs_dom_raw_HTMLSpanElement().firstElementChild;
  e.style.width = "auto";
  e.style.height = "auto";
  e.style.whiteSpace = "nowrap";
  e.style.position = "static";
  e.style.visibility = "hidden";
  var bounding = e.getBoundingClientRect();
  var width = $uD(bounding.width);
  var height = $uD(bounding.height);
  return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width, height)
});
$c_Lio_youi_util_Measurer$.prototype.container$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLSpanElement = (function() {
  if ((!this.bitmap$0$1)) {
    var span = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("span");
    span.style.position = "absolute";
    span.style.visibility = "hidden";
    span.style.width = "auto";
    span.style.height = "auto";
    span.style.whiteSpace = "nowrap";
    $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(span);
    this.container$1 = span;
    this.bitmap$0$1 = true
  };
  return this.container$1
});
var $d_Lio_youi_util_Measurer$ = new $TypeData().initClass({
  Lio_youi_util_Measurer$: 0
}, false, "io.youi.util.Measurer$", {
  Lio_youi_util_Measurer$: 1,
  O: 1
});
$c_Lio_youi_util_Measurer$.prototype.$classData = $d_Lio_youi_util_Measurer$;
var $n_Lio_youi_util_Measurer$ = (void 0);
function $m_Lio_youi_util_Measurer$() {
  if ((!$n_Lio_youi_util_Measurer$)) {
    $n_Lio_youi_util_Measurer$ = new $c_Lio_youi_util_Measurer$().init___()
  };
  return $n_Lio_youi_util_Measurer$
}
/** @constructor */
function $c_Lio_youi_util_SizeUtility$() {
  $c_O.call(this)
}
$c_Lio_youi_util_SizeUtility$.prototype = new $h_O();
$c_Lio_youi_util_SizeUtility$.prototype.constructor = $c_Lio_youi_util_SizeUtility$;
/** @constructor */
function $h_Lio_youi_util_SizeUtility$() {
  /*<skip>*/
}
$h_Lio_youi_util_SizeUtility$.prototype = $c_Lio_youi_util_SizeUtility$.prototype;
$c_Lio_youi_util_SizeUtility$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_util_SizeUtility$.prototype.size__s_Option__s_Option__Lio_youi_spatial_Size__Lio_youi_spatial_Size = (function(width, height, original) {
  if ($is_s_Some(width)) {
    var x2 = $as_s_Some(width);
    var w = $uD(x2.value$2);
    if ($is_s_Some(height)) {
      var x2$2 = $as_s_Some(height);
      var h = $uD(x2$2.value$2);
      return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(w, h)
    } else {
      var x = $m_s_None$();
      if ((x === height)) {
        var aspectRatio = (original.height$1 / original.width$1);
        var height$1 = (w * aspectRatio);
        return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(w, height$1)
      } else {
        throw new $c_s_MatchError().init___O(height)
      }
    }
  } else {
    var x$3 = $m_s_None$();
    if ((x$3 === width)) {
      if ($is_s_Some(height)) {
        var x2$3 = $as_s_Some(height);
        var h$2 = $uD(x2$3.value$2);
        var aspectRatio$2 = (original.width$1 / original.height$1);
        var width$1 = (h$2 * aspectRatio$2);
        return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width$1, h$2)
      } else {
        var x$5 = $m_s_None$();
        if ((x$5 === height)) {
          var width$2 = original.width$1;
          var height$2 = original.height$1;
          return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width$2, height$2)
        } else {
          throw new $c_s_MatchError().init___O(height)
        }
      }
    } else {
      throw new $c_s_MatchError().init___O(width)
    }
  }
});
var $d_Lio_youi_util_SizeUtility$ = new $TypeData().initClass({
  Lio_youi_util_SizeUtility$: 0
}, false, "io.youi.util.SizeUtility$", {
  Lio_youi_util_SizeUtility$: 1,
  O: 1
});
$c_Lio_youi_util_SizeUtility$.prototype.$classData = $d_Lio_youi_util_SizeUtility$;
var $n_Lio_youi_util_SizeUtility$ = (void 0);
function $m_Lio_youi_util_SizeUtility$() {
  if ((!$n_Lio_youi_util_SizeUtility$)) {
    $n_Lio_youi_util_SizeUtility$ = new $c_Lio_youi_util_SizeUtility$().init___()
  };
  return $n_Lio_youi_util_SizeUtility$
}
/** @constructor */
function $c_Lio_youi_video_Video$() {
  $c_O.call(this)
}
$c_Lio_youi_video_Video$.prototype = new $h_O();
$c_Lio_youi_video_Video$.prototype.constructor = $c_Lio_youi_video_Video$;
/** @constructor */
function $h_Lio_youi_video_Video$() {
  /*<skip>*/
}
$h_Lio_youi_video_Video$.prototype = $c_Lio_youi_video_Video$.prototype;
$c_Lio_youi_video_Video$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_video_Video$.prototype.io$youi$video$Video$$$anonfun$apply$1__Lorg_scalajs_dom_raw_Event__Z__Z__Z__Lorg_scalajs_dom_raw_HTMLVideoElement__s_concurrent_Promise__s_concurrent_Promise = (function(x$8, autoPlay$1, loop$1, muted$1, element$1, promise$2) {
  var v = new $c_Lio_youi_video_Video().init___Lorg_scalajs_dom_raw_HTMLVideoElement(element$1);
  v.io$youi$video$Video$$init__Z__Z__Z__V(autoPlay$1, loop$1, muted$1);
  return $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$2, v)
});
$c_Lio_youi_video_Video$.prototype.apply__T__Z__Z__Z__s_concurrent_Future = (function(url, autoPlay, loop, muted) {
  var element = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("video");
  element.autoplay = autoPlay;
  element.loop = loop;
  element.muted = muted;
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  element.addEventListener("loadedmetadata", (function(autoPlay$1, loop$1, muted$1, element$1, promise$2) {
    return (function(arg1$2) {
      return $m_Lio_youi_video_Video$().io$youi$video$Video$$$anonfun$apply$1__Lorg_scalajs_dom_raw_Event__Z__Z__Z__Lorg_scalajs_dom_raw_HTMLVideoElement__s_concurrent_Promise__s_concurrent_Promise(arg1$2, autoPlay$1, loop$1, muted$1, element$1, promise$2)
    })
  })(autoPlay, loop, muted, element, promise));
  element.src = url;
  return promise
});
var $d_Lio_youi_video_Video$ = new $TypeData().initClass({
  Lio_youi_video_Video$: 0
}, false, "io.youi.video.Video$", {
  Lio_youi_video_Video$: 1,
  O: 1
});
$c_Lio_youi_video_Video$.prototype.$classData = $d_Lio_youi_video_Video$;
var $n_Lio_youi_video_Video$ = (void 0);
function $m_Lio_youi_video_Video$() {
  if ((!$n_Lio_youi_video_Video$)) {
    $n_Lio_youi_video_Video$ = new $c_Lio_youi_video_Video$().init___()
  };
  return $n_Lio_youi_video_Video$
}
/** @constructor */
function $c_Lio_youi_virtual_VirtualSize() {
  $c_O.call(this);
  this.screen$1 = null;
  this.size$1 = null;
  this.xOffset$1 = null;
  this.yOffset$1 = null;
  this.widthMultiplier$1 = null;
  this.heightMultiplier$1 = null
}
$c_Lio_youi_virtual_VirtualSize.prototype = new $h_O();
$c_Lio_youi_virtual_VirtualSize.prototype.constructor = $c_Lio_youi_virtual_VirtualSize;
/** @constructor */
function $h_Lio_youi_virtual_VirtualSize() {
  /*<skip>*/
}
$h_Lio_youi_virtual_VirtualSize.prototype = $c_Lio_youi_virtual_VirtualSize.prototype;
$c_Lio_youi_virtual_VirtualSize.prototype.init___Lio_youi_virtual_VirtualSizeSupport = (function(screen) {
  this.screen$1 = screen;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var v = $this.screen$1.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().width$1;
      if (($uD(v.state__Lreactify_State().value__O()) > 0.0)) {
        var v$1 = $this.screen$1.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().height$1;
        var jsx$1 = ($uD(v$1.state__Lreactify_State().value__O()) > 0.0)
      } else {
        var jsx$1 = false
      };
      if (jsx$1) {
        var this$3 = $this.screen$1.virtualMode$1;
        var x1 = $as_Lio_youi_virtual_VirtualMode(this$3.state__Lreactify_State().value__O());
        var x = $m_Lio_youi_virtual_VirtualMode$Bars$();
        if ((x === x1)) {
          var jsx$2 = true
        } else {
          var x$3 = $m_Lio_youi_virtual_VirtualMode$Clip$();
          if ((x$3 === x1)) {
            var jsx$2 = true
          } else {
            var x$5 = $m_Lio_youi_virtual_VirtualMode$FitWidth$();
            if ((x$5 === x1)) {
              var jsx$2 = true
            } else {
              var x$7 = $m_Lio_youi_virtual_VirtualMode$FitHeight$();
              var jsx$2 = (x$7 === x1)
            }
          }
        };
        if (jsx$2) {
          var v$2 = $this.screen$1.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().width$1;
          var jsx$3 = $uD(v$2.state__Lreactify_State().value__O());
          var this$5 = $this.screen$1.virtualWidth$1;
          var widthRatio = (jsx$3 / $uD(this$5.state__Lreactify_State().value__O()));
          var v$3 = $this.screen$1.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().height$1;
          var jsx$4 = $uD(v$3.state__Lreactify_State().value__O());
          var this$7 = $this.screen$1.virtualHeight$1;
          var heightRatio = (jsx$4 / $uD(this$7.state__Lreactify_State().value__O()));
          var this$8 = $this.screen$1.virtualMode$1;
          var x1$2 = $as_Lio_youi_virtual_VirtualMode(this$8.state__Lreactify_State().value__O());
          var x$9 = $m_Lio_youi_virtual_VirtualMode$Bars$();
          if ((x$9 === x1$2)) {
            var ratio = $uD($g.Math.min(widthRatio, heightRatio))
          } else {
            var x$11 = $m_Lio_youi_virtual_VirtualMode$Clip$();
            if ((x$11 === x1$2)) {
              var ratio = $uD($g.Math.max(widthRatio, heightRatio))
            } else {
              var x$13 = $m_Lio_youi_virtual_VirtualMode$FitWidth$();
              if ((x$13 === x1$2)) {
                var ratio = widthRatio
              } else {
                var x$15 = $m_Lio_youi_virtual_VirtualMode$FitHeight$();
                if ((x$15 === x1$2)) {
                  var ratio = heightRatio
                } else {
                  var ratio = 0.0
                }
              }
            }
          };
          var v$4 = $this.screen$1.virtualWidth$1;
          var w = ($uD(v$4.state__Lreactify_State().value__O()) * ratio);
          var v$5 = $this.screen$1.virtualHeight$1;
          var h = ($uD(v$5.state__Lreactify_State().value__O()) * ratio);
          var v$6 = $this.screen$1.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().width$1;
          var jsx$5 = $uD(v$6.state__Lreactify_State().value__O());
          var v$7 = $this.screen$1.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().height$1;
          return new $c_T4().init___O__O__O__O(((jsx$5 - w) / 2.0), (($uD(v$7.state__Lreactify_State().value__O()) - h) / 2.0), ratio, ratio)
        } else {
          var x$17 = $m_Lio_youi_virtual_VirtualMode$Stretch$();
          if ((x$17 === x1)) {
            var v$8 = $this.screen$1.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().width$1;
            var jsx$8 = $uD(v$8.state__Lreactify_State().value__O());
            var v$9 = $this.screen$1.virtualWidth$1;
            var jsx$7 = $uD(v$9.state__Lreactify_State().value__O());
            var v$10 = $this.screen$1.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().height$1;
            var jsx$6 = $uD(v$10.state__Lreactify_State().value__O());
            var v$11 = $this.screen$1.virtualHeight$1;
            return new $c_T4().init___O__O__O__O(0.0, 0.0, (jsx$8 / jsx$7), (jsx$6 / $uD(v$11.state__Lreactify_State().value__O())))
          } else {
            throw new $c_s_MatchError().init___O(x1)
          }
        }
      } else {
        return new $c_T4().init___O__O__O__O(0.0, 0.0, 1.0, 1.0)
      }
    })
  })(this));
  var name = $m_s_None$();
  this.size$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      var v$12 = this$2$1.size$1;
      return $uD($as_T4(v$12.state__Lreactify_State().value__O()).$$und1$1)
    })
  })(this));
  var name$1 = $m_s_None$();
  this.xOffset$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      var v$13 = this$3$1.size$1;
      return $uD($as_T4(v$13.state__Lreactify_State().value__O()).$$und2$1)
    })
  })(this));
  var name$2 = $m_s_None$();
  this.yOffset$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$2, name$2);
  var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1) {
    return (function() {
      var v$14 = this$4$1.size$1;
      return $uD($as_T4(v$14.state__Lreactify_State().value__O()).$$und3$1)
    })
  })(this));
  var name$3 = $m_s_None$();
  this.widthMultiplier$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$3, name$3);
  var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1) {
    return (function() {
      var v$15 = this$5$1.size$1;
      return $uD($as_T4(v$15.state__Lreactify_State().value__O()).$$und4$1)
    })
  })(this));
  var name$4 = $m_s_None$();
  this.heightMultiplier$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$4, name$4);
  return this
});
var $d_Lio_youi_virtual_VirtualSize = new $TypeData().initClass({
  Lio_youi_virtual_VirtualSize: 0
}, false, "io.youi.virtual.VirtualSize", {
  Lio_youi_virtual_VirtualSize: 1,
  O: 1
});
$c_Lio_youi_virtual_VirtualSize.prototype.$classData = $d_Lio_youi_virtual_VirtualSize;
/** @constructor */
function $c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels() {
  $c_O.call(this);
  this.i$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype = new $h_O();
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.constructor = $c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels;
/** @constructor */
function $h_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels() {
  /*<skip>*/
}
$h_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype = $c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype;
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.vh__Lreactify_Val = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var jsx$1 = $this.i$1;
      var v = $this.$$outer$1.virtual$1.heightMultiplier$1;
      return (jsx$1 * $uD(v.state__Lreactify_State().value__O()))
    })
  })(this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.init___Lio_youi_virtual_VirtualSizeSupport__I = (function($$outer, i) {
  this.i$1 = i;
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.vy__Lreactify_Val = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var this$1 = $this.vh__Lreactify_Val();
      var jsx$1 = $uD(this$1.state__Lreactify_State().value__O());
      var this$2 = $this.$$outer$1.virtual$1.yOffset$1;
      return (jsx$1 + $uD(this$2.state__Lreactify_State().value__O()))
    })
  })(this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.vx__Lreactify_Val = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var this$1 = $this.vw__Lreactify_Val();
      var jsx$1 = $uD(this$1.state__Lreactify_State().value__O());
      var this$2 = $this.$$outer$1.virtual$1.xOffset$1;
      return (jsx$1 + $uD(this$2.state__Lreactify_State().value__O()))
    })
  })(this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.vw__Lreactify_Val = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var jsx$1 = $this.i$1;
      var v = $this.$$outer$1.virtual$1.widthMultiplier$1;
      return (jsx$1 * $uD(v.state__Lreactify_State().value__O()))
    })
  })(this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
});
var $d_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels = new $TypeData().initClass({
  Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels: 0
}, false, "io.youi.virtual.VirtualSizeSupport$IntVirtualPixels", {
  Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels: 1,
  O: 1
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.$classData = $d_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels;
/** @constructor */
function $c_Lio_youi_virtual_VirtualSizeSupport$actual$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null
}
$c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype = new $h_O();
$c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype.constructor = $c_Lio_youi_virtual_VirtualSizeSupport$actual$;
/** @constructor */
function $h_Lio_youi_virtual_VirtualSizeSupport$actual$() {
  /*<skip>*/
}
$h_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype = $c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype;
$c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype.init___Lio_youi_virtual_VirtualSizeSupport = (function($$outer) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var v = $m_Lio_youi_ui$().size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      return $uD(v.state__Lreactify_State().value__O())
    })
  })(this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.width$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      var v$1 = $m_Lio_youi_ui$().size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      return $uD(v$1.state__Lreactify_State().value__O())
    })
  })(this));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.height$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  return this
});
var $d_Lio_youi_virtual_VirtualSizeSupport$actual$ = new $TypeData().initClass({
  Lio_youi_virtual_VirtualSizeSupport$actual$: 0
}, false, "io.youi.virtual.VirtualSizeSupport$actual$", {
  Lio_youi_virtual_VirtualSizeSupport$actual$: 1,
  O: 1
});
$c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype.$classData = $d_Lio_youi_virtual_VirtualSizeSupport$actual$;
function $is_Ljava_io_Closeable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Ljava_io_Closeable)))
}
function $as_Ljava_io_Closeable(obj) {
  return (($is_Ljava_io_Closeable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.io.Closeable"))
}
function $isArrayOf_Ljava_io_Closeable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Ljava_io_Closeable)))
}
function $asArrayOf_Ljava_io_Closeable(obj, depth) {
  return (($isArrayOf_Ljava_io_Closeable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.io.Closeable;", depth))
}
/** @constructor */
function $c_Ljava_math_BigInteger$QuotAndRem() {
  $c_O.call(this);
  this.quot$1 = null;
  this.rem$1 = null
}
$c_Ljava_math_BigInteger$QuotAndRem.prototype = new $h_O();
$c_Ljava_math_BigInteger$QuotAndRem.prototype.constructor = $c_Ljava_math_BigInteger$QuotAndRem;
/** @constructor */
function $h_Ljava_math_BigInteger$QuotAndRem() {
  /*<skip>*/
}
$h_Ljava_math_BigInteger$QuotAndRem.prototype = $c_Ljava_math_BigInteger$QuotAndRem.prototype;
$c_Ljava_math_BigInteger$QuotAndRem.prototype.toArray__ALjava_math_BigInteger = (function() {
  var array = [this.quot$1, this.rem$1];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var len = $uI(xs.array$6.length);
  var array$1 = $newArrayObject($d_Ljava_math_BigInteger.getArrayOf(), [len]);
  var elem$1 = 0;
  elem$1 = 0;
  var this$6 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
  while (this$6.hasNext__Z()) {
    var arg1 = this$6.next__O();
    array$1.set(elem$1, arg1);
    elem$1 = ((1 + elem$1) | 0)
  };
  return array$1
});
$c_Ljava_math_BigInteger$QuotAndRem.prototype.init___Ljava_math_BigInteger__Ljava_math_BigInteger = (function(quot, rem) {
  this.quot$1 = quot;
  this.rem$1 = rem;
  return this
});
var $d_Ljava_math_BigInteger$QuotAndRem = new $TypeData().initClass({
  Ljava_math_BigInteger$QuotAndRem: 0
}, false, "java.math.BigInteger$QuotAndRem", {
  Ljava_math_BigInteger$QuotAndRem: 1,
  O: 1
});
$c_Ljava_math_BigInteger$QuotAndRem.prototype.$classData = $d_Ljava_math_BigInteger$QuotAndRem;
/** @constructor */
function $c_Ljava_math_BitLevel$() {
  $c_O.call(this)
}
$c_Ljava_math_BitLevel$.prototype = new $h_O();
$c_Ljava_math_BitLevel$.prototype.constructor = $c_Ljava_math_BitLevel$;
/** @constructor */
function $h_Ljava_math_BitLevel$() {
  /*<skip>*/
}
$h_Ljava_math_BitLevel$.prototype = $c_Ljava_math_BitLevel$.prototype;
$c_Ljava_math_BitLevel$.prototype.init___ = (function() {
  return this
});
$c_Ljava_math_BitLevel$.prototype.shiftLeftOneBit__AI__AI__I__V = (function(result, source, srcLen) {
  var elem$1 = 0;
  elem$1 = 0;
  var isEmpty$4 = (srcLen <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + srcLen) | 0);
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      var iVal = source.get(v1);
      result.set(v1, ((iVal << 1) | elem$1));
      elem$1 = ((iVal >>> 31) | 0);
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  if ((elem$1 !== 0)) {
    result.set(srcLen, elem$1)
  }
});
$c_Ljava_math_BitLevel$.prototype.shiftLeft__Ljava_math_BigInteger__I__Ljava_math_BigInteger = (function(source, count) {
  var intCount = (count >> 5);
  var andCount = (31 & count);
  var offset = ((andCount === 0) ? 0 : 1);
  var resLength = ((((source.numberLength$2 + intCount) | 0) + offset) | 0);
  var resDigits = $newArrayObject($d_I.getArrayOf(), [resLength]);
  this.shiftLeft__AI__AI__I__I__V(resDigits, source.digits$2, intCount, andCount);
  var result = new $c_Ljava_math_BigInteger().init___I__I__AI(source.sign$2, resLength, resDigits);
  result.cutOffLeadingZeroes__V();
  return result
});
$c_Ljava_math_BitLevel$.prototype.shiftRight__Ljava_math_BigInteger__I__Ljava_math_BigInteger = (function(source, count) {
  var intCount = (count >> 5);
  var andCount = (31 & count);
  if ((intCount >= source.numberLength$2)) {
    return ((source.sign$2 < 0) ? $m_Ljava_math_BigInteger$().MINUS$undONE$1 : $m_Ljava_math_BigInteger$().ZERO$1)
  } else {
    var resLength = ((source.numberLength$2 - intCount) | 0);
    var resDigits = $newArrayObject($d_I.getArrayOf(), [((1 + resLength) | 0)]);
    this.shiftRight__AI__I__AI__I__I__Z(resDigits, resLength, source.digits$2, intCount, andCount);
    if ((source.sign$2 < 0)) {
      var i = 0;
      while (((i < intCount) && (source.digits$2.get(i) === 0))) {
        i = ((1 + i) | 0)
      };
      var cmp = ((source.digits$2.get(i) << ((32 - andCount) | 0)) !== 0);
      if (((i < intCount) || ((andCount > 0) && cmp))) {
        i = 0;
        while (((i < resLength) && (resDigits.get(i) === (-1)))) {
          resDigits.set(i, 0);
          i = ((1 + i) | 0)
        };
        if ((i === resLength)) {
          resLength = ((1 + resLength) | 0)
        };
        var ev$6 = i;
        resDigits.set(ev$6, ((1 + resDigits.get(ev$6)) | 0))
      }
    };
    var result = new $c_Ljava_math_BigInteger().init___I__I__AI(source.sign$2, resLength, resDigits);
    result.cutOffLeadingZeroes__V();
    return result
  }
});
$c_Ljava_math_BitLevel$.prototype.shiftLeftOneBit__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(source) {
  var srcLen = source.numberLength$2;
  var resLen = ((1 + srcLen) | 0);
  var resDigits = $newArrayObject($d_I.getArrayOf(), [resLen]);
  this.shiftLeftOneBit__AI__AI__I__V(resDigits, source.digits$2, srcLen);
  var result = new $c_Ljava_math_BigInteger().init___I__I__AI(source.sign$2, resLen, resDigits);
  result.cutOffLeadingZeroes__V();
  return result
});
$c_Ljava_math_BitLevel$.prototype.bitLength__Ljava_math_BigInteger__I = (function(bi) {
  if ((bi.sign$2 === 0)) {
    return 0
  } else {
    var bLength = (bi.numberLength$2 << 5);
    var highDigit = bi.digits$2.get((((-1) + bi.numberLength$2) | 0));
    if ((bi.sign$2 < 0)) {
      var i = bi.getFirstNonzeroDigit__I();
      if ((i === (((-1) + bi.numberLength$2) | 0))) {
        highDigit = (((-1) + highDigit) | 0)
      }
    };
    bLength = ((bLength - $clz32(highDigit)) | 0);
    return bLength
  }
});
$c_Ljava_math_BitLevel$.prototype.shiftRight__AI__I__AI__I__I__Z = (function(result, resultLen, source, intCount, count) {
  var i = 0;
  var allZero = true;
  while ((i < intCount)) {
    allZero = (!(!(allZero & (source.get(i) === 0))));
    i = ((1 + i) | 0)
  };
  if ((count === 0)) {
    $systemArraycopy(source, intCount, result, 0, resultLen)
  } else {
    var leftShiftCount = ((32 - count) | 0);
    allZero = (!(!(allZero & ((source.get(i) << leftShiftCount) === 0))));
    i = 0;
    while ((i < (((-1) + resultLen) | 0))) {
      result.set(i, (((source.get(((i + intCount) | 0)) >>> count) | 0) | (source.get(((1 + ((i + intCount) | 0)) | 0)) << leftShiftCount)));
      i = ((1 + i) | 0)
    };
    result.set(i, ((source.get(((i + intCount) | 0)) >>> count) | 0));
    i = ((1 + i) | 0)
  };
  return allZero
});
$c_Ljava_math_BitLevel$.prototype.shiftLeft__AI__AI__I__I__V = (function(result, source, intCount, count) {
  if ((count === 0)) {
    $systemArraycopy(source, 0, result, intCount, ((result.u.length - intCount) | 0))
  } else {
    var rightShiftCount = ((32 - count) | 0);
    result.set((((-1) + result.u.length) | 0), 0);
    var i = (((-1) + result.u.length) | 0);
    while ((i > intCount)) {
      var ev$5 = i;
      result.set(ev$5, (result.get(ev$5) | ((source.get((((-1) + ((i - intCount) | 0)) | 0)) >>> rightShiftCount) | 0)));
      result.set((((-1) + i) | 0), (source.get((((-1) + ((i - intCount) | 0)) | 0)) << count));
      i = (((-1) + i) | 0)
    }
  };
  var isEmpty$4 = (intCount <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + intCount) | 0);
  if ((!isEmpty$4)) {
    var i$1 = 0;
    while (true) {
      var v1 = i$1;
      result.set(v1, 0);
      if ((i$1 === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i$1 = ((1 + i$1) | 0)
    }
  }
});
var $d_Ljava_math_BitLevel$ = new $TypeData().initClass({
  Ljava_math_BitLevel$: 0
}, false, "java.math.BitLevel$", {
  Ljava_math_BitLevel$: 1,
  O: 1
});
$c_Ljava_math_BitLevel$.prototype.$classData = $d_Ljava_math_BitLevel$;
var $n_Ljava_math_BitLevel$ = (void 0);
function $m_Ljava_math_BitLevel$() {
  if ((!$n_Ljava_math_BitLevel$)) {
    $n_Ljava_math_BitLevel$ = new $c_Ljava_math_BitLevel$().init___()
  };
  return $n_Ljava_math_BitLevel$
}
/** @constructor */
function $c_Ljava_math_Conversion$() {
  $c_O.call(this);
  this.DigitFitInInt$1 = null;
  this.BigRadices$1 = null
}
$c_Ljava_math_Conversion$.prototype = new $h_O();
$c_Ljava_math_Conversion$.prototype.constructor = $c_Ljava_math_Conversion$;
/** @constructor */
function $h_Ljava_math_Conversion$() {
  /*<skip>*/
}
$h_Ljava_math_Conversion$.prototype = $c_Ljava_math_Conversion$.prototype;
$c_Ljava_math_Conversion$.prototype.init___ = (function() {
  $n_Ljava_math_Conversion$ = this;
  var array = [(-1), (-1), 31, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var len = $uI(xs.array$6.length);
  var array$1 = $newArrayObject($d_I.getArrayOf(), [len]);
  var elem$1 = 0;
  elem$1 = 0;
  var this$7 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
  while (this$7.hasNext__Z()) {
    var arg1 = this$7.next__O();
    array$1.set(elem$1, $uI(arg1));
    elem$1 = ((1 + elem$1) | 0)
  };
  this.DigitFitInInt$1 = array$1;
  var array$2 = [(-2147483648), 1162261467, 1073741824, 1220703125, 362797056, 1977326743, 1073741824, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 268435456, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 1073741824, 1291467969, 1544804416, 1838265625, 60466176];
  var xs$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$2);
  var len$1 = $uI(xs$1.array$6.length);
  var array$3 = $newArrayObject($d_I.getArrayOf(), [len$1]);
  var elem$1$1 = 0;
  elem$1$1 = 0;
  var this$14 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs$1, 0, $uI(xs$1.array$6.length));
  while (this$14.hasNext__Z()) {
    var arg1$1 = this$14.next__O();
    array$3.set(elem$1$1, $uI(arg1$1));
    elem$1$1 = ((1 + elem$1$1) | 0)
  };
  this.BigRadices$1 = array$3;
  return this
});
$c_Ljava_math_Conversion$.prototype.toDecimalScaledString__J__I__T = (function(value, scale) {
  if (((value.lo$2 === 0) && (value.hi$2 === 0))) {
    switch (scale) {
      case 0: {
        return "0";
        break
      }
      case 1: {
        return "0.0";
        break
      }
      case 2: {
        return "0.00";
        break
      }
      case 3: {
        return "0.000";
        break
      }
      case 4: {
        return "0.0000";
        break
      }
      case 5: {
        return "0.00000";
        break
      }
      case 6: {
        return "0.000000";
        break
      }
      default: {
        if ((scale === (-2147483648))) {
          var scaleVal = "2147483648"
        } else {
          var i = ((-scale) | 0);
          var scaleVal = ("" + i)
        };
        var result = ((scale < 0) ? "0E+" : "0E");
        return (result + scaleVal)
      }
    }
  } else {
    var ahi = value.hi$2;
    var negNumber = (ahi < 0);
    var elem$1 = null;
    elem$1 = "";
    var currentChar = 18;
    if (negNumber) {
      var lo = value.lo$2;
      var hi = value.hi$2;
      var lo$1 = ((-lo) | 0);
      var hi$1 = ((lo !== 0) ? (~hi) : ((-hi) | 0));
      var x_$_lo$2 = lo$1;
      var x_$_hi$2 = hi$1;
      var t = new $c_sjsr_RuntimeLong().init___I__I(x_$_lo$2, x_$_hi$2)
    } else {
      var t = value
    };
    var lo$2 = t.lo$2;
    var hi$2 = t.hi$2;
    var v_$_lo$2 = lo$2;
    var v_$_hi$2 = hi$2;
    while (true) {
      var prev_$_lo$2 = v_$_lo$2;
      var prev_$_hi$2 = v_$_hi$2;
      var this$5_$_lo$2 = v_$_lo$2;
      var this$5_$_hi$2 = v_$_hi$2;
      var this$6 = $m_sjsr_RuntimeLong$();
      var lo$3 = this$6.divideImpl__I__I__I__I__I(this$5_$_lo$2, this$5_$_hi$2, 10, 0);
      var hi$3 = this$6.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
      var jsx$1_$_lo$2 = lo$3;
      var jsx$1_$_hi$2 = hi$3;
      v_$_lo$2 = jsx$1_$_lo$2;
      v_$_hi$2 = jsx$1_$_hi$2;
      currentChar = (((-1) + currentChar) | 0);
      var b_$_lo$2 = v_$_lo$2;
      var b_$_hi$2 = v_$_hi$2;
      var blo = b_$_lo$2;
      var b0 = (65535 & blo);
      var b1 = ((blo >>> 16) | 0);
      var a0b0 = $imul(10, b0);
      var a0b1 = $imul(10, b1);
      var lo$4 = ((a0b0 + (a0b1 << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (($imul(10, b_$_hi$2) + ((c1part >>> 16) | 0)) | 0);
      var alo = prev_$_lo$2;
      var ahi$1 = prev_$_hi$2;
      var lo$5 = ((alo - lo$4) | 0);
      elem$1 = (("" + lo$5) + $as_T(elem$1));
      var this$9_$_lo$2 = v_$_lo$2;
      var this$9_$_hi$2 = v_$_hi$2;
      if ((!((this$9_$_lo$2 === 0) && (this$9_$_hi$2 === 0)))) {
        /*<skip>*/
      } else {
        break
      }
    };
    var exponent = (((-1) + ((((18 - currentChar) | 0) - scale) | 0)) | 0);
    if (((scale > 0) && (exponent >= (-6)))) {
      var index = ((1 + exponent) | 0);
      if ((index > 0)) {
        var thiz = $as_T(elem$1);
        var jsx$2 = $as_T(thiz.substring(0, index));
        var thiz$1 = $as_T(elem$1);
        elem$1 = ((jsx$2 + ".") + $as_T(thiz$1.substring(index)))
      } else {
        var end = ((-index) | 0);
        var isEmpty$4 = (end <= 0);
        var scala$collection$immutable$Range$$lastElement$4 = (((-1) + end) | 0);
        if ((!isEmpty$4)) {
          var i$1 = 0;
          while (true) {
            var v1 = i$1;
            elem$1 = ("0" + $as_T(elem$1));
            if ((i$1 === scala$collection$immutable$Range$$lastElement$4)) {
              break
            };
            i$1 = ((1 + i$1) | 0)
          }
        };
        elem$1 = ("0." + $as_T(elem$1))
      }
    } else if ((scale !== 0)) {
      var result1 = ("" + exponent);
      if ((exponent > 0)) {
        result1 = ("+" + result1)
      };
      result1 = ("E" + result1);
      if ((((18 - currentChar) | 0) > 1)) {
        var thiz$2 = $as_T(elem$1);
        var jsx$3 = $as_T(thiz$2.substring(0, 1));
        var thiz$3 = $as_T(elem$1);
        elem$1 = (((jsx$3 + ".") + $as_T(thiz$3.substring(1))) + result1)
      } else {
        elem$1 = (("" + $as_T(elem$1)) + result1)
      }
    };
    return (negNumber ? ("-" + $as_T(elem$1)) : $as_T(elem$1))
  }
});
$c_Ljava_math_Conversion$.prototype.dropLeadingZeros__p1__T__T = (function(s) {
  var zeroPrefixLength = 0;
  var len = $uI(s.length);
  while (true) {
    if ((zeroPrefixLength < len)) {
      var index = zeroPrefixLength;
      var jsx$1 = ((65535 & $uI(s.charCodeAt(index))) === 48)
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      zeroPrefixLength = ((1 + zeroPrefixLength) | 0)
    } else {
      break
    }
  };
  var beginIndex = zeroPrefixLength;
  return $as_T(s.substring(beginIndex))
});
$c_Ljava_math_Conversion$.prototype.toDecimalScaledString__Ljava_math_BigInteger__T = (function(bi) {
  var sign = bi.sign$2;
  var numberLength = bi.numberLength$2;
  var digits = bi.digits$2;
  if ((sign === 0)) {
    return "0"
  } else if ((numberLength === 1)) {
    var i = digits.get(0);
    var x = $uD((i >>> 0));
    var jsx$1 = x.toString(10);
    var absStr = $as_T(jsx$1);
    return ((sign < 0) ? ("-" + absStr) : absStr)
  } else {
    var result = "";
    var temp = $newArrayObject($d_I.getArrayOf(), [numberLength]);
    var tempLen = numberLength;
    $systemArraycopy(digits, 0, temp, 0, tempLen);
    do {
      var rem = 0;
      var i$1 = (((-1) + tempLen) | 0);
      while ((i$1 >= 0)) {
        var value = rem;
        var value$1 = temp.get(i$1);
        var this$8 = $m_sjsr_RuntimeLong$();
        var lo = this$8.divideUnsignedImpl__I__I__I__I__I(value$1, value, 1000000000, 0);
        temp.set(i$1, lo);
        var hi$3 = (lo >> 31);
        var b0 = (65535 & lo);
        var b1 = ((lo >>> 16) | 0);
        var a0b0 = $imul(51712, b0);
        var a1b0 = $imul(15258, b0);
        var a0b1 = $imul(51712, b1);
        var lo$1 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
        var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
        var hi$4 = (((((($imul(1000000000, hi$3) + $imul(15258, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
        var lo$2 = ((value$1 - lo$1) | 0);
        rem = lo$2;
        i$1 = (((-1) + i$1) | 0)
      };
      var this$10 = rem;
      var remStr = ("" + this$10);
      var beginIndex = $uI(remStr.length);
      var padding = $as_T("000000000".substring(beginIndex));
      result = ((padding + remStr) + result);
      while (((tempLen !== 0) && (temp.get((((-1) + tempLen) | 0)) === 0))) {
        tempLen = (((-1) + tempLen) | 0)
      }
    } while ((tempLen !== 0));
    result = this.dropLeadingZeros__p1__T__T(result);
    return ((sign < 0) ? ("-" + result) : result)
  }
});
var $d_Ljava_math_Conversion$ = new $TypeData().initClass({
  Ljava_math_Conversion$: 0
}, false, "java.math.Conversion$", {
  Ljava_math_Conversion$: 1,
  O: 1
});
$c_Ljava_math_Conversion$.prototype.$classData = $d_Ljava_math_Conversion$;
var $n_Ljava_math_Conversion$ = (void 0);
function $m_Ljava_math_Conversion$() {
  if ((!$n_Ljava_math_Conversion$)) {
    $n_Ljava_math_Conversion$ = new $c_Ljava_math_Conversion$().init___()
  };
  return $n_Ljava_math_Conversion$
}
/** @constructor */
function $c_Ljava_math_Division$() {
  $c_O.call(this)
}
$c_Ljava_math_Division$.prototype = new $h_O();
$c_Ljava_math_Division$.prototype.constructor = $c_Ljava_math_Division$;
/** @constructor */
function $h_Ljava_math_Division$() {
  /*<skip>*/
}
$h_Ljava_math_Division$.prototype = $c_Ljava_math_Division$.prototype;
$c_Ljava_math_Division$.prototype.init___ = (function() {
  return this
});
$c_Ljava_math_Division$.prototype.divide__AI__I__AI__I__AI__I__AI = (function(quot, quotLength, a, aLength, b, bLength) {
  var normA = $newArrayObject($d_I.getArrayOf(), [((1 + aLength) | 0)]);
  var normB = $newArrayObject($d_I.getArrayOf(), [((1 + bLength) | 0)]);
  var divisorShift = $clz32(b.get((((-1) + bLength) | 0)));
  if ((divisorShift !== 0)) {
    $m_Ljava_math_BitLevel$().shiftLeft__AI__AI__I__I__V(normB, b, 0, divisorShift);
    $m_Ljava_math_BitLevel$().shiftLeft__AI__AI__I__I__V(normA, a, 0, divisorShift)
  } else {
    $systemArraycopy(a, 0, normA, 0, aLength);
    $systemArraycopy(b, 0, normB, 0, bLength)
  };
  var firstDivisorDigit = normB.get((((-1) + bLength) | 0));
  var i = (((-1) + quotLength) | 0);
  var elem$1 = 0;
  elem$1 = aLength;
  while ((i >= 0)) {
    var elem$1$1 = 0;
    elem$1$1 = 0;
    if ((normA.get(elem$1) === firstDivisorDigit)) {
      elem$1$1 = (-1)
    } else {
      var value = normA.get(elem$1);
      var value$1 = normA.get((((-1) + elem$1) | 0));
      var this$5 = $m_sjsr_RuntimeLong$();
      var lo = this$5.divideUnsignedImpl__I__I__I__I__I(value$1, value, firstDivisorDigit, 0);
      var hi$3 = this$5.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
      elem$1$1 = lo;
      var a0 = (65535 & lo);
      var a1 = ((lo >>> 16) | 0);
      var b0 = (65535 & firstDivisorDigit);
      var b1 = ((firstDivisorDigit >>> 16) | 0);
      var a0b0 = $imul(a0, b0);
      var a1b0 = $imul(a1, b0);
      var a0b1 = $imul(a0, b1);
      var lo$1 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (((((($imul(hi$3, firstDivisorDigit) + $imul(a1, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
      var lo$2 = ((value$1 - lo$1) | 0);
      var elem$1$2 = 0;
      elem$1$2 = lo$2;
      if ((elem$1$1 !== 0)) {
        elem$1$1 = ((1 + elem$1$1) | 0);
        _loop: while (true) {
          elem$1$1 = (((-1) + elem$1$1) | 0);
          var value$2 = elem$1$1;
          var value$3 = normB.get((((-2) + bLength) | 0));
          var a0$1 = (65535 & value$2);
          var a1$1 = ((value$2 >>> 16) | 0);
          var b0$1 = (65535 & value$3);
          var b1$1 = ((value$3 >>> 16) | 0);
          var a0b0$1 = $imul(a0$1, b0$1);
          var a1b0$1 = $imul(a1$1, b0$1);
          var a0b1$1 = $imul(a0$1, b1$1);
          var lo$3 = ((a0b0$1 + (((a1b0$1 + a0b1$1) | 0) << 16)) | 0);
          var c1part$1 = ((((a0b0$1 >>> 16) | 0) + a0b1$1) | 0);
          var hi$8 = (((($imul(a1$1, b1$1) + ((c1part$1 >>> 16) | 0)) | 0) + (((((65535 & c1part$1) + a1b0$1) | 0) >>> 16) | 0)) | 0);
          var value$4 = elem$1$2;
          var value$5 = normA.get((((-2) + elem$1) | 0));
          var value$6 = elem$1$2;
          var lo$4 = ((value$6 + firstDivisorDigit) | 0);
          var hi$13 = ((((-2147483648) ^ lo$4) < ((-2147483648) ^ value$6)) ? 1 : 0);
          if ((hi$13 === 0)) {
            elem$1$2 = lo$4;
            var hi$14 = ((-2147483648) ^ hi$8);
            var hi$15 = ((-2147483648) ^ value$4);
            if (((hi$14 === hi$15) ? (((-2147483648) ^ lo$3) > ((-2147483648) ^ value$5)) : (hi$14 > hi$15))) {
              continue _loop
            }
          };
          break
        }
      }
    };
    if ((elem$1$1 !== 0)) {
      var borrow = $m_Ljava_math_Division$().multiplyAndSubtract__AI__I__AI__I__I__I(normA, ((elem$1 - bLength) | 0), normB, bLength, elem$1$1);
      if ((borrow !== 0)) {
        elem$1$1 = (((-1) + elem$1$1) | 0);
        var elem$1$3_$_lo$2 = 0;
        var elem$1$3_$_hi$2 = 0;
        var jsx$1_$_lo$2 = 0;
        var jsx$1_$_hi$2 = 0;
        elem$1$3_$_lo$2 = jsx$1_$_lo$2;
        elem$1$3_$_hi$2 = jsx$1_$_hi$2;
        var isEmpty$4 = (bLength <= 0);
        var scala$collection$immutable$Range$$lastElement$4 = (((-1) + bLength) | 0);
        if ((!isEmpty$4)) {
          var i$1 = 0;
          while (true) {
            var v1 = i$1;
            var this$15_$_lo$2 = elem$1$3_$_lo$2;
            var this$15_$_hi$2 = elem$1$3_$_hi$2;
            var value$7 = normA.get(((((elem$1 - bLength) | 0) + v1) | 0));
            var value$8 = normB.get(v1);
            var lo$5 = ((value$7 + value$8) | 0);
            var hi$20 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ value$7)) ? 1 : 0);
            var alo = this$15_$_lo$2;
            var ahi = this$15_$_hi$2;
            var lo$6 = ((alo + lo$5) | 0);
            var hi$21 = ((((-2147483648) ^ lo$6) < ((-2147483648) ^ alo)) ? ((1 + ((ahi + hi$20) | 0)) | 0) : ((ahi + hi$20) | 0));
            var jsx$2_$_lo$2 = lo$6;
            var jsx$2_$_hi$2 = hi$21;
            elem$1$3_$_lo$2 = jsx$2_$_lo$2;
            elem$1$3_$_hi$2 = jsx$2_$_hi$2;
            var jsx$3 = elem$1;
            var this$17_$_lo$2 = elem$1$3_$_lo$2;
            var this$17_$_hi$2 = elem$1$3_$_hi$2;
            normA.set(((((jsx$3 - bLength) | 0) + v1) | 0), this$17_$_lo$2);
            var this$18_$_lo$2 = elem$1$3_$_lo$2;
            var this$18_$_hi$2 = elem$1$3_$_hi$2;
            var lo$7 = this$18_$_hi$2;
            var jsx$4_$_lo$2 = lo$7;
            var jsx$4_$_hi$2 = 0;
            elem$1$3_$_lo$2 = jsx$4_$_lo$2;
            elem$1$3_$_hi$2 = jsx$4_$_hi$2;
            if ((i$1 === scala$collection$immutable$Range$$lastElement$4)) {
              break
            };
            i$1 = ((1 + i$1) | 0)
          }
        }
      }
    };
    if ((quot !== null)) {
      quot.set(i, elem$1$1)
    };
    elem$1 = (((-1) + elem$1) | 0);
    i = (((-1) + i) | 0)
  };
  return ((divisorShift !== 0) ? ($m_Ljava_math_BitLevel$().shiftRight__AI__I__AI__I__I__Z(normB, bLength, normA, 0, divisorShift), normB) : ($systemArraycopy(normA, 0, normB, 0, bLength), normA))
});
$c_Ljava_math_Division$.prototype.divideAndRemainderByInteger__Ljava_math_BigInteger__I__I__Ljava_math_BigInteger$QuotAndRem = (function(bi, divisor, divisorSign) {
  var valDigits = bi.digits$2;
  var valLen = bi.numberLength$2;
  var valSign = bi.sign$2;
  if ((valLen === 1)) {
    var valDigit = valDigits.get(0);
    var n = ($uD((valDigit >>> 0)) / $uD((divisor >>> 0)));
    var value = $uI((n | 0));
    var quo_$_lo$2 = value;
    var quo_$_hi$2 = 0;
    var n$1 = ($uD((valDigit >>> 0)) % $uD((divisor >>> 0)));
    var value$1 = $uI((n$1 | 0));
    var rem_$_lo$2 = value$1;
    var rem_$_hi$2 = 0;
    if ((valSign !== divisorSign)) {
      var this$13_$_lo$2 = quo_$_lo$2;
      var this$13_$_hi$2 = quo_$_hi$2;
      var lo = this$13_$_lo$2;
      var hi$2 = this$13_$_hi$2;
      var lo$1 = ((-lo) | 0);
      var hi$3 = ((lo !== 0) ? (~hi$2) : ((-hi$2) | 0));
      var jsx$1_$_lo$2 = lo$1;
      var jsx$1_$_hi$2 = hi$3;
      quo_$_lo$2 = jsx$1_$_lo$2;
      quo_$_hi$2 = jsx$1_$_hi$2
    };
    if ((valSign < 0)) {
      var this$16_$_lo$2 = rem_$_lo$2;
      var this$16_$_hi$2 = rem_$_hi$2;
      var lo$2 = this$16_$_lo$2;
      var hi$4 = this$16_$_hi$2;
      var lo$3 = ((-lo$2) | 0);
      var hi$5 = ((lo$2 !== 0) ? (~hi$4) : ((-hi$4) | 0));
      var jsx$2_$_lo$2 = lo$3;
      var jsx$2_$_hi$2 = hi$5;
      rem_$_lo$2 = jsx$2_$_lo$2;
      rem_$_hi$2 = jsx$2_$_hi$2
    };
    return new $c_Ljava_math_BigInteger$QuotAndRem().init___Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_BigInteger$().valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(quo_$_lo$2, quo_$_hi$2)), $m_Ljava_math_BigInteger$().valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(rem_$_lo$2, rem_$_hi$2)))
  } else {
    var quotientSign = ((valSign === divisorSign) ? 1 : (-1));
    var quotientDigits = $newArrayObject($d_I.getArrayOf(), [valLen]);
    var div = this.divideArrayByInt__AI__AI__I__I__I(quotientDigits, valDigits, valLen, divisor);
    var jsx$3 = $m_s_Array$();
    var array = [];
    var remainderDigits = jsx$3.apply__I__sc_Seq__AI(div, new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var result0 = new $c_Ljava_math_BigInteger().init___I__I__AI(quotientSign, valLen, quotientDigits);
    var result1 = new $c_Ljava_math_BigInteger().init___I__I__AI(valSign, 1, remainderDigits);
    result0.cutOffLeadingZeroes__V();
    result1.cutOffLeadingZeroes__V();
    return new $c_Ljava_math_BigInteger$QuotAndRem().init___Ljava_math_BigInteger__Ljava_math_BigInteger(result0, result1)
  }
});
$c_Ljava_math_Division$.prototype.multiplyAndSubtract__AI__I__AI__I__I__I = (function(a, start, b, bLen, c) {
  var elem$1 = 0;
  elem$1 = 0;
  var elem$1$1 = 0;
  elem$1$1 = 0;
  var isEmpty$4 = (bLen <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + bLen) | 0);
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      $m_Ljava_math_Multiplication$();
      var a$1 = b.get(v1);
      var c$1 = elem$1;
      var a0 = (65535 & a$1);
      var a1 = ((a$1 >>> 16) | 0);
      var b0 = (65535 & c);
      var b1 = ((c >>> 16) | 0);
      var a0b0 = $imul(a0, b0);
      var a1b0 = $imul(a1, b0);
      var a0b1 = $imul(a0, b1);
      var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
      var lo$1 = ((lo + c$1) | 0);
      var hi$6 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + hi$4) | 0) : hi$4);
      var value = a.get(((start + v1) | 0));
      var lo$2 = ((value - lo$1) | 0);
      var hi$8 = ((((-2147483648) ^ lo$2) > ((-2147483648) ^ value)) ? (-1) : 0);
      var value$1 = elem$1$1;
      var hi$9 = (value$1 >> 31);
      var lo$3 = ((lo$2 + value$1) | 0);
      var hi$10 = ((((-2147483648) ^ lo$3) < ((-2147483648) ^ lo$2)) ? ((1 + ((hi$8 + hi$9) | 0)) | 0) : ((hi$8 + hi$9) | 0));
      a.set(((start + v1) | 0), lo$3);
      elem$1$1 = hi$10;
      elem$1 = hi$6;
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  var value$2 = a.get(((start + bLen) | 0));
  var value$3 = elem$1;
  var lo$4 = ((value$2 - value$3) | 0);
  var hi$15 = ((((-2147483648) ^ lo$4) > ((-2147483648) ^ value$2)) ? (-1) : 0);
  var value$4 = elem$1$1;
  var hi$16 = (value$4 >> 31);
  var lo$5 = ((lo$4 + value$4) | 0);
  var hi$17 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ lo$4)) ? ((1 + ((hi$15 + hi$16) | 0)) | 0) : ((hi$15 + hi$16) | 0));
  a.set(((start + bLen) | 0), lo$5);
  return hi$17
});
$c_Ljava_math_Division$.prototype.divideArrayByInt__AI__AI__I__I__I = (function(dest, src, srcLength, divisor) {
  var rem = 0;
  var i = (((-1) + srcLength) | 0);
  while ((i >= 0)) {
    var value = rem;
    var value$1 = src.get(i);
    var this$2 = $m_sjsr_RuntimeLong$();
    var lo = this$2.divideUnsignedImpl__I__I__I__I__I(value$1, value, divisor, 0);
    var hi$3 = this$2.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
    var a0 = (65535 & lo);
    var a1 = ((lo >>> 16) | 0);
    var b0 = (65535 & divisor);
    var b1 = ((divisor >>> 16) | 0);
    var a0b0 = $imul(a0, b0);
    var a1b0 = $imul(a1, b0);
    var a0b1 = $imul(a0, b1);
    var lo$1 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
    var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
    var hi$4 = (((((($imul(hi$3, divisor) + $imul(a1, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
    var lo$2 = ((value$1 - lo$1) | 0);
    rem = lo$2;
    dest.set(i, lo);
    i = (((-1) + i) | 0)
  };
  return rem
});
var $d_Ljava_math_Division$ = new $TypeData().initClass({
  Ljava_math_Division$: 0
}, false, "java.math.Division$", {
  Ljava_math_Division$: 1,
  O: 1
});
$c_Ljava_math_Division$.prototype.$classData = $d_Ljava_math_Division$;
var $n_Ljava_math_Division$ = (void 0);
function $m_Ljava_math_Division$() {
  if ((!$n_Ljava_math_Division$)) {
    $n_Ljava_math_Division$ = new $c_Ljava_math_Division$().init___()
  };
  return $n_Ljava_math_Division$
}
/** @constructor */
function $c_Ljava_math_Elementary$() {
  $c_O.call(this)
}
$c_Ljava_math_Elementary$.prototype = new $h_O();
$c_Ljava_math_Elementary$.prototype.constructor = $c_Ljava_math_Elementary$;
/** @constructor */
function $h_Ljava_math_Elementary$() {
  /*<skip>*/
}
$h_Ljava_math_Elementary$.prototype = $c_Ljava_math_Elementary$.prototype;
$c_Ljava_math_Elementary$.prototype.init___ = (function() {
  return this
});
$c_Ljava_math_Elementary$.prototype.subtract__p1__AI__I__AI__I__AI = (function(a, aSize, b, bSize) {
  var res = $newArrayObject($d_I.getArrayOf(), [aSize]);
  this.subtract__p1__AI__AI__I__AI__I__V(res, a, aSize, b, bSize);
  return res
});
$c_Ljava_math_Elementary$.prototype.compareArrays__AI__AI__I__I = (function(a, b, size) {
  var i = (((-1) + size) | 0);
  while (((i >= 0) && (a.get(i) === b.get(i)))) {
    i = (((-1) + i) | 0)
  };
  if ((i < 0)) {
    return 0
  } else {
    var value = a.get(i);
    var value$1 = b.get(i);
    if ((((-2147483648) ^ value) < ((-2147483648) ^ value$1))) {
      return (-1)
    } else {
      return 1
    }
  }
});
$c_Ljava_math_Elementary$.prototype.inplaceAdd__AI__I__I__I = (function(a, aSize, addend) {
  var carry = addend;
  var i = 0;
  while (((carry !== 0) && (i < aSize))) {
    var value = carry;
    var value$1 = a.get(i);
    var lo = ((value + value$1) | 0);
    var hi$2 = ((((-2147483648) ^ lo) < ((-2147483648) ^ value)) ? 1 : 0);
    a.set(i, lo);
    carry = hi$2;
    i = ((1 + i) | 0)
  };
  return carry
});
$c_Ljava_math_Elementary$.prototype.add__p1__AI__I__AI__I__AI = (function(a, aSize, b, bSize) {
  var res = $newArrayObject($d_I.getArrayOf(), [((1 + aSize) | 0)]);
  this.add__p1__AI__AI__I__AI__I__V(res, a, aSize, b, bSize);
  return res
});
$c_Ljava_math_Elementary$.prototype.add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(op1, op2) {
  var op1Sign = op1.sign$2;
  var op2Sign = op2.sign$2;
  var op1Len = op1.numberLength$2;
  var op2Len = op2.numberLength$2;
  if ((op1Sign === 0)) {
    return op2
  } else if ((op2Sign === 0)) {
    return op1
  } else if ((((op1Len + op2Len) | 0) === 2)) {
    var value = op1.digits$2.get(0);
    var value$1 = op2.digits$2.get(0);
    if ((op1Sign === op2Sign)) {
      var lo = ((value + value$1) | 0);
      var hi$2 = ((((-2147483648) ^ lo) < ((-2147483648) ^ value)) ? 1 : 0);
      if ((hi$2 === 0)) {
        return new $c_Ljava_math_BigInteger().init___I__I(op1Sign, lo)
      } else {
        var jsx$1 = $m_s_Array$();
        var array = [hi$2];
        return new $c_Ljava_math_BigInteger().init___I__I__AI(op1Sign, 2, jsx$1.apply__I__sc_Seq__AI(lo, new $c_sjs_js_WrappedArray().init___sjs_js_Array(array)))
      }
    } else {
      var jsx$2 = $m_Ljava_math_BigInteger$();
      if ((op1Sign < 0)) {
        var lo$1 = ((value$1 - value) | 0);
        var hi$3 = ((((-2147483648) ^ lo$1) > ((-2147483648) ^ value$1)) ? (-1) : 0);
        var x_$_lo$2 = lo$1;
        var x_$_hi$2 = hi$3
      } else {
        var lo$2 = ((value - value$1) | 0);
        var hi$4 = ((((-2147483648) ^ lo$2) > ((-2147483648) ^ value)) ? (-1) : 0);
        var x_$_lo$2 = lo$2;
        var x_$_hi$2 = hi$4
      };
      return jsx$2.valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(x_$_lo$2, x_$_hi$2))
    }
  } else {
    if ((op1Sign === op2Sign)) {
      var res$2 = ((op1Len >= op2Len) ? this.add__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len) : this.add__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len));
      var x1_$_$$und1$f = op1Sign;
      var x1_$_$$und2$f = res$2
    } else {
      var cmp = ((op1Len !== op2Len) ? ((op1Len > op2Len) ? 1 : (-1)) : this.compareArrays__AI__AI__I__I(op1.digits$2, op2.digits$2, op1Len));
      if ((cmp === 0)) {
        return $m_Ljava_math_BigInteger$().ZERO$1
      };
      if ((cmp === 1)) {
        var _2 = this.subtract__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len);
        var x1_$_$$und1$f = op1Sign;
        var x1_$_$$und2$f = _2
      } else {
        var _2$1 = this.subtract__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len);
        var x1_$_$$und1$f = op2Sign;
        var x1_$_$$und2$f = _2$1
      }
    };
    var resSign = $uI(x1_$_$$und1$f);
    var resDigits = $asArrayOf_I(x1_$_$$und2$f, 1);
    var res$3 = new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, resDigits.u.length, resDigits);
    res$3.cutOffLeadingZeroes__V();
    return res$3
  }
});
$c_Ljava_math_Elementary$.prototype.subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(op1, op2) {
  var op1Sign = op1.sign$2;
  var op2Sign = op2.sign$2;
  var op1Len = op1.numberLength$2;
  var op2Len = op2.numberLength$2;
  if ((op2Sign === 0)) {
    return op1
  } else if ((op1Sign === 0)) {
    return op2.negate__Ljava_math_BigInteger()
  } else if ((((op1Len + op2Len) | 0) === 2)) {
    var value = op1.digits$2.get(0);
    var a_$_lo$2 = value;
    var a_$_hi$2 = 0;
    var value$1 = op2.digits$2.get(0);
    var b_$_lo$2 = value$1;
    var b_$_hi$2 = 0;
    if ((op1Sign < 0)) {
      var this$1_$_lo$2 = a_$_lo$2;
      var this$1_$_hi$2 = a_$_hi$2;
      var lo = this$1_$_lo$2;
      var hi$2 = this$1_$_hi$2;
      var lo$1 = ((-lo) | 0);
      var hi$3 = ((lo !== 0) ? (~hi$2) : ((-hi$2) | 0));
      var jsx$1_$_lo$2 = lo$1;
      var jsx$1_$_hi$2 = hi$3;
      a_$_lo$2 = jsx$1_$_lo$2;
      a_$_hi$2 = jsx$1_$_hi$2
    };
    if ((op2Sign < 0)) {
      var this$4_$_lo$2 = b_$_lo$2;
      var this$4_$_hi$2 = b_$_hi$2;
      var lo$2 = this$4_$_lo$2;
      var hi$4 = this$4_$_hi$2;
      var lo$3 = ((-lo$2) | 0);
      var hi$5 = ((lo$2 !== 0) ? (~hi$4) : ((-hi$4) | 0));
      var jsx$2_$_lo$2 = lo$3;
      var jsx$2_$_hi$2 = hi$5;
      b_$_lo$2 = jsx$2_$_lo$2;
      b_$_hi$2 = jsx$2_$_hi$2
    };
    var jsx$3 = $m_Ljava_math_BigInteger$();
    var this$7_$_lo$2 = a_$_lo$2;
    var this$7_$_hi$2 = a_$_hi$2;
    var b$1_$_lo$2 = b_$_lo$2;
    var b$1_$_hi$2 = b_$_hi$2;
    var alo = this$7_$_lo$2;
    var ahi = this$7_$_hi$2;
    var bhi = b$1_$_hi$2;
    var lo$4 = ((alo - b$1_$_lo$2) | 0);
    var hi$6 = ((((-2147483648) ^ lo$4) > ((-2147483648) ^ alo)) ? (((-1) + ((ahi - bhi) | 0)) | 0) : ((ahi - bhi) | 0));
    return jsx$3.valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(lo$4, hi$6))
  } else {
    var cmp = ((op1Len !== op2Len) ? ((op1Len > op2Len) ? 1 : (-1)) : $m_Ljava_math_Elementary$().compareArrays__AI__AI__I__I(op1.digits$2, op2.digits$2, op1Len));
    if (((op1Sign === op2Sign) && (cmp === 0))) {
      return $m_Ljava_math_BigInteger$().ZERO$1
    };
    if ((cmp === (-1))) {
      var res = ((op1Sign === op2Sign) ? this.subtract__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len) : this.add__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len));
      var _1 = ((-op2Sign) | 0);
      var x1_$_$$und1$f = _1;
      var x1_$_$$und2$f = res
    } else if ((op1Sign === op2Sign)) {
      var _2 = this.subtract__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len);
      var x1_$_$$und1$f = op1Sign;
      var x1_$_$$und2$f = _2
    } else {
      var _2$1 = this.add__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len);
      var x1_$_$$und1$f = op1Sign;
      var x1_$_$$und2$f = _2$1
    };
    var resSign = $uI(x1_$_$$und1$f);
    var resDigits = $asArrayOf_I(x1_$_$$und2$f, 1);
    var res$2 = new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, resDigits.u.length, resDigits);
    res$2.cutOffLeadingZeroes__V();
    return res$2
  }
});
$c_Ljava_math_Elementary$.prototype.subtract__p1__AI__AI__I__AI__I__V = (function(res, a, aSize, b, bSize) {
  var i = 0;
  var borrow = 0;
  while ((i < bSize)) {
    var value = a.get(i);
    var value$1 = b.get(i);
    var lo = ((value - value$1) | 0);
    var hi$2 = ((((-2147483648) ^ lo) > ((-2147483648) ^ value)) ? (-1) : 0);
    var value$2 = borrow;
    var hi$3 = (value$2 >> 31);
    var lo$1 = ((lo + value$2) | 0);
    var hi$4 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + ((hi$2 + hi$3) | 0)) | 0) : ((hi$2 + hi$3) | 0));
    res.set(i, lo$1);
    borrow = hi$4;
    i = ((1 + i) | 0)
  };
  while ((i < aSize)) {
    var value$3 = a.get(i);
    var value$4 = borrow;
    var hi$7 = (value$4 >> 31);
    var lo$2 = ((value$3 + value$4) | 0);
    var hi$8 = ((((-2147483648) ^ lo$2) < ((-2147483648) ^ value$3)) ? ((1 + hi$7) | 0) : hi$7);
    res.set(i, lo$2);
    borrow = hi$8;
    i = ((1 + i) | 0)
  }
});
$c_Ljava_math_Elementary$.prototype.add__p1__AI__AI__I__AI__I__V = (function(res, a, aSize, b, bSize) {
  var i = 1;
  var value = a.get(0);
  var value$1 = b.get(0);
  var lo = ((value + value$1) | 0);
  var hi$2 = ((((-2147483648) ^ lo) < ((-2147483648) ^ value)) ? 1 : 0);
  res.set(0, lo);
  var carry = hi$2;
  if ((aSize >= bSize)) {
    while ((i < bSize)) {
      var value$2 = a.get(i);
      var value$3 = b.get(i);
      var lo$1 = ((value$2 + value$3) | 0);
      var hi$6 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ value$2)) ? 1 : 0);
      var value$4 = carry;
      var lo$2 = ((lo$1 + value$4) | 0);
      var hi$8 = ((((-2147483648) ^ lo$2) < ((-2147483648) ^ lo$1)) ? ((1 + hi$6) | 0) : hi$6);
      res.set(i, lo$2);
      carry = hi$8;
      i = ((1 + i) | 0)
    };
    while ((i < aSize)) {
      var value$5 = a.get(i);
      var value$6 = carry;
      var lo$3 = ((value$5 + value$6) | 0);
      var hi$12 = ((((-2147483648) ^ lo$3) < ((-2147483648) ^ value$5)) ? 1 : 0);
      res.set(i, lo$3);
      carry = hi$12;
      i = ((1 + i) | 0)
    }
  } else {
    while ((i < aSize)) {
      var value$7 = a.get(i);
      var value$8 = b.get(i);
      var lo$4 = ((value$7 + value$8) | 0);
      var hi$16 = ((((-2147483648) ^ lo$4) < ((-2147483648) ^ value$7)) ? 1 : 0);
      var value$9 = carry;
      var lo$5 = ((lo$4 + value$9) | 0);
      var hi$18 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ lo$4)) ? ((1 + hi$16) | 0) : hi$16);
      res.set(i, lo$5);
      carry = hi$18;
      i = ((1 + i) | 0)
    };
    while ((i < bSize)) {
      var value$10 = b.get(i);
      var value$11 = carry;
      var lo$6 = ((value$10 + value$11) | 0);
      var hi$22 = ((((-2147483648) ^ lo$6) < ((-2147483648) ^ value$10)) ? 1 : 0);
      res.set(i, lo$6);
      carry = hi$22;
      i = ((1 + i) | 0)
    }
  };
  if ((carry !== 0)) {
    res.set(i, carry)
  }
});
var $d_Ljava_math_Elementary$ = new $TypeData().initClass({
  Ljava_math_Elementary$: 0
}, false, "java.math.Elementary$", {
  Ljava_math_Elementary$: 1,
  O: 1
});
$c_Ljava_math_Elementary$.prototype.$classData = $d_Ljava_math_Elementary$;
var $n_Ljava_math_Elementary$ = (void 0);
function $m_Ljava_math_Elementary$() {
  if ((!$n_Ljava_math_Elementary$)) {
    $n_Ljava_math_Elementary$ = new $c_Ljava_math_Elementary$().init___()
  };
  return $n_Ljava_math_Elementary$
}
/** @constructor */
function $c_Ljava_math_MathContext() {
  $c_O.call(this);
  this.precision$1 = 0;
  this.roundingMode$1 = null
}
$c_Ljava_math_MathContext.prototype = new $h_O();
$c_Ljava_math_MathContext.prototype.constructor = $c_Ljava_math_MathContext;
/** @constructor */
function $h_Ljava_math_MathContext() {
  /*<skip>*/
}
$h_Ljava_math_MathContext.prototype = $c_Ljava_math_MathContext.prototype;
$c_Ljava_math_MathContext.prototype.equals__O__Z = (function(x) {
  if ($is_Ljava_math_MathContext(x)) {
    var x2 = $as_Ljava_math_MathContext(x);
    if ((this.precision$1 === x2.precision$1)) {
      var x$2 = this.roundingMode$1;
      var x$3 = x2.roundingMode$1;
      return (x$2 === x$3)
    } else {
      return false
    }
  } else {
    return false
  }
});
$c_Ljava_math_MathContext.prototype.toString__T = (function() {
  return ((("precision=" + this.precision$1) + " roundingMode=") + this.roundingMode$1)
});
$c_Ljava_math_MathContext.prototype.init___I__Ljava_math_RoundingMode = (function(setPrecision, setRoundingMode) {
  this.precision$1 = setPrecision;
  this.roundingMode$1 = setRoundingMode;
  return this
});
$c_Ljava_math_MathContext.prototype.hashCode__I = (function() {
  return ((this.precision$1 << 3) | this.roundingMode$1.$$undordinal$1)
});
function $is_Ljava_math_MathContext(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Ljava_math_MathContext)))
}
function $as_Ljava_math_MathContext(obj) {
  return (($is_Ljava_math_MathContext(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.math.MathContext"))
}
function $isArrayOf_Ljava_math_MathContext(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Ljava_math_MathContext)))
}
function $asArrayOf_Ljava_math_MathContext(obj, depth) {
  return (($isArrayOf_Ljava_math_MathContext(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.math.MathContext;", depth))
}
var $d_Ljava_math_MathContext = new $TypeData().initClass({
  Ljava_math_MathContext: 0
}, false, "java.math.MathContext", {
  Ljava_math_MathContext: 1,
  O: 1
});
$c_Ljava_math_MathContext.prototype.$classData = $d_Ljava_math_MathContext;
/** @constructor */
function $c_Ljava_math_MathContext$() {
  $c_O.call(this);
  this.DECIMAL128$1 = null;
  this.DECIMAL32$1 = null;
  this.DECIMAL64$1 = null;
  this.UNLIMITED$1 = null
}
$c_Ljava_math_MathContext$.prototype = new $h_O();
$c_Ljava_math_MathContext$.prototype.constructor = $c_Ljava_math_MathContext$;
/** @constructor */
function $h_Ljava_math_MathContext$() {
  /*<skip>*/
}
$h_Ljava_math_MathContext$.prototype = $c_Ljava_math_MathContext$.prototype;
$c_Ljava_math_MathContext$.prototype.init___ = (function() {
  $n_Ljava_math_MathContext$ = this;
  $m_Ljava_math_MathContext$();
  var roundingMode = $m_Ljava_math_RoundingMode$().HALF$undEVEN$1;
  this.DECIMAL128$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(34, roundingMode);
  $m_Ljava_math_MathContext$();
  var roundingMode$1 = $m_Ljava_math_RoundingMode$().HALF$undEVEN$1;
  this.DECIMAL32$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(7, roundingMode$1);
  $m_Ljava_math_MathContext$();
  var roundingMode$2 = $m_Ljava_math_RoundingMode$().HALF$undEVEN$1;
  this.DECIMAL64$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(16, roundingMode$2);
  $m_Ljava_math_MathContext$();
  var roundingMode$3 = $m_Ljava_math_RoundingMode$().HALF$undUP$1;
  this.UNLIMITED$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(0, roundingMode$3);
  return this
});
var $d_Ljava_math_MathContext$ = new $TypeData().initClass({
  Ljava_math_MathContext$: 0
}, false, "java.math.MathContext$", {
  Ljava_math_MathContext$: 1,
  O: 1
});
$c_Ljava_math_MathContext$.prototype.$classData = $d_Ljava_math_MathContext$;
var $n_Ljava_math_MathContext$ = (void 0);
function $m_Ljava_math_MathContext$() {
  if ((!$n_Ljava_math_MathContext$)) {
    $n_Ljava_math_MathContext$ = new $c_Ljava_math_MathContext$().init___()
  };
  return $n_Ljava_math_MathContext$
}
/** @constructor */
function $c_Ljava_math_Multiplication$() {
  $c_O.call(this);
  this.TenPows$1 = null;
  this.FivePows$1 = null;
  this.BigTenPows$1 = null;
  this.BigFivePows$1 = null
}
$c_Ljava_math_Multiplication$.prototype = new $h_O();
$c_Ljava_math_Multiplication$.prototype.constructor = $c_Ljava_math_Multiplication$;
/** @constructor */
function $h_Ljava_math_Multiplication$() {
  /*<skip>*/
}
$h_Ljava_math_Multiplication$.prototype = $c_Ljava_math_Multiplication$.prototype;
$c_Ljava_math_Multiplication$.prototype.multiplyPAP__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(a, b) {
  var aLen = a.numberLength$2;
  var bLen = b.numberLength$2;
  var resLength = ((aLen + bLen) | 0);
  var resSign = ((a.sign$2 !== b.sign$2) ? (-1) : 1);
  if ((resLength === 2)) {
    var a$1 = a.digits$2.get(0);
    var b$1 = b.digits$2.get(0);
    var a0 = (65535 & a$1);
    var a1 = ((a$1 >>> 16) | 0);
    var b0 = (65535 & b$1);
    var b1 = ((b$1 >>> 16) | 0);
    var a0b0 = $imul(a0, b0);
    var a1b0 = $imul(a1, b0);
    var a0b1 = $imul(a0, b1);
    var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
    var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
    var hi$2 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
    if ((hi$2 === 0)) {
      return new $c_Ljava_math_BigInteger().init___I__I(resSign, lo)
    } else {
      var jsx$1 = $m_s_Array$();
      var array = [hi$2];
      return new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, 2, jsx$1.apply__I__sc_Seq__AI(lo, new $c_sjs_js_WrappedArray().init___sjs_js_Array(array)))
    }
  } else {
    var aDigits = a.digits$2;
    var bDigits = b.digits$2;
    var resDigits = $newArrayObject($d_I.getArrayOf(), [resLength]);
    this.multArraysPAP__AI__I__AI__I__AI__V(aDigits, aLen, bDigits, bLen, resDigits);
    var result = new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, resLength, resDigits);
    result.cutOffLeadingZeroes__V();
    return result
  }
});
$c_Ljava_math_Multiplication$.prototype.init___ = (function() {
  $n_Ljava_math_Multiplication$ = this;
  this.TenPows$1 = this.newArrayOfPows__p1__I__I__AI(10, 10);
  this.FivePows$1 = this.newArrayOfPows__p1__I__I__AI(14, 5);
  this.BigTenPows$1 = $newArrayObject($d_Ljava_math_BigInteger.getArrayOf(), [32]);
  this.BigFivePows$1 = $newArrayObject($d_Ljava_math_BigInteger.getArrayOf(), [32]);
  this.initialiseArrays__p1__V();
  return this
});
$c_Ljava_math_Multiplication$.prototype.square__AI__I__AI__AI = (function(a, aLen, res) {
  var elem$1 = 0;
  elem$1 = 0;
  var isEmpty$4 = (aLen <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + aLen) | 0);
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      elem$1 = 0;
      var x = ((1 + v1) | 0);
      var isEmpty$4$1 = (x >= aLen);
      var scala$collection$immutable$Range$$lastElement$4$1 = (((-1) + aLen) | 0);
      if ((!isEmpty$4$1)) {
        var i$1 = x;
        while (true) {
          var v1$1 = i$1;
          $m_Ljava_math_Multiplication$();
          var a$1 = a.get(v1);
          var b = a.get(v1$1);
          var c = res.get(((v1 + v1$1) | 0));
          var d = elem$1;
          var a0 = (65535 & a$1);
          var a1 = ((a$1 >>> 16) | 0);
          var b0 = (65535 & b);
          var b1 = ((b >>> 16) | 0);
          var a0b0 = $imul(a0, b0);
          var a1b0 = $imul(a1, b0);
          var a0b1 = $imul(a0, b1);
          var lo$4 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
          var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
          var hi$13 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
          var lo$5 = ((lo$4 + c) | 0);
          var hi$15 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ lo$4)) ? ((1 + hi$13) | 0) : hi$13);
          var lo$6 = ((lo$5 + d) | 0);
          var hi$17 = ((((-2147483648) ^ lo$6) < ((-2147483648) ^ lo$5)) ? ((1 + hi$15) | 0) : hi$15);
          res.set(((v1 + v1$1) | 0), lo$6);
          elem$1 = hi$17;
          if ((i$1 === scala$collection$immutable$Range$$lastElement$4$1)) {
            break
          };
          i$1 = ((1 + i$1) | 0)
        }
      };
      res.set(((v1 + aLen) | 0), elem$1);
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  $m_Ljava_math_BitLevel$().shiftLeftOneBit__AI__AI__I__V(res, res, (aLen << 1));
  elem$1 = 0;
  var i$3 = 0;
  var index = 0;
  while ((i$3 < aLen)) {
    var a$2 = a.get(i$3);
    var b$1 = a.get(i$3);
    var c$1 = res.get(index);
    var d$1 = elem$1;
    var a0$1 = (65535 & a$2);
    var a1$1 = ((a$2 >>> 16) | 0);
    var b0$1 = (65535 & b$1);
    var b1$1 = ((b$1 >>> 16) | 0);
    var a0b0$1 = $imul(a0$1, b0$1);
    var a1b0$1 = $imul(a1$1, b0$1);
    var a0b1$1 = $imul(a0$1, b1$1);
    var lo$7 = ((a0b0$1 + (((a1b0$1 + a0b1$1) | 0) << 16)) | 0);
    var c1part$1 = ((((a0b0$1 >>> 16) | 0) + a0b1$1) | 0);
    var hi$20 = (((($imul(a1$1, b1$1) + ((c1part$1 >>> 16) | 0)) | 0) + (((((65535 & c1part$1) + a1b0$1) | 0) >>> 16) | 0)) | 0);
    var lo$8 = ((lo$7 + c$1) | 0);
    var hi$22 = ((((-2147483648) ^ lo$8) < ((-2147483648) ^ lo$7)) ? ((1 + hi$20) | 0) : hi$20);
    var lo$9 = ((lo$8 + d$1) | 0);
    var hi$24 = ((((-2147483648) ^ lo$9) < ((-2147483648) ^ lo$8)) ? ((1 + hi$22) | 0) : hi$22);
    res.set(index, lo$9);
    index = ((1 + index) | 0);
    var value$1 = res.get(index);
    var lo$10 = ((hi$24 + value$1) | 0);
    var hi$26 = ((((-2147483648) ^ lo$10) < ((-2147483648) ^ hi$24)) ? 1 : 0);
    res.set(index, lo$10);
    elem$1 = hi$26;
    i$3 = ((1 + i$3) | 0);
    index = ((1 + index) | 0)
  };
  return res
});
$c_Ljava_math_Multiplication$.prototype.pow__Ljava_math_BigInteger__I__Ljava_math_BigInteger = (function(base, exponent) {
  var exp = exponent;
  var res = $m_Ljava_math_BigInteger$().ONE$1;
  var acc = base;
  _loop: while (true) {
    if ((exp > 1)) {
      var res2 = (((1 & exp) !== 0) ? res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(acc) : res);
      if ((acc.numberLength$2 === 1)) {
        var acc2 = acc.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(acc)
      } else {
        var a = $newArrayObject($d_I.getArrayOf(), [(acc.numberLength$2 << 1)]);
        var sq = this.square__AI__I__AI__AI(acc.digits$2, acc.numberLength$2, a);
        var acc2 = new $c_Ljava_math_BigInteger().init___I__AI(1, sq)
      };
      var temp$exp = (exp >> 1);
      exp = temp$exp;
      res = res2;
      acc = acc2;
      continue _loop
    } else {
      return res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(acc)
    }
  }
});
$c_Ljava_math_Multiplication$.prototype.multPAP__p1__AI__AI__AI__I__I__V = (function(a, b, t, aLen, bLen) {
  if (((a === b) && (aLen === bLen))) {
    this.square__AI__I__AI__AI(a, aLen, t)
  } else {
    var isEmpty$4 = (aLen <= 0);
    var scala$collection$immutable$Range$$lastElement$4 = (((-1) + aLen) | 0);
    if ((!isEmpty$4)) {
      var i = 0;
      while (true) {
        var v1 = i;
        var elem$1 = 0;
        elem$1 = 0;
        var aI = a.get(v1);
        var isEmpty$4$1 = (bLen <= 0);
        var scala$collection$immutable$Range$$lastElement$4$1 = (((-1) + bLen) | 0);
        if ((!isEmpty$4$1)) {
          var i$1 = 0;
          while (true) {
            var v1$1 = i$1;
            $m_Ljava_math_Multiplication$();
            var b$1 = b.get(v1$1);
            var c = t.get(((v1 + v1$1) | 0));
            var d = elem$1;
            var a0 = (65535 & aI);
            var a1 = ((aI >>> 16) | 0);
            var b0 = (65535 & b$1);
            var b1 = ((b$1 >>> 16) | 0);
            var a0b0 = $imul(a0, b0);
            var a1b0 = $imul(a1, b0);
            var a0b1 = $imul(a0, b1);
            var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
            var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
            var hi$6 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
            var lo$1 = ((lo + c) | 0);
            var hi$8 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + hi$6) | 0) : hi$6);
            var lo$2 = ((lo$1 + d) | 0);
            var hi$10 = ((((-2147483648) ^ lo$2) < ((-2147483648) ^ lo$1)) ? ((1 + hi$8) | 0) : hi$8);
            t.set(((v1 + v1$1) | 0), lo$2);
            elem$1 = hi$10;
            if ((i$1 === scala$collection$immutable$Range$$lastElement$4$1)) {
              break
            };
            i$1 = ((1 + i$1) | 0)
          }
        };
        t.set(((v1 + bLen) | 0), elem$1);
        if ((i === scala$collection$immutable$Range$$lastElement$4)) {
          break
        };
        i = ((1 + i) | 0)
      }
    }
  }
});
$c_Ljava_math_Multiplication$.prototype.initialiseArrays__p1__V = (function() {
  var elem$1_$_lo$2 = 0;
  var elem$1_$_hi$2 = 0;
  var jsx$1_$_lo$2 = 1;
  var jsx$1_$_hi$2 = 0;
  elem$1_$_lo$2 = jsx$1_$_lo$2;
  elem$1_$_hi$2 = jsx$1_$_hi$2;
  var i = 0;
  while (true) {
    var v1 = i;
    if ((v1 <= 18)) {
      $m_Ljava_math_Multiplication$().BigFivePows$1.set(v1, $m_Ljava_math_BigInteger$().valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(elem$1_$_lo$2, elem$1_$_hi$2)));
      var jsx$3 = $m_Ljava_math_Multiplication$().BigTenPows$1;
      var jsx$2 = $m_Ljava_math_BigInteger$();
      var this$5_$_lo$2 = elem$1_$_lo$2;
      var this$5_$_hi$2 = elem$1_$_hi$2;
      var lo = (((32 & v1) === 0) ? (this$5_$_lo$2 << v1) : 0);
      var hi = (((32 & v1) === 0) ? (((((this$5_$_lo$2 >>> 1) | 0) >>> ((31 - v1) | 0)) | 0) | (this$5_$_hi$2 << v1)) : (this$5_$_lo$2 << v1));
      jsx$3.set(v1, jsx$2.valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
      var b_$_lo$2 = elem$1_$_lo$2;
      var b_$_hi$2 = elem$1_$_hi$2;
      var blo = b_$_lo$2;
      var b0 = (65535 & blo);
      var b1 = ((blo >>> 16) | 0);
      var a0b0 = $imul(5, b0);
      var a0b1 = $imul(5, b1);
      var lo$1 = ((a0b0 + (a0b1 << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$1 = (($imul(5, b_$_hi$2) + ((c1part >>> 16) | 0)) | 0);
      var jsx$4_$_lo$2 = lo$1;
      var jsx$4_$_hi$2 = hi$1;
      elem$1_$_lo$2 = jsx$4_$_lo$2;
      elem$1_$_hi$2 = jsx$4_$_hi$2
    } else {
      $m_Ljava_math_Multiplication$().BigFivePows$1.set(v1, $m_Ljava_math_Multiplication$().BigFivePows$1.get((((-1) + v1) | 0)).multiply__Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_Multiplication$().BigFivePows$1.get(1)));
      $m_Ljava_math_Multiplication$().BigTenPows$1.set(v1, $m_Ljava_math_Multiplication$().BigTenPows$1.get((((-1) + v1) | 0)).multiply__Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_BigInteger$().TEN$1))
    };
    if ((i === 31)) {
      break
    };
    i = ((1 + i) | 0)
  }
});
$c_Ljava_math_Multiplication$.prototype.newArrayOfPows__p1__I__I__AI = (function(len, pow) {
  var elems$2 = null;
  elems$2 = [];
  if ((len > 0)) {
    var acc = 1;
    var i = 1;
    var elem = acc;
    var unboxedElem = ((elem === null) ? 0 : elem);
    elems$2.push(unboxedElem);
    while ((i < len)) {
      var arg1 = acc;
      var x$2 = $uI(arg1);
      acc = $imul(x$2, pow);
      i = ((1 + i) | 0);
      var elem$1 = acc;
      var unboxedElem$1 = ((elem$1 === null) ? 0 : elem$1);
      elems$2.push(unboxedElem$1)
    }
  };
  return $makeNativeArrayWrapper($d_I.getArrayOf(), elems$2)
});
$c_Ljava_math_Multiplication$.prototype.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(val1, val2) {
  if ((val2.numberLength$2 > val1.numberLength$2)) {
    var x1_$_$$und1$f = val2;
    var x1_$_$$und2$f = val1
  } else {
    var x1_$_$$und1$f = val1;
    var x1_$_$$und2$f = val2
  };
  var op1 = $as_Ljava_math_BigInteger(x1_$_$$und1$f);
  var op2 = $as_Ljava_math_BigInteger(x1_$_$$und2$f);
  if ((op2.numberLength$2 < 63)) {
    return this.multiplyPAP__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(op1, op2)
  } else {
    var ndiv2 = (((-2) & op1.numberLength$2) << 4);
    var upperOp1 = op1.shiftRight__I__Ljava_math_BigInteger(ndiv2);
    var upperOp2 = op2.shiftRight__I__Ljava_math_BigInteger(ndiv2);
    var bi = upperOp1.shiftLeft__I__Ljava_math_BigInteger(ndiv2);
    var lowerOp1 = $m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(op1, bi);
    var bi$1 = upperOp2.shiftLeft__I__Ljava_math_BigInteger(ndiv2);
    var lowerOp2 = $m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(op2, bi$1);
    var upper = this.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(upperOp1, upperOp2);
    var lower = this.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(lowerOp1, lowerOp2);
    var middle = this.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(upperOp1, lowerOp1), $m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(lowerOp2, upperOp2));
    var this$1 = middle;
    var bi$2 = upper;
    var this$2 = $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$1, bi$2);
    middle = $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$2, lower);
    middle = middle.shiftLeft__I__Ljava_math_BigInteger(ndiv2);
    upper = upper.shiftLeft__I__Ljava_math_BigInteger((ndiv2 << 1));
    var this$3 = upper;
    var bi$3 = middle;
    var this$4 = $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$3, bi$3);
    return $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$4, lower)
  }
});
$c_Ljava_math_Multiplication$.prototype.multiplyByInt__p1__AI__AI__I__I__I = (function(res, a, aSize, factor) {
  var elem$1 = 0;
  elem$1 = 0;
  var isEmpty$4 = (aSize <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + aSize) | 0);
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      $m_Ljava_math_Multiplication$();
      var a$1 = a.get(v1);
      var c = elem$1;
      var a0 = (65535 & a$1);
      var a1 = ((a$1 >>> 16) | 0);
      var b0 = (65535 & factor);
      var b1 = ((factor >>> 16) | 0);
      var a0b0 = $imul(a0, b0);
      var a1b0 = $imul(a1, b0);
      var a0b1 = $imul(a0, b1);
      var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
      var lo$1 = ((lo + c) | 0);
      var hi$6 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + hi$4) | 0) : hi$4);
      res.set(v1, lo$1);
      elem$1 = hi$6;
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  return elem$1
});
$c_Ljava_math_Multiplication$.prototype.multArraysPAP__AI__I__AI__I__AI__V = (function(aDigits, aLen, bDigits, bLen, resDigits) {
  if ((!((aLen === 0) || (bLen === 0)))) {
    if ((aLen === 1)) {
      resDigits.set(bLen, this.multiplyByInt__p1__AI__AI__I__I__I(resDigits, bDigits, bLen, aDigits.get(0)))
    } else if ((bLen === 1)) {
      resDigits.set(aLen, this.multiplyByInt__p1__AI__AI__I__I__I(resDigits, aDigits, aLen, bDigits.get(0)))
    } else {
      this.multPAP__p1__AI__AI__AI__I__I__V(aDigits, bDigits, resDigits, aLen, bLen)
    }
  }
});
$c_Ljava_math_Multiplication$.prototype.powerOf10__J__Ljava_math_BigInteger = (function(exp) {
  var value = this.BigTenPows$1.u.length;
  var hi = (value >> 31);
  var ahi = exp.hi$2;
  if (((ahi === hi) ? (((-2147483648) ^ exp.lo$2) < ((-2147483648) ^ value)) : (ahi < hi))) {
    return this.BigTenPows$1.get(exp.lo$2)
  } else {
    var ahi$1 = exp.hi$2;
    if (((ahi$1 === 0) ? (((-2147483648) ^ exp.lo$2) <= (-2147483598)) : (ahi$1 < 0))) {
      return $m_Ljava_math_BigInteger$().TEN$1.pow__I__Ljava_math_BigInteger(exp.lo$2)
    } else {
      var ahi$2 = exp.hi$2;
      if (((ahi$2 === 0) ? (((-2147483648) ^ exp.lo$2) <= (-1)) : (ahi$2 < 0))) {
        return this.BigFivePows$1.get(1).pow__I__Ljava_math_BigInteger(exp.lo$2).shiftLeft__I__Ljava_math_BigInteger(exp.lo$2)
      } else {
        var powerOfFive = this.BigFivePows$1.get(1).pow__I__Ljava_math_BigInteger(2147483647);
        var res = powerOfFive;
        var bhi = exp.hi$2;
        var lo = (((-2147483647) + exp.lo$2) | 0);
        var hi$1 = ((((-2147483648) ^ lo) < 1) ? bhi : (((-1) + bhi) | 0));
        var longExp_$_lo$2 = lo;
        var longExp_$_hi$2 = hi$1;
        var this$2 = $m_sjsr_RuntimeLong$();
        var lo$1 = this$2.remainderImpl__I__I__I__I__I(exp.lo$2, exp.hi$2, 2147483647, 0);
        while (true) {
          var this$3_$_lo$2 = longExp_$_lo$2;
          var this$3_$_hi$2 = longExp_$_hi$2;
          var ahi$3 = this$3_$_hi$2;
          if (((ahi$3 === 0) ? (((-2147483648) ^ this$3_$_lo$2) > (-1)) : (ahi$3 > 0))) {
            res = res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(powerOfFive);
            var b_$_lo$2 = longExp_$_lo$2;
            var b_$_hi$2 = longExp_$_hi$2;
            var bhi$1 = b_$_hi$2;
            var lo$2 = (((-2147483647) + b_$_lo$2) | 0);
            var hi$3 = ((((-2147483648) ^ lo$2) < 1) ? bhi$1 : (((-1) + bhi$1) | 0));
            var jsx$1_$_lo$2 = lo$2;
            var jsx$1_$_hi$2 = hi$3;
            longExp_$_lo$2 = jsx$1_$_lo$2;
            longExp_$_hi$2 = jsx$1_$_hi$2
          } else {
            break
          }
        };
        res = res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(this.BigFivePows$1.get(1).pow__I__Ljava_math_BigInteger(lo$1));
        res = res.shiftLeft__I__Ljava_math_BigInteger(2147483647);
        var bhi$2 = exp.hi$2;
        var lo$3 = (((-2147483647) + exp.lo$2) | 0);
        var hi$4 = ((((-2147483648) ^ lo$3) < 1) ? bhi$2 : (((-1) + bhi$2) | 0));
        var jsx$2_$_lo$2 = lo$3;
        var jsx$2_$_hi$2 = hi$4;
        longExp_$_lo$2 = jsx$2_$_lo$2;
        longExp_$_hi$2 = jsx$2_$_hi$2;
        while (true) {
          var this$6_$_lo$2 = longExp_$_lo$2;
          var this$6_$_hi$2 = longExp_$_hi$2;
          var ahi$4 = this$6_$_hi$2;
          if (((ahi$4 === 0) ? (((-2147483648) ^ this$6_$_lo$2) > (-1)) : (ahi$4 > 0))) {
            res = res.shiftLeft__I__Ljava_math_BigInteger(2147483647);
            var b$1_$_lo$2 = longExp_$_lo$2;
            var b$1_$_hi$2 = longExp_$_hi$2;
            var bhi$3 = b$1_$_hi$2;
            var lo$4 = (((-2147483647) + b$1_$_lo$2) | 0);
            var hi$5 = ((((-2147483648) ^ lo$4) < 1) ? bhi$3 : (((-1) + bhi$3) | 0));
            var jsx$3_$_lo$2 = lo$4;
            var jsx$3_$_hi$2 = hi$5;
            longExp_$_lo$2 = jsx$3_$_lo$2;
            longExp_$_hi$2 = jsx$3_$_hi$2
          } else {
            break
          }
        };
        return res.shiftLeft__I__Ljava_math_BigInteger(lo$1)
      }
    }
  }
});
var $d_Ljava_math_Multiplication$ = new $TypeData().initClass({
  Ljava_math_Multiplication$: 0
}, false, "java.math.Multiplication$", {
  Ljava_math_Multiplication$: 1,
  O: 1
});
$c_Ljava_math_Multiplication$.prototype.$classData = $d_Ljava_math_Multiplication$;
var $n_Ljava_math_Multiplication$ = (void 0);
function $m_Ljava_math_Multiplication$() {
  if ((!$n_Ljava_math_Multiplication$)) {
    $n_Ljava_math_Multiplication$ = new $c_Ljava_math_Multiplication$().init___()
  };
  return $n_Ljava_math_Multiplication$
}
/** @constructor */
function $c_Llocales_LocaleRegistry$() {
  $c_O.call(this);
  this.en$1 = null;
  this.fr$1 = null;
  this.de$1 = null;
  this.it$1 = null;
  this.ja$1 = null;
  this.ko$1 = null;
  this.zh$1 = null;
  this.zh$undHans$undCN$1 = null;
  this.zh$undHant$undTW$1 = null;
  this.fr$undFR$1 = null;
  this.de$undDE$1 = null;
  this.it$undIT$1 = null;
  this.ja$undJP$1 = null;
  this.ko$undKR$1 = null;
  this.en$undGB$1 = null;
  this.en$undUS$1 = null;
  this.en$undCA$1 = null;
  this.fr$undCA$1 = null;
  this.root$1 = null;
  this.defaultLocales$1 = null;
  this.ldmls$1 = null;
  this.defaultLocale$1 = null;
  this.defaultPerCategory$1 = null;
  this.bitmap$0$1 = 0
}
$c_Llocales_LocaleRegistry$.prototype = new $h_O();
$c_Llocales_LocaleRegistry$.prototype.constructor = $c_Llocales_LocaleRegistry$;
/** @constructor */
function $h_Llocales_LocaleRegistry$() {
  /*<skip>*/
}
$h_Llocales_LocaleRegistry$.prototype = $c_Llocales_LocaleRegistry$.prototype;
$c_Llocales_LocaleRegistry$.prototype.en$undUS__Llocales_cldr_LDML = (function() {
  return (((32768 & this.bitmap$0$1) === 0) ? this.en$undUS$lzycompute__p1__Llocales_cldr_LDML() : this.en$undUS$1)
});
$c_Llocales_LocaleRegistry$.prototype.init___ = (function() {
  $n_Llocales_LocaleRegistry$ = this;
  this.defaultLocale$1 = this.en__Llocales_cldr_LDML().toLocale__ju_Locale();
  var this$1 = $m_ju_Locale$Category$();
  var xs = this$1.categories__p1__Aju_Locale$Category();
  var elems$2 = null;
  elems$2 = [];
  var x1 = xs.u.length;
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var x$1 = $as_ju_Locale$Category(arg1);
    var y = new $c_s_Some().init___O(this.defaultLocale$1);
    var elem = new $c_T2().init___O__O(x$1, y);
    elems$2.push(elem);
    i = ((1 + i) | 0)
  };
  var xs$1 = $makeNativeArrayWrapper($d_T2.getArrayOf(), elems$2);
  var b = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  var i$1 = 0;
  var len$1 = xs$1.u.length;
  while ((i$1 < len$1)) {
    var index$1 = i$1;
    var arg1$1 = xs$1.get(index$1);
    b.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1$1));
    i$1 = ((1 + i$1) | 0)
  };
  this.defaultPerCategory$1 = $as_sci_Map(b.elems$1);
  this.initDefaultLocales__p1__V();
  return this
});
$c_Llocales_LocaleRegistry$.prototype.fr$undFR$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((512 & this.bitmap$0$1) === 0)) {
    this.fr$undFR$1 = $m_Llocales_cldr_data_fr$undFR$();
    this.bitmap$0$1 = (512 | this.bitmap$0$1)
  };
  return this.fr$undFR$1
});
$c_Llocales_LocaleRegistry$.prototype.ko$undKR__Llocales_cldr_LDML = (function() {
  return (((8192 & this.bitmap$0$1) === 0) ? this.ko$undKR$lzycompute__p1__Llocales_cldr_LDML() : this.ko$undKR$1)
});
$c_Llocales_LocaleRegistry$.prototype.en$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.en$1 = $m_Llocales_cldr_data_en$();
    this.bitmap$0$1 = (1 | this.bitmap$0$1)
  };
  return this.en$1
});
$c_Llocales_LocaleRegistry$.prototype.zh$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((64 & this.bitmap$0$1) === 0)) {
    this.zh$1 = $m_Llocales_cldr_data_zh$();
    this.bitmap$0$1 = (64 | this.bitmap$0$1)
  };
  return this.zh$1
});
$c_Llocales_LocaleRegistry$.prototype.defaultLocales$lzycompute__p1__sc_Map = (function() {
  if (((524288 & this.bitmap$0$1) === 0)) {
    var this$1 = this.root__Llocales_cldr_LDML();
    var self = this$1.toLocale__ju_Locale().toLanguageTag__T();
    var y = this.root__Llocales_cldr_LDML();
    var jsx$18 = new $c_T2().init___O__O(self, y);
    var this$4 = this.en__Llocales_cldr_LDML();
    var self$1 = this$4.toLocale__ju_Locale().toLanguageTag__T();
    var y$1 = this.en__Llocales_cldr_LDML();
    var jsx$17 = new $c_T2().init___O__O(self$1, y$1);
    var this$7 = this.fr__Llocales_cldr_LDML();
    var self$2 = this$7.toLocale__ju_Locale().toLanguageTag__T();
    var y$2 = this.fr__Llocales_cldr_LDML();
    var jsx$16 = new $c_T2().init___O__O(self$2, y$2);
    var this$10 = this.de__Llocales_cldr_LDML();
    var self$3 = this$10.toLocale__ju_Locale().toLanguageTag__T();
    var y$3 = this.de__Llocales_cldr_LDML();
    var jsx$15 = new $c_T2().init___O__O(self$3, y$3);
    var this$13 = this.it__Llocales_cldr_LDML();
    var self$4 = this$13.toLocale__ju_Locale().toLanguageTag__T();
    var y$4 = this.it__Llocales_cldr_LDML();
    var jsx$14 = new $c_T2().init___O__O(self$4, y$4);
    var this$16 = this.ja__Llocales_cldr_LDML();
    var self$5 = this$16.toLocale__ju_Locale().toLanguageTag__T();
    var y$5 = this.ja__Llocales_cldr_LDML();
    var jsx$13 = new $c_T2().init___O__O(self$5, y$5);
    var this$19 = this.ko__Llocales_cldr_LDML();
    var self$6 = this$19.toLocale__ju_Locale().toLanguageTag__T();
    var y$6 = this.ko__Llocales_cldr_LDML();
    var jsx$12 = new $c_T2().init___O__O(self$6, y$6);
    var this$22 = this.zh__Llocales_cldr_LDML();
    var self$7 = this$22.toLocale__ju_Locale().toLanguageTag__T();
    var y$7 = this.zh__Llocales_cldr_LDML();
    var jsx$11 = new $c_T2().init___O__O(self$7, y$7);
    var this$25 = this.zh$undHans$undCN__Llocales_cldr_LDML();
    var self$8 = this$25.toLocale__ju_Locale().toLanguageTag__T();
    var y$8 = this.zh$undHans$undCN__Llocales_cldr_LDML();
    var jsx$10 = new $c_T2().init___O__O(self$8, y$8);
    var this$28 = this.zh$undHant$undTW__Llocales_cldr_LDML();
    var self$9 = this$28.toLocale__ju_Locale().toLanguageTag__T();
    var y$9 = this.zh$undHant$undTW__Llocales_cldr_LDML();
    var jsx$9 = new $c_T2().init___O__O(self$9, y$9);
    var this$31 = this.fr$undFR__Llocales_cldr_LDML();
    var self$10 = this$31.toLocale__ju_Locale().toLanguageTag__T();
    var y$10 = this.fr$undFR__Llocales_cldr_LDML();
    var jsx$8 = new $c_T2().init___O__O(self$10, y$10);
    var this$34 = this.de$undDE__Llocales_cldr_LDML();
    var self$11 = this$34.toLocale__ju_Locale().toLanguageTag__T();
    var y$11 = this.de$undDE__Llocales_cldr_LDML();
    var jsx$7 = new $c_T2().init___O__O(self$11, y$11);
    var this$37 = this.it$undIT__Llocales_cldr_LDML();
    var self$12 = this$37.toLocale__ju_Locale().toLanguageTag__T();
    var y$12 = this.it$undIT__Llocales_cldr_LDML();
    var jsx$6 = new $c_T2().init___O__O(self$12, y$12);
    var this$40 = this.ja$undJP__Llocales_cldr_LDML();
    var self$13 = this$40.toLocale__ju_Locale().toLanguageTag__T();
    var y$13 = this.ja$undJP__Llocales_cldr_LDML();
    var jsx$5 = new $c_T2().init___O__O(self$13, y$13);
    var this$43 = this.ko$undKR__Llocales_cldr_LDML();
    var self$14 = this$43.toLocale__ju_Locale().toLanguageTag__T();
    var y$14 = this.ko$undKR__Llocales_cldr_LDML();
    var jsx$4 = new $c_T2().init___O__O(self$14, y$14);
    var this$46 = this.en$undGB__Llocales_cldr_LDML();
    var self$15 = this$46.toLocale__ju_Locale().toLanguageTag__T();
    var y$15 = this.en$undGB__Llocales_cldr_LDML();
    var jsx$3 = new $c_T2().init___O__O(self$15, y$15);
    var this$49 = this.en$undUS__Llocales_cldr_LDML();
    var self$16 = this$49.toLocale__ju_Locale().toLanguageTag__T();
    var y$16 = this.en$undUS__Llocales_cldr_LDML();
    var jsx$2 = new $c_T2().init___O__O(self$16, y$16);
    var this$52 = this.en$undCA__Llocales_cldr_LDML();
    var self$17 = this$52.toLocale__ju_Locale().toLanguageTag__T();
    var y$17 = this.en$undCA__Llocales_cldr_LDML();
    var jsx$1 = new $c_T2().init___O__O(self$17, y$17);
    var this$55 = this.fr$undCA__Llocales_cldr_LDML();
    var self$18 = this$55.toLocale__ju_Locale().toLanguageTag__T();
    var y$18 = this.fr$undCA__Llocales_cldr_LDML();
    var array = [jsx$18, jsx$17, jsx$16, jsx$15, jsx$14, jsx$13, jsx$12, jsx$11, jsx$10, jsx$9, jsx$8, jsx$7, jsx$6, jsx$5, jsx$4, jsx$3, jsx$2, jsx$1, new $c_T2().init___O__O(self$18, y$18)];
    var this$60 = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
    var i = 0;
    var len = $uI(array.length);
    while ((i < len)) {
      var index = i;
      var arg1 = array[index];
      this$60.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1));
      i = ((1 + i) | 0)
    };
    this.defaultLocales$1 = $as_sc_Map(this$60.elems$1);
    this.bitmap$0$1 = (524288 | this.bitmap$0$1)
  };
  return this.defaultLocales$1
});
$c_Llocales_LocaleRegistry$.prototype.installLocale__Llocales_cldr_LDML__V = (function(ldml) {
  var jsx$1 = this.ldmls__p1__scm_Map();
  var self = ldml.toLocale__ju_Locale().toLanguageTag__T();
  jsx$1.$$plus$eq__T2__scm_MapLike(new $c_T2().init___O__O(self, ldml))
});
$c_Llocales_LocaleRegistry$.prototype.zh__Llocales_cldr_LDML = (function() {
  return (((64 & this.bitmap$0$1) === 0) ? this.zh$lzycompute__p1__Llocales_cldr_LDML() : this.zh$1)
});
$c_Llocales_LocaleRegistry$.prototype.root__Llocales_cldr_LDML = (function() {
  return (((262144 & this.bitmap$0$1) === 0) ? this.root$lzycompute__p1__Llocales_cldr_LDML() : this.root$1)
});
$c_Llocales_LocaleRegistry$.prototype.zh$undHans$undCN$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((128 & this.bitmap$0$1) === 0)) {
    var x$6 = $m_s_None$();
    var this$1 = $m_Llocales_cldr_data_zh$undHans$undCN$().locale$1;
    var x$7 = this$1.language$1;
    var this$2 = $m_Llocales_cldr_data_zh$undHans$undCN$().locale$1;
    var x$8 = this$2.territory$1;
    var this$3 = $m_Llocales_cldr_data_zh$undHans$undCN$().locale$1;
    var x$9 = this$3.variant$1;
    $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$10 = new $c_Llocales_cldr_LDMLLocale().init___T__s_Option__s_Option__s_Option(x$7, x$8, x$9, x$6);
    var this$5 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$11 = this$5.parent$1;
    var this$6 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$12 = this$6.defaultNS$1;
    var this$7 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$13 = this$7.digitSymbols$1;
    var this$8 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$14 = this$8.calendarSymbols$1;
    var this$9 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$15 = this$9.calendarPatterns$1;
    var this$10 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$16 = this$10.currencies$1;
    var this$11 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$17 = this$11.numberPatterns$1;
    $m_Llocales_cldr_data_zh$undHans$undCN$();
    this.zh$undHans$undCN$1 = new $c_Llocales_cldr_LDML().init___s_Option__Llocales_cldr_LDMLLocale__s_Option__sci_List__s_Option__s_Option__sci_List__Llocales_cldr_NumberPatterns(x$11, x$10, x$12, x$13, x$14, x$15, x$16, x$17);
    this.bitmap$0$1 = (128 | this.bitmap$0$1)
  };
  return this.zh$undHans$undCN$1
});
$c_Llocales_LocaleRegistry$.prototype.de__Llocales_cldr_LDML = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.de$lzycompute__p1__Llocales_cldr_LDML() : this.de$1)
});
$c_Llocales_LocaleRegistry$.prototype.en$undUS$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((32768 & this.bitmap$0$1) === 0)) {
    this.en$undUS$1 = $m_Llocales_cldr_data_en$undUS$();
    this.bitmap$0$1 = (32768 | this.bitmap$0$1)
  };
  return this.en$undUS$1
});
$c_Llocales_LocaleRegistry$.prototype.fr$undCA__Llocales_cldr_LDML = (function() {
  return (((131072 & this.bitmap$0$1) === 0) ? this.fr$undCA$lzycompute__p1__Llocales_cldr_LDML() : this.fr$undCA$1)
});
$c_Llocales_LocaleRegistry$.prototype.defaultLocales__p1__sc_Map = (function() {
  return (((524288 & this.bitmap$0$1) === 0) ? this.defaultLocales$lzycompute__p1__sc_Map() : this.defaultLocales$1)
});
$c_Llocales_LocaleRegistry$.prototype.en$undCA__Llocales_cldr_LDML = (function() {
  return (((65536 & this.bitmap$0$1) === 0) ? this.en$undCA$lzycompute__p1__Llocales_cldr_LDML() : this.en$undCA$1)
});
$c_Llocales_LocaleRegistry$.prototype.ldmls__p1__scm_Map = (function() {
  return (((1048576 & this.bitmap$0$1) === 0) ? this.ldmls$lzycompute__p1__scm_Map() : this.ldmls$1)
});
$c_Llocales_LocaleRegistry$.prototype.ja$undJP$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((4096 & this.bitmap$0$1) === 0)) {
    this.ja$undJP$1 = $m_Llocales_cldr_data_ja$undJP$();
    this.bitmap$0$1 = (4096 | this.bitmap$0$1)
  };
  return this.ja$undJP$1
});
$c_Llocales_LocaleRegistry$.prototype.fr$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.fr$1 = $m_Llocales_cldr_data_fr$();
    this.bitmap$0$1 = (2 | this.bitmap$0$1)
  };
  return this.fr$1
});
$c_Llocales_LocaleRegistry$.prototype.setDefault__ju_Locale__V = (function(newLocale) {
  if ((newLocale === null)) {
    throw new $c_jl_NullPointerException().init___T("Argument cannot be null")
  };
  this.defaultLocale$1 = newLocale;
  var this$1 = $m_ju_Locale$Category$();
  var xs = this$1.categories__p1__Aju_Locale$Category();
  var elems$2 = null;
  elems$2 = [];
  var x1 = xs.u.length;
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var x$3 = $as_ju_Locale$Category(arg1);
    var y = new $c_s_Some().init___O(newLocale);
    var elem = new $c_T2().init___O__O(x$3, y);
    elems$2.push(elem);
    i = ((1 + i) | 0)
  };
  var xs$1 = $makeNativeArrayWrapper($d_T2.getArrayOf(), elems$2);
  var b = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  var i$1 = 0;
  var len$1 = xs$1.u.length;
  while ((i$1 < len$1)) {
    var index$1 = i$1;
    var arg1$1 = xs$1.get(index$1);
    b.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1$1));
    i$1 = ((1 + i$1) | 0)
  };
  this.defaultPerCategory$1 = $as_sci_Map(b.elems$1)
});
$c_Llocales_LocaleRegistry$.prototype.it$undIT__Llocales_cldr_LDML = (function() {
  return (((2048 & this.bitmap$0$1) === 0) ? this.it$undIT$lzycompute__p1__Llocales_cldr_LDML() : this.it$undIT$1)
});
$c_Llocales_LocaleRegistry$.prototype.fr$undFR__Llocales_cldr_LDML = (function() {
  return (((512 & this.bitmap$0$1) === 0) ? this.fr$undFR$lzycompute__p1__Llocales_cldr_LDML() : this.fr$undFR$1)
});
$c_Llocales_LocaleRegistry$.prototype.ldmls$lzycompute__p1__scm_Map = (function() {
  if (((1048576 & this.bitmap$0$1) === 0)) {
    this.ldmls$1 = new $c_scm_HashMap().init___();
    this.bitmap$0$1 = (1048576 | this.bitmap$0$1)
  };
  return this.ldmls$1
});
$c_Llocales_LocaleRegistry$.prototype.ja__Llocales_cldr_LDML = (function() {
  return (((16 & this.bitmap$0$1) === 0) ? this.ja$lzycompute__p1__Llocales_cldr_LDML() : this.ja$1)
});
$c_Llocales_LocaleRegistry$.prototype.en$undGB$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((16384 & this.bitmap$0$1) === 0)) {
    this.en$undGB$1 = $m_Llocales_cldr_data_en$undGB$();
    this.bitmap$0$1 = (16384 | this.bitmap$0$1)
  };
  return this.en$undGB$1
});
$c_Llocales_LocaleRegistry$.prototype.it$undIT$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((2048 & this.bitmap$0$1) === 0)) {
    this.it$undIT$1 = $m_Llocales_cldr_data_it$undIT$();
    this.bitmap$0$1 = (2048 | this.bitmap$0$1)
  };
  return this.it$undIT$1
});
$c_Llocales_LocaleRegistry$.prototype.de$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.de$1 = $m_Llocales_cldr_data_de$();
    this.bitmap$0$1 = (4 | this.bitmap$0$1)
  };
  return this.de$1
});
$c_Llocales_LocaleRegistry$.prototype.ko$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((32 & this.bitmap$0$1) === 0)) {
    this.ko$1 = $m_Llocales_cldr_data_ko$();
    this.bitmap$0$1 = (32 | this.bitmap$0$1)
  };
  return this.ko$1
});
$c_Llocales_LocaleRegistry$.prototype.zh$undHant$undTW$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((256 & this.bitmap$0$1) === 0)) {
    var x$18 = $m_s_None$();
    var this$1 = $m_Llocales_cldr_data_zh$undHant$undTW$().locale$1;
    var x$19 = this$1.language$1;
    var this$2 = $m_Llocales_cldr_data_zh$undHant$undTW$().locale$1;
    var x$20 = this$2.territory$1;
    var this$3 = $m_Llocales_cldr_data_zh$undHant$undTW$().locale$1;
    var x$21 = this$3.variant$1;
    $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$22 = new $c_Llocales_cldr_LDMLLocale().init___T__s_Option__s_Option__s_Option(x$19, x$20, x$21, x$18);
    var this$5 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$23 = this$5.parent$1;
    var this$6 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$24 = this$6.defaultNS$1;
    var this$7 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$25 = this$7.digitSymbols$1;
    var this$8 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$26 = this$8.calendarSymbols$1;
    var this$9 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$27 = this$9.calendarPatterns$1;
    var this$10 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$28 = this$10.currencies$1;
    var this$11 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$29 = this$11.numberPatterns$1;
    $m_Llocales_cldr_data_zh$undHant$undTW$();
    this.zh$undHant$undTW$1 = new $c_Llocales_cldr_LDML().init___s_Option__Llocales_cldr_LDMLLocale__s_Option__sci_List__s_Option__s_Option__sci_List__Llocales_cldr_NumberPatterns(x$23, x$22, x$24, x$25, x$26, x$27, x$28, x$29);
    this.bitmap$0$1 = (256 | this.bitmap$0$1)
  };
  return this.zh$undHant$undTW$1
});
$c_Llocales_LocaleRegistry$.prototype.fr__Llocales_cldr_LDML = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.fr$lzycompute__p1__Llocales_cldr_LDML() : this.fr$1)
});
$c_Llocales_LocaleRegistry$.prototype.root$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((262144 & this.bitmap$0$1) === 0)) {
    this.root$1 = $m_Llocales_cldr_data_root$();
    this.bitmap$0$1 = (262144 | this.bitmap$0$1)
  };
  return this.root$1
});
$c_Llocales_LocaleRegistry$.prototype.en$undGB__Llocales_cldr_LDML = (function() {
  return (((16384 & this.bitmap$0$1) === 0) ? this.en$undGB$lzycompute__p1__Llocales_cldr_LDML() : this.en$undGB$1)
});
$c_Llocales_LocaleRegistry$.prototype.ko__Llocales_cldr_LDML = (function() {
  return (((32 & this.bitmap$0$1) === 0) ? this.ko$lzycompute__p1__Llocales_cldr_LDML() : this.ko$1)
});
$c_Llocales_LocaleRegistry$.prototype.en__Llocales_cldr_LDML = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.en$lzycompute__p1__Llocales_cldr_LDML() : this.en$1)
});
$c_Llocales_LocaleRegistry$.prototype.ja$undJP__Llocales_cldr_LDML = (function() {
  return (((4096 & this.bitmap$0$1) === 0) ? this.ja$undJP$lzycompute__p1__Llocales_cldr_LDML() : this.ja$undJP$1)
});
$c_Llocales_LocaleRegistry$.prototype.ko$undKR$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((8192 & this.bitmap$0$1) === 0)) {
    this.ko$undKR$1 = $m_Llocales_cldr_data_ko$undKR$();
    this.bitmap$0$1 = (8192 | this.bitmap$0$1)
  };
  return this.ko$undKR$1
});
$c_Llocales_LocaleRegistry$.prototype.it__Llocales_cldr_LDML = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.it$lzycompute__p1__Llocales_cldr_LDML() : this.it$1)
});
$c_Llocales_LocaleRegistry$.prototype.de$undDE$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((1024 & this.bitmap$0$1) === 0)) {
    this.de$undDE$1 = $m_Llocales_cldr_data_de$undDE$();
    this.bitmap$0$1 = (1024 | this.bitmap$0$1)
  };
  return this.de$undDE$1
});
$c_Llocales_LocaleRegistry$.prototype.en$undCA$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((65536 & this.bitmap$0$1) === 0)) {
    this.en$undCA$1 = $m_Llocales_cldr_data_en$undCA$();
    this.bitmap$0$1 = (65536 | this.bitmap$0$1)
  };
  return this.en$undCA$1
});
$c_Llocales_LocaleRegistry$.prototype.initDefaultLocales__p1__V = (function() {
  this.defaultLocales__p1__sc_Map().foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$1$2) {
      var x0$1 = $as_T2(x0$1$2);
      if ((x0$1 !== null)) {
        var l = $as_Llocales_cldr_LDML(x0$1.$$und2__O());
        $this.installLocale__Llocales_cldr_LDML__V(l)
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })(this)))
});
$c_Llocales_LocaleRegistry$.prototype.zh$undHans$undCN__Llocales_cldr_LDML = (function() {
  return (((128 & this.bitmap$0$1) === 0) ? this.zh$undHans$undCN$lzycompute__p1__Llocales_cldr_LDML() : this.zh$undHans$undCN$1)
});
$c_Llocales_LocaleRegistry$.prototype.ja$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((16 & this.bitmap$0$1) === 0)) {
    this.ja$1 = $m_Llocales_cldr_data_ja$();
    this.bitmap$0$1 = (16 | this.bitmap$0$1)
  };
  return this.ja$1
});
$c_Llocales_LocaleRegistry$.prototype.de$undDE__Llocales_cldr_LDML = (function() {
  return (((1024 & this.bitmap$0$1) === 0) ? this.de$undDE$lzycompute__p1__Llocales_cldr_LDML() : this.de$undDE$1)
});
$c_Llocales_LocaleRegistry$.prototype.it$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    this.it$1 = $m_Llocales_cldr_data_it$();
    this.bitmap$0$1 = (8 | this.bitmap$0$1)
  };
  return this.it$1
});
$c_Llocales_LocaleRegistry$.prototype.zh$undHant$undTW__Llocales_cldr_LDML = (function() {
  return (((256 & this.bitmap$0$1) === 0) ? this.zh$undHant$undTW$lzycompute__p1__Llocales_cldr_LDML() : this.zh$undHant$undTW$1)
});
$c_Llocales_LocaleRegistry$.prototype.fr$undCA$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((131072 & this.bitmap$0$1) === 0)) {
    this.fr$undCA$1 = $m_Llocales_cldr_data_fr$undCA$();
    this.bitmap$0$1 = (131072 | this.bitmap$0$1)
  };
  return this.fr$undCA$1
});
var $d_Llocales_LocaleRegistry$ = new $TypeData().initClass({
  Llocales_LocaleRegistry$: 0
}, false, "locales.LocaleRegistry$", {
  Llocales_LocaleRegistry$: 1,
  O: 1
});
$c_Llocales_LocaleRegistry$.prototype.$classData = $d_Llocales_LocaleRegistry$;
var $n_Llocales_LocaleRegistry$ = (void 0);
function $m_Llocales_LocaleRegistry$() {
  if ((!$n_Llocales_LocaleRegistry$)) {
    $n_Llocales_LocaleRegistry$ = new $c_Llocales_LocaleRegistry$().init___()
  };
  return $n_Llocales_LocaleRegistry$
}
/** @constructor */
function $c_Llocales_cldr_data_numericsystems$() {
  $c_O.call(this);
  this.adlm$1 = null;
  this.ahom$1 = null;
  this.arab$1 = null;
  this.arabext$1 = null;
  this.bali$1 = null;
  this.beng$1 = null;
  this.bhks$1 = null;
  this.brah$1 = null;
  this.cakm$1 = null;
  this.cham$1 = null;
  this.deva$1 = null;
  this.fullwide$1 = null;
  this.gujr$1 = null;
  this.guru$1 = null;
  this.hanidec$1 = null;
  this.hmng$1 = null;
  this.java$1 = null;
  this.kali$1 = null;
  this.khmr$1 = null;
  this.knda$1 = null;
  this.lana$1 = null;
  this.lanatham$1 = null;
  this.laoo$1 = null;
  this.latn$1 = null;
  this.lepc$1 = null;
  this.limb$1 = null;
  this.mathbold$1 = null;
  this.mathdbl$1 = null;
  this.mathmono$1 = null;
  this.mathsanb$1 = null;
  this.mathsans$1 = null;
  this.mlym$1 = null;
  this.modi$1 = null;
  this.mong$1 = null;
  this.mroo$1 = null;
  this.mtei$1 = null;
  this.mymr$1 = null;
  this.mymrshan$1 = null;
  this.mymrtlng$1 = null;
  this.newa$1 = null;
  this.nkoo$1 = null;
  this.olck$1 = null;
  this.orya$1 = null;
  this.osma$1 = null;
  this.saur$1 = null;
  this.shrd$1 = null;
  this.sind$1 = null;
  this.sinh$1 = null;
  this.sora$1 = null;
  this.sund$1 = null;
  this.takr$1 = null;
  this.talu$1 = null;
  this.tamldec$1 = null;
  this.telu$1 = null;
  this.thai$1 = null;
  this.tibt$1 = null;
  this.tirh$1 = null;
  this.vaii$1 = null;
  this.wara$1 = null;
  this.bitmap$0$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_Llocales_cldr_data_numericsystems$.prototype = new $h_O();
$c_Llocales_cldr_data_numericsystems$.prototype.constructor = $c_Llocales_cldr_data_numericsystems$;
/** @constructor */
function $h_Llocales_cldr_data_numericsystems$() {
  /*<skip>*/
}
$h_Llocales_cldr_data_numericsystems$.prototype = $c_Llocales_cldr_data_numericsystems$.prototype;
$c_Llocales_cldr_data_numericsystems$.prototype.cham__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (512 & b.lo$2);
  if ((lo === 0)) {
    return this.cham$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.cham$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.lepc__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16777216 & b.lo$2);
  if ((lo === 0)) {
    return this.lepc$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.lepc$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.fullwide$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (2048 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(65296), new $c_jl_Character().init___C(65297), new $c_jl_Character().init___C(65298), new $c_jl_Character().init___C(65299), new $c_jl_Character().init___C(65300), new $c_jl_Character().init___C(65301), new $c_jl_Character().init___C(65302), new $c_jl_Character().init___C(65303), new $c_jl_Character().init___C(65304), new $c_jl_Character().init___C(65305)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.fullwide$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("fullwide", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (2048 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.fullwide$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.arabext__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8 & b.lo$2);
  if ((lo === 0)) {
    return this.arabext$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.arabext$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.khmr$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (262144 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6112), new $c_jl_Character().init___C(6113), new $c_jl_Character().init___C(6114), new $c_jl_Character().init___C(6115), new $c_jl_Character().init___C(6116), new $c_jl_Character().init___C(6117), new $c_jl_Character().init___C(6118), new $c_jl_Character().init___C(6119), new $c_jl_Character().init___C(6120), new $c_jl_Character().init___C(6121)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.khmr$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("khmr", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (262144 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.khmr$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.lanatham$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (2097152 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6800), new $c_jl_Character().init___C(6801), new $c_jl_Character().init___C(6802), new $c_jl_Character().init___C(6803), new $c_jl_Character().init___C(6804), new $c_jl_Character().init___C(6805), new $c_jl_Character().init___C(6806), new $c_jl_Character().init___C(6807), new $c_jl_Character().init___C(6808), new $c_jl_Character().init___C(6809)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.lanatham$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("lanatham", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (2097152 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.lanatham$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.init___ = (function() {
  return this
});
$c_Llocales_cldr_data_numericsystems$.prototype.orya$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (1024 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2918), new $c_jl_Character().init___C(2919), new $c_jl_Character().init___C(2920), new $c_jl_Character().init___C(2921), new $c_jl_Character().init___C(2922), new $c_jl_Character().init___C(2923), new $c_jl_Character().init___C(2924), new $c_jl_Character().init___C(2925), new $c_jl_Character().init___C(2926), new $c_jl_Character().init___C(2927)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.orya$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("orya", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (1024 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.orya$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.sora__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (65536 & b.hi$2);
  if ((hi === 0)) {
    return this.sora$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.sora$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.deva__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (1024 & b.lo$2);
  if ((lo === 0)) {
    return this.deva$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.deva$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.tamldec$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (1048576 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3046), new $c_jl_Character().init___C(3047), new $c_jl_Character().init___C(3048), new $c_jl_Character().init___C(3049), new $c_jl_Character().init___C(3050), new $c_jl_Character().init___C(3051), new $c_jl_Character().init___C(3052), new $c_jl_Character().init___C(3053), new $c_jl_Character().init___C(3054), new $c_jl_Character().init___C(3055)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.tamldec$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("tamldec", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (1048576 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.tamldec$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.laoo$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4194304 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3792), new $c_jl_Character().init___C(3793), new $c_jl_Character().init___C(3794), new $c_jl_Character().init___C(3795), new $c_jl_Character().init___C(3796), new $c_jl_Character().init___C(3797), new $c_jl_Character().init___C(3798), new $c_jl_Character().init___C(3799), new $c_jl_Character().init___C(3800), new $c_jl_Character().init___C(3801)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.laoo$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("laoo", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (4194304 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.laoo$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mymr$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (16 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(4160), new $c_jl_Character().init___C(4161), new $c_jl_Character().init___C(4162), new $c_jl_Character().init___C(4163), new $c_jl_Character().init___C(4164), new $c_jl_Character().init___C(4165), new $c_jl_Character().init___C(4166), new $c_jl_Character().init___C(4167), new $c_jl_Character().init___C(4168), new $c_jl_Character().init___C(4169)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mymr$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mymr", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (16 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.mymr$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.sund$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (131072 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(7088), new $c_jl_Character().init___C(7089), new $c_jl_Character().init___C(7090), new $c_jl_Character().init___C(7091), new $c_jl_Character().init___C(7092), new $c_jl_Character().init___C(7093), new $c_jl_Character().init___C(7094), new $c_jl_Character().init___C(7095), new $c_jl_Character().init___C(7096), new $c_jl_Character().init___C(7097)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.sund$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("sund", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (131072 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.sund$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.orya__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (1024 & b.hi$2);
  if ((hi === 0)) {
    return this.orya$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.orya$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.knda__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (524288 & b.lo$2);
  if ((lo === 0)) {
    return this.knda$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.knda$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.laoo__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4194304 & b.lo$2);
  if ((lo === 0)) {
    return this.laoo$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.laoo$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.bali__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16 & b.lo$2);
  if ((lo === 0)) {
    return this.bali$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.bali$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.gujr__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4096 & b.lo$2);
  if ((lo === 0)) {
    return this.gujr$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.gujr$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.guru__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8192 & b.lo$2);
  if ((lo === 0)) {
    return this.guru$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.guru$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.saur__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (4096 & b.hi$2);
  if ((hi === 0)) {
    return this.saur$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.saur$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.thai__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (4194304 & b.hi$2);
  if ((hi === 0)) {
    return this.thai$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.thai$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.gujr$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4096 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2790), new $c_jl_Character().init___C(2791), new $c_jl_Character().init___C(2792), new $c_jl_Character().init___C(2793), new $c_jl_Character().init___C(2794), new $c_jl_Character().init___C(2795), new $c_jl_Character().init___C(2796), new $c_jl_Character().init___C(2797), new $c_jl_Character().init___C(2798), new $c_jl_Character().init___C(2799)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.gujr$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("gujr", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (4096 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.gujr$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.lanatham__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (2097152 & b.lo$2);
  if ((lo === 0)) {
    return this.lanatham$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.lanatham$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.brah$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (128 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.brah$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("brah", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (128 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.brah$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.saur$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (4096 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(43216), new $c_jl_Character().init___C(43217), new $c_jl_Character().init___C(43218), new $c_jl_Character().init___C(43219), new $c_jl_Character().init___C(43220), new $c_jl_Character().init___C(43221), new $c_jl_Character().init___C(43222), new $c_jl_Character().init___C(43223), new $c_jl_Character().init___C(43224), new $c_jl_Character().init___C(43225)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.saur$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("saur", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (4096 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.saur$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.osma__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2048 & b.hi$2);
  if ((hi === 0)) {
    return this.osma$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.osma$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.beng$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (32 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2534), new $c_jl_Character().init___C(2535), new $c_jl_Character().init___C(2536), new $c_jl_Character().init___C(2537), new $c_jl_Character().init___C(2538), new $c_jl_Character().init___C(2539), new $c_jl_Character().init___C(2540), new $c_jl_Character().init___C(2541), new $c_jl_Character().init___C(2542), new $c_jl_Character().init___C(2543)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.beng$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("beng", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (32 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.beng$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.cakm__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (256 & b.lo$2);
  if ((lo === 0)) {
    return this.cakm$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.cakm$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.knda$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (524288 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3302), new $c_jl_Character().init___C(3303), new $c_jl_Character().init___C(3304), new $c_jl_Character().init___C(3305), new $c_jl_Character().init___C(3306), new $c_jl_Character().init___C(3307), new $c_jl_Character().init___C(3308), new $c_jl_Character().init___C(3309), new $c_jl_Character().init___C(3310), new $c_jl_Character().init___C(3311)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.knda$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("knda", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (524288 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.knda$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.arabext$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(1776), new $c_jl_Character().init___C(1777), new $c_jl_Character().init___C(1778), new $c_jl_Character().init___C(1779), new $c_jl_Character().init___C(1780), new $c_jl_Character().init___C(1781), new $c_jl_Character().init___C(1782), new $c_jl_Character().init___C(1783), new $c_jl_Character().init___C(1784), new $c_jl_Character().init___C(1785)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.arabext$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("arabext", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (8 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.arabext$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.latn$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8388608 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(48), new $c_jl_Character().init___C(49), new $c_jl_Character().init___C(50), new $c_jl_Character().init___C(51), new $c_jl_Character().init___C(52), new $c_jl_Character().init___C(53), new $c_jl_Character().init___C(54), new $c_jl_Character().init___C(55), new $c_jl_Character().init___C(56), new $c_jl_Character().init___C(57)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.latn$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("latn", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (8388608 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.latn$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.osma$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2048 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.osma$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("osma", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (2048 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.osma$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.lepc$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16777216 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(7232), new $c_jl_Character().init___C(7233), new $c_jl_Character().init___C(7234), new $c_jl_Character().init___C(7235), new $c_jl_Character().init___C(7236), new $c_jl_Character().init___C(7237), new $c_jl_Character().init___C(7238), new $c_jl_Character().init___C(7239), new $c_jl_Character().init___C(7240), new $c_jl_Character().init___C(7241)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.lepc$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("lepc", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (16777216 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.lepc$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.sund__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (131072 & b.hi$2);
  if ((hi === 0)) {
    return this.sund$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.sund$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.guru$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8192 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2662), new $c_jl_Character().init___C(2663), new $c_jl_Character().init___C(2664), new $c_jl_Character().init___C(2665), new $c_jl_Character().init___C(2666), new $c_jl_Character().init___C(2667), new $c_jl_Character().init___C(2668), new $c_jl_Character().init___C(2669), new $c_jl_Character().init___C(2670), new $c_jl_Character().init___C(2671)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.guru$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("guru", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (8192 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.guru$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.tibt__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8388608 & b.hi$2);
  if ((hi === 0)) {
    return this.tibt$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.tibt$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mymrshan__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (32 & b.hi$2);
  if ((hi === 0)) {
    return this.mymrshan$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mymrshan$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.telu$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2097152 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3174), new $c_jl_Character().init___C(3175), new $c_jl_Character().init___C(3176), new $c_jl_Character().init___C(3177), new $c_jl_Character().init___C(3178), new $c_jl_Character().init___C(3179), new $c_jl_Character().init___C(3180), new $c_jl_Character().init___C(3181), new $c_jl_Character().init___C(3182), new $c_jl_Character().init___C(3183)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.telu$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("telu", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (2097152 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.telu$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.lana__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (1048576 & b.lo$2);
  if ((lo === 0)) {
    return this.lana$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.lana$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.java__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (65536 & b.lo$2);
  if ((lo === 0)) {
    return this.java$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.java$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.shrd__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8192 & b.hi$2);
  if ((hi === 0)) {
    return this.shrd$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.shrd$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.sora$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (65536 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.sora$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("sora", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (65536 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.sora$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.cham$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (512 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(43600), new $c_jl_Character().init___C(43601), new $c_jl_Character().init___C(43602), new $c_jl_Character().init___C(43603), new $c_jl_Character().init___C(43604), new $c_jl_Character().init___C(43605), new $c_jl_Character().init___C(43606), new $c_jl_Character().init___C(43607), new $c_jl_Character().init___C(43608), new $c_jl_Character().init___C(43609)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.cham$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("cham", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (512 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.cham$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.arab$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(1632), new $c_jl_Character().init___C(1633), new $c_jl_Character().init___C(1634), new $c_jl_Character().init___C(1635), new $c_jl_Character().init___C(1636), new $c_jl_Character().init___C(1637), new $c_jl_Character().init___C(1638), new $c_jl_Character().init___C(1639), new $c_jl_Character().init___C(1640), new $c_jl_Character().init___C(1641)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.arab$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("arab", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (4 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.arab$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.kali$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (131072 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(43264), new $c_jl_Character().init___C(43265), new $c_jl_Character().init___C(43266), new $c_jl_Character().init___C(43267), new $c_jl_Character().init___C(43268), new $c_jl_Character().init___C(43269), new $c_jl_Character().init___C(43270), new $c_jl_Character().init___C(43271), new $c_jl_Character().init___C(43272), new $c_jl_Character().init___C(43273)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.kali$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("kali", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (131072 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.kali$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.vaii$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (33554432 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(42528), new $c_jl_Character().init___C(42529), new $c_jl_Character().init___C(42530), new $c_jl_Character().init___C(42531), new $c_jl_Character().init___C(42532), new $c_jl_Character().init___C(42533), new $c_jl_Character().init___C(42534), new $c_jl_Character().init___C(42535), new $c_jl_Character().init___C(42536), new $c_jl_Character().init___C(42537)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.vaii$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("vaii", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (33554432 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.vaii$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mlym$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = ((-2147483648) & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3430), new $c_jl_Character().init___C(3431), new $c_jl_Character().init___C(3432), new $c_jl_Character().init___C(3433), new $c_jl_Character().init___C(3434), new $c_jl_Character().init___C(3435), new $c_jl_Character().init___C(3436), new $c_jl_Character().init___C(3437), new $c_jl_Character().init___C(3438), new $c_jl_Character().init___C(3439)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mlym$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mlym", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = ((-2147483648) | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.mlym$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.tamldec__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (1048576 & b.hi$2);
  if ((hi === 0)) {
    return this.tamldec$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.tamldec$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.vaii__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (33554432 & b.hi$2);
  if ((hi === 0)) {
    return this.vaii$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.vaii$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.brah__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (128 & b.lo$2);
  if ((lo === 0)) {
    return this.brah$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.brah$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.thai$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (4194304 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3664), new $c_jl_Character().init___C(3665), new $c_jl_Character().init___C(3666), new $c_jl_Character().init___C(3667), new $c_jl_Character().init___C(3668), new $c_jl_Character().init___C(3669), new $c_jl_Character().init___C(3670), new $c_jl_Character().init___C(3671), new $c_jl_Character().init___C(3672), new $c_jl_Character().init___C(3673)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.thai$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("thai", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (4194304 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.thai$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mong$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6160), new $c_jl_Character().init___C(6161), new $c_jl_Character().init___C(6162), new $c_jl_Character().init___C(6163), new $c_jl_Character().init___C(6164), new $c_jl_Character().init___C(6165), new $c_jl_Character().init___C(6166), new $c_jl_Character().init___C(6167), new $c_jl_Character().init___C(6168), new $c_jl_Character().init___C(6169)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mong$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mong", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (2 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.mong$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.telu__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2097152 & b.hi$2);
  if ((hi === 0)) {
    return this.telu$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.telu$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.takr$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (262144 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.takr$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("takr", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (262144 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.takr$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.lana$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (1048576 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6784), new $c_jl_Character().init___C(6785), new $c_jl_Character().init___C(6786), new $c_jl_Character().init___C(6787), new $c_jl_Character().init___C(6788), new $c_jl_Character().init___C(6789), new $c_jl_Character().init___C(6790), new $c_jl_Character().init___C(6791), new $c_jl_Character().init___C(6792), new $c_jl_Character().init___C(6793)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.lana$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("lana", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (1048576 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.lana$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.nkoo__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (256 & b.hi$2);
  if ((hi === 0)) {
    return this.nkoo$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.nkoo$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mymr__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (16 & b.hi$2);
  if ((hi === 0)) {
    return this.mymr$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mymr$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.cakm$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (256 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.cakm$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("cakm", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (256 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.cakm$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mlym__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = ((-2147483648) & b.lo$2);
  if ((lo === 0)) {
    return this.mlym$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mlym$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.bali$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6992), new $c_jl_Character().init___C(6993), new $c_jl_Character().init___C(6994), new $c_jl_Character().init___C(6995), new $c_jl_Character().init___C(6996), new $c_jl_Character().init___C(6997), new $c_jl_Character().init___C(6998), new $c_jl_Character().init___C(6999), new $c_jl_Character().init___C(7000), new $c_jl_Character().init___C(7001)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.bali$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("bali", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (16 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.bali$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.talu__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (524288 & b.hi$2);
  if ((hi === 0)) {
    return this.talu$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.talu$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.hanidec$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16384 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(12295), new $c_jl_Character().init___C(19968), new $c_jl_Character().init___C(20108), new $c_jl_Character().init___C(19977), new $c_jl_Character().init___C(22235), new $c_jl_Character().init___C(20116), new $c_jl_Character().init___C(20845), new $c_jl_Character().init___C(19971), new $c_jl_Character().init___C(20843), new $c_jl_Character().init___C(20061)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.hanidec$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("hanidec", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (16384 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.hanidec$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.hanidec__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16384 & b.lo$2);
  if ((lo === 0)) {
    return this.hanidec$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.hanidec$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.arab__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4 & b.lo$2);
  if ((lo === 0)) {
    return this.arab$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.arab$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.beng__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (32 & b.lo$2);
  if ((lo === 0)) {
    return this.beng$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.beng$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.shrd$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8192 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.shrd$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("shrd", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (8192 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.shrd$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.olck__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (512 & b.hi$2);
  if ((hi === 0)) {
    return this.olck$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.olck$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.tibt$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8388608 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3872), new $c_jl_Character().init___C(3873), new $c_jl_Character().init___C(3874), new $c_jl_Character().init___C(3875), new $c_jl_Character().init___C(3876), new $c_jl_Character().init___C(3877), new $c_jl_Character().init___C(3878), new $c_jl_Character().init___C(3879), new $c_jl_Character().init___C(3880), new $c_jl_Character().init___C(3881)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.tibt$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("tibt", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (8388608 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.tibt$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.talu$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (524288 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6608), new $c_jl_Character().init___C(6609), new $c_jl_Character().init___C(6610), new $c_jl_Character().init___C(6611), new $c_jl_Character().init___C(6612), new $c_jl_Character().init___C(6613), new $c_jl_Character().init___C(6614), new $c_jl_Character().init___C(6615), new $c_jl_Character().init___C(6616), new $c_jl_Character().init___C(6617)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.talu$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("talu", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (524288 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.talu$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.takr__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (262144 & b.hi$2);
  if ((hi === 0)) {
    return this.takr$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.takr$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.java$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (65536 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(43472), new $c_jl_Character().init___C(43473), new $c_jl_Character().init___C(43474), new $c_jl_Character().init___C(43475), new $c_jl_Character().init___C(43476), new $c_jl_Character().init___C(43477), new $c_jl_Character().init___C(43478), new $c_jl_Character().init___C(43479), new $c_jl_Character().init___C(43480), new $c_jl_Character().init___C(43481)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.java$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("java", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (65536 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.java$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.deva$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (1024 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2406), new $c_jl_Character().init___C(2407), new $c_jl_Character().init___C(2408), new $c_jl_Character().init___C(2409), new $c_jl_Character().init___C(2410), new $c_jl_Character().init___C(2411), new $c_jl_Character().init___C(2412), new $c_jl_Character().init___C(2413), new $c_jl_Character().init___C(2414), new $c_jl_Character().init___C(2415)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.deva$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("deva", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (1024 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.deva$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.nkoo$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (256 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(1984), new $c_jl_Character().init___C(1985), new $c_jl_Character().init___C(1986), new $c_jl_Character().init___C(1987), new $c_jl_Character().init___C(1988), new $c_jl_Character().init___C(1989), new $c_jl_Character().init___C(1990), new $c_jl_Character().init___C(1991), new $c_jl_Character().init___C(1992), new $c_jl_Character().init___C(1993)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.nkoo$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("nkoo", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (256 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.nkoo$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.latn__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8388608 & b.lo$2);
  if ((lo === 0)) {
    return this.latn$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.latn$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mymrshan$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (32 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(4240), new $c_jl_Character().init___C(4241), new $c_jl_Character().init___C(4242), new $c_jl_Character().init___C(4243), new $c_jl_Character().init___C(4244), new $c_jl_Character().init___C(4245), new $c_jl_Character().init___C(4246), new $c_jl_Character().init___C(4247), new $c_jl_Character().init___C(4248), new $c_jl_Character().init___C(4249)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mymrshan$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mymrshan", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (32 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.mymrshan$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mtei__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8 & b.hi$2);
  if ((hi === 0)) {
    return this.mtei$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mtei$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.kali__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (131072 & b.lo$2);
  if ((lo === 0)) {
    return this.kali$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.kali$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.khmr__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (262144 & b.lo$2);
  if ((lo === 0)) {
    return this.khmr$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.khmr$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mong__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2 & b.hi$2);
  if ((hi === 0)) {
    return this.mong$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mong$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.fullwide__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (2048 & b.lo$2);
  if ((lo === 0)) {
    return this.fullwide$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.fullwide$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mtei$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(44016), new $c_jl_Character().init___C(44017), new $c_jl_Character().init___C(44018), new $c_jl_Character().init___C(44019), new $c_jl_Character().init___C(44020), new $c_jl_Character().init___C(44021), new $c_jl_Character().init___C(44022), new $c_jl_Character().init___C(44023), new $c_jl_Character().init___C(44024), new $c_jl_Character().init___C(44025)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mtei$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mtei", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (8 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.mtei$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.olck$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (512 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(7248), new $c_jl_Character().init___C(7249), new $c_jl_Character().init___C(7250), new $c_jl_Character().init___C(7251), new $c_jl_Character().init___C(7252), new $c_jl_Character().init___C(7253), new $c_jl_Character().init___C(7254), new $c_jl_Character().init___C(7255), new $c_jl_Character().init___C(7256), new $c_jl_Character().init___C(7257)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.olck$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("olck", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (512 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.olck$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.limb$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (33554432 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6470), new $c_jl_Character().init___C(6471), new $c_jl_Character().init___C(6472), new $c_jl_Character().init___C(6473), new $c_jl_Character().init___C(6474), new $c_jl_Character().init___C(6475), new $c_jl_Character().init___C(6476), new $c_jl_Character().init___C(6477), new $c_jl_Character().init___C(6478), new $c_jl_Character().init___C(6479)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.limb$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("limb", $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (33554432 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.limb$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.limb__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (33554432 & b.lo$2);
  if ((lo === 0)) {
    return this.limb$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.limb$1
  }
});
var $d_Llocales_cldr_data_numericsystems$ = new $TypeData().initClass({
  Llocales_cldr_data_numericsystems$: 0
}, false, "locales.cldr.data.numericsystems$", {
  Llocales_cldr_data_numericsystems$: 1,
  O: 1
});
$c_Llocales_cldr_data_numericsystems$.prototype.$classData = $d_Llocales_cldr_data_numericsystems$;
var $n_Llocales_cldr_data_numericsystems$ = (void 0);
function $m_Llocales_cldr_data_numericsystems$() {
  if ((!$n_Llocales_cldr_data_numericsystems$)) {
    $n_Llocales_cldr_data_numericsystems$ = new $c_Llocales_cldr_data_numericsystems$().init___()
  };
  return $n_Llocales_cldr_data_numericsystems$
}
/** @constructor */
function $c_Lorg_scalajs_dom_package$() {
  $c_O.call(this);
  this.ApplicationCache$1 = null;
  this.Blob$1 = null;
  this.BlobPropertyBag$1 = null;
  this.ClipboardEventInit$1 = null;
  this.DOMException$1 = null;
  this.Event$1 = null;
  this.EventException$1 = null;
  this.EventSource$1 = null;
  this.FileReader$1 = null;
  this.FormData$1 = null;
  this.KeyboardEvent$1 = null;
  this.MediaError$1 = null;
  this.MutationEvent$1 = null;
  this.MutationObserverInit$1 = null;
  this.Node$1 = null;
  this.NodeFilter$1 = null;
  this.PerformanceNavigation$1 = null;
  this.PositionError$1 = null;
  this.Range$1 = null;
  this.TextEvent$1 = null;
  this.TextTrack$1 = null;
  this.URL$1 = null;
  this.VisibilityState$1 = null;
  this.WebSocket$1 = null;
  this.WheelEvent$1 = null;
  this.XMLHttpRequest$1 = null;
  this.XPathResult$1 = null;
  this.window$1 = null;
  this.document$1 = null;
  this.console$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lorg_scalajs_dom_package$.prototype = new $h_O();
$c_Lorg_scalajs_dom_package$.prototype.constructor = $c_Lorg_scalajs_dom_package$;
/** @constructor */
function $h_Lorg_scalajs_dom_package$() {
  /*<skip>*/
}
$h_Lorg_scalajs_dom_package$.prototype = $c_Lorg_scalajs_dom_package$.prototype;
$c_Lorg_scalajs_dom_package$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_dom_package$.prototype.document__Lorg_scalajs_dom_raw_HTMLDocument = (function() {
  return (((268435456 & this.bitmap$0$1) === 0) ? this.document$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLDocument() : this.document$1)
});
$c_Lorg_scalajs_dom_package$.prototype.window__Lorg_scalajs_dom_raw_Window = (function() {
  return (((134217728 & this.bitmap$0$1) === 0) ? this.window$lzycompute__p1__Lorg_scalajs_dom_raw_Window() : this.window$1)
});
$c_Lorg_scalajs_dom_package$.prototype.window$lzycompute__p1__Lorg_scalajs_dom_raw_Window = (function() {
  if (((134217728 & this.bitmap$0$1) === 0)) {
    this.window$1 = $g.window;
    this.bitmap$0$1 = (134217728 | this.bitmap$0$1)
  };
  return this.window$1
});
$c_Lorg_scalajs_dom_package$.prototype.document$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLDocument = (function() {
  if (((268435456 & this.bitmap$0$1) === 0)) {
    this.document$1 = this.window__Lorg_scalajs_dom_raw_Window().document;
    this.bitmap$0$1 = (268435456 | this.bitmap$0$1)
  };
  return this.document$1
});
$c_Lorg_scalajs_dom_package$.prototype.WebSocket__Lorg_scalajs_dom_raw_WebSocket$ = (function() {
  return (((8388608 & this.bitmap$0$1) === 0) ? this.WebSocket$lzycompute__p1__Lorg_scalajs_dom_raw_WebSocket$() : this.WebSocket$1)
});
$c_Lorg_scalajs_dom_package$.prototype.WebSocket$lzycompute__p1__Lorg_scalajs_dom_raw_WebSocket$ = (function() {
  if (((8388608 & this.bitmap$0$1) === 0)) {
    this.WebSocket$1 = $g.WebSocket;
    this.bitmap$0$1 = (8388608 | this.bitmap$0$1)
  };
  return this.WebSocket$1
});
var $d_Lorg_scalajs_dom_package$ = new $TypeData().initClass({
  Lorg_scalajs_dom_package$: 0
}, false, "org.scalajs.dom.package$", {
  Lorg_scalajs_dom_package$: 1,
  O: 1
});
$c_Lorg_scalajs_dom_package$.prototype.$classData = $d_Lorg_scalajs_dom_package$;
var $n_Lorg_scalajs_dom_package$ = (void 0);
function $m_Lorg_scalajs_dom_package$() {
  if ((!$n_Lorg_scalajs_dom_package$)) {
    $n_Lorg_scalajs_dom_package$ = new $c_Lorg_scalajs_dom_package$().init___()
  };
  return $n_Lorg_scalajs_dom_package$
}
/** @constructor */
function $c_Lperfolation_CrossDate$() {
  $c_O.call(this);
  this.cache$1 = null
}
$c_Lperfolation_CrossDate$.prototype = new $h_O();
$c_Lperfolation_CrossDate$.prototype.constructor = $c_Lperfolation_CrossDate$;
/** @constructor */
function $h_Lperfolation_CrossDate$() {
  /*<skip>*/
}
$h_Lperfolation_CrossDate$.prototype = $c_Lperfolation_CrossDate$.prototype;
$c_Lperfolation_CrossDate$.prototype.init___ = (function() {
  $n_Lperfolation_CrossDate$ = this;
  this.cache$1 = new $c_jl_ThreadLocal().init___();
  return this
});
$c_Lperfolation_CrossDate$.prototype.apply__J__Lperfolation_CrossDate = (function(l) {
  var x1 = $m_s_Option$().apply__O__s_Option(this.cache$1.get__O());
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var d = $as_Lperfolation_CrossDate(x2.value$2);
    var t = d.milliseconds$1;
    var lo = t.lo$2;
    var hi = t.hi$2;
    if (((lo === l.lo$2) && (hi === l.hi$2))) {
      return d
    }
  };
  var d$2 = $m_Lperfolation_Platform$().createDate__J__Lperfolation_CrossDate(l);
  this.cache$1.set__O__V(d$2);
  return d$2
});
var $d_Lperfolation_CrossDate$ = new $TypeData().initClass({
  Lperfolation_CrossDate$: 0
}, false, "perfolation.CrossDate$", {
  Lperfolation_CrossDate$: 1,
  O: 1
});
$c_Lperfolation_CrossDate$.prototype.$classData = $d_Lperfolation_CrossDate$;
var $n_Lperfolation_CrossDate$ = (void 0);
function $m_Lperfolation_CrossDate$() {
  if ((!$n_Lperfolation_CrossDate$)) {
    $n_Lperfolation_CrossDate$ = new $c_Lperfolation_CrossDate$().init___()
  };
  return $n_Lperfolation_CrossDate$
}
/** @constructor */
function $c_Lperfolation_NumberFormatUtil$() {
  $c_O.call(this)
}
$c_Lperfolation_NumberFormatUtil$.prototype = new $h_O();
$c_Lperfolation_NumberFormatUtil$.prototype.constructor = $c_Lperfolation_NumberFormatUtil$;
/** @constructor */
function $h_Lperfolation_NumberFormatUtil$() {
  /*<skip>*/
}
$h_Lperfolation_NumberFormatUtil$.prototype = $c_Lperfolation_NumberFormatUtil$.prototype;
$c_Lperfolation_NumberFormatUtil$.prototype.init___ = (function() {
  return this
});
$c_Lperfolation_NumberFormatUtil$.prototype.$int__I__I__T = (function(i, digits) {
  var s = ("" + i);
  var padTo = ((digits - $uI(s.length)) | 0);
  if ((padTo <= 0)) {
    return s
  } else if ((padTo === 1)) {
    return ("0" + s)
  } else if ((padTo === 2)) {
    return ("00" + s)
  } else if ((padTo === 3)) {
    return ("000" + s)
  } else if ((padTo === 4)) {
    return ("0000" + s)
  } else if ((padTo === 5)) {
    return ("00000" + s)
  } else if ((padTo === 6)) {
    return ("000000" + s)
  } else if ((padTo === 7)) {
    return ("0000000" + s)
  } else if ((padTo === 8)) {
    return ("00000000" + s)
  } else if ((padTo === 9)) {
    return ("000000000" + s)
  } else {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T((("intFormat padding not available for " + digits) + "!")))
  }
});
var $d_Lperfolation_NumberFormatUtil$ = new $TypeData().initClass({
  Lperfolation_NumberFormatUtil$: 0
}, false, "perfolation.NumberFormatUtil$", {
  Lperfolation_NumberFormatUtil$: 1,
  O: 1
});
$c_Lperfolation_NumberFormatUtil$.prototype.$classData = $d_Lperfolation_NumberFormatUtil$;
var $n_Lperfolation_NumberFormatUtil$ = (void 0);
function $m_Lperfolation_NumberFormatUtil$() {
  if ((!$n_Lperfolation_NumberFormatUtil$)) {
    $n_Lperfolation_NumberFormatUtil$ = new $c_Lperfolation_NumberFormatUtil$().init___()
  };
  return $n_Lperfolation_NumberFormatUtil$
}
/** @constructor */
function $c_Lperfolation_Platform$() {
  $c_O.call(this);
  this.startOfYear$1 = null
}
$c_Lperfolation_Platform$.prototype = new $h_O();
$c_Lperfolation_Platform$.prototype.constructor = $c_Lperfolation_Platform$;
/** @constructor */
function $h_Lperfolation_Platform$() {
  /*<skip>*/
}
$h_Lperfolation_Platform$.prototype = $c_Lperfolation_Platform$.prototype;
$c_Lperfolation_Platform$.prototype.init___ = (function() {
  $n_Lperfolation_Platform$ = this;
  var newLocale = $m_ju_Locale$().US__ju_Locale();
  $m_Llocales_LocaleRegistry$().setDefault__ju_Locale__V(newLocale);
  this.startOfYear$1 = new $g.Date($uI(new $g.Date().getFullYear()), 0, 0);
  return this
});
$c_Lperfolation_Platform$.prototype.createDate__J__Lperfolation_CrossDate = (function(l) {
  return new $c_Lperfolation_JavaScriptCrossDate().init___J__sjs_js_Date(l, new $g.Date($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(l.lo$2, l.hi$2)))
});
var $d_Lperfolation_Platform$ = new $TypeData().initClass({
  Lperfolation_Platform$: 0
}, false, "perfolation.Platform$", {
  Lperfolation_Platform$: 1,
  O: 1
});
$c_Lperfolation_Platform$.prototype.$classData = $d_Lperfolation_Platform$;
var $n_Lperfolation_Platform$ = (void 0);
function $m_Lperfolation_Platform$() {
  if ((!$n_Lperfolation_Platform$)) {
    $n_Lperfolation_Platform$ = new $c_Lperfolation_Platform$().init___()
  };
  return $n_Lperfolation_Platform$
}
/** @constructor */
function $c_Lperfolation_package$() {
  $c_O.call(this);
  this.perfolation$package$$size$f = 0;
  this.pool$1 = null
}
$c_Lperfolation_package$.prototype = new $h_O();
$c_Lperfolation_package$.prototype.constructor = $c_Lperfolation_package$;
/** @constructor */
function $h_Lperfolation_package$() {
  /*<skip>*/
}
$h_Lperfolation_package$.prototype = $c_Lperfolation_package$.prototype;
$c_Lperfolation_package$.prototype.init___ = (function() {
  $n_Lperfolation_package$ = this;
  try {
    var this$3 = new $c_s_sys_SystemProperties().init___();
    var x1 = this$3.get__T__s_Option("perfolation.buffer.size");
    if ($is_s_Some(x1)) {
      var x2 = $as_s_Some(x1);
      var v = x2.value$2;
      var jsx$2 = v
    } else {
      var x = $m_s_None$();
      if ((!(x === x1))) {
        throw new $c_s_MatchError().init___O(x1)
      };
      var jsx$2 = ""
    };
    var x$1 = $as_T(jsx$2);
    var this$5 = new $c_sci_StringOps().init___T(x$1);
    var this$7 = $m_jl_Integer$();
    var $$this = this$5.repr$1;
    var jsx$1 = new $c_s_util_Success().init___O(this$7.parseInt__T__I__I($$this, 10))
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      matchEnd8: {
        var jsx$1;
        var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
        if ((!o11.isEmpty__Z())) {
          var e$3 = $as_jl_Throwable(o11.get__O());
          var jsx$1 = new $c_s_util_Failure().init___jl_Throwable(e$3);
          break matchEnd8
        };
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
      }
    } else {
      var jsx$1;
      throw e
    }
  };
  this.perfolation$package$$size$f = $uI(jsx$1.getOrElse__F0__O(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      return 16384
    })
  })(this))));
  this.pool$1 = new $c_Lperfolation_package$$anon$1().init___();
  return this
});
$c_Lperfolation_package$.prototype.stringBuilder__jl_StringBuilder = (function() {
  return $as_jl_StringBuilder(this.pool$1.get__O())
});
var $d_Lperfolation_package$ = new $TypeData().initClass({
  Lperfolation_package$: 0
}, false, "perfolation.package$", {
  Lperfolation_package$: 1,
  O: 1
});
$c_Lperfolation_package$.prototype.$classData = $d_Lperfolation_package$;
var $n_Lperfolation_package$ = (void 0);
function $m_Lperfolation_package$() {
  if ((!$n_Lperfolation_package$)) {
    $n_Lperfolation_package$ = new $c_Lperfolation_package$().init___()
  };
  return $n_Lperfolation_package$
}
/** @constructor */
function $c_Lprofig_Conversions$() {
  $c_O.call(this);
  this.booleanDecoder$1 = null
}
$c_Lprofig_Conversions$.prototype = new $h_O();
$c_Lprofig_Conversions$.prototype.constructor = $c_Lprofig_Conversions$;
/** @constructor */
function $h_Lprofig_Conversions$() {
  /*<skip>*/
}
$h_Lprofig_Conversions$.prototype = $c_Lprofig_Conversions$.prototype;
$c_Lprofig_Conversions$.prototype.init___ = (function() {
  $n_Lprofig_Conversions$ = this;
  this.booleanDecoder$1 = new $c_Lprofig_Conversions$$anon$1().init___();
  return this
});
var $d_Lprofig_Conversions$ = new $TypeData().initClass({
  Lprofig_Conversions$: 0
}, false, "profig.Conversions$", {
  Lprofig_Conversions$: 1,
  O: 1
});
$c_Lprofig_Conversions$.prototype.$classData = $d_Lprofig_Conversions$;
var $n_Lprofig_Conversions$ = (void 0);
function $m_Lprofig_Conversions$() {
  if ((!$n_Lprofig_Conversions$)) {
    $n_Lprofig_Conversions$ = new $c_Lprofig_Conversions$().init___()
  };
  return $n_Lprofig_Conversions$
}
/** @constructor */
function $c_Lprofig_JsonParser$() {
  $c_O.call(this);
  this.overrideParser$1 = null
}
$c_Lprofig_JsonParser$.prototype = new $h_O();
$c_Lprofig_JsonParser$.prototype.constructor = $c_Lprofig_JsonParser$;
/** @constructor */
function $h_Lprofig_JsonParser$() {
  /*<skip>*/
}
$h_Lprofig_JsonParser$.prototype = $c_Lprofig_JsonParser$.prototype;
$c_Lprofig_JsonParser$.prototype.init___ = (function() {
  $n_Lprofig_JsonParser$ = this;
  this.overrideParser$1 = $m_s_None$();
  return this
});
$c_Lprofig_JsonParser$.prototype.parse__T__s_util_Either = (function(jsonString) {
  var x1 = this.overrideParser$1;
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var parser = $as_F1(x2.value$2);
    return $as_s_util_Either(parser.apply__O__O(jsonString))
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var x1$2 = $m_Lio_circe_parser_package$().parse__T__s_util_Either(jsonString);
      if ($is_s_util_Left(x1$2)) {
        var x2$2 = $as_s_util_Left(x1$2);
        var exc = $as_Lio_circe_ParsingFailure(x2$2.value$2);
        if ((exc.message$4 === "an implementation is missing")) {
          new $c_Lio_circe_jawn_JawnParser().init___();
          $m_s_Predef$().$$qmark$qmark$qmark__sr_Nothing$()
        }
      };
      return x1$2
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
var $d_Lprofig_JsonParser$ = new $TypeData().initClass({
  Lprofig_JsonParser$: 0
}, false, "profig.JsonParser$", {
  Lprofig_JsonParser$: 1,
  O: 1
});
$c_Lprofig_JsonParser$.prototype.$classData = $d_Lprofig_JsonParser$;
var $n_Lprofig_JsonParser$ = (void 0);
function $m_Lprofig_JsonParser$() {
  if ((!$n_Lprofig_JsonParser$)) {
    $n_Lprofig_JsonParser$ = new $c_Lprofig_JsonParser$().init___()
  };
  return $n_Lprofig_JsonParser$
}
/** @constructor */
function $c_Lprofig_ProfigUtil$() {
  $c_O.call(this);
  this.NamedKeyValue$1 = null;
  this.NamedFlag$1 = null
}
$c_Lprofig_ProfigUtil$.prototype = new $h_O();
$c_Lprofig_ProfigUtil$.prototype.constructor = $c_Lprofig_ProfigUtil$;
/** @constructor */
function $h_Lprofig_ProfigUtil$() {
  /*<skip>*/
}
$h_Lprofig_ProfigUtil$.prototype = $c_Lprofig_ProfigUtil$.prototype;
$c_Lprofig_ProfigUtil$.prototype.init___ = (function() {
  $n_Lprofig_ProfigUtil$ = this;
  var this$2 = new $c_sci_StringOps().init___T("-{1,}(.+)=(.+)");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  this.NamedKeyValue$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames);
  var this$5 = new $c_sci_StringOps().init___T("-{1,}(.+)");
  var groupNames$1 = $m_sci_Nil$();
  var $$this$1 = this$5.repr$1;
  this.NamedFlag$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$1, groupNames$1);
  return this
});
$c_Lprofig_ProfigUtil$.prototype.map2Json__sci_Map__Lio_circe_Json = (function(map) {
  var this$1 = $m_Lio_circe_Json$();
  var fields = $m_sci_Nil$();
  var elem = this$1.fromFields__sc_Iterable__Lio_circe_Json(fields);
  var json = new $c_sr_ObjectRef().init___O(elem);
  map.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, json$1) {
    return (function(x0$1$2) {
      var x0$1 = $as_T2(x0$1$2);
      if ((x0$1 !== null)) {
        var key = $as_T(x0$1.$$und1__O());
        var value = $as_T(x0$1.$$und2__O());
        json$1.elem$1 = $as_Lio_circe_Json(json$1.elem$1).deepMerge__Lio_circe_Json__Lio_circe_Json($m_Lprofig_ProfigUtil$().createJson__T__Lio_circe_Json__Lio_circe_Json(key, ($m_Lprofig_ProfigUtil$(), $m_Lio_circe_Json$(), new $c_Lio_circe_Json$JString().init___T(value))))
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })(this, json)));
  return $as_Lio_circe_Json(json.elem$1)
});
$c_Lprofig_ProfigUtil$.prototype.properties2Json__ju_Properties__Lio_circe_Json = (function(properties) {
  var this$1 = $m_sc_JavaConverters$();
  var jsx$2 = $as_sc_TraversableLike($f_sc_convert_DecorateAsScala__propertiesAsScalaMapConverter__ju_Properties__sc_convert_Decorators$AsScala(this$1, properties).asScala__O());
  var jsx$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$2$2) {
      var x0$2 = $as_T2(x0$2$2);
      if ((x0$2 !== null)) {
        var key = $as_T(x0$2.$$und1__O());
        var value = $as_T(x0$2.$$und2__O());
        return new $c_T2().init___O__O(key, value)
      } else {
        throw new $c_s_MatchError().init___O(x0$2)
      }
    })
  })(this));
  var this$4 = $m_scm_Map$();
  var map = $as_sc_TraversableOnce(jsx$2.map__F1__scg_CanBuildFrom__O(jsx$1, new $c_scg_GenMapFactory$MapCanBuildFrom().init___scg_GenMapFactory(this$4))).toMap__s_Predef$$less$colon$less__sci_Map($m_s_Predef$().singleton$und$less$colon$less$2);
  return this.map2Json__sci_Map__Lio_circe_Json(map)
});
$c_Lprofig_ProfigUtil$.prototype.createJson__T__Lio_circe_Json__Lio_circe_Json = (function(name, value) {
  var index = $m_sjsr_RuntimeString$().indexOf__T__I__I(name, 46);
  if ((index === (-1))) {
    var this$3 = $m_Lio_circe_Json$();
    var fields = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_T2().init___O__O(name, value)]);
    return this$3.fromFields__sc_Iterable__Lio_circe_Json(fields)
  } else {
    var n = $as_T(name.substring(0, index));
    var this$10 = $m_Lio_circe_Json$();
    var beginIndex = ((1 + index) | 0);
    var y = this.createJson__T__Lio_circe_Json__Lio_circe_Json($as_T(name.substring(beginIndex)), value);
    var fields$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_T2().init___O__O(n, y)]);
    return this$10.fromFields__sc_Iterable__Lio_circe_Json(fields$1)
  }
});
var $d_Lprofig_ProfigUtil$ = new $TypeData().initClass({
  Lprofig_ProfigUtil$: 0
}, false, "profig.ProfigUtil$", {
  Lprofig_ProfigUtil$: 1,
  O: 1
});
$c_Lprofig_ProfigUtil$.prototype.$classData = $d_Lprofig_ProfigUtil$;
var $n_Lprofig_ProfigUtil$ = (void 0);
function $m_Lprofig_ProfigUtil$() {
  if ((!$n_Lprofig_ProfigUtil$)) {
    $n_Lprofig_ProfigUtil$ = new $c_Lprofig_ProfigUtil$().init___()
  };
  return $n_Lprofig_ProfigUtil$
}
function $f_Lreactify_Channel__toString__T($thiz) {
  var this$1 = $thiz.name__s_Option();
  return $as_T((this$1.isEmpty__Z() ? "Channel" : this$1.get__O()))
}
/** @constructor */
function $c_Lreactify_Priority$() {
  $c_O.call(this);
  this.Lowest$1 = 0.0;
  this.Low$1 = 0.0;
  this.Normal$1 = 0.0;
  this.High$1 = 0.0;
  this.Highest$1 = 0.0
}
$c_Lreactify_Priority$.prototype = new $h_O();
$c_Lreactify_Priority$.prototype.constructor = $c_Lreactify_Priority$;
/** @constructor */
function $h_Lreactify_Priority$() {
  /*<skip>*/
}
$h_Lreactify_Priority$.prototype = $c_Lreactify_Priority$.prototype;
$c_Lreactify_Priority$.prototype.init___ = (function() {
  $n_Lreactify_Priority$ = this;
  this.Lowest$1 = $m_s_Double$().MinValue$1;
  this.Low$1 = (-100.0);
  this.Normal$1 = 0.0;
  this.High$1 = 100.0;
  this.Highest$1 = 1.7976931348623157E308;
  return this
});
var $d_Lreactify_Priority$ = new $TypeData().initClass({
  Lreactify_Priority$: 0
}, false, "reactify.Priority$", {
  Lreactify_Priority$: 1,
  O: 1
});
$c_Lreactify_Priority$.prototype.$classData = $d_Lreactify_Priority$;
var $n_Lreactify_Priority$ = (void 0);
function $m_Lreactify_Priority$() {
  if ((!$n_Lreactify_Priority$)) {
    $n_Lreactify_Priority$ = new $c_Lreactify_Priority$().init___()
  };
  return $n_Lreactify_Priority$
}
/** @constructor */
function $c_Lreactify_Reactive$() {
  $c_O.call(this)
}
$c_Lreactify_Reactive$.prototype = new $h_O();
$c_Lreactify_Reactive$.prototype.constructor = $c_Lreactify_Reactive$;
/** @constructor */
function $h_Lreactify_Reactive$() {
  /*<skip>*/
}
$h_Lreactify_Reactive$.prototype = $c_Lreactify_Reactive$.prototype;
$c_Lreactify_Reactive$.prototype.init___ = (function() {
  return this
});
$c_Lreactify_Reactive$.prototype.fire__Lreactify_Reactive__O__s_Option__V = (function(reactive, value, previous) {
  var this$1 = reactive.reactions__Lreactify_reaction_Reactions();
  var reactions = this$1.list$1;
  $f_Lreactify_Reactive__fire__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus(reactive, value, previous, reactions)
});
var $d_Lreactify_Reactive$ = new $TypeData().initClass({
  Lreactify_Reactive$: 0
}, false, "reactify.Reactive$", {
  Lreactify_Reactive$: 1,
  O: 1
});
$c_Lreactify_Reactive$.prototype.$classData = $d_Lreactify_Reactive$;
var $n_Lreactify_Reactive$ = (void 0);
function $m_Lreactify_Reactive$() {
  if ((!$n_Lreactify_Reactive$)) {
    $n_Lreactify_Reactive$ = new $c_Lreactify_Reactive$().init___()
  };
  return $n_Lreactify_Reactive$
}
/** @constructor */
function $c_Lreactify_StateCounter() {
  $c_O.call(this);
  this.references$1 = null
}
$c_Lreactify_StateCounter.prototype = new $h_O();
$c_Lreactify_StateCounter.prototype.constructor = $c_Lreactify_StateCounter;
/** @constructor */
function $h_Lreactify_StateCounter() {
  /*<skip>*/
}
$h_Lreactify_StateCounter.prototype = $c_Lreactify_StateCounter.prototype;
$c_Lreactify_StateCounter.prototype.init___ = (function() {
  this.references$1 = $m_sci_Nil$();
  return this
});
function $is_Lreactify_StateCounter(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_StateCounter)))
}
function $as_Lreactify_StateCounter(obj) {
  return (($is_Lreactify_StateCounter(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.StateCounter"))
}
function $isArrayOf_Lreactify_StateCounter(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_StateCounter)))
}
function $asArrayOf_Lreactify_StateCounter(obj, depth) {
  return (($isArrayOf_Lreactify_StateCounter(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.StateCounter;", depth))
}
var $d_Lreactify_StateCounter = new $TypeData().initClass({
  Lreactify_StateCounter: 0
}, false, "reactify.StateCounter", {
  Lreactify_StateCounter: 1,
  O: 1
});
$c_Lreactify_StateCounter.prototype.$classData = $d_Lreactify_StateCounter;
/** @constructor */
function $c_Lreactify_StateCounter$() {
  $c_O.call(this);
  this.instance$1 = null
}
$c_Lreactify_StateCounter$.prototype = new $h_O();
$c_Lreactify_StateCounter$.prototype.constructor = $c_Lreactify_StateCounter$;
/** @constructor */
function $h_Lreactify_StateCounter$() {
  /*<skip>*/
}
$h_Lreactify_StateCounter$.prototype = $c_Lreactify_StateCounter$.prototype;
$c_Lreactify_StateCounter$.prototype.init___ = (function() {
  $n_Lreactify_StateCounter$ = this;
  this.instance$1 = new $c_Lreactify_StateCounter$$anon$1().init___();
  return this
});
$c_Lreactify_StateCounter$.prototype.referenced__Lreactify_State__V = (function(state) {
  var this$1 = $as_s_Option(this.instance$1.get__O());
  if ((!this$1.isEmpty__Z())) {
    var arg1 = this$1.get__O();
    var counter = $as_Lreactify_StateCounter(arg1);
    var this$2 = counter.references$1;
    counter.references$1 = new $c_sci_$colon$colon().init___O__sci_List(state, this$2)
  }
});
var $d_Lreactify_StateCounter$ = new $TypeData().initClass({
  Lreactify_StateCounter$: 0
}, false, "reactify.StateCounter$", {
  Lreactify_StateCounter$: 1,
  O: 1
});
$c_Lreactify_StateCounter$.prototype.$classData = $d_Lreactify_StateCounter$;
var $n_Lreactify_StateCounter$ = (void 0);
function $m_Lreactify_StateCounter$() {
  if ((!$n_Lreactify_StateCounter$)) {
    $n_Lreactify_StateCounter$ = new $c_Lreactify_StateCounter$().init___()
  };
  return $n_Lreactify_StateCounter$
}
function $f_Lreactify_Val__toString__T($thiz) {
  var this$1 = $thiz.name__s_Option();
  return $as_T((this$1.isEmpty__Z() ? "Val" : this$1.get__O()))
}
function $f_Lreactify_Val__attachAndFire__F1__D__Lreactify_reaction_Reaction($thiz, f, priority) {
  var reaction = $f_Lreactify_Reactive__attach__F1__D__Lreactify_reaction_Reaction($thiz, f, priority);
  var value = $thiz.state__Lreactify_State().value__O();
  var previous = new $c_s_Some().init___O($thiz.state__Lreactify_State().value__O());
  $m_sci_List$();
  var array = [reaction];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var this$4 = $m_sci_List$();
  var cbf = this$4.ReusableCBFInstance$2;
  var reactions = $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf));
  $f_Lreactify_Reactive__fire__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus($thiz, value, previous, reactions);
  return reaction
}
function $is_Lreactify_Val(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_Val)))
}
function $as_Lreactify_Val(obj) {
  return (($is_Lreactify_Val(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.Val"))
}
function $isArrayOf_Lreactify_Val(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_Val)))
}
function $asArrayOf_Lreactify_Val(obj, depth) {
  return (($isArrayOf_Lreactify_Val(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.Val;", depth))
}
/** @constructor */
function $c_Lreactify_package$VectorVar() {
  $c_O.call(this);
  this.v$1 = null
}
$c_Lreactify_package$VectorVar.prototype = new $h_O();
$c_Lreactify_package$VectorVar.prototype.constructor = $c_Lreactify_package$VectorVar;
/** @constructor */
function $h_Lreactify_package$VectorVar() {
  /*<skip>*/
}
$h_Lreactify_package$VectorVar.prototype = $c_Lreactify_package$VectorVar.prototype;
$c_Lreactify_package$VectorVar.prototype.init___Lreactify_Var = (function(v) {
  this.v$1 = v;
  return this
});
$c_Lreactify_package$VectorVar.prototype.$$plus$plus$eq__sc_Seq__V = (function(seq) {
  var this$3 = this.v$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, seq$1) {
    return (function() {
      var this$1 = $this.v$1;
      return $as_sci_Vector($as_sci_Vector(this$1.state__Lreactify_State().value__O()).$$plus$plus__sc_GenTraversableOnce__scg_CanBuildFrom__O(seq$1, ($m_sci_Vector$(), $m_sc_IndexedSeq$().ReusableCBF$6)))
    })
  })(this, seq));
  this$3.set__F0__V(value)
});
$c_Lreactify_package$VectorVar.prototype.$$plus$eq__O__V = (function(t) {
  var this$3 = this.v$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, t$1) {
    return (function() {
      var this$1 = $this.v$1;
      return $as_sci_Vector($as_sci_Vector(this$1.state__Lreactify_State().value__O()).$$colon$plus__O__scg_CanBuildFrom__O(t$1, ($m_sci_Vector$(), $m_sc_IndexedSeq$().ReusableCBF$6)))
    })
  })(this, t));
  this$3.set__F0__V(value)
});
var $d_Lreactify_package$VectorVar = new $TypeData().initClass({
  Lreactify_package$VectorVar: 0
}, false, "reactify.package$VectorVar", {
  Lreactify_package$VectorVar: 1,
  O: 1
});
$c_Lreactify_package$VectorVar.prototype.$classData = $d_Lreactify_package$VectorVar;
function $is_Lreactify_transaction_Transaction(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_transaction_Transaction)))
}
function $as_Lreactify_transaction_Transaction(obj) {
  return (($is_Lreactify_transaction_Transaction(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.transaction.Transaction"))
}
function $isArrayOf_Lreactify_transaction_Transaction(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_transaction_Transaction)))
}
function $asArrayOf_Lreactify_transaction_Transaction(obj, depth) {
  return (($isArrayOf_Lreactify_transaction_Transaction(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.transaction.Transaction;", depth))
}
/** @constructor */
function $c_Lreactify_transaction_Transaction$() {
  $c_O.call(this);
  this.threadLocal$1 = null
}
$c_Lreactify_transaction_Transaction$.prototype = new $h_O();
$c_Lreactify_transaction_Transaction$.prototype.constructor = $c_Lreactify_transaction_Transaction$;
/** @constructor */
function $h_Lreactify_transaction_Transaction$() {
  /*<skip>*/
}
$h_Lreactify_transaction_Transaction$.prototype = $c_Lreactify_transaction_Transaction$.prototype;
$c_Lreactify_transaction_Transaction$.prototype.init___ = (function() {
  $n_Lreactify_transaction_Transaction$ = this;
  this.threadLocal$1 = new $c_Lreactify_transaction_Transaction$$anon$1().init___();
  return this
});
$c_Lreactify_transaction_Transaction$.prototype.change__Lreactify_Var__F0__F0__V = (function(owner, oldFunction, newFunction) {
  var this$1 = $as_s_Option(this.threadLocal$1.get__O());
  if ((!this$1.isEmpty__Z())) {
    var arg1 = this$1.get__O();
    var x$1 = $as_Lreactify_transaction_Transaction(arg1);
    x$1.change__Lreactify_Var__F0__F0__V(owner, oldFunction, newFunction)
  }
});
var $d_Lreactify_transaction_Transaction$ = new $TypeData().initClass({
  Lreactify_transaction_Transaction$: 0
}, false, "reactify.transaction.Transaction$", {
  Lreactify_transaction_Transaction$: 1,
  O: 1
});
$c_Lreactify_transaction_Transaction$.prototype.$classData = $d_Lreactify_transaction_Transaction$;
var $n_Lreactify_transaction_Transaction$ = (void 0);
function $m_Lreactify_transaction_Transaction$() {
  if ((!$n_Lreactify_transaction_Transaction$)) {
    $n_Lreactify_transaction_Transaction$ = new $c_Lreactify_transaction_Transaction$().init___()
  };
  return $n_Lreactify_transaction_Transaction$
}
/** @constructor */
function $c_Lscribe_Level$() {
  $c_O.call(this);
  this.scribe$Level$$maxLength$1 = 0;
  this.levels$1 = null
}
$c_Lscribe_Level$.prototype = new $h_O();
$c_Lscribe_Level$.prototype.constructor = $c_Lscribe_Level$;
/** @constructor */
function $h_Lscribe_Level$() {
  /*<skip>*/
}
$h_Lscribe_Level$.prototype = $c_Lscribe_Level$.prototype;
$c_Lscribe_Level$.prototype.init___ = (function() {
  $n_Lscribe_Level$ = this;
  this.scribe$Level$$maxLength$1 = 5;
  this.levels$1 = $m_sci_Map$EmptyMap$();
  return this
});
var $d_Lscribe_Level$ = new $TypeData().initClass({
  Lscribe_Level$: 0
}, false, "scribe.Level$", {
  Lscribe_Level$: 1,
  O: 1
});
$c_Lscribe_Level$.prototype.$classData = $d_Lscribe_Level$;
var $n_Lscribe_Level$ = (void 0);
function $m_Lscribe_Level$() {
  if ((!$n_Lscribe_Level$)) {
    $n_Lscribe_Level$ = new $c_Lscribe_Level$().init___()
  };
  return $n_Lscribe_Level$
}
/** @constructor */
function $c_Lscribe_LogRecord$() {
  $c_O.call(this)
}
$c_Lscribe_LogRecord$.prototype = new $h_O();
$c_Lscribe_LogRecord$.prototype.constructor = $c_Lscribe_LogRecord$;
/** @constructor */
function $h_Lscribe_LogRecord$() {
  /*<skip>*/
}
$h_Lscribe_LogRecord$.prototype = $c_Lscribe_LogRecord$.prototype;
$c_Lscribe_LogRecord$.prototype.init___ = (function() {
  return this
});
$c_Lscribe_LogRecord$.prototype.writeStackTrace__p1__scm_StringBuilder__Ajl_StackTraceElement__V = (function(b, elements) {
  _writeStackTrace: while (true) {
    var xs = elements;
    var this$2 = new $c_scm_ArrayOps$ofRef().init___AO(xs);
    var x1 = $f_sc_TraversableLike__headOption__s_Option(this$2);
    var x$2 = $m_s_None$();
    if ((!(x$2 === x1))) {
      if ($is_s_Some(x1)) {
        var x2 = $as_s_Some(x1);
        var head = $as_jl_StackTraceElement(x2.value$2);
        b.append__T__scm_StringBuilder("\tat ");
        b.append__T__scm_StringBuilder(head.declaringClass$1);
        b.append__C__scm_StringBuilder(46);
        b.append__T__scm_StringBuilder(head.methodName$1);
        b.append__C__scm_StringBuilder(40);
        if ((head.lineNumber$1 === (-2))) {
          b.append__T__scm_StringBuilder("Native Method")
        } else {
          b.append__T__scm_StringBuilder(head.fileName$1);
          if ((head.lineNumber$1 > 0)) {
            b.append__C__scm_StringBuilder(58);
            b.append__I__scm_StringBuilder(head.lineNumber$1)
          }
        };
        b.append__C__scm_StringBuilder(41);
        b.append__T__scm_StringBuilder($m_Lscribe_package$().lineSeparator__T());
        var xs$1 = elements;
        if ((xs$1.u.length === 0)) {
          if ((xs$1.u.length === 0)) {
            throw new $c_jl_UnsupportedOperationException().init___T("empty.tail")
          };
          var until = xs$1.u.length;
          var x = ((until > 0) ? until : 0);
          var y = xs$1.u.length;
          var hi = ((x < y) ? x : y);
          var x$1 = (((-1) + hi) | 0);
          var size = ((x$1 > 0) ? x$1 : 0);
          var result = $m_jl_reflect_Array$().newInstance__jl_Class__I__O($objectGetClass(xs$1).getComponentType__jl_Class(), size);
          if ((size > 0)) {
            $m_s_Array$().copy__O__I__O__I__I__V(xs$1, 1, result, 0, size)
          };
          var jsx$1 = result
        } else {
          var until$1 = xs$1.u.length;
          var x$3 = ((until$1 > 0) ? until$1 : 0);
          var y$1 = xs$1.u.length;
          var hi$1 = ((x$3 < y$1) ? x$3 : y$1);
          var x$4 = (((-1) + hi$1) | 0);
          var size$1 = ((x$4 > 0) ? x$4 : 0);
          var result$1 = $m_jl_reflect_Array$().newInstance__jl_Class__I__O($objectGetClass(xs$1).getComponentType__jl_Class(), size$1);
          if ((size$1 > 0)) {
            $m_s_Array$().copy__O__I__O__I__I__V(xs$1, 1, result$1, 0, size$1)
          };
          var jsx$1 = result$1
        };
        elements = $asArrayOf_jl_StackTraceElement(jsx$1, 1);
        continue _writeStackTrace
      };
      throw new $c_s_MatchError().init___O(x1)
    };
    break
  }
});
$c_Lscribe_LogRecord$.prototype.throwable2LogOutput__Lscribe_output_LogOutput__jl_Throwable__Z__scm_StringBuilder__Lscribe_output_LogOutput = (function(message, t, primaryCause, b) {
  _throwable2LogOutput: while (true) {
    if ((!primaryCause)) {
      b.append__T__scm_StringBuilder("Caused by: ")
    };
    var this$1 = t;
    b.append__T__scm_StringBuilder($objectGetClass(this$1).getName__T());
    var jsx$1 = $m_s_Option$();
    var this$2 = t;
    var this$3 = jsx$1.apply__O__s_Option(this$2.getMessage__T());
    if (this$3.isDefined__Z()) {
      b.append__T__scm_StringBuilder(": ");
      var this$4 = t;
      b.append__T__scm_StringBuilder(this$4.getMessage__T())
    };
    b.append__T__scm_StringBuilder($m_Lscribe_package$().lineSeparator__T());
    this.writeStackTrace__p1__scm_StringBuilder__Ajl_StackTraceElement__V(b, t.getStackTrace__Ajl_StackTraceElement());
    var jsx$2 = $m_s_Option$();
    var this$5 = t;
    if (jsx$2.apply__O__s_Option(this$5.e$1).isEmpty__Z()) {
      var output = b.underlying$5.java$lang$StringBuilder$$content$f;
      var x$3 = $m_Lscribe_output_EmptyOutput$();
      if (((message !== null) && message.equals__O__Z(x$3))) {
        return new $c_Lscribe_output_TextOutput().init___T(output)
      } else {
        $m_sci_List$();
        var array = [message, new $c_Lscribe_output_TextOutput().init___T($m_Lscribe_package$().lineSeparator__T()), new $c_Lscribe_output_TextOutput().init___T(output)];
        var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
        var this$9 = $m_sci_List$();
        var cbf = this$9.ReusableCBFInstance$2;
        return new $c_Lscribe_output_CompositeOutput().init___sci_List($as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)))
      }
    } else {
      var this$10 = t;
      var temp$t = this$10.e$1;
      t = temp$t;
      primaryCause = false;
      continue _throwable2LogOutput
    }
  }
});
var $d_Lscribe_LogRecord$ = new $TypeData().initClass({
  Lscribe_LogRecord$: 0
}, false, "scribe.LogRecord$", {
  Lscribe_LogRecord$: 1,
  O: 1
});
$c_Lscribe_LogRecord$.prototype.$classData = $d_Lscribe_LogRecord$;
var $n_Lscribe_LogRecord$ = (void 0);
function $m_Lscribe_LogRecord$() {
  if ((!$n_Lscribe_LogRecord$)) {
    $n_Lscribe_LogRecord$ = new $c_Lscribe_LogRecord$().init___()
  };
  return $n_Lscribe_LogRecord$
}
/** @constructor */
function $c_Lscribe_MDC() {
  $c_O.call(this);
  this.$$undmap$1 = null
}
$c_Lscribe_MDC.prototype = new $h_O();
$c_Lscribe_MDC.prototype.constructor = $c_Lscribe_MDC;
/** @constructor */
function $h_Lscribe_MDC() {
  /*<skip>*/
}
$h_Lscribe_MDC.prototype = $c_Lscribe_MDC.prototype;
$c_Lscribe_MDC.prototype.init___s_Option = (function(parent) {
  this.$$undmap$1 = $m_sci_Map$EmptyMap$();
  return this
});
function $is_Lscribe_MDC(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lscribe_MDC)))
}
function $as_Lscribe_MDC(obj) {
  return (($is_Lscribe_MDC(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scribe.MDC"))
}
function $isArrayOf_Lscribe_MDC(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lscribe_MDC)))
}
function $asArrayOf_Lscribe_MDC(obj, depth) {
  return (($isArrayOf_Lscribe_MDC(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscribe.MDC;", depth))
}
var $d_Lscribe_MDC = new $TypeData().initClass({
  Lscribe_MDC: 0
}, false, "scribe.MDC", {
  Lscribe_MDC: 1,
  O: 1
});
$c_Lscribe_MDC.prototype.$classData = $d_Lscribe_MDC;
/** @constructor */
function $c_Lscribe_MDC$() {
  $c_O.call(this);
  this.threadLocal$1 = null
}
$c_Lscribe_MDC$.prototype = new $h_O();
$c_Lscribe_MDC$.prototype.constructor = $c_Lscribe_MDC$;
/** @constructor */
function $h_Lscribe_MDC$() {
  /*<skip>*/
}
$h_Lscribe_MDC$.prototype = $c_Lscribe_MDC$.prototype;
$c_Lscribe_MDC$.prototype.init___ = (function() {
  $n_Lscribe_MDC$ = this;
  this.threadLocal$1 = new $c_Lscribe_MDC$$anon$1().init___();
  return this
});
var $d_Lscribe_MDC$ = new $TypeData().initClass({
  Lscribe_MDC$: 0
}, false, "scribe.MDC$", {
  Lscribe_MDC$: 1,
  O: 1
});
$c_Lscribe_MDC$.prototype.$classData = $d_Lscribe_MDC$;
var $n_Lscribe_MDC$ = (void 0);
function $m_Lscribe_MDC$() {
  if ((!$n_Lscribe_MDC$)) {
    $n_Lscribe_MDC$ = new $c_Lscribe_MDC$().init___()
  };
  return $n_Lscribe_MDC$
}
/** @constructor */
function $c_Lscribe_Priority$() {
  $c_O.call(this);
  this.Highest$1 = 0.0;
  this.Critical$1 = 0.0;
  this.Important$1 = 0.0;
  this.High$1 = 0.0;
  this.Normal$1 = 0.0;
  this.Low$1 = 0.0;
  this.Lower$1 = 0.0;
  this.Fallthrough$1 = 0.0;
  this.Lowest$1 = 0.0;
  this.bitmap$0$1 = 0
}
$c_Lscribe_Priority$.prototype = new $h_O();
$c_Lscribe_Priority$.prototype.constructor = $c_Lscribe_Priority$;
/** @constructor */
function $h_Lscribe_Priority$() {
  /*<skip>*/
}
$h_Lscribe_Priority$.prototype = $c_Lscribe_Priority$.prototype;
$c_Lscribe_Priority$.prototype.init___ = (function() {
  return this
});
$c_Lscribe_Priority$.prototype.compare$extension__D__D__I = (function($$this, that) {
  var this$2 = new $c_sr_RichDouble().init___D($$this);
  var x = this$2.self$1;
  return $m_jl_Double$().compare__D__D__I(x, that)
});
$c_Lscribe_Priority$.prototype.High__D = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.High$lzycompute__p1__D() : this.High$1)
});
$c_Lscribe_Priority$.prototype.High$lzycompute__p1__D = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    this.High$1 = 10.0;
    this.bitmap$0$1 = (8 | this.bitmap$0$1)
  };
  return this.High$1
});
var $d_Lscribe_Priority$ = new $TypeData().initClass({
  Lscribe_Priority$: 0
}, false, "scribe.Priority$", {
  Lscribe_Priority$: 1,
  O: 1
});
$c_Lscribe_Priority$.prototype.$classData = $d_Lscribe_Priority$;
var $n_Lscribe_Priority$ = (void 0);
function $m_Lscribe_Priority$() {
  if ((!$n_Lscribe_Priority$)) {
    $n_Lscribe_Priority$ = new $c_Lscribe_Priority$().init___()
  };
  return $n_Lscribe_Priority$
}
/** @constructor */
function $c_Lscribe_format_Formatter$() {
  $c_O.call(this);
  this.simple$1 = null;
  this.classic$1 = null;
  this.default$1 = null;
  this.enhanced$1 = null;
  this.strict$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lscribe_format_Formatter$.prototype = new $h_O();
$c_Lscribe_format_Formatter$.prototype.constructor = $c_Lscribe_format_Formatter$;
/** @constructor */
function $h_Lscribe_format_Formatter$() {
  /*<skip>*/
}
$h_Lscribe_format_Formatter$.prototype = $c_Lscribe_format_Formatter$.prototype;
$c_Lscribe_format_Formatter$.prototype.init___ = (function() {
  return this
});
$c_Lscribe_format_Formatter$.prototype.$default__Lscribe_format_Formatter = (function() {
  return (((((4 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.default$lzycompute__p1__Lscribe_format_Formatter() : this.default$1)
});
$c_Lscribe_format_Formatter$.prototype.default$lzycompute__p1__Lscribe_format_Formatter = (function() {
  if (((((4 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var array = [$m_Lscribe_format_FormatBlock$Date$Standard$(), new $c_Lscribe_format_FormatBlock$RawString().init___T(" "), $m_Lscribe_format_FormatBlock$Level$(), new $c_Lscribe_format_FormatBlock$RawString().init___T(" "), $m_Lscribe_format_FormatBlock$Position$(), new $c_Lscribe_format_FormatBlock$RawString().init___T(" - "), $m_Lscribe_format_FormatBlock$Message$(), $m_Lscribe_format_FormatBlock$MDCAll$(), $m_Lscribe_format_FormatBlock$NewLine$()];
    var blocks = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
    var this$10 = $m_sci_List$();
    var cbf = this$10.ReusableCBFInstance$2;
    this.default$1 = new $c_Lscribe_format_FormatBlocksFormatter().init___sci_List($as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(blocks, cbf)));
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.default$1
});
var $d_Lscribe_format_Formatter$ = new $TypeData().initClass({
  Lscribe_format_Formatter$: 0
}, false, "scribe.format.Formatter$", {
  Lscribe_format_Formatter$: 1,
  O: 1
});
$c_Lscribe_format_Formatter$.prototype.$classData = $d_Lscribe_format_Formatter$;
var $n_Lscribe_format_Formatter$ = (void 0);
function $m_Lscribe_format_Formatter$() {
  if ((!$n_Lscribe_format_Formatter$)) {
    $n_Lscribe_format_Formatter$ = new $c_Lscribe_format_Formatter$().init___()
  };
  return $n_Lscribe_format_Formatter$
}
function $is_Lscribe_handler_LogHandler(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lscribe_handler_LogHandler)))
}
function $as_Lscribe_handler_LogHandler(obj) {
  return (($is_Lscribe_handler_LogHandler(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scribe.handler.LogHandler"))
}
function $isArrayOf_Lscribe_handler_LogHandler(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lscribe_handler_LogHandler)))
}
function $asArrayOf_Lscribe_handler_LogHandler(obj, depth) {
  return (($isArrayOf_Lscribe_handler_LogHandler(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscribe.handler.LogHandler;", depth))
}
/** @constructor */
function $c_Lscribe_handler_LogHandler$() {
  $c_O.call(this);
  this.default$1 = null;
  this.bitmap$0$1 = false
}
$c_Lscribe_handler_LogHandler$.prototype = new $h_O();
$c_Lscribe_handler_LogHandler$.prototype.constructor = $c_Lscribe_handler_LogHandler$;
/** @constructor */
function $h_Lscribe_handler_LogHandler$() {
  /*<skip>*/
}
$h_Lscribe_handler_LogHandler$.prototype = $c_Lscribe_handler_LogHandler$.prototype;
$c_Lscribe_handler_LogHandler$.prototype.init___ = (function() {
  return this
});
$c_Lscribe_handler_LogHandler$.prototype.apply__Lscribe_format_Formatter__Lscribe_writer_Writer__s_Option__sci_List__Lscribe_handler_LogHandler = (function(formatter, writer, minimumLevel, modifiers) {
  if (minimumLevel.isEmpty__Z()) {
    var jsx$1 = $m_s_None$()
  } else {
    var arg1 = minimumLevel.get__O();
    var x$1 = $as_Lscribe_Level(arg1);
    var jsx$1 = new $c_s_Some().init___O($m_Lscribe_modify_LevelFilter$().$$greater$eq__Lscribe_Level__Lscribe_modify_LevelFilter(x$1))
  };
  var x$2 = jsx$1.toList__sci_List();
  var mods = modifiers.$$colon$colon$colon__sci_List__sci_List(x$2);
  return new $c_Lscribe_handler_SynchronousLogHandler().init___Lscribe_format_Formatter__Lscribe_writer_Writer__sci_List(formatter, writer, mods)
});
var $d_Lscribe_handler_LogHandler$ = new $TypeData().initClass({
  Lscribe_handler_LogHandler$: 0
}, false, "scribe.handler.LogHandler$", {
  Lscribe_handler_LogHandler$: 1,
  O: 1
});
$c_Lscribe_handler_LogHandler$.prototype.$classData = $d_Lscribe_handler_LogHandler$;
var $n_Lscribe_handler_LogHandler$ = (void 0);
function $m_Lscribe_handler_LogHandler$() {
  if ((!$n_Lscribe_handler_LogHandler$)) {
    $n_Lscribe_handler_LogHandler$ = new $c_Lscribe_handler_LogHandler$().init___()
  };
  return $n_Lscribe_handler_LogHandler$
}
/** @constructor */
function $c_Lscribe_modify_LevelFilter$() {
  $c_O.call(this);
  this.Id$1 = null
}
$c_Lscribe_modify_LevelFilter$.prototype = new $h_O();
$c_Lscribe_modify_LevelFilter$.prototype.constructor = $c_Lscribe_modify_LevelFilter$;
/** @constructor */
function $h_Lscribe_modify_LevelFilter$() {
  /*<skip>*/
}
$h_Lscribe_modify_LevelFilter$.prototype = $c_Lscribe_modify_LevelFilter$.prototype;
$c_Lscribe_modify_LevelFilter$.prototype.init___ = (function() {
  this.Id$1 = "LevelFilter";
  return this
});
$c_Lscribe_modify_LevelFilter$.prototype.$$greater$eq__Lscribe_Level__Lscribe_modify_LevelFilter = (function(level) {
  return new $c_Lscribe_modify_LevelFilter().init___F1__F1__D(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, level$1) {
    return (function(x$1$2) {
      var x$1 = $uD(x$1$2);
      return $f_s_math_Ordered__$$less$eq__O__Z(level$1, x$1)
    })
  })(this, level)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(x$2$2) {
      $uD(x$2$2);
      return false
    })
  })(this)), $m_Lscribe_Priority$().High__D())
});
var $d_Lscribe_modify_LevelFilter$ = new $TypeData().initClass({
  Lscribe_modify_LevelFilter$: 0
}, false, "scribe.modify.LevelFilter$", {
  Lscribe_modify_LevelFilter$: 1,
  O: 1
});
$c_Lscribe_modify_LevelFilter$.prototype.$classData = $d_Lscribe_modify_LevelFilter$;
var $n_Lscribe_modify_LevelFilter$ = (void 0);
function $m_Lscribe_modify_LevelFilter$() {
  if ((!$n_Lscribe_modify_LevelFilter$)) {
    $n_Lscribe_modify_LevelFilter$ = new $c_Lscribe_modify_LevelFilter$().init___()
  };
  return $n_Lscribe_modify_LevelFilter$
}
/** @constructor */
function $c_Lscribe_output_TextOutput$() {
  $c_O.call(this)
}
$c_Lscribe_output_TextOutput$.prototype = new $h_O();
$c_Lscribe_output_TextOutput$.prototype.constructor = $c_Lscribe_output_TextOutput$;
/** @constructor */
function $h_Lscribe_output_TextOutput$() {
  /*<skip>*/
}
$h_Lscribe_output_TextOutput$.prototype = $c_Lscribe_output_TextOutput$.prototype;
$c_Lscribe_output_TextOutput$.prototype.init___ = (function() {
  return this
});
$c_Lscribe_output_TextOutput$.prototype.equals$extension__T__O__Z = (function($$this, x$1) {
  if ($is_Lscribe_output_TextOutput(x$1)) {
    var TextOutput$1 = ((x$1 === null) ? null : $as_Lscribe_output_TextOutput(x$1).plainText$1);
    return ($$this === TextOutput$1)
  } else {
    return false
  }
});
var $d_Lscribe_output_TextOutput$ = new $TypeData().initClass({
  Lscribe_output_TextOutput$: 0
}, false, "scribe.output.TextOutput$", {
  Lscribe_output_TextOutput$: 1,
  O: 1
});
$c_Lscribe_output_TextOutput$.prototype.$classData = $d_Lscribe_output_TextOutput$;
var $n_Lscribe_output_TextOutput$ = (void 0);
function $m_Lscribe_output_TextOutput$() {
  if ((!$n_Lscribe_output_TextOutput$)) {
    $n_Lscribe_output_TextOutput$ = new $c_Lscribe_output_TextOutput$().init___()
  };
  return $n_Lscribe_output_TextOutput$
}
/** @constructor */
function $c_Lscribe_util_Time$() {
  $c_O.call(this);
  this.function$1 = null
}
$c_Lscribe_util_Time$.prototype = new $h_O();
$c_Lscribe_util_Time$.prototype.constructor = $c_Lscribe_util_Time$;
/** @constructor */
function $h_Lscribe_util_Time$() {
  /*<skip>*/
}
$h_Lscribe_util_Time$.prototype = $c_Lscribe_util_Time$.prototype;
$c_Lscribe_util_Time$.prototype.init___ = (function() {
  $n_Lscribe_util_Time$ = this;
  this.reset__V();
  return this
});
$c_Lscribe_util_Time$.prototype.reset__V = (function() {
  this.function$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_jl_System$().currentTimeMillis__J()
    })
  })(this))
});
var $d_Lscribe_util_Time$ = new $TypeData().initClass({
  Lscribe_util_Time$: 0
}, false, "scribe.util.Time$", {
  Lscribe_util_Time$: 1,
  O: 1
});
$c_Lscribe_util_Time$.prototype.$classData = $d_Lscribe_util_Time$;
var $n_Lscribe_util_Time$ = (void 0);
function $m_Lscribe_util_Time$() {
  if ((!$n_Lscribe_util_Time$)) {
    $n_Lscribe_util_Time$ = new $c_Lscribe_util_Time$().init___()
  };
  return $n_Lscribe_util_Time$
}
/** @constructor */
function $c_Lshapeless_labelled$FieldBuilder() {
  $c_O.call(this)
}
$c_Lshapeless_labelled$FieldBuilder.prototype = new $h_O();
$c_Lshapeless_labelled$FieldBuilder.prototype.constructor = $c_Lshapeless_labelled$FieldBuilder;
/** @constructor */
function $h_Lshapeless_labelled$FieldBuilder() {
  /*<skip>*/
}
$h_Lshapeless_labelled$FieldBuilder.prototype = $c_Lshapeless_labelled$FieldBuilder.prototype;
$c_Lshapeless_labelled$FieldBuilder.prototype.init___ = (function() {
  return this
});
var $d_Lshapeless_labelled$FieldBuilder = new $TypeData().initClass({
  Lshapeless_labelled$FieldBuilder: 0
}, false, "shapeless.labelled$FieldBuilder", {
  Lshapeless_labelled$FieldBuilder: 1,
  O: 1
});
$c_Lshapeless_labelled$FieldBuilder.prototype.$classData = $d_Lshapeless_labelled$FieldBuilder;
/** @constructor */
function $c_jl_Class() {
  $c_O.call(this);
  this.data$1 = null
}
$c_jl_Class.prototype = new $h_O();
$c_jl_Class.prototype.constructor = $c_jl_Class;
/** @constructor */
function $h_jl_Class() {
  /*<skip>*/
}
$h_jl_Class.prototype = $c_jl_Class.prototype;
$c_jl_Class.prototype.getName__T = (function() {
  return $as_T(this.data$1.name)
});
$c_jl_Class.prototype.getComponentType__jl_Class = (function() {
  return $as_jl_Class(this.data$1.getComponentType())
});
$c_jl_Class.prototype.isPrimitive__Z = (function() {
  return $uZ(this.data$1.isPrimitive)
});
$c_jl_Class.prototype.toString__T = (function() {
  return ((this.isInterface__Z() ? "interface " : (this.isPrimitive__Z() ? "" : "class ")) + this.getName__T())
});
$c_jl_Class.prototype.isAssignableFrom__jl_Class__Z = (function(that) {
  return ((this.isPrimitive__Z() || that.isPrimitive__Z()) ? ((this === that) || ((this === $d_S.getClassOf()) ? (that === $d_B.getClassOf()) : ((this === $d_I.getClassOf()) ? ((that === $d_B.getClassOf()) || (that === $d_S.getClassOf())) : ((this === $d_F.getClassOf()) ? (((that === $d_B.getClassOf()) || (that === $d_S.getClassOf())) || (that === $d_I.getClassOf())) : ((this === $d_D.getClassOf()) && ((((that === $d_B.getClassOf()) || (that === $d_S.getClassOf())) || (that === $d_I.getClassOf())) || (that === $d_F.getClassOf()))))))) : this.isInstance__O__Z(that.getFakeInstance__p1__O()))
});
$c_jl_Class.prototype.isInstance__O__Z = (function(obj) {
  return $uZ(this.data$1.isInstance(obj))
});
$c_jl_Class.prototype.init___jl_ScalaJSClassData = (function(data) {
  this.data$1 = data;
  return this
});
$c_jl_Class.prototype.getFakeInstance__p1__O = (function() {
  return this.data$1.getFakeInstance()
});
$c_jl_Class.prototype.newArrayOfThisClass__sjs_js_Array__O = (function(dimensions) {
  return this.data$1.newArrayOfThisClass(dimensions)
});
$c_jl_Class.prototype.getSimpleName__T = (function() {
  var x = $as_T(this.data$1.name);
  var this$2 = new $c_sci_StringOps().init___T(x);
  var xs = $f_sci_StringLike__split__C__AT(this$2, 46);
  var this$4 = new $c_scm_ArrayOps$ofRef().init___AO(xs);
  var x$1 = $as_T($f_sc_IndexedSeqOptimized__last__O(this$4));
  var this$6 = new $c_sci_StringOps().init___T(x$1);
  var xs$1 = $f_sci_StringLike__split__C__AT(this$6, 36);
  var this$8 = new $c_scm_ArrayOps$ofRef().init___AO(xs$1);
  return $as_T($f_sc_IndexedSeqOptimized__last__O(this$8))
});
$c_jl_Class.prototype.isArray__Z = (function() {
  return $uZ(this.data$1.isArrayClass)
});
$c_jl_Class.prototype.isInterface__Z = (function() {
  return $uZ(this.data$1.isInterface)
});
function $is_jl_Class(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.jl_Class)))
}
function $as_jl_Class(obj) {
  return (($is_jl_Class(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Class"))
}
function $isArrayOf_jl_Class(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Class)))
}
function $asArrayOf_jl_Class(obj, depth) {
  return (($isArrayOf_jl_Class(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Class;", depth))
}
var $d_jl_Class = new $TypeData().initClass({
  jl_Class: 0
}, false, "java.lang.Class", {
  jl_Class: 1,
  O: 1
});
$c_jl_Class.prototype.$classData = $d_jl_Class;
/** @constructor */
function $c_jl_Long$StringRadixInfo() {
  $c_O.call(this);
  this.chunkLength$1 = 0;
  this.radixPowLength$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.paddingZeros$1 = null;
  this.overflowBarrier$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_jl_Long$StringRadixInfo.prototype = new $h_O();
$c_jl_Long$StringRadixInfo.prototype.constructor = $c_jl_Long$StringRadixInfo;
/** @constructor */
function $h_jl_Long$StringRadixInfo() {
  /*<skip>*/
}
$h_jl_Long$StringRadixInfo.prototype = $c_jl_Long$StringRadixInfo.prototype;
$c_jl_Long$StringRadixInfo.prototype.init___I__J__T__J = (function(chunkLength, radixPowLength, paddingZeros, overflowBarrier) {
  this.chunkLength$1 = chunkLength;
  this.radixPowLength$1 = radixPowLength;
  this.paddingZeros$1 = paddingZeros;
  this.overflowBarrier$1 = overflowBarrier;
  return this
});
function $is_jl_Long$StringRadixInfo(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.jl_Long$StringRadixInfo)))
}
function $as_jl_Long$StringRadixInfo(obj) {
  return (($is_jl_Long$StringRadixInfo(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Long$StringRadixInfo"))
}
function $isArrayOf_jl_Long$StringRadixInfo(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Long$StringRadixInfo)))
}
function $asArrayOf_jl_Long$StringRadixInfo(obj, depth) {
  return (($isArrayOf_jl_Long$StringRadixInfo(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Long$StringRadixInfo;", depth))
}
var $d_jl_Long$StringRadixInfo = new $TypeData().initClass({
  jl_Long$StringRadixInfo: 0
}, false, "java.lang.Long$StringRadixInfo", {
  jl_Long$StringRadixInfo: 1,
  O: 1
});
$c_jl_Long$StringRadixInfo.prototype.$classData = $d_jl_Long$StringRadixInfo;
/** @constructor */
function $c_jl_System$() {
  $c_O.call(this);
  this.out$1 = null;
  this.err$1 = null;
  this.in$1 = null;
  this.getHighPrecisionTime$1 = null
}
$c_jl_System$.prototype = new $h_O();
$c_jl_System$.prototype.constructor = $c_jl_System$;
/** @constructor */
function $h_jl_System$() {
  /*<skip>*/
}
$h_jl_System$.prototype = $c_jl_System$.prototype;
$c_jl_System$.prototype.init___ = (function() {
  $n_jl_System$ = this;
  this.out$1 = new $c_jl_JSConsoleBasedPrintStream().init___jl_Boolean(false);
  this.err$1 = new $c_jl_JSConsoleBasedPrintStream().init___jl_Boolean(true);
  this.in$1 = null;
  var x = $g.performance;
  if ($uZ((!(!x)))) {
    var x$1 = $g.performance.now;
    if ($uZ((!(!x$1)))) {
      var jsx$1 = (function() {
        return $m_jl_System$().java$lang$System$$$anonfun$getHighPrecisionTime$1__D()
      })
    } else {
      var x$2 = $g.performance.webkitNow;
      if ($uZ((!(!x$2)))) {
        var jsx$1 = (function() {
          return $m_jl_System$().java$lang$System$$$anonfun$getHighPrecisionTime$2__D()
        })
      } else {
        var jsx$1 = (function() {
          return $m_jl_System$().java$lang$System$$$anonfun$getHighPrecisionTime$3__D()
        })
      }
    }
  } else {
    var jsx$1 = (function() {
      return $m_jl_System$().java$lang$System$$$anonfun$getHighPrecisionTime$4__D()
    })
  };
  this.getHighPrecisionTime$1 = jsx$1;
  return this
});
$c_jl_System$.prototype.java$lang$System$$$anonfun$getHighPrecisionTime$3__D = (function() {
  return $uD(new $g.Date().getTime())
});
$c_jl_System$.prototype.java$lang$System$$$anonfun$getHighPrecisionTime$1__D = (function() {
  return $uD($g.performance.now())
});
$c_jl_System$.prototype.java$lang$System$$$anonfun$getHighPrecisionTime$4__D = (function() {
  return $uD(new $g.Date().getTime())
});
$c_jl_System$.prototype.java$lang$System$$$anonfun$getHighPrecisionTime$2__D = (function() {
  return $uD($g.performance.webkitNow())
});
$c_jl_System$.prototype.currentTimeMillis__J = (function() {
  var this$1 = $m_sjsr_RuntimeLong$();
  var value = $uD(new $g.Date().getTime());
  var lo = this$1.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I(value);
  var hi = this$1.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
  return new $c_sjsr_RuntimeLong().init___I__I(lo, hi)
});
var $d_jl_System$ = new $TypeData().initClass({
  jl_System$: 0
}, false, "java.lang.System$", {
  jl_System$: 1,
  O: 1
});
$c_jl_System$.prototype.$classData = $d_jl_System$;
var $n_jl_System$ = (void 0);
function $m_jl_System$() {
  if ((!$n_jl_System$)) {
    $n_jl_System$ = new $c_jl_System$().init___()
  };
  return $n_jl_System$
}
/** @constructor */
function $c_jl_System$SystemProperties$() {
  $c_O.call(this);
  this.value$1 = null
}
$c_jl_System$SystemProperties$.prototype = new $h_O();
$c_jl_System$SystemProperties$.prototype.constructor = $c_jl_System$SystemProperties$;
/** @constructor */
function $h_jl_System$SystemProperties$() {
  /*<skip>*/
}
$h_jl_System$SystemProperties$.prototype = $c_jl_System$SystemProperties$.prototype;
$c_jl_System$SystemProperties$.prototype.init___ = (function() {
  $n_jl_System$SystemProperties$ = this;
  this.value$1 = this.loadSystemProperties__ju_Properties();
  return this
});
$c_jl_System$SystemProperties$.prototype.loadSystemProperties__ju_Properties = (function() {
  var sysProp = new $c_ju_Properties().init___();
  sysProp.put__O__O__O("java.version", "1.8");
  sysProp.put__O__O__O("java.vm.specification.version", "1.8");
  sysProp.put__O__O__O("java.vm.specification.vendor", "Oracle Corporation");
  sysProp.put__O__O__O("java.vm.specification.name", "Java Virtual Machine Specification");
  sysProp.put__O__O__O("java.vm.name", "Scala.js");
  var value = $linkingInfo.linkerVersion;
  if ((value !== (void 0))) {
    var v = $as_T(value);
    sysProp.put__O__O__O("java.vm.version", v)
  };
  sysProp.put__O__O__O("java.specification.version", "1.8");
  sysProp.put__O__O__O("java.specification.vendor", "Oracle Corporation");
  sysProp.put__O__O__O("java.specification.name", "Java Platform API Specification");
  sysProp.put__O__O__O("file.separator", "/");
  sysProp.put__O__O__O("path.separator", ":");
  sysProp.put__O__O__O("line.separator", "\n");
  var value$1 = $env.javaSystemProperties;
  if ((value$1 !== (void 0))) {
    var this$13 = new $c_sjs_js_WrappedDictionary().init___sjs_js_Dictionary(value$1);
    var p = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
      return (function(check$ifrefutable$1$2) {
        var check$ifrefutable$1 = $as_T2(check$ifrefutable$1$2);
        return (check$ifrefutable$1 !== null)
      })
    })(this));
    new $c_sc_TraversableLike$WithFilter().init___sc_TraversableLike__F1(this$13, p).foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, sysProp$1) {
      return (function(x$1$2) {
        var x$1 = $as_T2(x$1$2);
        if ((x$1 !== null)) {
          var key = $as_T(x$1.$$und1__O());
          var value$2 = $as_T(x$1.$$und2__O());
          return sysProp$1.put__O__O__O(key, value$2)
        } else {
          throw new $c_s_MatchError().init___O(x$1)
        }
      })
    })(this, sysProp)))
  };
  return sysProp
});
var $d_jl_System$SystemProperties$ = new $TypeData().initClass({
  jl_System$SystemProperties$: 0
}, false, "java.lang.System$SystemProperties$", {
  jl_System$SystemProperties$: 1,
  O: 1
});
$c_jl_System$SystemProperties$.prototype.$classData = $d_jl_System$SystemProperties$;
var $n_jl_System$SystemProperties$ = (void 0);
function $m_jl_System$SystemProperties$() {
  if ((!$n_jl_System$SystemProperties$)) {
    $n_jl_System$SystemProperties$ = new $c_jl_System$SystemProperties$().init___()
  };
  return $n_jl_System$SystemProperties$
}
/** @constructor */
function $c_jl_Thread$() {
  $c_O.call(this);
  this.SingleThread$1 = null
}
$c_jl_Thread$.prototype = new $h_O();
$c_jl_Thread$.prototype.constructor = $c_jl_Thread$;
/** @constructor */
function $h_jl_Thread$() {
  /*<skip>*/
}
$h_jl_Thread$.prototype = $c_jl_Thread$.prototype;
$c_jl_Thread$.prototype.init___ = (function() {
  $n_jl_Thread$ = this;
  this.SingleThread$1 = new $c_jl_Thread().init___sr_BoxedUnit((void 0));
  return this
});
var $d_jl_Thread$ = new $TypeData().initClass({
  jl_Thread$: 0
}, false, "java.lang.Thread$", {
  jl_Thread$: 1,
  O: 1
});
$c_jl_Thread$.prototype.$classData = $d_jl_Thread$;
var $n_jl_Thread$ = (void 0);
function $m_jl_Thread$() {
  if ((!$n_jl_Thread$)) {
    $n_jl_Thread$ = new $c_jl_Thread$().init___()
  };
  return $n_jl_Thread$
}
/** @constructor */
function $c_jl_ThreadLocal() {
  $c_O.call(this);
  this.hasValue$1 = null;
  this.v$1 = null
}
$c_jl_ThreadLocal.prototype = new $h_O();
$c_jl_ThreadLocal.prototype.constructor = $c_jl_ThreadLocal;
/** @constructor */
function $h_jl_ThreadLocal() {
  /*<skip>*/
}
$h_jl_ThreadLocal.prototype = $c_jl_ThreadLocal.prototype;
$c_jl_ThreadLocal.prototype.init___ = (function() {
  this.hasValue$1 = false;
  return this
});
$c_jl_ThreadLocal.prototype.remove__V = (function() {
  this.hasValue$1 = false;
  this.v$1 = null
});
$c_jl_ThreadLocal.prototype.get__O = (function() {
  var x = this.hasValue$1;
  if ((!$uZ(x))) {
    this.set__O__V(this.initialValue__O())
  };
  return this.v$1
});
$c_jl_ThreadLocal.prototype.set__O__V = (function(o) {
  this.v$1 = o;
  this.hasValue$1 = true
});
$c_jl_ThreadLocal.prototype.initialValue__O = (function() {
  return null
});
var $d_jl_ThreadLocal = new $TypeData().initClass({
  jl_ThreadLocal: 0
}, false, "java.lang.ThreadLocal", {
  jl_ThreadLocal: 1,
  O: 1
});
$c_jl_ThreadLocal.prototype.$classData = $d_jl_ThreadLocal;
/** @constructor */
function $c_jl_reflect_Array$() {
  $c_O.call(this)
}
$c_jl_reflect_Array$.prototype = new $h_O();
$c_jl_reflect_Array$.prototype.constructor = $c_jl_reflect_Array$;
/** @constructor */
function $h_jl_reflect_Array$() {
  /*<skip>*/
}
$h_jl_reflect_Array$.prototype = $c_jl_reflect_Array$.prototype;
$c_jl_reflect_Array$.prototype.init___ = (function() {
  return this
});
$c_jl_reflect_Array$.prototype.newInstance__jl_Class__I__O = (function(componentType, length) {
  return componentType.newArrayOfThisClass__sjs_js_Array__O([length])
});
var $d_jl_reflect_Array$ = new $TypeData().initClass({
  jl_reflect_Array$: 0
}, false, "java.lang.reflect.Array$", {
  jl_reflect_Array$: 1,
  O: 1
});
$c_jl_reflect_Array$.prototype.$classData = $d_jl_reflect_Array$;
var $n_jl_reflect_Array$ = (void 0);
function $m_jl_reflect_Array$() {
  if ((!$n_jl_reflect_Array$)) {
    $n_jl_reflect_Array$ = new $c_jl_reflect_Array$().init___()
  };
  return $n_jl_reflect_Array$
}
/** @constructor */
function $c_ju_AbstractMap$() {
  $c_O.call(this)
}
$c_ju_AbstractMap$.prototype = new $h_O();
$c_ju_AbstractMap$.prototype.constructor = $c_ju_AbstractMap$;
/** @constructor */
function $h_ju_AbstractMap$() {
  /*<skip>*/
}
$h_ju_AbstractMap$.prototype = $c_ju_AbstractMap$.prototype;
$c_ju_AbstractMap$.prototype.init___ = (function() {
  return this
});
$c_ju_AbstractMap$.prototype.java$util$AbstractMap$$entryHashCode__ju_Map$Entry__I = (function(entry) {
  var keyHash = ((entry.getKey__O() === null) ? 0 : $objectHashCode(entry.getKey__O()));
  var valueHash = ((entry.getValue__O() === null) ? 0 : $objectHashCode(entry.getValue__O()));
  return (keyHash ^ valueHash)
});
$c_ju_AbstractMap$.prototype.java$util$AbstractMap$$entryEquals__ju_Map$Entry__O__Z = (function(entry, other) {
  if ($is_ju_Map$Entry(other)) {
    var x2 = $as_ju_Map$Entry(other);
    var self = entry.getKey__O();
    var that = x2.getKey__O();
    if (((self === null) ? (that === null) : $objectEquals(self, that))) {
      var self$1 = entry.getValue__O();
      var that$1 = x2.getValue__O();
      return ((self$1 === null) ? (that$1 === null) : $objectEquals(self$1, that$1))
    } else {
      return false
    }
  } else {
    return false
  }
});
var $d_ju_AbstractMap$ = new $TypeData().initClass({
  ju_AbstractMap$: 0
}, false, "java.util.AbstractMap$", {
  ju_AbstractMap$: 1,
  O: 1
});
$c_ju_AbstractMap$.prototype.$classData = $d_ju_AbstractMap$;
var $n_ju_AbstractMap$ = (void 0);
function $m_ju_AbstractMap$() {
  if ((!$n_ju_AbstractMap$)) {
    $n_ju_AbstractMap$ = new $c_ju_AbstractMap$().init___()
  };
  return $n_ju_AbstractMap$
}
/** @constructor */
function $c_ju_Arrays$() {
  $c_O.call(this)
}
$c_ju_Arrays$.prototype = new $h_O();
$c_ju_Arrays$.prototype.constructor = $c_ju_Arrays$;
/** @constructor */
function $h_ju_Arrays$() {
  /*<skip>*/
}
$h_ju_Arrays$.prototype = $c_ju_Arrays$.prototype;
$c_ju_Arrays$.prototype.equals__AO__AO__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.init___ = (function() {
  return this
});
$c_ju_Arrays$.prototype.binarySearch__AJ__J__I = (function(a, key) {
  var startIndex = 0;
  var endIndex = a.u.length;
  _binarySearchImpl: while (true) {
    if ((startIndex === endIndex)) {
      return (((-1) - startIndex) | 0)
    } else {
      var mid = ((((startIndex + endIndex) | 0) >>> 1) | 0);
      var elem = a.get(mid);
      var t = $uJ(elem);
      var lo = t.lo$2;
      var hi = t.hi$2;
      var ahi = key.hi$2;
      if (((ahi === hi) ? (((-2147483648) ^ key.lo$2) < ((-2147483648) ^ lo)) : (ahi < hi))) {
        endIndex = mid;
        continue _binarySearchImpl
      } else if ($m_sr_BoxesRunTime$().equals__O__O__Z(key, elem)) {
        return mid
      } else {
        startIndex = ((1 + mid) | 0);
        continue _binarySearchImpl
      }
    }
  }
});
$c_ju_Arrays$.prototype.equals__AD__AD__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AI__AI__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AF__AF__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AJ__AJ__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.binarySearch__AI__I__I = (function(a, key) {
  var startIndex = 0;
  var endIndex = a.u.length;
  _binarySearchImpl: while (true) {
    if ((startIndex === endIndex)) {
      return (((-1) - startIndex) | 0)
    } else {
      var mid = ((((startIndex + endIndex) | 0) >>> 1) | 0);
      var elem = a.get(mid);
      if ((key < elem)) {
        endIndex = mid;
        continue _binarySearchImpl
      } else if ($m_sr_BoxesRunTime$().equals__O__O__Z(key, elem)) {
        return mid
      } else {
        startIndex = ((1 + mid) | 0);
        continue _binarySearchImpl
      }
    }
  }
});
$c_ju_Arrays$.prototype.equals__AB__AB__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AZ__AZ__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.java$util$Arrays$$insertionSortAnyRef__AO__I__I__s_math_Ordering__V = (function(a, start, end, ord) {
  var n = ((end - start) | 0);
  if ((n >= 2)) {
    if ((ord.compare__O__O__I(a.get(start), a.get(((1 + start) | 0))) > 0)) {
      var temp = a.get(start);
      a.set(start, a.get(((1 + start) | 0)));
      a.set(((1 + start) | 0), temp)
    };
    var m = 2;
    while ((m < n)) {
      var next = a.get(((start + m) | 0));
      if ((ord.compare__O__O__I(next, a.get((((-1) + ((start + m) | 0)) | 0))) < 0)) {
        var iA = start;
        var iB = (((-1) + ((start + m) | 0)) | 0);
        while ((((iB - iA) | 0) > 1)) {
          var ix = ((((iA + iB) | 0) >>> 1) | 0);
          if ((ord.compare__O__O__I(next, a.get(ix)) < 0)) {
            iB = ix
          } else {
            iA = ix
          }
        };
        var ix$2 = ((iA + ((ord.compare__O__O__I(next, a.get(iA)) < 0) ? 0 : 1)) | 0);
        var i = ((start + m) | 0);
        while ((i > ix$2)) {
          a.set(i, a.get((((-1) + i) | 0)));
          i = (((-1) + i) | 0)
        };
        a.set(ix$2, next)
      };
      m = ((1 + m) | 0)
    }
  }
});
$c_ju_Arrays$.prototype.fill__AI__I__V = (function(a, value) {
  var toIndex = a.u.length;
  var i = 0;
  while ((i !== toIndex)) {
    a.set(i, value);
    i = ((1 + i) | 0)
  }
});
$c_ju_Arrays$.prototype.equals__AC__AC__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(new $c_jl_Character().init___C(a.get(i)), new $c_jl_Character().init___C(b.get(i)))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AS__AS__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.sort__AO__ju_Comparator__V = (function(array, comparator) {
  var ord = new $c_ju_Arrays$$anon$3().init___ju_Comparator(comparator);
  var end = array.u.length;
  if ((end > 16)) {
    this.java$util$Arrays$$stableSplitMergeAnyRef__AO__AO__I__I__s_math_Ordering__V(array, $newArrayObject($d_O.getArrayOf(), [array.u.length]), 0, end, ord)
  } else {
    this.java$util$Arrays$$insertionSortAnyRef__AO__I__I__s_math_Ordering__V(array, 0, end, ord)
  }
});
$c_ju_Arrays$.prototype.java$util$Arrays$$stableSplitMergeAnyRef__AO__AO__I__I__s_math_Ordering__V = (function(a, temp, start, end, ord) {
  var length = ((end - start) | 0);
  if ((length > 16)) {
    var middle = ((start + ((length / 2) | 0)) | 0);
    this.java$util$Arrays$$stableSplitMergeAnyRef__AO__AO__I__I__s_math_Ordering__V(a, temp, start, middle, ord);
    this.java$util$Arrays$$stableSplitMergeAnyRef__AO__AO__I__I__s_math_Ordering__V(a, temp, middle, end, ord);
    var outIndex = start;
    var leftInIndex = start;
    var rightInIndex = middle;
    while ((outIndex < end)) {
      if (((leftInIndex < middle) && ((rightInIndex >= end) || ord.lteq__O__O__Z(a.get(leftInIndex), a.get(rightInIndex))))) {
        temp.set(outIndex, a.get(leftInIndex));
        leftInIndex = ((1 + leftInIndex) | 0)
      } else {
        temp.set(outIndex, a.get(rightInIndex));
        rightInIndex = ((1 + rightInIndex) | 0)
      };
      outIndex = ((1 + outIndex) | 0)
    };
    $systemArraycopy(temp, start, a, start, length)
  } else {
    this.java$util$Arrays$$insertionSortAnyRef__AO__I__I__s_math_Ordering__V(a, start, end, ord)
  }
});
var $d_ju_Arrays$ = new $TypeData().initClass({
  ju_Arrays$: 0
}, false, "java.util.Arrays$", {
  ju_Arrays$: 1,
  O: 1
});
$c_ju_Arrays$.prototype.$classData = $d_ju_Arrays$;
var $n_ju_Arrays$ = (void 0);
function $m_ju_Arrays$() {
  if ((!$n_ju_Arrays$)) {
    $n_ju_Arrays$ = new $c_ju_Arrays$().init___()
  };
  return $n_ju_Arrays$
}
function $is_ju_Collection(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_Collection)))
}
function $as_ju_Collection(obj) {
  return (($is_ju_Collection(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.Collection"))
}
function $isArrayOf_ju_Collection(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_Collection)))
}
function $asArrayOf_ju_Collection(obj, depth) {
  return (($isArrayOf_ju_Collection(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.Collection;", depth))
}
/** @constructor */
function $c_ju_Collections$() {
  $c_O.call(this);
  this.EMPTY$undSET$1 = null;
  this.EMPTY$undLIST$1 = null;
  this.EMPTY$undMAP$1 = null;
  this.EMPTY$undITERATOR$1 = null;
  this.EMPTY$undLIST$undITERATOR$1 = null;
  this.EMPTY$undENUMERATION$1 = null;
  this.bitmap$0$1 = 0
}
$c_ju_Collections$.prototype = new $h_O();
$c_ju_Collections$.prototype.constructor = $c_ju_Collections$;
/** @constructor */
function $h_ju_Collections$() {
  /*<skip>*/
}
$h_ju_Collections$.prototype = $c_ju_Collections$.prototype;
$c_ju_Collections$.prototype.init___ = (function() {
  return this
});
$c_ju_Collections$.prototype.EMPTY$undITERATOR__p1__ju_Iterator = (function() {
  return (((((8 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.EMPTY$undITERATOR$lzycompute__p1__ju_Iterator() : this.EMPTY$undITERATOR$1)
});
$c_ju_Collections$.prototype.EMPTY$undSET$lzycompute__p1__ju_Set = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.EMPTY$undSET$1 = new $c_ju_Collections$ImmutableSet().init___ju_Set(new $c_ju_Collections$$anon$11().init___());
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.EMPTY$undSET$1
});
$c_ju_Collections$.prototype.EMPTY$undMAP__ju_Map = (function() {
  return (((((4 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.EMPTY$undMAP$lzycompute__p1__ju_Map() : this.EMPTY$undMAP$1)
});
$c_ju_Collections$.prototype.EMPTY$undSET__ju_Set = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.EMPTY$undSET$lzycompute__p1__ju_Set() : this.EMPTY$undSET$1)
});
$c_ju_Collections$.prototype.EMPTY$undMAP$lzycompute__p1__ju_Map = (function() {
  if (((((4 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.EMPTY$undMAP$1 = new $c_ju_Collections$ImmutableMap().init___ju_Map(new $c_ju_Collections$$anon$17().init___());
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.EMPTY$undMAP$1
});
$c_ju_Collections$.prototype.EMPTY$undITERATOR$lzycompute__p1__ju_Iterator = (function() {
  if (((((8 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.EMPTY$undITERATOR$1 = new $c_ju_Collections$EmptyIterator().init___();
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.EMPTY$undITERATOR$1
});
var $d_ju_Collections$ = new $TypeData().initClass({
  ju_Collections$: 0
}, false, "java.util.Collections$", {
  ju_Collections$: 1,
  O: 1
});
$c_ju_Collections$.prototype.$classData = $d_ju_Collections$;
var $n_ju_Collections$ = (void 0);
function $m_ju_Collections$() {
  if ((!$n_ju_Collections$)) {
    $n_ju_Collections$ = new $c_ju_Collections$().init___()
  };
  return $n_ju_Collections$
}
/** @constructor */
function $c_ju_Dictionary() {
  $c_O.call(this)
}
$c_ju_Dictionary.prototype = new $h_O();
$c_ju_Dictionary.prototype.constructor = $c_ju_Dictionary;
/** @constructor */
function $h_ju_Dictionary() {
  /*<skip>*/
}
$h_ju_Dictionary.prototype = $c_ju_Dictionary.prototype;
/** @constructor */
function $c_ju_Formatter$() {
  $c_O.call(this);
  this.java$util$Formatter$$FormatSpecifier$1 = null
}
$c_ju_Formatter$.prototype = new $h_O();
$c_ju_Formatter$.prototype.constructor = $c_ju_Formatter$;
/** @constructor */
function $h_ju_Formatter$() {
  /*<skip>*/
}
$h_ju_Formatter$.prototype = $c_ju_Formatter$.prototype;
$c_ju_Formatter$.prototype.init___ = (function() {
  $n_ju_Formatter$ = this;
  this.java$util$Formatter$$FormatSpecifier$1 = new $g.RegExp("(?:(\\d+)\\$)?([-#+ 0,\\(<]*)(\\d+)?(?:\\.(\\d+))?[%A-Za-z]", "g");
  return this
});
var $d_ju_Formatter$ = new $TypeData().initClass({
  ju_Formatter$: 0
}, false, "java.util.Formatter$", {
  ju_Formatter$: 1,
  O: 1
});
$c_ju_Formatter$.prototype.$classData = $d_ju_Formatter$;
var $n_ju_Formatter$ = (void 0);
function $m_ju_Formatter$() {
  if ((!$n_ju_Formatter$)) {
    $n_ju_Formatter$ = new $c_ju_Formatter$().init___()
  };
  return $n_ju_Formatter$
}
/** @constructor */
function $c_ju_Locale() {
  $c_O.call(this);
  this.language$1 = null;
  this.country$1 = null;
  this.variant$1 = null;
  this.script$1 = null;
  this.unicodeExtensions$1 = null;
  this.unicodeAttributes$1 = null;
  this.extensions$1 = null
}
$c_ju_Locale.prototype = new $h_O();
$c_ju_Locale.prototype.constructor = $c_ju_Locale;
/** @constructor */
function $h_ju_Locale() {
  /*<skip>*/
}
$h_ju_Locale.prototype = $c_ju_Locale.prototype;
$c_ju_Locale.prototype.getLanguage__T = (function() {
  var thiz = this.language$1;
  return this.translateSpecialLanguages__p1__T__T($as_T(thiz.toLowerCase()))
});
$c_ju_Locale.prototype.init___T__T__T__s_Option__sc_Map__sc_Map__sc_Set__Z = (function(language, country, variant, script, _extensions, unicodeExtensions, unicodeAttributes, supportSpecialCases) {
  this.language$1 = language;
  this.country$1 = country;
  this.variant$1 = variant;
  this.script$1 = script;
  this.unicodeExtensions$1 = unicodeExtensions;
  this.unicodeAttributes$1 = unicodeAttributes;
  if ((((language === null) || (country === null)) || (variant === null))) {
    throw new $c_jl_NullPointerException().init___T("Null argument to constructor not allowed")
  };
  var x = new $c_T3().init___O__O__O(language, country, variant);
  var x$2 = new $c_T3().init___O__O__O("ja", "JP", "JP");
  if ((x.equals__O__Z(x$2) && supportSpecialCases)) {
    var c = $m_ju_Locale$().UNICODE$undLOCALE$undEXTENSION$1;
    var self = new $c_jl_Character().init___C(c);
    var jsx$1 = _extensions.$$plus__T2__sc_Map(new $c_T2().init___O__O(self, "ca-japanese"))
  } else {
    var x$3 = new $c_T3().init___O__O__O(language, country, variant);
    var x$4 = new $c_T3().init___O__O__O("th", "TH", "TH");
    if ((x$3.equals__O__Z(x$4) && supportSpecialCases)) {
      var c$1 = $m_ju_Locale$().UNICODE$undLOCALE$undEXTENSION$1;
      var self$1 = new $c_jl_Character().init___C(c$1);
      var jsx$1 = _extensions.$$plus__T2__sc_Map(new $c_T2().init___O__O(self$1, "nu-thai"))
    } else {
      var jsx$1 = _extensions
    }
  };
  this.extensions$1 = jsx$1;
  return this
});
$c_ju_Locale.prototype.equals__O__Z = (function(x) {
  if ($is_ju_Locale(x)) {
    var x2 = $as_ju_Locale(x);
    return this.isEqual__p1__ju_Locale__Z(x2)
  } else {
    return false
  }
});
$c_ju_Locale.prototype.getExtension__C__T = (function(key) {
  if ((key === $m_ju_Locale$().UNICODE$undLOCALE$undEXTENSION$1)) {
    var this$1 = this.unicodeExtensions$1;
    var jsx$1 = $f_sc_TraversableOnce__nonEmpty__Z(this$1)
  } else {
    var jsx$1 = false
  };
  if (jsx$1) {
    var this$3 = this.unicodeExtensions$1;
    var pf = new $c_ju_Locale$$anonfun$getExtension$1().init___ju_Locale(this);
    var this$2 = $m_sc_Iterable$();
    var bf = this$2.ReusableCBFInstance$2;
    return $as_sc_TraversableOnce($f_sc_TraversableLike__collect__s_PartialFunction__scg_CanBuildFrom__O(this$3, pf, bf)).mkString__T__T("-")
  } else {
    var this$6 = this.extensions$1.get__O__s_Option(new $c_jl_Character().init___C(key));
    return $as_T((this$6.isEmpty__Z() ? null : this$6.get__O()))
  }
});
$c_ju_Locale.prototype.toString__T = (function() {
  var x = this.variant$1;
  var this$2 = new $c_sci_StringOps().init___T(x);
  var hasVariant = $f_sc_TraversableOnce__nonEmpty__Z(this$2);
  var x$1 = this.getCountry__T();
  var this$4 = new $c_sci_StringOps().init___T(x$1);
  var hasCountry = $f_sc_TraversableOnce__nonEmpty__Z(this$4);
  var x$2 = this.getLanguage__T();
  var this$6 = new $c_sci_StringOps().init___T(x$2);
  var hasLanguage = $f_sc_TraversableOnce__nonEmpty__Z(this$6);
  var x$3 = this.getScript__T();
  var this$8 = new $c_sci_StringOps().init___T(x$3);
  var hasScript = $f_sc_TraversableOnce__nonEmpty__Z(this$8);
  var countryPart = (hasCountry ? new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["_", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.getCountry__T()])) : ((hasVariant || hasScript) ? "_" : ""));
  var variantPart = (hasVariant ? new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["_", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.variant$1])) : (hasScript ? "_" : ""));
  var scriptPart = ((hasScript && this.hasExtensions__Z()) ? new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["#", "_"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.getScript__T()])) : (hasScript ? new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["#", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.getScript__T()])) : (this.hasExtensions__Z() ? "_#" : "")));
  var this$14 = this.extensions$1;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$2$2) {
      var x0$2 = $as_T2(x0$2$2);
      if ((x0$2 !== null)) {
        var c = x0$2.$$und1__O();
        if ((c === null)) {
          var x$4 = 0
        } else {
          var this$10 = $as_jl_Character(c);
          var x$4 = this$10.value$1
        };
        var v = $as_T(x0$2.$$und2__O());
        return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "-", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(x$4), v]))
      } else {
        throw new $c_s_MatchError().init___O(x0$2)
      }
    })
  })(this));
  var this$13 = $m_sc_Iterable$();
  var bf = this$13.ReusableCBFInstance$2;
  var extensionsPart = $as_sc_TraversableOnce($f_sc_TraversableLike__map__F1__scg_CanBuildFrom__O(this$14, f, bf)).mkString__T__T("");
  return ((hasLanguage || hasCountry) ? new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "", "", "", "", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.getLanguage__T(), countryPart, variantPart, scriptPart, extensionsPart])) : "")
});
$c_ju_Locale.prototype.toLanguageTag__T = (function() {
  var x = this.getLanguage__T();
  var this$2 = new $c_sci_StringOps().init___T(x);
  if (($f_sc_TraversableOnce__nonEmpty__Z(this$2) && $m_ju_Locale$().checkLanguage__T__Z(this.getLanguage__T()))) {
    var language = this.updateSpecialLanguages__p1__T__T(this.getLanguage__T())
  } else {
    var language = "und"
  };
  var country = ($m_ju_Locale$().checkRegion__T__Z(this.getCountry__T()) ? new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["-", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.getCountry__T()])) : "");
  var thiz = this.variant$1;
  var variantSegments = $m_sjsr_RuntimeString$().split__T__T__I__AT(thiz, "-|_", 0);
  var i = 0;
  while (true) {
    if ((i < variantSegments.u.length)) {
      var index = i;
      var arg1 = variantSegments.get(index);
      var l = $as_T(arg1);
      var jsx$1 = ($m_ju_Locale$().checkVariantSegment__T__Z(l) === true)
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      i = ((1 + i) | 0)
    } else {
      break
    }
  };
  var allSegmentsWellFormed = (i === variantSegments.u.length);
  var i$1 = 0;
  while (true) {
    if ((i$1 < variantSegments.u.length)) {
      var index$1 = i$1;
      var arg1$1 = variantSegments.get(index$1);
      var l$3 = $as_T(arg1$1);
      var jsx$2 = ($m_ju_Locale$().checkAcceptableVariantSegment__T__Z(l$3) === true)
    } else {
      var jsx$2 = false
    };
    if (jsx$2) {
      i$1 = ((1 + i$1) | 0)
    } else {
      break
    }
  };
  var allAcceptableSegments = (i$1 === variantSegments.u.length);
  if (allSegmentsWellFormed) {
    var b = new $c_scm_StringBuilder().init___();
    var elem$1 = false;
    elem$1 = true;
    b.append__T__scm_StringBuilder("-");
    var i$2 = 0;
    var len = variantSegments.u.length;
    while ((i$2 < len)) {
      var index$2 = i$2;
      var arg1$2 = variantSegments.get(index$2);
      if (elem$1) {
        b.append__O__scm_StringBuilder(arg1$2);
        elem$1 = false
      } else {
        b.append__T__scm_StringBuilder("-");
        b.append__O__scm_StringBuilder(arg1$2)
      };
      i$2 = ((1 + i$2) | 0)
    };
    b.append__T__scm_StringBuilder("");
    var variant = b.underlying$5.java$lang$StringBuilder$$content$f
  } else if (allAcceptableSegments) {
    var l$1 = new $c_scm_ArrayBuilder$ofRef().init___s_reflect_ClassTag($m_s_reflect_ClassTag$().apply__jl_Class__s_reflect_ClassTag($objectGetClass(variantSegments).getComponentType__jl_Class()));
    var r = new $c_scm_ArrayBuilder$ofRef().init___s_reflect_ClassTag($m_s_reflect_ClassTag$().apply__jl_Class__s_reflect_ClassTag($objectGetClass(variantSegments).getComponentType__jl_Class()));
    var i$3 = 0;
    var len$1 = variantSegments.u.length;
    while ((i$3 < len$1)) {
      var index$3 = i$3;
      var arg1$3 = variantSegments.get(index$3);
      var l$4 = $as_T(arg1$3);
      if ($m_ju_Locale$().checkVariantSegment__T__Z(l$4)) {
        var this$21 = l$1
      } else {
        var this$21 = r
      };
      this$21.$$plus$eq__O__scm_ArrayBuilder$ofRef(arg1$3);
      i$3 = ((1 + i$3) | 0)
    };
    var _1 = l$1.result__AO();
    var _2 = r.result__AO();
    var wellFormed = $asArrayOf_T(_1, 1);
    var acceptable = $asArrayOf_T(_2, 1);
    if ((wellFormed.u.length !== 0)) {
      var y = wellFormed.u.length;
      var hi = ((y > 1) ? 1 : y);
      var size = ((hi > 0) ? hi : 0);
      var result = $m_jl_reflect_Array$().newInstance__jl_Class__I__O($objectGetClass(wellFormed).getComponentType__jl_Class(), size);
      if ((size > 0)) {
        $m_s_Array$().copy__O__I__O__I__I__V(wellFormed, 0, result, 0, size)
      };
      var xs = $asArrayOf_O(result, 1);
      var b$1 = new $c_scm_StringBuilder().init___();
      var elem$1$1 = false;
      elem$1$1 = true;
      b$1.append__T__scm_StringBuilder("-");
      var i$4 = 0;
      var len$2 = xs.u.length;
      while ((i$4 < len$2)) {
        var index$4 = i$4;
        var arg1$4 = xs.get(index$4);
        if (elem$1$1) {
          b$1.append__O__scm_StringBuilder(arg1$4);
          elem$1$1 = false
        } else {
          b$1.append__T__scm_StringBuilder("-");
          b$1.append__O__scm_StringBuilder(arg1$4)
        };
        i$4 = ((1 + i$4) | 0)
      };
      b$1.append__T__scm_StringBuilder("-");
      var pre = b$1.underlying$5.java$lang$StringBuilder$$content$f
    } else {
      var pre = "-"
    };
    var until = wellFormed.u.length;
    var x$1 = ((until > 0) ? until : 0);
    var y$1 = wellFormed.u.length;
    var hi$1 = ((x$1 < y$1) ? x$1 : y$1);
    var x$2 = (((-1) + hi$1) | 0);
    var size$1 = ((x$2 > 0) ? x$2 : 0);
    var result$1 = $m_jl_reflect_Array$().newInstance__jl_Class__I__O($objectGetClass(wellFormed).getComponentType__jl_Class(), size$1);
    if ((size$1 > 0)) {
      $m_s_Array$().copy__O__I__O__I__I__V(wellFormed, 1, result$1, 0, size$1)
    };
    var xs$1 = $asArrayOf_O(result$1, 1);
    var elems$2 = null;
    elems$2 = [];
    var this$54 = new $c_scm_WrappedArray$ofRef().init___AO(xs$1);
    this$54.length__I();
    var x1 = acceptable.u.length;
    switch (x1) {
      case (-1): {
        break
      }
    };
    var xs$2 = new $c_scm_WrappedArray$ofRef().init___AO(acceptable);
    var i$5 = 0;
    var len$3 = xs$2.length__I();
    while ((i$5 < len$3)) {
      var arg1$5 = xs$2.apply__I__O(i$5);
      var unboxedElem = ((arg1$5 === null) ? null : arg1$5);
      elems$2.push(unboxedElem);
      i$5 = ((1 + i$5) | 0)
    };
    var xs$3 = new $c_scm_WrappedArray$ofRef().init___AO(xs$1);
    var i$6 = 0;
    var len$4 = xs$3.length__I();
    while ((i$6 < len$4)) {
      var arg1$6 = xs$3.apply__I__O(i$6);
      var unboxedElem$1 = ((arg1$6 === null) ? null : arg1$6);
      elems$2.push(unboxedElem$1);
      i$6 = ((1 + i$6) | 0)
    };
    var xs$4 = $makeNativeArrayWrapper($d_T.getArrayOf(), elems$2);
    var b$2 = new $c_scm_StringBuilder().init___();
    var elem$1$2 = false;
    elem$1$2 = true;
    b$2.append__T__scm_StringBuilder("-");
    var i$7 = 0;
    var len$5 = xs$4.u.length;
    while ((i$7 < len$5)) {
      var index$5 = i$7;
      var arg1$7 = xs$4.get(index$5);
      if (elem$1$2) {
        b$2.append__O__scm_StringBuilder(arg1$7);
        elem$1$2 = false
      } else {
        b$2.append__T__scm_StringBuilder("-");
        b$2.append__O__scm_StringBuilder(arg1$7)
      };
      i$7 = ((1 + i$7) | 0)
    };
    b$2.append__T__scm_StringBuilder("");
    var variant = ((pre + "x-lvariant") + b$2.underlying$5.java$lang$StringBuilder$$content$f)
  } else {
    var variant = ""
  };
  var this$62 = this.extensions$1;
  if ($f_sc_TraversableOnce__nonEmpty__Z(this$62)) {
    var this$68 = this.extensions$1;
    var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
      return (function(x0$3$2) {
        var x0$3 = $as_T2(x0$3$2);
        if ((x0$3 !== null)) {
          var c = x0$3.$$und1__O();
          if ((c === null)) {
            var x$3 = 0
          } else {
            var this$64 = $as_jl_Character(c);
            var x$3 = this$64.value$1
          };
          var v = $as_T(x0$3.$$und2__O());
          return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "-", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(x$3), v]))
        } else {
          throw new $c_s_MatchError().init___O(x0$3)
        }
      })
    })(this));
    var this$67 = $m_sc_Iterable$();
    var bf = this$67.ReusableCBFInstance$2;
    var ext = $as_sc_TraversableOnce($f_sc_TraversableLike__map__F1__scg_CanBuildFrom__O(this$68, f, bf)).mkString__T__T__T__T("-", "-", "")
  } else {
    var ext = ""
  };
  var this$69 = this.script$1;
  if (this$69.isEmpty__Z()) {
    var this$70 = $m_s_None$()
  } else {
    var arg1$8 = this$69.get__O();
    $as_T(arg1$8);
    var this$70 = new $c_s_Some().init___O(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["-", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.getScript__T()])))
  };
  var script = $as_T((this$70.isEmpty__Z() ? "" : this$70.get__O()));
  return ((((this.getLanguage__T() === "no") && (this.getCountry__T() === "NO")) && (this.variant$1 === "NY")) ? "nn-NO" : new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "", "", "", "", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([language, script, country, ext, variant])))
});
$c_ju_Locale.prototype.getCountry__T = (function() {
  var thiz = this.country$1;
  return $as_T(thiz.toUpperCase())
});
$c_ju_Locale.prototype.getScript__T = (function() {
  var this$1 = this.script$1;
  return $as_T((this$1.isEmpty__Z() ? "" : this$1.get__O()))
});
$c_ju_Locale.prototype.updateSpecialLanguages__p1__T__T = (function(l) {
  return ((l === "iw") ? "he" : ((l === "ji") ? "yi" : ((l === "in") ? "id" : l)))
});
$c_ju_Locale.prototype.translateSpecialLanguages__p1__T__T = (function(l) {
  return ((l === "he") ? "iw" : ((l === "yi") ? "ji" : ((l === "id") ? "in" : l)))
});
$c_ju_Locale.prototype.getUnicodeLocaleAttributes__ju_Set = (function() {
  var this$1 = $m_sc_JavaConverters$();
  var s = this.unicodeAttributes$1;
  return $as_ju_Set($f_sc_convert_DecorateAsJava__setAsJavaSetConverter__sc_Set__sc_convert_Decorators$AsJava(this$1, s).asJava__O())
});
$c_ju_Locale.prototype.getUnicodeLocaleType__T__T = (function(key) {
  var this$1 = this.unicodeExtensions$1.get__O__s_Option(key);
  return $as_T((this$1.isEmpty__Z() ? null : this$1.get__O()))
});
$c_ju_Locale.prototype.hashCode__I = (function() {
  var this$1 = this.toLanguageTag__T();
  return $m_sjsr_RuntimeString$().hashCode__T__I(this$1)
});
$c_ju_Locale.prototype.hasExtensions__Z = (function() {
  var this$1 = this.extensions$1;
  if ($f_sc_TraversableOnce__nonEmpty__Z(this$1)) {
    return true
  } else {
    var this$2 = this.unicodeExtensions$1;
    return $f_sc_TraversableOnce__nonEmpty__Z(this$2)
  }
});
$c_ju_Locale.prototype.isEqual__p1__ju_Locale__Z = (function(l) {
  if ((((this.language$1 === l.getLanguage__T()) && (this.country$1 === l.getCountry__T())) && (this.variant$1 === l.variant$1))) {
    var this$1 = this.script$1;
    if (this$1.isEmpty__Z()) {
      var jsx$3 = true
    } else {
      var arg1 = this$1.get__O();
      var x$12 = $as_T(arg1);
      var jsx$3 = (x$12 === l.getScript__T())
    }
  } else {
    var jsx$3 = false
  };
  if (jsx$3) {
    var this$2 = this.extensions$1;
    var this$3 = this$2.iterator__sc_Iterator();
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1$1 = this$3.next__O();
      var x0$4 = $as_T2(arg1$1);
      if ((x0$4 === null)) {
        throw new $c_s_MatchError().init___O(x0$4)
      };
      var c = x0$4.$$und1__O();
      if ((c === null)) {
        var k = 0
      } else {
        var this$5 = $as_jl_Character(c);
        var k = this$5.value$1
      };
      var v = $as_T(x0$4.$$und2__O());
      res = (l.getExtension__C__T(k) === v)
    };
    var jsx$2 = res
  } else {
    var jsx$2 = false
  };
  if (jsx$2) {
    var this$6 = this.unicodeExtensions$1;
    var this$7 = this$6.iterator__sc_Iterator();
    var res$1 = true;
    while ((res$1 && this$7.hasNext__Z())) {
      var arg1$2 = this$7.next__O();
      var x0$5 = $as_T2(arg1$2);
      if ((x0$5 === null)) {
        throw new $c_s_MatchError().init___O(x0$5)
      };
      var k$1 = $as_T(x0$5.$$und1__O());
      var v$1 = $as_T(x0$5.$$und2__O());
      res$1 = (l.getUnicodeLocaleType__T__T(k$1) === v$1)
    };
    var jsx$1 = res$1
  } else {
    var jsx$1 = false
  };
  if (jsx$1) {
    var x = this.unicodeAttributes$1;
    var this$8 = $m_sc_JavaConverters$();
    var s = l.getUnicodeLocaleAttributes__ju_Set();
    var x$2 = $f_sc_convert_DecorateAsScala__asScalaSetConverter__ju_Set__sc_convert_Decorators$AsScala(this$8, s).asScala__O();
    return ((x === null) ? (x$2 === null) : $f_sc_GenSetLike__equals__O__Z(x, x$2))
  } else {
    return false
  }
});
function $is_ju_Locale(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_Locale)))
}
function $as_ju_Locale(obj) {
  return (($is_ju_Locale(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.Locale"))
}
function $isArrayOf_ju_Locale(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_Locale)))
}
function $asArrayOf_ju_Locale(obj, depth) {
  return (($isArrayOf_ju_Locale(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.Locale;", depth))
}
var $d_ju_Locale = new $TypeData().initClass({
  ju_Locale: 0
}, false, "java.util.Locale", {
  ju_Locale: 1,
  O: 1
});
$c_ju_Locale.prototype.$classData = $d_ju_Locale;
/** @constructor */
function $c_ju_Locale$() {
  $c_O.call(this);
  this.ENGLISH$1 = null;
  this.FRENCH$1 = null;
  this.GERMAN$1 = null;
  this.ITALIAN$1 = null;
  this.JAPANESE$1 = null;
  this.KOREAN$1 = null;
  this.CHINESE$1 = null;
  this.SIMPLIFIED$undCHINESE$1 = null;
  this.TRADITIONAL$undCHINESE$1 = null;
  this.FRANCE$1 = null;
  this.GERMANY$1 = null;
  this.ITALY$1 = null;
  this.JAPAN$1 = null;
  this.KOREA$1 = null;
  this.CHINA$1 = null;
  this.PRC$1 = null;
  this.TAIWAN$1 = null;
  this.UK$1 = null;
  this.US$1 = null;
  this.CANADA$1 = null;
  this.CANADA$undFRENCH$1 = null;
  this.ROOT$1 = null;
  this.PRIVATE$undUSE$undEXTENSION$1 = 0;
  this.UNICODE$undLOCALE$undEXTENSION$1 = 0;
  this.bitmap$0$1 = 0
}
$c_ju_Locale$.prototype = new $h_O();
$c_ju_Locale$.prototype.constructor = $c_ju_Locale$;
/** @constructor */
function $h_ju_Locale$() {
  /*<skip>*/
}
$h_ju_Locale$.prototype = $c_ju_Locale$.prototype;
$c_ju_Locale$.prototype.init___ = (function() {
  this.PRIVATE$undUSE$undEXTENSION$1 = 120;
  this.UNICODE$undLOCALE$undEXTENSION$1 = 117;
  return this
});
$c_ju_Locale$.prototype.US$lzycompute__p1__ju_Locale = (function() {
  if (((262144 & this.bitmap$0$1) === 0)) {
    this.US$1 = $m_Llocales_LocaleRegistry$().en$undUS__Llocales_cldr_LDML().toLocale__ju_Locale();
    this.bitmap$0$1 = (262144 | this.bitmap$0$1)
  };
  return this.US$1
});
$c_ju_Locale$.prototype.checkVariant__T__Z = (function(l) {
  var parts = $m_sjsr_RuntimeString$().split__T__T__I__AT(l, "-|_", 0);
  var i = 0;
  while (true) {
    if ((i < parts.u.length)) {
      var index = i;
      var arg1 = parts.get(index);
      var l$2 = $as_T(arg1);
      var jsx$1 = (this.checkVariantSegment__T__Z(l$2) === true)
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      i = ((1 + i) | 0)
    } else {
      break
    }
  };
  return (i === parts.u.length)
});
$c_ju_Locale$.prototype.checkVariantSegment__T__Z = (function(l) {
  var this$2 = new $c_sci_StringOps().init___T("[0-9][0-9a-zA-Z]{3}");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  if (this.checkRegex__s_util_matching_Regex__T__Z(new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames), l)) {
    return true
  } else {
    var this$5 = new $c_sci_StringOps().init___T("[0-9a-zA-Z]{5,8}");
    var groupNames$1 = $m_sci_Nil$();
    var $$this$1 = this$5.repr$1;
    return this.checkRegex__s_util_matching_Regex__T__Z(new $c_s_util_matching_Regex().init___T__sc_Seq($$this$1, groupNames$1), l)
  }
});
$c_ju_Locale$.prototype.checkRegion__T__Z = (function(l) {
  var this$2 = new $c_sci_StringOps().init___T("[a-zA-Z]{2}");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  if (this.checkRegex__s_util_matching_Regex__T__Z(new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames), l)) {
    return true
  } else {
    var this$5 = new $c_sci_StringOps().init___T("[0-9]{3}");
    var groupNames$1 = $m_sci_Nil$();
    var $$this$1 = this$5.repr$1;
    return this.checkRegex__s_util_matching_Regex__T__Z(new $c_s_util_matching_Regex().init___T__sc_Seq($$this$1, groupNames$1), l)
  }
});
$c_ju_Locale$.prototype.checkAcceptableVariantSegment__T__Z = (function(l) {
  var this$2 = new $c_sci_StringOps().init___T("[0-9a-zA-Z]{1,8}");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  return this.checkRegex__s_util_matching_Regex__T__Z(new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames), l)
});
$c_ju_Locale$.prototype.checkRegex__s_util_matching_Regex__T__Z = (function(regex, s) {
  var o7 = regex.unapplySeq__jl_CharSequence__s_Option(s);
  if ((!o7.isEmpty__Z())) {
    if ((o7.get__O() !== null)) {
      var this$1 = $as_sc_LinearSeqOptimized(o7.get__O());
      var jsx$1 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$1, 0) === 0)
    } else {
      var jsx$1 = false
    }
  } else {
    var jsx$1 = false
  };
  if (jsx$1) {
    return true
  };
  return false
});
$c_ju_Locale$.prototype.checkLanguage__T__Z = (function(l) {
  var this$2 = new $c_sci_StringOps().init___T("[a-zA-Z]{2,8}");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  return this.checkRegex__s_util_matching_Regex__T__Z(new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames), l)
});
$c_ju_Locale$.prototype.checkScript__T__Z = (function(l) {
  var this$2 = new $c_sci_StringOps().init___T("[a-zA-Z]{4}");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  return this.checkRegex__s_util_matching_Regex__T__Z(new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames), l)
});
$c_ju_Locale$.prototype.US__ju_Locale = (function() {
  return (((262144 & this.bitmap$0$1) === 0) ? this.US$lzycompute__p1__ju_Locale() : this.US$1)
});
var $d_ju_Locale$ = new $TypeData().initClass({
  ju_Locale$: 0
}, false, "java.util.Locale$", {
  ju_Locale$: 1,
  O: 1
});
$c_ju_Locale$.prototype.$classData = $d_ju_Locale$;
var $n_ju_Locale$ = (void 0);
function $m_ju_Locale$() {
  if ((!$n_ju_Locale$)) {
    $n_ju_Locale$ = new $c_ju_Locale$().init___()
  };
  return $n_ju_Locale$
}
/** @constructor */
function $c_ju_Locale$Builder() {
  $c_O.call(this);
  this.builder$1 = null
}
$c_ju_Locale$Builder.prototype = new $h_O();
$c_ju_Locale$Builder.prototype.constructor = $c_ju_Locale$Builder;
/** @constructor */
function $h_ju_Locale$Builder() {
  /*<skip>*/
}
$h_ju_Locale$Builder.prototype = $c_ju_Locale$Builder.prototype;
$c_ju_Locale$Builder.prototype.init___ = (function() {
  this.builder$1 = new $c_ju_Locale$LocaleBuilder().init___Z__s_Option__s_Option__s_Option__s_Option__sc_Map__sc_Map__sc_Set(true, $m_s_None$(), $m_s_None$(), $m_s_None$(), $m_s_None$(), $m_sci_Map$EmptyMap$(), $m_sci_Map$EmptyMap$(), $m_sci_Set$EmptySet$());
  return this
});
$c_ju_Locale$Builder.prototype.setLanguage__T__ju_Locale$Builder = (function(language) {
  var this$1 = this.builder$1.language__T__s_Option(language);
  if (this$1.isEmpty__Z()) {
    throw new $c_ju_IllformedLocaleException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Invalid language ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([language])))
  };
  var arg1 = this$1.get__O();
  var x = $as_ju_Locale$LocaleBuilder(arg1);
  this.builder$1 = x;
  return this
});
$c_ju_Locale$Builder.prototype.setRegion__T__ju_Locale$Builder = (function(region) {
  var this$1 = this.builder$1.region__T__s_Option(region);
  if (this$1.isEmpty__Z()) {
    throw new $c_ju_IllformedLocaleException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Invalid region ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([region])))
  };
  var arg1 = this$1.get__O();
  var x = $as_ju_Locale$LocaleBuilder(arg1);
  this.builder$1 = x;
  return this
});
$c_ju_Locale$Builder.prototype.build__ju_Locale = (function() {
  return this.builder$1.build__ju_Locale()
});
$c_ju_Locale$Builder.prototype.setVariant__T__ju_Locale$Builder = (function(variant) {
  var this$1 = this.builder$1.variant__T__s_Option(variant);
  if (this$1.isEmpty__Z()) {
    throw new $c_ju_IllformedLocaleException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Invalid variant ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([variant])))
  };
  var arg1 = this$1.get__O();
  var x = $as_ju_Locale$LocaleBuilder(arg1);
  this.builder$1 = x;
  return this
});
$c_ju_Locale$Builder.prototype.setScript__T__ju_Locale$Builder = (function(script) {
  var this$1 = this.builder$1.script__T__s_Option(script);
  if (this$1.isEmpty__Z()) {
    throw new $c_ju_IllformedLocaleException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Invalid script ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([script])))
  };
  var arg1 = this$1.get__O();
  var x = $as_ju_Locale$LocaleBuilder(arg1);
  this.builder$1 = x;
  return this
});
var $d_ju_Locale$Builder = new $TypeData().initClass({
  ju_Locale$Builder: 0
}, false, "java.util.Locale$Builder", {
  ju_Locale$Builder: 1,
  O: 1
});
$c_ju_Locale$Builder.prototype.$classData = $d_ju_Locale$Builder;
/** @constructor */
function $c_ju_regex_GroupStartMap() {
  $c_O.call(this);
  this.mapping$1 = null
}
$c_ju_regex_GroupStartMap.prototype = new $h_O();
$c_ju_regex_GroupStartMap.prototype.constructor = $c_ju_regex_GroupStartMap;
/** @constructor */
function $h_ju_regex_GroupStartMap() {
  /*<skip>*/
}
$h_ju_regex_GroupStartMap.prototype = $c_ju_regex_GroupStartMap.prototype;
$c_ju_regex_GroupStartMap.prototype.addSiblings$1__p1__ju_regex_GroupStartMap$Node__I__I__T__T3 = (function(node, remaining, nextGroupIndex, pattern$1) {
  var x1 = this.parse$1__p1__I__I__T__T3(remaining, nextGroupIndex, pattern$1);
  if ((x1 === null)) {
    throw new $c_s_MatchError().init___O(x1)
  };
  var siblings = $as_sc_Seq(x1.$$und1$1);
  var finalRemaining = $uI(x1.$$und2$1);
  var finalGroupIndex = $uI(x1.$$und3$1);
  var this$1 = $m_sc_Seq$();
  return new $c_T3().init___O__O__O(this.simplify$1__p1__sc_Seq__sc_Seq($as_sc_Seq(siblings.$$plus$colon__O__scg_CanBuildFrom__O(node, this$1.ReusableCBFInstance$2))), finalRemaining, finalGroupIndex)
});
$c_ju_regex_GroupStartMap.prototype.parseRegex__p1__T__ju_regex_GroupStartMap$Node = (function(pattern) {
  var x1 = $as_sc_Seq(this.parse$1__p1__I__I__T__T3(0, 1, pattern).$$und1$1);
  var x = $m_sci_Nil$();
  if (x.equals__O__Z(x1)) {
    return $m_ju_regex_GroupStartMap$Node$().apply__T__ju_regex_GroupStartMap$Node("")
  };
  $m_sc_Seq$();
  var o9 = new $c_s_Some().init___O(x1);
  if (((o9.value$2 !== null) && ($as_sc_SeqLike(o9.value$2).lengthCompare__I__I(1) === 0))) {
    var n = $as_ju_regex_GroupStartMap$Node($as_sc_SeqLike(o9.value$2).apply__I__O(0));
    return n
  };
  return $m_ju_regex_GroupStartMap$Node$().apply__sc_Seq__ju_regex_GroupStartMap$Node(x1)
});
$c_ju_regex_GroupStartMap.prototype.positionEndSquareBracket$1__p1__I__T__I = (function(pIndex, pattern$1) {
  _positionEndSquareBracket: while (true) {
    if (($uI(pattern$1.length) <= pIndex)) {
      return pIndex
    } else {
      var index = pIndex;
      if ((((65535 & $uI(pattern$1.charCodeAt(index))) === 92) && ($uI(pattern$1.length) > 1))) {
        pIndex = ((2 + pIndex) | 0);
        continue _positionEndSquareBracket
      } else {
        var index$1 = pIndex;
        if (((65535 & $uI(pattern$1.charCodeAt(index$1))) === 93)) {
          return ((1 + pIndex) | 0)
        } else {
          pIndex = ((1 + pIndex) | 0);
          continue _positionEndSquareBracket
        }
      }
    }
  }
});
$c_ju_regex_GroupStartMap.prototype.simplify$1__p1__sc_Seq__sc_Seq = (function(nodes) {
  _simplify: while (true) {
    var x1 = nodes;
    var o28 = $m_s_package$().$$plus$colon$1.unapply__sc_SeqLike__s_Option(x1);
    if ((!o28.isEmpty__Z())) {
      var p3 = $as_ju_regex_GroupStartMap$Node($as_T2(o28.get__O()).$$und1__O());
      var p4 = $as_sc_Seq($as_T2(o28.get__O()).$$und2__O());
      var o27 = $m_ju_regex_GroupStartMap$UnwrappedRegexLeaf$().unapply__ju_regex_GroupStartMap$Node__s_Option(p3);
      if ((!o27.isEmpty__Z())) {
        var r1 = $as_T(o27.get__O());
        var o26 = $m_s_package$().$$plus$colon$1.unapply__sc_SeqLike__s_Option(p4);
        if ((!o26.isEmpty__Z())) {
          var p7 = $as_ju_regex_GroupStartMap$Node($as_T2(o26.get__O()).$$und1__O());
          var tail = $as_sc_Seq($as_T2(o26.get__O()).$$und2__O());
          var o25 = $m_ju_regex_GroupStartMap$UnwrappedRegexLeaf$().unapply__ju_regex_GroupStartMap$Node__s_Option(p7);
          if ((!o25.isEmpty__Z())) {
            var r2 = $as_T(o25.get__O());
            if (((((!$m_ju_regex_GroupStartMap$().java$util$regex$GroupStartMap$$isBackReference__T__Z(r1)) && (r1 !== "|")) && (!$m_ju_regex_GroupStartMap$().java$util$regex$GroupStartMap$$isBackReference__T__Z(r2))) && (r2 !== "|"))) {
              var x$14 = $m_ju_regex_GroupStartMap$Node$().apply__T__ju_regex_GroupStartMap$Node((("" + r1) + r2));
              var this$1 = $m_sc_Seq$();
              nodes = $as_sc_Seq(tail.$$plus$colon__O__scg_CanBuildFrom__O(x$14, this$1.ReusableCBFInstance$2));
              continue _simplify
            }
          }
        }
      }
    };
    var o33 = $m_s_package$().$$plus$colon$1.unapply__sc_SeqLike__s_Option(x1);
    if ((!o33.isEmpty__Z())) {
      var n = $as_ju_regex_GroupStartMap$Node($as_T2(o33.get__O()).$$und1__O());
      var p10 = $as_sc_Seq($as_T2(o33.get__O()).$$und2__O());
      var o32 = $m_s_package$().$$plus$colon$1.unapply__sc_SeqLike__s_Option(p10);
      if ((!o32.isEmpty__Z())) {
        var p12 = $as_ju_regex_GroupStartMap$Node($as_T2(o32.get__O()).$$und1__O());
        var tail$2 = $as_sc_Seq($as_T2(o32.get__O()).$$und2__O());
        var o31 = $m_ju_regex_GroupStartMap$Node$().unapply__ju_regex_GroupStartMap$Node__s_Option(p12);
        if ((!o31.isEmpty__Z())) {
          var p14 = $as_ju_regex_GroupStartMap$OriginalRegex($as_T2(o31.get__O()).$$und1__O());
          var p15 = $as_ju_regex_GroupStartMap$NodeType($as_T2(o31.get__O()).$$und2__O());
          if ($is_ju_regex_GroupStartMap$OriginallyWrapped(p14)) {
            var x16 = $as_ju_regex_GroupStartMap$OriginallyWrapped(p14);
            var o30 = $m_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$().unapply__ju_regex_GroupStartMap$OriginallyWrapped__s_Option(x16);
            if ((!o30.isEmpty__Z())) {
              var modifier = $as_T(o30.get__O());
              if ($is_ju_regex_GroupStartMap$RegexLeaf(p15)) {
                var x18 = $as_ju_regex_GroupStartMap$RegexLeaf(p15);
                var p19 = x18.regex$1;
                if ((p19 === "")) {
                  var o13 = $m_ju_regex_GroupStartMap$Node$().unapply__ju_regex_GroupStartMap$Node__s_Option(n);
                  if ((!o13.isEmpty__Z())) {
                    var p3$2 = $as_ju_regex_GroupStartMap$OriginalRegex($as_T2(o13.get__O()).$$und1__O());
                    var m = $as_ju_regex_GroupStartMap$NodeType($as_T2(o13.get__O()).$$und2__O());
                    if ($is_ju_regex_GroupStartMap$OriginallyWrapped(p3$2)) {
                      var x4 = $as_ju_regex_GroupStartMap$OriginallyWrapped(p3$2);
                      var left = x4.left$1;
                      var right = x4.right$1;
                      var originalGroup = new $c_ju_regex_GroupStartMap$OriginallyWrapped().init___T__T(left, (("" + right) + modifier));
                      var x$15 = new $c_ju_regex_GroupStartMap$Node().init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType(originalGroup, m);
                      var this$3 = $m_sc_Seq$();
                      nodes = $as_sc_Seq(tail$2.$$plus$colon__O__scg_CanBuildFrom__O(x$15, this$3.ReusableCBFInstance$2));
                      continue _simplify
                    }
                  };
                  var o15 = $m_ju_regex_GroupStartMap$Node$().unapply__ju_regex_GroupStartMap$Node__s_Option(n);
                  if ((!o15.isEmpty__Z())) {
                    var p6 = $as_ju_regex_GroupStartMap$OriginalRegex($as_T2(o15.get__O()).$$und1__O());
                    if ($is_ju_regex_GroupStartMap$OriginallyGroupped(p6)) {
                      var originalGroup$1 = new $c_ju_regex_GroupStartMap$OriginallyWrapped().init___T__T("", modifier);
                      var jsx$1 = $m_sc_Seq$();
                      var array = [n];
                      var nodeType = new $c_ju_regex_GroupStartMap$ParentNode().init___sc_Seq($as_sc_Seq(jsx$1.apply__sc_Seq__sc_GenTraversable(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array))));
                      var x$16 = new $c_ju_regex_GroupStartMap$Node().init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType(originalGroup$1, nodeType);
                      var this$7 = $m_sc_Seq$();
                      nodes = $as_sc_Seq(tail$2.$$plus$colon__O__scg_CanBuildFrom__O(x$16, this$7.ReusableCBFInstance$2));
                      continue _simplify
                    }
                  };
                  throw new $c_s_MatchError().init___O(n)
                }
              }
            }
          }
        }
      }
    };
    return nodes
  }
});
$c_ju_regex_GroupStartMap.prototype.parse$1__p1__I__I__T__T3 = (function(pIndex, nextGroupIndex, pattern$1) {
  if ((pIndex >= $uI(pattern$1.length))) {
    return new $c_T3().init___O__O__O($m_sc_Seq$().apply__sc_Seq__sc_GenTraversable($m_sci_Nil$()), pIndex, nextGroupIndex)
  } else {
    var x1 = (65535 & $uI(pattern$1.charCodeAt(pIndex)));
    switch (x1) {
      case 40: {
        if (($uI(pattern$1.length) >= ((3 + pIndex) | 0))) {
          var index = ((1 + pIndex) | 0);
          var jsx$2 = ((65535 & $uI(pattern$1.charCodeAt(index))) === 63)
        } else {
          var jsx$2 = false
        };
        if (jsx$2) {
          var index$1 = ((2 + pIndex) | 0);
          if (((65535 & $uI(pattern$1.charCodeAt(index$1))) === 61)) {
            var jsx$1 = true
          } else {
            var index$2 = ((2 + pIndex) | 0);
            var jsx$1 = ((65535 & $uI(pattern$1.charCodeAt(index$2))) === 33)
          }
        } else {
          var jsx$1 = false
        };
        if (jsx$1) {
          var x1$2 = this.parse$1__p1__I__I__T__T3(((3 + pIndex) | 0), nextGroupIndex, pattern$1);
          if ((x1$2 === null)) {
            throw new $c_s_MatchError().init___O(x1$2)
          };
          var parsed = $as_sc_Seq(x1$2.$$und1$1);
          var remaining = $uI(x1$2.$$und2$1);
          var newNextGroupIndex = $uI(x1$2.$$und3$1);
          var remaining1 = this.parseClosingParenthesis$1__p1__I__I(remaining);
          var index$3 = ((2 + pIndex) | 0);
          var c = (65535 & $uI(pattern$1.charCodeAt(index$3)));
          var originalGroup = new $c_ju_regex_GroupStartMap$OriginallyWrapped().init___T__T(("(?" + new $c_jl_Character().init___C(c)), ")");
          var nodeType = $m_ju_regex_GroupStartMap$CreateParentNode$().apply__sc_Seq__ju_regex_GroupStartMap$NodeType(parsed);
          return this.addSiblings$1__p1__ju_regex_GroupStartMap$Node__I__I__T__T3(new $c_ju_regex_GroupStartMap$Node().init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType(originalGroup, nodeType), remaining1, newNextGroupIndex, pattern$1)
        } else {
          if (($uI(pattern$1.length) < ((3 + pIndex) | 0))) {
            var jsx$4 = true
          } else {
            var index$4 = ((1 + pIndex) | 0);
            var jsx$4 = ((65535 & $uI(pattern$1.charCodeAt(index$4))) !== 63)
          };
          if (jsx$4) {
            var jsx$3 = true
          } else {
            var index$5 = ((2 + pIndex) | 0);
            var jsx$3 = ((65535 & $uI(pattern$1.charCodeAt(index$5))) !== 58)
          };
          if (jsx$3) {
            var x1$3 = this.parse$1__p1__I__I__T__T3(((1 + pIndex) | 0), ((1 + nextGroupIndex) | 0), pattern$1);
            if ((x1$3 === null)) {
              throw new $c_s_MatchError().init___O(x1$3)
            };
            var parsed$3 = $as_sc_Seq(x1$3.$$und1$1);
            var remaining$3 = $uI(x1$3.$$und2$1);
            var newNextGroupIndex$3 = $uI(x1$3.$$und3$1);
            var remaining1$2 = this.parseClosingParenthesis$1__p1__I__I(remaining$3);
            var originalGroup$1 = new $c_ju_regex_GroupStartMap$OriginallyGroupped().init___I(nextGroupIndex);
            var nodeType$1 = $m_ju_regex_GroupStartMap$CreateParentNode$().apply__sc_Seq__ju_regex_GroupStartMap$NodeType(parsed$3);
            return this.addSiblings$1__p1__ju_regex_GroupStartMap$Node__I__I__T__T3(new $c_ju_regex_GroupStartMap$Node().init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType(originalGroup$1, nodeType$1).simplify__ju_regex_GroupStartMap$Node(), remaining1$2, newNextGroupIndex$3, pattern$1)
          } else {
            if (($uI(pattern$1.length) >= ((3 + pIndex) | 0))) {
              var index$6 = ((1 + pIndex) | 0);
              var jsx$6 = ((65535 & $uI(pattern$1.charCodeAt(index$6))) === 63)
            } else {
              var jsx$6 = false
            };
            if (jsx$6) {
              var index$7 = ((2 + pIndex) | 0);
              var jsx$5 = ((65535 & $uI(pattern$1.charCodeAt(index$7))) === 58)
            } else {
              var jsx$5 = false
            };
            if (jsx$5) {
              var x1$4 = this.parse$1__p1__I__I__T__T3(((3 + pIndex) | 0), nextGroupIndex, pattern$1);
              if ((x1$4 === null)) {
                throw new $c_s_MatchError().init___O(x1$4)
              };
              var parsedNodes = $as_sc_Seq(x1$4.$$und1$1);
              var remaining$5 = $uI(x1$4.$$und2$1);
              var newNextGroupIndex$5 = $uI(x1$4.$$und3$1);
              var remaining1$3 = this.parseClosingParenthesis$1__p1__I__I(remaining$5);
              return this.addSiblings$1__p1__ju_regex_GroupStartMap$Node__I__I__T__T3($m_ju_regex_GroupStartMap$Node$().apply__sc_Seq__ju_regex_GroupStartMap$Node(parsedNodes).simplify__ju_regex_GroupStartMap$Node(), remaining1$3, newNextGroupIndex$5, pattern$1)
            } else {
              return this.default$1__p1__T__I__I__T3(pattern$1, pIndex, nextGroupIndex)
            }
          }
        };
        break
      }
      case 41: {
        return new $c_T3().init___O__O__O($m_sc_Seq$().apply__sc_Seq__sc_GenTraversable($m_sci_Nil$()), pIndex, nextGroupIndex);
        break
      }
      case 92: {
        if (($uI(pattern$1.length) >= ((2 + pIndex) | 0))) {
          var index$8 = ((1 + pIndex) | 0);
          var c$1 = (65535 & $uI(pattern$1.charCodeAt(index$8)));
          var this$42 = $m_jl_Character$();
          if (this$42.isDigit__I__Z(c$1)) {
            var nextIndex = this.positionAfterLastDigit$1__p1__I__T__I(((1 + pIndex) | 0), pattern$1)
          } else {
            var nextIndex = ((2 + pIndex) | 0)
          };
          var regexPart = $as_T(pattern$1.substring(pIndex, nextIndex));
          return this.addSiblings$1__p1__ju_regex_GroupStartMap$Node__I__I__T__T3($m_ju_regex_GroupStartMap$Node$().apply__T__ju_regex_GroupStartMap$Node(regexPart), nextIndex, nextGroupIndex, pattern$1)
        } else {
          return this.default$1__p1__T__I__I__T3(pattern$1, pIndex, nextGroupIndex)
        };
        break
      }
      case 43:
      case 42:
      case 63: {
        if (($uI(pattern$1.length) >= ((2 + pIndex) | 0))) {
          var index$9 = ((1 + pIndex) | 0);
          var jsx$7 = ((65535 & $uI(pattern$1.charCodeAt(index$9))) === 63)
        } else {
          var jsx$7 = false
        };
        if (jsx$7) {
          var nextIndex$2 = ((2 + pIndex) | 0)
        } else {
          var nextIndex$2 = ((1 + pIndex) | 0)
        };
        var repeater = $as_T(pattern$1.substring(pIndex, nextIndex$2));
        var originalGroup$2 = new $c_ju_regex_GroupStartMap$OriginallyWrapped().init___T__T("", repeater);
        var nodeType$2 = new $c_ju_regex_GroupStartMap$RegexLeaf().init___T("");
        return this.addSiblings$1__p1__ju_regex_GroupStartMap$Node__I__I__T__T3(new $c_ju_regex_GroupStartMap$Node().init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType(originalGroup$2, nodeType$2), nextIndex$2, nextGroupIndex, pattern$1);
        break
      }
      case 123: {
        var nextIndex$3 = this.positionEndNextBrace$1__p1__I__T__I(((1 + pIndex) | 0), pattern$1);
        var repeater$2 = $as_T(pattern$1.substring(pIndex, nextIndex$3));
        var originalGroup$3 = new $c_ju_regex_GroupStartMap$OriginallyWrapped().init___T__T("", repeater$2);
        var nodeType$3 = new $c_ju_regex_GroupStartMap$RegexLeaf().init___T("");
        return this.addSiblings$1__p1__ju_regex_GroupStartMap$Node__I__I__T__T3(new $c_ju_regex_GroupStartMap$Node().init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType(originalGroup$3, nodeType$3), nextIndex$3, nextGroupIndex, pattern$1);
        break
      }
      case 91: {
        var remaining$7 = this.positionEndSquareBracket$1__p1__I__T__I(((1 + pIndex) | 0), pattern$1);
        var inside = $as_T(pattern$1.substring(pIndex, remaining$7));
        return this.addSiblings$1__p1__ju_regex_GroupStartMap$Node__I__I__T__T3($m_ju_regex_GroupStartMap$Node$().apply__T__ju_regex_GroupStartMap$Node(inside), remaining$7, nextGroupIndex, pattern$1);
        break
      }
      default: {
        return this.default$1__p1__T__I__I__T3(pattern$1, pIndex, nextGroupIndex)
      }
    }
  }
});
$c_ju_regex_GroupStartMap.prototype.parseClosingParenthesis$1__p1__I__I = (function(pIndex) {
  return ((1 + pIndex) | 0)
});
$c_ju_regex_GroupStartMap.prototype.positionEndNextBrace$1__p1__I__T__I = (function(pIndex, pattern$1) {
  _positionEndNextBrace: while (true) {
    if (($uI(pattern$1.length) <= pIndex)) {
      return pIndex
    } else {
      var index = pIndex;
      if (((65535 & $uI(pattern$1.charCodeAt(index))) === 125)) {
        return ((1 + pIndex) | 0)
      } else {
        pIndex = ((1 + pIndex) | 0);
        continue _positionEndNextBrace
      }
    }
  }
});
$c_ju_regex_GroupStartMap.prototype.init___T__I__ju_regex_Pattern = (function(string, start, pattern) {
  var node = this.parseRegex__p1__T__ju_regex_GroupStartMap$Node(pattern.jsPattern__T());
  var flags = pattern.jsFlags__T();
  node.setNewGroup__I__I(1);
  var groupNodeMap = node.getGroupNodeMap__sci_Map();
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(kv$2) {
      var kv = $as_T2(kv$2);
      return new $c_s_Tuple2$mcII$sp().init___I__I(kv.$$und1$mcI$sp__I(), $as_ju_regex_GroupStartMap$Node(kv.$$und2__O()).newGroup$1)
    })
  })(this));
  var this$1 = $m_sci_Map$();
  var bf = new $c_scg_GenMapFactory$MapCanBuildFrom().init___scg_GenMapFactory(this$1);
  node.transformGroupNumber__sci_Map__ju_regex_GroupStartMap$Node($as_sci_Map($f_sc_TraversableLike__map__F1__scg_CanBuildFrom__O(groupNodeMap, f, bf)));
  var allMatchingRegexStr = node.buildRegex__T();
  var allMatchingRegex = new $g.RegExp(allMatchingRegexStr, flags);
  allMatchingRegex.lastIndex = start;
  var allMatchResult = allMatchingRegex.exec(string);
  if ((allMatchResult === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_Exception().init___T((((((("[Internal error] Executed '" + allMatchingRegex) + "' on ") + ((("'" + string) + "' at position ") + start)) + ", got an error.\n") + ("Original pattern '" + pattern)) + "' did match however.")))
  };
  node.setMatch__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2, allMatchResult$1) {
    return (function(x$2) {
      var x = $uI(x$2);
      var value = allMatchResult$1[x];
      return $as_T(((value === (void 0)) ? null : value))
    })
  })(this, allMatchResult)));
  node.setStartReturnEnd__I__I(start);
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1) {
    return (function(kv$3$2) {
      var kv$3 = $as_T2(kv$3$2);
      return new $c_s_Tuple2$mcII$sp().init___I__I(kv$3.$$und1$mcI$sp__I(), $as_ju_regex_GroupStartMap$Node(kv$3.$$und2__O()).start$1)
    })
  })(this));
  var this$8 = $m_sci_Map$();
  var bf$1 = new $c_scg_GenMapFactory$MapCanBuildFrom().init___scg_GenMapFactory(this$8);
  this.mapping$1 = $as_F1($f_sc_TraversableLike__map__F1__scg_CanBuildFrom__O(groupNodeMap, f$1, bf$1));
  return this
});
$c_ju_regex_GroupStartMap.prototype.default$1__p1__T__I__I__T3 = (function(pattern$1, pIndex$1, nextGroupIndex$1) {
  var e = (65535 & $uI(pattern$1.charCodeAt(pIndex$1)));
  return this.addSiblings$1__p1__ju_regex_GroupStartMap$Node__I__I__T__T3($m_ju_regex_GroupStartMap$Node$().apply__T__ju_regex_GroupStartMap$Node(("" + new $c_jl_Character().init___C(e))), ((1 + pIndex$1) | 0), nextGroupIndex$1, pattern$1)
});
$c_ju_regex_GroupStartMap.prototype.positionAfterLastDigit$1__p1__I__T__I = (function(pIndex, pattern$1) {
  _positionAfterLastDigit: while (true) {
    if ((pIndex < $uI(pattern$1.length))) {
      var index = pIndex;
      var c = (65535 & $uI(pattern$1.charCodeAt(index)));
      var this$7 = $m_jl_Character$();
      var jsx$1 = this$7.isDigit__I__Z(c)
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      pIndex = ((1 + pIndex) | 0);
      continue _positionAfterLastDigit
    } else {
      return pIndex
    }
  }
});
var $d_ju_regex_GroupStartMap = new $TypeData().initClass({
  ju_regex_GroupStartMap: 0
}, false, "java.util.regex.GroupStartMap", {
  ju_regex_GroupStartMap: 1,
  O: 1
});
$c_ju_regex_GroupStartMap.prototype.$classData = $d_ju_regex_GroupStartMap;
/** @constructor */
function $c_ju_regex_GroupStartMap$() {
  $c_O.call(this)
}
$c_ju_regex_GroupStartMap$.prototype = new $h_O();
$c_ju_regex_GroupStartMap$.prototype.constructor = $c_ju_regex_GroupStartMap$;
/** @constructor */
function $h_ju_regex_GroupStartMap$() {
  /*<skip>*/
}
$h_ju_regex_GroupStartMap$.prototype = $c_ju_regex_GroupStartMap$.prototype;
$c_ju_regex_GroupStartMap$.prototype.init___ = (function() {
  return this
});
$c_ju_regex_GroupStartMap$.prototype.apply__T__I__ju_regex_Pattern__F1 = (function(string, start, pattern) {
  return new $c_ju_regex_GroupStartMap().init___T__I__ju_regex_Pattern(string, start, pattern).mapping$1
});
$c_ju_regex_GroupStartMap$.prototype.java$util$regex$GroupStartMap$$isBackReference__T__Z = (function(r) {
  if ((($uI(r.length) >= 2) && ((65535 & $uI(r.charCodeAt(0))) === 92))) {
    var this$6 = new $c_sci_StringOps().init___T(r);
    var x = $as_T($f_sc_IndexedSeqOptimized__tail__O(this$6));
    var this$8 = new $c_sci_StringOps().init___T(x);
    var i = 0;
    while (true) {
      var jsx$2 = i;
      var $$this = this$8.repr$1;
      if ((jsx$2 < $uI($$this.length))) {
        var arg1 = this$8.apply__I__O(i);
        if ((arg1 === null)) {
          var x$5 = 0
        } else {
          var this$12 = $as_jl_Character(arg1);
          var x$5 = this$12.value$1
        };
        var this$15 = $m_jl_Character$();
        var jsx$1 = (this$15.isDigit__I__Z(x$5) === true)
      } else {
        var jsx$1 = false
      };
      if (jsx$1) {
        i = ((1 + i) | 0)
      } else {
        break
      }
    };
    var jsx$3 = i;
    var $$this$1 = this$8.repr$1;
    return (jsx$3 === $uI($$this$1.length))
  } else {
    return false
  }
});
var $d_ju_regex_GroupStartMap$ = new $TypeData().initClass({
  ju_regex_GroupStartMap$: 0
}, false, "java.util.regex.GroupStartMap$", {
  ju_regex_GroupStartMap$: 1,
  O: 1
});
$c_ju_regex_GroupStartMap$.prototype.$classData = $d_ju_regex_GroupStartMap$;
var $n_ju_regex_GroupStartMap$ = (void 0);
function $m_ju_regex_GroupStartMap$() {
  if ((!$n_ju_regex_GroupStartMap$)) {
    $n_ju_regex_GroupStartMap$ = new $c_ju_regex_GroupStartMap$().init___()
  };
  return $n_ju_regex_GroupStartMap$
}
/** @constructor */
function $c_ju_regex_GroupStartMap$BackReferenceLeaf$() {
  $c_O.call(this)
}
$c_ju_regex_GroupStartMap$BackReferenceLeaf$.prototype = new $h_O();
$c_ju_regex_GroupStartMap$BackReferenceLeaf$.prototype.constructor = $c_ju_regex_GroupStartMap$BackReferenceLeaf$;
/** @constructor */
function $h_ju_regex_GroupStartMap$BackReferenceLeaf$() {
  /*<skip>*/
}
$h_ju_regex_GroupStartMap$BackReferenceLeaf$.prototype = $c_ju_regex_GroupStartMap$BackReferenceLeaf$.prototype;
$c_ju_regex_GroupStartMap$BackReferenceLeaf$.prototype.init___ = (function() {
  return this
});
$c_ju_regex_GroupStartMap$BackReferenceLeaf$.prototype.unapply__ju_regex_GroupStartMap$RegexLeaf__s_Option = (function(leaf) {
  var r = leaf.regex$1;
  if ($m_ju_regex_GroupStartMap$().java$util$regex$GroupStartMap$$isBackReference__T__Z(r)) {
    var x = $as_T(r.substring(1));
    var this$4 = new $c_sci_StringOps().init___T(x);
    var this$6 = $m_jl_Integer$();
    var $$this = this$4.repr$1;
    return new $c_s_Some().init___O(this$6.parseInt__T__I__I($$this, 10))
  } else {
    return $m_s_None$()
  }
});
var $d_ju_regex_GroupStartMap$BackReferenceLeaf$ = new $TypeData().initClass({
  ju_regex_GroupStartMap$BackReferenceLeaf$: 0
}, false, "java.util.regex.GroupStartMap$BackReferenceLeaf$", {
  ju_regex_GroupStartMap$BackReferenceLeaf$: 1,
  O: 1
});
$c_ju_regex_GroupStartMap$BackReferenceLeaf$.prototype.$classData = $d_ju_regex_GroupStartMap$BackReferenceLeaf$;
var $n_ju_regex_GroupStartMap$BackReferenceLeaf$ = (void 0);
function $m_ju_regex_GroupStartMap$BackReferenceLeaf$() {
  if ((!$n_ju_regex_GroupStartMap$BackReferenceLeaf$)) {
    $n_ju_regex_GroupStartMap$BackReferenceLeaf$ = new $c_ju_regex_GroupStartMap$BackReferenceLeaf$().init___()
  };
  return $n_ju_regex_GroupStartMap$BackReferenceLeaf$
}
/** @constructor */
function $c_ju_regex_GroupStartMap$CreateParentNode$() {
  $c_O.call(this)
}
$c_ju_regex_GroupStartMap$CreateParentNode$.prototype = new $h_O();
$c_ju_regex_GroupStartMap$CreateParentNode$.prototype.constructor = $c_ju_regex_GroupStartMap$CreateParentNode$;
/** @constructor */
function $h_ju_regex_GroupStartMap$CreateParentNode$() {
  /*<skip>*/
}
$h_ju_regex_GroupStartMap$CreateParentNode$.prototype = $c_ju_regex_GroupStartMap$CreateParentNode$.prototype;
$c_ju_regex_GroupStartMap$CreateParentNode$.prototype.init___ = (function() {
  return this
});
$c_ju_regex_GroupStartMap$CreateParentNode$.prototype.apply__sc_Seq__ju_regex_GroupStartMap$NodeType = (function(children) {
  var $in = children.toList__sci_List();
  var $in$1 = $in;
  var res = $m_sci_Nil$();
  var acc = $m_sci_Nil$();
  var disjuncts;
  _splitWhereAux: while (true) {
    var x1 = $in$1;
    var x$2 = $m_sci_Nil$();
    if ((!x$2.equals__O__Z(x1))) {
      if ($is_sci_$colon$colon(x1)) {
        var x2 = $as_sci_$colon$colon(x1);
        var head = x2.head$5;
        var tail = x2.tl$5;
        var c = $as_ju_regex_GroupStartMap$Node(head);
        var x = c.nodeType$1;
        var x$2$1 = new $c_ju_regex_GroupStartMap$RegexLeaf().init___T("|");
        if (((x !== null) && x.equals__O__Z(x$2$1))) {
          var x$2$2 = acc.reverse__sci_List();
          var this$2 = res;
          var temp$res = new $c_sci_$colon$colon().init___O__sci_List(x$2$2, this$2);
          var temp$acc = $m_sci_Nil$();
          $in$1 = tail;
          res = temp$res;
          acc = temp$acc;
          continue _splitWhereAux
        };
        var this$3 = acc;
        var temp$acc$2 = new $c_sci_$colon$colon().init___O__sci_List(head, this$3);
        $in$1 = tail;
        acc = temp$acc$2;
        continue _splitWhereAux
      };
      throw new $c_s_MatchError().init___O(x1)
    };
    var x$1 = acc.reverse__sci_List();
    var this$1 = res;
    var disjuncts = new $c_sci_$colon$colon().init___O__sci_List(x$1, this$1).reverse__sci_List();
    break
  };
  if (($f_sc_LinearSeqOptimized__length__I(disjuncts) === 1)) {
    return new $c_ju_regex_GroupStartMap$ParentNode().init___sc_Seq(children)
  } else {
    var f = (function(this$2$1) {
      return (function(x$4$2) {
        var x$4 = $as_sci_List(x$4$2);
        return $m_ju_regex_GroupStartMap$Node$().apply__sc_Seq__ju_regex_GroupStartMap$Node(x$4)
      })
    })(this);
    var this$4 = $m_sci_List$();
    var bf = this$4.ReusableCBFInstance$2;
    if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
      if ((disjuncts === $m_sci_Nil$())) {
        var jsx$1 = $m_sci_Nil$()
      } else {
        var arg1 = disjuncts.head__O();
        var h = new $c_sci_$colon$colon().init___O__sci_List(f(arg1), $m_sci_Nil$());
        var t = h;
        var rest = $as_sci_List(disjuncts.tail__O());
        while ((rest !== $m_sci_Nil$())) {
          var arg1$1 = rest.head__O();
          var nx = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$1), $m_sci_Nil$());
          t.tl$5 = nx;
          t = nx;
          rest = $as_sci_List(rest.tail__O())
        };
        var jsx$1 = h
      }
    } else {
      var b = $f_sc_TraversableLike__builder$1__psc_TraversableLike__scg_CanBuildFrom__scm_Builder(disjuncts, bf);
      var these = disjuncts;
      while ((!these.isEmpty__Z())) {
        var arg1$2 = these.head__O();
        b.$$plus$eq__O__scm_Builder(f(arg1$2));
        these = $as_sci_List(these.tail__O())
      };
      var jsx$1 = b.result__O()
    };
    return new $c_ju_regex_GroupStartMap$DisjunctNode().init___sc_Seq($as_sc_Seq(jsx$1))
  }
});
var $d_ju_regex_GroupStartMap$CreateParentNode$ = new $TypeData().initClass({
  ju_regex_GroupStartMap$CreateParentNode$: 0
}, false, "java.util.regex.GroupStartMap$CreateParentNode$", {
  ju_regex_GroupStartMap$CreateParentNode$: 1,
  O: 1
});
$c_ju_regex_GroupStartMap$CreateParentNode$.prototype.$classData = $d_ju_regex_GroupStartMap$CreateParentNode$;
var $n_ju_regex_GroupStartMap$CreateParentNode$ = (void 0);
function $m_ju_regex_GroupStartMap$CreateParentNode$() {
  if ((!$n_ju_regex_GroupStartMap$CreateParentNode$)) {
    $n_ju_regex_GroupStartMap$CreateParentNode$ = new $c_ju_regex_GroupStartMap$CreateParentNode$().init___()
  };
  return $n_ju_regex_GroupStartMap$CreateParentNode$
}
/** @constructor */
function $c_ju_regex_GroupStartMap$Node() {
  $c_O.call(this);
  this.originalGroup$1 = null;
  this.nodeType$1 = null;
  this.newGroup$1 = 0;
  this.matched$1 = null;
  this.start$1 = 0
}
$c_ju_regex_GroupStartMap$Node.prototype = new $h_O();
$c_ju_regex_GroupStartMap$Node.prototype.constructor = $c_ju_regex_GroupStartMap$Node;
/** @constructor */
function $h_ju_regex_GroupStartMap$Node() {
  /*<skip>*/
}
$h_ju_regex_GroupStartMap$Node.prototype = $c_ju_regex_GroupStartMap$Node.prototype;
$c_ju_regex_GroupStartMap$Node.prototype.setEndReturnStart__I__I = (function(newEnd) {
  var x1 = this.originalGroup$1;
  matchEnd5: {
    var jsx$1;
    if ($is_ju_regex_GroupStartMap$OriginallyWrapped(x1)) {
      var x2 = $as_ju_regex_GroupStartMap$OriginallyWrapped(x1);
      if ($m_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$().unapply__ju_regex_GroupStartMap$OriginallyWrapped__Z(x2)) {
        var jsx$1 = newEnd;
        break matchEnd5
      }
    };
    if ((this.matched$1 === null)) {
      var jsx$1 = (-1)
    } else {
      var thiz = this.matched$1;
      var jsx$1 = ((newEnd - $uI(thiz.length)) | 0)
    }
  };
  this.start$1 = jsx$1;
  this.propagateStart__V();
  return this.start$1
});
$c_ju_regex_GroupStartMap$Node.prototype.buildRegex__T = (function() {
  var this$1 = this.originalGroup$1;
  if ($is_ju_regex_GroupStartMap$OriginallyGroupped(this$1)) {
    var x2 = $as_ju_regex_GroupStartMap$OriginallyGroupped(this$1);
    var number = x2.number$1;
    var leftRegex = "("
  } else {
    if ((!$is_ju_regex_GroupStartMap$OriginallyWrapped(this$1))) {
      throw new $c_s_MatchError().init___O(this$1)
    };
    var x3 = $as_ju_regex_GroupStartMap$OriginallyWrapped(this$1);
    var left = x3.left$1;
    var leftRegex = ("((?:" + left)
  };
  var this$2 = this.nodeType$1;
  if ($is_ju_regex_GroupStartMap$RegexLeaf(this$2)) {
    var x2$1 = $as_ju_regex_GroupStartMap$RegexLeaf(this$2);
    var regex = x2$1.regex$1;
    var jsx$1 = regex
  } else if ($is_ju_regex_GroupStartMap$ParentNode(this$2)) {
    var x3$1 = $as_ju_regex_GroupStartMap$ParentNode(this$2);
    var children = x3$1.children$1;
    var jsx$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
      return (function(x$10$2) {
        var x$10 = $as_ju_regex_GroupStartMap$Node(x$10$2);
        return x$10.buildRegex__T()
      })
    })(this));
    var this$3 = $m_sc_Seq$();
    var jsx$1 = (("(?:" + $as_sc_TraversableOnce(children.map__F1__scg_CanBuildFrom__O(jsx$2, this$3.ReusableCBFInstance$2)).mkString__T()) + ")")
  } else {
    if ((!$is_ju_regex_GroupStartMap$DisjunctNode(this$2))) {
      throw new $c_s_MatchError().init___O(this$2)
    };
    var x4 = $as_ju_regex_GroupStartMap$DisjunctNode(this$2);
    var children$2 = x4.children$1;
    var jsx$3 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
      return (function(x$11$2) {
        var x$11 = $as_ju_regex_GroupStartMap$Node(x$11$2);
        return x$11.buildRegex__T()
      })
    })(this));
    var this$4 = $m_sc_Seq$();
    var jsx$1 = (("(?:" + $as_sc_TraversableOnce(children$2.map__F1__scg_CanBuildFrom__O(jsx$3, this$4.ReusableCBFInstance$2)).mkString__T__T("|")) + ")")
  };
  var middleRegex = $as_T(jsx$1);
  var this$5 = this.originalGroup$1;
  if ($is_ju_regex_GroupStartMap$OriginallyGroupped(this$5)) {
    var x2$2 = $as_ju_regex_GroupStartMap$OriginallyGroupped(this$5);
    var number$1 = x2$2.number$1;
    var rightRegex = ")"
  } else {
    if ((!$is_ju_regex_GroupStartMap$OriginallyWrapped(this$5))) {
      throw new $c_s_MatchError().init___O(this$5)
    };
    var x3$2 = $as_ju_regex_GroupStartMap$OriginallyWrapped(this$5);
    var right$1 = x3$2.right$1;
    var rightRegex = ((")" + right$1) + ")")
  };
  return ((leftRegex + middleRegex) + rightRegex)
});
$c_ju_regex_GroupStartMap$Node.prototype.toString__T = (function() {
  return (((("Node(" + this.originalGroup$1) + ", ") + this.nodeType$1) + ")")
});
$c_ju_regex_GroupStartMap$Node.prototype.transformGroupNumber__sci_Map__ju_regex_GroupStartMap$Node = (function(mapping) {
  var rc8 = false;
  var x2 = null;
  var x1 = this.nodeType$1;
  matchEnd9: {
    if ($is_ju_regex_GroupStartMap$RegexLeaf(x1)) {
      rc8 = true;
      x2 = $as_ju_regex_GroupStartMap$RegexLeaf(x1);
      var o12 = $m_ju_regex_GroupStartMap$BackReferenceLeaf$().unapply__ju_regex_GroupStartMap$RegexLeaf__s_Option(x2);
      if ((!o12.isEmpty__Z())) {
        var reference = $uI(o12.get__O());
        var this$1 = mapping.get__O__s_Option(reference);
        this.nodeType$1 = new $c_ju_regex_GroupStartMap$RegexLeaf().init___T(("\\" + (this$1.isEmpty__Z() ? 0 : this$1.get__O())));
        break matchEnd9
      }
    };
    if (rc8) {
      break matchEnd9
    };
    if ($is_ju_regex_GroupStartMap$ParentNode(x1)) {
      var x5 = $as_ju_regex_GroupStartMap$ParentNode(x1);
      var children = x5.children$1;
      children.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2, mapping$1) {
        return (function(x$6$2) {
          var x$6 = $as_ju_regex_GroupStartMap$Node(x$6$2);
          return x$6.transformGroupNumber__sci_Map__ju_regex_GroupStartMap$Node(mapping$1)
        })
      })(this, mapping)));
      break matchEnd9
    };
    if ($is_ju_regex_GroupStartMap$DisjunctNode(x1)) {
      var x6 = $as_ju_regex_GroupStartMap$DisjunctNode(x1);
      var children$2 = x6.children$1;
      children$2.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3, mapping$2) {
        return (function(x$7$2) {
          var x$7 = $as_ju_regex_GroupStartMap$Node(x$7$2);
          return x$7.transformGroupNumber__sci_Map__ju_regex_GroupStartMap$Node(mapping$2)
        })
      })(this, mapping)));
      break matchEnd9
    };
    throw new $c_s_MatchError().init___O(x1)
  };
  return this
});
$c_ju_regex_GroupStartMap$Node.prototype.end__I = (function() {
  var jsx$2 = this.start$1;
  if ((this.matched$1 === null)) {
    var jsx$1 = 0
  } else {
    var thiz = this.matched$1;
    var jsx$1 = $uI(thiz.length)
  };
  return ((jsx$2 + jsx$1) | 0)
});
$c_ju_regex_GroupStartMap$Node.prototype.setMatch__F1__V = (function(stringForGroupNumber) {
  this.matched$1 = $as_T(stringForGroupNumber.apply__O__O(this.newGroup$1));
  var this$1 = this.nodeType$1;
  if ($is_ju_regex_GroupStartMap$RegexLeaf(this$1)) {
    $as_ju_regex_GroupStartMap$RegexLeaf(this$1)
  } else if ($is_ju_regex_GroupStartMap$ParentNode(this$1)) {
    var x3 = $as_ju_regex_GroupStartMap$ParentNode(this$1);
    var children = x3.children$1;
    children.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, stringForGroupNumber$1) {
      return (function(x$8$2) {
        var x$8 = $as_ju_regex_GroupStartMap$Node(x$8$2);
        x$8.setMatch__F1__V(stringForGroupNumber$1)
      })
    })(this, stringForGroupNumber)))
  } else if ($is_ju_regex_GroupStartMap$DisjunctNode(this$1)) {
    var x4 = $as_ju_regex_GroupStartMap$DisjunctNode(this$1);
    var children$2 = x4.children$1;
    children$2.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1, stringForGroupNumber$1$1) {
      return (function(x$9$2) {
        var x$9 = $as_ju_regex_GroupStartMap$Node(x$9$2);
        x$9.setMatch__F1__V(stringForGroupNumber$1$1)
      })
    })(this, stringForGroupNumber)))
  } else {
    throw new $c_s_MatchError().init___O(this$1)
  }
});
$c_ju_regex_GroupStartMap$Node.prototype.getGroupNodeMap__sci_Map = (function() {
  var this$1 = this.originalGroup$1;
  if ($is_ju_regex_GroupStartMap$OriginallyGroupped(this$1)) {
    var x2 = $as_ju_regex_GroupStartMap$OriginallyGroupped(this$1);
    var number = x2.number$1;
    var array = [new $c_T2().init___O__O(number, this)];
    var this$7 = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
    var i = 0;
    var len = $uI(array.length);
    while ((i < len)) {
      var index = i;
      var arg1 = array[index];
      this$7.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1));
      i = ((1 + i) | 0)
    };
    var thisGroupNodeMap = $as_sci_Map(this$7.elems$1)
  } else {
    if ((!$is_ju_regex_GroupStartMap$OriginallyWrapped(this$1))) {
      throw new $c_s_MatchError().init___O(this$1)
    };
    var x3 = $as_ju_regex_GroupStartMap$OriginallyWrapped(this$1);
    var thisGroupNodeMap = $as_sci_Map($m_s_Predef$().Map$2.apply__sc_Seq__sc_GenMap($m_sci_Nil$()))
  };
  var this$8 = this.nodeType$1;
  if ($is_ju_regex_GroupStartMap$RegexLeaf(this$8)) {
    var x2$1 = $as_ju_regex_GroupStartMap$RegexLeaf(this$8);
    var childGroupNodeMap = $as_sci_Map($m_s_Predef$().Map$2.apply__sc_Seq__sc_GenMap($m_sci_Nil$()))
  } else if ($is_ju_regex_GroupStartMap$ParentNode(this$8)) {
    var x3$1 = $as_ju_regex_GroupStartMap$ParentNode(this$8);
    var children = x3$1.children$1;
    var childGroupNodeMap = $as_sci_Map(children.foldLeft__O__F2__O($m_s_Predef$().Map$2.apply__sc_Seq__sc_GenMap($m_sci_Nil$()), new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this) {
      return (function(x0$7$2, x1$5$2) {
        var x0$7 = $as_sci_Map(x0$7$2);
        var x1$5 = $as_ju_regex_GroupStartMap$Node(x1$5$2);
        return x0$7.$$plus$plus__sc_GenTraversableOnce__sci_Map(x1$5.getGroupNodeMap__sci_Map())
      })
    })(this))))
  } else {
    if ((!$is_ju_regex_GroupStartMap$DisjunctNode(this$8))) {
      throw new $c_s_MatchError().init___O(this$8)
    };
    var x4 = $as_ju_regex_GroupStartMap$DisjunctNode(this$8);
    var children$2 = x4.children$1;
    var childGroupNodeMap = $as_sci_Map(children$2.foldLeft__O__F2__O($m_s_Predef$().Map$2.apply__sc_Seq__sc_GenMap($m_sci_Nil$()), new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this$1) {
      return (function(x0$8$2, x1$6$2) {
        var x0$8 = $as_sci_Map(x0$8$2);
        var x1$6 = $as_ju_regex_GroupStartMap$Node(x1$6$2);
        return x0$8.$$plus$plus__sc_GenTraversableOnce__sci_Map(x1$6.getGroupNodeMap__sci_Map())
      })
    })(this))))
  };
  return thisGroupNodeMap.$$plus$plus__sc_GenTraversableOnce__sci_Map(childGroupNodeMap)
});
$c_ju_regex_GroupStartMap$Node.prototype.propagateStart__V = (function() {
  var this$1 = this.nodeType$1;
  if ($is_ju_regex_GroupStartMap$RegexLeaf(this$1)) {
    $as_ju_regex_GroupStartMap$RegexLeaf(this$1)
  } else if ($is_ju_regex_GroupStartMap$ParentNode(this$1)) {
    var x3 = $as_ju_regex_GroupStartMap$ParentNode(this$1);
    var children = x3.children$1;
    $uI(children.foldLeft__O__F2__O(this.start$1, new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this) {
      return (function(x0$3$2, x1$3$2) {
        var x0$3 = $uI(x0$3$2);
        var x1$3 = $as_ju_regex_GroupStartMap$Node(x1$3$2);
        return x1$3.setStartReturnEnd__I__I(x0$3)
      })
    })(this))))
  } else if ($is_ju_regex_GroupStartMap$DisjunctNode(this$1)) {
    var x4 = $as_ju_regex_GroupStartMap$DisjunctNode(this$1);
    var children$2 = x4.children$1;
    children$2.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
      return (function(x0$4$2) {
        var x0$4 = $as_ju_regex_GroupStartMap$Node(x0$4$2);
        return x0$4.setStartReturnEnd__I__I($this$1.start$1)
      })
    })(this)))
  } else {
    throw new $c_s_MatchError().init___O(this$1)
  }
});
$c_ju_regex_GroupStartMap$Node.prototype.init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType = (function(originalGroup, nodeType) {
  this.originalGroup$1 = originalGroup;
  this.nodeType$1 = nodeType;
  this.newGroup$1 = 0;
  this.matched$1 = "";
  this.start$1 = 0;
  return this
});
$c_ju_regex_GroupStartMap$Node.prototype.setNewGroup__I__I = (function(index) {
  this.newGroup$1 = index;
  var this$1 = this.nodeType$1;
  if ($is_ju_regex_GroupStartMap$RegexLeaf(this$1)) {
    var x2 = $as_ju_regex_GroupStartMap$RegexLeaf(this$1);
    return ((1 + index) | 0)
  } else if ($is_ju_regex_GroupStartMap$ParentNode(this$1)) {
    var x3 = $as_ju_regex_GroupStartMap$ParentNode(this$1);
    var children = x3.children$1;
    return $uI(children.foldLeft__O__F2__O(((1 + index) | 0), new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this) {
      return (function(x0$1$2, x1$1$2) {
        var x0$1 = $uI(x0$1$2);
        var x1$1 = $as_ju_regex_GroupStartMap$Node(x1$1$2);
        return x1$1.setNewGroup__I__I(x0$1)
      })
    })(this))))
  } else {
    if ((!$is_ju_regex_GroupStartMap$DisjunctNode(this$1))) {
      throw new $c_s_MatchError().init___O(this$1)
    };
    var x4 = $as_ju_regex_GroupStartMap$DisjunctNode(this$1);
    var children$2 = x4.children$1;
    return $uI(children$2.foldLeft__O__F2__O(((1 + index) | 0), new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this$1) {
      return (function(x0$2$2, x1$2$2) {
        var x0$2 = $uI(x0$2$2);
        var x1$2 = $as_ju_regex_GroupStartMap$Node(x1$2$2);
        return x1$2.setNewGroup__I__I(x0$2)
      })
    })(this))))
  }
});
$c_ju_regex_GroupStartMap$Node.prototype.propagateEnd__V = (function() {
  var this$1 = this.nodeType$1;
  if ($is_ju_regex_GroupStartMap$RegexLeaf(this$1)) {
    $as_ju_regex_GroupStartMap$RegexLeaf(this$1)
  } else if ($is_ju_regex_GroupStartMap$ParentNode(this$1)) {
    var x3 = $as_ju_regex_GroupStartMap$ParentNode(this$1);
    var children = x3.children$1;
    $uI(children.foldRight__O__F2__O(this.end__I(), new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this) {
      return (function(x0$5$2, x1$4$2) {
        var x0$5 = $as_ju_regex_GroupStartMap$Node(x0$5$2);
        var x1$4 = $uI(x1$4$2);
        return x0$5.setEndReturnStart__I__I(x1$4)
      })
    })(this))))
  } else if ($is_ju_regex_GroupStartMap$DisjunctNode(this$1)) {
    var x4 = $as_ju_regex_GroupStartMap$DisjunctNode(this$1);
    var children$2 = x4.children$1;
    children$2.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
      return (function(x0$6$2) {
        var x0$6 = $as_ju_regex_GroupStartMap$Node(x0$6$2);
        return x0$6.setEndReturnStart__I__I($this$1.end__I())
      })
    })(this)))
  } else {
    throw new $c_s_MatchError().init___O(this$1)
  }
});
$c_ju_regex_GroupStartMap$Node.prototype.simplify__ju_regex_GroupStartMap$Node = (function() {
  var o17 = $m_ju_regex_GroupStartMap$Node$().unapply__ju_regex_GroupStartMap$Node__s_Option(this);
  if ((!o17.isEmpty__Z())) {
    var p3 = $as_ju_regex_GroupStartMap$OriginalRegex($as_T2(o17.get__O()).$$und1__O());
    var p4 = $as_ju_regex_GroupStartMap$NodeType($as_T2(o17.get__O()).$$und2__O());
    if ($is_ju_regex_GroupStartMap$OriginallyGroupped(p3)) {
      var x5 = $as_ju_regex_GroupStartMap$OriginallyGroupped(p3);
      var nextGroupIndex = x5.number$1;
      if ($is_ju_regex_GroupStartMap$ParentNode(p4)) {
        var x6 = $as_ju_regex_GroupStartMap$ParentNode(p4);
        var p7 = x6.children$1;
        $m_sc_Seq$();
        var o16 = new $c_s_Some().init___O(p7);
        if (((o16.value$2 !== null) && ($as_sc_SeqLike(o16.value$2).lengthCompare__I__I(1) === 0))) {
          var p9 = $as_ju_regex_GroupStartMap$Node($as_sc_SeqLike(o16.value$2).apply__I__O(0));
          var o15 = $m_ju_regex_GroupStartMap$UnwrappedRegexLeaf$().unapply__ju_regex_GroupStartMap$Node__s_Option(p9);
          if ((!o15.isEmpty__Z())) {
            var regex = $as_T(o15.get__O());
            var originalGroup = new $c_ju_regex_GroupStartMap$OriginallyGroupped().init___I(nextGroupIndex);
            var nodeType = new $c_ju_regex_GroupStartMap$RegexLeaf().init___T(regex);
            return new $c_ju_regex_GroupStartMap$Node().init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType(originalGroup, nodeType)
          }
        }
      }
    }
  };
  return this
});
$c_ju_regex_GroupStartMap$Node.prototype.setStartReturnEnd__I__I = (function(offset) {
  this.start$1 = ((this.matched$1 === null) ? (-1) : offset);
  var x1 = this.originalGroup$1;
  matchEnd6: {
    if ($is_ju_regex_GroupStartMap$OriginallyWrapped(x1)) {
      var x2 = $as_ju_regex_GroupStartMap$OriginallyWrapped(x1);
      var o9 = $m_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$().unapply__ju_regex_GroupStartMap$OriginallyWrapped__s_Option(x2);
      if ((!o9.isEmpty__Z())) {
        this.propagateEnd__V();
        break matchEnd6
      }
    };
    this.propagateStart__V()
  };
  var x1$2 = this.originalGroup$1;
  if ($is_ju_regex_GroupStartMap$OriginallyWrapped(x1$2)) {
    var x2$2 = $as_ju_regex_GroupStartMap$OriginallyWrapped(x1$2);
    if ($m_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$().unapply__ju_regex_GroupStartMap$OriginallyWrapped__Z(x2$2)) {
      return offset
    }
  };
  return this.end__I()
});
function $is_ju_regex_GroupStartMap$Node(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_regex_GroupStartMap$Node)))
}
function $as_ju_regex_GroupStartMap$Node(obj) {
  return (($is_ju_regex_GroupStartMap$Node(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.regex.GroupStartMap$Node"))
}
function $isArrayOf_ju_regex_GroupStartMap$Node(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_regex_GroupStartMap$Node)))
}
function $asArrayOf_ju_regex_GroupStartMap$Node(obj, depth) {
  return (($isArrayOf_ju_regex_GroupStartMap$Node(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.regex.GroupStartMap$Node;", depth))
}
var $d_ju_regex_GroupStartMap$Node = new $TypeData().initClass({
  ju_regex_GroupStartMap$Node: 0
}, false, "java.util.regex.GroupStartMap$Node", {
  ju_regex_GroupStartMap$Node: 1,
  O: 1
});
$c_ju_regex_GroupStartMap$Node.prototype.$classData = $d_ju_regex_GroupStartMap$Node;
/** @constructor */
function $c_ju_regex_GroupStartMap$Node$() {
  $c_O.call(this)
}
$c_ju_regex_GroupStartMap$Node$.prototype = new $h_O();
$c_ju_regex_GroupStartMap$Node$.prototype.constructor = $c_ju_regex_GroupStartMap$Node$;
/** @constructor */
function $h_ju_regex_GroupStartMap$Node$() {
  /*<skip>*/
}
$h_ju_regex_GroupStartMap$Node$.prototype = $c_ju_regex_GroupStartMap$Node$.prototype;
$c_ju_regex_GroupStartMap$Node$.prototype.init___ = (function() {
  return this
});
$c_ju_regex_GroupStartMap$Node$.prototype.apply__T__ju_regex_GroupStartMap$Node = (function(regex) {
  return new $c_ju_regex_GroupStartMap$Node().init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType(new $c_ju_regex_GroupStartMap$OriginallyWrapped().init___T__T("", ""), new $c_ju_regex_GroupStartMap$RegexLeaf().init___T(regex))
});
$c_ju_regex_GroupStartMap$Node$.prototype.unapply__ju_regex_GroupStartMap$Node__s_Option = (function(n) {
  return new $c_s_Some().init___O(new $c_T2().init___O__O(n.originalGroup$1, n.nodeType$1))
});
$c_ju_regex_GroupStartMap$Node$.prototype.apply__sc_Seq__ju_regex_GroupStartMap$Node = (function(nodes) {
  return new $c_ju_regex_GroupStartMap$Node().init___ju_regex_GroupStartMap$OriginalRegex__ju_regex_GroupStartMap$NodeType(new $c_ju_regex_GroupStartMap$OriginallyWrapped().init___T__T("", ""), $m_ju_regex_GroupStartMap$CreateParentNode$().apply__sc_Seq__ju_regex_GroupStartMap$NodeType(nodes))
});
var $d_ju_regex_GroupStartMap$Node$ = new $TypeData().initClass({
  ju_regex_GroupStartMap$Node$: 0
}, false, "java.util.regex.GroupStartMap$Node$", {
  ju_regex_GroupStartMap$Node$: 1,
  O: 1
});
$c_ju_regex_GroupStartMap$Node$.prototype.$classData = $d_ju_regex_GroupStartMap$Node$;
var $n_ju_regex_GroupStartMap$Node$ = (void 0);
function $m_ju_regex_GroupStartMap$Node$() {
  if ((!$n_ju_regex_GroupStartMap$Node$)) {
    $n_ju_regex_GroupStartMap$Node$ = new $c_ju_regex_GroupStartMap$Node$().init___()
  };
  return $n_ju_regex_GroupStartMap$Node$
}
/** @constructor */
function $c_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$() {
  $c_O.call(this)
}
$c_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$.prototype = new $h_O();
$c_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$.prototype.constructor = $c_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$;
/** @constructor */
function $h_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$() {
  /*<skip>*/
}
$h_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$.prototype = $c_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$.prototype;
$c_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$.prototype.init___ = (function() {
  return this
});
$c_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$.prototype.unapply__ju_regex_GroupStartMap$OriginallyWrapped__Z = (function(e) {
  return (((e.left$1 === "(?!") || (e.left$1 === "(?=")) && (e.right$1 === ")"))
});
var $d_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$ = new $TypeData().initClass({
  ju_regex_GroupStartMap$OriginallyWrapped$Absolute$: 0
}, false, "java.util.regex.GroupStartMap$OriginallyWrapped$Absolute$", {
  ju_regex_GroupStartMap$OriginallyWrapped$Absolute$: 1,
  O: 1
});
$c_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$.prototype.$classData = $d_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$;
var $n_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$ = (void 0);
function $m_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$() {
  if ((!$n_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$)) {
    $n_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$ = new $c_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$().init___()
  };
  return $n_ju_regex_GroupStartMap$OriginallyWrapped$Absolute$
}
/** @constructor */
function $c_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$() {
  $c_O.call(this)
}
$c_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$.prototype = new $h_O();
$c_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$.prototype.constructor = $c_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$;
/** @constructor */
function $h_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$() {
  /*<skip>*/
}
$h_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$.prototype = $c_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$.prototype;
$c_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$.prototype.init___ = (function() {
  return this
});
$c_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$.prototype.unapply__ju_regex_GroupStartMap$OriginallyWrapped__s_Option = (function(e) {
  return (((e.left$1 === "") && $m_ju_regex_GroupStartMap$OriginallyWrapped$().isRepeatModifier__T__Z(e.right$1)) ? new $c_s_Some().init___O(e.right$1) : $m_s_None$())
});
var $d_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$ = new $TypeData().initClass({
  ju_regex_GroupStartMap$OriginallyWrapped$Repeater$: 0
}, false, "java.util.regex.GroupStartMap$OriginallyWrapped$Repeater$", {
  ju_regex_GroupStartMap$OriginallyWrapped$Repeater$: 1,
  O: 1
});
$c_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$.prototype.$classData = $d_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$;
var $n_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$ = (void 0);
function $m_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$() {
  if ((!$n_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$)) {
    $n_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$ = new $c_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$().init___()
  };
  return $n_ju_regex_GroupStartMap$OriginallyWrapped$Repeater$
}
/** @constructor */
function $c_ju_regex_GroupStartMap$UnwrappedRegexLeaf$() {
  $c_O.call(this)
}
$c_ju_regex_GroupStartMap$UnwrappedRegexLeaf$.prototype = new $h_O();
$c_ju_regex_GroupStartMap$UnwrappedRegexLeaf$.prototype.constructor = $c_ju_regex_GroupStartMap$UnwrappedRegexLeaf$;
/** @constructor */
function $h_ju_regex_GroupStartMap$UnwrappedRegexLeaf$() {
  /*<skip>*/
}
$h_ju_regex_GroupStartMap$UnwrappedRegexLeaf$.prototype = $c_ju_regex_GroupStartMap$UnwrappedRegexLeaf$.prototype;
$c_ju_regex_GroupStartMap$UnwrappedRegexLeaf$.prototype.init___ = (function() {
  return this
});
$c_ju_regex_GroupStartMap$UnwrappedRegexLeaf$.prototype.unapply__ju_regex_GroupStartMap$Node__s_Option = (function(n) {
  var o15 = $m_ju_regex_GroupStartMap$Node$().unapply__ju_regex_GroupStartMap$Node__s_Option(n);
  if ((!o15.isEmpty__Z())) {
    var p3 = $as_ju_regex_GroupStartMap$OriginalRegex($as_T2(o15.get__O()).$$und1__O());
    var p4 = $as_ju_regex_GroupStartMap$NodeType($as_T2(o15.get__O()).$$und2__O());
    if ($is_ju_regex_GroupStartMap$OriginallyWrapped(p3)) {
      var x5 = $as_ju_regex_GroupStartMap$OriginallyWrapped(p3);
      var p6 = x5.left$1;
      var p7 = x5.right$1;
      if (((p6 === "") && ((p7 === "") && $is_ju_regex_GroupStartMap$RegexLeaf(p4)))) {
        var x8 = $as_ju_regex_GroupStartMap$RegexLeaf(p4);
        var r = x8.regex$1;
        return new $c_s_Some().init___O(r)
      }
    }
  };
  return $m_s_None$()
});
var $d_ju_regex_GroupStartMap$UnwrappedRegexLeaf$ = new $TypeData().initClass({
  ju_regex_GroupStartMap$UnwrappedRegexLeaf$: 0
}, false, "java.util.regex.GroupStartMap$UnwrappedRegexLeaf$", {
  ju_regex_GroupStartMap$UnwrappedRegexLeaf$: 1,
  O: 1
});
$c_ju_regex_GroupStartMap$UnwrappedRegexLeaf$.prototype.$classData = $d_ju_regex_GroupStartMap$UnwrappedRegexLeaf$;
var $n_ju_regex_GroupStartMap$UnwrappedRegexLeaf$ = (void 0);
function $m_ju_regex_GroupStartMap$UnwrappedRegexLeaf$() {
  if ((!$n_ju_regex_GroupStartMap$UnwrappedRegexLeaf$)) {
    $n_ju_regex_GroupStartMap$UnwrappedRegexLeaf$ = new $c_ju_regex_GroupStartMap$UnwrappedRegexLeaf$().init___()
  };
  return $n_ju_regex_GroupStartMap$UnwrappedRegexLeaf$
}
/** @constructor */
function $c_s_FallbackArrayBuilding() {
  $c_O.call(this)
}
$c_s_FallbackArrayBuilding.prototype = new $h_O();
$c_s_FallbackArrayBuilding.prototype.constructor = $c_s_FallbackArrayBuilding;
/** @constructor */
function $h_s_FallbackArrayBuilding() {
  /*<skip>*/
}
$h_s_FallbackArrayBuilding.prototype = $c_s_FallbackArrayBuilding.prototype;
/** @constructor */
function $c_s_JSUniquenessCache() {
  $c_O.call(this);
  this.cache$1 = null
}
$c_s_JSUniquenessCache.prototype = new $h_O();
$c_s_JSUniquenessCache.prototype.constructor = $c_s_JSUniquenessCache;
/** @constructor */
function $h_s_JSUniquenessCache() {
  /*<skip>*/
}
$h_s_JSUniquenessCache.prototype = $c_s_JSUniquenessCache.prototype;
$c_s_JSUniquenessCache.prototype.init___ = (function() {
  this.cache$1 = {};
  return this
});
$c_s_JSUniquenessCache.prototype.apply__T__O = (function(name) {
  var dict = this.cache$1;
  var x1 = ($uZ($m_sjs_js_WrappedDictionary$Cache$().safeHasOwnProperty$1.call(dict, name)) ? new $c_s_Some().init___O(dict[name]) : $m_s_None$());
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var v = x2.value$2;
    return v
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var d = new $c_s_Symbol().init___T(name);
      dict[name] = d;
      return d
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
/** @constructor */
function $c_s_LowPriorityImplicits() {
  $c_O.call(this)
}
$c_s_LowPriorityImplicits.prototype = new $h_O();
$c_s_LowPriorityImplicits.prototype.constructor = $c_s_LowPriorityImplicits;
/** @constructor */
function $h_s_LowPriorityImplicits() {
  /*<skip>*/
}
$h_s_LowPriorityImplicits.prototype = $c_s_LowPriorityImplicits.prototype;
$c_s_LowPriorityImplicits.prototype.unwrapString__sci_WrappedString__T = (function(ws) {
  return ((ws !== null) ? ws.self$4 : null)
});
function $f_s_PartialFunction__runWith__F1__F1($thiz, action) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, action$1) {
    return (function(x$2) {
      var z = $this.applyOrElse__O__F1__O(x$2, $m_s_PartialFunction$().scala$PartialFunction$$fallback$undpf$f);
      return ((!$m_s_PartialFunction$().scala$PartialFunction$$fallbackOccurred__O__Z(z)) && (action$1.apply__O__O(z), true))
    })
  })($thiz, action))
}
function $f_s_PartialFunction__applyOrElse__O__F1__O($thiz, x, $default) {
  return ($thiz.isDefinedAt__O__Z(x) ? $thiz.apply__O__O(x) : $default.apply__O__O(x))
}
/** @constructor */
function $c_s_PartialFunction$() {
  $c_O.call(this);
  this.scala$PartialFunction$$fallback$undpf$f = null;
  this.scala$PartialFunction$$constFalse$f = null;
  this.empty$undpf$1 = null
}
$c_s_PartialFunction$.prototype = new $h_O();
$c_s_PartialFunction$.prototype.constructor = $c_s_PartialFunction$;
/** @constructor */
function $h_s_PartialFunction$() {
  /*<skip>*/
}
$h_s_PartialFunction$.prototype = $c_s_PartialFunction$.prototype;
$c_s_PartialFunction$.prototype.init___ = (function() {
  $n_s_PartialFunction$ = this;
  this.scala$PartialFunction$$fallback$undpf$f = new $c_s_PartialFunction$$anonfun$1().init___();
  this.scala$PartialFunction$$constFalse$f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      return false
    })
  })(this));
  this.empty$undpf$1 = new $c_s_PartialFunction$$anon$1().init___();
  return this
});
$c_s_PartialFunction$.prototype.scala$PartialFunction$$fallbackOccurred__O__Z = (function(x) {
  return (this.scala$PartialFunction$$fallback$undpf$f === x)
});
var $d_s_PartialFunction$ = new $TypeData().initClass({
  s_PartialFunction$: 0
}, false, "scala.PartialFunction$", {
  s_PartialFunction$: 1,
  O: 1
});
$c_s_PartialFunction$.prototype.$classData = $d_s_PartialFunction$;
var $n_s_PartialFunction$ = (void 0);
function $m_s_PartialFunction$() {
  if ((!$n_s_PartialFunction$)) {
    $n_s_PartialFunction$ = new $c_s_PartialFunction$().init___()
  };
  return $n_s_PartialFunction$
}
/** @constructor */
function $c_s_Predef$any2stringadd$() {
  $c_O.call(this)
}
$c_s_Predef$any2stringadd$.prototype = new $h_O();
$c_s_Predef$any2stringadd$.prototype.constructor = $c_s_Predef$any2stringadd$;
/** @constructor */
function $h_s_Predef$any2stringadd$() {
  /*<skip>*/
}
$h_s_Predef$any2stringadd$.prototype = $c_s_Predef$any2stringadd$.prototype;
$c_s_Predef$any2stringadd$.prototype.init___ = (function() {
  return this
});
$c_s_Predef$any2stringadd$.prototype.$$plus$extension__O__T__T = (function($$this, other) {
  return (("" + $$this) + other)
});
var $d_s_Predef$any2stringadd$ = new $TypeData().initClass({
  s_Predef$any2stringadd$: 0
}, false, "scala.Predef$any2stringadd$", {
  s_Predef$any2stringadd$: 1,
  O: 1
});
$c_s_Predef$any2stringadd$.prototype.$classData = $d_s_Predef$any2stringadd$;
var $n_s_Predef$any2stringadd$ = (void 0);
function $m_s_Predef$any2stringadd$() {
  if ((!$n_s_Predef$any2stringadd$)) {
    $n_s_Predef$any2stringadd$ = new $c_s_Predef$any2stringadd$().init___()
  };
  return $n_s_Predef$any2stringadd$
}
function $f_s_concurrent_BatchingExecutor__batchable__jl_Runnable__Z($thiz, runnable) {
  return $is_s_concurrent_OnCompleteRunnable(runnable)
}
function $f_s_concurrent_BatchingExecutor__execute__jl_Runnable__V($thiz, runnable) {
  if ($f_s_concurrent_BatchingExecutor__batchable__jl_Runnable__Z($thiz, runnable)) {
    var x1 = $as_sci_List($thiz.scala$concurrent$BatchingExecutor$$$undtasksLocal$1.get__O());
    if ((x1 === null)) {
      var this$1 = $m_sci_Nil$();
      var r = new $c_s_concurrent_BatchingExecutor$Batch().init___s_concurrent_BatchingExecutor__sci_List($thiz, new $c_sci_$colon$colon().init___O__sci_List(runnable, this$1));
      r.run__V()
    } else {
      $thiz.scala$concurrent$BatchingExecutor$$$undtasksLocal$1.set__O__V(new $c_sci_$colon$colon().init___O__sci_List(runnable, x1))
    }
  } else {
    runnable.run__V()
  }
}
/** @constructor */
function $c_s_concurrent_BlockContext$() {
  $c_O.call(this);
  this.contextLocal$1 = null
}
$c_s_concurrent_BlockContext$.prototype = new $h_O();
$c_s_concurrent_BlockContext$.prototype.constructor = $c_s_concurrent_BlockContext$;
/** @constructor */
function $h_s_concurrent_BlockContext$() {
  /*<skip>*/
}
$h_s_concurrent_BlockContext$.prototype = $c_s_concurrent_BlockContext$.prototype;
$c_s_concurrent_BlockContext$.prototype.init___ = (function() {
  $n_s_concurrent_BlockContext$ = this;
  this.contextLocal$1 = new $c_jl_ThreadLocal().init___();
  return this
});
$c_s_concurrent_BlockContext$.prototype.current__s_concurrent_BlockContext = (function() {
  var x1 = $as_s_concurrent_BlockContext(this.contextLocal$1.get__O());
  if ((x1 === null)) {
    var x1$2 = $m_jl_Thread$().SingleThread$1;
    return ($is_s_concurrent_BlockContext(x1$2) ? $as_s_concurrent_BlockContext(x1$2) : $m_s_concurrent_BlockContext$DefaultBlockContext$())
  } else {
    return x1
  }
});
var $d_s_concurrent_BlockContext$ = new $TypeData().initClass({
  s_concurrent_BlockContext$: 0
}, false, "scala.concurrent.BlockContext$", {
  s_concurrent_BlockContext$: 1,
  O: 1
});
$c_s_concurrent_BlockContext$.prototype.$classData = $d_s_concurrent_BlockContext$;
var $n_s_concurrent_BlockContext$ = (void 0);
function $m_s_concurrent_BlockContext$() {
  if ((!$n_s_concurrent_BlockContext$)) {
    $n_s_concurrent_BlockContext$ = new $c_s_concurrent_BlockContext$().init___()
  };
  return $n_s_concurrent_BlockContext$
}
/** @constructor */
function $c_s_concurrent_ExecutionContext$Implicits$() {
  $c_O.call(this);
  this.global$1 = null;
  this.bitmap$0$1 = false
}
$c_s_concurrent_ExecutionContext$Implicits$.prototype = new $h_O();
$c_s_concurrent_ExecutionContext$Implicits$.prototype.constructor = $c_s_concurrent_ExecutionContext$Implicits$;
/** @constructor */
function $h_s_concurrent_ExecutionContext$Implicits$() {
  /*<skip>*/
}
$h_s_concurrent_ExecutionContext$Implicits$.prototype = $c_s_concurrent_ExecutionContext$Implicits$.prototype;
$c_s_concurrent_ExecutionContext$Implicits$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_ExecutionContext$Implicits$.prototype.global$lzycompute__p1__s_concurrent_ExecutionContext = (function() {
  if ((!this.bitmap$0$1)) {
    this.global$1 = $m_sjs_concurrent_JSExecutionContext$().queue$1;
    this.bitmap$0$1 = true
  };
  return this.global$1
});
$c_s_concurrent_ExecutionContext$Implicits$.prototype.global__s_concurrent_ExecutionContext = (function() {
  return ((!this.bitmap$0$1) ? this.global$lzycompute__p1__s_concurrent_ExecutionContext() : this.global$1)
});
var $d_s_concurrent_ExecutionContext$Implicits$ = new $TypeData().initClass({
  s_concurrent_ExecutionContext$Implicits$: 0
}, false, "scala.concurrent.ExecutionContext$Implicits$", {
  s_concurrent_ExecutionContext$Implicits$: 1,
  O: 1
});
$c_s_concurrent_ExecutionContext$Implicits$.prototype.$classData = $d_s_concurrent_ExecutionContext$Implicits$;
var $n_s_concurrent_ExecutionContext$Implicits$ = (void 0);
function $m_s_concurrent_ExecutionContext$Implicits$() {
  if ((!$n_s_concurrent_ExecutionContext$Implicits$)) {
    $n_s_concurrent_ExecutionContext$Implicits$ = new $c_s_concurrent_ExecutionContext$Implicits$().init___()
  };
  return $n_s_concurrent_ExecutionContext$Implicits$
}
function $f_s_concurrent_Future__foreach__F1__s_concurrent_ExecutionContext__V($thiz, f, executor) {
  $thiz.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1) {
    return (function(x$1$2) {
      var x$1 = $as_s_util_Try(x$1$2);
      x$1.foreach__F1__V(f$1)
    })
  })($thiz, f)), executor)
}
function $f_s_concurrent_Future__flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f, executor) {
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1) {
    return (function(x0$5$2) {
      var x0$5 = $as_s_util_Try(x0$5$2);
      if ($is_s_util_Success(x0$5)) {
        var x2 = $as_s_util_Success(x0$5);
        var s = x2.value$2;
        return $as_s_concurrent_Future(f$1.apply__O__O(s))
      } else if ($is_s_util_Failure(x0$5)) {
        return $this
      } else {
        throw new $c_s_MatchError().init___O(x0$5)
      }
    })
  })($thiz, f));
  return $f_s_concurrent_impl_Promise__transformWith__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f$2, executor)
}
function $f_s_concurrent_Future__map__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f, executor) {
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1) {
    return (function(x$2$2) {
      var x$2 = $as_s_util_Try(x$2$2);
      return x$2.map__F1__s_util_Try(f$1)
    })
  })($thiz, f));
  return $f_s_concurrent_impl_Promise__transform__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f$2, executor)
}
function $f_s_concurrent_Future__failed__s_concurrent_Future($thiz) {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$3$2) {
      var x0$3 = $as_s_util_Try(x0$3$2);
      if ($is_s_util_Failure(x0$3)) {
        var x2 = $as_s_util_Failure(x0$3);
        var t = x2.exception$2;
        return new $c_s_util_Success().init___O(t)
      } else if ($is_s_util_Success(x0$3)) {
        return new $c_s_util_Failure().init___jl_Throwable(new $c_ju_NoSuchElementException().init___T("Future.failed not completed with a throwable."))
      } else {
        throw new $c_s_MatchError().init___O(x0$3)
      }
    })
  })($thiz));
  var executor = $m_s_concurrent_Future$InternalCallbackExecutor$();
  return $f_s_concurrent_impl_Promise__transform__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f, executor)
}
function $is_s_concurrent_Future(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_concurrent_Future)))
}
function $as_s_concurrent_Future(obj) {
  return (($is_s_concurrent_Future(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.concurrent.Future"))
}
function $isArrayOf_s_concurrent_Future(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_concurrent_Future)))
}
function $asArrayOf_s_concurrent_Future(obj, depth) {
  return (($isArrayOf_s_concurrent_Future(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.concurrent.Future;", depth))
}
/** @constructor */
function $c_s_concurrent_Future$() {
  $c_O.call(this);
  this.toBoxed$1 = null;
  this.unit$1 = null
}
$c_s_concurrent_Future$.prototype = new $h_O();
$c_s_concurrent_Future$.prototype.constructor = $c_s_concurrent_Future$;
/** @constructor */
function $h_s_concurrent_Future$() {
  /*<skip>*/
}
$h_s_concurrent_Future$.prototype = $c_s_concurrent_Future$.prototype;
$c_s_concurrent_Future$.prototype.init___ = (function() {
  $n_s_concurrent_Future$ = this;
  var array = [new $c_T2().init___O__O($d_Z.getClassOf(), $d_jl_Boolean.getClassOf()), new $c_T2().init___O__O($d_B.getClassOf(), $d_jl_Byte.getClassOf()), new $c_T2().init___O__O($d_C.getClassOf(), $d_jl_Character.getClassOf()), new $c_T2().init___O__O($d_S.getClassOf(), $d_jl_Short.getClassOf()), new $c_T2().init___O__O($d_I.getClassOf(), $d_jl_Integer.getClassOf()), new $c_T2().init___O__O($d_J.getClassOf(), $d_jl_Long.getClassOf()), new $c_T2().init___O__O($d_F.getClassOf(), $d_jl_Float.getClassOf()), new $c_T2().init___O__O($d_D.getClassOf(), $d_jl_Double.getClassOf()), new $c_T2().init___O__O($d_V.getClassOf(), $d_sr_BoxedUnit.getClassOf())];
  var this$22 = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  var i = 0;
  var len = $uI(array.length);
  while ((i < len)) {
    var index = i;
    var arg1 = array[index];
    this$22.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1));
    i = ((1 + i) | 0)
  };
  this.toBoxed$1 = $as_sci_Map(this$22.elems$1);
  this.unit$1 = this.successful__O__s_concurrent_Future((void 0));
  return this
});
$c_s_concurrent_Future$.prototype.successful__O__s_concurrent_Future = (function(result) {
  var this$1 = $m_s_concurrent_Promise$().successful__O__s_concurrent_Promise(result);
  return this$1
});
$c_s_concurrent_Future$.prototype.apply__F0__s_concurrent_ExecutionContext__s_concurrent_Future = (function(body, executor) {
  return this.unit$1.map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, body$1) {
    return (function(x$5$2) {
      $asUnit(x$5$2);
      return body$1.apply__O()
    })
  })(this, body)), executor)
});
var $d_s_concurrent_Future$ = new $TypeData().initClass({
  s_concurrent_Future$: 0
}, false, "scala.concurrent.Future$", {
  s_concurrent_Future$: 1,
  O: 1
});
$c_s_concurrent_Future$.prototype.$classData = $d_s_concurrent_Future$;
var $n_s_concurrent_Future$ = (void 0);
function $m_s_concurrent_Future$() {
  if ((!$n_s_concurrent_Future$)) {
    $n_s_concurrent_Future$ = new $c_s_concurrent_Future$().init___()
  };
  return $n_s_concurrent_Future$
}
/** @constructor */
function $c_s_concurrent_Promise$() {
  $c_O.call(this)
}
$c_s_concurrent_Promise$.prototype = new $h_O();
$c_s_concurrent_Promise$.prototype.constructor = $c_s_concurrent_Promise$;
/** @constructor */
function $h_s_concurrent_Promise$() {
  /*<skip>*/
}
$h_s_concurrent_Promise$.prototype = $c_s_concurrent_Promise$.prototype;
$c_s_concurrent_Promise$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_Promise$.prototype.successful__O__s_concurrent_Promise = (function(result) {
  var result$1 = new $c_s_util_Success().init___O(result);
  return $m_s_concurrent_impl_Promise$KeptPromise$().apply__s_util_Try__s_concurrent_Promise(result$1)
});
var $d_s_concurrent_Promise$ = new $TypeData().initClass({
  s_concurrent_Promise$: 0
}, false, "scala.concurrent.Promise$", {
  s_concurrent_Promise$: 1,
  O: 1
});
$c_s_concurrent_Promise$.prototype.$classData = $d_s_concurrent_Promise$;
var $n_s_concurrent_Promise$ = (void 0);
function $m_s_concurrent_Promise$() {
  if ((!$n_s_concurrent_Promise$)) {
    $n_s_concurrent_Promise$ = new $c_s_concurrent_Promise$().init___()
  };
  return $n_s_concurrent_Promise$
}
/** @constructor */
function $c_s_concurrent_duration_package$DurationInt$() {
  $c_O.call(this)
}
$c_s_concurrent_duration_package$DurationInt$.prototype = new $h_O();
$c_s_concurrent_duration_package$DurationInt$.prototype.constructor = $c_s_concurrent_duration_package$DurationInt$;
/** @constructor */
function $h_s_concurrent_duration_package$DurationInt$() {
  /*<skip>*/
}
$h_s_concurrent_duration_package$DurationInt$.prototype = $c_s_concurrent_duration_package$DurationInt$.prototype;
$c_s_concurrent_duration_package$DurationInt$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_duration_package$DurationInt$.prototype.equals$extension__I__O__Z = (function($$this, x$1) {
  if ($is_s_concurrent_duration_package$DurationInt(x$1)) {
    var DurationInt$1 = $as_s_concurrent_duration_package$DurationInt(x$1).scala$concurrent$duration$DurationInt$$n$1;
    return ($$this === DurationInt$1)
  } else {
    return false
  }
});
$c_s_concurrent_duration_package$DurationInt$.prototype.durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration = (function($$this, unit) {
  $m_s_concurrent_duration_Duration$();
  var hi = ($$this >> 31);
  return new $c_s_concurrent_duration_FiniteDuration().init___J__ju_concurrent_TimeUnit(new $c_sjsr_RuntimeLong().init___I__I($$this, hi), unit)
});
var $d_s_concurrent_duration_package$DurationInt$ = new $TypeData().initClass({
  s_concurrent_duration_package$DurationInt$: 0
}, false, "scala.concurrent.duration.package$DurationInt$", {
  s_concurrent_duration_package$DurationInt$: 1,
  O: 1
});
$c_s_concurrent_duration_package$DurationInt$.prototype.$classData = $d_s_concurrent_duration_package$DurationInt$;
var $n_s_concurrent_duration_package$DurationInt$ = (void 0);
function $m_s_concurrent_duration_package$DurationInt$() {
  if ((!$n_s_concurrent_duration_package$DurationInt$)) {
    $n_s_concurrent_duration_package$DurationInt$ = new $c_s_concurrent_duration_package$DurationInt$().init___()
  };
  return $n_s_concurrent_duration_package$DurationInt$
}
/** @constructor */
function $c_s_concurrent_duration_package$DurationLong$() {
  $c_O.call(this)
}
$c_s_concurrent_duration_package$DurationLong$.prototype = new $h_O();
$c_s_concurrent_duration_package$DurationLong$.prototype.constructor = $c_s_concurrent_duration_package$DurationLong$;
/** @constructor */
function $h_s_concurrent_duration_package$DurationLong$() {
  /*<skip>*/
}
$h_s_concurrent_duration_package$DurationLong$.prototype = $c_s_concurrent_duration_package$DurationLong$.prototype;
$c_s_concurrent_duration_package$DurationLong$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_duration_package$DurationLong$.prototype.equals$extension__J__O__Z = (function($$this, x$1) {
  if ($is_s_concurrent_duration_package$DurationLong(x$1)) {
    var t = $as_s_concurrent_duration_package$DurationLong(x$1).scala$concurrent$duration$DurationLong$$n$1;
    var lo = t.lo$2;
    var hi = t.hi$2;
    return (($$this.lo$2 === lo) && ($$this.hi$2 === hi))
  } else {
    return false
  }
});
var $d_s_concurrent_duration_package$DurationLong$ = new $TypeData().initClass({
  s_concurrent_duration_package$DurationLong$: 0
}, false, "scala.concurrent.duration.package$DurationLong$", {
  s_concurrent_duration_package$DurationLong$: 1,
  O: 1
});
$c_s_concurrent_duration_package$DurationLong$.prototype.$classData = $d_s_concurrent_duration_package$DurationLong$;
var $n_s_concurrent_duration_package$DurationLong$ = (void 0);
function $m_s_concurrent_duration_package$DurationLong$() {
  if ((!$n_s_concurrent_duration_package$DurationLong$)) {
    $n_s_concurrent_duration_package$DurationLong$ = new $c_s_concurrent_duration_package$DurationLong$().init___()
  };
  return $n_s_concurrent_duration_package$DurationLong$
}
/** @constructor */
function $c_s_concurrent_impl_Promise$() {
  $c_O.call(this)
}
$c_s_concurrent_impl_Promise$.prototype = new $h_O();
$c_s_concurrent_impl_Promise$.prototype.constructor = $c_s_concurrent_impl_Promise$;
/** @constructor */
function $h_s_concurrent_impl_Promise$() {
  /*<skip>*/
}
$h_s_concurrent_impl_Promise$.prototype = $c_s_concurrent_impl_Promise$.prototype;
$c_s_concurrent_impl_Promise$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_impl_Promise$.prototype.scala$concurrent$impl$Promise$$resolveTry__s_util_Try__s_util_Try = (function(source) {
  if ($is_s_util_Failure(source)) {
    var x2 = $as_s_util_Failure(source);
    var t = x2.exception$2;
    return this.resolver__p1__jl_Throwable__s_util_Try(t)
  } else {
    return source
  }
});
$c_s_concurrent_impl_Promise$.prototype.resolver__p1__jl_Throwable__s_util_Try = (function(throwable) {
  if ($is_sr_NonLocalReturnControl(throwable)) {
    var x2 = $as_sr_NonLocalReturnControl(throwable);
    return new $c_s_util_Success().init___O(x2.value$f)
  } else if ($is_s_util_control_ControlThrowable(throwable)) {
    var x3 = $as_s_util_control_ControlThrowable(throwable);
    return new $c_s_util_Failure().init___jl_Throwable(new $c_ju_concurrent_ExecutionException().init___T__jl_Throwable("Boxed ControlThrowable", $as_jl_Throwable(x3)))
  } else if ($is_jl_InterruptedException(throwable)) {
    var x4 = $as_jl_InterruptedException(throwable);
    return new $c_s_util_Failure().init___jl_Throwable(new $c_ju_concurrent_ExecutionException().init___T__jl_Throwable("Boxed InterruptedException", x4))
  } else if ($is_jl_Error(throwable)) {
    var x5 = $as_jl_Error(throwable);
    return new $c_s_util_Failure().init___jl_Throwable(new $c_ju_concurrent_ExecutionException().init___T__jl_Throwable("Boxed Error", x5))
  } else {
    return new $c_s_util_Failure().init___jl_Throwable(throwable)
  }
});
var $d_s_concurrent_impl_Promise$ = new $TypeData().initClass({
  s_concurrent_impl_Promise$: 0
}, false, "scala.concurrent.impl.Promise$", {
  s_concurrent_impl_Promise$: 1,
  O: 1
});
$c_s_concurrent_impl_Promise$.prototype.$classData = $d_s_concurrent_impl_Promise$;
var $n_s_concurrent_impl_Promise$ = (void 0);
function $m_s_concurrent_impl_Promise$() {
  if ((!$n_s_concurrent_impl_Promise$)) {
    $n_s_concurrent_impl_Promise$ = new $c_s_concurrent_impl_Promise$().init___()
  };
  return $n_s_concurrent_impl_Promise$
}
/** @constructor */
function $c_s_concurrent_impl_Promise$KeptPromise$() {
  $c_O.call(this)
}
$c_s_concurrent_impl_Promise$KeptPromise$.prototype = new $h_O();
$c_s_concurrent_impl_Promise$KeptPromise$.prototype.constructor = $c_s_concurrent_impl_Promise$KeptPromise$;
/** @constructor */
function $h_s_concurrent_impl_Promise$KeptPromise$() {
  /*<skip>*/
}
$h_s_concurrent_impl_Promise$KeptPromise$.prototype = $c_s_concurrent_impl_Promise$KeptPromise$.prototype;
$c_s_concurrent_impl_Promise$KeptPromise$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_impl_Promise$KeptPromise$.prototype.apply__s_util_Try__s_concurrent_Promise = (function(result) {
  var x1 = $m_s_concurrent_impl_Promise$().scala$concurrent$impl$Promise$$resolveTry__s_util_Try__s_util_Try(result);
  if ($is_s_util_Success(x1)) {
    var x2 = $as_s_util_Success(x1);
    return new $c_s_concurrent_impl_Promise$KeptPromise$Successful().init___s_util_Success(x2)
  } else if ($is_s_util_Failure(x1)) {
    var x4 = $as_s_util_Failure(x1);
    return new $c_s_concurrent_impl_Promise$KeptPromise$Failed().init___s_util_Failure(x4)
  } else {
    throw new $c_s_MatchError().init___O(x1)
  }
});
var $d_s_concurrent_impl_Promise$KeptPromise$ = new $TypeData().initClass({
  s_concurrent_impl_Promise$KeptPromise$: 0
}, false, "scala.concurrent.impl.Promise$KeptPromise$", {
  s_concurrent_impl_Promise$KeptPromise$: 1,
  O: 1
});
$c_s_concurrent_impl_Promise$KeptPromise$.prototype.$classData = $d_s_concurrent_impl_Promise$KeptPromise$;
var $n_s_concurrent_impl_Promise$KeptPromise$ = (void 0);
function $m_s_concurrent_impl_Promise$KeptPromise$() {
  if ((!$n_s_concurrent_impl_Promise$KeptPromise$)) {
    $n_s_concurrent_impl_Promise$KeptPromise$ = new $c_s_concurrent_impl_Promise$KeptPromise$().init___()
  };
  return $n_s_concurrent_impl_Promise$KeptPromise$
}
function $f_s_math_Ordered__$$less$eq__O__Z($thiz, that) {
  return ($thiz.compare__O__I(that) <= 0)
}
function $f_s_math_Ordered__$$greater$eq__O__Z($thiz, that) {
  return ($thiz.compare__O__I(that) >= 0)
}
/** @constructor */
function $c_s_math_Ordered$() {
  $c_O.call(this)
}
$c_s_math_Ordered$.prototype = new $h_O();
$c_s_math_Ordered$.prototype.constructor = $c_s_math_Ordered$;
/** @constructor */
function $h_s_math_Ordered$() {
  /*<skip>*/
}
$h_s_math_Ordered$.prototype = $c_s_math_Ordered$.prototype;
$c_s_math_Ordered$.prototype.init___ = (function() {
  return this
});
var $d_s_math_Ordered$ = new $TypeData().initClass({
  s_math_Ordered$: 0
}, false, "scala.math.Ordered$", {
  s_math_Ordered$: 1,
  O: 1
});
$c_s_math_Ordered$.prototype.$classData = $d_s_math_Ordered$;
var $n_s_math_Ordered$ = (void 0);
function $m_s_math_Ordered$() {
  if ((!$n_s_math_Ordered$)) {
    $n_s_math_Ordered$ = new $c_s_math_Ordered$().init___()
  };
  return $n_s_math_Ordered$
}
/** @constructor */
function $c_s_package$() {
  $c_O.call(this);
  this.BigDecimal$1 = null;
  this.BigInt$1 = null;
  this.AnyRef$1 = null;
  this.Traversable$1 = null;
  this.Iterable$1 = null;
  this.Seq$1 = null;
  this.IndexedSeq$1 = null;
  this.Iterator$1 = null;
  this.List$1 = null;
  this.Nil$1 = null;
  this.$$colon$colon$1 = null;
  this.$$plus$colon$1 = null;
  this.$$colon$plus$1 = null;
  this.Stream$1 = null;
  this.$$hash$colon$colon$1 = null;
  this.Vector$1 = null;
  this.StringBuilder$1 = null;
  this.Range$1 = null;
  this.Equiv$1 = null;
  this.Fractional$1 = null;
  this.Integral$1 = null;
  this.Numeric$1 = null;
  this.Ordered$1 = null;
  this.Ordering$1 = null;
  this.Either$1 = null;
  this.Left$1 = null;
  this.Right$1 = null;
  this.bitmap$0$1 = 0
}
$c_s_package$.prototype = new $h_O();
$c_s_package$.prototype.constructor = $c_s_package$;
/** @constructor */
function $h_s_package$() {
  /*<skip>*/
}
$h_s_package$.prototype = $c_s_package$.prototype;
$c_s_package$.prototype.init___ = (function() {
  $n_s_package$ = this;
  this.AnyRef$1 = new $c_s_package$$anon$1().init___();
  this.Traversable$1 = $m_sc_Traversable$();
  this.Iterable$1 = $m_sc_Iterable$();
  this.Seq$1 = $m_sc_Seq$();
  this.IndexedSeq$1 = $m_sc_IndexedSeq$();
  this.Iterator$1 = $m_sc_Iterator$();
  this.List$1 = $m_sci_List$();
  this.Nil$1 = $m_sci_Nil$();
  this.$$colon$colon$1 = $m_sci_$colon$colon$();
  this.$$plus$colon$1 = $m_sc_$plus$colon$();
  this.$$colon$plus$1 = $m_sc_$colon$plus$();
  this.Stream$1 = $m_sci_Stream$();
  this.$$hash$colon$colon$1 = $m_sci_Stream$$hash$colon$colon$();
  this.Vector$1 = $m_sci_Vector$();
  this.StringBuilder$1 = $m_scm_StringBuilder$();
  this.Range$1 = $m_sci_Range$();
  this.Equiv$1 = $m_s_math_Equiv$();
  this.Fractional$1 = $m_s_math_Fractional$();
  this.Integral$1 = $m_s_math_Integral$();
  this.Numeric$1 = $m_s_math_Numeric$();
  this.Ordered$1 = $m_s_math_Ordered$();
  this.Ordering$1 = $m_s_math_Ordering$();
  this.Either$1 = $m_s_util_Either$();
  this.Left$1 = $m_s_util_Left$();
  this.Right$1 = $m_s_util_Right$();
  return this
});
$c_s_package$.prototype.BigInt__s_math_BigInt$ = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.BigInt$lzycompute__p1__s_math_BigInt$() : this.BigInt$1)
});
$c_s_package$.prototype.BigInt$lzycompute__p1__s_math_BigInt$ = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.BigInt$1 = $m_s_math_BigInt$();
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.BigInt$1
});
$c_s_package$.prototype.BigDecimal__s_math_BigDecimal$ = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.BigDecimal$lzycompute__p1__s_math_BigDecimal$() : this.BigDecimal$1)
});
$c_s_package$.prototype.BigDecimal$lzycompute__p1__s_math_BigDecimal$ = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.BigDecimal$1 = $m_s_math_BigDecimal$();
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.BigDecimal$1
});
var $d_s_package$ = new $TypeData().initClass({
  s_package$: 0
}, false, "scala.package$", {
  s_package$: 1,
  O: 1
});
$c_s_package$.prototype.$classData = $d_s_package$;
var $n_s_package$ = (void 0);
function $m_s_package$() {
  if ((!$n_s_package$)) {
    $n_s_package$ = new $c_s_package$().init___()
  };
  return $n_s_package$
}
/** @constructor */
function $c_s_reflect_ClassManifestFactory$() {
  $c_O.call(this);
  this.Byte$1 = null;
  this.Short$1 = null;
  this.Char$1 = null;
  this.Int$1 = null;
  this.Long$1 = null;
  this.Float$1 = null;
  this.Double$1 = null;
  this.Boolean$1 = null;
  this.Unit$1 = null;
  this.Any$1 = null;
  this.Object$1 = null;
  this.AnyVal$1 = null;
  this.Nothing$1 = null;
  this.Null$1 = null
}
$c_s_reflect_ClassManifestFactory$.prototype = new $h_O();
$c_s_reflect_ClassManifestFactory$.prototype.constructor = $c_s_reflect_ClassManifestFactory$;
/** @constructor */
function $h_s_reflect_ClassManifestFactory$() {
  /*<skip>*/
}
$h_s_reflect_ClassManifestFactory$.prototype = $c_s_reflect_ClassManifestFactory$.prototype;
$c_s_reflect_ClassManifestFactory$.prototype.init___ = (function() {
  $n_s_reflect_ClassManifestFactory$ = this;
  this.Byte$1 = $m_s_reflect_ManifestFactory$ByteManifest$();
  this.Short$1 = $m_s_reflect_ManifestFactory$ShortManifest$();
  this.Char$1 = $m_s_reflect_ManifestFactory$CharManifest$();
  this.Int$1 = $m_s_reflect_ManifestFactory$IntManifest$();
  this.Long$1 = $m_s_reflect_ManifestFactory$LongManifest$();
  this.Float$1 = $m_s_reflect_ManifestFactory$FloatManifest$();
  this.Double$1 = $m_s_reflect_ManifestFactory$DoubleManifest$();
  this.Boolean$1 = $m_s_reflect_ManifestFactory$BooleanManifest$();
  this.Unit$1 = $m_s_reflect_ManifestFactory$UnitManifest$();
  this.Any$1 = $m_s_reflect_ManifestFactory$AnyManifest$();
  this.Object$1 = $m_s_reflect_ManifestFactory$ObjectManifest$();
  this.AnyVal$1 = $m_s_reflect_ManifestFactory$AnyValManifest$();
  this.Nothing$1 = $m_s_reflect_ManifestFactory$NothingManifest$();
  this.Null$1 = $m_s_reflect_ManifestFactory$NullManifest$();
  return this
});
var $d_s_reflect_ClassManifestFactory$ = new $TypeData().initClass({
  s_reflect_ClassManifestFactory$: 0
}, false, "scala.reflect.ClassManifestFactory$", {
  s_reflect_ClassManifestFactory$: 1,
  O: 1
});
$c_s_reflect_ClassManifestFactory$.prototype.$classData = $d_s_reflect_ClassManifestFactory$;
var $n_s_reflect_ClassManifestFactory$ = (void 0);
function $m_s_reflect_ClassManifestFactory$() {
  if ((!$n_s_reflect_ClassManifestFactory$)) {
    $n_s_reflect_ClassManifestFactory$ = new $c_s_reflect_ClassManifestFactory$().init___()
  };
  return $n_s_reflect_ClassManifestFactory$
}
/** @constructor */
function $c_s_reflect_ManifestFactory$() {
  $c_O.call(this)
}
$c_s_reflect_ManifestFactory$.prototype = new $h_O();
$c_s_reflect_ManifestFactory$.prototype.constructor = $c_s_reflect_ManifestFactory$;
/** @constructor */
function $h_s_reflect_ManifestFactory$() {
  /*<skip>*/
}
$h_s_reflect_ManifestFactory$.prototype = $c_s_reflect_ManifestFactory$.prototype;
$c_s_reflect_ManifestFactory$.prototype.init___ = (function() {
  return this
});
var $d_s_reflect_ManifestFactory$ = new $TypeData().initClass({
  s_reflect_ManifestFactory$: 0
}, false, "scala.reflect.ManifestFactory$", {
  s_reflect_ManifestFactory$: 1,
  O: 1
});
$c_s_reflect_ManifestFactory$.prototype.$classData = $d_s_reflect_ManifestFactory$;
var $n_s_reflect_ManifestFactory$ = (void 0);
function $m_s_reflect_ManifestFactory$() {
  if ((!$n_s_reflect_ManifestFactory$)) {
    $n_s_reflect_ManifestFactory$ = new $c_s_reflect_ManifestFactory$().init___()
  };
  return $n_s_reflect_ManifestFactory$
}
/** @constructor */
function $c_s_reflect_package$() {
  $c_O.call(this);
  this.ClassManifest$1 = null;
  this.Manifest$1 = null
}
$c_s_reflect_package$.prototype = new $h_O();
$c_s_reflect_package$.prototype.constructor = $c_s_reflect_package$;
/** @constructor */
function $h_s_reflect_package$() {
  /*<skip>*/
}
$h_s_reflect_package$.prototype = $c_s_reflect_package$.prototype;
$c_s_reflect_package$.prototype.init___ = (function() {
  $n_s_reflect_package$ = this;
  this.ClassManifest$1 = $m_s_reflect_ClassManifestFactory$();
  this.Manifest$1 = $m_s_reflect_ManifestFactory$();
  return this
});
var $d_s_reflect_package$ = new $TypeData().initClass({
  s_reflect_package$: 0
}, false, "scala.reflect.package$", {
  s_reflect_package$: 1,
  O: 1
});
$c_s_reflect_package$.prototype.$classData = $d_s_reflect_package$;
var $n_s_reflect_package$ = (void 0);
function $m_s_reflect_package$() {
  if ((!$n_s_reflect_package$)) {
    $n_s_reflect_package$ = new $c_s_reflect_package$().init___()
  };
  return $n_s_reflect_package$
}
/** @constructor */
function $c_s_util_control_Breaks() {
  $c_O.call(this);
  this.scala$util$control$Breaks$$breakException$1 = null
}
$c_s_util_control_Breaks.prototype = new $h_O();
$c_s_util_control_Breaks.prototype.constructor = $c_s_util_control_Breaks;
/** @constructor */
function $h_s_util_control_Breaks() {
  /*<skip>*/
}
$h_s_util_control_Breaks.prototype = $c_s_util_control_Breaks.prototype;
$c_s_util_control_Breaks.prototype.init___ = (function() {
  this.scala$util$control$Breaks$$breakException$1 = new $c_s_util_control_BreakControl().init___();
  return this
});
var $d_s_util_control_Breaks = new $TypeData().initClass({
  s_util_control_Breaks: 0
}, false, "scala.util.control.Breaks", {
  s_util_control_Breaks: 1,
  O: 1
});
$c_s_util_control_Breaks.prototype.$classData = $d_s_util_control_Breaks;
function $is_s_util_control_ControlThrowable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_util_control_ControlThrowable)))
}
function $as_s_util_control_ControlThrowable(obj) {
  return (($is_s_util_control_ControlThrowable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.util.control.ControlThrowable"))
}
function $isArrayOf_s_util_control_ControlThrowable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_util_control_ControlThrowable)))
}
function $asArrayOf_s_util_control_ControlThrowable(obj, depth) {
  return (($isArrayOf_s_util_control_ControlThrowable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.util.control.ControlThrowable;", depth))
}
/** @constructor */
function $c_s_util_control_NonFatal$() {
  $c_O.call(this)
}
$c_s_util_control_NonFatal$.prototype = new $h_O();
$c_s_util_control_NonFatal$.prototype.constructor = $c_s_util_control_NonFatal$;
/** @constructor */
function $h_s_util_control_NonFatal$() {
  /*<skip>*/
}
$h_s_util_control_NonFatal$.prototype = $c_s_util_control_NonFatal$.prototype;
$c_s_util_control_NonFatal$.prototype.init___ = (function() {
  return this
});
$c_s_util_control_NonFatal$.prototype.apply__jl_Throwable__Z = (function(t) {
  return (!($is_jl_VirtualMachineError(t) || ($is_jl_ThreadDeath(t) || ($is_jl_InterruptedException(t) || ($is_jl_LinkageError(t) || $is_s_util_control_ControlThrowable(t))))))
});
$c_s_util_control_NonFatal$.prototype.unapply__jl_Throwable__s_Option = (function(t) {
  return (this.apply__jl_Throwable__Z(t) ? new $c_s_Some().init___O(t) : $m_s_None$())
});
var $d_s_util_control_NonFatal$ = new $TypeData().initClass({
  s_util_control_NonFatal$: 0
}, false, "scala.util.control.NonFatal$", {
  s_util_control_NonFatal$: 1,
  O: 1
});
$c_s_util_control_NonFatal$.prototype.$classData = $d_s_util_control_NonFatal$;
var $n_s_util_control_NonFatal$ = (void 0);
function $m_s_util_control_NonFatal$() {
  if ((!$n_s_util_control_NonFatal$)) {
    $n_s_util_control_NonFatal$ = new $c_s_util_control_NonFatal$().init___()
  };
  return $n_s_util_control_NonFatal$
}
/** @constructor */
function $c_s_util_hashing_MurmurHash3() {
  $c_O.call(this)
}
$c_s_util_hashing_MurmurHash3.prototype = new $h_O();
$c_s_util_hashing_MurmurHash3.prototype.constructor = $c_s_util_hashing_MurmurHash3;
/** @constructor */
function $h_s_util_hashing_MurmurHash3() {
  /*<skip>*/
}
$h_s_util_hashing_MurmurHash3.prototype = $c_s_util_hashing_MurmurHash3.prototype;
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mVc$sp__Asr_BoxedUnit__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, 0);
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.mixLast__I__I__I = (function(hash, data) {
  var k = data;
  k = $imul((-862048943), k);
  var i = k;
  k = ((i << 15) | ((i >>> 17) | 0));
  k = $imul(461845907, k);
  return (hash ^ k)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mDc$sp__AD__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, $m_sr_Statics$().doubleHash__D__I(a.get(i)));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mJc$sp__AJ__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, $m_sr_Statics$().longHash__J__I(a.get(i)));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mZc$sp__AZ__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, (a.get(i) ? 1231 : 1237));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.mix__I__I__I = (function(hash, data) {
  var h = this.mixLast__I__I__I(hash, data);
  var i = h;
  h = ((i << 13) | ((i >>> 19) | 0));
  return (((-430675100) + $imul(5, h)) | 0)
});
$c_s_util_hashing_MurmurHash3.prototype.bytesHash__AB__I__I = (function(data, seed) {
  var len = data.u.length;
  var h = seed;
  var i = 0;
  while ((len >= 4)) {
    var k = (255 & data.get(i));
    k = (k | ((255 & data.get(((1 + i) | 0))) << 8));
    k = (k | ((255 & data.get(((2 + i) | 0))) << 16));
    k = (k | ((255 & data.get(((3 + i) | 0))) << 24));
    h = this.mix__I__I__I(h, k);
    i = ((4 + i) | 0);
    len = (((-4) + len) | 0)
  };
  var k$2 = 0;
  if ((len === 3)) {
    k$2 = (k$2 ^ ((255 & data.get(((2 + i) | 0))) << 16))
  };
  if ((len >= 2)) {
    k$2 = (k$2 ^ ((255 & data.get(((1 + i) | 0))) << 8))
  };
  if ((len >= 1)) {
    k$2 = (k$2 ^ (255 & data.get(i)));
    h = this.mixLast__I__I__I(h, k$2)
  };
  return this.finalizeHash__I__I__I(h, data.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.avalanche__p1__I__I = (function(hash) {
  var h = hash;
  h = (h ^ ((h >>> 16) | 0));
  h = $imul((-2048144789), h);
  h = (h ^ ((h >>> 13) | 0));
  h = $imul((-1028477387), h);
  h = (h ^ ((h >>> 16) | 0));
  return h
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mSc$sp__AS__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, a.get(i));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash__O__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < $m_sr_ScalaRunTime$().array$undlength__O__I(a))) {
    h = this.mix__I__I__I(h, $m_sr_Statics$().anyHash__O__I($m_sr_ScalaRunTime$().array$undapply__O__I__O(a, i)));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, $m_sr_ScalaRunTime$().array$undlength__O__I(a))
});
$c_s_util_hashing_MurmurHash3.prototype.productHash__s_Product__I__I = (function(x, seed) {
  var arr = x.productArity__I();
  if ((arr === 0)) {
    var this$1 = x.productPrefix__T();
    return $m_sjsr_RuntimeString$().hashCode__T__I(this$1)
  } else {
    var h = seed;
    var i = 0;
    while ((i < arr)) {
      h = this.mix__I__I__I(h, $m_sr_Statics$().anyHash__O__I(x.productElement__I__O(i)));
      i = ((1 + i) | 0)
    };
    return this.finalizeHash__I__I__I(h, arr)
  }
});
$c_s_util_hashing_MurmurHash3.prototype.unorderedHash__sc_TraversableOnce__I__I = (function(xs, seed) {
  var a = new $c_sr_IntRef().init___I(0);
  var b = new $c_sr_IntRef().init___I(0);
  var n = new $c_sr_IntRef().init___I(0);
  var c = new $c_sr_IntRef().init___I(1);
  xs.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, a$1, b$1, n$1, c$1) {
    return (function(x$2) {
      var h = $m_sr_Statics$().anyHash__O__I(x$2);
      a$1.elem$1 = ((a$1.elem$1 + h) | 0);
      b$1.elem$1 = (b$1.elem$1 ^ h);
      if ((h !== 0)) {
        c$1.elem$1 = $imul(c$1.elem$1, h)
      };
      n$1.elem$1 = ((1 + n$1.elem$1) | 0)
    })
  })(this, a, b, n, c)));
  var h$1 = seed;
  h$1 = this.mix__I__I__I(h$1, a.elem$1);
  h$1 = this.mix__I__I__I(h$1, b.elem$1);
  h$1 = this.mixLast__I__I__I(h$1, c.elem$1);
  return this.finalizeHash__I__I__I(h$1, n.elem$1)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mCc$sp__AC__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, a.get(i));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mFc$sp__AF__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    var jsx$1 = h;
    var this$1 = $m_sr_Statics$();
    var fv = a.get(i);
    h = this.mix__I__I__I(jsx$1, this$1.doubleHash__D__I(fv));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.finalizeHash__I__I__I = (function(hash, length) {
  return this.avalanche__p1__I__I((hash ^ length))
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mIc$sp__AI__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, a.get(i));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.orderedHash__sc_TraversableOnce__I__I = (function(xs, seed) {
  var n = new $c_sr_IntRef().init___I(0);
  var h = new $c_sr_IntRef().init___I(seed);
  xs.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, n$1, h$1) {
    return (function(x$2) {
      h$1.elem$1 = $this.mix__I__I__I(h$1.elem$1, $m_sr_Statics$().anyHash__O__I(x$2));
      n$1.elem$1 = ((1 + n$1.elem$1) | 0)
    })
  })(this, n, h)));
  return this.finalizeHash__I__I__I(h.elem$1, n.elem$1)
});
$c_s_util_hashing_MurmurHash3.prototype.listHash__sci_List__I__I = (function(xs, seed) {
  var n = 0;
  var h = seed;
  var elems = xs;
  while ((!elems.isEmpty__Z())) {
    var head = elems.head__O();
    var tail = $as_sci_List(elems.tail__O());
    h = this.mix__I__I__I(h, $m_sr_Statics$().anyHash__O__I(head));
    n = ((1 + n) | 0);
    elems = tail
  };
  return this.finalizeHash__I__I__I(h, n)
});
/** @constructor */
function $c_s_util_hashing_package$() {
  $c_O.call(this)
}
$c_s_util_hashing_package$.prototype = new $h_O();
$c_s_util_hashing_package$.prototype.constructor = $c_s_util_hashing_package$;
/** @constructor */
function $h_s_util_hashing_package$() {
  /*<skip>*/
}
$h_s_util_hashing_package$.prototype = $c_s_util_hashing_package$.prototype;
$c_s_util_hashing_package$.prototype.init___ = (function() {
  return this
});
$c_s_util_hashing_package$.prototype.byteswap32__I__I = (function(v) {
  var hc = $imul((-1640532531), v);
  hc = $m_jl_Integer$().reverseBytes__I__I(hc);
  return $imul((-1640532531), hc)
});
var $d_s_util_hashing_package$ = new $TypeData().initClass({
  s_util_hashing_package$: 0
}, false, "scala.util.hashing.package$", {
  s_util_hashing_package$: 1,
  O: 1
});
$c_s_util_hashing_package$.prototype.$classData = $d_s_util_hashing_package$;
var $n_s_util_hashing_package$ = (void 0);
function $m_s_util_hashing_package$() {
  if ((!$n_s_util_hashing_package$)) {
    $n_s_util_hashing_package$ = new $c_s_util_hashing_package$().init___()
  };
  return $n_s_util_hashing_package$
}
/** @constructor */
function $c_sc_$colon$plus$() {
  $c_O.call(this)
}
$c_sc_$colon$plus$.prototype = new $h_O();
$c_sc_$colon$plus$.prototype.constructor = $c_sc_$colon$plus$;
/** @constructor */
function $h_sc_$colon$plus$() {
  /*<skip>*/
}
$h_sc_$colon$plus$.prototype = $c_sc_$colon$plus$.prototype;
$c_sc_$colon$plus$.prototype.init___ = (function() {
  return this
});
var $d_sc_$colon$plus$ = new $TypeData().initClass({
  sc_$colon$plus$: 0
}, false, "scala.collection.$colon$plus$", {
  sc_$colon$plus$: 1,
  O: 1
});
$c_sc_$colon$plus$.prototype.$classData = $d_sc_$colon$plus$;
var $n_sc_$colon$plus$ = (void 0);
function $m_sc_$colon$plus$() {
  if ((!$n_sc_$colon$plus$)) {
    $n_sc_$colon$plus$ = new $c_sc_$colon$plus$().init___()
  };
  return $n_sc_$colon$plus$
}
/** @constructor */
function $c_sc_$plus$colon$() {
  $c_O.call(this)
}
$c_sc_$plus$colon$.prototype = new $h_O();
$c_sc_$plus$colon$.prototype.constructor = $c_sc_$plus$colon$;
/** @constructor */
function $h_sc_$plus$colon$() {
  /*<skip>*/
}
$h_sc_$plus$colon$.prototype = $c_sc_$plus$colon$.prototype;
$c_sc_$plus$colon$.prototype.init___ = (function() {
  return this
});
$c_sc_$plus$colon$.prototype.unapply__sc_SeqLike__s_Option = (function(t) {
  if (t.isEmpty__Z()) {
    return $m_s_None$()
  } else {
    var self = t.head__O();
    var y = t.tail__O();
    return new $c_s_Some().init___O(new $c_T2().init___O__O(self, y))
  }
});
var $d_sc_$plus$colon$ = new $TypeData().initClass({
  sc_$plus$colon$: 0
}, false, "scala.collection.$plus$colon$", {
  sc_$plus$colon$: 1,
  O: 1
});
$c_sc_$plus$colon$.prototype.$classData = $d_sc_$plus$colon$;
var $n_sc_$plus$colon$ = (void 0);
function $m_sc_$plus$colon$() {
  if ((!$n_sc_$plus$colon$)) {
    $n_sc_$plus$colon$ = new $c_sc_$plus$colon$().init___()
  };
  return $n_sc_$plus$colon$
}
/** @constructor */
function $c_sc_Iterator$() {
  $c_O.call(this);
  this.empty$1 = null
}
$c_sc_Iterator$.prototype = new $h_O();
$c_sc_Iterator$.prototype.constructor = $c_sc_Iterator$;
/** @constructor */
function $h_sc_Iterator$() {
  /*<skip>*/
}
$h_sc_Iterator$.prototype = $c_sc_Iterator$.prototype;
$c_sc_Iterator$.prototype.init___ = (function() {
  $n_sc_Iterator$ = this;
  this.empty$1 = new $c_sc_Iterator$$anon$2().init___();
  return this
});
var $d_sc_Iterator$ = new $TypeData().initClass({
  sc_Iterator$: 0
}, false, "scala.collection.Iterator$", {
  sc_Iterator$: 1,
  O: 1
});
$c_sc_Iterator$.prototype.$classData = $d_sc_Iterator$;
var $n_sc_Iterator$ = (void 0);
function $m_sc_Iterator$() {
  if ((!$n_sc_Iterator$)) {
    $n_sc_Iterator$ = new $c_sc_Iterator$().init___()
  };
  return $n_sc_Iterator$
}
function $f_sc_TraversableOnce__copyToArray__O__I__V($thiz, xs, start) {
  $thiz.copyToArray__O__I__I__V(xs, start, (($m_sr_ScalaRunTime$().array$undlength__O__I(xs) - start) | 0))
}
function $f_sc_TraversableOnce__to__scg_CanBuildFrom__O($thiz, cbf) {
  var b = cbf.apply__scm_Builder();
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($thiz.seq__sc_TraversableOnce());
  return b.result__O()
}
function $f_sc_TraversableOnce__mkString__T__T__T__T($thiz, start, sep, end) {
  var this$1 = $thiz.addString__scm_StringBuilder__T__T__T__scm_StringBuilder(new $c_scm_StringBuilder().init___(), start, sep, end);
  return this$1.underlying$5.java$lang$StringBuilder$$content$f
}
function $f_sc_TraversableOnce__foldLeft__O__F2__O($thiz, z, op) {
  var result = new $c_sr_ObjectRef().init___O(z);
  $thiz.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, op$1, result$1) {
    return (function(x$2) {
      result$1.elem$1 = op$1.apply__O__O__O(result$1.elem$1, x$2)
    })
  })($thiz, op, result)));
  return result.elem$1
}
function $f_sc_TraversableOnce__foldRight__O__F2__O($thiz, z, op) {
  var this$1 = $f_sc_TraversableOnce__reversed__sci_List($thiz);
  var acc = z;
  var these = this$1;
  while ((!these.isEmpty__Z())) {
    var arg1 = acc;
    var arg2 = these.head__O();
    acc = op.apply__O__O__O(arg2, arg1);
    these = $as_sc_LinearSeqOptimized(these.tail__O())
  };
  return acc
}
function $f_sc_TraversableOnce__size__I($thiz) {
  var result = new $c_sr_IntRef().init___I(0);
  $thiz.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, result$1) {
    return (function(x$2) {
      result$1.elem$1 = ((1 + result$1.elem$1) | 0)
    })
  })($thiz, result)));
  return result.elem$1
}
function $f_sc_TraversableOnce__collectFirst__s_PartialFunction__s_Option($thiz, pf) {
  var nonLocalReturnKey1 = new $c_O().init___();
  try {
    if ($is_sc_Iterator($thiz)) {
      var x2 = $as_sc_Iterator($thiz);
      var i = x2
    } else {
      if ((!$is_sc_GenIterable($thiz))) {
        $thiz.foreach__F1__V(pf.runWith__F1__F1(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, nonLocalReturnKey1$1) {
          return (function(b$2) {
            throw new $c_sr_NonLocalReturnControl().init___O__O(nonLocalReturnKey1$1, new $c_s_Some().init___O(b$2))
          })
        })($thiz, nonLocalReturnKey1))));
        return $m_s_None$()
      };
      var i = $thiz.toIterator__sc_Iterator()
    };
    var sentinel = new $c_sc_TraversableOnce$$anon$2().init___sc_TraversableOnce($thiz);
    while (i.hasNext__Z()) {
      var x = pf.applyOrElse__O__F1__O(i.next__O(), sentinel);
      if ((x !== sentinel)) {
        return new $c_s_Some().init___O(x)
      }
    };
    return $m_s_None$()
  } catch (e) {
    if ($is_sr_NonLocalReturnControl(e)) {
      var ex = $as_sr_NonLocalReturnControl(e);
      if ((ex.key$2 === nonLocalReturnKey1)) {
        return $as_s_Option(ex.value$f)
      } else {
        throw ex
      }
    } else {
      throw e
    }
  }
}
function $f_sc_TraversableOnce__addString__scm_StringBuilder__T__T__T__scm_StringBuilder($thiz, b, start, sep, end) {
  var first = new $c_sr_BooleanRef().init___Z(true);
  b.append__T__scm_StringBuilder(start);
  $thiz.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, b$1, sep$1, first$1) {
    return (function(x$2) {
      if (first$1.elem$1) {
        b$1.append__O__scm_StringBuilder(x$2);
        first$1.elem$1 = false;
        return (void 0)
      } else {
        b$1.append__T__scm_StringBuilder(sep$1);
        return b$1.append__O__scm_StringBuilder(x$2)
      }
    })
  })($thiz, b, sep, first)));
  b.append__T__scm_StringBuilder(end);
  return b
}
function $f_sc_TraversableOnce__max__s_math_Ordering__O($thiz, cmp) {
  if ($thiz.isEmpty__Z()) {
    throw new $c_jl_UnsupportedOperationException().init___T("empty.max")
  };
  return $thiz.reduceLeft__F2__O(new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this, cmp$1) {
    return (function(x$2, y$2) {
      return (cmp$1.gteq__O__O__Z(x$2, y$2) ? x$2 : y$2)
    })
  })($thiz, cmp)))
}
function $f_sc_TraversableOnce__nonEmpty__Z($thiz) {
  return (!$thiz.isEmpty__Z())
}
function $f_sc_TraversableOnce__reversed__sci_List($thiz) {
  var elem = $m_sci_Nil$();
  var elems = new $c_sr_ObjectRef().init___O(elem);
  $thiz.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, elems$1) {
    return (function(x$1$2) {
      var this$2 = $as_sci_List(elems$1.elem$1);
      elems$1.elem$1 = new $c_sci_$colon$colon().init___O__sci_List(x$1$2, this$2)
    })
  })($thiz, elems)));
  return $as_sci_List(elems.elem$1)
}
function $f_sc_TraversableOnce__reduceLeft__F2__O($thiz, op) {
  if ($thiz.isEmpty__Z()) {
    throw new $c_jl_UnsupportedOperationException().init___T("empty.reduceLeft")
  };
  var first = new $c_sr_BooleanRef().init___Z(true);
  var acc = new $c_sr_ObjectRef().init___O(0);
  $thiz.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, op$1, first$1, acc$1) {
    return (function(x$2) {
      if (first$1.elem$1) {
        acc$1.elem$1 = x$2;
        first$1.elem$1 = false
      } else {
        acc$1.elem$1 = op$1.apply__O__O__O(acc$1.elem$1, x$2)
      }
    })
  })($thiz, op, first, acc)));
  return acc.elem$1
}
function $is_sc_TraversableOnce(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.sc_TraversableOnce)))
}
function $as_sc_TraversableOnce(obj) {
  return (($is_sc_TraversableOnce(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.collection.TraversableOnce"))
}
function $isArrayOf_sc_TraversableOnce(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.sc_TraversableOnce)))
}
function $asArrayOf_sc_TraversableOnce(obj, depth) {
  return (($isArrayOf_sc_TraversableOnce(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.collection.TraversableOnce;", depth))
}
function $f_sc_convert_DecorateAsJava__setAsJavaSetConverter__sc_Set__sc_convert_Decorators$AsJava($thiz, s) {
  return new $c_sc_convert_Decorators$AsJava().init___F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, s$1) {
    return (function() {
      return $f_sc_convert_AsJavaConverters__setAsJavaSet__sc_Set__ju_Set($this, s$1)
    })
  })($thiz, s)))
}
function $f_sc_convert_DecorateAsJava__mutableMapAsJavaMapConverter__scm_Map__sc_convert_Decorators$AsJava($thiz, m) {
  return new $c_sc_convert_Decorators$AsJava().init___F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, m$1) {
    return (function() {
      return $f_sc_convert_AsJavaConverters__mutableMapAsJavaMap__scm_Map__ju_Map($this, m$1)
    })
  })($thiz, m)))
}
function $f_sc_convert_DecorateAsJava__mutableSetAsJavaSetConverter__scm_Set__sc_convert_Decorators$AsJava($thiz, s) {
  return new $c_sc_convert_Decorators$AsJava().init___F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, s$1) {
    return (function() {
      return $f_sc_convert_AsJavaConverters__mutableSetAsJavaSet__scm_Set__ju_Set($this, s$1)
    })
  })($thiz, s)))
}
function $f_sc_convert_DecorateAsScala__asScalaSetConverter__ju_Set__sc_convert_Decorators$AsScala($thiz, s) {
  return new $c_sc_convert_Decorators$AsScala().init___F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, s$1) {
    return (function() {
      return $f_sc_convert_AsScalaConverters__asScalaSet__ju_Set__scm_Set($this, s$1)
    })
  })($thiz, s)))
}
function $f_sc_convert_DecorateAsScala__asScalaIteratorConverter__ju_Iterator__sc_convert_Decorators$AsScala($thiz, i) {
  return new $c_sc_convert_Decorators$AsScala().init___F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, i$1) {
    return (function() {
      return $f_sc_convert_AsScalaConverters__asScalaIterator__ju_Iterator__sc_Iterator($this, i$1)
    })
  })($thiz, i)))
}
function $f_sc_convert_DecorateAsScala__mapAsScalaMapConverter__ju_Map__sc_convert_Decorators$AsScala($thiz, m) {
  return new $c_sc_convert_Decorators$AsScala().init___F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, m$1) {
    return (function() {
      return $f_sc_convert_AsScalaConverters__mapAsScalaMap__ju_Map__scm_Map($this, m$1)
    })
  })($thiz, m)))
}
function $f_sc_convert_DecorateAsScala__propertiesAsScalaMapConverter__ju_Properties__sc_convert_Decorators$AsScala($thiz, p) {
  return new $c_sc_convert_Decorators$AsScala().init___F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, p$1) {
    return (function() {
      return $f_sc_convert_AsScalaConverters__propertiesAsScalaMap__ju_Properties__scm_Map($this, p$1)
    })
  })($thiz, p)))
}
function $f_sc_convert_DecorateAsScala__asScalaBufferConverter__ju_List__sc_convert_Decorators$AsScala($thiz, l) {
  return new $c_sc_convert_Decorators$AsScala().init___F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, l$1) {
    return (function() {
      return $f_sc_convert_AsScalaConverters__asScalaBuffer__ju_List__scm_Buffer($this, l$1)
    })
  })($thiz, l)))
}
/** @constructor */
function $c_sc_convert_Decorators$AsJava() {
  $c_O.call(this);
  this.op$1 = null
}
$c_sc_convert_Decorators$AsJava.prototype = new $h_O();
$c_sc_convert_Decorators$AsJava.prototype.constructor = $c_sc_convert_Decorators$AsJava;
/** @constructor */
function $h_sc_convert_Decorators$AsJava() {
  /*<skip>*/
}
$h_sc_convert_Decorators$AsJava.prototype = $c_sc_convert_Decorators$AsJava.prototype;
$c_sc_convert_Decorators$AsJava.prototype.init___F0 = (function(op) {
  this.op$1 = op;
  return this
});
$c_sc_convert_Decorators$AsJava.prototype.asJava__O = (function() {
  return this.op$1.apply__O()
});
var $d_sc_convert_Decorators$AsJava = new $TypeData().initClass({
  sc_convert_Decorators$AsJava: 0
}, false, "scala.collection.convert.Decorators$AsJava", {
  sc_convert_Decorators$AsJava: 1,
  O: 1
});
$c_sc_convert_Decorators$AsJava.prototype.$classData = $d_sc_convert_Decorators$AsJava;
/** @constructor */
function $c_sc_convert_Decorators$AsScala() {
  $c_O.call(this);
  this.op$1 = null
}
$c_sc_convert_Decorators$AsScala.prototype = new $h_O();
$c_sc_convert_Decorators$AsScala.prototype.constructor = $c_sc_convert_Decorators$AsScala;
/** @constructor */
function $h_sc_convert_Decorators$AsScala() {
  /*<skip>*/
}
$h_sc_convert_Decorators$AsScala.prototype = $c_sc_convert_Decorators$AsScala.prototype;
$c_sc_convert_Decorators$AsScala.prototype.init___F0 = (function(op) {
  this.op$1 = op;
  return this
});
$c_sc_convert_Decorators$AsScala.prototype.asScala__O = (function() {
  return this.op$1.apply__O()
});
var $d_sc_convert_Decorators$AsScala = new $TypeData().initClass({
  sc_convert_Decorators$AsScala: 0
}, false, "scala.collection.convert.Decorators$AsScala", {
  sc_convert_Decorators$AsScala: 1,
  O: 1
});
$c_sc_convert_Decorators$AsScala.prototype.$classData = $d_sc_convert_Decorators$AsScala;
/** @constructor */
function $c_scg_GenMapFactory() {
  $c_O.call(this)
}
$c_scg_GenMapFactory.prototype = new $h_O();
$c_scg_GenMapFactory.prototype.constructor = $c_scg_GenMapFactory;
/** @constructor */
function $h_scg_GenMapFactory() {
  /*<skip>*/
}
$h_scg_GenMapFactory.prototype = $c_scg_GenMapFactory.prototype;
$c_scg_GenMapFactory.prototype.apply__sc_Seq__sc_GenMap = (function(elems) {
  return $as_sc_GenMap($as_scm_Builder(this.newBuilder__scm_Builder().$$plus$plus$eq__sc_TraversableOnce__scg_Growable(elems)).result__O())
});
$c_scg_GenMapFactory.prototype.newBuilder__scm_Builder = (function() {
  return new $c_scm_MapBuilder().init___sc_GenMap(this.empty__sc_GenMap())
});
/** @constructor */
function $c_scg_GenericCompanion() {
  $c_O.call(this)
}
$c_scg_GenericCompanion.prototype = new $h_O();
$c_scg_GenericCompanion.prototype.constructor = $c_scg_GenericCompanion;
/** @constructor */
function $h_scg_GenericCompanion() {
  /*<skip>*/
}
$h_scg_GenericCompanion.prototype = $c_scg_GenericCompanion.prototype;
$c_scg_GenericCompanion.prototype.apply__sc_Seq__sc_GenTraversable = (function(elems) {
  if (elems.isEmpty__Z()) {
    return this.empty__sc_GenTraversable()
  } else {
    var b = this.newBuilder__scm_Builder();
    b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(elems);
    return $as_sc_GenTraversable(b.result__O())
  }
});
$c_scg_GenericCompanion.prototype.empty__sc_GenTraversable = (function() {
  return $as_sc_GenTraversable(this.newBuilder__scm_Builder().result__O())
});
function $f_scg_Growable__loop$1__pscg_Growable__sc_LinearSeq__V($thiz, xs) {
  _loop: while (true) {
    var this$1 = xs;
    if ($f_sc_TraversableOnce__nonEmpty__Z(this$1)) {
      $thiz.$$plus$eq__O__scg_Growable(xs.head__O());
      xs = $as_sc_LinearSeq(xs.tail__O());
      continue _loop
    };
    break
  }
}
function $f_scg_Growable__$$plus$plus$eq__sc_TraversableOnce__scg_Growable($thiz, xs) {
  if ($is_sc_LinearSeq(xs)) {
    var x2 = $as_sc_LinearSeq(xs);
    var xs$1 = x2;
    $f_scg_Growable__loop$1__pscg_Growable__sc_LinearSeq__V($thiz, xs$1)
  } else {
    xs.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
      return (function(elem$2) {
        return $this.$$plus$eq__O__scg_Growable(elem$2)
      })
    })($thiz)))
  };
  return $thiz
}
function $is_scg_Growable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.scg_Growable)))
}
function $as_scg_Growable(obj) {
  return (($is_scg_Growable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.collection.generic.Growable"))
}
function $isArrayOf_scg_Growable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.scg_Growable)))
}
function $asArrayOf_scg_Growable(obj, depth) {
  return (($isArrayOf_scg_Growable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.collection.generic.Growable;", depth))
}
/** @constructor */
function $c_sci_HashMap$Merger() {
  $c_O.call(this)
}
$c_sci_HashMap$Merger.prototype = new $h_O();
$c_sci_HashMap$Merger.prototype.constructor = $c_sci_HashMap$Merger;
/** @constructor */
function $h_sci_HashMap$Merger() {
  /*<skip>*/
}
$h_sci_HashMap$Merger.prototype = $c_sci_HashMap$Merger.prototype;
/** @constructor */
function $c_sci_Stream$$hash$colon$colon$() {
  $c_O.call(this)
}
$c_sci_Stream$$hash$colon$colon$.prototype = new $h_O();
$c_sci_Stream$$hash$colon$colon$.prototype.constructor = $c_sci_Stream$$hash$colon$colon$;
/** @constructor */
function $h_sci_Stream$$hash$colon$colon$() {
  /*<skip>*/
}
$h_sci_Stream$$hash$colon$colon$.prototype = $c_sci_Stream$$hash$colon$colon$.prototype;
$c_sci_Stream$$hash$colon$colon$.prototype.init___ = (function() {
  return this
});
var $d_sci_Stream$$hash$colon$colon$ = new $TypeData().initClass({
  sci_Stream$$hash$colon$colon$: 0
}, false, "scala.collection.immutable.Stream$$hash$colon$colon$", {
  sci_Stream$$hash$colon$colon$: 1,
  O: 1
});
$c_sci_Stream$$hash$colon$colon$.prototype.$classData = $d_sci_Stream$$hash$colon$colon$;
var $n_sci_Stream$$hash$colon$colon$ = (void 0);
function $m_sci_Stream$$hash$colon$colon$() {
  if ((!$n_sci_Stream$$hash$colon$colon$)) {
    $n_sci_Stream$$hash$colon$colon$ = new $c_sci_Stream$$hash$colon$colon$().init___()
  };
  return $n_sci_Stream$$hash$colon$colon$
}
/** @constructor */
function $c_sci_StreamIterator$LazyCell() {
  $c_O.call(this);
  this.v$1 = null;
  this.st$1 = null;
  this.bitmap$0$1 = false;
  this.$$outer$1 = null
}
$c_sci_StreamIterator$LazyCell.prototype = new $h_O();
$c_sci_StreamIterator$LazyCell.prototype.constructor = $c_sci_StreamIterator$LazyCell;
/** @constructor */
function $h_sci_StreamIterator$LazyCell() {
  /*<skip>*/
}
$h_sci_StreamIterator$LazyCell.prototype = $c_sci_StreamIterator$LazyCell.prototype;
$c_sci_StreamIterator$LazyCell.prototype.init___sci_StreamIterator__F0 = (function($$outer, st) {
  this.st$1 = st;
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_sci_StreamIterator$LazyCell.prototype.v$lzycompute__p1__sci_Stream = (function() {
  if ((!this.bitmap$0$1)) {
    this.v$1 = $as_sci_Stream(this.st$1.apply__O());
    this.bitmap$0$1 = true
  };
  this.st$1 = null;
  return this.v$1
});
$c_sci_StreamIterator$LazyCell.prototype.v__sci_Stream = (function() {
  return ((!this.bitmap$0$1) ? this.v$lzycompute__p1__sci_Stream() : this.v$1)
});
var $d_sci_StreamIterator$LazyCell = new $TypeData().initClass({
  sci_StreamIterator$LazyCell: 0
}, false, "scala.collection.immutable.StreamIterator$LazyCell", {
  sci_StreamIterator$LazyCell: 1,
  O: 1
});
$c_sci_StreamIterator$LazyCell.prototype.$classData = $d_sci_StreamIterator$LazyCell;
/** @constructor */
function $c_sci_StringOps$() {
  $c_O.call(this)
}
$c_sci_StringOps$.prototype = new $h_O();
$c_sci_StringOps$.prototype.constructor = $c_sci_StringOps$;
/** @constructor */
function $h_sci_StringOps$() {
  /*<skip>*/
}
$h_sci_StringOps$.prototype = $c_sci_StringOps$.prototype;
$c_sci_StringOps$.prototype.init___ = (function() {
  return this
});
$c_sci_StringOps$.prototype.equals$extension__T__O__Z = (function($$this, x$1) {
  if ($is_sci_StringOps(x$1)) {
    var StringOps$1 = ((x$1 === null) ? null : $as_sci_StringOps(x$1).repr$1);
    return ($$this === StringOps$1)
  } else {
    return false
  }
});
$c_sci_StringOps$.prototype.slice$extension__T__I__I__T = (function($$this, from, until) {
  var start = ((from < 0) ? 0 : from);
  if (((until <= start) || (start >= $uI($$this.length)))) {
    return ""
  };
  var end = ((until > $uI($$this.length)) ? $uI($$this.length) : until);
  return $as_T($$this.substring(start, end))
});
var $d_sci_StringOps$ = new $TypeData().initClass({
  sci_StringOps$: 0
}, false, "scala.collection.immutable.StringOps$", {
  sci_StringOps$: 1,
  O: 1
});
$c_sci_StringOps$.prototype.$classData = $d_sci_StringOps$;
var $n_sci_StringOps$ = (void 0);
function $m_sci_StringOps$() {
  if ((!$n_sci_StringOps$)) {
    $n_sci_StringOps$ = new $c_sci_StringOps$().init___()
  };
  return $n_sci_StringOps$
}
/** @constructor */
function $c_sci_WrappedString$() {
  $c_O.call(this)
}
$c_sci_WrappedString$.prototype = new $h_O();
$c_sci_WrappedString$.prototype.constructor = $c_sci_WrappedString$;
/** @constructor */
function $h_sci_WrappedString$() {
  /*<skip>*/
}
$h_sci_WrappedString$.prototype = $c_sci_WrappedString$.prototype;
$c_sci_WrappedString$.prototype.init___ = (function() {
  return this
});
$c_sci_WrappedString$.prototype.newBuilder__scm_Builder = (function() {
  var this$2 = new $c_scm_StringBuilder().init___();
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$2) {
      var x = $as_T(x$2);
      return new $c_sci_WrappedString().init___T(x)
    })
  })(this));
  return new $c_scm_Builder$$anon$1().init___scm_Builder__F1(this$2, f)
});
var $d_sci_WrappedString$ = new $TypeData().initClass({
  sci_WrappedString$: 0
}, false, "scala.collection.immutable.WrappedString$", {
  sci_WrappedString$: 1,
  O: 1
});
$c_sci_WrappedString$.prototype.$classData = $d_sci_WrappedString$;
var $n_sci_WrappedString$ = (void 0);
function $m_sci_WrappedString$() {
  if ((!$n_sci_WrappedString$)) {
    $n_sci_WrappedString$ = new $c_sci_WrappedString$().init___()
  };
  return $n_sci_WrappedString$
}
/** @constructor */
function $c_scm_ArrayOps$ofBoolean$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofBoolean$.prototype = new $h_O();
$c_scm_ArrayOps$ofBoolean$.prototype.constructor = $c_scm_ArrayOps$ofBoolean$;
/** @constructor */
function $h_scm_ArrayOps$ofBoolean$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofBoolean$.prototype = $c_scm_ArrayOps$ofBoolean$.prototype;
$c_scm_ArrayOps$ofBoolean$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofBoolean$.prototype.equals$extension__AZ__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofBoolean(x$1)) {
    var ofBoolean$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofBoolean(x$1).repr$1);
    return ($$this === ofBoolean$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofBoolean$ = new $TypeData().initClass({
  scm_ArrayOps$ofBoolean$: 0
}, false, "scala.collection.mutable.ArrayOps$ofBoolean$", {
  scm_ArrayOps$ofBoolean$: 1,
  O: 1
});
$c_scm_ArrayOps$ofBoolean$.prototype.$classData = $d_scm_ArrayOps$ofBoolean$;
var $n_scm_ArrayOps$ofBoolean$ = (void 0);
function $m_scm_ArrayOps$ofBoolean$() {
  if ((!$n_scm_ArrayOps$ofBoolean$)) {
    $n_scm_ArrayOps$ofBoolean$ = new $c_scm_ArrayOps$ofBoolean$().init___()
  };
  return $n_scm_ArrayOps$ofBoolean$
}
/** @constructor */
function $c_scm_ArrayOps$ofByte$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofByte$.prototype = new $h_O();
$c_scm_ArrayOps$ofByte$.prototype.constructor = $c_scm_ArrayOps$ofByte$;
/** @constructor */
function $h_scm_ArrayOps$ofByte$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofByte$.prototype = $c_scm_ArrayOps$ofByte$.prototype;
$c_scm_ArrayOps$ofByte$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofByte$.prototype.equals$extension__AB__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofByte(x$1)) {
    var ofByte$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofByte(x$1).repr$1);
    return ($$this === ofByte$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofByte$ = new $TypeData().initClass({
  scm_ArrayOps$ofByte$: 0
}, false, "scala.collection.mutable.ArrayOps$ofByte$", {
  scm_ArrayOps$ofByte$: 1,
  O: 1
});
$c_scm_ArrayOps$ofByte$.prototype.$classData = $d_scm_ArrayOps$ofByte$;
var $n_scm_ArrayOps$ofByte$ = (void 0);
function $m_scm_ArrayOps$ofByte$() {
  if ((!$n_scm_ArrayOps$ofByte$)) {
    $n_scm_ArrayOps$ofByte$ = new $c_scm_ArrayOps$ofByte$().init___()
  };
  return $n_scm_ArrayOps$ofByte$
}
/** @constructor */
function $c_scm_ArrayOps$ofChar$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofChar$.prototype = new $h_O();
$c_scm_ArrayOps$ofChar$.prototype.constructor = $c_scm_ArrayOps$ofChar$;
/** @constructor */
function $h_scm_ArrayOps$ofChar$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofChar$.prototype = $c_scm_ArrayOps$ofChar$.prototype;
$c_scm_ArrayOps$ofChar$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofChar$.prototype.equals$extension__AC__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofChar(x$1)) {
    var ofChar$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofChar(x$1).repr$1);
    return ($$this === ofChar$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofChar$ = new $TypeData().initClass({
  scm_ArrayOps$ofChar$: 0
}, false, "scala.collection.mutable.ArrayOps$ofChar$", {
  scm_ArrayOps$ofChar$: 1,
  O: 1
});
$c_scm_ArrayOps$ofChar$.prototype.$classData = $d_scm_ArrayOps$ofChar$;
var $n_scm_ArrayOps$ofChar$ = (void 0);
function $m_scm_ArrayOps$ofChar$() {
  if ((!$n_scm_ArrayOps$ofChar$)) {
    $n_scm_ArrayOps$ofChar$ = new $c_scm_ArrayOps$ofChar$().init___()
  };
  return $n_scm_ArrayOps$ofChar$
}
/** @constructor */
function $c_scm_ArrayOps$ofDouble$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofDouble$.prototype = new $h_O();
$c_scm_ArrayOps$ofDouble$.prototype.constructor = $c_scm_ArrayOps$ofDouble$;
/** @constructor */
function $h_scm_ArrayOps$ofDouble$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofDouble$.prototype = $c_scm_ArrayOps$ofDouble$.prototype;
$c_scm_ArrayOps$ofDouble$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofDouble$.prototype.equals$extension__AD__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofDouble(x$1)) {
    var ofDouble$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofDouble(x$1).repr$1);
    return ($$this === ofDouble$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofDouble$ = new $TypeData().initClass({
  scm_ArrayOps$ofDouble$: 0
}, false, "scala.collection.mutable.ArrayOps$ofDouble$", {
  scm_ArrayOps$ofDouble$: 1,
  O: 1
});
$c_scm_ArrayOps$ofDouble$.prototype.$classData = $d_scm_ArrayOps$ofDouble$;
var $n_scm_ArrayOps$ofDouble$ = (void 0);
function $m_scm_ArrayOps$ofDouble$() {
  if ((!$n_scm_ArrayOps$ofDouble$)) {
    $n_scm_ArrayOps$ofDouble$ = new $c_scm_ArrayOps$ofDouble$().init___()
  };
  return $n_scm_ArrayOps$ofDouble$
}
/** @constructor */
function $c_scm_ArrayOps$ofFloat$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofFloat$.prototype = new $h_O();
$c_scm_ArrayOps$ofFloat$.prototype.constructor = $c_scm_ArrayOps$ofFloat$;
/** @constructor */
function $h_scm_ArrayOps$ofFloat$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofFloat$.prototype = $c_scm_ArrayOps$ofFloat$.prototype;
$c_scm_ArrayOps$ofFloat$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofFloat$.prototype.equals$extension__AF__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofFloat(x$1)) {
    var ofFloat$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofFloat(x$1).repr$1);
    return ($$this === ofFloat$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofFloat$ = new $TypeData().initClass({
  scm_ArrayOps$ofFloat$: 0
}, false, "scala.collection.mutable.ArrayOps$ofFloat$", {
  scm_ArrayOps$ofFloat$: 1,
  O: 1
});
$c_scm_ArrayOps$ofFloat$.prototype.$classData = $d_scm_ArrayOps$ofFloat$;
var $n_scm_ArrayOps$ofFloat$ = (void 0);
function $m_scm_ArrayOps$ofFloat$() {
  if ((!$n_scm_ArrayOps$ofFloat$)) {
    $n_scm_ArrayOps$ofFloat$ = new $c_scm_ArrayOps$ofFloat$().init___()
  };
  return $n_scm_ArrayOps$ofFloat$
}
/** @constructor */
function $c_scm_ArrayOps$ofInt$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofInt$.prototype = new $h_O();
$c_scm_ArrayOps$ofInt$.prototype.constructor = $c_scm_ArrayOps$ofInt$;
/** @constructor */
function $h_scm_ArrayOps$ofInt$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofInt$.prototype = $c_scm_ArrayOps$ofInt$.prototype;
$c_scm_ArrayOps$ofInt$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofInt$.prototype.equals$extension__AI__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofInt(x$1)) {
    var ofInt$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofInt(x$1).repr$1);
    return ($$this === ofInt$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofInt$ = new $TypeData().initClass({
  scm_ArrayOps$ofInt$: 0
}, false, "scala.collection.mutable.ArrayOps$ofInt$", {
  scm_ArrayOps$ofInt$: 1,
  O: 1
});
$c_scm_ArrayOps$ofInt$.prototype.$classData = $d_scm_ArrayOps$ofInt$;
var $n_scm_ArrayOps$ofInt$ = (void 0);
function $m_scm_ArrayOps$ofInt$() {
  if ((!$n_scm_ArrayOps$ofInt$)) {
    $n_scm_ArrayOps$ofInt$ = new $c_scm_ArrayOps$ofInt$().init___()
  };
  return $n_scm_ArrayOps$ofInt$
}
/** @constructor */
function $c_scm_ArrayOps$ofLong$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofLong$.prototype = new $h_O();
$c_scm_ArrayOps$ofLong$.prototype.constructor = $c_scm_ArrayOps$ofLong$;
/** @constructor */
function $h_scm_ArrayOps$ofLong$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofLong$.prototype = $c_scm_ArrayOps$ofLong$.prototype;
$c_scm_ArrayOps$ofLong$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofLong$.prototype.equals$extension__AJ__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofLong(x$1)) {
    var ofLong$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofLong(x$1).repr$1);
    return ($$this === ofLong$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofLong$ = new $TypeData().initClass({
  scm_ArrayOps$ofLong$: 0
}, false, "scala.collection.mutable.ArrayOps$ofLong$", {
  scm_ArrayOps$ofLong$: 1,
  O: 1
});
$c_scm_ArrayOps$ofLong$.prototype.$classData = $d_scm_ArrayOps$ofLong$;
var $n_scm_ArrayOps$ofLong$ = (void 0);
function $m_scm_ArrayOps$ofLong$() {
  if ((!$n_scm_ArrayOps$ofLong$)) {
    $n_scm_ArrayOps$ofLong$ = new $c_scm_ArrayOps$ofLong$().init___()
  };
  return $n_scm_ArrayOps$ofLong$
}
/** @constructor */
function $c_scm_ArrayOps$ofRef$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofRef$.prototype = new $h_O();
$c_scm_ArrayOps$ofRef$.prototype.constructor = $c_scm_ArrayOps$ofRef$;
/** @constructor */
function $h_scm_ArrayOps$ofRef$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofRef$.prototype = $c_scm_ArrayOps$ofRef$.prototype;
$c_scm_ArrayOps$ofRef$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofRef$.prototype.equals$extension__AO__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofRef(x$1)) {
    var ofRef$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofRef(x$1).repr$1);
    return ($$this === ofRef$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofRef$ = new $TypeData().initClass({
  scm_ArrayOps$ofRef$: 0
}, false, "scala.collection.mutable.ArrayOps$ofRef$", {
  scm_ArrayOps$ofRef$: 1,
  O: 1
});
$c_scm_ArrayOps$ofRef$.prototype.$classData = $d_scm_ArrayOps$ofRef$;
var $n_scm_ArrayOps$ofRef$ = (void 0);
function $m_scm_ArrayOps$ofRef$() {
  if ((!$n_scm_ArrayOps$ofRef$)) {
    $n_scm_ArrayOps$ofRef$ = new $c_scm_ArrayOps$ofRef$().init___()
  };
  return $n_scm_ArrayOps$ofRef$
}
/** @constructor */
function $c_scm_ArrayOps$ofShort$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofShort$.prototype = new $h_O();
$c_scm_ArrayOps$ofShort$.prototype.constructor = $c_scm_ArrayOps$ofShort$;
/** @constructor */
function $h_scm_ArrayOps$ofShort$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofShort$.prototype = $c_scm_ArrayOps$ofShort$.prototype;
$c_scm_ArrayOps$ofShort$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofShort$.prototype.equals$extension__AS__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofShort(x$1)) {
    var ofShort$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofShort(x$1).repr$1);
    return ($$this === ofShort$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofShort$ = new $TypeData().initClass({
  scm_ArrayOps$ofShort$: 0
}, false, "scala.collection.mutable.ArrayOps$ofShort$", {
  scm_ArrayOps$ofShort$: 1,
  O: 1
});
$c_scm_ArrayOps$ofShort$.prototype.$classData = $d_scm_ArrayOps$ofShort$;
var $n_scm_ArrayOps$ofShort$ = (void 0);
function $m_scm_ArrayOps$ofShort$() {
  if ((!$n_scm_ArrayOps$ofShort$)) {
    $n_scm_ArrayOps$ofShort$ = new $c_scm_ArrayOps$ofShort$().init___()
  };
  return $n_scm_ArrayOps$ofShort$
}
/** @constructor */
function $c_scm_ArrayOps$ofUnit$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofUnit$.prototype = new $h_O();
$c_scm_ArrayOps$ofUnit$.prototype.constructor = $c_scm_ArrayOps$ofUnit$;
/** @constructor */
function $h_scm_ArrayOps$ofUnit$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofUnit$.prototype = $c_scm_ArrayOps$ofUnit$.prototype;
$c_scm_ArrayOps$ofUnit$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofUnit$.prototype.equals$extension__Asr_BoxedUnit__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofUnit(x$1)) {
    var ofUnit$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofUnit(x$1).repr$1);
    return ($$this === ofUnit$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofUnit$ = new $TypeData().initClass({
  scm_ArrayOps$ofUnit$: 0
}, false, "scala.collection.mutable.ArrayOps$ofUnit$", {
  scm_ArrayOps$ofUnit$: 1,
  O: 1
});
$c_scm_ArrayOps$ofUnit$.prototype.$classData = $d_scm_ArrayOps$ofUnit$;
var $n_scm_ArrayOps$ofUnit$ = (void 0);
function $m_scm_ArrayOps$ofUnit$() {
  if ((!$n_scm_ArrayOps$ofUnit$)) {
    $n_scm_ArrayOps$ofUnit$ = new $c_scm_ArrayOps$ofUnit$().init___()
  };
  return $n_scm_ArrayOps$ofUnit$
}
function $f_scm_FlatHashTable__calcSizeMapSize__I__I($thiz, tableLength) {
  return ((1 + (tableLength >> 5)) | 0)
}
function $f_scm_FlatHashTable__tableSizeSeed__I($thiz) {
  return $m_jl_Integer$().bitCount__I__I((((-1) + $thiz.table$5.u.length) | 0))
}
function $f_scm_FlatHashTable__addElem__O__Z($thiz, elem) {
  var newEntry = $f_scm_FlatHashTable$HashUtils__elemToEntry__O__O($thiz, elem);
  return $f_scm_FlatHashTable__addEntry__O__Z($thiz, newEntry)
}
function $f_scm_FlatHashTable__precedes$1__pscm_FlatHashTable__I__I__Z($thiz, i, j) {
  var d = ($thiz.table$5.u.length >> 1);
  return ((i <= j) ? (((j - i) | 0) < d) : (((i - j) | 0) > d))
}
function $f_scm_FlatHashTable__addEntry__O__Z($thiz, newEntry) {
  var hcode = $objectHashCode(newEntry);
  var h = $f_scm_FlatHashTable__index__I__I($thiz, hcode);
  var curEntry = $thiz.table$5.get(h);
  while ((curEntry !== null)) {
    if ($m_sr_BoxesRunTime$().equals__O__O__Z(curEntry, newEntry)) {
      return false
    };
    h = ((((1 + h) | 0) % $thiz.table$5.u.length) | 0);
    curEntry = $thiz.table$5.get(h)
  };
  $thiz.table$5.set(h, newEntry);
  $thiz.tableSize$5 = ((1 + $thiz.tableSize$5) | 0);
  var h$1 = h;
  $f_scm_FlatHashTable__nnSizeMapAdd__I__V($thiz, h$1);
  if (($thiz.tableSize$5 >= $thiz.threshold$5)) {
    $f_scm_FlatHashTable__growTable__pscm_FlatHashTable__V($thiz)
  };
  return true
}
function $f_scm_FlatHashTable__index__I__I($thiz, hcode) {
  var seed = $thiz.seedvalue$5;
  var improved = $f_scm_FlatHashTable$HashUtils__improve__I__I__I($thiz, hcode, seed);
  var ones = (((-1) + $thiz.table$5.u.length) | 0);
  return (((improved >>> ((32 - $m_jl_Integer$().bitCount__I__I(ones)) | 0)) | 0) & ones)
}
function $f_scm_FlatHashTable__initWithContents__scm_FlatHashTable$Contents__V($thiz, c) {
  if ((c !== null)) {
    $thiz.$$undloadFactor$5 = c.loadFactor__I();
    $thiz.table$5 = c.table__AO();
    $thiz.tableSize$5 = c.tableSize__I();
    $thiz.threshold$5 = c.threshold__I();
    $thiz.seedvalue$5 = c.seedvalue__I();
    $thiz.sizemap$5 = c.sizemap__AI()
  }
}
function $f_scm_FlatHashTable__removeElem__O__Z($thiz, elem) {
  var removalEntry = $f_scm_FlatHashTable$HashUtils__elemToEntry__O__O($thiz, elem);
  var hcode = $objectHashCode(removalEntry);
  var h = $f_scm_FlatHashTable__index__I__I($thiz, hcode);
  var curEntry = $thiz.table$5.get(h);
  while ((curEntry !== null)) {
    if ($m_sr_BoxesRunTime$().equals__O__O__Z(curEntry, removalEntry)) {
      var h0 = h;
      var h1 = ((((1 + h0) | 0) % $thiz.table$5.u.length) | 0);
      while (($thiz.table$5.get(h1) !== null)) {
        var hcode$1 = $objectHashCode($thiz.table$5.get(h1));
        var h2 = $f_scm_FlatHashTable__index__I__I($thiz, hcode$1);
        if ((h2 !== h1)) {
          var j = h0;
          var jsx$1 = $f_scm_FlatHashTable__precedes$1__pscm_FlatHashTable__I__I__Z($thiz, h2, j)
        } else {
          var jsx$1 = false
        };
        if (jsx$1) {
          $thiz.table$5.set(h0, $thiz.table$5.get(h1));
          h0 = h1
        };
        h1 = ((((1 + h1) | 0) % $thiz.table$5.u.length) | 0)
      };
      $thiz.table$5.set(h0, null);
      $thiz.tableSize$5 = (((-1) + $thiz.tableSize$5) | 0);
      var h$1 = h0;
      $f_scm_FlatHashTable__nnSizeMapRemove__I__V($thiz, h$1);
      return true
    };
    h = ((((1 + h) | 0) % $thiz.table$5.u.length) | 0);
    curEntry = $thiz.table$5.get(h)
  };
  return false
}
function $f_scm_FlatHashTable__$$init$__V($thiz) {
  $thiz.$$undloadFactor$5 = 450;
  $thiz.table$5 = $newArrayObject($d_O.getArrayOf(), [$m_scm_HashTable$().nextPositivePowerOfTwo__I__I(32)]);
  $thiz.tableSize$5 = 0;
  $thiz.threshold$5 = $m_scm_FlatHashTable$().newThreshold__I__I__I($thiz.$$undloadFactor$5, $m_scm_HashTable$().nextPositivePowerOfTwo__I__I(32));
  $thiz.sizemap$5 = null;
  $thiz.seedvalue$5 = $f_scm_FlatHashTable__tableSizeSeed__I($thiz)
}
function $f_scm_FlatHashTable__findElemImpl__pscm_FlatHashTable__O__O($thiz, elem) {
  var searchEntry = $f_scm_FlatHashTable$HashUtils__elemToEntry__O__O($thiz, elem);
  var hcode = $objectHashCode(searchEntry);
  var h = $f_scm_FlatHashTable__index__I__I($thiz, hcode);
  var curEntry = $thiz.table$5.get(h);
  while (((curEntry !== null) && (!$m_sr_BoxesRunTime$().equals__O__O__Z(curEntry, searchEntry)))) {
    h = ((((1 + h) | 0) % $thiz.table$5.u.length) | 0);
    curEntry = $thiz.table$5.get(h)
  };
  return curEntry
}
function $f_scm_FlatHashTable__containsElem__O__Z($thiz, elem) {
  return ($f_scm_FlatHashTable__findElemImpl__pscm_FlatHashTable__O__O($thiz, elem) !== null)
}
function $f_scm_FlatHashTable__nnSizeMapRemove__I__V($thiz, h) {
  if (($thiz.sizemap$5 !== null)) {
    var ev$2 = $thiz.sizemap$5;
    var ev$3 = (h >> 5);
    ev$2.set(ev$3, (((-1) + ev$2.get(ev$3)) | 0))
  }
}
function $f_scm_FlatHashTable__nnSizeMapReset__I__V($thiz, tableLength) {
  if (($thiz.sizemap$5 !== null)) {
    var nsize = $f_scm_FlatHashTable__calcSizeMapSize__I__I($thiz, tableLength);
    if (($thiz.sizemap$5.u.length !== nsize)) {
      $thiz.sizemap$5 = $newArrayObject($d_I.getArrayOf(), [nsize])
    } else {
      $m_ju_Arrays$().fill__AI__I__V($thiz.sizemap$5, 0)
    }
  }
}
function $f_scm_FlatHashTable__nnSizeMapAdd__I__V($thiz, h) {
  if (($thiz.sizemap$5 !== null)) {
    var p = (h >> 5);
    var ev$1 = $thiz.sizemap$5;
    ev$1.set(p, ((1 + ev$1.get(p)) | 0))
  }
}
function $f_scm_FlatHashTable__growTable__pscm_FlatHashTable__V($thiz) {
  var oldtable = $thiz.table$5;
  $thiz.table$5 = $newArrayObject($d_O.getArrayOf(), [($thiz.table$5.u.length << 1)]);
  $thiz.tableSize$5 = 0;
  var tableLength = $thiz.table$5.u.length;
  $f_scm_FlatHashTable__nnSizeMapReset__I__V($thiz, tableLength);
  $thiz.seedvalue$5 = $f_scm_FlatHashTable__tableSizeSeed__I($thiz);
  $thiz.threshold$5 = $m_scm_FlatHashTable$().newThreshold__I__I__I($thiz.$$undloadFactor$5, $thiz.table$5.u.length);
  var i = 0;
  while ((i < oldtable.u.length)) {
    var entry = oldtable.get(i);
    if ((entry !== null)) {
      $f_scm_FlatHashTable__addEntry__O__Z($thiz, entry)
    };
    i = ((1 + i) | 0)
  }
}
/** @constructor */
function $c_scm_FlatHashTable$() {
  $c_O.call(this)
}
$c_scm_FlatHashTable$.prototype = new $h_O();
$c_scm_FlatHashTable$.prototype.constructor = $c_scm_FlatHashTable$;
/** @constructor */
function $h_scm_FlatHashTable$() {
  /*<skip>*/
}
$h_scm_FlatHashTable$.prototype = $c_scm_FlatHashTable$.prototype;
$c_scm_FlatHashTable$.prototype.init___ = (function() {
  return this
});
$c_scm_FlatHashTable$.prototype.newThreshold__I__I__I = (function(_loadFactor, size) {
  var assertion = (_loadFactor < 500);
  if ((!assertion)) {
    throw new $c_jl_AssertionError().init___O("assertion failed: loadFactor too large; must be < 0.5")
  };
  var hi = (size >> 31);
  var hi$1 = (_loadFactor >> 31);
  var a0 = (65535 & size);
  var a1 = ((size >>> 16) | 0);
  var b0 = (65535 & _loadFactor);
  var b1 = ((_loadFactor >>> 16) | 0);
  var a0b0 = $imul(a0, b0);
  var a1b0 = $imul(a1, b0);
  var a0b1 = $imul(a0, b1);
  var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
  var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
  var hi$2 = (((((((($imul(size, hi$1) + $imul(hi, _loadFactor)) | 0) + $imul(a1, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
  var this$2 = $m_sjsr_RuntimeLong$();
  var lo$1 = this$2.divideImpl__I__I__I__I__I(lo, hi$2, 1000, 0);
  return lo$1
});
var $d_scm_FlatHashTable$ = new $TypeData().initClass({
  scm_FlatHashTable$: 0
}, false, "scala.collection.mutable.FlatHashTable$", {
  scm_FlatHashTable$: 1,
  O: 1
});
$c_scm_FlatHashTable$.prototype.$classData = $d_scm_FlatHashTable$;
var $n_scm_FlatHashTable$ = (void 0);
function $m_scm_FlatHashTable$() {
  if ((!$n_scm_FlatHashTable$)) {
    $n_scm_FlatHashTable$ = new $c_scm_FlatHashTable$().init___()
  };
  return $n_scm_FlatHashTable$
}
/** @constructor */
function $c_scm_FlatHashTable$NullSentinel$() {
  $c_O.call(this)
}
$c_scm_FlatHashTable$NullSentinel$.prototype = new $h_O();
$c_scm_FlatHashTable$NullSentinel$.prototype.constructor = $c_scm_FlatHashTable$NullSentinel$;
/** @constructor */
function $h_scm_FlatHashTable$NullSentinel$() {
  /*<skip>*/
}
$h_scm_FlatHashTable$NullSentinel$.prototype = $c_scm_FlatHashTable$NullSentinel$.prototype;
$c_scm_FlatHashTable$NullSentinel$.prototype.init___ = (function() {
  return this
});
$c_scm_FlatHashTable$NullSentinel$.prototype.toString__T = (function() {
  return "NullSentinel"
});
$c_scm_FlatHashTable$NullSentinel$.prototype.hashCode__I = (function() {
  return 0
});
var $d_scm_FlatHashTable$NullSentinel$ = new $TypeData().initClass({
  scm_FlatHashTable$NullSentinel$: 0
}, false, "scala.collection.mutable.FlatHashTable$NullSentinel$", {
  scm_FlatHashTable$NullSentinel$: 1,
  O: 1
});
$c_scm_FlatHashTable$NullSentinel$.prototype.$classData = $d_scm_FlatHashTable$NullSentinel$;
var $n_scm_FlatHashTable$NullSentinel$ = (void 0);
function $m_scm_FlatHashTable$NullSentinel$() {
  if ((!$n_scm_FlatHashTable$NullSentinel$)) {
    $n_scm_FlatHashTable$NullSentinel$ = new $c_scm_FlatHashTable$NullSentinel$().init___()
  };
  return $n_scm_FlatHashTable$NullSentinel$
}
function $f_scm_HashTable__calcSizeMapSize__I__I($thiz, tableLength) {
  return ((1 + (tableLength >> 5)) | 0)
}
function $f_scm_HashTable__tableSizeSeed__I($thiz) {
  return $m_jl_Integer$().bitCount__I__I((((-1) + $thiz.table__Ascm_HashEntry().u.length) | 0))
}
function $f_scm_HashTable__findEntry0__pscm_HashTable__O__I__scm_HashEntry($thiz, key, h) {
  var e = $thiz.table__Ascm_HashEntry().get(h);
  while (true) {
    if ((e !== null)) {
      var key1 = e.key__O();
      var jsx$1 = (!$m_sr_BoxesRunTime$().equals__O__O__Z(key1, key))
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      e = $as_scm_HashEntry(e.next__O())
    } else {
      break
    }
  };
  return e
}
function $f_scm_HashTable__addEntry__scm_HashEntry__V($thiz, e) {
  var key = e.key__O();
  var hcode = $m_sr_Statics$().anyHash__O__I(key);
  var h = $f_scm_HashTable__index__I__I($thiz, hcode);
  $f_scm_HashTable__addEntry0__pscm_HashTable__scm_HashEntry__I__V($thiz, e, h)
}
function $f_scm_HashTable__initWithContents__scm_HashTable$Contents__V($thiz, c) {
  if ((c !== null)) {
    $thiz.$$undloadFactor$und$eq__I__V(c.loadFactor__I());
    $thiz.table$und$eq__Ascm_HashEntry__V(c.table__Ascm_HashEntry());
    $thiz.tableSize$und$eq__I__V(c.tableSize__I());
    $thiz.threshold$und$eq__I__V(c.threshold__I());
    $thiz.seedvalue$und$eq__I__V(c.seedvalue__I());
    $thiz.sizemap$und$eq__AI__V(c.sizemap__AI())
  }
}
function $f_scm_HashTable__index__I__I($thiz, hcode) {
  var ones = (((-1) + $thiz.table__Ascm_HashEntry().u.length) | 0);
  var exponent = $clz32(ones);
  var seed = $thiz.seedvalue__I();
  return ((($f_scm_HashTable$HashUtils__improve__I__I__I($thiz, hcode, seed) >>> exponent) | 0) & ones)
}
function $f_scm_HashTable__$$init$__V($thiz) {
  $thiz.$$undloadFactor$und$eq__I__V(750);
  var this$1 = $m_scm_HashTable$();
  $thiz.table$und$eq__Ascm_HashEntry__V($newArrayObject($d_scm_HashEntry.getArrayOf(), [this$1.nextPositivePowerOfTwo__I__I(16)]));
  $thiz.tableSize$und$eq__I__V(0);
  var _loadFactor = $thiz.$$undloadFactor__I();
  var jsx$1 = $m_scm_HashTable$();
  var this$2 = $m_scm_HashTable$();
  $thiz.threshold$und$eq__I__V(jsx$1.newThreshold__I__I__I(_loadFactor, this$2.nextPositivePowerOfTwo__I__I(16)));
  $thiz.sizemap$und$eq__AI__V(null);
  $thiz.seedvalue$und$eq__I__V($f_scm_HashTable__tableSizeSeed__I($thiz))
}
function $f_scm_HashTable__removeEntry__O__scm_HashEntry($thiz, key) {
  var hcode = $m_sr_Statics$().anyHash__O__I(key);
  var h = $f_scm_HashTable__index__I__I($thiz, hcode);
  var e = $thiz.table__Ascm_HashEntry().get(h);
  if ((e !== null)) {
    var key1 = e.key__O();
    if ($m_sr_BoxesRunTime$().equals__O__O__Z(key1, key)) {
      $thiz.table__Ascm_HashEntry().set(h, $as_scm_HashEntry(e.next__O()));
      $thiz.tableSize$und$eq__I__V((((-1) + $thiz.tableSize__I()) | 0));
      $f_scm_HashTable__nnSizeMapRemove__I__V($thiz, h);
      e.next$und$eq__O__V(null);
      return e
    } else {
      var e1 = $as_scm_HashEntry(e.next__O());
      while (true) {
        if ((e1 !== null)) {
          var key1$1 = e1.key__O();
          var jsx$1 = (!$m_sr_BoxesRunTime$().equals__O__O__Z(key1$1, key))
        } else {
          var jsx$1 = false
        };
        if (jsx$1) {
          e = e1;
          e1 = $as_scm_HashEntry(e1.next__O())
        } else {
          break
        }
      };
      if ((e1 !== null)) {
        e.next$und$eq__O__V(e1.next__O());
        $thiz.tableSize$und$eq__I__V((((-1) + $thiz.tableSize__I()) | 0));
        $f_scm_HashTable__nnSizeMapRemove__I__V($thiz, h);
        e1.next$und$eq__O__V(null);
        return e1
      }
    }
  };
  return null
}
function $f_scm_HashTable__scala$collection$mutable$HashTable$$lastPopulatedIndex__I($thiz) {
  var idx = (((-1) + $thiz.table__Ascm_HashEntry().u.length) | 0);
  while ((($thiz.table__Ascm_HashEntry().get(idx) === null) && (idx > 0))) {
    idx = (((-1) + idx) | 0)
  };
  return idx
}
function $f_scm_HashTable__findOrAddEntry__O__O__scm_HashEntry($thiz, key, value) {
  var hcode = $m_sr_Statics$().anyHash__O__I(key);
  var h = $f_scm_HashTable__index__I__I($thiz, hcode);
  var e = $f_scm_HashTable__findEntry0__pscm_HashTable__O__I__scm_HashEntry($thiz, key, h);
  if ((e !== null)) {
    return e
  } else {
    var e$1 = $thiz.createNewEntry__O__O__scm_HashEntry(key, value);
    $f_scm_HashTable__addEntry0__pscm_HashTable__scm_HashEntry__I__V($thiz, e$1, h);
    return null
  }
}
function $f_scm_HashTable__findEntry__O__scm_HashEntry($thiz, key) {
  var hcode = $m_sr_Statics$().anyHash__O__I(key);
  var h = $f_scm_HashTable__index__I__I($thiz, hcode);
  return $f_scm_HashTable__findEntry0__pscm_HashTable__O__I__scm_HashEntry($thiz, key, h)
}
function $f_scm_HashTable__addEntry0__pscm_HashTable__scm_HashEntry__I__V($thiz, e, h) {
  e.next$und$eq__O__V($thiz.table__Ascm_HashEntry().get(h));
  $thiz.table__Ascm_HashEntry().set(h, e);
  $thiz.tableSize$und$eq__I__V(((1 + $thiz.tableSize__I()) | 0));
  $f_scm_HashTable__nnSizeMapAdd__I__V($thiz, h);
  if (($thiz.tableSize__I() > $thiz.threshold__I())) {
    var newSize = ($thiz.table__Ascm_HashEntry().u.length << 1);
    $f_scm_HashTable__resize__pscm_HashTable__I__V($thiz, newSize)
  }
}
function $f_scm_HashTable__nnSizeMapRemove__I__V($thiz, h) {
  if (($thiz.sizemap__AI() !== null)) {
    var ev$3 = $thiz.sizemap__AI();
    var ev$4 = (h >> 5);
    ev$3.set(ev$4, (((-1) + ev$3.get(ev$4)) | 0))
  }
}
function $f_scm_HashTable__nnSizeMapReset__I__V($thiz, tableLength) {
  if (($thiz.sizemap__AI() !== null)) {
    var nsize = $f_scm_HashTable__calcSizeMapSize__I__I($thiz, tableLength);
    if (($thiz.sizemap__AI().u.length !== nsize)) {
      $thiz.sizemap$und$eq__AI__V($newArrayObject($d_I.getArrayOf(), [nsize]))
    } else {
      $m_ju_Arrays$().fill__AI__I__V($thiz.sizemap__AI(), 0)
    }
  }
}
function $f_scm_HashTable__nnSizeMapAdd__I__V($thiz, h) {
  if (($thiz.sizemap__AI() !== null)) {
    var ev$1 = $thiz.sizemap__AI();
    var ev$2 = (h >> 5);
    ev$1.set(ev$2, ((1 + ev$1.get(ev$2)) | 0))
  }
}
function $f_scm_HashTable__resize__pscm_HashTable__I__V($thiz, newSize) {
  var oldTable = $thiz.table__Ascm_HashEntry();
  $thiz.table$und$eq__Ascm_HashEntry__V($newArrayObject($d_scm_HashEntry.getArrayOf(), [newSize]));
  var tableLength = $thiz.table__Ascm_HashEntry().u.length;
  $f_scm_HashTable__nnSizeMapReset__I__V($thiz, tableLength);
  var i = (((-1) + oldTable.u.length) | 0);
  while ((i >= 0)) {
    var e = oldTable.get(i);
    while ((e !== null)) {
      var key = e.key__O();
      var hcode = $m_sr_Statics$().anyHash__O__I(key);
      var h = $f_scm_HashTable__index__I__I($thiz, hcode);
      var e1 = $as_scm_HashEntry(e.next__O());
      e.next$und$eq__O__V($thiz.table__Ascm_HashEntry().get(h));
      $thiz.table__Ascm_HashEntry().set(h, e);
      e = e1;
      $f_scm_HashTable__nnSizeMapAdd__I__V($thiz, h)
    };
    i = (((-1) + i) | 0)
  };
  $thiz.threshold$und$eq__I__V($m_scm_HashTable$().newThreshold__I__I__I($thiz.$$undloadFactor__I(), newSize))
}
/** @constructor */
function $c_scm_HashTable$() {
  $c_O.call(this)
}
$c_scm_HashTable$.prototype = new $h_O();
$c_scm_HashTable$.prototype.constructor = $c_scm_HashTable$;
/** @constructor */
function $h_scm_HashTable$() {
  /*<skip>*/
}
$h_scm_HashTable$.prototype = $c_scm_HashTable$.prototype;
$c_scm_HashTable$.prototype.init___ = (function() {
  return this
});
$c_scm_HashTable$.prototype.nextPositivePowerOfTwo__I__I = (function(target) {
  return (1 << ((-$clz32((((-1) + target) | 0))) | 0))
});
$c_scm_HashTable$.prototype.newThreshold__I__I__I = (function(_loadFactor, size) {
  var hi = (size >> 31);
  var hi$1 = (_loadFactor >> 31);
  var a0 = (65535 & size);
  var a1 = ((size >>> 16) | 0);
  var b0 = (65535 & _loadFactor);
  var b1 = ((_loadFactor >>> 16) | 0);
  var a0b0 = $imul(a0, b0);
  var a1b0 = $imul(a1, b0);
  var a0b1 = $imul(a0, b1);
  var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
  var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
  var hi$2 = (((((((($imul(size, hi$1) + $imul(hi, _loadFactor)) | 0) + $imul(a1, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
  var this$1 = $m_sjsr_RuntimeLong$();
  var lo$1 = this$1.divideImpl__I__I__I__I__I(lo, hi$2, 1000, 0);
  return lo$1
});
var $d_scm_HashTable$ = new $TypeData().initClass({
  scm_HashTable$: 0
}, false, "scala.collection.mutable.HashTable$", {
  scm_HashTable$: 1,
  O: 1
});
$c_scm_HashTable$.prototype.$classData = $d_scm_HashTable$;
var $n_scm_HashTable$ = (void 0);
function $m_scm_HashTable$() {
  if ((!$n_scm_HashTable$)) {
    $n_scm_HashTable$ = new $c_scm_HashTable$().init___()
  };
  return $n_scm_HashTable$
}
/** @constructor */
function $c_sjs_concurrent_JSExecutionContext$() {
  $c_O.call(this);
  this.runNow$1 = null;
  this.queue$1 = null
}
$c_sjs_concurrent_JSExecutionContext$.prototype = new $h_O();
$c_sjs_concurrent_JSExecutionContext$.prototype.constructor = $c_sjs_concurrent_JSExecutionContext$;
/** @constructor */
function $h_sjs_concurrent_JSExecutionContext$() {
  /*<skip>*/
}
$h_sjs_concurrent_JSExecutionContext$.prototype = $c_sjs_concurrent_JSExecutionContext$.prototype;
$c_sjs_concurrent_JSExecutionContext$.prototype.init___ = (function() {
  $n_sjs_concurrent_JSExecutionContext$ = this;
  this.runNow$1 = $m_sjs_concurrent_RunNowExecutionContext$();
  this.queue$1 = $m_sjs_concurrent_QueueExecutionContext$().apply__s_concurrent_ExecutionContextExecutor();
  return this
});
var $d_sjs_concurrent_JSExecutionContext$ = new $TypeData().initClass({
  sjs_concurrent_JSExecutionContext$: 0
}, false, "scala.scalajs.concurrent.JSExecutionContext$", {
  sjs_concurrent_JSExecutionContext$: 1,
  O: 1
});
$c_sjs_concurrent_JSExecutionContext$.prototype.$classData = $d_sjs_concurrent_JSExecutionContext$;
var $n_sjs_concurrent_JSExecutionContext$ = (void 0);
function $m_sjs_concurrent_JSExecutionContext$() {
  if ((!$n_sjs_concurrent_JSExecutionContext$)) {
    $n_sjs_concurrent_JSExecutionContext$ = new $c_sjs_concurrent_JSExecutionContext$().init___()
  };
  return $n_sjs_concurrent_JSExecutionContext$
}
/** @constructor */
function $c_sjs_concurrent_QueueExecutionContext$() {
  $c_O.call(this)
}
$c_sjs_concurrent_QueueExecutionContext$.prototype = new $h_O();
$c_sjs_concurrent_QueueExecutionContext$.prototype.constructor = $c_sjs_concurrent_QueueExecutionContext$;
/** @constructor */
function $h_sjs_concurrent_QueueExecutionContext$() {
  /*<skip>*/
}
$h_sjs_concurrent_QueueExecutionContext$.prototype = $c_sjs_concurrent_QueueExecutionContext$.prototype;
$c_sjs_concurrent_QueueExecutionContext$.prototype.init___ = (function() {
  return this
});
$c_sjs_concurrent_QueueExecutionContext$.prototype.apply__s_concurrent_ExecutionContextExecutor = (function() {
  var v = $g.Promise;
  if ((v === (void 0))) {
    return new $c_sjs_concurrent_QueueExecutionContext$TimeoutsExecutionContext().init___()
  } else {
    return new $c_sjs_concurrent_QueueExecutionContext$PromisesExecutionContext().init___()
  }
});
var $d_sjs_concurrent_QueueExecutionContext$ = new $TypeData().initClass({
  sjs_concurrent_QueueExecutionContext$: 0
}, false, "scala.scalajs.concurrent.QueueExecutionContext$", {
  sjs_concurrent_QueueExecutionContext$: 1,
  O: 1
});
$c_sjs_concurrent_QueueExecutionContext$.prototype.$classData = $d_sjs_concurrent_QueueExecutionContext$;
var $n_sjs_concurrent_QueueExecutionContext$ = (void 0);
function $m_sjs_concurrent_QueueExecutionContext$() {
  if ((!$n_sjs_concurrent_QueueExecutionContext$)) {
    $n_sjs_concurrent_QueueExecutionContext$ = new $c_sjs_concurrent_QueueExecutionContext$().init___()
  };
  return $n_sjs_concurrent_QueueExecutionContext$
}
/** @constructor */
function $c_sjs_js_JSConverters$JSRichGenMap$() {
  $c_O.call(this)
}
$c_sjs_js_JSConverters$JSRichGenMap$.prototype = new $h_O();
$c_sjs_js_JSConverters$JSRichGenMap$.prototype.constructor = $c_sjs_js_JSConverters$JSRichGenMap$;
/** @constructor */
function $h_sjs_js_JSConverters$JSRichGenMap$() {
  /*<skip>*/
}
$h_sjs_js_JSConverters$JSRichGenMap$.prototype = $c_sjs_js_JSConverters$JSRichGenMap$.prototype;
$c_sjs_js_JSConverters$JSRichGenMap$.prototype.init___ = (function() {
  return this
});
var $d_sjs_js_JSConverters$JSRichGenMap$ = new $TypeData().initClass({
  sjs_js_JSConverters$JSRichGenMap$: 0
}, false, "scala.scalajs.js.JSConverters$JSRichGenMap$", {
  sjs_js_JSConverters$JSRichGenMap$: 1,
  O: 1
});
$c_sjs_js_JSConverters$JSRichGenMap$.prototype.$classData = $d_sjs_js_JSConverters$JSRichGenMap$;
var $n_sjs_js_JSConverters$JSRichGenMap$ = (void 0);
function $m_sjs_js_JSConverters$JSRichGenMap$() {
  if ((!$n_sjs_js_JSConverters$JSRichGenMap$)) {
    $n_sjs_js_JSConverters$JSRichGenMap$ = new $c_sjs_js_JSConverters$JSRichGenMap$().init___()
  };
  return $n_sjs_js_JSConverters$JSRichGenMap$
}
/** @constructor */
function $c_sjs_js_JSConverters$JSRichGenTraversableOnce$() {
  $c_O.call(this)
}
$c_sjs_js_JSConverters$JSRichGenTraversableOnce$.prototype = new $h_O();
$c_sjs_js_JSConverters$JSRichGenTraversableOnce$.prototype.constructor = $c_sjs_js_JSConverters$JSRichGenTraversableOnce$;
/** @constructor */
function $h_sjs_js_JSConverters$JSRichGenTraversableOnce$() {
  /*<skip>*/
}
$h_sjs_js_JSConverters$JSRichGenTraversableOnce$.prototype = $c_sjs_js_JSConverters$JSRichGenTraversableOnce$.prototype;
$c_sjs_js_JSConverters$JSRichGenTraversableOnce$.prototype.init___ = (function() {
  return this
});
$c_sjs_js_JSConverters$JSRichGenTraversableOnce$.prototype.toJSArray$extension__sc_GenTraversableOnce__sjs_js_Array = (function($$this) {
  if ($is_sjs_js_ArrayOps($$this)) {
    var x2 = $as_sjs_js_ArrayOps($$this);
    return x2.scala$scalajs$js$ArrayOps$$array$f
  } else if ($is_sjs_js_WrappedArray($$this)) {
    var x3 = $as_sjs_js_WrappedArray($$this);
    return x3.array$6
  } else {
    var result = [];
    $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, result$1) {
      return (function(x$2) {
        return $uI(result$1.push(x$2))
      })
    })(this, result)));
    return result
  }
});
var $d_sjs_js_JSConverters$JSRichGenTraversableOnce$ = new $TypeData().initClass({
  sjs_js_JSConverters$JSRichGenTraversableOnce$: 0
}, false, "scala.scalajs.js.JSConverters$JSRichGenTraversableOnce$", {
  sjs_js_JSConverters$JSRichGenTraversableOnce$: 1,
  O: 1
});
$c_sjs_js_JSConverters$JSRichGenTraversableOnce$.prototype.$classData = $d_sjs_js_JSConverters$JSRichGenTraversableOnce$;
var $n_sjs_js_JSConverters$JSRichGenTraversableOnce$ = (void 0);
function $m_sjs_js_JSConverters$JSRichGenTraversableOnce$() {
  if ((!$n_sjs_js_JSConverters$JSRichGenTraversableOnce$)) {
    $n_sjs_js_JSConverters$JSRichGenTraversableOnce$ = new $c_sjs_js_JSConverters$JSRichGenTraversableOnce$().init___()
  };
  return $n_sjs_js_JSConverters$JSRichGenTraversableOnce$
}
/** @constructor */
function $c_sjs_js_WrappedDictionary$Cache$() {
  $c_O.call(this);
  this.safeHasOwnProperty$1 = null
}
$c_sjs_js_WrappedDictionary$Cache$.prototype = new $h_O();
$c_sjs_js_WrappedDictionary$Cache$.prototype.constructor = $c_sjs_js_WrappedDictionary$Cache$;
/** @constructor */
function $h_sjs_js_WrappedDictionary$Cache$() {
  /*<skip>*/
}
$h_sjs_js_WrappedDictionary$Cache$.prototype = $c_sjs_js_WrappedDictionary$Cache$.prototype;
$c_sjs_js_WrappedDictionary$Cache$.prototype.init___ = (function() {
  $n_sjs_js_WrappedDictionary$Cache$ = this;
  this.safeHasOwnProperty$1 = $g.Object.prototype.hasOwnProperty;
  return this
});
var $d_sjs_js_WrappedDictionary$Cache$ = new $TypeData().initClass({
  sjs_js_WrappedDictionary$Cache$: 0
}, false, "scala.scalajs.js.WrappedDictionary$Cache$", {
  sjs_js_WrappedDictionary$Cache$: 1,
  O: 1
});
$c_sjs_js_WrappedDictionary$Cache$.prototype.$classData = $d_sjs_js_WrappedDictionary$Cache$;
var $n_sjs_js_WrappedDictionary$Cache$ = (void 0);
function $m_sjs_js_WrappedDictionary$Cache$() {
  if ((!$n_sjs_js_WrappedDictionary$Cache$)) {
    $n_sjs_js_WrappedDictionary$Cache$ = new $c_sjs_js_WrappedDictionary$Cache$().init___()
  };
  return $n_sjs_js_WrappedDictionary$Cache$
}
/** @constructor */
function $c_sjsr_Bits$() {
  $c_O.call(this);
  this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f = false;
  this.arrayBuffer$1 = null;
  this.int32Array$1 = null;
  this.float32Array$1 = null;
  this.float64Array$1 = null;
  this.areTypedArraysBigEndian$1 = false;
  this.highOffset$1 = 0;
  this.lowOffset$1 = 0
}
$c_sjsr_Bits$.prototype = new $h_O();
$c_sjsr_Bits$.prototype.constructor = $c_sjsr_Bits$;
/** @constructor */
function $h_sjsr_Bits$() {
  /*<skip>*/
}
$h_sjsr_Bits$.prototype = $c_sjsr_Bits$.prototype;
$c_sjsr_Bits$.prototype.init___ = (function() {
  $n_sjsr_Bits$ = this;
  var x = ((($g.ArrayBuffer && $g.Int32Array) && $g.Float32Array) && $g.Float64Array);
  this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f = $uZ((!(!x)));
  this.arrayBuffer$1 = (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f ? new $g.ArrayBuffer(8) : null);
  this.int32Array$1 = (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f ? new $g.Int32Array(this.arrayBuffer$1, 0, 2) : null);
  this.float32Array$1 = (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f ? new $g.Float32Array(this.arrayBuffer$1, 0, 2) : null);
  this.float64Array$1 = (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f ? new $g.Float64Array(this.arrayBuffer$1, 0, 1) : null);
  if ((!this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f)) {
    var jsx$1 = true
  } else {
    this.int32Array$1[0] = 16909060;
    var jsx$1 = ($uB(new $g.Int8Array(this.arrayBuffer$1, 0, 8)[0]) === 1)
  };
  this.areTypedArraysBigEndian$1 = jsx$1;
  this.highOffset$1 = (this.areTypedArraysBigEndian$1 ? 0 : 1);
  this.lowOffset$1 = (this.areTypedArraysBigEndian$1 ? 1 : 0);
  return this
});
$c_sjsr_Bits$.prototype.numberHashCode__D__I = (function(value) {
  var iv = $uI((value | 0));
  if (((iv === value) && ((1.0 / value) !== (-Infinity)))) {
    return iv
  } else {
    var t = this.doubleToLongBits__D__J(value);
    var lo = t.lo$2;
    var hi = t.hi$2;
    return (lo ^ hi)
  }
});
$c_sjsr_Bits$.prototype.doubleToLongBitsPolyfill__p1__D__J = (function(value) {
  if ((value !== value)) {
    var _3 = $uD($g.Math.pow(2.0, 51));
    var x1_$_$$und1$1 = false;
    var x1_$_$$und2$1 = 2047;
    var x1_$_$$und3$1 = _3
  } else if (((value === Infinity) || (value === (-Infinity)))) {
    var _1 = (value < 0);
    var x1_$_$$und1$1 = _1;
    var x1_$_$$und2$1 = 2047;
    var x1_$_$$und3$1 = 0.0
  } else if ((value === 0.0)) {
    var _1$1 = ((1 / value) === (-Infinity));
    var x1_$_$$und1$1 = _1$1;
    var x1_$_$$und2$1 = 0;
    var x1_$_$$und3$1 = 0.0
  } else {
    var s = (value < 0);
    var av = (s ? (-value) : value);
    if ((av >= $uD($g.Math.pow(2.0, (-1022))))) {
      var twoPowFbits = $uD($g.Math.pow(2.0, 52));
      var a = ($uD($g.Math.log(av)) / 0.6931471805599453);
      var x = $uD($g.Math.floor(a));
      var a$1 = $uI((x | 0));
      var e = ((a$1 < 1023) ? a$1 : 1023);
      var b = e;
      var twoPowE = $uD($g.Math.pow(2.0, b));
      if ((twoPowE > av)) {
        e = (((-1) + e) | 0);
        twoPowE = (twoPowE / 2)
      };
      var n = ((av / twoPowE) * twoPowFbits);
      var w = $uD($g.Math.floor(n));
      var f = (n - w);
      var f$1 = ((f < 0.5) ? w : ((f > 0.5) ? (1 + w) : (((w % 2) !== 0) ? (1 + w) : w)));
      if (((f$1 / twoPowFbits) >= 2)) {
        e = ((1 + e) | 0);
        f$1 = 1.0
      };
      if ((e > 1023)) {
        e = 2047;
        f$1 = 0.0
      } else {
        e = ((1023 + e) | 0);
        f$1 = (f$1 - twoPowFbits)
      };
      var _2 = e;
      var _3$1 = f$1;
      var x1_$_$$und1$1 = s;
      var x1_$_$$und2$1 = _2;
      var x1_$_$$und3$1 = _3$1
    } else {
      var n$1 = (av / $uD($g.Math.pow(2.0, (-1074))));
      var w$1 = $uD($g.Math.floor(n$1));
      var f$2 = (n$1 - w$1);
      var _3$2 = ((f$2 < 0.5) ? w$1 : ((f$2 > 0.5) ? (1 + w$1) : (((w$1 % 2) !== 0) ? (1 + w$1) : w$1)));
      var x1_$_$$und1$1 = s;
      var x1_$_$$und2$1 = 0;
      var x1_$_$$und3$1 = _3$2
    }
  };
  var s$1 = $uZ(x1_$_$$und1$1);
  var e$1 = $uI(x1_$_$$und2$1);
  var f$3 = $uD(x1_$_$$und3$1);
  var x$1 = (f$3 / 4.294967296E9);
  var hif = $uI((x$1 | 0));
  var hi = (((s$1 ? (-2147483648) : 0) | (e$1 << 20)) | hif);
  var lo = $uI((f$3 | 0));
  return new $c_sjsr_RuntimeLong().init___I__I(lo, hi)
});
$c_sjsr_Bits$.prototype.longBitsToDoublePolyfill__p1__J__D = (function(bits) {
  var lo = bits.hi$2;
  var x = bits.lo$2;
  var lo$1 = $uD((x >>> 0));
  var s = (lo < 0);
  var e = (2047 & (lo >> 20));
  var f = ((4.294967296E9 * (1048575 & lo)) + lo$1);
  if ((e === 2047)) {
    return ((f !== 0.0) ? (NaN) : (s ? (-Infinity) : Infinity))
  } else if ((e > 0)) {
    var b = (((-1023) + e) | 0);
    var x$1 = ($uD($g.Math.pow(2.0, b)) * (1 + (f / $uD($g.Math.pow(2.0, 52)))));
    return (s ? (-x$1) : x$1)
  } else if ((f !== 0.0)) {
    var x$2 = ($uD($g.Math.pow(2.0, (-1022))) * (f / $uD($g.Math.pow(2.0, 52))));
    return (s ? (-x$2) : x$2)
  } else {
    return (s ? (-0) : 0.0)
  }
});
$c_sjsr_Bits$.prototype.longBitsToDouble__J__D = (function(bits) {
  if (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f) {
    var jsx$2 = this.int32Array$1;
    var jsx$1 = this.highOffset$1;
    var lo = bits.hi$2;
    jsx$2[jsx$1] = lo;
    this.int32Array$1[this.lowOffset$1] = bits.lo$2;
    return $uD(this.float64Array$1[0])
  } else {
    return this.longBitsToDoublePolyfill__p1__J__D(bits)
  }
});
$c_sjsr_Bits$.prototype.doubleToLongBits__D__J = (function(value) {
  if (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f) {
    this.float64Array$1[0] = value;
    var value$1 = $uI(this.int32Array$1[this.highOffset$1]);
    var value$2 = $uI(this.int32Array$1[this.lowOffset$1]);
    return new $c_sjsr_RuntimeLong().init___I__I(value$2, value$1)
  } else {
    return this.doubleToLongBitsPolyfill__p1__D__J(value)
  }
});
var $d_sjsr_Bits$ = new $TypeData().initClass({
  sjsr_Bits$: 0
}, false, "scala.scalajs.runtime.Bits$", {
  sjsr_Bits$: 1,
  O: 1
});
$c_sjsr_Bits$.prototype.$classData = $d_sjsr_Bits$;
var $n_sjsr_Bits$ = (void 0);
function $m_sjsr_Bits$() {
  if ((!$n_sjsr_Bits$)) {
    $n_sjsr_Bits$ = new $c_sjsr_Bits$().init___()
  };
  return $n_sjsr_Bits$
}
/** @constructor */
function $c_sjsr_RuntimeString$() {
  $c_O.call(this);
  this.CASE$undINSENSITIVE$undORDER$1 = null;
  this.bitmap$0$1 = false
}
$c_sjsr_RuntimeString$.prototype = new $h_O();
$c_sjsr_RuntimeString$.prototype.constructor = $c_sjsr_RuntimeString$;
/** @constructor */
function $h_sjsr_RuntimeString$() {
  /*<skip>*/
}
$h_sjsr_RuntimeString$.prototype = $c_sjsr_RuntimeString$.prototype;
$c_sjsr_RuntimeString$.prototype.endsWith__T__T__Z = (function(thiz, suffix) {
  return ($as_T(thiz.substring((($uI(thiz.length) - $uI(suffix.length)) | 0))) === suffix)
});
$c_sjsr_RuntimeString$.prototype.init___ = (function() {
  return this
});
$c_sjsr_RuntimeString$.prototype.indexOf__T__I__I__I = (function(thiz, ch, fromIndex) {
  var str = this.fromCodePoint__p1__I__T(ch);
  return $uI(thiz.indexOf(str, fromIndex))
});
$c_sjsr_RuntimeString$.prototype.valueOf__C__T = (function(c) {
  return $as_T($g.String.fromCharCode(c))
});
$c_sjsr_RuntimeString$.prototype.split__T__T__I__AT = (function(thiz, regex, limit) {
  if ((thiz === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  var this$1 = $m_ju_regex_Pattern$();
  return this$1.compile__T__I__ju_regex_Pattern(regex, 0).split__jl_CharSequence__I__AT(thiz, limit)
});
$c_sjsr_RuntimeString$.prototype.toCharArray__T__AC = (function(thiz) {
  var length = $uI(thiz.length);
  var result = $newArrayObject($d_C.getArrayOf(), [length]);
  var i = 0;
  while ((i < length)) {
    var jsx$1 = i;
    var index = i;
    result.set(jsx$1, (65535 & $uI(thiz.charCodeAt(index))));
    i = ((1 + i) | 0)
  };
  return result
});
$c_sjsr_RuntimeString$.prototype.lastIndexOf__T__I__I = (function(thiz, ch) {
  var str = this.fromCodePoint__p1__I__T(ch);
  return $uI(thiz.lastIndexOf(str))
});
$c_sjsr_RuntimeString$.prototype.indexOf__T__I__I = (function(thiz, ch) {
  var str = this.fromCodePoint__p1__I__T(ch);
  return $uI(thiz.indexOf(str))
});
$c_sjsr_RuntimeString$.prototype.newString__AC__I__I__T = (function(value, offset, count) {
  var end = ((offset + count) | 0);
  if ((((offset < 0) || (end < offset)) || (end > value.u.length))) {
    throw new $c_jl_StringIndexOutOfBoundsException().init___()
  };
  var result = "";
  var i = offset;
  while ((i !== end)) {
    var jsx$1 = result;
    var c = value.get(i);
    result = (("" + jsx$1) + $as_T($g.String.fromCharCode(c)));
    i = ((1 + i) | 0)
  };
  return result
});
$c_sjsr_RuntimeString$.prototype.fromCodePoint__p1__I__T = (function(codePoint) {
  if ((((-65536) & codePoint) === 0)) {
    return $as_T($g.String.fromCharCode(codePoint))
  } else if (((codePoint < 0) || (codePoint > 1114111))) {
    throw new $c_jl_IllegalArgumentException().init___()
  } else {
    var offsetCp = (((-65536) + codePoint) | 0);
    return $as_T($g.String.fromCharCode((55296 | (offsetCp >> 10)), (56320 | (1023 & offsetCp))))
  }
});
$c_sjsr_RuntimeString$.prototype.hashCode__T__I = (function(thiz) {
  var res = 0;
  var mul = 1;
  var i = (((-1) + $uI(thiz.length)) | 0);
  while ((i >= 0)) {
    var jsx$1 = res;
    var index = i;
    res = ((jsx$1 + $imul((65535 & $uI(thiz.charCodeAt(index))), mul)) | 0);
    mul = $imul(31, mul);
    i = (((-1) + i) | 0)
  };
  return res
});
$c_sjsr_RuntimeString$.prototype.format__T__AO__T = (function(format, args) {
  var frm = new $c_ju_Formatter().init___();
  var res = frm.format__T__AO__ju_Formatter(format, args).toString__T();
  frm.close__V();
  return res
});
$c_sjsr_RuntimeString$.prototype.replaceAll__T__T__T__T = (function(thiz, regex, replacement) {
  if ((thiz === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  var this$1 = $m_ju_regex_Pattern$();
  var this$2 = this$1.compile__T__I__ju_regex_Pattern(regex, 0);
  return new $c_ju_regex_Matcher().init___ju_regex_Pattern__jl_CharSequence__I__I(this$2, thiz, 0, $uI(thiz.length)).replaceAll__T__T(replacement)
});
var $d_sjsr_RuntimeString$ = new $TypeData().initClass({
  sjsr_RuntimeString$: 0
}, false, "scala.scalajs.runtime.RuntimeString$", {
  sjsr_RuntimeString$: 1,
  O: 1
});
$c_sjsr_RuntimeString$.prototype.$classData = $d_sjsr_RuntimeString$;
var $n_sjsr_RuntimeString$ = (void 0);
function $m_sjsr_RuntimeString$() {
  if ((!$n_sjsr_RuntimeString$)) {
    $n_sjsr_RuntimeString$ = new $c_sjsr_RuntimeString$().init___()
  };
  return $n_sjsr_RuntimeString$
}
/** @constructor */
function $c_sjsr_StackTrace$() {
  $c_O.call(this);
  this.isRhino$1 = false;
  this.decompressedClasses$1 = null;
  this.decompressedPrefixes$1 = null;
  this.compressedPrefixes$1 = null;
  this.bitmap$0$1 = 0
}
$c_sjsr_StackTrace$.prototype = new $h_O();
$c_sjsr_StackTrace$.prototype.constructor = $c_sjsr_StackTrace$;
/** @constructor */
function $h_sjsr_StackTrace$() {
  /*<skip>*/
}
$h_sjsr_StackTrace$.prototype = $c_sjsr_StackTrace$.prototype;
$c_sjsr_StackTrace$.prototype.compressedPrefixes$lzycompute__p1__sjs_js_Array = (function() {
  if (((((8 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.compressedPrefixes$1 = $g.Object.keys(this.decompressedPrefixes__p1__sjs_js_Dictionary());
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.compressedPrefixes$1
});
$c_sjsr_StackTrace$.prototype.extractFirefox__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = $as_T(e.stack);
  var jsx$2 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("(?:\\n@:0)?\\s+$", "m"), "");
  var x$1 = $as_T(jsx$2);
  var jsx$1 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^(?:\\((\\S*)\\))?@", "gm"), "{anonymous}($1)@");
  var x$2 = $as_T(jsx$1);
  return x$2.split("\n")
});
$c_sjsr_StackTrace$.prototype.extractOpera10a__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var lineRE = $m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("Line (\\d+).*script (?:in )?(\\S+)(?:: In function (\\S+))?$", "i");
  var x = $as_T(e.stacktrace);
  var lines = x.split("\n");
  var result = [];
  var i = 0;
  var len = $uI(lines.length);
  while ((i < len)) {
    var mtch = lineRE.exec($as_T(lines[i]));
    if ((mtch !== null)) {
      var value = mtch[3];
      var fnName = $as_T(((value === (void 0)) ? "{anonymous}" : value));
      var value$1 = mtch[2];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var value$2 = mtch[1];
      if ((value$2 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var jsx$1 = result.push(((((fnName + "()@") + value$1) + ":") + value$2));
      $uI(jsx$1)
    };
    i = ((2 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.init___ = (function() {
  return this
});
$c_sjsr_StackTrace$.prototype.isRhino__p1__Z = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.isRhino$lzycompute__p1__Z() : this.isRhino$1)
});
$c_sjsr_StackTrace$.prototype.decodeClassName__p1__T__T = (function(encodedName) {
  var encoded = (((65535 & $uI(encodedName.charCodeAt(0))) === 36) ? $as_T(encodedName.substring(1)) : encodedName);
  var dict = this.decompressedClasses__p1__sjs_js_Dictionary();
  if ($uZ($m_sjs_js_WrappedDictionary$Cache$().safeHasOwnProperty$1.call(dict, encoded))) {
    var dict$1 = this.decompressedClasses__p1__sjs_js_Dictionary();
    if ((!$uZ($m_sjs_js_WrappedDictionary$Cache$().safeHasOwnProperty$1.call(dict$1, encoded)))) {
      throw new $c_ju_NoSuchElementException().init___T(("key not found: " + encoded))
    };
    var base = $as_T(dict$1[encoded])
  } else {
    var base = this.loop$1__p1__I__T__T(0, encoded)
  };
  var thiz = $as_T(base.split("_").join("."));
  return $as_T(thiz.split("$und").join("_"))
});
$c_sjsr_StackTrace$.prototype.extractOpera10b__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var lineRE = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^(.*)@(.+):(\\d+)$");
  var x = $as_T(e.stacktrace);
  var lines = x.split("\n");
  var result = [];
  var i = 0;
  var len = $uI(lines.length);
  while ((i < len)) {
    var mtch = lineRE.exec($as_T(lines[i]));
    if ((mtch !== null)) {
      var value = mtch[1];
      if ((value === (void 0))) {
        var fnName = "global code"
      } else {
        var x$3 = $as_T(value);
        var fnName = (x$3 + "()")
      };
      var value$1 = mtch[2];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var value$2 = mtch[3];
      if ((value$2 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var jsx$1 = result.push(((((fnName + "@") + value$1) + ":") + value$2));
      $uI(jsx$1)
    };
    i = ((1 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.extractChrome__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = ($as_T(e.stack) + "\n");
  var jsx$6 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^[\\s\\S]+?\\s+at\\s+"), " at ");
  var x$1 = $as_T(jsx$6);
  var jsx$5 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^\\s+(at eval )?at\\s+", "gm"), "");
  var x$2 = $as_T(jsx$5);
  var jsx$4 = x$2.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^([^\\(]+?)([\\n])", "gm"), "{anonymous}() ($1)$2");
  var x$3 = $as_T(jsx$4);
  var jsx$3 = x$3.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^Object.<anonymous>\\s*\\(([^\\)]+)\\)", "gm"), "{anonymous}() ($1)");
  var x$4 = $as_T(jsx$3);
  var jsx$2 = x$4.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^([^\\(]+|\\{anonymous\\}\\(\\)) \\((.+)\\)$", "gm"), "$1@$2");
  var x$5 = $as_T(jsx$2);
  var jsx$1 = x$5.split("\n");
  return jsx$1.slice(0, (-1))
});
$c_sjsr_StackTrace$.prototype.extract__sjs_js_Dynamic__Ajl_StackTraceElement = (function(stackdata) {
  var lines = this.normalizeStackTraceLines__p1__sjs_js_Dynamic__sjs_js_Array(stackdata);
  return this.normalizedLinesToStackTrace__p1__sjs_js_Array__Ajl_StackTraceElement(lines)
});
$c_sjsr_StackTrace$.prototype.compressedPrefixes__p1__sjs_js_Array = (function() {
  return (((((8 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.compressedPrefixes$lzycompute__p1__sjs_js_Array() : this.compressedPrefixes$1)
});
$c_sjsr_StackTrace$.prototype.decompressedClasses__p1__sjs_js_Dictionary = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.decompressedClasses$lzycompute__p1__sjs_js_Dictionary() : this.decompressedClasses$1)
});
$c_sjsr_StackTrace$.prototype.extractClassMethod__p1__T__T2 = (function(functionName) {
  var PatC = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^(?:Object\\.|\\[object Object\\]\\.)?(?:ScalaJS\\.c\\.|\\$c_)([^\\.]+)(?:\\.prototype)?\\.([^\\.]+)$");
  var PatS = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^(?:Object\\.|\\[object Object\\]\\.)?(?:ScalaJS\\.(?:s|f)\\.|\\$(?:s|f)_)((?:_[^_]|[^_])+)__([^\\.]+)$");
  var PatM = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^(?:Object\\.|\\[object Object\\]\\.)?(?:ScalaJS\\.m\\.|\\$m_)([^\\.]+)$");
  var isModule = false;
  var mtch = PatC.exec(functionName);
  if ((mtch === null)) {
    mtch = PatS.exec(functionName);
    if ((mtch === null)) {
      mtch = PatM.exec(functionName);
      isModule = true
    }
  };
  if ((mtch !== null)) {
    var value = mtch[1];
    if ((value === (void 0))) {
      throw new $c_ju_NoSuchElementException().init___T("undefined.get")
    };
    var className = this.decodeClassName__p1__T__T($as_T(value));
    if (isModule) {
      var methodName = "<clinit>"
    } else {
      var value$1 = mtch[2];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var methodName = this.decodeMethodName__p1__T__T($as_T(value$1))
    };
    return new $c_T2().init___O__O(className, methodName)
  } else {
    return new $c_T2().init___O__O("<jscode>", functionName)
  }
});
$c_sjsr_StackTrace$.prototype.isRhino$lzycompute__p1__Z = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.isRhino$1 = this.liftedTree1$1__p1__Z();
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.isRhino$1
});
$c_sjsr_StackTrace$.prototype.decompressedPrefixes$lzycompute__p1__sjs_js_Dictionary = (function() {
  if (((((4 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.decompressedPrefixes$1 = {
      "sjsr_": "scala_scalajs_runtime_",
      "sjs_": "scala_scalajs_",
      "sci_": "scala_collection_immutable_",
      "scm_": "scala_collection_mutable_",
      "scg_": "scala_collection_generic_",
      "sc_": "scala_collection_",
      "sr_": "scala_runtime_",
      "s_": "scala_",
      "jl_": "java_lang_",
      "ju_": "java_util_"
    };
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.decompressedPrefixes$1
});
$c_sjsr_StackTrace$.prototype.extract__jl_Throwable__Ajl_StackTraceElement = (function(throwable) {
  return this.extract__sjs_js_Dynamic__Ajl_StackTraceElement(throwable.stackdata)
});
$c_sjsr_StackTrace$.prototype.decompressedClasses$lzycompute__p1__sjs_js_Dictionary = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var dict = {
      "O": "java_lang_Object",
      "T": "java_lang_String",
      "V": "scala_Unit",
      "Z": "scala_Boolean",
      "C": "scala_Char",
      "B": "scala_Byte",
      "S": "scala_Short",
      "I": "scala_Int",
      "J": "scala_Long",
      "F": "scala_Float",
      "D": "scala_Double"
    };
    var index = 0;
    while ((index <= 22)) {
      if ((index >= 2)) {
        dict[("T" + index)] = ("scala_Tuple" + index)
      };
      dict[("F" + index)] = ("scala_Function" + index);
      index = ((1 + index) | 0)
    };
    this.decompressedClasses$1 = dict;
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.decompressedClasses$1
});
$c_sjsr_StackTrace$.prototype.normalizeStackTraceLines__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = (!e);
  if ($uZ((!(!x)))) {
    return []
  } else if (this.isRhino__p1__Z()) {
    return this.extractRhino__p1__sjs_js_Dynamic__sjs_js_Array(e)
  } else {
    var x$1 = (e.arguments && e.stack);
    if ($uZ((!(!x$1)))) {
      return this.extractChrome__p1__sjs_js_Dynamic__sjs_js_Array(e)
    } else {
      var x$2 = (e.stack && e.sourceURL);
      if ($uZ((!(!x$2)))) {
        return this.extractSafari__p1__sjs_js_Dynamic__sjs_js_Array(e)
      } else {
        var x$3 = (e.stack && e.number);
        if ($uZ((!(!x$3)))) {
          return this.extractIE__p1__sjs_js_Dynamic__sjs_js_Array(e)
        } else {
          var x$4 = (e.stack && e.fileName);
          if ($uZ((!(!x$4)))) {
            return this.extractFirefox__p1__sjs_js_Dynamic__sjs_js_Array(e)
          } else {
            var x$5 = (e.message && e["opera#sourceloc"]);
            if ($uZ((!(!x$5)))) {
              var x$6 = (!e.stacktrace);
              if ($uZ((!(!x$6)))) {
                return this.extractOpera9__p1__sjs_js_Dynamic__sjs_js_Array(e)
              } else {
                var x$7 = ((e.message.indexOf("\n") > (-1)) && (e.message.split("\n").length > e.stacktrace.split("\n").length));
                if ($uZ((!(!x$7)))) {
                  return this.extractOpera9__p1__sjs_js_Dynamic__sjs_js_Array(e)
                } else {
                  return this.extractOpera10a__p1__sjs_js_Dynamic__sjs_js_Array(e)
                }
              }
            } else {
              var x$8 = ((e.message && e.stack) && e.stacktrace);
              if ($uZ((!(!x$8)))) {
                var x$9 = (e.stacktrace.indexOf("called from line") < 0);
                if ($uZ((!(!x$9)))) {
                  return this.extractOpera10b__p1__sjs_js_Dynamic__sjs_js_Array(e)
                } else {
                  return this.extractOpera11__p1__sjs_js_Dynamic__sjs_js_Array(e)
                }
              } else {
                var x$10 = (e.stack && (!e.fileName));
                if ($uZ((!(!x$10)))) {
                  return this.extractChrome__p1__sjs_js_Dynamic__sjs_js_Array(e)
                } else {
                  return this.extractOther__p1__sjs_js_Dynamic__sjs_js_Array(e)
                }
              }
            }
          }
        }
      }
    }
  }
});
$c_sjsr_StackTrace$.prototype.extractOpera9__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var lineRE = $m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("Line (\\d+).*script (?:in )?(\\S+)", "i");
  var x = $as_T(e.message);
  var lines = x.split("\n");
  var result = [];
  var i = 2;
  var len = $uI(lines.length);
  while ((i < len)) {
    var mtch = lineRE.exec($as_T(lines[i]));
    if ((mtch !== null)) {
      var value = mtch[2];
      if ((value === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var value$1 = mtch[1];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var jsx$1 = result.push(((("{anonymous}()@" + value) + ":") + value$1));
      $uI(jsx$1)
    };
    i = ((2 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.normalizedLinesToStackTrace__p1__sjs_js_Array__Ajl_StackTraceElement = (function(lines) {
  var NormalizedFrameLine = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^([^\\@]*)\\@(.*):([0-9]+)$");
  var NormalizedFrameLineWithColumn = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^([^\\@]*)\\@(.*):([0-9]+):([0-9]+)$");
  var trace = [];
  var i = 0;
  while ((i < $uI(lines.length))) {
    var line = $as_T(lines[i]);
    if ((line === null)) {
      throw new $c_jl_NullPointerException().init___()
    };
    if ((line !== "")) {
      var mtch1 = NormalizedFrameLineWithColumn.exec(line);
      if ((mtch1 !== null)) {
        var value = mtch1[1];
        if ((value === (void 0))) {
          throw new $c_ju_NoSuchElementException().init___T("undefined.get")
        };
        var x1 = this.extractClassMethod__p1__T__T2($as_T(value));
        if ((x1 === null)) {
          throw new $c_s_MatchError().init___O(x1)
        };
        var className = $as_T(x1.$$und1__O());
        var methodName = $as_T(x1.$$und2__O());
        var value$1 = mtch1[2];
        if ((value$1 === (void 0))) {
          throw new $c_ju_NoSuchElementException().init___T("undefined.get")
        };
        var fileName = $as_T(value$1);
        var value$2 = mtch1[3];
        if ((value$2 === (void 0))) {
          throw new $c_ju_NoSuchElementException().init___T("undefined.get")
        };
        var x = $as_T(value$2);
        var this$15 = new $c_sci_StringOps().init___T(x);
        var this$17 = $m_jl_Integer$();
        var $$this = this$15.repr$1;
        var lineNumber = this$17.parseInt__T__I__I($$this, 10);
        var value$3 = mtch1[4];
        if ((value$3 === (void 0))) {
          throw new $c_ju_NoSuchElementException().init___T("undefined.get")
        };
        var x$1 = $as_T(value$3);
        var this$23 = new $c_sci_StringOps().init___T(x$1);
        var this$25 = $m_jl_Integer$();
        var $$this$1 = this$23.repr$1;
        var value$4 = this$25.parseInt__T__I__I($$this$1, 10);
        var jsx$1 = trace.push({
          "declaringClass": className,
          "methodName": methodName,
          "fileName": fileName,
          "lineNumber": lineNumber,
          "columnNumber": ((value$4 === (void 0)) ? (void 0) : value$4)
        });
        $uI(jsx$1)
      } else {
        var mtch2 = NormalizedFrameLine.exec(line);
        if ((mtch2 !== null)) {
          var value$5 = mtch2[1];
          if ((value$5 === (void 0))) {
            throw new $c_ju_NoSuchElementException().init___T("undefined.get")
          };
          var x1$2 = this.extractClassMethod__p1__T__T2($as_T(value$5));
          if ((x1$2 === null)) {
            throw new $c_s_MatchError().init___O(x1$2)
          };
          var className$3 = $as_T(x1$2.$$und1__O());
          var methodName$3 = $as_T(x1$2.$$und2__O());
          var value$6 = mtch2[2];
          if ((value$6 === (void 0))) {
            throw new $c_ju_NoSuchElementException().init___T("undefined.get")
          };
          var fileName$1 = $as_T(value$6);
          var value$7 = mtch2[3];
          if ((value$7 === (void 0))) {
            throw new $c_ju_NoSuchElementException().init___T("undefined.get")
          };
          var x$2 = $as_T(value$7);
          var this$52 = new $c_sci_StringOps().init___T(x$2);
          var this$54 = $m_jl_Integer$();
          var $$this$2 = this$52.repr$1;
          var lineNumber$1 = this$54.parseInt__T__I__I($$this$2, 10);
          var jsx$2 = trace.push({
            "declaringClass": className$3,
            "methodName": methodName$3,
            "fileName": fileName$1,
            "lineNumber": lineNumber$1,
            "columnNumber": (void 0)
          });
          $uI(jsx$2)
        } else {
          $uI(trace.push({
            "declaringClass": "<jscode>",
            "methodName": line,
            "fileName": null,
            "lineNumber": (-1),
            "columnNumber": (void 0)
          }))
        }
      }
    };
    i = ((1 + i) | 0)
  };
  var value$8 = $env.sourceMapper;
  var mappedTrace = ((value$8 === (void 0)) ? trace : value$8(trace));
  var result = $newArrayObject($d_jl_StackTraceElement.getArrayOf(), [$uI(mappedTrace.length)]);
  i = 0;
  while ((i < $uI(mappedTrace.length))) {
    var jsSte = mappedTrace[i];
    var ste = new $c_jl_StackTraceElement().init___T__T__T__I($as_T(jsSte.declaringClass), $as_T(jsSte.methodName), $as_T(jsSte.fileName), $uI(jsSte.lineNumber));
    var value$9 = jsSte.columnNumber;
    if ((value$9 !== (void 0))) {
      var columnNumber = $uI(value$9);
      ste.setColumnNumber(columnNumber)
    };
    result.set(i, ste);
    i = ((1 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.extractOpera11__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var lineRE = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^.*line (\\d+), column (\\d+)(?: in (.+))? in (\\S+):$");
  var x = $as_T(e.stacktrace);
  var lines = x.split("\n");
  var result = [];
  var i = 0;
  var len = $uI(lines.length);
  while ((i < len)) {
    var mtch = lineRE.exec($as_T(lines[i]));
    if ((mtch !== null)) {
      var value = mtch[4];
      if ((value === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var jsx$1 = $as_T(value);
      var value$1 = mtch[1];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var value$2 = mtch[2];
      if ((value$2 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var location = ((((jsx$1 + ":") + value$1) + ":") + value$2);
      var value$3 = mtch[2];
      var fnName0 = $as_T(((value$3 === (void 0)) ? "global code" : value$3));
      var x$1 = $as_T(fnName0.replace($m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("<anonymous function: (\\S+)>"), "$1"));
      var jsx$2 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("<anonymous function>"), "{anonymous}");
      var fnName = $as_T(jsx$2);
      $uI(result.push(((fnName + "@") + location)))
    };
    i = ((2 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.extractSafari__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = $as_T(e.stack);
  var jsx$3 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("\\[native code\\]\\n", "m"), "");
  var x$1 = $as_T(jsx$3);
  var jsx$2 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^(?=\\w+Error\\:).*$\\n", "m"), "");
  var x$2 = $as_T(jsx$2);
  var jsx$1 = x$2.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^@", "gm"), "{anonymous}()@");
  var x$3 = $as_T(jsx$1);
  return x$3.split("\n")
});
$c_sjsr_StackTrace$.prototype.loop$1__p1__I__T__T = (function(i, encoded$1) {
  _loop: while (true) {
    if ((i < $uI(this.compressedPrefixes__p1__sjs_js_Array().length))) {
      var prefix = $as_T(this.compressedPrefixes__p1__sjs_js_Array()[i]);
      if ((($uI(encoded$1.length) >= 0) && ($as_T(encoded$1.substring(0, $uI(prefix.length))) === prefix))) {
        var dict = this.decompressedPrefixes__p1__sjs_js_Dictionary();
        if ((!$uZ($m_sjs_js_WrappedDictionary$Cache$().safeHasOwnProperty$1.call(dict, prefix)))) {
          throw new $c_ju_NoSuchElementException().init___T(("key not found: " + prefix))
        };
        var jsx$1 = $as_T(dict[prefix]);
        var beginIndex = $uI(prefix.length);
        return (("" + jsx$1) + $as_T(encoded$1.substring(beginIndex)))
      } else {
        i = ((1 + i) | 0);
        continue _loop
      }
    } else {
      return ((($uI(encoded$1.length) >= 0) && ($as_T(encoded$1.substring(0, $uI("L".length))) === "L")) ? $as_T(encoded$1.substring(1)) : encoded$1)
    }
  }
});
$c_sjsr_StackTrace$.prototype.liftedTree1$1__p1__Z = (function() {
  try {
    $g.Packages.org.mozilla.javascript.JavaScriptException;
    return true
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      if ($is_sjs_js_JavaScriptException(e$2)) {
        return false
      } else {
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
      }
    } else {
      throw e
    }
  }
});
$c_sjsr_StackTrace$.prototype.decompressedPrefixes__p1__sjs_js_Dictionary = (function() {
  return (((((4 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.decompressedPrefixes$lzycompute__p1__sjs_js_Dictionary() : this.decompressedPrefixes$1)
});
$c_sjsr_StackTrace$.prototype.extractRhino__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var value = e.stack;
  var x = $as_T(((value === (void 0)) ? "" : value));
  var jsx$3 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^\\s+at\\s+", "gm"), "");
  var x$1 = $as_T(jsx$3);
  var jsx$2 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^(.+?)(?: \\((.+)\\))?$", "gm"), "$2@$1");
  var x$2 = $as_T(jsx$2);
  var jsx$1 = x$2.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("\\r\\n?", "gm"), "\n");
  var x$3 = $as_T(jsx$1);
  return x$3.split("\n")
});
$c_sjsr_StackTrace$.prototype.extractOther__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  return []
});
$c_sjsr_StackTrace$.prototype.extractIE__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = $as_T(e.stack);
  var jsx$3 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^\\s*at\\s+(.*)$", "gm"), "$1");
  var x$1 = $as_T(jsx$3);
  var jsx$2 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^Anonymous function\\s+", "gm"), "{anonymous}() ");
  var x$2 = $as_T(jsx$2);
  var jsx$1 = x$2.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^([^\\(]+|\\{anonymous\\}\\(\\))\\s+\\((.+)\\)$", "gm"), "$1@$2");
  var x$3 = $as_T(jsx$1);
  var qual$1 = x$3.split("\n");
  return qual$1.slice(1)
});
$c_sjsr_StackTrace$.prototype.decodeMethodName__p1__T__T = (function(encodedName) {
  if ((($uI(encodedName.length) >= 0) && ($as_T(encodedName.substring(0, $uI("init___".length))) === "init___"))) {
    return "<init>"
  } else {
    var methodNameLen = $uI(encodedName.indexOf("__"));
    return ((methodNameLen < 0) ? encodedName : $as_T(encodedName.substring(0, methodNameLen)))
  }
});
var $d_sjsr_StackTrace$ = new $TypeData().initClass({
  sjsr_StackTrace$: 0
}, false, "scala.scalajs.runtime.StackTrace$", {
  sjsr_StackTrace$: 1,
  O: 1
});
$c_sjsr_StackTrace$.prototype.$classData = $d_sjsr_StackTrace$;
var $n_sjsr_StackTrace$ = (void 0);
function $m_sjsr_StackTrace$() {
  if ((!$n_sjsr_StackTrace$)) {
    $n_sjsr_StackTrace$ = new $c_sjsr_StackTrace$().init___()
  };
  return $n_sjsr_StackTrace$
}
/** @constructor */
function $c_sjsr_StackTrace$StringRE$() {
  $c_O.call(this)
}
$c_sjsr_StackTrace$StringRE$.prototype = new $h_O();
$c_sjsr_StackTrace$StringRE$.prototype.constructor = $c_sjsr_StackTrace$StringRE$;
/** @constructor */
function $h_sjsr_StackTrace$StringRE$() {
  /*<skip>*/
}
$h_sjsr_StackTrace$StringRE$.prototype = $c_sjsr_StackTrace$StringRE$.prototype;
$c_sjsr_StackTrace$StringRE$.prototype.init___ = (function() {
  return this
});
$c_sjsr_StackTrace$StringRE$.prototype.re$extension1__T__T__sjs_js_RegExp = (function($$this, mods) {
  return new $g.RegExp($$this, mods)
});
$c_sjsr_StackTrace$StringRE$.prototype.re$extension0__T__sjs_js_RegExp = (function($$this) {
  return new $g.RegExp($$this)
});
var $d_sjsr_StackTrace$StringRE$ = new $TypeData().initClass({
  sjsr_StackTrace$StringRE$: 0
}, false, "scala.scalajs.runtime.StackTrace$StringRE$", {
  sjsr_StackTrace$StringRE$: 1,
  O: 1
});
$c_sjsr_StackTrace$StringRE$.prototype.$classData = $d_sjsr_StackTrace$StringRE$;
var $n_sjsr_StackTrace$StringRE$ = (void 0);
function $m_sjsr_StackTrace$StringRE$() {
  if ((!$n_sjsr_StackTrace$StringRE$)) {
    $n_sjsr_StackTrace$StringRE$ = new $c_sjsr_StackTrace$StringRE$().init___()
  };
  return $n_sjsr_StackTrace$StringRE$
}
/** @constructor */
function $c_sjsr_package$() {
  $c_O.call(this)
}
$c_sjsr_package$.prototype = new $h_O();
$c_sjsr_package$.prototype.constructor = $c_sjsr_package$;
/** @constructor */
function $h_sjsr_package$() {
  /*<skip>*/
}
$h_sjsr_package$.prototype = $c_sjsr_package$.prototype;
$c_sjsr_package$.prototype.init___ = (function() {
  return this
});
$c_sjsr_package$.prototype.unwrapJavaScriptException__jl_Throwable__O = (function(th) {
  if ($is_sjs_js_JavaScriptException(th)) {
    var x2 = $as_sjs_js_JavaScriptException(th);
    var e = x2.exception$4;
    return e
  } else {
    return th
  }
});
$c_sjsr_package$.prototype.wrapJavaScriptException__O__jl_Throwable = (function(e) {
  if ($is_jl_Throwable(e)) {
    var x2 = $as_jl_Throwable(e);
    return x2
  } else {
    return new $c_sjs_js_JavaScriptException().init___O(e)
  }
});
var $d_sjsr_package$ = new $TypeData().initClass({
  sjsr_package$: 0
}, false, "scala.scalajs.runtime.package$", {
  sjsr_package$: 1,
  O: 1
});
$c_sjsr_package$.prototype.$classData = $d_sjsr_package$;
var $n_sjsr_package$ = (void 0);
function $m_sjsr_package$() {
  if ((!$n_sjsr_package$)) {
    $n_sjsr_package$ = new $c_sjsr_package$().init___()
  };
  return $n_sjsr_package$
}
/** @constructor */
function $c_sr_BoxesRunTime$() {
  $c_O.call(this)
}
$c_sr_BoxesRunTime$.prototype = new $h_O();
$c_sr_BoxesRunTime$.prototype.constructor = $c_sr_BoxesRunTime$;
/** @constructor */
function $h_sr_BoxesRunTime$() {
  /*<skip>*/
}
$h_sr_BoxesRunTime$.prototype = $c_sr_BoxesRunTime$.prototype;
$c_sr_BoxesRunTime$.prototype.init___ = (function() {
  return this
});
$c_sr_BoxesRunTime$.prototype.equalsCharObject__jl_Character__O__Z = (function(xc, y) {
  if ($is_jl_Character(y)) {
    var x2 = $as_jl_Character(y);
    return (xc.value$1 === x2.value$1)
  } else if ($is_jl_Number(y)) {
    var x3 = $as_jl_Number(y);
    if (((typeof x3) === "number")) {
      var x2$1 = $uD(x3);
      return (x2$1 === xc.value$1)
    } else if ($is_sjsr_RuntimeLong(x3)) {
      var t = $uJ(x3);
      var lo = t.lo$2;
      var hi = t.hi$2;
      var value = xc.value$1;
      var hi$1 = (value >> 31);
      return ((lo === value) && (hi === hi$1))
    } else {
      return ((x3 === null) ? (xc === null) : $objectEquals(x3, xc))
    }
  } else {
    return ((xc === null) && (y === null))
  }
});
$c_sr_BoxesRunTime$.prototype.equalsNumObject__jl_Number__O__Z = (function(xn, y) {
  if ($is_jl_Number(y)) {
    var x2 = $as_jl_Number(y);
    return this.equalsNumNum__jl_Number__jl_Number__Z(xn, x2)
  } else if ($is_jl_Character(y)) {
    var x3 = $as_jl_Character(y);
    if (((typeof xn) === "number")) {
      var x2$1 = $uD(xn);
      return (x2$1 === x3.value$1)
    } else if ($is_sjsr_RuntimeLong(xn)) {
      var t = $uJ(xn);
      var lo = t.lo$2;
      var hi = t.hi$2;
      var value = x3.value$1;
      var hi$1 = (value >> 31);
      return ((lo === value) && (hi === hi$1))
    } else {
      return ((xn === null) ? (x3 === null) : $objectEquals(xn, x3))
    }
  } else {
    return ((xn === null) ? (y === null) : $objectEquals(xn, y))
  }
});
$c_sr_BoxesRunTime$.prototype.equals__O__O__Z = (function(x, y) {
  if ((x === y)) {
    return true
  } else if ($is_jl_Number(x)) {
    var x2 = $as_jl_Number(x);
    return this.equalsNumObject__jl_Number__O__Z(x2, y)
  } else if ($is_jl_Character(x)) {
    var x3 = $as_jl_Character(x);
    return this.equalsCharObject__jl_Character__O__Z(x3, y)
  } else {
    return ((x === null) ? (y === null) : $objectEquals(x, y))
  }
});
$c_sr_BoxesRunTime$.prototype.equalsNumNum__jl_Number__jl_Number__Z = (function(xn, yn) {
  if (((typeof xn) === "number")) {
    var x2 = $uD(xn);
    if (((typeof yn) === "number")) {
      var x2$2 = $uD(yn);
      return (x2 === x2$2)
    } else if ($is_sjsr_RuntimeLong(yn)) {
      var t = $uJ(yn);
      var lo = t.lo$2;
      var hi = t.hi$2;
      return (x2 === $m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo, hi))
    } else if ($is_s_math_ScalaNumber(yn)) {
      var x4 = $as_s_math_ScalaNumber(yn);
      return x4.equals__O__Z(x2)
    } else {
      return false
    }
  } else if ($i