(function(){
'use strict';
/* Scala.js runtime support
 * Copyright 2013 LAMP/EPFL
 * Author: Sébastien Doeraene
 */

/* ---------------------------------- *
 * The top-level Scala.js environment *
 * ---------------------------------- */





// Get the environment info
var $env = (typeof __ScalaJSEnv === "object" && __ScalaJSEnv) ? __ScalaJSEnv : {};

// Global scope
var $g =
  (typeof $env["global"] === "object" && $env["global"])
    ? $env["global"]
    : ((typeof global === "object" && global && global["Object"] === Object) ? global : this);
$env["global"] = $g;

// Where to send exports



var $e =
  (typeof $env["exportsNamespace"] === "object" && $env["exportsNamespace"])
    ? $env["exportsNamespace"] : $g;

$env["exportsNamespace"] = $e;

// Freeze the environment info
$g["Object"]["freeze"]($env);

// Linking info - must be in sync with scala.scalajs.runtime.LinkingInfo
var $linkingInfo = {
  "envInfo": $env,
  "semantics": {




    "asInstanceOfs": 1,








    "arrayIndexOutOfBounds": 1,










    "moduleInit": 2,





    "strictFloats": false,




    "productionMode": false

  },



  "assumingES6": false,

  "linkerVersion": "0.6.25",
  "globalThis": this
};
$g["Object"]["freeze"]($linkingInfo);
$g["Object"]["freeze"]($linkingInfo["semantics"]);

// Snapshots of builtins and polyfills






var $imul = $g["Math"]["imul"] || (function(a, b) {
  // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/imul
  var ah = (a >>> 16) & 0xffff;
  var al = a & 0xffff;
  var bh = (b >>> 16) & 0xffff;
  var bl = b & 0xffff;
  // the shift by 0 fixes the sign on the high part
  // the final |0 converts the unsigned value into a signed value
  return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0) | 0);
});

var $fround = $g["Math"]["fround"] ||









  (function(v) {
    return +v;
  });


var $clz32 = $g["Math"]["clz32"] || (function(i) {
  // See Hacker's Delight, Section 5-3
  if (i === 0) return 32;
  var r = 1;
  if ((i & 0xffff0000) === 0) { i <<= 16; r += 16; };
  if ((i & 0xff000000) === 0) { i <<= 8; r += 8; };
  if ((i & 0xf0000000) === 0) { i <<= 4; r += 4; };
  if ((i & 0xc0000000) === 0) { i <<= 2; r += 2; };
  return r + (i >> 31);
});


// Other fields




















var $lastIDHash = 0; // last value attributed to an id hash code



var $idHashCodeMap = $g["WeakMap"] ? new $g["WeakMap"]() : null;



// Core mechanism

var $makeIsArrayOfPrimitive = function(primitiveData) {
  return function(obj, depth) {
    return !!(obj && obj.$classData &&
      (obj.$classData.arrayDepth === depth) &&
      (obj.$classData.arrayBase === primitiveData));
  }
};


var $makeAsArrayOfPrimitive = function(isInstanceOfFunction, arrayEncodedName) {
  return function(obj, depth) {
    if (isInstanceOfFunction(obj, depth) || (obj === null))
      return obj;
    else
      $throwArrayCastException(obj, arrayEncodedName, depth);
  }
};


/** Encode a property name for runtime manipulation
  *  Usage:
  *    env.propertyName({someProp:0})
  *  Returns:
  *    "someProp"
  *  Useful when the property is renamed by a global optimizer (like Closure)
  *  but we must still get hold of a string of that name for runtime
  * reflection.
  */
var $propertyName = function(obj) {
  for (var prop in obj)
    return prop;
};

// Runtime functions

var $isScalaJSObject = function(obj) {
  return !!(obj && obj.$classData);
};


var $throwClassCastException = function(instance, classFullName) {




  throw new $c_sjsr_UndefinedBehaviorError().init___jl_Throwable(
    new $c_jl_ClassCastException().init___T(
      instance + " is not an instance of " + classFullName));

};

var $throwArrayCastException = function(instance, classArrayEncodedName, depth) {
  for (; depth; --depth)
    classArrayEncodedName = "[" + classArrayEncodedName;
  $throwClassCastException(instance, classArrayEncodedName);
};



var $throwArrayIndexOutOfBoundsException = function(i) {
  var msg = (i === null) ? null : ("" + i);



  throw new $c_sjsr_UndefinedBehaviorError().init___jl_Throwable(
    new $c_jl_ArrayIndexOutOfBoundsException().init___T(msg));

};


var $noIsInstance = function(instance) {
  throw new $g["TypeError"](
    "Cannot call isInstance() on a Class representing a raw JS trait/object");
};

var $makeNativeArrayWrapper = function(arrayClassData, nativeArray) {
  return new arrayClassData.constr(nativeArray);
};

var $newArrayObject = function(arrayClassData, lengths) {
  return $newArrayObjectInternal(arrayClassData, lengths, 0);
};

var $newArrayObjectInternal = function(arrayClassData, lengths, lengthIndex) {
  var result = new arrayClassData.constr(lengths[lengthIndex]);

  if (lengthIndex < lengths.length-1) {
    var subArrayClassData = arrayClassData.componentData;
    var subLengthIndex = lengthIndex+1;
    var underlying = result.u;
    for (var i = 0; i < underlying.length; i++) {
      underlying[i] = $newArrayObjectInternal(
        subArrayClassData, lengths, subLengthIndex);
    }
  }

  return result;
};

var $objectToString = function(instance) {
  if (instance === void 0)
    return "undefined";
  else
    return instance.toString();
};

var $objectGetClass = function(instance) {
  switch (typeof instance) {
    case "string":
      return $d_T.getClassOf();
    case "number": {
      var v = instance | 0;
      if (v === instance) { // is the value integral?
        if ($isByte(v))
          return $d_jl_Byte.getClassOf();
        else if ($isShort(v))
          return $d_jl_Short.getClassOf();
        else
          return $d_jl_Integer.getClassOf();
      } else {
        if ($isFloat(instance))
          return $d_jl_Float.getClassOf();
        else
          return $d_jl_Double.getClassOf();
      }
    }
    case "boolean":
      return $d_jl_Boolean.getClassOf();
    case "undefined":
      return $d_sr_BoxedUnit.getClassOf();
    default:
      if (instance === null)
        return instance.getClass__jl_Class();
      else if ($is_sjsr_RuntimeLong(instance))
        return $d_jl_Long.getClassOf();
      else if ($isScalaJSObject(instance))
        return instance.$classData.getClassOf();
      else
        return null; // Exception?
  }
};

var $objectClone = function(instance) {
  if ($isScalaJSObject(instance) || (instance === null))
    return instance.clone__O();
  else
    throw new $c_jl_CloneNotSupportedException().init___();
};

var $objectNotify = function(instance) {
  // final and no-op in java.lang.Object
  if (instance === null)
    instance.notify__V();
};

var $objectNotifyAll = function(instance) {
  // final and no-op in java.lang.Object
  if (instance === null)
    instance.notifyAll__V();
};

var $objectFinalize = function(instance) {
  if ($isScalaJSObject(instance) || (instance === null))
    instance.finalize__V();
  // else no-op
};

var $objectEquals = function(instance, rhs) {
  if ($isScalaJSObject(instance) || (instance === null))
    return instance.equals__O__Z(rhs);
  else if (typeof instance === "number")
    return typeof rhs === "number" && $numberEquals(instance, rhs);
  else
    return instance === rhs;
};

var $numberEquals = function(lhs, rhs) {
  return (lhs === rhs) ? (
    // 0.0.equals(-0.0) must be false
    lhs !== 0 || 1/lhs === 1/rhs
  ) : (
    // are they both NaN?
    (lhs !== lhs) && (rhs !== rhs)
  );
};

var $objectHashCode = function(instance) {
  switch (typeof instance) {
    case "string":
      return $m_sjsr_RuntimeString$().hashCode__T__I(instance);
    case "number":
      return $m_sjsr_Bits$().numberHashCode__D__I(instance);
    case "boolean":
      return instance ? 1231 : 1237;
    case "undefined":
      return 0;
    default:
      if ($isScalaJSObject(instance) || instance === null)
        return instance.hashCode__I();

      else if ($idHashCodeMap === null)
        return 42;

      else
        return $systemIdentityHashCode(instance);
  }
};

var $comparableCompareTo = function(instance, rhs) {
  switch (typeof instance) {
    case "string":

      $as_T(rhs);

      return instance === rhs ? 0 : (instance < rhs ? -1 : 1);
    case "number":

      $as_jl_Number(rhs);

      return $m_jl_Double$().compare__D__D__I(instance, rhs);
    case "boolean":

      $asBoolean(rhs);

      return instance - rhs; // yes, this gives the right result
    default:
      return instance.compareTo__O__I(rhs);
  }
};

var $charSequenceLength = function(instance) {
  if (typeof(instance) === "string")

    return $uI(instance["length"]);



  else
    return instance.length__I();
};

var $charSequenceCharAt = function(instance, index) {
  if (typeof(instance) === "string")

    return $uI(instance["charCodeAt"](index)) & 0xffff;



  else
    return instance.charAt__I__C(index);
};

var $charSequenceSubSequence = function(instance, start, end) {
  if (typeof(instance) === "string")

    return $as_T(instance["substring"](start, end));



  else
    return instance.subSequence__I__I__jl_CharSequence(start, end);
};

var $booleanBooleanValue = function(instance) {
  if (typeof instance === "boolean") return instance;
  else                               return instance.booleanValue__Z();
};

var $numberByteValue = function(instance) {
  if (typeof instance === "number") return (instance << 24) >> 24;
  else                              return instance.byteValue__B();
};
var $numberShortValue = function(instance) {
  if (typeof instance === "number") return (instance << 16) >> 16;
  else                              return instance.shortValue__S();
};
var $numberIntValue = function(instance) {
  if (typeof instance === "number") return instance | 0;
  else                              return instance.intValue__I();
};
var $numberLongValue = function(instance) {
  if (typeof instance === "number")
    return $m_sjsr_RuntimeLong$().fromDouble__D__sjsr_RuntimeLong(instance);
  else
    return instance.longValue__J();
};
var $numberFloatValue = function(instance) {
  if (typeof instance === "number") return $fround(instance);
  else                              return instance.floatValue__F();
};
var $numberDoubleValue = function(instance) {
  if (typeof instance === "number") return instance;
  else                              return instance.doubleValue__D();
};

var $isNaN = function(instance) {
  return instance !== instance;
};

var $isInfinite = function(instance) {
  return !$g["isFinite"](instance) && !$isNaN(instance);
};

var $doubleToInt = function(x) {
  return (x > 2147483647) ? (2147483647) : ((x < -2147483648) ? -2147483648 : (x | 0));
};

/** Instantiates a JS object with variadic arguments to the constructor. */
var $newJSObjectWithVarargs = function(ctor, args) {
  // This basically emulates the ECMAScript specification for 'new'.
  var instance = $g["Object"]["create"](ctor.prototype);
  var result = ctor["apply"](instance, args);
  switch (typeof result) {
    case "string": case "number": case "boolean": case "undefined": case "symbol":
      return instance;
    default:
      return result === null ? instance : result;
  }
};

var $resolveSuperRef = function(initialProto, propName) {
  var getPrototypeOf = $g["Object"]["getPrototypeOf"];
  var getOwnPropertyDescriptor = $g["Object"]["getOwnPropertyDescriptor"];

  var superProto = getPrototypeOf(initialProto);
  while (superProto !== null) {
    var desc = getOwnPropertyDescriptor(superProto, propName);
    if (desc !== void 0)
      return desc;
    superProto = getPrototypeOf(superProto);
  }

  return void 0;
};

var $superGet = function(initialProto, self, propName) {
  var desc = $resolveSuperRef(initialProto, propName);
  if (desc !== void 0) {
    var getter = desc["get"];
    if (getter !== void 0)
      return getter["call"](self);
    else
      return desc["value"];
  }
  return void 0;
};

var $superSet = function(initialProto, self, propName, value) {
  var desc = $resolveSuperRef(initialProto, propName);
  if (desc !== void 0) {
    var setter = desc["set"];
    if (setter !== void 0) {
      setter["call"](self, value);
      return void 0;
    }
  }
  throw new $g["TypeError"]("super has no setter '" + propName + "'.");
};







var $propertiesOf = function(obj) {
  var result = [];
  for (var prop in obj)
    result["push"](prop);
  return result;
};

var $systemArraycopy = function(src, srcPos, dest, destPos, length) {
  var srcu = src.u;
  var destu = dest.u;


  if (srcPos < 0 || destPos < 0 || length < 0 ||
      (srcPos > ((srcu.length - length) | 0)) ||
      (destPos > ((destu.length - length) | 0))) {
    $throwArrayIndexOutOfBoundsException(null);
  }


  if (srcu !== destu || destPos < srcPos || (((srcPos + length) | 0) < destPos)) {
    for (var i = 0; i < length; i = (i + 1) | 0)
      destu[(destPos + i) | 0] = srcu[(srcPos + i) | 0];
  } else {
    for (var i = (length - 1) | 0; i >= 0; i = (i - 1) | 0)
      destu[(destPos + i) | 0] = srcu[(srcPos + i) | 0];
  }
};

var $systemIdentityHashCode =

  ($idHashCodeMap !== null) ?

  (function(obj) {
    switch (typeof obj) {
      case "string": case "number": case "boolean": case "undefined":
        return $objectHashCode(obj);
      default:
        if (obj === null) {
          return 0;
        } else {
          var hash = $idHashCodeMap["get"](obj);
          if (hash === void 0) {
            hash = ($lastIDHash + 1) | 0;
            $lastIDHash = hash;
            $idHashCodeMap["set"](obj, hash);
          }
          return hash;
        }
    }

  }) :
  (function(obj) {
    if ($isScalaJSObject(obj)) {
      var hash = obj["$idHashCode$0"];
      if (hash !== void 0) {
        return hash;
      } else if (!$g["Object"]["isSealed"](obj)) {
        hash = ($lastIDHash + 1) | 0;
        $lastIDHash = hash;
        obj["$idHashCode$0"] = hash;
        return hash;
      } else {
        return 42;
      }
    } else if (obj === null) {
      return 0;
    } else {
      return $objectHashCode(obj);
    }

  });

// is/as for hijacked boxed classes (the non-trivial ones)

var $isByte = function(v) {
  return typeof v === "number" && (v << 24 >> 24) === v && 1/v !== 1/-0;
};

var $isShort = function(v) {
  return typeof v === "number" && (v << 16 >> 16) === v && 1/v !== 1/-0;
};

var $isInt = function(v) {
  return typeof v === "number" && (v | 0) === v && 1/v !== 1/-0;
};

var $isFloat = function(v) {



  return typeof v === "number";

};


var $asUnit = function(v) {
  if (v === void 0 || v === null)
    return v;
  else
    $throwClassCastException(v, "scala.runtime.BoxedUnit");
};

var $asBoolean = function(v) {
  if (typeof v === "boolean" || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Boolean");
};

var $asByte = function(v) {
  if ($isByte(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Byte");
};

var $asShort = function(v) {
  if ($isShort(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Short");
};

var $asInt = function(v) {
  if ($isInt(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Integer");
};

var $asFloat = function(v) {
  if ($isFloat(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Float");
};

var $asDouble = function(v) {
  if (typeof v === "number" || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Double");
};


// Unboxes


var $uZ = function(value) {
  return !!$asBoolean(value);
};
var $uB = function(value) {
  return $asByte(value) | 0;
};
var $uS = function(value) {
  return $asShort(value) | 0;
};
var $uI = function(value) {
  return $asInt(value) | 0;
};
var $uJ = function(value) {
  return null === value ? $m_sjsr_RuntimeLong$().Zero$1
                        : $as_sjsr_RuntimeLong(value);
};
var $uF = function(value) {
  /* Here, it is fine to use + instead of fround, because asFloat already
   * ensures that the result is either null or a float.
   */
  return +$asFloat(value);
};
var $uD = function(value) {
  return +$asDouble(value);
};






// TypeArray conversions

var $byteArray2TypedArray = function(value) { return new $g["Int8Array"](value.u); };
var $shortArray2TypedArray = function(value) { return new $g["Int16Array"](value.u); };
var $charArray2TypedArray = function(value) { return new $g["Uint16Array"](value.u); };
var $intArray2TypedArray = function(value) { return new $g["Int32Array"](value.u); };
var $floatArray2TypedArray = function(value) { return new $g["Float32Array"](value.u); };
var $doubleArray2TypedArray = function(value) { return new $g["Float64Array"](value.u); };

var $typedArray2ByteArray = function(value) {
  var arrayClassData = $d_B.getArrayOf();
  return new arrayClassData.constr(new $g["Int8Array"](value));
};
var $typedArray2ShortArray = function(value) {
  var arrayClassData = $d_S.getArrayOf();
  return new arrayClassData.constr(new $g["Int16Array"](value));
};
var $typedArray2CharArray = function(value) {
  var arrayClassData = $d_C.getArrayOf();
  return new arrayClassData.constr(new $g["Uint16Array"](value));
};
var $typedArray2IntArray = function(value) {
  var arrayClassData = $d_I.getArrayOf();
  return new arrayClassData.constr(new $g["Int32Array"](value));
};
var $typedArray2FloatArray = function(value) {
  var arrayClassData = $d_F.getArrayOf();
  return new arrayClassData.constr(new $g["Float32Array"](value));
};
var $typedArray2DoubleArray = function(value) {
  var arrayClassData = $d_D.getArrayOf();
  return new arrayClassData.constr(new $g["Float64Array"](value));
};

// TypeData class


/** @constructor */
var $TypeData = function() {




  // Runtime support
  this.constr = void 0;
  this.parentData = void 0;
  this.ancestors = null;
  this.componentData = null;
  this.arrayBase = null;
  this.arrayDepth = 0;
  this.zero = null;
  this.arrayEncodedName = "";
  this._classOf = void 0;
  this._arrayOf = void 0;
  this.isArrayOf = void 0;

  // java.lang.Class support
  this["name"] = "";
  this["isPrimitive"] = false;
  this["isInterface"] = false;
  this["isArrayClass"] = false;
  this["isRawJSType"] = false;
  this["isInstance"] = void 0;
};


$TypeData.prototype.initPrim = function(



    zero, arrayEncodedName, displayName) {
  // Runtime support
  this.ancestors = {};
  this.componentData = null;
  this.zero = zero;
  this.arrayEncodedName = arrayEncodedName;
  this.isArrayOf = function(obj, depth) { return false; };

  // java.lang.Class support
  this["name"] = displayName;
  this["isPrimitive"] = true;
  this["isInstance"] = function(obj) { return false; };

  return this;
};


$TypeData.prototype.initClass = function(



    internalNameObj, isInterface, fullName,
    ancestors, isRawJSType, parentData, isInstance, isArrayOf) {
  var internalName = $propertyName(internalNameObj);

  isInstance = isInstance || function(obj) {
    return !!(obj && obj.$classData && obj.$classData.ancestors[internalName]);
  };

  isArrayOf = isArrayOf || function(obj, depth) {
    return !!(obj && obj.$classData && (obj.$classData.arrayDepth === depth)
      && obj.$classData.arrayBase.ancestors[internalName])
  };

  // Runtime support
  this.parentData = parentData;
  this.ancestors = ancestors;
  this.arrayEncodedName = "L"+fullName+";";
  this.isArrayOf = isArrayOf;

  // java.lang.Class support
  this["name"] = fullName;
  this["isInterface"] = isInterface;
  this["isRawJSType"] = !!isRawJSType;
  this["isInstance"] = isInstance;

  return this;
};


$TypeData.prototype.initArray = function(



    componentData) {
  // The constructor

  var componentZero0 = componentData.zero;

  // The zero for the Long runtime representation
  // is a special case here, since the class has not
  // been defined yet, when this file is read
  var componentZero = (componentZero0 == "longZero")
    ? $m_sjsr_RuntimeLong$().Zero$1
    : componentZero0;


  /** @constructor */
  var ArrayClass = function(arg) {
    if (typeof(arg) === "number") {
      // arg is the length of the array
      this.u = new Array(arg);
      for (var i = 0; i < arg; i++)
        this.u[i] = componentZero;
    } else {
      // arg is a native array that we wrap
      this.u = arg;
    }
  }
  ArrayClass.prototype = new $h_O;
  ArrayClass.prototype.constructor = ArrayClass;


  ArrayClass.prototype.get = function(i) {
    if (i < 0 || i >= this.u.length)
      $throwArrayIndexOutOfBoundsException(i);
    return this.u[i];
  };
  ArrayClass.prototype.set = function(i, v) {
    if (i < 0 || i >= this.u.length)
      $throwArrayIndexOutOfBoundsException(i);
    this.u[i] = v;
  };


  ArrayClass.prototype.clone__O = function() {
    if (this.u instanceof Array)
      return new ArrayClass(this.u["slice"](0));
    else
      // The underlying Array is a TypedArray
      return new ArrayClass(new this.u.constructor(this.u));
  };






































  ArrayClass.prototype.$classData = this;

  // Don't generate reflective call proxies. The compiler special cases
  // reflective calls to methods on scala.Array

  // The data

  var encodedName = "[" + componentData.arrayEncodedName;
  var componentBase = componentData.arrayBase || componentData;
  var arrayDepth = componentData.arrayDepth + 1;

  var isInstance = function(obj) {
    return componentBase.isArrayOf(obj, arrayDepth);
  }

  // Runtime support
  this.constr = ArrayClass;
  this.parentData = $d_O;
  this.ancestors = {O: 1, jl_Cloneable: 1, Ljava_io_Serializable: 1};
  this.componentData = componentData;
  this.arrayBase = componentBase;
  this.arrayDepth = arrayDepth;
  this.zero = null;
  this.arrayEncodedName = encodedName;
  this._classOf = undefined;
  this._arrayOf = undefined;
  this.isArrayOf = undefined;

  // java.lang.Class support
  this["name"] = encodedName;
  this["isPrimitive"] = false;
  this["isInterface"] = false;
  this["isArrayClass"] = true;
  this["isInstance"] = isInstance;

  return this;
};


$TypeData.prototype.getClassOf = function() {



  if (!this._classOf)
    this._classOf = new $c_jl_Class().init___jl_ScalaJSClassData(this);
  return this._classOf;
};


$TypeData.prototype.getArrayOf = function() {



  if (!this._arrayOf)
    this._arrayOf = new $TypeData().initArray(this);
  return this._arrayOf;
};

// java.lang.Class support


$TypeData.prototype["getFakeInstance"] = function() {



  if (this === $d_T)
    return "some string";
  else if (this === $d_jl_Boolean)
    return false;
  else if (this === $d_jl_Byte ||
           this === $d_jl_Short ||
           this === $d_jl_Integer ||
           this === $d_jl_Float ||
           this === $d_jl_Double)
    return 0;
  else if (this === $d_jl_Long)
    return $m_sjsr_RuntimeLong$().Zero$1;
  else if (this === $d_sr_BoxedUnit)
    return void 0;
  else
    return {$classData: this};
};


$TypeData.prototype["getSuperclass"] = function() {



  return this.parentData ? this.parentData.getClassOf() : null;
};


$TypeData.prototype["getComponentType"] = function() {



  return this.componentData ? this.componentData.getClassOf() : null;
};


$TypeData.prototype["newArrayOfThisClass"] = function(lengths) {



  var arrayClassData = this;
  for (var i = 0; i < lengths.length; i++)
    arrayClassData = arrayClassData.getArrayOf();
  return $newArrayObject(arrayClassData, lengths);
};




// Create primitive types

var $d_V = new $TypeData().initPrim(undefined, "V", "void");
var $d_Z = new $TypeData().initPrim(false, "Z", "boolean");
var $d_C = new $TypeData().initPrim(0, "C", "char");
var $d_B = new $TypeData().initPrim(0, "B", "byte");
var $d_S = new $TypeData().initPrim(0, "S", "short");
var $d_I = new $TypeData().initPrim(0, "I", "int");
var $d_J = new $TypeData().initPrim("longZero", "J", "long");
var $d_F = new $TypeData().initPrim(0.0, "F", "float");
var $d_D = new $TypeData().initPrim(0.0, "D", "double");

// Instance tests for array of primitives

var $isArrayOf_Z = $makeIsArrayOfPrimitive($d_Z);
$d_Z.isArrayOf = $isArrayOf_Z;

var $isArrayOf_C = $makeIsArrayOfPrimitive($d_C);
$d_C.isArrayOf = $isArrayOf_C;

var $isArrayOf_B = $makeIsArrayOfPrimitive($d_B);
$d_B.isArrayOf = $isArrayOf_B;

var $isArrayOf_S = $makeIsArrayOfPrimitive($d_S);
$d_S.isArrayOf = $isArrayOf_S;

var $isArrayOf_I = $makeIsArrayOfPrimitive($d_I);
$d_I.isArrayOf = $isArrayOf_I;

var $isArrayOf_J = $makeIsArrayOfPrimitive($d_J);
$d_J.isArrayOf = $isArrayOf_J;

var $isArrayOf_F = $makeIsArrayOfPrimitive($d_F);
$d_F.isArrayOf = $isArrayOf_F;

var $isArrayOf_D = $makeIsArrayOfPrimitive($d_D);
$d_D.isArrayOf = $isArrayOf_D;


// asInstanceOfs for array of primitives
var $asArrayOf_Z = $makeAsArrayOfPrimitive($isArrayOf_Z, "Z");
var $asArrayOf_C = $makeAsArrayOfPrimitive($isArrayOf_C, "C");
var $asArrayOf_B = $makeAsArrayOfPrimitive($isArrayOf_B, "B");
var $asArrayOf_S = $makeAsArrayOfPrimitive($isArrayOf_S, "S");
var $asArrayOf_I = $makeAsArrayOfPrimitive($isArrayOf_I, "I");
var $asArrayOf_J = $makeAsArrayOfPrimitive($isArrayOf_J, "J");
var $asArrayOf_F = $makeAsArrayOfPrimitive($isArrayOf_F, "F");
var $asArrayOf_D = $makeAsArrayOfPrimitive($isArrayOf_D, "D");

function $is_F0(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.F0)))
}
function $as_F0(obj) {
  return (($is_F0(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.Function0"))
}
function $isArrayOf_F0(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.F0)))
}
function $asArrayOf_F0(obj, depth) {
  return (($isArrayOf_F0(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.Function0;", depth))
}
function $is_F1(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.F1)))
}
function $as_F1(obj) {
  return (($is_F1(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.Function1"))
}
function $isArrayOf_F1(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.F1)))
}
function $asArrayOf_F1(obj, depth) {
  return (($isArrayOf_F1(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.Function1;", depth))
}
function $s_Lcats_instances_EitherInstances$class__$$init$__Lcats_instances_EitherInstances__V($$this) {
  $$this.catsStdBitraverseForEither$1 = new $c_Lcats_instances_EitherInstances$$anon$2().init___Lcats_instances_EitherInstances($$this)
}
function $s_Lcats_instances_ListInstances$class__$$init$__Lcats_instances_ListInstances__V($$this) {
  $$this.catsStdInstancesForList$1 = new $c_Lcats_instances_ListInstances$$anon$1().init___Lcats_instances_ListInstances($$this)
}
function $s_Lcats_instances_ListInstancesBinCompat0$class__$$init$__Lcats_instances_ListInstancesBinCompat0__V($$this) {
  $$this.catsStdTraverseFilterForList$1 = new $c_Lcats_instances_ListInstancesBinCompat0$$anon$3().init___Lcats_instances_ListInstancesBinCompat0($$this)
}
function $s_Lcats_kernel_Eq$class__neqv__Lcats_kernel_Eq__O__O__Z($$this, x, y) {
  return (!$$this.eqv__O__O__Z(x, y))
}
function $s_Lio_circe_ArrayEncoder$class__apply__Lio_circe_ArrayEncoder__O__Lio_circe_Json($$this, a) {
  $m_Lio_circe_Json$();
  var values = $$this.encodeArray__O__sci_Vector(a);
  return new $c_Lio_circe_Json$JArray().init___sci_Vector(values)
}
function $is_Lio_circe_CursorOp$Selection(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_circe_CursorOp$Selection)))
}
function $as_Lio_circe_CursorOp$Selection(obj) {
  return (($is_Lio_circe_CursorOp$Selection(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.circe.CursorOp$Selection"))
}
function $isArrayOf_Lio_circe_CursorOp$Selection(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_circe_CursorOp$Selection)))
}
function $asArrayOf_Lio_circe_CursorOp$Selection(obj, depth) {
  return (($isArrayOf_Lio_circe_CursorOp$Selection(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.circe.CursorOp$Selection;", depth))
}
function $s_Lio_circe_Decoder$class__decodeJson__Lio_circe_Decoder__Lio_circe_Json__s_util_Either($$this, j) {
  return $$this.apply__Lio_circe_HCursor__s_util_Either(new $c_Lio_circe_cursor_TopCursor().init___Lio_circe_Json__Lio_circe_HCursor__Lio_circe_CursorOp(j, null, null))
}
function $s_Lio_circe_Decoder$class__tryDecode__Lio_circe_Decoder__Lio_circe_ACursor__s_util_Either($$this, c) {
  if ($is_Lio_circe_HCursor(c)) {
    var x2 = $as_Lio_circe_HCursor(c);
    return $$this.apply__Lio_circe_HCursor__s_util_Either(x2)
  } else {
    $m_s_package$();
    $m_Lio_circe_DecodingFailure$();
    var ops = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(c$27) {
      return (function() {
        return c$27.history__sci_List()
      })
    })(c));
    var a = new $c_Lio_circe_DecodingFailure$$anon$2().init___T__F0("Attempt to decode value on failed cursor", ops);
    return new $c_s_util_Left().init___O(a)
  }
}
function $s_Lio_circe_ObjectEncoder$class__apply__Lio_circe_ObjectEncoder__O__Lio_circe_Json($$this, a) {
  $m_Lio_circe_Json$();
  var value = $$this.encodeObject__O__Lio_circe_JsonObject(a);
  return new $c_Lio_circe_Json$JObject().init___Lio_circe_JsonObject(value)
}
function $s_Lio_youi_ErrorSupport$class__error__Lio_youi_ErrorSupport__jl_Throwable__V($$this, t) {
  var this$1 = $m_Lio_youi_ErrorSupport$().error$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(t$1) {
    return (function() {
      return t$1
    })
  })(t));
  this$1.set__F0__V(value)
}
function $is_Lio_youi_MessageException(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_MessageException)))
}
function $as_Lio_youi_MessageException(obj) {
  return (($is_Lio_youi_MessageException(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.MessageException"))
}
function $isArrayOf_Lio_youi_MessageException(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_MessageException)))
}
function $asArrayOf_Lio_youi_MessageException(obj, depth) {
  return (($isArrayOf_Lio_youi_MessageException(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.MessageException;", depth))
}
function $is_Lio_youi_Modifiable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_Modifiable)))
}
function $as_Lio_youi_Modifiable(obj) {
  return (($is_Lio_youi_Modifiable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.Modifiable"))
}
function $isArrayOf_Lio_youi_Modifiable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_Modifiable)))
}
function $asArrayOf_Lio_youi_Modifiable(obj, depth) {
  return (($isArrayOf_Lio_youi_Modifiable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.Modifiable;", depth))
}
function $s_Lio_youi_Modifiable$class__modified__Lio_youi_Modifiable__Lreactify_Var($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $is_Lio_youi_Updatable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_Updatable)))
}
function $as_Lio_youi_Updatable(obj) {
  return (($is_Lio_youi_Updatable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.Updatable"))
}
function $isArrayOf_Lio_youi_Updatable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_Updatable)))
}
function $asArrayOf_Lio_youi_Updatable(obj, depth) {
  return (($isArrayOf_Lio_youi_Updatable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.Updatable;", depth))
}
function $s_Lio_youi_Updates$class__update__Lio_youi_Updates__D__V($$this, delta) {
  var this$1 = $$this.delta__Lreactify_Channel();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(delta$1) {
    return (function() {
      return delta$1
    })
  })(delta));
  this$1.set__F0__V(value)
}
function $s_Lio_youi_Updates$class__rateLimited$default$2__Lio_youi_Updates__s_concurrent_duration_FiniteDuration($$this) {
  var this$2 = new $c_s_concurrent_duration_package$DurationInt().init___I(0);
  var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
  return $m_s_concurrent_duration_package$DurationInt$().durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration(this$2.scala$concurrent$duration$DurationInt$$n$1, unit)
}
function $s_Lio_youi_Updates$class__once__Lio_youi_Updates__s_concurrent_duration_FiniteDuration__F0__V($$this, delay, f) {
  var until = new $c_s_Some().init___O(delay);
  $s_Lio_youi_Updates$class__every__Lio_youi_Updates__s_concurrent_duration_FiniteDuration__s_Option__F0__V($$this, delay, until, f)
}
function $s_Lio_youi_Updates$class__rateLimited__Lio_youi_Updates__s_concurrent_duration_FiniteDuration__s_concurrent_duration_FiniteDuration__F0__Lio_youi_LazyUpdate($$this, maxFrequency, frequency, f) {
  var lu = new $c_Lio_youi_LazyUpdate().init___F0__s_concurrent_duration_FiniteDuration(f, maxFrequency);
  var until = $m_s_None$();
  var f$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(lu$1) {
    return (function() {
      lu$1.update__Z__V(false)
    })
  })(lu));
  $s_Lio_youi_Updates$class__every__Lio_youi_Updates__s_concurrent_duration_FiniteDuration__s_Option__F0__V($$this, frequency, until, f$1);
  return lu
}
function $s_Lio_youi_Updates$class__every__Lio_youi_Updates__s_concurrent_duration_FiniteDuration__s_Option__F0__V($$this, delay, until, f) {
  var t = delay.unit$2.toMillis__J__J(delay.length$2);
  var lo = t.lo$2;
  var hi = t.hi$2;
  var timeout = ($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo, hi) / 1000.0);
  if (until.isEmpty__Z()) {
    var untilTimeout = $m_s_None$()
  } else {
    var arg1 = until.get__O();
    var x$2 = $as_s_concurrent_duration_FiniteDuration(arg1);
    var t$1 = x$2.unit$2.toMillis__J__J(x$2.length$2);
    var lo$1 = t$1.lo$2;
    var hi$1 = t$1.hi$2;
    var untilTimeout = new $c_s_Some().init___O(($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo$1, hi$1) / 1000.0))
  };
  var elapsed = new $c_sr_DoubleRef().init___D(0.0);
  var totalElapsed = new $c_sr_DoubleRef().init___D(0.0);
  var reaction = new $c_sr_ObjectRef().init___O(null);
  var this$5 = $$this.delta__Lreactify_Channel();
  var f$1 = new $c_Lio_youi_Updates$$anonfun$every$1().init___Lio_youi_Updates__D__s_Option__sr_DoubleRef__sr_DoubleRef__sr_ObjectRef__F0($$this, timeout, untilTimeout, elapsed, totalElapsed, reaction, f);
  $$this.delta__Lreactify_Channel();
  var priority = $m_Lreactify_Priority$().Normal$1;
  reaction.elem$1 = $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$5, f$1, priority)
}
function $s_Lio_youi_app_ClientApplication$class__$$init$__Lio_youi_app_ClientApplication__V($$this) {
  $m_Lio_youi_app_ClientApplication$().io$youi$app$ClientApplication$$instance$1 = $$this;
  $m_Lio_youi_dom$().addScript__T__Z__s_concurrent_Future("/source-map.min.js", ($m_Lio_youi_dom$(), false));
  $$this.io$youi$app$ClientApplication$$configuredConnectivity$1 = $m_sci_Map$EmptyMap$();
  $$this.io$youi$app$ClientApplication$$errorFunction$1 = (function(f) {
    return (function(arg1, arg2, arg3, arg4, arg5) {
      return f.apply__O__O__O__O__O__O(arg1, arg2, arg3, arg4, arg5)
    })
  })(new $c_Lio_youi_app_ClientApplication$$anonfun$1().init___Lio_youi_app_ClientApplication($$this));
  if ($s_Lio_youi_app_YouIApplication$class__logJavaScriptErrors__Lio_youi_app_YouIApplication__Z($$this)) {
    $g.window.onerror = $$this.io$youi$app$ClientApplication$$errorFunction$1;
    var this$4 = $m_Lscribe_Logger$();
    var qual$1 = this$4.apply__J__Lscribe_Logger(this$4.rootId$1);
    var x$1 = $m_Lio_youi_app_sourceMap_ErrorTrace$();
    var x$2 = $m_Lscribe_format_Formatter$().$default__Lscribe_format_Formatter();
    var x$3 = $m_s_None$();
    var x$4 = $m_sci_Nil$();
    var qual$2 = qual$1.withHandler__Lscribe_format_Formatter__Lscribe_writer_Writer__s_Option__sci_List__Lscribe_Logger(x$2, x$1, x$3, x$4);
    var x$5 = $m_s_None$();
    qual$2.replace__s_Option__Lscribe_Logger(x$5)
  };
  var this$6 = $$this.connectivityEntries$1;
  var f$1 = new $c_Lio_youi_app_ClientApplication$$anonfun$2().init___Lio_youi_app_ClientApplication($$this);
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Val$class__attachAndFire__Lreactify_Val__F1__D__Lreactify_reaction_Reaction(this$6, f$1, priority)
}
function $s_Lio_youi_app_YouIApplication$class__logJavaScriptErrors__Lio_youi_app_YouIApplication__Z($$this) {
  var this$3 = $m_Lprofig_Profig$();
  var array = ["logJavaScriptErrors"];
  var path = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var this$4 = $s_Lprofig_ProfigPath$class__apply__Lprofig_ProfigPath__sc_Seq__Lprofig_ProfigPath(this$3, path);
  var this$5 = $s_Lprofig_ProfigPath$class__get__Lprofig_ProfigPath__s_Option(this$4);
  if (this$5.isEmpty__Z()) {
    var this$7 = $m_s_None$()
  } else {
    var arg1 = this$5.get__O();
    var json = $as_Lio_circe_Json(arg1);
    $m_Lio_circe_generic_extras_Configuration$().default$1.withDefaults__Lio_circe_generic_extras_Configuration();
    var e = $m_Lprofig_Conversions$().booleanDecoder$1;
    var x1 = $s_Lio_circe_Decoder$class__decodeJson__Lio_circe_Decoder__Lio_circe_Json__s_util_Either(e, json);
    if ($is_s_util_Left(x1)) {
      var x2 = $as_s_util_Left(x1);
      var failure = $as_Lio_circe_DecodingFailure(x2.a$2);
      throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T__jl_Throwable(("Failed to decode from " + json), failure))
    };
    if ((!$is_s_util_Right(x1))) {
      throw new $c_s_MatchError().init___O(x1)
    };
    var x3 = $as_s_util_Right(x1);
    var value = $uZ(x3.b$2);
    var this$7 = new $c_s_Some().init___O(value)
  };
  return $uZ((this$7.isEmpty__Z() || this$7.get__O()))
}
function $s_Lio_youi_app_YouIApplication$class__$$init$__Lio_youi_app_YouIApplication__V($$this) {
  $m_Lio_youi_Cache$().implementation$1 = $$this;
  $m_Lio_youi_app_YouIApplication$().io$youi$app$YouIApplication$$instance$1 = new $c_s_Some().init___O($$this);
  $$this.logPath$1 = "/client/log";
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_sci_Set$EmptySet$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  $$this.connectivityEntries$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  $$this.connectivity$1 = new $c_Lio_youi_app_ApplicationConnectivity().init___Lio_youi_app_YouIApplication__T__Z($$this, "/communication", true)
}
function $s_Lio_youi_app_screen_ContentScreen$class__content__Lio_youi_app_screen_ContentScreen__Lorg_scalajs_dom_raw_HTMLSpanElement($$this) {
  var this$1 = $$this.contentOption__Lreactify_Val();
  var this$2 = $as_s_Option(this$1.state__Lreactify_State().value__O());
  if (this$2.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("Content not set!"))
  } else {
    return this$2.get__O()
  }
}
function $s_Lio_youi_app_screen_ContentScreen$class__deactivate__Lio_youi_app_screen_ContentScreen__s_concurrent_Future($$this) {
  var this$1 = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(x$3$2) {
      $asUnit(x$3$2);
      $s_Lio_youi_app_screen_ContentScreen$class__hideContent__Lio_youi_app_screen_ContentScreen__V(arg$outer)
    })
  })($$this));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
}
function $s_Lio_youi_app_screen_ContentScreen$class__io$youi$app$screen$ContentScreen$$loadScreen__Lio_youi_app_screen_ContentScreen__Lorg_scalajs_dom_raw_HTMLElement__V($$this, screen) {
  var span = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("span");
  ($m_Lio_youi_dom$(), new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(screen)).remove__V();
  var size = $uI(screen.childNodes.length);
  var isEmpty$4 = (size <= 0);
  if (isEmpty$4) {
    var numRangeElements$4 = 0
  } else {
    var hi = (size >> 31);
    var numRangeElements$4 = (((hi === 0) ? (((-2147483648) ^ size) > (-1)) : (hi > 0)) ? (-1) : size)
  };
  var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + size) | 0));
  var eta$0$1 = screen.childNodes;
  $m_sci_IndexedSeq$();
  $m_sc_IndexedSeq$();
  $m_sci_IndexedSeq$();
  $m_sci_Vector$();
  var b = new $c_sci_VectorBuilder().init___();
  if ((numRangeElements$4 < 0)) {
    $m_sci_Range$().scala$collection$immutable$Range$$fail__I__I__I__Z__sr_Nothing$(0, size, 1, false)
  };
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var arg1 = i;
      var elem = eta$0$1.item(arg1);
      b.$$plus$eq__O__sci_VectorBuilder(elem);
      if ((i === lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  var this$8 = b.result__sci_Vector();
  var this$9 = this$8.iterator__sci_VectorIterator();
  while (this$9.$$undhasNext$2) {
    var arg1$1 = this$9.next__O();
    if ($uZ((arg1$1 instanceof $g.Element))) {
      ($m_Lio_youi_dom$(), new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(arg1$1)).remove__V()
    };
    span.appendChild(arg1$1)
  };
  $s_Lio_youi_app_screen_ContentScreen$class__io$youi$app$screen$ContentScreen$$pageTag__Lio_youi_app_screen_ContentScreen__Lorg_scalajs_dom_raw_HTMLElement($$this).appendChild(span);
  var this$11 = $$this.io$youi$app$screen$ContentScreen$$contentOptionVar__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(span$1) {
    return (function() {
      return new $c_s_Some().init___O(span$1)
    })
  })(span));
  this$11.set__F0__V(value)
}
function $s_Lio_youi_app_screen_ContentScreen$class__activate__Lio_youi_app_screen_ContentScreen__s_concurrent_Future($$this) {
  var this$1 = $s_Lio_youi_app_screen_URLActivation$class__activate__Lio_youi_app_screen_URLActivation__s_concurrent_Future($$this);
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(x$2$2) {
      $asUnit(x$2$2);
      $s_Lio_youi_app_screen_ContentScreen$class__showContent__Lio_youi_app_screen_ContentScreen__V(arg$outer)
    })
  })($$this));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
}
function $s_Lio_youi_app_screen_ContentScreen$class__showContent__Lio_youi_app_screen_ContentScreen__V($$this) {
  var v = $$this.contentOption__Lreactify_Val();
  var this$2 = $as_s_Option(v.state__Lreactify_State().value__O());
  if ((!this$2.isEmpty__Z())) {
    var arg1 = this$2.get__O();
    if ($m_s_Option$().apply__O__s_Option(arg1.parentElement).isEmpty__Z()) {
      $s_Lio_youi_app_screen_ContentScreen$class__io$youi$app$screen$ContentScreen$$pageTag__Lio_youi_app_screen_ContentScreen__Lorg_scalajs_dom_raw_HTMLElement($$this).appendChild(arg1)
    }
  }
}
function $s_Lio_youi_app_screen_ContentScreen$class__hideContent__Lio_youi_app_screen_ContentScreen__V($$this) {
  var v = $$this.contentOption__Lreactify_Val();
  var this$2 = $as_s_Option(v.state__Lreactify_State().value__O());
  if ((!this$2.isEmpty__Z())) {
    var arg1 = this$2.get__O();
    var this$3 = $m_s_Option$().apply__O__s_Option(arg1.parentElement);
    if (this$3.isDefined__Z()) {
      ($m_Lio_youi_dom$(), new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(arg1)).remove__V()
    }
  }
}
function $s_Lio_youi_app_screen_ContentScreen$class__load__Lio_youi_app_screen_ContentScreen__s_concurrent_Future($$this) {
  var this$1 = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
  var f = new $c_Lio_youi_app_screen_ContentScreen$$anonfun$load$1().init___Lio_youi_app_screen_ContentScreen($$this);
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
}
function $s_Lio_youi_app_screen_ContentScreen$class__io$youi$app$screen$ContentScreen$$pageTag__Lio_youi_app_screen_ContentScreen__Lorg_scalajs_dom_raw_HTMLElement($$this) {
  var this$1 = $m_Lio_youi_dom$();
  return this$1.bySelector__T__sci_Vector("page").head__O()
}
function $s_Lio_youi_app_screen_ContentScreen$class__$$init$__Lio_youi_app_screen_ContentScreen__V($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_s_None$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  $$this.io$youi$app$screen$ContentScreen$$undsetter$und$io$youi$app$screen$ContentScreen$$contentOptionVar$und$eq__Lreactify_Var__V(new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name));
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var v = arg$outer.io$youi$app$screen$ContentScreen$$contentOptionVar__Lreactify_Var();
      return $as_s_Option(v.state__Lreactify_State().value__O())
    })
  })($$this));
  var name$1 = $m_s_None$();
  $$this.io$youi$app$screen$ContentScreen$$undsetter$und$contentOption$und$eq__Lreactify_Val__V(new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$1))
}
function $s_Lio_youi_app_screen_LoadingTransitionSupport$class__beforeScreenChange__Lio_youi_app_screen_LoadingTransitionSupport__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future($$this, oldScreen, newScreen) {
  $m_s_concurrent_Future$();
  var body = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      arg$outer.loadingElement$1.classList.remove("hidden")
    })
  })($$this));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $m_s_concurrent_impl_Future$().apply__F0__s_concurrent_ExecutionContext__s_concurrent_Future(body, executor)
}
function $s_Lio_youi_app_screen_LoadingTransitionSupport$class__afterScreenChange__Lio_youi_app_screen_LoadingTransitionSupport__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future($$this, oldScreen, newScreen) {
  $m_s_concurrent_Future$();
  var body = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      arg$outer.loadingElement$1.classList.add("hidden")
    })
  })($$this));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $m_s_concurrent_impl_Future$().apply__F0__s_concurrent_ExecutionContext__s_concurrent_Future(body, executor)
}
function $s_Lio_youi_app_screen_PathActivation$class__updateURL__Lio_youi_app_screen_PathActivation__Lio_youi_net_URL__s_Option($$this, current) {
  var x = current.path$1;
  var x$2 = $$this.path__Lio_youi_net_Path();
  if ((!((x === null) ? (x$2 === null) : x.equals__O__Z(x$2)))) {
    var url = current.withPath__Lio_youi_net_Path__Lio_youi_net_URL($$this.path__Lio_youi_net_Path());
    return new $c_s_Some().init___O(new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url, $m_Lio_youi_StateType$Push$(), null))
  } else {
    return $m_s_None$()
  }
}
function $is_Lio_youi_app_screen_Screen(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_screen_Screen)))
}
function $as_Lio_youi_app_screen_Screen(obj) {
  return (($is_Lio_youi_app_screen_Screen(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.screen.Screen"))
}
function $isArrayOf_Lio_youi_app_screen_Screen(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_screen_Screen)))
}
function $asArrayOf_Lio_youi_app_screen_Screen(obj, depth) {
  return (($isArrayOf_Lio_youi_app_screen_Screen(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.screen.Screen;", depth))
}
function $s_Lio_youi_app_screen_Screen$class__$$init$__Lio_youi_app_screen_Screen__V($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_app_screen_ScreenState$New$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  $$this.io$youi$app$screen$Screen$$undsetter$und$currentState$und$eq__Lreactify_Var__V(new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name));
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var v = arg$outer.currentState__Lreactify_Var();
      return $as_Lio_youi_app_screen_ScreenState(v.state__Lreactify_State().value__O())
    })
  })($$this));
  var name$1 = $m_s_None$();
  $$this.io$youi$app$screen$Screen$$undsetter$und$state$und$eq__Lreactify_Val__V(new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$1));
  var this$7 = $m_Lio_youi_app_screen_ScreenManager$().apply__Lio_youi_app_screen_ScreenManager();
  $s_Lio_youi_app_screen_ScreenManager$class__addScreen__Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__V(this$7, $$this)
}
function $s_Lio_youi_app_screen_Screen$class__activate__Lio_youi_app_screen_Screen__s_concurrent_Future($$this) {
  var this$1 = $m_Lio_youi_ui$().title__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      return arg$outer.title__T()
    })
  })($$this));
  this$1.set__F0__V(value);
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
}
function $is_Lio_youi_app_screen_ScreenManager(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_screen_ScreenManager)))
}
function $as_Lio_youi_app_screen_ScreenManager(obj) {
  return (($is_Lio_youi_app_screen_ScreenManager(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.screen.ScreenManager"))
}
function $isArrayOf_Lio_youi_app_screen_ScreenManager(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_screen_ScreenManager)))
}
function $asArrayOf_Lio_youi_app_screen_ScreenManager(obj, depth) {
  return (($isArrayOf_Lio_youi_app_screen_ScreenManager(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.screen.ScreenManager;", depth))
}
function $s_Lio_youi_app_screen_ScreenManager$class__$$init$__Lio_youi_app_screen_ScreenManager__V($$this) {
  $m_Lio_youi_app_screen_ScreenManager$().io$youi$app$screen$ScreenManager$$instance$1 = new $c_s_Some().init___O($$this);
  $$this.io$youi$app$screen$ScreenManager$$managerFuture$1 = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_sci_Nil$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  $$this.io$youi$app$screen$ScreenManager$$allScreens$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  $$this.screens$1 = $$this.io$youi$app$screen$ScreenManager$$allScreens$1;
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_app_screen_EmptyScreen$()
  }));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  $$this.active$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return false
  }));
  var mode$2 = $m_Lreactify_Var$Mode$Normal$();
  var name$2 = $m_s_None$();
  $$this.loaded$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$2, name$2);
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().addEventListener("load", (function(f) {
    return (function(arg1) {
      return f.apply__O__O(arg1)
    })
  })(new $c_Lio_youi_app_screen_ScreenManager$$anonfun$4().init___Lio_youi_app_screen_ScreenManager($$this)));
  var this$11 = $$this.active$1;
  var f$1 = new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function(arg$outer) {
    return (function(x0$1$2, x1$1$2) {
      var x0$1 = $as_Lio_youi_app_screen_Screen(x0$1$2);
      var x1$1 = $as_Lio_youi_app_screen_Screen(x1$1$2);
      $s_Lio_youi_app_screen_ScreenManager$class__io$youi$app$screen$ScreenManager$$screenChange__Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__V(arg$outer, x0$1, x1$1)
    })
  })($$this));
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__changes__Lreactify_Reactive__F2__D__Lreactify_reaction_Reaction(this$11, f$1, priority)
}
function $s_Lio_youi_app_screen_ScreenManager$class__addScreen__Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__V($$this, screen) {
  if (($$this === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  var this$6 = $$this.io$youi$app$screen$ScreenManager$$allScreens$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer, screen$3) {
    return (function() {
      var this$1 = arg$outer.io$youi$app$screen$ScreenManager$$allScreens$1;
      var x$7 = $as_sci_List(this$1.state__Lreactify_State().value__O());
      $m_sci_List$();
      var array = [screen$3];
      var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
      var this$5 = $m_sci_List$();
      var cbf = this$5.ReusableCBFInstance$2;
      return $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)).$$colon$colon$colon__sci_List__sci_List(x$7)
    })
  })($$this, screen));
  this$6.set__F0__V(value)
}
function $s_Lio_youi_app_screen_ScreenManager$class__io$youi$app$screen$ScreenManager$$deactivate__Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future($$this, screen) {
  var this$1 = screen.state__Lreactify_Val();
  var x = this$1.state__Lreactify_State().value__O();
  var x$2 = $m_Lio_youi_app_screen_ScreenState$Activated$();
  if (((x !== null) && $objectEquals(x, x$2))) {
    var this$2 = screen.currentState__Lreactify_Var();
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return $m_Lio_youi_app_screen_ScreenState$Deactivating$()
    }));
    this$2.set__F0__V(value);
    var this$4 = screen.deactivate__s_concurrent_Future();
    var f = new $c_Lio_youi_app_screen_ScreenManager$$anonfun$6().init___Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen($$this, screen);
    var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
    var future = $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$4, f, executor);
    var this$5 = $s_s_concurrent_Future$class__failed__s_concurrent_Future__s_concurrent_Future(future);
    var eta$0$3 = $m_Lio_youi_app_YouIApplication$().apply__Lio_youi_app_YouIApplication();
    var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(eta$0$3$1) {
      return (function(t$2) {
        var t = $as_jl_Throwable(t$2);
        $s_Lio_youi_ErrorSupport$class__error__Lio_youi_ErrorSupport__jl_Throwable__V(eta$0$3$1, t)
      })
    })(eta$0$3));
    var executor$1 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
    $s_s_concurrent_Future$class__foreach__s_concurrent_Future__F1__s_concurrent_ExecutionContext__V(this$5, f$1, executor$1);
    $$this.io$youi$app$screen$ScreenManager$$managerFuture$1 = future;
    return future
  } else {
    return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
  }
}
function $s_Lio_youi_app_screen_ScreenManager$class__io$youi$app$screen$ScreenManager$$activate__Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future($$this, screen) {
  var elem = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
  var elem$1 = null;
  elem$1 = elem;
  var this$2 = screen.state__Lreactify_Val();
  var state = $as_Lio_youi_app_screen_ScreenState(this$2.state__Lreactify_State().value__O());
  var applying = $m_Lio_youi_app_screen_ScreenState$Initializing$();
  var applied = $m_Lio_youi_app_screen_ScreenState$Initialized$();
  var call = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(screen$2) {
    return (function() {
      return screen$2.init__s_concurrent_Future()
    })
  })(screen));
  var applyToStates = $m_s_Predef$().wrapRefArray__AO__scm_WrappedArray($makeNativeArrayWrapper($d_Lio_youi_app_screen_ScreenState.getArrayOf(), [$m_Lio_youi_app_screen_ScreenState$New$(), $m_Lio_youi_app_screen_ScreenState$Disposing$(), $m_Lio_youi_app_screen_ScreenState$Disposed$()]));
  if ($s_sc_SeqLike$class__contains__sc_SeqLike__O__Z(applyToStates, state)) {
    var this$4 = $as_s_concurrent_Future(elem$1);
    var f = new $c_Lio_youi_app_screen_ScreenManager$$anonfun$applyState$2$1().init___Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__Lio_youi_app_screen_ScreenState__Lio_youi_app_screen_ScreenState__F0($$this, screen, applying, applied, call);
    var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
    elem$1 = $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$4, f, executor)
  };
  var applying$1 = $m_Lio_youi_app_screen_ScreenState$Loading$();
  var applied$1 = $m_Lio_youi_app_screen_ScreenState$Loaded$();
  var call$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(screen$2$1) {
    return (function() {
      return screen$2$1.load__s_concurrent_Future()
    })
  })(screen));
  var applyToStates$1 = $m_s_Predef$().wrapRefArray__AO__scm_WrappedArray($makeNativeArrayWrapper($d_Lio_youi_app_screen_ScreenState.getArrayOf(), [$m_Lio_youi_app_screen_ScreenState$New$(), $m_Lio_youi_app_screen_ScreenState$Disposing$(), $m_Lio_youi_app_screen_ScreenState$Disposed$(), $m_Lio_youi_app_screen_ScreenState$Initializing$(), $m_Lio_youi_app_screen_ScreenState$Initialized$()]));
  if ($s_sc_SeqLike$class__contains__sc_SeqLike__O__Z(applyToStates$1, state)) {
    var this$6 = $as_s_concurrent_Future(elem$1);
    var f$1 = new $c_Lio_youi_app_screen_ScreenManager$$anonfun$applyState$2$1().init___Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__Lio_youi_app_screen_ScreenState__Lio_youi_app_screen_ScreenState__F0($$this, screen, applying$1, applied$1, call$1);
    var executor$1 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
    elem$1 = $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$6, f$1, executor$1)
  };
  var applying$2 = $m_Lio_youi_app_screen_ScreenState$Activating$();
  var applied$2 = $m_Lio_youi_app_screen_ScreenState$Activated$();
  var call$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(screen$2$2) {
    return (function() {
      return screen$2$2.activate__s_concurrent_Future()
    })
  })(screen));
  var applyToStates$2 = $m_s_Predef$().wrapRefArray__AO__scm_WrappedArray($makeNativeArrayWrapper($d_Lio_youi_app_screen_ScreenState.getArrayOf(), [$m_Lio_youi_app_screen_ScreenState$New$(), $m_Lio_youi_app_screen_ScreenState$Disposing$(), $m_Lio_youi_app_screen_ScreenState$Disposed$(), $m_Lio_youi_app_screen_ScreenState$Initializing$(), $m_Lio_youi_app_screen_ScreenState$Initialized$(), $m_Lio_youi_app_screen_ScreenState$Deactivating$(), $m_Lio_youi_app_screen_ScreenState$Deactivated$()]));
  if ($s_sc_SeqLike$class__contains__sc_SeqLike__O__Z(applyToStates$2, state)) {
    var this$8 = $as_s_concurrent_Future(elem$1);
    var f$2 = new $c_Lio_youi_app_screen_ScreenManager$$anonfun$applyState$2$1().init___Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__Lio_youi_app_screen_ScreenState__Lio_youi_app_screen_ScreenState__F0($$this, screen, applying$2, applied$2, call$2);
    var executor$2 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
    elem$1 = $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$8, f$2, executor$2)
  };
  var this$9 = $as_s_concurrent_Future(elem$1);
  var this$10 = $s_s_concurrent_Future$class__failed__s_concurrent_Future__s_concurrent_Future(this$9);
  var eta$0$2 = $m_Lio_youi_app_YouIApplication$().apply__Lio_youi_app_YouIApplication();
  var f$3 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(eta$0$2$1) {
    return (function(t$2) {
      var t = $as_jl_Throwable(t$2);
      $s_Lio_youi_ErrorSupport$class__error__Lio_youi_ErrorSupport__jl_Throwable__V(eta$0$2$1, t)
    })
  })(eta$0$2));
  var executor$3 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  $s_s_concurrent_Future$class__foreach__s_concurrent_Future__F1__s_concurrent_ExecutionContext__V(this$10, f$3, executor$3);
  $$this.io$youi$app$screen$ScreenManager$$managerFuture$1 = $as_s_concurrent_Future(elem$1);
  return $as_s_concurrent_Future(elem$1)
}
function $s_Lio_youi_app_screen_ScreenManager$class__io$youi$app$screen$ScreenManager$$screenChange__Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__V($$this, oldScreen, newScreen) {
  if (($$this === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  if ($$this.io$youi$app$screen$ScreenManager$$managerFuture$1.isCompleted__Z()) {
    $$this.io$youi$app$screen$ScreenManager$$managerFuture$1 = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
  };
  var jsx$2 = $m_Lscribe_package$();
  var level = $m_Lscribe_Level$Debug$();
  var value = $m_Lscribe_Level$Debug$().value$1;
  var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(oldScreen$1, newScreen$1) {
    return (function() {
      var array = ["Screen change from ", " to ", "..."];
      var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
      var array$1 = [oldScreen$1, newScreen$1];
      return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
    })
  })(oldScreen, newScreen));
  var loggable = $m_Lscribe_Loggable$StringLoggable$();
  var throwable = $m_s_None$();
  var methodName = new $c_s_Some().init___O("screenChange");
  var line = new $c_s_Some().init___O(34);
  var column = new $c_s_Some().init___O(17);
  var thread = $m_jl_Thread$().SingleThread$1;
  var this$7 = $m_Lscribe_util_Time$();
  var t = this$7.function$1.apply$mcJ$sp__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  jsx$2.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/app/js/src/main/scala/io/youi/app/screen/ScreenManager.scala", "io.youi.app.screen.ScreenManager", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
  var this$9 = $$this.loaded$1;
  if ((!$uZ(this$9.state__Lreactify_State().value__O()))) {
    var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
    var this$13 = $$this.loaded$1;
    var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(promise$1) {
      return (function(x$1$2) {
        $uZ(x$1$2);
        $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(promise$1, (void 0))
      })
    })(promise));
    var this$11 = $$this.loaded$1;
    var condition = $s_Lreactify_Reactive$class__once$default$2__Lreactify_Reactive__F1(this$11);
    var priority = $m_Lreactify_Priority$().Normal$1;
    $s_Lreactify_Reactive$class__once__Lreactify_Reactive__F1__F1__D__Lreactify_reaction_Reaction(this$13, f, condition, priority);
    var this$14 = $$this.io$youi$app$screen$ScreenManager$$managerFuture$1;
    var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(promise$1$1) {
      return (function(x$2$2) {
        $asUnit(x$2$2);
        return promise$1$1
      })
    })(promise));
    var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
    $$this.io$youi$app$screen$ScreenManager$$managerFuture$1 = $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$14, f$1, executor)
  };
  var this$15 = $$this.io$youi$app$screen$ScreenManager$$managerFuture$1;
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer, oldScreen$1$1, newScreen$1$1) {
    return (function(x$3$2) {
      $asUnit(x$3$2);
      return $s_Lio_youi_app_screen_LoadingTransitionSupport$class__beforeScreenChange__Lio_youi_app_screen_LoadingTransitionSupport__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future(arg$outer, oldScreen$1$1, newScreen$1$1)
    })
  })($$this, oldScreen, newScreen));
  var executor$1 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  $$this.io$youi$app$screen$ScreenManager$$managerFuture$1 = $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$15, f$2, executor$1);
  var this$16 = $$this.io$youi$app$screen$ScreenManager$$managerFuture$1;
  var f$3 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$1, oldScreen$1$2) {
    return (function(x$4$2) {
      $asUnit(x$4$2);
      return $s_Lio_youi_app_screen_ScreenManager$class__io$youi$app$screen$ScreenManager$$deactivate__Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future(arg$outer$1, oldScreen$1$2)
    })
  })($$this, oldScreen));
  var executor$2 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  $$this.io$youi$app$screen$ScreenManager$$managerFuture$1 = $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$16, f$3, executor$2);
  var this$17 = $$this.io$youi$app$screen$ScreenManager$$managerFuture$1;
  var f$4 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$2, newScreen$1$2) {
    return (function(x$5$2) {
      $asUnit(x$5$2);
      return $s_Lio_youi_app_screen_ScreenManager$class__io$youi$app$screen$ScreenManager$$activate__Lio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future(arg$outer$2, newScreen$1$2)
    })
  })($$this, newScreen));
  var executor$3 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  $$this.io$youi$app$screen$ScreenManager$$managerFuture$1 = $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$17, f$4, executor$3);
  var this$18 = $$this.io$youi$app$screen$ScreenManager$$managerFuture$1;
  var f$5 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$3, oldScreen$1$3, newScreen$1$3) {
    return (function(x$6$2) {
      $asUnit(x$6$2);
      return $s_Lio_youi_app_screen_LoadingTransitionSupport$class__afterScreenChange__Lio_youi_app_screen_LoadingTransitionSupport__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future(arg$outer$3, oldScreen$1$3, newScreen$1$3)
    })
  })($$this, oldScreen, newScreen));
  var executor$4 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  $$this.io$youi$app$screen$ScreenManager$$managerFuture$1 = $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$18, f$5, executor$4)
}
function $s_Lio_youi_app_screen_UIScreen$class__deactivate__Lio_youi_app_screen_UIScreen__s_concurrent_Future($$this) {
  var this$1 = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
  var f = new $c_Lio_youi_app_screen_UIScreen$$anonfun$deactivate$1().init___Lio_youi_app_screen_UIScreen($$this);
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
}
function $s_Lio_youi_app_screen_UIScreen$class__init__Lio_youi_app_screen_UIScreen__s_concurrent_Future($$this) {
  var this$1 = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
  var f = new $c_Lio_youi_app_screen_UIScreen$$anonfun$init$1().init___Lio_youi_app_screen_UIScreen($$this);
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
}
function $s_Lio_youi_app_screen_UIScreen$class__activate__Lio_youi_app_screen_UIScreen__s_concurrent_Future($$this) {
  var this$1 = $s_Lio_youi_app_screen_URLActivation$class__activate__Lio_youi_app_screen_URLActivation__s_concurrent_Future($$this);
  var f = new $c_Lio_youi_app_screen_UIScreen$$anonfun$activate$1().init___Lio_youi_app_screen_UIScreen($$this);
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
}
function $s_Lio_youi_app_screen_UIScreen$class__container__Lio_youi_app_screen_UIScreen__Lio_youi_component_Container($$this) {
  var c = new $c_Lio_youi_component_Container().init___Lorg_scalajs_dom_raw_HTMLElement(($m_Lio_youi_component_Container$(), $m_Lio_youi_component_extras_HTMLComponent$().create__T__Lorg_scalajs_dom_raw_Element("div")));
  var this$2 = c.id__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      return arg$outer.title__T()
    })
  })($$this));
  this$2.set__F0__V(value);
  return c
}
function $s_Lio_youi_app_screen_URLActivation$class__$$init$__Lio_youi_app_screen_URLActivation__V($$this) {
  var this$2 = $m_Lio_youi_History$().url$1;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(url$2) {
      var url = $as_Lio_youi_net_URL(url$2);
      $s_Lio_youi_app_screen_URLActivation$class__io$youi$app$screen$URLActivation$$validateURL__Lio_youi_app_screen_URLActivation__Lio_youi_net_URL__V(arg$outer, url)
    })
  })($$this));
  $m_Lio_youi_History$();
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$2, f, priority);
  var this$3 = $m_Lio_youi_History$().url$1;
  $s_Lio_youi_app_screen_URLActivation$class__io$youi$app$screen$URLActivation$$validateURL__Lio_youi_app_screen_URLActivation__Lio_youi_net_URL__V($$this, $as_Lio_youi_net_URL(this$3.state__Lreactify_State().value__O()))
}
function $s_Lio_youi_app_screen_URLActivation$class__activate__Lio_youi_app_screen_URLActivation__s_concurrent_Future($$this) {
  var this$1 = $s_Lio_youi_app_screen_Screen$class__activate__Lio_youi_app_screen_Screen__s_concurrent_Future($$this);
  var f = new $c_Lio_youi_app_screen_URLActivation$$anonfun$activate$1().init___Lio_youi_app_screen_URLActivation($$this);
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
}
function $s_Lio_youi_app_screen_URLActivation$class__io$youi$app$screen$URLActivation$$validateURL__Lio_youi_app_screen_URLActivation__Lio_youi_net_URL__V($$this, url) {
  if ($$this.matcher__Lio_youi_net_URLMatcher().matches__Lio_youi_net_URL__Z(url)) {
    var this$1 = $$this.state__Lreactify_Val();
    var x = this$1.state__Lreactify_State().value__O();
    var x$2 = $m_Lio_youi_app_screen_ScreenState$Activated$();
    if ((!((x !== null) && $objectEquals(x, x$2)))) {
      var this$2 = $m_Lio_youi_app_screen_ScreenManager$().apply__Lio_youi_app_screen_ScreenManager().active$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
        return (function() {
          return arg$outer
        })
      })($$this));
      this$2.set__F0__V(value)
    }
  }
}
function $s_Lio_youi_communication_Communication$class__$$init$__Lio_youi_communication_Communication__V($$this) {
  $$this.io$youi$communication$Communication$$undsetter$und$comm$und$eq__Lio_youi_communication_CommunicationInternal__V(new $c_Lio_youi_communication_CommunicationInternal().init___Lio_youi_communication_Communication($$this));
  $$this.comm__Lio_youi_communication_CommunicationInternal().init__V()
}
function $s_Lio_youi_component_AbstractContainer$class__init__Lio_youi_component_AbstractContainer__V($$this) {
  $s_Lio_youi_component_extras_HTMLComponent$class__init__Lio_youi_component_extras_HTMLComponent__V($$this);
  var v = $$this.children__Lreactify_Var();
  if ($as_sc_TraversableOnce(v.state__Lreactify_State().value__O()).nonEmpty__Z()) {
    var this$2 = $m_s_package$().Vector$1;
    var removed = this$2.NIL$6;
    var v$1 = $$this.children__Lreactify_Var();
    var added = $as_sci_Vector(v$1.state__Lreactify_State().value__O());
    $s_Lio_youi_component_AbstractContainer$class__childrenChanged__Lio_youi_component_AbstractContainer__sci_Vector__sci_Vector__V($$this, removed, added)
  };
  var this$5 = $$this.children__Lreactify_Var();
  var f = new $c_Lio_youi_component_AbstractContainer$$anonfun$init$2().init___Lio_youi_component_AbstractContainer($$this);
  $$this.children__Lreactify_Var();
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__changes__Lreactify_Reactive__F2__D__Lreactify_reaction_Reaction(this$5, f, priority);
  var this$7 = $$this.layout__Lreactify_Var();
  var f$1 = new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function(arg$outer) {
    return (function(x0$2$2, x1$2$2) {
      var x0$2 = $as_Lio_youi_layout_Layout(x0$2$2);
      var x1$2 = $as_Lio_youi_layout_Layout(x1$2$2);
      x0$2.disconnect__Lio_youi_component_Component__V(arg$outer);
      x1$2.connect__Lio_youi_component_Component__V(arg$outer)
    })
  })($$this));
  $$this.layout__Lreactify_Var();
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__changes__Lreactify_Reactive__F2__D__Lreactify_reaction_Reaction(this$7, f$1, priority$1);
  var qual$1 = $$this.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var().and__Lreactify_Var__Lreactify_Var($$this.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var());
  var x$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer$1) {
    return (function() {
      var v$2 = arg$outer$1.layout__Lreactify_Var();
      var jsx$2 = $as_Lio_youi_layout_Layout(v$2.state__Lreactify_State().value__O());
      var v$3 = arg$outer$1.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      var jsx$1 = $uD(v$3.state__Lreactify_State().value__O());
      var v$4 = arg$outer$1.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      jsx$2.resized__Lio_youi_component_Component__D__D__V(arg$outer$1, jsx$1, $uD(v$4.state__Lreactify_State().value__O()))
    })
  })($$this));
  var x$5 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__on__Lreactify_Reactive__F0__D__Lreactify_reaction_Reaction(qual$1, x$4, x$5)
}
function $s_Lio_youi_component_AbstractContainer$class__childrenChanged__Lio_youi_component_AbstractContainer__sci_Vector__sci_Vector__V($$this, removed, added) {
  var this$1 = removed.iterator__sci_VectorIterator();
  while (this$1.$$undhasNext$2) {
    var v1 = this$1.next__O();
    var x$2 = $as_Lio_youi_component_Component(v1);
    var this$2 = x$2.parent__Lreactify_Var();
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return $m_s_None$()
    }));
    this$2.set__F0__V(value)
  };
  var f = new $c_Lio_youi_component_AbstractContainer$$anonfun$childrenChanged$2().init___Lio_youi_component_AbstractContainer($$this);
  var this$3 = added.iterator__sci_VectorIterator();
  $s_sc_Iterator$class__foreach__sc_Iterator__F1__V(this$3, f);
  var v = $$this.layout__Lreactify_Var();
  $as_Lio_youi_layout_Layout(v.state__Lreactify_State().value__O()).childrenChanged__Lio_youi_component_Component__sci_Vector__sci_Vector__V($$this, removed, added)
}
function $s_Lio_youi_component_AbstractContainer$class__update__Lio_youi_component_AbstractContainer__D__V($$this, delta) {
  $s_Lio_youi_component_Component$class__update__Lio_youi_component_Component__D__V($$this, delta);
  var this$1 = $$this.children__Lreactify_Var();
  $as_sc_IterableLike(this$1.state__Lreactify_State().value__O()).foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(delta$1) {
    return (function(x$1$2) {
      var x$1 = $as_Lio_youi_component_Component(x$1$2);
      x$1.update__D__V(delta$1)
    })
  })(delta)))
}
function $s_Lio_youi_component_Component$class__io$youi$component$Component$$rendering__Lio_youi_component_Component__Lio_youi_LazyUpdate($$this) {
  var this$2 = new $c_s_concurrent_duration_package$DurationInt().init___I(1);
  var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
  var maxFrequency = $m_s_concurrent_duration_package$DurationInt$().durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration(this$2.scala$concurrent$duration$DurationInt$$n$1, unit);
  var frequency = $s_Lio_youi_Updates$class__rateLimited$default$2__Lio_youi_Updates__s_concurrent_duration_FiniteDuration($$this);
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      arg$outer.updateRendering__V()
    })
  })($$this));
  return $s_Lio_youi_Updates$class__rateLimited__Lio_youi_Updates__s_concurrent_duration_FiniteDuration__s_concurrent_duration_FiniteDuration__F0__Lio_youi_LazyUpdate($$this, maxFrequency, frequency, f)
}
function $s_Lio_youi_component_Component$class__io$youi$component$Component$$internalUpdatables__Lio_youi_component_Component__Lreactify_Val($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      return $m_sci_Nil$()
    })
  })($$this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
}
function $s_Lio_youi_component_Component$class__io$youi$component$Component$$transform__Lio_youi_component_Component__Lio_youi_LazyUpdate($$this) {
  var this$2 = new $c_s_concurrent_duration_package$DurationInt().init___I(1);
  var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
  var maxFrequency = $m_s_concurrent_duration_package$DurationInt$().durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration(this$2.scala$concurrent$duration$DurationInt$$n$1, unit);
  var frequency = $s_Lio_youi_Updates$class__rateLimited$default$2__Lio_youi_Updates__s_concurrent_duration_FiniteDuration($$this);
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      $s_Lio_youi_component_Component$class__updateTransform__Lio_youi_component_Component__V(arg$outer)
    })
  })($$this));
  return $s_Lio_youi_Updates$class__rateLimited__Lio_youi_Updates__s_concurrent_duration_FiniteDuration__s_concurrent_duration_FiniteDuration__F0__Lio_youi_LazyUpdate($$this, maxFrequency, frequency, f)
}
function $s_Lio_youi_component_Component$class__update__Lio_youi_component_Component__D__V($$this, delta) {
  if ((!$$this.io$youi$component$Component$$$undinitialized__Z())) {
    $$this.init__V();
    $$this.io$youi$component$Component$$$undinitialized$und$eq__Z__V(true)
  };
  $s_Lio_youi_Updates$class__update__Lio_youi_Updates__D__V($$this, delta);
  var this$1 = $$this.io$youi$component$Component$$internalUpdatables__Lreactify_Val();
  $s_Lio_youi_component_Component$class__updateUpdatables__p0__Lio_youi_component_Component__D__sci_List__V($$this, delta, $as_sci_List(this$1.state__Lreactify_State().value__O()))
}
function $s_Lio_youi_component_Component$class__updateTransform__Lio_youi_component_Component__V($$this) {
  var this$1 = $$this.size__Lio_youi_component_extras_HTMLComponentSize().measured__Lio_youi_component_extras_ComponentSize$measured$().width__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      return arg$outer.measuredWidth__D()
    })
  })($$this));
  this$1.set__F0__V(value);
  var this$2 = $$this.size__Lio_youi_component_extras_HTMLComponentSize().measured__Lio_youi_component_extras_ComponentSize$measured$().height__Lreactify_Var();
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer$1) {
    return (function() {
      return arg$outer$1.measuredHeight__D()
    })
  })($$this));
  this$2.set__F0__V(value$1)
}
function $s_Lio_youi_component_Component$class__id__Lio_youi_component_Component__Lreactify_Var($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var array = ["", ".", ""];
      var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
      var jsx$1 = arg$outer.componentType__T();
      var thiz = $m_Lio_youi_Unique$().apply__I__T__T(4, $m_Lio_youi_Unique$().Readable$1);
      var array$1 = [jsx$1, $as_T(thiz.toLowerCase())];
      return jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
    })
  })($$this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $s_Lio_youi_component_Component$class__parent__Lio_youi_component_Component__Lreactify_Var($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_s_None$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $s_Lio_youi_component_Component$class__updateUpdatables__p0__Lio_youi_component_Component__D__sci_List__V($$this, delta, updatables) {
  _updateUpdatables: while (true) {
    var this$1 = updatables;
    if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$1)) {
      $as_Lio_youi_Updatable(updatables.head__O()).update__D__V(delta);
      updatables = $as_sci_List(updatables.tail__O());
      continue _updateUpdatables
    };
    break
  }
}
function $s_Lio_youi_component_Component$class__$$init$__Lio_youi_component_Component__V($$this) {
  $$this.io$youi$component$Component$$$undinitialized$und$eq__Z__V(false);
  var value = new $c_Lio_youi_component_Component$$anonfun$1().init___Lio_youi_component_Component($$this);
  var name = $m_s_None$();
  $$this.io$youi$component$Component$$undsetter$und$visible$und$eq__Lreactify_Val__V(new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name));
  var this$3 = $$this.io$youi$component$Component$$transform__Lio_youi_LazyUpdate();
  this$3.dirty$1.value$1 = true
}
function $s_Lio_youi_component_extras_ComponentPosition$class__x__Lio_youi_component_extras_ComponentPosition__Lreactify_Var($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 0.0
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $s_Lio_youi_component_extras_ComponentPosition$class__y__Lio_youi_component_extras_ComponentPosition__Lreactify_Var($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 0.0
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $s_Lio_youi_component_extras_ComponentPosition$class__right__Lio_youi_component_extras_ComponentPosition__Lreactify_Dep($$this) {
  var owner = $$this.left__Lreactify_Var();
  var r2T = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(x$3$2) {
      var x$3 = $uD(x$3$2);
      var this$1 = arg$outer.component$1;
      var v = this$1.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      return (x$3 + $uD(v.state__Lreactify_State().value__O()))
    })
  })($$this));
  var t2R = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$1) {
    return (function(x$4$2) {
      var x$4 = $uD(x$4$2);
      var this$3 = arg$outer$1.component$1;
      var v$1 = this$3.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      return (x$4 - $uD(v$1.state__Lreactify_State().value__O()))
    })
  })($$this));
  return new $c_Lreactify_standard_StandardDep().init___s_Option__Lreactify_Var__F1__F1($m_s_None$(), owner, r2T, t2R)
}
function $s_Lio_youi_component_extras_ComponentPosition$class__z__Lio_youi_component_extras_ComponentPosition__Lreactify_Var($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 0
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $s_Lio_youi_component_extras_ComponentPosition$class__middle__Lio_youi_component_extras_ComponentPosition__Lreactify_Dep($$this) {
  var owner = $$this.top__Lreactify_Var();
  var r2T = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(x$5$2) {
      var x$5 = $uD(x$5$2);
      var this$1 = arg$outer.component$1;
      var v = this$1.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      return (x$5 + ($uD(v.state__Lreactify_State().value__O()) / 2.0))
    })
  })($$this));
  var t2R = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$1) {
    return (function(x$6$2) {
      var x$6 = $uD(x$6$2);
      var this$3 = arg$outer$1.component$1;
      var v$1 = this$3.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      return (x$6 - ($uD(v$1.state__Lreactify_State().value__O()) / 2.0))
    })
  })($$this));
  return new $c_Lreactify_standard_StandardDep().init___s_Option__Lreactify_Var__F1__F1($m_s_None$(), owner, r2T, t2R)
}
function $s_Lio_youi_component_extras_ComponentPosition$class__center__Lio_youi_component_extras_ComponentPosition__Lreactify_Dep($$this) {
  var owner = $$this.left__Lreactify_Var();
  var r2T = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(x$1$2) {
      var x$1 = $uD(x$1$2);
      var this$1 = arg$outer.component$1;
      var v = this$1.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      return (x$1 + ($uD(v.state__Lreactify_State().value__O()) / 2.0))
    })
  })($$this));
  var t2R = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$1) {
    return (function(x$2$2) {
      var x$2 = $uD(x$2$2);
      var this$3 = arg$outer$1.component$1;
      var v$1 = this$3.size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
      return (x$2 - ($uD(v$1.state__Lreactify_State().value__O()) / 2.0))
    })
  })($$this));
  return new $c_Lreactify_standard_StandardDep().init___s_Option__Lreactify_Var__F1__F1($m_s_None$(), owner, r2T, t2R)
}
function $s_Lio_youi_component_extras_ComponentPosition$class__bottom__Lio_youi_component_extras_ComponentPosition__Lreactify_Dep($$this) {
  var owner = $$this.top__Lreactify_Var();
  var r2T = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(x$7$2) {
      var x$7 = $uD(x$7$2);
      var this$1 = arg$outer.component$1;
      var v = this$1.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      return (x$7 + $uD(v.state__Lreactify_State().value__O()))
    })
  })($$this));
  var t2R = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$1) {
    return (function(x$8$2) {
      var x$8 = $uD(x$8$2);
      var this$3 = arg$outer$1.component$1;
      var v$1 = this$3.size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
      return (x$8 - $uD(v$1.state__Lreactify_State().value__O()))
    })
  })($$this));
  return new $c_Lreactify_standard_StandardDep().init___s_Option__Lreactify_Var__F1__F1($m_s_None$(), owner, r2T, t2R)
}
function $s_Lio_youi_component_extras_ComponentSize$class__width__Lio_youi_component_extras_ComponentSize__Lreactify_Var($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 0.0
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $s_Lio_youi_component_extras_ComponentSize$class__reset__Lio_youi_component_extras_ComponentSize__Z__Z__V($$this, width, height) {
  if (width) {
    $$this.width__Lreactify_Var().set__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
      return (function() {
        var this$1 = arg$outer.measured__Lio_youi_component_extras_ComponentSize$measured$().width__Lreactify_Var();
        return $uD(this$1.state__Lreactify_State().value__O())
      })
    })($$this)))
  };
  if (height) {
    $$this.height__Lreactify_Var().set__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer$1) {
      return (function() {
        var this$2 = arg$outer$1.measured__Lio_youi_component_extras_ComponentSize$measured$().height__Lreactify_Var();
        return $uD(this$2.state__Lreactify_State().value__O())
      })
    })($$this)))
  }
}
function $s_Lio_youi_component_extras_ComponentSize$class__height__Lio_youi_component_extras_ComponentSize__Lreactify_Var($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 0.0
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $s_Lio_youi_component_extras_ComponentSize$class__middle__Lio_youi_component_extras_ComponentSize__Lreactify_Val($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var v = arg$outer.height__Lreactify_Var();
      return ($uD(v.state__Lreactify_State().value__O()) / 2.0)
    })
  })($$this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
}
function $s_Lio_youi_component_extras_ComponentSize$class__center__Lio_youi_component_extras_ComponentSize__Lreactify_Val($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var v = arg$outer.width__Lreactify_Var();
      return ($uD(v.state__Lreactify_State().value__O()) / 2.0)
    })
  })($$this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
}
function $s_Lio_youi_component_extras_ComponentSize$class__$$colon$eq__Lio_youi_component_extras_ComponentSize__F0__V($$this, size) {
  var this$1 = $$this.width__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(size$1) {
    return (function() {
      return $as_Lio_youi_spatial_Size(size$1.apply__O()).width$1
    })
  })(size));
  this$1.set__F0__V(value);
  var this$2 = $$this.height__Lreactify_Var();
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(size$1$1) {
    return (function() {
      return $as_Lio_youi_spatial_Size(size$1$1.apply__O()).height$1
    })
  })(size));
  this$2.set__F0__V(value$1)
}
function $s_Lio_youi_component_extras_HTMLComponent$class__$$init$__Lio_youi_component_extras_HTMLComponent__V($$this) {
  $$this.io$youi$component$extras$HTMLComponent$$undsetter$und$e$und$eq__Lio_youi_component_extras_HTMLExtras__V(new $c_Lio_youi_component_extras_HTMLExtras().init___Lorg_scalajs_dom_raw_HTMLElement($$this.element__Lorg_scalajs_dom_raw_HTMLElement()));
  var this$1 = $m_s_Option$().apply__O__s_Option($as_T($$this.element__Lorg_scalajs_dom_raw_HTMLElement().getAttribute("id")));
  if (($$this === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  };
  if ((!this$1.isEmpty__Z())) {
    var v1 = this$1.get__O();
    var x0$1 = $as_T(v1);
    if ((x0$1 !== "")) {
      var this$2 = $$this.id__Lreactify_Var();
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(x1$1) {
        return (function() {
          return x1$1
        })
      })(x0$1));
      this$2.set__F0__V(value)
    }
  };
  $$this.io$youi$component$extras$HTMLComponent$$undsetter$und$event$und$eq__Lio_youi_event_EventSupport__V(new $c_Lio_youi_event_HTMLEvents().init___Lio_youi_component_Component__Lorg_scalajs_dom_raw_HTMLElement($$this, $$this.element__Lorg_scalajs_dom_raw_HTMLElement()))
}
function $s_Lio_youi_component_extras_HTMLComponent$class__measuredWidth__Lio_youi_component_extras_HTMLComponent__D($$this) {
  return $m_Lio_youi_util_Measurer$().measure__Lorg_scalajs_dom_raw_HTMLElement__Lio_youi_spatial_Size($$this.element__Lorg_scalajs_dom_raw_HTMLElement()).width$1
}
function $s_Lio_youi_component_extras_HTMLComponent$class__measuredHeight__Lio_youi_component_extras_HTMLComponent__D($$this) {
  return $m_Lio_youi_util_Measurer$().measure__Lorg_scalajs_dom_raw_HTMLElement__Lio_youi_spatial_Size($$this.element__Lorg_scalajs_dom_raw_HTMLElement()).height$1
}
function $s_Lio_youi_component_extras_HTMLComponent$class__init__Lio_youi_component_extras_HTMLComponent__V($$this) {
  var this$4 = $$this.id__Lreactify_Var();
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(s$2) {
      $as_T(s$2);
      var jsx$1 = arg$outer.element__Lorg_scalajs_dom_raw_HTMLElement();
      var this$1 = arg$outer.id__Lreactify_Var();
      jsx$1.setAttribute("data-youi-id", $as_T(this$1.state__Lreactify_State().value__O()));
      var jsx$2 = arg$outer.element__Lorg_scalajs_dom_raw_HTMLElement();
      var this$2 = arg$outer.id__Lreactify_Var();
      jsx$2.setAttribute("id", $as_T(this$2.state__Lreactify_State().value__O()))
    })
  })($$this));
  $$this.id__Lreactify_Var();
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Val$class__attachAndFire__Lreactify_Val__F1__D__Lreactify_reaction_Reaction(this$4, f, priority);
  var x$2 = $m_Lio_youi_ui$();
  if ((!(($$this !== null) && ($$this === x$2)))) {
    var this$11 = $$this.parent__Lreactify_Var();
    var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$1) {
      return (function(x0$2$2) {
        var x0$2 = $as_s_Option(x0$2$2);
        if ($is_s_Some(x0$2)) {
          var x2 = $as_s_Some(x0$2);
          var p = $as_Lio_youi_component_Component(x2.x$2);
          var x1$2 = arg$outer$1.sibling__Lio_youi_component_Component$sibling$().previous__s_Option();
          if ($is_s_Some(x1$2)) {
            var x2$2 = $as_s_Some(x1$2);
            var previous = $as_Lio_youi_component_Component(x2$2.x$2);
            $m_Lio_youi_component_extras_HTMLComponent$();
            var previousElement = $as_Lio_youi_component_extras_HTMLComponent(previous).element__Lorg_scalajs_dom_raw_HTMLElement();
            $m_Lio_youi_dom$();
            var e = arg$outer$1.element__Lorg_scalajs_dom_raw_HTMLElement();
            new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(e).insertAfter__Lorg_scalajs_dom_raw_Element__V(previousElement)
          } else {
            var x = $m_s_None$();
            if ((!(x === x1$2))) {
              throw new $c_s_MatchError().init___O(x1$2)
            };
            $m_Lio_youi_component_extras_HTMLComponent$();
            var parent = $as_Lio_youi_component_extras_HTMLComponent(p).element__Lorg_scalajs_dom_raw_HTMLElement();
            $m_Lio_youi_dom$();
            var e$1 = arg$outer$1.element__Lorg_scalajs_dom_raw_HTMLElement();
            new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(e$1).insertFirst__Lorg_scalajs_dom_raw_Element__V(parent)
          }
        } else {
          var x$4 = $m_s_None$();
          if ((x$4 === x0$2)) {
            $m_Lio_youi_dom$();
            var e$2 = arg$outer$1.element__Lorg_scalajs_dom_raw_HTMLElement();
            new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(e$2).remove__V()
          } else {
            throw new $c_s_MatchError().init___O(x0$2)
          }
        }
      })
    })($$this));
    $$this.parent__Lreactify_Var();
    var priority$1 = $m_Lreactify_Priority$().Normal$1;
    $s_Lreactify_Val$class__attachAndFire__Lreactify_Val__F1__D__Lreactify_reaction_Reaction(this$11, f$1, priority$1)
  }
}
function $s_Lio_youi_drawable_Group$class__modified__Lio_youi_drawable_Group__Lreactify_Var($$this) {
  var value = new $c_Lio_youi_drawable_Group$$anonfun$modified$1().init___Lio_youi_drawable_Group($$this);
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $s_Lio_youi_drawable_Group$class__drawRecursive__p0__Lio_youi_drawable_Group__Lio_youi_drawable_Context__D__D__sci_List__V($$this, context, x, y, elements) {
  _drawRecursive: while (true) {
    var this$1 = elements;
    if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$1)) {
      $as_Lio_youi_drawable_Drawable(elements.head__O()).draw__Lio_youi_drawable_Context__D__D__V(context, x, y);
      elements = $as_sci_List(elements.tail__O());
      continue _drawRecursive
    };
    break
  }
}
function $s_Lio_youi_drawable_Transformation$class__$$init$__Lio_youi_drawable_Transformation__V($$this) {
  var this$2 = $$this.modified__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var v = arg$outer.d$1$1.modified__Lreactify_Var();
      return $uJ(v.state__Lreactify_State().value__O())
    })
  })($$this));
  this$2.set__F0__V(value)
}
function $s_Lio_youi_drawable_Transformation$class__draw__Lio_youi_drawable_Transformation__Lio_youi_drawable_Context__D__D__V($$this, context, x, y) {
  context.save__V();
  $$this.transform__Lio_youi_drawable_Context__V(context);
  $$this.d$1$1.draw__Lio_youi_drawable_Context__D__D__V(context, x, y);
  context.restore__V()
}
function $is_Lio_youi_easing_Easing(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_easing_Easing)))
}
function $as_Lio_youi_easing_Easing(obj) {
  return (($is_Lio_youi_easing_Easing(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.easing.Easing"))
}
function $isArrayOf_Lio_youi_easing_Easing(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_easing_Easing)))
}
function $asArrayOf_Lio_youi_easing_Easing(obj, depth) {
  return (($isArrayOf_Lio_youi_easing_Easing(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.easing.Easing;", depth))
}
function $s_Lio_youi_event_EventSupport$class__link__Lio_youi_event_EventSupport__T__V($$this, path) {
  var this$1 = $m_Lio_youi_History$().url$1;
  var url = $as_Lio_youi_net_URL(this$1.state__Lreactify_State().value__O()).withPart__T__Lio_youi_net_URL(path);
  $s_Lio_youi_event_EventSupport$class__link__Lio_youi_event_EventSupport__Lio_youi_net_URL__V($$this, url)
}
function $s_Lio_youi_event_EventSupport$class__link__Lio_youi_event_EventSupport__Lio_youi_net_URL__V($$this, url) {
  $$this.component$1.cursor__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_Cursor$Pointer$()
  })));
  var this$2 = $$this.click__Lreactify_Channel();
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(url$1) {
    return (function() {
      $m_Lio_youi_History$().push__Lio_youi_net_URL__sjs_js_Any__V(url$1, ($m_Lio_youi_History$(), null))
    })
  })(url));
  $$this.click__Lreactify_Channel();
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__on__Lreactify_Reactive__F0__D__Lreactify_reaction_Reaction(this$2, f, priority)
}
function $s_Lio_youi_example_ClientExampleCommunication$class__navigateTo__Lio_youi_example_ClientExampleCommunication__T__Z__s_concurrent_Future($$this, url, push) {
  var jsx$2 = $m_s_concurrent_Future$();
  if (push) {
    $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.pushState(url, url, url);
    var jsx$1 = (void 0)
  } else {
    $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.href = url;
    var jsx$1 = (void 0)
  };
  return jsx$2.successful__O__s_concurrent_Future(jsx$1)
}
function $s_Lio_youi_example_ClientExampleCommunication$class__url__Lio_youi_example_ClientExampleCommunication__s_concurrent_Future($$this) {
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future($as_T($m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.href))
}
function $s_Lio_youi_example_ClientExampleCommunication$class__show__Lio_youi_example_ClientExampleCommunication__T__s_concurrent_Future($$this, message) {
  $m_s_concurrent_Future$();
  var body = new $c_Lio_youi_example_ClientExampleCommunication$$anonfun$show$1().init___Lio_youi_example_ClientExampleCommunication__T($$this, message);
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $m_s_concurrent_impl_Future$().apply__F0__s_concurrent_ExecutionContext__s_concurrent_Future(body, executor)
}
function $s_Lio_youi_example_ExampleApplication$class__$$init$__Lio_youi_example_ExampleApplication__V($$this) {
  $$this.example$1 = new $c_Lio_youi_app_CommunicationManager().init___Lio_youi_app_ApplicationConnectivity__F1($$this.connectivity$1, new $c_Lio_youi_example_ExampleApplication$$anonfun$1().init___Lio_youi_example_ExampleApplication($$this));
  $$this.simple$1 = new $c_Lio_youi_app_CommunicationManager().init___Lio_youi_app_ApplicationConnectivity__F1($$this.connectivity$1, new $c_Lio_youi_example_ExampleApplication$$anonfun$5().init___Lio_youi_example_ExampleApplication($$this))
}
function $s_Lio_youi_example_ExampleCommunication$class__$$init$__Lio_youi_example_ExampleCommunication__V($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_s_None$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  var v = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var modifying = new $c_Lio_youi_example_ExampleCommunication$$anon$1().init___Lio_youi_example_ExampleCommunication($$this);
  var f = new $c_Lio_youi_example_ExampleCommunication$$anonfun$2().init___Lio_youi_example_ExampleCommunication__jl_ThreadLocal($$this, modifying);
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(v, f, priority);
  var this$5 = $$this.comm$1.receive$1;
  var f$1 = new $c_Lio_youi_example_ExampleCommunication$$anonfun$3().init___Lio_youi_example_ExampleCommunication__Lreactify_Var__jl_ThreadLocal($$this, v, modifying);
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$5, f$1, priority$1);
  $$this.name$1 = v;
  var this$7 = $$this.name$1;
  var f$2 = new $c_Lio_youi_example_ExampleCommunication$$anonfun$4().init___Lio_youi_example_ExampleCommunication($$this);
  var priority$2 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$7, f$2, priority$2)
}
function $s_Lio_youi_example_screen_ExampleScreen$class__s__Lio_youi_example_screen_ExampleScreen__Lio_youi_example_SimpleCommunication($$this) {
  var jsx$1 = $m_Lio_youi_example_ClientExampleApplication$().simple$1;
  var this$1 = $m_Lio_youi_example_ClientExampleApplication$();
  var connectivity = $m_Lio_youi_example_ClientExampleApplication$().connectivity$1;
  return $as_Lio_youi_example_SimpleCommunication(jsx$1.apply__Lio_youi_http_Connection__Lio_youi_communication_Communication($as_Lio_youi_app_ClientConnectivity(this$1.io$youi$app$ClientApplication$$configuredConnectivity$1.apply__O__O(connectivity)).connection$1))
}
function $s_Lio_youi_example_screen_ExampleScreen$class__c__Lio_youi_example_screen_ExampleScreen__Lio_youi_example_ExampleCommunication($$this) {
  var jsx$1 = $m_Lio_youi_example_ClientExampleApplication$().example$1;
  var this$1 = $m_Lio_youi_example_ClientExampleApplication$();
  var connectivity = $m_Lio_youi_example_ClientExampleApplication$().connectivity$1;
  return $as_Lio_youi_example_ExampleCommunication(jsx$1.apply__Lio_youi_http_Connection__Lio_youi_communication_Communication($as_Lio_youi_app_ClientConnectivity(this$1.io$youi$app$ClientApplication$$configuredConnectivity$1.apply__O__O(connectivity)).connection$1))
}
function $s_Lio_youi_example_screen_ExampleScreen$class__activate__Lio_youi_example_screen_ExampleScreen__s_concurrent_Future($$this) {
  var this$1 = $s_Lio_youi_app_screen_ContentScreen$class__activate__Lio_youi_app_screen_ContentScreen__s_concurrent_Future($$this);
  var f = new $c_Lio_youi_example_screen_ExampleScreen$$anonfun$activate$1().init___Lio_youi_example_screen_ExampleScreen($$this);
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
}
function $s_Lio_youi_example_screen_UIExampleScreen$class__init__Lio_youi_example_screen_UIExampleScreen__s_concurrent_Future($$this) {
  var this$1 = $s_Lio_youi_app_screen_UIScreen$class__init__Lio_youi_app_screen_UIScreen__s_concurrent_Future($$this);
  var f = new $c_Lio_youi_example_screen_UIExampleScreen$$anonfun$init$1().init___Lio_youi_example_screen_UIExampleScreen($$this);
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
}
function $is_Lio_youi_font_GoogleFont(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_font_GoogleFont)))
}
function $as_Lio_youi_font_GoogleFont(obj) {
  return (($is_Lio_youi_font_GoogleFont(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.font.GoogleFont"))
}
function $isArrayOf_Lio_youi_font_GoogleFont(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_font_GoogleFont)))
}
function $asArrayOf_Lio_youi_font_GoogleFont(obj, depth) {
  return (($isArrayOf_Lio_youi_font_GoogleFont(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.font.GoogleFont;", depth))
}
function $s_Lio_youi_image_CanvasImage$class__toDataURL__Lio_youi_image_CanvasImage__s_concurrent_Future($$this) {
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future($as_T($$this.canvas$1.toDataURL("image/png")))
}
function $s_Lio_youi_image_CanvasImage$class__$$init$__Lio_youi_image_CanvasImage__V($$this) {
  $$this.width$1 = $uI($$this.canvas$1.width);
  $$this.height$1 = $uI($$this.canvas$1.height)
}
function $s_Lio_youi_image_Image$class__clip__Lio_youi_image_Image__D__D__D__D__s_concurrent_Future($$this, x1, y1, x2, y2) {
  var w = (x2 - x1);
  var h = (y2 - y1);
  var this$1 = $m_Lio_youi_util_CanvasPool$();
  $m_Lio_youi_util_CanvasPool$();
  var ratio = 1.0;
  if (($$this === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  };
  var t = $s_Lio_youi_util_ObjectPool$class__apply__Lio_youi_util_ObjectPool__O(this$1);
  try {
    $m_Lio_youi_util_CanvasPool$().io$youi$util$CanvasPool$$update__Lorg_scalajs_dom_raw_HTMLCanvasElement__D__D__Lorg_scalajs_dom_raw_HTMLCanvasElement(t, (w * ratio), (h * ratio));
    var context = new $c_Lio_youi_drawable_Context().init___Lorg_scalajs_dom_raw_HTMLCanvasElement__F0(t, new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      var v = $m_Lio_youi_ui$().ratio__Lreactify_Var();
      return $uD(v.state__Lreactify_State().value__O())
    })));
    context.translate__D__D__V((-x1), (-y1));
    $$this.draw__Lio_youi_drawable_Context__D__D__D__D__V(context, 0.0, 0.0, $$this.width__D(), $$this.height__D());
    var dataURL = $as_T(t.toDataURL("image/png"))
  } finally {
    $s_Lio_youi_util_ObjectPool$class__restore__Lio_youi_util_ObjectPool__O__V(this$1, t)
  };
  return $m_Lio_youi_image_Image$().apply__T__s_concurrent_Future(dataURL)
}
function $is_Lio_youi_layout_GridLayout$Config(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_layout_GridLayout$Config)))
}
function $as_Lio_youi_layout_GridLayout$Config(obj) {
  return (($is_Lio_youi_layout_GridLayout$Config(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.layout.GridLayout$Config"))
}
function $isArrayOf_Lio_youi_layout_GridLayout$Config(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_layout_GridLayout$Config)))
}
function $asArrayOf_Lio_youi_layout_GridLayout$Config(obj, depth) {
  return (($isArrayOf_Lio_youi_layout_GridLayout$Config(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.layout.GridLayout$Config;", depth))
}
function $s_Lio_youi_layout_GridLayout$Config$class__prop__Lio_youi_layout_GridLayout$Config__F1__Lreactify_Var($$this, lookup) {
  var value = new $c_Lio_youi_layout_GridLayout$Config$$anonfun$29().init___Lio_youi_layout_GridLayout$Config__F1($$this, lookup);
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  var v = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      arg$outer.io$youi$layout$GridLayout$Config$$$outer__Lio_youi_layout_GridLayout().updateAll__V()
    })
  })($$this));
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__on__Lreactify_Reactive__F0__D__Lreactify_reaction_Reaction(v, f, priority);
  return v
}
function $is_Lio_youi_layout_Layout(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_layout_Layout)))
}
function $as_Lio_youi_layout_Layout(obj) {
  return (($is_Lio_youi_layout_Layout(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.layout.Layout"))
}
function $isArrayOf_Lio_youi_layout_Layout(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_layout_Layout)))
}
function $asArrayOf_Lio_youi_layout_Layout(obj, depth) {
  return (($isArrayOf_Lio_youi_layout_Layout(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.layout.Layout;", depth))
}
function $is_Lio_youi_net_PathPart(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_net_PathPart)))
}
function $as_Lio_youi_net_PathPart(obj) {
  return (($is_Lio_youi_net_PathPart(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.net.PathPart"))
}
function $isArrayOf_Lio_youi_net_PathPart(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_net_PathPart)))
}
function $asArrayOf_Lio_youi_net_PathPart(obj, depth) {
  return (($isArrayOf_Lio_youi_net_PathPart(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.net.PathPart;", depth))
}
function $is_Lio_youi_paint_Border(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_paint_Border)))
}
function $as_Lio_youi_paint_Border(obj) {
  return (($is_Lio_youi_paint_Border(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.paint.Border"))
}
function $isArrayOf_Lio_youi_paint_Border(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_paint_Border)))
}
function $asArrayOf_Lio_youi_paint_Border(obj, depth) {
  return (($isArrayOf_Lio_youi_paint_Border(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.paint.Border;", depth))
}
function $s_Lio_youi_paint_Border$class__height__Lio_youi_paint_Border__D($$this) {
  return ($$this.stroke$1.lineWidth$1 + $$this.stroke$1.lineWidth$1)
}
function $s_Lio_youi_paint_Border$class__width__Lio_youi_paint_Border__D($$this) {
  return ($$this.stroke$1.lineWidth$1 + $$this.stroke$1.lineWidth$1)
}
function $s_Lio_youi_paint_Paint$class__nonEmpty__Lio_youi_paint_Paint__Z($$this) {
  return (!$$this.isEmpty__Z())
}
function $s_Lio_youi_spatial_BoundingBox$class__adjustX__Lio_youi_spatial_BoundingBox__D($$this) {
  return (-$$this.x1__D())
}
function $s_Lio_youi_spatial_BoundingBox$class__height__Lio_youi_spatial_BoundingBox__D($$this) {
  return ($$this.y2__D() - $$this.y1__D())
}
function $s_Lio_youi_spatial_BoundingBox$class__adjustY__Lio_youi_spatial_BoundingBox__D($$this) {
  return ($s_Lio_youi_spatial_BoundingBox$class__height__Lio_youi_spatial_BoundingBox__D($$this) - $$this.y2__D())
}
function $s_Lio_youi_spatial_BoundingBox$class__toString__Lio_youi_spatial_BoundingBox__T($$this) {
  var array = ["BoundingBox(x1: ", ", y1: ", ", x2: ", ", y2: ", ", adjustX: ", ", adjustY: ", ", width: ", ", height: ", ")"];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [$$this.x1__D(), $$this.y1__D(), $$this.x2__D(), $$this.y2__D(), $s_Lio_youi_spatial_BoundingBox$class__adjustX__Lio_youi_spatial_BoundingBox__D($$this), $s_Lio_youi_spatial_BoundingBox$class__adjustY__Lio_youi_spatial_BoundingBox__D($$this), $s_Lio_youi_spatial_BoundingBox$class__width__Lio_youi_spatial_BoundingBox__D($$this), $s_Lio_youi_spatial_BoundingBox$class__height__Lio_youi_spatial_BoundingBox__D($$this)];
  return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
}
function $s_Lio_youi_spatial_BoundingBox$class__width__Lio_youi_spatial_BoundingBox__D($$this) {
  return ($$this.x2__D() - $$this.x1__D())
}
function $s_Lio_youi_spatial_Point$class__toString__Lio_youi_spatial_Point__T($$this) {
  var array = ["Point(x: ", ", y: ", ")"];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [$$this.x$1, $$this.y$1];
  return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
}
function $s_Lio_youi_spatial_Point$class__equals__Lio_youi_spatial_Point__O__Z($$this, obj) {
  if ($is_Lio_youi_spatial_Point(obj)) {
    var x2 = $as_Lio_youi_spatial_Point(obj);
    var d = $$this.x$1;
    var other = x2.x$1;
    var this$3 = $m_Lio_youi_spatial_package$().tolerance__F2();
    if ($uZ(this$3.apply__O__O__O(d, other))) {
      var d$1 = $$this.y$1;
      var other$1 = x2.y$1;
      var this$6 = $m_Lio_youi_spatial_package$().tolerance__F2();
      return $uZ(this$6.apply__O__O__O(d$1, other$1))
    } else {
      return false
    }
  } else {
    return false
  }
}
function $s_Lio_youi_spatial_Size$class__equals__Lio_youi_spatial_Size__O__Z($$this, obj) {
  if ($is_Lio_youi_spatial_Size(obj)) {
    var x2 = $as_Lio_youi_spatial_Size(obj);
    return (($$this.width$1 === x2.width$1) && ($$this.height$1 === x2.height$1))
  } else {
    return false
  }
}
function $s_Lio_youi_spatial_Size$class__toString__Lio_youi_spatial_Size__T($$this) {
  var array = ["Size(width: ", ", height: ", ")"];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [$$this.width$1, $$this.height$1];
  return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
}
function $is_Lio_youi_style_Position(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_Position)))
}
function $as_Lio_youi_style_Position(obj) {
  return (($is_Lio_youi_style_Position(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.Position"))
}
function $isArrayOf_Lio_youi_style_Position(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_Position)))
}
function $asArrayOf_Lio_youi_style_Position(obj, depth) {
  return (($isArrayOf_Lio_youi_style_Position(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.Position;", depth))
}
function $s_Lio_youi_task_DurationTask$class__update__Lio_youi_task_DurationTask__D__Z__Lio_youi_task_Conclusion($$this, delta, reset) {
  if (reset) {
    $$this.io$youi$task$DurationTask$$elapsed$und$eq__D__V(0.0)
  };
  $$this.io$youi$task$DurationTask$$elapsed$und$eq__D__V(($$this.io$youi$task$DurationTask$$elapsed__D() + delta));
  var this$1 = $$this.time__s_concurrent_duration_FiniteDuration();
  var t = this$1.unit$2.toMillis__J__J(this$1.length$2);
  var lo = t.lo$2;
  var hi = t.hi$2;
  var duration = ($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo, hi) / 1000.0);
  var x = ($$this.io$youi$task$DurationTask$$elapsed__D() / duration);
  var progress = $uD($g.Math.min(x, 1.0));
  $$this.act__D__D__D__Z__V(delta, $$this.io$youi$task$DurationTask$$elapsed__D(), progress, reset);
  return (($$this.io$youi$task$DurationTask$$elapsed__D() >= duration) ? $m_Lio_youi_task_Conclusion$Finished$() : $m_Lio_youi_task_Conclusion$Continue$())
}
function $is_Lio_youi_task_Task(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_task_Task)))
}
function $as_Lio_youi_task_Task(obj) {
  return (($is_Lio_youi_task_Task(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.task.Task"))
}
function $isArrayOf_Lio_youi_task_Task(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_task_Task)))
}
function $asArrayOf_Lio_youi_task_Task(obj, depth) {
  return (($isArrayOf_Lio_youi_task_Task(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.task.Task;", depth))
}
function $s_Lio_youi_task_Task$class__andThen__Lio_youi_task_Task__Lio_youi_task_Task__Lio_youi_task_Task($$this, that) {
  $m_sci_List$();
  var array = [$$this, that];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var this$4 = $m_sci_List$();
  var cbf = this$4.ReusableCBFInstance$2;
  return new $c_Lio_youi_task_Sequential().init___sci_List($as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)))
}
function $s_Lio_youi_task_TaskSupport$class__start__Lio_youi_task_TaskSupport__Lio_youi_task_Task__Lio_youi_task_TaskInstance($$this, task) {
  var instance = new $c_Lio_youi_task_TaskInstance().init___Lio_youi_task_Task__Lio_youi_Updates(task, $$this);
  instance.start__s_concurrent_Future();
  return instance
}
function $s_Lio_youi_theme_CanvasComponentTheme$class__$$init$__Lio_youi_theme_CanvasComponentTheme__V($$this) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    var v = $m_Lio_youi_ui$().ratio__Lreactify_Var();
    return $uD(v.state__Lreactify_State().value__O())
  }));
  var connect = $m_s_None$();
  $$this.io$youi$theme$CanvasComponentTheme$$undsetter$und$ratio$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "ratio", $default, connect, true, true, false))
}
function $s_Lio_youi_theme_ComponentTheme$class__$$init$__Lio_youi_theme_ComponentTheme__V($$this) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_Cursor$Default$()
  }));
  var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_Cursor$());
  $$this.io$youi$theme$ComponentTheme$$undsetter$und$cursor$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "cursor", $default, connect, false, false, false));
  var $default$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return true
  }));
  var connect$1 = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__stringifyBoolean__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify($$this));
  $$this.io$youi$theme$ComponentTheme$$undsetter$und$interactive$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "interactive", $default$1, connect$1, false, false, false));
  var $default$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_style_Visibility$Visible$()
  }));
  var connect$2 = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_Visibility$());
  $$this.io$youi$theme$ComponentTheme$$undsetter$und$visibility$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "visibility", $default$2, connect$2, true, false, false));
  var x$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 1.0
  }));
  var x$3 = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__stringifyDouble__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify($$this));
  $$this.io$youi$theme$ComponentTheme$$undsetter$und$opacity$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "opacity", x$2, x$3, false, true, false));
  var x$8 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_paint_NoPaint$()
  }));
  var x$9 = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_paint_Paint$());
  $$this.io$youi$theme$ComponentTheme$$undsetter$und$background$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "background", x$8, x$9, false, true, false))
}
function $s_Lio_youi_theme_DrawableComponentTheme$class__border__Lio_youi_theme_DrawableComponentTheme__Lio_youi_theme_StyleProp($$this) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_paint_Border$().empty__Lio_youi_paint_Border()
  }));
  var connect = $m_s_None$();
  return $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "border", $default, connect, true, true, false)
}
function $s_Lio_youi_theme_HTMLComponentTheme$class__rotation__Lio_youi_theme_HTMLComponentTheme__Lio_youi_theme_StyleProp($$this) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 0.0
  }));
  var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option(new $c_Lio_youi_theme_HTMLComponentTheme$$anon$1().init___Lio_youi_theme_HTMLComponentTheme($$this));
  return $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "transform", $default, connect, true, false, false)
}
function $s_Lio_youi_theme_StringifyImplicits$class__stringifyDouble__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify($$this) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(d$2) {
    var d = $uD(d$2);
    return new $c_s_Some().init___O(("" + d))
  }));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(s$2) {
    var s = $as_T(s$2);
    try {
      var this$3 = new $c_sci_StringOps().init___T(s);
      var jsx$1 = $m_jl_Double$();
      var $$this$1 = this$3.repr$1;
      return new $c_s_Some().init___O(jsx$1.parseDouble__T__D($$this$1))
    } catch (e) {
      var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
      if ((e$2 !== null)) {
        return $m_s_None$()
      } else {
        throw e
      }
    }
  }));
  return new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from)
}
function $s_Lio_youi_theme_StringifyImplicits$class__$$init$__Lio_youi_theme_StringifyImplicits__V($$this) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(c$2) {
    var t = $as_Lio_youi_Color(c$2).value$1;
    var lo = t.lo$2;
    var hi = t.hi$2;
    var this$3 = new $c_Lio_youi_paint_ColorPaint().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo, hi));
    return new $c_s_Some().init___O($m_Lio_youi_Color$().toRGBA$extension__J__T(this$3.color$1))
  }));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(value$2) {
    var value = $as_T(value$2);
    return $m_Lio_youi_Color$().unapply__T__s_Option(value)
  }));
  $$this.io$youi$theme$StringifyImplicits$$undsetter$und$stringifyColor$und$eq__Lio_youi_theme_Stringify__V(new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from))
}
function $s_Lio_youi_theme_StringifyImplicits$class__stringifyBoolean__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify($$this) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(b$2) {
    var b = $uZ(b$2);
    return new $c_s_Some().init___O(("" + b))
  }));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x0$1$2) {
    var x0$1 = $as_T(x0$1$2);
    return ((x0$1 === "true") ? new $c_s_Some().init___O(true) : ((x0$1 === "false") ? new $c_s_Some().init___O(false) : $m_s_None$()))
  }));
  return new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from)
}
function $s_Lio_youi_theme_StringifyImplicits$class__stringifyString__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify($$this) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$1$2) {
    var x$1 = $as_T(x$1$2);
    return new $c_s_Some().init___O(x$1)
  }));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$2$2) {
    var x$2 = $as_T(x$2$2);
    return new $c_s_Some().init___O(x$2)
  }));
  return new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from)
}
function $s_Lio_youi_theme_StringifyImplicits$class__pixels__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify($$this) {
  var to = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(d$2) {
    var d = $uD(d$2);
    var array = ["", "px"];
    var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var array$1 = [d];
    return new $c_s_Some().init___O(jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1)))
  }));
  var from = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(s$2) {
    var s = $as_T(s$2);
    try {
      var this$6 = new $c_sci_StringOps().init___T(s);
      var x = $s_sci_StringLike$class__replaceAllLiterally__sci_StringLike__T__T__T(this$6, "px", "");
      var this$8 = new $c_sci_StringOps().init___T(x);
      var jsx$2 = $m_jl_Double$();
      var $$this$1 = this$8.repr$1;
      return new $c_s_Some().init___O(jsx$2.parseDouble__T__D($$this$1))
    } catch (e) {
      var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
      if ((e$2 !== null)) {
        return $m_s_None$()
      } else {
        throw e
      }
    }
  }));
  return new $c_Lio_youi_theme_Stringify$$anon$1().init___F1__F1(to, from)
}
function $is_Lio_youi_theme_StyleConnect(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_theme_StyleConnect)))
}
function $as_Lio_youi_theme_StyleConnect(obj) {
  return (($is_Lio_youi_theme_StyleConnect(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.theme.StyleConnect"))
}
function $isArrayOf_Lio_youi_theme_StyleConnect(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_theme_StyleConnect)))
}
function $asArrayOf_Lio_youi_theme_StyleConnect(obj, depth) {
  return (($isArrayOf_Lio_youi_theme_StyleConnect(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.theme.StyleConnect;", depth))
}
function $s_Lio_youi_theme_TextViewTheme$class__value__Lio_youi_theme_TextViewTheme__Lio_youi_theme_StyleProp($$this) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return ""
  }));
  var connect = $m_Lio_youi_theme_StyleConnect$().content__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__stringifyString__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify($$this));
  return $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "value", $default, connect, true, false, false)
}
function $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, name, $default, connect, updatesTransform, updatesRendering, ignoreParent) {
  var prop = new $c_Lio_youi_theme_StyleProp().init___T__Lreactify_Var__F0(name, $$this.parentTheme__Lreactify_Var(), $default);
  $$this.io$youi$theme$Theme$$store__Lio_youi_MapStore().update__T__O__V(name, prop);
  if ((!connect.isEmpty__Z())) {
    var arg1 = connect.get__O();
    var x$1 = $as_Lio_youi_theme_StyleConnect(arg1);
    x$1.init__Lio_youi_theme_Theme__Lio_youi_theme_StyleProp__T__V($$this, prop, name)
  };
  if ((updatesTransform || updatesRendering)) {
    var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer, updatesTransform$1, updatesRendering$1) {
      return (function(x$2$2) {
        if (updatesTransform$1) {
          arg$outer.invalidateTransform__V()
        };
        if (updatesRendering$1) {
          arg$outer.invalidateRendering__V()
        }
      })
    })($$this, updatesTransform, updatesRendering));
    var priority = $m_Lreactify_Priority$().Normal$1;
    var this$1 = prop.value$1;
    $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$1, f, priority)
  };
  return prop
}
function $s_Lio_youi_theme_Theme$class__parentTheme__Lio_youi_theme_Theme__Lreactify_Var($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      return arg$outer.defaultParentTheme__Lio_youi_theme_Theme()
    })
  })($$this));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name)
}
function $s_Lio_youi_theme_Theme$class__$$init$__Lio_youi_theme_Theme__V($$this) {
  $$this.io$youi$theme$Theme$$undsetter$und$io$youi$theme$Theme$$store$und$eq__Lio_youi_MapStore__V(new $c_Lio_youi_MapStore().init___sci_Map($m_sci_Map$EmptyMap$()))
}
function $s_Lio_youi_theme_Theme$class__get__Lio_youi_theme_Theme__T__s_Option($$this, name) {
  var x$2 = $m_Lio_youi_theme_Theme$();
  if ((($$this !== null) && ($$this === x$2))) {
    var this$1 = $$this.io$youi$theme$Theme$$store__Lio_youi_MapStore();
    return this$1.map$1.get__O__s_Option(name)
  } else {
    var this$2 = $$this.io$youi$theme$Theme$$store__Lio_youi_MapStore();
    var this$3 = this$2.map$1.get__O__s_Option(name);
    if (this$3.isEmpty__Z()) {
      var this$4 = $$this.parentTheme__Lreactify_Var();
      var this$5 = $as_Lio_youi_theme_Theme(this$4.state__Lreactify_State().value__O());
      return $s_Lio_youi_theme_Theme$class__get__Lio_youi_theme_Theme__T__s_Option(this$5, name)
    } else {
      return this$3
    }
  }
}
function $s_Lio_youi_theme_VideoViewTheme$class__autoPauseOnHide__Lio_youi_theme_VideoViewTheme__Lio_youi_theme_StyleProp($$this) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return true
  }));
  var connect = $m_s_None$();
  return $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "autoPauseOnHide", $default, connect, false, false, false)
}
function $s_Lio_youi_theme_VideoViewTheme$class__video__Lio_youi_theme_VideoViewTheme__Lio_youi_theme_StyleProp($$this) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_video_Video$empty$()
  }));
  var connect = new $c_s_Some().init___O($m_Lio_youi_theme_VideoViewTheme$());
  return $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "video", $default, connect, false, false, false)
}
function $s_Lio_youi_theme_bootstrap_ButtonTheme$class__$$init$__Lio_youi_theme_bootstrap_ButtonTheme__V($$this) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_component_bootstrap_ButtonType$Primary$()
  }));
  var connect = $m_Lio_youi_theme_StyleConnect$().classify__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_component_bootstrap_ButtonType$());
  $$this.io$youi$theme$bootstrap$ButtonTheme$$undsetter$und$type$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "type", $default, connect, false, false, false));
  var $default$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_component_bootstrap_ButtonSize$Normal$()
  }));
  var connect$1 = $m_Lio_youi_theme_StyleConnect$().classify__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_component_bootstrap_ButtonSize$());
  $$this.io$youi$theme$bootstrap$ButtonTheme$$undsetter$und$buttonSize$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "buttonSize", $default$1, connect$1, false, false, false));
  var $default$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return false
  }));
  var connect$2 = $m_Lio_youi_theme_StyleConnect$().flag__s_Option__s_Option__s_Option(new $c_s_Some().init___O("btn-block"), $m_s_None$());
  $$this.io$youi$theme$bootstrap$ButtonTheme$$undsetter$und$block$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "block", $default$2, connect$2, false, false, false))
}
function $s_Lio_youi_theme_mixins_HTMLFontTheme$class__$$init$__Lio_youi_theme_mixins_HTMLFontTheme__V($$this) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_style_WhiteSpace$Normal$()
  }));
  var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_WhiteSpace$());
  $$this.io$youi$theme$mixins$HTMLFontTheme$$undsetter$und$whiteSpace$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "white-space", $default, connect, true, false, false));
  var $default$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return new $c_Lio_youi_Color().init___J($m_Lio_youi_Color$().Black$1)
  }));
  var connect$1 = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($$this.stringifyColor__Lio_youi_theme_Stringify());
  $$this.io$youi$theme$mixins$HTMLFontTheme$$undsetter$und$color$und$eq__Lio_youi_theme_StyleProp__V($s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$this, "color", $default$1, connect$1, false, false, false))
}
function $s_Lio_youi_util_ObjectPool$class__apply__Lio_youi_util_ObjectPool__O($$this) {
  var this$1 = $s_Lio_youi_util_ObjectPool$class__get__Lio_youi_util_ObjectPool__s_Option($$this);
  if (this$1.isEmpty__Z()) {
    $$this.io$youi$util$ObjectPool$$created$1 = ((1 + $$this.io$youi$util$ObjectPool$$created$1) | 0);
    return $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("canvas")
  } else {
    return this$1.get__O()
  }
}
function $s_Lio_youi_util_ObjectPool$class__get__Lio_youi_util_ObjectPool__s_Option($$this) {
  var this$1 = $$this.io$youi$util$ObjectPool$$cached$1;
  if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$1)) {
    try {
      var this$2 = $$this.io$youi$util$ObjectPool$$cached$1;
      return $s_sc_TraversableLike$class__headOption__sc_TraversableLike__s_Option(this$2)
    } finally {
      $$this.io$youi$util$ObjectPool$$cached$1 = $as_sci_List($$this.io$youi$util$ObjectPool$$cached$1.tail__O())
    }
  } else {
    return $m_s_None$()
  }
}
function $s_Lio_youi_util_ObjectPool$class__$$init$__Lio_youi_util_ObjectPool__V($$this) {
  $$this.io$youi$util$ObjectPool$$created$1 = 0;
  $$this.io$youi$util$ObjectPool$$cached$1 = ($m_sci_List$(), $m_sci_Nil$())
}
function $s_Lio_youi_util_ObjectPool$class__restore__Lio_youi_util_ObjectPool__O__V($$this, t) {
  var this$1 = $$this.io$youi$util$ObjectPool$$cached$1;
  $$this.io$youi$util$ObjectPool$$cached$1 = new $c_sci_$colon$colon().init___O__sci_List(t, this$1)
}
function $is_Lio_youi_virtual_VirtualMode(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_virtual_VirtualMode)))
}
function $as_Lio_youi_virtual_VirtualMode(obj) {
  return (($is_Lio_youi_virtual_VirtualMode(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.virtual.VirtualMode"))
}
function $isArrayOf_Lio_youi_virtual_VirtualMode(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_virtual_VirtualMode)))
}
function $asArrayOf_Lio_youi_virtual_VirtualMode(obj, depth) {
  return (($isArrayOf_Lio_youi_virtual_VirtualMode(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.virtual.VirtualMode;", depth))
}
function $s_Lio_youi_virtual_VirtualSizeSupport$class__$$init$__Lio_youi_virtual_VirtualSizeSupport__V($$this) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 1024.0
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  $$this.virtualWidth$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 768.0
  }));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  $$this.virtualHeight$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_Lio_youi_virtual_VirtualMode$Bars$()
  }));
  var mode$2 = $m_Lreactify_Var$Mode$Normal$();
  var name$2 = $m_s_None$();
  $$this.virtualMode$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$2, name$2);
  $$this.virtual$1 = new $c_Lio_youi_virtual_VirtualSize().init___Lio_youi_virtual_VirtualSizeSupport($$this)
}
function $is_Lorg_scalajs_testcommon_RPCCore$BoundEndpoint(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_RPCCore$BoundEndpoint)))
}
function $as_Lorg_scalajs_testcommon_RPCCore$BoundEndpoint(obj) {
  return (($is_Lorg_scalajs_testcommon_RPCCore$BoundEndpoint(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.RPCCore$BoundEndpoint"))
}
function $isArrayOf_Lorg_scalajs_testcommon_RPCCore$BoundEndpoint(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_RPCCore$BoundEndpoint)))
}
function $asArrayOf_Lorg_scalajs_testcommon_RPCCore$BoundEndpoint(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_RPCCore$BoundEndpoint(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.RPCCore$BoundEndpoint;", depth))
}
function $is_Lorg_scalajs_testcommon_RPCCore$PendingCall(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_RPCCore$PendingCall)))
}
function $as_Lorg_scalajs_testcommon_RPCCore$PendingCall(obj) {
  return (($is_Lorg_scalajs_testcommon_RPCCore$PendingCall(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.RPCCore$PendingCall"))
}
function $isArrayOf_Lorg_scalajs_testcommon_RPCCore$PendingCall(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_RPCCore$PendingCall)))
}
function $asArrayOf_Lorg_scalajs_testcommon_RPCCore$PendingCall(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_RPCCore$PendingCall(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.RPCCore$PendingCall;", depth))
}
function $is_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testinterface_HTMLRunner$UI$Test)))
}
function $as_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj) {
  return (($is_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testinterface.HTMLRunner$UI$Test"))
}
function $isArrayOf_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testinterface_HTMLRunner$UI$Test)))
}
function $asArrayOf_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testinterface.HTMLRunner$UI$Test;", depth))
}
function $is_Lperfolation_CrossDate(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lperfolation_CrossDate)))
}
function $as_Lperfolation_CrossDate(obj) {
  return (($is_Lperfolation_CrossDate(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "perfolation.CrossDate"))
}
function $isArrayOf_Lperfolation_CrossDate(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lperfolation_CrossDate)))
}
function $asArrayOf_Lperfolation_CrossDate(obj, depth) {
  return (($isArrayOf_Lperfolation_CrossDate(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lperfolation.CrossDate;", depth))
}
function $s_Lperfolation_CrossDate$class__m__Lperfolation_CrossDate__T($$this) {
  return $m_Lperfolation_NumberFormatUtil$().$int__I__I__T(((1 + $$this.month__I()) | 0), 2)
}
function $s_Lperfolation_CrossDate$class__T__Lperfolation_CrossDate__T($$this) {
  var fresh$macro$6 = $m_Lperfolation_NumberFormatUtil$().$int__I__I__T($$this.hour24__I(), 2);
  var fresh$macro$7 = $m_Lperfolation_NumberFormatUtil$().$int__I__I__T($$this.minuteOfHour__I(), 2);
  var fresh$macro$8 = $m_Lperfolation_NumberFormatUtil$().$int__I__I__T($$this.secondOfMinute__I(), 2);
  var this$1 = $m_Lperfolation_package$().stringBuilder__jl_StringBuilder();
  this$1.java$lang$StringBuilder$$content$f = (("" + this$1.java$lang$StringBuilder$$content$f) + fresh$macro$6);
  var this$2 = this$1.append__C__jl_StringBuilder(58);
  this$2.java$lang$StringBuilder$$content$f = (("" + this$2.java$lang$StringBuilder$$content$f) + fresh$macro$7);
  var this$3 = this$2.append__C__jl_StringBuilder(58);
  this$3.java$lang$StringBuilder$$content$f = (("" + this$3.java$lang$StringBuilder$$content$f) + fresh$macro$8);
  return this$3.java$lang$StringBuilder$$content$f
}
function $s_Lprofig_ProfigPath$class__profig$ProfigPath$$path2List__Lprofig_ProfigPath__T__sci_List($$this, path) {
  var this$2 = new $c_sci_StringOps().init___T(path);
  var xs = $s_sci_StringLike$class__split__sci_StringLike__C__AT(this$2, 46);
  var this$4 = $m_sci_List$();
  var cbf = this$4.ReusableCBFInstance$2;
  var b = cbf.apply__scm_Builder();
  b.sizeHint__I__V(xs.u.length);
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs));
  return $as_sci_List(b.result__O())
}
function $s_Lprofig_ProfigPath$class__get__Lprofig_ProfigPath__s_Option($$this) {
  var this$1 = $$this.path__sci_List();
  if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$1)) {
    if ($as_sc_SeqLike($$this.path__sci_List().tail__O()).isEmpty__Z()) {
      var this$2 = $$this.instance__Lprofig_Profig().json__Lio_circe_Json();
      var x1 = new $c_Lio_circe_cursor_TopCursor().init___Lio_circe_Json__Lio_circe_HCursor__Lio_circe_CursorOp(this$2, null, null).get__T__Lio_circe_Decoder__s_util_Either($as_T($$this.path__sci_List().head__O()), $m_Lio_circe_Decoder$().decodeJson$1);
      if ($is_s_util_Left(x1)) {
        return $m_s_None$()
      } else if ($is_s_util_Right(x1)) {
        var x4 = $as_s_util_Right(x1);
        var value = $as_Lio_circe_Json(x4.b$2);
        return new $c_s_Some().init___O(value)
      } else {
        throw new $c_s_MatchError().init___O(x1)
      }
    } else {
      var jsx$1 = $as_sci_List($$this.path__sci_List().tail__O());
      var this$4 = $$this.instance__Lprofig_Profig().json__Lio_circe_Json();
      return $s_Lprofig_ProfigPath$class__find$1__p0__Lprofig_ProfigPath__sci_List__Lio_circe_ACursor__s_Option($$this, jsx$1, new $c_Lio_circe_cursor_TopCursor().init___Lio_circe_Json__Lio_circe_HCursor__Lio_circe_CursorOp(this$4, null, null).downField__T__Lio_circe_ACursor($as_T($$this.path__sci_List().head__O())))
    }
  } else {
    return new $c_s_Some().init___O($$this.instance__Lprofig_Profig().json__Lio_circe_Json())
  }
}
function $s_Lprofig_ProfigPath$class__apply__Lprofig_ProfigPath__sc_Seq__Lprofig_ProfigPath($$this, path) {
  var this$2 = path.toList__sci_List();
  var f = (function(arg$outer) {
    return (function(path$2) {
      var path$1 = $as_T(path$2);
      return $s_Lprofig_ProfigPath$class__profig$ProfigPath$$path2List__Lprofig_ProfigPath__T__sci_List(arg$outer, path$1)
    })
  })($$this);
  var this$1 = $m_sci_List$();
  var bf = this$1.ReusableCBFInstance$2;
  if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
    if ((this$2 === $m_sci_Nil$())) {
      var jsx$1 = $m_sci_Nil$()
    } else {
      var rest = this$2;
      var found = new $c_sr_BooleanRef().init___Z(false);
      var h = new $c_sr_ObjectRef().init___O(null);
      var t = new $c_sr_ObjectRef().init___O(null);
      while ((rest !== $m_sci_Nil$())) {
        var arg1 = rest.head__O();
        $as_sc_GenTraversableOnce(f(arg1)).seq__sc_TraversableOnce().foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, found$1, h$1, t$1) {
          return (function(b$2) {
            if ((!found$1.elem$1)) {
              h$1.elem$1 = new $c_sci_$colon$colon().init___O__sci_List(b$2, $m_sci_Nil$());
              t$1.elem$1 = $as_sci_$colon$colon(h$1.elem$1);
              found$1.elem$1 = true
            } else {
              var nx = new $c_sci_$colon$colon().init___O__sci_List(b$2, $m_sci_Nil$());
              $as_sci_$colon$colon(t$1.elem$1).tl$5 = nx;
              t$1.elem$1 = nx
            }
          })
        })(this$2, found, h, t)));
        rest = $as_sci_List(rest.tail__O())
      };
      var jsx$1 = ((!found.elem$1) ? $m_sci_Nil$() : $as_sci_$colon$colon(h.elem$1))
    }
  } else {
    $m_sci_List$();
    var b = new $c_scm_ListBuffer().init___();
    var these = this$2;
    while ((!these.isEmpty__Z())) {
      var arg1$1 = these.head__O();
      var xs = $as_sc_GenTraversableOnce(f(arg1$1)).seq__sc_TraversableOnce();
      b.$$plus$plus$eq__sc_TraversableOnce__scm_ListBuffer(xs);
      these = $as_sci_List(these.tail__O())
    };
    var jsx$1 = b.toList__sci_List()
  };
  var list = $as_sci_List(jsx$1);
  var instance = $$this.instance__Lprofig_Profig();
  var x$1 = $$this.path__sci_List();
  var path$3 = list.$$colon$colon$colon__sci_List__sci_List(x$1);
  return new $c_Lprofig_ProfigPath$ProfigSubPath().init___Lprofig_Profig__sci_List(instance, path$3)
}
function $s_Lprofig_ProfigPath$class__combine__Lprofig_ProfigPath__Lio_circe_Json__Z__V($$this, json, defaults) {
  if (($$this === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  var this$1 = $$this.path__sci_List();
  if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$1)) {
    var jsx$1 = $m_Lprofig_ProfigUtil$();
    var this$2 = $$this.path__sci_List();
    var updated = jsx$1.createJson__T__Lio_circe_Json__Lio_circe_Json($s_sc_TraversableOnce$class__mkString__sc_TraversableOnce__T__T__T__T(this$2, "", ".", ""), json);
    if (defaults) {
      var this$3 = $$this.instance__Lprofig_Profig();
      var arg1 = this$3.$$undlocal$1;
      this$3.$$undlocal$1 = updated.deepMerge__Lio_circe_Json__Lio_circe_Json(arg1);
      this$3.updateGlobal__p1__V();
      this$3.$$undlastModified$1 = $m_jl_System$().currentTimeMillis__J()
    } else {
      var this$4 = $$this.instance__Lprofig_Profig();
      var arg1$1 = this$4.$$undlocal$1;
      this$4.$$undlocal$1 = arg1$1.deepMerge__Lio_circe_Json__Lio_circe_Json(updated);
      this$4.updateGlobal__p1__V();
      this$4.$$undlastModified$1 = $m_jl_System$().currentTimeMillis__J()
    }
  } else if (defaults) {
    var this$5 = $$this.instance__Lprofig_Profig();
    var arg1$2 = this$5.$$undlocal$1;
    this$5.$$undlocal$1 = json.deepMerge__Lio_circe_Json__Lio_circe_Json(arg1$2);
    this$5.updateGlobal__p1__V();
    this$5.$$undlastModified$1 = $m_jl_System$().currentTimeMillis__J()
  } else {
    var this$6 = $$this.instance__Lprofig_Profig();
    var arg1$3 = this$6.$$undlocal$1;
    this$6.$$undlocal$1 = arg1$3.deepMerge__Lio_circe_Json__Lio_circe_Json(json);
    this$6.updateGlobal__p1__V();
    this$6.$$undlastModified$1 = $m_jl_System$().currentTimeMillis__J()
  }
}
function $s_Lprofig_ProfigPath$class__find$1__p0__Lprofig_ProfigPath__sci_List__Lio_circe_ACursor__s_Option($$this, path, cursor) {
  _find: while (true) {
    if ($as_sc_SeqLike(path.tail__O()).isEmpty__Z()) {
      var x1 = cursor.get__T__Lio_circe_Decoder__s_util_Either($as_T(path.head__O()), $m_Lio_circe_Decoder$().decodeJson$1);
      if ($is_s_util_Left(x1)) {
        return $m_s_None$()
      } else if ($is_s_util_Right(x1)) {
        var x4 = $as_s_util_Right(x1);
        var value = $as_Lio_circe_Json(x4.b$2);
        return new $c_s_Some().init___O(value)
      } else {
        throw new $c_s_MatchError().init___O(x1)
      }
    } else {
      var temp$path = $as_sci_List(path.tail__O());
      var temp$cursor = cursor.downField__T__Lio_circe_ACursor($as_T(path.head__O()));
      path = temp$path;
      cursor = temp$cursor;
      continue _find
    }
  }
}
function $s_Lreactify_Channel$class__toString__Lreactify_Channel__T($$this) {
  var this$1 = $$this.name__s_Option();
  return $as_T((this$1.isEmpty__Z() ? "Channel" : this$1.get__O()))
}
function $is_Lreactify_Reactive(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_Reactive)))
}
function $as_Lreactify_Reactive(obj) {
  return (($is_Lreactify_Reactive(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.Reactive"))
}
function $isArrayOf_Lreactify_Reactive(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_Reactive)))
}
function $asArrayOf_Lreactify_Reactive(obj, depth) {
  return (($isArrayOf_Lreactify_Reactive(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.Reactive;", depth))
}
function $s_Lreactify_Reactive$class__once__Lreactify_Reactive__F1__F1__D__Lreactify_reaction_Reaction($$this, f, condition, priority) {
  var reaction = new $c_sr_ObjectRef().init___O(null);
  var $function = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer, reaction$1, f$2, condition$1) {
    return (function(t$2) {
      if ($uZ(condition$1.apply__O__O(t$2))) {
        arg$outer.reactions__Lreactify_reaction_Reactions().$$minus$eq__Lreactify_reaction_Reaction__Z($as_Lreactify_reaction_Reaction(reaction$1.elem$1));
        f$2.apply__O__O(t$2)
      }
    })
  })($$this, reaction, f, condition));
  reaction.elem$1 = new $c_Lreactify_reaction_FunctionReaction().init___F1__D($function, priority);
  $$this.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction($as_Lreactify_reaction_Reaction(reaction.elem$1));
  return $as_Lreactify_reaction_Reaction(reaction.elem$1)
}
function $s_Lreactify_Reactive$class__changes__Lreactify_Reactive__F2__D__Lreactify_reaction_Reaction($$this, f, priority) {
  return $$this.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(new $c_Lreactify_reaction_ChangeFunctionReaction().init___F2__D(f, priority))
}
function $s_Lreactify_Reactive$class__on__Lreactify_Reactive__F0__D__Lreactify_reaction_Reaction($$this, f, priority) {
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(f$1) {
    return (function(x$1$2) {
      f$1.apply$mcV$sp__V()
    })
  })(f));
  return $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction($$this, f$2, priority)
}
function $s_Lreactify_Reactive$class__fire__Lreactify_Reactive__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus($$this, value, previous, reactions) {
  $$this.reactify$Reactive$$$undstatus__jl_ThreadLocal().set__O__V(new $c_s_Some().init___O($m_Lreactify_reaction_ReactionStatus$Continue$()));
  try {
    return $s_Lreactify_Reactive$class__fireInternal__p0__Lreactify_Reactive__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus($$this, value, previous, reactions)
  } finally {
    $$this.reactify$Reactive$$$undstatus__jl_ThreadLocal().remove__V()
  }
}
function $s_Lreactify_Reactive$class__fireInternal__p0__Lreactify_Reactive__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus($$this, value, previous, reactions) {
  _fireInternal: while (true) {
    var this$1 = reactions;
    if (($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$1) && $as_s_Option($$this.reactify$Reactive$$$undstatus__jl_ThreadLocal().get__O()).contains__O__Z($m_Lreactify_reaction_ReactionStatus$Continue$()))) {
      var reaction = $as_Lreactify_reaction_Reaction(reactions.head__O());
      var status = reaction.apply__O__s_Option__Lreactify_reaction_ReactionStatus(value, previous);
      var x$3 = $m_Lreactify_reaction_ReactionStatus$Continue$();
      if ((((status !== null) && (status === x$3)) && $as_s_Option($$this.reactify$Reactive$$$undstatus__jl_ThreadLocal().get__O()).contains__O__Z($m_Lreactify_reaction_ReactionStatus$Continue$()))) {
        reactions = $as_sci_List(reactions.tail__O());
        continue _fireInternal
      } else {
        return $m_Lreactify_reaction_ReactionStatus$Stop$()
      }
    } else {
      var this$2 = $as_s_Option($$this.reactify$Reactive$$$undstatus__jl_ThreadLocal().get__O());
      if (this$2.isEmpty__Z()) {
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("Status not set"))
      };
      return $as_Lreactify_reaction_ReactionStatus(this$2.get__O())
    }
  }
}
function $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction($$this, f, priority) {
  return $$this.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(new $c_Lreactify_reaction_FunctionReaction().init___F1__D(f, priority))
}
function $s_Lreactify_Reactive$class__once$default$2__Lreactify_Reactive__F1($$this) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$2$2) {
    return true
  }))
}
function $s_Lreactify_Val$class__attachAndFire__Lreactify_Val__F1__D__Lreactify_reaction_Reaction($$this, f, priority) {
  var reaction = $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction($$this, f, priority);
  var value = $$this.state__Lreactify_State().value__O();
  var previous = new $c_s_Some().init___O($$this.state__Lreactify_State().value__O());
  $m_sci_List$();
  var array = [reaction];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var this$4 = $m_sci_List$();
  var cbf = this$4.ReusableCBFInstance$2;
  var reactions = $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf));
  $s_Lreactify_Reactive$class__fire__Lreactify_Reactive__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus($$this, value, previous, reactions);
  return reaction
}
function $s_Lreactify_Val$class__toString__Lreactify_Val__T($$this) {
  var this$1 = $$this.name__s_Option();
  return $as_T((this$1.isEmpty__Z() ? "Val" : this$1.get__O()))
}
function $s_Lreactify_Var$class__$static__Lreactify_Var__O__V($$this, value) {
  $$this.set__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(value$1) {
    return (function() {
      return value$1
    })
  })(value)))
}
function $s_Lreactify_Var$class__toString__Lreactify_Var__T($$this) {
  var this$1 = $$this.name__s_Option();
  return $as_T((this$1.isEmpty__Z() ? "Var" : this$1.get__O()))
}
function $s_Lreactify_Var$class__and__Lreactify_Var__Lreactify_Var__Lreactify_Var($$this, that) {
  var jsx$1 = $m_s_None$();
  $m_sci_List$();
  var array = [$$this, that];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var this$4 = $m_sci_List$();
  var cbf = this$4.ReusableCBFInstance$2;
  return new $c_Lreactify_group_VarGroup().init___s_Option__sci_List(jsx$1, $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)))
}
function $s_Lreactify_Var$class__map__Lreactify_Var__F1__Lreactify_Var($$this, f) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer, f$1) {
    return (function() {
      return f$1.apply__O__O(arg$outer.state__Lreactify_State().value__O())
    })
  })($$this, f));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  var v = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var f$2 = new $c_Lreactify_Var$$anonfun$map$1().init___Lreactify_Var__Lreactify_Var__F1($$this, v, f);
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction($$this, f$2, priority);
  return v
}
function $s_Lreactify_reaction_Reaction$class__compare__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction__I($$this, that) {
  var x = $$this.priority__D();
  var this$2 = new $c_sr_RichDouble().init___D(x);
  var y = that.priority__D();
  var x$1 = this$2.self$1;
  return $m_jl_Double$().compare__D__D__I(x$1, y)
}
function $is_Lreactify_reaction_ReactionStatus(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_reaction_ReactionStatus)))
}
function $as_Lreactify_reaction_ReactionStatus(obj) {
  return (($is_Lreactify_reaction_ReactionStatus(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.reaction.ReactionStatus"))
}
function $isArrayOf_Lreactify_reaction_ReactionStatus(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_reaction_ReactionStatus)))
}
function $asArrayOf_Lreactify_reaction_ReactionStatus(obj, depth) {
  return (($isArrayOf_Lreactify_reaction_ReactionStatus(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.reaction.ReactionStatus;", depth))
}
function $is_Lsbt_testing_Event(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_Event)))
}
function $as_Lsbt_testing_Event(obj) {
  return (($is_Lsbt_testing_Event(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.Event"))
}
function $isArrayOf_Lsbt_testing_Event(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_Event)))
}
function $asArrayOf_Lsbt_testing_Event(obj, depth) {
  return (($isArrayOf_Lsbt_testing_Event(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.Event;", depth))
}
function $is_Lsbt_testing_Fingerprint(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_Fingerprint)))
}
function $as_Lsbt_testing_Fingerprint(obj) {
  return (($is_Lsbt_testing_Fingerprint(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.Fingerprint"))
}
function $isArrayOf_Lsbt_testing_Fingerprint(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_Fingerprint)))
}
function $asArrayOf_Lsbt_testing_Fingerprint(obj, depth) {
  return (($isArrayOf_Lsbt_testing_Fingerprint(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.Fingerprint;", depth))
}
function $is_Lsbt_testing_Framework(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_Framework)))
}
function $as_Lsbt_testing_Framework(obj) {
  return (($is_Lsbt_testing_Framework(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.Framework"))
}
function $isArrayOf_Lsbt_testing_Framework(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_Framework)))
}
function $asArrayOf_Lsbt_testing_Framework(obj, depth) {
  return (($isArrayOf_Lsbt_testing_Framework(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.Framework;", depth))
}
var $d_Lsbt_testing_Framework = new $TypeData().initClass({
  Lsbt_testing_Framework: 0
}, true, "sbt.testing.Framework", {
  Lsbt_testing_Framework: 1
});
var $d_Lsbt_testing_Logger = new $TypeData().initClass({
  Lsbt_testing_Logger: 0
}, true, "sbt.testing.Logger", {
  Lsbt_testing_Logger: 1
});
function $is_Lsbt_testing_Task(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_Task)))
}
function $as_Lsbt_testing_Task(obj) {
  return (($is_Lsbt_testing_Task(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.Task"))
}
function $isArrayOf_Lsbt_testing_Task(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_Task)))
}
function $asArrayOf_Lsbt_testing_Task(obj, depth) {
  return (($isArrayOf_Lsbt_testing_Task(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.Task;", depth))
}
var $d_Lsbt_testing_Task = new $TypeData().initClass({
  Lsbt_testing_Task: 0
}, true, "sbt.testing.Task", {
  Lsbt_testing_Task: 1
});
function $is_Lscribe_LogRecord(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lscribe_LogRecord)))
}
function $as_Lscribe_LogRecord(obj) {
  return (($is_Lscribe_LogRecord(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scribe.LogRecord"))
}
function $isArrayOf_Lscribe_LogRecord(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lscribe_LogRecord)))
}
function $asArrayOf_Lscribe_LogRecord(obj, depth) {
  return (($isArrayOf_Lscribe_LogRecord(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscribe.LogRecord;", depth))
}
function $s_Lscribe_LogSupport$class__withMinimumLevel__Lscribe_LogSupport__Lscribe_Level__Lscribe_LogSupport($$this, level) {
  var modifier = $m_Lscribe_modify_LevelFilter$().$$greater$eq__Lscribe_Level__Lscribe_modify_LevelFilter(level);
  return $s_Lscribe_LogSupport$class__withModifier__Lscribe_LogSupport__Lscribe_modify_LogModifier__Lscribe_LogSupport($$this, modifier)
}
function $s_Lscribe_LogSupport$class__withModifier__Lscribe_LogSupport__Lscribe_modify_LogModifier__Lscribe_LogSupport($$this, modifier) {
  var this$1 = $$this.modifiers__sci_List();
  $m_sci_List$();
  var b = new $c_scm_ListBuffer().init___();
  var these = this$1;
  while ((!these.isEmpty__Z())) {
    var arg1 = these.head__O();
    if ((($as_Lscribe_modify_LogModifier(arg1), ($m_Lscribe_modify_LevelFilter$().Id$1 === $m_Lscribe_modify_LevelFilter$().Id$1)) !== true)) {
      b.$$plus$eq__O__scm_ListBuffer(arg1)
    };
    these = $as_sci_List(these.tail__O())
  };
  var x$2 = b.toList__sci_List();
  $m_sci_List$();
  var array = [modifier];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var this$6 = $m_sci_List$();
  var cbf = this$6.ReusableCBFInstance$2;
  var this$8 = $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)).$$colon$colon$colon__sci_List__sci_List(x$2);
  var this$7 = $m_s_math_Ordering$();
  var evidence$1 = $m_s_Predef$().singleton$und$less$colon$less$2;
  var ord = new $c_s_math_LowPriorityOrderingImplicits$$anon$6().init___s_math_LowPriorityOrderingImplicits__F1(this$7, evidence$1);
  return $$this.setModifiers__sci_List__Lscribe_LogSupport($as_sci_List($s_sc_SeqLike$class__sorted__sc_SeqLike__s_math_Ordering__O(this$8, ord)))
}
function $is_Lscribe_format_FormatBlock(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lscribe_format_FormatBlock)))
}
function $as_Lscribe_format_FormatBlock(obj) {
  return (($is_Lscribe_format_FormatBlock(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scribe.format.FormatBlock"))
}
function $isArrayOf_Lscribe_format_FormatBlock(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lscribe_format_FormatBlock)))
}
function $asArrayOf_Lscribe_format_FormatBlock(obj, depth) {
  return (($isArrayOf_Lscribe_format_FormatBlock(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscribe.format.FormatBlock;", depth))
}
function $s_Lshapeless_Nats$class__$$init$__Lshapeless_Nats__V($$this) {
  $$this.$$und1$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und2$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und3$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und4$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und5$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und6$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und7$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und8$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und9$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und10$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und11$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und12$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und13$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und14$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und15$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und16$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und17$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und18$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und19$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und20$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und21$1 = new $c_Lshapeless_Succ().init___();
  $$this.$$und22$1 = new $c_Lshapeless_Succ().init___()
}
function $s_Lshapeless_ops_hlist$ToTraversable$class__apply__Lshapeless_ops_hlist$ToTraversable__Lshapeless_HList__O($$this, l) {
  var b = $$this.builder__scm_Builder();
  var f = $m_Lshapeless_PolyDefns$$tilde$greater$().inst4__Lshapeless_PolyDefns$$tilde$greater__F1($m_Lshapeless_PolyDefns$identity$());
  $$this.append__Lshapeless_$colon$colon__scm_Builder__F1__V($as_Lshapeless_$colon$colon(l), b, f);
  return b.result__O()
}
/** @constructor */
function $c_O() {
  /*<skip>*/
}
/** @constructor */
function $h_O() {
  /*<skip>*/
}
$h_O.prototype = $c_O.prototype;
$c_O.prototype.init___ = (function() {
  return this
});
$c_O.prototype.equals__O__Z = (function(that) {
  return (this === that)
});
$c_O.prototype.toString__T = (function() {
  var jsx$2 = $objectGetClass(this).getName__T();
  var i = this.hashCode__I();
  var x = $uD((i >>> 0));
  var jsx$1 = x.toString(16);
  return ((jsx$2 + "@") + $as_T(jsx$1))
});
$c_O.prototype.hashCode__I = (function() {
  return $systemIdentityHashCode(this)
});
$c_O.prototype.toString = (function() {
  return this.toString__T()
});
function $is_O(obj) {
  return (obj !== null)
}
function $as_O(obj) {
  return obj
}
function $isArrayOf_O(obj, depth) {
  var data = (obj && obj.$classData);
  if ((!data)) {
    return false
  } else {
    var arrayDepth = (data.arrayDepth || 0);
    return ((!(arrayDepth < depth)) && ((arrayDepth > depth) || (!data.arrayBase.isPrimitive)))
  }
}
function $asArrayOf_O(obj, depth) {
  return (($isArrayOf_O(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Object;", depth))
}
var $d_O = new $TypeData().initClass({
  O: 0
}, false, "java.lang.Object", {
  O: 1
}, (void 0), (void 0), $is_O, $isArrayOf_O);
$c_O.prototype.$classData = $d_O;
function $is_jl_Comparable(obj) {
  return (!(!(((((obj && obj.$classData) && obj.$classData.ancestors.jl_Comparable) || ((typeof obj) === "string")) || ((typeof obj) === "number")) || ((typeof obj) === "boolean"))))
}
function $as_jl_Comparable(obj) {
  return (($is_jl_Comparable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Comparable"))
}
function $isArrayOf_jl_Comparable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Comparable)))
}
function $asArrayOf_jl_Comparable(obj, depth) {
  return (($isArrayOf_jl_Comparable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Comparable;", depth))
}
function $is_jl_Runnable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.jl_Runnable)))
}
function $as_jl_Runnable(obj) {
  return (($is_jl_Runnable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Runnable"))
}
function $isArrayOf_jl_Runnable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Runnable)))
}
function $asArrayOf_jl_Runnable(obj, depth) {
  return (($isArrayOf_jl_Runnable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Runnable;", depth))
}
function $is_ju_Formattable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_Formattable)))
}
function $as_ju_Formattable(obj) {
  return (($is_ju_Formattable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.Formattable"))
}
function $isArrayOf_ju_Formattable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_Formattable)))
}
function $asArrayOf_ju_Formattable(obj, depth) {
  return (($isArrayOf_ju_Formattable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.Formattable;", depth))
}
function $s_ju_HashMap$AbstractMapView$class__size__ju_HashMap$AbstractMapView__I($$this) {
  return $$this.$$outer$f.java$util$HashMap$$inner$f.size__I()
}
function $is_ju_Map(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_Map)))
}
function $as_ju_Map(obj) {
  return (($is_ju_Map(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.Map"))
}
function $isArrayOf_ju_Map(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_Map)))
}
function $asArrayOf_ju_Map(obj, depth) {
  return (($isArrayOf_ju_Map(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.Map;", depth))
}
function $is_ju_Map$Entry(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_Map$Entry)))
}
function $as_ju_Map$Entry(obj) {
  return (($is_ju_Map$Entry(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.Map$Entry"))
}
function $isArrayOf_ju_Map$Entry(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_Map$Entry)))
}
function $asArrayOf_ju_Map$Entry(obj, depth) {
  return (($isArrayOf_ju_Map$Entry(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.Map$Entry;", depth))
}
function $is_ju_regex_GroupStartMap$NodeType(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_regex_GroupStartMap$NodeType)))
}
function $as_ju_regex_GroupStartMap$NodeType(obj) {
  return (($is_ju_regex_GroupStartMap$NodeType(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.regex.GroupStartMap$NodeType"))
}
function $isArrayOf_ju_regex_GroupStartMap$NodeType(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_regex_GroupStartMap$NodeType)))
}
function $asArrayOf_ju_regex_GroupStartMap$NodeType(obj, depth) {
  return (($isArrayOf_ju_regex_GroupStartMap$NodeType(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.regex.GroupStartMap$NodeType;", depth))
}
function $is_ju_regex_GroupStartMap$OriginalRegex(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_regex_GroupStartMap$OriginalRegex)))
}
function $as_ju_regex_GroupStartMap$OriginalRegex(obj) {
  return (($is_ju_regex_GroupStartMap$OriginalRegex(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.regex.GroupStartMap$OriginalRegex"))
}
function $isArrayOf_ju_regex_GroupStartMap$OriginalRegex(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_regex_GroupStartMap$OriginalRegex)))
}
function $asArrayOf_ju_regex_GroupStartMap$OriginalRegex(obj, depth) {
  return (($isArrayOf_ju_regex_GroupStartMap$OriginalRegex(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.regex.GroupStartMap$OriginalRegex;", depth))
}
function $s_s_Function1$class__compose__F1__F1__F1($$this, g) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, g$1) {
    return (function(x$2) {
      return $$this$1.apply__O__O(g$1.apply__O__O(x$2))
    })
  })($$this, g))
}
function $s_s_PartialFunction$class__runWith__s_PartialFunction__F1__F1($$this, action) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, action$1) {
    return (function(x$2) {
      var z = $$this$1.applyOrElse__O__F1__O(x$2, $m_s_PartialFunction$().scala$PartialFunction$$fallback$undpf$f);
      return ((!$m_s_PartialFunction$().scala$PartialFunction$$fallbackOccurred__O__Z(z)) && (action$1.apply__O__O(z), true))
    })
  })($$this, action))
}
function $s_s_PartialFunction$class__applyOrElse__s_PartialFunction__O__F1__O($$this, x, $default) {
  return ($$this.isDefinedAt__O__Z(x) ? $$this.apply__O__O(x) : $default.apply__O__O(x))
}
function $s_s_Product2$class__productElement__s_Product2__I__O($$this, n) {
  switch (n) {
    case 0: {
      return $$this.$$und1__O();
      break
    }
    case 1: {
      return $$this.$$und2__O();
      break
    }
    default: {
      throw new $c_jl_IndexOutOfBoundsException().init___T(("" + n))
    }
  }
}
function $s_s_Product3$class__productElement__s_Product3__I__O($$this, n) {
  switch (n) {
    case 0: {
      return $$this.$$und1$1;
      break
    }
    case 1: {
      return $$this.$$und2$1;
      break
    }
    case 2: {
      return $$this.$$und3$1;
      break
    }
    default: {
      throw new $c_jl_IndexOutOfBoundsException().init___T(("" + n))
    }
  }
}
function $s_s_Product4$class__productElement__s_Product4__I__O($$this, n) {
  switch (n) {
    case 0: {
      return $$this.$$und1$1;
      break
    }
    case 1: {
      return $$this.$$und2$1;
      break
    }
    case 2: {
      return $$this.$$und3$1;
      break
    }
    case 3: {
      return $$this.$$und4$1;
      break
    }
    default: {
      throw new $c_jl_IndexOutOfBoundsException().init___T(("" + n))
    }
  }
}
function $s_s_Proxy$class__toString__s_Proxy__T($$this) {
  return ("" + $$this.self__O())
}
function $s_s_Proxy$class__equals__s_Proxy__O__Z($$this, that) {
  return ((that !== null) && (((that === $$this) || (that === $$this.self__O())) || $objectEquals(that, $$this.self__O())))
}
function $s_s_concurrent_BatchingExecutor$class__batchable__s_concurrent_BatchingExecutor__jl_Runnable__Z($$this, runnable) {
  return $is_s_concurrent_OnCompleteRunnable(runnable)
}
function $s_s_concurrent_BatchingExecutor$class__execute__s_concurrent_BatchingExecutor__jl_Runnable__V($$this, runnable) {
  if ($s_s_concurrent_BatchingExecutor$class__batchable__s_concurrent_BatchingExecutor__jl_Runnable__Z($$this, runnable)) {
    var x1 = $as_sci_List($$this.scala$concurrent$BatchingExecutor$$$undtasksLocal$1.get__O());
    if ((x1 === null)) {
      $m_sci_List$();
      var array = [runnable];
      var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
      var this$4 = $m_sci_List$();
      var cbf = this$4.ReusableCBFInstance$2;
      var r = new $c_s_concurrent_BatchingExecutor$Batch().init___s_concurrent_BatchingExecutor__sci_List($$this, $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
      r.run__V()
    } else {
      $$this.scala$concurrent$BatchingExecutor$$$undtasksLocal$1.set__O__V(new $c_sci_$colon$colon().init___O__sci_List(runnable, x1))
    }
  } else {
    runnable.run__V()
  }
}
function $is_s_concurrent_BlockContext(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_concurrent_BlockContext)))
}
function $as_s_concurrent_BlockContext(obj) {
  return (($is_s_concurrent_BlockContext(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.concurrent.BlockContext"))
}
function $isArrayOf_s_concurrent_BlockContext(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_concurrent_BlockContext)))
}
function $asArrayOf_s_concurrent_BlockContext(obj, depth) {
  return (($isArrayOf_s_concurrent_BlockContext(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.concurrent.BlockContext;", depth))
}
function $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future($$this, f, executor) {
  var p = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  $$this.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, p$1, f$1) {
    return (function(x0$5$2) {
      var x0$5 = $as_s_util_Try(x0$5$2);
      if ($is_s_util_Failure(x0$5)) {
        var x3 = $as_s_util_Failure(x0$5);
        return $s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise(p$1, x3)
      } else if ($is_s_util_Success(x0$5)) {
        var x2 = $as_s_util_Success(x0$5);
        var v = x2.value$2;
        try {
          var x1$2 = $as_s_concurrent_Future(f$1.apply__O__O(v));
          if ($is_s_concurrent_impl_Promise$DefaultPromise(x1$2)) {
            var x2$2 = $as_s_concurrent_impl_Promise$DefaultPromise(x1$2);
            x2$2.link__p2__s_concurrent_impl_Promise$DefaultPromise__V(p$1.compressedRoot__p2__s_concurrent_impl_Promise$DefaultPromise())
          } else {
            x1$2.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$2, p$4) {
              return (function(result$2) {
                var result = $as_s_util_Try(result$2);
                return $as_s_concurrent_impl_Promise$DefaultPromise($s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise(p$4, result))
              })
            })($$this$1, p$1)), $m_s_concurrent_Future$InternalCallbackExecutor$())
          };
          return (void 0)
        } catch (e) {
          var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
          if ((e$2 !== null)) {
            var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
            if ((!o11.isEmpty__Z())) {
              var t = $as_jl_Throwable(o11.get__O());
              return $s_s_concurrent_Promise$class__failure__s_concurrent_Promise__jl_Throwable__s_concurrent_Promise(p$1, t)
            };
            throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
          } else {
            throw e
          }
        }
      } else {
        throw new $c_s_MatchError().init___O(x0$5)
      }
    })
  })($$this, p, f)), executor);
  return p
}
function $s_s_concurrent_Future$class__recover__s_concurrent_Future__s_PartialFunction__s_concurrent_ExecutionContext__s_concurrent_Future($$this, pf, executor) {
  var p = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  $$this.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, p$1, pf$1) {
    return (function(v$2) {
      var v = $as_s_util_Try(v$2);
      var result = v.recover__s_PartialFunction__s_util_Try(pf$1);
      return $s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise(p$1, result)
    })
  })($$this, p, pf)), executor);
  return p
}
function $s_s_concurrent_Future$class__foreach__s_concurrent_Future__F1__s_concurrent_ExecutionContext__V($$this, f, executor) {
  $$this.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, f$1) {
    return (function(x$1$2) {
      var x$1 = $as_s_util_Try(x$1$2);
      x$1.foreach__F1__V(f$1)
    })
  })($$this, f)), executor)
}
function $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future($$this, f, executor) {
  var p = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  $$this.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, p$1, f$1) {
    return (function(v$2) {
      var v = $as_s_util_Try(v$2);
      var result = v.map__F1__s_util_Try(f$1);
      return $s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise(p$1, result)
    })
  })($$this, p, f)), executor);
  return p
}
function $s_s_concurrent_Future$class__filter__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future($$this, p, executor) {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, p$1) {
    return (function(r$2) {
      if ($uZ(p$1.apply__O__O(r$2))) {
        return r$2
      } else {
        throw new $c_ju_NoSuchElementException().init___T("Future.filter predicate is not satisfied")
      }
    })
  })($$this, p));
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future($$this, f, executor)
}
function $s_s_concurrent_Future$class__failed__s_concurrent_Future__s_concurrent_Future($$this) {
  var ec = $m_s_concurrent_Future$InternalCallbackExecutor$();
  var p = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  $$this.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, p$1) {
    return (function(x0$3$2) {
      var x0$3 = $as_s_util_Try(x0$3$2);
      if ($is_s_util_Failure(x0$3)) {
        var x2 = $as_s_util_Failure(x0$3);
        var t = x2.exception$2;
        return $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(p$1, t)
      } else if ($is_s_util_Success(x0$3)) {
        var cause = new $c_ju_NoSuchElementException().init___T("Future.failed not completed with a throwable.");
        return $s_s_concurrent_Promise$class__failure__s_concurrent_Promise__jl_Throwable__s_concurrent_Promise(p$1, cause)
      } else {
        throw new $c_s_MatchError().init___O(x0$3)
      }
    })
  })($$this, p)), ec);
  return p
}
function $is_s_concurrent_OnCompleteRunnable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_concurrent_OnCompleteRunnable)))
}
function $as_s_concurrent_OnCompleteRunnable(obj) {
  return (($is_s_concurrent_OnCompleteRunnable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.concurrent.OnCompleteRunnable"))
}
function $isArrayOf_s_concurrent_OnCompleteRunnable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_concurrent_OnCompleteRunnable)))
}
function $asArrayOf_s_concurrent_OnCompleteRunnable(obj, depth) {
  return (($isArrayOf_s_concurrent_OnCompleteRunnable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.concurrent.OnCompleteRunnable;", depth))
}
function $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise($$this, value) {
  var result = new $c_s_util_Success().init___O(value);
  return $s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise($$this, result)
}
function $s_s_concurrent_Promise$class__failure__s_concurrent_Promise__jl_Throwable__s_concurrent_Promise($$this, cause) {
  var result = new $c_s_util_Failure().init___jl_Throwable(cause);
  return $s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise($$this, result)
}
function $s_s_concurrent_Promise$class__tryFailure__s_concurrent_Promise__jl_Throwable__Z($$this, cause) {
  return $$this.tryComplete__s_util_Try__Z(new $c_s_util_Failure().init___jl_Throwable(cause))
}
function $s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise($$this, result) {
  if ($$this.tryComplete__s_util_Try__Z(result)) {
    return $$this
  } else {
    throw new $c_jl_IllegalStateException().init___T("Promise already completed.")
  }
}
function $s_s_concurrent_impl_Promise$class__toString__s_concurrent_impl_Promise__T($$this) {
  var x1 = $$this.value__s_Option();
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var result = $as_s_util_Try(x2.x$2);
    return (("Future(" + result) + ")")
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      return "Future(<not completed>)"
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $s_s_math_Numeric$IntIsIntegral$class__plus__s_math_Numeric$IntIsIntegral__I__I__I($$this, x, y) {
  return ((x + y) | 0)
}
function $s_s_math_Ordered$class__$$less$eq__s_math_Ordered__O__Z($$this, that) {
  return ($$this.compare__O__I(that) <= 0)
}
function $s_s_math_Ordering$IntOrdering$class__compare__s_math_Ordering$IntOrdering__I__I__I($$this, x, y) {
  return ((x < y) ? (-1) : ((x === y) ? 0 : 1))
}
function $s_s_math_Ordering$LongOrdering$class__compare__s_math_Ordering$LongOrdering__J__J__I($$this, x, y) {
  var ahi = x.hi$2;
  var bhi = y.hi$2;
  if (((ahi === bhi) ? (((-2147483648) ^ x.lo$2) < ((-2147483648) ^ y.lo$2)) : (ahi < bhi))) {
    return (-1)
  } else {
    return (((x.lo$2 === y.lo$2) && (x.hi$2 === y.hi$2)) ? 0 : 1)
  }
}
function $s_s_math_Ordering$class__gteq__s_math_Ordering__O__O__Z($$this, x, y) {
  return ($$this.compare__O__O__I(x, y) >= 0)
}
function $s_s_math_Ordering$class__lteq__s_math_Ordering__O__O__Z($$this, x, y) {
  return ($$this.compare__O__O__I(x, y) <= 0)
}
function $s_s_math_ScalaNumericAnyConversions$class__unifiedPrimitiveEquals__s_math_ScalaNumericAnyConversions__O__Z($$this, x) {
  if ($is_jl_Character(x)) {
    if ((x === null)) {
      var x2 = 0
    } else {
      var this$2 = $as_jl_Character(x);
      var x2 = this$2.value$1
    };
    return ($$this.isValidChar__Z() && ($$this.intValue__I() === x2))
  } else if ($isByte(x)) {
    var x3 = $uB(x);
    return ($$this.isValidByte__Z() && ($$this.byteValue__B() === x3))
  } else if ($isShort(x)) {
    var x4 = $uS(x);
    return ($$this.isValidShort__Z() && ($$this.shortValue__S() === x4))
  } else if ($isInt(x)) {
    var x5 = $uI(x);
    return ($$this.isValidInt__Z() && ($$this.intValue__I() === x5))
  } else if ($is_sjsr_RuntimeLong(x)) {
    var t = $uJ(x);
    var lo = t.lo$2;
    var hi = t.hi$2;
    var t$1 = $$this.longValue__J();
    var lo$1 = t$1.lo$2;
    var hi$1 = t$1.hi$2;
    return ((lo$1 === lo) && (hi$1 === hi))
  } else if ($isFloat(x)) {
    var x7 = $uF(x);
    return ($$this.floatValue__F() === x7)
  } else if (((typeof x) === "number")) {
    var x8 = $uD(x);
    return ($$this.doubleValue__D() === x8)
  } else {
    return false
  }
}
function $s_s_math_ScalaNumericAnyConversions$class__unifiedPrimitiveHashcode__s_math_ScalaNumericAnyConversions__I($$this) {
  var t = $$this.longValue__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  return ((((hi === (-1)) ? (((-2147483648) ^ lo) >= 0) : (hi > (-1))) && ((hi === 0) ? (((-2147483648) ^ lo) <= (-1)) : (hi < 0))) ? lo : $m_sr_ScalaRunTime$().hash__O__I(new $c_sjsr_RuntimeLong().init___I__I(lo, hi)))
}
function $s_s_reflect_ClassTag$class__newArray__s_reflect_ClassTag__I__O($$this, len) {
  var x1 = $$this.runtimeClass__jl_Class();
  return ((x1 === $d_B.getClassOf()) ? $newArrayObject($d_B.getArrayOf(), [len]) : ((x1 === $d_S.getClassOf()) ? $newArrayObject($d_S.getArrayOf(), [len]) : ((x1 === $d_C.getClassOf()) ? $newArrayObject($d_C.getArrayOf(), [len]) : ((x1 === $d_I.getClassOf()) ? $newArrayObject($d_I.getArrayOf(), [len]) : ((x1 === $d_J.getClassOf()) ? $newArrayObject($d_J.getArrayOf(), [len]) : ((x1 === $d_F.getClassOf()) ? $newArrayObject($d_F.getArrayOf(), [len]) : ((x1 === $d_D.getClassOf()) ? $newArrayObject($d_D.getArrayOf(), [len]) : ((x1 === $d_Z.getClassOf()) ? $newArrayObject($d_Z.getArrayOf(), [len]) : ((x1 === $d_V.getClassOf()) ? $newArrayObject($d_sr_BoxedUnit.getArrayOf(), [len]) : $m_jl_reflect_Array$().newInstance__jl_Class__I__O($$this.runtimeClass__jl_Class(), len))))))))))
}
function $s_s_reflect_ClassTag$class__equals__s_reflect_ClassTag__O__Z($$this, x) {
  if ($is_s_reflect_ClassTag(x)) {
    var x$2 = $$this.runtimeClass__jl_Class();
    var x$3 = $as_s_reflect_ClassTag(x).runtimeClass__jl_Class();
    return (x$2 === x$3)
  } else {
    return false
  }
}
function $s_s_reflect_ClassTag$class__prettyprint$1__p0__s_reflect_ClassTag__jl_Class__T($$this, clazz) {
  if (clazz.isArray__Z()) {
    var array = ["Array[", "]"];
    var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var array$1 = [$s_s_reflect_ClassTag$class__prettyprint$1__p0__s_reflect_ClassTag__jl_Class__T($$this, clazz.getComponentType__jl_Class())];
    return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
  } else {
    return clazz.getName__T()
  }
}
function $s_s_util_control_NoStackTrace$class__fillInStackTrace__s_util_control_NoStackTrace__jl_Throwable($$this) {
  var this$1 = $m_s_util_control_NoStackTrace$();
  if (this$1.$$undnoSuppression$1) {
    return $c_jl_Throwable.prototype.fillInStackTrace__jl_Throwable.call($$this)
  } else {
    return $as_jl_Throwable($$this)
  }
}
function $s_s_util_matching_Regex$MatchData$class__group__s_util_matching_Regex$MatchData__I__T($$this, i) {
  return (($$this.start__I__I(i) >= 0) ? $objectToString($charSequenceSubSequence($$this.source__jl_CharSequence(), $$this.start__I__I(i), $$this.end__I__I(i))) : null)
}
function $s_s_util_matching_Regex$MatchData$class__matched__s_util_matching_Regex$MatchData__T($$this) {
  return (($$this.start__I() >= 0) ? $objectToString($charSequenceSubSequence($$this.source__jl_CharSequence(), $$this.start__I(), $$this.end__I())) : null)
}
function $s_s_util_matching_Regex$Replacement$class__replaced__s_util_matching_Regex$Replacement__T($$this) {
  var newsb = new $c_jl_StringBuffer().init___jl_CharSequence($$this.scala$util$matching$Regex$Replacement$$sb$2);
  $$this.matcher__ju_regex_Matcher().appendTail__jl_StringBuffer__jl_StringBuffer(newsb);
  return newsb.toString__T()
}
function $s_sc_DefaultMap$class__$$plus__sc_DefaultMap__T2__sc_Map($$this, kv) {
  var b = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  $s_scg_Growable$class__$$plus$plus$eq__scg_Growable__sc_TraversableOnce__scg_Growable(b, $$this);
  var elem = new $c_T2().init___O__O(kv.$$und1__O(), kv.$$und2__O());
  b.$$plus$eq__T2__scm_MapBuilder(elem);
  return $as_sc_Map(b.elems$1)
}
function $s_sc_DefaultMap$class__$$minus__sc_DefaultMap__O__sc_Map($$this, key) {
  var b = new $c_scm_MapBuilder().init___sc_GenMap($$this.empty__sc_Map());
  var p = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, key$1) {
    return (function(x$1$2) {
      var x$1 = $as_T2(x$1$2);
      return (!$m_sr_BoxesRunTime$().equals__O__O__Z(key$1, x$1.$$und1__O()))
    })
  })($$this, key));
  var xs = $as_sc_TraversableOnce($s_sc_TraversableLike$class__filterImpl__p0__sc_TraversableLike__F1__Z__O($$this, p, false));
  $s_scg_Growable$class__$$plus$plus$eq__scg_Growable__sc_TraversableOnce__scg_Growable(b, xs);
  return $as_sc_Map(b.elems$1)
}
function $s_sc_GenMapLike$class__liftedTree1$1__p0__sc_GenMapLike__sc_GenMap__Z($$this, x2$1) {
  try {
    var this$1 = $$this.iterator__sc_Iterator();
    var res = true;
    while ((res && this$1.hasNext__Z())) {
      var arg1 = this$1.next__O();
      var x0$1 = $as_T2(arg1);
      if ((x0$1 === null)) {
        throw new $c_s_MatchError().init___O(x0$1)
      };
      var k = x0$1.$$und1__O();
      var v = x0$1.$$und2__O();
      var x1$2 = x2$1.get__O__s_Option(k);
      matchEnd6: {
        if ($is_s_Some(x1$2)) {
          var x2 = $as_s_Some(x1$2);
          var p3 = x2.x$2;
          if ($m_sr_BoxesRunTime$().equals__O__O__Z(v, p3)) {
            res = true;
            break matchEnd6
          }
        };
        res = false
      }
    };
    return res
  } catch (e) {
    if ($is_jl_ClassCastException(e)) {
      $as_jl_ClassCastException(e);
      return false
    } else {
      throw e
    }
  }
}
function $s_sc_GenMapLike$class__equals__sc_GenMapLike__O__Z($$this, that) {
  if ($is_sc_GenMap(that)) {
    var x2 = $as_sc_GenMap(that);
    return (($$this === x2) || (($$this.size__I() === x2.size__I()) && $s_sc_GenMapLike$class__liftedTree1$1__p0__sc_GenMapLike__sc_GenMap__Z($$this, x2)))
  } else {
    return false
  }
}
function $s_sc_GenSeqLike$class__equals__sc_GenSeqLike__O__Z($$this, that) {
  if ($is_sc_GenSeq(that)) {
    var x2 = $as_sc_GenSeq(that);
    return $$this.sameElements__sc_GenIterable__Z(x2)
  } else {
    return false
  }
}
function $s_sc_GenSeqLike$class__indexOf__sc_GenSeqLike__O__I__I($$this, elem, from) {
  return $$this.indexWhere__F1__I__I(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, elem$1) {
    return (function(x$1$2) {
      return $m_sr_BoxesRunTime$().equals__O__O__Z(elem$1, x$1$2)
    })
  })($$this, elem)), from)
}
function $s_sc_GenSeqLike$class__isDefinedAt__sc_GenSeqLike__I__Z($$this, idx) {
  return ((idx >= 0) && (idx < $$this.length__I()))
}
function $s_sc_GenSetLike$class__liftedTree1$1__p0__sc_GenSetLike__sc_GenSet__Z($$this, x2$1) {
  try {
    return $$this.subsetOf__sc_GenSet__Z(x2$1)
  } catch (e) {
    if ($is_jl_ClassCastException(e)) {
      $as_jl_ClassCastException(e);
      return false
    } else {
      throw e
    }
  }
}
function $s_sc_GenSetLike$class__equals__sc_GenSetLike__O__Z($$this, that) {
  if ($is_sc_GenSet(that)) {
    var x2 = $as_sc_GenSet(that);
    return (($$this === x2) || (($$this.size__I() === x2.size__I()) && $s_sc_GenSetLike$class__liftedTree1$1__p0__sc_GenSetLike__sc_GenSet__Z($$this, x2)))
  } else {
    return false
  }
}
function $is_sc_GenTraversableOnce(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.sc_GenTraversableOnce)))
}
function $as_sc_GenTraversableOnce(obj) {
  return (($is_sc_GenTraversableOnce(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.collection.GenTraversableOnce"))
}
function $isArrayOf_sc_GenTraversableOnce(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.sc_GenTraversableOnce)))
}
function $asArrayOf_sc_GenTraversableOnce(obj, depth) {
  return (($isArrayOf_sc_GenTraversableOnce(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.collection.GenTraversableOnce;", depth))
}
function $s_sc_IndexedSeqLike$class__toBuffer__sc_IndexedSeqLike__scm_Buffer($$this) {
  var result = new $c_scm_ArrayBuffer().init___I($$this.size__I());
  var xs = $$this.seq__sc_TraversableOnce();
  result.$$plus$plus$eq__sc_TraversableOnce__scm_ArrayBuffer(xs);
  return result
}
function $s_sc_IndexedSeqOptimized$class__foldr__p0__sc_IndexedSeqOptimized__I__I__O__F2__O($$this, start, end, z, op) {
  _foldr: while (true) {
    if ((start === end)) {
      return z
    } else {
      var temp$end = (((-1) + end) | 0);
      var temp$z = op.apply__O__O__O($$this.apply__I__O((((-1) + end) | 0)), z);
      end = temp$end;
      z = temp$z;
      continue _foldr
    }
  }
}
function $s_sc_IndexedSeqOptimized$class__lengthCompare__sc_IndexedSeqOptimized__I__I($$this, len) {
  return (($$this.length__I() - len) | 0)
}
function $s_sc_IndexedSeqOptimized$class__last__sc_IndexedSeqOptimized__O($$this) {
  return (($$this.length__I() > 0) ? $$this.apply__I__O((((-1) + $$this.length__I()) | 0)) : $s_sc_TraversableLike$class__last__sc_TraversableLike__O($$this))
}
function $s_sc_IndexedSeqOptimized$class__forall__sc_IndexedSeqOptimized__F1__Z($$this, p) {
  return ($s_sc_IndexedSeqOptimized$class__prefixLengthImpl__p0__sc_IndexedSeqOptimized__F1__Z__I($$this, p, true) === $$this.length__I())
}
function $s_sc_IndexedSeqOptimized$class__reduceLeft__sc_IndexedSeqOptimized__F2__O($$this, op) {
  return (($$this.length__I() > 0) ? $s_sc_IndexedSeqOptimized$class__foldl__p0__sc_IndexedSeqOptimized__I__I__O__F2__O($$this, 1, $$this.length__I(), $$this.apply__I__O(0), op) : $s_sc_TraversableOnce$class__reduceLeft__sc_TraversableOnce__F2__O($$this, op))
}
function $s_sc_IndexedSeqOptimized$class__find__sc_IndexedSeqOptimized__F1__s_Option($$this, p) {
  var len = $$this.length__I();
  var i = 0;
  while (true) {
    if ((i < len)) {
      var arg1 = $$this.apply__I__O(i);
      var jsx$1 = (!$uZ(p.apply__O__O(arg1)))
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      i = ((1 + i) | 0)
    } else {
      break
    }
  };
  var i$1 = i;
  return ((i$1 < $$this.length__I()) ? new $c_s_Some().init___O($$this.apply__I__O(i$1)) : $m_s_None$())
}
function $s_sc_IndexedSeqOptimized$class__slice__sc_IndexedSeqOptimized__I__I__O($$this, from, until) {
  var lo = ((from > 0) ? from : 0);
  var x = ((until > 0) ? until : 0);
  var y = $$this.length__I();
  var hi = ((x < y) ? x : y);
  var x$1 = ((hi - lo) | 0);
  var elems = ((x$1 > 0) ? x$1 : 0);
  var b = $$this.newBuilder__scm_Builder();
  b.sizeHint__I__V(elems);
  var i = lo;
  while ((i < hi)) {
    b.$$plus$eq__O__scm_Builder($$this.apply__I__O(i));
    i = ((1 + i) | 0)
  };
  return b.result__O()
}
function $s_sc_IndexedSeqOptimized$class__negLength__p0__sc_IndexedSeqOptimized__I__I($$this, n) {
  return ((n >= $$this.length__I()) ? (-1) : n)
}
function $s_sc_IndexedSeqOptimized$class__foldl__p0__sc_IndexedSeqOptimized__I__I__O__F2__O($$this, start, end, z, op) {
  _foldl: while (true) {
    if ((start === end)) {
      return z
    } else {
      var temp$start = ((1 + start) | 0);
      var temp$z = op.apply__O__O__O(z, $$this.apply__I__O(start));
      start = temp$start;
      z = temp$z;
      continue _foldl
    }
  }
}
function $s_sc_IndexedSeqOptimized$class__zip__sc_IndexedSeqOptimized__sc_GenIterable__scg_CanBuildFrom__O($$this, that, bf) {
  if ($is_sc_IndexedSeq(that)) {
    var x2 = $as_sc_IndexedSeq(that);
    var b = bf.apply__O__scm_Builder($$this.repr__O());
    var i = 0;
    var x = $$this.length__I();
    var that$1 = x2.length__I();
    var len = ((x < that$1) ? x : that$1);
    b.sizeHint__I__V(len);
    while ((i < len)) {
      b.$$plus$eq__O__scm_Builder(new $c_T2().init___O__O($$this.apply__I__O(i), x2.apply__I__O(i)));
      i = ((1 + i) | 0)
    };
    return b.result__O()
  } else {
    return $s_sc_IterableLike$class__zip__sc_IterableLike__sc_GenIterable__scg_CanBuildFrom__O($$this, that, bf)
  }
}
function $s_sc_IndexedSeqOptimized$class__copyToArray__sc_IndexedSeqOptimized__O__I__I__V($$this, xs, start, len) {
  var i = 0;
  var j = start;
  var x = $$this.length__I();
  var x$1 = ((x < len) ? x : len);
  var that = (($m_sr_ScalaRunTime$().array$undlength__O__I(xs) - start) | 0);
  var end = ((x$1 < that) ? x$1 : that);
  while ((i < end)) {
    $m_sr_ScalaRunTime$().array$undupdate__O__I__O__V(xs, j, $$this.apply__I__O(i));
    i = ((1 + i) | 0);
    j = ((1 + j) | 0)
  }
}
function $s_sc_IndexedSeqOptimized$class__sameElements__sc_IndexedSeqOptimized__sc_GenIterable__Z($$this, that) {
  if ($is_sc_IndexedSeq(that)) {
    var x2 = $as_sc_IndexedSeq(that);
    var len = $$this.length__I();
    if ((len === x2.length__I())) {
      var i = 0;
      while (((i < len) && $m_sr_BoxesRunTime$().equals__O__O__Z($$this.apply__I__O(i), x2.apply__I__O(i)))) {
        i = ((1 + i) | 0)
      };
      return (i === len)
    } else {
      return false
    }
  } else {
    return $s_sc_IterableLike$class__sameElements__sc_IterableLike__sc_GenIterable__Z($$this, that)
  }
}
function $s_sc_IndexedSeqOptimized$class__foreach__sc_IndexedSeqOptimized__F1__V($$this, f) {
  var i = 0;
  var len = $$this.length__I();
  while ((i < len)) {
    f.apply__O__O($$this.apply__I__O(i));
    i = ((1 + i) | 0)
  }
}
function $s_sc_IndexedSeqOptimized$class__reverse__sc_IndexedSeqOptimized__O($$this) {
  var b = $$this.newBuilder__scm_Builder();
  b.sizeHint__I__V($$this.length__I());
  var i = $$this.length__I();
  while ((i > 0)) {
    i = (((-1) + i) | 0);
    b.$$plus$eq__O__scm_Builder($$this.apply__I__O(i))
  };
  return b.result__O()
}
function $s_sc_IndexedSeqOptimized$class__tail__sc_IndexedSeqOptimized__O($$this) {
  return ($s_sc_IndexedSeqOptimized$class__isEmpty__sc_IndexedSeqOptimized__Z($$this) ? $s_sc_TraversableLike$class__tail__sc_TraversableLike__O($$this) : $$this.slice__I__I__O(1, $$this.length__I()))
}
function $s_sc_IndexedSeqOptimized$class__prefixLengthImpl__p0__sc_IndexedSeqOptimized__F1__Z__I($$this, p, expectTrue) {
  var i = 0;
  while (((i < $$this.length__I()) && ($uZ(p.apply__O__O($$this.apply__I__O(i))) === expectTrue))) {
    i = ((1 + i) | 0)
  };
  return i
}
function $s_sc_IndexedSeqOptimized$class__exists__sc_IndexedSeqOptimized__F1__Z($$this, p) {
  return ($s_sc_IndexedSeqOptimized$class__prefixLengthImpl__p0__sc_IndexedSeqOptimized__F1__Z__I($$this, p, false) !== $$this.length__I())
}
function $s_sc_IndexedSeqOptimized$class__isEmpty__sc_IndexedSeqOptimized__Z($$this) {
  return ($$this.length__I() === 0)
}
function $s_sc_IndexedSeqOptimized$class__head__sc_IndexedSeqOptimized__O($$this) {
  return ($s_sc_IndexedSeqOptimized$class__isEmpty__sc_IndexedSeqOptimized__Z($$this) ? new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I($$this, 0, $$this.length__I()).next__O() : $$this.apply__I__O(0))
}
function $s_sc_IndexedSeqOptimized$class__indexWhere__sc_IndexedSeqOptimized__F1__I__I($$this, p, from) {
  var start = ((from > 0) ? from : 0);
  var len = $$this.length__I();
  var i = start;
  while (true) {
    if ((i < len)) {
      var arg1 = $$this.apply__I__O(i);
      var jsx$1 = (!$uZ(p.apply__O__O(arg1)))
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      i = ((1 + i) | 0)
    } else {
      break
    }
  };
  return $s_sc_IndexedSeqOptimized$class__negLength__p0__sc_IndexedSeqOptimized__I__I($$this, ((start + ((i - start) | 0)) | 0))
}
function $s_sc_IndexedSeqOptimized$class__splitAt__sc_IndexedSeqOptimized__I__T2($$this, n) {
  return new $c_T2().init___O__O($$this.slice__I__I__O(0, n), $$this.slice__I__I__O(n, $$this.length__I()))
}
function $s_sc_IterableLike$class__drop__sc_IterableLike__I__O($$this, n) {
  var b = $$this.newBuilder__scm_Builder();
  var lo = ((n < 0) ? 0 : n);
  var delta = ((-lo) | 0);
  $s_scm_Builder$class__sizeHint__scm_Builder__sc_TraversableLike__I__V(b, $$this, delta);
  var i = 0;
  var it = $$this.iterator__sc_Iterator();
  while (((i < n) && it.hasNext__Z())) {
    it.next__O();
    i = ((1 + i) | 0)
  };
  return $as_scm_Builder(b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(it)).result__O()
}
function $s_sc_IterableLike$class__zip__sc_IterableLike__sc_GenIterable__scg_CanBuildFrom__O($$this, that, bf) {
  var b = bf.apply__O__scm_Builder($$this.repr__O());
  var these = $$this.iterator__sc_Iterator();
  var those = that.iterator__sc_Iterator();
  while ((these.hasNext__Z() && those.hasNext__Z())) {
    b.$$plus$eq__O__scm_Builder(new $c_T2().init___O__O(these.next__O(), those.next__O()))
  };
  return b.result__O()
}
function $s_sc_IterableLike$class__copyToArray__sc_IterableLike__O__I__I__V($$this, xs, start, len) {
  var i = start;
  var x = ((start + len) | 0);
  var that = $m_sr_ScalaRunTime$().array$undlength__O__I(xs);
  var end = ((x < that) ? x : that);
  var it = $$this.iterator__sc_Iterator();
  while (((i < end) && it.hasNext__Z())) {
    $m_sr_ScalaRunTime$().array$undupdate__O__I__O__V(xs, i, it.next__O());
    i = ((1 + i) | 0)
  }
}
function $s_sc_IterableLike$class__isEmpty__sc_IterableLike__Z($$this) {
  return (!$$this.iterator__sc_Iterator().hasNext__Z())
}
function $s_sc_IterableLike$class__take__sc_IterableLike__I__O($$this, n) {
  var b = $$this.newBuilder__scm_Builder();
  if ((n <= 0)) {
    return b.result__O()
  } else {
    b.sizeHintBounded__I__sc_TraversableLike__V(n, $$this);
    var i = 0;
    var it = $$this.iterator__sc_Iterator();
    while (((i < n) && it.hasNext__Z())) {
      b.$$plus$eq__O__scm_Builder(it.next__O());
      i = ((1 + i) | 0)
    };
    return b.result__O()
  }
}
function $s_sc_IterableLike$class__sameElements__sc_IterableLike__sc_GenIterable__Z($$this, that) {
  var these = $$this.iterator__sc_Iterator();
  var those = that.iterator__sc_Iterator();
  while ((these.hasNext__Z() && those.hasNext__Z())) {
    if ((!$m_sr_BoxesRunTime$().equals__O__O__Z(these.next__O(), those.next__O()))) {
      return false
    }
  };
  return ((!these.hasNext__Z()) && (!those.hasNext__Z()))
}
function $s_sc_IterableLike$class__zipWithIndex__sc_IterableLike__scg_CanBuildFrom__O($$this, bf) {
  var b = bf.apply__O__scm_Builder($$this.repr__O());
  var i = new $c_sr_IntRef().init___I(0);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, b$1, i$1) {
    return (function(x$2) {
      b$1.$$plus$eq__O__scm_Builder(new $c_T2().init___O__O(x$2, i$1.elem$1));
      i$1.elem$1 = ((1 + i$1.elem$1) | 0)
    })
  })($$this, b, i)));
  return b.result__O()
}
function $s_sc_Iterator$class__toStream__sc_Iterator__sci_Stream($$this) {
  if ($$this.hasNext__Z()) {
    var hd = $$this.next__O();
    var tl = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($$this$1) {
      return (function() {
        return $$this$1.toStream__sci_Stream()
      })
    })($$this));
    return new $c_sci_Stream$Cons().init___O__F0(hd, tl)
  } else {
    $m_sci_Stream$();
    return $m_sci_Stream$Empty$()
  }
}
function $s_sc_Iterator$class__isEmpty__sc_Iterator__Z($$this) {
  return (!$$this.hasNext__Z())
}
function $s_sc_Iterator$class__drop__sc_Iterator__I__sc_Iterator($$this, n) {
  var j = 0;
  while (((j < n) && $$this.hasNext__Z())) {
    $$this.next__O();
    j = ((1 + j) | 0)
  };
  return $$this
}
function $s_sc_Iterator$class__toString__sc_Iterator__T($$this) {
  return (($$this.hasNext__Z() ? "non-empty" : "empty") + " iterator")
}
function $s_sc_Iterator$class__exists__sc_Iterator__F1__Z($$this, p) {
  var res = false;
  while (((!res) && $$this.hasNext__Z())) {
    res = $uZ(p.apply__O__O($$this.next__O()))
  };
  return res
}
function $s_sc_Iterator$class__foreach__sc_Iterator__F1__V($$this, f) {
  while ($$this.hasNext__Z()) {
    f.apply__O__O($$this.next__O())
  }
}
function $s_sc_Iterator$class__copyToArray__sc_Iterator__O__I__I__V($$this, xs, start, len) {
  var requirement = ((start >= 0) && ((start < $m_sr_ScalaRunTime$().array$undlength__O__I(xs)) || ($m_sr_ScalaRunTime$().array$undlength__O__I(xs) === 0)));
  if ((!requirement)) {
    var array = ["start ", " out of range ", ""];
    var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var array$1 = [start, $m_sr_ScalaRunTime$().array$undlength__O__I(xs)];
    throw new $c_jl_IllegalArgumentException().init___T(("requirement failed: " + jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))))
  };
  var i = start;
  var y = (($m_sr_ScalaRunTime$().array$undlength__O__I(xs) - start) | 0);
  var end = ((start + ((len < y) ? len : y)) | 0);
  while (((i < end) && $$this.hasNext__Z())) {
    $m_sr_ScalaRunTime$().array$undupdate__O__I__O__V(xs, i, $$this.next__O());
    i = ((1 + i) | 0)
  }
}
function $s_sc_Iterator$class__find__sc_Iterator__F1__s_Option($$this, p) {
  while ($$this.hasNext__Z()) {
    var a = $$this.next__O();
    if ($uZ(p.apply__O__O(a))) {
      return new $c_s_Some().init___O(a)
    }
  };
  return $m_s_None$()
}
function $s_sc_Iterator$class__forall__sc_Iterator__F1__Z($$this, p) {
  var res = true;
  while ((res && $$this.hasNext__Z())) {
    res = $uZ(p.apply__O__O($$this.next__O()))
  };
  return res
}
function $s_sc_LinearSeqOptimized$class__isDefinedAt__sc_LinearSeqOptimized__I__Z($$this, x) {
  return ((x >= 0) && ($s_sc_LinearSeqOptimized$class__lengthCompare__sc_LinearSeqOptimized__I__I($$this, x) > 0))
}
function $s_sc_LinearSeqOptimized$class__foldLeft__sc_LinearSeqOptimized__O__F2__O($$this, z, op) {
  var acc = z;
  var these = $$this;
  while ((!these.isEmpty__Z())) {
    acc = op.apply__O__O__O(acc, these.head__O());
    these = $as_sc_LinearSeqOptimized(these.tail__O())
  };
  return acc
}
function $s_sc_LinearSeqOptimized$class__lengthCompare__sc_LinearSeqOptimized__I__I($$this, len) {
  return ((len < 0) ? 1 : $s_sc_LinearSeqOptimized$class__loop$1__p0__sc_LinearSeqOptimized__I__sc_LinearSeqOptimized__I__I($$this, 0, $$this, len))
}
function $s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O($$this, n) {
  var rest = $$this.drop__I__sc_LinearSeqOptimized(n);
  if (((n < 0) || rest.isEmpty__Z())) {
    throw new $c_jl_IndexOutOfBoundsException().init___T(("" + n))
  };
  return rest.head__O()
}
function $s_sc_LinearSeqOptimized$class__exists__sc_LinearSeqOptimized__F1__Z($$this, p) {
  var these = $$this;
  while ((!these.isEmpty__Z())) {
    if ($uZ(p.apply__O__O(these.head__O()))) {
      return true
    };
    these = $as_sc_LinearSeqOptimized(these.tail__O())
  };
  return false
}
function $s_sc_LinearSeqOptimized$class__loop$1__p0__sc_LinearSeqOptimized__I__sc_LinearSeqOptimized__I__I($$this, i, xs, len$1) {
  _loop: while (true) {
    if ((i === len$1)) {
      return (xs.isEmpty__Z() ? 0 : 1)
    } else if (xs.isEmpty__Z()) {
      return (-1)
    } else {
      var temp$i = ((1 + i) | 0);
      var temp$xs = $as_sc_LinearSeqOptimized(xs.tail__O());
      i = temp$i;
      xs = temp$xs;
      continue _loop
    }
  }
}
function $s_sc_LinearSeqOptimized$class__forall__sc_LinearSeqOptimized__F1__Z($$this, p) {
  var these = $$this;
  while ((!these.isEmpty__Z())) {
    if ((!$uZ(p.apply__O__O(these.head__O())))) {
      return false
    };
    these = $as_sc_LinearSeqOptimized(these.tail__O())
  };
  return true
}
function $s_sc_LinearSeqOptimized$class__length__sc_LinearSeqOptimized__I($$this) {
  var these = $$this;
  var len = 0;
  while ((!these.isEmpty__Z())) {
    len = ((1 + len) | 0);
    these = $as_sc_LinearSeqOptimized(these.tail__O())
  };
  return len
}
function $s_sc_LinearSeqOptimized$class__dropRight__sc_LinearSeqOptimized__I__sc_LinearSeqOptimized($$this, n) {
  var b = $$this.companion__scg_GenericCompanion().newBuilder__scm_Builder();
  var these = $$this;
  var lead = $$this.drop__I__sc_LinearSeqOptimized(n);
  while ((!lead.isEmpty__Z())) {
    b.$$plus$eq__O__scm_Builder(these.head__O());
    these = $as_sc_LinearSeqOptimized(these.tail__O());
    lead = $as_sc_LinearSeqOptimized(lead.tail__O())
  };
  return $as_sc_LinearSeqOptimized(b.result__O())
}
function $s_sc_LinearSeqOptimized$class__last__sc_LinearSeqOptimized__O($$this) {
  if ($$this.isEmpty__Z()) {
    throw new $c_ju_NoSuchElementException().init___()
  };
  var these = $$this;
  var nx = $as_sc_LinearSeqOptimized(these.tail__O());
  while ((!nx.isEmpty__Z())) {
    these = nx;
    nx = $as_sc_LinearSeqOptimized(nx.tail__O())
  };
  return these.head__O()
}
function $s_sc_LinearSeqOptimized$class__foldRight__sc_LinearSeqOptimized__O__F2__O($$this, z, op) {
  return ($$this.isEmpty__Z() ? z : op.apply__O__O__O($$this.head__O(), $as_sc_LinearSeqOptimized($$this.tail__O()).foldRight__O__F2__O(z, op)))
}
function $s_sc_LinearSeqOptimized$class__find__sc_LinearSeqOptimized__F1__s_Option($$this, p) {
  var these = $$this;
  while ((!these.isEmpty__Z())) {
    if ($uZ(p.apply__O__O(these.head__O()))) {
      return new $c_s_Some().init___O(these.head__O())
    };
    these = $as_sc_LinearSeqOptimized(these.tail__O())
  };
  return $m_s_None$()
}
function $s_sc_LinearSeqOptimized$class__sameElements__sc_LinearSeqOptimized__sc_GenIterable__Z($$this, that) {
  if ($is_sc_LinearSeq(that)) {
    var x2 = $as_sc_LinearSeq(that);
    if (($$this === x2)) {
      return true
    } else {
      var these = $$this;
      var those = x2;
      while ((((!these.isEmpty__Z()) && (!those.isEmpty__Z())) && $m_sr_BoxesRunTime$().equals__O__O__Z(these.head__O(), those.head__O()))) {
        these = $as_sc_LinearSeqOptimized(these.tail__O());
        those = $as_sc_LinearSeq(those.tail__O())
      };
      return (these.isEmpty__Z() && those.isEmpty__Z())
    }
  } else {
    return $s_sc_IterableLike$class__sameElements__sc_IterableLike__sc_GenIterable__Z($$this, that)
  }
}
function $s_sc_LinearSeqOptimized$class__indexWhere__sc_LinearSeqOptimized__F1__I__I($$this, p, from) {
  var i = from;
  var these = $$this.drop__I__sc_LinearSeqOptimized(from);
  while (true) {
    var this$1 = these;
    if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$1)) {
      if ($uZ(p.apply__O__O(these.head__O()))) {
        return i
      };
      i = ((1 + i) | 0);
      these = $as_sc_LinearSeqOptimized(these.tail__O())
    } else {
      break
    }
  };
  return (-1)
}
function $s_sc_LinearSeqOptimized$class__contains__sc_LinearSeqOptimized__O__Z($$this, elem) {
  var these = $$this;
  while ((!these.isEmpty__Z())) {
    if ($m_sr_BoxesRunTime$().equals__O__O__Z(these.head__O(), elem)) {
      return true
    };
    these = $as_sc_LinearSeqOptimized(these.tail__O())
  };
  return false
}
function $s_sc_LinearSeqOptimized$class__reduceLeft__sc_LinearSeqOptimized__F2__O($$this, f) {
  if ($$this.isEmpty__Z()) {
    throw new $c_jl_UnsupportedOperationException().init___T("empty.reduceLeft")
  } else {
    return $as_sc_LinearSeqOptimized($$this.tail__O()).foldLeft__O__F2__O($$this.head__O(), f)
  }
}
function $s_sc_MapLike$class__filterNot__sc_MapLike__F1__sc_Map($$this, p) {
  var elem = $as_sc_Map($$this);
  var res = new $c_sr_ObjectRef().init___O(elem);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, res$1, p$1) {
    return (function(kv$2) {
      var kv = $as_T2(kv$2);
      if ($uZ(p$1.apply__O__O(kv))) {
        res$1.elem$1 = $as_sc_Map(res$1.elem$1).$$minus__O__sc_Map(kv.$$und1__O())
      }
    })
  })($$this, res, p)));
  return $as_sc_Map(res.elem$1)
}
function $s_sc_MapLike$class__addString__sc_MapLike__scm_StringBuilder__T__T__T__scm_StringBuilder($$this, b, start, sep, end) {
  var this$2 = $$this.iterator__sc_Iterator();
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1) {
    return (function(x0$1$2) {
      var x0$1 = $as_T2(x0$1$2);
      if ((x0$1 !== null)) {
        var k = x0$1.$$und1__O();
        var v = x0$1.$$und2__O();
        return (("" + $m_s_Predef$any2stringadd$().$$plus$extension__O__T__T(k, " -> ")) + v)
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })($$this));
  var this$3 = new $c_sc_Iterator$$anon$11().init___sc_Iterator__F1(this$2, f);
  return $s_sc_TraversableOnce$class__addString__sc_TraversableOnce__scm_StringBuilder__T__T__T__scm_StringBuilder(this$3, b, start, sep, end)
}
function $s_sc_MapLike$class__apply__sc_MapLike__O__O($$this, key) {
  var x1 = $$this.get__O__s_Option(key);
  var x = $m_s_None$();
  if ((x === x1)) {
    return $$this.$default__O__O(key)
  } else if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var value = x2.x$2;
    return value
  } else {
    throw new $c_s_MatchError().init___O(x1)
  }
}
function $s_sc_MapLike$class__isEmpty__sc_MapLike__Z($$this) {
  return ($$this.size__I() === 0)
}
function $s_sc_MapLike$class__toBuffer__sc_MapLike__scm_Buffer($$this) {
  var result = new $c_scm_ArrayBuffer().init___I($$this.size__I());
  var xs = $$this.seq__sc_TraversableOnce();
  result.$$plus$plus$eq__sc_TraversableOnce__scm_ArrayBuffer(xs);
  return result
}
function $s_sc_MapLike$class__contains__sc_MapLike__O__Z($$this, key) {
  return $$this.get__O__s_Option(key).isDefined__Z()
}
function $s_sc_MapLike$class__$default__sc_MapLike__O__O($$this, key) {
  throw new $c_ju_NoSuchElementException().init___T(("key not found: " + key))
}
function $s_sc_SeqLike$class__indices__sc_SeqLike__sci_Range($$this) {
  var end = $$this.length__I();
  return new $c_sci_Range().init___I__I__I(0, end, 1)
}
function $s_sc_SeqLike$class__isEmpty__sc_SeqLike__Z($$this) {
  return ($$this.lengthCompare__I__I(0) === 0)
}
function $s_sc_SeqLike$class__padTo__sc_SeqLike__I__O__scg_CanBuildFrom__O($$this, len, elem, bf) {
  var b = bf.apply__O__scm_Builder($$this.repr__O());
  var L = $$this.length__I();
  b.sizeHint__I__V(((L > len) ? L : len));
  var diff = ((len - L) | 0);
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($$this.thisCollection__sc_Seq());
  while ((diff > 0)) {
    b.$$plus$eq__O__scm_Builder(elem);
    diff = (((-1) + diff) | 0)
  };
  return b.result__O()
}
function $s_sc_SeqLike$class__$$plus$colon__sc_SeqLike__O__scg_CanBuildFrom__O($$this, elem, bf) {
  var b = bf.apply__O__scm_Builder($$this.repr__O());
  b.$$plus$eq__O__scm_Builder(elem);
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($$this.thisCollection__sc_Seq());
  return b.result__O()
}
function $s_sc_SeqLike$class__reverse__sc_SeqLike__O($$this) {
  var elem = $m_sci_Nil$();
  var xs = new $c_sr_ObjectRef().init___O(elem);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, xs$1) {
    return (function(x$2) {
      var this$2 = $as_sci_List(xs$1.elem$1);
      xs$1.elem$1 = new $c_sci_$colon$colon().init___O__sci_List(x$2, this$2)
    })
  })($$this, xs)));
  var b = $$this.newBuilder__scm_Builder();
  $s_scm_Builder$class__sizeHint__scm_Builder__sc_TraversableLike__V(b, $$this);
  var this$3 = $as_sci_List(xs.elem$1);
  var these = this$3;
  while ((!these.isEmpty__Z())) {
    var arg1 = these.head__O();
    b.$$plus$eq__O__scm_Builder(arg1);
    these = $as_sci_List(these.tail__O())
  };
  return b.result__O()
}
function $s_sc_SeqLike$class__sortBy__sc_SeqLike__F1__s_math_Ordering__O($$this, f, ord) {
  var ord$1 = new $c_s_math_Ordering$$anon$5().init___s_math_Ordering__F1(ord, f);
  return $s_sc_SeqLike$class__sorted__sc_SeqLike__s_math_Ordering__O($$this, ord$1)
}
function $s_sc_SeqLike$class__reverseIterator__sc_SeqLike__sc_Iterator($$this) {
  return $$this.toCollection__O__sc_Seq($$this.reverse__O()).iterator__sc_Iterator()
}
function $s_sc_SeqLike$class__$$colon$plus__sc_SeqLike__O__scg_CanBuildFrom__O($$this, elem, bf) {
  var b = bf.apply__O__scm_Builder($$this.repr__O());
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($$this.thisCollection__sc_Seq());
  b.$$plus$eq__O__scm_Builder(elem);
  return b.result__O()
}
function $s_sc_SeqLike$class__sorted__sc_SeqLike__s_math_Ordering__O($$this, ord) {
  var len = $$this.length__I();
  var b = $$this.newBuilder__scm_Builder();
  if ((len === 1)) {
    b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($$this)
  } else if ((len > 1)) {
    b.sizeHint__I__V(len);
    var arr = $newArrayObject($d_O.getArrayOf(), [len]);
    var i = new $c_sr_IntRef().init___I(0);
    $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, arr$1, i$1) {
      return (function(x$2) {
        arr$1.set(i$1.elem$1, x$2);
        i$1.elem$1 = ((1 + i$1.elem$1) | 0)
      })
    })($$this, arr, i)));
    $m_ju_Arrays$().sort__AO__ju_Comparator__V(arr, ord);
    i.elem$1 = 0;
    while ((i.elem$1 < arr.u.length)) {
      b.$$plus$eq__O__scm_Builder(arr.get(i.elem$1));
      i.elem$1 = ((1 + i.elem$1) | 0)
    }
  };
  return b.result__O()
}
function $s_sc_SeqLike$class__diff__sc_SeqLike__sc_GenSeq__O($$this, that) {
  var occ = $s_sc_SeqLike$class__occCounts__p0__sc_SeqLike__sc_Seq__scm_Map($$this, that.seq__sc_Seq());
  var b = $$this.newBuilder__scm_Builder();
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, occ$1, b$1) {
    return (function(x$2) {
      var ox = $uI(occ$1.apply__O__O(x$2));
      return ((ox === 0) ? b$1.$$plus$eq__O__scm_Builder(x$2) : (occ$1.update__O__O__V(x$2, (((-1) + ox) | 0)), (void 0)))
    })
  })($$this, occ, b)));
  return b.result__O()
}
function $s_sc_SeqLike$class__contains__sc_SeqLike__O__Z($$this, elem) {
  return $$this.exists__F1__Z(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, elem$1) {
    return (function(x$12$2) {
      return $m_sr_BoxesRunTime$().equals__O__O__Z(x$12$2, elem$1)
    })
  })($$this, elem)))
}
function $s_sc_SeqLike$class__distinct__sc_SeqLike__O($$this) {
  var b = $$this.newBuilder__scm_Builder();
  var seen = $as_scm_HashSet($m_scm_HashSet$().apply__sc_Seq__sc_GenTraversable($m_sci_Nil$()));
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, b$1, seen$1) {
    return (function(x$2) {
      return ((!$s_scm_FlatHashTable$class__containsElem__scm_FlatHashTable__O__Z(seen$1, x$2)) ? (b$1.$$plus$eq__O__scm_Builder(x$2), seen$1.$$plus$eq__O__scm_HashSet(x$2)) : (void 0))
    })
  })($$this, b, seen)));
  return b.result__O()
}
function $s_sc_SeqLike$class__indexWhere__sc_SeqLike__F1__I__I($$this, p, from) {
  var i = from;
  var it = $$this.iterator__sc_Iterator().drop__I__sc_Iterator(from);
  while (it.hasNext__Z()) {
    if ($uZ(p.apply__O__O(it.next__O()))) {
      return i
    } else {
      i = ((1 + i) | 0)
    }
  };
  return (-1)
}
function $s_sc_SeqLike$class__occCounts__p0__sc_SeqLike__sc_Seq__scm_Map($$this, sq) {
  var occ = new $c_sc_SeqLike$$anon$1().init___sc_SeqLike($$this);
  sq.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, occ$1) {
    return (function(y$2) {
      var value = ((1 + $uI(occ$1.apply__O__O(y$2))) | 0);
      occ$1.put__O__O__s_Option(y$2, value)
    })
  })($$this, occ)));
  return occ
}
function $s_sc_SeqLike$class__lengthCompare__sc_SeqLike__I__I($$this, len) {
  if ((len < 0)) {
    return 1
  } else {
    var i = 0;
    var it = $$this.iterator__sc_Iterator();
    while (it.hasNext__Z()) {
      if ((i === len)) {
        return (it.hasNext__Z() ? 1 : 0)
      };
      it.next__O();
      i = ((1 + i) | 0)
    };
    return ((i - len) | 0)
  }
}
function $s_sc_SetLike$class__isEmpty__sc_SetLike__Z($$this) {
  return ($$this.size__I() === 0)
}
function $s_sc_SetLike$class__$$plus$plus__sc_SetLike__sc_GenTraversableOnce__sc_Set($$this, elems) {
  var x$1 = $as_sc_Set($$this);
  return $as_sc_Set(elems.seq__sc_TraversableOnce().$$div$colon__O__F2__O(x$1, new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($$this$1) {
    return (function(x$2$2, x$3$2) {
      var x$2 = $as_sc_Set(x$2$2);
      return x$2.$$plus__O__sc_Set(x$3$2)
    })
  })($$this))))
}
function $s_sc_SetLike$class__toBuffer__sc_SetLike__scm_Buffer($$this) {
  var result = new $c_scm_ArrayBuffer().init___I($$this.size__I());
  var xs = $$this.seq__sc_TraversableOnce();
  result.$$plus$plus$eq__sc_TraversableOnce__scm_ArrayBuffer(xs);
  return result
}
function $s_sc_TraversableLike$class__headOption__sc_TraversableLike__s_Option($$this) {
  return ($$this.isEmpty__Z() ? $m_s_None$() : new $c_s_Some().init___O($$this.head__O()))
}
function $s_sc_TraversableLike$class__collect__sc_TraversableLike__s_PartialFunction__scg_CanBuildFrom__O($$this, pf, bf) {
  var b = bf.apply__O__scm_Builder($$this.repr__O());
  $$this.foreach__F1__V(pf.runWith__F1__F1(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, b$1) {
    return (function(x$1$2) {
      return b$1.$$plus$eq__O__scm_Builder(x$1$2)
    })
  })($$this, b))));
  return b.result__O()
}
function $s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O($$this, cbf) {
  var b = cbf.apply__scm_Builder();
  $s_scm_Builder$class__sizeHint__scm_Builder__sc_TraversableLike__V(b, $$this);
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($$this.thisCollection__sc_Traversable());
  return b.result__O()
}
function $s_sc_TraversableLike$class__toString__sc_TraversableLike__T($$this) {
  return $$this.mkString__T__T__T__T(($$this.stringPrefix__T() + "("), ", ", ")")
}
function $s_sc_TraversableLike$class__flatMap__sc_TraversableLike__F1__scg_CanBuildFrom__O($$this, f, bf) {
  var b = bf.apply__O__scm_Builder($$this.repr__O());
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, b$1, f$1) {
    return (function(x$2) {
      return $as_scm_Builder(b$1.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($as_sc_GenTraversableOnce(f$1.apply__O__O(x$2)).seq__sc_TraversableOnce()))
    })
  })($$this, b, f)));
  return b.result__O()
}
function $s_sc_TraversableLike$class__map__sc_TraversableLike__F1__scg_CanBuildFrom__O($$this, f, bf) {
  var b = $s_sc_TraversableLike$class__builder$1__p0__sc_TraversableLike__scg_CanBuildFrom__scm_Builder($$this, bf);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, b$1, f$1) {
    return (function(x$2) {
      return b$1.$$plus$eq__O__scm_Builder(f$1.apply__O__O(x$2))
    })
  })($$this, b, f)));
  return b.result__O()
}
function $s_sc_TraversableLike$class__filterImpl__p0__sc_TraversableLike__F1__Z__O($$this, p, isFlipped) {
  var b = $$this.newBuilder__scm_Builder();
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, p$1, isFlipped$1, b$1) {
    return (function(x$2) {
      return (($uZ(p$1.apply__O__O(x$2)) !== isFlipped$1) ? b$1.$$plus$eq__O__scm_Builder(x$2) : (void 0))
    })
  })($$this, p, isFlipped, b)));
  return b.result__O()
}
function $s_sc_TraversableLike$class__tail__sc_TraversableLike__O($$this) {
  if ($$this.isEmpty__Z()) {
    throw new $c_jl_UnsupportedOperationException().init___T("empty.tail")
  };
  return $$this.drop__I__O(1)
}
function $s_sc_TraversableLike$class__$$plus$plus__sc_TraversableLike__sc_GenTraversableOnce__scg_CanBuildFrom__O($$this, that, bf) {
  var b = bf.apply__O__scm_Builder($$this.repr__O());
  if ($is_sc_IndexedSeqLike(that)) {
    var delta = that.seq__sc_TraversableOnce().size__I();
    $s_scm_Builder$class__sizeHint__scm_Builder__sc_TraversableLike__I__V(b, $$this, delta)
  };
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($$this.thisCollection__sc_Traversable());
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(that.seq__sc_TraversableOnce());
  return b.result__O()
}
function $s_sc_TraversableLike$class__builder$1__p0__sc_TraversableLike__scg_CanBuildFrom__scm_Builder($$this, bf$1) {
  var b = bf$1.apply__O__scm_Builder($$this.repr__O());
  $s_scm_Builder$class__sizeHint__scm_Builder__sc_TraversableLike__V(b, $$this);
  return b
}
function $s_sc_TraversableLike$class__stringPrefix__sc_TraversableLike__T($$this) {
  var this$1 = $$this.repr__O();
  var string = $objectGetClass(this$1).getName__T();
  var idx1 = $m_sjsr_RuntimeString$().lastIndexOf__T__I__I(string, 46);
  if ((idx1 !== (-1))) {
    var thiz = string;
    var beginIndex = ((1 + idx1) | 0);
    string = $as_T(thiz.substring(beginIndex))
  };
  var idx2 = $m_sjsr_RuntimeString$().indexOf__T__I__I(string, 36);
  if ((idx2 !== (-1))) {
    var thiz$1 = string;
    string = $as_T(thiz$1.substring(0, idx2))
  };
  return string
}
function $s_sc_TraversableLike$class__partition__sc_TraversableLike__F1__T2($$this, p) {
  var l = $$this.newBuilder__scm_Builder();
  var r = $$this.newBuilder__scm_Builder();
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, l$1, r$1, p$1) {
    return (function(x$2) {
      return ($uZ(p$1.apply__O__O(x$2)) ? l$1 : r$1).$$plus$eq__O__scm_Builder(x$2)
    })
  })($$this, l, r, p)));
  return new $c_T2().init___O__O(l.result__O(), r.result__O())
}
function $s_sc_TraversableLike$class__last__sc_TraversableLike__O($$this) {
  var elem = $$this.head__O();
  var lst = new $c_sr_ObjectRef().init___O(elem);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, lst$1) {
    return (function(x$2) {
      lst$1.elem$1 = x$2
    })
  })($$this, lst)));
  return lst.elem$1
}
function $s_sc_TraversableOnce$class__collectFirst__sc_TraversableOnce__s_PartialFunction__s_Option($$this, pf) {
  var nonLocalReturnKey1 = new $c_O().init___();
  try {
    if ($is_sc_Iterator($$this)) {
      var x2 = $as_sc_Iterator($$this);
      var i = x2
    } else {
      if ((!$is_sc_GenIterable($$this))) {
        $$this.foreach__F1__V(pf.runWith__F1__F1(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, nonLocalReturnKey1$1) {
          return (function(b$2) {
            throw new $c_sr_NonLocalReturnControl().init___O__O(nonLocalReturnKey1$1, new $c_s_Some().init___O(b$2))
          })
        })($$this, nonLocalReturnKey1))));
        return $m_s_None$()
      };
      var i = $$this.toIterator__sc_Iterator()
    };
    var sentinel = new $c_sc_TraversableOnce$$anon$2().init___sc_TraversableOnce($$this);
    while (i.hasNext__Z()) {
      var x = pf.applyOrElse__O__F1__O(i.next__O(), sentinel);
      if ((x !== sentinel)) {
        return new $c_s_Some().init___O(x)
      }
    };
    return $m_s_None$()
  } catch (e) {
    if ($is_sr_NonLocalReturnControl(e)) {
      var ex = $as_sr_NonLocalReturnControl(e);
      if ((ex.key$2 === nonLocalReturnKey1)) {
        return $as_s_Option(ex.value$f)
      } else {
        throw ex
      }
    } else {
      throw e
    }
  }
}
function $s_sc_TraversableOnce$class__to__sc_TraversableOnce__scg_CanBuildFrom__O($$this, cbf) {
  var b = cbf.apply__scm_Builder();
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($$this.seq__sc_TraversableOnce());
  return b.result__O()
}
function $s_sc_TraversableOnce$class__addString__sc_TraversableOnce__scm_StringBuilder__T__T__T__scm_StringBuilder($$this, b, start, sep, end) {
  var first = new $c_sr_BooleanRef().init___Z(true);
  b.append__T__scm_StringBuilder(start);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, first$1, b$1, sep$1) {
    return (function(x$2) {
      if (first$1.elem$1) {
        b$1.append__O__scm_StringBuilder(x$2);
        first$1.elem$1 = false;
        return (void 0)
      } else {
        b$1.append__T__scm_StringBuilder(sep$1);
        return b$1.append__O__scm_StringBuilder(x$2)
      }
    })
  })($$this, first, b, sep)));
  b.append__T__scm_StringBuilder(end);
  return b
}
function $s_sc_TraversableOnce$class__reduceLeft__sc_TraversableOnce__F2__O($$this, op) {
  if ($$this.isEmpty__Z()) {
    throw new $c_jl_UnsupportedOperationException().init___T("empty.reduceLeft")
  };
  var first = new $c_sr_BooleanRef().init___Z(true);
  var acc = new $c_sr_ObjectRef().init___O(0);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, first$1, acc$1, op$1) {
    return (function(x$2) {
      if (first$1.elem$1) {
        acc$1.elem$1 = x$2;
        first$1.elem$1 = false
      } else {
        acc$1.elem$1 = op$1.apply__O__O__O(acc$1.elem$1, x$2)
      }
    })
  })($$this, first, acc, op)));
  return acc.elem$1
}
function $s_sc_TraversableOnce$class__toArray__sc_TraversableOnce__s_reflect_ClassTag__O($$this, evidence$1) {
  if ($$this.isTraversableAgain__Z()) {
    var result = evidence$1.newArray__I__O($$this.size__I());
    $$this.copyToArray__O__I__V(result, 0);
    return result
  } else {
    return $$this.toBuffer__scm_Buffer().toArray__s_reflect_ClassTag__O(evidence$1)
  }
}
function $s_sc_TraversableOnce$class__foldLeft__sc_TraversableOnce__O__F2__O($$this, z, op) {
  var result = new $c_sr_ObjectRef().init___O(z);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, result$1, op$1) {
    return (function(x$2) {
      result$1.elem$1 = op$1.apply__O__O__O(result$1.elem$1, x$2)
    })
  })($$this, result, op)));
  return result.elem$1
}
function $s_sc_TraversableOnce$class__max__sc_TraversableOnce__s_math_Ordering__O($$this, cmp) {
  if ($$this.isEmpty__Z()) {
    throw new $c_jl_UnsupportedOperationException().init___T("empty.max")
  };
  return $$this.reduceLeft__F2__O(new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($$this$1, cmp$1) {
    return (function(x$2, y$2) {
      return (cmp$1.gteq__O__O__Z(x$2, y$2) ? x$2 : y$2)
    })
  })($$this, cmp)))
}
function $s_sc_TraversableOnce$class__mkString__sc_TraversableOnce__T__T__T__T($$this, start, sep, end) {
  var this$1 = $$this.addString__scm_StringBuilder__T__T__T__scm_StringBuilder(new $c_scm_StringBuilder().init___(), start, sep, end);
  return this$1.underlying$5.java$lang$StringBuilder$$content$f
}
function $s_sc_TraversableOnce$class__foldRight__sc_TraversableOnce__O__F2__O($$this, z, op) {
  var this$1 = $s_sc_TraversableOnce$class__reversed__sc_TraversableOnce__sci_List($$this);
  var acc = z;
  var these = this$1;
  while ((!these.isEmpty__Z())) {
    var arg1 = acc;
    var arg2 = these.head__O();
    acc = op.apply__O__O__O(arg2, arg1);
    these = $as_sc_LinearSeqOptimized(these.tail__O())
  };
  return acc
}
function $s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z($$this) {
  return (!$$this.isEmpty__Z())
}
function $s_sc_TraversableOnce$class__size__sc_TraversableOnce__I($$this) {
  var result = new $c_sr_IntRef().init___I(0);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, result$1) {
    return (function(x$2) {
      result$1.elem$1 = ((1 + result$1.elem$1) | 0)
    })
  })($$this, result)));
  return result.elem$1
}
function $s_sc_TraversableOnce$class__sum__sc_TraversableOnce__s_math_Numeric__O($$this, num) {
  return $$this.foldLeft__O__F2__O(0, new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($$this$1, num$1) {
    return (function(x$2, y$2) {
      var x = $uI(x$2);
      var y = $uI(y$2);
      return $s_s_math_Numeric$IntIsIntegral$class__plus__s_math_Numeric$IntIsIntegral__I__I__I(num$1, x, y)
    })
  })($$this, num)))
}
function $s_sc_TraversableOnce$class__copyToArray__sc_TraversableOnce__O__I__V($$this, xs, start) {
  $$this.copyToArray__O__I__I__V(xs, start, (($m_sr_ScalaRunTime$().array$undlength__O__I(xs) - start) | 0))
}
function $s_sc_TraversableOnce$class__reversed__sc_TraversableOnce__sci_List($$this) {
  var elem = $m_sci_Nil$();
  var elems = new $c_sr_ObjectRef().init___O(elem);
  $$this.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, elems$1) {
    return (function(x$1$2) {
      var this$2 = $as_sci_List(elems$1.elem$1);
      elems$1.elem$1 = new $c_sci_$colon$colon().init___O__sci_List(x$1$2, this$2)
    })
  })($$this, elems)));
  return $as_sci_List(elems.elem$1)
}
function $s_sc_convert_DecorateAsJava$class__mutableMapAsJavaMapConverter__sc_convert_DecorateAsJava__scm_Map__sc_convert_Decorators$AsJava($$this, m) {
  return new $c_sc_convert_Decorators$AsJava().init___sc_convert_Decorators__F0($m_sc_convert_Decorators$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($$this$1, m$1) {
    return (function() {
      var this$1 = $m_sc_convert_WrapAsJava$();
      return $s_sc_convert_WrapAsJava$class__mutableMapAsJavaMap__sc_convert_WrapAsJava__scm_Map__ju_Map(this$1, m$1)
    })
  })($$this, m)))
}
function $s_sc_convert_DecorateAsJava$class__setAsJavaSetConverter__sc_convert_DecorateAsJava__sc_Set__sc_convert_Decorators$AsJava($$this, s) {
  return new $c_sc_convert_Decorators$AsJava().init___sc_convert_Decorators__F0($m_sc_convert_Decorators$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($$this$1, s$1) {
    return (function() {
      var this$1 = $m_sc_convert_WrapAsJava$();
      return $s_sc_convert_WrapAsJava$class__setAsJavaSet__sc_convert_WrapAsJava__sc_Set__ju_Set(this$1, s$1)
    })
  })($$this, s)))
}
function $s_sc_convert_DecorateAsJava$class__mutableSetAsJavaSetConverter__sc_convert_DecorateAsJava__scm_Set__sc_convert_Decorators$AsJava($$this, s) {
  return new $c_sc_convert_Decorators$AsJava().init___sc_convert_Decorators__F0($m_sc_convert_Decorators$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($$this$1, s$1) {
    return (function() {
      var this$1 = $m_sc_convert_WrapAsJava$();
      return $s_sc_convert_WrapAsJava$class__mutableSetAsJavaSet__sc_convert_WrapAsJava__scm_Set__ju_Set(this$1, s$1)
    })
  })($$this, s)))
}
function $s_sc_convert_DecorateAsScala$class__propertiesAsScalaMapConverter__sc_convert_DecorateAsScala__ju_Properties__sc_convert_Decorators$AsScala($$this, p) {
  return new $c_sc_convert_Decorators$AsScala().init___sc_convert_Decorators__F0($m_sc_convert_Decorators$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($$this$1, p$1) {
    return (function() {
      var this$1 = $m_sc_convert_WrapAsScala$();
      return $s_sc_convert_WrapAsScala$class__propertiesAsScalaMap__sc_convert_WrapAsScala__ju_Properties__scm_Map(this$1, p$1)
    })
  })($$this, p)))
}
function $s_sc_convert_DecorateAsScala$class__asScalaIteratorConverter__sc_convert_DecorateAsScala__ju_Iterator__sc_convert_Decorators$AsScala($$this, i) {
  return new $c_sc_convert_Decorators$AsScala().init___sc_convert_Decorators__F0($m_sc_convert_Decorators$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($$this$1, i$1) {
    return (function() {
      var this$1 = $m_sc_convert_WrapAsScala$();
      return $s_sc_convert_WrapAsScala$class__asScalaIterator__sc_convert_WrapAsScala__ju_Iterator__sc_Iterator(this$1, i$1)
    })
  })($$this, i)))
}
function $s_sc_convert_DecorateAsScala$class__asScalaBufferConverter__sc_convert_DecorateAsScala__ju_List__sc_convert_Decorators$AsScala($$this, l) {
  return new $c_sc_convert_Decorators$AsScala().init___sc_convert_Decorators__F0($m_sc_convert_Decorators$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($$this$1, l$1) {
    return (function() {
      var this$1 = $m_sc_convert_WrapAsScala$();
      return $s_sc_convert_WrapAsScala$class__asScalaBuffer__sc_convert_WrapAsScala__ju_List__scm_Buffer(this$1, l$1)
    })
  })($$this, l)))
}
function $s_sc_convert_DecorateAsScala$class__mapAsScalaMapConverter__sc_convert_DecorateAsScala__ju_Map__sc_convert_Decorators$AsScala($$this, m) {
  return new $c_sc_convert_Decorators$AsScala().init___sc_convert_Decorators__F0($m_sc_convert_Decorators$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($$this$1, m$1) {
    return (function() {
      var this$1 = $m_sc_convert_WrapAsScala$();
      return $s_sc_convert_WrapAsScala$class__mapAsScalaMap__sc_convert_WrapAsScala__ju_Map__scm_Map(this$1, m$1)
    })
  })($$this, m)))
}
function $s_sc_convert_DecorateAsScala$class__asScalaSetConverter__sc_convert_DecorateAsScala__ju_Set__sc_convert_Decorators$AsScala($$this, s) {
  return new $c_sc_convert_Decorators$AsScala().init___sc_convert_Decorators__F0($m_sc_convert_Decorators$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($$this$1, s$1) {
    return (function() {
      var this$1 = $m_sc_convert_WrapAsScala$();
      return $s_sc_convert_WrapAsScala$class__asScalaSet__sc_convert_WrapAsScala__ju_Set__scm_Set(this$1, s$1)
    })
  })($$this, s)))
}
function $s_sc_convert_WrapAsJava$class__mutableMapAsJavaMap__sc_convert_WrapAsJava__scm_Map__ju_Map($$this, m) {
  if ($is_sc_convert_Wrappers$JMapWrapper(m)) {
    var x2 = $as_sc_convert_Wrappers$JMapWrapper(m);
    var wrapped = x2.underlying$5;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$MutableMapWrapper().init___sc_convert_Wrappers__scm_Map($m_sc_convert_Wrappers$(), m)
  }
}
function $s_sc_convert_WrapAsJava$class__setAsJavaSet__sc_convert_WrapAsJava__sc_Set__ju_Set($$this, s) {
  if ($is_sc_convert_Wrappers$JSetWrapper(s)) {
    var x2 = $as_sc_convert_Wrappers$JSetWrapper(s);
    var wrapped = x2.underlying$5;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$SetWrapper().init___sc_convert_Wrappers__sc_Set($m_sc_convert_Wrappers$(), s)
  }
}
function $s_sc_convert_WrapAsJava$class__mutableSetAsJavaSet__sc_convert_WrapAsJava__scm_Set__ju_Set($$this, s) {
  if ($is_sc_convert_Wrappers$JSetWrapper(s)) {
    var x2 = $as_sc_convert_Wrappers$JSetWrapper(s);
    var wrapped = x2.underlying$5;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$MutableSetWrapper().init___sc_convert_Wrappers__scm_Set($m_sc_convert_Wrappers$(), s)
  }
}
function $s_sc_convert_WrapAsScala$class__asScalaBuffer__sc_convert_WrapAsScala__ju_List__scm_Buffer($$this, l) {
  if ($is_sc_convert_Wrappers$MutableBufferWrapper(l)) {
    var x2 = $as_sc_convert_Wrappers$MutableBufferWrapper(l);
    var wrapped = x2.underlying__scm_Buffer();
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$JListWrapper().init___sc_convert_Wrappers__ju_List($m_sc_convert_Wrappers$(), l)
  }
}
function $s_sc_convert_WrapAsScala$class__propertiesAsScalaMap__sc_convert_WrapAsScala__ju_Properties__scm_Map($$this, p) {
  return new $c_sc_convert_Wrappers$JPropertiesWrapper().init___sc_convert_Wrappers__ju_Properties($m_sc_convert_Wrappers$(), p)
}
function $s_sc_convert_WrapAsScala$class__asScalaIterator__sc_convert_WrapAsScala__ju_Iterator__sc_Iterator($$this, it) {
  if ($is_sc_convert_Wrappers$IteratorWrapper(it)) {
    var x2 = $as_sc_convert_Wrappers$IteratorWrapper(it);
    var wrapped = x2.underlying__sc_Iterator();
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$JIteratorWrapper().init___sc_convert_Wrappers__ju_Iterator($m_sc_convert_Wrappers$(), it)
  }
}
function $s_sc_convert_WrapAsScala$class__asScalaSet__sc_convert_WrapAsScala__ju_Set__scm_Set($$this, s) {
  if ($is_sc_convert_Wrappers$MutableSetWrapper(s)) {
    var x2 = $as_sc_convert_Wrappers$MutableSetWrapper(s);
    var wrapped = x2.underlying$4;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$JSetWrapper().init___sc_convert_Wrappers__ju_Set($m_sc_convert_Wrappers$(), s)
  }
}
function $s_sc_convert_WrapAsScala$class__mapAsScalaMap__sc_convert_WrapAsScala__ju_Map__scm_Map($$this, m) {
  if ($is_sc_convert_Wrappers$MutableMapWrapper(m)) {
    var x2 = $as_sc_convert_Wrappers$MutableMapWrapper(m);
    var wrapped = x2.underlying$3;
    return wrapped
  } else {
    return new $c_sc_convert_Wrappers$JMapWrapper().init___sc_convert_Wrappers__ju_Map($m_sc_convert_Wrappers$(), m)
  }
}
function $s_sc_convert_Wrappers$JMapWrapperLike$class__$$minus$eq__sc_convert_Wrappers$JMapWrapperLike__O__sc_convert_Wrappers$JMapWrapperLike($$this, key) {
  $$this.underlying$5.remove__O__O(key);
  return $$this
}
function $s_sc_convert_Wrappers$JMapWrapperLike$class__$$plus$eq__sc_convert_Wrappers$JMapWrapperLike__T2__sc_convert_Wrappers$JMapWrapperLike($$this, kv) {
  $$this.underlying$5.put__O__O__O(kv.$$und1__O(), kv.$$und2__O());
  return $$this
}
function $s_sc_convert_Wrappers$JMapWrapperLike$class__get__sc_convert_Wrappers$JMapWrapperLike__O__s_Option($$this, k) {
  var v = $$this.underlying$5.get__O__O(k);
  return ((v !== null) ? new $c_s_Some().init___O(v) : ($$this.underlying$5.containsKey__O__Z(k) ? new $c_s_Some().init___O(null) : $m_s_None$()))
}
function $s_sc_convert_Wrappers$JMapWrapperLike$class__remove__sc_convert_Wrappers$JMapWrapperLike__O__s_Option($$this, k) {
  return $m_s_Option$().apply__O__s_Option($$this.underlying$5.remove__O__O(k))
}
function $s_sc_convert_Wrappers$JMapWrapperLike$class__put__sc_convert_Wrappers$JMapWrapperLike__O__O__s_Option($$this, k, v) {
  return $m_s_Option$().apply__O__s_Option($$this.underlying$5.put__O__O__O(k, v))
}
function $s_scg_Growable$class__loop$1__p0__scg_Growable__sc_LinearSeq__V($$this, xs) {
  _loop: while (true) {
    var this$1 = xs;
    if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$1)) {
      $$this.$$plus$eq__O__scg_Growable(xs.head__O());
      xs = $as_sc_LinearSeq(xs.tail__O());
      continue _loop
    };
    break
  }
}
function $s_scg_Growable$class__$$plus$plus$eq__scg_Growable__sc_TraversableOnce__scg_Growable($$this, xs) {
  if ($is_sc_LinearSeq(xs)) {
    var x2 = $as_sc_LinearSeq(xs);
    $s_scg_Growable$class__loop$1__p0__scg_Growable__sc_LinearSeq__V($$this, x2)
  } else {
    xs.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1) {
      return (function(elem$2) {
        return $$this$1.$$plus$eq__O__scg_Growable(elem$2)
      })
    })($$this)))
  };
  return $$this
}
function $s_sci_DefaultMap$class__$$plus__sci_DefaultMap__T2__sci_Map($$this, kv) {
  var b = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  $s_scg_Growable$class__$$plus$plus$eq__scg_Growable__sc_TraversableOnce__scg_Growable(b, $$this);
  var elem = new $c_T2().init___O__O(kv.$$und1__O(), kv.$$und2__O());
  b.$$plus$eq__T2__scm_MapBuilder(elem);
  return $as_sci_Map(b.elems$1)
}
function $s_sci_DefaultMap$class__$$minus__sci_DefaultMap__O__sci_Map($$this, key) {
  var b = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  var p = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, key$1) {
    return (function(kv$2) {
      var kv = $as_T2(kv$2);
      return (!$m_sr_BoxesRunTime$().equals__O__O__Z(kv.$$und1__O(), key$1))
    })
  })($$this, key));
  new $c_sc_TraversableLike$WithFilter().init___sc_TraversableLike__F1($$this, p).foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$2, b$1) {
    return (function(kv$3$2) {
      var kv$3 = $as_T2(kv$3$2);
      return b$1.$$plus$eq__O__scm_Builder(kv$3)
    })
  })($$this, b)));
  return $as_sci_Map(b.elems$1)
}
function $s_sci_MapLike$class__$$plus$plus__sci_MapLike__sc_GenTraversableOnce__sci_Map($$this, xs) {
  var x$1 = $as_sci_Map($$this);
  return $as_sci_Map(xs.seq__sc_TraversableOnce().$$div$colon__O__F2__O(x$1, new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($$this$1) {
    return (function(x$2$2, x$3$2) {
      var x$2 = $as_sci_Map(x$2$2);
      var x$3 = $as_T2(x$3$2);
      return x$2.$$plus__T2__sci_Map(x$3)
    })
  })($$this))))
}
function $s_sci_MapLike$class__updated__sci_MapLike__O__O__sci_Map($$this, key, value) {
  return $$this.$$plus__T2__sci_Map(new $c_T2().init___O__O(key, value))
}
function $s_sci_StringLike$class__split__sci_StringLike__C__AT($$this, separator) {
  var thisString = $$this.toString__T();
  var pos = $m_sjsr_RuntimeString$().indexOf__T__I__I(thisString, separator);
  if ((pos !== (-1))) {
    var res = new $c_scm_ArrayBuilder$ofRef().init___s_reflect_ClassTag(new $c_s_reflect_ClassTag$ClassClassTag().init___jl_Class($d_T.getClassOf()));
    var prev = 0;
    do {
      var beginIndex = prev;
      var endIndex = pos;
      res.$$plus$eq__O__scm_ArrayBuilder$ofRef($as_T(thisString.substring(beginIndex, endIndex)));
      prev = ((1 + pos) | 0);
      pos = $m_sjsr_RuntimeString$().indexOf__T__I__I__I(thisString, separator, prev)
    } while ((pos !== (-1)));
    if ((prev !== $uI(thisString.length))) {
      var beginIndex$1 = prev;
      var endIndex$1 = $uI(thisString.length);
      res.$$plus$eq__O__scm_ArrayBuilder$ofRef($as_T(thisString.substring(beginIndex$1, endIndex$1)))
    };
    var initialResult = $asArrayOf_T(res.result__AO(), 1);
    pos = initialResult.u.length;
    while (true) {
      if ((pos > 0)) {
        var thiz = initialResult.get((((-1) + pos) | 0));
        if ((thiz === null)) {
          throw new $c_jl_NullPointerException().init___()
        };
        var jsx$1 = (thiz === "")
      } else {
        var jsx$1 = false
      };
      if (jsx$1) {
        pos = (((-1) + pos) | 0)
      } else {
        break
      }
    };
    if ((pos !== initialResult.u.length)) {
      var trimmed = $newArrayObject($d_T.getArrayOf(), [pos]);
      $m_s_Array$().copy__O__I__O__I__I__V(initialResult, 0, trimmed, 0, pos);
      return trimmed
    } else {
      return initialResult
    }
  } else {
    var array = [thisString];
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
    var len = $uI(xs.array$6.length);
    var array$1 = $newArrayObject($d_T.getArrayOf(), [len]);
    var elem$1 = 0;
    elem$1 = 0;
    var this$14 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
    while (this$14.hasNext__Z()) {
      var arg1 = this$14.next__O();
      array$1.set(elem$1, arg1);
      elem$1 = ((1 + elem$1) | 0)
    };
    return array$1
  }
}
function $s_sci_StringLike$class__parseBoolean__p0__sci_StringLike__T__Z($$this, s) {
  if ((s !== null)) {
    var x1 = $as_T(s.toLowerCase());
    if ((x1 === "true")) {
      return true
    } else if ((x1 === "false")) {
      return false
    } else {
      throw new $c_jl_IllegalArgumentException().init___T((("For input string: \"" + s) + "\""))
    }
  } else {
    throw new $c_jl_IllegalArgumentException().init___T("For input string: \"null\"")
  }
}
function $s_sci_StringLike$class__replaceAllLiterally__sci_StringLike__T__T__T($$this, literal, replacement) {
  var arg1 = $m_ju_regex_Pattern$().quote__T__T(literal);
  var arg2 = $m_ju_regex_Matcher$().quoteReplacement__T__T(replacement);
  return $m_sjsr_RuntimeString$().replaceAll__T__T__T__T($$this.toString__T(), arg1, arg2)
}
function $s_sci_StringLike$class__unwrapArg__p0__sci_StringLike__O__O($$this, arg) {
  if ($is_s_math_ScalaNumber(arg)) {
    var x2 = $as_s_math_ScalaNumber(arg);
    return x2.underlying__O()
  } else {
    return arg
  }
}
function $s_sci_StringLike$class__stripPrefix__sci_StringLike__T__T($$this, prefix) {
  var thiz = $$this.toString__T();
  if ((($uI(thiz.length) >= 0) && ($as_T(thiz.substring(0, $uI(prefix.length))) === prefix))) {
    var thiz$1 = $$this.toString__T();
    var beginIndex = $uI(prefix.length);
    return $as_T(thiz$1.substring(beginIndex))
  } else {
    return $$this.toString__T()
  }
}
function $s_sci_StringLike$class__slice__sci_StringLike__I__I__O($$this, from, until) {
  var start = ((from > 0) ? from : 0);
  var that = $$this.length__I();
  var end = ((until < that) ? until : that);
  if ((start >= end)) {
    return $$this.newBuilder__scm_Builder().result__O()
  } else {
    var jsx$1 = $$this.newBuilder__scm_Builder();
    var thiz = $$this.toString__T();
    var x = $as_T(thiz.substring(start, end));
    return $as_scm_Builder(jsx$1.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_sci_StringOps().init___T(x))).result__O()
  }
}
function $s_sci_StringLike$class__stripMargin__sci_StringLike__C__T($$this, marginChar) {
  var buf = new $c_scm_StringBuilder().init___();
  var this$1 = new $c_sci_StringLike$$anon$1().init___sci_StringLike($$this);
  while (this$1.hasNext__Z()) {
    var arg1 = this$1.next__T();
    var len = $uI(arg1.length);
    var index = 0;
    while (true) {
      if ((index < len)) {
        var index$1 = index;
        var jsx$1 = ((65535 & $uI(arg1.charCodeAt(index$1))) <= 32)
      } else {
        var jsx$1 = false
      };
      if (jsx$1) {
        index = ((1 + index) | 0)
      } else {
        break
      }
    };
    if ((index < len)) {
      var index$2 = index;
      var jsx$3 = ((65535 & $uI(arg1.charCodeAt(index$2))) === marginChar)
    } else {
      var jsx$3 = false
    };
    if (jsx$3) {
      var beginIndex = ((1 + index) | 0);
      var jsx$2 = $as_T(arg1.substring(beginIndex))
    } else {
      var jsx$2 = arg1
    };
    buf.append__T__scm_StringBuilder(jsx$2)
  };
  return buf.underlying$5.java$lang$StringBuilder$$content$f
}
function $s_sci_StringLike$class__scala$collection$immutable$StringLike$$isLineBreak__sci_StringLike__C__Z($$this, c) {
  return ((c === 10) || (c === 12))
}
function $s_sci_VectorPointer$class__gotoFreshPosWritable1__sci_VectorPointer__I__I__I__V($$this, oldIndex, newIndex, xor) {
  $s_sci_VectorPointer$class__stabilize__sci_VectorPointer__I__V($$this, oldIndex);
  $s_sci_VectorPointer$class__gotoFreshPosWritable0__sci_VectorPointer__I__I__I__V($$this, oldIndex, newIndex, xor)
}
function $s_sci_VectorPointer$class__getElem__sci_VectorPointer__I__I__O($$this, index, xor) {
  if ((xor < 32)) {
    return $$this.display0__AO().get((31 & index))
  } else if ((xor < 1024)) {
    return $asArrayOf_O($$this.display1__AO().get((31 & (index >> 5))), 1).get((31 & index))
  } else if ((xor < 32768)) {
    return $asArrayOf_O($asArrayOf_O($$this.display2__AO().get((31 & (index >> 10))), 1).get((31 & (index >> 5))), 1).get((31 & index))
  } else if ((xor < 1048576)) {
    return $asArrayOf_O($asArrayOf_O($asArrayOf_O($$this.display3__AO().get((31 & (index >> 15))), 1).get((31 & (index >> 10))), 1).get((31 & (index >> 5))), 1).get((31 & index))
  } else if ((xor < 33554432)) {
    return $asArrayOf_O($asArrayOf_O($asArrayOf_O($asArrayOf_O($$this.display4__AO().get((31 & (index >> 20))), 1).get((31 & (index >> 15))), 1).get((31 & (index >> 10))), 1).get((31 & (index >> 5))), 1).get((31 & index))
  } else if ((xor < 1073741824)) {
    return $asArrayOf_O($asArrayOf_O($asArrayOf_O($asArrayOf_O($asArrayOf_O($$this.display5__AO().get((31 & (index >> 25))), 1).get((31 & (index >> 20))), 1).get((31 & (index >> 15))), 1).get((31 & (index >> 10))), 1).get((31 & (index >> 5))), 1).get((31 & index))
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $s_sci_VectorPointer$class__gotoNextBlockStartWritable__sci_VectorPointer__I__I__V($$this, index, xor) {
  if ((xor < 1024)) {
    if (($$this.depth__I() === 1)) {
      $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $$this.display1__AO().set(0, $$this.display0__AO());
      $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
    };
    $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO())
  } else if ((xor < 32768)) {
    if (($$this.depth__I() === 2)) {
      $$this.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $$this.display2__AO().set(0, $$this.display1__AO());
      $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
    };
    $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO());
    $$this.display2__AO().set((31 & (index >> 10)), $$this.display1__AO())
  } else if ((xor < 1048576)) {
    if (($$this.depth__I() === 3)) {
      $$this.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $$this.display3__AO().set(0, $$this.display2__AO());
      $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
    };
    $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO());
    $$this.display2__AO().set((31 & (index >> 10)), $$this.display1__AO());
    $$this.display3__AO().set((31 & (index >> 15)), $$this.display2__AO())
  } else if ((xor < 33554432)) {
    if (($$this.depth__I() === 4)) {
      $$this.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $$this.display4__AO().set(0, $$this.display3__AO());
      $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
    };
    $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO());
    $$this.display2__AO().set((31 & (index >> 10)), $$this.display1__AO());
    $$this.display3__AO().set((31 & (index >> 15)), $$this.display2__AO());
    $$this.display4__AO().set((31 & (index >> 20)), $$this.display3__AO())
  } else if ((xor < 1073741824)) {
    if (($$this.depth__I() === 5)) {
      $$this.display5$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $$this.display5__AO().set(0, $$this.display4__AO());
      $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
    };
    $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO());
    $$this.display2__AO().set((31 & (index >> 10)), $$this.display1__AO());
    $$this.display3__AO().set((31 & (index >> 15)), $$this.display2__AO());
    $$this.display4__AO().set((31 & (index >> 20)), $$this.display3__AO());
    $$this.display5__AO().set((31 & (index >> 25)), $$this.display4__AO())
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $s_sci_VectorPointer$class__gotoPosWritable0__sci_VectorPointer__I__I__V($$this, newIndex, xor) {
  var x1 = (((-1) + $$this.depth__I()) | 0);
  switch (x1) {
    case 5: {
      var a = $$this.display5__AO();
      $$this.display5$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a));
      var array = $$this.display5__AO();
      var index = (31 & (newIndex >> 25));
      $$this.display4$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array, index));
      var array$1 = $$this.display4__AO();
      var index$1 = (31 & (newIndex >> 20));
      $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$1, index$1));
      var array$2 = $$this.display3__AO();
      var index$2 = (31 & (newIndex >> 15));
      $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$2, index$2));
      var array$3 = $$this.display2__AO();
      var index$3 = (31 & (newIndex >> 10));
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$3, index$3));
      var array$4 = $$this.display1__AO();
      var index$4 = (31 & (newIndex >> 5));
      $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$4, index$4));
      break
    }
    case 4: {
      var a$1 = $$this.display4__AO();
      $$this.display4$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$1));
      var array$5 = $$this.display4__AO();
      var index$5 = (31 & (newIndex >> 20));
      $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$5, index$5));
      var array$6 = $$this.display3__AO();
      var index$6 = (31 & (newIndex >> 15));
      $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$6, index$6));
      var array$7 = $$this.display2__AO();
      var index$7 = (31 & (newIndex >> 10));
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$7, index$7));
      var array$8 = $$this.display1__AO();
      var index$8 = (31 & (newIndex >> 5));
      $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$8, index$8));
      break
    }
    case 3: {
      var a$2 = $$this.display3__AO();
      $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$2));
      var array$9 = $$this.display3__AO();
      var index$9 = (31 & (newIndex >> 15));
      $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$9, index$9));
      var array$10 = $$this.display2__AO();
      var index$10 = (31 & (newIndex >> 10));
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$10, index$10));
      var array$11 = $$this.display1__AO();
      var index$11 = (31 & (newIndex >> 5));
      $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$11, index$11));
      break
    }
    case 2: {
      var a$3 = $$this.display2__AO();
      $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$3));
      var array$12 = $$this.display2__AO();
      var index$12 = (31 & (newIndex >> 10));
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$12, index$12));
      var array$13 = $$this.display1__AO();
      var index$13 = (31 & (newIndex >> 5));
      $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$13, index$13));
      break
    }
    case 1: {
      var a$4 = $$this.display1__AO();
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$4));
      var array$14 = $$this.display1__AO();
      var index$14 = (31 & (newIndex >> 5));
      $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$14, index$14));
      break
    }
    case 0: {
      var a$5 = $$this.display0__AO();
      $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$5));
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $s_sci_VectorPointer$class__debug__sci_VectorPointer__V($$this) {
  return (void 0)
}
function $s_sci_VectorPointer$class__stabilize__sci_VectorPointer__I__V($$this, index) {
  var x1 = (((-1) + $$this.depth__I()) | 0);
  switch (x1) {
    case 5: {
      var a = $$this.display5__AO();
      $$this.display5$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a));
      var a$1 = $$this.display4__AO();
      $$this.display4$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$1));
      var a$2 = $$this.display3__AO();
      $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$2));
      var a$3 = $$this.display2__AO();
      $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$3));
      var a$4 = $$this.display1__AO();
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$4));
      $$this.display5__AO().set((31 & (index >> 25)), $$this.display4__AO());
      $$this.display4__AO().set((31 & (index >> 20)), $$this.display3__AO());
      $$this.display3__AO().set((31 & (index >> 15)), $$this.display2__AO());
      $$this.display2__AO().set((31 & (index >> 10)), $$this.display1__AO());
      $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO());
      break
    }
    case 4: {
      var a$5 = $$this.display4__AO();
      $$this.display4$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$5));
      var a$6 = $$this.display3__AO();
      $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$6));
      var a$7 = $$this.display2__AO();
      $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$7));
      var a$8 = $$this.display1__AO();
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$8));
      $$this.display4__AO().set((31 & (index >> 20)), $$this.display3__AO());
      $$this.display3__AO().set((31 & (index >> 15)), $$this.display2__AO());
      $$this.display2__AO().set((31 & (index >> 10)), $$this.display1__AO());
      $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO());
      break
    }
    case 3: {
      var a$9 = $$this.display3__AO();
      $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$9));
      var a$10 = $$this.display2__AO();
      $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$10));
      var a$11 = $$this.display1__AO();
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$11));
      $$this.display3__AO().set((31 & (index >> 15)), $$this.display2__AO());
      $$this.display2__AO().set((31 & (index >> 10)), $$this.display1__AO());
      $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO());
      break
    }
    case 2: {
      var a$12 = $$this.display2__AO();
      $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$12));
      var a$13 = $$this.display1__AO();
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$13));
      $$this.display2__AO().set((31 & (index >> 10)), $$this.display1__AO());
      $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO());
      break
    }
    case 1: {
      var a$14 = $$this.display1__AO();
      $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$14));
      $$this.display1__AO().set((31 & (index >> 5)), $$this.display0__AO());
      break
    }
    case 0: {
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array, index) {
  var x = array.get(index);
  array.set(index, null);
  var a = $asArrayOf_O(x, 1);
  return $s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a)
}
function $s_sci_VectorPointer$class__initFrom__sci_VectorPointer__sci_VectorPointer__I__V($$this, that, depth) {
  $$this.depth$und$eq__I__V(depth);
  var x1 = (((-1) + depth) | 0);
  switch (x1) {
    case (-1): {
      break
    }
    case 0: {
      $$this.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 1: {
      $$this.display1$und$eq__AO__V(that.display1__AO());
      $$this.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 2: {
      $$this.display2$und$eq__AO__V(that.display2__AO());
      $$this.display1$und$eq__AO__V(that.display1__AO());
      $$this.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 3: {
      $$this.display3$und$eq__AO__V(that.display3__AO());
      $$this.display2$und$eq__AO__V(that.display2__AO());
      $$this.display1$und$eq__AO__V(that.display1__AO());
      $$this.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 4: {
      $$this.display4$und$eq__AO__V(that.display4__AO());
      $$this.display3$und$eq__AO__V(that.display3__AO());
      $$this.display2$und$eq__AO__V(that.display2__AO());
      $$this.display1$und$eq__AO__V(that.display1__AO());
      $$this.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 5: {
      $$this.display5$und$eq__AO__V(that.display5__AO());
      $$this.display4$und$eq__AO__V(that.display4__AO());
      $$this.display3$und$eq__AO__V(that.display3__AO());
      $$this.display2$und$eq__AO__V(that.display2__AO());
      $$this.display1$und$eq__AO__V(that.display1__AO());
      $$this.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $s_sci_VectorPointer$class__gotoNextBlockStart__sci_VectorPointer__I__I__V($$this, index, xor) {
  if ((xor < 1024)) {
    $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get((31 & (index >> 5))), 1))
  } else if ((xor < 32768)) {
    $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get((31 & (index >> 10))), 1));
    $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get(0), 1))
  } else if ((xor < 1048576)) {
    $$this.display2$und$eq__AO__V($asArrayOf_O($$this.display3__AO().get((31 & (index >> 15))), 1));
    $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get(0), 1));
    $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get(0), 1))
  } else if ((xor < 33554432)) {
    $$this.display3$und$eq__AO__V($asArrayOf_O($$this.display4__AO().get((31 & (index >> 20))), 1));
    $$this.display2$und$eq__AO__V($asArrayOf_O($$this.display3__AO().get(0), 1));
    $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get(0), 1));
    $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get(0), 1))
  } else if ((xor < 1073741824)) {
    $$this.display4$und$eq__AO__V($asArrayOf_O($$this.display5__AO().get((31 & (index >> 25))), 1));
    $$this.display3$und$eq__AO__V($asArrayOf_O($$this.display4__AO().get(0), 1));
    $$this.display2$und$eq__AO__V($asArrayOf_O($$this.display3__AO().get(0), 1));
    $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get(0), 1));
    $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get(0), 1))
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $s_sci_VectorPointer$class__gotoPos__sci_VectorPointer__I__I__V($$this, index, xor) {
  if ((xor >= 32)) {
    if ((xor < 1024)) {
      $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get((31 & (index >> 5))), 1))
    } else if ((xor < 32768)) {
      $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get((31 & (index >> 10))), 1));
      $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get((31 & (index >> 5))), 1))
    } else if ((xor < 1048576)) {
      $$this.display2$und$eq__AO__V($asArrayOf_O($$this.display3__AO().get((31 & (index >> 15))), 1));
      $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get((31 & (index >> 10))), 1));
      $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get((31 & (index >> 5))), 1))
    } else if ((xor < 33554432)) {
      $$this.display3$und$eq__AO__V($asArrayOf_O($$this.display4__AO().get((31 & (index >> 20))), 1));
      $$this.display2$und$eq__AO__V($asArrayOf_O($$this.display3__AO().get((31 & (index >> 15))), 1));
      $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get((31 & (index >> 10))), 1));
      $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get((31 & (index >> 5))), 1))
    } else if ((xor < 1073741824)) {
      $$this.display4$und$eq__AO__V($asArrayOf_O($$this.display5__AO().get((31 & (index >> 25))), 1));
      $$this.display3$und$eq__AO__V($asArrayOf_O($$this.display4__AO().get((31 & (index >> 20))), 1));
      $$this.display2$und$eq__AO__V($asArrayOf_O($$this.display3__AO().get((31 & (index >> 15))), 1));
      $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get((31 & (index >> 10))), 1));
      $$this.display0$und$eq__AO__V($asArrayOf_O($$this.display1__AO().get((31 & (index >> 5))), 1))
    } else {
      throw new $c_jl_IllegalArgumentException().init___()
    }
  }
}
function $s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a) {
  var b = $newArrayObject($d_O.getArrayOf(), [a.u.length]);
  var length = a.u.length;
  $systemArraycopy(a, 0, b, 0, length);
  return b
}
function $s_sci_VectorPointer$class__gotoPosWritable1__sci_VectorPointer__I__I__I__V($$this, oldIndex, newIndex, xor) {
  if ((xor < 32)) {
    var a = $$this.display0__AO();
    $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a))
  } else if ((xor < 1024)) {
    var a$1 = $$this.display1__AO();
    $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$1));
    $$this.display1__AO().set((31 & (oldIndex >> 5)), $$this.display0__AO());
    var array = $$this.display1__AO();
    var index = (31 & (newIndex >> 5));
    $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array, index))
  } else if ((xor < 32768)) {
    var a$2 = $$this.display1__AO();
    $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$2));
    var a$3 = $$this.display2__AO();
    $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$3));
    $$this.display1__AO().set((31 & (oldIndex >> 5)), $$this.display0__AO());
    $$this.display2__AO().set((31 & (oldIndex >> 10)), $$this.display1__AO());
    var array$1 = $$this.display2__AO();
    var index$1 = (31 & (newIndex >> 10));
    $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$1, index$1));
    var array$2 = $$this.display1__AO();
    var index$2 = (31 & (newIndex >> 5));
    $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$2, index$2))
  } else if ((xor < 1048576)) {
    var a$4 = $$this.display1__AO();
    $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$4));
    var a$5 = $$this.display2__AO();
    $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$5));
    var a$6 = $$this.display3__AO();
    $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$6));
    $$this.display1__AO().set((31 & (oldIndex >> 5)), $$this.display0__AO());
    $$this.display2__AO().set((31 & (oldIndex >> 10)), $$this.display1__AO());
    $$this.display3__AO().set((31 & (oldIndex >> 15)), $$this.display2__AO());
    var array$3 = $$this.display3__AO();
    var index$3 = (31 & (newIndex >> 15));
    $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$3, index$3));
    var array$4 = $$this.display2__AO();
    var index$4 = (31 & (newIndex >> 10));
    $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$4, index$4));
    var array$5 = $$this.display1__AO();
    var index$5 = (31 & (newIndex >> 5));
    $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$5, index$5))
  } else if ((xor < 33554432)) {
    var a$7 = $$this.display1__AO();
    $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$7));
    var a$8 = $$this.display2__AO();
    $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$8));
    var a$9 = $$this.display3__AO();
    $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$9));
    var a$10 = $$this.display4__AO();
    $$this.display4$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$10));
    $$this.display1__AO().set((31 & (oldIndex >> 5)), $$this.display0__AO());
    $$this.display2__AO().set((31 & (oldIndex >> 10)), $$this.display1__AO());
    $$this.display3__AO().set((31 & (oldIndex >> 15)), $$this.display2__AO());
    $$this.display4__AO().set((31 & (oldIndex >> 20)), $$this.display3__AO());
    var array$6 = $$this.display4__AO();
    var index$6 = (31 & (newIndex >> 20));
    $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$6, index$6));
    var array$7 = $$this.display3__AO();
    var index$7 = (31 & (newIndex >> 15));
    $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$7, index$7));
    var array$8 = $$this.display2__AO();
    var index$8 = (31 & (newIndex >> 10));
    $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$8, index$8));
    var array$9 = $$this.display1__AO();
    var index$9 = (31 & (newIndex >> 5));
    $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$9, index$9))
  } else if ((xor < 1073741824)) {
    var a$11 = $$this.display1__AO();
    $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$11));
    var a$12 = $$this.display2__AO();
    $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$12));
    var a$13 = $$this.display3__AO();
    $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$13));
    var a$14 = $$this.display4__AO();
    $$this.display4$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$14));
    var a$15 = $$this.display5__AO();
    $$this.display5$und$eq__AO__V($s_sci_VectorPointer$class__copyOf__sci_VectorPointer__AO__AO($$this, a$15));
    $$this.display1__AO().set((31 & (oldIndex >> 5)), $$this.display0__AO());
    $$this.display2__AO().set((31 & (oldIndex >> 10)), $$this.display1__AO());
    $$this.display3__AO().set((31 & (oldIndex >> 15)), $$this.display2__AO());
    $$this.display4__AO().set((31 & (oldIndex >> 20)), $$this.display3__AO());
    $$this.display5__AO().set((31 & (oldIndex >> 25)), $$this.display4__AO());
    var array$10 = $$this.display5__AO();
    var index$10 = (31 & (newIndex >> 25));
    $$this.display4$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$10, index$10));
    var array$11 = $$this.display4__AO();
    var index$11 = (31 & (newIndex >> 20));
    $$this.display3$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$11, index$11));
    var array$12 = $$this.display3__AO();
    var index$12 = (31 & (newIndex >> 15));
    $$this.display2$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$12, index$12));
    var array$13 = $$this.display2__AO();
    var index$13 = (31 & (newIndex >> 10));
    $$this.display1$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$13, index$13));
    var array$14 = $$this.display1__AO();
    var index$14 = (31 & (newIndex >> 5));
    $$this.display0$und$eq__AO__V($s_sci_VectorPointer$class__nullSlotAndCopy__sci_VectorPointer__AO__I__AO($$this, array$14, index$14))
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $s_sci_VectorPointer$class__copyRange__sci_VectorPointer__AO__I__I__AO($$this, array, oldLeft, newLeft) {
  var elems = $newArrayObject($d_O.getArrayOf(), [32]);
  var length = ((32 - ((newLeft > oldLeft) ? newLeft : oldLeft)) | 0);
  $systemArraycopy(array, oldLeft, elems, newLeft, length);
  return elems
}
function $s_sci_VectorPointer$class__gotoFreshPosWritable0__sci_VectorPointer__I__I__I__V($$this, oldIndex, newIndex, xor) {
  if ((xor >= 32)) {
    if ((xor < 1024)) {
      if (($$this.depth__I() === 1)) {
        $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $$this.display1__AO().set((31 & (oldIndex >> 5)), $$this.display0__AO());
        $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
      };
      $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 32768)) {
      if (($$this.depth__I() === 2)) {
        $$this.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $$this.display2__AO().set((31 & (oldIndex >> 10)), $$this.display1__AO());
        $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
      };
      $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get((31 & (newIndex >> 10))), 1));
      if (($$this.display1__AO() === null)) {
        $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 1048576)) {
      if (($$this.depth__I() === 3)) {
        $$this.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $$this.display3__AO().set((31 & (oldIndex >> 15)), $$this.display2__AO());
        $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
      };
      $$this.display2$und$eq__AO__V($asArrayOf_O($$this.display3__AO().get((31 & (newIndex >> 15))), 1));
      if (($$this.display2__AO() === null)) {
        $$this.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get((31 & (newIndex >> 10))), 1));
      if (($$this.display1__AO() === null)) {
        $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 33554432)) {
      if (($$this.depth__I() === 4)) {
        $$this.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $$this.display4__AO().set((31 & (oldIndex >> 20)), $$this.display3__AO());
        $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
      };
      $$this.display3$und$eq__AO__V($asArrayOf_O($$this.display4__AO().get((31 & (newIndex >> 20))), 1));
      if (($$this.display3__AO() === null)) {
        $$this.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display2$und$eq__AO__V($asArrayOf_O($$this.display3__AO().get((31 & (newIndex >> 15))), 1));
      if (($$this.display2__AO() === null)) {
        $$this.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get((31 & (newIndex >> 10))), 1));
      if (($$this.display1__AO() === null)) {
        $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 1073741824)) {
      if (($$this.depth__I() === 5)) {
        $$this.display5$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $$this.display5__AO().set((31 & (oldIndex >> 25)), $$this.display4__AO());
        $$this.depth$und$eq__I__V(((1 + $$this.depth__I()) | 0))
      };
      $$this.display4$und$eq__AO__V($asArrayOf_O($$this.display5__AO().get((31 & (newIndex >> 25))), 1));
      if (($$this.display4__AO() === null)) {
        $$this.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display3$und$eq__AO__V($asArrayOf_O($$this.display4__AO().get((31 & (newIndex >> 20))), 1));
      if (($$this.display3__AO() === null)) {
        $$this.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display2$und$eq__AO__V($asArrayOf_O($$this.display3__AO().get((31 & (newIndex >> 15))), 1));
      if (($$this.display2__AO() === null)) {
        $$this.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display1$und$eq__AO__V($asArrayOf_O($$this.display2__AO().get((31 & (newIndex >> 10))), 1));
      if (($$this.display1__AO() === null)) {
        $$this.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $$this.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else {
      throw new $c_jl_IllegalArgumentException().init___()
    }
  }
}
function $s_scm_ArrayOps$class__copyToArray__scm_ArrayOps__O__I__I__V($$this, xs, start, len) {
  var y = $m_sr_ScalaRunTime$().array$undlength__O__I($$this.repr__O());
  var l = ((len < y) ? len : y);
  if (((($m_sr_ScalaRunTime$().array$undlength__O__I(xs) - start) | 0) < l)) {
    var x = (($m_sr_ScalaRunTime$().array$undlength__O__I(xs) - start) | 0);
    l = ((x > 0) ? x : 0)
  };
  $m_s_Array$().copy__O__I__O__I__I__V($$this.repr__O(), 0, xs, start, l)
}
function $s_scm_Builder$class__sizeHint__scm_Builder__sc_TraversableLike__V($$this, coll) {
  if ($is_sc_IndexedSeqLike(coll)) {
    $$this.sizeHint__I__V(coll.size__I())
  }
}
function $s_scm_Builder$class__sizeHint__scm_Builder__sc_TraversableLike__I__V($$this, coll, delta) {
  if ($is_sc_IndexedSeqLike(coll)) {
    $$this.sizeHint__I__V(((coll.size__I() + delta) | 0))
  }
}
function $s_scm_Builder$class__sizeHintBounded__scm_Builder__I__sc_TraversableLike__V($$this, size, boundingColl) {
  if ($is_sc_IndexedSeqLike(boundingColl)) {
    var that = boundingColl.size__I();
    $$this.sizeHint__I__V(((size < that) ? size : that))
  }
}
function $s_scm_FlatHashTable$HashUtils$class__improve__scm_FlatHashTable$HashUtils__I__I__I($$this, hcode, seed) {
  var i = $m_s_util_hashing_package$().byteswap32__I__I(hcode);
  return (((i >>> seed) | 0) | (i << ((-seed) | 0)))
}
function $s_scm_FlatHashTable$HashUtils$class__entryToElem__scm_FlatHashTable$HashUtils__O__O($$this, entry) {
  return ((entry === $m_scm_FlatHashTable$NullSentinel$()) ? null : entry)
}
function $s_scm_FlatHashTable$HashUtils$class__elemToEntry__scm_FlatHashTable$HashUtils__O__O($$this, elem) {
  return ((elem === null) ? $m_scm_FlatHashTable$NullSentinel$() : elem)
}
function $s_scm_FlatHashTable$class__growTable__p0__scm_FlatHashTable__V($$this) {
  var oldtable = $$this.table$5;
  $$this.table$5 = $newArrayObject($d_O.getArrayOf(), [($$this.table$5.u.length << 1)]);
  $$this.tableSize$5 = 0;
  var tableLength = $$this.table$5.u.length;
  $s_scm_FlatHashTable$class__nnSizeMapReset__scm_FlatHashTable__I__V($$this, tableLength);
  $$this.seedvalue$5 = $s_scm_FlatHashTable$class__tableSizeSeed__scm_FlatHashTable__I($$this);
  $$this.threshold$5 = $m_scm_FlatHashTable$().newThreshold__I__I__I($$this.$$undloadFactor$5, $$this.table$5.u.length);
  var i = 0;
  while ((i < oldtable.u.length)) {
    var entry = oldtable.get(i);
    if ((entry !== null)) {
      $s_scm_FlatHashTable$class__addEntry__scm_FlatHashTable__O__Z($$this, entry)
    };
    i = ((1 + i) | 0)
  }
}
function $s_scm_FlatHashTable$class__removeElem__scm_FlatHashTable__O__Z($$this, elem) {
  var removalEntry = $s_scm_FlatHashTable$HashUtils$class__elemToEntry__scm_FlatHashTable$HashUtils__O__O($$this, elem);
  var hcode = $objectHashCode(removalEntry);
  var h = $s_scm_FlatHashTable$class__index__scm_FlatHashTable__I__I($$this, hcode);
  var curEntry = $$this.table$5.get(h);
  while ((curEntry !== null)) {
    if ($m_sr_BoxesRunTime$().equals__O__O__Z(curEntry, removalEntry)) {
      var h0 = h;
      var h1 = ((((1 + h0) | 0) % $$this.table$5.u.length) | 0);
      while (($$this.table$5.get(h1) !== null)) {
        var hcode$1 = $objectHashCode($$this.table$5.get(h1));
        var h2 = $s_scm_FlatHashTable$class__index__scm_FlatHashTable__I__I($$this, hcode$1);
        if (((h2 !== h1) && $s_scm_FlatHashTable$class__precedes$1__p0__scm_FlatHashTable__I__I__Z($$this, h2, h0))) {
          $$this.table$5.set(h0, $$this.table$5.get(h1));
          h0 = h1
        };
        h1 = ((((1 + h1) | 0) % $$this.table$5.u.length) | 0)
      };
      $$this.table$5.set(h0, null);
      $$this.tableSize$5 = (((-1) + $$this.tableSize$5) | 0);
      var h$1 = h0;
      $s_scm_FlatHashTable$class__nnSizeMapRemove__scm_FlatHashTable__I__V($$this, h$1);
      return true
    };
    h = ((((1 + h) | 0) % $$this.table$5.u.length) | 0);
    curEntry = $$this.table$5.get(h)
  };
  return false
}
function $s_scm_FlatHashTable$class__calcSizeMapSize__scm_FlatHashTable__I__I($$this, tableLength) {
  return ((1 + (tableLength >> 5)) | 0)
}
function $s_scm_FlatHashTable$class__nnSizeMapAdd__scm_FlatHashTable__I__V($$this, h) {
  if (($$this.sizemap$5 !== null)) {
    var p = (h >> 5);
    var ev$1 = $$this.sizemap$5;
    ev$1.set(p, ((1 + ev$1.get(p)) | 0))
  }
}
function $s_scm_FlatHashTable$class__nnSizeMapRemove__scm_FlatHashTable__I__V($$this, h) {
  if (($$this.sizemap$5 !== null)) {
    var ev$2 = $$this.sizemap$5;
    var ev$3 = (h >> 5);
    ev$2.set(ev$3, (((-1) + ev$2.get(ev$3)) | 0))
  }
}
function $s_scm_FlatHashTable$class__$$init$__scm_FlatHashTable__V($$this) {
  $$this.$$undloadFactor$5 = 450;
  $$this.table$5 = $newArrayObject($d_O.getArrayOf(), [$s_scm_FlatHashTable$class__capacity__scm_FlatHashTable__I__I($$this, 32)]);
  $$this.tableSize$5 = 0;
  $$this.threshold$5 = $m_scm_FlatHashTable$().newThreshold__I__I__I($$this.$$undloadFactor$5, $s_scm_FlatHashTable$class__capacity__scm_FlatHashTable__I__I($$this, 32));
  $$this.sizemap$5 = null;
  $$this.seedvalue$5 = $s_scm_FlatHashTable$class__tableSizeSeed__scm_FlatHashTable__I($$this)
}
function $s_scm_FlatHashTable$class__findElemImpl__p0__scm_FlatHashTable__O__O($$this, elem) {
  var searchEntry = $s_scm_FlatHashTable$HashUtils$class__elemToEntry__scm_FlatHashTable$HashUtils__O__O($$this, elem);
  var hcode = $objectHashCode(searchEntry);
  var h = $s_scm_FlatHashTable$class__index__scm_FlatHashTable__I__I($$this, hcode);
  var curEntry = $$this.table$5.get(h);
  while (((curEntry !== null) && (!$m_sr_BoxesRunTime$().equals__O__O__Z(curEntry, searchEntry)))) {
    h = ((((1 + h) | 0) % $$this.table$5.u.length) | 0);
    curEntry = $$this.table$5.get(h)
  };
  return curEntry
}
function $s_scm_FlatHashTable$class__addEntry__scm_FlatHashTable__O__Z($$this, newEntry) {
  var hcode = $objectHashCode(newEntry);
  var h = $s_scm_FlatHashTable$class__index__scm_FlatHashTable__I__I($$this, hcode);
  var curEntry = $$this.table$5.get(h);
  while ((curEntry !== null)) {
    if ($m_sr_BoxesRunTime$().equals__O__O__Z(curEntry, newEntry)) {
      return false
    };
    h = ((((1 + h) | 0) % $$this.table$5.u.length) | 0);
    curEntry = $$this.table$5.get(h)
  };
  $$this.table$5.set(h, newEntry);
  $$this.tableSize$5 = ((1 + $$this.tableSize$5) | 0);
  var h$1 = h;
  $s_scm_FlatHashTable$class__nnSizeMapAdd__scm_FlatHashTable__I__V($$this, h$1);
  if (($$this.tableSize$5 >= $$this.threshold$5)) {
    $s_scm_FlatHashTable$class__growTable__p0__scm_FlatHashTable__V($$this)
  };
  return true
}
function $s_scm_FlatHashTable$class__addElem__scm_FlatHashTable__O__Z($$this, elem) {
  var newEntry = $s_scm_FlatHashTable$HashUtils$class__elemToEntry__scm_FlatHashTable$HashUtils__O__O($$this, elem);
  return $s_scm_FlatHashTable$class__addEntry__scm_FlatHashTable__O__Z($$this, newEntry)
}
function $s_scm_FlatHashTable$class__index__scm_FlatHashTable__I__I($$this, hcode) {
  var seed = $$this.seedvalue$5;
  var improved = $s_scm_FlatHashTable$HashUtils$class__improve__scm_FlatHashTable$HashUtils__I__I__I($$this, hcode, seed);
  var ones = (((-1) + $$this.table$5.u.length) | 0);
  return (((improved >>> ((32 - $m_jl_Integer$().bitCount__I__I(ones)) | 0)) | 0) & ones)
}
function $s_scm_FlatHashTable$class__precedes$1__p0__scm_FlatHashTable__I__I__Z($$this, i, j) {
  var d = ($$this.table$5.u.length >> 1);
  return ((i <= j) ? (((j - i) | 0) < d) : (((i - j) | 0) > d))
}
function $s_scm_FlatHashTable$class__tableSizeSeed__scm_FlatHashTable__I($$this) {
  return $m_jl_Integer$().bitCount__I__I((((-1) + $$this.table$5.u.length) | 0))
}
function $s_scm_FlatHashTable$class__capacity__scm_FlatHashTable__I__I($$this, expectedSize) {
  return ((expectedSize === 0) ? 1 : $m_scm_HashTable$().powerOfTwo__I__I(expectedSize))
}
function $s_scm_FlatHashTable$class__nnSizeMapReset__scm_FlatHashTable__I__V($$this, tableLength) {
  if (($$this.sizemap$5 !== null)) {
    var nsize = $s_scm_FlatHashTable$class__calcSizeMapSize__scm_FlatHashTable__I__I($$this, tableLength);
    if (($$this.sizemap$5.u.length !== nsize)) {
      $$this.sizemap$5 = $newArrayObject($d_I.getArrayOf(), [nsize])
    } else {
      $m_ju_Arrays$().fill__AI__I__V($$this.sizemap$5, 0)
    }
  }
}
function $s_scm_FlatHashTable$class__initWithContents__scm_FlatHashTable__scm_FlatHashTable$Contents__V($$this, c) {
  if ((c !== null)) {
    $$this.$$undloadFactor$5 = c.loadFactor__I();
    $$this.table$5 = c.table__AO();
    $$this.tableSize$5 = c.tableSize__I();
    $$this.threshold$5 = c.threshold__I();
    $$this.seedvalue$5 = c.seedvalue__I();
    $$this.sizemap$5 = c.sizemap__AI()
  }
}
function $s_scm_FlatHashTable$class__containsElem__scm_FlatHashTable__O__Z($$this, elem) {
  return ($s_scm_FlatHashTable$class__findElemImpl__p0__scm_FlatHashTable__O__O($$this, elem) !== null)
}
function $is_scm_HashEntry(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.scm_HashEntry)))
}
function $as_scm_HashEntry(obj) {
  return (($is_scm_HashEntry(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.collection.mutable.HashEntry"))
}
function $isArrayOf_scm_HashEntry(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.scm_HashEntry)))
}
function $asArrayOf_scm_HashEntry(obj, depth) {
  return (($isArrayOf_scm_HashEntry(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.collection.mutable.HashEntry;", depth))
}
var $d_scm_HashEntry = new $TypeData().initClass({
  scm_HashEntry: 0
}, true, "scala.collection.mutable.HashEntry", {
  scm_HashEntry: 1
});
function $s_scm_HashTable$HashUtils$class__improve__scm_HashTable$HashUtils__I__I__I($$this, hcode, seed) {
  var i = $m_s_util_hashing_package$().byteswap32__I__I(hcode);
  return (((i >>> seed) | 0) | (i << ((-seed) | 0)))
}
function $s_scm_HashTable$class__scala$collection$mutable$HashTable$$lastPopulatedIndex__scm_HashTable__I($$this) {
  var idx = (((-1) + $$this.table__Ascm_HashEntry().u.length) | 0);
  while ((($$this.table__Ascm_HashEntry().get(idx) === null) && (idx > 0))) {
    idx = (((-1) + idx) | 0)
  };
  return idx
}
function $s_scm_HashTable$class__initWithContents__scm_HashTable__scm_HashTable$Contents__V($$this, c) {
  if ((c !== null)) {
    $$this.$$undloadFactor$und$eq__I__V(c.loadFactor__I());
    $$this.table$und$eq__Ascm_HashEntry__V(c.table__Ascm_HashEntry());
    $$this.tableSize$und$eq__I__V(c.tableSize__I());
    $$this.threshold$und$eq__I__V(c.threshold__I());
    $$this.seedvalue$und$eq__I__V(c.seedvalue__I());
    $$this.sizemap$und$eq__AI__V(c.sizemap__AI())
  }
}
function $s_scm_HashTable$class__findEntry__scm_HashTable__O__scm_HashEntry($$this, key) {
  var hcode = $m_sr_ScalaRunTime$().hash__O__I(key);
  return $s_scm_HashTable$class__scala$collection$mutable$HashTable$$findEntry0__scm_HashTable__O__I__scm_HashEntry($$this, key, $s_scm_HashTable$class__index__scm_HashTable__I__I($$this, hcode))
}
function $s_scm_HashTable$class__scala$collection$mutable$HashTable$$findEntry0__scm_HashTable__O__I__scm_HashEntry($$this, key, h) {
  var e = $$this.table__Ascm_HashEntry().get(h);
  while (true) {
    if ((e !== null)) {
      var key1 = e.key__O();
      var jsx$1 = (!$m_sr_BoxesRunTime$().equals__O__O__Z(key1, key))
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      e = $as_scm_HashEntry(e.next__O())
    } else {
      break
    }
  };
  return e
}
function $s_scm_HashTable$class__nnSizeMapAdd__scm_HashTable__I__V($$this, h) {
  if (($$this.sizemap__AI() !== null)) {
    var ev$1 = $$this.sizemap__AI();
    var ev$2 = (h >> 5);
    ev$1.set(ev$2, ((1 + ev$1.get(ev$2)) | 0))
  }
}
function $s_scm_HashTable$class__nnSizeMapRemove__scm_HashTable__I__V($$this, h) {
  if (($$this.sizemap__AI() !== null)) {
    var ev$3 = $$this.sizemap__AI();
    var ev$4 = (h >> 5);
    ev$3.set(ev$4, (((-1) + ev$3.get(ev$4)) | 0))
  }
}
function $s_scm_HashTable$class__calcSizeMapSize__scm_HashTable__I__I($$this, tableLength) {
  return ((1 + (tableLength >> 5)) | 0)
}
function $s_scm_HashTable$class__resize__p0__scm_HashTable__I__V($$this, newSize) {
  var oldTable = $$this.table__Ascm_HashEntry();
  $$this.table$und$eq__Ascm_HashEntry__V($newArrayObject($d_scm_HashEntry.getArrayOf(), [newSize]));
  var tableLength = $$this.table__Ascm_HashEntry().u.length;
  $s_scm_HashTable$class__nnSizeMapReset__scm_HashTable__I__V($$this, tableLength);
  var i = (((-1) + oldTable.u.length) | 0);
  while ((i >= 0)) {
    var e = oldTable.get(i);
    while ((e !== null)) {
      var key = e.key__O();
      var hcode = $m_sr_ScalaRunTime$().hash__O__I(key);
      var h = $s_scm_HashTable$class__index__scm_HashTable__I__I($$this, hcode);
      var e1 = $as_scm_HashEntry(e.next__O());
      e.next$und$eq__O__V($$this.table__Ascm_HashEntry().get(h));
      $$this.table__Ascm_HashEntry().set(h, e);
      e = e1;
      $s_scm_HashTable$class__nnSizeMapAdd__scm_HashTable__I__V($$this, h)
    };
    i = (((-1) + i) | 0)
  };
  $$this.threshold$und$eq__I__V($m_scm_HashTable$().newThreshold__I__I__I($$this.$$undloadFactor__I(), newSize))
}
function $s_scm_HashTable$class__addEntry__scm_HashTable__scm_HashEntry__V($$this, e) {
  var key = e.key__O();
  var hcode = $m_sr_ScalaRunTime$().hash__O__I(key);
  $s_scm_HashTable$class__scala$collection$mutable$HashTable$$addEntry0__scm_HashTable__scm_HashEntry__I__V($$this, e, $s_scm_HashTable$class__index__scm_HashTable__I__I($$this, hcode))
}
function $s_scm_HashTable$class__$$init$__scm_HashTable__V($$this) {
  $$this.$$undloadFactor$und$eq__I__V(750);
  $$this.table$und$eq__Ascm_HashEntry__V($newArrayObject($d_scm_HashEntry.getArrayOf(), [$m_scm_HashTable$().capacity__I__I(16)]));
  $$this.tableSize$und$eq__I__V(0);
  $$this.threshold$und$eq__I__V($s_scm_HashTable$class__initialThreshold__p0__scm_HashTable__I__I($$this, $$this.$$undloadFactor__I()));
  $$this.sizemap$und$eq__AI__V(null);
  $$this.seedvalue$und$eq__I__V($s_scm_HashTable$class__tableSizeSeed__scm_HashTable__I($$this))
}
function $s_scm_HashTable$class__removeEntry__scm_HashTable__O__scm_HashEntry($$this, key) {
  var hcode = $m_sr_ScalaRunTime$().hash__O__I(key);
  var h = $s_scm_HashTable$class__index__scm_HashTable__I__I($$this, hcode);
  var e = $$this.table__Ascm_HashEntry().get(h);
  if ((e !== null)) {
    var key1 = e.key__O();
    if ($m_sr_BoxesRunTime$().equals__O__O__Z(key1, key)) {
      $$this.table__Ascm_HashEntry().set(h, $as_scm_HashEntry(e.next__O()));
      $$this.tableSize$und$eq__I__V((((-1) + $$this.tableSize__I()) | 0));
      $s_scm_HashTable$class__nnSizeMapRemove__scm_HashTable__I__V($$this, h);
      e.next$und$eq__O__V(null);
      return e
    } else {
      var e1 = $as_scm_HashEntry(e.next__O());
      while (true) {
        if ((e1 !== null)) {
          var key1$1 = e1.key__O();
          var jsx$1 = (!$m_sr_BoxesRunTime$().equals__O__O__Z(key1$1, key))
        } else {
          var jsx$1 = false
        };
        if (jsx$1) {
          e = e1;
          e1 = $as_scm_HashEntry(e1.next__O())
        } else {
          break
        }
      };
      if ((e1 !== null)) {
        e.next$und$eq__O__V(e1.next__O());
        $$this.tableSize$und$eq__I__V((((-1) + $$this.tableSize__I()) | 0));
        $s_scm_HashTable$class__nnSizeMapRemove__scm_HashTable__I__V($$this, h);
        e1.next$und$eq__O__V(null);
        return e1
      }
    }
  };
  return null
}
function $s_scm_HashTable$class__index__scm_HashTable__I__I($$this, hcode) {
  if (($$this.table__Ascm_HashEntry().u.length === 1)) {
    return 0
  } else {
    var seed = $$this.seedvalue__I();
    return (($s_scm_HashTable$HashUtils$class__improve__scm_HashTable$HashUtils__I__I__I($$this, hcode, seed) >>> $clz32((((-1) + $$this.table__Ascm_HashEntry().u.length) | 0))) | 0)
  }
}
function $s_scm_HashTable$class__scala$collection$mutable$HashTable$$addEntry0__scm_HashTable__scm_HashEntry__I__V($$this, e, h) {
  e.next$und$eq__O__V($$this.table__Ascm_HashEntry().get(h));
  $$this.table__Ascm_HashEntry().set(h, e);
  $$this.tableSize$und$eq__I__V(((1 + $$this.tableSize__I()) | 0));
  $s_scm_HashTable$class__nnSizeMapAdd__scm_HashTable__I__V($$this, h);
  if (($$this.tableSize__I() > $$this.threshold__I())) {
    $s_scm_HashTable$class__resize__p0__scm_HashTable__I__V($$this, ($$this.table__Ascm_HashEntry().u.length << 1))
  }
}
function $s_scm_HashTable$class__initialThreshold__p0__scm_HashTable__I__I($$this, _loadFactor) {
  return $m_scm_HashTable$().newThreshold__I__I__I(_loadFactor, $m_scm_HashTable$().capacity__I__I(16))
}
function $s_scm_HashTable$class__findOrAddEntry__scm_HashTable__O__O__scm_HashEntry($$this, key, value) {
  var hcode = $m_sr_ScalaRunTime$().hash__O__I(key);
  var h = $s_scm_HashTable$class__index__scm_HashTable__I__I($$this, hcode);
  var e = $s_scm_HashTable$class__scala$collection$mutable$HashTable$$findEntry0__scm_HashTable__O__I__scm_HashEntry($$this, key, h);
  return ((e !== null) ? e : ($s_scm_HashTable$class__scala$collection$mutable$HashTable$$addEntry0__scm_HashTable__scm_HashEntry__I__V($$this, $$this.createNewEntry__O__O__scm_HashEntry(key, value), h), null))
}
function $s_scm_HashTable$class__nnSizeMapReset__scm_HashTable__I__V($$this, tableLength) {
  if (($$this.sizemap__AI() !== null)) {
    var nsize = $s_scm_HashTable$class__calcSizeMapSize__scm_HashTable__I__I($$this, tableLength);
    if (($$this.sizemap__AI().u.length !== nsize)) {
      $$this.sizemap$und$eq__AI__V($newArrayObject($d_I.getArrayOf(), [nsize]))
    } else {
      $m_ju_Arrays$().fill__AI__I__V($$this.sizemap__AI(), 0)
    }
  }
}
function $s_scm_HashTable$class__tableSizeSeed__scm_HashTable__I($$this) {
  return $m_jl_Integer$().bitCount__I__I((((-1) + $$this.table__Ascm_HashEntry().u.length) | 0))
}
function $s_scm_Map$class__withDefaultValue__scm_Map__O__scm_Map($$this, d) {
  return new $c_scm_Map$WithDefault().init___scm_Map__F1($$this, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($$this$1, d$1) {
    return (function(x$2) {
      return d$1
    })
  })($$this, d)))
}
function $s_scm_MapLike$class__updated__scm_MapLike__O__O__scm_Map($$this, key, value) {
  return $$this.$$plus__T2__scm_Map(new $c_T2().init___O__O(key, value))
}
function $s_scm_MapLike$class__put__scm_MapLike__O__O__s_Option($$this, key, value) {
  var r = $$this.get__O__s_Option(key);
  $$this.update__O__O__V(key, value);
  return r
}
function $s_scm_MapLike$class__remove__scm_MapLike__O__s_Option($$this, key) {
  var r = $$this.get__O__s_Option(key);
  $$this.$$minus$eq__O__scm_MapLike(key);
  return r
}
function $s_scm_MapLike$class__update__scm_MapLike__O__O__V($$this, key, value) {
  $$this.$$plus$eq__T2__scm_MapLike(new $c_T2().init___O__O(key, value))
}
function $s_scm_MapLike$class__getOrElseUpdate__scm_MapLike__O__F0__O($$this, key, op) {
  var x1 = $$this.get__O__s_Option(key);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var v = x2.x$2;
    return v
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var d = op.apply__O();
      $$this.update__O__O__V(key, d);
      return d
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $s_scm_ResizableArray$class__copyToArray__scm_ResizableArray__O__I__I__V($$this, xs, start, len) {
  var that = (($m_sr_ScalaRunTime$().array$undlength__O__I(xs) - start) | 0);
  var x = ((len < that) ? len : that);
  var that$1 = $$this.size0$6;
  var len1 = ((x < that$1) ? x : that$1);
  $m_s_Array$().copy__O__I__O__I__I__V($$this.array$6, 0, xs, start, len1)
}
function $s_scm_ResizableArray$class__ensureSize__scm_ResizableArray__I__V($$this, n) {
  var value = $$this.array$6.u.length;
  var hi = (value >> 31);
  var hi$1 = (n >> 31);
  if (((hi$1 === hi) ? (((-2147483648) ^ n) > ((-2147483648) ^ value)) : (hi$1 > hi))) {
    var lo = (value << 1);
    var hi$2 = (((value >>> 31) | 0) | (hi << 1));
    var newSize_$_lo$2 = lo;
    var newSize_$_hi$2 = hi$2;
    while (true) {
      var hi$3 = (n >> 31);
      var b_$_lo$2 = newSize_$_lo$2;
      var b_$_hi$2 = newSize_$_hi$2;
      var bhi = b_$_hi$2;
      if (((hi$3 === bhi) ? (((-2147483648) ^ n) > ((-2147483648) ^ b_$_lo$2)) : (hi$3 > bhi))) {
        var this$1_$_lo$2 = newSize_$_lo$2;
        var this$1_$_hi$2 = newSize_$_hi$2;
        var lo$1 = (this$1_$_lo$2 << 1);
        var hi$4 = (((this$1_$_lo$2 >>> 31) | 0) | (this$1_$_hi$2 << 1));
        var jsx$1_$_lo$2 = lo$1;
        var jsx$1_$_hi$2 = hi$4;
        newSize_$_lo$2 = jsx$1_$_lo$2;
        newSize_$_hi$2 = jsx$1_$_hi$2
      } else {
        break
      }
    };
    var this$2_$_lo$2 = newSize_$_lo$2;
    var this$2_$_hi$2 = newSize_$_hi$2;
    var ahi = this$2_$_hi$2;
    if (((ahi === 0) ? (((-2147483648) ^ this$2_$_lo$2) > (-1)) : (ahi > 0))) {
      var jsx$2_$_lo$2 = 2147483647;
      var jsx$2_$_hi$2 = 0;
      newSize_$_lo$2 = jsx$2_$_lo$2;
      newSize_$_hi$2 = jsx$2_$_hi$2
    };
    var this$3_$_lo$2 = newSize_$_lo$2;
    var this$3_$_hi$2 = newSize_$_hi$2;
    var newArray = $newArrayObject($d_O.getArrayOf(), [this$3_$_lo$2]);
    var src = $$this.array$6;
    var length = $$this.size0$6;
    $systemArraycopy(src, 0, newArray, 0, length);
    $$this.array$6 = newArray
  }
}
function $s_scm_ResizableArray$class__foreach__scm_ResizableArray__F1__V($$this, f) {
  var i = 0;
  var top = $$this.size0$6;
  while ((i < top)) {
    f.apply__O__O($$this.array$6.get(i));
    i = ((1 + i) | 0)
  }
}
function $s_scm_ResizableArray$class__apply__scm_ResizableArray__I__O($$this, idx) {
  if ((idx >= $$this.size0$6)) {
    throw new $c_jl_IndexOutOfBoundsException().init___T(("" + idx))
  };
  return $$this.array$6.get(idx)
}
function $s_scm_ResizableArray$class__$$init$__scm_ResizableArray__V($$this) {
  var x = $$this.initialSize$6;
  $$this.array$6 = $newArrayObject($d_O.getArrayOf(), [((x > 1) ? x : 1)]);
  $$this.size0$6 = 0
}
function $s_scm_SetLike$class__clone__scm_SetLike__scm_Set($$this) {
  var jsx$1 = $as_scg_Growable($$this.empty__sc_Set());
  var this$1 = $as_scm_Set($$this);
  return $as_scm_Set(jsx$1.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(this$1))
}
/** @constructor */
function $c_Lcats_kernel_EqFunctions() {
  $c_O.call(this)
}
$c_Lcats_kernel_EqFunctions.prototype = new $h_O();
$c_Lcats_kernel_EqFunctions.prototype.constructor = $c_Lcats_kernel_EqFunctions;
/** @constructor */
function $h_Lcats_kernel_EqFunctions() {
  /*<skip>*/
}
$h_Lcats_kernel_EqFunctions.prototype = $c_Lcats_kernel_EqFunctions.prototype;
/** @constructor */
function $c_Lcats_kernel_SemigroupFunctions() {
  $c_O.call(this)
}
$c_Lcats_kernel_SemigroupFunctions.prototype = new $h_O();
$c_Lcats_kernel_SemigroupFunctions.prototype.constructor = $c_Lcats_kernel_SemigroupFunctions;
/** @constructor */
function $h_Lcats_kernel_SemigroupFunctions() {
  /*<skip>*/
}
$h_Lcats_kernel_SemigroupFunctions.prototype = $c_Lcats_kernel_SemigroupFunctions.prototype;
/** @constructor */
function $c_Lcats_package$() {
  $c_O.call(this);
  this.catsInstancesForId$1 = null;
  this.catsRepresentableForId$1 = null;
  this.catsParallelForId$1 = null;
  this.Eq$1 = null;
  this.PartialOrder$1 = null;
  this.Order$1 = null;
  this.Comparison$1 = null;
  this.Hash$1 = null;
  this.Semigroup$1 = null;
  this.Monoid$1 = null;
  this.Group$1 = null
}
$c_Lcats_package$.prototype = new $h_O();
$c_Lcats_package$.prototype.constructor = $c_Lcats_package$;
/** @constructor */
function $h_Lcats_package$() {
  /*<skip>*/
}
$h_Lcats_package$.prototype = $c_Lcats_package$.prototype;
$c_Lcats_package$.prototype.init___ = (function() {
  $n_Lcats_package$ = this;
  this.catsInstancesForId$1 = new $c_Lcats_package$$anon$1().init___();
  this.catsRepresentableForId$1 = new $c_Lcats_package$$anon$2().init___();
  var evidence$17 = this.catsInstancesForId$1;
  this.catsParallelForId$1 = new $c_Lcats_Parallel$$anon$2().init___Lcats_Monad(evidence$17);
  this.Eq$1 = $m_Lcats_kernel_Eq$();
  this.PartialOrder$1 = $m_Lcats_kernel_PartialOrder$();
  this.Order$1 = $m_Lcats_kernel_Order$();
  this.Comparison$1 = $m_Lcats_kernel_Comparison$();
  this.Hash$1 = $m_Lcats_kernel_Hash$();
  this.Semigroup$1 = $m_Lcats_kernel_Semigroup$();
  this.Monoid$1 = $m_Lcats_kernel_Monoid$();
  this.Group$1 = $m_Lcats_kernel_Group$();
  return this
});
var $d_Lcats_package$ = new $TypeData().initClass({
  Lcats_package$: 0
}, false, "cats.package$", {
  Lcats_package$: 1,
  O: 1
});
$c_Lcats_package$.prototype.$classData = $d_Lcats_package$;
var $n_Lcats_package$ = (void 0);
function $m_Lcats_package$() {
  if ((!$n_Lcats_package$)) {
    $n_Lcats_package$ = new $c_Lcats_package$().init___()
  };
  return $n_Lcats_package$
}
/** @constructor */
function $c_Lio_circe_Printer$SizePredictor() {
  $c_O.call(this)
}
$c_Lio_circe_Printer$SizePredictor.prototype = new $h_O();
$c_Lio_circe_Printer$SizePredictor.prototype.constructor = $c_Lio_circe_Printer$SizePredictor;
/** @constructor */
function $h_Lio_circe_Printer$SizePredictor() {
  /*<skip>*/
}
$h_Lio_circe_Printer$SizePredictor.prototype = $c_Lio_circe_Printer$SizePredictor.prototype;
/** @constructor */
function $c_Lio_circe_jawn_JawnParser() {
  $c_O.call(this)
}
$c_Lio_circe_jawn_JawnParser.prototype = new $h_O();
$c_Lio_circe_jawn_JawnParser.prototype.constructor = $c_Lio_circe_jawn_JawnParser;
/** @constructor */
function $h_Lio_circe_jawn_JawnParser() {
  /*<skip>*/
}
$h_Lio_circe_jawn_JawnParser.prototype = $c_Lio_circe_jawn_JawnParser.prototype;
$c_Lio_circe_jawn_JawnParser.prototype.init___ = (function() {
  return this
});
var $d_Lio_circe_jawn_JawnParser = new $TypeData().initClass({
  Lio_circe_jawn_JawnParser: 0
}, false, "io.circe.jawn.JawnParser", {
  Lio_circe_jawn_JawnParser: 1,
  O: 1
});
$c_Lio_circe_jawn_JawnParser.prototype.$classData = $d_Lio_circe_jawn_JawnParser;
/** @constructor */
function $c_Lio_circe_scalajs_package$() {
  $c_O.call(this);
  this.toJsAnyFolder$1 = null
}
$c_Lio_circe_scalajs_package$.prototype = new $h_O();
$c_Lio_circe_scalajs_package$.prototype.constructor = $c_Lio_circe_scalajs_package$;
/** @constructor */
function $h_Lio_circe_scalajs_package$() {
  /*<skip>*/
}
$h_Lio_circe_scalajs_package$.prototype = $c_Lio_circe_scalajs_package$.prototype;
$c_Lio_circe_scalajs_package$.prototype.init___ = (function() {
  $n_Lio_circe_scalajs_package$ = this;
  this.toJsAnyFolder$1 = new $c_Lio_circe_scalajs_package$$anon$1().init___();
  return this
});
$c_Lio_circe_scalajs_package$.prototype.io$circe$scalajs$package$$convertAnyToJsonUnsafe__O__Lio_circe_Json = (function(input) {
  if ($is_T(input)) {
    var x2 = $as_T(input);
    $m_Lio_circe_Json$();
    return new $c_Lio_circe_Json$JString().init___T(x2)
  } else if (((typeof input) === "number")) {
    var x3 = $uD(input);
    return $m_Lio_circe_Json$().fromDoubleOrNull__D__Lio_circe_Json(x3)
  } else if ($m_sr_BoxesRunTime$().equals__O__O__Z(true, input)) {
    return $m_Lio_circe_Json$().True$1
  } else if ($m_sr_BoxesRunTime$().equals__O__O__Z(false, input)) {
    return $m_Lio_circe_Json$().False$1
  } else if ((input === null)) {
    return $m_Lio_circe_Json$().Null$1
  } else if ($uZ((input instanceof $g.Array))) {
    $m_Lio_circe_Json$();
    var array = [];
    $uI(input.length);
    var i = 0;
    var len = $uI(input.length);
    while ((i < len)) {
      var index = i;
      var arg1 = input[index];
      var elem = $m_Lio_circe_scalajs_package$().io$circe$scalajs$package$$convertAnyToJsonUnsafe__O__Lio_circe_Json(arg1);
      array.push(elem);
      i = ((1 + i) | 0)
    };
    var values = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
    $m_sci_Vector$();
    var cbf = $m_sc_IndexedSeq$().ReusableCBF$6;
    return new $c_Lio_circe_Json$JArray().init___sci_Vector($as_sci_Vector($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(values, cbf)))
  } else if ($uZ((input instanceof $g.Object))) {
    var jsx$1 = $m_Lio_circe_Json$();
    var this$8 = new $c_sjs_js_WrappedDictionary().init___sjs_js_Dictionary(input);
    var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(input$2) {
      return $m_Lio_circe_scalajs_package$().io$circe$scalajs$package$$convertAnyToJsonUnsafe__O__Lio_circe_Json(input$2)
    }));
    var this$9 = new $c_sc_MapLike$MappedValues().init___sc_MapLike__F1(this$8, f);
    return jsx$1.fromFields__sc_Iterable__Lio_circe_Json($s_sc_MapLike$class__toBuffer__sc_MapLike__scm_Buffer(this$9))
  } else if ((input === (void 0))) {
    return $m_Lio_circe_Json$().Null$1
  } else {
    throw new $c_s_MatchError().init___O(input)
  }
});
$c_Lio_circe_scalajs_package$.prototype.convertJsToJson__sjs_js_Any__s_util_Either = (function(input) {
  try {
    $m_s_package$();
    var b = this.io$circe$scalajs$package$$convertAnyToJsonUnsafe__O__Lio_circe_Json(input);
    return new $c_s_util_Right().init___O(b)
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
      if ((!o11.isEmpty__Z())) {
        var exception = $as_jl_Throwable(o11.get__O());
        $m_s_package$();
        return new $c_s_util_Left().init___O(exception)
      };
      throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
    } else {
      throw e
    }
  }
});
var $d_Lio_circe_scalajs_package$ = new $TypeData().initClass({
  Lio_circe_scalajs_package$: 0
}, false, "io.circe.scalajs.package$", {
  Lio_circe_scalajs_package$: 1,
  O: 1
});
$c_Lio_circe_scalajs_package$.prototype.$classData = $d_Lio_circe_scalajs_package$;
var $n_Lio_circe_scalajs_package$ = (void 0);
function $m_Lio_circe_scalajs_package$() {
  if ((!$n_Lio_circe_scalajs_package$)) {
    $n_Lio_circe_scalajs_package$ = new $c_Lio_circe_scalajs_package$().init___()
  };
  return $n_Lio_circe_scalajs_package$
}
/** @constructor */
function $c_Lio_youi_Cache$() {
  $c_O.call(this);
  this.implementation$1 = null
}
$c_Lio_youi_Cache$.prototype = new $h_O();
$c_Lio_youi_Cache$.prototype.constructor = $c_Lio_youi_Cache$;
/** @constructor */
function $h_Lio_youi_Cache$() {
  /*<skip>*/
}
$h_Lio_youi_Cache$.prototype = $c_Lio_youi_Cache$.prototype;
$c_Lio_youi_Cache$.prototype.init___ = (function() {
  return this
});
var $d_Lio_youi_Cache$ = new $TypeData().initClass({
  Lio_youi_Cache$: 0
}, false, "io.youi.Cache$", {
  Lio_youi_Cache$: 1,
  O: 1
});
$c_Lio_youi_Cache$.prototype.$classData = $d_Lio_youi_Cache$;
var $n_Lio_youi_Cache$ = (void 0);
function $m_Lio_youi_Cache$() {
  if ((!$n_Lio_youi_Cache$)) {
    $n_Lio_youi_Cache$ = new $c_Lio_youi_Cache$().init___()
  };
  return $n_Lio_youi_Cache$
}
/** @constructor */
function $c_Lio_youi_Color() {
  $c_O.call(this);
  this.value$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_Lio_youi_Color.prototype = new $h_O();
$c_Lio_youi_Color.prototype.constructor = $c_Lio_youi_Color;
/** @constructor */
function $h_Lio_youi_Color() {
  /*<skip>*/
}
$h_Lio_youi_Color.prototype = $c_Lio_youi_Color.prototype;
$c_Lio_youi_Color.prototype.init___J = (function(value) {
  this.value$1 = value;
  return this
});
$c_Lio_youi_Color.prototype.equals__O__Z = (function(x$1) {
  return $m_Lio_youi_Color$().equals$extension__J__O__Z(this.value$1, x$1)
});
$c_Lio_youi_Color.prototype.toString__T = (function() {
  return $m_Lio_youi_Color$().toString$extension__J__T(this.value$1)
});
$c_Lio_youi_Color.prototype.hashCode__I = (function() {
  $m_Lio_youi_Color$();
  var t = this.value$1;
  var lo = t.lo$2;
  var hi = t.hi$2;
  return (lo ^ hi)
});
function $is_Lio_youi_Color(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_Color)))
}
function $as_Lio_youi_Color(obj) {
  return (($is_Lio_youi_Color(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.Color"))
}
function $isArrayOf_Lio_youi_Color(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_Color)))
}
function $asArrayOf_Lio_youi_Color(obj, depth) {
  return (($isArrayOf_Lio_youi_Color(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.Color;", depth))
}
var $d_Lio_youi_Color = new $TypeData().initClass({
  Lio_youi_Color: 0
}, false, "io.youi.Color", {
  Lio_youi_Color: 1,
  O: 1
});
$c_Lio_youi_Color.prototype.$classData = $d_Lio_youi_Color;
/** @constructor */
function $c_Lio_youi_Color$() {
  $c_O.call(this);
  this.Clear$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.AliceBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.AntiqueWhite$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Aqua$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Aquamarine$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Azure$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Beige$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Bisque$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Black$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.BlanchedAlmond$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Blue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.BlueViolet$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Brown$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.BurlyWood$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.CadetBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Chartreuse$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Chocolate$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Coral$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.CornflowerBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Cornsilk$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Crimson$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Cyan$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkCyan$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkGoldenRod$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkKhaki$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkMagenta$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkOliveGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkOrange$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkOrchid$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkSalmon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkSeaGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkSlateBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkSlateGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkTurquoise$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DarkViolet$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DeepPink$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DeepSkyBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DimGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.DodgerBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.FireBrick$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.FloralWhite$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.ForestGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Fuchsia$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Gainsboro$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.GhostWhite$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Gold$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.GoldenRod$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Gray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Green$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.GreenYellow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.HoneyDew$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.HotPink$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.IndianRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Indigo$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Ivory$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Khaki$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Lavender$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LavenderBlush$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LawnGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LemonChiffon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightCoral$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightCyan$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightGoldenRodYellow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightPink$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSalmon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSeaGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSkyBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSlateGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightSteelBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LightYellow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Lime$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.LimeGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Linen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Magenta$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Maroon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumAquaMarine$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumOrchid$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumPurple$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumSeaGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumSlateBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumSpringGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumTurquoise$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MediumVioletRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MidnightBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MintCream$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.MistyRose$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Moccasin$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.NavajoWhite$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Navy$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.OldLace$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Olive$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.OliveDrab$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Orange$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.OrangeRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Orchid$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PaleGoldenRod$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PaleGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PaleTurquoise$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PaleVioletRed$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PapayaWhip$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PeachPuff$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Peru$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Pink$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Plum$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.PowderBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Purple$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.RebeccaPurple$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Red$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.RosyBrown$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.RoyalBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SaddleBrown$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Salmon$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SandyBrown$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SeaGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SeaShell$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Sienna$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Silver$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SkyBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SlateBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SlateGray$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Snow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SpringGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.SteelBlue$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Tan$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Teal$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Thistle$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Tomato$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Turquoise$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Violet$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Wheat$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.White$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.WhiteSmoke$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Yellow$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.YellowGreen$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.Hex3Regex$1 = null;
  this.Hex6Regex$1 = null;
  this.RGBARegex$1 = null
}
$c_Lio_youi_Color$.prototype = new $h_O();
$c_Lio_youi_Color$.prototype.constructor = $c_Lio_youi_Color$;
/** @constructor */
function $h_Lio_youi_Color$() {
  /*<skip>*/
}
$h_Lio_youi_Color$.prototype = $c_Lio_youi_Color$.prototype;
$c_Lio_youi_Color$.prototype.init___ = (function() {
  $n_Lio_youi_Color$ = this;
  this.Clear$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.AliceBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-252116993), (-1));
  this.AntiqueWhite$1 = new $c_sjsr_RuntimeLong().init___I__I((-85207041), (-1));
  this.Aqua$1 = new $c_sjsr_RuntimeLong().init___I__I(16777215, 0);
  this.Aquamarine$1 = new $c_sjsr_RuntimeLong().init___I__I(2147472639, 0);
  this.Azure$1 = new $c_sjsr_RuntimeLong().init___I__I((-251658241), (-1));
  this.Beige$1 = new $c_sjsr_RuntimeLong().init___I__I((-168436481), (-1));
  this.Bisque$1 = new $c_sjsr_RuntimeLong().init___I__I((-1784577), (-1));
  this.Black$1 = new $c_sjsr_RuntimeLong().init___I__I(255, 0);
  this.BlanchedAlmond$1 = new $c_sjsr_RuntimeLong().init___I__I((-1323521), (-1));
  this.Blue$1 = new $c_sjsr_RuntimeLong().init___I__I(65535, 0);
  this.BlueViolet$1 = new $c_sjsr_RuntimeLong().init___I__I((-1976835329), (-1));
  this.Brown$1 = new $c_sjsr_RuntimeLong().init___I__I((-1523963137), (-1));
  this.BurlyWood$1 = new $c_sjsr_RuntimeLong().init___I__I((-558331905), (-1));
  this.CadetBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1604231423, 0);
  this.Chartreuse$1 = new $c_sjsr_RuntimeLong().init___I__I(2147418367, 0);
  this.Chocolate$1 = new $c_sjsr_RuntimeLong().init___I__I((-764862721), (-1));
  this.Coral$1 = new $c_sjsr_RuntimeLong().init___I__I((-8433409), (-1));
  this.CornflowerBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1687547391, 0);
  this.Cornsilk$1 = new $c_sjsr_RuntimeLong().init___I__I((-467713), (-1));
  this.Crimson$1 = new $c_sjsr_RuntimeLong().init___I__I((-602653441), (-1));
  this.Cyan$1 = new $c_sjsr_RuntimeLong().init___I__I(16777215, 0);
  this.DarkBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(35839, 0);
  this.DarkCyan$1 = new $c_sjsr_RuntimeLong().init___I__I(9145343, 0);
  this.DarkGoldenRod$1 = new $c_sjsr_RuntimeLong().init___I__I((-1199174657), (-1));
  this.DarkGray$1 = new $c_sjsr_RuntimeLong().init___I__I((-1448498689), (-1));
  this.DarkGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(6553855, 0);
  this.DarkKhaki$1 = new $c_sjsr_RuntimeLong().init___I__I((-1112052737), (-1));
  this.DarkMagenta$1 = new $c_sjsr_RuntimeLong().init___I__I((-1962898433), (-1));
  this.DarkOliveGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(1433087999, 0);
  this.DarkOrange$1 = new $c_sjsr_RuntimeLong().init___I__I((-7601921), (-1));
  this.DarkOrchid$1 = new $c_sjsr_RuntimeLong().init___I__I((-1724723969), (-1));
  this.DarkRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-1962934017), (-1));
  this.DarkSalmon$1 = new $c_sjsr_RuntimeLong().init___I__I((-376014081), (-1));
  this.DarkSeaGreen$1 = new $c_sjsr_RuntimeLong().init___I__I((-1883467777), (-1));
  this.DarkSlateBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1211993087, 0);
  this.DarkSlateGray$1 = new $c_sjsr_RuntimeLong().init___I__I(793726975, 0);
  this.DarkTurquoise$1 = new $c_sjsr_RuntimeLong().init___I__I(13554175, 0);
  this.DarkViolet$1 = new $c_sjsr_RuntimeLong().init___I__I((-1811885057), (-1));
  this.DeepPink$1 = new $c_sjsr_RuntimeLong().init___I__I((-15428609), (-1));
  this.DeepSkyBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(12582911, 0);
  this.DimGray$1 = new $c_sjsr_RuntimeLong().init___I__I(1768516095, 0);
  this.DodgerBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(512819199, 0);
  this.FireBrick$1 = new $c_sjsr_RuntimeLong().init___I__I((-1306385665), (-1));
  this.FloralWhite$1 = new $c_sjsr_RuntimeLong().init___I__I((-331521), (-1));
  this.ForestGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(579543807, 0);
  this.Fuchsia$1 = new $c_sjsr_RuntimeLong().init___I__I((-16711681), (-1));
  this.Gainsboro$1 = new $c_sjsr_RuntimeLong().init___I__I((-589505281), (-1));
  this.GhostWhite$1 = new $c_sjsr_RuntimeLong().init___I__I((-117899265), (-1));
  this.Gold$1 = new $c_sjsr_RuntimeLong().init___I__I((-2686721), (-1));
  this.GoldenRod$1 = new $c_sjsr_RuntimeLong().init___I__I((-626712321), (-1));
  this.Gray$1 = new $c_sjsr_RuntimeLong().init___I__I((-2139062017), (-1));
  this.Green$1 = new $c_sjsr_RuntimeLong().init___I__I(8388863, 0);
  this.GreenYellow$1 = new $c_sjsr_RuntimeLong().init___I__I((-1375784961), (-1));
  this.HoneyDew$1 = new $c_sjsr_RuntimeLong().init___I__I((-251662081), (-1));
  this.HotPink$1 = new $c_sjsr_RuntimeLong().init___I__I((-9849601), (-1));
  this.IndianRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-849584897), (-1));
  this.Indigo$1 = new $c_sjsr_RuntimeLong().init___I__I(1258324735, 0);
  this.Ivory$1 = new $c_sjsr_RuntimeLong().init___I__I((-3841), (-1));
  this.Khaki$1 = new $c_sjsr_RuntimeLong().init___I__I((-253326081), (-1));
  this.Lavender$1 = new $c_sjsr_RuntimeLong().init___I__I((-421070081), (-1));
  this.LavenderBlush$1 = new $c_sjsr_RuntimeLong().init___I__I((-985601), (-1));
  this.LawnGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(2096890111, 0);
  this.LemonChiffon$1 = new $c_sjsr_RuntimeLong().init___I__I((-340481), (-1));
  this.LightBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-1378294017), (-1));
  this.LightCoral$1 = new $c_sjsr_RuntimeLong().init___I__I((-260013825), (-1));
  this.LightCyan$1 = new $c_sjsr_RuntimeLong().init___I__I((-520093697), (-1));
  this.LightGoldenRodYellow$1 = new $c_sjsr_RuntimeLong().init___I__I((-84225281), (-1));
  this.LightGray$1 = new $c_sjsr_RuntimeLong().init___I__I((-741092353), (-1));
  this.LightGreen$1 = new $c_sjsr_RuntimeLong().init___I__I((-1863413505), (-1));
  this.LightPink$1 = new $c_sjsr_RuntimeLong().init___I__I((-4800001), (-1));
  this.LightSalmon$1 = new $c_sjsr_RuntimeLong().init___I__I((-6259969), (-1));
  this.LightSeaGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(548580095, 0);
  this.LightSkyBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-2016478465), (-1));
  this.LightSlateGray$1 = new $c_sjsr_RuntimeLong().init___I__I(2005441023, 0);
  this.LightSteelBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-1329275137), (-1));
  this.LightYellow$1 = new $c_sjsr_RuntimeLong().init___I__I((-7937), (-1));
  this.Lime$1 = new $c_sjsr_RuntimeLong().init___I__I(16711935, 0);
  this.LimeGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(852308735, 0);
  this.Linen$1 = new $c_sjsr_RuntimeLong().init___I__I((-84875521), (-1));
  this.Magenta$1 = new $c_sjsr_RuntimeLong().init___I__I((-16711681), (-1));
  this.Maroon$1 = new $c_sjsr_RuntimeLong().init___I__I((-2147483393), (-1));
  this.MediumAquaMarine$1 = new $c_sjsr_RuntimeLong().init___I__I(1724754687, 0);
  this.MediumBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(52735, 0);
  this.MediumOrchid$1 = new $c_sjsr_RuntimeLong().init___I__I((-1168780289), (-1));
  this.MediumPurple$1 = new $c_sjsr_RuntimeLong().init___I__I((-1821320193), (-1));
  this.MediumSeaGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(1018393087, 0);
  this.MediumSlateBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(2070474495, 0);
  this.MediumSpringGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(16423679, 0);
  this.MediumTurquoise$1 = new $c_sjsr_RuntimeLong().init___I__I(1221709055, 0);
  this.MediumVioletRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-954890753), (-1));
  this.MidnightBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(421097727, 0);
  this.MintCream$1 = new $c_sjsr_RuntimeLong().init___I__I((-167773441), (-1));
  this.MistyRose$1 = new $c_sjsr_RuntimeLong().init___I__I((-1777153), (-1));
  this.Moccasin$1 = new $c_sjsr_RuntimeLong().init___I__I((-1788417), (-1));
  this.NavajoWhite$1 = new $c_sjsr_RuntimeLong().init___I__I((-2183681), (-1));
  this.Navy$1 = new $c_sjsr_RuntimeLong().init___I__I(33023, 0);
  this.OldLace$1 = new $c_sjsr_RuntimeLong().init___I__I((-34216193), (-1));
  this.Olive$1 = new $c_sjsr_RuntimeLong().init___I__I((-2139094785), (-1));
  this.OliveDrab$1 = new $c_sjsr_RuntimeLong().init___I__I(1804477439, 0);
  this.Orange$1 = new $c_sjsr_RuntimeLong().init___I__I((-5963521), (-1));
  this.OrangeRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-12254977), (-1));
  this.Orchid$1 = new $c_sjsr_RuntimeLong().init___I__I((-630139137), (-1));
  this.PaleGoldenRod$1 = new $c_sjsr_RuntimeLong().init___I__I((-286741761), (-1));
  this.PaleGreen$1 = new $c_sjsr_RuntimeLong().init___I__I((-1728341761), (-1));
  this.PaleTurquoise$1 = new $c_sjsr_RuntimeLong().init___I__I((-1343295745), (-1));
  this.PaleVioletRed$1 = new $c_sjsr_RuntimeLong().init___I__I((-613379073), (-1));
  this.PapayaWhip$1 = new $c_sjsr_RuntimeLong().init___I__I((-1059329), (-1));
  this.PeachPuff$1 = new $c_sjsr_RuntimeLong().init___I__I((-2442753), (-1));
  this.Peru$1 = new $c_sjsr_RuntimeLong().init___I__I((-846905345), (-1));
  this.Pink$1 = new $c_sjsr_RuntimeLong().init___I__I((-4142081), (-1));
  this.Plum$1 = new $c_sjsr_RuntimeLong().init___I__I((-576659969), (-1));
  this.PowderBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-1327438081), (-1));
  this.Purple$1 = new $c_sjsr_RuntimeLong().init___I__I((-2147450625), (-1));
  this.RebeccaPurple$1 = new $c_sjsr_RuntimeLong().init___I__I(1714657791, 0);
  this.Red$1 = new $c_sjsr_RuntimeLong().init___I__I((-16776961), (-1));
  this.RosyBrown$1 = new $c_sjsr_RuntimeLong().init___I__I((-1131442177), (-1));
  this.RoyalBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1097458175, 0);
  this.SaddleBrown$1 = new $c_sjsr_RuntimeLong().init___I__I((-1958407169), (-1));
  this.Salmon$1 = new $c_sjsr_RuntimeLong().init___I__I((-92245249), (-1));
  this.SandyBrown$1 = new $c_sjsr_RuntimeLong().init___I__I((-190553857), (-1));
  this.SeaGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(780883967, 0);
  this.SeaShell$1 = new $c_sjsr_RuntimeLong().init___I__I((-659713), (-1));
  this.Sienna$1 = new $c_sjsr_RuntimeLong().init___I__I((-1605227009), (-1));
  this.Silver$1 = new $c_sjsr_RuntimeLong().init___I__I((-1061109505), (-1));
  this.SkyBlue$1 = new $c_sjsr_RuntimeLong().init___I__I((-2016482305), (-1));
  this.SlateBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1784335871, 0);
  this.SlateGray$1 = new $c_sjsr_RuntimeLong().init___I__I(1887473919, 0);
  this.Snow$1 = new $c_sjsr_RuntimeLong().init___I__I((-328961), (-1));
  this.SpringGreen$1 = new $c_sjsr_RuntimeLong().init___I__I(16744447, 0);
  this.SteelBlue$1 = new $c_sjsr_RuntimeLong().init___I__I(1182971135, 0);
  this.Tan$1 = new $c_sjsr_RuntimeLong().init___I__I((-759919361), (-1));
  this.Teal$1 = new $c_sjsr_RuntimeLong().init___I__I(8421631, 0);
  this.Thistle$1 = new $c_sjsr_RuntimeLong().init___I__I((-658515713), (-1));
  this.Tomato$1 = new $c_sjsr_RuntimeLong().init___I__I((-10270721), (-1));
  this.Turquoise$1 = new $c_sjsr_RuntimeLong().init___I__I(1088475391, 0);
  this.Violet$1 = new $c_sjsr_RuntimeLong().init___I__I((-293409025), (-1));
  this.Wheat$1 = new $c_sjsr_RuntimeLong().init___I__I((-169954305), (-1));
  this.White$1 = new $c_sjsr_RuntimeLong().init___I__I((-1), (-1));
  this.WhiteSmoke$1 = new $c_sjsr_RuntimeLong().init___I__I((-168430081), (-1));
  this.Yellow$1 = new $c_sjsr_RuntimeLong().init___I__I((-65281), (-1));
  this.YellowGreen$1 = new $c_sjsr_RuntimeLong().init___I__I((-1697828097), (-1));
  var this$2 = new $c_sci_StringOps().init___T("#?([\\w\\d])([\\w\\d])([\\w\\d])");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  this.Hex3Regex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames);
  var this$5 = new $c_sci_StringOps().init___T("#?([\\w\\d]{2})([\\w\\d]{2})([\\w\\d]{2})");
  var groupNames$1 = $m_sci_Nil$();
  var $$this$1 = this$5.repr$1;
  this.Hex6Regex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$1, groupNames$1);
  var this$8 = new $c_sci_StringOps().init___T("rgba\\((\\d+), (\\d+), (\\d+), ([\\d.]+)\\)");
  var groupNames$2 = $m_sci_Nil$();
  var $$this$2 = this$8.repr$1;
  this.RGBARegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$2, groupNames$2);
  return this
});
$c_Lio_youi_Color$.prototype.fromHex__T__J = (function(value) {
  _fromHex: while (true) {
    var thiz = value;
    var x1 = $uI(thiz.length);
    var thiz$1 = value;
    if ((($uI(thiz$1.length) >= 0) && ($as_T(thiz$1.substring(0, $uI("#".length))) === "#"))) {
      var thiz$2 = value;
      value = $as_T(thiz$2.substring(1));
      continue _fromHex
    } else if ((x1 === 1)) {
      var value$1 = value;
      $m_sci_IndexedSeq$();
      $m_sc_IndexedSeq$();
      $m_sci_IndexedSeq$();
      $m_sci_Vector$();
      var b = new $c_sci_VectorBuilder().init___();
      var i = 0;
      while (true) {
        var arg1 = i;
        b.$$plus$eq__O__sci_VectorBuilder(value$1);
        if ((i === 7)) {
          break
        };
        i = ((1 + i) | 0)
      };
      var this$15 = b.result__sci_Vector();
      value = $s_sc_TraversableOnce$class__mkString__sc_TraversableOnce__T__T__T__T(this$15, "", "", "");
      continue _fromHex
    } else if ((x1 === 2)) {
      var value$1$1 = value;
      $m_sci_IndexedSeq$();
      $m_sc_IndexedSeq$();
      $m_sci_IndexedSeq$();
      $m_sci_Vector$();
      var b$1 = new $c_sci_VectorBuilder().init___();
      var i$1 = 0;
      while (true) {
        var arg1$1 = i$1;
        b$1.$$plus$eq__O__sci_VectorBuilder(value$1$1);
        if ((i$1 === 3)) {
          break
        };
        i$1 = ((1 + i$1) | 0)
      };
      var this$22 = b$1.result__sci_Vector();
      value = $s_sc_TraversableOnce$class__mkString__sc_TraversableOnce__T__T__T__T(this$22, "", "", "");
      continue _fromHex
    } else if ((x1 === 3)) {
      var thiz$3 = value;
      var r = (65535 & $uI(thiz$3.charCodeAt(0)));
      var thiz$4 = value;
      var g = (65535 & $uI(thiz$4.charCodeAt(1)));
      var thiz$5 = value;
      var b$2 = (65535 & $uI(thiz$5.charCodeAt(2)));
      var array = ["", "", "", "", "", "", "ff"];
      var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
      var array$1 = [new $c_jl_Character().init___C(r), new $c_jl_Character().init___C(r), new $c_jl_Character().init___C(g), new $c_jl_Character().init___C(g), new $c_jl_Character().init___C(b$2), new $c_jl_Character().init___C(b$2)];
      value = jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1));
      continue _fromHex
    } else if ((x1 === 4)) {
      var thiz$6 = value;
      var r$2 = (65535 & $uI(thiz$6.charCodeAt(0)));
      var thiz$7 = value;
      var g$2 = (65535 & $uI(thiz$7.charCodeAt(1)));
      var thiz$8 = value;
      var b$2$1 = (65535 & $uI(thiz$8.charCodeAt(2)));
      var thiz$9 = value;
      var a = (65535 & $uI(thiz$9.charCodeAt(3)));
      var array$2 = ["", "", "", "", "", "", "", "", ""];
      var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$2));
      var array$3 = [new $c_jl_Character().init___C(r$2), new $c_jl_Character().init___C(r$2), new $c_jl_Character().init___C(g$2), new $c_jl_Character().init___C(g$2), new $c_jl_Character().init___C(b$2$1), new $c_jl_Character().init___C(b$2$1), new $c_jl_Character().init___C(a), new $c_jl_Character().init___C(a)];
      value = jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$3));
      continue _fromHex
    } else if ((x1 === 6)) {
      var array$4 = ["", "ff"];
      var jsx$3 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$4));
      var array$5 = [value];
      value = jsx$3.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$5));
      continue _fromHex
    } else if ((x1 === 8)) {
      var t = $m_jl_Long$().parseLong__T__I__J(value, 16);
      var lo = t.lo$2;
      var hi = t.hi$2;
      return new $c_sjsr_RuntimeLong().init___I__I(lo, hi)
    } else {
      var jsx$5 = $m_sjsr_package$();
      var array$6 = ["Unsupported hex length (", ") for ", "."];
      var jsx$4 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$6));
      var array$7 = [x1, value];
      throw jsx$5.unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(jsx$4.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$7))))
    }
  }
});
$c_Lio_youi_Color$.prototype.equals$extension__J__O__Z = (function($$this, x$1) {
  if ($is_Lio_youi_Color(x$1)) {
    var t = $as_Lio_youi_Color(x$1).value$1;
    var lo = t.lo$2;
    var hi = t.hi$2;
    return (($$this.lo$2 === lo) && ($$this.hi$2 === hi))
  } else {
    return false
  }
});
$c_Lio_youi_Color$.prototype.hexify__p1__D__T = (function(value) {
  var x = (255.0 * value);
  return this.hexify__p1__I__T($doubleToInt($uD($g.Math.floor(x))))
});
$c_Lio_youi_Color$.prototype.greenHex$extension__J__T = (function($$this) {
  return $m_Lio_youi_Color$().hexify__p1__I__T(this.greenInt$extension__J__I($$this))
});
$c_Lio_youi_Color$.prototype.toRGBA$extension__J__T = (function($$this) {
  var array = ["rgba(", ", ", ", ", ", ", ")"];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [this.redInt$extension__J__I($$this), this.greenInt$extension__J__I($$this), this.blueInt$extension__J__I($$this), this.alpha$extension__J__D($$this)];
  return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
});
$c_Lio_youi_Color$.prototype.toString$extension__J__T = (function($$this) {
  var array = ["Color(red: ", ", green: ", ", blue: ", ", alpha: ", ")"];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [this.red$extension__J__D($$this), this.green$extension__J__D($$this), this.blue$extension__J__D($$this), this.alpha$extension__J__D($$this)];
  return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
});
$c_Lio_youi_Color$.prototype.withAlpha$extension__J__D__J = (function($$this, alpha) {
  var jsx$2 = $m_Lio_youi_Color$();
  var array = ["", "", "", "", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [this.redHex$extension__J__T($$this), this.greenHex$extension__J__T($$this), this.blueHex$extension__J__T($$this), $m_Lio_youi_Color$().hexify__p1__D__T(alpha)];
  return jsx$2.fromHex__T__J(jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1)))
});
$c_Lio_youi_Color$.prototype.alphaInt$extension__J__I = (function($$this) {
  var lo = (255 & $$this.lo$2);
  return lo
});
$c_Lio_youi_Color$.prototype.greenInt$extension__J__I = (function($$this) {
  var lo = ((($$this.lo$2 >>> 16) | 0) | ($$this.hi$2 << 16));
  var lo$1 = (255 & lo);
  return lo$1
});
$c_Lio_youi_Color$.prototype.redHex$extension__J__T = (function($$this) {
  return $m_Lio_youi_Color$().hexify__p1__I__T(this.redInt$extension__J__I($$this))
});
$c_Lio_youi_Color$.prototype.withRed$extension__J__D__J = (function($$this, red) {
  var jsx$2 = $m_Lio_youi_Color$();
  var array = ["", "", "", "", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [$m_Lio_youi_Color$().hexify__p1__D__T(red), this.greenHex$extension__J__T($$this), this.blueHex$extension__J__T($$this), this.alphaHex$extension__J__T($$this)];
  return jsx$2.fromHex__T__J(jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1)))
});
$c_Lio_youi_Color$.prototype.blueHex$extension__J__T = (function($$this) {
  return $m_Lio_youi_Color$().hexify__p1__I__T(this.blueInt$extension__J__I($$this))
});
$c_Lio_youi_Color$.prototype.redInt$extension__J__I = (function($$this) {
  var lo = ((($$this.lo$2 >>> 24) | 0) | ($$this.hi$2 << 8));
  var lo$1 = (255 & lo);
  return lo$1
});
$c_Lio_youi_Color$.prototype.unapply__T__s_Option = (function(value) {
  if (((value === null) || (value === ""))) {
    return $m_s_None$()
  };
  var o16 = this.Hex3Regex$1.unapplySeq__jl_CharSequence__s_Option(value);
  if ((!o16.isEmpty__Z())) {
    if ((o16.get__O() !== null)) {
      var this$1 = $as_sc_LinearSeqOptimized(o16.get__O());
      var jsx$1 = ($s_sc_LinearSeqOptimized$class__lengthCompare__sc_LinearSeqOptimized__I__I(this$1, 3) === 0)
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      var this$2 = $as_sc_LinearSeqOptimized(o16.get__O());
      var r = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$2, 0));
      var this$3 = $as_sc_LinearSeqOptimized(o16.get__O());
      var g = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$3, 1));
      var this$4 = $as_sc_LinearSeqOptimized(o16.get__O());
      var b = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$4, 2));
      var jsx$3 = $m_jl_Long$();
      var array = ["", "", "", "", "", "", "ff"];
      var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
      var array$1 = [r, r, g, g, b, b];
      var t = jsx$3.parseLong__T__I__J(jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1)), 16);
      var lo = t.lo$2;
      var hi = t.hi$2;
      return new $c_s_Some().init___O(new $c_Lio_youi_Color().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo, hi)))
    }
  };
  var o18 = this.Hex6Regex$1.unapplySeq__jl_CharSequence__s_Option(value);
  if ((!o18.isEmpty__Z())) {
    if ((o18.get__O() !== null)) {
      var this$9 = $as_sc_LinearSeqOptimized(o18.get__O());
      var jsx$4 = ($s_sc_LinearSeqOptimized$class__lengthCompare__sc_LinearSeqOptimized__I__I(this$9, 3) === 0)
    } else {
      var jsx$4 = false
    };
    if (jsx$4) {
      var this$10 = $as_sc_LinearSeqOptimized(o18.get__O());
      var r$2 = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$10, 0));
      var this$11 = $as_sc_LinearSeqOptimized(o18.get__O());
      var g$2 = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$11, 1));
      var this$12 = $as_sc_LinearSeqOptimized(o18.get__O());
      var b$2 = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$12, 2));
      var jsx$6 = $m_jl_Long$();
      var array$2 = ["", "", "", "ff"];
      var jsx$5 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$2));
      var array$3 = [r$2, g$2, b$2];
      var t$1 = jsx$6.parseLong__T__I__J(jsx$5.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$3)), 16);
      var lo$1 = t$1.lo$2;
      var hi$1 = t$1.hi$2;
      return new $c_s_Some().init___O(new $c_Lio_youi_Color().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1)))
    }
  };
  var o20 = this.RGBARegex$1.unapplySeq__jl_CharSequence__s_Option(value);
  if ((!o20.isEmpty__Z())) {
    if ((o20.get__O() !== null)) {
      var this$17 = $as_sc_LinearSeqOptimized(o20.get__O());
      var jsx$7 = ($s_sc_LinearSeqOptimized$class__lengthCompare__sc_LinearSeqOptimized__I__I(this$17, 4) === 0)
    } else {
      var jsx$7 = false
    };
    if (jsx$7) {
      var this$18 = $as_sc_LinearSeqOptimized(o20.get__O());
      var r$3 = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$18, 0));
      var this$19 = $as_sc_LinearSeqOptimized(o20.get__O());
      var g$3 = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$19, 1));
      var this$20 = $as_sc_LinearSeqOptimized(o20.get__O());
      var b$3 = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$20, 2));
      var this$21 = $as_sc_LinearSeqOptimized(o20.get__O());
      var a = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$21, 3));
      var this$23 = new $c_sci_StringOps().init___T(r$3);
      var this$25 = $m_jl_Integer$();
      var $$this = this$23.repr$1;
      var red = this.hexify__p1__I__T(this$25.parseInt__T__I__I($$this, 10));
      var this$27 = new $c_sci_StringOps().init___T(g$3);
      var this$29 = $m_jl_Integer$();
      var $$this$1 = this$27.repr$1;
      var green = this.hexify__p1__I__T(this$29.parseInt__T__I__I($$this$1, 10));
      var this$31 = new $c_sci_StringOps().init___T(b$3);
      var this$33 = $m_jl_Integer$();
      var $$this$2 = this$31.repr$1;
      var blue = this.hexify__p1__I__T(this$33.parseInt__T__I__I($$this$2, 10));
      var this$35 = new $c_sci_StringOps().init___T(a);
      var jsx$8 = $m_jl_Double$();
      var $$this$3 = this$35.repr$1;
      var alpha = this.hexify__p1__D__T(jsx$8.parseDouble__T__D($$this$3));
      var jsx$10 = $m_jl_Long$();
      var array$4 = ["", "", "", "", ""];
      var jsx$9 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$4));
      var array$5 = [red, green, blue, alpha];
      var t$2 = jsx$10.parseLong__T__I__J(jsx$9.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$5)), 16);
      var lo$2 = t$2.lo$2;
      var hi$2 = t$2.hi$2;
      return new $c_s_Some().init___O(new $c_Lio_youi_Color().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo$2, hi$2)))
    }
  };
  var jsx$12 = $m_Lscribe_package$();
  var level = $m_Lscribe_Level$Warn$();
  var value$1 = $m_Lscribe_Level$Warn$().value$1;
  var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(value$2) {
    return (function() {
      var array$6 = ["Unknown conversion for color value from String: ", ""];
      var jsx$11 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$6));
      var array$7 = [value$2];
      return jsx$11.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$7))
    })
  })(value));
  var loggable = $m_Lscribe_Loggable$StringLoggable$();
  var throwable = $m_s_None$();
  var methodName = new $c_s_Some().init___O("unapply");
  var line = new $c_s_Some().init___O(239);
  var column = new $c_s_Some().init___O(18);
  var thread = $m_jl_Thread$().SingleThread$1;
  var this$47 = $m_Lscribe_util_Time$();
  var t$3 = this$47.function$1.apply$mcJ$sp__J();
  var lo$3 = t$3.lo$2;
  var hi$3 = t$3.hi$2;
  jsx$12.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value$1, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/core/shared/src/main/scala/io/youi/Color.scala", "io.youi.Color", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo$3, hi$3)));
  return $m_s_None$()
});
$c_Lio_youi_Color$.prototype.hexify__p1__I__T = (function(value) {
  var this$3 = new $c_sci_StringOps().init___T("%02x");
  var array = [value];
  var jsx$2 = $m_sjsr_RuntimeString$();
  var $$this = this$3.repr$1;
  $m_sc_Seq$();
  $m_sjs_js_WrappedArray$();
  var array$1 = [];
  $uI(array.length);
  var i = 0;
  var len = $uI(array.length);
  while ((i < len)) {
    var index = i;
    var arg1 = array[index];
    var elem = $s_sci_StringLike$class__unwrapArg__p0__sci_StringLike__O__O(this$3, arg1);
    array$1.push(elem);
    i = ((1 + i) | 0)
  };
  $m_s_reflect_ManifestFactory$ObjectManifest$();
  var len$1 = $uI(array$1.length);
  var result = $newArrayObject($d_O.getArrayOf(), [len$1]);
  var len$2 = result.u.length;
  var i$1 = 0;
  var j = 0;
  var x = $uI(array$1.length);
  var x$1 = ((x < len$2) ? x : len$2);
  var that = result.u.length;
  var end = ((x$1 < that) ? x$1 : that);
  while ((i$1 < end)) {
    var jsx$1 = j;
    var index$1 = i$1;
    result.set(jsx$1, array$1[index$1]);
    i$1 = ((1 + i$1) | 0);
    j = ((1 + j) | 0)
  };
  return jsx$2.format__T__AO__T($$this, result)
});
$c_Lio_youi_Color$.prototype.green$extension__J__D = (function($$this) {
  return (this.greenInt$extension__J__I($$this) / 255.0)
});
$c_Lio_youi_Color$.prototype.red$extension__J__D = (function($$this) {
  return (this.redInt$extension__J__I($$this) / 255.0)
});
$c_Lio_youi_Color$.prototype.alphaHex$extension__J__T = (function($$this) {
  return $m_Lio_youi_Color$().hexify__p1__I__T(this.alphaInt$extension__J__I($$this))
});
$c_Lio_youi_Color$.prototype.blueInt$extension__J__I = (function($$this) {
  var lo = ((($$this.lo$2 >>> 8) | 0) | ($$this.hi$2 << 24));
  var lo$1 = (255 & lo);
  return lo$1
});
$c_Lio_youi_Color$.prototype.alpha$extension__J__D = (function($$this) {
  return (this.alphaInt$extension__J__I($$this) / 255.0)
});
$c_Lio_youi_Color$.prototype.blue$extension__J__D = (function($$this) {
  return (this.blueInt$extension__J__I($$this) / 255.0)
});
var $d_Lio_youi_Color$ = new $TypeData().initClass({
  Lio_youi_Color$: 0
}, false, "io.youi.Color$", {
  Lio_youi_Color$: 1,
  O: 1
});
$c_Lio_youi_Color$.prototype.$classData = $d_Lio_youi_Color$;
var $n_Lio_youi_Color$ = (void 0);
function $m_Lio_youi_Color$() {
  if ((!$n_Lio_youi_Color$)) {
    $n_Lio_youi_Color$ = new $c_Lio_youi_Color$().init___()
  };
  return $n_Lio_youi_Color$
}
/** @constructor */
function $c_Lio_youi_Cursor() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_Cursor.prototype = new $h_O();
$c_Lio_youi_Cursor.prototype.constructor = $c_Lio_youi_Cursor;
/** @constructor */
function $h_Lio_youi_Cursor() {
  /*<skip>*/
}
$h_Lio_youi_Cursor.prototype = $c_Lio_youi_Cursor.prototype;
$c_Lio_youi_Cursor.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_Cursor(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_Cursor)))
}
function $as_Lio_youi_Cursor(obj) {
  return (($is_Lio_youi_Cursor(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.Cursor"))
}
function $isArrayOf_Lio_youi_Cursor(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_Cursor)))
}
function $asArrayOf_Lio_youi_Cursor(obj, depth) {
  return (($isArrayOf_Lio_youi_Cursor(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.Cursor;", depth))
}
/** @constructor */
function $c_Lio_youi_ErrorSupport$() {
  $c_O.call(this);
  this.error$1 = null;
  this.defaultHandler$1 = null
}
$c_Lio_youi_ErrorSupport$.prototype = new $h_O();
$c_Lio_youi_ErrorSupport$.prototype.constructor = $c_Lio_youi_ErrorSupport$;
/** @constructor */
function $h_Lio_youi_ErrorSupport$() {
  /*<skip>*/
}
$h_Lio_youi_ErrorSupport$.prototype = $c_Lio_youi_ErrorSupport$.prototype;
$c_Lio_youi_ErrorSupport$.prototype.init___ = (function() {
  $n_Lio_youi_ErrorSupport$ = this;
  this.error$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  var this$3 = this.error$1;
  var f = new $c_Lio_youi_ErrorSupport$$anonfun$1().init___();
  var priority = $m_Lreactify_Priority$().Normal$1;
  this.defaultHandler$1 = $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$3, f, priority);
  return this
});
var $d_Lio_youi_ErrorSupport$ = new $TypeData().initClass({
  Lio_youi_ErrorSupport$: 0
}, false, "io.youi.ErrorSupport$", {
  Lio_youi_ErrorSupport$: 1,
  O: 1
});
$c_Lio_youi_ErrorSupport$.prototype.$classData = $d_Lio_youi_ErrorSupport$;
var $n_Lio_youi_ErrorSupport$ = (void 0);
function $m_Lio_youi_ErrorSupport$() {
  if ((!$n_Lio_youi_ErrorSupport$)) {
    $n_Lio_youi_ErrorSupport$ = new $c_Lio_youi_ErrorSupport$().init___()
  };
  return $n_Lio_youi_ErrorSupport$
}
/** @constructor */
function $c_Lio_youi_ExtendedElement() {
  $c_O.call(this);
  this.element$1 = null
}
$c_Lio_youi_ExtendedElement.prototype = new $h_O();
$c_Lio_youi_ExtendedElement.prototype.constructor = $c_Lio_youi_ExtendedElement;
/** @constructor */
function $h_Lio_youi_ExtendedElement() {
  /*<skip>*/
}
$h_Lio_youi_ExtendedElement.prototype = $c_Lio_youi_ExtendedElement.prototype;
$c_Lio_youi_ExtendedElement.prototype.bySelector__T__sci_Vector = (function(selectors) {
  return $m_Lio_youi_dom$().bySelector__T__s_Option__sci_Vector(selectors, this.element$1)
});
$c_Lio_youi_ExtendedElement.prototype.firstBySelector__T__s_Option = (function(selectors) {
  return $m_Lio_youi_dom$().firstBySelector__T__s_Option__s_Option(selectors, this.element$1)
});
$c_Lio_youi_ExtendedElement.prototype.getById__T__s_Option = (function(id) {
  var array = ["#", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [id];
  return this.firstBySelector__T__s_Option(jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1)))
});
$c_Lio_youi_ExtendedElement.prototype.byId__T__Lorg_scalajs_dom_raw_Element = (function(id) {
  var array = ["#", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [id];
  return this.oneBySelector__T__Lorg_scalajs_dom_raw_Element(jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1)))
});
$c_Lio_youi_ExtendedElement.prototype.init___s_Option = (function(element) {
  this.element$1 = element;
  return this
});
$c_Lio_youi_ExtendedElement.prototype.oneBySelector__T__Lorg_scalajs_dom_raw_Element = (function(selectors) {
  return $m_Lio_youi_dom$().oneBySelector__T__s_Option__Lorg_scalajs_dom_raw_Element(selectors, this.element$1)
});
/** @constructor */
function $c_Lio_youi_History$() {
  $c_O.call(this);
  this.alwaysReload$1 = null;
  this.io$youi$History$$currentURL$1 = null;
  this.url$1 = null;
  this.stateChange$1 = null
}
$c_Lio_youi_History$.prototype = new $h_O();
$c_Lio_youi_History$.prototype.constructor = $c_Lio_youi_History$;
/** @constructor */
function $h_Lio_youi_History$() {
  /*<skip>*/
}
$h_Lio_youi_History$.prototype = $c_Lio_youi_History$.prototype;
$c_Lio_youi_History$.prototype.init___ = (function() {
  $n_Lio_youi_History$ = this;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return false
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.alwaysReload$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    var this$4 = $m_Lio_youi_net_URL$();
    var url = $as_T($m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().location.href);
    return this$4.apply__T__Z__Lio_youi_net_URL(url, true)
  }));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.io$youi$History$$currentURL$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    var v = $m_Lio_youi_History$().io$youi$History$$currentURL$1;
    return $as_Lio_youi_net_URL(v.state__Lreactify_State().value__O())
  }));
  var name$2 = $m_s_None$();
  this.url$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$2, name$2);
  this.stateChange$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().addEventListener("popstate", (function(f) {
    return (function(arg1) {
      return f.apply__O__O(arg1)
    })
  })(new $c_Lio_youi_History$$anonfun$4().init___()));
  return this
});
$c_Lio_youi_History$.prototype.reload__Z__V = (function(force) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.reload(force)
});
$c_Lio_youi_History$.prototype.replace__Lio_youi_net_URL__sjs_js_Any__V = (function(url, state) {
  var this$1 = this.alwaysReload$1;
  if ($uZ(this$1.state__Lreactify_State().value__O())) {
    this.set__Lio_youi_net_URL__V(url)
  } else {
    var this$2 = this.url$1;
    var x$2 = this$2.state__Lreactify_State().value__O();
    if ((!((url === null) ? (x$2 === null) : url.equals__O__Z(x$2)))) {
      var urlString = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
      $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.replaceState(state, urlString, urlString);
      var this$3 = this.io$youi$History$$currentURL$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(url$2) {
        return (function() {
          return url$2
        })
      })(url));
      this$3.set__F0__V(value);
      var this$4 = this.stateChange$1;
      var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(url$2$1, state$2) {
        return (function() {
          return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url$2$1, $m_Lio_youi_StateType$Replace$(), state$2)
        })
      })(url, state));
      this$4.set__F0__V(value$1)
    }
  }
});
$c_Lio_youi_History$.prototype.back__I__V = (function(delta) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.go(((-delta) | 0))
});
$c_Lio_youi_History$.prototype.update__Lio_youi_HistoryStateChange__V = (function(change) {
  var x1 = change.stateType$1;
  var x = $m_Lio_youi_StateType$Push$();
  if ((x === x1)) {
    this.push__Lio_youi_net_URL__sjs_js_Any__V(change.url$1, change.state$1)
  } else {
    var x$3 = $m_Lio_youi_StateType$Replace$();
    if ((x$3 === x1)) {
      this.replace__Lio_youi_net_URL__sjs_js_Any__V(change.url$1, change.state$1)
    } else {
      var x$5 = $m_Lio_youi_StateType$Set$();
      if ((x$5 === x1)) {
        this.set__Lio_youi_net_URL__V(change.url$1)
      } else {
        var x$7 = $m_Lio_youi_StateType$Pop$();
        if ((x$7 === x1)) {
          this.back__I__V(1)
        } else {
          throw new $c_s_MatchError().init___O(x1)
        }
      }
    }
  }
});
$c_Lio_youi_History$.prototype.push__Lio_youi_net_URL__sjs_js_Any__V = (function(url, state) {
  var this$1 = this.alwaysReload$1;
  if ($uZ(this$1.state__Lreactify_State().value__O())) {
    this.set__Lio_youi_net_URL__V(url)
  } else {
    var this$2 = this.url$1;
    var x$2 = this$2.state__Lreactify_State().value__O();
    if ((!((url === null) ? (x$2 === null) : url.equals__O__Z(x$2)))) {
      var urlString = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
      $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.pushState(state, urlString, urlString);
      var this$3 = this.io$youi$History$$currentURL$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(url$1) {
        return (function() {
          return url$1
        })
      })(url));
      this$3.set__F0__V(value);
      var this$4 = this.stateChange$1;
      var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(url$1$1, state$1) {
        return (function() {
          return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url$1$1, $m_Lio_youi_StateType$Push$(), state$1)
        })
      })(url, state));
      this$4.set__F0__V(value$1)
    }
  }
});
$c_Lio_youi_History$.prototype.set__Lio_youi_net_URL__V = (function(url) {
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().location.href = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
  var this$1 = this.stateChange$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(url$3) {
    return (function() {
      return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url$3, $m_Lio_youi_StateType$Set$(), null)
    })
  })(url));
  this$1.set__F0__V(value)
});
var $d_Lio_youi_History$ = new $TypeData().initClass({
  Lio_youi_History$: 0
}, false, "io.youi.History$", {
  Lio_youi_History$: 1,
  O: 1
});
$c_Lio_youi_History$.prototype.$classData = $d_Lio_youi_History$;
var $n_Lio_youi_History$ = (void 0);
function $m_Lio_youi_History$() {
  if ((!$n_Lio_youi_History$)) {
    $n_Lio_youi_History$ = new $c_Lio_youi_History$().init___()
  };
  return $n_Lio_youi_History$
}
/** @constructor */
function $c_Lio_youi_LazyUpdate() {
  $c_O.call(this);
  this.f$1 = null;
  this.maxFrequency$1 = null;
  this.lastUpdate$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.dirty$1 = null
}
$c_Lio_youi_LazyUpdate.prototype = new $h_O();
$c_Lio_youi_LazyUpdate.prototype.constructor = $c_Lio_youi_LazyUpdate;
/** @constructor */
function $h_Lio_youi_LazyUpdate() {
  /*<skip>*/
}
$h_Lio_youi_LazyUpdate.prototype = $c_Lio_youi_LazyUpdate.prototype;
$c_Lio_youi_LazyUpdate.prototype.isReady__Z = (function() {
  var t = $m_jl_System$().currentTimeMillis__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  var b = this.lastUpdate$1;
  var bhi = b.hi$2;
  var lo$1 = ((lo - b.lo$2) | 0);
  var hi$1 = ((((-2147483648) ^ lo$1) > ((-2147483648) ^ lo)) ? (((-1) + ((hi - bhi) | 0)) | 0) : ((hi - bhi) | 0));
  var this$2 = this.maxFrequency$1;
  var b$1 = this$2.unit$2.toMillis__J__J(this$2.length$2);
  var bhi$1 = b$1.hi$2;
  return ((hi$1 === bhi$1) ? (((-2147483648) ^ lo$1) >= ((-2147483648) ^ b$1.lo$2)) : (hi$1 > bhi$1))
});
$c_Lio_youi_LazyUpdate.prototype.update__Z__V = (function(force) {
  if (((this.isReady__Z() && this.dirty$1.compareAndSet__Z__Z__Z(true, false)) || force)) {
    try {
      this.f$1.apply$mcV$sp__V()
    } finally {
      this.lastUpdate$1 = $m_jl_System$().currentTimeMillis__J()
    }
  }
});
$c_Lio_youi_LazyUpdate.prototype.init___F0__s_concurrent_duration_FiniteDuration = (function(f, maxFrequency) {
  this.f$1 = f;
  this.maxFrequency$1 = maxFrequency;
  this.lastUpdate$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.dirty$1 = new $c_ju_concurrent_atomic_AtomicBoolean().init___Z(false);
  return this
});
var $d_Lio_youi_LazyUpdate = new $TypeData().initClass({
  Lio_youi_LazyUpdate: 0
}, false, "io.youi.LazyUpdate", {
  Lio_youi_LazyUpdate: 1,
  O: 1
});
$c_Lio_youi_LazyUpdate.prototype.$classData = $d_Lio_youi_LazyUpdate;
/** @constructor */
function $c_Lio_youi_LazyUpdate$() {
  $c_O.call(this)
}
$c_Lio_youi_LazyUpdate$.prototype = new $h_O();
$c_Lio_youi_LazyUpdate$.prototype.constructor = $c_Lio_youi_LazyUpdate$;
/** @constructor */
function $h_Lio_youi_LazyUpdate$() {
  /*<skip>*/
}
$h_Lio_youi_LazyUpdate$.prototype = $c_Lio_youi_LazyUpdate$.prototype;
$c_Lio_youi_LazyUpdate$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_LazyUpdate$.prototype.apply$default$2__s_concurrent_duration_FiniteDuration = (function() {
  var this$2 = new $c_s_concurrent_duration_package$DurationInt().init___I(0);
  var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
  return $m_s_concurrent_duration_package$DurationInt$().durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration(this$2.scala$concurrent$duration$DurationInt$$n$1, unit)
});
var $d_Lio_youi_LazyUpdate$ = new $TypeData().initClass({
  Lio_youi_LazyUpdate$: 0
}, false, "io.youi.LazyUpdate$", {
  Lio_youi_LazyUpdate$: 1,
  O: 1
});
$c_Lio_youi_LazyUpdate$.prototype.$classData = $d_Lio_youi_LazyUpdate$;
var $n_Lio_youi_LazyUpdate$ = (void 0);
function $m_Lio_youi_LazyUpdate$() {
  if ((!$n_Lio_youi_LazyUpdate$)) {
    $n_Lio_youi_LazyUpdate$ = new $c_Lio_youi_LazyUpdate$().init___()
  };
  return $n_Lio_youi_LazyUpdate$
}
/** @constructor */
function $c_Lio_youi_Unique$() {
  $c_O.call(this);
  this.LettersLower$1 = null;
  this.LettersUpper$1 = null;
  this.Numbers$1 = null;
  this.Readable$1 = null;
  this.LettersAndNumbers$1 = null;
  this.AllLettersAndNumbers$1 = null
}
$c_Lio_youi_Unique$.prototype = new $h_O();
$c_Lio_youi_Unique$.prototype.constructor = $c_Lio_youi_Unique$;
/** @constructor */
function $h_Lio_youi_Unique$() {
  /*<skip>*/
}
$h_Lio_youi_Unique$.prototype = $c_Lio_youi_Unique$.prototype;
$c_Lio_youi_Unique$.prototype.init___ = (function() {
  $n_Lio_youi_Unique$ = this;
  this.LettersLower$1 = "abcdefghijklmnopqrstuvwxyz";
  this.LettersUpper$1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  this.Numbers$1 = "0123456789";
  this.Readable$1 = "ABCDEFGHJKLMNPQRSTWXYZ23456789";
  var array = ["", "", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [this.LettersLower$1, this.Numbers$1];
  this.LettersAndNumbers$1 = jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1));
  var array$2 = ["", "", "", ""];
  var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$2));
  var array$3 = [this.LettersLower$1, this.LettersUpper$1, this.Numbers$1];
  this.AllLettersAndNumbers$1 = jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$3));
  return this
});
$c_Lio_youi_Unique$.prototype.apply__I__T__T = (function(length, characters) {
  var charMax = $uI(characters.length);
  var isEmpty$4 = (length <= 0);
  if (isEmpty$4) {
    var numRangeElements$4 = 0
  } else {
    var hi = (length >> 31);
    var numRangeElements$4 = (((hi === 0) ? (((-2147483648) ^ length) > (-1)) : (hi > 0)) ? (-1) : length)
  };
  var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + length) | 0));
  $m_sci_IndexedSeq$();
  $m_sc_IndexedSeq$();
  $m_sci_IndexedSeq$();
  $m_sci_Vector$();
  var b = new $c_sci_VectorBuilder().init___();
  if ((numRangeElements$4 < 0)) {
    $m_sci_Range$().scala$collection$immutable$Range$$fail__I__I__I__Z__sr_Nothing$(0, length, 1, false)
  };
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var arg1 = i;
      $m_Lio_youi_Unique$();
      var this$9 = $m_ju_concurrent_ThreadLocalRandom$();
      var index = this$9.$$undcurrent$1.nextInt__I__I(charMax);
      var c = (65535 & $uI(characters.charCodeAt(index)));
      var elem = new $c_jl_Character().init___C(c);
      b.$$plus$eq__O__sci_VectorBuilder(elem);
      if ((i === lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  var this$13 = b.result__sci_Vector();
  return $s_sc_TraversableOnce$class__mkString__sc_TraversableOnce__T__T__T__T(this$13, "", "", "")
});
var $d_Lio_youi_Unique$ = new $TypeData().initClass({
  Lio_youi_Unique$: 0
}, false, "io.youi.Unique$", {
  Lio_youi_Unique$: 1,
  O: 1
});
$c_Lio_youi_Unique$.prototype.$classData = $d_Lio_youi_Unique$;
var $n_Lio_youi_Unique$ = (void 0);
function $m_Lio_youi_Unique$() {
  if ((!$n_Lio_youi_Unique$)) {
    $n_Lio_youi_Unique$ = new $c_Lio_youi_Unique$().init___()
  };
  return $n_Lio_youi_Unique$
}
/** @constructor */
function $c_Lio_youi_ajax_AjaxRequest() {
  $c_O.call(this);
  this.data$1 = null;
  this.req$1 = null;
  this.promise$1 = null;
  this.loaded$1 = null;
  this.total$1 = null;
  this.percentage$1 = null;
  this.cancelled$1 = null
}
$c_Lio_youi_ajax_AjaxRequest.prototype = new $h_O();
$c_Lio_youi_ajax_AjaxRequest.prototype.constructor = $c_Lio_youi_ajax_AjaxRequest;
/** @constructor */
function $h_Lio_youi_ajax_AjaxRequest() {
  /*<skip>*/
}
$h_Lio_youi_ajax_AjaxRequest.prototype = $c_Lio_youi_ajax_AjaxRequest.prototype;
$c_Lio_youi_ajax_AjaxRequest.prototype.send__s_concurrent_Future = (function() {
  var x1 = this.data$1;
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var formData = x2.x$2;
    this.req$1.send(formData)
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      this.req$1.send()
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  };
  var this$1 = this.promise$1;
  return this$1
});
$c_Lio_youi_ajax_AjaxRequest.prototype.init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T = (function(url, data, timeout, headers, withCredentials, responseType) {
  this.data$1 = data;
  this.req$1 = new $g.XMLHttpRequest();
  this.promise$1 = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 0.0
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.loaded$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 0.0
  }));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.total$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 0
  }));
  var mode$2 = $m_Lreactify_Var$Mode$Normal$();
  var name$2 = $m_s_None$();
  this.percentage$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$2, name$2);
  var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return false
  }));
  var mode$3 = $m_Lreactify_Var$Mode$Normal$();
  var name$3 = $m_s_None$();
  this.cancelled$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$3, mode$3, name$3);
  this.req$1.onreadystatechange = (function(arg$outer) {
    return (function(x$1$2) {
      if (($uI(arg$outer.req$1.readyState) === 4)) {
        if (((($uI(arg$outer.req$1.status) >= 200) && ($uI(arg$outer.req$1.status) < 300)) || ($uI(arg$outer.req$1.status) === 304))) {
          var this$14 = arg$outer.promise$1;
          var value$4 = arg$outer.req$1;
          return $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(this$14, value$4)
        } else {
          var this$15 = arg$outer.promise$1;
          var cause = new $c_Lorg_scalajs_dom_ext_AjaxException().init___Lorg_scalajs_dom_raw_XMLHttpRequest(arg$outer.req$1);
          return $s_s_concurrent_Promise$class__failure__s_concurrent_Promise__jl_Throwable__s_concurrent_Promise(this$15, cause)
        }
      } else {
        return (void 0)
      }
    })
  })(this);
  var qual$1 = this.req$1.upload;
  var x$3 = (function(f) {
    return (function(arg1) {
      return f.apply__O__O(arg1)
    })
  })(new $c_Lio_youi_ajax_AjaxRequest$$anonfun$6().init___Lio_youi_ajax_AjaxRequest(this));
  qual$1.addEventListener("progress", x$3);
  this.req$1.open("POST", url.encoded__Lio_youi_net_URL$URLParts().asString__T());
  this.req$1.responseType = responseType;
  this.req$1.timeout = timeout;
  this.req$1.withCredentials = withCredentials;
  headers.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$1) {
    return (function(x$2) {
      var x = $as_T2(x$2);
      arg$outer$1.req$1.setRequestHeader($as_T(x.$$und1__O()), $as_T(x.$$und2__O()))
    })
  })(this)));
  return this
});
var $d_Lio_youi_ajax_AjaxRequest = new $TypeData().initClass({
  Lio_youi_ajax_AjaxRequest: 0
}, false, "io.youi.ajax.AjaxRequest", {
  Lio_youi_ajax_AjaxRequest: 1,
  O: 1
});
$c_Lio_youi_ajax_AjaxRequest.prototype.$classData = $d_Lio_youi_ajax_AjaxRequest;
/** @constructor */
function $c_Lio_youi_app_ApplicationConnectivity() {
  $c_O.call(this);
  this.application$1 = null;
  this.path$1 = null;
  this.autoConnect$1 = false;
  this.activeConnections$1 = null;
  this.connections$1 = null;
  this.communicationManagers$1 = null
}
$c_Lio_youi_app_ApplicationConnectivity.prototype = new $h_O();
$c_Lio_youi_app_ApplicationConnectivity.prototype.constructor = $c_Lio_youi_app_ApplicationConnectivity;
/** @constructor */
function $h_Lio_youi_app_ApplicationConnectivity() {
  /*<skip>*/
}
$h_Lio_youi_app_ApplicationConnectivity.prototype = $c_Lio_youi_app_ApplicationConnectivity.prototype;
$c_Lio_youi_app_ApplicationConnectivity.prototype.registerCommunicationManager__Lio_youi_app_CommunicationManager__V = (function(communicationManager) {
  var this$2 = $as_Lreactify_Var(this.communicationManagers$1);
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer, communicationManager$1) {
    return (function() {
      var this$1 = arg$outer.communicationManagers$1;
      return $as_sci_Set($as_sc_SetLike(this$1.state__Lreactify_State().value__O()).$$plus__O__sc_Set(communicationManager$1))
    })
  })(this, communicationManager));
  this$2.set__F0__V(value)
});
$c_Lio_youi_app_ApplicationConnectivity.prototype.init___Lio_youi_app_YouIApplication__T__Z = (function(application, path, autoConnect) {
  this.application$1 = application;
  this.path$1 = path;
  this.autoConnect$1 = autoConnect;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_sci_Set$EmptySet$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.activeConnections$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var v = arg$outer.activeConnections$1;
      return $as_sci_Set(v.state__Lreactify_State().value__O())
    })
  })(this));
  var name$1 = $m_s_None$();
  this.connections$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_sci_Set$EmptySet$()
  }));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$2 = $m_s_None$();
  this.communicationManagers$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$1, name$2);
  if ((application === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  var this$12 = application.connectivityEntries$1;
  var entries = $as_sci_Set(this$12.state__Lreactify_State().value__O());
  var this$13 = application.connectivityEntries$1;
  var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer$1, entries$1) {
    return (function() {
      return $as_sci_Set(entries$1.$$plus__O__sc_Set(arg$outer$1))
    })
  })(this, entries));
  this$13.set__F0__V(value$3);
  return this
});
function $is_Lio_youi_app_ApplicationConnectivity(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_ApplicationConnectivity)))
}
function $as_Lio_youi_app_ApplicationConnectivity(obj) {
  return (($is_Lio_youi_app_ApplicationConnectivity(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.ApplicationConnectivity"))
}
function $isArrayOf_Lio_youi_app_ApplicationConnectivity(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_ApplicationConnectivity)))
}
function $asArrayOf_Lio_youi_app_ApplicationConnectivity(obj, depth) {
  return (($isArrayOf_Lio_youi_app_ApplicationConnectivity(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.ApplicationConnectivity;", depth))
}
var $d_Lio_youi_app_ApplicationConnectivity = new $TypeData().initClass({
  Lio_youi_app_ApplicationConnectivity: 0
}, false, "io.youi.app.ApplicationConnectivity", {
  Lio_youi_app_ApplicationConnectivity: 1,
  O: 1
});
$c_Lio_youi_app_ApplicationConnectivity.prototype.$classData = $d_Lio_youi_app_ApplicationConnectivity;
/** @constructor */
function $c_Lio_youi_app_ClientApplication$() {
  $c_O.call(this);
  this.logWriter$1 = null;
  this.io$youi$app$ClientApplication$$instance$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_app_ClientApplication$.prototype = new $h_O();
$c_Lio_youi_app_ClientApplication$.prototype.constructor = $c_Lio_youi_app_ClientApplication$;
/** @constructor */
function $h_Lio_youi_app_ClientApplication$() {
  /*<skip>*/
}
$h_Lio_youi_app_ClientApplication$.prototype = $c_Lio_youi_app_ClientApplication$.prototype;
$c_Lio_youi_app_ClientApplication$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_app_ClientApplication$.prototype.logWriter$lzycompute__p1__Lscribe_writer_Writer = (function() {
  if ((!this.bitmap$0$1)) {
    this.logWriter$1 = new $c_Lio_youi_app_ClientApplication$$anon$15().init___();
    this.bitmap$0$1 = true
  };
  return this.logWriter$1
});
$c_Lio_youi_app_ClientApplication$.prototype.sendLog__Lio_youi_JavaScriptLog__s_concurrent_Future = (function(log) {
  var formData = new $g.FormData();
  var customConfig = $m_Lio_circe_generic_extras_Configuration$().default$1.withDefaults__Lio_circe_generic_extras_Configuration();
  $m_Lio_circe_Encoder$();
  var inst$macro$186 = new $c_Lio_youi_app_ClientApplication$anon$importedEncoder$macro$185$1().init___Lio_circe_generic_extras_Configuration(customConfig).inst$macro$175__Lio_circe_generic_extras_encoding_ConfiguredObjectEncoder();
  var t = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(inst$macro$186$1) {
    return (function() {
      return inst$macro$186$1
    })
  })(inst$macro$186));
  var lv = new $c_Lshapeless_Lazy$$anon$1().init___F0(t);
  var exported = $as_Lio_circe_ObjectEncoder(lv.value__O());
  var this$5 = $s_Lio_circe_ObjectEncoder$class__apply__Lio_circe_ObjectEncoder__O__Lio_circe_Json(exported, log);
  var p = $m_Lio_circe_Printer$().noSpaces$1;
  var jsonString = p.pretty__Lio_circe_Json__T(this$5);
  formData.append("message", jsonString);
  var this$8 = $m_Lio_youi_History$().url$1;
  var request = new $c_Lio_youi_ajax_AjaxRequest().init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T($as_Lio_youi_net_URL(this$8.state__Lreactify_State().value__O()).replacePathAndParams__T__Lio_youi_net_URL(this.io$youi$app$ClientApplication$$instance$1.logPath$1), new $c_s_Some().init___O(formData), 0, $m_sci_Map$EmptyMap$(), true, "");
  return request.send__s_concurrent_Future()
});
$c_Lio_youi_app_ClientApplication$.prototype.logWriter__Lscribe_writer_Writer = (function() {
  return ((!this.bitmap$0$1) ? this.logWriter$lzycompute__p1__Lscribe_writer_Writer() : this.logWriter$1)
});
$c_Lio_youi_app_ClientApplication$.prototype.sendError__jl_Throwable__s_concurrent_Future = (function(throwable) {
  var this$1 = $m_Lio_youi_app_sourceMap_ErrorTrace$().toError__jl_Throwable__s_concurrent_Future(throwable);
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(error$2) {
    var error = $as_Lio_youi_JavaScriptError(error$2);
    return $m_Lio_youi_app_ClientApplication$().sendError__Lio_youi_JavaScriptError__s_concurrent_Future(error)
  }));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
});
$c_Lio_youi_app_ClientApplication$.prototype.sendError__Lorg_scalajs_dom_raw_ErrorEvent__s_concurrent_Future = (function(event) {
  var this$1 = $m_Lio_youi_app_sourceMap_ErrorTrace$().toError__Lorg_scalajs_dom_raw_ErrorEvent__s_concurrent_Future(event);
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(error$2) {
    var error = $as_Lio_youi_JavaScriptError(error$2);
    return $m_Lio_youi_app_ClientApplication$().sendError__Lio_youi_JavaScriptError__s_concurrent_Future(error)
  }));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, f, executor)
});
$c_Lio_youi_app_ClientApplication$.prototype.sendError__Lio_youi_JavaScriptError__s_concurrent_Future = (function(error) {
  var formData = new $g.FormData();
  var customConfig = $m_Lio_circe_generic_extras_Configuration$().default$1.withDefaults__Lio_circe_generic_extras_Configuration();
  $m_Lio_circe_Encoder$();
  var inst$macro$174 = new $c_Lio_youi_app_ClientApplication$anon$importedEncoder$macro$173$1().init___Lio_circe_generic_extras_Configuration(customConfig).inst$macro$1__Lio_circe_generic_extras_encoding_ConfiguredObjectEncoder();
  var t = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(inst$macro$174$1) {
    return (function() {
      return inst$macro$174$1
    })
  })(inst$macro$174));
  var lv = new $c_Lshapeless_Lazy$$anon$1().init___F0(t);
  var exported = $as_Lio_circe_ObjectEncoder(lv.value__O());
  var this$5 = $s_Lio_circe_ObjectEncoder$class__apply__Lio_circe_ObjectEncoder__O__Lio_circe_Json(exported, error);
  var p = $m_Lio_circe_Printer$().noSpaces$1;
  var jsonString = p.pretty__Lio_circe_Json__T(this$5);
  formData.append("error", jsonString);
  var this$8 = $m_Lio_youi_History$().url$1;
  var request = new $c_Lio_youi_ajax_AjaxRequest().init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T($as_Lio_youi_net_URL(this$8.state__Lreactify_State().value__O()).replacePathAndParams__T__Lio_youi_net_URL(this.io$youi$app$ClientApplication$$instance$1.logPath$1), new $c_s_Some().init___O(formData), 0, $m_sci_Map$EmptyMap$(), true, "");
  return request.send__s_concurrent_Future()
});
var $d_Lio_youi_app_ClientApplication$ = new $TypeData().initClass({
  Lio_youi_app_ClientApplication$: 0
}, false, "io.youi.app.ClientApplication$", {
  Lio_youi_app_ClientApplication$: 1,
  O: 1
});
$c_Lio_youi_app_ClientApplication$.prototype.$classData = $d_Lio_youi_app_ClientApplication$;
var $n_Lio_youi_app_ClientApplication$ = (void 0);
function $m_Lio_youi_app_ClientApplication$() {
  if ((!$n_Lio_youi_app_ClientApplication$)) {
    $n_Lio_youi_app_ClientApplication$ = new $c_Lio_youi_app_ClientApplication$().init___()
  };
  return $n_Lio_youi_app_ClientApplication$
}
/** @constructor */
function $c_Lio_youi_app_ClientConnectivity() {
  $c_O.call(this);
  this.connectivity$1 = null;
  this.io$youi$app$ClientConnectivity$$application$f = null;
  this.connection$1 = null;
  this.webSocket$1 = null
}
$c_Lio_youi_app_ClientConnectivity.prototype = new $h_O();
$c_Lio_youi_app_ClientConnectivity.prototype.constructor = $c_Lio_youi_app_ClientConnectivity;
/** @constructor */
function $h_Lio_youi_app_ClientConnectivity() {
  /*<skip>*/
}
$h_Lio_youi_app_ClientConnectivity.prototype = $c_Lio_youi_app_ClientConnectivity.prototype;
$c_Lio_youi_app_ClientConnectivity.prototype.init___Lio_youi_app_ApplicationConnectivity__Lio_youi_app_ClientApplication = (function(connectivity, application) {
  this.connectivity$1 = connectivity;
  this.io$youi$app$ClientConnectivity$$application$f = application;
  this.connection$1 = new $c_Lio_youi_http_Connection().init___();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_s_None$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.webSocket$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var this$5 = this.connection$1.receive$1.text$1;
  var f = new $c_Lio_youi_app_ClientConnectivity$$anonfun$2().init___Lio_youi_app_ClientConnectivity(this);
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$5, f, priority);
  if (connectivity.autoConnect$1) {
    this.connect__V()
  };
  var this$8 = this.connection$1.connected$1;
  var f$1 = new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function(arg$outer) {
    return (function(x0$2$2, x1$1$2) {
      var x0$2 = $uZ(x0$2$2);
      var x1$1 = $uZ(x1$1$2);
      if ((x0$2 && (!x1$1))) {
        arg$outer.io$youi$app$ClientConnectivity$$attemptReload__I__V(0)
      }
    })
  })(this));
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__changes__Lreactify_Reactive__F2__D__Lreactify_reaction_Reaction(this$8, f$1, priority$1);
  return this
});
$c_Lio_youi_app_ClientConnectivity.prototype.connect__V = (function() {
  var this$4 = this.connectivity$1.activeConnections$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var array = [arg$outer.connection$1];
      if (($uI(array.length) === 0)) {
        var jsx$1 = $m_sci_Set$EmptySet$()
      } else {
        var b = new $c_scm_SetBuilder().init___sc_Set($m_sci_Set$EmptySet$());
        var i = 0;
        var len = $uI(array.length);
        while ((i < len)) {
          var index = i;
          var arg1 = array[index];
          b.$$plus$eq__O__scm_SetBuilder(arg1);
          i = ((1 + i) | 0)
        };
        var jsx$1 = b.elems$1
      };
      return $as_sci_Set(jsx$1)
    })
  })(this));
  this$4.set__F0__V(value);
  this.disconnect__V();
  var protocol = (($as_T($m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.protocol) === "https:") ? "wss" : "ws");
  var this$9 = $m_Lio_youi_net_URL$();
  var array$1 = ["", "://", "", ""];
  var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1));
  var array$2 = [protocol, $as_T($m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.host), this.connectivity$1.path$1];
  var url = jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$2));
  var url$1 = this$9.apply__T__Z__Lio_youi_net_URL(url, true);
  var this$10 = this.webSocket$1;
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer$1, url$1$1) {
    return (function() {
      return new $c_s_Some().init___O($m_Lio_youi_http_WebSocketUtil$().connect__Lio_youi_net_URL__Lio_youi_http_Connection__Lorg_scalajs_dom_raw_WebSocket(url$1$1, arg$outer$1.connection$1))
    })
  })(this, url$1));
  this$10.set__F0__V(value$1)
});
$c_Lio_youi_app_ClientConnectivity.prototype.io$youi$app$ClientConnectivity$$attemptReload__I__V = (function(attempt) {
  var jsx$1 = $m_Lio_youi_stream_StreamURL$();
  var this$1 = $m_Lio_youi_History$().url$1;
  jsx$1.stream__Lio_youi_net_URL__s_Option__I__sci_Map__Z__T__s_concurrent_Future($as_Lio_youi_net_URL(this$1.state__Lreactify_State().value__O()), $m_s_None$(), 0, $m_sci_Map$EmptyMap$(), true, "").onComplete__F1__s_concurrent_ExecutionContext__V(new $c_Lio_youi_app_ClientConnectivity$$anonfun$io$youi$app$ClientConnectivity$$attemptReload$1().init___Lio_youi_app_ClientConnectivity__I(this, attempt), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor())
});
$c_Lio_youi_app_ClientConnectivity.prototype.disconnect__V = (function() {
  var this$1 = this.webSocket$1;
  var this$2 = $as_s_Option(this$1.state__Lreactify_State().value__O());
  if ((!this$2.isEmpty__Z())) {
    var v1 = this$2.get__O();
    if (($uI(v1.readyState) === $uI($m_Lorg_scalajs_dom_package$().WebSocket__Lorg_scalajs_dom_raw_WebSocket$().OPEN))) {
      v1.close()
    };
    var this$3 = this.webSocket$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return $m_s_None$()
    }));
    this$3.set__F0__V(value)
  }
});
function $is_Lio_youi_app_ClientConnectivity(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_ClientConnectivity)))
}
function $as_Lio_youi_app_ClientConnectivity(obj) {
  return (($is_Lio_youi_app_ClientConnectivity(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.ClientConnectivity"))
}
function $isArrayOf_Lio_youi_app_ClientConnectivity(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_ClientConnectivity)))
}
function $asArrayOf_Lio_youi_app_ClientConnectivity(obj, depth) {
  return (($isArrayOf_Lio_youi_app_ClientConnectivity(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.ClientConnectivity;", depth))
}
var $d_Lio_youi_app_ClientConnectivity = new $TypeData().initClass({
  Lio_youi_app_ClientConnectivity: 0
}, false, "io.youi.app.ClientConnectivity", {
  Lio_youi_app_ClientConnectivity: 1,
  O: 1
});
$c_Lio_youi_app_ClientConnectivity.prototype.$classData = $d_Lio_youi_app_ClientConnectivity;
/** @constructor */
function $c_Lio_youi_app_CommunicationManager() {
  $c_O.call(this);
  this.io$youi$app$CommunicationManager$$connectivity$f = null;
  this.io$youi$app$CommunicationManager$$create$f = null;
  this.id$1 = 0;
  this.instances$1 = null
}
$c_Lio_youi_app_CommunicationManager.prototype = new $h_O();
$c_Lio_youi_app_CommunicationManager.prototype.constructor = $c_Lio_youi_app_CommunicationManager;
/** @constructor */
function $h_Lio_youi_app_CommunicationManager() {
  /*<skip>*/
}
$h_Lio_youi_app_CommunicationManager.prototype = $c_Lio_youi_app_CommunicationManager.prototype;
$c_Lio_youi_app_CommunicationManager.prototype.byConnection__Lio_youi_http_Connection__s_Option = (function(connection) {
  var v = this.instances$1;
  return $as_sc_IterableLike(v.state__Lreactify_State().value__O()).find__F1__s_Option(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(connection$1) {
    return (function(x$1$2) {
      var x$1 = $as_Lio_youi_communication_Communication(x$1$2);
      return (x$1.connection__Lio_youi_http_Connection() === connection$1)
    })
  })(connection)))
});
$c_Lio_youi_app_CommunicationManager.prototype.init___Lio_youi_app_ApplicationConnectivity__F1 = (function(connectivity, create) {
  this.io$youi$app$CommunicationManager$$connectivity$f = connectivity;
  this.io$youi$app$CommunicationManager$$create$f = create;
  var this$1 = $m_Lio_youi_app_CommunicationManager$().io$youi$app$CommunicationManager$$increment$1;
  var old = this$1.java$util$concurrent$atomic$AtomicInteger$$value$f;
  this$1.java$util$concurrent$atomic$AtomicInteger$$value$f = ((1 + old) | 0);
  this.id$1 = old;
  var value = new $c_Lio_youi_app_CommunicationManager$$anonfun$1().init___Lio_youi_app_CommunicationManager(this);
  var name = $m_s_None$();
  this.instances$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name);
  connectivity.registerCommunicationManager__Lio_youi_app_CommunicationManager__V(this);
  return this
});
$c_Lio_youi_app_CommunicationManager.prototype.apply__Lio_youi_http_Connection__Lio_youi_communication_Communication = (function(connection) {
  var this$1 = this.byConnection__Lio_youi_http_Connection__s_Option(connection);
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("No CommunicationManager found for connection!"))
  };
  return $as_Lio_youi_communication_Communication(this$1.get__O())
});
var $d_Lio_youi_app_CommunicationManager = new $TypeData().initClass({
  Lio_youi_app_CommunicationManager: 0
}, false, "io.youi.app.CommunicationManager", {
  Lio_youi_app_CommunicationManager: 1,
  O: 1
});
$c_Lio_youi_app_CommunicationManager.prototype.$classData = $d_Lio_youi_app_CommunicationManager;
/** @constructor */
function $c_Lio_youi_app_CommunicationManager$() {
  $c_O.call(this);
  this.io$youi$app$CommunicationManager$$increment$1 = null
}
$c_Lio_youi_app_CommunicationManager$.prototype = new $h_O();
$c_Lio_youi_app_CommunicationManager$.prototype.constructor = $c_Lio_youi_app_CommunicationManager$;
/** @constructor */
function $h_Lio_youi_app_CommunicationManager$() {
  /*<skip>*/
}
$h_Lio_youi_app_CommunicationManager$.prototype = $c_Lio_youi_app_CommunicationManager$.prototype;
$c_Lio_youi_app_CommunicationManager$.prototype.init___ = (function() {
  $n_Lio_youi_app_CommunicationManager$ = this;
  this.io$youi$app$CommunicationManager$$increment$1 = new $c_ju_concurrent_atomic_AtomicInteger().init___I(0);
  return this
});
var $d_Lio_youi_app_CommunicationManager$ = new $TypeData().initClass({
  Lio_youi_app_CommunicationManager$: 0
}, false, "io.youi.app.CommunicationManager$", {
  Lio_youi_app_CommunicationManager$: 1,
  O: 1
});
$c_Lio_youi_app_CommunicationManager$.prototype.$classData = $d_Lio_youi_app_CommunicationManager$;
var $n_Lio_youi_app_CommunicationManager$ = (void 0);
function $m_Lio_youi_app_CommunicationManager$() {
  if ((!$n_Lio_youi_app_CommunicationManager$)) {
    $n_Lio_youi_app_CommunicationManager$ = new $c_Lio_youi_app_CommunicationManager$().init___()
  };
  return $n_Lio_youi_app_CommunicationManager$
}
/** @constructor */
function $c_Lio_youi_app_YouIApplication$() {
  $c_O.call(this);
  this.io$youi$app$YouIApplication$$instance$1 = null
}
$c_Lio_youi_app_YouIApplication$.prototype = new $h_O();
$c_Lio_youi_app_YouIApplication$.prototype.constructor = $c_Lio_youi_app_YouIApplication$;
/** @constructor */
function $h_Lio_youi_app_YouIApplication$() {
  /*<skip>*/
}
$h_Lio_youi_app_YouIApplication$.prototype = $c_Lio_youi_app_YouIApplication$.prototype;
$c_Lio_youi_app_YouIApplication$.prototype.init___ = (function() {
  $n_Lio_youi_app_YouIApplication$ = this;
  this.io$youi$app$YouIApplication$$instance$1 = $m_s_None$();
  return this
});
$c_Lio_youi_app_YouIApplication$.prototype.apply__Lio_youi_app_YouIApplication = (function() {
  var this$1 = this.io$youi$app$YouIApplication$$instance$1;
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("No YouIApplication is initialized!"))
  };
  return $as_Lio_youi_app_YouIApplication(this$1.get__O())
});
var $d_Lio_youi_app_YouIApplication$ = new $TypeData().initClass({
  Lio_youi_app_YouIApplication$: 0
}, false, "io.youi.app.YouIApplication$", {
  Lio_youi_app_YouIApplication$: 1,
  O: 1
});
$c_Lio_youi_app_YouIApplication$.prototype.$classData = $d_Lio_youi_app_YouIApplication$;
var $n_Lio_youi_app_YouIApplication$ = (void 0);
function $m_Lio_youi_app_YouIApplication$() {
  if ((!$n_Lio_youi_app_YouIApplication$)) {
    $n_Lio_youi_app_YouIApplication$ = new $c_Lio_youi_app_YouIApplication$().init___()
  };
  return $n_Lio_youi_app_YouIApplication$
}
/** @constructor */
function $c_Lio_youi_app_screen_ScreenManager$() {
  $c_O.call(this);
  this.io$youi$app$screen$ScreenManager$$instance$1 = null
}
$c_Lio_youi_app_screen_ScreenManager$.prototype = new $h_O();
$c_Lio_youi_app_screen_ScreenManager$.prototype.constructor = $c_Lio_youi_app_screen_ScreenManager$;
/** @constructor */
function $h_Lio_youi_app_screen_ScreenManager$() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_ScreenManager$.prototype = $c_Lio_youi_app_screen_ScreenManager$.prototype;
$c_Lio_youi_app_screen_ScreenManager$.prototype.init___ = (function() {
  $n_Lio_youi_app_screen_ScreenManager$ = this;
  this.io$youi$app$screen$ScreenManager$$instance$1 = $m_s_None$();
  return this
});
$c_Lio_youi_app_screen_ScreenManager$.prototype.apply__Lio_youi_app_screen_ScreenManager = (function() {
  var this$1 = this.io$youi$app$screen$ScreenManager$$instance$1;
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("No ScreenManager is initialized!"))
  };
  return $as_Lio_youi_app_screen_ScreenManager(this$1.get__O())
});
var $d_Lio_youi_app_screen_ScreenManager$ = new $TypeData().initClass({
  Lio_youi_app_screen_ScreenManager$: 0
}, false, "io.youi.app.screen.ScreenManager$", {
  Lio_youi_app_screen_ScreenManager$: 1,
  O: 1
});
$c_Lio_youi_app_screen_ScreenManager$.prototype.$classData = $d_Lio_youi_app_screen_ScreenManager$;
var $n_Lio_youi_app_screen_ScreenManager$ = (void 0);
function $m_Lio_youi_app_screen_ScreenManager$() {
  if ((!$n_Lio_youi_app_screen_ScreenManager$)) {
    $n_Lio_youi_app_screen_ScreenManager$ = new $c_Lio_youi_app_screen_ScreenManager$().init___()
  };
  return $n_Lio_youi_app_screen_ScreenManager$
}
/** @constructor */
function $c_Lio_youi_app_screen_ScreenState() {
  $c_O.call(this);
  this.index$1 = 0;
  this.working$1 = false
}
$c_Lio_youi_app_screen_ScreenState.prototype = new $h_O();
$c_Lio_youi_app_screen_ScreenState.prototype.constructor = $c_Lio_youi_app_screen_ScreenState;
/** @constructor */
function $h_Lio_youi_app_screen_ScreenState() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_ScreenState.prototype = $c_Lio_youi_app_screen_ScreenState.prototype;
$c_Lio_youi_app_screen_ScreenState.prototype.init___I__Z = (function(index, working) {
  this.index$1 = index;
  this.working$1 = working;
  return this
});
function $is_Lio_youi_app_screen_ScreenState(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_screen_ScreenState)))
}
function $as_Lio_youi_app_screen_ScreenState(obj) {
  return (($is_Lio_youi_app_screen_ScreenState(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.screen.ScreenState"))
}
function $isArrayOf_Lio_youi_app_screen_ScreenState(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_screen_ScreenState)))
}
function $asArrayOf_Lio_youi_app_screen_ScreenState(obj, depth) {
  return (($isArrayOf_Lio_youi_app_screen_ScreenState(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.screen.ScreenState;", depth))
}
var $d_Lio_youi_app_screen_ScreenState = new $TypeData().initClass({
  Lio_youi_app_screen_ScreenState: 0
}, false, "io.youi.app.screen.ScreenState", {
  Lio_youi_app_screen_ScreenState: 1,
  O: 1
});
$c_Lio_youi_app_screen_ScreenState.prototype.$classData = $d_Lio_youi_app_screen_ScreenState;
function $is_Lio_youi_communication_Communication(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_communication_Communication)))
}
function $as_Lio_youi_communication_Communication(obj) {
  return (($is_Lio_youi_communication_Communication(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.communication.Communication"))
}
function $isArrayOf_Lio_youi_communication_Communication(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_communication_Communication)))
}
function $asArrayOf_Lio_youi_communication_Communication(obj, depth) {
  return (($isArrayOf_Lio_youi_communication_Communication(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.communication.Communication;", depth))
}
/** @constructor */
function $c_Lio_youi_communication_CommunicationInternal() {
  $c_O.call(this);
  this.io$youi$communication$CommunicationInternal$$communication$f = null;
  this.increment$1 = null;
  this.io$youi$communication$CommunicationInternal$$queue$1 = null;
  this.io$youi$communication$CommunicationInternal$$endPoints$1 = null;
  this.send$1 = null;
  this.receive$1 = null
}
$c_Lio_youi_communication_CommunicationInternal.prototype = new $h_O();
$c_Lio_youi_communication_CommunicationInternal.prototype.constructor = $c_Lio_youi_communication_CommunicationInternal;
/** @constructor */
function $h_Lio_youi_communication_CommunicationInternal() {
  /*<skip>*/
}
$h_Lio_youi_communication_CommunicationInternal.prototype = $c_Lio_youi_communication_CommunicationInternal.prototype;
$c_Lio_youi_communication_CommunicationInternal.prototype.init___Lio_youi_communication_Communication = (function(communication) {
  this.io$youi$communication$CommunicationInternal$$communication$f = communication;
  this.increment$1 = new $c_ju_concurrent_atomic_AtomicInteger().init___I(0);
  this.io$youi$communication$CommunicationInternal$$queue$1 = $m_sci_Map$EmptyMap$();
  this.io$youi$communication$CommunicationInternal$$endPoints$1 = $m_sci_Map$EmptyMap$();
  this.send$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  this.receive$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  return this
});
$c_Lio_youi_communication_CommunicationInternal.prototype.init__V = (function() {
  var this$2 = this.receive$1;
  var f = new $c_Lio_youi_communication_CommunicationInternal$$anonfun$init$1().init___Lio_youi_communication_CommunicationInternal(this);
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$2, f, priority);
  var qual$1 = this.io$youi$communication$CommunicationInternal$$communication$f.connection__Lio_youi_http_Connection().receive$1.text$1;
  var x$1 = new $c_Lio_youi_communication_CommunicationInternal$$anonfun$1().init___Lio_youi_communication_CommunicationInternal(this);
  var x$2 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(qual$1, x$1, x$2);
  var this$4 = this.send$1;
  var f$1 = new $c_Lio_youi_communication_CommunicationInternal$$anonfun$init$2().init___Lio_youi_communication_CommunicationInternal(this);
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$4, f$1, priority$1)
});
$c_Lio_youi_communication_CommunicationInternal.prototype.onEndPoint__T__F1__V = (function(endPoint, f) {
  this.io$youi$communication$CommunicationInternal$$endPoints$1 = this.io$youi$communication$CommunicationInternal$$endPoints$1.$$plus__T2__sci_Map(new $c_T2().init___O__O(endPoint, f))
});
$c_Lio_youi_communication_CommunicationInternal.prototype.onInvocation__I__F1__s_concurrent_Future = (function(invocationId, f) {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var handler = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(f$1, promise$1) {
    return (function(m$2) {
      var m = $as_Lio_youi_communication_CommunicationMessage(m$2);
      var x1 = m.error$1;
      if ($is_s_Some(x1)) {
        var x2 = $as_s_Some(x1);
        var error = $as_T(x2.x$2);
        var cause = new $c_Lio_youi_communication_CommunicationException().init___T(error);
        $s_s_concurrent_Promise$class__failure__s_concurrent_Promise__jl_Throwable__s_concurrent_Promise(promise$1, cause)
      } else {
        var x = $m_s_None$();
        if ((x === x1)) {
          var value = f$1.apply__O__O(m);
          $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(promise$1, value)
        } else {
          throw new $c_s_MatchError().init___O(x1)
        }
      }
    })
  })(f, promise));
  this.io$youi$communication$CommunicationInternal$$queue$1 = this.io$youi$communication$CommunicationInternal$$queue$1.$$plus__T2__sci_Map(new $c_T2().init___O__O(invocationId, handler));
  return promise
});
var $d_Lio_youi_communication_CommunicationInternal = new $TypeData().initClass({
  Lio_youi_communication_CommunicationInternal: 0
}, false, "io.youi.communication.CommunicationInternal", {
  Lio_youi_communication_CommunicationInternal: 1,
  O: 1
});
$c_Lio_youi_communication_CommunicationInternal.prototype.$classData = $d_Lio_youi_communication_CommunicationInternal;
/** @constructor */
function $c_Lio_youi_component_Component$sibling$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_component_Component$sibling$.prototype = new $h_O();
$c_Lio_youi_component_Component$sibling$.prototype.constructor = $c_Lio_youi_component_Component$sibling$;
/** @constructor */
function $h_Lio_youi_component_Component$sibling$() {
  /*<skip>*/
}
$h_Lio_youi_component_Component$sibling$.prototype = $c_Lio_youi_component_Component$sibling$.prototype;
$c_Lio_youi_component_Component$sibling$.prototype.init___Lio_youi_component_Component = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_Component$sibling$.prototype.previous__s_Option = (function() {
  var this$1 = this.$$outer$1.parent__Lreactify_Var();
  var this$2 = $as_s_Option(this$1.state__Lreactify_State().value__O());
  if (this$2.isEmpty__Z()) {
    return $m_s_None$()
  } else {
    var arg1 = this$2.get__O();
    var p = $as_Lio_youi_component_Component(arg1);
    var children = p.childComponents__sci_Vector();
    var elem = this.$$outer$1;
    var index = $s_sc_GenSeqLike$class__indexOf__sc_GenSeqLike__O__I__I(children, elem, 0);
    return ((index > 0) ? new $c_s_Some().init___O(children.apply__I__O((((-1) + index) | 0))) : $m_s_None$())
  }
});
var $d_Lio_youi_component_Component$sibling$ = new $TypeData().initClass({
  Lio_youi_component_Component$sibling$: 0
}, false, "io.youi.component.Component$sibling$", {
  Lio_youi_component_Component$sibling$: 1,
  O: 1
});
$c_Lio_youi_component_Component$sibling$.prototype.$classData = $d_Lio_youi_component_Component$sibling$;
/** @constructor */
function $c_Lio_youi_component_bootstrap_ButtonSize() {
  $c_O.call(this);
  this.io$youi$component$bootstrap$ButtonSize$$className$1 = null
}
$c_Lio_youi_component_bootstrap_ButtonSize.prototype = new $h_O();
$c_Lio_youi_component_bootstrap_ButtonSize.prototype.constructor = $c_Lio_youi_component_bootstrap_ButtonSize;
/** @constructor */
function $h_Lio_youi_component_bootstrap_ButtonSize() {
  /*<skip>*/
}
$h_Lio_youi_component_bootstrap_ButtonSize.prototype = $c_Lio_youi_component_bootstrap_ButtonSize.prototype;
$c_Lio_youi_component_bootstrap_ButtonSize.prototype.init___T = (function(key) {
  var array = ["btn-", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [key];
  this.io$youi$component$bootstrap$ButtonSize$$className$1 = jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1));
  return this
});
function $is_Lio_youi_component_bootstrap_ButtonSize(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_component_bootstrap_ButtonSize)))
}
function $as_Lio_youi_component_bootstrap_ButtonSize(obj) {
  return (($is_Lio_youi_component_bootstrap_ButtonSize(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.component.bootstrap.ButtonSize"))
}
function $isArrayOf_Lio_youi_component_bootstrap_ButtonSize(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_component_bootstrap_ButtonSize)))
}
function $asArrayOf_Lio_youi_component_bootstrap_ButtonSize(obj, depth) {
  return (($isArrayOf_Lio_youi_component_bootstrap_ButtonSize(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.component.bootstrap.ButtonSize;", depth))
}
/** @constructor */
function $c_Lio_youi_component_bootstrap_ButtonType() {
  $c_O.call(this);
  this.io$youi$component$bootstrap$ButtonType$$className$1 = null
}
$c_Lio_youi_component_bootstrap_ButtonType.prototype = new $h_O();
$c_Lio_youi_component_bootstrap_ButtonType.prototype.constructor = $c_Lio_youi_component_bootstrap_ButtonType;
/** @constructor */
function $h_Lio_youi_component_bootstrap_ButtonType() {
  /*<skip>*/
}
$h_Lio_youi_component_bootstrap_ButtonType.prototype = $c_Lio_youi_component_bootstrap_ButtonType.prototype;
$c_Lio_youi_component_bootstrap_ButtonType.prototype.init___T = (function(key) {
  var array = ["btn-", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [key];
  this.io$youi$component$bootstrap$ButtonType$$className$1 = jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1));
  return this
});
function $is_Lio_youi_component_bootstrap_ButtonType(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_component_bootstrap_ButtonType)))
}
function $as_Lio_youi_component_bootstrap_ButtonType(obj) {
  return (($is_Lio_youi_component_bootstrap_ButtonType(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.component.bootstrap.ButtonType"))
}
function $isArrayOf_Lio_youi_component_bootstrap_ButtonType(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_component_bootstrap_ButtonType)))
}
function $asArrayOf_Lio_youi_component_bootstrap_ButtonType(obj, depth) {
  return (($isArrayOf_Lio_youi_component_bootstrap_ButtonType(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.component.bootstrap.ButtonType;", depth))
}
/** @constructor */
function $c_Lio_youi_component_extras_ComponentSize$measured$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype = new $h_O();
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.constructor = $c_Lio_youi_component_extras_ComponentSize$measured$;
/** @constructor */
function $h_Lio_youi_component_extras_ComponentSize$measured$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_ComponentSize$measured$.prototype = $c_Lio_youi_component_extras_ComponentSize$measured$.prototype;
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.width$lzycompute__p1__Lreactify_Var = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var mode = $m_Lreactify_Var$Mode$Normal$();
    var name = $m_s_None$();
    this.width$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.width$1
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.init___Lio_youi_component_extras_ComponentSize = (function($$outer) {
  return this
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.height$lzycompute__p1__Lreactify_Var = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var mode = $m_Lreactify_Var$Mode$Normal$();
    var name = $m_s_None$();
    this.height$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.width__Lreactify_Var = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.width$lzycompute__p1__Lreactify_Var() : this.width$1)
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.height__Lreactify_Var = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.height$lzycompute__p1__Lreactify_Var() : this.height$1)
});
var $d_Lio_youi_component_extras_ComponentSize$measured$ = new $TypeData().initClass({
  Lio_youi_component_extras_ComponentSize$measured$: 0
}, false, "io.youi.component.extras.ComponentSize$measured$", {
  Lio_youi_component_extras_ComponentSize$measured$: 1,
  O: 1
});
$c_Lio_youi_component_extras_ComponentSize$measured$.prototype.$classData = $d_Lio_youi_component_extras_ComponentSize$measured$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.max$module$1 = null;
  this.percent$module$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentPosition$scroll$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype;
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.max__Lio_youi_component_extras_HTMLComponentPosition$scroll$max$ = (function() {
  return ((this.max$module$1 === null) ? this.max$lzycompute__p1__Lio_youi_component_extras_HTMLComponentPosition$scroll$max$() : this.max$module$1)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.io$youi$component$extras$HTMLComponentPosition$scroll$$real__D__D = (function(d) {
  return ((((d === Infinity) || (d === (-Infinity))) || (d !== d)) ? 0.0 : d)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.init___Lio_youi_component_extras_HTMLComponentPosition = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.y__Lreactify_Var = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.y$lzycompute__p1__Lreactify_Var() : this.y$1)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.percent$lzycompute__p1__Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$ = (function() {
  if ((this.percent$module$1 === null)) {
    this.percent$module$1 = new $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$().init___Lio_youi_component_extras_HTMLComponentPosition$scroll$(this)
  };
  return this.percent$module$1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.max$lzycompute__p1__Lio_youi_component_extras_HTMLComponentPosition$scroll$max$ = (function() {
  if ((this.max$module$1 === null)) {
    this.max$module$1 = new $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$().init___Lio_youi_component_extras_HTMLComponentPosition$scroll$(this)
  };
  return this.max$module$1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.y$lzycompute__p1__Lreactify_Var = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.y$1 = this.prop__p1__F0__F1__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
      return (function() {
        var this$1 = arg$outer.$$outer$1;
        $m_Lio_youi_component_extras_HTMLComponent$();
        var component = this$1.component$1;
        var jsx$2 = component.element__Lorg_scalajs_dom_raw_HTMLElement().getBoundingClientRect();
        var jsx$1 = jsx$2.top;
        return $uD(jsx$1)
      })
    })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$1) {
      return (function(x$2$2) {
        var x$2 = $uD(x$2$2);
        var this$3 = arg$outer$1.$$outer$1;
        $m_Lio_youi_component_extras_HTMLComponent$();
        var component$1 = this$3.component$1;
        component$1.element__Lorg_scalajs_dom_raw_HTMLElement().scrollTop = x$2
      })
    })(this)));
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.percent__Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$ = (function() {
  return ((this.percent$module$1 === null) ? this.percent$lzycompute__p1__Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$() : this.percent$module$1)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.prop__p1__F0__F1__Lreactify_Var = (function(get, set) {
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  var v = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(get, mode, name);
  var updating = new $c_sr_BooleanRef().init___Z(false);
  var this$6 = this.$$outer$1.component$1.delta__Lreactify_Channel();
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(get$1, v$1, updating$1) {
    return (function() {
      updating$1.elem$1 = true;
      try {
        var value = get$1.apply$mcD$sp__D();
        $s_Lreactify_Var$class__$static__Lreactify_Var__O__V(v$1, value)
      } finally {
        updating$1.elem$1 = false
      }
    })
  })(get, v, updating));
  this.$$outer$1.component$1.delta__Lreactify_Channel();
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__on__Lreactify_Reactive__F0__D__Lreactify_reaction_Reaction(this$6, f, priority);
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(set$1, updating$1$1) {
    return (function(d$2) {
      var d = $uD(d$2);
      if ((!updating$1$1.elem$1)) {
        set$1.apply$mcVD$sp__D__V(d)
      }
    })
  })(set, updating));
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(v, f$1, priority$1);
  return v
});
var $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentPosition$scroll$: 0
}, false, "io.youi.component.extras.HTMLComponentPosition$scroll$", {
  Lio_youi_component_extras_HTMLComponentPosition$scroll$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype;
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.init___Lio_youi_component_extras_HTMLComponentPosition$scroll$ = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.y__Lreactify_Val = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.y$lzycompute__p1__Lreactify_Val() : this.y$1)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.y$lzycompute__p1__Lreactify_Val = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
      return (function() {
        var jsx$2 = arg$outer.$$outer$1;
        var v = arg$outer.$$outer$1.$$outer$1.component$1.size__Lio_youi_component_extras_HTMLComponentSize().scroll__Lio_youi_component_extras_HTMLComponentSize$scroll$().height__Lreactify_Val();
        var jsx$1 = $uD(v.state__Lreactify_State().value__O());
        var v$1 = arg$outer.$$outer$1.$$outer$1.component$1.size__Lio_youi_component_extras_HTMLComponentSize().view__Lio_youi_component_extras_HTMLComponentSize$view$().height__Lreactify_Val();
        return jsx$2.io$youi$component$extras$HTMLComponentPosition$scroll$$real__D__D((jsx$1 - $uD(v$1.state__Lreactify_State().value__O())))
      })
    })(this));
    var name = $m_s_None$();
    this.y$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
var $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentPosition$scroll$max$: 0
}, false, "io.youi.component.extras.HTMLComponentPosition$scroll$max$", {
  Lio_youi_component_extras_HTMLComponentPosition$scroll$max$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$max$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype = $c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype;
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.init___Lio_youi_component_extras_HTMLComponentPosition$scroll$ = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.y__Lreactify_Val = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.y$lzycompute__p1__Lreactify_Val() : this.y$1)
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.y$lzycompute__p1__Lreactify_Val = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
      return (function() {
        var v = arg$outer.$$outer$1.$$outer$1.scroll__Lio_youi_component_extras_HTMLComponentPosition$scroll$().y__Lreactify_Var();
        var jsx$1 = $uD(v.state__Lreactify_State().value__O());
        var v$1 = arg$outer.$$outer$1.max__Lio_youi_component_extras_HTMLComponentPosition$scroll$max$().y__Lreactify_Val();
        var x = (jsx$1 / $uD(v$1.state__Lreactify_State().value__O()));
        return $uD($g.Math.abs(x))
      })
    })(this));
    var name = $m_s_None$();
    this.y$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
var $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$: 0
}, false, "io.youi.component.extras.HTMLComponentPosition$scroll$percent$", {
  Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentPosition$scroll$percent$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentSize$scroll$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentSize$scroll$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentSize$scroll$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype = $c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype;
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.height__Lreactify_Val = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.height$lzycompute__p1__Lreactify_Val() : this.height$1)
});
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.height$lzycompute__p1__Lreactify_Val = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.height$1 = this.$$outer$1.io$youi$component$extras$HTMLComponentSize$$prop__F0__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
      return (function() {
        var this$1 = arg$outer.$$outer$1;
        $m_Lio_youi_component_extras_HTMLComponent$();
        var component = this$1.component$1;
        var jsx$2 = $as_Lio_youi_component_extras_HTMLComponent(component).element__Lorg_scalajs_dom_raw_HTMLElement().getBoundingClientRect();
        var jsx$1 = jsx$2.height;
        return $uD(jsx$1)
      })
    })(this)));
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.init___Lio_youi_component_extras_HTMLComponentSize = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_component_extras_HTMLComponentSize$scroll$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentSize$scroll$: 0
}, false, "io.youi.component.extras.HTMLComponentSize$scroll$", {
  Lio_youi_component_extras_HTMLComponentSize$scroll$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentSize$scroll$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentSize$scroll$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLComponentSize$view$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.constructor = $c_Lio_youi_component_extras_HTMLComponentSize$view$;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLComponentSize$view$() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLComponentSize$view$.prototype = $c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype;
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.height__Lreactify_Val = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.height$lzycompute__p1__Lreactify_Val() : this.height$1)
});
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.height$lzycompute__p1__Lreactify_Val = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.height$1 = this.$$outer$1.io$youi$component$extras$HTMLComponentSize$$prop__F0__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
      return (function() {
        var this$1 = arg$outer.$$outer$1;
        $m_Lio_youi_component_extras_HTMLComponent$();
        var component = this$1.component$1;
        var jsx$1 = $as_Lio_youi_component_extras_HTMLComponent(component).element__Lorg_scalajs_dom_raw_HTMLElement().clientHeight;
        return $uI(jsx$1)
      })
    })(this)));
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.init___Lio_youi_component_extras_HTMLComponentSize = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_component_extras_HTMLComponentSize$view$ = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLComponentSize$view$: 0
}, false, "io.youi.component.extras.HTMLComponentSize$view$", {
  Lio_youi_component_extras_HTMLComponentSize$view$: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLComponentSize$view$.prototype.$classData = $d_Lio_youi_component_extras_HTMLComponentSize$view$;
/** @constructor */
function $c_Lio_youi_component_extras_HTMLExtras() {
  $c_O.call(this);
  this.element$1 = null
}
$c_Lio_youi_component_extras_HTMLExtras.prototype = new $h_O();
$c_Lio_youi_component_extras_HTMLExtras.prototype.constructor = $c_Lio_youi_component_extras_HTMLExtras;
/** @constructor */
function $h_Lio_youi_component_extras_HTMLExtras() {
  /*<skip>*/
}
$h_Lio_youi_component_extras_HTMLExtras.prototype = $c_Lio_youi_component_extras_HTMLExtras.prototype;
$c_Lio_youi_component_extras_HTMLExtras.prototype.init___Lorg_scalajs_dom_raw_HTMLElement = (function(element) {
  this.element$1 = element;
  return this
});
var $d_Lio_youi_component_extras_HTMLExtras = new $TypeData().initClass({
  Lio_youi_component_extras_HTMLExtras: 0
}, false, "io.youi.component.extras.HTMLExtras", {
  Lio_youi_component_extras_HTMLExtras: 1,
  O: 1
});
$c_Lio_youi_component_extras_HTMLExtras.prototype.$classData = $d_Lio_youi_component_extras_HTMLExtras;
/** @constructor */
function $c_Lio_youi_drawable_Composite() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_drawable_Composite.prototype = new $h_O();
$c_Lio_youi_drawable_Composite.prototype.constructor = $c_Lio_youi_drawable_Composite;
/** @constructor */
function $h_Lio_youi_drawable_Composite() {
  /*<skip>*/
}
$h_Lio_youi_drawable_Composite.prototype = $c_Lio_youi_drawable_Composite.prototype;
$c_Lio_youi_drawable_Composite.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
/** @constructor */
function $c_Lio_youi_drawable_Context() {
  $c_O.call(this);
  this.canvas$1 = null;
  this.$$undratio$1 = null;
  this.adjustScaleX$1 = 0.0;
  this.adjustScaleY$1 = 0.0;
  this.fillStyle$1 = null;
  this.strokeStyle$1 = null
}
$c_Lio_youi_drawable_Context.prototype = new $h_O();
$c_Lio_youi_drawable_Context.prototype.constructor = $c_Lio_youi_drawable_Context;
/** @constructor */
function $h_Lio_youi_drawable_Context() {
  /*<skip>*/
}
$h_Lio_youi_drawable_Context.prototype = $c_Lio_youi_drawable_Context.prototype;
$c_Lio_youi_drawable_Context.prototype.drawCanvas__Lorg_scalajs_dom_raw_HTMLCanvasElement__D__D__D__D__V = (function(canvas, x, y, width, height) {
  var qual$2 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
  var x$11 = (x * this.ratioX__D());
  var x$12 = (y * this.ratioY__D());
  var x$13 = (width * this.ratioX__D());
  var x$14 = (height * this.ratioY__D());
  qual$2.drawImage(canvas, x$11, x$12, x$13, x$14)
});
$c_Lio_youi_drawable_Context.prototype.rotate__D__V = (function(angle) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().rotate(angle)
});
$c_Lio_youi_drawable_Context.prototype.reset__V = (function() {
  this.composite__Lio_youi_drawable_Composite__V($m_Lio_youi_drawable_Composite$SourceOver$());
  this.fillStyle$1 = $m_Lio_youi_paint_NoPaint$();
  this.strokeStyle$1 = $m_Lio_youi_paint_Stroke$().none__Lio_youi_paint_Stroke();
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().fillStyle = "";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().strokeStyle = "";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineCap = "";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineDashOffset = 0.0;
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineJoin = "";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineWidth = 0.0;
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().setLineDash([]);
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().globalAlpha = 1.0;
  this.transform__Lio_youi_spatial_Matrix3__V($m_Lio_youi_spatial_Matrix3$().Identity__Lio_youi_spatial_Matrix3())
});
$c_Lio_youi_drawable_Context.prototype.composite__Lio_youi_drawable_Composite__V = (function(composite) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().globalCompositeOperation = composite.value$1
});
$c_Lio_youi_drawable_Context.prototype.drawVideo__Lorg_scalajs_dom_raw_HTMLVideoElement__D__D__D__D__V = (function(video, x, y, width, height) {
  var qual$3 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
  var x$20 = (x * this.ratioX__D());
  var x$21 = (y * this.ratioY__D());
  var x$22 = (width * this.ratioX__D());
  var x$23 = (height * this.ratioY__D());
  qual$3.drawImage(video, x$20, x$21, x$22, x$23)
});
$c_Lio_youi_drawable_Context.prototype.bezierCurveTo__D__D__D__D__D__D__V = (function(cp1x, cp1y, cp2x, cp2y, x, y) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().bezierCurveTo((cp1x * this.ratioX__D()), (cp1y * this.ratioY__D()), (cp2x * this.ratioX__D()), (cp2y * this.ratioY__D()), (x * this.ratioX__D()), (y * this.ratioY__D()))
});
$c_Lio_youi_drawable_Context.prototype.lineTo__D__D__V = (function(x, y) {
  var value = (x * this.ratioX__D());
  var value$1 = (y * this.ratioY__D());
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineTo(value, value$1)
});
$c_Lio_youi_drawable_Context.prototype.rect__D__D__D__D__Z__Z__V = (function(x, y, width, height, begin, close) {
  if (begin) {
    this.begin__V()
  };
  var jsx$1 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
  var value = (x * this.ratioX__D());
  var value$1 = (y * this.ratioY__D());
  jsx$1.rect(value, value$1, (width * this.ratioX__D()), (height * this.ratioY__D()));
  if (close) {
    this.close__V()
  }
});
$c_Lio_youi_drawable_Context.prototype.strokeText__T__D__D__D__V = (function(text, x, y, maxWidth) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().strokeText(text, (x * this.ratioX__D()), (y * this.ratioY__D()), (maxWidth * this.ratioX__D()))
});
$c_Lio_youi_drawable_Context.prototype.stroke__Lio_youi_paint_Paint__D__sci_List__D__Lio_youi_paint_LineCap__Lio_youi_paint_LineJoin__Z__V = (function(paint, lineWidth, lineDash, lineDashOffset, lineCap, lineJoin, apply) {
  if ($s_Lio_youi_paint_Paint$class__nonEmpty__Lio_youi_paint_Paint__Z(paint)) {
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().strokeStyle = paint.asJS__Lio_youi_drawable_Context__sjs_js_Any(this);
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineWidth = (lineWidth * this.ratioX__D());
    var jsx$2 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
    if ($is_sjs_js_ArrayOps(lineDash)) {
      var x2 = $as_sjs_js_ArrayOps(lineDash);
      var jsx$1 = x2.scala$scalajs$js$ArrayOps$$array$f
    } else if ($is_sjs_js_WrappedArray(lineDash)) {
      var x3 = $as_sjs_js_WrappedArray(lineDash);
      var jsx$1 = x3.array$6
    } else {
      var result = [];
      var these = lineDash;
      while ((!these.isEmpty__Z())) {
        var arg1 = these.head__O();
        $uI(result.push(arg1));
        these = $as_sci_List(these.tail__O())
      };
      var jsx$1 = result
    };
    jsx$2.setLineDash(jsx$1);
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineDashOffset = (lineDashOffset * this.ratioX__D());
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineCap = lineCap.value$1;
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().lineJoin = lineJoin.value$1;
    if (apply) {
      this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().stroke()
    }
  }
});
$c_Lio_youi_drawable_Context.prototype.ratioX__D = (function() {
  return (this.$$undratio$1.apply$mcD$sp__D() * this.adjustScaleX$1)
});
$c_Lio_youi_drawable_Context.prototype.restore__V = (function() {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().restore()
});
$c_Lio_youi_drawable_Context.prototype.quadraticCurveTo__D__D__D__D__V = (function(cpx, cpy, x, y) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().quadraticCurveTo((cpx * this.ratioX__D()), (cpy * this.ratioY__D()), (x * this.ratioX__D()), (y * this.ratioY__D()))
});
$c_Lio_youi_drawable_Context.prototype.fillText__T__D__D__D__V = (function(text, x, y, maxWidth) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().textBaseline = "top";
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().fillText(text, (x * this.ratioX__D()), (y * this.ratioY__D()), (maxWidth * this.ratioX__D()))
});
$c_Lio_youi_drawable_Context.prototype.roundedRect__D__D__D__D__D__V = (function(x, y, width, height, radius) {
  this.begin__V();
  this.moveTo__D__D__V((x + radius), y);
  this.lineTo__D__D__V(((x + width) - radius), y);
  this.quadraticCurveTo__D__D__D__D__V((x + width), y, (x + width), (y + radius));
  this.lineTo__D__D__V((x + width), ((y + height) - radius));
  this.quadraticCurveTo__D__D__D__D__V((x + width), (y + height), ((x + width) - radius), (y + height));
  this.lineTo__D__D__V((x + radius), (y + height));
  this.quadraticCurveTo__D__D__D__D__V(x, (y + height), x, ((y + height) - radius));
  this.lineTo__D__D__V(x, (y + radius));
  this.quadraticCurveTo__D__D__D__D__V(x, y, (x + radius), y);
  this.close__V()
});
$c_Lio_youi_drawable_Context.prototype.save__V = (function() {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().save()
});
$c_Lio_youi_drawable_Context.prototype.transform__Lio_youi_spatial_Matrix3__V = (function(matrix) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().setTransform(matrix.m00$1, matrix.m01$1, matrix.m10$1, matrix.m11$1, matrix.m02$1, matrix.m12$1)
});
$c_Lio_youi_drawable_Context.prototype.begin__V = (function() {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().beginPath()
});
$c_Lio_youi_drawable_Context.prototype.init___Lorg_scalajs_dom_raw_HTMLCanvasElement__F0 = (function(canvas, _ratio) {
  this.canvas$1 = canvas;
  this.$$undratio$1 = _ratio;
  this.adjustScaleX$1 = 1.0;
  this.adjustScaleY$1 = 1.0;
  this.fillStyle$1 = $m_Lio_youi_paint_NoPaint$();
  this.strokeStyle$1 = $m_Lio_youi_paint_Stroke$().none__Lio_youi_paint_Stroke();
  return this
});
$c_Lio_youi_drawable_Context.prototype.translate__D__D__V = (function(x, y) {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().translate((x * this.ratioX__D()), (y * this.ratioY__D()))
});
$c_Lio_youi_drawable_Context.prototype.moveTo__D__D__V = (function(x, y) {
  var value = (x * this.ratioX__D());
  var value$1 = (y * this.ratioY__D());
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().moveTo(value, value$1)
});
$c_Lio_youi_drawable_Context.prototype.setFont__T__D__T__T__T__V = (function(family, size, style, variant, weight) {
  var jsx$2 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
  var array = ["", " ", " ", " ", "px ", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [style, variant, weight, (size * this.ratioX__D()), family];
  jsx$2.font = jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
});
$c_Lio_youi_drawable_Context.prototype.drawImage__Lorg_scalajs_dom_raw_HTMLImageElement__D__D__D__D__V = (function(image, x, y, width, height) {
  var qual$1 = this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D();
  var x$2 = (x * this.ratioX__D());
  var x$3 = (y * this.ratioY__D());
  var x$4 = (width * this.ratioX__D());
  var x$5 = (height * this.ratioY__D());
  qual$1.drawImage(image, x$2, x$3, x$4, x$5)
});
$c_Lio_youi_drawable_Context.prototype.close__V = (function() {
  this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().closePath()
});
$c_Lio_youi_drawable_Context.prototype.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D = (function() {
  var canvas = this.canvas$1;
  return new $c_Lio_youi_package$ExtendedCanvas().init___Lorg_scalajs_dom_raw_HTMLCanvasElement(canvas).context__Lorg_scalajs_dom_raw_CanvasRenderingContext2D()
});
$c_Lio_youi_drawable_Context.prototype.ratioY__D = (function() {
  return (this.$$undratio$1.apply$mcD$sp__D() * this.adjustScaleY$1)
});
$c_Lio_youi_drawable_Context.prototype.stroke__Lio_youi_paint_Stroke__Z__V = (function(stroke, apply) {
  if (stroke.nonEmpty__Z()) {
    this.strokeStyle$1 = stroke;
    this.stroke__Lio_youi_paint_Paint__D__sci_List__D__Lio_youi_paint_LineCap__Lio_youi_paint_LineJoin__Z__V(stroke.paint$1, stroke.lineWidth$1, stroke.lineDash$1, stroke.lineDashOffset$1, stroke.lineCap$1, stroke.lineJoin$1, apply)
  }
});
$c_Lio_youi_drawable_Context.prototype.fill__Lio_youi_paint_Paint__Z__V = (function(paint, apply) {
  if ($s_Lio_youi_paint_Paint$class__nonEmpty__Lio_youi_paint_Paint__Z(paint)) {
    this.fillStyle$1 = paint;
    this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().fillStyle = paint.asJS__Lio_youi_drawable_Context__sjs_js_Any(this);
    if (apply) {
      this.ctx__Lorg_scalajs_dom_raw_CanvasRenderingContext2D().fill()
    }
  }
});
var $d_Lio_youi_drawable_Context = new $TypeData().initClass({
  Lio_youi_drawable_Context: 0
}, false, "io.youi.drawable.Context", {
  Lio_youi_drawable_Context: 1,
  O: 1
});
$c_Lio_youi_drawable_Context.prototype.$classData = $d_Lio_youi_drawable_Context;
function $is_Lio_youi_drawable_Drawable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_drawable_Drawable)))
}
function $as_Lio_youi_drawable_Drawable(obj) {
  return (($is_Lio_youi_drawable_Drawable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.drawable.Drawable"))
}
function $isArrayOf_Lio_youi_drawable_Drawable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_drawable_Drawable)))
}
function $asArrayOf_Lio_youi_drawable_Drawable(obj, depth) {
  return (($isArrayOf_Lio_youi_drawable_Drawable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.drawable.Drawable;", depth))
}
/** @constructor */
function $c_Lio_youi_drawable_Transformation$() {
  $c_O.call(this)
}
$c_Lio_youi_drawable_Transformation$.prototype = new $h_O();
$c_Lio_youi_drawable_Transformation$.prototype.constructor = $c_Lio_youi_drawable_Transformation$;
/** @constructor */
function $h_Lio_youi_drawable_Transformation$() {
  /*<skip>*/
}
$h_Lio_youi_drawable_Transformation$.prototype = $c_Lio_youi_drawable_Transformation$.prototype;
$c_Lio_youi_drawable_Transformation$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_drawable_Transformation$.prototype.apply__D__D__D__D__D__Lio_youi_drawable_Drawable__Lio_youi_drawable_Transformation = (function(x, y, pivotX, pivotY, rotation, drawable) {
  return new $c_Lio_youi_drawable_Transformation$$anon$1().init___D__D__D__D__D__Lio_youi_drawable_Drawable(x, y, pivotX, pivotY, rotation, drawable)
});
var $d_Lio_youi_drawable_Transformation$ = new $TypeData().initClass({
  Lio_youi_drawable_Transformation$: 0
}, false, "io.youi.drawable.Transformation$", {
  Lio_youi_drawable_Transformation$: 1,
  O: 1
});
$c_Lio_youi_drawable_Transformation$.prototype.$classData = $d_Lio_youi_drawable_Transformation$;
var $n_Lio_youi_drawable_Transformation$ = (void 0);
function $m_Lio_youi_drawable_Transformation$() {
  if ((!$n_Lio_youi_drawable_Transformation$)) {
    $n_Lio_youi_drawable_Transformation$ = new $c_Lio_youi_drawable_Transformation$().init___()
  };
  return $n_Lio_youi_drawable_Transformation$
}
/** @constructor */
function $c_Lio_youi_easing_Bounce$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Bounce$.prototype = new $h_O();
$c_Lio_youi_easing_Bounce$.prototype.constructor = $c_Lio_youi_easing_Bounce$;
/** @constructor */
function $h_Lio_youi_easing_Bounce$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Bounce$.prototype = $c_Lio_youi_easing_Bounce$.prototype;
$c_Lio_youi_easing_Bounce$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Bounce$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  return ((time < (duration / 2.0)) ? ((0.5 * this.easeIn__D__D__D__D__D((2.0 * time), 0.0, change, duration)) + start) : (((0.5 * this.easeOut__D__D__D__D__D(((2.0 * time) - duration), 0.0, change, duration)) + (0.5 * change)) + start))
});
$c_Lio_youi_easing_Bounce$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  if ((t < 0.36363636363636365)) {
    return ((change * ((7.5625 * t) * t)) + start)
  } else if ((t < 0.7272727272727273)) {
    var t2 = ((-0.5454545454545454) + t);
    return ((change * (0.75 + ((7.5625 * t2) * t2))) + start)
  } else if ((t < 0.9090909090909091)) {
    var t3 = ((-0.8181818181818182) + t);
    return ((change * (0.9375 + ((7.5625 * t3) * t3))) + start)
  } else {
    var t4 = ((-0.9545454545454546) + t);
    return ((change * (0.984375 + ((7.5625 * t4) * t4))) + start)
  }
});
$c_Lio_youi_easing_Bounce$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  return ((change - this.easeOut__D__D__D__D__D((duration - time), 0.0, change, duration)) + start)
});
var $d_Lio_youi_easing_Bounce$ = new $TypeData().initClass({
  Lio_youi_easing_Bounce$: 0
}, false, "io.youi.easing.Bounce$", {
  Lio_youi_easing_Bounce$: 1,
  O: 1
});
$c_Lio_youi_easing_Bounce$.prototype.$classData = $d_Lio_youi_easing_Bounce$;
var $n_Lio_youi_easing_Bounce$ = (void 0);
function $m_Lio_youi_easing_Bounce$() {
  if ((!$n_Lio_youi_easing_Bounce$)) {
    $n_Lio_youi_easing_Bounce$ = new $c_Lio_youi_easing_Bounce$().init___()
  };
  return $n_Lio_youi_easing_Bounce$
}
/** @constructor */
function $c_Lio_youi_easing_Circular$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Circular$.prototype = new $h_O();
$c_Lio_youi_easing_Circular$.prototype.constructor = $c_Lio_youi_easing_Circular$;
/** @constructor */
function $h_Lio_youi_easing_Circular$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Circular$.prototype = $c_Lio_youi_easing_Circular$.prototype;
$c_Lio_youi_easing_Circular$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Circular$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2));
  if ((t < 1)) {
    var x = (1.0 - (t * t));
    return ((((-change) / 2.0) * ((-1.0) + $uD($g.Math.sqrt(x)))) + start)
  } else {
    var t2 = ((-2.0) + t);
    var x$1 = (1.0 - (t2 * t2));
    return (((change / 2.0) * (1.0 + $uD($g.Math.sqrt(x$1)))) + start)
  }
});
$c_Lio_youi_easing_Circular$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  var x = (1.0 - (t * t));
  return ((change * $uD($g.Math.sqrt(x))) + start)
});
$c_Lio_youi_easing_Circular$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  var x = (1.0 - (t * t));
  return (((-change) * ((-1.0) + $uD($g.Math.sqrt(x)))) + start)
});
var $d_Lio_youi_easing_Circular$ = new $TypeData().initClass({
  Lio_youi_easing_Circular$: 0
}, false, "io.youi.easing.Circular$", {
  Lio_youi_easing_Circular$: 1,
  O: 1
});
$c_Lio_youi_easing_Circular$.prototype.$classData = $d_Lio_youi_easing_Circular$;
var $n_Lio_youi_easing_Circular$ = (void 0);
function $m_Lio_youi_easing_Circular$() {
  if ((!$n_Lio_youi_easing_Circular$)) {
    $n_Lio_youi_easing_Circular$ = new $c_Lio_youi_easing_Circular$().init___()
  };
  return $n_Lio_youi_easing_Circular$
}
/** @constructor */
function $c_Lio_youi_easing_Cubic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Cubic$.prototype = new $h_O();
$c_Lio_youi_easing_Cubic$.prototype.constructor = $c_Lio_youi_easing_Cubic$;
/** @constructor */
function $h_Lio_youi_easing_Cubic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Cubic$.prototype = $c_Lio_youi_easing_Cubic$.prototype;
$c_Lio_youi_easing_Cubic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Cubic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return (((((change / 2.0) * t) * t) * t) + start)
  } else {
    var t2 = ((-2.0) + t);
    return (((change / 2.0) * (2.0 + ((t2 * t2) * t2))) + start)
  }
});
$c_Lio_youi_easing_Cubic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  return ((change * (1.0 + ((t * t) * t))) + start)
});
$c_Lio_youi_easing_Cubic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return ((((change * t) * t) * t) + start)
});
var $d_Lio_youi_easing_Cubic$ = new $TypeData().initClass({
  Lio_youi_easing_Cubic$: 0
}, false, "io.youi.easing.Cubic$", {
  Lio_youi_easing_Cubic$: 1,
  O: 1
});
$c_Lio_youi_easing_Cubic$.prototype.$classData = $d_Lio_youi_easing_Cubic$;
var $n_Lio_youi_easing_Cubic$ = (void 0);
function $m_Lio_youi_easing_Cubic$() {
  if ((!$n_Lio_youi_easing_Cubic$)) {
    $n_Lio_youi_easing_Cubic$ = new $c_Lio_youi_easing_Cubic$().init___()
  };
  return $n_Lio_youi_easing_Cubic$
}
/** @constructor */
function $c_Lio_youi_easing_Easing$() {
  $c_O.call(this);
  this.map$1 = null;
  this.all$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_easing_Easing$.prototype = new $h_O();
$c_Lio_youi_easing_Easing$.prototype.constructor = $c_Lio_youi_easing_Easing$;
/** @constructor */
function $h_Lio_youi_easing_Easing$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Easing$.prototype = $c_Lio_youi_easing_Easing$.prototype;
$c_Lio_youi_easing_Easing$.prototype.cubicInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Cubic$().easeInOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Easing$.prototype.map__sci_Map = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.map$lzycompute__p1__sci_Map() : this.map$1)
});
$c_Lio_youi_easing_Easing$.prototype.cubicOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Cubic$().easeOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.exponentialIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Exponential$().easeIn__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.sineIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Sine$().easeIn__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quarticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Quartic$().easeOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.exponentialOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Exponential$().easeOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quinticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Quintic$().easeIn__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.circularIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Circular$().easeIn__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quadraticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Quadratic$().easeIn__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.bounceIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Bounce$().easeIn__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.sineOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Sine$().easeOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quinticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Quintic$().easeInOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.elasticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Elastic$().easeIn__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.circularInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Circular$().easeInOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.sineInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Sine$().easeInOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.elasticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Elastic$().easeOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quadraticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Quadratic$().easeOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quarticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Quartic$().easeInOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.bounceOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Bounce$().easeOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.exponentialInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Exponential$().easeInOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.bounceInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Bounce$().easeInOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.circularOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Circular$().easeOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quarticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Quartic$().easeIn__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quadraticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Quadratic$().easeInOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.cubicIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Cubic$().easeIn__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quinticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Quintic$().easeOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.map$lzycompute__p1__sci_Map = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var y = new $c_Lio_youi_easing_BackIn().init___D(1.70158);
    var jsx$30 = new $c_T2().init___O__O("BackIn", y);
    var y$1 = new $c_Lio_youi_easing_BackOut().init___D(1.70158);
    var jsx$29 = new $c_T2().init___O__O("BackOut", y$1);
    var y$2 = new $c_Lio_youi_easing_BackInOut().init___D(1.70158);
    var jsx$28 = new $c_T2().init___O__O("BackInOut", y$2);
    var y$3 = $m_Lio_youi_easing_Linear$();
    var jsx$27 = new $c_T2().init___O__O("Linear", y$3);
    var y$4 = $m_Lio_youi_easing_Easing$().bounceIn__Lio_youi_easing_Easing();
    var jsx$26 = new $c_T2().init___O__O("BounceIn", y$4);
    var y$5 = $m_Lio_youi_easing_Easing$().bounceOut__Lio_youi_easing_Easing();
    var jsx$25 = new $c_T2().init___O__O("BounceOut", y$5);
    var y$6 = $m_Lio_youi_easing_Easing$().bounceInOut__Lio_youi_easing_Easing();
    var jsx$24 = new $c_T2().init___O__O("BounceInOut", y$6);
    var y$7 = $m_Lio_youi_easing_Easing$().circularIn__Lio_youi_easing_Easing();
    var jsx$23 = new $c_T2().init___O__O("CircularIn", y$7);
    var y$8 = $m_Lio_youi_easing_Easing$().circularOut__Lio_youi_easing_Easing();
    var jsx$22 = new $c_T2().init___O__O("CircularOut", y$8);
    var y$9 = $m_Lio_youi_easing_Easing$().circularInOut__Lio_youi_easing_Easing();
    var jsx$21 = new $c_T2().init___O__O("CircularInOut", y$9);
    var y$10 = $m_Lio_youi_easing_Easing$().cubicIn__Lio_youi_easing_Easing();
    var jsx$20 = new $c_T2().init___O__O("CubicIn", y$10);
    var y$11 = $m_Lio_youi_easing_Easing$().cubicOut__Lio_youi_easing_Easing();
    var jsx$19 = new $c_T2().init___O__O("CubicOut", y$11);
    var y$12 = $m_Lio_youi_easing_Easing$().cubicInOut__Lio_youi_easing_Easing();
    var jsx$18 = new $c_T2().init___O__O("CubicInOut", y$12);
    var y$13 = $m_Lio_youi_easing_Easing$().elasticIn__Lio_youi_easing_Easing();
    var jsx$17 = new $c_T2().init___O__O("ElasticIn", y$13);
    var y$14 = $m_Lio_youi_easing_Easing$().elasticOut__Lio_youi_easing_Easing();
    var jsx$16 = new $c_T2().init___O__O("ElasticOut", y$14);
    var y$15 = $m_Lio_youi_easing_Easing$().elasticInOut__Lio_youi_easing_Easing();
    var jsx$15 = new $c_T2().init___O__O("ElasticInOut", y$15);
    var y$16 = $m_Lio_youi_easing_Easing$().exponentialIn__Lio_youi_easing_Easing();
    var jsx$14 = new $c_T2().init___O__O("ExponentialIn", y$16);
    var y$17 = $m_Lio_youi_easing_Easing$().exponentialOut__Lio_youi_easing_Easing();
    var jsx$13 = new $c_T2().init___O__O("ExponentialOut", y$17);
    var y$18 = $m_Lio_youi_easing_Easing$().exponentialInOut__Lio_youi_easing_Easing();
    var jsx$12 = new $c_T2().init___O__O("ExponentialInOut", y$18);
    var y$19 = $m_Lio_youi_easing_Easing$().quadraticIn__Lio_youi_easing_Easing();
    var jsx$11 = new $c_T2().init___O__O("QuadraticIn", y$19);
    var y$20 = $m_Lio_youi_easing_Easing$().quadraticOut__Lio_youi_easing_Easing();
    var jsx$10 = new $c_T2().init___O__O("QuadraticOut", y$20);
    var y$21 = $m_Lio_youi_easing_Easing$().quadraticInOut__Lio_youi_easing_Easing();
    var jsx$9 = new $c_T2().init___O__O("QuadraticInOut", y$21);
    var y$22 = $m_Lio_youi_easing_Easing$().quarticIn__Lio_youi_easing_Easing();
    var jsx$8 = new $c_T2().init___O__O("QuarticIn", y$22);
    var y$23 = $m_Lio_youi_easing_Easing$().quarticOut__Lio_youi_easing_Easing();
    var jsx$7 = new $c_T2().init___O__O("QuarticOut", y$23);
    var y$24 = $m_Lio_youi_easing_Easing$().quarticInOut__Lio_youi_easing_Easing();
    var jsx$6 = new $c_T2().init___O__O("QuarticInOut", y$24);
    var y$25 = $m_Lio_youi_easing_Easing$().quinticIn__Lio_youi_easing_Easing();
    var jsx$5 = new $c_T2().init___O__O("QuinticIn", y$25);
    var y$26 = $m_Lio_youi_easing_Easing$().quinticOut__Lio_youi_easing_Easing();
    var jsx$4 = new $c_T2().init___O__O("QuinticOut", y$26);
    var y$27 = $m_Lio_youi_easing_Easing$().quinticInOut__Lio_youi_easing_Easing();
    var jsx$3 = new $c_T2().init___O__O("QuinticInOut", y$27);
    var y$28 = $m_Lio_youi_easing_Easing$().sineIn__Lio_youi_easing_Easing();
    var jsx$2 = new $c_T2().init___O__O("SineIn", y$28);
    var y$29 = $m_Lio_youi_easing_Easing$().sineOut__Lio_youi_easing_Easing();
    var jsx$1 = new $c_T2().init___O__O("SineOut", y$29);
    var y$30 = $m_Lio_youi_easing_Easing$().sineInOut__Lio_youi_easing_Easing();
    var array = [jsx$30, jsx$29, jsx$28, jsx$27, jsx$26, jsx$25, jsx$24, jsx$23, jsx$22, jsx$21, jsx$20, jsx$19, jsx$18, jsx$17, jsx$16, jsx$15, jsx$14, jsx$13, jsx$12, jsx$11, jsx$10, jsx$9, jsx$8, jsx$7, jsx$6, jsx$5, jsx$4, jsx$3, jsx$2, jsx$1, new $c_T2().init___O__O("SineInOut", y$30)];
    var this$70 = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
    var i = 0;
    var len = $uI(array.length);
    while ((i < len)) {
      var index = i;
      var arg1 = array[index];
      this$70.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1));
      i = ((1 + i) | 0)
    };
    this.map$1 = $as_sci_Map(this$70.elems$1);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.map$1
});
$c_Lio_youi_easing_Easing$.prototype.elasticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function(time$2, start$2, change$2, duration$2) {
    var time = $uD(time$2);
    var start = $uD(start$2);
    var change = $uD(change$2);
    var duration = $uD(duration$2);
    return $m_Lio_youi_easing_Elastic$().easeInOut__D__D__D__D__D(time, start, change, duration)
  }));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
var $d_Lio_youi_easing_Easing$ = new $TypeData().initClass({
  Lio_youi_easing_Easing$: 0
}, false, "io.youi.easing.Easing$", {
  Lio_youi_easing_Easing$: 1,
  O: 1
});
$c_Lio_youi_easing_Easing$.prototype.$classData = $d_Lio_youi_easing_Easing$;
var $n_Lio_youi_easing_Easing$ = (void 0);
function $m_Lio_youi_easing_Easing$() {
  if ((!$n_Lio_youi_easing_Easing$)) {
    $n_Lio_youi_easing_Easing$ = new $c_Lio_youi_easing_Easing$().init___()
  };
  return $n_Lio_youi_easing_Easing$
}
/** @constructor */
function $c_Lio_youi_easing_Elastic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Elastic$.prototype = new $h_O();
$c_Lio_youi_easing_Elastic$.prototype.constructor = $c_Lio_youi_easing_Elastic$;
/** @constructor */
function $h_Lio_youi_easing_Elastic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Elastic$.prototype = $c_Lio_youi_easing_Elastic$.prototype;
$c_Lio_youi_easing_Elastic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Elastic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((time === 0.0)) {
    return start
  } else if ((t === 2.0)) {
    return (start + change)
  } else {
    var period = (0.44999999999999996 * duration);
    var s = (period / 4.0);
    var t2 = ((-1.0) + t);
    if ((t < 1.0)) {
      var y = (10.0 * t2);
      var jsx$1 = $uD($g.Math.pow(2.0, y));
      var x = ((6.283185307179586 * ((t2 * duration) - s)) / period);
      return (((-0.5) * ((change * jsx$1) * $uD($g.Math.sin(x)))) + start)
    } else {
      var y$1 = ((-10.0) * t2);
      var jsx$2 = $uD($g.Math.pow(2.0, y$1));
      var x$1 = ((6.283185307179586 * ((t2 * duration) - s)) / period);
      return (((0.5 * ((change * jsx$2) * $uD($g.Math.sin(x$1)))) + change) + start)
    }
  }
});
$c_Lio_youi_easing_Elastic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  if ((time === 0.0)) {
    return start
  } else if ((t === 1.0)) {
    return (start + change)
  } else {
    var period = (0.3 * duration);
    var s = (period / 4.0);
    var y = ((-10.0) * t);
    var jsx$1 = $uD($g.Math.pow(2.0, y));
    var x = ((6.283185307179586 * ((t * duration) - s)) / period);
    return ((((change * jsx$1) * $uD($g.Math.sin(x))) + change) + start)
  }
});
$c_Lio_youi_easing_Elastic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  if ((time === 0.0)) {
    return start
  } else if ((t === 1.0)) {
    return (start + change)
  } else {
    var period = (0.3 * duration);
    var s = (period / 4.0);
    var t2 = ((-1.0) + t);
    var y = (10.0 * t2);
    var jsx$1 = $uD($g.Math.pow(2.0, y));
    var x = ((6.283185307179586 * ((t2 * duration) - s)) / period);
    return ((-((change * jsx$1) * $uD($g.Math.sin(x)))) + start)
  }
});
var $d_Lio_youi_easing_Elastic$ = new $TypeData().initClass({
  Lio_youi_easing_Elastic$: 0
}, false, "io.youi.easing.Elastic$", {
  Lio_youi_easing_Elastic$: 1,
  O: 1
});
$c_Lio_youi_easing_Elastic$.prototype.$classData = $d_Lio_youi_easing_Elastic$;
var $n_Lio_youi_easing_Elastic$ = (void 0);
function $m_Lio_youi_easing_Elastic$() {
  if ((!$n_Lio_youi_easing_Elastic$)) {
    $n_Lio_youi_easing_Elastic$ = new $c_Lio_youi_easing_Elastic$().init___()
  };
  return $n_Lio_youi_easing_Elastic$
}
/** @constructor */
function $c_Lio_youi_easing_Exponential$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Exponential$.prototype = new $h_O();
$c_Lio_youi_easing_Exponential$.prototype.constructor = $c_Lio_youi_easing_Exponential$;
/** @constructor */
function $h_Lio_youi_easing_Exponential$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Exponential$.prototype = $c_Lio_youi_easing_Exponential$.prototype;
$c_Lio_youi_easing_Exponential$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Exponential$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((time === 0.0)) {
    return start
  } else if ((time === duration)) {
    return (start + change)
  } else if ((t < 1.0)) {
    var y = (10.0 * ((-1.0) + t));
    return (((change / 2.0) * $uD($g.Math.pow(2.0, y))) + start)
  } else {
    var y$1 = ((-10.0) * ((-1.0) + t));
    return (((change / 2.0) * (2.0 - $uD($g.Math.pow(2.0, y$1)))) + start)
  }
});
$c_Lio_youi_easing_Exponential$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  if ((time === duration)) {
    return (start + change)
  } else {
    var y = (((-10.0) * time) / duration);
    return ((change * (1.0 - $uD($g.Math.pow(2.0, y)))) + start)
  }
});
$c_Lio_youi_easing_Exponential$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  if ((time === 0.0)) {
    return start
  } else {
    var y = (10.0 * ((-1.0) + (time / duration)));
    return ((change * $uD($g.Math.pow(2.0, y))) + start)
  }
});
var $d_Lio_youi_easing_Exponential$ = new $TypeData().initClass({
  Lio_youi_easing_Exponential$: 0
}, false, "io.youi.easing.Exponential$", {
  Lio_youi_easing_Exponential$: 1,
  O: 1
});
$c_Lio_youi_easing_Exponential$.prototype.$classData = $d_Lio_youi_easing_Exponential$;
var $n_Lio_youi_easing_Exponential$ = (void 0);
function $m_Lio_youi_easing_Exponential$() {
  if ((!$n_Lio_youi_easing_Exponential$)) {
    $n_Lio_youi_easing_Exponential$ = new $c_Lio_youi_easing_Exponential$().init___()
  };
  return $n_Lio_youi_easing_Exponential$
}
/** @constructor */
function $c_Lio_youi_easing_Quadratic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Quadratic$.prototype = new $h_O();
$c_Lio_youi_easing_Quadratic$.prototype.constructor = $c_Lio_youi_easing_Quadratic$;
/** @constructor */
function $h_Lio_youi_easing_Quadratic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Quadratic$.prototype = $c_Lio_youi_easing_Quadratic$.prototype;
$c_Lio_youi_easing_Quadratic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Quadratic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return ((((change / 2.0) * t) * t) + start)
  } else {
    var t2 = ((-1.0) + t);
    return ((((-change) / 2.0) * ((-1.0) + (t2 * ((-2.0) + t2)))) + start)
  }
});
$c_Lio_youi_easing_Quadratic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return ((((-change) * t) * ((-2.0) + t)) + start)
});
$c_Lio_youi_easing_Quadratic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return (((change * t) * t) + start)
});
var $d_Lio_youi_easing_Quadratic$ = new $TypeData().initClass({
  Lio_youi_easing_Quadratic$: 0
}, false, "io.youi.easing.Quadratic$", {
  Lio_youi_easing_Quadratic$: 1,
  O: 1
});
$c_Lio_youi_easing_Quadratic$.prototype.$classData = $d_Lio_youi_easing_Quadratic$;
var $n_Lio_youi_easing_Quadratic$ = (void 0);
function $m_Lio_youi_easing_Quadratic$() {
  if ((!$n_Lio_youi_easing_Quadratic$)) {
    $n_Lio_youi_easing_Quadratic$ = new $c_Lio_youi_easing_Quadratic$().init___()
  };
  return $n_Lio_youi_easing_Quadratic$
}
/** @constructor */
function $c_Lio_youi_easing_Quartic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Quartic$.prototype = new $h_O();
$c_Lio_youi_easing_Quartic$.prototype.constructor = $c_Lio_youi_easing_Quartic$;
/** @constructor */
function $h_Lio_youi_easing_Quartic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Quartic$.prototype = $c_Lio_youi_easing_Quartic$.prototype;
$c_Lio_youi_easing_Quartic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Quartic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return ((((((change / 2.0) * t) * t) * t) * t) + start)
  } else {
    var t2 = ((-2.0) + t);
    return ((((-change) / 2.0) * ((-2.0) + (((t2 * t2) * t2) * t2))) + start)
  }
});
$c_Lio_youi_easing_Quartic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  return (((-change) * ((-1.0) + (((t * t) * t) * t))) + start)
});
$c_Lio_youi_easing_Quartic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return (((((change * t) * t) * t) * t) + start)
});
var $d_Lio_youi_easing_Quartic$ = new $TypeData().initClass({
  Lio_youi_easing_Quartic$: 0
}, false, "io.youi.easing.Quartic$", {
  Lio_youi_easing_Quartic$: 1,
  O: 1
});
$c_Lio_youi_easing_Quartic$.prototype.$classData = $d_Lio_youi_easing_Quartic$;
var $n_Lio_youi_easing_Quartic$ = (void 0);
function $m_Lio_youi_easing_Quartic$() {
  if ((!$n_Lio_youi_easing_Quartic$)) {
    $n_Lio_youi_easing_Quartic$ = new $c_Lio_youi_easing_Quartic$().init___()
  };
  return $n_Lio_youi_easing_Quartic$
}
/** @constructor */
function $c_Lio_youi_easing_Quintic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Quintic$.prototype = new $h_O();
$c_Lio_youi_easing_Quintic$.prototype.constructor = $c_Lio_youi_easing_Quintic$;
/** @constructor */
function $h_Lio_youi_easing_Quintic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Quintic$.prototype = $c_Lio_youi_easing_Quintic$.prototype;
$c_Lio_youi_easing_Quintic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Quintic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return (((((((change / 2.0) * t) * t) * t) * t) * t) + start)
  } else {
    var t2 = ((-2.0) + t);
    return (((change / 2.0) * (2.0 + ((((t2 * t2) * t2) * t2) * t2))) + start)
  }
});
$c_Lio_youi_easing_Quintic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  return ((change * (1.0 + ((((t * t) * t) * t) * t))) + start)
});
$c_Lio_youi_easing_Quintic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return ((((((change * t) * t) * t) * t) * t) + start)
});
var $d_Lio_youi_easing_Quintic$ = new $TypeData().initClass({
  Lio_youi_easing_Quintic$: 0
}, false, "io.youi.easing.Quintic$", {
  Lio_youi_easing_Quintic$: 1,
  O: 1
});
$c_Lio_youi_easing_Quintic$.prototype.$classData = $d_Lio_youi_easing_Quintic$;
var $n_Lio_youi_easing_Quintic$ = (void 0);
function $m_Lio_youi_easing_Quintic$() {
  if ((!$n_Lio_youi_easing_Quintic$)) {
    $n_Lio_youi_easing_Quintic$ = new $c_Lio_youi_easing_Quintic$().init___()
  };
  return $n_Lio_youi_easing_Quintic$
}
/** @constructor */
function $c_Lio_youi_easing_Sine$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Sine$.prototype = new $h_O();
$c_Lio_youi_easing_Sine$.prototype.constructor = $c_Lio_youi_easing_Sine$;
/** @constructor */
function $h_Lio_youi_easing_Sine$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Sine$.prototype = $c_Lio_youi_easing_Sine$.prototype;
$c_Lio_youi_easing_Sine$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Sine$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var x = ((3.141592653589793 * time) / duration);
  return ((((-change) / 2.0) * ((-1.0) + $uD($g.Math.cos(x)))) + start)
});
$c_Lio_youi_easing_Sine$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var x = (1.5707963267948966 * (time / duration));
  return ((change * $uD($g.Math.sin(x))) + start)
});
$c_Lio_youi_easing_Sine$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var x = (1.5707963267948966 * (time / duration));
  return ((((-change) * $uD($g.Math.cos(x))) + change) + start)
});
var $d_Lio_youi_easing_Sine$ = new $TypeData().initClass({
  Lio_youi_easing_Sine$: 0
}, false, "io.youi.easing.Sine$", {
  Lio_youi_easing_Sine$: 1,
  O: 1
});
$c_Lio_youi_easing_Sine$.prototype.$classData = $d_Lio_youi_easing_Sine$;
var $n_Lio_youi_easing_Sine$ = (void 0);
function $m_Lio_youi_easing_Sine$() {
  if ((!$n_Lio_youi_easing_Sine$)) {
    $n_Lio_youi_easing_Sine$ = new $c_Lio_youi_easing_Sine$().init___()
  };
  return $n_Lio_youi_easing_Sine$
}
/** @constructor */
function $c_Lio_youi_event_Event$() {
  $c_O.call(this);
  this.threadLocal$1 = null
}
$c_Lio_youi_event_Event$.prototype = new $h_O();
$c_Lio_youi_event_Event$.prototype.constructor = $c_Lio_youi_event_Event$;
/** @constructor */
function $h_Lio_youi_event_Event$() {
  /*<skip>*/
}
$h_Lio_youi_event_Event$.prototype = $c_Lio_youi_event_Event$.prototype;
$c_Lio_youi_event_Event$.prototype.init___ = (function() {
  $n_Lio_youi_event_Event$ = this;
  this.threadLocal$1 = new $c_Lio_youi_event_Event$$anon$1().init___();
  return this
});
$c_Lio_youi_event_Event$.prototype.io$youi$event$Event$$stopPropagation__Lio_youi_event_Event__V = (function(event) {
  var map = $as_sci_Map(this.threadLocal$1.get__O());
  var x1 = map.get__O__s_Option(event);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var v = x2.x$2;
    var jsx$1 = v
  } else {
    var x = $m_s_None$();
    if ((!(x === x1))) {
      throw new $c_s_MatchError().init___O(x1)
    };
    var jsx$1 = new $c_Lio_youi_event_EventStatus().init___Z(true)
  };
  var eventStatus = $as_Lio_youi_event_EventStatus(jsx$1);
  this.threadLocal$1.set__O__V(map.$$plus__T2__sci_Map(new $c_T2().init___O__O(event, eventStatus)))
});
var $d_Lio_youi_event_Event$ = new $TypeData().initClass({
  Lio_youi_event_Event$: 0
}, false, "io.youi.event.Event$", {
  Lio_youi_event_Event$: 1,
  O: 1
});
$c_Lio_youi_event_Event$.prototype.$classData = $d_Lio_youi_event_Event$;
var $n_Lio_youi_event_Event$ = (void 0);
function $m_Lio_youi_event_Event$() {
  if ((!$n_Lio_youi_event_Event$)) {
    $n_Lio_youi_event_Event$ = new $c_Lio_youi_event_Event$().init___()
  };
  return $n_Lio_youi_event_Event$
}
/** @constructor */
function $c_Lio_youi_event_EventSupport$pointer$() {
  $c_O.call(this);
  this.move$1 = null;
  this.enter$1 = null;
  this.exit$1 = null;
  this.down$1 = null;
  this.up$1 = null;
  this.cancel$1 = null;
  this.wheel$1 = null;
  this.x$1$1 = null;
  this.x$1 = null;
  this.y$1 = null;
  this.overState$1 = null;
  this.downState$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_event_EventSupport$pointer$.prototype = new $h_O();
$c_Lio_youi_event_EventSupport$pointer$.prototype.constructor = $c_Lio_youi_event_EventSupport$pointer$;
/** @constructor */
function $h_Lio_youi_event_EventSupport$pointer$() {
  /*<skip>*/
}
$h_Lio_youi_event_EventSupport$pointer$.prototype = $c_Lio_youi_event_EventSupport$pointer$.prototype;
$c_Lio_youi_event_EventSupport$pointer$.prototype.overState__Lreactify_Val = (function() {
  return (((1024 & this.bitmap$0$1) === 0) ? this.overState$lzycompute__p1__Lreactify_Val() : this.overState$1)
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.enter__Lreactify_Channel = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.enter$lzycompute__p1__Lreactify_Channel() : this.enter$1)
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.move__Lreactify_Channel = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.move$lzycompute__p1__Lreactify_Channel() : this.move$1)
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.move$lzycompute__p1__Lreactify_Channel = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.move$1 = this.$$outer$1.pointerChannel__Lio_youi_event_PointerEvent$Type__Lreactify_Channel($m_Lio_youi_event_PointerEvent$Type$Move$());
    this.bitmap$0$1 = (1 | this.bitmap$0$1)
  };
  return this.move$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.init___Lio_youi_event_EventSupport = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.exit__Lreactify_Channel = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.exit$lzycompute__p1__Lreactify_Channel() : this.exit$1)
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.exit$lzycompute__p1__Lreactify_Channel = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.exit$1 = this.$$outer$1.pointerChannel__Lio_youi_event_PointerEvent$Type__Lreactify_Channel($m_Lio_youi_event_PointerEvent$Type$Exit$());
    this.bitmap$0$1 = (4 | this.bitmap$0$1)
  };
  return this.exit$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.overState$lzycompute__p1__Lreactify_Val = (function() {
  if (((1024 & this.bitmap$0$1) === 0)) {
    this.overState$1 = $as_Lreactify_Val(this.x$1__p1__T3().$$und3$1);
    this.bitmap$0$1 = (1024 | this.bitmap$0$1)
  };
  return this.overState$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.x$1$lzycompute__p1__T3 = (function() {
  if (((128 & this.bitmap$0$1) === 0)) {
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var mode = $m_Lreactify_Var$Mode$Normal$();
    var name = $m_s_None$();
    var px = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var mode$1 = $m_Lreactify_Var$Mode$Normal$();
    var name$1 = $m_s_None$();
    var py = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
    var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return false
    }));
    var mode$2 = $m_Lreactify_Var$Mode$Normal$();
    var name$2 = $m_s_None$();
    var o = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$2, mode$2, name$2);
    var this$11 = this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().enter__Lreactify_Channel();
    var f = new $c_Lio_youi_event_EventSupport$pointer$$anonfun$4().init___Lio_youi_event_EventSupport$pointer$__Lreactify_Var(this, o);
    this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().enter__Lreactify_Channel();
    var priority = $m_Lreactify_Priority$().Normal$1;
    $s_Lreactify_Reactive$class__on__Lreactify_Reactive__F0__D__Lreactify_reaction_Reaction(this$11, f, priority);
    var this$13 = this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().exit__Lreactify_Channel();
    var f$1 = new $c_Lio_youi_event_EventSupport$pointer$$anonfun$5().init___Lio_youi_event_EventSupport$pointer$__Lreactify_Var(this, o);
    this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().exit__Lreactify_Channel();
    var priority$1 = $m_Lreactify_Priority$().Normal$1;
    $s_Lreactify_Reactive$class__on__Lreactify_Reactive__F0__D__Lreactify_reaction_Reaction(this$13, f$1, priority$1);
    var this$15 = this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().move__Lreactify_Channel();
    var f$2 = new $c_Lio_youi_event_EventSupport$pointer$$anonfun$7().init___Lio_youi_event_EventSupport$pointer$__Lreactify_Var__Lreactify_Var(this, px, py);
    this.$$outer$1.pointer__Lio_youi_event_EventSupport$pointer$().move__Lreactify_Channel();
    var priority$2 = $m_Lreactify_Priority$().Normal$1;
    $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$15, f$2, priority$2);
    var jsx$1;
    var jsx$1 = new $c_T3().init___O__O__O(px, py, o);
    this.x$1$1 = jsx$1;
    this.bitmap$0$1 = (128 | this.bitmap$0$1)
  };
  return this.x$1$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.enter$lzycompute__p1__Lreactify_Channel = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.enter$1 = this.$$outer$1.pointerChannel__Lio_youi_event_PointerEvent$Type__Lreactify_Channel($m_Lio_youi_event_PointerEvent$Type$Enter$());
    this.bitmap$0$1 = (2 | this.bitmap$0$1)
  };
  return this.enter$1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.x$1__p1__T3 = (function() {
  return (((128 & this.bitmap$0$1) === 0) ? this.x$1$lzycompute__p1__T3() : this.x$1$1)
});
var $d_Lio_youi_event_EventSupport$pointer$ = new $TypeData().initClass({
  Lio_youi_event_EventSupport$pointer$: 0
}, false, "io.youi.event.EventSupport$pointer$", {
  Lio_youi_event_EventSupport$pointer$: 1,
  O: 1
});
$c_Lio_youi_event_EventSupport$pointer$.prototype.$classData = $d_Lio_youi_event_EventSupport$pointer$;
/** @constructor */
function $c_Lio_youi_event_HTMLEvents$() {
  $c_O.call(this);
  this.hasPointerSupport$1 = false;
  this.hasTouchSupport$1 = false;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_event_HTMLEvents$.prototype = new $h_O();
$c_Lio_youi_event_HTMLEvents$.prototype.constructor = $c_Lio_youi_event_HTMLEvents$;
/** @constructor */
function $h_Lio_youi_event_HTMLEvents$() {
  /*<skip>*/
}
$h_Lio_youi_event_HTMLEvents$.prototype = $c_Lio_youi_event_HTMLEvents$.prototype;
$c_Lio_youi_event_HTMLEvents$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_event_HTMLEvents$.prototype.hasPointerSupport$lzycompute__p1__Z = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.hasPointerSupport$1 = ($as_T((typeof $g.PointerEvent)) !== "undefined");
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.hasPointerSupport$1
});
$c_Lio_youi_event_HTMLEvents$.prototype.hasPointerSupport__Z = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.hasPointerSupport$lzycompute__p1__Z() : this.hasPointerSupport$1)
});
var $d_Lio_youi_event_HTMLEvents$ = new $TypeData().initClass({
  Lio_youi_event_HTMLEvents$: 0
}, false, "io.youi.event.HTMLEvents$", {
  Lio_youi_event_HTMLEvents$: 1,
  O: 1
});
$c_Lio_youi_event_HTMLEvents$.prototype.$classData = $d_Lio_youi_event_HTMLEvents$;
var $n_Lio_youi_event_HTMLEvents$ = (void 0);
function $m_Lio_youi_event_HTMLEvents$() {
  if ((!$n_Lio_youi_event_HTMLEvents$)) {
    $n_Lio_youi_event_HTMLEvents$ = new $c_Lio_youi_event_HTMLEvents$().init___()
  };
  return $n_Lio_youi_event_HTMLEvents$
}
/** @constructor */
function $c_Lio_youi_event_PointerEvent$Type() {
  $c_O.call(this);
  this.type$1 = null;
  this.includePrefix$1 = false;
  this.htmlTypeString$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_event_PointerEvent$Type.prototype = new $h_O();
$c_Lio_youi_event_PointerEvent$Type.prototype.constructor = $c_Lio_youi_event_PointerEvent$Type;
/** @constructor */
function $h_Lio_youi_event_PointerEvent$Type() {
  /*<skip>*/
}
$h_Lio_youi_event_PointerEvent$Type.prototype = $c_Lio_youi_event_PointerEvent$Type.prototype;
$c_Lio_youi_event_PointerEvent$Type.prototype.htmlTypeString__T = (function() {
  return ((!this.bitmap$0$1) ? this.htmlTypeString$lzycompute__p1__T() : this.htmlTypeString$1)
});
$c_Lio_youi_event_PointerEvent$Type.prototype.htmlType__Lio_youi_event_HTMLEventType = (function() {
  var x1 = this.htmlTypeString__T();
  return ((($uI(x1.length) >= 0) && ($as_T(x1.substring(0, $uI("pointer".length))) === "pointer")) ? $m_Lio_youi_event_HTMLEventType$Pointer$() : ((($uI(x1.length) >= 0) && ($as_T(x1.substring(0, $uI("touch".length))) === "touch")) ? $m_Lio_youi_event_HTMLEventType$Touch$() : $m_Lio_youi_event_HTMLEventType$Mouse$()))
});
$c_Lio_youi_event_PointerEvent$Type.prototype.htmlTypeString$lzycompute__p1__T = (function() {
  if ((!this.bitmap$0$1)) {
    if (this.includePrefix$1) {
      var prefix = ($m_Lio_youi_event_HTMLEvents$().hasPointerSupport__Z() ? "pointer" : "mouse");
      var array = ["", "", ""];
      var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
      var array$1 = [prefix, this.type$1];
      var jsx$1 = jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
    } else {
      var jsx$1 = this.type$1
    };
    this.htmlTypeString$1 = jsx$1;
    this.bitmap$0$1 = true
  };
  return this.htmlTypeString$1
});
$c_Lio_youi_event_PointerEvent$Type.prototype.init___T__Z = (function(type, includePrefix) {
  this.type$1 = type;
  this.includePrefix$1 = includePrefix;
  return this
});
/** @constructor */
function $c_Lio_youi_example_ClientExampleApplication$colors$blue$() {
  $c_O.call(this);
  this.dark$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.light$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype = new $h_O();
$c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype.constructor = $c_Lio_youi_example_ClientExampleApplication$colors$blue$;
/** @constructor */
function $h_Lio_youi_example_ClientExampleApplication$colors$blue$() {
  /*<skip>*/
}
$h_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype = $c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype;
$c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype.init___ = (function() {
  $n_Lio_youi_example_ClientExampleApplication$colors$blue$ = this;
  this.dark$1 = ($m_Lio_youi_Color$(), new $c_sjsr_RuntimeLong().init___I__I(375494399, 0));
  this.light$1 = ($m_Lio_youi_Color$(), new $c_sjsr_RuntimeLong().init___I__I(1672801791, 0));
  return this
});
var $d_Lio_youi_example_ClientExampleApplication$colors$blue$ = new $TypeData().initClass({
  Lio_youi_example_ClientExampleApplication$colors$blue$: 0
}, false, "io.youi.example.ClientExampleApplication$colors$blue$", {
  Lio_youi_example_ClientExampleApplication$colors$blue$: 1,
  O: 1
});
$c_Lio_youi_example_ClientExampleApplication$colors$blue$.prototype.$classData = $d_Lio_youi_example_ClientExampleApplication$colors$blue$;
var $n_Lio_youi_example_ClientExampleApplication$colors$blue$ = (void 0);
function $m_Lio_youi_example_ClientExampleApplication$colors$blue$() {
  if ((!$n_Lio_youi_example_ClientExampleApplication$colors$blue$)) {
    $n_Lio_youi_example_ClientExampleApplication$colors$blue$ = new $c_Lio_youi_example_ClientExampleApplication$colors$blue$().init___()
  };
  return $n_Lio_youi_example_ClientExampleApplication$colors$blue$
}
/** @constructor */
function $c_Lio_youi_example_screen_BootstrapComponent() {
  $c_O.call(this);
  this.element$1 = null
}
$c_Lio_youi_example_screen_BootstrapComponent.prototype = new $h_O();
$c_Lio_youi_example_screen_BootstrapComponent.prototype.constructor = $c_Lio_youi_example_screen_BootstrapComponent;
/** @constructor */
function $h_Lio_youi_example_screen_BootstrapComponent() {
  /*<skip>*/
}
$h_Lio_youi_example_screen_BootstrapComponent.prototype = $c_Lio_youi_example_screen_BootstrapComponent.prototype;
$c_Lio_youi_example_screen_BootstrapComponent.prototype.content__T__Lio_youi_example_screen_BootstrapComponent = (function(value) {
  this.element$1.innerHTML = value;
  return this
});
$c_Lio_youi_example_screen_BootstrapComponent.prototype.init___Lorg_scalajs_dom_raw_HTMLElement = (function(element) {
  this.element$1 = element;
  return this
});
/** @constructor */
function $c_Lio_youi_example_screen_UIExampleScreen$() {
  $c_O.call(this);
  this.header$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_example_screen_UIExampleScreen$.prototype = new $h_O();
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.constructor = $c_Lio_youi_example_screen_UIExampleScreen$;
/** @constructor */
function $h_Lio_youi_example_screen_UIExampleScreen$() {
  /*<skip>*/
}
$h_Lio_youi_example_screen_UIExampleScreen$.prototype = $c_Lio_youi_example_screen_UIExampleScreen$.prototype;
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.header$lzycompute__p1__Lio_youi_example_ui_component_Header = (function() {
  if ((!this.bitmap$0$1)) {
    var h = new $c_Lio_youi_example_ui_component_Header().init___();
    var v = $m_Lio_youi_ui$().children__Lreactify_Var();
    new $c_Lreactify_package$VectorVar().init___Lreactify_Var(v).$$plus$eq__O__V(h);
    this.header$1 = h;
    this.bitmap$0$1 = true
  };
  return this.header$1
});
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.header__Lio_youi_example_ui_component_Header = (function() {
  return ((!this.bitmap$0$1) ? this.header$lzycompute__p1__Lio_youi_example_ui_component_Header() : this.header$1)
});
var $d_Lio_youi_example_screen_UIExampleScreen$ = new $TypeData().initClass({
  Lio_youi_example_screen_UIExampleScreen$: 0
}, false, "io.youi.example.screen.UIExampleScreen$", {
  Lio_youi_example_screen_UIExampleScreen$: 1,
  O: 1
});
$c_Lio_youi_example_screen_UIExampleScreen$.prototype.$classData = $d_Lio_youi_example_screen_UIExampleScreen$;
var $n_Lio_youi_example_screen_UIExampleScreen$ = (void 0);
function $m_Lio_youi_example_screen_UIExampleScreen$() {
  if ((!$n_Lio_youi_example_screen_UIExampleScreen$)) {
    $n_Lio_youi_example_screen_UIExampleScreen$ = new $c_Lio_youi_example_screen_UIExampleScreen$().init___()
  };
  return $n_Lio_youi_example_screen_UIExampleScreen$
}
/** @constructor */
function $c_Lio_youi_example_screen_bootstrap$() {
  $c_O.call(this)
}
$c_Lio_youi_example_screen_bootstrap$.prototype = new $h_O();
$c_Lio_youi_example_screen_bootstrap$.prototype.constructor = $c_Lio_youi_example_screen_bootstrap$;
/** @constructor */
function $h_Lio_youi_example_screen_bootstrap$() {
  /*<skip>*/
}
$h_Lio_youi_example_screen_bootstrap$.prototype = $c_Lio_youi_example_screen_bootstrap$.prototype;
$c_Lio_youi_example_screen_bootstrap$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_example_screen_bootstrap$.prototype.button__Lio_youi_example_screen_Button = (function() {
  var b = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("button");
  b.classList.add("btn");
  b.classList.add("btn-primary");
  return new $c_Lio_youi_example_screen_Button().init___Lorg_scalajs_dom_raw_HTMLButtonElement(b)
});
var $d_Lio_youi_example_screen_bootstrap$ = new $TypeData().initClass({
  Lio_youi_example_screen_bootstrap$: 0
}, false, "io.youi.example.screen.bootstrap$", {
  Lio_youi_example_screen_bootstrap$: 1,
  O: 1
});
$c_Lio_youi_example_screen_bootstrap$.prototype.$classData = $d_Lio_youi_example_screen_bootstrap$;
var $n_Lio_youi_example_screen_bootstrap$ = (void 0);
function $m_Lio_youi_example_screen_bootstrap$() {
  if ((!$n_Lio_youi_example_screen_bootstrap$)) {
    $n_Lio_youi_example_screen_bootstrap$ = new $c_Lio_youi_example_screen_bootstrap$().init___()
  };
  return $n_Lio_youi_example_screen_bootstrap$
}
/** @constructor */
function $c_Lio_youi_example_ui_GridLayoutExample$Box$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype = new $h_O();
$c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype.constructor = $c_Lio_youi_example_ui_GridLayoutExample$Box$;
/** @constructor */
function $h_Lio_youi_example_ui_GridLayoutExample$Box$() {
  /*<skip>*/
}
$h_Lio_youi_example_ui_GridLayoutExample$Box$.prototype = $c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype;
$c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype.init___Lio_youi_example_ui_GridLayoutExample = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_example_ui_GridLayoutExample$Box$ = new $TypeData().initClass({
  Lio_youi_example_ui_GridLayoutExample$Box$: 0
}, false, "io.youi.example.ui.GridLayoutExample$Box$", {
  Lio_youi_example_ui_GridLayoutExample$Box$: 1,
  O: 1
});
$c_Lio_youi_example_ui_GridLayoutExample$Box$.prototype.$classData = $d_Lio_youi_example_ui_GridLayoutExample$Box$;
/** @constructor */
function $c_Lio_youi_example_ui_SnapExample$Box$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_example_ui_SnapExample$Box$.prototype = new $h_O();
$c_Lio_youi_example_ui_SnapExample$Box$.prototype.constructor = $c_Lio_youi_example_ui_SnapExample$Box$;
/** @constructor */
function $h_Lio_youi_example_ui_SnapExample$Box$() {
  /*<skip>*/
}
$h_Lio_youi_example_ui_SnapExample$Box$.prototype = $c_Lio_youi_example_ui_SnapExample$Box$.prototype;
$c_Lio_youi_example_ui_SnapExample$Box$.prototype.init___Lio_youi_example_ui_SnapExample = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_example_ui_SnapExample$Box$ = new $TypeData().initClass({
  Lio_youi_example_ui_SnapExample$Box$: 0
}, false, "io.youi.example.ui.SnapExample$Box$", {
  Lio_youi_example_ui_SnapExample$Box$: 1,
  O: 1
});
$c_Lio_youi_example_ui_SnapExample$Box$.prototype.$classData = $d_Lio_youi_example_ui_SnapExample$Box$;
/** @constructor */
function $c_Lio_youi_example_ui_VerticalLayoutExample$Box$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype = new $h_O();
$c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype.constructor = $c_Lio_youi_example_ui_VerticalLayoutExample$Box$;
/** @constructor */
function $h_Lio_youi_example_ui_VerticalLayoutExample$Box$() {
  /*<skip>*/
}
$h_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype = $c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype;
$c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype.init___Lio_youi_example_ui_VerticalLayoutExample = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_example_ui_VerticalLayoutExample$Box$ = new $TypeData().initClass({
  Lio_youi_example_ui_VerticalLayoutExample$Box$: 0
}, false, "io.youi.example.ui.VerticalLayoutExample$Box$", {
  Lio_youi_example_ui_VerticalLayoutExample$Box$: 1,
  O: 1
});
$c_Lio_youi_example_ui_VerticalLayoutExample$Box$.prototype.$classData = $d_Lio_youi_example_ui_VerticalLayoutExample$Box$;
/** @constructor */
function $c_Lio_youi_font_GoogleFont$() {
  $c_O.call(this);
  this.io$youi$font$GoogleFont$$base$1 = null
}
$c_Lio_youi_font_GoogleFont$.prototype = new $h_O();
$c_Lio_youi_font_GoogleFont$.prototype.constructor = $c_Lio_youi_font_GoogleFont$;
/** @constructor */
function $h_Lio_youi_font_GoogleFont$() {
  /*<skip>*/
}
$h_Lio_youi_font_GoogleFont$.prototype = $c_Lio_youi_font_GoogleFont$.prototype;
$c_Lio_youi_font_GoogleFont$.prototype.init___ = (function() {
  $n_Lio_youi_font_GoogleFont$ = this;
  var array = ["https://fonts.gstatic.com/s"];
  this.io$youi$font$GoogleFont$$base$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array)).s__sc_Seq__T($m_sci_Nil$());
  return this
});
var $d_Lio_youi_font_GoogleFont$ = new $TypeData().initClass({
  Lio_youi_font_GoogleFont$: 0
}, false, "io.youi.font.GoogleFont$", {
  Lio_youi_font_GoogleFont$: 1,
  O: 1
});
$c_Lio_youi_font_GoogleFont$.prototype.$classData = $d_Lio_youi_font_GoogleFont$;
var $n_Lio_youi_font_GoogleFont$ = (void 0);
function $m_Lio_youi_font_GoogleFont$() {
  if ((!$n_Lio_youi_font_GoogleFont$)) {
    $n_Lio_youi_font_GoogleFont$ = new $c_Lio_youi_font_GoogleFont$().init___()
  };
  return $n_Lio_youi_font_GoogleFont$
}
/** @constructor */
function $c_Lio_youi_http_Connection() {
  $c_O.call(this);
  this.$$undconnected$1 = null;
  this.connected$1 = null;
  this.send$1 = null;
  this.receive$1 = null;
  this.error$1 = null;
  this.store$1 = null;
  this.io$youi$http$Connection$$backlog$1 = null
}
$c_Lio_youi_http_Connection.prototype = new $h_O();
$c_Lio_youi_http_Connection.prototype.constructor = $c_Lio_youi_http_Connection;
/** @constructor */
function $h_Lio_youi_http_Connection() {
  /*<skip>*/
}
$h_Lio_youi_http_Connection.prototype = $c_Lio_youi_http_Connection.prototype;
$c_Lio_youi_http_Connection.prototype.init___ = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return false
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.$$undconnected$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var v = arg$outer.$$undconnected$1;
      return $uZ(v.state__Lreactify_State().value__O())
    })
  })(this));
  var name$1 = $m_s_None$();
  this.connected$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$1);
  this.send$1 = new $c_Lio_youi_http_WebSocketChannels().init___();
  this.receive$1 = new $c_Lio_youi_http_WebSocketChannels().init___();
  this.error$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  this.store$1 = new $c_Lio_youi_MapStore().init___sci_Map($m_sci_Map$EmptyMap$());
  $m_scm_ListBuffer$();
  var this$11 = new $c_scm_GrowingBuilder().init___scg_Growable(new $c_scm_ListBuffer().init___());
  this.io$youi$http$Connection$$backlog$1 = $as_scm_ListBuffer($as_sc_GenTraversable(this$11.elems$1));
  this.init__p1__V();
  return this
});
$c_Lio_youi_http_Connection.prototype.init__p1__V = (function() {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(t$2) {
      var t = $as_T(t$2);
      $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V(arg$outer, t)
    })
  })(this));
  var priority = $m_Lreactify_Priority$().Normal$1;
  var textReaction = new $c_Lreactify_reaction_FunctionReaction().init___F1__D(f, priority);
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer$1) {
    return (function(b$2) {
      var b = $asArrayOf_Ljava_nio_ByteBuffer(b$2, 1);
      $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V(arg$outer$1, b)
    })
  })(this));
  var priority$1 = $m_Lreactify_Priority$().Normal$1;
  var binaryReaction = new $c_Lreactify_reaction_FunctionReaction().init___F1__D(f$1, priority$1);
  this.send$1.text$1.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(textReaction);
  this.send$1.binary$1.reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(binaryReaction);
  var this$6 = this.send$1.text$1;
  var f$2 = new $c_Lio_youi_http_Connection$$anonfun$init$3().init___Lio_youi_http_Connection(this);
  var priority$2 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$6, f$2, priority$2);
  var this$8 = this.receive$1.text$1;
  var f$3 = new $c_Lio_youi_http_Connection$$anonfun$init$4().init___Lio_youi_http_Connection(this);
  var priority$3 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$8, f$3, priority$3);
  var this$10 = this.send$1.close$1;
  var f$4 = new $c_Lio_youi_http_Connection$$anonfun$init$1().init___Lio_youi_http_Connection(this);
  var priority$4 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__on__Lreactify_Reactive__F0__D__Lreactify_reaction_Reaction(this$10, f$4, priority$4);
  var this$12 = this.receive$1.close$1;
  var f$5 = new $c_Lio_youi_http_Connection$$anonfun$init$2().init___Lio_youi_http_Connection(this);
  var priority$5 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__on__Lreactify_Reactive__F0__D__Lreactify_reaction_Reaction(this$12, f$5, priority$5);
  var this$14 = this.connected$1;
  var f$6 = new $c_Lio_youi_http_Connection$$anonfun$init$5().init___Lio_youi_http_Connection__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(this, textReaction, binaryReaction);
  var priority$6 = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$14, f$6, priority$6)
});
$c_Lio_youi_http_Connection.prototype.close__V = (function() {
  var this$1 = this.connected$1;
  if ($uZ(this$1.state__Lreactify_State().value__O())) {
    var this$2 = this.send$1.close$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return (void 0)
    }));
    this$2.set__F0__V(value);
    var this$3 = this.$$undconnected$1;
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return false
    }));
    this$3.set__F0__V(value$1)
  }
});
function $is_Lio_youi_http_Connection(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_http_Connection)))
}
function $as_Lio_youi_http_Connection(obj) {
  return (($is_Lio_youi_http_Connection(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.http.Connection"))
}
function $isArrayOf_Lio_youi_http_Connection(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_http_Connection)))
}
function $asArrayOf_Lio_youi_http_Connection(obj, depth) {
  return (($isArrayOf_Lio_youi_http_Connection(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.http.Connection;", depth))
}
var $d_Lio_youi_http_Connection = new $TypeData().initClass({
  Lio_youi_http_Connection: 0
}, false, "io.youi.http.Connection", {
  Lio_youi_http_Connection: 1,
  O: 1
});
$c_Lio_youi_http_Connection.prototype.$classData = $d_Lio_youi_http_Connection;
/** @constructor */
function $c_Lio_youi_http_Connection$() {
  $c_O.call(this);
  this.debug$1 = false;
  this.key$1 = null
}
$c_Lio_youi_http_Connection$.prototype = new $h_O();
$c_Lio_youi_http_Connection$.prototype.constructor = $c_Lio_youi_http_Connection$;
/** @constructor */
function $h_Lio_youi_http_Connection$() {
  /*<skip>*/
}
$h_Lio_youi_http_Connection$.prototype = $c_Lio_youi_http_Connection$.prototype;
$c_Lio_youi_http_Connection$.prototype.init___ = (function() {
  this.debug$1 = false;
  this.key$1 = "webSocketConnection";
  return this
});
$c_Lio_youi_http_Connection$.prototype.backlog__Lio_youi_http_Connection__O__V = (function(listener, message) {
  if ((listener === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  listener.io$youi$http$Connection$$backlog$1.$$plus$eq__O__scm_ListBuffer(message)
});
var $d_Lio_youi_http_Connection$ = new $TypeData().initClass({
  Lio_youi_http_Connection$: 0
}, false, "io.youi.http.Connection$", {
  Lio_youi_http_Connection$: 1,
  O: 1
});
$c_Lio_youi_http_Connection$.prototype.$classData = $d_Lio_youi_http_Connection$;
var $n_Lio_youi_http_Connection$ = (void 0);
function $m_Lio_youi_http_Connection$() {
  if ((!$n_Lio_youi_http_Connection$)) {
    $n_Lio_youi_http_Connection$ = new $c_Lio_youi_http_Connection$().init___()
  };
  return $n_Lio_youi_http_Connection$
}
/** @constructor */
function $c_Lio_youi_http_WebSocketChannels() {
  $c_O.call(this);
  this.text$1 = null;
  this.binary$1 = null;
  this.close$1 = null
}
$c_Lio_youi_http_WebSocketChannels.prototype = new $h_O();
$c_Lio_youi_http_WebSocketChannels.prototype.constructor = $c_Lio_youi_http_WebSocketChannels;
/** @constructor */
function $h_Lio_youi_http_WebSocketChannels() {
  /*<skip>*/
}
$h_Lio_youi_http_WebSocketChannels.prototype = $c_Lio_youi_http_WebSocketChannels.prototype;
$c_Lio_youi_http_WebSocketChannels.prototype.init___ = (function() {
  this.text$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  this.binary$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  this.close$1 = new $c_Lreactify_standard_StandardChannel().init___s_Option($m_s_None$());
  return this
});
var $d_Lio_youi_http_WebSocketChannels = new $TypeData().initClass({
  Lio_youi_http_WebSocketChannels: 0
}, false, "io.youi.http.WebSocketChannels", {
  Lio_youi_http_WebSocketChannels: 1,
  O: 1
});
$c_Lio_youi_http_WebSocketChannels.prototype.$classData = $d_Lio_youi_http_WebSocketChannels;
/** @constructor */
function $c_Lio_youi_http_WebSocketUtil$() {
  $c_O.call(this)
}
$c_Lio_youi_http_WebSocketUtil$.prototype = new $h_O();
$c_Lio_youi_http_WebSocketUtil$.prototype.constructor = $c_Lio_youi_http_WebSocketUtil$;
/** @constructor */
function $h_Lio_youi_http_WebSocketUtil$() {
  /*<skip>*/
}
$h_Lio_youi_http_WebSocketUtil$.prototype = $c_Lio_youi_http_WebSocketUtil$.prototype;
$c_Lio_youi_http_WebSocketUtil$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_http_WebSocketUtil$.prototype.connect__Lio_youi_net_URL__Lio_youi_http_Connection__Lorg_scalajs_dom_raw_WebSocket = (function(socketURL, listener) {
  var ws = new $g.WebSocket(socketURL.encoded__Lio_youi_net_URL$URLParts().asString__T());
  var this$2 = listener.send$1.text$1;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(listener$1, ws$1) {
    return (function(message$2) {
      var message = $as_T(message$2);
      if (($uI(ws$1.readyState) >= $uI($m_Lorg_scalajs_dom_package$().WebSocket__Lorg_scalajs_dom_raw_WebSocket$().CLOSING))) {
        listener$1.close__V();
        $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V(listener$1, message)
      } else if (($uI(ws$1.readyState) === $uI($m_Lorg_scalajs_dom_package$().WebSocket__Lorg_scalajs_dom_raw_WebSocket$().OPEN))) {
        ws$1.send(message)
      } else {
        $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V(listener$1, message)
      }
    })
  })(listener, ws));
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__attach__Lreactify_Reactive__F1__D__Lreactify_reaction_Reaction(this$2, f, priority);
  ws.onopen = (function(f$1) {
    return (function(arg1) {
      return f$1.apply__O__O(arg1)
    })
  })(new $c_Lio_youi_http_WebSocketUtil$$anonfun$connect$2().init___Lio_youi_http_Connection(listener));
  ws.onerror = (function(f$2) {
    return (function(arg1$1) {
      return f$2.apply__O__O(arg1$1)
    })
  })(new $c_Lio_youi_http_WebSocketUtil$$anonfun$connect$3().init___Lio_youi_http_Connection(listener));
  ws.onclose = (function(listener$1$1) {
    return (function(evt$2) {
      listener$1$1.close__V()
    })
  })(listener);
  ws.onmessage = (function(f$3) {
    return (function(arg1$2) {
      return f$3.apply__O__O(arg1$2)
    })
  })(new $c_Lio_youi_http_WebSocketUtil$$anonfun$connect$5().init___Lio_youi_http_Connection(listener));
  return ws
});
var $d_Lio_youi_http_WebSocketUtil$ = new $TypeData().initClass({
  Lio_youi_http_WebSocketUtil$: 0
}, false, "io.youi.http.WebSocketUtil$", {
  Lio_youi_http_WebSocketUtil$: 1,
  O: 1
});
$c_Lio_youi_http_WebSocketUtil$.prototype.$classData = $d_Lio_youi_http_WebSocketUtil$;
var $n_Lio_youi_http_WebSocketUtil$ = (void 0);
function $m_Lio_youi_http_WebSocketUtil$() {
  if ((!$n_Lio_youi_http_WebSocketUtil$)) {
    $n_Lio_youi_http_WebSocketUtil$ = new $c_Lio_youi_http_WebSocketUtil$().init___()
  };
  return $n_Lio_youi_http_WebSocketUtil$
}
/** @constructor */
function $c_Lio_youi_image_HTMLImage$() {
  $c_O.call(this)
}
$c_Lio_youi_image_HTMLImage$.prototype = new $h_O();
$c_Lio_youi_image_HTMLImage$.prototype.constructor = $c_Lio_youi_image_HTMLImage$;
/** @constructor */
function $h_Lio_youi_image_HTMLImage$() {
  /*<skip>*/
}
$h_Lio_youi_image_HTMLImage$.prototype = $c_Lio_youi_image_HTMLImage$.prototype;
$c_Lio_youi_image_HTMLImage$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_image_HTMLImage$.prototype.apply__Lorg_scalajs_dom_raw_HTMLImageElement__s_concurrent_Future = (function(img) {
  if ((($uI(img.width) > 0) && ($uI(img.height) > 0))) {
    return $m_s_concurrent_Future$().successful__O__s_concurrent_Future(new $c_Lio_youi_image_HTMLImage().init___Lorg_scalajs_dom_raw_HTMLImageElement(img))
  } else {
    var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
    var listener = (function(img$1, promise$1) {
      return (function(x$1$2) {
        var value = new $c_Lio_youi_image_HTMLImage().init___Lorg_scalajs_dom_raw_HTMLImageElement(img$1);
        return $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(promise$1, value)
      })
    })(img, promise);
    img.addEventListener("load", listener);
    promise.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(img$1$1, listener$1) {
      return (function(x$2$2) {
        $as_s_util_Try(x$2$2);
        img$1$1.removeEventListener("load", listener$1)
      })
    })(img, listener)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor());
    return promise
  }
});
$c_Lio_youi_image_HTMLImage$.prototype.apply__Lio_youi_net_URL__s_concurrent_Future = (function(url) {
  var img = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("img");
  img.src = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
  return this.apply__Lorg_scalajs_dom_raw_HTMLImageElement__s_concurrent_Future(img)
});
var $d_Lio_youi_image_HTMLImage$ = new $TypeData().initClass({
  Lio_youi_image_HTMLImage$: 0
}, false, "io.youi.image.HTMLImage$", {
  Lio_youi_image_HTMLImage$: 1,
  O: 1
});
$c_Lio_youi_image_HTMLImage$.prototype.$classData = $d_Lio_youi_image_HTMLImage$;
var $n_Lio_youi_image_HTMLImage$ = (void 0);
function $m_Lio_youi_image_HTMLImage$() {
  if ((!$n_Lio_youi_image_HTMLImage$)) {
    $n_Lio_youi_image_HTMLImage$ = new $c_Lio_youi_image_HTMLImage$().init___()
  };
  return $n_Lio_youi_image_HTMLImage$
}
/** @constructor */
function $c_Lio_youi_image_Image$() {
  $c_O.call(this)
}
$c_Lio_youi_image_Image$.prototype = new $h_O();
$c_Lio_youi_image_Image$.prototype.constructor = $c_Lio_youi_image_Image$;
/** @constructor */
function $h_Lio_youi_image_Image$() {
  /*<skip>*/
}
$h_Lio_youi_image_Image$.prototype = $c_Lio_youi_image_Image$.prototype;
$c_Lio_youi_image_Image$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_image_Image$.prototype.apply__Lio_youi_net_URL__s_concurrent_Future = (function(url) {
  var jsx$1 = $m_sjsr_RuntimeString$();
  var thiz = url.path$1.encoded__T();
  if (jsx$1.endsWith__T__T__Z($as_T(thiz.toLowerCase()), ".svg")) {
    return $m_Lio_youi_image_SVGImage$().apply__Lio_youi_net_URL__s_concurrent_Future(url)
  } else {
    return $m_Lio_youi_image_HTMLImage$().apply__Lio_youi_net_URL__s_concurrent_Future(url)
  }
});
$c_Lio_youi_image_Image$.prototype.apply__T__s_concurrent_Future = (function(source) {
  if (($uI(source.indexOf("<svg")) !== (-1))) {
    return $m_Lio_youi_image_SVGImage$().apply__T__s_concurrent_Future(source)
  } else if (((($uI(source.length) >= 0) && ($as_T(source.substring(0, $uI("data:image/".length))) === "data:image/")) || (($uI(source.length) >= 0) && ($as_T(source.substring(0, $uI("blob:".length))) === "blob:")))) {
    var img = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("img");
    img.src = source;
    return $m_Lio_youi_image_HTMLImage$().apply__Lorg_scalajs_dom_raw_HTMLImageElement__s_concurrent_Future(img)
  } else {
    var v = $m_Lio_youi_History$().url$1;
    return this.apply__Lio_youi_net_URL__s_concurrent_Future($as_Lio_youi_net_URL(v.state__Lreactify_State().value__O()).withPart__T__Lio_youi_net_URL(source))
  }
});
var $d_Lio_youi_image_Image$ = new $TypeData().initClass({
  Lio_youi_image_Image$: 0
}, false, "io.youi.image.Image$", {
  Lio_youi_image_Image$: 1,
  O: 1
});
$c_Lio_youi_image_Image$.prototype.$classData = $d_Lio_youi_image_Image$;
var $n_Lio_youi_image_Image$ = (void 0);
function $m_Lio_youi_image_Image$() {
  if ((!$n_Lio_youi_image_Image$)) {
    $n_Lio_youi_image_Image$ = new $c_Lio_youi_image_Image$().init___()
  };
  return $n_Lio_youi_image_Image$
}
/** @constructor */
function $c_Lio_youi_image_SVGImage$() {
  $c_O.call(this)
}
$c_Lio_youi_image_SVGImage$.prototype = new $h_O();
$c_Lio_youi_image_SVGImage$.prototype.constructor = $c_Lio_youi_image_SVGImage$;
/** @constructor */
function $h_Lio_youi_image_SVGImage$() {
  /*<skip>*/
}
$h_Lio_youi_image_SVGImage$.prototype = $c_Lio_youi_image_SVGImage$.prototype;
$c_Lio_youi_image_SVGImage$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_image_SVGImage$.prototype.measure__Lorg_scalajs_dom_raw_SVGSVGElement__Z__Z__Lio_youi_spatial_BoundingBox = (function(svg, applyDimension, force) {
  var viewBox = (((svg.viewBox !== null) && (svg.viewBox.animVal !== null)) ? new $c_Lio_youi_image_SVGImage$ViewBox().init___D__D($uD(svg.viewBox.animVal.width), $uD(svg.viewBox.animVal.height)) : new $c_Lio_youi_image_SVGImage$ViewBox().init___D__D(0.0, 0.0));
  var definedWidth = (($uI(svg.width.animVal.unitType) === $uI($g.SVGLength.SVG_LENGTHTYPE_NUMBER)) ? new $c_s_Some().init___O($uD(svg.width.animVal.value)) : ((viewBox.width$1 > 0.0) ? new $c_s_Some().init___O(viewBox.width$1) : $m_s_None$()));
  var definedHeight = (($uI(svg.height.animVal.unitType) === $uI($g.SVGLength.SVG_LENGTHTYPE_NUMBER)) ? new $c_s_Some().init___O($uD(svg.height.animVal.value)) : ((viewBox.height$1 > 0.0) ? new $c_s_Some().init___O(viewBox.height$1) : $m_s_None$()));
  if (((definedWidth.isEmpty__Z() || definedHeight.isEmpty__Z()) || force)) {
    var minX = new $c_sr_DoubleRef().init___D(0.0);
    var minY = new $c_sr_DoubleRef().init___D(0.0);
    var maxX = new $c_sr_DoubleRef().init___D(0.0);
    var maxY = new $c_sr_DoubleRef().init___D(0.0);
    $m_Lio_youi_dom$();
    var list = svg.children;
    var this$6 = new $c_Lio_youi_dom$$anon$1().init___Lorg_scalajs_dom_raw_DOMList(list);
    while (this$6.hasNext__Z()) {
      var arg1 = this$6.next__O();
      $m_Lio_youi_image_SVGImage$().io$youi$image$SVGImage$$measureInternal$1__Lorg_scalajs_dom_raw_Element__D__D__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__V(arg1, 0.0, 0.0, minX, minY, maxX, maxY)
    };
    $m_Lio_youi_spatial_BoundingBox$();
    var x1 = minX.elem$1;
    var y1 = minY.elem$1;
    var x2 = maxX.elem$1;
    var y2 = maxY.elem$1;
    var bb = new $c_Lio_youi_spatial_ImmutableBoundingBox().init___D__D__D__D(x1, y1, x2, y2)
  } else {
    $m_Lio_youi_spatial_BoundingBox$();
    var x2$1 = $uD(definedWidth.get__O());
    var y2$1 = $uD(definedHeight.get__O());
    var bb = new $c_Lio_youi_spatial_ImmutableBoundingBox().init___D__D__D__D(0.0, 0.0, x2$1, y2$1)
  };
  if (applyDimension) {
    var this$9 = $s_Lio_youi_spatial_BoundingBox$class__width__Lio_youi_spatial_BoundingBox__D(bb);
    svg.setAttribute("width", ("" + this$9));
    var this$11 = $s_Lio_youi_spatial_BoundingBox$class__height__Lio_youi_spatial_BoundingBox__D(bb);
    svg.setAttribute("height", ("" + this$11))
  };
  return bb
});
$c_Lio_youi_image_SVGImage$.prototype.io$youi$image$SVGImage$$measureInternal$1__Lorg_scalajs_dom_raw_Element__D__D__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__V = (function(e, offsetX, offsetY, minX$1, minY$1, maxX$1, maxY$1) {
  if ($uZ((e instanceof $g.SVGGElement))) {
    var elem$1 = 0.0;
    elem$1 = offsetX;
    var elem$1$1 = 0.0;
    elem$1$1 = offsetY;
    var end = $uI(e.transform.baseVal.numberOfItems);
    var isEmpty$4 = (end <= 0);
    var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + end) | 0));
    if ((!isEmpty$4)) {
      var i = 0;
      while (true) {
        var v1 = i;
        var transform = e.transform.baseVal.getItem(v1);
        if (($uI(transform.type) === $uI($g.SVGTransform.SVG_TRANSFORM_TRANSLATE))) {
          elem$1 = (elem$1 + $uD(transform.matrix.e));
          elem$1$1 = (elem$1$1 + $uD(transform.matrix.f))
        };
        if ((i === lastElement$4)) {
          break
        };
        i = ((1 + i) | 0)
      }
    };
    $m_Lio_youi_dom$();
    var list = e.children;
    var this$7 = new $c_Lio_youi_dom$$anon$1().init___Lorg_scalajs_dom_raw_DOMList(list);
    while (this$7.hasNext__Z()) {
      var arg1 = this$7.next__O();
      $m_Lio_youi_image_SVGImage$().io$youi$image$SVGImage$$measureInternal$1__Lorg_scalajs_dom_raw_Element__D__D__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__sr_DoubleRef__V(arg1, elem$1, elem$1$1, minX$1, minY$1, maxX$1, maxY$1)
    }
  } else if ($uZ((e instanceof $g.SVGCircleElement))) {
    var x = minX$1.elem$1;
    var y = (offsetX + ($uD(e.cx.baseVal.value) - $uD(e.r.baseVal.value)));
    minX$1.elem$1 = $uD($g.Math.min(x, y));
    var x$1 = minY$1.elem$1;
    var y$1 = (offsetY + ($uD(e.cy.baseVal.value) - $uD(e.r.baseVal.value)));
    minY$1.elem$1 = $uD($g.Math.min(x$1, y$1));
    var x$2 = maxX$1.elem$1;
    var y$2 = (offsetX + ($uD(e.cx.baseVal.value) + $uD(e.r.baseVal.value)));
    maxX$1.elem$1 = $uD($g.Math.max(x$2, y$2));
    var x$3 = maxY$1.elem$1;
    var y$3 = (offsetY + ($uD(e.cy.baseVal.value) + $uD(e.r.baseVal.value)));
    maxY$1.elem$1 = $uD($g.Math.max(x$3, y$3))
  } else if ($uZ((e instanceof $g.SVGEllipseElement))) {
    var x$4 = minX$1.elem$1;
    var y$4 = (offsetX + ($uD(e.cx.baseVal.value) - $uD(e.rx.baseVal.value)));
    minX$1.elem$1 = $uD($g.Math.min(x$4, y$4));
    var x$5 = minY$1.elem$1;
    var y$5 = (offsetY + ($uD(e.cy.baseVal.value) - $uD(e.ry.baseVal.value)));
    minY$1.elem$1 = $uD($g.Math.min(x$5, y$5));
    var x$6 = maxX$1.elem$1;
    var y$6 = (offsetX + ($uD(e.cx.baseVal.value) + $uD(e.rx.baseVal.value)));
    maxX$1.elem$1 = $uD($g.Math.max(x$6, y$6));
    var x$7 = maxY$1.elem$1;
    var y$7 = (offsetY + ($uD(e.cy.baseVal.value) + $uD(e.ry.baseVal.value)));
    maxY$1.elem$1 = $uD($g.Math.max(x$7, y$7))
  } else if ($uZ((e instanceof $g.SVGRectElement))) {
    var x$8 = minX$1.elem$1;
    var y$8 = (offsetX + $uD(e.x.baseVal.value));
    minX$1.elem$1 = $uD($g.Math.min(x$8, y$8));
    var x$9 = minY$1.elem$1;
    var y$9 = (offsetY + $uD(e.y.baseVal.value));
    minY$1.elem$1 = $uD($g.Math.min(x$9, y$9));
    var x$10 = maxX$1.elem$1;
    var y$10 = ((offsetX + $uD(e.x.baseVal.value)) + $uD(e.width.baseVal.value));
    maxX$1.elem$1 = $uD($g.Math.max(x$10, y$10));
    var x$11 = maxY$1.elem$1;
    var y$11 = ((offsetY + $uD(e.y.baseVal.value)) + $uD(e.height.baseVal.value));
    maxY$1.elem$1 = $uD($g.Math.max(x$11, y$11))
  } else if ($uZ((e instanceof $g.SVGImageElement))) {
    var x$12 = minX$1.elem$1;
    var y$12 = (offsetX + $uD(e.x.baseVal.value));
    minX$1.elem$1 = $uD($g.Math.min(x$12, y$12));
    var x$13 = minY$1.elem$1;
    var y$13 = (offsetY + $uD(e.y.baseVal.value));
    minY$1.elem$1 = $uD($g.Math.min(x$13, y$13));
    var x$14 = maxX$1.elem$1;
    var y$14 = ((offsetX + $uD(e.x.baseVal.value)) + $uD(e.width.baseVal.value));
    maxX$1.elem$1 = $uD($g.Math.max(x$14, y$14));
    var x$15 = maxY$1.elem$1;
    var y$15 = ((offsetY + $uD(e.y.baseVal.value)) + $uD(e.height.baseVal.value));
    maxY$1.elem$1 = $uD($g.Math.max(x$15, y$15))
  } else if ($uZ((e instanceof $g.SVGLinearGradientElement))) {
    var x$16 = minX$1.elem$1;
    var y$16 = (offsetX + $uD(e.x1.baseVal.value));
    minX$1.elem$1 = $uD($g.Math.min(x$16, y$16));
    var x$17 = minY$1.elem$1;
    var y$17 = (offsetY + $uD(e.y1.baseVal.value));
    minY$1.elem$1 = $uD($g.Math.min(x$17, y$17));
    var x$18 = maxX$1.elem$1;
    var y$18 = (offsetX + $uD(e.x2.baseVal.value));
    maxX$1.elem$1 = $uD($g.Math.max(x$18, y$18));
    var x$19 = maxY$1.elem$1;
    var y$19 = (offsetY + $uD(e.y2.baseVal.value));
    maxY$1.elem$1 = $uD($g.Math.max(x$19, y$19))
  } else if ($uZ((e instanceof $g.SVGPolygonElement))) {
    var end$1 = $uI(e.points.numberOfItems);
    var isEmpty$4$1 = (end$1 <= 0);
    var lastElement$4$1 = (isEmpty$4$1 ? (-1) : (((-1) + end$1) | 0));
    if ((!isEmpty$4$1)) {
      var i$1 = 0;
      while (true) {
        var v1$1 = i$1;
        var point = e.points.getItem(v1$1);
        var x$20 = minX$1.elem$1;
        var y$20 = (offsetX + $uD(point.x));
        minX$1.elem$1 = $uD($g.Math.min(x$20, y$20));
        var x$21 = minY$1.elem$1;
        var y$21 = (offsetY + $uD(point.y));
        minY$1.elem$1 = $uD($g.Math.min(x$21, y$21));
        var x$22 = maxX$1.elem$1;
        var y$22 = (offsetX + $uD(point.x));
        maxX$1.elem$1 = $uD($g.Math.max(x$22, y$22));
        var x$23 = maxY$1.elem$1;
        var y$23 = (offsetY + $uD(point.y));
        maxY$1.elem$1 = $uD($g.Math.max(x$23, y$23));
        if ((i$1 === lastElement$4$1)) {
          break
        };
        i$1 = ((1 + i$1) | 0)
      }
    }
  } else if ($uZ((e instanceof $g.SVGPathElement))) {
    var path = $m_Lio_youi_path_Path$().apply__T__Lio_youi_path_Path($as_T(e.getAttribute("d")));
    var x$24 = minX$1.elem$1;
    var y$24 = (offsetX + path.boundingBox__Lio_youi_spatial_BoundingBox().x1__D());
    minX$1.elem$1 = $uD($g.Math.min(x$24, y$24));
    var x$25 = minY$1.elem$1;
    var y$25 = (offsetY + path.boundingBox__Lio_youi_spatial_BoundingBox().y1__D());
    minY$1.elem$1 = $uD($g.Math.min(x$25, y$25));
    var x$26 = maxX$1.elem$1;
    var y$26 = (offsetX + path.boundingBox__Lio_youi_spatial_BoundingBox().x2__D());
    maxX$1.elem$1 = $uD($g.Math.max(x$26, y$26));
    var x$27 = maxY$1.elem$1;
    var y$27 = (offsetY + path.boundingBox__Lio_youi_spatial_BoundingBox().y2__D());
    maxY$1.elem$1 = $uD($g.Math.max(x$27, y$27))
  } else if ((!$uZ((e instanceof $g.SVGStyleElement)))) {
    var jsx$2 = $m_Lscribe_package$();
    var level = $m_Lscribe_Level$Warn$();
    var value = $m_Lscribe_Level$Warn$().value$1;
    var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(e$1) {
      return (function() {
        var array = ["Unsupported SVG node: ", "."];
        var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
        var array$1 = [e$1];
        return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
      })
    })(e));
    var loggable = $m_Lscribe_Loggable$StringLoggable$();
    var throwable = $m_s_None$();
    var methodName = new $c_s_Some().init___O("measureInternal");
    var line = new $c_s_Some().init___O(184);
    var column = new $c_s_Some().init___O(30);
    var thread = $m_jl_Thread$().SingleThread$1;
    var this$73 = $m_Lscribe_util_Time$();
    var t = this$73.function$1.apply$mcJ$sp__J();
    var lo = t.lo$2;
    var hi$4 = t.hi$2;
    jsx$2.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/ui/js/src/main/scala/io/youi/image/SVGImage.scala", "io.youi.image.SVGImage.bb", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi$4)))
  }
});
$c_Lio_youi_image_SVGImage$.prototype.apply__Lorg_scalajs_dom_raw_SVGSVGElement__s_concurrent_Future = (function(svg) {
  var this$1 = this.measure__Lorg_scalajs_dom_raw_SVGSVGElement__Z__Z__Lio_youi_spatial_BoundingBox(svg, true, false);
  var width = $s_Lio_youi_spatial_BoundingBox$class__width__Lio_youi_spatial_BoundingBox__D(this$1);
  var height = $s_Lio_youi_spatial_BoundingBox$class__height__Lio_youi_spatial_BoundingBox__D(this$1);
  var size = new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width, height);
  return this.apply__Lorg_scalajs_dom_raw_SVGSVGElement__D__D__s_concurrent_Future(svg, size.width$1, size.height$1)
});
$c_Lio_youi_image_SVGImage$.prototype.apply__Lio_youi_net_URL__s_concurrent_Future = (function(url) {
  var stream = $m_Lio_youi_stream_StreamURL$().stream__Lio_youi_net_URL__s_Option__I__sci_Map__Z__T__s_concurrent_Future(url, $m_s_None$(), 0, $m_sci_Map$EmptyMap$(), true, "");
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(svgString$2) {
    var svgString = $as_T(svgString$2);
    return $m_Lio_youi_image_SVGImage$().apply__T__s_concurrent_Future(svgString)
  }));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(stream, f, executor)
});
$c_Lio_youi_image_SVGImage$.prototype.apply__Lorg_scalajs_dom_raw_SVGSVGElement__D__D__s_concurrent_Future = (function(svg, width, height) {
  var this$1 = this.measure__Lorg_scalajs_dom_raw_SVGSVGElement__Z__Z__Lio_youi_spatial_BoundingBox(svg, true, false);
  var width$1 = $s_Lio_youi_spatial_BoundingBox$class__width__Lio_youi_spatial_BoundingBox__D(this$1);
  var height$1 = $s_Lio_youi_spatial_BoundingBox$class__height__Lio_youi_spatial_BoundingBox__D(this$1);
  var size = new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width$1, height$1);
  var canvas = $m_Lio_youi_util_CanvasPool$().apply__D__D__D__Lorg_scalajs_dom_raw_HTMLCanvasElement(width, height, ($m_Lio_youi_util_CanvasPool$(), 1.0));
  var this$3 = this.drawToCanvas__Lorg_scalajs_dom_raw_HTMLCanvasElement__Lorg_scalajs_dom_raw_SVGSVGElement__D__D__D__D__s_concurrent_Future(canvas, svg, 0.0, 0.0, width, height);
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(svg$1, size$1, canvas$2) {
    return (function(x$4$2) {
      $asUnit(x$4$2);
      return new $c_Lio_youi_image_SVGImage().init___Lorg_scalajs_dom_raw_SVGSVGElement__Lorg_scalajs_dom_raw_HTMLCanvasElement__Lio_youi_spatial_Size(svg$1, canvas$2, size$1)
    })
  })(svg, size, canvas));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$3, f, executor)
});
$c_Lio_youi_image_SVGImage$.prototype.drawToCanvas__Lorg_scalajs_dom_raw_HTMLCanvasElement__Lorg_scalajs_dom_raw_SVGSVGElement__D__D__D__D__s_concurrent_Future = (function(canvas, svg, x, y, width, height) {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var callback = (function(promise$1) {
    return (function() {
      return $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(promise$1, (void 0))
    })
  })(promise);
  var jsx$2 = $g;
  var jsx$1 = $as_T(svg.outerHTML);
  var $this = {};
  $this.ignoreMouse = true;
  $this.ignoreAnimation = true;
  $this.ignoreDimensions = true;
  $this.ignoreClear = true;
  var this$11 = $m_sjsr_RuntimeLong$();
  var value = $uD($g.Math.round(x));
  var lo = this$11.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I(value);
  $this.offsetX = lo;
  var this$15 = $m_sjsr_RuntimeLong$();
  var value$1 = $uD($g.Math.round(y));
  var lo$1 = this$15.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I(value$1);
  $this.offsetY = lo$1;
  var value$2 = $doubleToInt($uD($g.Math.ceil(width)));
  $this.scaleWidth = value$2;
  var value$3 = $doubleToInt($uD($g.Math.ceil(height)));
  $this.scaleHeight = value$3;
  $this.renderCallback = callback;
  jsx$2.canvg(canvas, jsx$1, $this);
  return promise
});
$c_Lio_youi_image_SVGImage$.prototype.apply__T__s_concurrent_Future = (function(svgString) {
  try {
    var div = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("div");
    div.innerHTML = svgString;
    $m_Lio_youi_dom$();
    var this$2 = new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(div);
    var svg = this$2.oneBySelector__T__Lorg_scalajs_dom_raw_Element("svg");
    return this.apply__Lorg_scalajs_dom_raw_SVGSVGElement__s_concurrent_Future(svg)
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      var jsx$1 = $m_Lscribe_package$();
      var level = $m_Lscribe_Level$Error$();
      var value = $m_Lscribe_Level$Error$().value$1;
      var messageFunction = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(t$1) {
        return (function() {
          return t$1
        })
      })(e$2));
      var loggable = $m_Lscribe_Loggable$ThrowableLoggable$();
      var throwable = $m_s_None$();
      var methodName = new $c_s_Some().init___O("apply");
      var line = new $c_s_Some().init___O(61);
      var column = new $c_s_Some().init___O(19);
      var thread = $m_jl_Thread$().SingleThread$1;
      var this$5 = $m_Lscribe_util_Time$();
      var t = this$5.function$1.apply$mcJ$sp__J();
      var lo = t.lo$2;
      var hi = t.hi$2;
      jsx$1.log__Lscribe_LogRecord__V(new $c_Lscribe_LogRecord$SimpleLogRecord().init___Lscribe_Level__D__F0__Lscribe_Loggable__s_Option__T__T__s_Option__s_Option__s_Option__jl_Thread__J(level, value, messageFunction, loggable, throwable, "/home/mhicks/projects/open/youi/ui/js/src/main/scala/io/youi/image/SVGImage.scala", "io.youi.image.SVGImage", methodName, line, column, thread, new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
      throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
    } else {
      throw e
    }
  }
});
var $d_Lio_youi_image_SVGImage$ = new $TypeData().initClass({
  Lio_youi_image_SVGImage$: 0
}, false, "io.youi.image.SVGImage$", {
  Lio_youi_image_SVGImage$: 1,
  O: 1
});
$c_Lio_youi_image_SVGImage$.prototype.$classData = $d_Lio_youi_image_SVGImage$;
var $n_Lio_youi_image_SVGImage$ = (void 0);
function $m_Lio_youi_image_SVGImage$() {
  if ((!$n_Lio_youi_image_SVGImage$)) {
    $n_Lio_youi_image_SVGImage$ = new $c_Lio_youi_image_SVGImage$().init___()
  };
  return $n_Lio_youi_image_SVGImage$
}
/** @constructor */
function $c_Lio_youi_layout_GridLayout$Config$alignment$() {
  $c_O.call(this);
  this.horizontal$1 = null;
  this.vertical$1 = null
}
$c_Lio_youi_layout_GridLayout$Config$alignment$.prototype = new $h_O();
$c_Lio_youi_layout_GridLayout$Config$alignment$.prototype.constructor = $c_Lio_youi_layout_GridLayout$Config$alignment$;
/** @constructor */
function $h_Lio_youi_layout_GridLayout$Config$alignment$() {
  /*<skip>*/
}
$h_Lio_youi_layout_GridLayout$Config$alignment$.prototype = $c_Lio_youi_layout_GridLayout$Config$alignment$.prototype;
$c_Lio_youi_layout_GridLayout$Config$alignment$.prototype.init___Lio_youi_layout_GridLayout$Config = (function($$outer) {
  var lookup = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$7$2) {
    var x$7 = $as_Lio_youi_layout_GridLayout$Config(x$7$2);
    return x$7.alignment__Lio_youi_layout_GridLayout$Config$alignment$().horizontal$1
  }));
  this.horizontal$1 = $s_Lio_youi_layout_GridLayout$Config$class__prop__Lio_youi_layout_GridLayout$Config__F1__Lreactify_Var($$outer, lookup);
  var lookup$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$8$2) {
    var x$8 = $as_Lio_youi_layout_GridLayout$Config(x$8$2);
    return x$8.alignment__Lio_youi_layout_GridLayout$Config$alignment$().vertical$1
  }));
  this.vertical$1 = $s_Lio_youi_layout_GridLayout$Config$class__prop__Lio_youi_layout_GridLayout$Config__F1__Lreactify_Var($$outer, lookup$1);
  return this
});
var $d_Lio_youi_layout_GridLayout$Config$alignment$ = new $TypeData().initClass({
  Lio_youi_layout_GridLayout$Config$alignment$: 0
}, false, "io.youi.layout.GridLayout$Config$alignment$", {
  Lio_youi_layout_GridLayout$Config$alignment$: 1,
  O: 1
});
$c_Lio_youi_layout_GridLayout$Config$alignment$.prototype.$classData = $d_Lio_youi_layout_GridLayout$Config$alignment$;
/** @constructor */
function $c_Lio_youi_layout_GridLayout$Config$margin$() {
  $c_O.call(this);
  this.left$1 = null;
  this.right$1 = null;
  this.top$1 = null;
  this.bottom$1 = null
}
$c_Lio_youi_layout_GridLayout$Config$margin$.prototype = new $h_O();
$c_Lio_youi_layout_GridLayout$Config$margin$.prototype.constructor = $c_Lio_youi_layout_GridLayout$Config$margin$;
/** @constructor */
function $h_Lio_youi_layout_GridLayout$Config$margin$() {
  /*<skip>*/
}
$h_Lio_youi_layout_GridLayout$Config$margin$.prototype = $c_Lio_youi_layout_GridLayout$Config$margin$.prototype;
$c_Lio_youi_layout_GridLayout$Config$margin$.prototype.init___Lio_youi_layout_GridLayout$Config = (function($$outer) {
  var lookup = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$1$2) {
    var x$1 = $as_Lio_youi_layout_GridLayout$Config(x$1$2);
    return x$1.margin__Lio_youi_layout_GridLayout$Config$margin$().left$1
  }));
  this.left$1 = $s_Lio_youi_layout_GridLayout$Config$class__prop__Lio_youi_layout_GridLayout$Config__F1__Lreactify_Var($$outer, lookup);
  var lookup$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$2$2) {
    var x$2 = $as_Lio_youi_layout_GridLayout$Config(x$2$2);
    return x$2.margin__Lio_youi_layout_GridLayout$Config$margin$().right$1
  }));
  this.right$1 = $s_Lio_youi_layout_GridLayout$Config$class__prop__Lio_youi_layout_GridLayout$Config__F1__Lreactify_Var($$outer, lookup$1);
  var lookup$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$3$2) {
    var x$3 = $as_Lio_youi_layout_GridLayout$Config(x$3$2);
    return x$3.margin__Lio_youi_layout_GridLayout$Config$margin$().top$1
  }));
  this.top$1 = $s_Lio_youi_layout_GridLayout$Config$class__prop__Lio_youi_layout_GridLayout$Config__F1__Lreactify_Var($$outer, lookup$2);
  var lookup$3 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$4$2) {
    var x$4 = $as_Lio_youi_layout_GridLayout$Config(x$4$2);
    return x$4.margin__Lio_youi_layout_GridLayout$Config$margin$().bottom$1
  }));
  this.bottom$1 = $s_Lio_youi_layout_GridLayout$Config$class__prop__Lio_youi_layout_GridLayout$Config__F1__Lreactify_Var($$outer, lookup$3);
  return this
});
var $d_Lio_youi_layout_GridLayout$Config$margin$ = new $TypeData().initClass({
  Lio_youi_layout_GridLayout$Config$margin$: 0
}, false, "io.youi.layout.GridLayout$Config$margin$", {
  Lio_youi_layout_GridLayout$Config$margin$: 1,
  O: 1
});
$c_Lio_youi_layout_GridLayout$Config$margin$.prototype.$classData = $d_Lio_youi_layout_GridLayout$Config$margin$;
/** @constructor */
function $c_Lio_youi_layout_GridLayout$Config$span$() {
  $c_O.call(this);
  this.columns$1 = null;
  this.rows$1 = null
}
$c_Lio_youi_layout_GridLayout$Config$span$.prototype = new $h_O();
$c_Lio_youi_layout_GridLayout$Config$span$.prototype.constructor = $c_Lio_youi_layout_GridLayout$Config$span$;
/** @constructor */
function $h_Lio_youi_layout_GridLayout$Config$span$() {
  /*<skip>*/
}
$h_Lio_youi_layout_GridLayout$Config$span$.prototype = $c_Lio_youi_layout_GridLayout$Config$span$.prototype;
$c_Lio_youi_layout_GridLayout$Config$span$.prototype.init___Lio_youi_layout_GridLayout$Config = (function($$outer) {
  var lookup = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$5$2) {
    var x$5 = $as_Lio_youi_layout_GridLayout$Config(x$5$2);
    return x$5.span__Lio_youi_layout_GridLayout$Config$span$().columns$1
  }));
  this.columns$1 = $s_Lio_youi_layout_GridLayout$Config$class__prop__Lio_youi_layout_GridLayout$Config__F1__Lreactify_Var($$outer, lookup);
  var lookup$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$6$2) {
    var x$6 = $as_Lio_youi_layout_GridLayout$Config(x$6$2);
    return x$6.span__Lio_youi_layout_GridLayout$Config$span$().rows$1
  }));
  this.rows$1 = $s_Lio_youi_layout_GridLayout$Config$class__prop__Lio_youi_layout_GridLayout$Config__F1__Lreactify_Var($$outer, lookup$1);
  return this
});
var $d_Lio_youi_layout_GridLayout$Config$span$ = new $TypeData().initClass({
  Lio_youi_layout_GridLayout$Config$span$: 0
}, false, "io.youi.layout.GridLayout$Config$span$", {
  Lio_youi_layout_GridLayout$Config$span$: 1,
  O: 1
});
$c_Lio_youi_layout_GridLayout$Config$span$.prototype.$classData = $d_Lio_youi_layout_GridLayout$Config$span$;
/** @constructor */
function $c_Lio_youi_layout_GridLayout$config$() {
  $c_O.call(this);
  this.default$1 = null;
  this.rows$1 = null;
  this.columns$1 = null;
  this.$$outer$1 = null
}
$c_Lio_youi_layout_GridLayout$config$.prototype = new $h_O();
$c_Lio_youi_layout_GridLayout$config$.prototype.constructor = $c_Lio_youi_layout_GridLayout$config$;
/** @constructor */
function $h_Lio_youi_layout_GridLayout$config$() {
  /*<skip>*/
}
$h_Lio_youi_layout_GridLayout$config$.prototype = $c_Lio_youi_layout_GridLayout$config$.prototype;
$c_Lio_youi_layout_GridLayout$config$.prototype.row__I__Lio_youi_layout_GridLayout$RowConfig = (function(rowIndex) {
  var this$1 = this.rows$1;
  var x1 = $as_sc_MapLike(this$1.state__Lreactify_State().value__O()).get__O__s_Option(rowIndex);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var c = $as_Lio_youi_layout_GridLayout$RowConfig(x2.x$2);
    return c
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var c$2 = new $c_Lio_youi_layout_GridLayout$RowConfig().init___Lio_youi_layout_GridLayout__I(this.$$outer$1, rowIndex);
      var this$5 = this.rows$1;
      var this$2 = this.rows$1;
      var value = $as_sci_Map(this$2.state__Lreactify_State().value__O()).$$plus__T2__sci_Map(new $c_T2().init___O__O(rowIndex, c$2));
      $s_Lreactify_Var$class__$static__Lreactify_Var__O__V(this$5, value);
      return c$2
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
$c_Lio_youi_layout_GridLayout$config$.prototype.column__I__Lio_youi_layout_GridLayout$ColumnConfig = (function(columnIndex) {
  var this$1 = this.columns$1;
  var x1 = $as_sc_MapLike(this$1.state__Lreactify_State().value__O()).get__O__s_Option(columnIndex);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var c = $as_Lio_youi_layout_GridLayout$ColumnConfig(x2.x$2);
    return c
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var c$2 = new $c_Lio_youi_layout_GridLayout$ColumnConfig().init___Lio_youi_layout_GridLayout__I(this.$$outer$1, columnIndex);
      var this$5 = this.columns$1;
      var this$2 = this.columns$1;
      var value = $as_sci_Map(this$2.state__Lreactify_State().value__O()).$$plus__T2__sci_Map(new $c_T2().init___O__O(columnIndex, c$2));
      $s_Lreactify_Var$class__$static__Lreactify_Var__O__V(this$5, value);
      return c$2
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
$c_Lio_youi_layout_GridLayout$config$.prototype.init___Lio_youi_layout_GridLayout = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  this.default$1 = new $c_Lio_youi_layout_GridLayout$config$$anon$1().init___Lio_youi_layout_GridLayout$config$(this);
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_sci_Map$EmptyMap$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.rows$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_sci_Map$EmptyMap$()
  }));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.columns$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  return this
});
$c_Lio_youi_layout_GridLayout$config$.prototype.cell__I__I__Lio_youi_layout_GridLayout$CellConfig = (function(row, column) {
  return this.row__I__Lio_youi_layout_GridLayout$RowConfig(row).cell__I__Lio_youi_layout_GridLayout$CellConfig(column)
});
var $d_Lio_youi_layout_GridLayout$config$ = new $TypeData().initClass({
  Lio_youi_layout_GridLayout$config$: 0
}, false, "io.youi.layout.GridLayout$config$", {
  Lio_youi_layout_GridLayout$config$: 1,
  O: 1
});
$c_Lio_youi_layout_GridLayout$config$.prototype.$classData = $d_Lio_youi_layout_GridLayout$config$;
/** @constructor */
function $c_Lio_youi_net_ArgumentPathPart$() {
  $c_O.call(this)
}
$c_Lio_youi_net_ArgumentPathPart$.prototype = new $h_O();
$c_Lio_youi_net_ArgumentPathPart$.prototype.constructor = $c_Lio_youi_net_ArgumentPathPart$;
/** @constructor */
function $h_Lio_youi_net_ArgumentPathPart$() {
  /*<skip>*/
}
$h_Lio_youi_net_ArgumentPathPart$.prototype = $c_Lio_youi_net_ArgumentPathPart$.prototype;
$c_Lio_youi_net_ArgumentPathPart$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_net_ArgumentPathPart$.prototype.equals$extension__T__O__Z = (function($$this, x$1) {
  if ($is_Lio_youi_net_ArgumentPathPart(x$1)) {
    var ArgumentPathPart$1 = ((x$1 === null) ? null : $as_Lio_youi_net_ArgumentPathPart(x$1).name$1);
    return ($$this === ArgumentPathPart$1)
  } else {
    return false
  }
});
$c_Lio_youi_net_ArgumentPathPart$.prototype.value$extension__T__T = (function($$this) {
  var array = [":", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [$$this];
  return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
});
var $d_Lio_youi_net_ArgumentPathPart$ = new $TypeData().initClass({
  Lio_youi_net_ArgumentPathPart$: 0
}, false, "io.youi.net.ArgumentPathPart$", {
  Lio_youi_net_ArgumentPathPart$: 1,
  O: 1
});
$c_Lio_youi_net_ArgumentPathPart$.prototype.$classData = $d_Lio_youi_net_ArgumentPathPart$;
var $n_Lio_youi_net_ArgumentPathPart$ = (void 0);
function $m_Lio_youi_net_ArgumentPathPart$() {
  if ((!$n_Lio_youi_net_ArgumentPathPart$)) {
    $n_Lio_youi_net_ArgumentPathPart$ = new $c_Lio_youi_net_ArgumentPathPart$().init___()
  };
  return $n_Lio_youi_net_ArgumentPathPart$
}
/** @constructor */
function $c_Lio_youi_net_LiteralPathPart$() {
  $c_O.call(this)
}
$c_Lio_youi_net_LiteralPathPart$.prototype = new $h_O();
$c_Lio_youi_net_LiteralPathPart$.prototype.constructor = $c_Lio_youi_net_LiteralPathPart$;
/** @constructor */
function $h_Lio_youi_net_LiteralPathPart$() {
  /*<skip>*/
}
$h_Lio_youi_net_LiteralPathPart$.prototype = $c_Lio_youi_net_LiteralPathPart$.prototype;
$c_Lio_youi_net_LiteralPathPart$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_net_LiteralPathPart$.prototype.equals$extension__T__O__Z = (function($$this, x$1) {
  if ($is_Lio_youi_net_LiteralPathPart(x$1)) {
    var LiteralPathPart$1 = ((x$1 === null) ? null : $as_Lio_youi_net_LiteralPathPart(x$1).value$1);
    return ($$this === LiteralPathPart$1)
  } else {
    return false
  }
});
var $d_Lio_youi_net_LiteralPathPart$ = new $TypeData().initClass({
  Lio_youi_net_LiteralPathPart$: 0
}, false, "io.youi.net.LiteralPathPart$", {
  Lio_youi_net_LiteralPathPart$: 1,
  O: 1
});
$c_Lio_youi_net_LiteralPathPart$.prototype.$classData = $d_Lio_youi_net_LiteralPathPart$;
var $n_Lio_youi_net_LiteralPathPart$ = (void 0);
function $m_Lio_youi_net_LiteralPathPart$() {
  if ((!$n_Lio_youi_net_LiteralPathPart$)) {
    $n_Lio_youi_net_LiteralPathPart$ = new $c_Lio_youi_net_LiteralPathPart$().init___()
  };
  return $n_Lio_youi_net_LiteralPathPart$
}
/** @constructor */
function $c_Lio_youi_net_PathPart$() {
  $c_O.call(this);
  this.ArgumentPartRegex$1 = null
}
$c_Lio_youi_net_PathPart$.prototype = new $h_O();
$c_Lio_youi_net_PathPart$.prototype.constructor = $c_Lio_youi_net_PathPart$;
/** @constructor */
function $h_Lio_youi_net_PathPart$() {
  /*<skip>*/
}
$h_Lio_youi_net_PathPart$.prototype = $c_Lio_youi_net_PathPart$.prototype;
$c_Lio_youi_net_PathPart$.prototype.init___ = (function() {
  $n_Lio_youi_net_PathPart$ = this;
  var this$2 = new $c_sci_StringOps().init___T("[:](.+)");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  this.ArgumentPartRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames);
  return this
});
$c_Lio_youi_net_PathPart$.prototype.equals__Lio_youi_net_PathPart__Lio_youi_net_PathPart__Z = (function(p1, p2) {
  return (((p1 === null) ? (p2 === null) : p1.equals__O__Z(p2)) || ($is_Lio_youi_net_LiteralPathPart(p1) ? $is_Lio_youi_net_ArgumentPathPart(p2) : ($is_Lio_youi_net_ArgumentPathPart(p1) && $is_Lio_youi_net_LiteralPathPart(p2))))
});
$c_Lio_youi_net_PathPart$.prototype.apply__T__s_Option = (function(value) {
  if (((value === null) || (value === ""))) {
    return $m_s_None$()
  };
  if ((value === "..")) {
    return new $c_s_Some().init___O($m_Lio_youi_net_UpLevelPathPart$())
  };
  if ((value === ".")) {
    return new $c_s_Some().init___O($m_Lio_youi_net_SameLevelPathPart$())
  };
  var o18 = this.ArgumentPartRegex$1.unapplySeq__jl_CharSequence__s_Option(value);
  if ((!o18.isEmpty__Z())) {
    if ((o18.get__O() !== null)) {
      var this$1 = $as_sc_LinearSeqOptimized(o18.get__O());
      var jsx$1 = ($s_sc_LinearSeqOptimized$class__lengthCompare__sc_LinearSeqOptimized__I__I(this$1, 1) === 0)
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      var this$2 = $as_sc_LinearSeqOptimized(o18.get__O());
      var name = $as_T($s_sc_LinearSeqOptimized$class__apply__sc_LinearSeqOptimized__I__O(this$2, 0));
      return new $c_s_Some().init___O(new $c_Lio_youi_net_ArgumentPathPart().init___T(name))
    }
  };
  return new $c_s_Some().init___O(new $c_Lio_youi_net_LiteralPathPart().init___T(value))
});
var $d_Lio_youi_net_PathPart$ = new $TypeData().initClass({
  Lio_youi_net_PathPart$: 0
}, false, "io.youi.net.PathPart$", {
  Lio_youi_net_PathPart$: 1,
  O: 1
});
$c_Lio_youi_net_PathPart$.prototype.$classData = $d_Lio_youi_net_PathPart$;
var $n_Lio_youi_net_PathPart$ = (void 0);
function $m_Lio_youi_net_PathPart$() {
  if ((!$n_Lio_youi_net_PathPart$)) {
    $n_Lio_youi_net_PathPart$ = new $c_Lio_youi_net_PathPart$().init___()
  };
  return $n_Lio_youi_net_PathPart$
}
/** @constructor */
function $c_Lio_youi_net_URL$URLParts() {
  $c_O.call(this);
  this.encoded$1 = false;
  this.pathAndArgs$1 = null;
  this.asString$1 = null;
  this.$$outer$f = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_net_URL$URLParts.prototype = new $h_O();
$c_Lio_youi_net_URL$URLParts.prototype.constructor = $c_Lio_youi_net_URL$URLParts;
/** @constructor */
function $h_Lio_youi_net_URL$URLParts() {
  /*<skip>*/
}
$h_Lio_youi_net_URL$URLParts.prototype = $c_Lio_youi_net_URL$URLParts.prototype;
$c_Lio_youi_net_URL$URLParts.prototype.asString__T = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.asString$lzycompute__p1__T() : this.asString$1)
});
$c_Lio_youi_net_URL$URLParts.prototype.toString__T = (function() {
  return this.asString__T()
});
$c_Lio_youi_net_URL$URLParts.prototype.pathAndArgs__T = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.pathAndArgs$lzycompute__p1__T() : this.pathAndArgs$1)
});
$c_Lio_youi_net_URL$URLParts.prototype.asString$lzycompute__p1__T = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var array = ["", "", ""];
    var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var array$1 = [this.$$outer$f.base__T(), this.pathAndArgs__T()];
    this.asString$1 = jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1));
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.asString$1
});
$c_Lio_youi_net_URL$URLParts.prototype.init___Lio_youi_net_URL__Z = (function($$outer, encoded) {
  this.encoded$1 = encoded;
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$f = $$outer
  };
  return this
});
$c_Lio_youi_net_URL$URLParts.prototype.pathAndArgs$lzycompute__p1__T = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var b = new $c_scm_StringBuilder().init___();
    b.append__O__scm_StringBuilder(this.$$outer$f.path$1);
    b.append__T__scm_StringBuilder((this.encoded$1 ? this.$$outer$f.parameters$1.encoded__T() : this.$$outer$f.parameters$1.decoded__T()));
    var this$1 = this.$$outer$f.fragment$1;
    if ((!this$1.isEmpty__Z())) {
      var arg1 = this$1.get__O();
      var f = $as_T(arg1);
      b.append__C__scm_StringBuilder(35);
      b.append__T__scm_StringBuilder(f)
    };
    this.pathAndArgs$1 = b.underlying$5.java$lang$StringBuilder$$content$f;
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.pathAndArgs$1
});
var $d_Lio_youi_net_URL$URLParts = new $TypeData().initClass({
  Lio_youi_net_URL$URLParts: 0
}, false, "io.youi.net.URL$URLParts", {
  Lio_youi_net_URL$URLParts: 1,
  O: 1
});
$c_Lio_youi_net_URL$URLParts.prototype.$classData = $d_Lio_youi_net_URL$URLParts;
/** @constructor */
function $c_Lio_youi_package$() {
  $c_O.call(this);
  this.ppi$1 = 0.0;
  this.bitmap$0$1 = false
}
$c_Lio_youi_package$.prototype = new $h_O();
$c_Lio_youi_package$.prototype.constructor = $c_Lio_youi_package$;
/** @constructor */
function $h_Lio_youi_package$() {
  /*<skip>*/
}
$h_Lio_youi_package$.prototype = $c_Lio_youi_package$.prototype;
$c_Lio_youi_package$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_package$.prototype.ppi__D = (function() {
  return ((!this.bitmap$0$1) ? this.ppi$lzycompute__p1__D() : this.ppi$1)
});
$c_Lio_youi_package$.prototype.ppi$lzycompute__p1__D = (function() {
  if ((!this.bitmap$0$1)) {
    var div = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("div");
    div.style.width = "1in";
    $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(div);
    try {
      var jsx$1 = $uD(div.offsetWidth)
    } finally {
      $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.removeChild(div)
    };
    this.ppi$1 = jsx$1;
    this.bitmap$0$1 = true
  };
  return this.ppi$1
});
var $d_Lio_youi_package$ = new $TypeData().initClass({
  Lio_youi_package$: 0
}, false, "io.youi.package$", {
  Lio_youi_package$: 1,
  O: 1
});
$c_Lio_youi_package$.prototype.$classData = $d_Lio_youi_package$;
var $n_Lio_youi_package$ = (void 0);
function $m_Lio_youi_package$() {
  if ((!$n_Lio_youi_package$)) {
    $n_Lio_youi_package$ = new $c_Lio_youi_package$().init___()
  };
  return $n_Lio_youi_package$
}
/** @constructor */
function $c_Lio_youi_package$ExtendedCanvas() {
  $c_O.call(this);
  this.canvas$1 = null
}
$c_Lio_youi_package$ExtendedCanvas.prototype = new $h_O();
$c_Lio_youi_package$ExtendedCanvas.prototype.constructor = $c_Lio_youi_package$ExtendedCanvas;
/** @constructor */
function $h_Lio_youi_package$ExtendedCanvas() {
  /*<skip>*/
}
$h_Lio_youi_package$ExtendedCanvas.prototype = $c_Lio_youi_package$ExtendedCanvas.prototype;
$c_Lio_youi_package$ExtendedCanvas.prototype.init___Lorg_scalajs_dom_raw_HTMLCanvasElement = (function(canvas) {
  this.canvas$1 = canvas;
  return this
});
$c_Lio_youi_package$ExtendedCanvas.prototype.context__Lorg_scalajs_dom_raw_CanvasRenderingContext2D = (function() {
  return this.canvas$1.getContext("2d")
});
var $d_Lio_youi_package$ExtendedCanvas = new $TypeData().initClass({
  Lio_youi_package$ExtendedCanvas: 0
}, false, "io.youi.package$ExtendedCanvas", {
  Lio_youi_package$ExtendedCanvas: 1,
  O: 1
});
$c_Lio_youi_package$ExtendedCanvas.prototype.$classData = $d_Lio_youi_package$ExtendedCanvas;
/** @constructor */
function $c_Lio_youi_package$ExtendedGoogleFont() {
  $c_O.call(this);
  this.io$youi$ExtendedGoogleFont$$font$f = null
}
$c_Lio_youi_package$ExtendedGoogleFont.prototype = new $h_O();
$c_Lio_youi_package$ExtendedGoogleFont.prototype.constructor = $c_Lio_youi_package$ExtendedGoogleFont;
/** @constructor */
function $h_Lio_youi_package$ExtendedGoogleFont() {
  /*<skip>*/
}
$h_Lio_youi_package$ExtendedGoogleFont.prototype = $c_Lio_youi_package$ExtendedGoogleFont.prototype;
$c_Lio_youi_package$ExtendedGoogleFont.prototype.load__s_concurrent_Future = (function() {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var f = (function(arg$outer, promise$1) {
    return (function() {
      var value = arg$outer.io$youi$ExtendedGoogleFont$$font$f;
      $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(promise$1, value)
    })
  })(this, promise);
  var jsx$1 = $g.WebFont;
  var $this = {};
  $this.$$outer$2 = null;
  $this.$$outer$2 = this;
  var $this$1 = {};
  var value$1 = [$s_Lio_youi_package$ExtendedGoogleFont$$anon$1__io$youi$ExtendedGoogleFont$$anon$$$outer__Lio_youi_package$ExtendedGoogleFont$$anon$1__Lio_youi_package$ExtendedGoogleFont($this).io$youi$ExtendedGoogleFont$$font$f.family__T()];
  $this$1.families = value$1;
  $this.google = $this$1;
  $this.active = f;
  jsx$1.load($this);
  return promise
});
$c_Lio_youi_package$ExtendedGoogleFont.prototype.init___Lio_youi_font_GoogleFont = (function(font) {
  this.io$youi$ExtendedGoogleFont$$font$f = font;
  return this
});
function $is_Lio_youi_package$ExtendedGoogleFont(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_package$ExtendedGoogleFont)))
}
function $as_Lio_youi_package$ExtendedGoogleFont(obj) {
  return (($is_Lio_youi_package$ExtendedGoogleFont(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.package$ExtendedGoogleFont"))
}
function $isArrayOf_Lio_youi_package$ExtendedGoogleFont(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_package$ExtendedGoogleFont)))
}
function $asArrayOf_Lio_youi_package$ExtendedGoogleFont(obj, depth) {
  return (($isArrayOf_Lio_youi_package$ExtendedGoogleFont(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.package$ExtendedGoogleFont;", depth))
}
var $d_Lio_youi_package$ExtendedGoogleFont = new $TypeData().initClass({
  Lio_youi_package$ExtendedGoogleFont: 0
}, false, "io.youi.package$ExtendedGoogleFont", {
  Lio_youi_package$ExtendedGoogleFont: 1,
  O: 1
});
$c_Lio_youi_package$ExtendedGoogleFont.prototype.$classData = $d_Lio_youi_package$ExtendedGoogleFont;
function $s_Lio_youi_package$ExtendedGoogleFont$$anon$1__io$youi$ExtendedGoogleFont$$anon$$$outer__Lio_youi_package$ExtendedGoogleFont$$anon$1__Lio_youi_package$ExtendedGoogleFont($this) {
  return $as_Lio_youi_package$ExtendedGoogleFont($this.$$outer$2)
}
/** @constructor */
function $c_Lio_youi_package$ExtendedGoogleFontWeight() {
  $c_O.call(this);
  this.io$youi$ExtendedGoogleFontWeight$$weight$f = null
}
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype = new $h_O();
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype.constructor = $c_Lio_youi_package$ExtendedGoogleFontWeight;
/** @constructor */
function $h_Lio_youi_package$ExtendedGoogleFontWeight() {
  /*<skip>*/
}
$h_Lio_youi_package$ExtendedGoogleFontWeight.prototype = $c_Lio_youi_package$ExtendedGoogleFontWeight.prototype;
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype.init___Lio_youi_font_GoogleFontWeight = (function(weight) {
  this.io$youi$ExtendedGoogleFontWeight$$weight$f = weight;
  return this
});
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype.load__s_concurrent_Future = (function() {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var f = (function(arg$outer, promise$2) {
    return (function() {
      var value = arg$outer.io$youi$ExtendedGoogleFontWeight$$weight$f;
      $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(promise$2, value)
    })
  })(this, promise);
  var jsx$2 = $g.WebFont;
  var $this = {};
  $this.$$outer$2 = null;
  $this.$$outer$2 = this;
  var $this$1 = {};
  var array = ["", ":", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [$s_Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__io$youi$ExtendedGoogleFontWeight$$anon$$$outer__Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__Lio_youi_package$ExtendedGoogleFontWeight($this).io$youi$ExtendedGoogleFontWeight$$weight$f.font$1.family__T(), $s_Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__io$youi$ExtendedGoogleFontWeight$$anon$$$outer__Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__Lio_youi_package$ExtendedGoogleFontWeight($this).io$youi$ExtendedGoogleFontWeight$$weight$f.name$1];
  var value$1 = [jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))];
  $this$1.families = value$1;
  $this.google = $this$1;
  $this.active = f;
  jsx$2.load($this);
  return promise
});
function $is_Lio_youi_package$ExtendedGoogleFontWeight(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_package$ExtendedGoogleFontWeight)))
}
function $as_Lio_youi_package$ExtendedGoogleFontWeight(obj) {
  return (($is_Lio_youi_package$ExtendedGoogleFontWeight(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.package$ExtendedGoogleFontWeight"))
}
function $isArrayOf_Lio_youi_package$ExtendedGoogleFontWeight(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_package$ExtendedGoogleFontWeight)))
}
function $asArrayOf_Lio_youi_package$ExtendedGoogleFontWeight(obj, depth) {
  return (($isArrayOf_Lio_youi_package$ExtendedGoogleFontWeight(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.package$ExtendedGoogleFontWeight;", depth))
}
var $d_Lio_youi_package$ExtendedGoogleFontWeight = new $TypeData().initClass({
  Lio_youi_package$ExtendedGoogleFontWeight: 0
}, false, "io.youi.package$ExtendedGoogleFontWeight", {
  Lio_youi_package$ExtendedGoogleFontWeight: 1,
  O: 1
});
$c_Lio_youi_package$ExtendedGoogleFontWeight.prototype.$classData = $d_Lio_youi_package$ExtendedGoogleFontWeight;
function $s_Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__io$youi$ExtendedGoogleFontWeight$$anon$$$outer__Lio_youi_package$ExtendedGoogleFontWeight$$anon$3__Lio_youi_package$ExtendedGoogleFontWeight($this) {
  return $as_Lio_youi_package$ExtendedGoogleFontWeight($this.$$outer$2)
}
/** @constructor */
function $c_Lio_youi_package$StylePropWorkflowDouble() {
  $c_O.call(this);
  this.io$youi$StylePropWorkflowDouble$$prop$f = null
}
$c_Lio_youi_package$StylePropWorkflowDouble.prototype = new $h_O();
$c_Lio_youi_package$StylePropWorkflowDouble.prototype.constructor = $c_Lio_youi_package$StylePropWorkflowDouble;
/** @constructor */
function $h_Lio_youi_package$StylePropWorkflowDouble() {
  /*<skip>*/
}
$h_Lio_youi_package$StylePropWorkflowDouble.prototype = $c_Lio_youi_package$StylePropWorkflowDouble.prototype;
$c_Lio_youi_package$StylePropWorkflowDouble.prototype.init___Lio_youi_theme_StyleProp = (function(prop) {
  this.io$youi$StylePropWorkflowDouble$$prop$f = prop;
  return this
});
$c_Lio_youi_package$StylePropWorkflowDouble.prototype.to__F0__Lio_youi_task_PartialAnimate = (function(destination) {
  return new $c_Lio_youi_task_PartialAnimate().init___F0__F1__F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var this$1 = arg$outer.io$youi$StylePropWorkflowDouble$$prop$f;
      var this$2 = this$1.value$1;
      return $uD(this$2.state__Lreactify_State().value__O())
    })
  })(this)), new $c_Lio_youi_package$StylePropWorkflowDouble$$anonfun$to$2().init___Lio_youi_package$StylePropWorkflowDouble(this), destination)
});
var $d_Lio_youi_package$StylePropWorkflowDouble = new $TypeData().initClass({
  Lio_youi_package$StylePropWorkflowDouble: 0
}, false, "io.youi.package$StylePropWorkflowDouble", {
  Lio_youi_package$StylePropWorkflowDouble: 1,
  O: 1
});
$c_Lio_youi_package$StylePropWorkflowDouble.prototype.$classData = $d_Lio_youi_package$StylePropWorkflowDouble;
/** @constructor */
function $c_Lio_youi_package$UINumericSize() {
  $c_O.call(this);
  this.io$youi$UINumericSize$$d$1 = 0.0
}
$c_Lio_youi_package$UINumericSize.prototype = new $h_O();
$c_Lio_youi_package$UINumericSize.prototype.constructor = $c_Lio_youi_package$UINumericSize;
/** @constructor */
function $h_Lio_youi_package$UINumericSize() {
  /*<skip>*/
}
$h_Lio_youi_package$UINumericSize.prototype = $c_Lio_youi_package$UINumericSize.prototype;
$c_Lio_youi_package$UINumericSize.prototype.init___O__s_math_Numeric = (function(t, n) {
  var x = $uI(t);
  this.io$youi$UINumericSize$$d$1 = x;
  return this
});
$c_Lio_youi_package$UINumericSize.prototype.$in__D = (function() {
  return (this.io$youi$UINumericSize$$d$1 * $m_Lio_youi_package$().ppi__D())
});
$c_Lio_youi_package$UINumericSize.prototype.pt__D = (function() {
  return (this.$in__D() / 72.0)
});
var $d_Lio_youi_package$UINumericSize = new $TypeData().initClass({
  Lio_youi_package$UINumericSize: 0
}, false, "io.youi.package$UINumericSize", {
  Lio_youi_package$UINumericSize: 1,
  O: 1
});
$c_Lio_youi_package$UINumericSize.prototype.$classData = $d_Lio_youi_package$UINumericSize;
/** @constructor */
function $c_Lio_youi_paint_Border$() {
  $c_O.call(this);
  this.empty$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_paint_Border$.prototype = new $h_O();
$c_Lio_youi_paint_Border$.prototype.constructor = $c_Lio_youi_paint_Border$;
/** @constructor */
function $h_Lio_youi_paint_Border$() {
  /*<skip>*/
}
$h_Lio_youi_paint_Border$.prototype = $c_Lio_youi_paint_Border$.prototype;
$c_Lio_youi_paint_Border$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_paint_Border$.prototype.empty$lzycompute__p1__Lio_youi_paint_Border = (function() {
  if ((!this.bitmap$0$1)) {
    var stroke = $m_Lio_youi_paint_Stroke$().none__Lio_youi_paint_Stroke();
    this.empty$1 = new $c_Lio_youi_paint_RectangleBorder().init___Lio_youi_paint_Stroke__D(stroke, 0.0);
    this.bitmap$0$1 = true
  };
  return this.empty$1
});
$c_Lio_youi_paint_Border$.prototype.empty__Lio_youi_paint_Border = (function() {
  return ((!this.bitmap$0$1) ? this.empty$lzycompute__p1__Lio_youi_paint_Border() : this.empty$1)
});
var $d_Lio_youi_paint_Border$ = new $TypeData().initClass({
  Lio_youi_paint_Border$: 0
}, false, "io.youi.paint.Border$", {
  Lio_youi_paint_Border$: 1,
  O: 1
});
$c_Lio_youi_paint_Border$.prototype.$classData = $d_Lio_youi_paint_Border$;
var $n_Lio_youi_paint_Border$ = (void 0);
function $m_Lio_youi_paint_Border$() {
  if ((!$n_Lio_youi_paint_Border$)) {
    $n_Lio_youi_paint_Border$ = new $c_Lio_youi_paint_Border$().init___()
  };
  return $n_Lio_youi_paint_Border$
}
/** @constructor */
function $c_Lio_youi_paint_LineCap() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_paint_LineCap.prototype = new $h_O();
$c_Lio_youi_paint_LineCap.prototype.constructor = $c_Lio_youi_paint_LineCap;
/** @constructor */
function $h_Lio_youi_paint_LineCap() {
  /*<skip>*/
}
$h_Lio_youi_paint_LineCap.prototype = $c_Lio_youi_paint_LineCap.prototype;
$c_Lio_youi_paint_LineCap.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
/** @constructor */
function $c_Lio_youi_paint_LineJoin() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_paint_LineJoin.prototype = new $h_O();
$c_Lio_youi_paint_LineJoin.prototype.constructor = $c_Lio_youi_paint_LineJoin;
/** @constructor */
function $h_Lio_youi_paint_LineJoin() {
  /*<skip>*/
}
$h_Lio_youi_paint_LineJoin.prototype = $c_Lio_youi_paint_LineJoin.prototype;
$c_Lio_youi_paint_LineJoin.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
/** @constructor */
function $c_Lio_youi_spatial_BoundingBox$() {
  $c_O.call(this);
  this.zero$1 = null;
  this.temp$1 = null
}
$c_Lio_youi_spatial_BoundingBox$.prototype = new $h_O();
$c_Lio_youi_spatial_BoundingBox$.prototype.constructor = $c_Lio_youi_spatial_BoundingBox$;
/** @constructor */
function $h_Lio_youi_spatial_BoundingBox$() {
  /*<skip>*/
}
$h_Lio_youi_spatial_BoundingBox$.prototype = $c_Lio_youi_spatial_BoundingBox$.prototype;
$c_Lio_youi_spatial_BoundingBox$.prototype.init___ = (function() {
  $n_Lio_youi_spatial_BoundingBox$ = this;
  $m_Lio_youi_spatial_BoundingBox$();
  $m_Lio_youi_spatial_BoundingBox$();
  var x1 = 0.0;
  $m_Lio_youi_spatial_BoundingBox$();
  var y1 = 0.0;
  $m_Lio_youi_spatial_BoundingBox$();
  var x2 = 0.0;
  $m_Lio_youi_spatial_BoundingBox$();
  var y2 = 0.0;
  this.zero$1 = new $c_Lio_youi_spatial_ImmutableBoundingBox().init___D__D__D__D(x1, y1, x2, y2);
  this.temp$1 = new $c_Lio_youi_spatial_MutableBoundingBox().init___D__D__D__D(0.0, 0.0, 0.0, 0.0);
  return this
});
var $d_Lio_youi_spatial_BoundingBox$ = new $TypeData().initClass({
  Lio_youi_spatial_BoundingBox$: 0
}, false, "io.youi.spatial.BoundingBox$", {
  Lio_youi_spatial_BoundingBox$: 1,
  O: 1
});
$c_Lio_youi_spatial_BoundingBox$.prototype.$classData = $d_Lio_youi_spatial_BoundingBox$;
var $n_Lio_youi_spatial_BoundingBox$ = (void 0);
function $m_Lio_youi_spatial_BoundingBox$() {
  if ((!$n_Lio_youi_spatial_BoundingBox$)) {
    $n_Lio_youi_spatial_BoundingBox$ = new $c_Lio_youi_spatial_BoundingBox$().init___()
  };
  return $n_Lio_youi_spatial_BoundingBox$
}
/** @constructor */
function $c_Lio_youi_spatial_Matrix3$() {
  $c_O.call(this);
  this.Identity$1 = null;
  this.Empty$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_spatial_Matrix3$.prototype = new $h_O();
$c_Lio_youi_spatial_Matrix3$.prototype.constructor = $c_Lio_youi_spatial_Matrix3$;
/** @constructor */
function $h_Lio_youi_spatial_Matrix3$() {
  /*<skip>*/
}
$h_Lio_youi_spatial_Matrix3$.prototype = $c_Lio_youi_spatial_Matrix3$.prototype;
$c_Lio_youi_spatial_Matrix3$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_spatial_Matrix3$.prototype.Identity__Lio_youi_spatial_Matrix3 = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.Identity$lzycompute__p1__Lio_youi_spatial_Matrix3() : this.Identity$1)
});
$c_Lio_youi_spatial_Matrix3$.prototype.Identity$lzycompute__p1__Lio_youi_spatial_Matrix3 = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    this.Identity$1 = new $c_Lio_youi_spatial_ImmutableMatrix3().init___D__D__D__D__D__D__D__D__D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.Identity$1
});
var $d_Lio_youi_spatial_Matrix3$ = new $TypeData().initClass({
  Lio_youi_spatial_Matrix3$: 0
}, false, "io.youi.spatial.Matrix3$", {
  Lio_youi_spatial_Matrix3$: 1,
  O: 1
});
$c_Lio_youi_spatial_Matrix3$.prototype.$classData = $d_Lio_youi_spatial_Matrix3$;
var $n_Lio_youi_spatial_Matrix3$ = (void 0);
function $m_Lio_youi_spatial_Matrix3$() {
  if ((!$n_Lio_youi_spatial_Matrix3$)) {
    $n_Lio_youi_spatial_Matrix3$ = new $c_Lio_youi_spatial_Matrix3$().init___()
  };
  return $n_Lio_youi_spatial_Matrix3$
}
function $is_Lio_youi_spatial_Point(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_spatial_Point)))
}
function $as_Lio_youi_spatial_Point(obj) {
  return (($is_Lio_youi_spatial_Point(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.spatial.Point"))
}
function $isArrayOf_Lio_youi_spatial_Point(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_spatial_Point)))
}
function $asArrayOf_Lio_youi_spatial_Point(obj, depth) {
  return (($isArrayOf_Lio_youi_spatial_Point(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.spatial.Point;", depth))
}
function $is_Lio_youi_spatial_Size(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_spatial_Size)))
}
function $as_Lio_youi_spatial_Size(obj) {
  return (($is_Lio_youi_spatial_Size(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.spatial.Size"))
}
function $isArrayOf_Lio_youi_spatial_Size(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_spatial_Size)))
}
function $asArrayOf_Lio_youi_spatial_Size(obj, depth) {
  return (($isArrayOf_Lio_youi_spatial_Size(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.spatial.Size;", depth))
}
/** @constructor */
function $c_Lio_youi_spatial_package$() {
  $c_O.call(this);
  this.precision$1 = 0.0;
  this.tolerance$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_spatial_package$.prototype = new $h_O();
$c_Lio_youi_spatial_package$.prototype.constructor = $c_Lio_youi_spatial_package$;
/** @constructor */
function $h_Lio_youi_spatial_package$() {
  /*<skip>*/
}
$h_Lio_youi_spatial_package$.prototype = $c_Lio_youi_spatial_package$.prototype;
$c_Lio_youi_spatial_package$.prototype.init___ = (function() {
  this.precision$1 = 0.001;
  return this
});
$c_Lio_youi_spatial_package$.prototype.tolerantEquals__D__D__D__Z = (function(precision, d1, d2) {
  var a = (d1 - d2);
  return ($uD($g.Math.abs(a)) <= precision)
});
$c_Lio_youi_spatial_package$.prototype.tolerance$lzycompute__p1__F2 = (function() {
  if ((!this.bitmap$0$1)) {
    this.tolerance$1 = new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function(d1$2, d2$2) {
      var d1 = $uD(d1$2);
      var d2 = $uD(d2$2);
      return $m_Lio_youi_spatial_package$().tolerantEquals__D__D__D__Z($m_Lio_youi_spatial_package$().precision$1, d1, d2)
    }));
    this.bitmap$0$1 = true
  };
  return this.tolerance$1
});
$c_Lio_youi_spatial_package$.prototype.tolerance__F2 = (function() {
  return ((!this.bitmap$0$1) ? this.tolerance$lzycompute__p1__F2() : this.tolerance$1)
});
var $d_Lio_youi_spatial_package$ = new $TypeData().initClass({
  Lio_youi_spatial_package$: 0
}, false, "io.youi.spatial.package$", {
  Lio_youi_spatial_package$: 1,
  O: 1
});
$c_Lio_youi_spatial_package$.prototype.$classData = $d_Lio_youi_spatial_package$;
var $n_Lio_youi_spatial_package$ = (void 0);
function $m_Lio_youi_spatial_package$() {
  if ((!$n_Lio_youi_spatial_package$)) {
    $n_Lio_youi_spatial_package$ = new $c_Lio_youi_spatial_package$().init___()
  };
  return $n_Lio_youi_spatial_package$
}
/** @constructor */
function $c_Lio_youi_stream_StreamURL$() {
  $c_O.call(this)
}
$c_Lio_youi_stream_StreamURL$.prototype = new $h_O();
$c_Lio_youi_stream_StreamURL$.prototype.constructor = $c_Lio_youi_stream_StreamURL$;
/** @constructor */
function $h_Lio_youi_stream_StreamURL$() {
  /*<skip>*/
}
$h_Lio_youi_stream_StreamURL$.prototype = $c_Lio_youi_stream_StreamURL$.prototype;
$c_Lio_youi_stream_StreamURL$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_stream_StreamURL$.prototype.stream__Lio_youi_net_URL__s_Option__I__sci_Map__Z__T__s_concurrent_Future = (function(url, data, timeout, headers, withCredentials, responseType) {
  var request = new $c_Lio_youi_ajax_AjaxRequest().init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T(url, data, timeout, headers.$$plus__T2__sci_Map(new $c_T2().init___O__O("streaming", "true")), withCredentials, responseType);
  var future = request.send__s_concurrent_Future();
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x$1$2) {
    return $as_T(x$1$2.responseText)
  }));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(future, f, executor)
});
var $d_Lio_youi_stream_StreamURL$ = new $TypeData().initClass({
  Lio_youi_stream_StreamURL$: 0
}, false, "io.youi.stream.StreamURL$", {
  Lio_youi_stream_StreamURL$: 1,
  O: 1
});
$c_Lio_youi_stream_StreamURL$.prototype.$classData = $d_Lio_youi_stream_StreamURL$;
var $n_Lio_youi_stream_StreamURL$ = (void 0);
function $m_Lio_youi_stream_StreamURL$() {
  if ((!$n_Lio_youi_stream_StreamURL$)) {
    $n_Lio_youi_stream_StreamURL$ = new $c_Lio_youi_stream_StreamURL$().init___()
  };
  return $n_Lio_youi_stream_StreamURL$
}
/** @constructor */
function $c_Lio_youi_style_FontFamily() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_FontFamily.prototype = new $h_O();
$c_Lio_youi_style_FontFamily.prototype.constructor = $c_Lio_youi_style_FontFamily;
/** @constructor */
function $h_Lio_youi_style_FontFamily() {
  /*<skip>*/
}
$h_Lio_youi_style_FontFamily.prototype = $c_Lio_youi_style_FontFamily.prototype;
$c_Lio_youi_style_FontFamily.prototype.equals__O__Z = (function(x$1) {
  return $m_Lio_youi_style_FontFamily$().equals$extension__T__O__Z(this.value$1, x$1)
});
$c_Lio_youi_style_FontFamily.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
$c_Lio_youi_style_FontFamily.prototype.hashCode__I = (function() {
  var $$this = this.value$1;
  return $m_sjsr_RuntimeString$().hashCode__T__I($$this)
});
function $is_Lio_youi_style_FontFamily(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_FontFamily)))
}
function $as_Lio_youi_style_FontFamily(obj) {
  return (($is_Lio_youi_style_FontFamily(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.FontFamily"))
}
function $isArrayOf_Lio_youi_style_FontFamily(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_FontFamily)))
}
function $asArrayOf_Lio_youi_style_FontFamily(obj, depth) {
  return (($isArrayOf_Lio_youi_style_FontFamily(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.FontFamily;", depth))
}
var $d_Lio_youi_style_FontFamily = new $TypeData().initClass({
  Lio_youi_style_FontFamily: 0
}, false, "io.youi.style.FontFamily", {
  Lio_youi_style_FontFamily: 1,
  O: 1
});
$c_Lio_youi_style_FontFamily.prototype.$classData = $d_Lio_youi_style_FontFamily;
/** @constructor */
function $c_Lio_youi_style_FontWeight() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_FontWeight.prototype = new $h_O();
$c_Lio_youi_style_FontWeight.prototype.constructor = $c_Lio_youi_style_FontWeight;
/** @constructor */
function $h_Lio_youi_style_FontWeight() {
  /*<skip>*/
}
$h_Lio_youi_style_FontWeight.prototype = $c_Lio_youi_style_FontWeight.prototype;
$c_Lio_youi_style_FontWeight.prototype.equals__O__Z = (function(x$1) {
  return $m_Lio_youi_style_FontWeight$().equals$extension__T__O__Z(this.value$1, x$1)
});
$c_Lio_youi_style_FontWeight.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
$c_Lio_youi_style_FontWeight.prototype.hashCode__I = (function() {
  var $$this = this.value$1;
  return $m_sjsr_RuntimeString$().hashCode__T__I($$this)
});
function $is_Lio_youi_style_FontWeight(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_FontWeight)))
}
function $as_Lio_youi_style_FontWeight(obj) {
  return (($is_Lio_youi_style_FontWeight(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.FontWeight"))
}
function $isArrayOf_Lio_youi_style_FontWeight(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_FontWeight)))
}
function $asArrayOf_Lio_youi_style_FontWeight(obj, depth) {
  return (($isArrayOf_Lio_youi_style_FontWeight(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.FontWeight;", depth))
}
var $d_Lio_youi_style_FontWeight = new $TypeData().initClass({
  Lio_youi_style_FontWeight: 0
}, false, "io.youi.style.FontWeight", {
  Lio_youi_style_FontWeight: 1,
  O: 1
});
$c_Lio_youi_style_FontWeight.prototype.$classData = $d_Lio_youi_style_FontWeight;
/** @constructor */
function $c_Lio_youi_style_HTMLBorderStyle() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_HTMLBorderStyle.prototype = new $h_O();
$c_Lio_youi_style_HTMLBorderStyle.prototype.constructor = $c_Lio_youi_style_HTMLBorderStyle;
/** @constructor */
function $h_Lio_youi_style_HTMLBorderStyle() {
  /*<skip>*/
}
$h_Lio_youi_style_HTMLBorderStyle.prototype = $c_Lio_youi_style_HTMLBorderStyle.prototype;
$c_Lio_youi_style_HTMLBorderStyle.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
/** @constructor */
function $c_Lio_youi_style_Overflow() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_Overflow.prototype = new $h_O();
$c_Lio_youi_style_Overflow.prototype.constructor = $c_Lio_youi_style_Overflow;
/** @constructor */
function $h_Lio_youi_style_Overflow() {
  /*<skip>*/
}
$h_Lio_youi_style_Overflow.prototype = $c_Lio_youi_style_Overflow.prototype;
$c_Lio_youi_style_Overflow.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_style_Overflow(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_Overflow)))
}
function $as_Lio_youi_style_Overflow(obj) {
  return (($is_Lio_youi_style_Overflow(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.Overflow"))
}
function $isArrayOf_Lio_youi_style_Overflow(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_Overflow)))
}
function $asArrayOf_Lio_youi_style_Overflow(obj, depth) {
  return (($isArrayOf_Lio_youi_style_Overflow(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.Overflow;", depth))
}
/** @constructor */
function $c_Lio_youi_style_Visibility() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_Visibility.prototype = new $h_O();
$c_Lio_youi_style_Visibility.prototype.constructor = $c_Lio_youi_style_Visibility;
/** @constructor */
function $h_Lio_youi_style_Visibility() {
  /*<skip>*/
}
$h_Lio_youi_style_Visibility.prototype = $c_Lio_youi_style_Visibility.prototype;
$c_Lio_youi_style_Visibility.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_style_Visibility(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_Visibility)))
}
function $as_Lio_youi_style_Visibility(obj) {
  return (($is_Lio_youi_style_Visibility(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.Visibility"))
}
function $isArrayOf_Lio_youi_style_Visibility(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_Visibility)))
}
function $asArrayOf_Lio_youi_style_Visibility(obj, depth) {
  return (($isArrayOf_Lio_youi_style_Visibility(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.Visibility;", depth))
}
/** @constructor */
function $c_Lio_youi_style_WhiteSpace() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_style_WhiteSpace.prototype = new $h_O();
$c_Lio_youi_style_WhiteSpace.prototype.constructor = $c_Lio_youi_style_WhiteSpace;
/** @constructor */
function $h_Lio_youi_style_WhiteSpace() {
  /*<skip>*/
}
$h_Lio_youi_style_WhiteSpace.prototype = $c_Lio_youi_style_WhiteSpace.prototype;
$c_Lio_youi_style_WhiteSpace.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_style_WhiteSpace(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_WhiteSpace)))
}
function $as_Lio_youi_style_WhiteSpace(obj) {
  return (($is_Lio_youi_style_WhiteSpace(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.WhiteSpace"))
}
function $isArrayOf_Lio_youi_style_WhiteSpace(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_WhiteSpace)))
}
function $asArrayOf_Lio_youi_style_WhiteSpace(obj, depth) {
  return (($isArrayOf_Lio_youi_style_WhiteSpace(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.WhiteSpace;", depth))
}
/** @constructor */
function $c_Lio_youi_task_TaskInstance() {
  $c_O.call(this);
  this.io$youi$task$TaskInstance$$task$f = null;
  this.io$youi$task$TaskInstance$$updates$f = null;
  this.io$youi$task$TaskInstance$$promise$1 = null;
  this.io$youi$task$TaskInstance$$reaction$1 = null;
  this.io$youi$task$TaskInstance$$first$1 = false;
  this.io$youi$task$TaskInstance$$elapsed$1 = 0.0;
  this.io$youi$task$TaskInstance$$paused$1 = false;
  this.io$youi$task$TaskInstance$$step$1 = 0.0;
  this.future$1 = null
}
$c_Lio_youi_task_TaskInstance.prototype = new $h_O();
$c_Lio_youi_task_TaskInstance.prototype.constructor = $c_Lio_youi_task_TaskInstance;
/** @constructor */
function $h_Lio_youi_task_TaskInstance() {
  /*<skip>*/
}
$h_Lio_youi_task_TaskInstance.prototype = $c_Lio_youi_task_TaskInstance.prototype;
$c_Lio_youi_task_TaskInstance.prototype.init___Lio_youi_task_Task__Lio_youi_Updates = (function(task, updates) {
  this.io$youi$task$TaskInstance$$task$f = task;
  this.io$youi$task$TaskInstance$$updates$f = updates;
  this.io$youi$task$TaskInstance$$promise$1 = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  this.io$youi$task$TaskInstance$$first$1 = true;
  this.io$youi$task$TaskInstance$$elapsed$1 = 0.0;
  this.io$youi$task$TaskInstance$$paused$1 = false;
  this.io$youi$task$TaskInstance$$step$1 = 0.0;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
    return (function(delta$2) {
      var delta = $uD(delta$2);
      var x1 = arg$outer.io$youi$task$TaskInstance$$updates$f;
      if ((!$is_Lio_youi_task_TaskSupport(x1))) {
        var updateTask = true
      } else {
        var x2 = $as_Lio_youi_task_TaskSupport(x1);
        var updateTask = x2.updateTasks__Z()
      };
      if (((!arg$outer.io$youi$task$TaskInstance$$paused$1) && updateTask)) {
        arg$outer.io$youi$task$TaskInstance$$elapsed$1 = (arg$outer.io$youi$task$TaskInstance$$elapsed$1 + delta);
        if ((arg$outer.io$youi$task$TaskInstance$$step$1 >= 0.0)) {
          arg$outer.io$youi$task$TaskInstance$$step$1 = 0.0;
          var x1$2 = arg$outer.io$youi$task$TaskInstance$$task$f.update__D__Z__Lio_youi_task_Conclusion(delta, arg$outer.io$youi$task$TaskInstance$$first$1);
          var x = $m_Lio_youi_task_Conclusion$Continue$();
          if ((!(x === x1$2))) {
            var x$3 = $m_Lio_youi_task_Conclusion$Finished$();
            if ((x$3 === x1$2)) {
              arg$outer.io$youi$task$TaskInstance$$updates$f.delta__Lreactify_Channel().reactions__Lreactify_reaction_Reactions().$$minus$eq__Lreactify_reaction_Reaction__Z(arg$outer.io$youi$task$TaskInstance$$reaction$1);
              var this$3 = arg$outer.io$youi$task$TaskInstance$$promise$1;
              var value = arg$outer.io$youi$task$TaskInstance$$elapsed$1;
              $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(this$3, value)
            } else {
              throw new $c_s_MatchError().init___O(x1$2)
            }
          };
          arg$outer.io$youi$task$TaskInstance$$first$1 = false
        }
      }
    })
  })(this));
  var priority = $m_Lreactify_Priority$().Normal$1;
  this.io$youi$task$TaskInstance$$reaction$1 = new $c_Lreactify_reaction_FunctionReaction().init___F1__D(f, priority);
  var this$6 = this.io$youi$task$TaskInstance$$promise$1;
  this.future$1 = this$6;
  return this
});
$c_Lio_youi_task_TaskInstance.prototype.start__s_concurrent_Future = (function() {
  this.io$youi$task$TaskInstance$$updates$f.delta__Lreactify_Channel().reactions__Lreactify_reaction_Reactions().$$plus$eq__Lreactify_reaction_Reaction__Lreactify_reaction_Reaction(this.io$youi$task$TaskInstance$$reaction$1);
  return this.future$1
});
var $d_Lio_youi_task_TaskInstance = new $TypeData().initClass({
  Lio_youi_task_TaskInstance: 0
}, false, "io.youi.task.TaskInstance", {
  Lio_youi_task_TaskInstance: 1,
  O: 1
});
$c_Lio_youi_task_TaskInstance.prototype.$classData = $d_Lio_youi_task_TaskInstance;
/** @constructor */
function $c_Lio_youi_task_package$() {
  $c_O.call(this)
}
$c_Lio_youi_task_package$.prototype = new $h_O();
$c_Lio_youi_task_package$.prototype.constructor = $c_Lio_youi_task_package$;
/** @constructor */
function $h_Lio_youi_task_package$() {
  /*<skip>*/
}
$h_Lio_youi_task_package$.prototype = $c_Lio_youi_task_package$.prototype;
$c_Lio_youi_task_package$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_task_package$.prototype.synchronous__F0__Lio_youi_task_Action = (function(f) {
  var f$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(f$2) {
    return (function() {
      f$2.apply$mcV$sp__V();
      $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
    })
  })(f));
  return new $c_Lio_youi_task_Action().init___F0(f$1)
});
var $d_Lio_youi_task_package$ = new $TypeData().initClass({
  Lio_youi_task_package$: 0
}, false, "io.youi.task.package$", {
  Lio_youi_task_package$: 1,
  O: 1
});
$c_Lio_youi_task_package$.prototype.$classData = $d_Lio_youi_task_package$;
var $n_Lio_youi_task_package$ = (void 0);
function $m_Lio_youi_task_package$() {
  if ((!$n_Lio_youi_task_package$)) {
    $n_Lio_youi_task_package$ = new $c_Lio_youi_task_package$().init___()
  };
  return $n_Lio_youi_task_package$
}
/** @constructor */
function $c_Lio_youi_task_package$StateChannelWorkflowDouble() {
  $c_O.call(this);
  this.io$youi$task$StateChannelWorkflowDouble$$state$f = null
}
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype = new $h_O();
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype.constructor = $c_Lio_youi_task_package$StateChannelWorkflowDouble;
/** @constructor */
function $h_Lio_youi_task_package$StateChannelWorkflowDouble() {
  /*<skip>*/
}
$h_Lio_youi_task_package$StateChannelWorkflowDouble.prototype = $c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype;
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype.init___Lreactify_Var = (function(state) {
  this.io$youi$task$StateChannelWorkflowDouble$$state$f = state;
  return this
});
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype.to__F0__Lio_youi_task_PartialAnimate = (function(destination) {
  return new $c_Lio_youi_task_PartialAnimate().init___F0__F1__F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var this$1 = arg$outer.io$youi$task$StateChannelWorkflowDouble$$state$f;
      return $uD(this$1.state__Lreactify_State().value__O())
    })
  })(this)), new $c_Lio_youi_task_package$StateChannelWorkflowDouble$$anonfun$to$2().init___Lio_youi_task_package$StateChannelWorkflowDouble(this), destination)
});
var $d_Lio_youi_task_package$StateChannelWorkflowDouble = new $TypeData().initClass({
  Lio_youi_task_package$StateChannelWorkflowDouble: 0
}, false, "io.youi.task.package$StateChannelWorkflowDouble", {
  Lio_youi_task_package$StateChannelWorkflowDouble: 1,
  O: 1
});
$c_Lio_youi_task_package$StateChannelWorkflowDouble.prototype.$classData = $d_Lio_youi_task_package$StateChannelWorkflowDouble;
/** @constructor */
function $c_Lio_youi_theme_ComponentTheme$padding$() {
  $c_O.call(this);
  this.left$1 = null;
  this.right$1 = null;
  this.top$1 = null;
  this.bottom$1 = null;
  this.width$1 = null;
  this.height$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_theme_ComponentTheme$padding$.prototype = new $h_O();
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.constructor = $c_Lio_youi_theme_ComponentTheme$padding$;
/** @constructor */
function $h_Lio_youi_theme_ComponentTheme$padding$() {
  /*<skip>*/
}
$h_Lio_youi_theme_ComponentTheme$padding$.prototype = $c_Lio_youi_theme_ComponentTheme$padding$.prototype;
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.right__Lio_youi_theme_StyleProp = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.right$lzycompute__p1__Lio_youi_theme_StyleProp() : this.right$1)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.bottom$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((8 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__stringifyDouble__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify(this$1));
    this.bottom$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "padding.bottom", $default, connect, false, false, false);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottom$1
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.bottom__Lio_youi_theme_StyleProp = (function() {
  return (((((8 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.bottom$lzycompute__p1__Lio_youi_theme_StyleProp() : this.bottom$1)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.left__Lio_youi_theme_StyleProp = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.left$lzycompute__p1__Lio_youi_theme_StyleProp() : this.left$1)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.top$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((4 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__stringifyDouble__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify(this$1));
    this.top$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "padding.top", $default, connect, false, false, false);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.top$1
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.right$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__stringifyDouble__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify(this$1));
    this.right$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "padding.right", $default, connect, false, false, false);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.right$1
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.set__F0__V = (function(f) {
  this.left__Lio_youi_theme_StyleProp().set__F0__V(f);
  this.right__Lio_youi_theme_StyleProp().set__F0__V(f);
  this.top__Lio_youi_theme_StyleProp().set__F0__V(f);
  this.bottom__Lio_youi_theme_StyleProp().set__F0__V(f)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.top__Lio_youi_theme_StyleProp = (function() {
  return (((((4 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.top$lzycompute__p1__Lio_youi_theme_StyleProp() : this.top$1)
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.init___Lio_youi_theme_ComponentTheme = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.left$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$7 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      var n = $m_s_math_Numeric$IntIsIntegral$();
      var this$2 = new $c_Lio_youi_package$UINumericSize().init___O__s_math_Numeric(0, n);
      return this$2.io$youi$UINumericSize$$d$1
    }));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$3 = this.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__stringifyDouble__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify(this$3));
    this.left$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$7, "padding.left", $default, connect, false, false, false);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.left$1
});
var $d_Lio_youi_theme_ComponentTheme$padding$ = new $TypeData().initClass({
  Lio_youi_theme_ComponentTheme$padding$: 0
}, false, "io.youi.theme.ComponentTheme$padding$", {
  Lio_youi_theme_ComponentTheme$padding$: 1,
  O: 1
});
$c_Lio_youi_theme_ComponentTheme$padding$.prototype.$classData = $d_Lio_youi_theme_ComponentTheme$padding$;
/** @constructor */
function $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$() {
  $c_O.call(this);
  this.top$1 = null;
  this.bottom$1 = null;
  this.left$1 = null;
  this.right$1 = null;
  this.radius$module$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype = new $h_O();
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.constructor = $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$;
/** @constructor */
function $h_Lio_youi_theme_HTMLComponentTheme$htmlBorder$() {
  /*<skip>*/
}
$h_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype = $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype;
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.right__Lio_youi_theme_StyleProp = (function() {
  return (((((8 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.right$lzycompute__p1__Lio_youi_theme_StyleProp() : this.right$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.bottom$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return $m_Lio_youi_style_HTMLBorder$().empty__Lio_youi_style_HTMLBorder()
    }));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_HTMLBorder$());
    this.bottom$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-bottom", $default, connect, false, false, false);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottom$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.bottom__Lio_youi_theme_StyleProp = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.bottom$lzycompute__p1__Lio_youi_theme_StyleProp() : this.bottom$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.radius$lzycompute__p1__Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$ = (function() {
  if ((this.radius$module$1 === null)) {
    this.radius$module$1 = new $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$().init___Lio_youi_theme_HTMLComponentTheme$htmlBorder$(this)
  };
  return this.radius$module$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.radius__Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$ = (function() {
  return ((this.radius$module$1 === null) ? this.radius$lzycompute__p1__Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$() : this.radius$module$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.init___Lio_youi_theme_HTMLComponentTheme = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.top$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return $m_Lio_youi_style_HTMLBorder$().empty__Lio_youi_style_HTMLBorder()
    }));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_HTMLBorder$());
    this.top$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-top", $default, connect, false, false, false);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.top$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.left__Lio_youi_theme_StyleProp = (function() {
  return (((((4 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.left$lzycompute__p1__Lio_youi_theme_StyleProp() : this.left$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.right$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((8 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return $m_Lio_youi_style_HTMLBorder$().empty__Lio_youi_style_HTMLBorder()
    }));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_HTMLBorder$());
    this.right$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-right", $default, connect, false, false, false);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.right$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.top__Lio_youi_theme_StyleProp = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.top$lzycompute__p1__Lio_youi_theme_StyleProp() : this.top$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.$$colon$eq__F0__V = (function(border) {
  this.top__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(border);
  this.bottom__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(border);
  this.left__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(border);
  this.right__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(border)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.left$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((4 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return $m_Lio_youi_style_HTMLBorder$().empty__Lio_youi_style_HTMLBorder()
    }));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_HTMLBorder$());
    this.left$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-left", $default, connect, false, false, false);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.left$1
});
var $d_Lio_youi_theme_HTMLComponentTheme$htmlBorder$ = new $TypeData().initClass({
  Lio_youi_theme_HTMLComponentTheme$htmlBorder$: 0
}, false, "io.youi.theme.HTMLComponentTheme$htmlBorder$", {
  Lio_youi_theme_HTMLComponentTheme$htmlBorder$: 1,
  O: 1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$.prototype.$classData = $d_Lio_youi_theme_HTMLComponentTheme$htmlBorder$;
/** @constructor */
function $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$() {
  $c_O.call(this);
  this.topLeft$1 = null;
  this.topRight$1 = null;
  this.bottomLeft$1 = null;
  this.bottomRight$1 = null;
  this.top$module$1 = null;
  this.bottom$module$1 = null;
  this.left$module$1 = null;
  this.right$module$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype = new $h_O();
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.constructor = $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$;
/** @constructor */
function $h_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$() {
  /*<skip>*/
}
$h_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype = $c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype;
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.bottomRight$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((8 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__pixels__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify(this$1));
    this.bottomRight$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-bottom-right-radius", $default, connect, false, false, false);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottomRight$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.bottomLeft__Lio_youi_theme_StyleProp = (function() {
  return (((((4 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.bottomLeft$lzycompute__p1__Lio_youi_theme_StyleProp() : this.bottomLeft$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.init___Lio_youi_theme_HTMLComponentTheme$htmlBorder$ = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.topLeft__Lio_youi_theme_StyleProp = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.topLeft$lzycompute__p1__Lio_youi_theme_StyleProp() : this.topLeft$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.topLeft$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__pixels__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify(this$1));
    this.topLeft$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-top-left-radius", $default, connect, false, false, false);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.topLeft$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.bottomRight__Lio_youi_theme_StyleProp = (function() {
  return (((((8 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.bottomRight$lzycompute__p1__Lio_youi_theme_StyleProp() : this.bottomRight$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.topRight$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__pixels__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify(this$1));
    this.topRight$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-top-right-radius", $default, connect, false, false, false);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.topRight$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.$$colon$eq__F0__V = (function(value) {
  this.topLeft__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(value);
  this.topRight__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(value);
  this.bottomLeft__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(value);
  this.bottomRight__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(value)
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.bottomLeft$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((4 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return 0.0
    }));
    var jsx$1 = $m_Lio_youi_theme_StyleConnect$();
    var this$1 = this.$$outer$1.$$outer$1;
    var connect = jsx$1.style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__pixels__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify(this$1));
    this.bottomLeft$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "border-bottom-left-radius", $default, connect, false, false, false);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottomLeft$1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.topRight__Lio_youi_theme_StyleProp = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.topRight$lzycompute__p1__Lio_youi_theme_StyleProp() : this.topRight$1)
});
var $d_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$ = new $TypeData().initClass({
  Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$: 0
}, false, "io.youi.theme.HTMLComponentTheme$htmlBorder$radius$", {
  Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$: 1,
  O: 1
});
$c_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$.prototype.$classData = $d_Lio_youi_theme_HTMLComponentTheme$htmlBorder$radius$;
/** @constructor */
function $c_Lio_youi_theme_HTMLComponentTheme$overflow$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.$$outer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype = new $h_O();
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.constructor = $c_Lio_youi_theme_HTMLComponentTheme$overflow$;
/** @constructor */
function $h_Lio_youi_theme_HTMLComponentTheme$overflow$() {
  /*<skip>*/
}
$h_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype = $c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype;
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.init___Lio_youi_theme_HTMLComponentTheme = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.y__Lio_youi_theme_StyleProp = (function() {
  return (((((2 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.y$lzycompute__p1__Lio_youi_theme_StyleProp() : this.y$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.x__Lio_youi_theme_StyleProp = (function() {
  return (((((1 & this.bitmap$0$1) << 24) >> 24) === 0) ? this.x$lzycompute__p1__Lio_youi_theme_StyleProp() : this.x$1)
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.y$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((2 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return $m_Lio_youi_style_Overflow$Visible$()
    }));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_Overflow$());
    this.y$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "overflow-y", $default, connect, false, false, false);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.$$colon$eq__F0__V = (function(overflow) {
  this.x__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(overflow);
  this.y__Lio_youi_theme_StyleProp().$$colon$eq__F0__V(overflow)
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.x$lzycompute__p1__Lio_youi_theme_StyleProp = (function() {
  if (((((1 & this.bitmap$0$1) << 24) >> 24) === 0)) {
    var this$5 = this.$$outer$1;
    var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
      return $m_Lio_youi_style_Overflow$Visible$()
    }));
    var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_Overflow$());
    this.x$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp(this$5, "overflow-x", $default, connect, false, false, false);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.x$1
});
var $d_Lio_youi_theme_HTMLComponentTheme$overflow$ = new $TypeData().initClass({
  Lio_youi_theme_HTMLComponentTheme$overflow$: 0
}, false, "io.youi.theme.HTMLComponentTheme$overflow$", {
  Lio_youi_theme_HTMLComponentTheme$overflow$: 1,
  O: 1
});
$c_Lio_youi_theme_HTMLComponentTheme$overflow$.prototype.$classData = $d_Lio_youi_theme_HTMLComponentTheme$overflow$;
/** @constructor */
function $c_Lio_youi_theme_StyleConnect$() {
  $c_O.call(this)
}
$c_Lio_youi_theme_StyleConnect$.prototype = new $h_O();
$c_Lio_youi_theme_StyleConnect$.prototype.constructor = $c_Lio_youi_theme_StyleConnect$;
/** @constructor */
function $h_Lio_youi_theme_StyleConnect$() {
  /*<skip>*/
}
$h_Lio_youi_theme_StyleConnect$.prototype = $c_Lio_youi_theme_StyleConnect$.prototype;
$c_Lio_youi_theme_StyleConnect$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_theme_StyleConnect$.prototype.style__F1__Lio_youi_theme_Stringify__s_Option = (function(modifier, stringify) {
  return new $c_s_Some().init___O(new $c_Lio_youi_theme_StyleConnect$$anon$2().init___F1__Lio_youi_theme_Stringify(modifier, stringify))
});
$c_Lio_youi_theme_StyleConnect$.prototype.style__Lio_youi_theme_Stringify__s_Option = (function(stringify) {
  return this.style__F1__Lio_youi_theme_Stringify__s_Option(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(t$2) {
    return t$2
  })), stringify)
});
$c_Lio_youi_theme_StyleConnect$.prototype.io$youi$theme$StyleConnect$$withElement__Lio_youi_theme_Theme__F1__V = (function(theme, f) {
  if ($is_Lio_youi_component_extras_HTMLComponent(theme)) {
    var x2 = $as_Lio_youi_component_extras_HTMLComponent(theme);
    $m_Lio_youi_component_extras_HTMLComponent$();
    var e = x2.element__Lorg_scalajs_dom_raw_HTMLElement();
    $asUnit(f.apply__O__O(e))
  }
});
$c_Lio_youi_theme_StyleConnect$.prototype.flag__s_Option__s_Option__s_Option = (function(on, off) {
  return new $c_s_Some().init___O(new $c_Lio_youi_theme_StyleConnect$$anon$5().init___s_Option__s_Option(on, off))
});
$c_Lio_youi_theme_StyleConnect$.prototype.content__Lio_youi_theme_Stringify__s_Option = (function(stringify) {
  return new $c_s_Some().init___O(new $c_Lio_youi_theme_StyleConnect$$anon$3().init___Lio_youi_theme_Stringify(stringify))
});
$c_Lio_youi_theme_StyleConnect$.prototype.classify__Lio_youi_theme_Stringify__s_Option = (function(stringify) {
  return new $c_s_Some().init___O(new $c_Lio_youi_theme_StyleConnect$$anon$4().init___Lio_youi_theme_Stringify(stringify))
});
var $d_Lio_youi_theme_StyleConnect$ = new $TypeData().initClass({
  Lio_youi_theme_StyleConnect$: 0
}, false, "io.youi.theme.StyleConnect$", {
  Lio_youi_theme_StyleConnect$: 1,
  O: 1
});
$c_Lio_youi_theme_StyleConnect$.prototype.$classData = $d_Lio_youi_theme_StyleConnect$;
var $n_Lio_youi_theme_StyleConnect$ = (void 0);
function $m_Lio_youi_theme_StyleConnect$() {
  if ((!$n_Lio_youi_theme_StyleConnect$)) {
    $n_Lio_youi_theme_StyleConnect$ = new $c_Lio_youi_theme_StyleConnect$().init___()
  };
  return $n_Lio_youi_theme_StyleConnect$
}
/** @constructor */
function $c_Lio_youi_theme_StyleProp() {
  $c_O.call(this);
  this.name$1 = null;
  this.io$youi$theme$StyleProp$$parent$f = null;
  this.io$youi$theme$StyleProp$$default$f = null;
  this.option$1 = null;
  this.value$1 = null
}
$c_Lio_youi_theme_StyleProp.prototype = new $h_O();
$c_Lio_youi_theme_StyleProp.prototype.constructor = $c_Lio_youi_theme_StyleProp;
/** @constructor */
function $h_Lio_youi_theme_StyleProp() {
  /*<skip>*/
}
$h_Lio_youi_theme_StyleProp.prototype = $c_Lio_youi_theme_StyleProp.prototype;
$c_Lio_youi_theme_StyleProp.prototype.init___T__Lreactify_Var__F0 = (function(name, parent, $default) {
  this.name$1 = name;
  this.io$youi$theme$StyleProp$$parent$f = parent;
  this.io$youi$theme$StyleProp$$default$f = $default;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_s_None$()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.option$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name$1);
  var value$1 = new $c_Lio_youi_theme_StyleProp$$anonfun$2().init___Lio_youi_theme_StyleProp(this);
  var name$2 = $m_s_None$();
  this.value$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$2);
  return this
});
$c_Lio_youi_theme_StyleProp.prototype.set__F0__V = (function(value) {
  var this$1 = this.option$1;
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(value$2) {
    return (function() {
      return $m_s_Option$().apply__O__s_Option(value$2.apply__O())
    })
  })(value));
  this$1.set__F0__V(value$1)
});
$c_Lio_youi_theme_StyleProp.prototype.attachAndFire__F1__Lreactify_reaction_Reaction = (function(f) {
  var this$2 = this.value$1;
  var priority = $m_Lreactify_Priority$().Normal$1;
  return $s_Lreactify_Val$class__attachAndFire__Lreactify_Val__F1__D__Lreactify_reaction_Reaction(this$2, f, priority)
});
$c_Lio_youi_theme_StyleProp.prototype.$$colon$eq__F0__V = (function(value) {
  var this$1 = this.option$1;
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(value$1) {
    return (function() {
      return $m_s_Option$().apply__O__s_Option(value$1.apply__O())
    })
  })(value));
  this$1.set__F0__V(value$2)
});
function $is_Lio_youi_theme_StyleProp(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_theme_StyleProp)))
}
function $as_Lio_youi_theme_StyleProp(obj) {
  return (($is_Lio_youi_theme_StyleProp(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.theme.StyleProp"))
}
function $isArrayOf_Lio_youi_theme_StyleProp(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_theme_StyleProp)))
}
function $asArrayOf_Lio_youi_theme_StyleProp(obj, depth) {
  return (($isArrayOf_Lio_youi_theme_StyleProp(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.theme.StyleProp;", depth))
}
var $d_Lio_youi_theme_StyleProp = new $TypeData().initClass({
  Lio_youi_theme_StyleProp: 0
}, false, "io.youi.theme.StyleProp", {
  Lio_youi_theme_StyleProp: 1,
  O: 1
});
$c_Lio_youi_theme_StyleProp.prototype.$classData = $d_Lio_youi_theme_StyleProp;
function $is_Lio_youi_theme_Theme(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_theme_Theme)))
}
function $as_Lio_youi_theme_Theme(obj) {
  return (($is_Lio_youi_theme_Theme(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.theme.Theme"))
}
function $isArrayOf_Lio_youi_theme_Theme(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_theme_Theme)))
}
function $asArrayOf_Lio_youi_theme_Theme(obj, depth) {
  return (($isArrayOf_Lio_youi_theme_Theme(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.theme.Theme;", depth))
}
/** @constructor */
function $c_Lio_youi_theme_mixins_HTMLFontTheme$font$() {
  $c_O.call(this);
  this.family$1 = null;
  this.weight$1 = null;
  this.size$1 = null
}
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype = new $h_O();
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.constructor = $c_Lio_youi_theme_mixins_HTMLFontTheme$font$;
/** @constructor */
function $h_Lio_youi_theme_mixins_HTMLFontTheme$font$() {
  /*<skip>*/
}
$h_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype = $c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype;
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.$$colon$eq__Lio_youi_font_GoogleFont__V = (function(gf) {
  this.family$1.$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(gf$1) {
    return (function() {
      var value = gf$1.family__T();
      return new $c_Lio_youi_style_FontFamily().init___T(value)
    })
  })(gf)));
  this.weight$1.$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return new $c_Lio_youi_style_FontWeight().init___T($m_Lio_youi_style_FontWeight$().default$1)
  })))
});
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.$$colon$eq__Lio_youi_font_GoogleFontWeight__V = (function(gfw) {
  this.family$1.$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(gfw$1) {
    return (function() {
      var value = gfw$1.font$1.family__T();
      return new $c_Lio_youi_style_FontFamily().init___T(value)
    })
  })(gfw)));
  this.weight$1.$$colon$eq__F0__V(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(gfw$1$1) {
    return (function() {
      var value$1 = gfw$1$1.name$1;
      return new $c_Lio_youi_style_FontWeight().init___T(value$1)
    })
  })(gfw)))
});
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.init___Lio_youi_theme_mixins_HTMLFontTheme = (function($$outer) {
  var $default = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return new $c_Lio_youi_style_FontFamily().init___T($m_Lio_youi_style_FontFamily$().default$1)
  }));
  var connect = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_FontFamily$());
  this.family$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$outer, "font-family", $default, connect, true, false, false);
  var $default$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return new $c_Lio_youi_style_FontWeight().init___T($m_Lio_youi_style_FontWeight$().default$1)
  }));
  var connect$1 = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($m_Lio_youi_style_FontWeight$());
  this.weight$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$outer, "font-weight", $default$1, connect$1, true, false, false);
  var $default$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return 12.0
  }));
  var connect$2 = $m_Lio_youi_theme_StyleConnect$().style__Lio_youi_theme_Stringify__s_Option($s_Lio_youi_theme_StringifyImplicits$class__stringifyDouble__Lio_youi_theme_StringifyImplicits__Lio_youi_theme_Stringify($$outer));
  this.size$1 = $s_Lio_youi_theme_Theme$class__style__Lio_youi_theme_Theme__T__F0__s_Option__Z__Z__Z__Lio_youi_theme_StyleProp($$outer, "font-size", $default$2, connect$2, true, false, false);
  return this
});
var $d_Lio_youi_theme_mixins_HTMLFontTheme$font$ = new $TypeData().initClass({
  Lio_youi_theme_mixins_HTMLFontTheme$font$: 0
}, false, "io.youi.theme.mixins.HTMLFontTheme$font$", {
  Lio_youi_theme_mixins_HTMLFontTheme$font$: 1,
  O: 1
});
$c_Lio_youi_theme_mixins_HTMLFontTheme$font$.prototype.$classData = $d_Lio_youi_theme_mixins_HTMLFontTheme$font$;
/** @constructor */
function $c_Lio_youi_util_LazyFuture() {
  $c_O.call(this);
  this.f$1 = null;
  this.maxFrequency$1 = null;
  this.automatic$1 = false;
  this.lastUpdate$1 = null;
  this.dirty$1 = null;
  this.future$1 = null
}
$c_Lio_youi_util_LazyFuture.prototype = new $h_O();
$c_Lio_youi_util_LazyFuture.prototype.constructor = $c_Lio_youi_util_LazyFuture;
/** @constructor */
function $h_Lio_youi_util_LazyFuture() {
  /*<skip>*/
}
$h_Lio_youi_util_LazyFuture.prototype = $c_Lio_youi_util_LazyFuture.prototype;
$c_Lio_youi_util_LazyFuture.prototype.init___F0__s_concurrent_duration_FiniteDuration__Z = (function(f, maxFrequency, automatic) {
  this.f$1 = f;
  this.maxFrequency$1 = maxFrequency;
  this.automatic$1 = automatic;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    return $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.lastUpdate$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  this.dirty$1 = new $c_ju_concurrent_atomic_AtomicBoolean().init___Z(false);
  this.future$1 = $m_s_None$();
  return this
});
$c_Lio_youi_util_LazyFuture.prototype.isReady__Z = (function() {
  var t = this.delay__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  return ((lo === 0) && (hi === 0))
});
$c_Lio_youi_util_LazyFuture.prototype.elapsed__J = (function() {
  var t = $m_jl_System$().currentTimeMillis__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  var v = this.lastUpdate$1;
  var b = $uJ(v.state__Lreactify_State().value__O());
  var bhi = b.hi$2;
  var lo$1 = ((lo - b.lo$2) | 0);
  var hi$1 = ((((-2147483648) ^ lo$1) > ((-2147483648) ^ lo)) ? (((-1) + ((hi - bhi) | 0)) | 0) : ((hi - bhi) | 0));
  return new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1)
});
$c_Lio_youi_util_LazyFuture.prototype.update__Z__V = (function(force) {
  var this$1 = this.future$1;
  if (this$1.isEmpty__Z()) {
    var finished = true
  } else {
    var arg1 = this$1.get__O();
    var x$2 = $as_s_concurrent_Future(arg1);
    var finished = x$2.isCompleted__Z()
  };
  if (finished) {
    var this$2 = this.future$1;
    if (this$2.isDefined__Z()) {
      this.future$1 = $m_s_None$();
      var this$3 = this.lastUpdate$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
        return $m_jl_System$().currentTimeMillis__J()
      }));
      this$3.set__F0__V(value)
    };
    if (((this.isReady__Z() && this.dirty$1.compareAndSet__Z__Z__Z(true, false)) || force)) {
      var future = $as_s_concurrent_Future(this.f$1.apply__O());
      var this$4 = $s_s_concurrent_Future$class__failed__s_concurrent_Future__s_concurrent_Future(future);
      var f = new $c_Lio_youi_util_LazyFuture$$anonfun$update$2().init___Lio_youi_util_LazyFuture(this);
      var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
      $s_s_concurrent_Future$class__foreach__s_concurrent_Future__F1__s_concurrent_ExecutionContext__V(this$4, f, executor);
      if (this.automatic$1) {
        future.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(arg$outer) {
          return (function(x$3$2) {
            $as_s_util_Try(x$3$2);
            arg$outer.update__Z__V(false)
          })
        })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor())
      };
      this.future$1 = new $c_s_Some().init___O(future)
    }
  }
});
$c_Lio_youi_util_LazyFuture.prototype.delay__J = (function() {
  var this$1 = this.maxFrequency$1;
  var t = this$1.unit$2.toMillis__J__J(this$1.length$2);
  var lo = t.lo$2;
  var hi = t.hi$2;
  var b = this.elapsed__J();
  var bhi = b.hi$2;
  var lo$1 = ((lo - b.lo$2) | 0);
  var hi$1 = ((((-2147483648) ^ lo$1) > ((-2147483648) ^ lo)) ? (((-1) + ((hi - bhi) | 0)) | 0) : ((hi - bhi) | 0));
  return ((hi$1 < 0) ? $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong() : new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1))
});
$c_Lio_youi_util_LazyFuture.prototype.flag__s_concurrent_Future = (function() {
  if (this.dirty$1.compareAndSet__Z__Z__Z(false, true)) {
    if (this.automatic$1) {
      if (this.isReady__Z()) {
        this.update__Z__V(false)
      } else {
        var this$5 = $m_Lio_youi_AnimationFrame$();
        var t = this.delay__J();
        var lo = t.lo$2;
        var hi = t.hi$2;
        var this$2 = new $c_s_concurrent_duration_package$DurationLong().init___J(new $c_sjsr_RuntimeLong().init___I__I(lo, hi));
        var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
        var t$1 = this$2.scala$concurrent$duration$DurationLong$$n$1;
        var lo$1 = t$1.lo$2;
        var hi$1 = t$1.hi$2;
        $m_s_concurrent_duration_Duration$();
        var delay = new $c_s_concurrent_duration_FiniteDuration().init___J__ju_concurrent_TimeUnit(new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1), unit);
        var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
          return (function() {
            arg$outer.update__Z__V(false)
          })
        })(this));
        $s_Lio_youi_Updates$class__once__Lio_youi_Updates__s_concurrent_duration_FiniteDuration__F0__V(this$5, delay, f)
      }
    }
  };
  var p = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var this$9 = this.lastUpdate$1;
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(p$1) {
    return (function(x$1$2) {
      var t$2 = $uJ(x$1$2);
      $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(p$1, (void 0))
    })
  })(p));
  var this$7 = this.lastUpdate$1;
  var condition = $s_Lreactify_Reactive$class__once$default$2__Lreactify_Reactive__F1(this$7);
  var priority = $m_Lreactify_Priority$().Normal$1;
  $s_Lreactify_Reactive$class__once__Lreactify_Reactive__F1__F1__D__Lreactify_reaction_Reaction(this$9, f$1, condition, priority);
  return p
});
var $d_Lio_youi_util_LazyFuture = new $TypeData().initClass({
  Lio_youi_util_LazyFuture: 0
}, false, "io.youi.util.LazyFuture", {
  Lio_youi_util_LazyFuture: 1,
  O: 1
});
$c_Lio_youi_util_LazyFuture.prototype.$classData = $d_Lio_youi_util_LazyFuture;
/** @constructor */
function $c_Lio_youi_util_LazyFuture$() {
  $c_O.call(this)
}
$c_Lio_youi_util_LazyFuture$.prototype = new $h_O();
$c_Lio_youi_util_LazyFuture$.prototype.constructor = $c_Lio_youi_util_LazyFuture$;
/** @constructor */
function $h_Lio_youi_util_LazyFuture$() {
  /*<skip>*/
}
$h_Lio_youi_util_LazyFuture$.prototype = $c_Lio_youi_util_LazyFuture$.prototype;
$c_Lio_youi_util_LazyFuture$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_util_LazyFuture$.prototype.apply$default$2__s_concurrent_duration_FiniteDuration = (function() {
  var this$2 = new $c_s_concurrent_duration_package$DurationInt().init___I(0);
  var unit = $m_ju_concurrent_TimeUnit$().MILLISECONDS$1;
  return $m_s_concurrent_duration_package$DurationInt$().durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration(this$2.scala$concurrent$duration$DurationInt$$n$1, unit)
});
var $d_Lio_youi_util_LazyFuture$ = new $TypeData().initClass({
  Lio_youi_util_LazyFuture$: 0
}, false, "io.youi.util.LazyFuture$", {
  Lio_youi_util_LazyFuture$: 1,
  O: 1
});
$c_Lio_youi_util_LazyFuture$.prototype.$classData = $d_Lio_youi_util_LazyFuture$;
var $n_Lio_youi_util_LazyFuture$ = (void 0);
function $m_Lio_youi_util_LazyFuture$() {
  if ((!$n_Lio_youi_util_LazyFuture$)) {
    $n_Lio_youi_util_LazyFuture$ = new $c_Lio_youi_util_LazyFuture$().init___()
  };
  return $n_Lio_youi_util_LazyFuture$
}
/** @constructor */
function $c_Lio_youi_util_Measurer$() {
  $c_O.call(this);
  this.container$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_util_Measurer$.prototype = new $h_O();
$c_Lio_youi_util_Measurer$.prototype.constructor = $c_Lio_youi_util_Measurer$;
/** @constructor */
function $h_Lio_youi_util_Measurer$() {
  /*<skip>*/
}
$h_Lio_youi_util_Measurer$.prototype = $c_Lio_youi_util_Measurer$.prototype;
$c_Lio_youi_util_Measurer$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_util_Measurer$.prototype.container__p1__Lorg_scalajs_dom_raw_HTMLSpanElement = (function() {
  return ((!this.bitmap$0$1) ? this.container$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLSpanElement() : this.container$1)
});
$c_Lio_youi_util_Measurer$.prototype.measure__Lorg_scalajs_dom_raw_HTMLElement__Lio_youi_spatial_Size = (function(element) {
  return this.measure__T__Lio_youi_spatial_Size($as_T(element.outerHTML))
});
$c_Lio_youi_util_Measurer$.prototype.measure__T__Lio_youi_spatial_Size = (function(htmlString) {
  this.container__p1__Lorg_scalajs_dom_raw_HTMLSpanElement().innerHTML = htmlString;
  var e = this.container__p1__Lorg_scalajs_dom_raw_HTMLSpanElement().firstElementChild;
  e.style.width = "auto";
  e.style.height = "auto";
  e.style.whiteSpace = "nowrap";
  e.style.position = "static";
  e.style.visibility = "hidden";
  var bounding = e.getBoundingClientRect();
  var width = $uD(bounding.width);
  var height = $uD(bounding.height);
  return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width, height)
});
$c_Lio_youi_util_Measurer$.prototype.container$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLSpanElement = (function() {
  if ((!this.bitmap$0$1)) {
    var span = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("span");
    span.style.position = "absolute";
    span.style.visibility = "hidden";
    span.style.width = "auto";
    span.style.height = "auto";
    span.style.whiteSpace = "nowrap";
    $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(span);
    this.container$1 = span;
    this.bitmap$0$1 = true
  };
  return this.container$1
});
var $d_Lio_youi_util_Measurer$ = new $TypeData().initClass({
  Lio_youi_util_Measurer$: 0
}, false, "io.youi.util.Measurer$", {
  Lio_youi_util_Measurer$: 1,
  O: 1
});
$c_Lio_youi_util_Measurer$.prototype.$classData = $d_Lio_youi_util_Measurer$;
var $n_Lio_youi_util_Measurer$ = (void 0);
function $m_Lio_youi_util_Measurer$() {
  if ((!$n_Lio_youi_util_Measurer$)) {
    $n_Lio_youi_util_Measurer$ = new $c_Lio_youi_util_Measurer$().init___()
  };
  return $n_Lio_youi_util_Measurer$
}
/** @constructor */
function $c_Lio_youi_util_SizeUtility$() {
  $c_O.call(this)
}
$c_Lio_youi_util_SizeUtility$.prototype = new $h_O();
$c_Lio_youi_util_SizeUtility$.prototype.constructor = $c_Lio_youi_util_SizeUtility$;
/** @constructor */
function $h_Lio_youi_util_SizeUtility$() {
  /*<skip>*/
}
$h_Lio_youi_util_SizeUtility$.prototype = $c_Lio_youi_util_SizeUtility$.prototype;
$c_Lio_youi_util_SizeUtility$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_util_SizeUtility$.prototype.size__s_Option__s_Option__Lio_youi_spatial_Size__Lio_youi_spatial_Size = (function(width, height, original) {
  if ($is_s_Some(width)) {
    var x2 = $as_s_Some(width);
    var w = $uD(x2.x$2);
    if ($is_s_Some(height)) {
      var x2$2 = $as_s_Some(height);
      var h = $uD(x2$2.x$2);
      return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(w, h)
    } else {
      var x = $m_s_None$();
      if ((x === height)) {
        var aspectRatio = (original.height$1 / original.width$1);
        var height$1 = (w * aspectRatio);
        return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(w, height$1)
      } else {
        throw new $c_s_MatchError().init___O(height)
      }
    }
  } else {
    var x$3 = $m_s_None$();
    if ((x$3 === width)) {
      if ($is_s_Some(height)) {
        var x2$3 = $as_s_Some(height);
        var h$2 = $uD(x2$3.x$2);
        var aspectRatio$2 = (original.width$1 / original.height$1);
        var width$1 = (h$2 * aspectRatio$2);
        return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width$1, h$2)
      } else {
        var x$5 = $m_s_None$();
        if ((x$5 === height)) {
          var width$2 = original.width$1;
          var height$2 = original.height$1;
          return new $c_Lio_youi_spatial_ImmutableSize().init___D__D(width$2, height$2)
        } else {
          throw new $c_s_MatchError().init___O(height)
        }
      }
    } else {
      throw new $c_s_MatchError().init___O(width)
    }
  }
});
var $d_Lio_youi_util_SizeUtility$ = new $TypeData().initClass({
  Lio_youi_util_SizeUtility$: 0
}, false, "io.youi.util.SizeUtility$", {
  Lio_youi_util_SizeUtility$: 1,
  O: 1
});
$c_Lio_youi_util_SizeUtility$.prototype.$classData = $d_Lio_youi_util_SizeUtility$;
var $n_Lio_youi_util_SizeUtility$ = (void 0);
function $m_Lio_youi_util_SizeUtility$() {
  if ((!$n_Lio_youi_util_SizeUtility$)) {
    $n_Lio_youi_util_SizeUtility$ = new $c_Lio_youi_util_SizeUtility$().init___()
  };
  return $n_Lio_youi_util_SizeUtility$
}
/** @constructor */
function $c_Lio_youi_video_Video$() {
  $c_O.call(this)
}
$c_Lio_youi_video_Video$.prototype = new $h_O();
$c_Lio_youi_video_Video$.prototype.constructor = $c_Lio_youi_video_Video$;
/** @constructor */
function $h_Lio_youi_video_Video$() {
  /*<skip>*/
}
$h_Lio_youi_video_Video$.prototype = $c_Lio_youi_video_Video$.prototype;
$c_Lio_youi_video_Video$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_video_Video$.prototype.apply__T__Z__Z__Z__s_concurrent_Future = (function(url, autoPlay, loop, muted) {
  var element = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("video");
  element.autoplay = autoPlay;
  element.loop = loop;
  element.muted = muted;
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  element.addEventListener("loadedmetadata", (function(autoPlay$1, loop$1, muted$1, element$1, promise$2) {
    return (function(x$8$2) {
      var v = new $c_Lio_youi_video_Video().init___Lorg_scalajs_dom_raw_HTMLVideoElement(element$1);
      v.io$youi$video$Video$$init__Z__Z__Z__V(autoPlay$1, loop$1, muted$1);
      return $s_s_concurrent_Promise$class__success__s_concurrent_Promise__O__s_concurrent_Promise(promise$2, v)
    })
  })(autoPlay, loop, muted, element, promise));
  element.src = url;
  return promise
});
var $d_Lio_youi_video_Video$ = new $TypeData().initClass({
  Lio_youi_video_Video$: 0
}, false, "io.youi.video.Video$", {
  Lio_youi_video_Video$: 1,
  O: 1
});
$c_Lio_youi_video_Video$.prototype.$classData = $d_Lio_youi_video_Video$;
var $n_Lio_youi_video_Video$ = (void 0);
function $m_Lio_youi_video_Video$() {
  if ((!$n_Lio_youi_video_Video$)) {
    $n_Lio_youi_video_Video$ = new $c_Lio_youi_video_Video$().init___()
  };
  return $n_Lio_youi_video_Video$
}
/** @constructor */
function $c_Lio_youi_virtual_VirtualSize() {
  $c_O.call(this);
  this.io$youi$virtual$VirtualSize$$screen$f = null;
  this.io$youi$virtual$VirtualSize$$size$1 = null;
  this.xOffset$1 = null;
  this.yOffset$1 = null;
  this.widthMultiplier$1 = null;
  this.heightMultiplier$1 = null
}
$c_Lio_youi_virtual_VirtualSize.prototype = new $h_O();
$c_Lio_youi_virtual_VirtualSize.prototype.constructor = $c_Lio_youi_virtual_VirtualSize;
/** @constructor */
function $h_Lio_youi_virtual_VirtualSize() {
  /*<skip>*/
}
$h_Lio_youi_virtual_VirtualSize.prototype = $c_Lio_youi_virtual_VirtualSize.prototype;
$c_Lio_youi_virtual_VirtualSize.prototype.init___Lio_youi_virtual_VirtualSizeSupport = (function(screen) {
  this.io$youi$virtual$VirtualSize$$screen$f = screen;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var v = arg$outer.io$youi$virtual$VirtualSize$$screen$f.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().width$1;
      if (($uD(v.state__Lreactify_State().value__O()) > 0.0)) {
        var v$1 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().height$1;
        var jsx$1 = ($uD(v$1.state__Lreactify_State().value__O()) > 0.0)
      } else {
        var jsx$1 = false
      };
      if (jsx$1) {
        var this$3 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.virtualMode$1;
        var x1 = $as_Lio_youi_virtual_VirtualMode(this$3.state__Lreactify_State().value__O());
        var x = $m_Lio_youi_virtual_VirtualMode$Bars$();
        if ((x === x1)) {
          var jsx$2 = true
        } else {
          var x$3 = $m_Lio_youi_virtual_VirtualMode$Clip$();
          if ((x$3 === x1)) {
            var jsx$2 = true
          } else {
            var x$5 = $m_Lio_youi_virtual_VirtualMode$FitWidth$();
            if ((x$5 === x1)) {
              var jsx$2 = true
            } else {
              var x$7 = $m_Lio_youi_virtual_VirtualMode$FitHeight$();
              var jsx$2 = (x$7 === x1)
            }
          }
        };
        if (jsx$2) {
          var v$2 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().width$1;
          var jsx$3 = $uD(v$2.state__Lreactify_State().value__O());
          var this$5 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.virtualWidth$1;
          var widthRatio = (jsx$3 / $uD(this$5.state__Lreactify_State().value__O()));
          var v$3 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().height$1;
          var jsx$4 = $uD(v$3.state__Lreactify_State().value__O());
          var this$7 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.virtualHeight$1;
          var heightRatio = (jsx$4 / $uD(this$7.state__Lreactify_State().value__O()));
          var this$8 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.virtualMode$1;
          var x1$2 = $as_Lio_youi_virtual_VirtualMode(this$8.state__Lreactify_State().value__O());
          var x$9 = $m_Lio_youi_virtual_VirtualMode$Bars$();
          if ((x$9 === x1$2)) {
            var ratio = $uD($g.Math.min(widthRatio, heightRatio))
          } else {
            var x$11 = $m_Lio_youi_virtual_VirtualMode$Clip$();
            if ((x$11 === x1$2)) {
              var ratio = $uD($g.Math.max(widthRatio, heightRatio))
            } else {
              var x$13 = $m_Lio_youi_virtual_VirtualMode$FitWidth$();
              if ((x$13 === x1$2)) {
                var ratio = widthRatio
              } else {
                var x$15 = $m_Lio_youi_virtual_VirtualMode$FitHeight$();
                if ((x$15 === x1$2)) {
                  var ratio = heightRatio
                } else {
                  var ratio = 0.0
                }
              }
            }
          };
          var v$4 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.virtualWidth$1;
          var w = ($uD(v$4.state__Lreactify_State().value__O()) * ratio);
          var v$5 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.virtualHeight$1;
          var h = ($uD(v$5.state__Lreactify_State().value__O()) * ratio);
          var v$6 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().width$1;
          var jsx$5 = $uD(v$6.state__Lreactify_State().value__O());
          var v$7 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().height$1;
          return new $c_T4().init___O__O__O__O(((jsx$5 - w) / 2.0), (($uD(v$7.state__Lreactify_State().value__O()) - h) / 2.0), ratio, ratio)
        } else {
          var x$17 = $m_Lio_youi_virtual_VirtualMode$Stretch$();
          if ((x$17 === x1)) {
            var v$8 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().width$1;
            var jsx$8 = $uD(v$8.state__Lreactify_State().value__O());
            var v$9 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.virtualWidth$1;
            var jsx$7 = $uD(v$9.state__Lreactify_State().value__O());
            var v$10 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.actual__Lio_youi_virtual_VirtualSizeSupport$actual$().height$1;
            var jsx$6 = $uD(v$10.state__Lreactify_State().value__O());
            var v$11 = arg$outer.io$youi$virtual$VirtualSize$$screen$f.virtualHeight$1;
            return new $c_T4().init___O__O__O__O(0.0, 0.0, (jsx$8 / jsx$7), (jsx$6 / $uD(v$11.state__Lreactify_State().value__O())))
          } else {
            throw new $c_s_MatchError().init___O(x1)
          }
        }
      } else {
        return new $c_T4().init___O__O__O__O(0.0, 0.0, 1.0, 1.0)
      }
    })
  })(this));
  var name = $m_s_None$();
  this.io$youi$virtual$VirtualSize$$size$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer$1) {
    return (function() {
      var v$12 = arg$outer$1.io$youi$virtual$VirtualSize$$size$1;
      return $uD($as_T4(v$12.state__Lreactify_State().value__O()).$$und1$1)
    })
  })(this));
  var name$1 = $m_s_None$();
  this.xOffset$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$1, name$1);
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer$2) {
    return (function() {
      var v$13 = arg$outer$2.io$youi$virtual$VirtualSize$$size$1;
      return $uD($as_T4(v$13.state__Lreactify_State().value__O()).$$und2$1)
    })
  })(this));
  var name$2 = $m_s_None$();
  this.yOffset$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$2, name$2);
  var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer$3) {
    return (function() {
      var v$14 = arg$outer$3.io$youi$virtual$VirtualSize$$size$1;
      return $uD($as_T4(v$14.state__Lreactify_State().value__O()).$$und3$1)
    })
  })(this));
  var name$3 = $m_s_None$();
  this.widthMultiplier$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$3, name$3);
  var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer$4) {
    return (function() {
      var v$15 = arg$outer$4.io$youi$virtual$VirtualSize$$size$1;
      return $uD($as_T4(v$15.state__Lreactify_State().value__O()).$$und4$1)
    })
  })(this));
  var name$4 = $m_s_None$();
  this.heightMultiplier$1 = new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value$4, name$4);
  return this
});
var $d_Lio_youi_virtual_VirtualSize = new $TypeData().initClass({
  Lio_youi_virtual_VirtualSize: 0
}, false, "io.youi.virtual.VirtualSize", {
  Lio_youi_virtual_VirtualSize: 1,
  O: 1
});
$c_Lio_youi_virtual_VirtualSize.prototype.$classData = $d_Lio_youi_virtual_VirtualSize;
/** @constructor */
function $c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels() {
  $c_O.call(this);
  this.io$youi$virtual$VirtualSizeSupport$IntVirtualPixels$$i$f = 0;
  this.$$outer$f = null
}
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype = new $h_O();
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.constructor = $c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels;
/** @constructor */
function $h_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels() {
  /*<skip>*/
}
$h_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype = $c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype;
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.vh__Lreactify_Val = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var jsx$1 = arg$outer.io$youi$virtual$VirtualSizeSupport$IntVirtualPixels$$i$f;
      var v = arg$outer.$$outer$f.virtual$1.heightMultiplier$1;
      return (jsx$1 * $uD(v.state__Lreactify_State().value__O()))
    })
  })(this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.init___Lio_youi_virtual_VirtualSizeSupport__I = (function($$outer, i) {
  this.io$youi$virtual$VirtualSizeSupport$IntVirtualPixels$$i$f = i;
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$f = $$outer
  };
  return this
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.vy__Lreactify_Val = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var this$1 = arg$outer.vh__Lreactify_Val();
      var jsx$1 = $uD(this$1.state__Lreactify_State().value__O());
      var this$2 = arg$outer.$$outer$f.virtual$1.yOffset$1;
      return (jsx$1 + $uD(this$2.state__Lreactify_State().value__O()))
    })
  })(this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.vx__Lreactify_Val = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var this$1 = arg$outer.vw__Lreactify_Val();
      var jsx$1 = $uD(this$1.state__Lreactify_State().value__O());
      var this$2 = arg$outer.$$outer$f.virtual$1.xOffset$1;
      return (jsx$1 + $uD(this$2.state__Lreactify_State().value__O()))
    })
  })(this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.vw__Lreactify_Val = (function() {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer) {
    return (function() {
      var jsx$1 = arg$outer.io$youi$virtual$VirtualSizeSupport$IntVirtualPixels$$i$f;
      var v = arg$outer.$$outer$f.virtual$1.widthMultiplier$1;
      return (jsx$1 * $uD(v.state__Lreactify_State().value__O()))
    })
  })(this));
  var name = $m_s_None$();
  return new $c_Lreactify_standard_StandardVal().init___F0__s_Option(value, name)
});
var $d_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels = new $TypeData().initClass({
  Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels: 0
}, false, "io.youi.virtual.VirtualSizeSupport$IntVirtualPixels", {
  Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels: 1,
  O: 1
});
$c_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels.prototype.$classData = $d_Lio_youi_virtual_VirtualSizeSupport$IntVirtualPixels;
/** @constructor */
function $c_Lio_youi_virtual_VirtualSizeSupport$actual$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null
}
$c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype = new $h_O();
$c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype.constructor = $c_Lio_youi_virtual_VirtualSizeSupport$actual$;
/** @constructor */
function $h_Lio_youi_virtual_VirtualSizeSupport$actual$() {
  /*<skip>*/
}
$h_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype = $c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype;
$c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype.init___Lio_youi_virtual_VirtualSizeSupport = (function($$outer) {
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    var v = $m_Lio_youi_ui$().size__Lio_youi_component_extras_HTMLComponentSize().width__Lreactify_Var();
    return $uD(v.state__Lreactify_State().value__O())
  }));
  var mode = $m_Lreactify_Var$Mode$Normal$();
  var name = $m_s_None$();
  this.width$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value, mode, name);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function() {
    var v$1 = $m_Lio_youi_ui$().size__Lio_youi_component_extras_HTMLComponentSize().height__Lreactify_Var();
    return $uD(v$1.state__Lreactify_State().value__O())
  }));
  var mode$1 = $m_Lreactify_Var$Mode$Normal$();
  var name$1 = $m_s_None$();
  this.height$1 = new $c_Lreactify_standard_StandardVar().init___F0__Lreactify_Var$Mode__s_Option(value$1, mode$1, name$1);
  return this
});
var $d_Lio_youi_virtual_VirtualSizeSupport$actual$ = new $TypeData().initClass({
  Lio_youi_virtual_VirtualSizeSupport$actual$: 0
}, false, "io.youi.virtual.VirtualSizeSupport$actual$", {
  Lio_youi_virtual_VirtualSizeSupport$actual$: 1,
  O: 1
});
$c_Lio_youi_virtual_VirtualSizeSupport$actual$.prototype.$classData = $d_Lio_youi_virtual_VirtualSizeSupport$actual$;
function $is_Ljava_io_Closeable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Ljava_io_Closeable)))
}
function $as_Ljava_io_Closeable(obj) {
  return (($is_Ljava_io_Closeable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.io.Closeable"))
}
function $isArrayOf_Ljava_io_Closeable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Ljava_io_Closeable)))
}
function $asArrayOf_Ljava_io_Closeable(obj, depth) {
  return (($isArrayOf_Ljava_io_Closeable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.io.Closeable;", depth))
}
/** @constructor */
function $c_Ljava_math_BigInteger$QuotAndRem() {
  $c_O.call(this);
  this.quot$1 = null;
  this.rem$1 = null
}
$c_Ljava_math_BigInteger$QuotAndRem.prototype = new $h_O();
$c_Ljava_math_BigInteger$QuotAndRem.prototype.constructor = $c_Ljava_math_BigInteger$QuotAndRem;
/** @constructor */
function $h_Ljava_math_BigInteger$QuotAndRem() {
  /*<skip>*/
}
$h_Ljava_math_BigInteger$QuotAndRem.prototype = $c_Ljava_math_BigInteger$QuotAndRem.prototype;
$c_Ljava_math_BigInteger$QuotAndRem.prototype.toArray__ALjava_math_BigInteger = (function() {
  var array = [this.quot$1, this.rem$1];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var len = $uI(xs.array$6.length);
  var array$1 = $newArrayObject($d_Ljava_math_BigInteger.getArrayOf(), [len]);
  var elem$1 = 0;
  elem$1 = 0;
  var this$6 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
  while (this$6.hasNext__Z()) {
    var arg1 = this$6.next__O();
    array$1.set(elem$1, arg1);
    elem$1 = ((1 + elem$1) | 0)
  };
  return array$1
});
$c_Ljava_math_BigInteger$QuotAndRem.prototype.init___Ljava_math_BigInteger__Ljava_math_BigInteger = (function(quot, rem) {
  this.quot$1 = quot;
  this.rem$1 = rem;
  return this
});
var $d_Ljava_math_BigInteger$QuotAndRem = new $TypeData().initClass({
  Ljava_math_BigInteger$QuotAndRem: 0
}, false, "java.math.BigInteger$QuotAndRem", {
  Ljava_math_BigInteger$QuotAndRem: 1,
  O: 1
});
$c_Ljava_math_BigInteger$QuotAndRem.prototype.$classData = $d_Ljava_math_BigInteger$QuotAndRem;
/** @constructor */
function $c_Ljava_math_BitLevel$() {
  $c_O.call(this)
}
$c_Ljava_math_BitLevel$.prototype = new $h_O();
$c_Ljava_math_BitLevel$.prototype.constructor = $c_Ljava_math_BitLevel$;
/** @constructor */
function $h_Ljava_math_BitLevel$() {
  /*<skip>*/
}
$h_Ljava_math_BitLevel$.prototype = $c_Ljava_math_BitLevel$.prototype;
$c_Ljava_math_BitLevel$.prototype.init___ = (function() {
  return this
});
$c_Ljava_math_BitLevel$.prototype.shiftLeftOneBit__AI__AI__I__V = (function(result, source, srcLen) {
  var elem$1 = 0;
  elem$1 = 0;
  var isEmpty$4 = (srcLen <= 0);
  var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + srcLen) | 0));
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      var iVal = source.get(v1);
      result.set(v1, ((iVal << 1) | elem$1));
      elem$1 = ((iVal >>> 31) | 0);
      if ((i === lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  if ((elem$1 !== 0)) {
    result.set(srcLen, elem$1)
  }
});
$c_Ljava_math_BitLevel$.prototype.shiftLeft__Ljava_math_BigInteger__I__Ljava_math_BigInteger = (function(source, count) {
  var intCount = (count >> 5);
  var andCount = (31 & count);
  var offset = ((andCount === 0) ? 0 : 1);
  var resLength = ((((source.numberLength$2 + intCount) | 0) + offset) | 0);
  var resDigits = $newArrayObject($d_I.getArrayOf(), [resLength]);
  this.shiftLeft__AI__AI__I__I__V(resDigits, source.digits$2, intCount, andCount);
  var result = new $c_Ljava_math_BigInteger().init___I__I__AI(source.sign$2, resLength, resDigits);
  result.cutOffLeadingZeroes__V();
  return result
});
$c_Ljava_math_BitLevel$.prototype.shiftRight__Ljava_math_BigInteger__I__Ljava_math_BigInteger = (function(source, count) {
  var intCount = (count >> 5);
  var andCount = (31 & count);
  if ((intCount >= source.numberLength$2)) {
    return ((source.sign$2 < 0) ? $m_Ljava_math_BigInteger$().MINUS$undONE$1 : $m_Ljava_math_BigInteger$().ZERO$1)
  } else {
    var resLength = ((source.numberLength$2 - intCount) | 0);
    var resDigits = $newArrayObject($d_I.getArrayOf(), [((1 + resLength) | 0)]);
    this.shiftRight__AI__I__AI__I__I__Z(resDigits, resLength, source.digits$2, intCount, andCount);
    if ((source.sign$2 < 0)) {
      var i = 0;
      while (((i < intCount) && (source.digits$2.get(i) === 0))) {
        i = ((1 + i) | 0)
      };
      var cmp = ((source.digits$2.get(i) << ((32 - andCount) | 0)) !== 0);
      if (((i < intCount) || ((andCount > 0) && cmp))) {
        i = 0;
        while (((i < resLength) && (resDigits.get(i) === (-1)))) {
          resDigits.set(i, 0);
          i = ((1 + i) | 0)
        };
        if ((i === resLength)) {
          resLength = ((1 + resLength) | 0)
        };
        var ev$6 = i;
        resDigits.set(ev$6, ((1 + resDigits.get(ev$6)) | 0))
      }
    };
    var result = new $c_Ljava_math_BigInteger().init___I__I__AI(source.sign$2, resLength, resDigits);
    result.cutOffLeadingZeroes__V();
    return result
  }
});
$c_Ljava_math_BitLevel$.prototype.shiftLeftOneBit__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(source) {
  var srcLen = source.numberLength$2;
  var resLen = ((1 + srcLen) | 0);
  var resDigits = $newArrayObject($d_I.getArrayOf(), [resLen]);
  this.shiftLeftOneBit__AI__AI__I__V(resDigits, source.digits$2, srcLen);
  var result = new $c_Ljava_math_BigInteger().init___I__I__AI(source.sign$2, resLen, resDigits);
  result.cutOffLeadingZeroes__V();
  return result
});
$c_Ljava_math_BitLevel$.prototype.bitLength__Ljava_math_BigInteger__I = (function(bi) {
  if ((bi.sign$2 === 0)) {
    return 0
  } else {
    var bLength = (bi.numberLength$2 << 5);
    var highDigit = bi.digits$2.get((((-1) + bi.numberLength$2) | 0));
    if ((bi.sign$2 < 0)) {
      var i = bi.getFirstNonzeroDigit__I();
      if ((i === (((-1) + bi.numberLength$2) | 0))) {
        highDigit = (((-1) + highDigit) | 0)
      }
    };
    bLength = ((bLength - $clz32(highDigit)) | 0);
    return bLength
  }
});
$c_Ljava_math_BitLevel$.prototype.shiftRight__AI__I__AI__I__I__Z = (function(result, resultLen, source, intCount, count) {
  var i = 0;
  var allZero = true;
  while ((i < intCount)) {
    allZero = (!(!(allZero & (source.get(i) === 0))));
    i = ((1 + i) | 0)
  };
  if ((count === 0)) {
    $systemArraycopy(source, intCount, result, 0, resultLen)
  } else {
    var leftShiftCount = ((32 - count) | 0);
    allZero = (!(!(allZero & ((source.get(i) << leftShiftCount) === 0))));
    i = 0;
    while ((i < (((-1) + resultLen) | 0))) {
      result.set(i, (((source.get(((i + intCount) | 0)) >>> count) | 0) | (source.get(((1 + ((i + intCount) | 0)) | 0)) << leftShiftCount)));
      i = ((1 + i) | 0)
    };
    result.set(i, ((source.get(((i + intCount) | 0)) >>> count) | 0));
    i = ((1 + i) | 0)
  };
  return allZero
});
$c_Ljava_math_BitLevel$.prototype.shiftLeft__AI__AI__I__I__V = (function(result, source, intCount, count) {
  if ((count === 0)) {
    $systemArraycopy(source, 0, result, intCount, ((result.u.length - intCount) | 0))
  } else {
    var rightShiftCount = ((32 - count) | 0);
    result.set((((-1) + result.u.length) | 0), 0);
    var i = (((-1) + result.u.length) | 0);
    while ((i > intCount)) {
      var ev$5 = i;
      result.set(ev$5, (result.get(ev$5) | ((source.get((((-1) + ((i - intCount) | 0)) | 0)) >>> rightShiftCount) | 0)));
      result.set((((-1) + i) | 0), (source.get((((-1) + ((i - intCount) | 0)) | 0)) << count));
      i = (((-1) + i) | 0)
    }
  };
  var isEmpty$4 = (intCount <= 0);
  var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + intCount) | 0));
  if ((!isEmpty$4)) {
    var i$1 = 0;
    while (true) {
      var v1 = i$1;
      result.set(v1, 0);
      if ((i$1 === lastElement$4)) {
        break
      };
      i$1 = ((1 + i$1) | 0)
    }
  }
});
var $d_Ljava_math_BitLevel$ = new $TypeData().initClass({
  Ljava_math_BitLevel$: 0
}, false, "java.math.BitLevel$", {
  Ljava_math_BitLevel$: 1,
  O: 1
});
$c_Ljava_math_BitLevel$.prototype.$classData = $d_Ljava_math_BitLevel$;
var $n_Ljava_math_BitLevel$ = (void 0);
function $m_Ljava_math_BitLevel$() {
  if ((!$n_Ljava_math_BitLevel$)) {
    $n_Ljava_math_BitLevel$ = new $c_Ljava_math_BitLevel$().init___()
  };
  return $n_Ljava_math_BitLevel$
}
/** @constructor */
function $c_Ljava_math_Conversion$() {
  $c_O.call(this);
  this.DigitFitInInt$1 = null;
  this.BigRadices$1 = null
}
$c_Ljava_math_Conversion$.prototype = new $h_O();
$c_Ljava_math_Conversion$.prototype.constructor = $c_Ljava_math_Conversion$;
/** @constructor */
function $h_Ljava_math_Conversion$() {
  /*<skip>*/
}
$h_Ljava_math_Conversion$.prototype = $c_Ljava_math_Conversion$.prototype;
$c_Ljava_math_Conversion$.prototype.init___ = (function() {
  $n_Ljava_math_Conversion$ = this;
  var array = [(-1), (-1), 31, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5];
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array);
  var len = $uI(xs.array$6.length);
  var array$1 = $newArrayObject($d_I.getArrayOf(), [len]);
  var elem$1 = 0;
  elem$1 = 0;
  var this$7 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
  while (this$7.hasNext__Z()) {
    var arg1 = this$7.next__O();
    array$1.set(elem$1, $uI(arg1));
    elem$1 = ((1 + elem$1) | 0)
  };
  this.DigitFitInInt$1 = array$1;
  var array$2 = [(-2147483648), 1162261467, 1073741824, 1220703125, 362797056, 1977326743, 1073741824, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 268435456, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 1073741824, 1291467969, 1544804416, 1838265625, 60466176];
  var xs$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$2);
  var len$1 = $uI(xs$1.array$6.length);
  var array$3 = $newArrayObject($d_I.getArrayOf(), [len$1]);
  var elem$1$1 = 0;
  elem$1$1 = 0;
  var this$14 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs$1, 0, $uI(xs$1.array$6.length));
  while (this$14.hasNext__Z()) {
    var arg1$1 = this$14.next__O();
    array$3.set(elem$1$1, $uI(arg1$1));
    elem$1$1 = ((1 + elem$1$1) | 0)
  };
  this.BigRadices$1 = array$3;
  return this
});
$c_Ljava_math_Conversion$.prototype.toDecimalScaledString__J__I__T = (function(value, scale) {
  if (((value.lo$2 === 0) && (value.hi$2 === 0))) {
    switch (scale) {
      case 0: {
        return "0";
        break
      }
      case 1: {
        return "0.0";
        break
      }
      case 2: {
        return "0.00";
        break
      }
      case 3: {
        return "0.000";
        break
      }
      case 4: {
        return "0.0000";
        break
      }
      case 5: {
        return "0.00000";
        break
      }
      case 6: {
        return "0.000000";
        break
      }
      default: {
        if ((scale === (-2147483648))) {
          var scaleVal = "2147483648"
        } else {
          var i = ((-scale) | 0);
          var scaleVal = ("" + i)
        };
        var result = ((scale < 0) ? "0E+" : "0E");
        return (result + scaleVal)
      }
    }
  } else {
    var ahi = value.hi$2;
    var negNumber = (ahi < 0);
    var elem$1 = null;
    elem$1 = "";
    var currentChar = 18;
    if (negNumber) {
      var lo = value.lo$2;
      var hi = value.hi$2;
      var lo$1 = ((-lo) | 0);
      var hi$1 = ((lo !== 0) ? (~hi) : ((-hi) | 0));
      var x_$_lo$2 = lo$1;
      var x_$_hi$2 = hi$1;
      var t = new $c_sjsr_RuntimeLong().init___I__I(x_$_lo$2, x_$_hi$2)
    } else {
      var t = value
    };
    var lo$2 = t.lo$2;
    var hi$2 = t.hi$2;
    var v_$_lo$2 = lo$2;
    var v_$_hi$2 = hi$2;
    while (true) {
      var prev_$_lo$2 = v_$_lo$2;
      var prev_$_hi$2 = v_$_hi$2;
      var this$5_$_lo$2 = v_$_lo$2;
      var this$5_$_hi$2 = v_$_hi$2;
      var this$6 = $m_sjsr_RuntimeLong$();
      var lo$3 = this$6.divideImpl__I__I__I__I__I(this$5_$_lo$2, this$5_$_hi$2, 10, 0);
      var hi$3 = this$6.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
      var jsx$1_$_lo$2 = lo$3;
      var jsx$1_$_hi$2 = hi$3;
      v_$_lo$2 = jsx$1_$_lo$2;
      v_$_hi$2 = jsx$1_$_hi$2;
      currentChar = (((-1) + currentChar) | 0);
      var b_$_lo$2 = v_$_lo$2;
      var b_$_hi$2 = v_$_hi$2;
      var blo = b_$_lo$2;
      var b0 = (65535 & blo);
      var b1 = ((blo >>> 16) | 0);
      var a0b0 = $imul(10, b0);
      var a0b1 = $imul(10, b1);
      var lo$4 = ((a0b0 + (a0b1 << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (($imul(10, b_$_hi$2) + ((c1part >>> 16) | 0)) | 0);
      var alo = prev_$_lo$2;
      var ahi$1 = prev_$_hi$2;
      var lo$5 = ((alo - lo$4) | 0);
      elem$1 = (("" + lo$5) + $as_T(elem$1));
      var this$9_$_lo$2 = v_$_lo$2;
      var this$9_$_hi$2 = v_$_hi$2;
      if ((!((this$9_$_lo$2 === 0) && (this$9_$_hi$2 === 0)))) {
        /*<skip>*/
      } else {
        break
      }
    };
    var exponent = (((-1) + ((((18 - currentChar) | 0) - scale) | 0)) | 0);
    if (((scale > 0) && (exponent >= (-6)))) {
      var index = ((1 + exponent) | 0);
      if ((index > 0)) {
        var thiz = $as_T(elem$1);
        var jsx$2 = $as_T(thiz.substring(0, index));
        var thiz$1 = $as_T(elem$1);
        elem$1 = ((jsx$2 + ".") + $as_T(thiz$1.substring(index)))
      } else {
        var end = ((-index) | 0);
        var isEmpty$4 = (end <= 0);
        var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + end) | 0));
        if ((!isEmpty$4)) {
          var i$1 = 0;
          while (true) {
            var v1 = i$1;
            elem$1 = ("0" + $as_T(elem$1));
            if ((i$1 === lastElement$4)) {
              break
            };
            i$1 = ((1 + i$1) | 0)
          }
        };
        elem$1 = ("0." + $as_T(elem$1))
      }
    } else if ((scale !== 0)) {
      var result1 = ("" + exponent);
      if ((exponent > 0)) {
        result1 = ("+" + result1)
      };
      result1 = ("E" + result1);
      if ((((18 - currentChar) | 0) > 1)) {
        var thiz$2 = $as_T(elem$1);
        var jsx$3 = $as_T(thiz$2.substring(0, 1));
        var thiz$3 = $as_T(elem$1);
        elem$1 = (((jsx$3 + ".") + $as_T(thiz$3.substring(1))) + result1)
      } else {
        elem$1 = (("" + $as_T(elem$1)) + result1)
      }
    };
    return (negNumber ? ("-" + $as_T(elem$1)) : $as_T(elem$1))
  }
});
$c_Ljava_math_Conversion$.prototype.dropLeadingZeros__p1__T__T = (function(s) {
  var zeroPrefixLength = 0;
  var len = $uI(s.length);
  while (true) {
    if ((zeroPrefixLength < len)) {
      var index = zeroPrefixLength;
      var jsx$1 = ((65535 & $uI(s.charCodeAt(index))) === 48)
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      zeroPrefixLength = ((1 + zeroPrefixLength) | 0)
    } else {
      break
    }
  };
  var beginIndex = zeroPrefixLength;
  return $as_T(s.substring(beginIndex))
});
$c_Ljava_math_Conversion$.prototype.toDecimalScaledString__Ljava_math_BigInteger__T = (function(bi) {
  var sign = bi.sign$2;
  var numberLength = bi.numberLength$2;
  var digits = bi.digits$2;
  if ((sign === 0)) {
    return "0"
  } else if ((numberLength === 1)) {
    var i = digits.get(0);
    var x = $uD((i >>> 0));
    var jsx$1 = x.toString(10);
    var absStr = $as_T(jsx$1);
    return ((sign < 0) ? ("-" + absStr) : absStr)
  } else {
    var result = "";
    var temp = $newArrayObject($d_I.getArrayOf(), [numberLength]);
    var tempLen = numberLength;
    $systemArraycopy(digits, 0, temp, 0, tempLen);
    do {
      var rem = 0;
      var i$1 = (((-1) + tempLen) | 0);
      while ((i$1 >= 0)) {
        var value = rem;
        var value$1 = temp.get(i$1);
        var this$8 = $m_sjsr_RuntimeLong$();
        var lo = this$8.divideUnsignedImpl__I__I__I__I__I(value$1, value, 1000000000, 0);
        temp.set(i$1, lo);
        var hi$3 = (lo >> 31);
        var b0 = (65535 & lo);
        var b1 = ((lo >>> 16) | 0);
        var a0b0 = $imul(51712, b0);
        var a1b0 = $imul(15258, b0);
        var a0b1 = $imul(51712, b1);
        var lo$1 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
        var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
        var hi$4 = (((((($imul(1000000000, hi$3) + $imul(15258, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
        var lo$2 = ((value$1 - lo$1) | 0);
        rem = lo$2;
        i$1 = (((-1) + i$1) | 0)
      };
      var this$10 = rem;
      var remStr = ("" + this$10);
      var beginIndex = $uI(remStr.length);
      var padding = $as_T("000000000".substring(beginIndex));
      result = ((padding + remStr) + result);
      while (((tempLen !== 0) && (temp.get((((-1) + tempLen) | 0)) === 0))) {
        tempLen = (((-1) + tempLen) | 0)
      }
    } while ((tempLen !== 0));
    result = this.dropLeadingZeros__p1__T__T(result);
    return ((sign < 0) ? ("-" + result) : result)
  }
});
var $d_Ljava_math_Conversion$ = new $TypeData().initClass({
  Ljava_math_Conversion$: 0
}, false, "java.math.Conversion$", {
  Ljava_math_Conversion$: 1,
  O: 1
});
$c_Ljava_math_Conversion$.prototype.$classData = $d_Ljava_math_Conversion$;
var $n_Ljava_math_Conversion$ = (void 0);
function $m_Ljava_math_Conversion$() {
  if ((!$n_Ljava_math_Conversion$)) {
    $n_Ljava_math_Conversion$ = new $c_Ljava_math_Conversion$().init___()
  };
  return $n_Ljava_math_Conversion$
}
/** @constructor */
function $c_Ljava_math_Division$() {
  $c_O.call(this);
  this.UINT$undMAX$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_Ljava_math_Division$.prototype = new $h_O();
$c_Ljava_math_Division$.prototype.constructor = $c_Ljava_math_Division$;
/** @constructor */
function $h_Ljava_math_Division$() {
  /*<skip>*/
}
$h_Ljava_math_Division$.prototype = $c_Ljava_math_Division$.prototype;
$c_Ljava_math_Division$.prototype.init___ = (function() {
  return this
});
$c_Ljava_math_Division$.prototype.divide__AI__I__AI__I__AI__I__AI = (function(quot, quotLength, a, aLength, b, bLength) {
  var normA = $newArrayObject($d_I.getArrayOf(), [((1 + aLength) | 0)]);
  var normB = $newArrayObject($d_I.getArrayOf(), [((1 + bLength) | 0)]);
  var divisorShift = $clz32(b.get((((-1) + bLength) | 0)));
  if ((divisorShift !== 0)) {
    $m_Ljava_math_BitLevel$().shiftLeft__AI__AI__I__I__V(normB, b, 0, divisorShift);
    $m_Ljava_math_BitLevel$().shiftLeft__AI__AI__I__I__V(normA, a, 0, divisorShift)
  } else {
    $systemArraycopy(a, 0, normA, 0, aLength);
    $systemArraycopy(b, 0, normB, 0, bLength)
  };
  var firstDivisorDigit = normB.get((((-1) + bLength) | 0));
  var i = (((-1) + quotLength) | 0);
  var elem$1 = 0;
  elem$1 = aLength;
  while ((i >= 0)) {
    var elem$1$1 = 0;
    elem$1$1 = 0;
    if ((normA.get(elem$1) === firstDivisorDigit)) {
      elem$1$1 = (-1)
    } else {
      var value = normA.get(elem$1);
      var value$1 = normA.get((((-1) + elem$1) | 0));
      var this$5 = $m_sjsr_RuntimeLong$();
      var lo = this$5.divideUnsignedImpl__I__I__I__I__I(value$1, value, firstDivisorDigit, 0);
      var hi$3 = this$5.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
      elem$1$1 = lo;
      var a0 = (65535 & lo);
      var a1 = ((lo >>> 16) | 0);
      var b0 = (65535 & firstDivisorDigit);
      var b1 = ((firstDivisorDigit >>> 16) | 0);
      var a0b0 = $imul(a0, b0);
      var a1b0 = $imul(a1, b0);
      var a0b1 = $imul(a0, b1);
      var lo$1 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (((((($imul(hi$3, firstDivisorDigit) + $imul(a1, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
      var lo$2 = ((value$1 - lo$1) | 0);
      var elem$1$2 = 0;
      elem$1$2 = lo$2;
      if ((elem$1$1 !== 0)) {
        elem$1$1 = ((1 + elem$1$1) | 0);
        _loop: while (true) {
          elem$1$1 = (((-1) + elem$1$1) | 0);
          var value$2 = elem$1$1;
          var value$3 = normB.get((((-2) + bLength) | 0));
          var a0$1 = (65535 & value$2);
          var a1$1 = ((value$2 >>> 16) | 0);
          var b0$1 = (65535 & value$3);
          var b1$1 = ((value$3 >>> 16) | 0);
          var a0b0$1 = $imul(a0$1, b0$1);
          var a1b0$1 = $imul(a1$1, b0$1);
          var a0b1$1 = $imul(a0$1, b1$1);
          var lo$3 = ((a0b0$1 + (((a1b0$1 + a0b1$1) | 0) << 16)) | 0);
          var c1part$1 = ((((a0b0$1 >>> 16) | 0) + a0b1$1) | 0);
          var hi$8 = (((($imul(a1$1, b1$1) + ((c1part$1 >>> 16) | 0)) | 0) + (((((65535 & c1part$1) + a1b0$1) | 0) >>> 16) | 0)) | 0);
          var value$4 = elem$1$2;
          var value$5 = normA.get((((-2) + elem$1) | 0));
          var value$6 = elem$1$2;
          var lo$4 = ((value$6 + firstDivisorDigit) | 0);
          var hi$13 = ((((-2147483648) ^ lo$4) < ((-2147483648) ^ value$6)) ? 1 : 0);
          if ((hi$13 === 0)) {
            elem$1$2 = lo$4;
            var hi$14 = ((-2147483648) ^ hi$8);
            var hi$15 = ((-2147483648) ^ value$4);
            if (((hi$14 === hi$15) ? (((-2147483648) ^ lo$3) > ((-2147483648) ^ value$5)) : (hi$14 > hi$15))) {
              continue _loop
            }
          };
          break
        }
      }
    };
    if ((elem$1$1 !== 0)) {
      var borrow = $m_Ljava_math_Division$().multiplyAndSubtract__AI__I__AI__I__I__I(normA, ((elem$1 - bLength) | 0), normB, bLength, elem$1$1);
      if ((borrow !== 0)) {
        elem$1$1 = (((-1) + elem$1$1) | 0);
        var elem$1$3_$_lo$2 = 0;
        var elem$1$3_$_hi$2 = 0;
        var jsx$1_$_lo$2 = 0;
        var jsx$1_$_hi$2 = 0;
        elem$1$3_$_lo$2 = jsx$1_$_lo$2;
        elem$1$3_$_hi$2 = jsx$1_$_hi$2;
        var isEmpty$4 = (bLength <= 0);
        var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + bLength) | 0));
        if ((!isEmpty$4)) {
          var i$1 = 0;
          while (true) {
            var v1 = i$1;
            var this$15_$_lo$2 = elem$1$3_$_lo$2;
            var this$15_$_hi$2 = elem$1$3_$_hi$2;
            var value$7 = normA.get(((((elem$1 - bLength) | 0) + v1) | 0));
            var value$8 = normB.get(v1);
            var lo$5 = ((value$7 + value$8) | 0);
            var hi$20 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ value$7)) ? 1 : 0);
            var alo = this$15_$_lo$2;
            var ahi = this$15_$_hi$2;
            var lo$6 = ((alo + lo$5) | 0);
            var hi$21 = ((((-2147483648) ^ lo$6) < ((-2147483648) ^ alo)) ? ((1 + ((ahi + hi$20) | 0)) | 0) : ((ahi + hi$20) | 0));
            var jsx$2_$_lo$2 = lo$6;
            var jsx$2_$_hi$2 = hi$21;
            elem$1$3_$_lo$2 = jsx$2_$_lo$2;
            elem$1$3_$_hi$2 = jsx$2_$_hi$2;
            var jsx$3 = elem$1;
            var this$17_$_lo$2 = elem$1$3_$_lo$2;
            var this$17_$_hi$2 = elem$1$3_$_hi$2;
            normA.set(((((jsx$3 - bLength) | 0) + v1) | 0), this$17_$_lo$2);
            var this$18_$_lo$2 = elem$1$3_$_lo$2;
            var this$18_$_hi$2 = elem$1$3_$_hi$2;
            var lo$7 = this$18_$_hi$2;
            var jsx$4_$_lo$2 = lo$7;
            var jsx$4_$_hi$2 = 0;
            elem$1$3_$_lo$2 = jsx$4_$_lo$2;
            elem$1$3_$_hi$2 = jsx$4_$_hi$2;
            if ((i$1 === lastElement$4)) {
              break
            };
            i$1 = ((1 + i$1) | 0)
          }
        }
      }
    };
    if ((quot !== null)) {
      quot.set(i, elem$1$1)
    };
    elem$1 = (((-1) + elem$1) | 0);
    i = (((-1) + i) | 0)
  };
  return ((divisorShift !== 0) ? ($m_Ljava_math_BitLevel$().shiftRight__AI__I__AI__I__I__Z(normB, bLength, normA, 0, divisorShift), normB) : ($systemArraycopy(normA, 0, normB, 0, bLength), normA))
});
$c_Ljava_math_Division$.prototype.divideAndRemainderByInteger__Ljava_math_BigInteger__I__I__Ljava_math_BigInteger$QuotAndRem = (function(bi, divisor, divisorSign) {
  var valDigits = bi.digits$2;
  var valLen = bi.numberLength$2;
  var valSign = bi.sign$2;
  if ((valLen === 1)) {
    var valDigit = valDigits.get(0);
    var n = ($uD((valDigit >>> 0)) / $uD((divisor >>> 0)));
    var value = $uI((n | 0));
    var quo_$_lo$2 = value;
    var quo_$_hi$2 = 0;
    var n$1 = ($uD((valDigit >>> 0)) % $uD((divisor >>> 0)));
    var value$1 = $uI((n$1 | 0));
    var rem_$_lo$2 = value$1;
    var rem_$_hi$2 = 0;
    if ((valSign !== divisorSign)) {
      var this$13_$_lo$2 = quo_$_lo$2;
      var this$13_$_hi$2 = quo_$_hi$2;
      var lo = this$13_$_lo$2;
      var hi$2 = this$13_$_hi$2;
      var lo$1 = ((-lo) | 0);
      var hi$3 = ((lo !== 0) ? (~hi$2) : ((-hi$2) | 0));
      var jsx$1_$_lo$2 = lo$1;
      var jsx$1_$_hi$2 = hi$3;
      quo_$_lo$2 = jsx$1_$_lo$2;
      quo_$_hi$2 = jsx$1_$_hi$2
    };
    if ((valSign < 0)) {
      var this$16_$_lo$2 = rem_$_lo$2;
      var this$16_$_hi$2 = rem_$_hi$2;
      var lo$2 = this$16_$_lo$2;
      var hi$4 = this$16_$_hi$2;
      var lo$3 = ((-lo$2) | 0);
      var hi$5 = ((lo$2 !== 0) ? (~hi$4) : ((-hi$4) | 0));
      var jsx$2_$_lo$2 = lo$3;
      var jsx$2_$_hi$2 = hi$5;
      rem_$_lo$2 = jsx$2_$_lo$2;
      rem_$_hi$2 = jsx$2_$_hi$2
    };
    return new $c_Ljava_math_BigInteger$QuotAndRem().init___Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_BigInteger$().valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(quo_$_lo$2, quo_$_hi$2)), $m_Ljava_math_BigInteger$().valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(rem_$_lo$2, rem_$_hi$2)))
  } else {
    var quotientSign = ((valSign === divisorSign) ? 1 : (-1));
    var quotientDigits = $newArrayObject($d_I.getArrayOf(), [valLen]);
    var div = this.divideArrayByInt__AI__AI__I__I__I(quotientDigits, valDigits, valLen, divisor);
    var jsx$3 = $m_s_Array$();
    var array = [];
    var remainderDigits = jsx$3.apply__I__sc_Seq__AI(div, new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var result0 = new $c_Ljava_math_BigInteger().init___I__I__AI(quotientSign, valLen, quotientDigits);
    var result1 = new $c_Ljava_math_BigInteger().init___I__I__AI(valSign, 1, remainderDigits);
    result0.cutOffLeadingZeroes__V();
    result1.cutOffLeadingZeroes__V();
    return new $c_Ljava_math_BigInteger$QuotAndRem().init___Ljava_math_BigInteger__Ljava_math_BigInteger(result0, result1)
  }
});
$c_Ljava_math_Division$.prototype.multiplyAndSubtract__AI__I__AI__I__I__I = (function(a, start, b, bLen, c) {
  var elem$1 = 0;
  elem$1 = 0;
  var elem$1$1 = 0;
  elem$1$1 = 0;
  var isEmpty$4 = (bLen <= 0);
  var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + bLen) | 0));
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      $m_Ljava_math_Multiplication$();
      var a$1 = b.get(v1);
      var c$1 = elem$1;
      var a0 = (65535 & a$1);
      var a1 = ((a$1 >>> 16) | 0);
      var b0 = (65535 & c);
      var b1 = ((c >>> 16) | 0);
      var a0b0 = $imul(a0, b0);
      var a1b0 = $imul(a1, b0);
      var a0b1 = $imul(a0, b1);
      var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
      var lo$1 = ((lo + c$1) | 0);
      var hi$6 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + hi$4) | 0) : hi$4);
      var value = a.get(((start + v1) | 0));
      var lo$2 = ((value - lo$1) | 0);
      var hi$8 = ((((-2147483648) ^ lo$2) > ((-2147483648) ^ value)) ? (-1) : 0);
      var value$1 = elem$1$1;
      var hi$9 = (value$1 >> 31);
      var lo$3 = ((lo$2 + value$1) | 0);
      var hi$10 = ((((-2147483648) ^ lo$3) < ((-2147483648) ^ lo$2)) ? ((1 + ((hi$8 + hi$9) | 0)) | 0) : ((hi$8 + hi$9) | 0));
      a.set(((start + v1) | 0), lo$3);
      elem$1$1 = hi$10;
      elem$1 = hi$6;
      if ((i === lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  var value$2 = a.get(((start + bLen) | 0));
  var value$3 = elem$1;
  var lo$4 = ((value$2 - value$3) | 0);
  var hi$15 = ((((-2147483648) ^ lo$4) > ((-2147483648) ^ value$2)) ? (-1) : 0);
  var value$4 = elem$1$1;
  var hi$16 = (value$4 >> 31);
  var lo$5 = ((lo$4 + value$4) | 0);
  var hi$17 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ lo$4)) ? ((1 + ((hi$15 + hi$16) | 0)) | 0) : ((hi$15 + hi$16) | 0));
  a.set(((start + bLen) | 0), lo$5);
  return hi$17
});
$c_Ljava_math_Division$.prototype.divideArrayByInt__AI__AI__I__I__I = (function(dest, src, srcLength, divisor) {
  var rem = 0;
  var i = (((-1) + srcLength) | 0);
  while ((i >= 0)) {
    var value = rem;
    var value$1 = src.get(i);
    var this$2 = $m_sjsr_RuntimeLong$();
    var lo = this$2.divideUnsignedImpl__I__I__I__I__I(value$1, value, divisor, 0);
    var hi$3 = this$2.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
    var a0 = (65535 & lo);
    var a1 = ((lo >>> 16) | 0);
    var b0 = (65535 & divisor);
    var b1 = ((divisor >>> 16) | 0);
    var a0b0 = $imul(a0, b0);
    var a1b0 = $imul(a1, b0);
    var a0b1 = $imul(a0, b1);
    var lo$1 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
    var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
    var hi$4 = (((((($imul(hi$3, divisor) + $imul(a1, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
    var lo$2 = ((value$1 - lo$1) | 0);
    rem = lo$2;
    dest.set(i, lo);
    i = (((-1) + i) | 0)
  };
  return rem
});
var $d_Ljava_math_Division$ = new $TypeData().initClass({
  Ljava_math_Division$: 0
}, false, "java.math.Division$", {
  Ljava_math_Division$: 1,
  O: 1
});
$c_Ljava_math_Division$.prototype.$classData = $d_Ljava_math_Division$;
var $n_Ljava_math_Division$ = (void 0);
function $m_Ljava_math_Division$() {
  if ((!$n_Ljava_math_Division$)) {
    $n_Ljava_math_Division$ = new $c_Ljava_math_Division$().init___()
  };
  return $n_Ljava_math_Division$
}
/** @constructor */
function $c_Ljava_math_Elementary$() {
  $c_O.call(this);
  this.UINT$undMAX$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_Ljava_math_Elementary$.prototype = new $h_O();
$c_Ljava_math_Elementary$.prototype.constructor = $c_Ljava_math_Elementary$;
/** @constructor */
function $h_Ljava_math_Elementary$() {
  /*<skip>*/
}
$h_Ljava_math_Elementary$.prototype = $c_Ljava_math_Elementary$.prototype;
$c_Ljava_math_Elementary$.prototype.init___ = (function() {
  return this
});
$c_Ljava_math_Elementary$.prototype.subtract__p1__AI__I__AI__I__AI = (function(a, aSize, b, bSize) {
  var res = $newArrayObject($d_I.getArrayOf(), [aSize]);
  this.subtract__p1__AI__AI__I__AI__I__V(res, a, aSize, b, bSize);
  return res
});
$c_Ljava_math_Elementary$.prototype.compareArrays__AI__AI__I__I = (function(a, b, size) {
  var i = (((-1) + size) | 0);
  while (((i >= 0) && (a.get(i) === b.get(i)))) {
    i = (((-1) + i) | 0)
  };
  if ((i < 0)) {
    return 0
  } else {
    var value = a.get(i);
    var value$1 = b.get(i);
    if ((((-2147483648) ^ value) < ((-2147483648) ^ value$1))) {
      return (-1)
    } else {
      return 1
    }
  }
});
$c_Ljava_math_Elementary$.prototype.inplaceAdd__AI__I__I__I = (function(a, aSize, addend) {
  var carry = addend;
  var i = 0;
  while (((carry !== 0) && (i < aSize))) {
    var value = carry;
    var value$1 = a.get(i);
    var lo = ((value + value$1) | 0);
    var hi$2 = ((((-2147483648) ^ lo) < ((-2147483648) ^ value)) ? 1 : 0);
    a.set(i, lo);
    carry = hi$2;
    i = ((1 + i) | 0)
  };
  return carry
});
$c_Ljava_math_Elementary$.prototype.add__p1__AI__I__AI__I__AI = (function(a, aSize, b, bSize) {
  var res = $newArrayObject($d_I.getArrayOf(), [((1 + aSize) | 0)]);
  this.add__p1__AI__AI__I__AI__I__V(res, a, aSize, b, bSize);
  return res
});
$c_Ljava_math_Elementary$.prototype.add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(op1, op2) {
  var op1Sign = op1.sign$2;
  var op2Sign = op2.sign$2;
  var op1Len = op1.numberLength$2;
  var op2Len = op2.numberLength$2;
  if ((op1Sign === 0)) {
    return op2
  } else if ((op2Sign === 0)) {
    return op1
  } else if ((((op1Len + op2Len) | 0) === 2)) {
    var value = op1.digits$2.get(0);
    var value$1 = op2.digits$2.get(0);
    if ((op1Sign === op2Sign)) {
      var lo = ((value + value$1) | 0);
      var hi$2 = ((((-2147483648) ^ lo) < ((-2147483648) ^ value)) ? 1 : 0);
      if ((hi$2 === 0)) {
        return new $c_Ljava_math_BigInteger().init___I__I(op1Sign, lo)
      } else {
        var jsx$1 = $m_s_Array$();
        var array = [hi$2];
        return new $c_Ljava_math_BigInteger().init___I__I__AI(op1Sign, 2, jsx$1.apply__I__sc_Seq__AI(lo, new $c_sjs_js_WrappedArray().init___sjs_js_Array(array)))
      }
    } else {
      var jsx$2 = $m_Ljava_math_BigInteger$();
      if ((op1Sign < 0)) {
        var lo$1 = ((value$1 - value) | 0);
        var hi$3 = ((((-2147483648) ^ lo$1) > ((-2147483648) ^ value$1)) ? (-1) : 0);
        var x_$_lo$2 = lo$1;
        var x_$_hi$2 = hi$3
      } else {
        var lo$2 = ((value - value$1) | 0);
        var hi$4 = ((((-2147483648) ^ lo$2) > ((-2147483648) ^ value)) ? (-1) : 0);
        var x_$_lo$2 = lo$2;
        var x_$_hi$2 = hi$4
      };
      return jsx$2.valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(x_$_lo$2, x_$_hi$2))
    }
  } else {
    if ((op1Sign === op2Sign)) {
      var res$2 = ((op1Len >= op2Len) ? this.add__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len) : this.add__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len));
      var x1_$_$$und1$f = op1Sign;
      var x1_$_$$und2$f = res$2
    } else {
      var cmp = ((op1Len !== op2Len) ? ((op1Len > op2Len) ? 1 : (-1)) : this.compareArrays__AI__AI__I__I(op1.digits$2, op2.digits$2, op1Len));
      if ((cmp === 0)) {
        return $m_Ljava_math_BigInteger$().ZERO$1
      };
      if ((cmp === 1)) {
        var _2 = this.subtract__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len);
        var x1_$_$$und1$f = op1Sign;
        var x1_$_$$und2$f = _2
      } else {
        var _2$1 = this.subtract__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len);
        var x1_$_$$und1$f = op2Sign;
        var x1_$_$$und2$f = _2$1
      }
    };
    var resSign = $uI(x1_$_$$und1$f);
    var resDigits = $asArrayOf_I(x1_$_$$und2$f, 1);
    var res$3 = new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, resDigits.u.length, resDigits);
    res$3.cutOffLeadingZeroes__V();
    return res$3
  }
});
$c_Ljava_math_Elementary$.prototype.subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(op1, op2) {
  var op1Sign = op1.sign$2;
  var op2Sign = op2.sign$2;
  var op1Len = op1.numberLength$2;
  var op2Len = op2.numberLength$2;
  if ((op2Sign === 0)) {
    return op1
  } else if ((op1Sign === 0)) {
    return op2.negate__Ljava_math_BigInteger()
  } else if ((((op1Len + op2Len) | 0) === 2)) {
    var value = op1.digits$2.get(0);
    var a_$_lo$2 = value;
    var a_$_hi$2 = 0;
    var value$1 = op2.digits$2.get(0);
    var b_$_lo$2 = value$1;
    var b_$_hi$2 = 0;
    if ((op1Sign < 0)) {
      var this$1_$_lo$2 = a_$_lo$2;
      var this$1_$_hi$2 = a_$_hi$2;
      var lo = this$1_$_lo$2;
      var hi$2 = this$1_$_hi$2;
      var lo$1 = ((-lo) | 0);
      var hi$3 = ((lo !== 0) ? (~hi$2) : ((-hi$2) | 0));
      var jsx$1_$_lo$2 = lo$1;
      var jsx$1_$_hi$2 = hi$3;
      a_$_lo$2 = jsx$1_$_lo$2;
      a_$_hi$2 = jsx$1_$_hi$2
    };
    if ((op2Sign < 0)) {
      var this$4_$_lo$2 = b_$_lo$2;
      var this$4_$_hi$2 = b_$_hi$2;
      var lo$2 = this$4_$_lo$2;
      var hi$4 = this$4_$_hi$2;
      var lo$3 = ((-lo$2) | 0);
      var hi$5 = ((lo$2 !== 0) ? (~hi$4) : ((-hi$4) | 0));
      var jsx$2_$_lo$2 = lo$3;
      var jsx$2_$_hi$2 = hi$5;
      b_$_lo$2 = jsx$2_$_lo$2;
      b_$_hi$2 = jsx$2_$_hi$2
    };
    var jsx$3 = $m_Ljava_math_BigInteger$();
    var this$7_$_lo$2 = a_$_lo$2;
    var this$7_$_hi$2 = a_$_hi$2;
    var b$1_$_lo$2 = b_$_lo$2;
    var b$1_$_hi$2 = b_$_hi$2;
    var alo = this$7_$_lo$2;
    var ahi = this$7_$_hi$2;
    var bhi = b$1_$_hi$2;
    var lo$4 = ((alo - b$1_$_lo$2) | 0);
    var hi$6 = ((((-2147483648) ^ lo$4) > ((-2147483648) ^ alo)) ? (((-1) + ((ahi - bhi) | 0)) | 0) : ((ahi - bhi) | 0));
    return jsx$3.valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(lo$4, hi$6))
  } else {
    var cmp = ((op1Len !== op2Len) ? ((op1Len > op2Len) ? 1 : (-1)) : $m_Ljava_math_Elementary$().compareArrays__AI__AI__I__I(op1.digits$2, op2.digits$2, op1Len));
    if (((op1Sign === op2Sign) && (cmp === 0))) {
      return $m_Ljava_math_BigInteger$().ZERO$1
    };
    if ((cmp === (-1))) {
      var res = ((op1Sign === op2Sign) ? this.subtract__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len) : this.add__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len));
      var _1 = ((-op2Sign) | 0);
      var x1_$_$$und1$f = _1;
      var x1_$_$$und2$f = res
    } else if ((op1Sign === op2Sign)) {
      var _2 = this.subtract__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len);
      var x1_$_$$und1$f = op1Sign;
      var x1_$_$$und2$f = _2
    } else {
      var _2$1 = this.add__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len);
      var x1_$_$$und1$f = op1Sign;
      var x1_$_$$und2$f = _2$1
    };
    var resSign = $uI(x1_$_$$und1$f);
    var resDigits = $asArrayOf_I(x1_$_$$und2$f, 1);
    var res$2 = new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, resDigits.u.length, resDigits);
    res$2.cutOffLeadingZeroes__V();
    return res$2
  }
});
$c_Ljava_math_Elementary$.prototype.subtract__p1__AI__AI__I__AI__I__V = (function(res, a, aSize, b, bSize) {
  var i = 0;
  var borrow = 0;
  while ((i < bSize)) {
    var value = a.get(i);
    var value$1 = b.get(i);
    var lo = ((value - value$1) | 0);
    var hi$2 = ((((-2147483648) ^ lo) > ((-2147483648) ^ value)) ? (-1) : 0);
    var value$2 = borrow;
    var hi$3 = (value$2 >> 31);
    var lo$1 = ((lo + value$2) | 0);
    var hi$4 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + ((hi$2 + hi$3) | 0)) | 0) : ((hi$2 + hi$3) | 0));
    res.set(i, lo$1);
    borrow = hi$4;
    i = ((1 + i) | 0)
  };
  while ((i < aSize)) {
    var value$3 = a.get(i);
    var value$4 = borrow;
    var hi$7 = (value$4 >> 31);
    var lo$2 = ((value$3 + value$4) | 0);
    var hi$8 = ((((-2147483648) ^ lo$2) < ((-2147483648) ^ value$3)) ? ((1 + hi$7) | 0) : hi$7);
    res.set(i, lo$2);
    borrow = hi$8;
    i = ((1 + i) | 0)
  }
});
$c_Ljava_math_Elementary$.prototype.add__p1__AI__AI__I__AI__I__V = (function(res, a, aSize, b, bSize) {
  var i = 1;
  var value = a.get(0);
  var value$1 = b.get(0);
  var lo = ((value + value$1) | 0);
  var hi$2 = ((((-2147483648) ^ lo) < ((-2147483648) ^ value)) ? 1 : 0);
  res.set(0, lo);
  var carry = hi$2;
  if ((aSize >= bSize)) {
    while ((i < bSize)) {
      var value$2 = a.get(i);
      var value$3 = b.get(i);
      var lo$1 = ((value$2 + value$3) | 0);
      var hi$6 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ value$2)) ? 1 : 0);
      var value$4 = carry;
      var lo$2 = ((lo$1 + value$4) | 0);
      var hi$8 = ((((-2147483648) ^ lo$2) < ((-2147483648) ^ lo$1)) ? ((1 + hi$6) | 0) : hi$6);
      res.set(i, lo$2);
      carry = hi$8;
      i = ((1 + i) | 0)
    };
    while ((i < aSize)) {
      var value$5 = a.get(i);
      var value$6 = carry;
      var lo$3 = ((value$5 + value$6) | 0);
      var hi$12 = ((((-2147483648) ^ lo$3) < ((-2147483648) ^ value$5)) ? 1 : 0);
      res.set(i, lo$3);
      carry = hi$12;
      i = ((1 + i) | 0)
    }
  } else {
    while ((i < aSize)) {
      var value$7 = a.get(i);
      var value$8 = b.get(i);
      var lo$4 = ((value$7 + value$8) | 0);
      var hi$16 = ((((-2147483648) ^ lo$4) < ((-2147483648) ^ value$7)) ? 1 : 0);
      var value$9 = carry;
      var lo$5 = ((lo$4 + value$9) | 0);
      var hi$18 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ lo$4)) ? ((1 + hi$16) | 0) : hi$16);
      res.set(i, lo$5);
      carry = hi$18;
      i = ((1 + i) | 0)
    };
    while ((i < bSize)) {
      var value$10 = b.get(i);
      var value$11 = carry;
      var lo$6 = ((value$10 + value$11) | 0);
      var hi$22 = ((((-2147483648) ^ lo$6) < ((-2147483648) ^ value$10)) ? 1 : 0);
      res.set(i, lo$6);
      carry = hi$22;
      i = ((1 + i) | 0)
    }
  };
  if ((carry !== 0)) {
    res.set(i, carry)
  }
});
var $d_Ljava_math_Elementary$ = new $TypeData().initClass({
  Ljava_math_Elementary$: 0
}, false, "java.math.Elementary$", {
  Ljava_math_Elementary$: 1,
  O: 1
});
$c_Ljava_math_Elementary$.prototype.$classData = $d_Ljava_math_Elementary$;
var $n_Ljava_math_Elementary$ = (void 0);
function $m_Ljava_math_Elementary$() {
  if ((!$n_Ljava_math_Elementary$)) {
    $n_Ljava_math_Elementary$ = new $c_Ljava_math_Elementary$().init___()
  };
  return $n_Ljava_math_Elementary$
}
/** @constructor */
function $c_Ljava_math_MathContext() {
  $c_O.call(this);
  this.precision$1 = 0;
  this.roundingMode$1 = null
}
$c_Ljava_math_MathContext.prototype = new $h_O();
$c_Ljava_math_MathContext.prototype.constructor = $c_Ljava_math_MathContext;
/** @constructor */
function $h_Ljava_math_MathContext() {
  /*<skip>*/
}
$h_Ljava_math_MathContext.prototype = $c_Ljava_math_MathContext.prototype;
$c_Ljava_math_MathContext.prototype.equals__O__Z = (function(x) {
  if ($is_Ljava_math_MathContext(x)) {
    var x2 = $as_Ljava_math_MathContext(x);
    if ((this.precision$1 === x2.precision$1)) {
      var x$2 = this.roundingMode$1;
      var x$3 = x2.roundingMode$1;
      return (x$2 === x$3)
    } else {
      return false
    }
  } else {
    return false
  }
});
$c_Ljava_math_MathContext.prototype.toString__T = (function() {
  return ((("precision=" + this.precision$1) + " roundingMode=") + this.roundingMode$1)
});
$c_Ljava_math_MathContext.prototype.init___I__Ljava_math_RoundingMode = (function(setPrecision, setRoundingMode) {
  this.precision$1 = setPrecision;
  this.roundingMode$1 = setRoundingMode;
  return this
});
$c_Ljava_math_MathContext.prototype.hashCode__I = (function() {
  return ((this.precision$1 << 3) | this.roundingMode$1.$$undordinal$1)
});
function $is_Ljava_math_MathContext(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Ljava_math_MathContext)))
}
function $as_Ljava_math_MathContext(obj) {
  return (($is_Ljava_math_MathContext(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.math.MathContext"))
}
function $isArrayOf_Ljava_math_MathContext(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Ljava_math_MathContext)))
}
function $asArrayOf_Ljava_math_MathContext(obj, depth) {
  return (($isArrayOf_Ljava_math_MathContext(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.math.MathContext;", depth))
}
var $d_Ljava_math_MathContext = new $TypeData().initClass({
  Ljava_math_MathContext: 0
}, false, "java.math.MathContext", {
  Ljava_math_MathContext: 1,
  O: 1
});
$c_Ljava_math_MathContext.prototype.$classData = $d_Ljava_math_MathContext;
/** @constructor */
function $c_Ljava_math_MathContext$() {
  $c_O.call(this);
  this.DECIMAL128$1 = null;
  this.DECIMAL32$1 = null;
  this.DECIMAL64$1 = null;
  this.UNLIMITED$1 = null
}
$c_Ljava_math_MathContext$.prototype = new $h_O();
$c_Ljava_math_MathContext$.prototype.constructor = $c_Ljava_math_MathContext$;
/** @constructor */
function $h_Ljava_math_MathContext$() {
  /*<skip>*/
}
$h_Ljava_math_MathContext$.prototype = $c_Ljava_math_MathContext$.prototype;
$c_Ljava_math_MathContext$.prototype.init___ = (function() {
  $n_Ljava_math_MathContext$ = this;
  $m_Ljava_math_MathContext$();
  var roundingMode = $m_Ljava_math_RoundingMode$().HALF$undEVEN$1;
  this.DECIMAL128$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(34, roundingMode);
  $m_Ljava_math_MathContext$();
  var roundingMode$1 = $m_Ljava_math_RoundingMode$().HALF$undEVEN$1;
  this.DECIMAL32$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(7, roundingMode$1);
  $m_Ljava_math_MathContext$();
  var roundingMode$2 = $m_Ljava_math_RoundingMode$().HALF$undEVEN$1;
  this.DECIMAL64$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(16, roundingMode$2);
  $m_Ljava_math_MathContext$();
  var roundingMode$3 = $m_Ljava_math_RoundingMode$().HALF$undUP$1;
  this.UNLIMITED$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(0, roundingMode$3);
  return this
});
var $d_Ljava_math_MathContext$ = new $TypeData().initClass({
  Ljava_math_MathContext$: 0
}, false, "java.math.MathContext$", {
  Ljava_math_MathContext$: 1,
  O: 1
});
$c_Ljava_math_MathContext$.prototype.$classData = $d_Ljava_math_MathContext$;
var $n_Ljava_math_MathContext$ = (void 0);
function $m_Ljava_math_MathContext$() {
  if ((!$n_Ljava_math_MathContext$)) {
    $n_Ljava_math_MathContext$ = new $c_Ljava_math_MathContext$().init___()
  };
  return $n_Ljava_math_MathContext$
}
/** @constructor */
function $c_Ljava_math_Multiplication$() {
  $c_O.call(this);
  this.TenPows$1 = null;
  this.FivePows$1 = null;
  this.BigTenPows$1 = null;
  this.BigFivePows$1 = null;
  this.whenUseKaratsuba$1 = 0
}
$c_Ljava_math_Multiplication$.prototype = new $h_O();
$c_Ljava_math_Multiplication$.prototype.constructor = $c_Ljava_math_Multiplication$;
/** @constructor */
function $h_Ljava_math_Multiplication$() {
  /*<skip>*/
}
$h_Ljava_math_Multiplication$.prototype = $c_Ljava_math_Multiplication$.prototype;
$c_Ljava_math_Multiplication$.prototype.multiplyPAP__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(a, b) {
  var aLen = a.numberLength$2;
  var bLen = b.numberLength$2;
  var resLength = ((aLen + bLen) | 0);
  var resSign = ((a.sign$2 !== b.sign$2) ? (-1) : 1);
  if ((resLength === 2)) {
    var a$1 = a.digits$2.get(0);
    var b$1 = b.digits$2.get(0);
    var a0 = (65535 & a$1);
    var a1 = ((a$1 >>> 16) | 0);
    var b0 = (65535 & b$1);
    var b1 = ((b$1 >>> 16) | 0);
    var a0b0 = $imul(a0, b0);
    var a1b0 = $imul(a1, b0);
    var a0b1 = $imul(a0, b1);
    var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
    var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
    var hi$2 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
    if ((hi$2 === 0)) {
      return new $c_Ljava_math_BigInteger().init___I__I(resSign, lo)
    } else {
      var jsx$1 = $m_s_Array$();
      var array = [hi$2];
      return new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, 2, jsx$1.apply__I__sc_Seq__AI(lo, new $c_sjs_js_WrappedArray().init___sjs_js_Array(array)))
    }
  } else {
    var aDigits = a.digits$2;
    var bDigits = b.digits$2;
    var resDigits = $newArrayObject($d_I.getArrayOf(), [resLength]);
    this.multArraysPAP__AI__I__AI__I__AI__V(aDigits, aLen, bDigits, bLen, resDigits);
    var result = new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, resLength, resDigits);
    result.cutOffLeadingZeroes__V();
    return result
  }
});
$c_Ljava_math_Multiplication$.prototype.init___ = (function() {
  $n_Ljava_math_Multiplication$ = this;
  this.TenPows$1 = this.newArrayOfPows__p1__I__I__AI(10, 10);
  this.FivePows$1 = this.newArrayOfPows__p1__I__I__AI(14, 5);
  this.BigTenPows$1 = $newArrayObject($d_Ljava_math_BigInteger.getArrayOf(), [32]);
  this.BigFivePows$1 = $newArrayObject($d_Ljava_math_BigInteger.getArrayOf(), [32]);
  this.initialiseArrays__p1__V();
  return this
});
$c_Ljava_math_Multiplication$.prototype.square__AI__I__AI__AI = (function(a, aLen, res) {
  var elem$1 = 0;
  elem$1 = 0;
  var isEmpty$4 = (aLen <= 0);
  var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + aLen) | 0));
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var i$1 = i;
      elem$1 = 0;
      var x = ((1 + i$1) | 0);
      var isEmpty$4$1 = (x >= aLen);
      var lastElement$4$1 = (isEmpty$4$1 ? (((-1) + x) | 0) : (((-1) + aLen) | 0));
      if ((!isEmpty$4$1)) {
        var i$2 = x;
        while (true) {
          var v1 = i$2;
          $m_Ljava_math_Multiplication$();
          var a$1 = a.get(i$1);
          var b = a.get(v1);
          var c = res.get(((i$1 + v1) | 0));
          var d = elem$1;
          var a0 = (65535 & a$1);
          var a1 = ((a$1 >>> 16) | 0);
          var b0 = (65535 & b);
          var b1 = ((b >>> 16) | 0);
          var a0b0 = $imul(a0, b0);
          var a1b0 = $imul(a1, b0);
          var a0b1 = $imul(a0, b1);
          var lo$4 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
          var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
          var hi$13 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
          var lo$5 = ((lo$4 + c) | 0);
          var hi$15 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ lo$4)) ? ((1 + hi$13) | 0) : hi$13);
          var lo$6 = ((lo$5 + d) | 0);
          var hi$17 = ((((-2147483648) ^ lo$6) < ((-2147483648) ^ lo$5)) ? ((1 + hi$15) | 0) : hi$15);
          res.set(((i$1 + v1) | 0), lo$6);
          elem$1 = hi$17;
          if ((i$2 === lastElement$4$1)) {
            break
          };
          i$2 = ((1 + i$2) | 0)
        }
      };
      res.set(((i$1 + aLen) | 0), elem$1);
      if ((i === lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  $m_Ljava_math_BitLevel$().shiftLeftOneBit__AI__AI__I__V(res, res, (aLen << 1));
  elem$1 = 0;
  var i$3 = 0;
  var index = 0;
  while ((i$3 < aLen)) {
    var a$2 = a.get(i$3);
    var b$1 = a.get(i$3);
    var c$1 = res.get(index);
    var d$1 = elem$1;
    var a0$1 = (65535 & a$2);
    var a1$1 = ((a$2 >>> 16) | 0);
    var b0$1 = (65535 & b$1);
    var b1$1 = ((b$1 >>> 16) | 0);
    var a0b0$1 = $imul(a0$1, b0$1);
    var a1b0$1 = $imul(a1$1, b0$1);
    var a0b1$1 = $imul(a0$1, b1$1);
    var lo$7 = ((a0b0$1 + (((a1b0$1 + a0b1$1) | 0) << 16)) | 0);
    var c1part$1 = ((((a0b0$1 >>> 16) | 0) + a0b1$1) | 0);
    var hi$20 = (((($imul(a1$1, b1$1) + ((c1part$1 >>> 16) | 0)) | 0) + (((((65535 & c1part$1) + a1b0$1) | 0) >>> 16) | 0)) | 0);
    var lo$8 = ((lo$7 + c$1) | 0);
    var hi$22 = ((((-2147483648) ^ lo$8) < ((-2147483648) ^ lo$7)) ? ((1 + hi$20) | 0) : hi$20);
    var lo$9 = ((lo$8 + d$1) | 0);
    var hi$24 = ((((-2147483648) ^ lo$9) < ((-2147483648) ^ lo$8)) ? ((1 + hi$22) | 0) : hi$22);
    res.set(index, lo$9);
    index = ((1 + index) | 0);
    var value$1 = res.get(index);
    var lo$10 = ((hi$24 + value$1) | 0);
    var hi$26 = ((((-2147483648) ^ lo$10) < ((-2147483648) ^ hi$24)) ? 1 : 0);
    res.set(index, lo$10);
    elem$1 = hi$26;
    i$3 = ((1 + i$3) | 0);
    index = ((1 + index) | 0)
  };
  return res
});
$c_Ljava_math_Multiplication$.prototype.pow__Ljava_math_BigInteger__I__Ljava_math_BigInteger = (function(base, exponent) {
  var exp = exponent;
  var res = $m_Ljava_math_BigInteger$().ONE$1;
  var acc = base;
  _loop: while (true) {
    if ((exp > 1)) {
      var res2 = (((1 & exp) !== 0) ? res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(acc) : res);
      if ((acc.numberLength$2 === 1)) {
        var acc2 = acc.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(acc)
      } else {
        var a = $newArrayObject($d_I.getArrayOf(), [(acc.numberLength$2 << 1)]);
        var sq = this.square__AI__I__AI__AI(acc.digits$2, acc.numberLength$2, a);
        var acc2 = new $c_Ljava_math_BigInteger().init___I__AI(1, sq)
      };
      var temp$exp = (exp >> 1);
      exp = temp$exp;
      res = res2;
      acc = acc2;
      continue _loop
    } else {
      return res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(acc)
    }
  }
});
$c_Ljava_math_Multiplication$.prototype.multPAP__p1__AI__AI__AI__I__I__V = (function(a, b, t, aLen, bLen) {
  if (((a === b) && (aLen === bLen))) {
    this.square__AI__I__AI__AI(a, aLen, t)
  } else {
    var isEmpty$4 = (aLen <= 0);
    var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + aLen) | 0));
    if ((!isEmpty$4)) {
      var i = 0;
      while (true) {
        var i$1 = i;
        var elem$1 = 0;
        elem$1 = 0;
        var aI = a.get(i$1);
        var isEmpty$4$1 = (bLen <= 0);
        var lastElement$4$1 = (isEmpty$4$1 ? (-1) : (((-1) + bLen) | 0));
        if ((!isEmpty$4$1)) {
          var i$2 = 0;
          while (true) {
            var v1 = i$2;
            $m_Ljava_math_Multiplication$();
            var b$1 = b.get(v1);
            var c = t.get(((i$1 + v1) | 0));
            var d = elem$1;
            var a0 = (65535 & aI);
            var a1 = ((aI >>> 16) | 0);
            var b0 = (65535 & b$1);
            var b1 = ((b$1 >>> 16) | 0);
            var a0b0 = $imul(a0, b0);
            var a1b0 = $imul(a1, b0);
            var a0b1 = $imul(a0, b1);
            var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
            var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
            var hi$6 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
            var lo$1 = ((lo + c) | 0);
            var hi$8 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + hi$6) | 0) : hi$6);
            var lo$2 = ((lo$1 + d) | 0);
            var hi$10 = ((((-2147483648) ^ lo$2) < ((-2147483648) ^ lo$1)) ? ((1 + hi$8) | 0) : hi$8);
            t.set(((i$1 + v1) | 0), lo$2);
            elem$1 = hi$10;
            if ((i$2 === lastElement$4$1)) {
              break
            };
            i$2 = ((1 + i$2) | 0)
          }
        };
        t.set(((i$1 + bLen) | 0), elem$1);
        if ((i === lastElement$4)) {
          break
        };
        i = ((1 + i) | 0)
      }
    }
  }
});
$c_Ljava_math_Multiplication$.prototype.initialiseArrays__p1__V = (function() {
  var elem$1_$_lo$2 = 0;
  var elem$1_$_hi$2 = 0;
  var jsx$1_$_lo$2 = 1;
  var jsx$1_$_hi$2 = 0;
  elem$1_$_lo$2 = jsx$1_$_lo$2;
  elem$1_$_hi$2 = jsx$1_$_hi$2;
  var i = 0;
  while (true) {
    var v1 = i;
    if ((v1 <= 18)) {
      $m_Ljava_math_Multiplication$().BigFivePows$1.set(v1, $m_Ljava_math_BigInteger$().valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(elem$1_$_lo$2, elem$1_$_hi$2)));
      var jsx$3 = $m_Ljava_math_Multiplication$().BigTenPows$1;
      var jsx$2 = $m_Ljava_math_BigInteger$();
      var this$5_$_lo$2 = elem$1_$_lo$2;
      var this$5_$_hi$2 = elem$1_$_hi$2;
      var lo = (((32 & v1) === 0) ? (this$5_$_lo$2 << v1) : 0);
      var hi = (((32 & v1) === 0) ? (((((this$5_$_lo$2 >>> 1) | 0) >>> ((31 - v1) | 0)) | 0) | (this$5_$_hi$2 << v1)) : (this$5_$_lo$2 << v1));
      jsx$3.set(v1, jsx$2.valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
      var b_$_lo$2 = elem$1_$_lo$2;
      var b_$_hi$2 = elem$1_$_hi$2;
      var blo = b_$_lo$2;
      var b0 = (65535 & blo);
      var b1 = ((blo >>> 16) | 0);
      var a0b0 = $imul(5, b0);
      var a0b1 = $imul(5, b1);
      var lo$1 = ((a0b0 + (a0b1 << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$1 = (($imul(5, b_$_hi$2) + ((c1part >>> 16) | 0)) | 0);
      var jsx$4_$_lo$2 = lo$1;
      var jsx$4_$_hi$2 = hi$1;
      elem$1_$_lo$2 = jsx$4_$_lo$2;
      elem$1_$_hi$2 = jsx$4_$_hi$2
    } else {
      $m_Ljava_math_Multiplication$().BigFivePows$1.set(v1, $m_Ljava_math_Multiplication$().BigFivePows$1.get((((-1) + v1) | 0)).multiply__Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_Multiplication$().BigFivePows$1.get(1)));
      $m_Ljava_math_Multiplication$().BigTenPows$1.set(v1, $m_Ljava_math_Multiplication$().BigTenPows$1.get((((-1) + v1) | 0)).multiply__Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_BigInteger$().TEN$1))
    };
    if ((i === 31)) {
      break
    };
    i = ((1 + i) | 0)
  }
});
$c_Ljava_math_Multiplication$.prototype.newArrayOfPows__p1__I__I__AI = (function(len, pow) {
  var elems$2 = null;
  elems$2 = [];
  if ((len > 0)) {
    var acc = 1;
    var i = 1;
    var elem = acc;
    var unboxedElem = ((elem === null) ? 0 : elem);
    elems$2.push(unboxedElem);
    while ((i < len)) {
      var arg1 = acc;
      var x$2 = $uI(arg1);
      acc = $imul(x$2, pow);
      i = ((1 + i) | 0);
      var elem$1 = acc;
      var unboxedElem$1 = ((elem$1 === null) ? 0 : elem$1);
      elems$2.push(unboxedElem$1)
    }
  };
  return $makeNativeArrayWrapper($d_I.getArrayOf(), elems$2)
});
$c_Ljava_math_Multiplication$.prototype.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(val1, val2) {
  if ((val2.numberLength$2 > val1.numberLength$2)) {
    var x1_$_$$und1$f = val2;
    var x1_$_$$und2$f = val1
  } else {
    var x1_$_$$und1$f = val1;
    var x1_$_$$und2$f = val2
  };
  var op1 = $as_Ljava_math_BigInteger(x1_$_$$und1$f);
  var op2 = $as_Ljava_math_BigInteger(x1_$_$$und2$f);
  if ((op2.numberLength$2 < 63)) {
    return this.multiplyPAP__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(op1, op2)
  } else {
    var ndiv2 = (((-2) & op1.numberLength$2) << 4);
    var upperOp1 = op1.shiftRight__I__Ljava_math_BigInteger(ndiv2);
    var upperOp2 = op2.shiftRight__I__Ljava_math_BigInteger(ndiv2);
    var bi = upperOp1.shiftLeft__I__Ljava_math_BigInteger(ndiv2);
    var lowerOp1 = $m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(op1, bi);
    var bi$1 = upperOp2.shiftLeft__I__Ljava_math_BigInteger(ndiv2);
    var lowerOp2 = $m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(op2, bi$1);
    var upper = this.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(upperOp1, upperOp2);
    var lower = this.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(lowerOp1, lowerOp2);
    var middle = this.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(upperOp1, lowerOp1), $m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(lowerOp2, upperOp2));
    var this$1 = middle;
    var bi$2 = upper;
    var this$2 = $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$1, bi$2);
    middle = $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$2, lower);
    middle = middle.shiftLeft__I__Ljava_math_BigInteger(ndiv2);
    upper = upper.shiftLeft__I__Ljava_math_BigInteger((ndiv2 << 1));
    var this$3 = upper;
    var bi$3 = middle;
    var this$4 = $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$3, bi$3);
    return $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$4, lower)
  }
});
$c_Ljava_math_Multiplication$.prototype.multiplyByInt__p1__AI__AI__I__I__I = (function(res, a, aSize, factor) {
  var elem$1 = 0;
  elem$1 = 0;
  var isEmpty$4 = (aSize <= 0);
  var lastElement$4 = (isEmpty$4 ? (-1) : (((-1) + aSize) | 0));
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      $m_Ljava_math_Multiplication$();
      var a$1 = a.get(v1);
      var c = elem$1;
      var a0 = (65535 & a$1);
      var a1 = ((a$1 >>> 16) | 0);
      var b0 = (65535 & factor);
      var b1 = ((factor >>> 16) | 0);
      var a0b0 = $imul(a0, b0);
      var a1b0 = $imul(a1, b0);
      var a0b1 = $imul(a0, b1);
      var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
      var lo$1 = ((lo + c) | 0);
      var hi$6 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + hi$4) | 0) : hi$4);
      res.set(v1, lo$1);
      elem$1 = hi$6;
      if ((i === lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  return elem$1
});
$c_Ljava_math_Multiplication$.prototype.multArraysPAP__AI__I__AI__I__AI__V = (function(aDigits, aLen, bDigits, bLen, resDigits) {
  if ((!((aLen === 0) || (bLen === 0)))) {
    if ((aLen === 1)) {
      resDigits.set(bLen, this.multiplyByInt__p1__AI__AI__I__I__I(resDigits, bDigits, bLen, aDigits.get(0)))
    } else if ((bLen === 1)) {
      resDigits.set(aLen, this.multiplyByInt__p1__AI__AI__I__I__I(resDigits, aDigits, aLen, bDigits.get(0)))
    } else {
      this.multPAP__p1__AI__AI__AI__I__I__V(aDigits, bDigits, resDigits, aLen, bLen)
    }
  }
});
$c_Ljava_math_Multiplication$.prototype.powerOf10__J__Ljava_math_BigInteger = (function(exp) {
  var value = this.BigTenPows$1.u.length;
  var hi = (value >> 31);
  var ahi = exp.hi$2;
  if (((ahi === hi) ? (((-2147483648) ^ exp.lo$2) < ((-2147483648) ^ value)) : (ahi < hi))) {
    return this.BigTenPows$1.get(exp.lo$2)
  } else {
    var ahi$1 = exp.hi$2;
    if (((ahi$1 === 0) ? (((-2147483648) ^ exp.lo$2) <= (-2147483598)) : (ahi$1 < 0))) {
      return $m_Ljava_math_BigInteger$().TEN$1.pow__I__Ljava_math_BigInteger(exp.lo$2)
    } else {
      var ahi$2 = exp.hi$2;
      if (((ahi$2 === 0) ? (((-2147483648) ^ exp.lo$2) <= (-1)) : (ahi$2 < 0))) {
        return this.BigFivePows$1.get(1).pow__I__Ljava_math_BigInteger(exp.lo$2).shiftLeft__I__Ljava_math_BigInteger(exp.lo$2)
      } else {
        var powerOfFive = this.BigFivePows$1.get(1).pow__I__Ljava_math_BigInteger(2147483647);
        var res = powerOfFive;
        var bhi = exp.hi$2;
        var lo = (((-2147483647) + exp.lo$2) | 0);
        var hi$1 = ((((-2147483648) ^ lo) < 1) ? bhi : (((-1) + bhi) | 0));
        var longExp_$_lo$2 = lo;
        var longExp_$_hi$2 = hi$1;
        var this$2 = $m_sjsr_RuntimeLong$();
        var lo$1 = this$2.remainderImpl__I__I__I__I__I(exp.lo$2, exp.hi$2, 2147483647, 0);
        while (true) {
          var this$3_$_lo$2 = longExp_$_lo$2;
          var this$3_$_hi$2 = longExp_$_hi$2;
          var ahi$3 = this$3_$_hi$2;
          if (((ahi$3 === 0) ? (((-2147483648) ^ this$3_$_lo$2) > (-1)) : (ahi$3 > 0))) {
            res = res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(powerOfFive);
            var b_$_lo$2 = longExp_$_lo$2;
            var b_$_hi$2 = longExp_$_hi$2;
            var bhi$1 = b_$_hi$2;
            var lo$2 = (((-2147483647) + b_$_lo$2) | 0);
            var hi$3 = ((((-2147483648) ^ lo$2) < 1) ? bhi$1 : (((-1) + bhi$1) | 0));
            var jsx$1_$_lo$2 = lo$2;
            var jsx$1_$_hi$2 = hi$3;
            longExp_$_lo$2 = jsx$1_$_lo$2;
            longExp_$_hi$2 = jsx$1_$_hi$2
          } else {
            break
          }
        };
        res = res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(this.BigFivePows$1.get(1).pow__I__Ljava_math_BigInteger(lo$1));
        res = res.shiftLeft__I__Ljava_math_BigInteger(2147483647);
        var bhi$2 = exp.hi$2;
        var lo$3 = (((-2147483647) + exp.lo$2) | 0);
        var hi$4 = ((((-2147483648) ^ lo$3) < 1) ? bhi$2 : (((-1) + bhi$2) | 0));
        var jsx$2_$_lo$2 = lo$3;
        var jsx$2_$_hi$2 = hi$4;
        longExp_$_lo$2 = jsx$2_$_lo$2;
        longExp_$_hi$2 = jsx$2_$_hi$2;
        while (true) {
          var this$6_$_lo$2 = longExp_$_lo$2;
          var this$6_$_hi$2 = longExp_$_hi$2;
          var ahi$4 = this$6_$_hi$2;
          if (((ahi$4 === 0) ? (((-2147483648) ^ this$6_$_lo$2) > (-1)) : (ahi$4 > 0))) {
            res = res.shiftLeft__I__Ljava_math_BigInteger(2147483647);
            var b$1_$_lo$2 = longExp_$_lo$2;
            var b$1_$_hi$2 = longExp_$_hi$2;
            var bhi$3 = b$1_$_hi$2;
            var lo$4 = (((-2147483647) + b$1_$_lo$2) | 0);
            var hi$5 = ((((-2147483648) ^ lo$4) < 1) ? bhi$3 : (((-1) + bhi$3) | 0));
            var jsx$3_$_lo$2 = lo$4;
            var jsx$3_$_hi$2 = hi$5;
            longExp_$_lo$2 = jsx$3_$_lo$2;
            longExp_$_hi$2 = jsx$3_$_hi$2
          } else {
            break
          }
        };
        return res.shiftLeft__I__Ljava_math_BigInteger(lo$1)
      }
    }
  }
});
var $d_Ljava_math_Multiplication$ = new $TypeData().initClass({
  Ljava_math_Multiplication$: 0
}, false, "java.math.Multiplication$", {
  Ljava_math_Multiplication$: 1,
  O: 1
});
$c_Ljava_math_Multiplication$.prototype.$classData = $d_Ljava_math_Multiplication$;
var $n_Ljava_math_Multiplication$ = (void 0);
function $m_Ljava_math_Multiplication$() {
  if ((!$n_Ljava_math_Multiplication$)) {
    $n_Ljava_math_Multiplication$ = new $c_Ljava_math_Multiplication$().init___()
  };
  return $n_Ljava_math_Multiplication$
}
/** @constructor */
function $c_Ljava_nio_Buffer() {
  $c_O.call(this);
  this.$$undcapacity$1 = 0;
  this.$$undlimit$1 = 0;
  this.java$nio$Buffer$$$undposition$1 = 0;
  this.$$undmark$1 = 0
}
$c_Ljava_nio_Buffer.prototype = new $h_O();
$c_Ljava_nio_Buffer.prototype.constructor = $c_Ljava_nio_Buffer;
/** @constructor */
function $h_Ljava_nio_Buffer() {
  /*<skip>*/
}
$h_Ljava_nio_Buffer.prototype = $c_Ljava_nio_Buffer.prototype;
$c_Ljava_nio_Buffer.prototype.position__I__Ljava_nio_Buffer = (function(newPosition) {
  if (((newPosition < 0) || (newPosition > this.$$undlimit$1))) {
    throw new $c_jl_IllegalArgumentException().init___()
  };
  this.java$nio$Buffer$$$undposition$1 = newPosition;
  if ((this.$$undmark$1 > newPosition)) {
    this.$$undmark$1 = (-1)
  };
  return this
});
$c_Ljava_nio_Buffer.prototype.toString__T = (function() {
  var array = ["", "[pos=", " lim=", " cap=", "]"];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [$objectGetClass(this).getName__T(), this.java$nio$Buffer$$$undposition$1, this.$$undlimit$1, this.$$undcapacity$1];
  return jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))
});
$c_Ljava_nio_Buffer.prototype.flip__Ljava_nio_Buffer = (function() {
  this.$$undmark$1 = (-1);
  this.$$undlimit$1 = this.java$nio$Buffer$$$undposition$1;
  this.java$nio$Buffer$$$undposition$1 = 0;
  return this
});
$c_Ljava_nio_Buffer.prototype.limit__I__Ljava_nio_Buffer = (function(newLimit) {
  if (((newLimit < 0) || (newLimit > this.$$undcapacity$1))) {
    throw new $c_jl_IllegalArgumentException().init___()
  };
  this.$$undlimit$1 = newLimit;
  if ((this.java$nio$Buffer$$$undposition$1 > newLimit)) {
    this.java$nio$Buffer$$$undposition$1 = newLimit;
    if ((this.$$undmark$1 > newLimit)) {
      this.$$undmark$1 = (-1)
    }
  };
  return this
});
$c_Ljava_nio_Buffer.prototype.init___I = (function(_capacity) {
  this.$$undcapacity$1 = _capacity;
  this.$$undlimit$1 = this.$$undcapacity$1;
  this.java$nio$Buffer$$$undposition$1 = 0;
  this.$$undmark$1 = (-1);
  return this
});
/** @constructor */
function $c_Ljava_nio_CharBuffer$() {
  $c_O.call(this);
  this.HashSeed$1 = 0
}
$c_Ljava_nio_CharBuffer$.prototype = new $h_O();
$c_Ljava_nio_CharBuffer$.prototype.constructor = $c_Ljava_nio_CharBuffer$;
/** @constructor */
function $h_Ljava_nio_CharBuffer$() {
  /*<skip>*/
}
$h_Ljava_nio_CharBuffer$.prototype = $c_Ljava_nio_CharBuffer$.prototype;
$c_Ljava_nio_CharBuffer$.prototype.init___ = (function() {
  return this
});
$c_Ljava_nio_CharBuffer$.prototype.wrap__jl_CharSequence__I__I__Ljava_nio_CharBuffer = (function(csq, start, end) {
  return $m_Ljava_nio_StringCharBuffer$().wrap__jl_CharSequence__I__I__I__I__Ljava_nio_CharBuffer(csq, 0, $charSequenceLength(csq), start, ((end - start) | 0))
});
$c_Ljava_nio_CharBuffer$.prototype.allocate__I__Ljava_nio_CharBuffer = (function(capacity) {
  var array = $newArrayObject($d_C.getArrayOf(), [capacity]);
  var length = array.u.length;
  var capacity$1 = array.u.length;
  if (((capacity$1 < 0) || (capacity$1 > array.u.length))) {
    throw new $c_jl_IndexOutOfBoundsException().init___()
  };
  if (((length < 0) || (length > capacity$1))) {
    throw new $c_jl_IndexOutOfBoundsException().init___()
  };
  return new $c_Ljava_nio_HeapCharBuffer().init___I__AC__I__I__I__Z(capacity$1, array, 0, 0, length, false)
});
var $d_Ljava_nio_CharBuffer$ = new $TypeData().initClass({
  Ljava_nio_CharBuffer$: 0
}, false, "java.nio.CharBuffer$", {
  Ljava_nio_CharBuffer$: 1,
  O: 1
});
$c_Ljava_nio_CharBuffer$.prototype.$classData = $d_Ljava_nio_CharBuffer$;
var $n_Ljava_nio_CharBuffer$ = (void 0);
function $m_Ljava_nio_CharBuffer$() {
  if ((!$n_Ljava_nio_CharBuffer$)) {
    $n_Ljava_nio_CharBuffer$ = new $c_Ljava_nio_CharBuffer$().init___()
  };
  return $n_Ljava_nio_CharBuffer$
}
/** @constructor */
function $c_Ljava_nio_HeapByteBuffer$() {
  $c_O.call(this)
}
$c_Ljava_nio_HeapByteBuffer$.prototype = new $h_O();
$c_Ljava_nio_HeapByteBuffer$.prototype.constructor = $c_Ljava_nio_HeapByteBuffer$;
/** @constructor */
function $h_Ljava_nio_HeapByteBuffer$() {
  /*<skip>*/
}
$h_Ljava_nio_HeapByteBuffer$.prototype = $c_Ljava_nio_HeapByteBuffer$.prototype;
$c_Ljava_nio_HeapByteBuffer$.prototype.init___ = (function() {
  return this
});
$c_Ljava_nio_HeapByteBuffer$.prototype.wrap__AB__I__I__I__I__Z__Ljava_nio_ByteBuffer = (function(array, arrayOffset, capacity, initialPosition, initialLength, isReadOnly) {
  if ((((arrayOffset < 0) || (capacity < 0)) || (((arrayOffset + capacity) | 0) > array.u.length))) {
    throw new $c_jl_IndexOutOfBoundsException().init___()
  };
  var initialLimit = ((initialPosition + initialLength) | 0);
  if ((((initialPosition < 0) || (initialLength < 0)) || (initialLimit > capacity))) {
    throw new $c_jl_IndexOutOfBoundsException().init___()
  };
  return new $c_Ljava_nio_HeapByteBuffer().init___I__AB__I__I__I__Z(capacity, array, arrayOffset, initialPosition, initialLimit, isReadOnly)
});
var $d_Ljava_nio_HeapByteBuffer$ = new $TypeData().initClass({
  Ljava_nio_HeapByteBuffer$: 0
}, false, "java.nio.HeapByteBuffer$", {
  Ljava_nio_HeapByteBuffer$: 1,
  O: 1
});
$c_Ljava_nio_HeapByteBuffer$.prototype.$classData = $d_Ljava_nio_HeapByteBuffer$;
var $n_Ljava_nio_HeapByteBuffer$ = (void 0);
function $m_Ljava_nio_HeapByteBuffer$() {
  if ((!$n_Ljava_nio_HeapByteBuffer$)) {
    $n_Ljava_nio_HeapByteBuffer$ = new $c_Ljava_nio_HeapByteBuffer$().init___()
  };
  return $n_Ljava_nio_HeapByteBuffer$
}
/** @constructor */
function $c_Ljava_nio_StringCharBuffer$() {
  $c_O.call(this)
}
$c_Ljava_nio_StringCharBuffer$.prototype = new $h_O();
$c_Ljava_nio_StringCharBuffer$.prototype.constructor = $c_Ljava_nio_StringCharBuffer$;
/** @constructor */
function $h_Ljava_nio_StringCharBuffer$() {
  /*<skip>*/
}
$h_Ljava_nio_StringCharBuffer$.prototype = $c_Ljava_nio_StringCharBuffer$.prototype;
$c_Ljava_nio_StringCharBuffer$.prototype.init___ = (function() {
  return this
});
$c_Ljava_nio_StringCharBuffer$.prototype.wrap__jl_CharSequence__I__I__I__I__Ljava_nio_CharBuffer = (function(csq, csqOffset, capacity, initialPosition, initialLength) {
  if ((((csqOffset < 0) || (capacity < 0)) || (((csqOffset + capacity) | 0) > $charSequenceLength(csq)))) {
    throw new $c_jl_IndexOutOfBoundsException().init___()
  };
  var initialLimit = ((initialPosition + initialLength) | 0);
  if ((((initialPosition < 0) || (initialLength < 0)) || (initialLimit > capacity))) {
    throw new $c_jl_IndexOutOfBoundsException().init___()
  };
  return new $c_Ljava_nio_StringCharBuffer().init___I__jl_CharSequence__I__I__I(capacity, csq, csqOffset, initialPosition, initialLimit)
});
var $d_Ljava_nio_StringCharBuffer$ = new $TypeData().initClass({
  Ljava_nio_StringCharBuffer$: 0
}, false, "java.nio.StringCharBuffer$", {
  Ljava_nio_StringCharBuffer$: 1,
  O: 1
});
$c_Ljava_nio_StringCharBuffer$.prototype.$classData = $d_Ljava_nio_StringCharBuffer$;
var $n_Ljava_nio_StringCharBuffer$ = (void 0);
function $m_Ljava_nio_StringCharBuffer$() {
  if ((!$n_Ljava_nio_StringCharBuffer$)) {
    $n_Ljava_nio_StringCharBuffer$ = new $c_Ljava_nio_StringCharBuffer$().init___()
  };
  return $n_Ljava_nio_StringCharBuffer$
}
/** @constructor */
function $c_Ljava_nio_charset_CharsetDecoder() {
  $c_O.call(this);
  this.cs$1 = null;
  this.$$undaverageCharsPerByte$1 = 0.0;
  this.$$undmaxCharsPerByte$1 = 0.0;
  this.$$undreplacement$1 = null;
  this.$$undmalformedInputAction$1 = null;
  this.$$undunmappableCharacterAction$1 = null;
  this.status$1 = 0
}
$c_Ljava_nio_charset_CharsetDecoder.prototype = new $h_O();
$c_Ljava_nio_charset_CharsetDecoder.prototype.constructor = $c_Ljava_nio_charset_CharsetDecoder;
/** @constructor */
function $h_Ljava_nio_charset_CharsetDecoder() {
  /*<skip>*/
}
$h_Ljava_nio_charset_CharsetDecoder.prototype = $c_Ljava_nio_charset_CharsetDecoder.prototype;
$c_Ljava_nio_charset_CharsetDecoder.prototype.flush__Ljava_nio_CharBuffer__Ljava_nio_charset_CoderResult = (function(out) {
  var x1 = this.status$1;
  switch (x1) {
    case 3: {
      var result = $m_Ljava_nio_charset_CoderResult$().UNDERFLOW$1;
      if ((result.java$nio$charset$CoderResult$$kind$f === 0)) {
        this.status$1 = 4
      };
      return result;
      break
    }
    case 4: {
      return $m_Ljava_nio_charset_CoderResult$().UNDERFLOW$1;
      break
    }
    default: {
      throw new $c_jl_IllegalStateException().init___()
    }
  }
});
$c_Ljava_nio_charset_CharsetDecoder.prototype.decode__Ljava_nio_ByteBuffer__Ljava_nio_CharBuffer = (function($in) {
  this.reset__Ljava_nio_charset_CharsetDecoder();
  var initLength = $doubleToInt(((($in.$$undlimit$1 - $in.java$nio$Buffer$$$undposition$1) | 0) * this.$$undaverageCharsPerByte$1));
  var out = $m_Ljava_nio_CharBuffer$().allocate__I__Ljava_nio_CharBuffer(initLength);
  var out$1;
  _loopDecode: while (true) {
    var result = this.decode__Ljava_nio_ByteBuffer__Ljava_nio_CharBuffer__Z__Ljava_nio_charset_CoderResult($in, out, true);
    if ((result.java$nio$charset$CoderResult$$kind$f !== 0)) {
      if ((result.java$nio$charset$CoderResult$$kind$f === 1)) {
        out = this.grow$1__p1__Ljava_nio_CharBuffer__Ljava_nio_CharBuffer(out);
        continue _loopDecode
      };
      result.throwException__V();
      throw new $c_jl_AssertionError().init___O("should not get here")
    };
    $m_s_Predef$().assert__Z__V(($in.java$nio$Buffer$$$undposition$1 === $in.$$undlimit$1));
    var out$1 = out;
    break
  };
  var out$2;
  _loopFlush: while (true) {
    var result$1 = this.flush__Ljava_nio_CharBuffer__Ljava_nio_charset_CoderResult(out$1);
    if ((result$1.java$nio$charset$CoderResult$$kind$f !== 0)) {
      if ((result$1.java$nio$charset$CoderResult$$kind$f === 1)) {
        out$1 = this.grow$1__p1__Ljava_nio_CharBuffer__Ljava_nio_CharBuffer(out$1);
        continue _loopFlush
      };
      result$1.throwException__V();
      throw new $c_jl_AssertionError().init___O("should not get here")
    };
    var out$2 = out$1;
    break
  };
  $c_Ljava_nio_Buffer.prototype.flip__Ljava_nio_Buffer.call(out$2);
  return out$2
});
$c_Ljava_nio_charset_CharsetDecoder.prototype.decode__Ljava_nio_ByteBuffer__Ljava_nio_CharBuffer__Z__Ljava_nio_charset_CoderResult = (function($in, out, endOfInput) {
  if (((this.status$1 === 4) || ((!endOfInput) && (this.status$1 === 3)))) {
    throw new $c_jl_IllegalStateException().init___()
  };
  this.status$1 = (endOfInput ? 3 : 2);
  _loop: while (true) {
    try {
      var result1 = this.decodeLoop__Ljava_nio_ByteBuffer__Ljava_nio_CharBuffer__Ljava_nio_charset_CoderResult($in, out)
    } catch (e) {
      var result1;
      if ($is_Ljava_nio_BufferOverflowException(e)) {
        var ex$2 = $as_Ljava_nio_BufferOverflowException(e);
        throw new $c_Ljava_nio_charset_CoderMalfunctionError().init___jl_Exception(ex$2)
      } else if ($is_Ljava_nio_BufferUnderflowException(e)) {
        var ex = $as_Ljava_nio_BufferUnderflowException(e);
        throw new $c_Ljava_nio_charset_CoderMalfunctionError().init___jl_Exception(ex)
      } else {
        throw e
      }
    };
    if ((result1.java$nio$charset$CoderResult$$kind$f === 0)) {
      var remaining = (($in.$$undlimit$1 - $in.java$nio$Buffer$$$undposition$1) | 0);
      if ((endOfInput && (remaining > 0))) {
        var this$1 = $m_Ljava_nio_charset_CoderResult$();
        switch (remaining) {
          case 1: {
            var result2 = this$1.java$nio$charset$CoderResult$$Malformed1$1;
            break
          }
          case 2: {
            var result2 = this$1.java$nio$charset$CoderResult$$Malformed2$1;
            break
          }
          case 3: {
            var result2 = this$1.java$nio$charset$CoderResult$$Malformed3$1;
            break
          }
          case 4: {
            var result2 = this$1.java$nio$charset$CoderResult$$Malformed4$1;
            break
          }
          default: {
            var result2 = this$1.java$nio$charset$CoderResult$$malformedForLengthImpl__I__Ljava_nio_charset_CoderResult(remaining)
          }
        }
      } else {
        var result2 = result1
      }
    } else {
      var result2 = result1
    };
    if (((result2.java$nio$charset$CoderResult$$kind$f === 0) || (result2.java$nio$charset$CoderResult$$kind$f === 1))) {
      return result2
    } else {
      var action = ((result2.java$nio$charset$CoderResult$$kind$f === 3) ? this.$$undunmappableCharacterAction$1 : this.$$undmalformedInputAction$1);
      var x$2 = $m_Ljava_nio_charset_CodingErrorAction$().REPLACE$1;
      if ((x$2 === action)) {
        var jsx$2 = out.$$undlimit$1;
        var jsx$1 = out.java$nio$Buffer$$$undposition$1;
        var thiz = this.$$undreplacement$1;
        if ((((jsx$2 - jsx$1) | 0) < $uI(thiz.length))) {
          return $m_Ljava_nio_charset_CoderResult$().OVERFLOW$1
        } else {
          out.put__T__Ljava_nio_CharBuffer(this.$$undreplacement$1);
          var jsx$3 = $in.java$nio$Buffer$$$undposition$1;
          var l = result2.java$nio$charset$CoderResult$$$undlength$f;
          if ((l < 0)) {
            throw new $c_jl_UnsupportedOperationException().init___()
          };
          var newPosition = ((jsx$3 + l) | 0);
          $c_Ljava_nio_Buffer.prototype.position__I__Ljava_nio_Buffer.call($in, newPosition);
          continue _loop
        }
      } else {
        var x$4 = $m_Ljava_nio_charset_CodingErrorAction$().REPORT$1;
        if ((x$4 === action)) {
          return result2
        } else {
          var x$6 = $m_Ljava_nio_charset_CodingErrorAction$().IGNORE$1;
          if ((x$6 === action)) {
            var jsx$4 = $in.java$nio$Buffer$$$undposition$1;
            var l$1 = result2.java$nio$charset$CoderResult$$$undlength$f;
            if ((l$1 < 0)) {
              throw new $c_jl_UnsupportedOperationException().init___()
            };
            var newPosition$1 = ((jsx$4 + l$1) | 0);
            $c_Ljava_nio_Buffer.prototype.position__I__Ljava_nio_Buffer.call($in, newPosition$1);
            continue _loop
          } else {
            throw new $c_s_MatchError().init___O(action)
          }
        }
      }
    }
  }
});
$c_Ljava_nio_charset_CharsetDecoder.prototype.reset__Ljava_nio_charset_CharsetDecoder = (function() {
  this.status$1 = 1;
  return this
});
$c_Ljava_nio_charset_CharsetDecoder.prototype.onMalformedInput__Ljava_nio_charset_CodingErrorAction__Ljava_nio_charset_CharsetDecoder = (function(newAction) {
  if ((newAction === null)) {
    throw new $c_jl_IllegalArgumentException().init___T("null CodingErrorAction")
  };
  this.$$undmalformedInputAction$1 = newAction;
  return this
});
$c_Ljava_nio_charset_CharsetDecoder.prototype.onUnmappableCharacter__Ljava_nio_charset_CodingErrorAction__Ljava_nio_charset_CharsetDecoder = (function(newAction) {
  if ((newAction === null)) {
    throw new $c_jl_IllegalArgumentException().init___T("null CodingErrorAction")
  };
  this.$$undunmappableCharacterAction$1 = newAction;
  return this
});
$c_Ljava_nio_charset_CharsetDecoder.prototype.init___Ljava_nio_charset_Charset__F__F = (function(cs, _averageCharsPerByte, _maxCharsPerByte) {
  this.cs$1 = cs;
  this.$$undaverageCharsPerByte$1 = _averageCharsPerByte;
  this.$$undmaxCharsPerByte$1 = _maxCharsPerByte;
  this.$$undreplacement$1 = "\ufffd";
  this.$$undmalformedInputAction$1 = $m_Ljava_nio_charset_CodingErrorAction$().REPORT$1;
  this.$$undunmappableCharacterAction$1 = $m_Ljava_nio_charset_CodingErrorAction$().REPORT$1;
  this.status$1 = 1;
  return this
});
$c_Ljava_nio_charset_CharsetDecoder.prototype.grow$1__p1__Ljava_nio_CharBuffer__Ljava_nio_CharBuffer = (function(out) {
  if ((out.$$undcapacity$1 === 0)) {
    return $m_Ljava_nio_CharBuffer$().allocate__I__Ljava_nio_CharBuffer(1)
  } else {
    var result = $m_Ljava_nio_CharBuffer$().allocate__I__Ljava_nio_CharBuffer((out.$$undcapacity$1 << 1));
    $c_Ljava_nio_Buffer.prototype.flip__Ljava_nio_Buffer.call(out);
    result.put__Ljava_nio_CharBuffer__Ljava_nio_CharBuffer(out);
    return result
  }
});
/** @constructor */
function $c_Ljava_nio_charset_CoderResult() {
  $c_O.call(this);
  this.java$nio$charset$CoderResult$$kind$f = 0;
  this.java$nio$charset$CoderResult$$$undlength$f = 0
}
$c_Ljava_nio_charset_CoderResult.prototype = new $h_O();
$c_Ljava_nio_charset_CoderResult.prototype.constructor = $c_Ljava_nio_charset_CoderResult;
/** @constructor */
function $h_Ljava_nio_charset_CoderResult() {
  /*<skip>*/
}
$h_Ljava_nio_charset_CoderResult.prototype = $c_Ljava_nio_charset_CoderResult.prototype;
$c_Ljava_nio_charset_CoderResult.prototype.init___I__I = (function(kind, _length) {
  this.java$nio$charset$CoderResult$$kind$f = kind;
  this.java$nio$charset$CoderResult$$$undlength$f = _length;
  return this
});
$c_Ljava_nio_charset_CoderResult.prototype.throwException__V = (function() {
  var x1 = this.java$nio$charset$CoderResult$$kind$f;
  switch (x1) {
    case 1: {
      throw new $c_Ljava_nio_BufferOverflowException().init___();
      break
    }
    case 0: {
      throw new $c_Ljava_nio_BufferUnderflowException().init___();
      break
    }
    case 2: {
      throw new $c_Ljava_nio_charset_MalformedInputException().init___I(this.java$nio$charset$CoderResult$$$undlength$f);
      break
    }
    case 3: {
      throw new $c_Ljava_nio_charset_UnmappableCharacterException().init___I(this.java$nio$charset$CoderResult$$$undlength$f);
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
function $is_Ljava_nio_charset_CoderResult(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Ljava_nio_charset_CoderResult)))
}
function $as_Ljava_nio_charset_CoderResult(obj) {
  return (($is_Ljava_nio_charset_CoderResult(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.nio.charset.CoderResult"))
}
function $isArrayOf_Ljava_nio_charset_CoderResult(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Ljava_nio_charset_CoderResult)))
}
function $asArrayOf_Ljava_nio_charset_CoderResult(obj, depth) {
  return (($isArrayOf_Ljava_nio_charset_CoderResult(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.nio.charset.CoderResult;", depth))
}
var $d_Ljava_nio_charset_CoderResult = new $TypeData().initClass({
  Ljava_nio_charset_CoderResult: 0
}, false, "java.nio.charset.CoderResult", {
  Ljava_nio_charset_CoderResult: 1,
  O: 1
});
$c_Ljava_nio_charset_CoderResult.prototype.$classData = $d_Ljava_nio_charset_CoderResult;
/** @constructor */
function $c_Ljava_nio_charset_CoderResult$() {
  $c_O.call(this);
  this.Underflow$1 = 0;
  this.Overflow$1 = 0;
  this.Malformed$1 = 0;
  this.Unmappable$1 = 0;
  this.OVERFLOW$1 = null;
  this.UNDERFLOW$1 = null;
  this.java$nio$charset$CoderResult$$Malformed1$1 = null;
  this.java$nio$charset$CoderResult$$Malformed2$1 = null;
  this.java$nio$charset$CoderResult$$Malformed3$1 = null;
  this.java$nio$charset$CoderResult$$Malformed4$1 = null;
  this.uniqueMalformed$1 = null;
  this.java$nio$charset$CoderResult$$Unmappable1$1 = null;
  this.java$nio$charset$CoderResult$$Unmappable2$1 = null;
  this.java$nio$charset$CoderResult$$Unmappable3$1 = null;
  this.java$nio$charset$CoderResult$$Unmappable4$1 = null;
  this.uniqueUnmappable$1 = null
}
$c_Ljava_nio_charset_CoderResult$.prototype = new $h_O();
$c_Ljava_nio_charset_CoderResult$.prototype.constructor = $c_Ljava_nio_charset_CoderResult$;
/** @constructor */
function $h_Ljava_nio_charset_CoderResult$() {
  /*<skip>*/
}
$h_Ljava_nio_charset_CoderResult$.prototype = $c_Ljava_nio_charset_CoderResult$.prototype;
$c_Ljava_nio_charset_CoderResult$.prototype.init___ = (function() {
  $n_Ljava_nio_charset_CoderResult$ = this;
  this.OVERFLOW$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(1, (-1));
  this.UNDERFLOW$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(0, (-1));
  this.java$nio$charset$CoderResult$$Malformed1$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(2, 1);
  this.java$nio$charset$CoderResult$$Malformed2$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(2, 2);
  this.java$nio$charset$CoderResult$$Malformed3$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(2, 3);
  this.java$nio$charset$CoderResult$$Malformed4$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(2, 4);
  this.uniqueMalformed$1 = new $c_scm_HashMap().init___();
  this.java$nio$charset$CoderResult$$Unmappable1$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(3, 1);
  this.java$nio$charset$CoderResult$$Unmappable2$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(3, 2);
  this.java$nio$charset$CoderResult$$Unmappable3$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(3, 3);
  this.java$nio$charset$CoderResult$$Unmappable4$1 = new $c_Ljava_nio_charset_CoderResult().init___I__I(3, 4);
  this.uniqueUnmappable$1 = new $c_scm_HashMap().init___();
  return this
});
$c_Ljava_nio_charset_CoderResult$.prototype.java$nio$charset$CoderResult$$malformedForLengthImpl__I__Ljava_nio_charset_CoderResult = (function(length) {
  return $as_Ljava_nio_charset_CoderResult(this.uniqueMalformed$1.getOrElseUpdate__O__F0__O(length, new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, length$1) {
    return (function() {
      return new $c_Ljava_nio_charset_CoderResult().init___I__I(2, length$1)
    })
  })(this, length))))
});
var $d_Ljava_nio_charset_CoderResult$ = new $TypeData().initClass({
  Ljava_nio_charset_CoderResult$: 0
}, false, "java.nio.charset.CoderResult$", {
  Ljava_nio_charset_CoderResult$: 1,
  O: 1
});
$c_Ljava_nio_charset_CoderResult$.prototype.$classData = $d_Ljava_nio_charset_CoderResult$;
var $n_Ljava_nio_charset_CoderResult$ = (void 0);
function $m_Ljava_nio_charset_CoderResult$() {
  if ((!$n_Ljava_nio_charset_CoderResult$)) {
    $n_Ljava_nio_charset_CoderResult$ = new $c_Ljava_nio_charset_CoderResult$().init___()
  };
  return $n_Ljava_nio_charset_CoderResult$
}
/** @constructor */
function $c_Ljava_nio_charset_CodingErrorAction() {
  $c_O.call(this);
  this.name$1 = null
}
$c_Ljava_nio_charset_CodingErrorAction.prototype = new $h_O();
$c_Ljava_nio_charset_CodingErrorAction.prototype.constructor = $c_Ljava_nio_charset_CodingErrorAction;
/** @constructor */
function $h_Ljava_nio_charset_CodingErrorAction() {
  /*<skip>*/
}
$h_Ljava_nio_charset_CodingErrorAction.prototype = $c_Ljava_nio_charset_CodingErrorAction.prototype;
$c_Ljava_nio_charset_CodingErrorAction.prototype.toString__T = (function() {
  return this.name$1
});
$c_Ljava_nio_charset_CodingErrorAction.prototype.init___T = (function(name) {
  this.name$1 = name;
  return this
});
var $d_Ljava_nio_charset_CodingErrorAction = new $TypeData().initClass({
  Ljava_nio_charset_CodingErrorAction: 0
}, false, "java.nio.charset.CodingErrorAction", {
  Ljava_nio_charset_CodingErrorAction: 1,
  O: 1
});
$c_Ljava_nio_charset_CodingErrorAction.prototype.$classData = $d_Ljava_nio_charset_CodingErrorAction;
/** @constructor */
function $c_Ljava_nio_charset_CodingErrorAction$() {
  $c_O.call(this);
  this.IGNORE$1 = null;
  this.REPLACE$1 = null;
  this.REPORT$1 = null
}
$c_Ljava_nio_charset_CodingErrorAction$.prototype = new $h_O();
$c_Ljava_nio_charset_CodingErrorAction$.prototype.constructor = $c_Ljava_nio_charset_CodingErrorAction$;
/** @constructor */
function $h_Ljava_nio_charset_CodingErrorAction$() {
  /*<skip>*/
}
$h_Ljava_nio_charset_CodingErrorAction$.prototype = $c_Ljava_nio_charset_CodingErrorAction$.prototype;
$c_Ljava_nio_charset_CodingErrorAction$.prototype.init___ = (function() {
  $n_Ljava_nio_charset_CodingErrorAction$ = this;
  this.IGNORE$1 = new $c_Ljava_nio_charset_CodingErrorAction().init___T("IGNORE");
  this.REPLACE$1 = new $c_Ljava_nio_charset_CodingErrorAction().init___T("REPLACE");
  this.REPORT$1 = new $c_Ljava_nio_charset_CodingErrorAction().init___T("REPORT");
  return this
});
var $d_Ljava_nio_charset_CodingErrorAction$ = new $TypeData().initClass({
  Ljava_nio_charset_CodingErrorAction$: 0
}, false, "java.nio.charset.CodingErrorAction$", {
  Ljava_nio_charset_CodingErrorAction$: 1,
  O: 1
});
$c_Ljava_nio_charset_CodingErrorAction$.prototype.$classData = $d_Ljava_nio_charset_CodingErrorAction$;
var $n_Ljava_nio_charset_CodingErrorAction$ = (void 0);
function $m_Ljava_nio_charset_CodingErrorAction$() {
  if ((!$n_Ljava_nio_charset_CodingErrorAction$)) {
    $n_Ljava_nio_charset_CodingErrorAction$ = new $c_Ljava_nio_charset_CodingErrorAction$().init___()
  };
  return $n_Ljava_nio_charset_CodingErrorAction$
}
/** @constructor */
function $c_Llocales_LocaleRegistry$() {
  $c_O.call(this);
  this.en$1 = null;
  this.fr$1 = null;
  this.de$1 = null;
  this.it$1 = null;
  this.ja$1 = null;
  this.ko$1 = null;
  this.zh$1 = null;
  this.zh$undHans$undCN$1 = null;
  this.zh$undHant$undTW$1 = null;
  this.fr$undFR$1 = null;
  this.de$undDE$1 = null;
  this.it$undIT$1 = null;
  this.ja$undJP$1 = null;
  this.ko$undKR$1 = null;
  this.en$undGB$1 = null;
  this.en$undUS$1 = null;
  this.en$undCA$1 = null;
  this.fr$undCA$1 = null;
  this.root$1 = null;
  this.defaultLocales$1 = null;
  this.locales$LocaleRegistry$$defaultLocale$1 = null;
  this.defaultPerCategory$1 = null;
  this.ldmls$1 = null;
  this.bitmap$0$1 = 0
}
$c_Llocales_LocaleRegistry$.prototype = new $h_O();
$c_Llocales_LocaleRegistry$.prototype.constructor = $c_Llocales_LocaleRegistry$;
/** @constructor */
function $h_Llocales_LocaleRegistry$() {
  /*<skip>*/
}
$h_Llocales_LocaleRegistry$.prototype = $c_Llocales_LocaleRegistry$.prototype;
$c_Llocales_LocaleRegistry$.prototype.en$undUS__Llocales_cldr_LDML = (function() {
  return (((32768 & this.bitmap$0$1) === 0) ? this.en$undUS$lzycompute__p1__Llocales_cldr_LDML() : this.en$undUS$1)
});
$c_Llocales_LocaleRegistry$.prototype.init___ = (function() {
  $n_Llocales_LocaleRegistry$ = this;
  this.locales$LocaleRegistry$$defaultLocale$1 = this.en__Llocales_cldr_LDML().toLocale__ju_Locale();
  var this$1 = $m_ju_Locale$Category$();
  var xs = this$1.categories__p1__Aju_Locale$Category();
  var elems$2 = null;
  elems$2 = [];
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var x$1 = $as_ju_Locale$Category(arg1);
    var y = new $c_s_Some().init___O($m_Llocales_LocaleRegistry$().locales$LocaleRegistry$$defaultLocale$1);
    var elem = new $c_T2().init___O__O(x$1, y);
    elems$2.push(elem);
    i = ((1 + i) | 0)
  };
  var xs$1 = $makeNativeArrayWrapper($d_T2.getArrayOf(), elems$2);
  var b = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  var i$1 = 0;
  var len$1 = xs$1.u.length;
  while ((i$1 < len$1)) {
    var index$1 = i$1;
    var arg1$1 = xs$1.get(index$1);
    b.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1$1));
    i$1 = ((1 + i$1) | 0)
  };
  this.defaultPerCategory$1 = $as_sci_Map(b.elems$1);
  this.initDefaultLocales__p1__V();
  return this
});
$c_Llocales_LocaleRegistry$.prototype.fr$undFR$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((512 & this.bitmap$0$1) === 0)) {
    this.fr$undFR$1 = $m_Llocales_cldr_data_fr$undFR$();
    this.bitmap$0$1 = (512 | this.bitmap$0$1)
  };
  return this.fr$undFR$1
});
$c_Llocales_LocaleRegistry$.prototype.ko$undKR__Llocales_cldr_LDML = (function() {
  return (((8192 & this.bitmap$0$1) === 0) ? this.ko$undKR$lzycompute__p1__Llocales_cldr_LDML() : this.ko$undKR$1)
});
$c_Llocales_LocaleRegistry$.prototype.defaultLocales$lzycompute__p1__sc_Map = (function() {
  if (((524288 & this.bitmap$0$1) === 0)) {
    var this$1 = this.root__Llocales_cldr_LDML();
    var self = this$1.toLocale__ju_Locale().toLanguageTag__T();
    var y = this.root__Llocales_cldr_LDML();
    var jsx$18 = new $c_T2().init___O__O(self, y);
    var this$4 = this.en__Llocales_cldr_LDML();
    var self$1 = this$4.toLocale__ju_Locale().toLanguageTag__T();
    var y$1 = this.en__Llocales_cldr_LDML();
    var jsx$17 = new $c_T2().init___O__O(self$1, y$1);
    var this$7 = this.fr__Llocales_cldr_LDML();
    var self$2 = this$7.toLocale__ju_Locale().toLanguageTag__T();
    var y$2 = this.fr__Llocales_cldr_LDML();
    var jsx$16 = new $c_T2().init___O__O(self$2, y$2);
    var this$10 = this.de__Llocales_cldr_LDML();
    var self$3 = this$10.toLocale__ju_Locale().toLanguageTag__T();
    var y$3 = this.de__Llocales_cldr_LDML();
    var jsx$15 = new $c_T2().init___O__O(self$3, y$3);
    var this$13 = this.it__Llocales_cldr_LDML();
    var self$4 = this$13.toLocale__ju_Locale().toLanguageTag__T();
    var y$4 = this.it__Llocales_cldr_LDML();
    var jsx$14 = new $c_T2().init___O__O(self$4, y$4);
    var this$16 = this.ja__Llocales_cldr_LDML();
    var self$5 = this$16.toLocale__ju_Locale().toLanguageTag__T();
    var y$5 = this.ja__Llocales_cldr_LDML();
    var jsx$13 = new $c_T2().init___O__O(self$5, y$5);
    var this$19 = this.ko__Llocales_cldr_LDML();
    var self$6 = this$19.toLocale__ju_Locale().toLanguageTag__T();
    var y$6 = this.ko__Llocales_cldr_LDML();
    var jsx$12 = new $c_T2().init___O__O(self$6, y$6);
    var this$22 = this.zh__Llocales_cldr_LDML();
    var self$7 = this$22.toLocale__ju_Locale().toLanguageTag__T();
    var y$7 = this.zh__Llocales_cldr_LDML();
    var jsx$11 = new $c_T2().init___O__O(self$7, y$7);
    var this$25 = this.zh$undHans$undCN__Llocales_cldr_LDML();
    var self$8 = this$25.toLocale__ju_Locale().toLanguageTag__T();
    var y$8 = this.zh$undHans$undCN__Llocales_cldr_LDML();
    var jsx$10 = new $c_T2().init___O__O(self$8, y$8);
    var this$28 = this.zh$undHant$undTW__Llocales_cldr_LDML();
    var self$9 = this$28.toLocale__ju_Locale().toLanguageTag__T();
    var y$9 = this.zh$undHant$undTW__Llocales_cldr_LDML();
    var jsx$9 = new $c_T2().init___O__O(self$9, y$9);
    var this$31 = this.fr$undFR__Llocales_cldr_LDML();
    var self$10 = this$31.toLocale__ju_Locale().toLanguageTag__T();
    var y$10 = this.fr$undFR__Llocales_cldr_LDML();
    var jsx$8 = new $c_T2().init___O__O(self$10, y$10);
    var this$34 = this.de$undDE__Llocales_cldr_LDML();
    var self$11 = this$34.toLocale__ju_Locale().toLanguageTag__T();
    var y$11 = this.de$undDE__Llocales_cldr_LDML();
    var jsx$7 = new $c_T2().init___O__O(self$11, y$11);
    var this$37 = this.it$undIT__Llocales_cldr_LDML();
    var self$12 = this$37.toLocale__ju_Locale().toLanguageTag__T();
    var y$12 = this.it$undIT__Llocales_cldr_LDML();
    var jsx$6 = new $c_T2().init___O__O(self$12, y$12);
    var this$40 = this.ja$undJP__Llocales_cldr_LDML();
    var self$13 = this$40.toLocale__ju_Locale().toLanguageTag__T();
    var y$13 = this.ja$undJP__Llocales_cldr_LDML();
    var jsx$5 = new $c_T2().init___O__O(self$13, y$13);
    var this$43 = this.ko$undKR__Llocales_cldr_LDML();
    var self$14 = this$43.toLocale__ju_Locale().toLanguageTag__T();
    var y$14 = this.ko$undKR__Llocales_cldr_LDML();
    var jsx$4 = new $c_T2().init___O__O(self$14, y$14);
    var this$46 = this.en$undGB__Llocales_cldr_LDML();
    var self$15 = this$46.toLocale__ju_Locale().toLanguageTag__T();
    var y$15 = this.en$undGB__Llocales_cldr_LDML();
    var jsx$3 = new $c_T2().init___O__O(self$15, y$15);
    var this$49 = this.en$undUS__Llocales_cldr_LDML();
    var self$16 = this$49.toLocale__ju_Locale().toLanguageTag__T();
    var y$16 = this.en$undUS__Llocales_cldr_LDML();
    var jsx$2 = new $c_T2().init___O__O(self$16, y$16);
    var this$52 = this.en$undCA__Llocales_cldr_LDML();
    var self$17 = this$52.toLocale__ju_Locale().toLanguageTag__T();
    var y$17 = this.en$undCA__Llocales_cldr_LDML();
    var jsx$1 = new $c_T2().init___O__O(self$17, y$17);
    var this$55 = this.fr$undCA__Llocales_cldr_LDML();
    var self$18 = this$55.toLocale__ju_Locale().toLanguageTag__T();
    var y$18 = this.fr$undCA__Llocales_cldr_LDML();
    var array = [jsx$18, jsx$17, jsx$16, jsx$15, jsx$14, jsx$13, jsx$12, jsx$11, jsx$10, jsx$9, jsx$8, jsx$7, jsx$6, jsx$5, jsx$4, jsx$3, jsx$2, jsx$1, new $c_T2().init___O__O(self$18, y$18)];
    var this$60 = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
    var i = 0;
    var len = $uI(array.length);
    while ((i < len)) {
      var index = i;
      var arg1 = array[index];
      this$60.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1));
      i = ((1 + i) | 0)
    };
    this.defaultLocales$1 = $as_sc_Map(this$60.elems$1);
    this.bitmap$0$1 = (524288 | this.bitmap$0$1)
  };
  return this.defaultLocales$1
});
$c_Llocales_LocaleRegistry$.prototype.en$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.en$1 = $m_Llocales_cldr_data_en$();
    this.bitmap$0$1 = (1 | this.bitmap$0$1)
  };
  return this.en$1
});
$c_Llocales_LocaleRegistry$.prototype.zh$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((64 & this.bitmap$0$1) === 0)) {
    this.zh$1 = $m_Llocales_cldr_data_zh$();
    this.bitmap$0$1 = (64 | this.bitmap$0$1)
  };
  return this.zh$1
});
$c_Llocales_LocaleRegistry$.prototype.installLocale__Llocales_cldr_LDML__V = (function(ldml) {
  var jsx$1 = this.ldmls__p1__scm_Map();
  var self = ldml.toLocale__ju_Locale().toLanguageTag__T();
  jsx$1.$$plus$eq__T2__scm_MapLike(new $c_T2().init___O__O(self, ldml))
});
$c_Llocales_LocaleRegistry$.prototype.zh__Llocales_cldr_LDML = (function() {
  return (((64 & this.bitmap$0$1) === 0) ? this.zh$lzycompute__p1__Llocales_cldr_LDML() : this.zh$1)
});
$c_Llocales_LocaleRegistry$.prototype.root__Llocales_cldr_LDML = (function() {
  return (((262144 & this.bitmap$0$1) === 0) ? this.root$lzycompute__p1__Llocales_cldr_LDML() : this.root$1)
});
$c_Llocales_LocaleRegistry$.prototype.zh$undHans$undCN$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((128 & this.bitmap$0$1) === 0)) {
    var x$6 = $m_s_None$();
    var this$1 = $m_Llocales_cldr_data_zh$undHans$undCN$().locale$1;
    var x$7 = this$1.language$1;
    var this$2 = $m_Llocales_cldr_data_zh$undHans$undCN$().locale$1;
    var x$8 = this$2.territory$1;
    var this$3 = $m_Llocales_cldr_data_zh$undHans$undCN$().locale$1;
    var x$9 = this$3.variant$1;
    $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$10 = new $c_Llocales_cldr_LDMLLocale().init___T__s_Option__s_Option__s_Option(x$7, x$8, x$9, x$6);
    var this$5 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$11 = this$5.parent$1;
    var this$6 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$12 = this$6.defaultNS$1;
    var this$7 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$13 = this$7.digitSymbols$1;
    var this$8 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$14 = this$8.calendarSymbols$1;
    var this$9 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$15 = this$9.calendarPatterns$1;
    var this$10 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$16 = this$10.currencies$1;
    var this$11 = $m_Llocales_cldr_data_zh$undHans$undCN$();
    var x$17 = this$11.numberPatterns$1;
    $m_Llocales_cldr_data_zh$undHans$undCN$();
    this.zh$undHans$undCN$1 = new $c_Llocales_cldr_LDML().init___s_Option__Llocales_cldr_LDMLLocale__s_Option__sci_List__s_Option__s_Option__sci_List__Llocales_cldr_NumberPatterns(x$11, x$10, x$12, x$13, x$14, x$15, x$16, x$17);
    this.bitmap$0$1 = (128 | this.bitmap$0$1)
  };
  return this.zh$undHans$undCN$1
});
$c_Llocales_LocaleRegistry$.prototype.de__Llocales_cldr_LDML = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.de$lzycompute__p1__Llocales_cldr_LDML() : this.de$1)
});
$c_Llocales_LocaleRegistry$.prototype.en$undUS$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((32768 & this.bitmap$0$1) === 0)) {
    this.en$undUS$1 = $m_Llocales_cldr_data_en$undUS$();
    this.bitmap$0$1 = (32768 | this.bitmap$0$1)
  };
  return this.en$undUS$1
});
$c_Llocales_LocaleRegistry$.prototype.fr$undCA__Llocales_cldr_LDML = (function() {
  return (((131072 & this.bitmap$0$1) === 0) ? this.fr$undCA$lzycompute__p1__Llocales_cldr_LDML() : this.fr$undCA$1)
});
$c_Llocales_LocaleRegistry$.prototype.defaultLocales__p1__sc_Map = (function() {
  return (((524288 & this.bitmap$0$1) === 0) ? this.defaultLocales$lzycompute__p1__sc_Map() : this.defaultLocales$1)
});
$c_Llocales_LocaleRegistry$.prototype.en$undCA__Llocales_cldr_LDML = (function() {
  return (((65536 & this.bitmap$0$1) === 0) ? this.en$undCA$lzycompute__p1__Llocales_cldr_LDML() : this.en$undCA$1)
});
$c_Llocales_LocaleRegistry$.prototype.ldmls__p1__scm_Map = (function() {
  return (((1048576 & this.bitmap$0$1) === 0) ? this.ldmls$lzycompute__p1__scm_Map() : this.ldmls$1)
});
$c_Llocales_LocaleRegistry$.prototype.ja$undJP$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((4096 & this.bitmap$0$1) === 0)) {
    this.ja$undJP$1 = $m_Llocales_cldr_data_ja$undJP$();
    this.bitmap$0$1 = (4096 | this.bitmap$0$1)
  };
  return this.ja$undJP$1
});
$c_Llocales_LocaleRegistry$.prototype.fr$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.fr$1 = $m_Llocales_cldr_data_fr$();
    this.bitmap$0$1 = (2 | this.bitmap$0$1)
  };
  return this.fr$1
});
$c_Llocales_LocaleRegistry$.prototype.setDefault__ju_Locale__V = (function(newLocale) {
  if ((newLocale === null)) {
    throw new $c_jl_NullPointerException().init___T("Argument cannot be null")
  };
  this.locales$LocaleRegistry$$defaultLocale$1 = newLocale;
  var this$1 = $m_ju_Locale$Category$();
  var xs = this$1.categories__p1__Aju_Locale$Category();
  var elems$2 = null;
  elems$2 = [];
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var x$3 = $as_ju_Locale$Category(arg1);
    var y = new $c_s_Some().init___O(newLocale);
    var elem = new $c_T2().init___O__O(x$3, y);
    elems$2.push(elem);
    i = ((1 + i) | 0)
  };
  var xs$1 = $makeNativeArrayWrapper($d_T2.getArrayOf(), elems$2);
  var b = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  var i$1 = 0;
  var len$1 = xs$1.u.length;
  while ((i$1 < len$1)) {
    var index$1 = i$1;
    var arg1$1 = xs$1.get(index$1);
    b.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1$1));
    i$1 = ((1 + i$1) | 0)
  };
  this.defaultPerCategory$1 = $as_sci_Map(b.elems$1)
});
$c_Llocales_LocaleRegistry$.prototype.it$undIT__Llocales_cldr_LDML = (function() {
  return (((2048 & this.bitmap$0$1) === 0) ? this.it$undIT$lzycompute__p1__Llocales_cldr_LDML() : this.it$undIT$1)
});
$c_Llocales_LocaleRegistry$.prototype.ldmls$lzycompute__p1__scm_Map = (function() {
  if (((1048576 & this.bitmap$0$1) === 0)) {
    this.ldmls$1 = new $c_scm_HashMap().init___();
    this.bitmap$0$1 = (1048576 | this.bitmap$0$1)
  };
  return this.ldmls$1
});
$c_Llocales_LocaleRegistry$.prototype.fr$undFR__Llocales_cldr_LDML = (function() {
  return (((512 & this.bitmap$0$1) === 0) ? this.fr$undFR$lzycompute__p1__Llocales_cldr_LDML() : this.fr$undFR$1)
});
$c_Llocales_LocaleRegistry$.prototype.ja__Llocales_cldr_LDML = (function() {
  return (((16 & this.bitmap$0$1) === 0) ? this.ja$lzycompute__p1__Llocales_cldr_LDML() : this.ja$1)
});
$c_Llocales_LocaleRegistry$.prototype.en$undGB$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((16384 & this.bitmap$0$1) === 0)) {
    this.en$undGB$1 = $m_Llocales_cldr_data_en$undGB$();
    this.bitmap$0$1 = (16384 | this.bitmap$0$1)
  };
  return this.en$undGB$1
});
$c_Llocales_LocaleRegistry$.prototype.de$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.de$1 = $m_Llocales_cldr_data_de$();
    this.bitmap$0$1 = (4 | this.bitmap$0$1)
  };
  return this.de$1
});
$c_Llocales_LocaleRegistry$.prototype.ko$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((32 & this.bitmap$0$1) === 0)) {
    this.ko$1 = $m_Llocales_cldr_data_ko$();
    this.bitmap$0$1 = (32 | this.bitmap$0$1)
  };
  return this.ko$1
});
$c_Llocales_LocaleRegistry$.prototype.it$undIT$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((2048 & this.bitmap$0$1) === 0)) {
    this.it$undIT$1 = $m_Llocales_cldr_data_it$undIT$();
    this.bitmap$0$1 = (2048 | this.bitmap$0$1)
  };
  return this.it$undIT$1
});
$c_Llocales_LocaleRegistry$.prototype.zh$undHant$undTW$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((256 & this.bitmap$0$1) === 0)) {
    var x$18 = $m_s_None$();
    var this$1 = $m_Llocales_cldr_data_zh$undHant$undTW$().locale$1;
    var x$19 = this$1.language$1;
    var this$2 = $m_Llocales_cldr_data_zh$undHant$undTW$().locale$1;
    var x$20 = this$2.territory$1;
    var this$3 = $m_Llocales_cldr_data_zh$undHant$undTW$().locale$1;
    var x$21 = this$3.variant$1;
    $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$22 = new $c_Llocales_cldr_LDMLLocale().init___T__s_Option__s_Option__s_Option(x$19, x$20, x$21, x$18);
    var this$5 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$23 = this$5.parent$1;
    var this$6 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$24 = this$6.defaultNS$1;
    var this$7 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$25 = this$7.digitSymbols$1;
    var this$8 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$26 = this$8.calendarSymbols$1;
    var this$9 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$27 = this$9.calendarPatterns$1;
    var this$10 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$28 = this$10.currencies$1;
    var this$11 = $m_Llocales_cldr_data_zh$undHant$undTW$();
    var x$29 = this$11.numberPatterns$1;
    $m_Llocales_cldr_data_zh$undHant$undTW$();
    this.zh$undHant$undTW$1 = new $c_Llocales_cldr_LDML().init___s_Option__Llocales_cldr_LDMLLocale__s_Option__sci_List__s_Option__s_Option__sci_List__Llocales_cldr_NumberPatterns(x$23, x$22, x$24, x$25, x$26, x$27, x$28, x$29);
    this.bitmap$0$1 = (256 | this.bitmap$0$1)
  };
  return this.zh$undHant$undTW$1
});
$c_Llocales_LocaleRegistry$.prototype.fr__Llocales_cldr_LDML = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.fr$lzycompute__p1__Llocales_cldr_LDML() : this.fr$1)
});
$c_Llocales_LocaleRegistry$.prototype.root$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((262144 & this.bitmap$0$1) === 0)) {
    this.root$1 = $m_Llocales_cldr_data_root$();
    this.bitmap$0$1 = (262144 | this.bitmap$0$1)
  };
  return this.root$1
});
$c_Llocales_LocaleRegistry$.prototype.en$undGB__Llocales_cldr_LDML = (function() {
  return (((16384 & this.bitmap$0$1) === 0) ? this.en$undGB$lzycompute__p1__Llocales_cldr_LDML() : this.en$undGB$1)
});
$c_Llocales_LocaleRegistry$.prototype.ko__Llocales_cldr_LDML = (function() {
  return (((32 & this.bitmap$0$1) === 0) ? this.ko$lzycompute__p1__Llocales_cldr_LDML() : this.ko$1)
});
$c_Llocales_LocaleRegistry$.prototype.en__Llocales_cldr_LDML = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.en$lzycompute__p1__Llocales_cldr_LDML() : this.en$1)
});
$c_Llocales_LocaleRegistry$.prototype.ja$undJP__Llocales_cldr_LDML = (function() {
  return (((4096 & this.bitmap$0$1) === 0) ? this.ja$undJP$lzycompute__p1__Llocales_cldr_LDML() : this.ja$undJP$1)
});
$c_Llocales_LocaleRegistry$.prototype.ko$undKR$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((8192 & this.bitmap$0$1) === 0)) {
    this.ko$undKR$1 = $m_Llocales_cldr_data_ko$undKR$();
    this.bitmap$0$1 = (8192 | this.bitmap$0$1)
  };
  return this.ko$undKR$1
});
$c_Llocales_LocaleRegistry$.prototype.it__Llocales_cldr_LDML = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.it$lzycompute__p1__Llocales_cldr_LDML() : this.it$1)
});
$c_Llocales_LocaleRegistry$.prototype.de$undDE$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((1024 & this.bitmap$0$1) === 0)) {
    this.de$undDE$1 = $m_Llocales_cldr_data_de$undDE$();
    this.bitmap$0$1 = (1024 | this.bitmap$0$1)
  };
  return this.de$undDE$1
});
$c_Llocales_LocaleRegistry$.prototype.en$undCA$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((65536 & this.bitmap$0$1) === 0)) {
    this.en$undCA$1 = $m_Llocales_cldr_data_en$undCA$();
    this.bitmap$0$1 = (65536 | this.bitmap$0$1)
  };
  return this.en$undCA$1
});
$c_Llocales_LocaleRegistry$.prototype.initDefaultLocales__p1__V = (function() {
  this.defaultLocales__p1__sc_Map().foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x0$1$2) {
    var x0$1 = $as_T2(x0$1$2);
    if ((x0$1 !== null)) {
      var l = $as_Llocales_cldr_LDML(x0$1.$$und2__O());
      $m_Llocales_LocaleRegistry$().installLocale__Llocales_cldr_LDML__V(l)
    } else {
      throw new $c_s_MatchError().init___O(x0$1)
    }
  })))
});
$c_Llocales_LocaleRegistry$.prototype.ja$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((16 & this.bitmap$0$1) === 0)) {
    this.ja$1 = $m_Llocales_cldr_data_ja$();
    this.bitmap$0$1 = (16 | this.bitmap$0$1)
  };
  return this.ja$1
});
$c_Llocales_LocaleRegistry$.prototype.zh$undHans$undCN__Llocales_cldr_LDML = (function() {
  return (((128 & this.bitmap$0$1) === 0) ? this.zh$undHans$undCN$lzycompute__p1__Llocales_cldr_LDML() : this.zh$undHans$undCN$1)
});
$c_Llocales_LocaleRegistry$.prototype.de$undDE__Llocales_cldr_LDML = (function() {
  return (((1024 & this.bitmap$0$1) === 0) ? this.de$undDE$lzycompute__p1__Llocales_cldr_LDML() : this.de$undDE$1)
});
$c_Llocales_LocaleRegistry$.prototype.it$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    this.it$1 = $m_Llocales_cldr_data_it$();
    this.bitmap$0$1 = (8 | this.bitmap$0$1)
  };
  return this.it$1
});
$c_Llocales_LocaleRegistry$.prototype.fr$undCA$lzycompute__p1__Llocales_cldr_LDML = (function() {
  if (((131072 & this.bitmap$0$1) === 0)) {
    this.fr$undCA$1 = $m_Llocales_cldr_data_fr$undCA$();
    this.bitmap$0$1 = (131072 | this.bitmap$0$1)
  };
  return this.fr$undCA$1
});
$c_Llocales_LocaleRegistry$.prototype.zh$undHant$undTW__Llocales_cldr_LDML = (function() {
  return (((256 & this.bitmap$0$1) === 0) ? this.zh$undHant$undTW$lzycompute__p1__Llocales_cldr_LDML() : this.zh$undHant$undTW$1)
});
var $d_Llocales_LocaleRegistry$ = new $TypeData().initClass({
  Llocales_LocaleRegistry$: 0
}, false, "locales.LocaleRegistry$", {
  Llocales_LocaleRegistry$: 1,
  O: 1
});
$c_Llocales_LocaleRegistry$.prototype.$classData = $d_Llocales_LocaleRegistry$;
var $n_Llocales_LocaleRegistry$ = (void 0);
function $m_Llocales_LocaleRegistry$() {
  if ((!$n_Llocales_LocaleRegistry$)) {
    $n_Llocales_LocaleRegistry$ = new $c_Llocales_LocaleRegistry$().init___()
  };
  return $n_Llocales_LocaleRegistry$
}
/** @constructor */
function $c_Llocales_cldr_data_numericsystems$() {
  $c_O.call(this);
  this.adlm$1 = null;
  this.ahom$1 = null;
  this.arab$1 = null;
  this.arabext$1 = null;
  this.bali$1 = null;
  this.beng$1 = null;
  this.bhks$1 = null;
  this.brah$1 = null;
  this.cakm$1 = null;
  this.cham$1 = null;
  this.deva$1 = null;
  this.fullwide$1 = null;
  this.gujr$1 = null;
  this.guru$1 = null;
  this.hanidec$1 = null;
  this.hmng$1 = null;
  this.java$1 = null;
  this.kali$1 = null;
  this.khmr$1 = null;
  this.knda$1 = null;
  this.lana$1 = null;
  this.lanatham$1 = null;
  this.laoo$1 = null;
  this.latn$1 = null;
  this.lepc$1 = null;
  this.limb$1 = null;
  this.mathbold$1 = null;
  this.mathdbl$1 = null;
  this.mathmono$1 = null;
  this.mathsanb$1 = null;
  this.mathsans$1 = null;
  this.mlym$1 = null;
  this.modi$1 = null;
  this.mong$1 = null;
  this.mroo$1 = null;
  this.mtei$1 = null;
  this.mymr$1 = null;
  this.mymrshan$1 = null;
  this.mymrtlng$1 = null;
  this.newa$1 = null;
  this.nkoo$1 = null;
  this.olck$1 = null;
  this.orya$1 = null;
  this.osma$1 = null;
  this.saur$1 = null;
  this.shrd$1 = null;
  this.sind$1 = null;
  this.sinh$1 = null;
  this.sora$1 = null;
  this.sund$1 = null;
  this.takr$1 = null;
  this.talu$1 = null;
  this.tamldec$1 = null;
  this.telu$1 = null;
  this.thai$1 = null;
  this.tibt$1 = null;
  this.tirh$1 = null;
  this.vaii$1 = null;
  this.wara$1 = null;
  this.bitmap$0$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_Llocales_cldr_data_numericsystems$.prototype = new $h_O();
$c_Llocales_cldr_data_numericsystems$.prototype.constructor = $c_Llocales_cldr_data_numericsystems$;
/** @constructor */
function $h_Llocales_cldr_data_numericsystems$() {
  /*<skip>*/
}
$h_Llocales_cldr_data_numericsystems$.prototype = $c_Llocales_cldr_data_numericsystems$.prototype;
$c_Llocales_cldr_data_numericsystems$.prototype.lepc__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16777216 & b.lo$2);
  if ((lo === 0)) {
    return this.lepc$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.lepc$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.cham__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (512 & b.lo$2);
  if ((lo === 0)) {
    return this.cham$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.cham$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.fullwide$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (2048 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(65296), new $c_jl_Character().init___C(65297), new $c_jl_Character().init___C(65298), new $c_jl_Character().init___C(65299), new $c_jl_Character().init___C(65300), new $c_jl_Character().init___C(65301), new $c_jl_Character().init___C(65302), new $c_jl_Character().init___C(65303), new $c_jl_Character().init___C(65304), new $c_jl_Character().init___C(65305)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.fullwide$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("fullwide", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (2048 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.fullwide$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.lanatham$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (2097152 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6800), new $c_jl_Character().init___C(6801), new $c_jl_Character().init___C(6802), new $c_jl_Character().init___C(6803), new $c_jl_Character().init___C(6804), new $c_jl_Character().init___C(6805), new $c_jl_Character().init___C(6806), new $c_jl_Character().init___C(6807), new $c_jl_Character().init___C(6808), new $c_jl_Character().init___C(6809)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.lanatham$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("lanatham", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (2097152 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.lanatham$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.khmr$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (262144 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6112), new $c_jl_Character().init___C(6113), new $c_jl_Character().init___C(6114), new $c_jl_Character().init___C(6115), new $c_jl_Character().init___C(6116), new $c_jl_Character().init___C(6117), new $c_jl_Character().init___C(6118), new $c_jl_Character().init___C(6119), new $c_jl_Character().init___C(6120), new $c_jl_Character().init___C(6121)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.khmr$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("khmr", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (262144 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.khmr$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.arabext__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8 & b.lo$2);
  if ((lo === 0)) {
    return this.arabext$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.arabext$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.init___ = (function() {
  return this
});
$c_Llocales_cldr_data_numericsystems$.prototype.orya$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (1024 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2918), new $c_jl_Character().init___C(2919), new $c_jl_Character().init___C(2920), new $c_jl_Character().init___C(2921), new $c_jl_Character().init___C(2922), new $c_jl_Character().init___C(2923), new $c_jl_Character().init___C(2924), new $c_jl_Character().init___C(2925), new $c_jl_Character().init___C(2926), new $c_jl_Character().init___C(2927)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.orya$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("orya", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (1024 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.orya$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.sora__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (65536 & b.hi$2);
  if ((hi === 0)) {
    return this.sora$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.sora$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.deva__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (1024 & b.lo$2);
  if ((lo === 0)) {
    return this.deva$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.deva$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.tamldec$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (1048576 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3046), new $c_jl_Character().init___C(3047), new $c_jl_Character().init___C(3048), new $c_jl_Character().init___C(3049), new $c_jl_Character().init___C(3050), new $c_jl_Character().init___C(3051), new $c_jl_Character().init___C(3052), new $c_jl_Character().init___C(3053), new $c_jl_Character().init___C(3054), new $c_jl_Character().init___C(3055)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.tamldec$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("tamldec", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (1048576 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.tamldec$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.laoo$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4194304 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3792), new $c_jl_Character().init___C(3793), new $c_jl_Character().init___C(3794), new $c_jl_Character().init___C(3795), new $c_jl_Character().init___C(3796), new $c_jl_Character().init___C(3797), new $c_jl_Character().init___C(3798), new $c_jl_Character().init___C(3799), new $c_jl_Character().init___C(3800), new $c_jl_Character().init___C(3801)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.laoo$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("laoo", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (4194304 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.laoo$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mymr$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (16 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(4160), new $c_jl_Character().init___C(4161), new $c_jl_Character().init___C(4162), new $c_jl_Character().init___C(4163), new $c_jl_Character().init___C(4164), new $c_jl_Character().init___C(4165), new $c_jl_Character().init___C(4166), new $c_jl_Character().init___C(4167), new $c_jl_Character().init___C(4168), new $c_jl_Character().init___C(4169)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mymr$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mymr", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (16 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.mymr$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.orya__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (1024 & b.hi$2);
  if ((hi === 0)) {
    return this.orya$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.orya$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.knda__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (524288 & b.lo$2);
  if ((lo === 0)) {
    return this.knda$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.knda$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.sund$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (131072 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(7088), new $c_jl_Character().init___C(7089), new $c_jl_Character().init___C(7090), new $c_jl_Character().init___C(7091), new $c_jl_Character().init___C(7092), new $c_jl_Character().init___C(7093), new $c_jl_Character().init___C(7094), new $c_jl_Character().init___C(7095), new $c_jl_Character().init___C(7096), new $c_jl_Character().init___C(7097)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.sund$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("sund", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (131072 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.sund$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.laoo__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4194304 & b.lo$2);
  if ((lo === 0)) {
    return this.laoo$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.laoo$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.bali__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16 & b.lo$2);
  if ((lo === 0)) {
    return this.bali$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.bali$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.gujr__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4096 & b.lo$2);
  if ((lo === 0)) {
    return this.gujr$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.gujr$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.guru__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8192 & b.lo$2);
  if ((lo === 0)) {
    return this.guru$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.guru$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.saur__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (4096 & b.hi$2);
  if ((hi === 0)) {
    return this.saur$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.saur$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.thai__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (4194304 & b.hi$2);
  if ((hi === 0)) {
    return this.thai$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.thai$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.gujr$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4096 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2790), new $c_jl_Character().init___C(2791), new $c_jl_Character().init___C(2792), new $c_jl_Character().init___C(2793), new $c_jl_Character().init___C(2794), new $c_jl_Character().init___C(2795), new $c_jl_Character().init___C(2796), new $c_jl_Character().init___C(2797), new $c_jl_Character().init___C(2798), new $c_jl_Character().init___C(2799)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.gujr$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("gujr", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (4096 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.gujr$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.lanatham__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (2097152 & b.lo$2);
  if ((lo === 0)) {
    return this.lanatham$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.lanatham$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.brah$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (128 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.brah$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("brah", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (128 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.brah$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.saur$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (4096 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(43216), new $c_jl_Character().init___C(43217), new $c_jl_Character().init___C(43218), new $c_jl_Character().init___C(43219), new $c_jl_Character().init___C(43220), new $c_jl_Character().init___C(43221), new $c_jl_Character().init___C(43222), new $c_jl_Character().init___C(43223), new $c_jl_Character().init___C(43224), new $c_jl_Character().init___C(43225)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.saur$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("saur", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (4096 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.saur$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.osma__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2048 & b.hi$2);
  if ((hi === 0)) {
    return this.osma$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.osma$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.beng$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (32 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2534), new $c_jl_Character().init___C(2535), new $c_jl_Character().init___C(2536), new $c_jl_Character().init___C(2537), new $c_jl_Character().init___C(2538), new $c_jl_Character().init___C(2539), new $c_jl_Character().init___C(2540), new $c_jl_Character().init___C(2541), new $c_jl_Character().init___C(2542), new $c_jl_Character().init___C(2543)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.beng$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("beng", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (32 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.beng$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.cakm__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (256 & b.lo$2);
  if ((lo === 0)) {
    return this.cakm$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.cakm$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.knda$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (524288 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3302), new $c_jl_Character().init___C(3303), new $c_jl_Character().init___C(3304), new $c_jl_Character().init___C(3305), new $c_jl_Character().init___C(3306), new $c_jl_Character().init___C(3307), new $c_jl_Character().init___C(3308), new $c_jl_Character().init___C(3309), new $c_jl_Character().init___C(3310), new $c_jl_Character().init___C(3311)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.knda$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("knda", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (524288 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.knda$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.latn$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8388608 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(48), new $c_jl_Character().init___C(49), new $c_jl_Character().init___C(50), new $c_jl_Character().init___C(51), new $c_jl_Character().init___C(52), new $c_jl_Character().init___C(53), new $c_jl_Character().init___C(54), new $c_jl_Character().init___C(55), new $c_jl_Character().init___C(56), new $c_jl_Character().init___C(57)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.latn$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("latn", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (8388608 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.latn$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.arabext$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(1776), new $c_jl_Character().init___C(1777), new $c_jl_Character().init___C(1778), new $c_jl_Character().init___C(1779), new $c_jl_Character().init___C(1780), new $c_jl_Character().init___C(1781), new $c_jl_Character().init___C(1782), new $c_jl_Character().init___C(1783), new $c_jl_Character().init___C(1784), new $c_jl_Character().init___C(1785)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.arabext$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("arabext", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (8 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.arabext$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.lepc$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16777216 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(7232), new $c_jl_Character().init___C(7233), new $c_jl_Character().init___C(7234), new $c_jl_Character().init___C(7235), new $c_jl_Character().init___C(7236), new $c_jl_Character().init___C(7237), new $c_jl_Character().init___C(7238), new $c_jl_Character().init___C(7239), new $c_jl_Character().init___C(7240), new $c_jl_Character().init___C(7241)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.lepc$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("lepc", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (16777216 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.lepc$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.osma$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2048 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.osma$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("osma", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (2048 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.osma$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.sund__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (131072 & b.hi$2);
  if ((hi === 0)) {
    return this.sund$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.sund$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.guru$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8192 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2662), new $c_jl_Character().init___C(2663), new $c_jl_Character().init___C(2664), new $c_jl_Character().init___C(2665), new $c_jl_Character().init___C(2666), new $c_jl_Character().init___C(2667), new $c_jl_Character().init___C(2668), new $c_jl_Character().init___C(2669), new $c_jl_Character().init___C(2670), new $c_jl_Character().init___C(2671)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.guru$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("guru", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (8192 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.guru$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.tibt__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8388608 & b.hi$2);
  if ((hi === 0)) {
    return this.tibt$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.tibt$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mymrshan__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (32 & b.hi$2);
  if ((hi === 0)) {
    return this.mymrshan$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mymrshan$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.lana__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (1048576 & b.lo$2);
  if ((lo === 0)) {
    return this.lana$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.lana$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.telu$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2097152 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3174), new $c_jl_Character().init___C(3175), new $c_jl_Character().init___C(3176), new $c_jl_Character().init___C(3177), new $c_jl_Character().init___C(3178), new $c_jl_Character().init___C(3179), new $c_jl_Character().init___C(3180), new $c_jl_Character().init___C(3181), new $c_jl_Character().init___C(3182), new $c_jl_Character().init___C(3183)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.telu$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("telu", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (2097152 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.telu$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.java__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (65536 & b.lo$2);
  if ((lo === 0)) {
    return this.java$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.java$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.shrd__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8192 & b.hi$2);
  if ((hi === 0)) {
    return this.shrd$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.shrd$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.sora$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (65536 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.sora$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("sora", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (65536 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.sora$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.cham$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (512 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(43600), new $c_jl_Character().init___C(43601), new $c_jl_Character().init___C(43602), new $c_jl_Character().init___C(43603), new $c_jl_Character().init___C(43604), new $c_jl_Character().init___C(43605), new $c_jl_Character().init___C(43606), new $c_jl_Character().init___C(43607), new $c_jl_Character().init___C(43608), new $c_jl_Character().init___C(43609)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.cham$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("cham", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (512 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.cham$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.arab$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(1632), new $c_jl_Character().init___C(1633), new $c_jl_Character().init___C(1634), new $c_jl_Character().init___C(1635), new $c_jl_Character().init___C(1636), new $c_jl_Character().init___C(1637), new $c_jl_Character().init___C(1638), new $c_jl_Character().init___C(1639), new $c_jl_Character().init___C(1640), new $c_jl_Character().init___C(1641)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.arab$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("arab", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (4 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.arab$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.kali$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (131072 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(43264), new $c_jl_Character().init___C(43265), new $c_jl_Character().init___C(43266), new $c_jl_Character().init___C(43267), new $c_jl_Character().init___C(43268), new $c_jl_Character().init___C(43269), new $c_jl_Character().init___C(43270), new $c_jl_Character().init___C(43271), new $c_jl_Character().init___C(43272), new $c_jl_Character().init___C(43273)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.kali$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("kali", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (131072 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.kali$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mlym$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = ((-2147483648) & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3430), new $c_jl_Character().init___C(3431), new $c_jl_Character().init___C(3432), new $c_jl_Character().init___C(3433), new $c_jl_Character().init___C(3434), new $c_jl_Character().init___C(3435), new $c_jl_Character().init___C(3436), new $c_jl_Character().init___C(3437), new $c_jl_Character().init___C(3438), new $c_jl_Character().init___C(3439)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mlym$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mlym", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = ((-2147483648) | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.mlym$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.vaii$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (33554432 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(42528), new $c_jl_Character().init___C(42529), new $c_jl_Character().init___C(42530), new $c_jl_Character().init___C(42531), new $c_jl_Character().init___C(42532), new $c_jl_Character().init___C(42533), new $c_jl_Character().init___C(42534), new $c_jl_Character().init___C(42535), new $c_jl_Character().init___C(42536), new $c_jl_Character().init___C(42537)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.vaii$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("vaii", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (33554432 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.vaii$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.tamldec__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (1048576 & b.hi$2);
  if ((hi === 0)) {
    return this.tamldec$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.tamldec$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.vaii__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (33554432 & b.hi$2);
  if ((hi === 0)) {
    return this.vaii$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.vaii$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.brah__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (128 & b.lo$2);
  if ((lo === 0)) {
    return this.brah$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.brah$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mong$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6160), new $c_jl_Character().init___C(6161), new $c_jl_Character().init___C(6162), new $c_jl_Character().init___C(6163), new $c_jl_Character().init___C(6164), new $c_jl_Character().init___C(6165), new $c_jl_Character().init___C(6166), new $c_jl_Character().init___C(6167), new $c_jl_Character().init___C(6168), new $c_jl_Character().init___C(6169)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mong$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mong", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (2 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.mong$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.thai$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (4194304 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3664), new $c_jl_Character().init___C(3665), new $c_jl_Character().init___C(3666), new $c_jl_Character().init___C(3667), new $c_jl_Character().init___C(3668), new $c_jl_Character().init___C(3669), new $c_jl_Character().init___C(3670), new $c_jl_Character().init___C(3671), new $c_jl_Character().init___C(3672), new $c_jl_Character().init___C(3673)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.thai$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("thai", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (4194304 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.thai$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.telu__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2097152 & b.hi$2);
  if ((hi === 0)) {
    return this.telu$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.telu$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.takr$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (262144 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.takr$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("takr", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (262144 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.takr$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.lana$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (1048576 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6784), new $c_jl_Character().init___C(6785), new $c_jl_Character().init___C(6786), new $c_jl_Character().init___C(6787), new $c_jl_Character().init___C(6788), new $c_jl_Character().init___C(6789), new $c_jl_Character().init___C(6790), new $c_jl_Character().init___C(6791), new $c_jl_Character().init___C(6792), new $c_jl_Character().init___C(6793)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.lana$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("lana", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (1048576 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.lana$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.nkoo__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (256 & b.hi$2);
  if ((hi === 0)) {
    return this.nkoo$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.nkoo$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mymr__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (16 & b.hi$2);
  if ((hi === 0)) {
    return this.mymr$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mymr$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.cakm$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (256 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.cakm$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("cakm", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (256 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.cakm$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mlym__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = ((-2147483648) & b.lo$2);
  if ((lo === 0)) {
    return this.mlym$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mlym$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.bali$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6992), new $c_jl_Character().init___C(6993), new $c_jl_Character().init___C(6994), new $c_jl_Character().init___C(6995), new $c_jl_Character().init___C(6996), new $c_jl_Character().init___C(6997), new $c_jl_Character().init___C(6998), new $c_jl_Character().init___C(6999), new $c_jl_Character().init___C(7000), new $c_jl_Character().init___C(7001)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.bali$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("bali", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (16 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.bali$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.talu__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (524288 & b.hi$2);
  if ((hi === 0)) {
    return this.talu$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.talu$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.hanidec$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16384 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(12295), new $c_jl_Character().init___C(19968), new $c_jl_Character().init___C(20108), new $c_jl_Character().init___C(19977), new $c_jl_Character().init___C(22235), new $c_jl_Character().init___C(20116), new $c_jl_Character().init___C(20845), new $c_jl_Character().init___C(19971), new $c_jl_Character().init___C(20843), new $c_jl_Character().init___C(20061)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.hanidec$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("hanidec", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (16384 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.hanidec$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.hanidec__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (16384 & b.lo$2);
  if ((lo === 0)) {
    return this.hanidec$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.hanidec$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.arab__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (4 & b.lo$2);
  if ((lo === 0)) {
    return this.arab$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.arab$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.beng__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (32 & b.lo$2);
  if ((lo === 0)) {
    return this.beng$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.beng$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.shrd$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8192 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63), new $c_jl_Character().init___C(63)]);
    var this$42 = $m_sci_List$();
    var cbf = this$42.ReusableCBFInstance$2;
    this.shrd$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("shrd", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (8192 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.shrd$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.olck__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (512 & b.hi$2);
  if ((hi === 0)) {
    return this.olck$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.olck$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.tibt$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8388608 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(3872), new $c_jl_Character().init___C(3873), new $c_jl_Character().init___C(3874), new $c_jl_Character().init___C(3875), new $c_jl_Character().init___C(3876), new $c_jl_Character().init___C(3877), new $c_jl_Character().init___C(3878), new $c_jl_Character().init___C(3879), new $c_jl_Character().init___C(3880), new $c_jl_Character().init___C(3881)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.tibt$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("tibt", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (8388608 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.tibt$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.takr__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (262144 & b.hi$2);
  if ((hi === 0)) {
    return this.takr$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.takr$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.java$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (65536 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(43472), new $c_jl_Character().init___C(43473), new $c_jl_Character().init___C(43474), new $c_jl_Character().init___C(43475), new $c_jl_Character().init___C(43476), new $c_jl_Character().init___C(43477), new $c_jl_Character().init___C(43478), new $c_jl_Character().init___C(43479), new $c_jl_Character().init___C(43480), new $c_jl_Character().init___C(43481)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.java$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("java", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (65536 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.java$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.talu$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (524288 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6608), new $c_jl_Character().init___C(6609), new $c_jl_Character().init___C(6610), new $c_jl_Character().init___C(6611), new $c_jl_Character().init___C(6612), new $c_jl_Character().init___C(6613), new $c_jl_Character().init___C(6614), new $c_jl_Character().init___C(6615), new $c_jl_Character().init___C(6616), new $c_jl_Character().init___C(6617)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.talu$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("talu", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (524288 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.talu$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.deva$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (1024 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(2406), new $c_jl_Character().init___C(2407), new $c_jl_Character().init___C(2408), new $c_jl_Character().init___C(2409), new $c_jl_Character().init___C(2410), new $c_jl_Character().init___C(2411), new $c_jl_Character().init___C(2412), new $c_jl_Character().init___C(2413), new $c_jl_Character().init___C(2414), new $c_jl_Character().init___C(2415)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.deva$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("deva", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (1024 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.deva$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.latn__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (8388608 & b.lo$2);
  if ((lo === 0)) {
    return this.latn$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.latn$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.nkoo$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (256 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(1984), new $c_jl_Character().init___C(1985), new $c_jl_Character().init___C(1986), new $c_jl_Character().init___C(1987), new $c_jl_Character().init___C(1988), new $c_jl_Character().init___C(1989), new $c_jl_Character().init___C(1990), new $c_jl_Character().init___C(1991), new $c_jl_Character().init___C(1992), new $c_jl_Character().init___C(1993)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.nkoo$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("nkoo", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (256 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.nkoo$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mymrshan$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (32 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(4240), new $c_jl_Character().init___C(4241), new $c_jl_Character().init___C(4242), new $c_jl_Character().init___C(4243), new $c_jl_Character().init___C(4244), new $c_jl_Character().init___C(4245), new $c_jl_Character().init___C(4246), new $c_jl_Character().init___C(4247), new $c_jl_Character().init___C(4248), new $c_jl_Character().init___C(4249)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mymrshan$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mymrshan", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (32 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.mymrshan$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.mtei__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8 & b.hi$2);
  if ((hi === 0)) {
    return this.mtei$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mtei$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.kali__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (131072 & b.lo$2);
  if ((lo === 0)) {
    return this.kali$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.kali$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.khmr__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (262144 & b.lo$2);
  if ((lo === 0)) {
    return this.khmr$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.khmr$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mong__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (2 & b.hi$2);
  if ((hi === 0)) {
    return this.mong$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.mong$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.fullwide__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (2048 & b.lo$2);
  if ((lo === 0)) {
    return this.fullwide$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.fullwide$1
  }
});
$c_Llocales_cldr_data_numericsystems$.prototype.mtei$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (8 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(44016), new $c_jl_Character().init___C(44017), new $c_jl_Character().init___C(44018), new $c_jl_Character().init___C(44019), new $c_jl_Character().init___C(44020), new $c_jl_Character().init___C(44021), new $c_jl_Character().init___C(44022), new $c_jl_Character().init___C(44023), new $c_jl_Character().init___C(44024), new $c_jl_Character().init___C(44025)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.mtei$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("mtei", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (8 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.mtei$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.olck$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var hi = (512 & b.hi$2);
  if ((hi === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(7248), new $c_jl_Character().init___C(7249), new $c_jl_Character().init___C(7250), new $c_jl_Character().init___C(7251), new $c_jl_Character().init___C(7252), new $c_jl_Character().init___C(7253), new $c_jl_Character().init___C(7254), new $c_jl_Character().init___C(7255), new $c_jl_Character().init___C(7256), new $c_jl_Character().init___C(7257)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.olck$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("olck", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo = b$1.lo$2;
    var hi$1 = (512 | b$1.hi$2);
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo, hi$1)
  };
  return this.olck$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.limb$lzycompute__p1__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (33554432 & b.lo$2);
  if ((lo === 0)) {
    $m_sci_List$();
    var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_jl_Character().init___C(6470), new $c_jl_Character().init___C(6471), new $c_jl_Character().init___C(6472), new $c_jl_Character().init___C(6473), new $c_jl_Character().init___C(6474), new $c_jl_Character().init___C(6475), new $c_jl_Character().init___C(6476), new $c_jl_Character().init___C(6477), new $c_jl_Character().init___C(6478), new $c_jl_Character().init___C(6479)]);
    var this$22 = $m_sci_List$();
    var cbf = this$22.ReusableCBFInstance$2;
    this.limb$1 = new $c_Llocales_cldr_NumberingSystem().init___T__sc_Seq("limb", $as_sci_List($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(xs, cbf)));
    var b$1 = this.bitmap$0$1;
    var lo$1 = (33554432 | b$1.lo$2);
    var hi = b$1.hi$2;
    this.bitmap$0$1 = new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi)
  };
  return this.limb$1
});
$c_Llocales_cldr_data_numericsystems$.prototype.limb__Llocales_cldr_NumberingSystem = (function() {
  var b = this.bitmap$0$1;
  var lo = (33554432 & b.lo$2);
  if ((lo === 0)) {
    return this.limb$lzycompute__p1__Llocales_cldr_NumberingSystem()
  } else {
    return this.limb$1
  }
});
var $d_Llocales_cldr_data_numericsystems$ = new $TypeData().initClass({
  Llocales_cldr_data_numericsystems$: 0
}, false, "locales.cldr.data.numericsystems$", {
  Llocales_cldr_data_numericsystems$: 1,
  O: 1
});
$c_Llocales_cldr_data_numericsystems$.prototype.$classData = $d_Llocales_cldr_data_numericsystems$;
var $n_Llocales_cldr_data_numericsystems$ = (void 0);
function $m_Llocales_cldr_data_numericsystems$() {
  if ((!$n_Llocales_cldr_data_numericsystems$)) {
    $n_Llocales_cldr_data_numericsystems$ = new $c_Llocales_cldr_data_numericsystems$().init___()
  };
  return $n_Llocales_cldr_data_numericsystems$
}
/** @constructor */
function $c_Lorg_scalajs_dom_package$() {
  $c_O.call(this);
  this.ApplicationCache$1 = null;
  this.Blob$1 = null;
  this.BlobPropertyBag$1 = null;
  this.ClipboardEventInit$1 = null;
  this.DOMException$1 = null;
  this.Event$1 = null;
  this.EventException$1 = null;
  this.EventSource$1 = null;
  this.FileReader$1 = null;
  this.FormData$1 = null;
  this.KeyboardEvent$1 = null;
  this.MediaError$1 = null;
  this.MutationEvent$1 = null;
  this.MutationObserverInit$1 = null;
  this.Node$1 = null;
  this.NodeFilter$1 = null;
  this.PerformanceNavigation$1 = null;
  this.PositionError$1 = null;
  this.Range$1 = null;
  this.TextEvent$1 = null;
  this.TextTrack$1 = null;
  this.URL$1 = null;
  this.VisibilityState$1 = null;
  this.WebSocket$1 = null;
  this.WheelEvent$1 = null;
  this.XMLHttpRequest$1 = null;
  this.XPathResult$1 = null;
  this.window$1 = null;
  this.document$1 = null;
  this.console$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lorg_scalajs_dom_package$.prototype = new $h_O();
$c_Lorg_scalajs_dom_package$.prototype.constructor = $c_Lorg_scalajs_dom_package$;
/** @constructor */
function $h_Lorg_scalajs_dom_package$() {
  /*<skip>*/
}
$h_Lorg_scalajs_dom_package$.prototype = $c_Lorg_scalajs_dom_package$.prototype;
$c_Lorg_scalajs_dom_package$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_dom_package$.prototype.document__Lorg_scalajs_dom_raw_HTMLDocument = (function() {
  return (((268435456 & this.bitmap$0$1) === 0) ? this.document$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLDocument() : this.document$1)
});
$c_Lorg_scalajs_dom_package$.prototype.window__Lorg_scalajs_dom_raw_Window = (function() {
  return (((134217728 & this.bitmap$0$1) === 0) ? this.window$lzycompute__p1__Lorg_scalajs_dom_raw_Window() : this.window$1)
});
$c_Lorg_scalajs_dom_package$.prototype.window$lzycompute__p1__Lorg_scalajs_dom_raw_Window = (function() {
  if (((134217728 & this.bitmap$0$1) === 0)) {
    this.window$1 = $g.window;
    this.bitmap$0$1 = (134217728 | this.bitmap$0$1)
  };
  return this.window$1
});
$c_Lorg_scalajs_dom_package$.prototype.WebSocket__Lorg_scalajs_dom_raw_WebSocket$ = (function() {
  return (((8388608 & this.bitmap$0$1) === 0) ? this.WebSocket$lzycompute__p1__Lorg_scalajs_dom_raw_WebSocket$() : this.WebSocket$1)
});
$c_Lorg_scalajs_dom_package$.prototype.document$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLDocument = (function() {
  if (((268435456 & this.bitmap$0$1) === 0)) {
    this.document$1 = this.window__Lorg_scalajs_dom_raw_Window().document;
    this.bitmap$0$1 = (268435456 | this.bitmap$0$1)
  };
  return this.document$1
});
$c_Lorg_scalajs_dom_package$.prototype.WebSocket$lzycompute__p1__Lorg_scalajs_dom_raw_WebSocket$ = (function() {
  if (((8388608 & this.bitmap$0$1) === 0)) {
    this.WebSocket$1 = $g.WebSocket;
    this.bitmap$0$1 = (8388608 | this.bitmap$0$1)
  };
  return this.WebSocket$1
});
var $d_Lorg_scalajs_dom_package$ = new $TypeData().initClass({
  Lorg_scalajs_dom_package$: 0
}, false, "org.scalajs.dom.package$", {
  Lorg_scalajs_dom_package$: 1,
  O: 1
});
$c_Lorg_scalajs_dom_package$.prototype.$classData = $d_Lorg_scalajs_dom_package$;
var $n_Lorg_scalajs_dom_package$ = (void 0);
function $m_Lorg_scalajs_dom_package$() {
  if ((!$n_Lorg_scalajs_dom_package$)) {
    $n_Lorg_scalajs_dom_package$ = new $c_Lorg_scalajs_dom_package$().init___()
  };
  return $n_Lorg_scalajs_dom_package$
}
/** @constructor */
function $c_Lorg_scalajs_testcommon_ExecuteRequest() {
  $c_O.call(this);
  this.taskInfo$1 = null;
  this.loggerColorSupport$1 = null
}
$c_Lorg_scalajs_testcommon_ExecuteRequest.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_ExecuteRequest.prototype.constructor = $c_Lorg_scalajs_testcommon_ExecuteRequest;
/** @constructor */
function $h_Lorg_scalajs_testcommon_ExecuteRequest() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_ExecuteRequest.prototype = $c_Lorg_scalajs_testcommon_ExecuteRequest.prototype;
$c_Lorg_scalajs_testcommon_ExecuteRequest.prototype.init___Lorg_scalajs_testcommon_TaskInfo__sci_List = (function(taskInfo, loggerColorSupport) {
  this.taskInfo$1 = taskInfo;
  this.loggerColorSupport$1 = loggerColorSupport;
  return this
});
function $is_Lorg_scalajs_testcommon_ExecuteRequest(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_ExecuteRequest)))
}
function $as_Lorg_scalajs_testcommon_ExecuteRequest(obj) {
  return (($is_Lorg_scalajs_testcommon_ExecuteRequest(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.ExecuteRequest"))
}
function $isArrayOf_Lorg_scalajs_testcommon_ExecuteRequest(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_ExecuteRequest)))
}
function $asArrayOf_Lorg_scalajs_testcommon_ExecuteRequest(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_ExecuteRequest(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.ExecuteRequest;", depth))
}
var $d_Lorg_scalajs_testcommon_ExecuteRequest = new $TypeData().initClass({
  Lorg_scalajs_testcommon_ExecuteRequest: 0
}, false, "org.scalajs.testcommon.ExecuteRequest", {
  Lorg_scalajs_testcommon_ExecuteRequest: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_ExecuteRequest.prototype.$classData = $d_Lorg_scalajs_testcommon_ExecuteRequest;
/** @constructor */
function $c_Lorg_scalajs_testcommon_FrameworkInfo() {
  $c_O.call(this);
  this.implName$1 = null;
  this.displayName$1 = null;
  this.fingerprints$1 = null
}
$c_Lorg_scalajs_testcommon_FrameworkInfo.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_FrameworkInfo.prototype.constructor = $c_Lorg_scalajs_testcommon_FrameworkInfo;
/** @constructor */
function $h_Lorg_scalajs_testcommon_FrameworkInfo() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_FrameworkInfo.prototype = $c_Lorg_scalajs_testcommon_FrameworkInfo.prototype;
$c_Lorg_scalajs_testcommon_FrameworkInfo.prototype.init___T__T__sci_List = (function(implName, displayName, fingerprints) {
  this.implName$1 = implName;
  this.displayName$1 = displayName;
  this.fingerprints$1 = fingerprints;
  return this
});
function $is_Lorg_scalajs_testcommon_FrameworkInfo(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_FrameworkInfo)))
}
function $as_Lorg_scalajs_testcommon_FrameworkInfo(obj) {
  return (($is_Lorg_scalajs_testcommon_FrameworkInfo(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.FrameworkInfo"))
}
function $isArrayOf_Lorg_scalajs_testcommon_FrameworkInfo(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_FrameworkInfo)))
}
function $asArrayOf_Lorg_scalajs_testcommon_FrameworkInfo(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_FrameworkInfo(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.FrameworkInfo;", depth))
}
var $d_Lorg_scalajs_testcommon_FrameworkInfo = new $TypeData().initClass({
  Lorg_scalajs_testcommon_FrameworkInfo: 0
}, false, "org.scalajs.testcommon.FrameworkInfo", {
  Lorg_scalajs_testcommon_FrameworkInfo: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_FrameworkInfo.prototype.$classData = $d_Lorg_scalajs_testcommon_FrameworkInfo;
/** @constructor */
function $c_Lorg_scalajs_testcommon_FrameworkMessage() {
  $c_O.call(this);
  this.slaveId$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.msg$1 = null
}
$c_Lorg_scalajs_testcommon_FrameworkMessage.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_FrameworkMessage.prototype.constructor = $c_Lorg_scalajs_testcommon_FrameworkMessage;
/** @constructor */
function $h_Lorg_scalajs_testcommon_FrameworkMessage() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_FrameworkMessage.prototype = $c_Lorg_scalajs_testcommon_FrameworkMessage.prototype;
$c_Lorg_scalajs_testcommon_FrameworkMessage.prototype.init___J__T = (function(slaveId, msg) {
  this.slaveId$1 = slaveId;
  this.msg$1 = msg;
  return this
});
function $is_Lorg_scalajs_testcommon_FrameworkMessage(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_FrameworkMessage)))
}
function $as_Lorg_scalajs_testcommon_FrameworkMessage(obj) {
  return (($is_Lorg_scalajs_testcommon_FrameworkMessage(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.FrameworkMessage"))
}
function $isArrayOf_Lorg_scalajs_testcommon_FrameworkMessage(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_FrameworkMessage)))
}
function $asArrayOf_Lorg_scalajs_testcommon_FrameworkMessage(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_FrameworkMessage(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.FrameworkMessage;", depth))
}
var $d_Lorg_scalajs_testcommon_FrameworkMessage = new $TypeData().initClass({
  Lorg_scalajs_testcommon_FrameworkMessage: 0
}, false, "org.scalajs.testcommon.FrameworkMessage", {
  Lorg_scalajs_testcommon_FrameworkMessage: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_FrameworkMessage.prototype.$classData = $d_Lorg_scalajs_testcommon_FrameworkMessage;
/** @constructor */
function $c_Lorg_scalajs_testcommon_FutureUtil$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testcommon_FutureUtil$.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_FutureUtil$.prototype.constructor = $c_Lorg_scalajs_testcommon_FutureUtil$;
/** @constructor */
function $h_Lorg_scalajs_testcommon_FutureUtil$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_FutureUtil$.prototype = $c_Lorg_scalajs_testcommon_FutureUtil$.prototype;
$c_Lorg_scalajs_testcommon_FutureUtil$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testcommon_FutureUtil$.prototype.futureFromTry__s_util_Try__s_concurrent_Future = (function(x) {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  $s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise(promise, x);
  return promise
});
var $d_Lorg_scalajs_testcommon_FutureUtil$ = new $TypeData().initClass({
  Lorg_scalajs_testcommon_FutureUtil$: 0
}, false, "org.scalajs.testcommon.FutureUtil$", {
  Lorg_scalajs_testcommon_FutureUtil$: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_FutureUtil$.prototype.$classData = $d_Lorg_scalajs_testcommon_FutureUtil$;
var $n_Lorg_scalajs_testcommon_FutureUtil$ = (void 0);
function $m_Lorg_scalajs_testcommon_FutureUtil$() {
  if ((!$n_Lorg_scalajs_testcommon_FutureUtil$)) {
    $n_Lorg_scalajs_testcommon_FutureUtil$ = new $c_Lorg_scalajs_testcommon_FutureUtil$().init___()
  };
  return $n_Lorg_scalajs_testcommon_FutureUtil$
}
/** @constructor */
function $c_Lorg_scalajs_testcommon_JSEndpoints$() {
  $c_O.call(this);
  this.detectFrameworks$1 = null;
  this.createMasterRunner$1 = null;
  this.createSlaveRunner$1 = null;
  this.msgSlave$1 = null;
  this.msgMaster$1 = null;
  this.tasks$1 = null;
  this.execute$1 = null;
  this.done$1 = null
}
$c_Lorg_scalajs_testcommon_JSEndpoints$.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_JSEndpoints$.prototype.constructor = $c_Lorg_scalajs_testcommon_JSEndpoints$;
/** @constructor */
function $h_Lorg_scalajs_testcommon_JSEndpoints$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_JSEndpoints$.prototype = $c_Lorg_scalajs_testcommon_JSEndpoints$.prototype;
$c_Lorg_scalajs_testcommon_JSEndpoints$.prototype.init___ = (function() {
  $n_Lorg_scalajs_testcommon_JSEndpoints$ = this;
  var jsx$2 = $m_Lorg_scalajs_testcommon_RPCEndpoint$();
  var evidence$3 = $m_Lorg_scalajs_testcommon_Serializer$StringSerializer$();
  var evidence$3$1 = new $c_Lorg_scalajs_testcommon_Serializer$$anon$4().init___Lorg_scalajs_testcommon_Serializer(evidence$3);
  var jsx$1 = new $c_Lorg_scalajs_testcommon_Serializer$$anon$4().init___Lorg_scalajs_testcommon_Serializer(evidence$3$1);
  var evidence$4 = $m_Lorg_scalajs_testcommon_FrameworkInfo$FrameworkInfoSerializer$();
  var evidence$3$2 = new $c_Lorg_scalajs_testcommon_Serializer$$anon$5().init___Lorg_scalajs_testcommon_Serializer(evidence$4);
  this.detectFrameworks$1 = jsx$2.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_RPCEndpoint(2, jsx$1, new $c_Lorg_scalajs_testcommon_Serializer$$anon$4().init___Lorg_scalajs_testcommon_Serializer(evidence$3$2));
  this.createMasterRunner$1 = $m_Lorg_scalajs_testcommon_RPCEndpoint$().apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_RPCEndpoint(3, $m_Lorg_scalajs_testcommon_RunnerArgs$RunnerArgsSerializer$(), $m_Lorg_scalajs_testcommon_Serializer$UnitSerializer$());
  this.createSlaveRunner$1 = $m_Lorg_scalajs_testcommon_RPCEndpoint$().apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_RPCEndpoint(4, $m_Lorg_scalajs_testcommon_RunnerArgs$RunnerArgsSerializer$(), $m_Lorg_scalajs_testcommon_Serializer$UnitSerializer$());
  var jsx$3 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1 = $m_Lorg_scalajs_testcommon_Serializer$StringSerializer$();
  this.msgSlave$1 = jsx$3.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(5, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1));
  var jsx$4 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1$1 = $m_Lorg_scalajs_testcommon_FrameworkMessage$FrameworkMessageSerializer$();
  this.msgMaster$1 = jsx$4.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(6, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$1));
  var jsx$6 = $m_Lorg_scalajs_testcommon_RPCEndpoint$();
  var evidence$3$3 = $m_Lorg_scalajs_testcommon_Serializer$TaskDefSerializer$();
  var evidence$1$2 = new $c_Lorg_scalajs_testcommon_Serializer$$anon$4().init___Lorg_scalajs_testcommon_Serializer(evidence$3$3);
  var jsx$5 = new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$2);
  var evidence$3$4 = $m_Lorg_scalajs_testcommon_TaskInfo$TaskInfoSerializer$();
  this.tasks$1 = jsx$6.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_RPCEndpoint(7, jsx$5, new $c_Lorg_scalajs_testcommon_Serializer$$anon$4().init___Lorg_scalajs_testcommon_Serializer(evidence$3$4));
  var jsx$8 = $m_Lorg_scalajs_testcommon_RPCEndpoint$();
  var evidence$1$3 = $m_Lorg_scalajs_testcommon_ExecuteRequest$ExecuteRequestSerializer$();
  var jsx$7 = new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$3);
  var evidence$3$5 = $m_Lorg_scalajs_testcommon_TaskInfo$TaskInfoSerializer$();
  this.execute$1 = jsx$8.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_RPCEndpoint(8, jsx$7, new $c_Lorg_scalajs_testcommon_Serializer$$anon$4().init___Lorg_scalajs_testcommon_Serializer(evidence$3$5));
  var jsx$9 = $m_Lorg_scalajs_testcommon_RPCEndpoint$();
  var evidence$1$4 = $m_Lorg_scalajs_testcommon_Serializer$UnitSerializer$();
  this.done$1 = jsx$9.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_RPCEndpoint(9, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$4), $m_Lorg_scalajs_testcommon_Serializer$StringSerializer$());
  return this
});
var $d_Lorg_scalajs_testcommon_JSEndpoints$ = new $TypeData().initClass({
  Lorg_scalajs_testcommon_JSEndpoints$: 0
}, false, "org.scalajs.testcommon.JSEndpoints$", {
  Lorg_scalajs_testcommon_JSEndpoints$: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_JSEndpoints$.prototype.$classData = $d_Lorg_scalajs_testcommon_JSEndpoints$;
var $n_Lorg_scalajs_testcommon_JSEndpoints$ = (void 0);
function $m_Lorg_scalajs_testcommon_JSEndpoints$() {
  if ((!$n_Lorg_scalajs_testcommon_JSEndpoints$)) {
    $n_Lorg_scalajs_testcommon_JSEndpoints$ = new $c_Lorg_scalajs_testcommon_JSEndpoints$().init___()
  };
  return $n_Lorg_scalajs_testcommon_JSEndpoints$
}
/** @constructor */
function $c_Lorg_scalajs_testcommon_JVMEndpoints$() {
  $c_O.call(this);
  this.msgSlave$1 = null;
  this.msgMaster$1 = null;
  this.event$1 = null;
  this.logError$1 = null;
  this.logWarn$1 = null;
  this.logInfo$1 = null;
  this.logDebug$1 = null;
  this.logTrace$1 = null
}
$c_Lorg_scalajs_testcommon_JVMEndpoints$.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_JVMEndpoints$.prototype.constructor = $c_Lorg_scalajs_testcommon_JVMEndpoints$;
/** @constructor */
function $h_Lorg_scalajs_testcommon_JVMEndpoints$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_JVMEndpoints$.prototype = $c_Lorg_scalajs_testcommon_JVMEndpoints$.prototype;
$c_Lorg_scalajs_testcommon_JVMEndpoints$.prototype.init___ = (function() {
  $n_Lorg_scalajs_testcommon_JVMEndpoints$ = this;
  var jsx$1 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1 = $m_Lorg_scalajs_testcommon_Serializer$StringSerializer$();
  this.msgSlave$1 = jsx$1.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(2, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1));
  var jsx$2 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1$1 = $m_Lorg_scalajs_testcommon_FrameworkMessage$FrameworkMessageSerializer$();
  this.msgMaster$1 = jsx$2.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(3, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$1));
  var jsx$3 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1$2 = $m_Lorg_scalajs_testcommon_Serializer$EventSerializer$();
  this.event$1 = jsx$3.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(4, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$2));
  var jsx$4 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1$3 = $m_Lorg_scalajs_testcommon_Serializer$StringSerializer$();
  var evidence$1$4 = new $c_Lorg_scalajs_testcommon_LogElement$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$3);
  this.logError$1 = jsx$4.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(5, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$4));
  var jsx$5 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1$5 = $m_Lorg_scalajs_testcommon_Serializer$StringSerializer$();
  var evidence$1$6 = new $c_Lorg_scalajs_testcommon_LogElement$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$5);
  this.logWarn$1 = jsx$5.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(6, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$6));
  var jsx$6 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1$7 = $m_Lorg_scalajs_testcommon_Serializer$StringSerializer$();
  var evidence$1$8 = new $c_Lorg_scalajs_testcommon_LogElement$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$7);
  this.logInfo$1 = jsx$6.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(7, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$8));
  var jsx$7 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1$9 = $m_Lorg_scalajs_testcommon_Serializer$StringSerializer$();
  var evidence$1$10 = new $c_Lorg_scalajs_testcommon_LogElement$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$9);
  this.logDebug$1 = jsx$7.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(8, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$10));
  var jsx$8 = $m_Lorg_scalajs_testcommon_MsgEndpoint$();
  var evidence$1$11 = $m_Lorg_scalajs_testcommon_Serializer$ThrowableSerializer$();
  var evidence$1$12 = new $c_Lorg_scalajs_testcommon_LogElement$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$11);
  this.logTrace$1 = jsx$8.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint(9, new $c_Lorg_scalajs_testcommon_RunMux$$anon$1().init___Lorg_scalajs_testcommon_Serializer(evidence$1$12));
  return this
});
var $d_Lorg_scalajs_testcommon_JVMEndpoints$ = new $TypeData().initClass({
  Lorg_scalajs_testcommon_JVMEndpoints$: 0
}, false, "org.scalajs.testcommon.JVMEndpoints$", {
  Lorg_scalajs_testcommon_JVMEndpoints$: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_JVMEndpoints$.prototype.$classData = $d_Lorg_scalajs_testcommon_JVMEndpoints$;
var $n_Lorg_scalajs_testcommon_JVMEndpoints$ = (void 0);
function $m_Lorg_scalajs_testcommon_JVMEndpoints$() {
  if ((!$n_Lorg_scalajs_testcommon_JVMEndpoints$)) {
    $n_Lorg_scalajs_testcommon_JVMEndpoints$ = new $c_Lorg_scalajs_testcommon_JVMEndpoints$().init___()
  };
  return $n_Lorg_scalajs_testcommon_JVMEndpoints$
}
/** @constructor */
function $c_Lorg_scalajs_testcommon_LogElement() {
  $c_O.call(this);
  this.index$1 = 0;
  this.x$1 = null
}
$c_Lorg_scalajs_testcommon_LogElement.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_LogElement.prototype.constructor = $c_Lorg_scalajs_testcommon_LogElement;
/** @constructor */
function $h_Lorg_scalajs_testcommon_LogElement() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_LogElement.prototype = $c_Lorg_scalajs_testcommon_LogElement.prototype;
$c_Lorg_scalajs_testcommon_LogElement.prototype.init___I__O = (function(index, x) {
  this.index$1 = index;
  this.x$1 = x;
  return this
});
function $is_Lorg_scalajs_testcommon_LogElement(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_LogElement)))
}
function $as_Lorg_scalajs_testcommon_LogElement(obj) {
  return (($is_Lorg_scalajs_testcommon_LogElement(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.LogElement"))
}
function $isArrayOf_Lorg_scalajs_testcommon_LogElement(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_LogElement)))
}
function $asArrayOf_Lorg_scalajs_testcommon_LogElement(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_LogElement(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.LogElement;", depth))
}
var $d_Lorg_scalajs_testcommon_LogElement = new $TypeData().initClass({
  Lorg_scalajs_testcommon_LogElement: 0
}, false, "org.scalajs.testcommon.LogElement", {
  Lorg_scalajs_testcommon_LogElement: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_LogElement.prototype.$classData = $d_Lorg_scalajs_testcommon_LogElement;
/** @constructor */
function $c_Lorg_scalajs_testcommon_MsgEndpoint$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testcommon_MsgEndpoint$.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_MsgEndpoint$.prototype.constructor = $c_Lorg_scalajs_testcommon_MsgEndpoint$;
/** @constructor */
function $h_Lorg_scalajs_testcommon_MsgEndpoint$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_MsgEndpoint$.prototype = $c_Lorg_scalajs_testcommon_MsgEndpoint$.prototype;
$c_Lorg_scalajs_testcommon_MsgEndpoint$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testcommon_MsgEndpoint$.prototype.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_MsgEndpoint = (function(opc, ms) {
  var requirement = (!$m_Lorg_scalajs_testcommon_RPCCore$().isReservedOpCode__B__Z(opc));
  if ((!requirement)) {
    var array = ["Reserved op code: ", ""];
    var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var array$1 = [opc];
    throw new $c_jl_IllegalArgumentException().init___T(("requirement failed: " + jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))))
  };
  return new $c_Lorg_scalajs_testcommon_MsgEndpoint$$anon$1().init___B__Lorg_scalajs_testcommon_Serializer(opc, ms)
});
var $d_Lorg_scalajs_testcommon_MsgEndpoint$ = new $TypeData().initClass({
  Lorg_scalajs_testcommon_MsgEndpoint$: 0
}, false, "org.scalajs.testcommon.MsgEndpoint$", {
  Lorg_scalajs_testcommon_MsgEndpoint$: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_MsgEndpoint$.prototype.$classData = $d_Lorg_scalajs_testcommon_MsgEndpoint$;
var $n_Lorg_scalajs_testcommon_MsgEndpoint$ = (void 0);
function $m_Lorg_scalajs_testcommon_MsgEndpoint$() {
  if ((!$n_Lorg_scalajs_testcommon_MsgEndpoint$)) {
    $n_Lorg_scalajs_testcommon_MsgEndpoint$ = new $c_Lorg_scalajs_testcommon_MsgEndpoint$().init___()
  };
  return $n_Lorg_scalajs_testcommon_MsgEndpoint$
}
/** @constructor */
function $c_Lorg_scalajs_testcommon_RPCCore() {
  $c_O.call(this);
  this.ex$1 = null;
  this.org$scalajs$testcommon$RPCCore$$pending$f = null;
  this.closeReason$1 = null;
  this.nextID$1 = null;
  this.endpoints$1 = null
}
$c_Lorg_scalajs_testcommon_RPCCore.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_RPCCore.prototype.constructor = $c_Lorg_scalajs_testcommon_RPCCore;
/** @constructor */
function $h_Lorg_scalajs_testcommon_RPCCore() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_RPCCore.prototype = $c_Lorg_scalajs_testcommon_RPCCore.prototype;
$c_Lorg_scalajs_testcommon_RPCCore.prototype.attach__Lorg_scalajs_testcommon_MsgEndpoint__F1__V = (function(ep, ex) {
  this.attach__p1__Lorg_scalajs_testcommon_RPCCore$BoundEndpoint__V(new $c_Lorg_scalajs_testcommon_RPCCore$$anon$1().init___Lorg_scalajs_testcommon_RPCCore__Lorg_scalajs_testcommon_MsgEndpoint__F1(this, ep, ex))
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.send__Lorg_scalajs_testcommon_MsgEndpoint__O__V = (function(ep, msg) {
  this.send__T__V(this.makeMsgMsg__p1__B__O__Lorg_scalajs_testcommon_Serializer__T(ep.opCode$1, msg, ep.msgSerializer$1))
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.handleMessage__T__V = (function(msg) {
  var this$5 = new $c_sci_StringOps().init___T(msg);
  var jsx$1 = $m_sjsr_RuntimeString$();
  var $$this = this$5.repr$1;
  var xs = jsx$1.toCharArray__T__AC($$this);
  var elems$2 = null;
  elems$2 = [];
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var idx = i;
    var c = xs.get(idx);
    var elem = ((c << 24) >> 24);
    elems$2.push(elem);
    i = ((1 + i) | 0)
  };
  var bytes = $makeNativeArrayWrapper($d_B.getArrayOf(), elems$2);
  var $in = new $c_Ljava_io_DataInputStream().init___Ljava_io_InputStream(new $c_Ljava_io_ByteArrayInputStream().init___AB(bytes));
  try {
    var opCode = $in.readByte__B();
    if (($m_Lorg_scalajs_testcommon_RPCCore$().org$scalajs$testcommon$RPCCore$$ReplyOK$1 === opCode)) {
      var this$19 = this.getPending$1__p1__Ljava_io_DataInputStream__s_Option($in);
      if ((!this$19.isEmpty__Z())) {
        var arg1 = this$19.get__O();
        var p = $as_Lorg_scalajs_testcommon_RPCCore$PendingCall(arg1);
        var this$22 = p.promise__s_concurrent_Promise();
        try {
          var s = p.serializer__Lorg_scalajs_testcommon_Serializer();
          var result = new $c_s_util_Success().init___O(s.deserialize__Ljava_io_DataInputStream__O($in))
        } catch (e) {
          var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
          if ((e$2 !== null)) {
            matchEnd8: {
              var result;
              var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
              if ((!o11.isEmpty__Z())) {
                var e$3 = $as_jl_Throwable(o11.get__O());
                var result = new $c_s_util_Failure().init___jl_Throwable(e$3);
                break matchEnd8
              };
              throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
            }
          } else {
            var result;
            throw e
          }
        };
        $s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise(this$22, result)
      }
    } else if (($m_Lorg_scalajs_testcommon_RPCCore$().org$scalajs$testcommon$RPCCore$$ReplyErr$1 === opCode)) {
      var this$23 = this.getPending$1__p1__Ljava_io_DataInputStream__s_Option($in);
      if ((!this$23.isEmpty__Z())) {
        var arg1$1 = this$23.get__O();
        var p$3 = $as_Lorg_scalajs_testcommon_RPCCore$PendingCall(arg1$1);
        try {
          var s$1 = $m_Lorg_scalajs_testcommon_Serializer$ThrowableSerializer$();
          var x1 = new $c_s_util_Success().init___O(s$1.deserialize__Ljava_io_DataInputStream__jl_Throwable($in))
        } catch (e$1) {
          var e$2$1 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e$1);
          if ((e$2$1 !== null)) {
            matchEnd8$1: {
              var x1;
              var o11$1 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2$1);
              if ((!o11$1.isEmpty__Z())) {
                var e$3$1 = $as_jl_Throwable(o11$1.get__O());
                var x1 = new $c_s_util_Failure().init___jl_Throwable(e$3$1);
                break matchEnd8$1
              };
              throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2$1)
            }
          } else {
            var x1;
            throw e$1
          }
        };
        if ($is_s_util_Success(x1)) {
          var x2 = $as_s_util_Success(x1);
          var t$1 = $as_jl_Throwable(x2.value$2);
          var throwable = new $c_Lorg_scalajs_testcommon_RPCCore$RPCException().init___jl_Throwable(t$1)
        } else {
          if ((!$is_s_util_Failure(x1))) {
            throw new $c_s_MatchError().init___O(x1)
          };
          var x3 = $as_s_util_Failure(x1);
          var t$2 = x3.exception$2;
          var throwable = t$2
        };
        var this$26 = p$3.promise__s_concurrent_Promise();
        $s_s_concurrent_Promise$class__failure__s_concurrent_Promise__jl_Throwable__s_concurrent_Promise(this$26, throwable)
      }
    } else {
      var x1$2 = $as_Lorg_scalajs_testcommon_RPCCore$BoundEndpoint(this.endpoints$1.get__O__O(opCode));
      if ((x1$2 === null)) {
        var array = ["Unknown opcode: ", ""];
        var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
        var array$1 = [opCode];
        throw new $c_jl_IllegalStateException().init___T(jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1)))
      };
      if ($is_Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint(x1$2)) {
        var x3$1 = $as_Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint(x1$2);
        var ep = x3$1.endpoint$1;
        var jsx$3 = x3$1.exec$1;
        var s$2 = ep.msgSerializer$1;
        $asUnit(jsx$3.apply__O__O(s$2.deserialize__Ljava_io_DataInputStream__O($in)))
      } else {
        if ((!$is_Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint(x1$2))) {
          throw new $c_s_MatchError().init___O(x1$2)
        };
        var x4 = $as_Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint(x1$2);
        var t$3 = $in.readLong__J();
        var lo = t$3.lo$2;
        var hi = t$3.hi$2;
        var ep$2 = x4.endpoint$1;
        var jsx$5 = $m_Lorg_scalajs_testcommon_FutureUtil$();
        try {
          var s$3 = ep$2.reqSerializer$1;
          var jsx$4 = new $c_s_util_Success().init___O(s$3.deserialize__Ljava_io_DataInputStream__O($in))
        } catch (e$4) {
          var e$2$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e$4);
          if ((e$2$2 !== null)) {
            matchEnd8$2: {
              var jsx$4;
              var o11$2 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2$2);
              if ((!o11$2.isEmpty__Z())) {
                var e$3$2 = $as_jl_Throwable(o11$2.get__O());
                var jsx$4 = new $c_s_util_Failure().init___jl_Throwable(e$3$2);
                break matchEnd8$2
              };
              throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2$2)
            }
          } else {
            var jsx$4;
            throw e$4
          }
        };
        var this$34 = jsx$5.futureFromTry__s_util_Try__s_concurrent_Future(jsx$4);
        var f = x4.exec$1;
        var executor = this.ex$1;
        $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$34, f, executor).onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1, callID, ep$2$1) {
          return (function(repl$2) {
            var repl = $as_s_util_Try(repl$2);
            this$4$1.send__T__V(this$4$1.makeReply__p1__J__s_util_Try__Lorg_scalajs_testcommon_Serializer__T(callID, repl, ep$2$1.respSerializer$1))
          })
        })(this, new $c_sjsr_RuntimeLong().init___I__I(lo, hi), ep$2)), this.ex$1)
      }
    }
  } finally {
    $in.in$2.close__V()
  }
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.attach__Lorg_scalajs_testcommon_RPCEndpoint__F1__V = (function(ep, ex) {
  this.attachAsync__Lorg_scalajs_testcommon_RPCEndpoint__F1__V(ep, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, ex$2) {
    return (function(x$2) {
      var jsx$2 = $m_Lorg_scalajs_testcommon_FutureUtil$();
      try {
        var jsx$1 = new $c_s_util_Success().init___O(ex$2.apply__O__O(x$2))
      } catch (e) {
        var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
        if ((e$2 !== null)) {
          matchEnd8: {
            var jsx$1;
            var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
            if ((!o11.isEmpty__Z())) {
              var e$3 = $as_jl_Throwable(o11.get__O());
              var jsx$1 = new $c_s_util_Failure().init___jl_Throwable(e$3);
              break matchEnd8
            };
            throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
          }
        } else {
          var jsx$1;
          throw e
        }
      };
      return jsx$2.futureFromTry__s_util_Try__s_concurrent_Future(jsx$1)
    })
  })(this, ex)))
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.makeMsgMsg__p1__B__O__Lorg_scalajs_testcommon_Serializer__T = (function(opCode, payload, evidence$3) {
  var byteOut = new $c_Ljava_io_ByteArrayOutputStream().init___();
  var dataOut = new $c_Ljava_io_DataOutputStream().init___Ljava_io_OutputStream(byteOut);
  try {
    dataOut.write__I__V(opCode);
    evidence$3.serialize__O__Ljava_io_DataOutputStream__V(payload, dataOut)
  } finally {
    dataOut.out$2.close__V()
  };
  var this$15 = $m_sjsr_RuntimeString$();
  var xs = byteOut.toByteArray__AB();
  var elems$2 = null;
  elems$2 = [];
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var idx = i;
    var arg1 = xs.get(idx);
    var b = $uB(arg1);
    var c = (255 & b);
    elems$2.push(c);
    i = ((1 + i) | 0)
  };
  var value = $makeNativeArrayWrapper($d_C.getArrayOf(), elems$2);
  return this$15.newString__AC__I__I__T(value, 0, value.u.length)
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.attach__p1__Lorg_scalajs_testcommon_RPCCore$BoundEndpoint__V = (function(bep) {
  var opCode = bep.endpoint__Lorg_scalajs_testcommon_Endpoint().opCode__B();
  var old = $as_Lorg_scalajs_testcommon_RPCCore$BoundEndpoint(this.endpoints$1.put__O__O__O(opCode, bep));
  var requirement = (old === null);
  if ((!requirement)) {
    var array = ["Duplicate endpoint for opcode ", "."];
    var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var array$1 = [opCode];
    throw new $c_jl_IllegalArgumentException().init___T(("requirement failed: " + jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))))
  }
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.attachAsync__Lorg_scalajs_testcommon_RPCEndpoint__F1__V = (function(ep, ex) {
  this.attach__p1__Lorg_scalajs_testcommon_RPCCore$BoundEndpoint__V(new $c_Lorg_scalajs_testcommon_RPCCore$$anon$2().init___Lorg_scalajs_testcommon_RPCCore__Lorg_scalajs_testcommon_RPCEndpoint__F1(this, ep, ex))
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.makeReply__p1__J__s_util_Try__Lorg_scalajs_testcommon_Serializer__T = (function(id, result, evidence$1) {
  var x1 = result.map__F1__s_util_Try(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, id$1, evidence$1$1) {
    return (function(x$1$2) {
      return $this.makeRPCMsg__p1__B__J__O__Lorg_scalajs_testcommon_Serializer__T($m_Lorg_scalajs_testcommon_RPCCore$().org$scalajs$testcommon$RPCCore$$ReplyOK$1, id$1, x$1$2, evidence$1$1)
    })
  })(this, id, evidence$1)));
  if ($is_s_util_Success(x1)) {
    var x2 = $as_s_util_Success(x1);
    var m = $as_T(x2.value$2);
    return m
  } else if ($is_s_util_Failure(x1)) {
    var x3 = $as_s_util_Failure(x1);
    var t = x3.exception$2;
    return this.makeRPCMsg__p1__B__J__O__Lorg_scalajs_testcommon_Serializer__T($m_Lorg_scalajs_testcommon_RPCCore$().org$scalajs$testcommon$RPCCore$$ReplyErr$1, id, t, $m_Lorg_scalajs_testcommon_Serializer$ThrowableSerializer$())
  } else {
    throw new $c_s_MatchError().init___O(x1)
  }
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.getPending$1__p1__Ljava_io_DataInputStream__s_Option = (function(in$1) {
  var t = in$1.readLong__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  return $m_s_Option$().apply__O__s_Option(this.org$scalajs$testcommon$RPCCore$$pending$f.remove__O__O(new $c_sjsr_RuntimeLong().init___I__I(lo, hi)))
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.init___s_concurrent_ExecutionContext = (function(ex) {
  this.ex$1 = ex;
  this.org$scalajs$testcommon$RPCCore$$pending$f = new $c_ju_concurrent_ConcurrentHashMap().init___();
  this.nextID$1 = new $c_ju_concurrent_atomic_AtomicLong().init___J($m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong());
  this.endpoints$1 = new $c_ju_concurrent_ConcurrentHashMap().init___();
  return this
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.makeRPCMsg__p1__B__J__O__Lorg_scalajs_testcommon_Serializer__T = (function(opCode, id, payload, evidence$2) {
  var byteOut = new $c_Ljava_io_ByteArrayOutputStream().init___();
  var dataOut = new $c_Ljava_io_DataOutputStream().init___Ljava_io_OutputStream(byteOut);
  try {
    dataOut.write__I__V(opCode);
    var lo = id.hi$2;
    dataOut.writeInt__I__V(lo);
    dataOut.writeInt__I__V(id.lo$2);
    evidence$2.serialize__O__Ljava_io_DataOutputStream__V(payload, dataOut)
  } finally {
    dataOut.out$2.close__V()
  };
  var this$15 = $m_sjsr_RuntimeString$();
  var xs = byteOut.toByteArray__AB();
  var elems$2 = null;
  elems$2 = [];
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var idx = i;
    var arg1 = xs.get(idx);
    var b = $uB(arg1);
    var c = (255 & b);
    elems$2.push(c);
    i = ((1 + i) | 0)
  };
  var value = $makeNativeArrayWrapper($d_C.getArrayOf(), elems$2);
  return this$15.newString__AC__I__I__T(value, 0, value.u.length)
});
$c_Lorg_scalajs_testcommon_RPCCore.prototype.detach__Lorg_scalajs_testcommon_Endpoint__V = (function(ep) {
  var old = $as_Lorg_scalajs_testcommon_RPCCore$BoundEndpoint(this.endpoints$1.remove__O__O(ep.opCode__B()));
  var requirement = (old !== null);
  if ((!requirement)) {
    throw new $c_jl_IllegalArgumentException().init___T("requirement failed: Endpoint was not attached.")
  }
});
/** @constructor */
function $c_Lorg_scalajs_testcommon_RPCCore$() {
  $c_O.call(this);
  this.org$scalajs$testcommon$RPCCore$$ReplyOK$1 = 0;
  this.org$scalajs$testcommon$RPCCore$$ReplyErr$1 = 0
}
$c_Lorg_scalajs_testcommon_RPCCore$.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_RPCCore$.prototype.constructor = $c_Lorg_scalajs_testcommon_RPCCore$;
/** @constructor */
function $h_Lorg_scalajs_testcommon_RPCCore$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_RPCCore$.prototype = $c_Lorg_scalajs_testcommon_RPCCore$.prototype;
$c_Lorg_scalajs_testcommon_RPCCore$.prototype.init___ = (function() {
  this.org$scalajs$testcommon$RPCCore$$ReplyOK$1 = 0;
  this.org$scalajs$testcommon$RPCCore$$ReplyErr$1 = 1;
  return this
});
$c_Lorg_scalajs_testcommon_RPCCore$.prototype.isReservedOpCode__B__Z = (function(opc) {
  return ((opc === this.org$scalajs$testcommon$RPCCore$$ReplyOK$1) || (opc === this.org$scalajs$testcommon$RPCCore$$ReplyErr$1))
});
var $d_Lorg_scalajs_testcommon_RPCCore$ = new $TypeData().initClass({
  Lorg_scalajs_testcommon_RPCCore$: 0
}, false, "org.scalajs.testcommon.RPCCore$", {
  Lorg_scalajs_testcommon_RPCCore$: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_RPCCore$.prototype.$classData = $d_Lorg_scalajs_testcommon_RPCCore$;
var $n_Lorg_scalajs_testcommon_RPCCore$ = (void 0);
function $m_Lorg_scalajs_testcommon_RPCCore$() {
  if ((!$n_Lorg_scalajs_testcommon_RPCCore$)) {
    $n_Lorg_scalajs_testcommon_RPCCore$ = new $c_Lorg_scalajs_testcommon_RPCCore$().init___()
  };
  return $n_Lorg_scalajs_testcommon_RPCCore$
}
function $is_Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint)))
}
function $as_Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint(obj) {
  return (($is_Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.RPCCore$BoundMsgEndpoint"))
}
function $isArrayOf_Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint)))
}
function $asArrayOf_Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_RPCCore$BoundMsgEndpoint(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.RPCCore$BoundMsgEndpoint;", depth))
}
function $is_Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint)))
}
function $as_Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint(obj) {
  return (($is_Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.RPCCore$BoundRPCEndpoint"))
}
function $isArrayOf_Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint)))
}
function $asArrayOf_Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_RPCCore$BoundRPCEndpoint(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.RPCCore$BoundRPCEndpoint;", depth))
}
/** @constructor */
function $c_Lorg_scalajs_testcommon_RPCEndpoint$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testcommon_RPCEndpoint$.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_RPCEndpoint$.prototype.constructor = $c_Lorg_scalajs_testcommon_RPCEndpoint$;
/** @constructor */
function $h_Lorg_scalajs_testcommon_RPCEndpoint$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_RPCEndpoint$.prototype = $c_Lorg_scalajs_testcommon_RPCEndpoint$.prototype;
$c_Lorg_scalajs_testcommon_RPCEndpoint$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testcommon_RPCEndpoint$.prototype.apply__B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_RPCEndpoint = (function(opc, rqs, rps) {
  var requirement = (!$m_Lorg_scalajs_testcommon_RPCCore$().isReservedOpCode__B__Z(opc));
  if ((!requirement)) {
    var array = ["Reserved op code: ", ""];
    var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var array$1 = [opc];
    throw new $c_jl_IllegalArgumentException().init___T(("requirement failed: " + jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))))
  };
  return new $c_Lorg_scalajs_testcommon_RPCEndpoint$$anon$2().init___B__Lorg_scalajs_testcommon_Serializer__Lorg_scalajs_testcommon_Serializer(opc, rqs, rps)
});
var $d_Lorg_scalajs_testcommon_RPCEndpoint$ = new $TypeData().initClass({
  Lorg_scalajs_testcommon_RPCEndpoint$: 0
}, false, "org.scalajs.testcommon.RPCEndpoint$", {
  Lorg_scalajs_testcommon_RPCEndpoint$: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_RPCEndpoint$.prototype.$classData = $d_Lorg_scalajs_testcommon_RPCEndpoint$;
var $n_Lorg_scalajs_testcommon_RPCEndpoint$ = (void 0);
function $m_Lorg_scalajs_testcommon_RPCEndpoint$() {
  if ((!$n_Lorg_scalajs_testcommon_RPCEndpoint$)) {
    $n_Lorg_scalajs_testcommon_RPCEndpoint$ = new $c_Lorg_scalajs_testcommon_RPCEndpoint$().init___()
  };
  return $n_Lorg_scalajs_testcommon_RPCEndpoint$
}
/** @constructor */
function $c_Lorg_scalajs_testcommon_RunMux() {
  $c_O.call(this);
  this.runId$1 = 0;
  this.value$1 = null
}
$c_Lorg_scalajs_testcommon_RunMux.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_RunMux.prototype.constructor = $c_Lorg_scalajs_testcommon_RunMux;
/** @constructor */
function $h_Lorg_scalajs_testcommon_RunMux() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_RunMux.prototype = $c_Lorg_scalajs_testcommon_RunMux.prototype;
$c_Lorg_scalajs_testcommon_RunMux.prototype.init___I__O = (function(runId, value) {
  this.runId$1 = runId;
  this.value$1 = value;
  return this
});
function $is_Lorg_scalajs_testcommon_RunMux(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_RunMux)))
}
function $as_Lorg_scalajs_testcommon_RunMux(obj) {
  return (($is_Lorg_scalajs_testcommon_RunMux(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.RunMux"))
}
function $isArrayOf_Lorg_scalajs_testcommon_RunMux(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_RunMux)))
}
function $asArrayOf_Lorg_scalajs_testcommon_RunMux(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_RunMux(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.RunMux;", depth))
}
var $d_Lorg_scalajs_testcommon_RunMux = new $TypeData().initClass({
  Lorg_scalajs_testcommon_RunMux: 0
}, false, "org.scalajs.testcommon.RunMux", {
  Lorg_scalajs_testcommon_RunMux: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_RunMux.prototype.$classData = $d_Lorg_scalajs_testcommon_RunMux;
/** @constructor */
function $c_Lorg_scalajs_testcommon_RunMuxRPC() {
  $c_O.call(this);
  this.rpc$1 = null;
  this.mux$1 = null
}
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.constructor = $c_Lorg_scalajs_testcommon_RunMuxRPC;
/** @constructor */
function $h_Lorg_scalajs_testcommon_RunMuxRPC() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_RunMuxRPC.prototype = $c_Lorg_scalajs_testcommon_RunMuxRPC.prototype;
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.init___Lorg_scalajs_testcommon_RPCCore = (function(rpc) {
  this.rpc$1 = rpc;
  this.mux$1 = new $c_scm_HashMap().init___();
  return this
});
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.newDispatchMap$1__p1__F1__ju_concurrent_ConcurrentHashMap = (function(attach$1) {
  var dispatch = new $c_ju_concurrent_ConcurrentHashMap().init___();
  attach$1.apply__O__O(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, dispatch$1) {
    return (function(r$2) {
      var r = $as_Lorg_scalajs_testcommon_RunMux(r$2);
      var this$1 = $m_s_Option$().apply__O__s_Option(dispatch$1.get__O__O(r.runId$1));
      if (this$1.isEmpty__Z()) {
        var array = ["Unknown run ", ""];
        var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
        var array$1 = [r.runId$1];
        throw new $c_jl_IllegalArgumentException().init___T(jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1)))
      } else {
        var arg1 = this$1.get__O();
        var f = $as_F1(arg1);
        return f.apply__O__O(r.value$1)
      }
    })
  })(this, dispatch)));
  return dispatch
});
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.attachMux__p1__B__I__F1__F1__V = (function(opCode, runId, ex, attach) {
  var dispatch = $as_ju_concurrent_ConcurrentHashMap(this.mux$1.getOrElseUpdate__O__F0__O(opCode, new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, attach$1) {
    return (function() {
      return $this.newDispatchMap$1__p1__F1__ju_concurrent_ConcurrentHashMap(attach$1)
    })
  })(this, attach))));
  var old = $as_F1(dispatch.put__O__O__O(runId, ex));
  var requirement = (old === null);
  if ((!requirement)) {
    var array = ["Duplicate endpoint for opcode ", " run ", ""];
    var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
    var array$1 = [opCode, runId];
    throw new $c_jl_IllegalArgumentException().init___T(("requirement failed: " + jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1))))
  }
});
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.send__Lorg_scalajs_testcommon_MsgEndpoint__I__O__V = (function(ep, runId, msg) {
  this.rpc$1.send__Lorg_scalajs_testcommon_MsgEndpoint__O__V(ep, new $c_Lorg_scalajs_testcommon_RunMux().init___I__O(runId, msg))
});
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.attach__Lorg_scalajs_testcommon_MsgEndpoint__I__F1__V = (function(ep, runId, ex) {
  this.attachMux__p1__B__I__F1__F1__V(ep.opCode$1, runId, ex, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, ep$1) {
    return (function(ex$2$2) {
      var ex$2 = $as_F1(ex$2$2);
      $this.rpc$1.attach__Lorg_scalajs_testcommon_MsgEndpoint__F1__V(ep$1, ex$2)
    })
  })(this, ep)))
});
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.detach__Lorg_scalajs_testcommon_Endpoint__I__V = (function(ep, runId) {
  var opCode = ep.opCode__B();
  var this$1 = this.mux$1;
  var x1 = this$1.get__O__s_Option(opCode);
  if ((!$is_s_Some(x1))) {
    var x = $m_s_None$();
    if ((x === x1)) {
      var array = ["No endpoint attached for opCode ", ""];
      var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
      var array$1 = [opCode];
      throw new $c_jl_IllegalArgumentException().init___T(jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1)))
    };
    throw new $c_s_MatchError().init___O(x1)
  };
  var x2 = $as_s_Some(x1);
  var v = x2.x$2;
  var dispatch = $as_ju_concurrent_ConcurrentHashMap(v);
  var old = dispatch.remove__O__O(runId);
  var requirement = (old !== null);
  if ((!requirement)) {
    var array$2 = ["No endpoint attached for opCode ", " run ", ""];
    var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$2));
    var array$3 = [opCode, runId];
    throw new $c_jl_IllegalArgumentException().init___T(("requirement failed: " + jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$3))))
  };
  var this$11 = dispatch.java$util$concurrent$ConcurrentHashMap$$inner$2;
  if ($s_sc_MapLike$class__isEmpty__sc_MapLike__Z(this$11)) {
    this.rpc$1.detach__Lorg_scalajs_testcommon_Endpoint__V(ep);
    this.mux$1.$$minus$eq__O__scm_MapLike(opCode)
  }
});
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.attachAsync__Lorg_scalajs_testcommon_RPCEndpoint__I__F1__V = (function(ep, runId, ex) {
  this.attachMux__p1__B__I__F1__F1__V(ep.opCode$1, runId, ex, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, ep$2) {
    return (function(ex$3$2) {
      var ex$3 = $as_F1(ex$3$2);
      $this.rpc$1.attachAsync__Lorg_scalajs_testcommon_RPCEndpoint__F1__V(ep$2, ex$3)
    })
  })(this, ep)))
});
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.attach__Lorg_scalajs_testcommon_RPCEndpoint__I__F1__V = (function(ep, runId, ex) {
  this.attachAsync__Lorg_scalajs_testcommon_RPCEndpoint__I__F1__V(ep, runId, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, ex$1) {
    return (function(x$2) {
      var jsx$2 = $m_Lorg_scalajs_testcommon_FutureUtil$();
      try {
        var jsx$1 = new $c_s_util_Success().init___O(ex$1.apply__O__O(x$2))
      } catch (e) {
        var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
        if ((e$2 !== null)) {
          matchEnd8: {
            var jsx$1;
            var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
            if ((!o11.isEmpty__Z())) {
              var e$3 = $as_jl_Throwable(o11.get__O());
              var jsx$1 = new $c_s_util_Failure().init___jl_Throwable(e$3);
              break matchEnd8
            };
            throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
          }
        } else {
          var jsx$1;
          throw e
        }
      };
      return jsx$2.futureFromTry__s_util_Try__s_concurrent_Future(jsx$1)
    })
  })(this, ex)))
});
var $d_Lorg_scalajs_testcommon_RunMuxRPC = new $TypeData().initClass({
  Lorg_scalajs_testcommon_RunMuxRPC: 0
}, false, "org.scalajs.testcommon.RunMuxRPC", {
  Lorg_scalajs_testcommon_RunMuxRPC: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_RunMuxRPC.prototype.$classData = $d_Lorg_scalajs_testcommon_RunMuxRPC;
/** @constructor */
function $c_Lorg_scalajs_testcommon_RunnerArgs() {
  $c_O.call(this);
  this.runID$1 = 0;
  this.frameworkImpl$1 = null;
  this.args$1 = null;
  this.remoteArgs$1 = null
}
$c_Lorg_scalajs_testcommon_RunnerArgs.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_RunnerArgs.prototype.constructor = $c_Lorg_scalajs_testcommon_RunnerArgs;
/** @constructor */
function $h_Lorg_scalajs_testcommon_RunnerArgs() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_RunnerArgs.prototype = $c_Lorg_scalajs_testcommon_RunnerArgs.prototype;
$c_Lorg_scalajs_testcommon_RunnerArgs.prototype.init___I__T__sci_List__sci_List = (function(runID, frameworkImpl, args, remoteArgs) {
  this.runID$1 = runID;
  this.frameworkImpl$1 = frameworkImpl;
  this.args$1 = args;
  this.remoteArgs$1 = remoteArgs;
  return this
});
function $is_Lorg_scalajs_testcommon_RunnerArgs(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_RunnerArgs)))
}
function $as_Lorg_scalajs_testcommon_RunnerArgs(obj) {
  return (($is_Lorg_scalajs_testcommon_RunnerArgs(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.RunnerArgs"))
}
function $isArrayOf_Lorg_scalajs_testcommon_RunnerArgs(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_RunnerArgs)))
}
function $asArrayOf_Lorg_scalajs_testcommon_RunnerArgs(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_RunnerArgs(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.RunnerArgs;", depth))
}
var $d_Lorg_scalajs_testcommon_RunnerArgs = new $TypeData().initClass({
  Lorg_scalajs_testcommon_RunnerArgs: 0
}, false, "org.scalajs.testcommon.RunnerArgs", {
  Lorg_scalajs_testcommon_RunnerArgs: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_RunnerArgs.prototype.$classData = $d_Lorg_scalajs_testcommon_RunnerArgs;
/** @constructor */
function $c_Lorg_scalajs_testcommon_Serializer$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testcommon_Serializer$.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_Serializer$.prototype.constructor = $c_Lorg_scalajs_testcommon_Serializer$;
/** @constructor */
function $h_Lorg_scalajs_testcommon_Serializer$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_Serializer$.prototype = $c_Lorg_scalajs_testcommon_Serializer$.prototype;
$c_Lorg_scalajs_testcommon_Serializer$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testcommon_Serializer$.prototype.serialize__O__Lorg_scalajs_testcommon_Serializer__T = (function(t, evidence$1) {
  var byteOut = new $c_Ljava_io_ByteArrayOutputStream().init___();
  var dataOut = new $c_Ljava_io_DataOutputStream().init___Ljava_io_OutputStream(byteOut);
  try {
    evidence$1.serialize__O__Ljava_io_DataOutputStream__V(t, dataOut)
  } finally {
    dataOut.out$2.close__V()
  };
  var this$14 = $m_sjsr_RuntimeString$();
  var xs = byteOut.toByteArray__AB();
  var elems$2 = null;
  elems$2 = [];
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var idx = i;
    var arg1 = xs.get(idx);
    var b = $uB(arg1);
    var c = (255 & b);
    elems$2.push(c);
    i = ((1 + i) | 0)
  };
  var value = $makeNativeArrayWrapper($d_C.getArrayOf(), elems$2);
  return this$14.newString__AC__I__I__T(value, 0, value.u.length)
});
$c_Lorg_scalajs_testcommon_Serializer$.prototype.deserialize__T__Lorg_scalajs_testcommon_Serializer__O = (function(s, evidence$2) {
  var this$4 = new $c_sci_StringOps().init___T(s);
  var jsx$1 = $m_sjsr_RuntimeString$();
  var $$this = this$4.repr$1;
  var xs = jsx$1.toCharArray__T__AC($$this);
  var elems$2 = null;
  elems$2 = [];
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var idx = i;
    var c = xs.get(idx);
    var elem = ((c << 24) >> 24);
    elems$2.push(elem);
    i = ((1 + i) | 0)
  };
  var bytes = $makeNativeArrayWrapper($d_B.getArrayOf(), elems$2);
  var $in = new $c_Ljava_io_DataInputStream().init___Ljava_io_InputStream(new $c_Ljava_io_ByteArrayInputStream().init___AB(bytes));
  try {
    return evidence$2.deserialize__Ljava_io_DataInputStream__O($in)
  } finally {
    $in.in$2.close__V()
  }
});
var $d_Lorg_scalajs_testcommon_Serializer$ = new $TypeData().initClass({
  Lorg_scalajs_testcommon_Serializer$: 0
}, false, "org.scalajs.testcommon.Serializer$", {
  Lorg_scalajs_testcommon_Serializer$: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_Serializer$.prototype.$classData = $d_Lorg_scalajs_testcommon_Serializer$;
var $n_Lorg_scalajs_testcommon_Serializer$ = (void 0);
function $m_Lorg_scalajs_testcommon_Serializer$() {
  if ((!$n_Lorg_scalajs_testcommon_Serializer$)) {
    $n_Lorg_scalajs_testcommon_Serializer$ = new $c_Lorg_scalajs_testcommon_Serializer$().init___()
  };
  return $n_Lorg_scalajs_testcommon_Serializer$
}
/** @constructor */
function $c_Lorg_scalajs_testcommon_Serializer$SerializeState$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testcommon_Serializer$SerializeState$.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_Serializer$SerializeState$.prototype.constructor = $c_Lorg_scalajs_testcommon_Serializer$SerializeState$;
/** @constructor */
function $h_Lorg_scalajs_testcommon_Serializer$SerializeState$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_Serializer$SerializeState$.prototype = $c_Lorg_scalajs_testcommon_Serializer$SerializeState$.prototype;
$c_Lorg_scalajs_testcommon_Serializer$SerializeState$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testcommon_Serializer$SerializeState$.prototype.write$extension__Ljava_io_DataOutputStream__O__Lorg_scalajs_testcommon_Serializer__V = (function($$this, t, s) {
  s.serialize__O__Ljava_io_DataOutputStream__V(t, $$this)
});
var $d_Lorg_scalajs_testcommon_Serializer$SerializeState$ = new $TypeData().initClass({
  Lorg_scalajs_testcommon_Serializer$SerializeState$: 0
}, false, "org.scalajs.testcommon.Serializer$SerializeState$", {
  Lorg_scalajs_testcommon_Serializer$SerializeState$: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_Serializer$SerializeState$.prototype.$classData = $d_Lorg_scalajs_testcommon_Serializer$SerializeState$;
var $n_Lorg_scalajs_testcommon_Serializer$SerializeState$ = (void 0);
function $m_Lorg_scalajs_testcommon_Serializer$SerializeState$() {
  if ((!$n_Lorg_scalajs_testcommon_Serializer$SerializeState$)) {
    $n_Lorg_scalajs_testcommon_Serializer$SerializeState$ = new $c_Lorg_scalajs_testcommon_Serializer$SerializeState$().init___()
  };
  return $n_Lorg_scalajs_testcommon_Serializer$SerializeState$
}
/** @constructor */
function $c_Lorg_scalajs_testcommon_TaskInfo() {
  $c_O.call(this);
  this.serializedTask$1 = null;
  this.taskDef$1 = null;
  this.tags$1 = null
}
$c_Lorg_scalajs_testcommon_TaskInfo.prototype = new $h_O();
$c_Lorg_scalajs_testcommon_TaskInfo.prototype.constructor = $c_Lorg_scalajs_testcommon_TaskInfo;
/** @constructor */
function $h_Lorg_scalajs_testcommon_TaskInfo() {
  /*<skip>*/
}
$h_Lorg_scalajs_testcommon_TaskInfo.prototype = $c_Lorg_scalajs_testcommon_TaskInfo.prototype;
$c_Lorg_scalajs_testcommon_TaskInfo.prototype.init___T__Lsbt_testing_TaskDef__sci_List = (function(serializedTask, taskDef, tags) {
  this.serializedTask$1 = serializedTask;
  this.taskDef$1 = taskDef;
  this.tags$1 = tags;
  return this
});
function $is_Lorg_scalajs_testcommon_TaskInfo(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testcommon_TaskInfo)))
}
function $as_Lorg_scalajs_testcommon_TaskInfo(obj) {
  return (($is_Lorg_scalajs_testcommon_TaskInfo(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testcommon.TaskInfo"))
}
function $isArrayOf_Lorg_scalajs_testcommon_TaskInfo(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testcommon_TaskInfo)))
}
function $asArrayOf_Lorg_scalajs_testcommon_TaskInfo(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testcommon_TaskInfo(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testcommon.TaskInfo;", depth))
}
var $d_Lorg_scalajs_testcommon_TaskInfo = new $TypeData().initClass({
  Lorg_scalajs_testcommon_TaskInfo: 0
}, false, "org.scalajs.testcommon.TaskInfo", {
  Lorg_scalajs_testcommon_TaskInfo: 1,
  O: 1
});
$c_Lorg_scalajs_testcommon_TaskInfo.prototype.$classData = $d_Lorg_scalajs_testcommon_TaskInfo;
/** @constructor */
function $c_Lorg_scalajs_testinterface_HTMLRunner$() {
  $c_O.call(this);
  this.classLoader$1 = null
}
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype.constructor = $c_Lorg_scalajs_testinterface_HTMLRunner$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_HTMLRunner$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_HTMLRunner$.prototype = $c_Lorg_scalajs_testinterface_HTMLRunner$.prototype;
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype.init___ = (function() {
  $n_Lorg_scalajs_testinterface_HTMLRunner$ = this;
  this.classLoader$1 = new $c_Lorg_scalajs_testinterface_ScalaJSClassLoader().init___sjs_js_Dynamic($g);
  return this
});
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype.and__p1__sc_Seq__Z = (function(xs) {
  return $uZ(xs.foldLeft__O__F2__O(true, new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this) {
    return (function(x$21$2, x$22$2) {
      var x$21 = $uZ(x$21$2);
      var x$22 = $uZ(x$22$2);
      return (x$21 && x$22)
    })
  })(this))))
});
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype.runAllTasks$1__p1__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$UI__s_concurrent_Future = (function(tasks, ui$2) {
  var jsx$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, ui$2$1) {
    return (function(task$2) {
      var task = $as_Lsbt_testing_Task(task$2);
      var this$1 = $this.scheduleTask__p1__Lsbt_testing_Task__Lorg_scalajs_testinterface_HTMLRunner$UI__s_concurrent_Future(task, ui$2$1);
      var p = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
        return (function(check$ifrefutable$2$2) {
          var check$ifrefutable$2 = $as_T2(check$ifrefutable$2$2);
          return (check$ifrefutable$2 !== null)
        })
      })($this));
      var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
      var this$4 = $s_s_concurrent_Future$class__filter__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$1, p, executor);
      var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2, ui$2$2) {
        return (function(x$8$2) {
          var x$8 = $as_T2(x$8$2);
          if ((x$8 !== null)) {
            var ok = x$8.$$und1$mcZ$sp__Z();
            var newTasks = $asArrayOf_Lsbt_testing_Task(x$8.$$und2__O(), 1);
            var this$3 = this$2.runAllTasks$1__p1__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$UI__s_concurrent_Future($m_s_Predef$().wrapRefArray__AO__scm_WrappedArray(newTasks), ui$2$2);
            var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$2, ok$1) {
              return (function(newOk$2) {
                var newOk = $uZ(newOk$2);
                return (ok$1 && newOk)
              })
            })(this$2, ok));
            var executor$1 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
            return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$3, f, executor$1)
          } else {
            throw new $c_s_MatchError().init___O(x$8)
          }
        })
      })($this, ui$2$1));
      var executor$2 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
      return $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$4, f$1, executor$2)
    })
  })(this, ui$2));
  var this$5 = $m_sc_Seq$();
  var oks = $as_sc_Seq(tasks.map__F1__scg_CanBuildFrom__O(jsx$1, this$5.ReusableCBFInstance$2));
  var jsx$2 = $m_s_concurrent_Future$();
  var this$6 = $m_sc_Seq$();
  var this$7 = jsx$2.sequence__sc_TraversableOnce__scg_CanBuildFrom__s_concurrent_ExecutionContext__s_concurrent_Future(oks, this$6.ReusableCBFInstance$2, $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor());
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(xs$2) {
      var xs = $as_sc_Seq(xs$2);
      return this$2$1.and__p1__sc_Seq__Z(xs)
    })
  })(this));
  var executor$3 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$7, f$2, executor$3)
});
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype.runTests__p1__Lsbt_testing_Framework__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$UI__s_concurrent_Future = (function(framework, taskDefs, ui) {
  var xs = $m_sci_Nil$();
  var len = $s_sc_LinearSeqOptimized$class__length__sc_LinearSeqOptimized__I(xs);
  var array = $newArrayObject($d_T.getArrayOf(), [len]);
  var elem$1 = 0;
  elem$1 = 0;
  var this$4 = new $c_sc_LinearSeqLike$$anon$1().init___sc_LinearSeqLike(xs);
  while (this$4.hasNext__Z()) {
    var arg1 = this$4.next__O();
    array.set(elem$1, arg1);
    elem$1 = ((1 + elem$1) | 0)
  };
  var xs$1 = $m_sci_Nil$();
  var len$1 = $s_sc_LinearSeqOptimized$class__length__sc_LinearSeqOptimized__I(xs$1);
  var array$1 = $newArrayObject($d_T.getArrayOf(), [len$1]);
  var elem$1$1 = 0;
  elem$1$1 = 0;
  var this$8 = new $c_sc_LinearSeqLike$$anon$1().init___sc_LinearSeqLike(xs$1);
  while (this$8.hasNext__Z()) {
    var arg1$1 = this$8.next__O();
    array$1.set(elem$1$1, arg1$1);
    elem$1$1 = ((1 + elem$1$1) | 0)
  };
  var runner = framework.runner__AT__AT__jl_ClassLoader__Lsbt_testing_Runner(array, array$1, this.classLoader$1);
  var tasks = runner.tasks__ALsbt_testing_TaskDef__ALsbt_testing_Task($asArrayOf_Lsbt_testing_TaskDef(taskDefs.toArray__s_reflect_ClassTag__O(new $c_s_reflect_ClassTag$ClassClassTag().init___jl_Class($d_Lsbt_testing_TaskDef.getClassOf())), 1));
  var this$12 = this.runAllTasks$1__p1__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$UI__s_concurrent_Future($m_s_Predef$().wrapRefArray__AO__scm_WrappedArray(tasks), ui);
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, framework$1, ui$1, runner$1) {
    return (function(ok$2) {
      var ok = $uZ(ok$2);
      var resultStr = runner$1.done__T();
      var this$11 = new $c_sci_StringOps().init___T(resultStr);
      if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$11)) {
        ui$1.reportFrameworkResult__Z__T__T__V(ok, framework$1.name__T(), resultStr)
      };
      return ok
    })
  })(this, framework, ui, runner));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$12, f, executor)
});
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype.main__V = (function() {
  var x = $as_T($g.document.location.search);
  var this$2 = new $c_sci_StringOps().init___T(x);
  var search = $s_sci_StringLike$class__stripPrefix__sci_StringLike__T__T(this$2, "?");
  var rc11 = false;
  var x2 = null;
  var xs = $m_sjsr_RuntimeString$().split__T__T__I__AT(search, "&", 0);
  var elems$2 = null;
  elems$2 = [];
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var encodedURIComponent = $as_T(arg1);
    var elem = $as_T($g.decodeURIComponent(encodedURIComponent));
    var unboxedElem = ((elem === null) ? null : elem);
    elems$2.push(unboxedElem);
    i = ((1 + i) | 0)
  };
  var xs$1 = $makeNativeArrayWrapper($d_T.getArrayOf(), elems$2);
  var this$13 = $m_sci_List$();
  var cbf = this$13.ReusableCBFInstance$2;
  var b = cbf.apply__scm_Builder();
  b.sizeHint__I__V(xs$1.u.length);
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs$1));
  var x1 = $as_sci_List(b.result__O());
  matchEnd12: {
    var x1$2_$_$$und1$f;
    var x1$2_$_$$und2$f;
    if ($is_sci_$colon$colon(x1)) {
      rc11 = true;
      x2 = $as_sci_$colon$colon(x1);
      var p3 = $as_T(x2.head$5);
      var p4 = x2.tl$5;
      if ((p3 === "i")) {
        if ($is_sci_$colon$colon(p4)) {
          var x5 = $as_sci_$colon$colon(p4);
          var excludedHash = $as_T(x5.head$5);
          var included = x5.tl$5;
          var this$16 = $m_sci_Set$();
          var cbf$1 = new $c_scg_GenSetFactory$$anon$1().init___scg_GenSetFactory(this$16);
          var includeSet = $as_sci_Set($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(included, cbf$1));
          var _1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, includeSet$1) {
            return (function(t$2) {
              var t = $as_Lsbt_testing_TaskDef(t$2);
              return includeSet$1.contains__O__Z(t.$$undfullyQualifiedName$1)
            })
          })(this, includeSet));
          var this$18 = new $c_sci_StringOps().init___T(excludedHash);
          var this$20 = $m_jl_Integer$();
          var $$this = this$18.repr$1;
          var _2 = new $c_s_Some().init___O(this$20.parseInt__T__I__I($$this, 10));
          var x1$2_$_$$und1$f = _1;
          var x1$2_$_$$und2$f = _2;
          break matchEnd12
        }
      }
    };
    if (rc11) {
      var p7 = $as_T(x2.head$5);
      var excluded = x2.tl$5;
      if ((p7 === "e")) {
        var this$21 = $m_sci_Set$();
        var cbf$2 = new $c_scg_GenSetFactory$$anon$1().init___scg_GenSetFactory(this$21);
        var excludeSet = $as_sci_Set($s_sc_TraversableLike$class__to__sc_TraversableLike__scg_CanBuildFrom__O(excluded, cbf$2));
        var _1$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, excludeSet$1) {
          return (function(t$3$2) {
            var t$3 = $as_Lsbt_testing_TaskDef(t$3$2);
            return (!excludeSet$1.contains__O__Z(t$3.$$undfullyQualifiedName$1))
          })
        })(this, excludeSet));
        var _2$1 = $m_s_None$();
        var x1$2_$_$$und1$f = _1$1;
        var x1$2_$_$$und2$f = _2$1;
        break matchEnd12
      }
    };
    var _1$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
      return (function(x$1$2) {
        $as_Lsbt_testing_TaskDef(x$1$2);
        return true
      })
    })(this));
    var _2$2 = $m_s_None$();
    var x1$2_$_$$und1$f = _1$2;
    var x1$2_$_$$und2$f = _2$2
  };
  var testFilter = $as_F1(x1$2_$_$$und1$f);
  var optExcludedHash = $as_s_Option(x1$2_$_$$und2$f);
  var allTests = $m_Lorg_scalajs_testinterface_TestDetector$().detectTests__sc_Seq();
  var jsx$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$5$1) {
    return (function(x$3$2) {
      var x$3 = $as_T2(x$3$2);
      return $as_sc_SeqLike(x$3.$$und2__O()).size__I()
    })
  })(this));
  var this$22 = $m_sc_Seq$();
  var totalTestCount = $uI($as_sc_TraversableOnce(allTests.map__F1__scg_CanBuildFrom__O(jsx$1, this$22.ReusableCBFInstance$2)).sum__s_math_Numeric__O($m_s_math_Numeric$IntIsIntegral$()));
  var jsx$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$6$1, testFilter$2) {
    return (function(x$4$2) {
      var x$4 = $as_T2(x$4$2);
      return $as_sc_Seq($as_sc_TraversableLike(x$4.$$und2__O()).filterNot__F1__O(testFilter$2))
    })
  })(this, testFilter));
  var this$23 = $m_sc_Seq$();
  var excludedTests = $as_sc_Seq(allTests.flatMap__F1__scg_CanBuildFrom__O(jsx$2, this$23.ReusableCBFInstance$2));
  var ui = new $c_Lorg_scalajs_testinterface_HTMLRunner$UI().init___sc_Seq__I(excludedTests, totalTestCount);
  if ((!optExcludedHash.isEmpty__Z())) {
    var arg1$1 = optExcludedHash.get__O();
    var x$6 = $uI(arg1$1);
    var jsx$3 = (x$6 !== $m_Lorg_scalajs_testinterface_HTMLRunner$().org$scalajs$testinterface$HTMLRunner$$excludedHash$1__sc_Seq__I(excludedTests))
  } else {
    var jsx$3 = false
  };
  if (jsx$3) {
    ui.warnTestSetChanged__V()
  };
  var jsx$5 = allTests.withFilter__F1__scg_FilterMonadic(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$7$1) {
    return (function(check$ifrefutable$1$2) {
      var check$ifrefutable$1 = $as_T2(check$ifrefutable$1$2);
      return (check$ifrefutable$1 !== null)
    })
  })(this)));
  var jsx$4 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$8$1, testFilter$2$1, ui$1) {
    return (function(x$7$2) {
      var x$7 = $as_T2(x$7$2);
      if ((x$7 !== null)) {
        var framework = $as_Lsbt_testing_Framework(x$7.$$und1__O());
        var taskDefs = $as_sc_Seq(x$7.$$und2__O());
        return this$8$1.runTests__p1__Lsbt_testing_Framework__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$UI__s_concurrent_Future(framework, $as_sc_Seq(taskDefs.filter__F1__O(testFilter$2$1)), ui$1)
      } else {
        throw new $c_s_MatchError().init___O(x$7)
      }
    })
  })(this, testFilter, ui));
  var this$24 = $m_sc_Seq$();
  var oks = $as_sc_Seq(jsx$5.map__F1__scg_CanBuildFrom__O(jsx$4, this$24.ReusableCBFInstance$2));
  var jsx$6 = $m_s_concurrent_Future$();
  var this$25 = $m_sc_Seq$();
  var this$26 = jsx$6.sequence__sc_TraversableOnce__scg_CanBuildFrom__s_concurrent_ExecutionContext__s_concurrent_Future(oks, this$25.ReusableCBFInstance$2, $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor());
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$9$1) {
    return (function(xs$2) {
      var xs$3 = $as_sc_Seq(xs$2);
      return this$9$1.and__p1__sc_Seq__Z(xs$3)
    })
  })(this));
  var executor = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(this$26, f, executor).onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$10$1, ui$2) {
    return (function(ok$2) {
      var ok = $as_s_util_Try(ok$2);
      ui$2.done__s_util_Try__V(ok)
    })
  })(this, ui)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor())
});
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype.org$scalajs$testinterface$HTMLRunner$$excludedHash$1__sc_Seq__I = (function(excludedTests$1) {
  var jsx$2 = $m_sr_ScalaRunTime$();
  var jsx$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$5$2) {
      var x$5 = $as_Lsbt_testing_TaskDef(x$5$2);
      return x$5.$$undfullyQualifiedName$1
    })
  })(this));
  var this$1 = $m_sc_Seq$();
  return jsx$2.hash__O__I($as_sc_TraversableOnce(excludedTests$1.map__F1__scg_CanBuildFrom__O(jsx$1, this$1.ReusableCBFInstance$2)).toSet__sci_Set())
});
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype.scheduleTask__p1__Lsbt_testing_Task__Lorg_scalajs_testinterface_HTMLRunner$UI__s_concurrent_Future = (function(task, ui) {
  var uiBox = ui.newTestTask__T__Lorg_scalajs_testinterface_HTMLRunner$UI$TestTask(task.taskDef__Lsbt_testing_TaskDef().$$undfullyQualifiedName$1);
  var handler = new $c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$Handler().init___();
  var newTasks = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  $m_s_concurrent_Future$();
  var body = new $c_Lorg_scalajs_testinterface_HTMLRunner$$anonfun$37().init___Lsbt_testing_Task__Lorg_scalajs_testinterface_HTMLRunner$UI$TestTask__Lorg_scalajs_testinterface_HTMLRunner$EventCounter$Handler__s_concurrent_Promise(task, uiBox, handler, newTasks);
  var executor = new $c_sjs_concurrent_QueueExecutionContext$TimeoutsExecutionContext().init___();
  var invocation = $m_s_concurrent_impl_Future$().apply__F0__s_concurrent_ExecutionContext__s_concurrent_Future(body, executor);
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, handler$1, newTasks$1) {
    return (function(_$2) {
      $asUnit(_$2);
      var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1, handler$1$1) {
        return (function(tasks$2) {
          var tasks = $asArrayOf_Lsbt_testing_Task(tasks$2, 1);
          return new $c_T2().init___O__O((!handler$1$1.$$undhasErrors$1), tasks)
        })
      })($this, handler$1));
      var executor$1 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
      return $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(newTasks$1, f, executor$1)
    })
  })(this, handler, newTasks));
  var executor$2 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  var result = $s_s_concurrent_Future$class__flatMap__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(invocation, f$1, executor$2);
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(x$9$2) {
      var x$9 = $as_T2(x$9$2);
      return x$9.$$und1$mcZ$sp__Z()
    })
  })(this));
  var executor$3 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  $s_s_concurrent_Future$class__map__s_concurrent_Future__F1__s_concurrent_ExecutionContext__s_concurrent_Future(result, f$2, executor$3).onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, uiBox$1) {
    return (function(ok$2) {
      var ok = $as_s_util_Try(ok$2);
      uiBox$1.done__s_util_Try__V(ok)
    })
  })(this, uiBox)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor());
  var pf = new $c_Lorg_scalajs_testinterface_HTMLRunner$$anonfun$scheduleTask$1().init___();
  var executor$4 = $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContextExecutor();
  return $s_s_concurrent_Future$class__recover__s_concurrent_Future__s_PartialFunction__s_concurrent_ExecutionContext__s_concurrent_Future(result, pf, executor$4)
});
var $d_Lorg_scalajs_testinterface_HTMLRunner$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_HTMLRunner$: 0
}, false, "org.scalajs.testinterface.HTMLRunner$", {
  Lorg_scalajs_testinterface_HTMLRunner$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_HTMLRunner$.prototype.$classData = $d_Lorg_scalajs_testinterface_HTMLRunner$;
var $n_Lorg_scalajs_testinterface_HTMLRunner$ = (void 0);
function $m_Lorg_scalajs_testinterface_HTMLRunner$() {
  if ((!$n_Lorg_scalajs_testinterface_HTMLRunner$)) {
    $n_Lorg_scalajs_testinterface_HTMLRunner$ = new $c_Lorg_scalajs_testinterface_HTMLRunner$().init___()
  };
  return $n_Lorg_scalajs_testinterface_HTMLRunner$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$() {
  $c_O.call(this);
  this.org$scalajs$testinterface$HTMLRunner$EventCounter$$isErrorStatus$1 = null;
  this.counts$1 = null
}
$c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype.constructor = $c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype = $c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype;
$c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype.init___ = (function() {
  $n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$ = this;
  var array = [$m_Lsbt_testing_Status$().Error$1, $m_Lsbt_testing_Status$().Failure$1];
  if (($uI(array.length) === 0)) {
    var jsx$1 = $m_sci_Set$EmptySet$()
  } else {
    var b = new $c_scm_SetBuilder().init___sc_Set($m_sci_Set$EmptySet$());
    var i = 0;
    var len = $uI(array.length);
    while ((i < len)) {
      var index = i;
      var arg1 = array[index];
      b.$$plus$eq__O__scm_SetBuilder(arg1);
      i = ((1 + i) | 0)
    };
    var jsx$1 = b.elems$1
  };
  this.org$scalajs$testinterface$HTMLRunner$EventCounter$$isErrorStatus$1 = $as_sci_Set(jsx$1);
  var this$5 = new $c_scm_HashMap().init___();
  this.counts$1 = $s_scm_Map$class__withDefaultValue__scm_Map__O__scm_Map(this$5, 0);
  return this
});
var $d_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_HTMLRunner$EventCounter$: 0
}, false, "org.scalajs.testinterface.HTMLRunner$EventCounter$", {
  Lorg_scalajs_testinterface_HTMLRunner$EventCounter$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype.$classData = $d_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$;
var $n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$ = (void 0);
function $m_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$() {
  if ((!$n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$)) {
    $n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$ = new $c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$().init___()
  };
  return $n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_HTMLRunner$UI() {
  $c_O.call(this);
  this.org$scalajs$testinterface$HTMLRunner$UI$$excludedTaskDefs$f = null;
  this.$$unddone$1 = false;
  this.org$scalajs$testinterface$HTMLRunner$UI$$runningTests$1 = null;
  this.org$scalajs$testinterface$HTMLRunner$UI$$excludedTests$1 = null;
  this.org$scalajs$testinterface$HTMLRunner$UI$$container$1 = null;
  this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1 = null;
  this.org$scalajs$testinterface$HTMLRunner$UI$$nextFailureLocation$f = null
}
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.constructor = $c_Lorg_scalajs_testinterface_HTMLRunner$UI;
/** @constructor */
function $h_Lorg_scalajs_testinterface_HTMLRunner$UI() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype = $c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype;
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$statusClass__Z__T = (function(ok) {
  return (ok ? "success" : "error")
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.warnTestSetChanged__V = (function() {
  var this$1 = this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1;
  var line = this$1.box$1.log__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element("", "warn");
  $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newTextNode$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Node(line, "There are new excluded tests in your project. You may wish to ");
  $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newLink$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element(line, "?", "Run all");
  $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newTextNode$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Node(line, " to rediscover all available tests.")
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$testUpdater__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox__sjs_js_Function0 = (function(tests, checkbox) {
  return (function(f) {
    return (function() {
      return f.apply__O()
    })
  })(new $c_Lorg_scalajs_testinterface_HTMLRunner$UI$$anonfun$org$scalajs$testinterface$HTMLRunner$UI$$testUpdater$1().init___Lorg_scalajs_testinterface_HTMLRunner$UI__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox(this, tests, checkbox))
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$updateCounts__V = (function() {
  var total = $uI($m_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$().counts$1.values__sc_Iterable().sum__s_math_Numeric__O($m_s_math_Numeric$IntIsIntegral$()));
  var array = ["Total: ", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [total];
  var x$10 = jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1));
  var xs = $m_Lsbt_testing_Status$().values__ALsbt_testing_Status();
  var elems$2 = null;
  elems$2 = [];
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var status = $as_Lsbt_testing_Status(arg1);
    var array$2 = ["", ": ", ""];
    var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$2));
    var array$3 = [status, $m_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$().counts$1.apply__O__O(status)];
    var elem = jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$3));
    var unboxedElem = ((elem === null) ? null : elem);
    elems$2.push(unboxedElem);
    i = ((1 + i) | 0)
  };
  var xs$1 = $makeNativeArrayWrapper($d_T.getArrayOf(), elems$2);
  var n1 = ((1 + xs$1.u.length) | 0);
  var result = $newArrayObject($d_T.getArrayOf(), [n1]);
  result.set(0, x$10);
  $m_s_Array$().copy__O__I__O__I__I__V(xs$1, 0, result, 1, xs$1.u.length);
  var b = new $c_scm_StringBuilder().init___();
  var elem$1 = false;
  elem$1 = true;
  b.append__T__scm_StringBuilder("");
  var i$1 = 0;
  var len$1 = result.u.length;
  while ((i$1 < len$1)) {
    var index$1 = i$1;
    var arg1$1 = result.get(index$1);
    if (elem$1) {
      b.append__O__scm_StringBuilder(arg1$1);
      elem$1 = false
    } else {
      b.append__T__scm_StringBuilder(", ");
      b.append__O__scm_StringBuilder(arg1$1)
    };
    i$1 = ((1 + i$1) | 0)
  };
  b.append__T__scm_StringBuilder("");
  var countStr = b.underlying$5.java$lang$StringBuilder$$content$f;
  if (this.$$unddone$1) {
    this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1.counterLineText$und$eq__T__V(countStr)
  } else {
    this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1.counterLineText$und$eq__T__V(("Running... " + countStr))
  }
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.newTestTask__T__Lorg_scalajs_testinterface_HTMLRunner$UI$TestTask = (function(testName) {
  var task = new $c_Lorg_scalajs_testinterface_HTMLRunner$UI$RunningTest().init___Lorg_scalajs_testinterface_HTMLRunner$UI__T(this, testName);
  this.org$scalajs$testinterface$HTMLRunner$UI$$runningTests$1.$$plus$eq__O__scm_Buffer(task);
  return task
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$checkboxUpdater__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox__sjs_js_Function0 = (function(tests, checkbox) {
  return (function(f) {
    return (function() {
      return f.apply__O()
    })
  })(new $c_Lorg_scalajs_testinterface_HTMLRunner$UI$$anonfun$org$scalajs$testinterface$HTMLRunner$UI$$checkboxUpdater$1().init___Lorg_scalajs_testinterface_HTMLRunner$UI__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox(this, tests, checkbox))
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.init___sc_Seq__I = (function(excludedTaskDefs, totalTestCount) {
  this.org$scalajs$testinterface$HTMLRunner$UI$$excludedTaskDefs$f = excludedTaskDefs;
  this.$$unddone$1 = false;
  $m_scm_Buffer$();
  var this$2 = new $c_sjs_js_WrappedArray().init___();
  this.org$scalajs$testinterface$HTMLRunner$UI$$runningTests$1 = this$2;
  $m_scm_Buffer$();
  var this$4 = new $c_sjs_js_WrappedArray().init___();
  this.org$scalajs$testinterface$HTMLRunner$UI$$excludedTests$1 = this$4;
  var element = $g.document.body;
  this.org$scalajs$testinterface$HTMLRunner$UI$$container$1 = $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newElement$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element(element, "", "", "div");
  this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1 = new $c_Lorg_scalajs_testinterface_HTMLRunner$UI$RootBox().init___Lorg_scalajs_testinterface_HTMLRunner$UI__I__I(this, excludedTaskDefs.size__I(), totalTestCount);
  this.org$scalajs$testinterface$HTMLRunner$UI$$nextFailureLocation$f = (excludedTaskDefs.nonEmpty__Z() ? new $c_Lorg_scalajs_testinterface_HTMLRunner$UI$ExcludedTestBox().init___Lorg_scalajs_testinterface_HTMLRunner$UI(this) : this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1);
  this.org$scalajs$testinterface$HTMLRunner$UI$$updateCounts__V();
  return this
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.reportFrameworkResult__Z__T__T__V = (function(ok, framework, result) {
  var this$5 = this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1;
  var array = ["", " reported ", ""];
  var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array));
  var array$1 = [framework, result];
  var msg = jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1));
  var clss = this.org$scalajs$testinterface$HTMLRunner$UI$$statusClass__Z__T(ok);
  this$5.box$1.log__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element(msg, clss)
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.done__s_util_Try__V = (function(ok) {
  this.$$unddone$1 = true;
  ok.failed__s_util_Try().foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(t$2) {
      var t = $as_jl_Throwable(t$2);
      var this$1 = $this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1;
      this$1.box$1.log__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element("Test framework crashed during execution:", "error");
      var this$2 = $this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1;
      var msg = t.toString__T();
      return this$2.box$1.log__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element(msg, "error")
    })
  })(this)));
  this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1.done__Z__V($uZ((ok.isSuccess__Z() && ok.get__O())));
  this.org$scalajs$testinterface$HTMLRunner$UI$$updateCounts__V()
});
var $d_Lorg_scalajs_testinterface_HTMLRunner$UI = new $TypeData().initClass({
  Lorg_scalajs_testinterface_HTMLRunner$UI: 0
}, false, "org.scalajs.testinterface.HTMLRunner$UI", {
  Lorg_scalajs_testinterface_HTMLRunner$UI: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.$classData = $d_Lorg_scalajs_testinterface_HTMLRunner$UI;
/** @constructor */
function $c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.constructor = $c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype = $c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype;
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.newCheckbox$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__Z__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox = (function($$this, checked) {
  var el = this.newElement$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element($$this, "", "", "input");
  el.setAttribute("type", "checkbox");
  el.checked = checked;
  return el
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.newElement$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element = (function($$this, clss, text, tpe) {
  var el = $g.document.createElement(tpe);
  var this$2 = new $c_sci_StringOps().init___T(clss);
  if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$2)) {
    el.className = clss
  };
  var this$4 = new $c_sci_StringOps().init___T(text);
  if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$4)) {
    el.textContent = text
  };
  $$this.appendChild(el);
  return el
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.newTextNode$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Node = (function($$this, text) {
  var n = $g.document.createTextNode(text);
  $$this.appendChild(n);
  return n
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.newLink$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element = (function($$this, href, text) {
  var el = this.newElement$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element($$this, "", text, "a");
  el.setAttribute("href", href);
  return el
});
var $d_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$: 0
}, false, "org.scalajs.testinterface.HTMLRunner$dom$RichElement$", {
  Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.$classData = $d_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$;
var $n_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$ = (void 0);
function $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$() {
  if ((!$n_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$)) {
    $n_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$ = new $c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().init___()
  };
  return $n_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_TestDetector$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_TestDetector$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.constructor = $c_Lorg_scalajs_testinterface_TestDetector$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_TestDetector$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_TestDetector$.prototype = $c_Lorg_scalajs_testinterface_TestDetector$.prototype;
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.fingerprintMatches__p1__Lsbt_testing_Fingerprint__Lsbt_testing_Fingerprint__Z = (function(a, b) {
  if ($is_Lsbt_testing_SubclassFingerprint(a)) {
    var x2 = $as_Lsbt_testing_SubclassFingerprint(a);
    if ($is_Lsbt_testing_SubclassFingerprint(b)) {
      var x3 = $as_Lsbt_testing_SubclassFingerprint(b);
      return ((x2.isModule$1 === x3.isModule$1) && (x2.superclassName$1 === x3.superclassName$1))
    }
  };
  if ($is_Lsbt_testing_AnnotatedFingerprint(a)) {
    var x4 = $as_Lsbt_testing_AnnotatedFingerprint(a);
    if ($is_Lsbt_testing_AnnotatedFingerprint(b)) {
      var x5 = $as_Lsbt_testing_AnnotatedFingerprint(b);
      return ((x4.isModule$1 === x5.isModule$1) && (x4.annotationName$1 === x5.annotationName$1))
    }
  };
  return false
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.tryLoadFromReflect$1__p1__T__s_Option = (function(name) {
  var this$1 = $m_sjs_reflect_Reflect$();
  var this$2 = this$1.instantiatableClasses$1.get__O__s_Option(name);
  var pf = new $c_Lorg_scalajs_testinterface_TestDetector$$anonfun$tryLoadFromReflect$1$1().init___();
  if ((!this$2.isEmpty__Z())) {
    var this$3 = new $c_s_PartialFunction$Lifted().init___s_PartialFunction(pf);
    var v1 = this$2.get__O();
    return this$3.apply__O__s_Option(v1)
  } else {
    return $m_s_None$()
  }
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.tryLoadFramework__p1__sjs_js_Array__s_Option = (function(names) {
  var this$2 = new $c_sjs_js_ArrayOps().init___sjs_js_Array(names);
  var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, $uI(this$2.scala$scalajs$js$ArrayOps$$array$f.length));
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(name$2) {
      var name = $as_T(name$2);
      return $this.tryLoad$1__p1__T__s_Option(name)
    })
  })(this));
  var this$4 = new $c_sc_Iterator$$anon$11().init___sc_Iterator__F1(this$3, f);
  var pf = new $c_Lorg_scalajs_testinterface_TestDetector$$anonfun$tryLoadFramework$1().init___();
  return $s_sc_TraversableOnce$class__collectFirst__sc_TraversableOnce__s_PartialFunction__s_Option(this$4, pf)
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.tryLoad$1__p1__T__s_Option = (function(name) {
  var this$1 = this.tryLoadFromReflect$1__p1__T__s_Option(name);
  return (this$1.isEmpty__Z() ? this.tryLoadFromExportsNamespace$1__p1__T__s_Option(name) : this$1)
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.tryLoadFromExportsNamespace$1__p1__T__s_Option = (function(name) {
  var exportsNamespace = $env.exportsNamespace;
  var this$2 = new $c_sci_StringOps().init___T(name);
  var parts = $s_sci_StringLike$class__split__sci_StringLike__C__AT(this$2, 46);
  var start = 0;
  var end = parts.u.length;
  var z = exportsNamespace;
  var ctor;
  _foldl: while (true) {
    if ((start !== end)) {
      var temp$start = ((1 + start) | 0);
      var arg1 = z;
      var index = start;
      var arg2 = parts.get(index);
      var name$2 = $as_T(arg2);
      if ((arg1 === (void 0))) {
        var temp$z = (void 0)
      } else {
        var value = arg1[name$2];
        var temp$z = value
      };
      start = temp$start;
      z = temp$z;
      continue _foldl
    };
    var ctor = z;
    break
  };
  if ((ctor === (void 0))) {
    var value$2 = (void 0)
  } else {
    var value$1 = new ctor();
    var value$2 = value$1
  };
  new $c_Lorg_scalajs_testinterface_TestDetector$$anonfun$tryLoadFromExportsNamespace$1$1().init___();
  var value$3 = ((value$2 === (void 0)) ? (void 0) : ($is_Lsbt_testing_Framework(value$2) ? value$2 : (void 0)));
  return ((value$3 === (void 0)) ? $m_s_None$() : new $c_s_Some().init___O(value$3))
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.detectTests__sc_Seq = (function() {
  var jsx$2 = $m_Lorg_scalajs_testcommon_Serializer$();
  var jsx$1 = $as_T($g.definedTests);
  var evidence$3 = $m_Lorg_scalajs_testcommon_Serializer$TaskDefSerializer$();
  var taskDefs = $as_sci_List(jsx$2.deserialize__T__Lorg_scalajs_testcommon_Serializer__O(jsx$1, new $c_Lorg_scalajs_testcommon_Serializer$$anon$4().init___Lorg_scalajs_testcommon_Serializer(evidence$3)));
  var array = $g.testFrameworkNames;
  var array$1 = [];
  var i = 0;
  var len = $uI(array.length);
  while ((i < len)) {
    var index = i;
    var arg1 = array[index];
    var xo = this.tryLoadFramework__p1__sjs_js_Array__s_Option(arg1);
    var this$5 = xo.toList__sci_List();
    if ((this$5 !== null)) {
      var xs = this$5;
      _loop: while (true) {
        var this$6 = xs;
        if ($s_sc_TraversableOnce$class__nonEmpty__sc_TraversableOnce__Z(this$6)) {
          var elem = xs.head__O();
          array$1.push(elem);
          xs = $as_sc_LinearSeq(xs.tail__O());
          continue _loop
        };
        break
      }
    } else {
      var these = this$5;
      while ((!these.isEmpty__Z())) {
        var arg1$1 = these.head__O();
        array$1.push(arg1$1);
        these = $as_sci_List(these.tail__O())
      }
    };
    i = ((1 + i) | 0)
  };
  var this$8 = $m_sci_List$();
  var cbf = this$8.ReusableCBFInstance$2;
  var b = cbf.apply__scm_Builder();
  b.sizeHint__I__V($uI(array$1.length));
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$1));
  var frameworks = $as_sci_List(b.result__O());
  var f = (function(this$2$1, taskDefs$1) {
    return (function(framework$2) {
      var framework = $as_Lsbt_testing_Framework(framework$2);
      var fingerprints = framework.fingerprints__ALsbt_testing_Fingerprint();
      $m_sci_List$();
      var b$1 = new $c_scm_ListBuffer().init___();
      var these$1 = taskDefs$1;
      while ((!these$1.isEmpty__Z())) {
        var arg1$2 = these$1.head__O();
        var taskDef = $as_Lsbt_testing_TaskDef(arg1$2);
        var i$1 = 0;
        while (true) {
          if ((i$1 < fingerprints.u.length)) {
            var index$1 = i$1;
            var arg1$3 = fingerprints.get(index$1);
            var x$1 = $as_Lsbt_testing_Fingerprint(arg1$3);
            var jsx$3 = (this$2$1.fingerprintMatches__p1__Lsbt_testing_Fingerprint__Lsbt_testing_Fingerprint__Z(x$1, taskDef.$$undfingerprint$1) === false)
          } else {
            var jsx$3 = false
          };
          if (jsx$3) {
            i$1 = ((1 + i$1) | 0)
          } else {
            break
          }
        };
        if (((i$1 !== fingerprints.u.length) !== false)) {
          b$1.$$plus$eq__O__scm_ListBuffer(arg1$2)
        };
        these$1 = $as_sci_List(these$1.tail__O())
      };
      var eligibleTaskDefs = b$1.toList__sci_List();
      return new $c_T2().init___O__O(framework, eligibleTaskDefs)
    })
  })(this, taskDefs);
  var this$14 = $m_sci_List$();
  var bf = this$14.ReusableCBFInstance$2;
  if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
    if ((frameworks === $m_sci_Nil$())) {
      var jsx$4 = $m_sci_Nil$()
    } else {
      var arg1$4 = frameworks.head__O();
      var h = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$4), $m_sci_Nil$());
      var t = h;
      var rest = $as_sci_List(frameworks.tail__O());
      while ((rest !== $m_sci_Nil$())) {
        var arg1$5 = rest.head__O();
        var nx = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$5), $m_sci_Nil$());
        t.tl$5 = nx;
        t = nx;
        rest = $as_sci_List(rest.tail__O())
      };
      var jsx$4 = h
    }
  } else {
    var b$2 = $s_sc_TraversableLike$class__builder$1__p0__sc_TraversableLike__scg_CanBuildFrom__scm_Builder(frameworks, bf);
    var these$2 = frameworks;
    while ((!these$2.isEmpty__Z())) {
      var arg1$6 = these$2.head__O();
      b$2.$$plus$eq__O__scm_Builder(f(arg1$6));
      these$2 = $as_sci_List(these$2.tail__O())
    };
    var jsx$4 = b$2.result__O()
  };
  return $as_sc_Seq(jsx$4)
});
var $d_Lorg_scalajs_testinterface_TestDetector$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_TestDetector$: 0
}, false, "org.scalajs.testinterface.TestDetector$", {
  Lorg_scalajs_testinterface_TestDetector$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.$classData = $d_Lorg_scalajs_testinterface_TestDetector$;
var $n_Lorg_scalajs_testinterface_TestDetector$ = (void 0);
function $m_Lorg_scalajs_testinterface_TestDetector$() {
  if ((!$n_Lorg_scalajs_testinterface_TestDetector$)) {
    $n_Lorg_scalajs_testinterface_TestDetector$ = new $c_Lorg_scalajs_testinterface_TestDetector$().init___()
  };
  return $n_Lorg_scalajs_testinterface_TestDetector$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_Bridge$() {
  $c_O.call(this);
  this.org$scalajs$testinterface$internal$Bridge$$mux$f = null
}
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_Bridge$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_Bridge$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_Bridge$.prototype = $c_Lorg_scalajs_testinterface_internal_Bridge$.prototype;
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.init___ = (function() {
  $n_Lorg_scalajs_testinterface_internal_Bridge$ = this;
  this.org$scalajs$testinterface$internal$Bridge$$mux$f = new $c_Lorg_scalajs_testcommon_RunMuxRPC().init___Lorg_scalajs_testcommon_RPCCore($m_Lorg_scalajs_testinterface_internal_JSRPC$());
  return this
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.createRunnerFun__p1__Z__F1 = (function(isMaster) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, isMaster$1) {
    return (function(args$2) {
      var args = $as_Lorg_scalajs_testcommon_RunnerArgs(args$2);
      var framework = $m_Lorg_scalajs_testinterface_internal_FrameworkLoader$().loadFramework__T__Lsbt_testing_Framework(args.frameworkImpl$1);
      var loader = new $c_Lorg_scalajs_testinterface_ScalaJSClassLoader().init___sjs_js_Dynamic($env.exportsNamespace);
      var runID = args.runID$1;
      if (isMaster$1) {
        var this$3 = args.args$1;
        var len = $s_sc_LinearSeqOptimized$class__length__sc_LinearSeqOptimized__I(this$3);
        var result = $newArrayObject($d_T.getArrayOf(), [len]);
        $s_sc_TraversableOnce$class__copyToArray__sc_TraversableOnce__O__I__V(this$3, result, 0);
        var this$5 = args.remoteArgs$1;
        var len$1 = $s_sc_LinearSeqOptimized$class__length__sc_LinearSeqOptimized__I(this$5);
        var result$1 = $newArrayObject($d_T.getArrayOf(), [len$1]);
        $s_sc_TraversableOnce$class__copyToArray__sc_TraversableOnce__O__I__V(this$5, result$1, 0);
        var runner = framework.runner__AT__AT__jl_ClassLoader__Lsbt_testing_Runner(result, result$1, loader)
      } else {
        var this$7 = args.args$1;
        var len$2 = $s_sc_LinearSeqOptimized$class__length__sc_LinearSeqOptimized__I(this$7);
        var result$2 = $newArrayObject($d_T.getArrayOf(), [len$2]);
        $s_sc_TraversableOnce$class__copyToArray__sc_TraversableOnce__O__I__V(this$7, result$2, 0);
        var this$9 = args.remoteArgs$1;
        var len$3 = $s_sc_LinearSeqOptimized$class__length__sc_LinearSeqOptimized__I(this$9);
        var result$3 = $newArrayObject($d_T.getArrayOf(), [len$3]);
        $s_sc_TraversableOnce$class__copyToArray__sc_TraversableOnce__O__I__V(this$9, result$3, 0);
        var runner = framework.slaveRunner__AT__AT__jl_ClassLoader__F1__Lsbt_testing_Runner(result$2, result$3, loader, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1, runID$1) {
          return (function(msg$2) {
            var msg = $as_T(msg$2);
            $this$1.org$scalajs$testinterface$internal$Bridge$$mux$f.send__Lorg_scalajs_testcommon_MsgEndpoint__I__O__V($m_Lorg_scalajs_testcommon_JVMEndpoints$().msgSlave$1, runID$1, msg)
          })
        })($this, runID)))
      };
      $this.org$scalajs$testinterface$internal$Bridge$$mux$f.attach__Lorg_scalajs_testcommon_RPCEndpoint__I__F1__V($m_Lorg_scalajs_testcommon_JSEndpoints$().tasks$1, runID, $this.tasksFun__p1__Lsbt_testing_Runner__F1(runner));
      $this.org$scalajs$testinterface$internal$Bridge$$mux$f.attachAsync__Lorg_scalajs_testcommon_RPCEndpoint__I__F1__V($m_Lorg_scalajs_testcommon_JSEndpoints$().execute$1, runID, $this.executeFun__p1__I__Lsbt_testing_Runner__F1(runID, runner));
      $this.org$scalajs$testinterface$internal$Bridge$$mux$f.attach__Lorg_scalajs_testcommon_RPCEndpoint__I__F1__V($m_Lorg_scalajs_testcommon_JSEndpoints$().done$1, runID, $this.doneFun__p1__I__Lsbt_testing_Runner__Z__F1(runID, runner, isMaster$1));
      if (isMaster$1) {
        $this.org$scalajs$testinterface$internal$Bridge$$mux$f.attach__Lorg_scalajs_testcommon_MsgEndpoint__I__F1__V($m_Lorg_scalajs_testcommon_JSEndpoints$().msgMaster$1, runID, $this.msgMasterFun__p1__I__Lsbt_testing_Runner__F1(runID, runner))
      } else {
        $this.org$scalajs$testinterface$internal$Bridge$$mux$f.attach__Lorg_scalajs_testcommon_MsgEndpoint__I__F1__V($m_Lorg_scalajs_testcommon_JSEndpoints$().msgSlave$1, runID, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, runner$1) {
          return (function(msg$3$2) {
            var msg$3 = $as_T(msg$3$2);
            runner$1.receiveMessage__T__s_Option(msg$3)
          })
        })($this, runner)))
      }
    })
  })(this, isMaster))
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.doneFun__p1__I__Lsbt_testing_Runner__Z__F1 = (function(runID, runner, isMaster) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, runID$1, runner$1, isMaster$1) {
    return (function(x$4$2) {
      $asUnit(x$4$2);
      try {
        return runner$1.done__T()
      } finally {
        $this.detachRunnerCommands__p1__I__Z__V(runID$1, isMaster$1)
      }
    })
  })(this, runID, runner, isMaster))
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.executeFun__p1__I__Lsbt_testing_Runner__F1 = (function(runID, runner) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, runID$1, runner$1) {
    return (function(req$2) {
      var req = $as_Lorg_scalajs_testcommon_ExecuteRequest(req$2);
      var task = $m_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$().attachTask__Lorg_scalajs_testcommon_TaskInfo__Lsbt_testing_Runner__Lsbt_testing_Task(req.taskInfo$1, runner$1);
      var eventHandler = new $c_Lorg_scalajs_testinterface_internal_Bridge$RemoteEventHandler().init___I(runID$1);
      var this$2 = req.loggerColorSupport$1;
      var this$1 = $m_sci_List$();
      var bf = this$1.ReusableCBFInstance$2;
      var jsx$2 = $as_sc_TraversableLike($s_sc_IterableLike$class__zipWithIndex__sc_IterableLike__scg_CanBuildFrom__O(this$2, bf)).withFilter__F1__scg_FilterMonadic(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
        return (function(check$ifrefutable$1$2) {
          var check$ifrefutable$1 = $as_T2(check$ifrefutable$1$2);
          return (check$ifrefutable$1 !== null)
        })
      })($this)));
      var jsx$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, runID$2) {
        return (function(x$2$2) {
          var x$2 = $as_T2(x$2$2);
          if ((x$2 !== null)) {
            var withColor = x$2.$$und1$mcZ$sp__Z();
            var i = x$2.$$und2$mcI$sp__I();
            return new $c_Lorg_scalajs_testinterface_internal_Bridge$RemoteLogger().init___I__I__Z(runID$2, i, withColor)
          } else {
            throw new $c_s_MatchError().init___O(x$2)
          }
        })
      })($this, runID$1));
      var this$3 = $m_sci_List$();
      var loggers = $as_sci_List(jsx$2.map__F1__scg_CanBuildFrom__O(jsx$1, this$3.ReusableCBFInstance$2));
      var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
      try {
        var len = $s_sc_LinearSeqOptimized$class__length__sc_LinearSeqOptimized__I(loggers);
        var result = $newArrayObject($d_Lsbt_testing_Logger.getArrayOf(), [len]);
        $s_sc_TraversableOnce$class__copyToArray__sc_TraversableOnce__O__I__V(loggers, result, 0);
        task.execute__Lsbt_testing_EventHandler__ALsbt_testing_Logger__F1__V(eventHandler, result, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, runner$3, promise$1) {
          return (function(tasks$2) {
            var tasks = $asArrayOf_Lsbt_testing_Task(tasks$2, 1);
            this$3$1.cont$1__p1__ALsbt_testing_Task__Lsbt_testing_Runner__s_concurrent_Promise__s_concurrent_Promise(tasks, runner$3, promise$1)
          })
        })($this, runner$1, promise)))
      } catch (e) {
        var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
        if ((e$2 !== null)) {
          matchEnd8: {
            var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
            if ((!o11.isEmpty__Z())) {
              var t = $as_jl_Throwable(o11.get__O());
              $s_s_concurrent_Promise$class__tryFailure__s_concurrent_Promise__jl_Throwable__Z(promise, t);
              break matchEnd8
            };
            throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
          }
        } else {
          throw e
        }
      };
      return promise
    })
  })(this, runID, runner))
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.msgMasterFun__p1__I__Lsbt_testing_Runner__F1 = (function(runID, runner) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, runID$1, runner$1) {
    return (function(msg$2) {
      var msg = $as_Lorg_scalajs_testcommon_FrameworkMessage(msg$2);
      var this$1 = runner$1.receiveMessage__T__s_Option(msg.msg$1);
      if ((!this$1.isEmpty__Z())) {
        var arg1 = this$1.get__O();
        var reply = $as_T(arg1);
        var fm = new $c_Lorg_scalajs_testcommon_FrameworkMessage().init___J__T(msg.slaveId$1, reply);
        $this.org$scalajs$testinterface$internal$Bridge$$mux$f.send__Lorg_scalajs_testcommon_MsgEndpoint__I__O__V($m_Lorg_scalajs_testcommon_JVMEndpoints$().msgMaster$1, runID$1, fm)
      }
    })
  })(this, runID, runner))
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.detectFrameworksFun__p1__F1 = (function() {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(names$2) {
      var names = $as_sci_List(names$2);
      var this$6 = $m_Lorg_scalajs_testinterface_internal_FrameworkLoader$().detectFrameworkNames__sci_List__sci_List(names);
      var f = (function($this$1) {
        return (function(maybeName$2) {
          var maybeName = $as_s_Option(maybeName$2);
          if (maybeName.isEmpty__Z()) {
            return $m_s_None$()
          } else {
            var arg1 = maybeName.get__O();
            var name = $as_T(arg1);
            var framework = $m_Lorg_scalajs_testinterface_internal_FrameworkLoader$().loadFramework__T__Lsbt_testing_Framework(name);
            var jsx$1 = framework.name__T();
            var xs = framework.fingerprints__ALsbt_testing_Fingerprint();
            var this$2 = $m_sci_List$();
            var cbf = this$2.ReusableCBFInstance$2;
            var b = cbf.apply__scm_Builder();
            b.sizeHint__I__V(xs.u.length);
            b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs));
            return new $c_s_Some().init___O(new $c_Lorg_scalajs_testcommon_FrameworkInfo().init___T__T__sci_List(name, jsx$1, $as_sci_List(b.result__O())))
          }
        })
      })($this);
      var this$5 = $m_sci_List$();
      var bf = this$5.ReusableCBFInstance$2;
      if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
        if ((this$6 === $m_sci_Nil$())) {
          var jsx$2 = $m_sci_Nil$()
        } else {
          var arg1$1 = this$6.head__O();
          var h = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$1), $m_sci_Nil$());
          var t = h;
          var rest = $as_sci_List(this$6.tail__O());
          while ((rest !== $m_sci_Nil$())) {
            var arg1$2 = rest.head__O();
            var nx = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$2), $m_sci_Nil$());
            t.tl$5 = nx;
            t = nx;
            rest = $as_sci_List(rest.tail__O())
          };
          var jsx$2 = h
        }
      } else {
        var b$1 = $s_sc_TraversableLike$class__builder$1__p0__sc_TraversableLike__scg_CanBuildFrom__scm_Builder(this$6, bf);
        var these = this$6;
        while ((!these.isEmpty__Z())) {
          var arg1$3 = these.head__O();
          b$1.$$plus$eq__O__scm_Builder(f(arg1$3));
          these = $as_sci_List(these.tail__O())
        };
        var jsx$2 = b$1.result__O()
      };
      return $as_sci_List(jsx$2)
    })
  })(this))
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.start__V = (function() {
  $m_Lorg_scalajs_testinterface_internal_JSRPC$().attach__Lorg_scalajs_testcommon_RPCEndpoint__F1__V($m_Lorg_scalajs_testcommon_JSEndpoints$().detectFrameworks$1, this.detectFrameworksFun__p1__F1());
  $m_Lorg_scalajs_testinterface_internal_JSRPC$().attach__Lorg_scalajs_testcommon_RPCEndpoint__F1__V($m_Lorg_scalajs_testcommon_JSEndpoints$().createMasterRunner$1, this.createRunnerFun__p1__Z__F1(true));
  $m_Lorg_scalajs_testinterface_internal_JSRPC$().attach__Lorg_scalajs_testcommon_RPCEndpoint__F1__V($m_Lorg_scalajs_testcommon_JSEndpoints$().createSlaveRunner$1, this.createRunnerFun__p1__Z__F1(false))
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.cont$1__p1__ALsbt_testing_Task__Lsbt_testing_Runner__s_concurrent_Promise__s_concurrent_Promise = (function(tasks, runner$3, promise$1) {
  try {
    var elems$2 = null;
    elems$2 = [];
    var i = 0;
    var len = tasks.u.length;
    while ((i < len)) {
      var index = i;
      var arg1 = tasks.get(index);
      var x$3 = $as_Lsbt_testing_Task(arg1);
      var elem = $m_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$().detachTask__Lsbt_testing_Task__Lsbt_testing_Runner__Lorg_scalajs_testcommon_TaskInfo(x$3, runner$3);
      var unboxedElem = ((elem === null) ? null : elem);
      elems$2.push(unboxedElem);
      i = ((1 + i) | 0)
    };
    var xs = $makeNativeArrayWrapper($d_Lorg_scalajs_testcommon_TaskInfo.getArrayOf(), elems$2);
    var this$11 = $m_sci_List$();
    var cbf = this$11.ReusableCBFInstance$2;
    var b = cbf.apply__scm_Builder();
    b.sizeHint__I__V(xs.u.length);
    b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs));
    var result = new $c_s_util_Success().init___O($as_sci_List(b.result__O()))
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      matchEnd8: {
        var result;
        var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
        if ((!o11.isEmpty__Z())) {
          var e$3 = $as_jl_Throwable(o11.get__O());
          var result = new $c_s_util_Failure().init___jl_Throwable(e$3);
          break matchEnd8
        };
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
      }
    } else {
      var result;
      throw e
    }
  };
  return $s_s_concurrent_Promise$class__complete__s_concurrent_Promise__s_util_Try__s_concurrent_Promise(promise$1, result)
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.detachRunnerCommands__p1__I__Z__V = (function(runID, isMaster) {
  this.org$scalajs$testinterface$internal$Bridge$$mux$f.detach__Lorg_scalajs_testcommon_Endpoint__I__V($m_Lorg_scalajs_testcommon_JSEndpoints$().tasks$1, runID);
  this.org$scalajs$testinterface$internal$Bridge$$mux$f.detach__Lorg_scalajs_testcommon_Endpoint__I__V($m_Lorg_scalajs_testcommon_JSEndpoints$().execute$1, runID);
  this.org$scalajs$testinterface$internal$Bridge$$mux$f.detach__Lorg_scalajs_testcommon_Endpoint__I__V($m_Lorg_scalajs_testcommon_JSEndpoints$().done$1, runID);
  if (isMaster) {
    this.org$scalajs$testinterface$internal$Bridge$$mux$f.detach__Lorg_scalajs_testcommon_Endpoint__I__V($m_Lorg_scalajs_testcommon_JSEndpoints$().msgMaster$1, runID)
  } else {
    this.org$scalajs$testinterface$internal$Bridge$$mux$f.detach__Lorg_scalajs_testcommon_Endpoint__I__V($m_Lorg_scalajs_testcommon_JSEndpoints$().msgSlave$1, runID)
  }
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.tasksFun__p1__Lsbt_testing_Runner__F1 = (function(runner) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, runner$1) {
    return (function(taskDefs$2) {
      var taskDefs = $as_sci_List(taskDefs$2);
      var len = $s_sc_LinearSeqOptimized$class__length__sc_LinearSeqOptimized__I(taskDefs);
      var result = $newArrayObject($d_Lsbt_testing_TaskDef.getArrayOf(), [len]);
      $s_sc_TraversableOnce$class__copyToArray__sc_TraversableOnce__O__I__V(taskDefs, result, 0);
      var tasks = runner$1.tasks__ALsbt_testing_TaskDef__ALsbt_testing_Task(result);
      var elems$2 = null;
      elems$2 = [];
      var i = 0;
      var len$1 = tasks.u.length;
      while ((i < len$1)) {
        var index = i;
        var arg1 = tasks.get(index);
        var x$1 = $as_Lsbt_testing_Task(arg1);
        var elem = $m_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$().detachTask__Lsbt_testing_Task__Lsbt_testing_Runner__Lorg_scalajs_testcommon_TaskInfo(x$1, runner$1);
        var unboxedElem = ((elem === null) ? null : elem);
        elems$2.push(unboxedElem);
        i = ((1 + i) | 0)
      };
      var xs = $makeNativeArrayWrapper($d_Lorg_scalajs_testcommon_TaskInfo.getArrayOf(), elems$2);
      var this$11 = $m_sci_List$();
      var cbf = this$11.ReusableCBFInstance$2;
      var b = cbf.apply__scm_Builder();
      b.sizeHint__I__V(xs.u.length);
      b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs));
      return $as_sci_List(b.result__O())
    })
  })(this, runner))
});
var $d_Lorg_scalajs_testinterface_internal_Bridge$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_Bridge$: 0
}, false, "org.scalajs.testinterface.internal.Bridge$", {
  Lorg_scalajs_testinterface_internal_Bridge$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_Bridge$.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_Bridge$;
var $n_Lorg_scalajs_testinterface_internal_Bridge$ = (void 0);
function $m_Lorg_scalajs_testinterface_internal_Bridge$() {
  if ((!$n_Lorg_scalajs_testinterface_internal_Bridge$)) {
    $n_Lorg_scalajs_testinterface_internal_Bridge$ = new $c_Lorg_scalajs_testinterface_internal_Bridge$().init___()
  };
  return $n_Lorg_scalajs_testinterface_internal_Bridge$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_FrameworkLoader$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_FrameworkLoader$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_FrameworkLoader$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype = $c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype;
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.frameworkExistsInReflect$1__p1__T__Z = (function(name) {
  var this$1 = $m_sjs_reflect_Reflect$();
  var this$2 = this$1.instantiatableClasses$1.get__O__s_Option(name);
  if ((!this$2.isEmpty__Z())) {
    var arg1 = this$2.get__O();
    var clazz = $as_sjs_reflect_InstantiatableClass(arg1);
    return $d_Lsbt_testing_Framework.getClassOf().isAssignableFrom__jl_Class__Z(clazz.runtimeClass__jl_Class())
  } else {
    return false
  }
});
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.frameworkExists$1__p1__T__Z = (function(name) {
  return (this.frameworkExistsInReflect$1__p1__T__Z(name) || this.frameworkExistsInExportsNamespace$1__p1__T__Z(name))
});
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.detectFrameworkNames__sci_List__sci_List = (function(names) {
  var f = (function($this) {
    return (function(frameworkNames$2) {
      var frameworkNames = $as_sci_List(frameworkNames$2);
      var these = frameworkNames;
      while ((!these.isEmpty__Z())) {
        var arg1 = these.head__O();
        var x$4 = $as_T(arg1);
        if ($this.frameworkExists$1__p1__T__Z(x$4)) {
          return new $c_s_Some().init___O(these.head__O())
        };
        these = $as_sc_LinearSeqOptimized(these.tail__O())
      };
      return $m_s_None$()
    })
  })(this);
  var this$1 = $m_sci_List$();
  var bf = this$1.ReusableCBFInstance$2;
  if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
    if ((names === $m_sci_Nil$())) {
      var jsx$1 = $m_sci_Nil$()
    } else {
      var arg1$1 = names.head__O();
      var h = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$1), $m_sci_Nil$());
      var t = h;
      var rest = $as_sci_List(names.tail__O());
      while ((rest !== $m_sci_Nil$())) {
        var arg1$2 = rest.head__O();
        var nx = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$2), $m_sci_Nil$());
        t.tl$5 = nx;
        t = nx;
        rest = $as_sci_List(rest.tail__O())
      };
      var jsx$1 = h
    }
  } else {
    var b = $s_sc_TraversableLike$class__builder$1__p0__sc_TraversableLike__scg_CanBuildFrom__scm_Builder(names, bf);
    var these$1 = names;
    while ((!these$1.isEmpty__Z())) {
      var arg1$3 = these$1.head__O();
      b.$$plus$eq__O__scm_Builder(f(arg1$3));
      these$1 = $as_sci_List(these$1.tail__O())
    };
    var jsx$1 = b.result__O()
  };
  return $as_sci_List(jsx$1)
});
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.frameworkExistsInExportsNamespace$1__p1__T__Z = (function(name) {
  var exportsNamespace = $env.exportsNamespace;
  var this$3 = new $c_sci_StringOps().init___T(name);
  var xs = $s_sci_StringLike$class__split__sci_StringLike__C__AT(this$3, 46);
  var start = 0;
  var end = xs.u.length;
  var z = exportsNamespace;
  var value$1;
  _foldl: while (true) {
    if ((start !== end)) {
      var temp$start = ((1 + start) | 0);
      var arg1 = z;
      var index = start;
      var arg2 = xs.get(index);
      var part = $as_T(arg2);
      if ((arg1 === (void 0))) {
        var temp$z = (void 0)
      } else {
        var value = arg1[part];
        var temp$z = value
      };
      start = temp$start;
      z = temp$z;
      continue _foldl
    };
    var value$1 = z;
    break
  };
  return (value$1 !== (void 0))
});
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.loadFramework__T__Lsbt_testing_Framework = (function(frameworkName) {
  var this$1 = $m_sjs_reflect_Reflect$();
  var this$2 = this$1.instantiatableClasses$1.get__O__s_Option(frameworkName);
  if (this$2.isEmpty__Z()) {
    var exportsNamespace = $env.exportsNamespace;
    var this$5 = new $c_sci_StringOps().init___T(frameworkName);
    var parts = $s_sci_StringLike$class__split__sci_StringLike__C__AT(this$5, 46);
    var start = 0;
    var end = parts.u.length;
    var z = exportsNamespace;
    var ctor;
    _foldl: while (true) {
      if ((start !== end)) {
        var temp$start = ((1 + start) | 0);
        var arg1 = z;
        var index = start;
        var arg2 = parts.get(index);
        var x$2 = $as_T(arg2);
        var temp$z = arg1[x$2];
        start = temp$start;
        z = temp$z;
        continue _foldl
      };
      var ctor = z;
      break
    };
    return $as_Lsbt_testing_Framework(new ctor())
  } else {
    var arg1$1 = this$2.get__O();
    var clazz = $as_sjs_reflect_InstantiatableClass(arg1$1);
    return $as_Lsbt_testing_Framework(clazz.newInstance__O())
  }
});
var $d_Lorg_scalajs_testinterface_internal_FrameworkLoader$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_FrameworkLoader$: 0
}, false, "org.scalajs.testinterface.internal.FrameworkLoader$", {
  Lorg_scalajs_testinterface_internal_FrameworkLoader$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_FrameworkLoader$;
var $n_Lorg_scalajs_testinterface_internal_FrameworkLoader$ = (void 0);
function $m_Lorg_scalajs_testinterface_internal_FrameworkLoader$() {
  if ((!$n_Lorg_scalajs_testinterface_internal_FrameworkLoader$)) {
    $n_Lorg_scalajs_testinterface_internal_FrameworkLoader$ = new $c_Lorg_scalajs_testinterface_internal_FrameworkLoader$().init___()
  };
  return $n_Lorg_scalajs_testinterface_internal_FrameworkLoader$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype = $c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype;
$c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype.attachTask__Lorg_scalajs_testcommon_TaskInfo__Lsbt_testing_Runner__Lsbt_testing_Task = (function(info, runner) {
  return runner.deserializeTask__T__F1__Lsbt_testing_Task(info.serializedTask$1, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, info$1) {
    return (function(s$2) {
      var s = $as_T(s$2);
      return $this.optDeserializer$1__p1__T__Lorg_scalajs_testcommon_TaskInfo__Lsbt_testing_TaskDef(s, info$1)
    })
  })(this, info)))
});
$c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype.optSerializer$1__p1__Lsbt_testing_TaskDef__Lsbt_testing_Task__T = (function(t, task$1) {
  var x$2 = task$1.taskDef__Lsbt_testing_TaskDef();
  if (((t === null) ? (x$2 === null) : t.equals__O__Z(x$2))) {
    return ""
  } else {
    return $m_Lorg_scalajs_testcommon_Serializer$().serialize__O__Lorg_scalajs_testcommon_Serializer__T(t, $m_Lorg_scalajs_testcommon_Serializer$TaskDefSerializer$())
  }
});
$c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype.detachTask__Lsbt_testing_Task__Lsbt_testing_Runner__Lorg_scalajs_testcommon_TaskInfo = (function(task, runner) {
  var jsx$2 = runner.serializeTask__Lsbt_testing_Task__F1__T(task, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, task$1) {
    return (function(t$2) {
      var t = $as_Lsbt_testing_TaskDef(t$2);
      return $this.optSerializer$1__p1__Lsbt_testing_TaskDef__Lsbt_testing_Task__T(t, task$1)
    })
  })(this, task)));
  var jsx$1 = task.taskDef__Lsbt_testing_TaskDef();
  var xs = task.tags__AT();
  var this$2 = $m_sci_List$();
  var cbf = this$2.ReusableCBFInstance$2;
  var b = cbf.apply__scm_Builder();
  b.sizeHint__I__V(xs.u.length);
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs));
  return new $c_Lorg_scalajs_testcommon_TaskInfo().init___T__Lsbt_testing_TaskDef__sci_List(jsx$2, jsx$1, $as_sci_List(b.result__O()))
});
$c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype.optDeserializer$1__p1__T__Lorg_scalajs_testcommon_TaskInfo__Lsbt_testing_TaskDef = (function(s, info$1) {
  return ((s === "") ? info$1.taskDef$1 : $as_Lsbt_testing_TaskDef($m_Lorg_scalajs_testcommon_Serializer$().deserialize__T__Lorg_scalajs_testcommon_Serializer__O(s, $m_Lorg_scalajs_testcommon_Serializer$TaskDefSerializer$())))
});
var $d_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_TaskInfoBuilder$: 0
}, false, "org.scalajs.testinterface.internal.TaskInfoBuilder$", {
  Lorg_scalajs_testinterface_internal_TaskInfoBuilder$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$;
var $n_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$ = (void 0);
function $m_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$() {
  if ((!$n_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$)) {
    $n_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$ = new $c_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$().init___()
  };
  return $n_Lorg_scalajs_testinterface_internal_TaskInfoBuilder$
}
/** @constructor */
function $c_Lperfolation_CrossDate$() {
  $c_O.call(this);
  this.cache$1 = null
}
$c_Lperfolation_CrossDate$.prototype = new $h_O();
$c_Lperfolation_CrossDate$.prototype.constructor = $c_Lperfolation_CrossDate$;
/** @constructor */
function $h_Lperfolation_CrossDate$() {
  /*<skip>*/
}
$h_Lperfolation_CrossDate$.prototype = $c_Lperfolation_CrossDate$.prototype;
$c_Lperfolation_CrossDate$.prototype.init___ = (function() {
  $n_Lperfolation_CrossDate$ = this;
  this.cache$1 = new $c_jl_ThreadLocal().init___();
  return this
});
$c_Lperfolation_CrossDate$.prototype.apply__J__Lperfolation_CrossDate = (function(l) {
  var x1 = $m_s_Option$().apply__O__s_Option(this.cache$1.get__O());
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var d = $as_Lperfolation_CrossDate(x2.x$2);
    var t = d.milliseconds$1;
    var lo = t.lo$2;
    var hi = t.hi$2;
    if (((lo === l.lo$2) && (hi === l.hi$2))) {
      return d
    }
  };
  var d$2 = $m_Lperfolation_Platform$().createDate__J__Lperfolation_CrossDate(l);
  this.cache$1.set__O__V(d$2);
  return d$2
});
var $d_Lperfolation_CrossDate$ = new $TypeData().initClass({
  Lperfolation_CrossDate$: 0
}, false, "perfolation.CrossDate$", {
  Lperfolation_CrossDate$: 1,
  O: 1
});
$c_Lperfolation_CrossDate$.prototype.$classData = $d_Lperfolation_CrossDate$;
var $n_Lperfolation_CrossDate$ = (void 0);
function $m_Lperfolation_CrossDate$() {
  if ((!$n_Lperfolation_CrossDate$)) {
    $n_Lperfolation_CrossDate$ = new $c_Lperfolation_CrossDate$().init___()
  };
  return $n_Lperfolation_CrossDate$
}
/** @constructor */
function $c_Lperfolation_NumberFormatUtil$() {
  $c_O.call(this)
}
$c_Lperfolation_NumberFormatUtil$.prototype = new $h_O();
$c_Lperfolation_NumberFormatUtil$.prototype.constructor = $c_Lperfolation_NumberFormatUtil$;
/** @constructor */
function $h_Lperfolation_NumberFormatUtil$() {
  /*<skip>*/
}
$h_Lperfolation_NumberFormatUtil$.prototype = $c_Lperfolation_NumberFormatUtil$.prototype;
$c_Lperfolation_NumberFormatUtil$.prototype.init___ = (function() {
  return this
});
$c_Lperfolation_NumberFormatUtil$.prototype.$int__I__I__T = (function(i, digits) {
  var s = ("" + i);
  var padTo = ((digits - $uI(s.length)) | 0);
  if ((padTo <= 0)) {
    return s
  } else if ((padTo === 1)) {
    return ("0" + s)
  } else if ((padTo === 2)) {
    return ("00" + s)
  } else if ((padTo === 3)) {
    return ("000" + s)
  } else if ((padTo === 4)) {
    return ("0000" + s)
  } else if ((padTo === 5)) {
    return ("00000" + s)
  } else if ((padTo === 6)) {
    return ("000000" + s)
  } else if ((padTo === 7)) {
    return ("0000000" + s)
  } else if ((padTo === 8)) {
    return ("00000000" + s)
  } else if ((padTo === 9)) {
    return ("000000000" + s)
  } else {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["intFormat padding not available for ", "!"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([digits]))))
  }
});
var $d_Lperfolation_NumberFormatUtil$ = new $TypeData().initClass({
  Lperfolation_NumberFormatUtil$: 0
}, false, "perfolation.NumberFormatUtil$", {
  Lperfolation_NumberFormatUtil$: 1,
  O: 1
});
$c_Lperfolation_NumberFormatUtil$.prototype.$classData = $d_Lperfolation_NumberFormatUtil$;
var $n_Lperfolation_NumberFormatUtil$ = (void 0);
function $m_Lperfolation_NumberFormatUtil$() {
  if ((!$n_Lperfolation_NumberFormatUtil$)) {
    $n_Lperfolation_NumberFormatUtil$ = new $c_Lperfolation_NumberFormatUtil$().init___()
  };
  return $n_Lperfolation_NumberFormatUtil$
}
/** @constructor */
function $c_Lperfolation_Platform$() {
  $c_O.call(this);
  this.startOfYear$1 = null
}
$c_Lperfolation_Platform$.prototype = new $h_O();
$c_Lperfolation_Platform$.prototype.constructor = $c_Lperfolation_Platform$;
/** @constructor */
function $h_Lperfolation_Platform$() {
  /*<skip>*/
}
$h_Lperfolation_Platform$.prototype = $c_Lperfolation_Platform$.prototype;
$c_Lperfolation_Platform$.prototype.init___ = (function() {
  $n_Lperfolation_Platform$ = this;
  var newLocale = $m_ju_Locale$().US__ju_Locale();
  $m_Llocales_LocaleRegistry$().setDefault__ju_Locale__V(newLocale);
  this.startOfYear$1 = new $g.Date($uI(new $g.Date().getFullYear()), 0, 0);
  return this
});
$c_Lperfolation_Platform$.prototype.createDate__J__Lperfolation_CrossDate = (function(l) {
  return new $c_Lperfolation_JavaScriptCrossDate().init___J__sjs_js_Date(l, new $g.Date($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(l.lo$2, l.hi$2)))
});
var $d_Lperfolation_Platform$ = new $TypeData().initClass({
  Lperfolation_Platform$: 0
}, false, "perfolation.Platform$", {
  Lperfolation_Platform$: 1,
  O: 1
});
$c_Lperfolation_Platform$.prototype.$classData = $d_Lperfolation_Platform$;
var $n_Lperfolation_Platform$ = (void 0);
function $m_Lperfolation_Platform$() {
  if ((!$n_Lperfolation_Platform$)) {
    $n_Lperfolation_Platform$ = new $c_Lperfolation_Platform$().init___()
  };
  return $n_Lperfolation_Platform$
}
/** @constructor */
function $c_Lperfolation_package$() {
  $c_O.call(this);
  this.perfolation$package$$size$f = 0;
  this.pool$1 = null
}
$c_Lperfolation_package$.prototype = new $h_O();
$c_Lperfolation_package$.prototype.constructor = $c_Lperfolation_package$;
/** @constructor */
function $h_Lperfolation_package$() {
  /*<skip>*/
}
$h_Lperfolation_package$.prototype = $c_Lperfolation_package$.prototype;
$c_Lperfolation_package$.prototype.init___ = (function() {
  $n_Lperfolation_package$ = this;
  try {
    var this$3 = new $c_s_sys_SystemProperties().init___();
    var x1 = this$3.get__T__s_Option("perfolation.buffer.size");
    if ($is_s_Some(x1)) {
      var x2 = $as_s_Some(x1);
      var v = x2.x$2;
      var jsx$1 = v
    } else {
      var x = $m_s_None$();
      if ((!(x === x1))) {
        throw new $c_s_MatchError().init___O(x1)
      };
      var jsx$1 = ""
    };
    var x$1 = $as_T(jsx$1);
    var this$5 = new $c_sci_StringOps().init___T(x$1);
    var this$7 = $m_jl_Integer$();
    var $$this = this$5.repr$1;
    var this$8 = new $c_s_util_Success().init___O(this$7.parseInt__T__I__I($$this, 10))
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      matchEnd8: {
        var this$8;
        var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
        if ((!o11.isEmpty__Z())) {
          var e$3 = $as_jl_Throwable(o11.get__O());
          var this$8 = new $c_s_util_Failure().init___jl_Throwable(e$3);
          break matchEnd8
        };
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
      }
    } else {
      var this$8;
      throw e
    }
  };
  this.perfolation$package$$size$f = $uI((this$8.isSuccess__Z() ? this$8.get__O() : 16384));
  this.pool$1 = new $c_Lperfolation_package$$anon$1().init___();
  return this
});
$c_Lperfolation_package$.prototype.stringBuilder__jl_StringBuilder = (function() {
  return $as_jl_StringBuilder(this.pool$1.get__O())
});
var $d_Lperfolation_package$ = new $TypeData().initClass({
  Lperfolation_package$: 0
}, false, "perfolation.package$", {
  Lperfolation_package$: 1,
  O: 1
});
$c_Lperfolation_package$.prototype.$classData = $d_Lperfolation_package$;
var $n_Lperfolation_package$ = (void 0);
function $m_Lperfolation_package$() {
  if ((!$n_Lperfolation_package$)) {
    $n_Lperfolation_package$ = new $c_Lperfolation_package$().init___()
  };
  return $n_Lperfolation_package$
}
/** @constructor */
function $c_Lprofig_Conversions$() {
  $c_O.call(this);
  this.booleanDecoder$1 = null
}
$c_Lprofig_Conversions$.prototype = new $h_O();
$c_Lprofig_Conversions$.prototype.constructor = $c_Lprofig_Conversions$;
/** @constructor */
function $h_Lprofig_Conversions$() {
  /*<skip>*/
}
$h_Lprofig_Conversions$.prototype = $c_Lprofig_Conversions$.prototype;
$c_Lprofig_Conversions$.prototype.init___ = (function() {
  $n_Lprofig_Conversions$ = this;
  this.booleanDecoder$1 = new $c_Lprofig_Conversions$$anon$1().init___();
  return this
});
var $d_Lprofig_Conversions$ = new $TypeData().initClass({
  Lprofig_Conversions$: 0
}, false, "profig.Conversions$", {
  Lprofig_Conversions$: 1,
  O: 1
});
$c_Lprofig_Conversions$.prototype.$classData = $d_Lprofig_Conversions$;
var $n_Lprofig_Conversions$ = (void 0);
function $m_Lprofig_Conversions$() {
  if ((!$n_Lprofig_Conversions$)) {
    $n_Lprofig_Conversions$ = new $c_Lprofig_Conversions$().init___()
  };
  return $n_Lprofig_Conversions$
}
/** @constructor */
function $c_Lprofig_JsonParser$() {
  $c_O.call(this);
  this.overrideParser$1 = null
}
$c_Lprofig_JsonParser$.prototype = new $h_O();
$c_Lprofig_JsonParser$.prototype.constructor = $c_Lprofig_JsonParser$;
/** @constructor */
function $h_Lprofig_JsonParser$() {
  /*<skip>*/
}
$h_Lprofig_JsonParser$.prototype = $c_Lprofig_JsonParser$.prototype;
$c_Lprofig_JsonParser$.prototype.init___ = (function() {
  $n_Lprofig_JsonParser$ = this;
  this.overrideParser$1 = $m_s_None$();
  return this
});
$c_Lprofig_JsonParser$.prototype.parse__T__s_util_Either = (function(jsonString) {
  var x1 = this.overrideParser$1;
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var parser = $as_F1(x2.x$2);
    return $as_s_util_Either(parser.apply__O__O(jsonString))
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var x1$2 = $m_Lio_circe_parser_package$().parse__T__s_util_Either(jsonString);
      if ($is_s_util_Left(x1$2)) {
        var x2$2 = $as_s_util_Left(x1$2);
        var exc = $as_Lio_circe_ParsingFailure(x2$2.a$2);
        if ((exc.message$4 === "an implementation is missing")) {
          new $c_Lio_circe_jawn_JawnParser().init___();
          $m_s_Predef$().$$qmark$qmark$qmark__sr_Nothing$()
        }
      };
      return x1$2
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
var $d_Lprofig_JsonParser$ = new $TypeData().initClass({
  Lprofig_JsonParser$: 0
}, false, "profig.JsonParser$", {
  Lprofig_JsonParser$: 1,
  O: 1
});
$c_Lprofig_JsonParser$.prototype.$classData = $d_Lprofig_JsonParser$;
var $n_Lprofig_JsonParser$ = (void 0);
function $m_Lprofig_JsonParser$() {
  if ((!$n_Lprofig_JsonParser$)) {
    $n_Lprofig_JsonParser$ = new $c_Lprofig_JsonParser$().init___()
  };
  return $n_Lprofig_JsonParser$
}
/** @constructor */
function $c_Lprofig_ProfigUtil$() {
  $c_O.call(this);
  this.profig$ProfigUtil$$NamedKeyValue$1 = null;
  this.profig$ProfigUtil$$NamedFlag$1 = null
}
$c_Lprofig_ProfigUtil$.prototype = new $h_O();
$c_Lprofig_ProfigUtil$.prototype.constructor = $c_Lprofig_ProfigUtil$;
/** @constructor */
function $h_Lprofig_ProfigUtil$() {
  /*<skip>*/
}
$h_Lprofig_ProfigUtil$.prototype = $c_Lprofig_ProfigUtil$.prototype;
$c_Lprofig_ProfigUtil$.prototype.init___ = (function() {
  $n_Lprofig_ProfigUtil$ = this;
  var this$2 = new $c_sci_StringOps().init___T("-{1,}(.+)=(.+)");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  this.profig$ProfigUtil$$NamedKeyValue$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames);
  var this$5 = new $c_sci_StringOps().init___T("-{1,}(.+)");
  var groupNames$1 = $m_sci_Nil$();
  var $$this$1 = this$5.repr$1;
  this.profig$ProfigUtil$$NamedFlag$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$1, groupNames$1);
  return this
});
$c_Lprofig_ProfigUtil$.prototype.map2Json__sci_Map__Lio_circe_Json = (function(map) {
  var this$1 = $m_Lio_circe_Json$();
  var fields = $m_sci_Nil$();
  var elem = this$1.fromFields__sc_Iterable__Lio_circe_Json(fields);
  var json = new $c_sr_ObjectRef().init___O(elem);
  map.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(json$1) {
    return (function(x0$1$2) {
      var x0$1 = $as_T2(x0$1$2);
      if ((x0$1 !== null)) {
        var key = $as_T(x0$1.$$und1__O());
        var value = $as_T(x0$1.$$und2__O());
        json$1.elem$1 = $as_Lio_circe_Json(json$1.elem$1).deepMerge__Lio_circe_Json__Lio_circe_Json($m_Lprofig_ProfigUtil$().createJson__T__Lio_circe_Json__Lio_circe_Json(key, ($m_Lprofig_ProfigUtil$(), $m_Lio_circe_Json$(), new $c_Lio_circe_Json$JString().init___T(value))))
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })(json)));
  return $as_Lio_circe_Json(json.elem$1)
});
$c_Lprofig_ProfigUtil$.prototype.properties2Json__ju_Properties__Lio_circe_Json = (function(properties) {
  var this$1 = $m_sc_JavaConverters$();
  var jsx$2 = $as_sc_TraversableLike($s_sc_convert_DecorateAsScala$class__propertiesAsScalaMapConverter__sc_convert_DecorateAsScala__ju_Properties__sc_convert_Decorators$AsScala(this$1, properties).asScala__O());
  var jsx$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(x0$2$2) {
    var x0$2 = $as_T2(x0$2$2);
    if ((x0$2 !== null)) {
      var key = $as_T(x0$2.$$und1__O());
      var value = $as_T(x0$2.$$und2__O());
      return new $c_T2().init___O__O(key, value)
    } else {
      throw new $c_s_MatchError().init___O(x0$2)
    }
  }));
  var this$4 = $m_scm_Map$();
  var map = $as_sc_TraversableOnce(jsx$2.map__F1__scg_CanBuildFrom__O(jsx$1, new $c_scg_GenMapFactory$MapCanBuildFrom().init___scg_GenMapFactory(this$4))).toMap__s_Predef$$less$colon$less__sci_Map($m_s_Predef$().singleton$und$less$colon$less$2);
  return this.map2Json__sci_Map__Lio_circe_Json(map)
});
$c_Lprofig_ProfigUtil$.prototype.createJson__T__Lio_circe_Json__Lio_circe_Json = (function(name, value) {
  var index = $m_sjsr_RuntimeString$().indexOf__T__I__I(name, 46);
  if ((index === (-1))) {
    var this$3 = $m_Lio_circe_Json$();
    var fields = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_T2().init___O__O(name, value)]);
    return this$3.fromFields__sc_Iterable__Lio_circe_Json(fields)
  } else {
    var n = $as_T(name.substring(0, index));
    var this$10 = $m_Lio_circe_Json$();
    var beginIndex = ((1 + index) | 0);
    var y = this.createJson__T__Lio_circe_Json__Lio_circe_Json($as_T(name.substring(beginIndex)), value);
    var fields$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array([new $c_T2().init___O__O(n, y)]);
    return this$10.fromFields__sc_Iterable__Lio_circe_Json(fields$1)
  }
});
var $d_Lprofig_ProfigUtil$ = new $TypeData().initClass({
  Lprofig_ProfigUtil$: 0
}, false, "profig.ProfigUtil$", {
  Lprofig_ProfigUtil$: 1,
  O: 1
});
$c_Lprofig_ProfigUtil$.prototype.$classData = $d_Lprofig_ProfigUtil$;
var $n_Lprofig_ProfigUtil$ = (void 0);
function $m_Lprofig_ProfigUtil$() {
  if ((!$n_Lprofig_ProfigUtil$)) {
    $n_Lprofig_ProfigUtil$ = new $c_Lprofig_ProfigUtil$().init___()
  };
  return $n_Lprofig_ProfigUtil$
}
/** @constructor */
function $c_Lreactify_Priority$() {
  $c_O.call(this);
  this.Lowest$1 = 0.0;
  this.Low$1 = 0.0;
  this.Normal$1 = 0.0;
  this.High$1 = 0.0;
  this.Highest$1 = 0.0
}
$c_Lreactify_Priority$.prototype = new $h_O();
$c_Lreactify_Priority$.prototype.constructor = $c_Lreactify_Priority$;
/** @constructor */
function $h_Lreactify_Priority$() {
  /*<skip>*/
}
$h_Lreactify_Priority$.prototype = $c_Lreactify_Priority$.prototype;
$c_Lreactify_Priority$.prototype.init___ = (function() {
  $n_Lreactify_Priority$ = this;
  this.Lowest$1 = $m_s_Double$().MinValue$1;
  this.Low$1 = (-100.0);
  this.Normal$1 = 0.0;
  this.High$1 = 100.0;
  this.Highest$1 = 1.7976931348623157E308;
  return this
});
var $d_Lreactify_Priority$ = new $TypeData().initClass({
  Lreactify_Priority$: 0
}, false, "reactify.Priority$", {
  Lreactify_Priority$: 1,
  O: 1
});
$c_Lreactify_Priority$.prototype.$classData = $d_Lreactify_Priority$;
var $n_Lreactify_Priority$ = (void 0);
function $m_Lreactify_Priority$() {
  if ((!$n_Lreactify_Priority$)) {
    $n_Lreactify_Priority$ = new $c_Lreactify_Priority$().init___()
  };
  return $n_Lreactify_Priority$
}
/** @constructor */
function $c_Lreactify_Reactive$() {
  $c_O.call(this)
}
$c_Lreactify_Reactive$.prototype = new $h_O();
$c_Lreactify_Reactive$.prototype.constructor = $c_Lreactify_Reactive$;
/** @constructor */
function $h_Lreactify_Reactive$() {
  /*<skip>*/
}
$h_Lreactify_Reactive$.prototype = $c_Lreactify_Reactive$.prototype;
$c_Lreactify_Reactive$.prototype.init___ = (function() {
  return this
});
$c_Lreactify_Reactive$.prototype.fire__Lreactify_Reactive__O__s_Option__V = (function(reactive, value, previous) {
  var this$1 = reactive.reactions__Lreactify_reaction_Reactions();
  var reactions = this$1.list$1;
  $s_Lreactify_Reactive$class__fire__Lreactify_Reactive__O__s_Option__sci_List__Lreactify_reaction_ReactionStatus(reactive, value, previous, reactions)
});
var $d_Lreactify_Reactive$ = new $TypeData().initClass({
  Lreactify_Reactive$: 0
}, false, "reactify.Reactive$", {
  Lreactify_Reactive$: 1,
  O: 1
});
$c_Lreactify_Reactive$.prototype.$classData = $d_Lreactify_Reactive$;
var $n_Lreactify_Reactive$ = (void 0);
function $m_Lreactify_Reactive$() {
  if ((!$n_Lreactify_Reactive$)) {
    $n_Lreactify_Reactive$ = new $c_Lreactify_Reactive$().init___()
  };
  return $n_Lreactify_Reactive$
}
/** @constructor */
function $c_Lreactify_StateCounter() {
  $c_O.call(this);
  this.references$1 = null
}
$c_Lreactify_StateCounter.prototype = new $h_O();
$c_Lreactify_StateCounter.prototype.constructor = $c_Lreactify_StateCounter;
/** @constructor */
function $h_Lreactify_StateCounter() {
  /*<skip>*/
}
$h_Lreactify_StateCounter.prototype = $c_Lreactify_StateCounter.prototype;
$c_Lreactify_StateCounter.prototype.init___ = (function() {
  this.references$1 = $m_sci_Nil$();
  return this
});
function $is_Lreactify_StateCounter(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_StateCounter)))
}
function $as_Lreactify_StateCounter(obj) {
  return (($is_Lreactify_StateCounter(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.StateCounter"))
}
function $isArrayOf_Lreactify_StateCounter(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_StateCounter)))
}
function $asArrayOf_Lreactify_StateCounter(obj, depth) {
  return (($isArrayOf_Lreactify_StateCounter(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.StateCounter;", depth))
}
var $d_Lreactify_StateCounter = new $TypeData().initClass({
  Lreactify_StateCounter: 0
}, false, "reactify.StateCounter", {
  Lreactify_StateCounter: 1,
  O: 1
});
$c_Lreactify_StateCounter.prototype.$classData = $d_Lreactify_StateCounter;
/** @constructor */
function $c_Lreactify_StateCounter$() {
  $c_O.call(this);
  this.instance$1 = null
}
$c_Lreactify_StateCounter$.prototype = new $h_O();
$c_Lreactify_StateCounter$.prototype.constructor = $c_Lreactify_StateCounter$;
/** @constructor */
function $h_Lreactify_StateCounter$() {
  /*<skip>*/
}
$h_Lreactify_StateCounter$.prototype = $c_Lreactify_StateCounter$.prototype;
$c_Lreactify_StateCounter$.prototype.init___ = (function() {
  $n_Lreactify_StateCounter$ = this;
  this.instance$1 = new $c_Lreactify_StateCounter$$anon$1().init___();
  return this
});
$c_Lreactify_StateCounter$.prototype.referenced__Lreactify_State__V = (function(state) {
  var this$1 = $as_s_Option(this.instance$1.get__O());
  if ((!this$1.isEmpty__Z())) {
    var arg1 = this$1.get__O();
    var counter = $as_Lreactify_StateCounter(arg1);
    var this$2 = counter.references$1;
    counter.references$1 = new $c_sci_$colon$colon().init___O__sci_List(state, this$2)
  }
});
var $d_Lreactify_StateCounter$ = new $TypeData().initClass({
  Lreactify_StateCounter$: 0
}, false, "reactify.StateCounter$", {
  Lreactify_StateCounter$: 1,
  O: 1
});
$c_Lreactify_StateCounter$.prototype.$classData = $d_Lreactify_StateCounter$;
var $n_Lreactify_StateCounter$ = (void 0);
function $m_Lreactify_StateCounter$() {
  if ((!$n_Lreactify_StateCounter$)) {
    $n_Lreactify_StateCounter$ = new $c_Lreactify_StateCounter$().init___()
  };
  return $n_Lreactify_StateCounter$
}
function $is_Lreactify_Val(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_Val)))
}
function $as_Lreactify_Val(obj) {
  return (($is_Lreactify_Val(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.Val"))
}
function $isArrayOf_Lreactify_Val(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_Val)))
}
function $asArrayOf_Lreactify_Val(obj, depth) {
  return (($isArrayOf_Lreactify_Val(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.Val;", depth))
}
/** @constructor */
function $c_Lreactify_package$VectorVar() {
  $c_O.call(this);
  this.reactify$VectorVar$$v$f = null
}
$c_Lreactify_package$VectorVar.prototype = new $h_O();
$c_Lreactify_package$VectorVar.prototype.constructor = $c_Lreactify_package$VectorVar;
/** @constructor */
function $h_Lreactify_package$VectorVar() {
  /*<skip>*/
}
$h_Lreactify_package$VectorVar.prototype = $c_Lreactify_package$VectorVar.prototype;
$c_Lreactify_package$VectorVar.prototype.init___Lreactify_Var = (function(v) {
  this.reactify$VectorVar$$v$f = v;
  return this
});
$c_Lreactify_package$VectorVar.prototype.$$plus$plus$eq__sc_Seq__V = (function(seq) {
  var this$3 = this.reactify$VectorVar$$v$f;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer, seq$2) {
    return (function() {
      var this$1 = arg$outer.reactify$VectorVar$$v$f;
      return $as_sci_Vector($as_sci_Vector(this$1.state__Lreactify_State().value__O()).$$plus$plus__sc_GenTraversableOnce__scg_CanBuildFrom__O(seq$2, ($m_sci_Vector$(), $m_sc_IndexedSeq$().ReusableCBF$6)))
    })
  })(this, seq));
  this$3.set__F0__V(value)
});
$c_Lreactify_package$VectorVar.prototype.$$plus$eq__O__V = (function(t) {
  var this$3 = this.reactify$VectorVar$$v$f;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(arg$outer, t$3) {
    return (function() {
      var this$1 = arg$outer.reactify$VectorVar$$v$f;
      return $as_sci_Vector($as_sci_Vector(this$1.state__Lreactify_State().value__O()).$$colon$plus__O__scg_CanBuildFrom__O(t$3, ($m_sci_Vector$(), $m_sc_IndexedSeq$().ReusableCBF$6)))
    })
  })(this, t));
  this$3.set__F0__V(value)
});
var $d_Lreactify_package$VectorVar = new $TypeData().initClass({
  Lreactify_package$VectorVar: 0
}, false, "reactify.package$VectorVar", {
  Lreactify_package$VectorVar: 1,
  O: 1
});
$c_Lreactify_package$VectorVar.prototype.$classData = $d_Lreactify_package$VectorVar;
function $is_Lreactify_transaction_Transaction(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_transaction_Transaction)))
}
function $as_Lreactify_transaction_Transaction(obj) {
  return (($is_Lreactify_transaction_Transaction(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.transaction.Transaction"))
}
function $isArrayOf_Lreactify_transaction_Transaction(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_transaction_Transaction)))
}
function $asArrayOf_Lreactify_transaction_Transaction(obj, depth) {
  return (($isArrayOf_Lreactify_transaction_Transaction(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.transaction.Transaction;", depth))
}
/** @constructor */
function $c_Lreactify_transaction_Transaction$() {
  $c_O.call(this);
  this.reactify$transaction$Transaction$$threadLocal$1 = null
}
$c_Lreactify_transaction_Transaction$.prototype = new $h_O();
$c_Lreactify_transaction_Transaction$.prototype.constructor = $c_Lreactify_transaction_Transaction$;
/** @constructor */
function $h_Lreactify_transaction_Transaction$() {
  /*<skip>*/
}
$h_Lreactify_transaction_Transaction$.prototype = $c_Lreactify_transaction_Transaction$.prototype;
$c_Lreactify_transaction_Transaction$.prototype.init___ = (function() {
  $n_Lreactify_transaction_Transaction$ = this;
  this.reactify$transaction$Transaction$$threadLocal$1 = new $c_Lreactify_transaction_Transaction$$anon$1().init___();
  return this
});
$c_Lreactify_transaction_Transaction$.prototype.change__Lreactify_Var__F0__F0__V = (function(owner, oldFunction, newFunction) {
  var this$1 = $as_s_Option(this.reactify$transaction$Transaction$$threadLocal$1.get__O());
  if ((!this$1.isEmpty__Z())) {
    var arg1 = this$1.get__O();
    var x$1 = $as_Lreactify_transaction_Transaction(arg1);
    x$1.change__Lreactify_Var__F0__F0__V(owner, oldFunction, newFunction)
  }
});
var $d_Lreactify_transaction_Transaction$ = new $TypeData().initClass({
  Lreactify_transaction_Transaction$: 0
}, false, "reactify.transaction.Transaction$", {
  Lreactify_transaction_Transaction$: 1,
  O: 1
});
$c_Lreactify_transaction_Transaction$.prototype.$classData = $d_Lreactify_transaction_Transaction$;
var $n_Lreactify_transaction_Transaction$ = (void 0);
function $m_Lreactify_transaction_Transaction$() {
  if ((!$n_Lreactify_transaction_Transaction$)) {
    $n_Lreactify_transaction_Transaction$ = new $c_Lreactify_transaction_Transaction$().init___()
  };
  return $n_Lreactify_transaction_Transaction$
}
function $is_Lsbt_testing_AnnotatedFingerprint(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_AnnotatedFingerprint)))
}
function $as_Lsbt_testing_AnnotatedFingerprint(obj) {
  return (($is_Lsbt_testing_AnnotatedFingerprint(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.AnnotatedFingerprint"))
}
function $isArrayOf_Lsbt_testing_AnnotatedFingerprint(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_AnnotatedFingerprint)))
}
function $asArrayOf_Lsbt_testing_AnnotatedFingerprint(obj, depth) {
  return (($isArrayOf_Lsbt_testing_AnnotatedFingerprint(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.AnnotatedFingerprint;", depth))
}
/** @constructor */
function $c_Lsbt_testing_Selector() {
  $c_O.call(this)
}
$c_Lsbt_testing_Selector.prototype = new $h_O();
$c_Lsbt_testing_Selector.prototype.constructor = $c_Lsbt_testing_Selector;
/** @constructor */
function $h_Lsbt_testing_Selector() {
  /*<skip>*/
}
$h_Lsbt_testing_Selector.prototype = $c_Lsbt_testing_Selector.prototype;
function $is_Lsbt_testing_Selector(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_Selector)))
}
function $as_Lsbt_testing_Selector(obj) {
  return (($is_Lsbt_testing_Selector(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.Selector"))
}
function $isA