(function(){
'use strict';
/* Scala.js runtime support
 * Copyright 2013 LAMP/EPFL
 * Author: Sébastien Doeraene
 */

/* ---------------------------------- *
 * The top-level Scala.js environment *
 * ---------------------------------- */





// Get the environment info
var $env = (typeof __ScalaJSEnv === "object" && __ScalaJSEnv) ? __ScalaJSEnv : {};

// Global scope
var $g =
  (typeof $env["global"] === "object" && $env["global"])
    ? $env["global"]
    : ((typeof global === "object" && global && global["Object"] === Object) ? global : this);
$env["global"] = $g;

// Where to send exports



var $e =
  (typeof $env["exportsNamespace"] === "object" && $env["exportsNamespace"])
    ? $env["exportsNamespace"] : $g;

$env["exportsNamespace"] = $e;

// Freeze the environment info
$g["Object"]["freeze"]($env);

// Linking info - must be in sync with scala.scalajs.runtime.LinkingInfo
var $linkingInfo = {
  "envInfo": $env,
  "semantics": {




    "asInstanceOfs": 1,








    "arrayIndexOutOfBounds": 1,










    "moduleInit": 2,





    "strictFloats": false,




    "productionMode": false

  },



  "assumingES6": false,

  "linkerVersion": "0.6.16"
};
$g["Object"]["freeze"]($linkingInfo);
$g["Object"]["freeze"]($linkingInfo["semantics"]);

// Snapshots of builtins and polyfills






var $imul = $g["Math"]["imul"] || (function(a, b) {
  // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/imul
  var ah = (a >>> 16) & 0xffff;
  var al = a & 0xffff;
  var bh = (b >>> 16) & 0xffff;
  var bl = b & 0xffff;
  // the shift by 0 fixes the sign on the high part
  // the final |0 converts the unsigned value into a signed value
  return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0) | 0);
});

var $fround = $g["Math"]["fround"] ||









  (function(v) {
    return +v;
  });


var $clz32 = $g["Math"]["clz32"] || (function(i) {
  // See Hacker's Delight, Section 5-3
  if (i === 0) return 32;
  var r = 1;
  if ((i & 0xffff0000) === 0) { i <<= 16; r += 16; };
  if ((i & 0xff000000) === 0) { i <<= 8; r += 8; };
  if ((i & 0xf0000000) === 0) { i <<= 4; r += 4; };
  if ((i & 0xc0000000) === 0) { i <<= 2; r += 2; };
  return r + (i >> 31);
});


// Other fields




















var $lastIDHash = 0; // last value attributed to an id hash code



var $idHashCodeMap = $g["WeakMap"] ? new $g["WeakMap"]() : null;



// Core mechanism

var $makeIsArrayOfPrimitive = function(primitiveData) {
  return function(obj, depth) {
    return !!(obj && obj.$classData &&
      (obj.$classData.arrayDepth === depth) &&
      (obj.$classData.arrayBase === primitiveData));
  }
};


var $makeAsArrayOfPrimitive = function(isInstanceOfFunction, arrayEncodedName) {
  return function(obj, depth) {
    if (isInstanceOfFunction(obj, depth) || (obj === null))
      return obj;
    else
      $throwArrayCastException(obj, arrayEncodedName, depth);
  }
};


/** Encode a property name for runtime manipulation
  *  Usage:
  *    env.propertyName({someProp:0})
  *  Returns:
  *    "someProp"
  *  Useful when the property is renamed by a global optimizer (like Closure)
  *  but we must still get hold of a string of that name for runtime
  * reflection.
  */
var $propertyName = function(obj) {
  for (var prop in obj)
    return prop;
};

// Runtime functions

var $isScalaJSObject = function(obj) {
  return !!(obj && obj.$classData);
};


var $throwClassCastException = function(instance, classFullName) {




  throw new $c_sjsr_UndefinedBehaviorError().init___jl_Throwable(
    new $c_jl_ClassCastException().init___T(
      instance + " is not an instance of " + classFullName));

};

var $throwArrayCastException = function(instance, classArrayEncodedName, depth) {
  for (; depth; --depth)
    classArrayEncodedName = "[" + classArrayEncodedName;
  $throwClassCastException(instance, classArrayEncodedName);
};



var $throwArrayIndexOutOfBoundsException = function(i) {
  var msg = (i === null) ? null : ("" + i);



  throw new $c_sjsr_UndefinedBehaviorError().init___jl_Throwable(
    new $c_jl_ArrayIndexOutOfBoundsException().init___T(msg));

};


var $noIsInstance = function(instance) {
  throw new $g["TypeError"](
    "Cannot call isInstance() on a Class representing a raw JS trait/object");
};

var $makeNativeArrayWrapper = function(arrayClassData, nativeArray) {
  return new arrayClassData.constr(nativeArray);
};

var $newArrayObject = function(arrayClassData, lengths) {
  return $newArrayObjectInternal(arrayClassData, lengths, 0);
};

var $newArrayObjectInternal = function(arrayClassData, lengths, lengthIndex) {
  var result = new arrayClassData.constr(lengths[lengthIndex]);

  if (lengthIndex < lengths.length-1) {
    var subArrayClassData = arrayClassData.componentData;
    var subLengthIndex = lengthIndex+1;
    var underlying = result.u;
    for (var i = 0; i < underlying.length; i++) {
      underlying[i] = $newArrayObjectInternal(
        subArrayClassData, lengths, subLengthIndex);
    }
  }

  return result;
};

var $objectToString = function(instance) {
  if (instance === void 0)
    return "undefined";
  else
    return instance.toString();
};

var $objectGetClass = function(instance) {
  switch (typeof instance) {
    case "string":
      return $d_T.getClassOf();
    case "number": {
      var v = instance | 0;
      if (v === instance) { // is the value integral?
        if ($isByte(v))
          return $d_jl_Byte.getClassOf();
        else if ($isShort(v))
          return $d_jl_Short.getClassOf();
        else
          return $d_jl_Integer.getClassOf();
      } else {
        if ($isFloat(instance))
          return $d_jl_Float.getClassOf();
        else
          return $d_jl_Double.getClassOf();
      }
    }
    case "boolean":
      return $d_jl_Boolean.getClassOf();
    case "undefined":
      return $d_sr_BoxedUnit.getClassOf();
    default:
      if (instance === null)
        return instance.getClass__jl_Class();
      else if ($is_sjsr_RuntimeLong(instance))
        return $d_jl_Long.getClassOf();
      else if ($isScalaJSObject(instance))
        return instance.$classData.getClassOf();
      else
        return null; // Exception?
  }
};

var $objectClone = function(instance) {
  if ($isScalaJSObject(instance) || (instance === null))
    return instance.clone__O();
  else
    throw new $c_jl_CloneNotSupportedException().init___();
};

var $objectNotify = function(instance) {
  // final and no-op in java.lang.Object
  if (instance === null)
    instance.notify__V();
};

var $objectNotifyAll = function(instance) {
  // final and no-op in java.lang.Object
  if (instance === null)
    instance.notifyAll__V();
};

var $objectFinalize = function(instance) {
  if ($isScalaJSObject(instance) || (instance === null))
    instance.finalize__V();
  // else no-op
};

var $objectEquals = function(instance, rhs) {
  if ($isScalaJSObject(instance) || (instance === null))
    return instance.equals__O__Z(rhs);
  else if (typeof instance === "number")
    return typeof rhs === "number" && $numberEquals(instance, rhs);
  else
    return instance === rhs;
};

var $numberEquals = function(lhs, rhs) {
  return (lhs === rhs) ? (
    // 0.0.equals(-0.0) must be false
    lhs !== 0 || 1/lhs === 1/rhs
  ) : (
    // are they both NaN?
    (lhs !== lhs) && (rhs !== rhs)
  );
};

var $objectHashCode = function(instance) {
  switch (typeof instance) {
    case "string":
      return $m_sjsr_RuntimeString$().hashCode__T__I(instance);
    case "number":
      return $m_sjsr_Bits$().numberHashCode__D__I(instance);
    case "boolean":
      return instance ? 1231 : 1237;
    case "undefined":
      return 0;
    default:
      if ($isScalaJSObject(instance) || instance === null)
        return instance.hashCode__I();

      else if ($idHashCodeMap === null)
        return 42;

      else
        return $systemIdentityHashCode(instance);
  }
};

var $comparableCompareTo = function(instance, rhs) {
  switch (typeof instance) {
    case "string":

      $as_T(rhs);

      return instance === rhs ? 0 : (instance < rhs ? -1 : 1);
    case "number":

      $as_jl_Number(rhs);

      return $m_jl_Double$().compare__D__D__I(instance, rhs);
    case "boolean":

      $asBoolean(rhs);

      return instance - rhs; // yes, this gives the right result
    default:
      return instance.compareTo__O__I(rhs);
  }
};

var $charSequenceLength = function(instance) {
  if (typeof(instance) === "string")

    return $uI(instance["length"]);



  else
    return instance.length__I();
};

var $charSequenceCharAt = function(instance, index) {
  if (typeof(instance) === "string")

    return $uI(instance["charCodeAt"](index)) & 0xffff;



  else
    return instance.charAt__I__C(index);
};

var $charSequenceSubSequence = function(instance, start, end) {
  if (typeof(instance) === "string")

    return $as_T(instance["substring"](start, end));



  else
    return instance.subSequence__I__I__jl_CharSequence(start, end);
};

var $booleanBooleanValue = function(instance) {
  if (typeof instance === "boolean") return instance;
  else                               return instance.booleanValue__Z();
};

var $numberByteValue = function(instance) {
  if (typeof instance === "number") return (instance << 24) >> 24;
  else                              return instance.byteValue__B();
};
var $numberShortValue = function(instance) {
  if (typeof instance === "number") return (instance << 16) >> 16;
  else                              return instance.shortValue__S();
};
var $numberIntValue = function(instance) {
  if (typeof instance === "number") return instance | 0;
  else                              return instance.intValue__I();
};
var $numberLongValue = function(instance) {
  if (typeof instance === "number")
    return $m_sjsr_RuntimeLong$().fromDouble__D__sjsr_RuntimeLong(instance);
  else
    return instance.longValue__J();
};
var $numberFloatValue = function(instance) {
  if (typeof instance === "number") return $fround(instance);
  else                              return instance.floatValue__F();
};
var $numberDoubleValue = function(instance) {
  if (typeof instance === "number") return instance;
  else                              return instance.doubleValue__D();
};

var $isNaN = function(instance) {
  return instance !== instance;
};

var $isInfinite = function(instance) {
  return !$g["isFinite"](instance) && !$isNaN(instance);
};

var $doubleToInt = function(x) {
  return (x > 2147483647) ? (2147483647) : ((x < -2147483648) ? -2147483648 : (x | 0));
};

/** Instantiates a JS object with variadic arguments to the constructor. */
var $newJSObjectWithVarargs = function(ctor, args) {
  // This basically emulates the ECMAScript specification for 'new'.
  var instance = $g["Object"]["create"](ctor.prototype);
  var result = ctor["apply"](instance, args);
  switch (typeof result) {
    case "string": case "number": case "boolean": case "undefined": case "symbol":
      return instance;
    default:
      return result === null ? instance : result;
  }
};

var $resolveSuperRef = function(initialProto, propName) {
  var getPrototypeOf = $g["Object"]["getPrototypeOf"];
  var getOwnPropertyDescriptor = $g["Object"]["getOwnPropertyDescriptor"];

  var superProto = getPrototypeOf(initialProto);
  while (superProto !== null) {
    var desc = getOwnPropertyDescriptor(superProto, propName);
    if (desc !== void 0)
      return desc;
    superProto = getPrototypeOf(superProto);
  }

  return void 0;
};

var $superGet = function(initialProto, self, propName) {
  var desc = $resolveSuperRef(initialProto, propName);
  if (desc !== void 0) {
    var getter = desc["get"];
    if (getter !== void 0)
      return getter["call"](self);
    else
      return desc["value"];
  }
  return void 0;
};

var $superSet = function(initialProto, self, propName, value) {
  var desc = $resolveSuperRef(initialProto, propName);
  if (desc !== void 0) {
    var setter = desc["set"];
    if (setter !== void 0) {
      setter["call"](self, value);
      return void 0;
    }
  }
  throw new $g["TypeError"]("super has no setter '" + propName + "'.");
};







var $propertiesOf = function(obj) {
  var result = [];
  for (var prop in obj)
    result["push"](prop);
  return result;
};

var $systemArraycopy = function(src, srcPos, dest, destPos, length) {
  var srcu = src.u;
  var destu = dest.u;


  if (srcPos < 0 || destPos < 0 || length < 0 ||
      (srcPos > ((srcu.length - length) | 0)) ||
      (destPos > ((destu.length - length) | 0))) {
    $throwArrayIndexOutOfBoundsException(null);
  }


  if (srcu !== destu || destPos < srcPos || (((srcPos + length) | 0) < destPos)) {
    for (var i = 0; i < length; i = (i + 1) | 0)
      destu[(destPos + i) | 0] = srcu[(srcPos + i) | 0];
  } else {
    for (var i = (length - 1) | 0; i >= 0; i = (i - 1) | 0)
      destu[(destPos + i) | 0] = srcu[(srcPos + i) | 0];
  }
};

var $systemIdentityHashCode =

  ($idHashCodeMap !== null) ?

  (function(obj) {
    switch (typeof obj) {
      case "string": case "number": case "boolean": case "undefined":
        return $objectHashCode(obj);
      default:
        if (obj === null) {
          return 0;
        } else {
          var hash = $idHashCodeMap["get"](obj);
          if (hash === void 0) {
            hash = ($lastIDHash + 1) | 0;
            $lastIDHash = hash;
            $idHashCodeMap["set"](obj, hash);
          }
          return hash;
        }
    }

  }) :
  (function(obj) {
    if ($isScalaJSObject(obj)) {
      var hash = obj["$idHashCode$0"];
      if (hash !== void 0) {
        return hash;
      } else if (!$g["Object"]["isSealed"](obj)) {
        hash = ($lastIDHash + 1) | 0;
        $lastIDHash = hash;
        obj["$idHashCode$0"] = hash;
        return hash;
      } else {
        return 42;
      }
    } else if (obj === null) {
      return 0;
    } else {
      return $objectHashCode(obj);
    }

  });

// is/as for hijacked boxed classes (the non-trivial ones)

var $isByte = function(v) {
  return (v << 24 >> 24) === v && 1/v !== 1/-0;
};

var $isShort = function(v) {
  return (v << 16 >> 16) === v && 1/v !== 1/-0;
};

var $isInt = function(v) {
  return (v | 0) === v && 1/v !== 1/-0;
};

var $isFloat = function(v) {



  return typeof v === "number";

};


var $asUnit = function(v) {
  if (v === void 0 || v === null)
    return v;
  else
    $throwClassCastException(v, "scala.runtime.BoxedUnit");
};

var $asBoolean = function(v) {
  if (typeof v === "boolean" || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Boolean");
};

var $asByte = function(v) {
  if ($isByte(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Byte");
};

var $asShort = function(v) {
  if ($isShort(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Short");
};

var $asInt = function(v) {
  if ($isInt(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Integer");
};

var $asFloat = function(v) {
  if ($isFloat(v) || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Float");
};

var $asDouble = function(v) {
  if (typeof v === "number" || v === null)
    return v;
  else
    $throwClassCastException(v, "java.lang.Double");
};


// Unboxes


var $uZ = function(value) {
  return !!$asBoolean(value);
};
var $uB = function(value) {
  return $asByte(value) | 0;
};
var $uS = function(value) {
  return $asShort(value) | 0;
};
var $uI = function(value) {
  return $asInt(value) | 0;
};
var $uJ = function(value) {
  return null === value ? $m_sjsr_RuntimeLong$().Zero$1
                        : $as_sjsr_RuntimeLong(value);
};
var $uF = function(value) {
  /* Here, it is fine to use + instead of fround, because asFloat already
   * ensures that the result is either null or a float.
   */
  return +$asFloat(value);
};
var $uD = function(value) {
  return +$asDouble(value);
};






// TypeArray conversions

var $byteArray2TypedArray = function(value) { return new $g["Int8Array"](value.u); };
var $shortArray2TypedArray = function(value) { return new $g["Int16Array"](value.u); };
var $charArray2TypedArray = function(value) { return new $g["Uint16Array"](value.u); };
var $intArray2TypedArray = function(value) { return new $g["Int32Array"](value.u); };
var $floatArray2TypedArray = function(value) { return new $g["Float32Array"](value.u); };
var $doubleArray2TypedArray = function(value) { return new $g["Float64Array"](value.u); };

var $typedArray2ByteArray = function(value) {
  var arrayClassData = $d_B.getArrayOf();
  return new arrayClassData.constr(new $g["Int8Array"](value));
};
var $typedArray2ShortArray = function(value) {
  var arrayClassData = $d_S.getArrayOf();
  return new arrayClassData.constr(new $g["Int16Array"](value));
};
var $typedArray2CharArray = function(value) {
  var arrayClassData = $d_C.getArrayOf();
  return new arrayClassData.constr(new $g["Uint16Array"](value));
};
var $typedArray2IntArray = function(value) {
  var arrayClassData = $d_I.getArrayOf();
  return new arrayClassData.constr(new $g["Int32Array"](value));
};
var $typedArray2FloatArray = function(value) {
  var arrayClassData = $d_F.getArrayOf();
  return new arrayClassData.constr(new $g["Float32Array"](value));
};
var $typedArray2DoubleArray = function(value) {
  var arrayClassData = $d_D.getArrayOf();
  return new arrayClassData.constr(new $g["Float64Array"](value));
};

// TypeData class


/** @constructor */
var $TypeData = function() {




  // Runtime support
  this.constr = void 0;
  this.parentData = void 0;
  this.ancestors = null;
  this.componentData = null;
  this.arrayBase = null;
  this.arrayDepth = 0;
  this.zero = null;
  this.arrayEncodedName = "";
  this._classOf = void 0;
  this._arrayOf = void 0;
  this.isArrayOf = void 0;

  // java.lang.Class support
  this["name"] = "";
  this["isPrimitive"] = false;
  this["isInterface"] = false;
  this["isArrayClass"] = false;
  this["isRawJSType"] = false;
  this["isInstance"] = void 0;
};


$TypeData.prototype.initPrim = function(



    zero, arrayEncodedName, displayName) {
  // Runtime support
  this.ancestors = {};
  this.componentData = null;
  this.zero = zero;
  this.arrayEncodedName = arrayEncodedName;
  this.isArrayOf = function(obj, depth) { return false; };

  // java.lang.Class support
  this["name"] = displayName;
  this["isPrimitive"] = true;
  this["isInstance"] = function(obj) { return false; };

  return this;
};


$TypeData.prototype.initClass = function(



    internalNameObj, isInterface, fullName,
    ancestors, isRawJSType, parentData, isInstance, isArrayOf) {
  var internalName = $propertyName(internalNameObj);

  isInstance = isInstance || function(obj) {
    return !!(obj && obj.$classData && obj.$classData.ancestors[internalName]);
  };

  isArrayOf = isArrayOf || function(obj, depth) {
    return !!(obj && obj.$classData && (obj.$classData.arrayDepth === depth)
      && obj.$classData.arrayBase.ancestors[internalName])
  };

  // Runtime support
  this.parentData = parentData;
  this.ancestors = ancestors;
  this.arrayEncodedName = "L"+fullName+";";
  this.isArrayOf = isArrayOf;

  // java.lang.Class support
  this["name"] = fullName;
  this["isInterface"] = isInterface;
  this["isRawJSType"] = !!isRawJSType;
  this["isInstance"] = isInstance;

  return this;
};


$TypeData.prototype.initArray = function(



    componentData) {
  // The constructor

  var componentZero0 = componentData.zero;

  // The zero for the Long runtime representation
  // is a special case here, since the class has not
  // been defined yet, when this file is read
  var componentZero = (componentZero0 == "longZero")
    ? $m_sjsr_RuntimeLong$().Zero$1
    : componentZero0;


  /** @constructor */
  var ArrayClass = function(arg) {
    if (typeof(arg) === "number") {
      // arg is the length of the array
      this.u = new Array(arg);
      for (var i = 0; i < arg; i++)
        this.u[i] = componentZero;
    } else {
      // arg is a native array that we wrap
      this.u = arg;
    }
  }
  ArrayClass.prototype = new $h_O;
  ArrayClass.prototype.constructor = ArrayClass;


  ArrayClass.prototype.get = function(i) {
    if (i < 0 || i >= this.u.length)
      $throwArrayIndexOutOfBoundsException(i);
    return this.u[i];
  };
  ArrayClass.prototype.set = function(i, v) {
    if (i < 0 || i >= this.u.length)
      $throwArrayIndexOutOfBoundsException(i);
    this.u[i] = v;
  };


  ArrayClass.prototype.clone__O = function() {
    if (this.u instanceof Array)
      return new ArrayClass(this.u["slice"](0));
    else
      // The underlying Array is a TypedArray
      return new ArrayClass(new this.u.constructor(this.u));
  };






































  ArrayClass.prototype.$classData = this;

  // Don't generate reflective call proxies. The compiler special cases
  // reflective calls to methods on scala.Array

  // The data

  var encodedName = "[" + componentData.arrayEncodedName;
  var componentBase = componentData.arrayBase || componentData;
  var arrayDepth = componentData.arrayDepth + 1;

  var isInstance = function(obj) {
    return componentBase.isArrayOf(obj, arrayDepth);
  }

  // Runtime support
  this.constr = ArrayClass;
  this.parentData = $d_O;
  this.ancestors = {O: 1, jl_Cloneable: 1, Ljava_io_Serializable: 1};
  this.componentData = componentData;
  this.arrayBase = componentBase;
  this.arrayDepth = arrayDepth;
  this.zero = null;
  this.arrayEncodedName = encodedName;
  this._classOf = undefined;
  this._arrayOf = undefined;
  this.isArrayOf = undefined;

  // java.lang.Class support
  this["name"] = encodedName;
  this["isPrimitive"] = false;
  this["isInterface"] = false;
  this["isArrayClass"] = true;
  this["isInstance"] = isInstance;

  return this;
};


$TypeData.prototype.getClassOf = function() {



  if (!this._classOf)
    this._classOf = new $c_jl_Class().init___jl_ScalaJSClassData(this);
  return this._classOf;
};


$TypeData.prototype.getArrayOf = function() {



  if (!this._arrayOf)
    this._arrayOf = new $TypeData().initArray(this);
  return this._arrayOf;
};

// java.lang.Class support


$TypeData.prototype["getFakeInstance"] = function() {



  if (this === $d_T)
    return "some string";
  else if (this === $d_jl_Boolean)
    return false;
  else if (this === $d_jl_Byte ||
           this === $d_jl_Short ||
           this === $d_jl_Integer ||
           this === $d_jl_Float ||
           this === $d_jl_Double)
    return 0;
  else if (this === $d_jl_Long)
    return $m_sjsr_RuntimeLong$().Zero$1;
  else if (this === $d_sr_BoxedUnit)
    return void 0;
  else
    return {$classData: this};
};


$TypeData.prototype["getSuperclass"] = function() {



  return this.parentData ? this.parentData.getClassOf() : null;
};


$TypeData.prototype["getComponentType"] = function() {



  return this.componentData ? this.componentData.getClassOf() : null;
};


$TypeData.prototype["newArrayOfThisClass"] = function(lengths) {



  var arrayClassData = this;
  for (var i = 0; i < lengths.length; i++)
    arrayClassData = arrayClassData.getArrayOf();
  return $newArrayObject(arrayClassData, lengths);
};




// Create primitive types

var $d_V = new $TypeData().initPrim(undefined, "V", "void");
var $d_Z = new $TypeData().initPrim(false, "Z", "boolean");
var $d_C = new $TypeData().initPrim(0, "C", "char");
var $d_B = new $TypeData().initPrim(0, "B", "byte");
var $d_S = new $TypeData().initPrim(0, "S", "short");
var $d_I = new $TypeData().initPrim(0, "I", "int");
var $d_J = new $TypeData().initPrim("longZero", "J", "long");
var $d_F = new $TypeData().initPrim(0.0, "F", "float");
var $d_D = new $TypeData().initPrim(0.0, "D", "double");

// Instance tests for array of primitives

var $isArrayOf_Z = $makeIsArrayOfPrimitive($d_Z);
$d_Z.isArrayOf = $isArrayOf_Z;

var $isArrayOf_C = $makeIsArrayOfPrimitive($d_C);
$d_C.isArrayOf = $isArrayOf_C;

var $isArrayOf_B = $makeIsArrayOfPrimitive($d_B);
$d_B.isArrayOf = $isArrayOf_B;

var $isArrayOf_S = $makeIsArrayOfPrimitive($d_S);
$d_S.isArrayOf = $isArrayOf_S;

var $isArrayOf_I = $makeIsArrayOfPrimitive($d_I);
$d_I.isArrayOf = $isArrayOf_I;

var $isArrayOf_J = $makeIsArrayOfPrimitive($d_J);
$d_J.isArrayOf = $isArrayOf_J;

var $isArrayOf_F = $makeIsArrayOfPrimitive($d_F);
$d_F.isArrayOf = $isArrayOf_F;

var $isArrayOf_D = $makeIsArrayOfPrimitive($d_D);
$d_D.isArrayOf = $isArrayOf_D;


// asInstanceOfs for array of primitives
var $asArrayOf_Z = $makeAsArrayOfPrimitive($isArrayOf_Z, "Z");
var $asArrayOf_C = $makeAsArrayOfPrimitive($isArrayOf_C, "C");
var $asArrayOf_B = $makeAsArrayOfPrimitive($isArrayOf_B, "B");
var $asArrayOf_S = $makeAsArrayOfPrimitive($isArrayOf_S, "S");
var $asArrayOf_I = $makeAsArrayOfPrimitive($isArrayOf_I, "I");
var $asArrayOf_J = $makeAsArrayOfPrimitive($isArrayOf_J, "J");
var $asArrayOf_F = $makeAsArrayOfPrimitive($isArrayOf_F, "F");
var $asArrayOf_D = $makeAsArrayOfPrimitive($isArrayOf_D, "D");

function $is_F0(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.F0)))
}
function $as_F0(obj) {
  return (($is_F0(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.Function0"))
}
function $isArrayOf_F0(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.F0)))
}
function $asArrayOf_F0(obj, depth) {
  return (($isArrayOf_F0(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.Function0;", depth))
}
function $is_F1(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.F1)))
}
function $as_F1(obj) {
  return (($is_F1(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.Function1"))
}
function $isArrayOf_F1(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.F1)))
}
function $asArrayOf_F1(obj, depth) {
  return (($isArrayOf_F1(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.Function1;", depth))
}
function $f_Lio_youi_ErrorSupport__error__jl_Throwable__V($thiz, t) {
  var this$1 = $m_Lio_youi_ErrorSupport$().error$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, t$1) {
    return (function() {
      return t$1
    })
  })($thiz, t));
  this$1.set__F0__V(value)
}
function $is_Lio_youi_MessageException(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_MessageException)))
}
function $as_Lio_youi_MessageException(obj) {
  return (($is_Lio_youi_MessageException(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.MessageException"))
}
function $isArrayOf_Lio_youi_MessageException(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_MessageException)))
}
function $asArrayOf_Lio_youi_MessageException(obj, depth) {
  return (($isArrayOf_Lio_youi_MessageException(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.MessageException;", depth))
}
function $f_Lio_youi_Updates__every__s_concurrent_duration_FiniteDuration__s_Option__Z__F0__V($thiz, delay, until, allowBackgrounding, f) {
  var t = delay.unit$2.toMillis__J__J(delay.length$2);
  var lo = t.lo$2;
  var hi = t.hi$2;
  var timeout = ($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo, hi) / 1000.0);
  if (until.isEmpty__Z()) {
    var untilTimeout = $m_s_None$()
  } else {
    var arg1 = until.get__O();
    var x$2 = $as_s_concurrent_duration_FiniteDuration(arg1);
    var t$1 = x$2.unit$2.toMillis__J__J(x$2.length$2);
    var lo$1 = t$1.lo$2;
    var hi$1 = t$1.hi$2;
    var untilTimeout = new $c_s_Some().init___O(($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo$1, hi$1) / 1000.0))
  };
  var elapsed = new $c_sr_DoubleRef().init___D(0.0);
  var totalElapsed = new $c_sr_DoubleRef().init___D(0.0);
  if (allowBackgrounding) {
    var listener = new $c_sr_ObjectRef().init___O(null);
    listener.elem$1 = $thiz.delta__Lreactify_Channel().attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, f$1, timeout$1, untilTimeout$1, elapsed$1, totalElapsed$1, listener$1) {
      return (function(d$2) {
        var d = $uD(d$2);
        elapsed$1.elem$1 = (elapsed$1.elem$1 + d);
        totalElapsed$1.elem$1 = (totalElapsed$1.elem$1 + d);
        if ((elapsed$1.elem$1 >= timeout$1)) {
          elapsed$1.elem$1 = 0.0;
          f$1.apply__O();
          if ((!untilTimeout$1.isEmpty__Z())) {
            var arg1$1 = untilTimeout$1.get__O();
            var total = $uD(arg1$1);
            if ((totalElapsed$1.elem$1 >= total)) {
              this$2$1.delta__Lreactify_Channel().detach__Lreactify_Listener__V($as_Lreactify_Listener(listener$1.elem$1))
            }
          }
        }
      })
    })($thiz, f, timeout, untilTimeout, elapsed, totalElapsed, listener)), $thiz.delta__Lreactify_Channel().attach$default$2__D())
  } else {
    var $function = new $c_sr_ObjectRef().init___O(null);
    $function.elem$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, delay$1, until$1, f$2, elapsed$2, $function$1) {
      return (function() {
        f$2.apply__O();
        var jsx$1 = elapsed$2.elem$1;
        var t$2 = delay$1.unit$2.toMillis__J__J(delay$1.length$2);
        var lo$2 = t$2.lo$2;
        var hi$2 = t$2.hi$2;
        elapsed$2.elem$1 = (jsx$1 + ($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo$2, hi$2) / 1000.0));
        if ((!until$1.isEmpty__Z())) {
          var arg1$2 = until$1.get__O();
          var x$3 = $as_s_concurrent_duration_FiniteDuration(arg1$2);
          var jsx$3 = elapsed$2.elem$1;
          var t$3 = x$3.unit$2.toMillis__J__J(x$3.length$2);
          var lo$3 = t$3.lo$2;
          var hi$3 = t$3.hi$2;
          var jsx$2 = (jsx$3 >= $m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo$3, hi$3))
        } else {
          var jsx$2 = false
        };
        if ((!jsx$2)) {
          var jsx$5 = $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window();
          var jsx$4 = $as_F0($function$1.elem$1);
          var t$4 = delay$1.unit$2.toMillis__J__J(delay$1.length$2);
          var lo$4 = t$4.lo$2;
          var hi$4 = t$4.hi$2;
          jsx$5.setTimeout((function(f$3) {
            return (function() {
              return f$3.apply__O()
            })
          })(jsx$4), $m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo$4, hi$4))
        }
      })
    })($thiz, delay, until, f, elapsed, $function));
    var jsx$7 = $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window();
    var jsx$6 = $as_F0($function.elem$1);
    var t$5 = delay.unit$2.toMillis__J__J(delay.length$2);
    var lo$5 = t$5.lo$2;
    var hi$5 = t$5.hi$2;
    jsx$7.setTimeout((function(f$4) {
      return (function() {
        return f$4.apply__O()
      })
    })(jsx$6), $m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo$5, hi$5))
  }
}
function $f_Lio_youi_Updates__nextFrame__F0__V($thiz, f) {
  var this$3 = $thiz.delta__Lreactify_Channel();
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1) {
    return (function(x$1$2) {
      $uD(x$1$2);
      f$1.apply__O()
    })
  })($thiz, f));
  var this$1 = $thiz.delta__Lreactify_Channel();
  var condition = $f_Lreactify_Observable__once$default$2__F1(this$1);
  $thiz.delta__Lreactify_Channel();
  var priority = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__once__F1__F1__D__Lreactify_Listener(this$3, f$2, condition, priority)
}
function $f_Lio_youi_Updates__update__D__V($thiz, delta) {
  var this$1 = $thiz.delta__Lreactify_Channel();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, delta$1) {
    return (function() {
      return delta$1
    })
  })($thiz, delta));
  this$1.set__F0__V(value)
}
function $is_Lio_youi_VirtualMode(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_VirtualMode)))
}
function $as_Lio_youi_VirtualMode(obj) {
  return (($is_Lio_youi_VirtualMode(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.VirtualMode"))
}
function $isArrayOf_Lio_youi_VirtualMode(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_VirtualMode)))
}
function $asArrayOf_Lio_youi_VirtualMode(obj, depth) {
  return (($isArrayOf_Lio_youi_VirtualMode(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.VirtualMode;", depth))
}
function $f_Lio_youi_VirtualSizeSupport__$$init$__V($thiz) {
  $thiz.io$youi$VirtualSizeSupport$$undsetter$und$virtualWidth$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 1024.0
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$VirtualSizeSupport$$undsetter$und$virtualHeight$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      return 768.0
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$VirtualSizeSupport$$undsetter$und$virtualMode$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3) {
    return (function() {
      return $m_Lio_youi_VirtualMode$Bars$()
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$VirtualSizeSupport$$undsetter$und$virtual$und$eq__Lio_youi_VirtualSize__V(new $c_Lio_youi_VirtualSize().init___Lio_youi_VirtualSizeSupport__Lreactify_State__Lreactify_State($thiz, $m_Lio_youi_VirtualSize$().$$lessinit$greater$default$2__Lreactify_State(), $m_Lio_youi_VirtualSize$().$$lessinit$greater$default$3__Lreactify_State()))
}
function $is_Lio_youi_activate_ActivateInstruction(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_activate_ActivateInstruction)))
}
function $as_Lio_youi_activate_ActivateInstruction(obj) {
  return (($is_Lio_youi_activate_ActivateInstruction(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.activate.ActivateInstruction"))
}
function $isArrayOf_Lio_youi_activate_ActivateInstruction(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_activate_ActivateInstruction)))
}
function $asArrayOf_Lio_youi_activate_ActivateInstruction(obj, depth) {
  return (($isArrayOf_Lio_youi_activate_ActivateInstruction(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.activate.ActivateInstruction;", depth))
}
function $f_Lio_youi_activate_ActivationSupport__activationRoot__Lorg_scalajs_dom_raw_HTMLElement($thiz) {
  return $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body
}
function $f_Lio_youi_app_screen_Screen__$$init$__V($thiz) {
  $thiz.io$youi$app$screen$Screen$$undsetter$und$currentState$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_Lio_youi_app_screen_ScreenState$New$()
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$app$screen$Screen$$undsetter$und$state$und$eq__Lreactify_Val__V($m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      $m_Lreactify_package$();
      var p = this$2.currentState__Lreactify_Var();
      return $as_Lio_youi_app_screen_ScreenState(p.get__O())
    })
  })($thiz)), false, true, true));
  var this$3 = $m_Lio_youi_app_screen_ScreenManager$().apply__Lio_youi_app_screen_ScreenManager();
  $f_Lio_youi_app_screen_ScreenManager__addScreen__Lio_youi_app_screen_Screen__V(this$3, $thiz)
}
function $is_Lio_youi_app_screen_Screen(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_screen_Screen)))
}
function $as_Lio_youi_app_screen_Screen(obj) {
  return (($is_Lio_youi_app_screen_Screen(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.screen.Screen"))
}
function $isArrayOf_Lio_youi_app_screen_Screen(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_screen_Screen)))
}
function $asArrayOf_Lio_youi_app_screen_Screen(obj, depth) {
  return (($isArrayOf_Lio_youi_app_screen_Screen(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.screen.Screen;", depth))
}
function $f_Lio_youi_app_screen_ScreenManager__addScreen__Lio_youi_app_screen_Screen__V($thiz, screen) {
  var this$4 = $thiz.io$youi$app$screen$ScreenManager$$allScreens__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, screen$1) {
    return (function() {
      var this$1 = $this.io$youi$app$screen$ScreenManager$$allScreens__Lreactify_Var();
      var x$5 = $as_sci_List(this$1.get__O());
      $m_sci_List$();
      var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([screen$1]);
      var this$3 = $m_sci_List$();
      var cbf = this$3.ReusableCBFInstance$2;
      return $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)).$$colon$colon$colon__sci_List__sci_List(x$5)
    })
  })($thiz, screen));
  this$4.replace__F0__Z__V(value, true)
}
function $f_Lio_youi_app_screen_ScreenManager__io$youi$app$screen$ScreenManager$$screenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__V($thiz, oldScreen, newScreen) {
  var this$1 = $m_Lscribe_package$();
  var level = $m_Lscribe_Level$Info$();
  var message = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, oldScreen$1, newScreen$1) {
    return (function() {
      return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Screen change from ", " to ", "..."])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([oldScreen$1, newScreen$1]))
    })
  })($thiz, oldScreen, newScreen));
  var methodName = new $c_s_Some().init___O("screenChange");
  $f_Lscribe_LoggerSupport__log__Lscribe_Level__F0__T__s_Option__I__V(this$1, level, message, "io.youi.app.screen.ScreenManager", methodName, 30);
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$und$eq__s_concurrent_Future__V($thiz.io$youi$app$screen$ScreenManager$$managerFuture__s_concurrent_Future().flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2, oldScreen$2, newScreen$2) {
    return (function(x$1$2) {
      $asUnit(x$1$2);
      return this$2.beforeScreenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future(oldScreen$2, newScreen$2)
    })
  })($thiz, oldScreen, newScreen)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext()));
  $f_Lio_youi_app_screen_ScreenManager__deactivate__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, oldScreen);
  $f_Lio_youi_app_screen_ScreenManager__activate__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, newScreen);
  var this$3 = $thiz.loaded__Lreactify_Val();
  if ((!$uZ(this$3.get__O()))) {
    var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
    var this$7 = $thiz.loaded__Lreactify_Val();
    var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, promise$1) {
      return (function(x$2$2) {
        $uZ(x$2$2);
        $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$1, (void 0))
      })
    })($thiz, promise));
    var this$5 = $thiz.loaded__Lreactify_Val();
    var condition = $f_Lreactify_Observable__once$default$2__F1(this$5);
    $thiz.loaded__Lreactify_Val();
    var priority = $m_Lreactify_Listener$Priority$().Normal$1;
    $f_Lreactify_Observable__once__F1__F1__D__Lreactify_Listener(this$7, f, condition, priority);
    $thiz.io$youi$app$screen$ScreenManager$$managerFuture$und$eq__s_concurrent_Future__V($thiz.io$youi$app$screen$ScreenManager$$managerFuture__s_concurrent_Future().flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1, promise$2) {
      return (function(x$3$2) {
        $asUnit(x$3$2);
        return promise$2
      })
    })($thiz, promise)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext()))
  };
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$und$eq__s_concurrent_Future__V($thiz.io$youi$app$screen$ScreenManager$$managerFuture__s_concurrent_Future().flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$5$1, oldScreen$3, newScreen$3) {
    return (function(x$4$2) {
      $asUnit(x$4$2);
      return this$5$1.afterScreenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future(oldScreen$3, newScreen$3)
    })
  })($thiz, oldScreen, newScreen)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext()))
}
function $f_Lio_youi_app_screen_ScreenManager__io$youi$app$screen$ScreenManager$$$anonfun$$init$$1__Lorg_scalajs_dom_raw_Event__V($thiz, evt) {
  var this$1 = $as_Lreactify_Var($thiz.loaded__Lreactify_Val());
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return true
    })
  })($thiz));
  this$1.replace__F0__Z__V(value, true)
}
function $f_Lio_youi_app_screen_ScreenManager__$$init$__V($thiz) {
  $m_Lio_youi_app_screen_ScreenManager$().io$youi$app$screen$ScreenManager$$instance$1 = new $c_s_Some().init___O($thiz);
  $thiz.io$youi$app$screen$ScreenManager$$managerFuture$und$eq__s_concurrent_Future__V($m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0)));
  $thiz.io$youi$app$screen$ScreenManager$$undsetter$und$io$youi$app$screen$ScreenManager$$allScreens$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_sci_Nil$()
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$app$screen$ScreenManager$$undsetter$und$screens$und$eq__Lreactify_State__V($thiz.io$youi$app$screen$ScreenManager$$allScreens__Lreactify_Var());
  $thiz.io$youi$app$screen$ScreenManager$$undsetter$und$active$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      return $m_Lio_youi_app_screen_EmptyScreen$()
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$app$screen$ScreenManager$$undsetter$und$loaded$und$eq__Lreactify_Val__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3) {
    return (function() {
      return false
    })
  })($thiz)), false, true, true));
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().addEventListener("load", (function(arg$outer) {
    return (function(arg1$2) {
      $f_Lio_youi_app_screen_ScreenManager__io$youi$app$screen$ScreenManager$$$anonfun$$init$$1__Lorg_scalajs_dom_raw_Event__V(arg$outer, arg1$2)
    })
  })($thiz));
  var this$1 = $thiz.active__Lreactify_Var();
  var listener = new $c_Lio_youi_app_screen_ScreenManager$$anon$1().init___Lio_youi_app_screen_ScreenManager($thiz);
  $f_Lreactify_State__changes__Lreactify_ChangeListener__Lreactify_Listener(this$1, listener)
}
function $f_Lio_youi_app_screen_ScreenManager__activate__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, screen) {
  return $thiz.io$youi$app$screen$ScreenManager$$managerFuture__s_concurrent_Future().flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, screen$1) {
    return (function(x$9$2) {
      $asUnit(x$9$2);
      var elem = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
      var elem$1 = null;
      elem$1 = elem;
      var this$2 = screen$1.state__Lreactify_Val();
      var state = $as_Lio_youi_app_screen_ScreenState(this$2.get__O());
      var applying = $m_Lio_youi_app_screen_ScreenState$Initializing$();
      var applied = $m_Lio_youi_app_screen_ScreenState$Initialized$();
      var call = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, screen$3) {
        return (function() {
          return screen$3.init__s_concurrent_Future()
        })
      })($this, screen$1));
      var array = [$m_Lio_youi_app_screen_ScreenState$New$(), $m_Lio_youi_app_screen_ScreenState$Disposing$(), $m_Lio_youi_app_screen_ScreenState$Disposed$()];
      var i = 0;
      while (true) {
        if ((i < $uI(array.length))) {
          var index = i;
          var arg1 = array[index];
          var jsx$1 = ($m_sr_BoxesRunTime$().equals__O__O__Z(arg1, state) === false)
        } else {
          var jsx$1 = false
        };
        if (jsx$1) {
          i = ((1 + i) | 0)
        } else {
          break
        }
      };
      if ((i !== $uI(array.length))) {
        elem$1 = $as_s_concurrent_Future(elem$1).flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$2, screen$3$1, applying$1, applied$1, call$1) {
          return (function(x$10$2) {
            $asUnit(x$10$2);
            var this$4 = screen$3$1.currentState__Lreactify_Var();
            var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$3, applying$2) {
              return (function() {
                return applying$2
              })
            })($this$2, applying$1));
            this$4.replace__F0__Z__V(value, true);
            return $as_s_concurrent_Future(call$1.apply__O()).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, screen$3$2, applied$2) {
              return (function(x$11$2) {
                $asUnit(x$11$2);
                var this$5 = screen$3$2.currentState__Lreactify_Var();
                var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$4, applied$2$1) {
                  return (function() {
                    return applied$2$1
                  })
                })(this$2$1, applied$2));
                this$5.replace__F0__Z__V(value$1, true)
              })
            })($this$2, screen$3$1, applied$1)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
          })
        })($this, screen$1, applying, applied, call)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
      };
      var applying$3 = $m_Lio_youi_app_screen_ScreenState$Loading$();
      var applied$3 = $m_Lio_youi_app_screen_ScreenState$Loaded$();
      var call$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$2, screen$3$3) {
        return (function() {
          return screen$3$3.load__s_concurrent_Future()
        })
      })($this, screen$1));
      var array$1 = [$m_Lio_youi_app_screen_ScreenState$New$(), $m_Lio_youi_app_screen_ScreenState$Disposing$(), $m_Lio_youi_app_screen_ScreenState$Disposed$(), $m_Lio_youi_app_screen_ScreenState$Initializing$(), $m_Lio_youi_app_screen_ScreenState$Initialized$()];
      var i$1 = 0;
      while (true) {
        if ((i$1 < $uI(array$1.length))) {
          var index$1 = i$1;
          var arg1$1 = array$1[index$1];
          var jsx$2 = ($m_sr_BoxesRunTime$().equals__O__O__Z(arg1$1, state) === false)
        } else {
          var jsx$2 = false
        };
        if (jsx$2) {
          i$1 = ((1 + i$1) | 0)
        } else {
          break
        }
      };
      if ((i$1 !== $uI(array$1.length))) {
        elem$1 = $as_s_concurrent_Future(elem$1).flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$5, screen$3$4, applying$4, applied$4, call$3) {
          return (function(x$10$2$1) {
            $asUnit(x$10$2$1);
            var this$7 = screen$3$4.currentState__Lreactify_Var();
            var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$6, applying$2$1) {
              return (function() {
                return applying$2$1
              })
            })($this$5, applying$4));
            this$7.replace__F0__Z__V(value$2, true);
            return $as_s_concurrent_Future(call$3.apply__O()).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$3, screen$3$5, applied$2$2) {
              return (function(x$11$2$1) {
                $asUnit(x$11$2$1);
                var this$8 = screen$3$5.currentState__Lreactify_Var();
                var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$7, applied$2$3) {
                  return (function() {
                    return applied$2$3
                  })
                })(this$2$3, applied$2$2));
                this$8.replace__F0__Z__V(value$3, true)
              })
            })($this$5, screen$3$4, applied$4)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
          })
        })($this, screen$1, applying$3, applied$3, call$2)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
      };
      var applying$5 = $m_Lio_youi_app_screen_ScreenState$Activating$();
      var applied$5 = $m_Lio_youi_app_screen_ScreenState$Activated$();
      var call$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, screen$3$6) {
        return (function() {
          return screen$3$6.activate__s_concurrent_Future()
        })
      })($this, screen$1));
      var array$2 = [$m_Lio_youi_app_screen_ScreenState$New$(), $m_Lio_youi_app_screen_ScreenState$Disposing$(), $m_Lio_youi_app_screen_ScreenState$Disposed$(), $m_Lio_youi_app_screen_ScreenState$Initializing$(), $m_Lio_youi_app_screen_ScreenState$Initialized$(), $m_Lio_youi_app_screen_ScreenState$Deactivating$(), $m_Lio_youi_app_screen_ScreenState$Deactivated$()];
      var i$2 = 0;
      while (true) {
        if ((i$2 < $uI(array$2.length))) {
          var index$2 = i$2;
          var arg1$2 = array$2[index$2];
          var jsx$3 = ($m_sr_BoxesRunTime$().equals__O__O__Z(arg1$2, state) === false)
        } else {
          var jsx$3 = false
        };
        if (jsx$3) {
          i$2 = ((1 + i$2) | 0)
        } else {
          break
        }
      };
      if ((i$2 !== $uI(array$2.length))) {
        elem$1 = $as_s_concurrent_Future(elem$1).flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$8, screen$3$7, applying$6, applied$6, call$5) {
          return (function(x$10$2$2) {
            $asUnit(x$10$2$2);
            var this$10 = screen$3$7.currentState__Lreactify_Var();
            var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$9, applying$2$2) {
              return (function() {
                return applying$2$2
              })
            })($this$8, applying$6));
            this$10.replace__F0__Z__V(value$4, true);
            return $as_s_concurrent_Future(call$5.apply__O()).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$4, screen$3$8, applied$2$4) {
              return (function(x$11$2$2) {
                $asUnit(x$11$2$2);
                var this$11 = screen$3$8.currentState__Lreactify_Var();
                var value$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$10, applied$2$5) {
                  return (function() {
                    return applied$2$5
                  })
                })(this$2$4, applied$2$4));
                this$11.replace__F0__Z__V(value$5, true)
              })
            })($this$8, screen$3$7, applied$6)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
          })
        })($this, screen$1, applying$5, applied$5, call$4)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
      };
      var jsx$4 = $as_s_concurrent_Future(elem$1).failed__s_concurrent_Future();
      var eta$0$2 = $m_Lio_youi_app_YouIApplication$().apply__Lio_youi_app_YouIApplication();
      jsx$4.foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1, eta$0$2$1) {
        return (function(t$2) {
          var t = $as_jl_Throwable(t$2);
          $f_Lio_youi_ErrorSupport__error__jl_Throwable__V(eta$0$2$1, t)
        })
      })($this, eta$0$2)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
      $this.io$youi$app$screen$ScreenManager$$managerFuture$und$eq__s_concurrent_Future__V($as_s_concurrent_Future(elem$1));
      return $as_s_concurrent_Future(elem$1)
    })
  })($thiz, screen)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $f_Lio_youi_app_screen_ScreenManager__deactivate__pLio_youi_app_screen_ScreenManager__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, screen) {
  return $thiz.io$youi$app$screen$ScreenManager$$managerFuture__s_concurrent_Future().flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, screen$1) {
    return (function(x$12$2) {
      $asUnit(x$12$2);
      var this$1 = screen$1.state__Lreactify_Val();
      var x = this$1.get__O();
      var x$2 = $m_Lio_youi_app_screen_ScreenState$Activated$();
      if (((x !== null) && $objectEquals(x, x$2))) {
        var this$2 = screen$1.currentState__Lreactify_Var();
        var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
          return (function() {
            return $m_Lio_youi_app_screen_ScreenState$Deactivating$()
          })
        })($this));
        this$2.replace__F0__Z__V(value, true);
        var future = screen$1.deactivate__s_concurrent_Future().map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, screen$2) {
          return (function(x$13$2) {
            $asUnit(x$13$2);
            var this$4 = screen$2.currentState__Lreactify_Var();
            var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$2) {
              return (function() {
                return $m_Lio_youi_app_screen_ScreenState$Deactivated$()
              })
            })(this$2$1));
            this$4.replace__F0__Z__V(value$1, true)
          })
        })($this, screen$1)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
        var jsx$1 = future.failed__s_concurrent_Future();
        var eta$0$3 = $m_Lio_youi_app_YouIApplication$().apply__Lio_youi_app_YouIApplication();
        jsx$1.foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, eta$0$3$1) {
          return (function(t$2) {
            var t = $as_jl_Throwable(t$2);
            $f_Lio_youi_ErrorSupport__error__jl_Throwable__V(eta$0$3$1, t)
          })
        })($this, eta$0$3)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
        $this.io$youi$app$screen$ScreenManager$$managerFuture$und$eq__s_concurrent_Future__V(future);
        return future
      } else {
        return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
      }
    })
  })($thiz, screen)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $is_Lio_youi_app_screen_ScreenManager(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_screen_ScreenManager)))
}
function $as_Lio_youi_app_screen_ScreenManager(obj) {
  return (($is_Lio_youi_app_screen_ScreenManager(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.screen.ScreenManager"))
}
function $isArrayOf_Lio_youi_app_screen_ScreenManager(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_screen_ScreenManager)))
}
function $asArrayOf_Lio_youi_app_screen_ScreenManager(obj, depth) {
  return (($isArrayOf_Lio_youi_app_screen_ScreenManager(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.screen.ScreenManager;", depth))
}
function $is_Lio_youi_easing_Easing(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_easing_Easing)))
}
function $as_Lio_youi_easing_Easing(obj) {
  return (($is_Lio_youi_easing_Easing(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.easing.Easing"))
}
function $isArrayOf_Lio_youi_easing_Easing(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_easing_Easing)))
}
function $asArrayOf_Lio_youi_easing_Easing(obj, depth) {
  return (($isArrayOf_Lio_youi_easing_Easing(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.easing.Easing;", depth))
}
function $is_Lio_youi_hypertext_style_Image(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_hypertext_style_Image)))
}
function $as_Lio_youi_hypertext_style_Image(obj) {
  return (($is_Lio_youi_hypertext_style_Image(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.hypertext.style.Image"))
}
function $isArrayOf_Lio_youi_hypertext_style_Image(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_hypertext_style_Image)))
}
function $asArrayOf_Lio_youi_hypertext_style_Image(obj, depth) {
  return (($isArrayOf_Lio_youi_hypertext_style_Image(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.hypertext.style.Image;", depth))
}
function $is_Lio_youi_hypertext_style_Position(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_hypertext_style_Position)))
}
function $as_Lio_youi_hypertext_style_Position(obj) {
  return (($is_Lio_youi_hypertext_style_Position(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.hypertext.style.Position"))
}
function $isArrayOf_Lio_youi_hypertext_style_Position(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_hypertext_style_Position)))
}
function $asArrayOf_Lio_youi_hypertext_style_Position(obj, depth) {
  return (($isArrayOf_Lio_youi_hypertext_style_Position(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.hypertext.style.Position;", depth))
}
function $is_Lio_youi_style_Paint(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_Paint)))
}
function $as_Lio_youi_style_Paint(obj) {
  return (($is_Lio_youi_style_Paint(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.Paint"))
}
function $isArrayOf_Lio_youi_style_Paint(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_Paint)))
}
function $asArrayOf_Lio_youi_style_Paint(obj, depth) {
  return (($isArrayOf_Lio_youi_style_Paint(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.Paint;", depth))
}
function $f_Lio_youi_workflow_Task__start__s_concurrent_Future($thiz) {
  $thiz.starting__V();
  var future = $thiz.run__s_concurrent_Future();
  future.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$1$2) {
      var x0$1 = $as_s_util_Try(x0$1$2);
      if ((!$is_s_util_Success(x0$1))) {
        if ($is_s_util_Failure(x0$1)) {
          $as_s_util_Failure(x0$1)
        } else {
          throw new $c_s_MatchError().init___O(x0$1)
        }
      }
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext());
  return future
}
function $is_Lio_youi_workflow_Task(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_workflow_Task)))
}
function $as_Lio_youi_workflow_Task(obj) {
  return (($is_Lio_youi_workflow_Task(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.workflow.Task"))
}
function $isArrayOf_Lio_youi_workflow_Task(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_workflow_Task)))
}
function $asArrayOf_Lio_youi_workflow_Task(obj, depth) {
  return (($isArrayOf_Lio_youi_workflow_Task(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.workflow.Task;", depth))
}
function $is_Ljava_io_Closeable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Ljava_io_Closeable)))
}
function $as_Ljava_io_Closeable(obj) {
  return (($is_Ljava_io_Closeable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.io.Closeable"))
}
function $isArrayOf_Ljava_io_Closeable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Ljava_io_Closeable)))
}
function $asArrayOf_Ljava_io_Closeable(obj, depth) {
  return (($isArrayOf_Ljava_io_Closeable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.io.Closeable;", depth))
}
function $is_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lorg_scalajs_testinterface_HTMLRunner$UI$Test)))
}
function $as_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj) {
  return (($is_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "org.scalajs.testinterface.HTMLRunner$UI$Test"))
}
function $isArrayOf_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lorg_scalajs_testinterface_HTMLRunner$UI$Test)))
}
function $asArrayOf_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj, depth) {
  return (($isArrayOf_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lorg.scalajs.testinterface.HTMLRunner$UI$Test;", depth))
}
function $f_Lreactify_Observable__on__F0__D__Lreactify_Listener($thiz, f, priority) {
  return $thiz.attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1) {
    return (function(x$2$2) {
      f$1.apply__O()
    })
  })($thiz, f)), priority)
}
function $f_Lreactify_Observable__fireRecursive__O__Lreactify_Invocation__sci_List__V($thiz, value, invocation, observers) {
  _fireRecursive: while (true) {
    var this$1 = observers;
    if (($f_sc_TraversableOnce__nonEmpty__Z(this$1) && (!invocation.stopped$1))) {
      var listener = $as_Lreactify_Listener(observers.head__O());
      listener.apply__O__V(value);
      observers = $as_sci_List(observers.tail__O());
      continue _fireRecursive
    };
    break
  }
}
function $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener($thiz, f, priority) {
  var listener = new $c_Lreactify_Listener$FunctionListener().init___F1__D(f, priority);
  return $f_Lreactify_Observable__observe__Lreactify_Listener__Lreactify_Listener($thiz, listener)
}
function $f_Lreactify_Observable__once$default$2__F1($thiz) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$4$2) {
      return true
    })
  })($thiz))
}
function $f_Lreactify_Observable__observe__Lreactify_Listener__Lreactify_Listener($thiz, listener) {
  var x$1 = $thiz.observers__sci_List();
  $m_sci_List$();
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([listener]);
  var this$2 = $m_sci_List$();
  var cbf = this$2.ReusableCBFInstance$2;
  var this$4 = $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)).$$colon$colon$colon__sci_List__sci_List(x$1);
  var this$3 = $m_s_math_Ordering$();
  var evidence$1 = $m_s_Predef$().singleton$und$less$colon$less$2;
  var ord = new $c_s_math_LowPriorityOrderingImplicits$$anon$6().init___s_math_LowPriorityOrderingImplicits__F1(this$3, evidence$1);
  $thiz.observers$und$eq__sci_List__V($as_sci_List($f_sc_SeqLike__sorted__s_math_Ordering__O(this$4, ord)));
  return listener
}
function $f_Lreactify_Observable__once__F1__F1__D__Lreactify_Listener($thiz, f, condition, priority) {
  var listener = new $c_sr_ObjectRef().init___O(null);
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1, condition$1, listener$1) {
    return (function(value$2) {
      if ($uZ(condition$1.apply__O__O(value$2))) {
        $this.detach__Lreactify_Listener__V($as_Lreactify_Listener(listener$1.elem$1));
        f$1.apply__O__O(value$2)
      }
    })
  })($thiz, f, condition, listener));
  listener.elem$1 = new $c_Lreactify_Listener$FunctionListener().init___F1__D(f$2, priority);
  var listener$2 = $as_Lreactify_Listener(listener.elem$1);
  return $f_Lreactify_Observable__observe__Lreactify_Listener__Lreactify_Listener($thiz, listener$2)
}
function $f_Lreactify_Observable__fire__O__V($thiz, value) {
  var this$1 = $m_Lreactify_Invocation$();
  var this$2 = $as_Lreactify_Invocation(this$1.instances$1.get__O());
  var previous = this$2.stopped$1;
  this$2.stopped$1 = false;
  try {
    var this$3 = $m_Lreactify_Invocation$();
    var invocation = $as_Lreactify_Invocation(this$3.instances$1.get__O());
    var observers = $thiz.observers__sci_List();
    $f_Lreactify_Observable__fireRecursive__O__Lreactify_Invocation__sci_List__V($thiz, value, invocation, observers)
  } finally {
    this$2.stopped$1 = previous
  }
}
function $f_Lreactify_Observable__detach__Lreactify_Listener__V($thiz, listener) {
  var this$1 = $thiz.observers__sci_List();
  $m_sci_List$();
  var b = new $c_scm_ListBuffer().init___();
  var these = this$1;
  while ((!these.isEmpty__Z())) {
    var arg1 = these.head__O();
    var x$3 = $as_Lreactify_Listener(arg1);
    if (((x$3 === listener) !== true)) {
      b.$$plus$eq__O__scm_ListBuffer(arg1)
    };
    these = $as_sci_List(these.tail__O())
  };
  $thiz.observers$und$eq__sci_List__V(b.toList__sci_List())
}
function $is_Lreactify_Observable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_Observable)))
}
function $as_Lreactify_Observable(obj) {
  return (($is_Lreactify_Observable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.Observable"))
}
function $isArrayOf_Lreactify_Observable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_Observable)))
}
function $asArrayOf_Lreactify_Observable(obj, depth) {
  return (($isArrayOf_Lreactify_Observable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.Observable;", depth))
}
function $is_Lsbt_testing_Fingerprint(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_Fingerprint)))
}
function $as_Lsbt_testing_Fingerprint(obj) {
  return (($is_Lsbt_testing_Fingerprint(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.Fingerprint"))
}
function $isArrayOf_Lsbt_testing_Fingerprint(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_Fingerprint)))
}
function $asArrayOf_Lsbt_testing_Fingerprint(obj, depth) {
  return (($isArrayOf_Lsbt_testing_Fingerprint(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.Fingerprint;", depth))
}
function $is_Lsbt_testing_Framework(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_Framework)))
}
function $as_Lsbt_testing_Framework(obj) {
  return (($is_Lsbt_testing_Framework(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.Framework"))
}
function $isArrayOf_Lsbt_testing_Framework(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_Framework)))
}
function $asArrayOf_Lsbt_testing_Framework(obj, depth) {
  return (($isArrayOf_Lsbt_testing_Framework(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.Framework;", depth))
}
var $d_Lsbt_testing_Framework = new $TypeData().initClass({
  Lsbt_testing_Framework: 0
}, true, "sbt.testing.Framework", {
  Lsbt_testing_Framework: 1
});
var $d_Lsbt_testing_Logger = new $TypeData().initClass({
  Lsbt_testing_Logger: 0
}, true, "sbt.testing.Logger", {
  Lsbt_testing_Logger: 1
});
function $is_Lsbt_testing_Task(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_Task)))
}
function $as_Lsbt_testing_Task(obj) {
  return (($is_Lsbt_testing_Task(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.Task"))
}
function $isArrayOf_Lsbt_testing_Task(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_Task)))
}
function $asArrayOf_Lsbt_testing_Task(obj, depth) {
  return (($isArrayOf_Lsbt_testing_Task(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.Task;", depth))
}
var $d_Lsbt_testing_Task = new $TypeData().initClass({
  Lsbt_testing_Task: 0
}, true, "sbt.testing.Task", {
  Lsbt_testing_Task: 1
});
function $f_Lscribe_LogHandler__accepts__D__Z($thiz, value) {
  return (value >= $thiz.level$1.value$1)
}
function $f_Lscribe_LogHandler__log__Lscribe_LogRecord__V($thiz, record) {
  var value = record.scribe$LogRecord$$$undvalue$1;
  if ($f_Lscribe_LogHandler__accepts__D__Z($thiz, value)) {
    $thiz.writer$1.write__Lscribe_LogRecord__Lscribe_formatter_Formatter__V(record, $thiz.formatter$1)
  }
}
function $is_Lscribe_LogHandler(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lscribe_LogHandler)))
}
function $as_Lscribe_LogHandler(obj) {
  return (($is_Lscribe_LogHandler(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scribe.LogHandler"))
}
function $isArrayOf_Lscribe_LogHandler(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lscribe_LogHandler)))
}
function $asArrayOf_Lscribe_LogHandler(obj, depth) {
  return (($isArrayOf_Lscribe_LogHandler(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscribe.LogHandler;", depth))
}
function $f_Lscribe_LoggerSupport__$$init$__V($thiz) {
  $thiz.handlers$und$eq__sci_Set__V($m_sci_Set$EmptySet$())
}
function $f_Lscribe_LoggerSupport__addHandler__Lscribe_LogHandler__V($thiz, handler) {
  $thiz.handlers$und$eq__sci_Set__V($as_sci_Set($thiz.handlers__sci_Set().$$plus__O__sc_Set(handler)))
}
function $f_Lscribe_LoggerSupport__log__Lscribe_Level__F0__T__s_Option__I__V($thiz, level, message, className, methodName, lineNumber) {
  var value = level.value$1;
  if ($f_Lscribe_LoggerSupport__accepts__D__Z($thiz, value)) {
    var record = $m_Lscribe_LogRecord$().apply__Lscribe_Level__D__F0__T__s_Option__I__J__T__J__Lscribe_LogRecord(level, (level.value$1 * $thiz.multiplier__D()), message, className, methodName, lineNumber, ($m_Lscribe_LogRecord$(), $m_jl_Thread$(), new $c_sjsr_RuntimeLong().init___I__I(1, 0)), ($m_Lscribe_LogRecord$(), $m_jl_Thread$().SingleThread$1.name$1), ($m_Lscribe_LogRecord$(), $m_jl_System$().currentTimeMillis__J()));
    $f_Lscribe_LoggerSupport__log__Lscribe_LogRecord__V($thiz, record)
  }
}
function $f_Lscribe_LoggerSupport__parent__s_Option($thiz) {
  var this$1 = $thiz.parentName__s_Option();
  if (this$1.isEmpty__Z()) {
    return $m_s_None$()
  } else {
    var arg1 = this$1.get__O();
    var name = $as_T(arg1);
    return new $c_s_Some().init___O($m_Lscribe_Logger$().byName__T__Lscribe_Logger(name))
  }
}
function $f_Lscribe_LoggerSupport__accepts__D__Z($thiz, value) {
  var v = (value * $thiz.multiplier__D());
  if ($thiz.handlers__sci_Set().exists__F1__Z(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, v$1) {
    return (function(handler$2) {
      var handler = $as_Lscribe_LogHandler(handler$2);
      return $f_Lscribe_LogHandler__accepts__D__Z(handler, v$1)
    })
  })($thiz, v)))) {
    return true
  } else {
    var this$1 = $f_Lscribe_LoggerSupport__parent__s_Option($thiz);
    if ((!this$1.isEmpty__Z())) {
      var arg1 = this$1.get__O();
      var p = $as_Lscribe_Logger(arg1);
      return $f_Lscribe_LoggerSupport__accepts__D__Z(p, v)
    } else {
      return false
    }
  }
}
function $f_Lscribe_LoggerSupport__log__Lscribe_LogRecord__V($thiz, record) {
  $thiz.handlers__sci_Set().foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, record$1) {
    return (function(h$2) {
      var h = $as_Lscribe_LogHandler(h$2);
      $f_Lscribe_LogHandler__log__Lscribe_LogRecord__V(h, record$1)
    })
  })($thiz, record)));
  var this$1 = $f_Lscribe_LoggerSupport__parent__s_Option($thiz);
  if ((!this$1.isEmpty__Z())) {
    var arg1 = this$1.get__O();
    var p = $as_Lscribe_Logger(arg1);
    var record$2 = record.updateValue__D__Lscribe_LogRecord((record.scribe$LogRecord$$$undvalue$1 * p.multiplier$1));
    $f_Lscribe_LoggerSupport__log__Lscribe_LogRecord__V(p, record$2)
  }
}
function $f_Lupickle_GeneratedUtil__arrayToMap__sc_Seq__AT__ALupickle_Js$Value__sc_Seq($thiz, a, names, defaults) {
  var accumulated = $newArrayObject($d_T2.getArrayOf(), [names.u.length]);
  var i = 0;
  var l = a.length__I();
  while ((i < l)) {
    var x = defaults.get(i);
    var x$2 = a.apply__I__O(i);
    if ((!((x === null) ? (x$2 === null) : x.equals__O__Z(x$2)))) {
      var jsx$1 = i;
      var self = names.get(i);
      var y = a.apply__I__O(i);
      accumulated.set(jsx$1, new $c_T2().init___O__O(self, y))
    };
    i = ((1 + i) | 0)
  };
  var jsx$2 = $m_s_Predef$();
  var b = new $c_scm_ArrayBuilder$ofRef().init___s_reflect_ClassTag(new $c_s_reflect_ClassTag$GenericClassTag().init___jl_Class($d_T2.getClassOf()));
  var i$1 = 0;
  var len = accumulated.u.length;
  while ((i$1 < len)) {
    var index = i$1;
    var arg1 = accumulated.get(index);
    var x$1 = $as_T2(arg1);
    if (((x$1 !== null) !== false)) {
      b.$$plus$eq__O__scm_ArrayBuilder$ofRef(arg1)
    };
    i$1 = ((1 + i$1) | 0)
  };
  return jsx$2.wrapRefArray__AO__scm_WrappedArray(b.result__AO())
}
function $is_Lupickle_GeneratedUtil(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lupickle_GeneratedUtil)))
}
function $as_Lupickle_GeneratedUtil(obj) {
  return (($is_Lupickle_GeneratedUtil(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "upickle.GeneratedUtil"))
}
function $isArrayOf_Lupickle_GeneratedUtil(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lupickle_GeneratedUtil)))
}
function $asArrayOf_Lupickle_GeneratedUtil(obj, depth) {
  return (($isArrayOf_Lupickle_GeneratedUtil(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lupickle.GeneratedUtil;", depth))
}
function $is_Lupickle_Js$Value(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lupickle_Js$Value)))
}
function $as_Lupickle_Js$Value(obj) {
  return (($is_Lupickle_Js$Value(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "upickle.Js$Value"))
}
function $isArrayOf_Lupickle_Js$Value(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lupickle_Js$Value)))
}
function $asArrayOf_Lupickle_Js$Value(obj, depth) {
  return (($isArrayOf_Lupickle_Js$Value(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lupickle.Js$Value;", depth))
}
var $d_Lupickle_Js$Value = new $TypeData().initClass({
  Lupickle_Js$Value: 0
}, true, "upickle.Js$Value", {
  Lupickle_Js$Value: 1
});
function $f_Lupickle_Types__readJs__Lupickle_Js$Value__Lupickle_Types$Reader__O($thiz, expr, evidence$4) {
  return evidence$4.read__s_PartialFunction().apply__O__O(expr)
}
function $f_Lupickle_Types__write__O__I__Lupickle_Types$Writer__T($thiz, expr, indent, evidence$1) {
  return $m_Lupickle_json_package$().write__Lupickle_Js$Value__I__T($f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($thiz, expr, evidence$1), indent)
}
function $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($thiz, expr, evidence$2) {
  return $as_Lupickle_Js$Value(evidence$2.write__F1().apply__O__O(expr))
}
function $f_Lupickle_Types__read__T__Lupickle_Types$Reader__O($thiz, expr, evidence$3) {
  var expr$1 = $m_Lupickle_json_package$().read__T__Lupickle_Js$Value(expr);
  return $f_Lupickle_Types__readJs__Lupickle_Js$Value__Lupickle_Types$Reader__O($thiz, expr$1, evidence$3)
}
function $f_Lupickle_Types$Reader__$$init$__V($thiz) {
  $thiz.upickle$Types$Reader$$undsetter$und$upickle$Types$Reader$$readNull$und$eq__s_PartialFunction__V(new $c_Lupickle_Types$Reader$$anonfun$upickle$Types$Reader$$readNull$1().init___Lupickle_Types$Reader($thiz));
  $thiz.upickle$Types$Reader$$undsetter$und$read$und$eq__s_PartialFunction__V(new $c_Lupickle_Types$Reader$$anon$2().init___Lupickle_Types$Reader($thiz))
}
function $is_Lupickle_Types$Reader(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lupickle_Types$Reader)))
}
function $as_Lupickle_Types$Reader(obj) {
  return (($is_Lupickle_Types$Reader(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "upickle.Types$Reader"))
}
function $isArrayOf_Lupickle_Types$Reader(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lupickle_Types$Reader)))
}
function $asArrayOf_Lupickle_Types$Reader(obj, depth) {
  return (($isArrayOf_Lupickle_Types$Reader(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lupickle.Types$Reader;", depth))
}
function $f_Lupickle_Types$Writer__$$init$__V($thiz) {
  $thiz.upickle$Types$Writer$$undsetter$und$write$und$eq__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$1$2) {
      return ((x0$1$2 === null) ? $m_Lupickle_Js$Null$() : $as_Lupickle_Js$Value($this.write0__F1().apply__O__O(x0$1$2)))
    })
  })($thiz)))
}
function $is_Lupickle_Types$Writer(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lupickle_Types$Writer)))
}
function $as_Lupickle_Types$Writer(obj) {
  return (($is_Lupickle_Types$Writer(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "upickle.Types$Writer"))
}
function $isArrayOf_Lupickle_Types$Writer(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lupickle_Types$Writer)))
}
function $asArrayOf_Lupickle_Types$Writer(obj, depth) {
  return (($isArrayOf_Lupickle_Types$Writer(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lupickle.Types$Writer;", depth))
}
/** @constructor */
function $c_O() {
  /*<skip>*/
}
/** @constructor */
function $h_O() {
  /*<skip>*/
}
$h_O.prototype = $c_O.prototype;
$c_O.prototype.init___ = (function() {
  return this
});
$c_O.prototype.equals__O__Z = (function(that) {
  return (this === that)
});
$c_O.prototype.toString__T = (function() {
  var jsx$2 = $objectGetClass(this).getName__T();
  var i = this.hashCode__I();
  var x = $uD((i >>> 0));
  var jsx$1 = x.toString(16);
  return ((jsx$2 + "@") + $as_T(jsx$1))
});
$c_O.prototype.hashCode__I = (function() {
  return $systemIdentityHashCode(this)
});
$c_O.prototype.toString = (function() {
  return this.toString__T()
});
function $is_O(obj) {
  return (obj !== null)
}
function $as_O(obj) {
  return obj
}
function $isArrayOf_O(obj, depth) {
  var data = (obj && obj.$classData);
  if ((!data)) {
    return false
  } else {
    var arrayDepth = (data.arrayDepth || 0);
    return ((!(arrayDepth < depth)) && ((arrayDepth > depth) || (!data.arrayBase.isPrimitive)))
  }
}
function $asArrayOf_O(obj, depth) {
  return (($isArrayOf_O(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Object;", depth))
}
var $d_O = new $TypeData().initClass({
  O: 0
}, false, "java.lang.Object", {
  O: 1
}, (void 0), (void 0), $is_O, $isArrayOf_O);
$c_O.prototype.$classData = $d_O;
function $is_jl_CharSequence(obj) {
  return (!(!(((obj && obj.$classData) && obj.$classData.ancestors.jl_CharSequence) || ((typeof obj) === "string"))))
}
function $as_jl_CharSequence(obj) {
  return (($is_jl_CharSequence(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.CharSequence"))
}
function $isArrayOf_jl_CharSequence(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_CharSequence)))
}
function $asArrayOf_jl_CharSequence(obj, depth) {
  return (($isArrayOf_jl_CharSequence(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.CharSequence;", depth))
}
function $is_jl_Comparable(obj) {
  return (!(!(((((obj && obj.$classData) && obj.$classData.ancestors.jl_Comparable) || ((typeof obj) === "string")) || ((typeof obj) === "number")) || ((typeof obj) === "boolean"))))
}
function $as_jl_Comparable(obj) {
  return (($is_jl_Comparable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Comparable"))
}
function $isArrayOf_jl_Comparable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Comparable)))
}
function $asArrayOf_jl_Comparable(obj, depth) {
  return (($isArrayOf_jl_Comparable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Comparable;", depth))
}
function $is_jl_Runnable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.jl_Runnable)))
}
function $as_jl_Runnable(obj) {
  return (($is_jl_Runnable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Runnable"))
}
function $isArrayOf_jl_Runnable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Runnable)))
}
function $asArrayOf_jl_Runnable(obj, depth) {
  return (($isArrayOf_jl_Runnable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Runnable;", depth))
}
function $is_ju_Formattable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.ju_Formattable)))
}
function $as_ju_Formattable(obj) {
  return (($is_ju_Formattable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.util.Formattable"))
}
function $isArrayOf_ju_Formattable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.ju_Formattable)))
}
function $asArrayOf_ju_Formattable(obj, depth) {
  return (($isArrayOf_ju_Formattable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.util.Formattable;", depth))
}
function $f_s_Proxy__equals__O__Z($thiz, that) {
  return ((that !== null) && (((that === $thiz) || (that === $thiz.self__O())) || $objectEquals(that, $thiz.self__O())))
}
function $f_s_Proxy__toString__T($thiz) {
  return ("" + $thiz.self__O())
}
function $is_s_concurrent_BlockContext(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_concurrent_BlockContext)))
}
function $as_s_concurrent_BlockContext(obj) {
  return (($is_s_concurrent_BlockContext(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.concurrent.BlockContext"))
}
function $isArrayOf_s_concurrent_BlockContext(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_concurrent_BlockContext)))
}
function $asArrayOf_s_concurrent_BlockContext(obj, depth) {
  return (($isArrayOf_s_concurrent_BlockContext(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.concurrent.BlockContext;", depth))
}
function $is_s_concurrent_OnCompleteRunnable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_concurrent_OnCompleteRunnable)))
}
function $as_s_concurrent_OnCompleteRunnable(obj) {
  return (($is_s_concurrent_OnCompleteRunnable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.concurrent.OnCompleteRunnable"))
}
function $isArrayOf_s_concurrent_OnCompleteRunnable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_concurrent_OnCompleteRunnable)))
}
function $asArrayOf_s_concurrent_OnCompleteRunnable(obj, depth) {
  return (($isArrayOf_s_concurrent_OnCompleteRunnable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.concurrent.OnCompleteRunnable;", depth))
}
function $f_s_concurrent_Promise__failure__jl_Throwable__s_concurrent_Promise($thiz, cause) {
  var result = new $c_s_util_Failure().init___jl_Throwable(cause);
  return $f_s_concurrent_Promise__complete__s_util_Try__s_concurrent_Promise($thiz, result)
}
function $f_s_concurrent_Promise__tryCompleteWith__s_concurrent_Future__s_concurrent_Promise($thiz, other) {
  if ((other !== $thiz)) {
    other.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
      return (function(x$1$2) {
        var x$1 = $as_s_util_Try(x$1$2);
        return $this.tryComplete__s_util_Try__Z(x$1)
      })
    })($thiz)), $m_s_concurrent_Future$InternalCallbackExecutor$())
  };
  return $thiz
}
function $f_s_concurrent_Promise__complete__s_util_Try__s_concurrent_Promise($thiz, result) {
  if ($thiz.tryComplete__s_util_Try__Z(result)) {
    return $thiz
  } else {
    throw new $c_jl_IllegalStateException().init___T("Promise already completed.")
  }
}
function $f_s_concurrent_Promise__success__O__s_concurrent_Promise($thiz, value) {
  var result = new $c_s_util_Success().init___O(value);
  return $f_s_concurrent_Promise__complete__s_util_Try__s_concurrent_Promise($thiz, result)
}
function $f_s_math_ScalaNumericAnyConversions__unifiedPrimitiveEquals__O__Z($thiz, x) {
  if ($is_jl_Character(x)) {
    if ((x === null)) {
      var x2 = 0
    } else {
      var this$2 = $as_jl_Character(x);
      var x2 = this$2.value$1
    };
    return ($thiz.isValidChar__Z() && ($thiz.intValue__I() === x2))
  } else if ($isByte(x)) {
    var x3 = $uB(x);
    return ($thiz.isValidByte__Z() && ($thiz.byteValue__B() === x3))
  } else if ($isShort(x)) {
    var x4 = $uS(x);
    return ($thiz.isValidShort__Z() && ($thiz.shortValue__S() === x4))
  } else if ($isInt(x)) {
    var x5 = $uI(x);
    return ($thiz.isValidInt__Z() && ($thiz.intValue__I() === x5))
  } else if ($is_sjsr_RuntimeLong(x)) {
    var t = $uJ(x);
    var lo = t.lo$2;
    var hi = t.hi$2;
    var t$1 = $thiz.longValue__J();
    var lo$1 = t$1.lo$2;
    var hi$1 = t$1.hi$2;
    return ((lo$1 === lo) && (hi$1 === hi))
  } else if ($isFloat(x)) {
    var x7 = $uF(x);
    return ($thiz.floatValue__F() === x7)
  } else if (((typeof x) === "number")) {
    var x8 = $uD(x);
    return ($thiz.doubleValue__D() === x8)
  } else {
    return false
  }
}
function $f_s_math_ScalaNumericAnyConversions__unifiedPrimitiveHashcode__I($thiz) {
  var t = $thiz.longValue__J();
  var lo = t.lo$2;
  var hi = t.hi$2;
  return ((((hi === (-1)) ? (((-2147483648) ^ lo) >= 0) : (hi > (-1))) && ((hi === 0) ? (((-2147483648) ^ lo) <= (-1)) : (hi < 0))) ? lo : $m_sr_Statics$().longHash__J__I(new $c_sjsr_RuntimeLong().init___I__I(lo, hi)))
}
function $f_s_util_control_NoStackTrace__fillInStackTrace__jl_Throwable($thiz) {
  var this$1 = $m_s_util_control_NoStackTrace$();
  if (this$1.$$undnoSuppression$1) {
    return $c_jl_Throwable.prototype.fillInStackTrace__jl_Throwable.call($thiz)
  } else {
    return $as_jl_Throwable($thiz)
  }
}
function $f_s_util_matching_Regex$MatchData__matched__T($thiz) {
  return (($thiz.start__I() >= 0) ? $objectToString($charSequenceSubSequence($thiz.source__jl_CharSequence(), $thiz.start__I(), $thiz.end__I())) : null)
}
function $f_s_util_matching_Regex$MatchData__group__I__T($thiz, i) {
  return (($thiz.start__I__I(i) >= 0) ? $objectToString($charSequenceSubSequence($thiz.source__jl_CharSequence(), $thiz.start__I__I(i), $thiz.end__I__I(i))) : null)
}
function $f_s_util_matching_Regex$Replacement__replaced__T($thiz) {
  var newsb = new $c_jl_StringBuffer().init___jl_CharSequence($thiz.scala$util$matching$Regex$Replacement$$sb$2);
  $thiz.matcher__ju_regex_Matcher().appendTail__jl_StringBuffer__jl_StringBuffer(newsb);
  return newsb.content$1
}
function $is_sc_GenTraversableOnce(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.sc_GenTraversableOnce)))
}
function $as_sc_GenTraversableOnce(obj) {
  return (($is_sc_GenTraversableOnce(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.collection.GenTraversableOnce"))
}
function $isArrayOf_sc_GenTraversableOnce(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.sc_GenTraversableOnce)))
}
function $asArrayOf_sc_GenTraversableOnce(obj, depth) {
  return (($isArrayOf_sc_GenTraversableOnce(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.collection.GenTraversableOnce;", depth))
}
function $f_sci_VectorPointer__copyOf__AO__AO($thiz, a) {
  var copy = $newArrayObject($d_O.getArrayOf(), [a.u.length]);
  $systemArraycopy(a, 0, copy, 0, a.u.length);
  return copy
}
function $f_sci_VectorPointer__gotoNextBlockStart__I__I__V($thiz, index, xor) {
  if ((xor < 1024)) {
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
  } else if ((xor < 32768)) {
    $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get(0), 1))
  } else if ((xor < 1048576)) {
    $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1));
    $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get(0), 1));
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get(0), 1))
  } else if ((xor < 33554432)) {
    $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((index >>> 20) | 0))), 1));
    $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get(0), 1));
    $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get(0), 1));
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get(0), 1))
  } else if ((xor < 1073741824)) {
    $thiz.display4$und$eq__AO__V($asArrayOf_O($thiz.display5__AO().get((31 & ((index >>> 25) | 0))), 1));
    $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get(0), 1));
    $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get(0), 1));
    $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get(0), 1));
    $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get(0), 1))
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $f_sci_VectorPointer__gotoFreshPosWritable1__I__I__I__V($thiz, oldIndex, newIndex, xor) {
  $f_sci_VectorPointer__stabilize__I__V($thiz, oldIndex);
  $f_sci_VectorPointer__gotoFreshPosWritable0__I__I__I__V($thiz, oldIndex, newIndex, xor)
}
function $f_sci_VectorPointer__getElem__I__I__O($thiz, index, xor) {
  if ((xor < 32)) {
    return $thiz.display0__AO().get((31 & index))
  } else if ((xor < 1024)) {
    return $asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else if ((xor < 32768)) {
    return $asArrayOf_O($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1).get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else if ((xor < 1048576)) {
    return $asArrayOf_O($asArrayOf_O($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1).get((31 & ((index >>> 10) | 0))), 1).get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else if ((xor < 33554432)) {
    return $asArrayOf_O($asArrayOf_O($asArrayOf_O($asArrayOf_O($thiz.display4__AO().get((31 & ((index >>> 20) | 0))), 1).get((31 & ((index >>> 15) | 0))), 1).get((31 & ((index >>> 10) | 0))), 1).get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else if ((xor < 1073741824)) {
    return $asArrayOf_O($asArrayOf_O($asArrayOf_O($asArrayOf_O($asArrayOf_O($thiz.display5__AO().get((31 & ((index >>> 25) | 0))), 1).get((31 & ((index >>> 20) | 0))), 1).get((31 & ((index >>> 15) | 0))), 1).get((31 & ((index >>> 10) | 0))), 1).get((31 & ((index >>> 5) | 0))), 1).get((31 & index))
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $f_sci_VectorPointer__gotoFreshPosWritable0__I__I__I__V($thiz, oldIndex, newIndex, xor) {
  if ((xor >= 32)) {
    if ((xor < 1024)) {
      if (($thiz.depth__I() === 1)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 32768)) {
      if (($thiz.depth__I() === 2)) {
        $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((newIndex >>> 10) | 0))), 1));
      if (($thiz.display1__AO() === null)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 1048576)) {
      if (($thiz.depth__I() === 3)) {
        $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display3__AO().set((31 & ((oldIndex >>> 15) | 0)), $thiz.display2__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((newIndex >>> 15) | 0))), 1));
      if (($thiz.display2__AO() === null)) {
        $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((newIndex >>> 10) | 0))), 1));
      if (($thiz.display1__AO() === null)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 33554432)) {
      if (($thiz.depth__I() === 4)) {
        $thiz.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display4__AO().set((31 & ((oldIndex >>> 20) | 0)), $thiz.display3__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((newIndex >>> 20) | 0))), 1));
      if (($thiz.display3__AO() === null)) {
        $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((newIndex >>> 15) | 0))), 1));
      if (($thiz.display2__AO() === null)) {
        $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((newIndex >>> 10) | 0))), 1));
      if (($thiz.display1__AO() === null)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else if ((xor < 1073741824)) {
      if (($thiz.depth__I() === 5)) {
        $thiz.display5$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
        $thiz.display5__AO().set((31 & ((oldIndex >>> 25) | 0)), $thiz.display4__AO());
        $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
      };
      $thiz.display4$und$eq__AO__V($asArrayOf_O($thiz.display5__AO().get((31 & ((newIndex >>> 25) | 0))), 1));
      if (($thiz.display4__AO() === null)) {
        $thiz.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((newIndex >>> 20) | 0))), 1));
      if (($thiz.display3__AO() === null)) {
        $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((newIndex >>> 15) | 0))), 1));
      if (($thiz.display2__AO() === null)) {
        $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((newIndex >>> 10) | 0))), 1));
      if (($thiz.display1__AO() === null)) {
        $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
      };
      $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]))
    } else {
      throw new $c_jl_IllegalArgumentException().init___()
    }
  }
}
function $f_sci_VectorPointer__gotoPosWritable1__I__I__I__V($thiz, oldIndex, newIndex, xor) {
  if ((xor < 32)) {
    var a = $thiz.display0__AO();
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a))
  } else if ((xor < 1024)) {
    var a$1 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$1));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    var array = $thiz.display1__AO();
    var index = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array, index))
  } else if ((xor < 32768)) {
    var a$2 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$2));
    var a$3 = $thiz.display2__AO();
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$3));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
    var array$1 = $thiz.display2__AO();
    var index$1 = (31 & ((newIndex >>> 10) | 0));
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$1, index$1));
    var array$2 = $thiz.display1__AO();
    var index$2 = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$2, index$2))
  } else if ((xor < 1048576)) {
    var a$4 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$4));
    var a$5 = $thiz.display2__AO();
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$5));
    var a$6 = $thiz.display3__AO();
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$6));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((oldIndex >>> 15) | 0)), $thiz.display2__AO());
    var array$3 = $thiz.display3__AO();
    var index$3 = (31 & ((newIndex >>> 15) | 0));
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$3, index$3));
    var array$4 = $thiz.display2__AO();
    var index$4 = (31 & ((newIndex >>> 10) | 0));
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$4, index$4));
    var array$5 = $thiz.display1__AO();
    var index$5 = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$5, index$5))
  } else if ((xor < 33554432)) {
    var a$7 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$7));
    var a$8 = $thiz.display2__AO();
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$8));
    var a$9 = $thiz.display3__AO();
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$9));
    var a$10 = $thiz.display4__AO();
    $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$10));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((oldIndex >>> 15) | 0)), $thiz.display2__AO());
    $thiz.display4__AO().set((31 & ((oldIndex >>> 20) | 0)), $thiz.display3__AO());
    var array$6 = $thiz.display4__AO();
    var index$6 = (31 & ((newIndex >>> 20) | 0));
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$6, index$6));
    var array$7 = $thiz.display3__AO();
    var index$7 = (31 & ((newIndex >>> 15) | 0));
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$7, index$7));
    var array$8 = $thiz.display2__AO();
    var index$8 = (31 & ((newIndex >>> 10) | 0));
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$8, index$8));
    var array$9 = $thiz.display1__AO();
    var index$9 = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$9, index$9))
  } else if ((xor < 1073741824)) {
    var a$11 = $thiz.display1__AO();
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$11));
    var a$12 = $thiz.display2__AO();
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$12));
    var a$13 = $thiz.display3__AO();
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$13));
    var a$14 = $thiz.display4__AO();
    $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$14));
    var a$15 = $thiz.display5__AO();
    $thiz.display5$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$15));
    $thiz.display1__AO().set((31 & ((oldIndex >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((oldIndex >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((oldIndex >>> 15) | 0)), $thiz.display2__AO());
    $thiz.display4__AO().set((31 & ((oldIndex >>> 20) | 0)), $thiz.display3__AO());
    $thiz.display5__AO().set((31 & ((oldIndex >>> 25) | 0)), $thiz.display4__AO());
    var array$10 = $thiz.display5__AO();
    var index$10 = (31 & ((newIndex >>> 25) | 0));
    $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$10, index$10));
    var array$11 = $thiz.display4__AO();
    var index$11 = (31 & ((newIndex >>> 20) | 0));
    $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$11, index$11));
    var array$12 = $thiz.display3__AO();
    var index$12 = (31 & ((newIndex >>> 15) | 0));
    $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$12, index$12));
    var array$13 = $thiz.display2__AO();
    var index$13 = (31 & ((newIndex >>> 10) | 0));
    $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$13, index$13));
    var array$14 = $thiz.display1__AO();
    var index$14 = (31 & ((newIndex >>> 5) | 0));
    $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$14, index$14))
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
function $f_sci_VectorPointer__copyRange__AO__I__I__AO($thiz, array, oldLeft, newLeft) {
  var elems = $newArrayObject($d_O.getArrayOf(), [32]);
  $systemArraycopy(array, oldLeft, elems, newLeft, ((32 - ((newLeft > oldLeft) ? newLeft : oldLeft)) | 0));
  return elems
}
function $f_sci_VectorPointer__gotoPos__I__I__V($thiz, index, xor) {
  if ((xor >= 32)) {
    if ((xor < 1024)) {
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else if ((xor < 32768)) {
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else if ((xor < 1048576)) {
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1));
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else if ((xor < 33554432)) {
      $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((index >>> 20) | 0))), 1));
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1));
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else if ((xor < 1073741824)) {
      $thiz.display4$und$eq__AO__V($asArrayOf_O($thiz.display5__AO().get((31 & ((index >>> 25) | 0))), 1));
      $thiz.display3$und$eq__AO__V($asArrayOf_O($thiz.display4__AO().get((31 & ((index >>> 20) | 0))), 1));
      $thiz.display2$und$eq__AO__V($asArrayOf_O($thiz.display3__AO().get((31 & ((index >>> 15) | 0))), 1));
      $thiz.display1$und$eq__AO__V($asArrayOf_O($thiz.display2__AO().get((31 & ((index >>> 10) | 0))), 1));
      $thiz.display0$und$eq__AO__V($asArrayOf_O($thiz.display1__AO().get((31 & ((index >>> 5) | 0))), 1))
    } else {
      throw new $c_jl_IllegalArgumentException().init___()
    }
  }
}
function $f_sci_VectorPointer__gotoPosWritable0__I__I__V($thiz, newIndex, xor) {
  var x1 = (((-1) + $thiz.depth__I()) | 0);
  switch (x1) {
    case 5: {
      var a = $thiz.display5__AO();
      $thiz.display5$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a));
      var array = $thiz.display5__AO();
      var index = (31 & ((newIndex >>> 25) | 0));
      $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array, index));
      var array$1 = $thiz.display4__AO();
      var index$1 = (31 & ((newIndex >>> 20) | 0));
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$1, index$1));
      var array$2 = $thiz.display3__AO();
      var index$2 = (31 & ((newIndex >>> 15) | 0));
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$2, index$2));
      var array$3 = $thiz.display2__AO();
      var index$3 = (31 & ((newIndex >>> 10) | 0));
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$3, index$3));
      var array$4 = $thiz.display1__AO();
      var index$4 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$4, index$4));
      break
    }
    case 4: {
      var a$1 = $thiz.display4__AO();
      $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$1));
      var array$5 = $thiz.display4__AO();
      var index$5 = (31 & ((newIndex >>> 20) | 0));
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$5, index$5));
      var array$6 = $thiz.display3__AO();
      var index$6 = (31 & ((newIndex >>> 15) | 0));
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$6, index$6));
      var array$7 = $thiz.display2__AO();
      var index$7 = (31 & ((newIndex >>> 10) | 0));
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$7, index$7));
      var array$8 = $thiz.display1__AO();
      var index$8 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$8, index$8));
      break
    }
    case 3: {
      var a$2 = $thiz.display3__AO();
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$2));
      var array$9 = $thiz.display3__AO();
      var index$9 = (31 & ((newIndex >>> 15) | 0));
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$9, index$9));
      var array$10 = $thiz.display2__AO();
      var index$10 = (31 & ((newIndex >>> 10) | 0));
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$10, index$10));
      var array$11 = $thiz.display1__AO();
      var index$11 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$11, index$11));
      break
    }
    case 2: {
      var a$3 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$3));
      var array$12 = $thiz.display2__AO();
      var index$12 = (31 & ((newIndex >>> 10) | 0));
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$12, index$12));
      var array$13 = $thiz.display1__AO();
      var index$13 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$13, index$13));
      break
    }
    case 1: {
      var a$4 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$4));
      var array$14 = $thiz.display1__AO();
      var index$14 = (31 & ((newIndex >>> 5) | 0));
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array$14, index$14));
      break
    }
    case 0: {
      var a$5 = $thiz.display0__AO();
      $thiz.display0$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$5));
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $f_sci_VectorPointer__stabilize__I__V($thiz, index) {
  var x1 = (((-1) + $thiz.depth__I()) | 0);
  switch (x1) {
    case 5: {
      var a = $thiz.display5__AO();
      $thiz.display5$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a));
      var a$1 = $thiz.display4__AO();
      $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$1));
      var a$2 = $thiz.display3__AO();
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$2));
      var a$3 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$3));
      var a$4 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$4));
      $thiz.display5__AO().set((31 & ((index >>> 25) | 0)), $thiz.display4__AO());
      $thiz.display4__AO().set((31 & ((index >>> 20) | 0)), $thiz.display3__AO());
      $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
      $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 4: {
      var a$5 = $thiz.display4__AO();
      $thiz.display4$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$5));
      var a$6 = $thiz.display3__AO();
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$6));
      var a$7 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$7));
      var a$8 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$8));
      $thiz.display4__AO().set((31 & ((index >>> 20) | 0)), $thiz.display3__AO());
      $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
      $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 3: {
      var a$9 = $thiz.display3__AO();
      $thiz.display3$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$9));
      var a$10 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$10));
      var a$11 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$11));
      $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
      $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 2: {
      var a$12 = $thiz.display2__AO();
      $thiz.display2$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$12));
      var a$13 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$13));
      $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 1: {
      var a$14 = $thiz.display1__AO();
      $thiz.display1$und$eq__AO__V($f_sci_VectorPointer__copyOf__AO__AO($thiz, a$14));
      $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
      break
    }
    case 0: {
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $f_sci_VectorPointer__nullSlotAndCopy__AO__I__AO($thiz, array, index) {
  var x = array.get(index);
  array.set(index, null);
  var a = $asArrayOf_O(x, 1);
  return $f_sci_VectorPointer__copyOf__AO__AO($thiz, a)
}
function $f_sci_VectorPointer__initFrom__sci_VectorPointer__I__V($thiz, that, depth) {
  $thiz.depth$und$eq__I__V(depth);
  var x1 = (((-1) + depth) | 0);
  switch (x1) {
    case (-1): {
      break
    }
    case 0: {
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 1: {
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 2: {
      $thiz.display2$und$eq__AO__V(that.display2__AO());
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 3: {
      $thiz.display3$und$eq__AO__V(that.display3__AO());
      $thiz.display2$und$eq__AO__V(that.display2__AO());
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 4: {
      $thiz.display4$und$eq__AO__V(that.display4__AO());
      $thiz.display3$und$eq__AO__V(that.display3__AO());
      $thiz.display2$und$eq__AO__V(that.display2__AO());
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    case 5: {
      $thiz.display5$und$eq__AO__V(that.display5__AO());
      $thiz.display4$und$eq__AO__V(that.display4__AO());
      $thiz.display3$und$eq__AO__V(that.display3__AO());
      $thiz.display2$und$eq__AO__V(that.display2__AO());
      $thiz.display1$und$eq__AO__V(that.display1__AO());
      $thiz.display0$und$eq__AO__V(that.display0__AO());
      break
    }
    default: {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
}
function $f_sci_VectorPointer__gotoNextBlockStartWritable__I__I__V($thiz, index, xor) {
  if ((xor < 1024)) {
    if (($thiz.depth__I() === 1)) {
      $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display1__AO().set(0, $thiz.display0__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO())
  } else if ((xor < 32768)) {
    if (($thiz.depth__I() === 2)) {
      $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display2__AO().set(0, $thiz.display1__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO())
  } else if ((xor < 1048576)) {
    if (($thiz.depth__I() === 3)) {
      $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display3__AO().set(0, $thiz.display2__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO())
  } else if ((xor < 33554432)) {
    if (($thiz.depth__I() === 4)) {
      $thiz.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display4__AO().set(0, $thiz.display3__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
    $thiz.display4__AO().set((31 & ((index >>> 20) | 0)), $thiz.display3__AO())
  } else if ((xor < 1073741824)) {
    if (($thiz.depth__I() === 5)) {
      $thiz.display5$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
      $thiz.display5__AO().set(0, $thiz.display4__AO());
      $thiz.depth$und$eq__I__V(((1 + $thiz.depth__I()) | 0))
    };
    $thiz.display0$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display2$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display3$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display4$und$eq__AO__V($newArrayObject($d_O.getArrayOf(), [32]));
    $thiz.display1__AO().set((31 & ((index >>> 5) | 0)), $thiz.display0__AO());
    $thiz.display2__AO().set((31 & ((index >>> 10) | 0)), $thiz.display1__AO());
    $thiz.display3__AO().set((31 & ((index >>> 15) | 0)), $thiz.display2__AO());
    $thiz.display4__AO().set((31 & ((index >>> 20) | 0)), $thiz.display3__AO());
    $thiz.display5__AO().set((31 & ((index >>> 25) | 0)), $thiz.display4__AO())
  } else {
    throw new $c_jl_IllegalArgumentException().init___()
  }
}
var $d_scm_HashEntry = new $TypeData().initClass({
  scm_HashEntry: 0
}, true, "scala.collection.mutable.HashEntry", {
  scm_HashEntry: 1
});
function $f_scm_HashTable$HashUtils__improve__I__I__I($thiz, hcode, seed) {
  var i = $m_s_util_hashing_package$().byteswap32__I__I(hcode);
  return (((i >>> seed) | 0) | (i << ((-seed) | 0)))
}
/** @constructor */
function $c_Lcom_outr_pixijs_examples_Basics$() {
  $c_O.call(this)
}
$c_Lcom_outr_pixijs_examples_Basics$.prototype = new $h_O();
$c_Lcom_outr_pixijs_examples_Basics$.prototype.constructor = $c_Lcom_outr_pixijs_examples_Basics$;
/** @constructor */
function $h_Lcom_outr_pixijs_examples_Basics$() {
  /*<skip>*/
}
$h_Lcom_outr_pixijs_examples_Basics$.prototype = $c_Lcom_outr_pixijs_examples_Basics$.prototype;
$c_Lcom_outr_pixijs_examples_Basics$.prototype.init___ = (function() {
  return this
});
$c_Lcom_outr_pixijs_examples_Basics$.prototype.main__V = (function() {
  var jsx$1 = $g.PIXI;
  var $this = {};
  $this.backgroundColor = 1087931;
  var renderer = jsx$1.autoDetectRenderer(800, 600, $this);
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(renderer.view);
  var stage = new $g.PIXI.Container();
  var texture = $g.PIXI.Texture.fromImage("bunny.png");
  var this$2 = new $g.PIXI.Sprite(texture);
  this$2.anchor.x = 0.5;
  this$2.anchor.y = 0.5;
  this$2.position.x = 200.0;
  this$2.position.y = 150.0;
  stage.addChild(this$2);
  this.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__Lcom_outr_pixijs_PIXI_Sprite__V(renderer, stage, this$2)
});
$c_Lcom_outr_pixijs_examples_Basics$.prototype.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__Lcom_outr_pixijs_PIXI_Sprite__V = (function(renderer$1, stage$1, bunny$1) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().requestAnimationFrame((function(renderer$1$1, stage$1$1, bunny$1$1) {
    return (function(arg1$2) {
      $uD(arg1$2);
      var this$1 = $m_Lcom_outr_pixijs_examples_Basics$();
      this$1.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__Lcom_outr_pixijs_PIXI_Sprite__V(renderer$1$1, stage$1$1, bunny$1$1)
    })
  })(renderer$1, stage$1, bunny$1));
  bunny$1.rotation = (0.1 + $uD(bunny$1.rotation));
  renderer$1.render(stage$1)
});
var $d_Lcom_outr_pixijs_examples_Basics$ = new $TypeData().initClass({
  Lcom_outr_pixijs_examples_Basics$: 0
}, false, "com.outr.pixijs.examples.Basics$", {
  Lcom_outr_pixijs_examples_Basics$: 1,
  O: 1
});
$c_Lcom_outr_pixijs_examples_Basics$.prototype.$classData = $d_Lcom_outr_pixijs_examples_Basics$;
var $n_Lcom_outr_pixijs_examples_Basics$ = (void 0);
function $m_Lcom_outr_pixijs_examples_Basics$() {
  if ((!$n_Lcom_outr_pixijs_examples_Basics$)) {
    $n_Lcom_outr_pixijs_examples_Basics$ = new $c_Lcom_outr_pixijs_examples_Basics$().init___()
  };
  return $n_Lcom_outr_pixijs_examples_Basics$
}
/** @constructor */
function $c_Lcom_outr_pixijs_examples_Click$() {
  $c_O.call(this)
}
$c_Lcom_outr_pixijs_examples_Click$.prototype = new $h_O();
$c_Lcom_outr_pixijs_examples_Click$.prototype.constructor = $c_Lcom_outr_pixijs_examples_Click$;
/** @constructor */
function $h_Lcom_outr_pixijs_examples_Click$() {
  /*<skip>*/
}
$h_Lcom_outr_pixijs_examples_Click$.prototype = $c_Lcom_outr_pixijs_examples_Click$.prototype;
$c_Lcom_outr_pixijs_examples_Click$.prototype.init___ = (function() {
  return this
});
$c_Lcom_outr_pixijs_examples_Click$.prototype.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V = (function(renderer$1, stage$1) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().requestAnimationFrame((function(renderer$1$1, stage$1$1) {
    return (function(arg1$2) {
      $uD(arg1$2);
      var this$1 = $m_Lcom_outr_pixijs_examples_Click$();
      this$1.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V(renderer$1$1, stage$1$1)
    })
  })(renderer$1, stage$1));
  renderer$1.render(stage$1)
});
$c_Lcom_outr_pixijs_examples_Click$.prototype.main__V = (function() {
  var jsx$1 = $g.PIXI;
  var $this = {};
  $this.backgroundColor = 1087931;
  var renderer = jsx$1.autoDetectRenderer(800, 600, $this);
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(renderer.view);
  var stage = new $g.PIXI.Container();
  var sprite = $g.PIXI.Sprite.fromImage("bunny.png");
  var onDown = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, sprite$1) {
    return (function() {
      var ev$1 = sprite$1.scale;
      ev$1.x = (0.3 + $uD(ev$1.x));
      var ev$2 = sprite$1.scale;
      ev$2.y = (0.3 + $uD(ev$2.y))
    })
  })(this, sprite));
  sprite.position.set(230.0, 264.0);
  sprite.interactive = true;
  sprite.on("mousedown", (function(f) {
    return (function() {
      return f.apply__O()
    })
  })(onDown));
  sprite.on("touchstart", (function(f$1) {
    return (function() {
      return f$1.apply__O()
    })
  })(onDown));
  stage.addChild(sprite);
  this.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V(renderer, stage)
});
var $d_Lcom_outr_pixijs_examples_Click$ = new $TypeData().initClass({
  Lcom_outr_pixijs_examples_Click$: 0
}, false, "com.outr.pixijs.examples.Click$", {
  Lcom_outr_pixijs_examples_Click$: 1,
  O: 1
});
$c_Lcom_outr_pixijs_examples_Click$.prototype.$classData = $d_Lcom_outr_pixijs_examples_Click$;
var $n_Lcom_outr_pixijs_examples_Click$ = (void 0);
function $m_Lcom_outr_pixijs_examples_Click$() {
  if ((!$n_Lcom_outr_pixijs_examples_Click$)) {
    $n_Lcom_outr_pixijs_examples_Click$ = new $c_Lcom_outr_pixijs_examples_Click$().init___()
  };
  return $n_Lcom_outr_pixijs_examples_Click$
}
/** @constructor */
function $c_Lcom_outr_pixijs_examples_Container$() {
  $c_O.call(this)
}
$c_Lcom_outr_pixijs_examples_Container$.prototype = new $h_O();
$c_Lcom_outr_pixijs_examples_Container$.prototype.constructor = $c_Lcom_outr_pixijs_examples_Container$;
/** @constructor */
function $h_Lcom_outr_pixijs_examples_Container$() {
  /*<skip>*/
}
$h_Lcom_outr_pixijs_examples_Container$.prototype = $c_Lcom_outr_pixijs_examples_Container$.prototype;
$c_Lcom_outr_pixijs_examples_Container$.prototype.init___ = (function() {
  return this
});
$c_Lcom_outr_pixijs_examples_Container$.prototype.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V = (function(renderer$1, stage$1) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().requestAnimationFrame((function(renderer$1$1, stage$1$1) {
    return (function(arg1$2) {
      $uD(arg1$2);
      var this$1 = $m_Lcom_outr_pixijs_examples_Container$();
      this$1.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V(renderer$1$1, stage$1$1)
    })
  })(renderer$1, stage$1));
  renderer$1.render(stage$1)
});
$c_Lcom_outr_pixijs_examples_Container$.prototype.main__V = (function() {
  var jsx$1 = $g.PIXI;
  var $this = {};
  $this.backgroundColor = 1087931;
  var renderer = jsx$1.autoDetectRenderer(800, 600, $this);
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(renderer.view);
  var stage = new $g.PIXI.Container();
  var container = new $g.PIXI.Container();
  stage.addChild(container);
  var i = 0;
  while (true) {
    var v1 = i;
    var i$1 = 0;
    while (true) {
      var v1$1 = i$1;
      var bunny = $g.PIXI.Sprite.fromImage("bunny.png");
      bunny.x = $imul(40, v1);
      bunny.y = $imul(40, v1$1);
      container.addChild(bunny);
      if ((i$1 === 4)) {
        break
      };
      i$1 = ((1 + i$1) | 0)
    };
    if ((i === 4)) {
      break
    };
    i = ((1 + i) | 0)
  };
  container.x = 100.0;
  container.y = 60.0;
  this.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V(renderer, stage)
});
var $d_Lcom_outr_pixijs_examples_Container$ = new $TypeData().initClass({
  Lcom_outr_pixijs_examples_Container$: 0
}, false, "com.outr.pixijs.examples.Container$", {
  Lcom_outr_pixijs_examples_Container$: 1,
  O: 1
});
$c_Lcom_outr_pixijs_examples_Container$.prototype.$classData = $d_Lcom_outr_pixijs_examples_Container$;
var $n_Lcom_outr_pixijs_examples_Container$ = (void 0);
function $m_Lcom_outr_pixijs_examples_Container$() {
  if ((!$n_Lcom_outr_pixijs_examples_Container$)) {
    $n_Lcom_outr_pixijs_examples_Container$ = new $c_Lcom_outr_pixijs_examples_Container$().init___()
  };
  return $n_Lcom_outr_pixijs_examples_Container$
}
/** @constructor */
function $c_Lcom_outr_pixijs_examples_ContainerPivot$() {
  $c_O.call(this)
}
$c_Lcom_outr_pixijs_examples_ContainerPivot$.prototype = new $h_O();
$c_Lcom_outr_pixijs_examples_ContainerPivot$.prototype.constructor = $c_Lcom_outr_pixijs_examples_ContainerPivot$;
/** @constructor */
function $h_Lcom_outr_pixijs_examples_ContainerPivot$() {
  /*<skip>*/
}
$h_Lcom_outr_pixijs_examples_ContainerPivot$.prototype = $c_Lcom_outr_pixijs_examples_ContainerPivot$.prototype;
$c_Lcom_outr_pixijs_examples_ContainerPivot$.prototype.init___ = (function() {
  return this
});
$c_Lcom_outr_pixijs_examples_ContainerPivot$.prototype.main__V = (function() {
  var jsx$1 = $g.PIXI;
  var $this = {};
  $this.backgroundColor = 1087931;
  var renderer = jsx$1.autoDetectRenderer(800, 600, $this);
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(renderer.view);
  var stage = new $g.PIXI.Container();
  var container = new $g.PIXI.Container();
  stage.addChild(container);
  var i = 0;
  while (true) {
    var v1 = i;
    var i$1 = 0;
    while (true) {
      var v1$1 = i$1;
      var bunny = $g.PIXI.Sprite.fromImage("bunny.png");
      bunny.x = $imul(40, v1);
      bunny.y = $imul(40, v1$1);
      container.addChild(bunny);
      if ((i$1 === 4)) {
        break
      };
      i$1 = ((1 + i$1) | 0)
    };
    if ((i === 4)) {
      break
    };
    i = ((1 + i) | 0)
  };
  container.position.x = 200.0;
  container.position.y = 150.0;
  container.pivot.x = 93.0;
  container.pivot.y = 98.5;
  this.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__Lcom_outr_pixijs_PIXI_Container__V(renderer, stage, container)
});
$c_Lcom_outr_pixijs_examples_ContainerPivot$.prototype.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__Lcom_outr_pixijs_PIXI_Container__V = (function(renderer$1, stage$1, container$1) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().requestAnimationFrame((function(renderer$1$1, stage$1$1, container$1$1) {
    return (function(arg1$2) {
      $uD(arg1$2);
      var this$1 = $m_Lcom_outr_pixijs_examples_ContainerPivot$();
      this$1.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__Lcom_outr_pixijs_PIXI_Container__V(renderer$1$1, stage$1$1, container$1$1)
    })
  })(renderer$1, stage$1, container$1));
  container$1.rotation = ((-0.01) + $uD(container$1.rotation));
  renderer$1.render(stage$1)
});
var $d_Lcom_outr_pixijs_examples_ContainerPivot$ = new $TypeData().initClass({
  Lcom_outr_pixijs_examples_ContainerPivot$: 0
}, false, "com.outr.pixijs.examples.ContainerPivot$", {
  Lcom_outr_pixijs_examples_ContainerPivot$: 1,
  O: 1
});
$c_Lcom_outr_pixijs_examples_ContainerPivot$.prototype.$classData = $d_Lcom_outr_pixijs_examples_ContainerPivot$;
var $n_Lcom_outr_pixijs_examples_ContainerPivot$ = (void 0);
function $m_Lcom_outr_pixijs_examples_ContainerPivot$() {
  if ((!$n_Lcom_outr_pixijs_examples_ContainerPivot$)) {
    $n_Lcom_outr_pixijs_examples_ContainerPivot$ = new $c_Lcom_outr_pixijs_examples_ContainerPivot$().init___()
  };
  return $n_Lcom_outr_pixijs_examples_ContainerPivot$
}
/** @constructor */
function $c_Lcom_outr_pixijs_examples_Graphics$() {
  $c_O.call(this)
}
$c_Lcom_outr_pixijs_examples_Graphics$.prototype = new $h_O();
$c_Lcom_outr_pixijs_examples_Graphics$.prototype.constructor = $c_Lcom_outr_pixijs_examples_Graphics$;
/** @constructor */
function $h_Lcom_outr_pixijs_examples_Graphics$() {
  /*<skip>*/
}
$h_Lcom_outr_pixijs_examples_Graphics$.prototype = $c_Lcom_outr_pixijs_examples_Graphics$.prototype;
$c_Lcom_outr_pixijs_examples_Graphics$.prototype.init___ = (function() {
  return this
});
$c_Lcom_outr_pixijs_examples_Graphics$.prototype.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V = (function(renderer$1, stage$1) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().requestAnimationFrame((function(renderer$1$1, stage$1$1) {
    return (function(arg1$2) {
      $uD(arg1$2);
      var this$1 = $m_Lcom_outr_pixijs_examples_Graphics$();
      this$1.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V(renderer$1$1, stage$1$1)
    })
  })(renderer$1, stage$1));
  renderer$1.render(stage$1)
});
$c_Lcom_outr_pixijs_examples_Graphics$.prototype.main__V = (function() {
  var jsx$1 = $g.PIXI;
  var $this = {};
  $this.antialias = true;
  var renderer = jsx$1.autoDetectRenderer(800, 600, $this);
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(renderer.view);
  var stage = new $g.PIXI.Container();
  stage.interactive = true;
  var graphics = new $g.PIXI.Graphics();
  graphics.beginFill(1.6724736E7);
  graphics.lineStyle(4.0, 1.6767232E7, 1.0);
  graphics.moveTo(50.0, 50.0);
  graphics.lineTo(250.0, 50.0);
  graphics.lineTo(100.0, 100.0);
  graphics.lineTo(50.0, 50.0);
  graphics.endFill();
  graphics.lineStyle(2.0, 255.0, 1.0);
  graphics.beginFill(1.6740363E7, 1.0);
  graphics.drawRect(50.0, 250.0, 120.0, 120.0);
  graphics.lineStyle(2.0, 1.6711935E7, 1.0);
  graphics.beginFill(1.6711867E7, 0.25);
  graphics.drawRoundedRect(150.0, 450.0, 300.0, 100.0, 15.0);
  graphics.endFill();
  graphics.lineStyle(0.0);
  graphics.beginFill(1.6776971E7, 0.5);
  graphics.drawCircle(470.0, 90.0, 60.0);
  graphics.endFill();
  stage.addChild(graphics);
  this.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V(renderer, stage)
});
var $d_Lcom_outr_pixijs_examples_Graphics$ = new $TypeData().initClass({
  Lcom_outr_pixijs_examples_Graphics$: 0
}, false, "com.outr.pixijs.examples.Graphics$", {
  Lcom_outr_pixijs_examples_Graphics$: 1,
  O: 1
});
$c_Lcom_outr_pixijs_examples_Graphics$.prototype.$classData = $d_Lcom_outr_pixijs_examples_Graphics$;
var $n_Lcom_outr_pixijs_examples_Graphics$ = (void 0);
function $m_Lcom_outr_pixijs_examples_Graphics$() {
  if ((!$n_Lcom_outr_pixijs_examples_Graphics$)) {
    $n_Lcom_outr_pixijs_examples_Graphics$ = new $c_Lcom_outr_pixijs_examples_Graphics$().init___()
  };
  return $n_Lcom_outr_pixijs_examples_Graphics$
}
/** @constructor */
function $c_Lcom_outr_pixijs_examples_Text$() {
  $c_O.call(this)
}
$c_Lcom_outr_pixijs_examples_Text$.prototype = new $h_O();
$c_Lcom_outr_pixijs_examples_Text$.prototype.constructor = $c_Lcom_outr_pixijs_examples_Text$;
/** @constructor */
function $h_Lcom_outr_pixijs_examples_Text$() {
  /*<skip>*/
}
$h_Lcom_outr_pixijs_examples_Text$.prototype = $c_Lcom_outr_pixijs_examples_Text$.prototype;
$c_Lcom_outr_pixijs_examples_Text$.prototype.init___ = (function() {
  return this
});
$c_Lcom_outr_pixijs_examples_Text$.prototype.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V = (function(renderer$1, stage$1) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().requestAnimationFrame((function(renderer$1$1, stage$1$1) {
    return (function(arg1$2) {
      $uD(arg1$2);
      var this$1 = $m_Lcom_outr_pixijs_examples_Text$();
      this$1.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V(renderer$1$1, stage$1$1)
    })
  })(renderer$1, stage$1));
  renderer$1.render(stage$1)
});
$c_Lcom_outr_pixijs_examples_Text$.prototype.main__V = (function() {
  var jsx$1 = $g.PIXI;
  var $this = {};
  $this.backgroundColor = 1087931;
  var renderer = jsx$1.autoDetectRenderer(800, 600, $this);
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(renderer.view);
  var stage = new $g.PIXI.Container();
  var basicText = new $g.PIXI.Text("Basic text in pixi");
  basicText.x = 30.0;
  basicText.y = 90.0;
  stage.addChild(basicText);
  var this$2 = {};
  this$2.fontFamily = "Arial";
  this$2.fontSize = "36px";
  this$2.fontStyle = "italic";
  this$2.fontWeight = "bold";
  this$2.fill = "#F7EDCA";
  this$2.stroke = "#4A1850";
  this$2.strokeThickness = 5.0;
  this$2.dropShadow = true;
  this$2.dropShadowColor = "#000000";
  this$2.dropShadowAngle = 0.5235987755982988;
  this$2.dropShadowDistance = 6.0;
  this$2.wordWrap = true;
  this$2.wordWrapWidth = 440.0;
  var richText = new $g.PIXI.Text("Rich text with a lot of options and across multiple lines", new $g.PIXI.TextStyle(this$2));
  richText.x = 30.0;
  richText.y = 180.0;
  stage.addChild(richText);
  this.animate$1__p1__Lcom_outr_pixijs_PIXI_SystemRenderer__Lcom_outr_pixijs_PIXI_Container__V(renderer, stage)
});
var $d_Lcom_outr_pixijs_examples_Text$ = new $TypeData().initClass({
  Lcom_outr_pixijs_examples_Text$: 0
}, false, "com.outr.pixijs.examples.Text$", {
  Lcom_outr_pixijs_examples_Text$: 1,
  O: 1
});
$c_Lcom_outr_pixijs_examples_Text$.prototype.$classData = $d_Lcom_outr_pixijs_examples_Text$;
var $n_Lcom_outr_pixijs_examples_Text$ = (void 0);
function $m_Lcom_outr_pixijs_examples_Text$() {
  if ((!$n_Lcom_outr_pixijs_examples_Text$)) {
    $n_Lcom_outr_pixijs_examples_Text$ = new $c_Lcom_outr_pixijs_examples_Text$().init___()
  };
  return $n_Lcom_outr_pixijs_examples_Text$
}
/** @constructor */
function $c_Lio_youi_Cache$() {
  $c_O.call(this);
  this.implementation$1 = null
}
$c_Lio_youi_Cache$.prototype = new $h_O();
$c_Lio_youi_Cache$.prototype.constructor = $c_Lio_youi_Cache$;
/** @constructor */
function $h_Lio_youi_Cache$() {
  /*<skip>*/
}
$h_Lio_youi_Cache$.prototype = $c_Lio_youi_Cache$.prototype;
$c_Lio_youi_Cache$.prototype.init___ = (function() {
  return this
});
var $d_Lio_youi_Cache$ = new $TypeData().initClass({
  Lio_youi_Cache$: 0
}, false, "io.youi.Cache$", {
  Lio_youi_Cache$: 1,
  O: 1
});
$c_Lio_youi_Cache$.prototype.$classData = $d_Lio_youi_Cache$;
var $n_Lio_youi_Cache$ = (void 0);
function $m_Lio_youi_Cache$() {
  if ((!$n_Lio_youi_Cache$)) {
    $n_Lio_youi_Cache$ = new $c_Lio_youi_Cache$().init___()
  };
  return $n_Lio_youi_Cache$
}
/** @constructor */
function $c_Lio_youi_ErrorSupport$() {
  $c_O.call(this);
  this.error$1 = null;
  this.defaultHandler$1 = null
}
$c_Lio_youi_ErrorSupport$.prototype = new $h_O();
$c_Lio_youi_ErrorSupport$.prototype.constructor = $c_Lio_youi_ErrorSupport$;
/** @constructor */
function $h_Lio_youi_ErrorSupport$() {
  /*<skip>*/
}
$h_Lio_youi_ErrorSupport$.prototype = $c_Lio_youi_ErrorSupport$.prototype;
$c_Lio_youi_ErrorSupport$.prototype.init___ = (function() {
  $n_Lio_youi_ErrorSupport$ = this;
  this.error$1 = new $c_Lreactify_Channel$$anon$1().init___();
  this.defaultHandler$1 = this.error$1.attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$1$2) {
      var x0$1 = $as_jl_Throwable(x0$1$2);
      if ($is_Lio_youi_MessageException(x0$1)) {
        var this$2 = $m_Lscribe_package$();
        var level = $m_Lscribe_Level$Error$();
        var message = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, x2) {
          return (function() {
            return $as_Lio_youi_MessageException(x2).message__T()
          })
        })($this, x0$1));
        var methodName = $m_s_None$();
        $f_Lscribe_LoggerSupport__log__Lscribe_Level__F0__T__s_Option__I__V(this$2, level, message, "io.youi.ErrorSupport.defaultHandler", methodName, 22)
      } else if ((x0$1 !== null)) {
        var this$4 = $m_Lscribe_package$();
        var level$1 = $m_Lscribe_Level$Error$();
        var message$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, x3) {
          return (function() {
            return $m_Lscribe_Logger$().throwable2String__jl_Throwable__Z__scm_StringBuilder__T(x3, ($m_Lscribe_Logger$(), true), ($m_Lscribe_Logger$(), new $c_scm_StringBuilder().init___()))
          })
        })($this, x0$1));
        var methodName$1 = $m_s_None$();
        $f_Lscribe_LoggerSupport__log__Lscribe_Level__F0__T__s_Option__I__V(this$4, level$1, message$1, "io.youi.ErrorSupport.defaultHandler", methodName$1, 23)
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })(this)), this.error$1.attach$default$2__D());
  return this
});
var $d_Lio_youi_ErrorSupport$ = new $TypeData().initClass({
  Lio_youi_ErrorSupport$: 0
}, false, "io.youi.ErrorSupport$", {
  Lio_youi_ErrorSupport$: 1,
  O: 1
});
$c_Lio_youi_ErrorSupport$.prototype.$classData = $d_Lio_youi_ErrorSupport$;
var $n_Lio_youi_ErrorSupport$ = (void 0);
function $m_Lio_youi_ErrorSupport$() {
  if ((!$n_Lio_youi_ErrorSupport$)) {
    $n_Lio_youi_ErrorSupport$ = new $c_Lio_youi_ErrorSupport$().init___()
  };
  return $n_Lio_youi_ErrorSupport$
}
/** @constructor */
function $c_Lio_youi_ExtendedElement() {
  $c_O.call(this);
  this.element$1 = null
}
$c_Lio_youi_ExtendedElement.prototype = new $h_O();
$c_Lio_youi_ExtendedElement.prototype.constructor = $c_Lio_youi_ExtendedElement;
/** @constructor */
function $h_Lio_youi_ExtendedElement() {
  /*<skip>*/
}
$h_Lio_youi_ExtendedElement.prototype = $c_Lio_youi_ExtendedElement.prototype;
$c_Lio_youi_ExtendedElement.prototype.bySelector__T__sci_Vector = (function(selectors) {
  return $m_Lio_youi_dom$().bySelector__T__s_Option__sci_Vector(selectors, this.element$1)
});
$c_Lio_youi_ExtendedElement.prototype.firstBySelector__T__s_Option = (function(selectors) {
  return $m_Lio_youi_dom$().firstBySelector__T__s_Option__s_Option(selectors, this.element$1)
});
$c_Lio_youi_ExtendedElement.prototype.getById__T__s_Option = (function(id) {
  return this.firstBySelector__T__s_Option(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["#", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([id])))
});
$c_Lio_youi_ExtendedElement.prototype.byId__T__Lorg_scalajs_dom_raw_Element = (function(id) {
  return this.oneBySelector__T__Lorg_scalajs_dom_raw_Element(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["#", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([id])))
});
$c_Lio_youi_ExtendedElement.prototype.init___s_Option = (function(element) {
  this.element$1 = element;
  return this
});
$c_Lio_youi_ExtendedElement.prototype.oneBySelector__T__Lorg_scalajs_dom_raw_Element = (function(selectors) {
  return $m_Lio_youi_dom$().oneBySelector__T__s_Option__Lorg_scalajs_dom_raw_Element(selectors, this.element$1)
});
/** @constructor */
function $c_Lio_youi_History$() {
  $c_O.call(this);
  this.alwaysReload$1 = null;
  this.currentURL$1 = null;
  this.url$1 = null;
  this.stateChange$1 = null
}
$c_Lio_youi_History$.prototype = new $h_O();
$c_Lio_youi_History$.prototype.constructor = $c_Lio_youi_History$;
/** @constructor */
function $h_Lio_youi_History$() {
  /*<skip>*/
}
$h_Lio_youi_History$.prototype = $c_Lio_youi_History$.prototype;
$c_Lio_youi_History$.prototype.linkType__T__Lio_youi_LinkType = (function(href) {
  var thiz = $as_T(href.trim());
  if ((thiz === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  if ((thiz === "")) {
    return $m_Lio_youi_LinkType$Empty$()
  } else if (($uI(href.indexOf("#")) !== (-1))) {
    return $m_Lio_youi_LinkType$Hash$()
  } else if ((($uI(href.length) >= 0) && ($as_T(href.substring(0, $uI("javascript:".length))) === "javascript:"))) {
    return $m_Lio_youi_LinkType$JavaScript$()
  } else {
    var this$11 = this.url$1;
    var prefix = $as_Lio_youi_net_URL(this$11.get__O()).base__T();
    if (((($uI(href.length) >= 0) && ($as_T(href.substring(0, $uI(prefix.length))) === prefix)) || (($uI(href.length) >= 0) && ($as_T(href.substring(0, $uI("/".length))) === "/")))) {
      return $m_Lio_youi_LinkType$Internal$()
    } else {
      return $m_Lio_youi_LinkType$External$()
    }
  }
});
$c_Lio_youi_History$.prototype.init___ = (function() {
  $n_Lio_youi_History$ = this;
  this.alwaysReload$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return false
    })
  })(this)), false, true, true);
  var this$1 = $m_Lreactify_Var$();
  var this$2 = $m_Lio_youi_net_URL$();
  var url = $as_T($m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().location.href);
  var v = this$2.apply__T__Z__Lio_youi_net_URL(url, true);
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, v$1) {
    return (function() {
      return v$1
    })
  })(this$1, v));
  this.currentURL$1 = new $c_Lreactify_Var().init___F0__Z__Z(f, true, true);
  this.url$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3) {
    return (function() {
      $m_Lreactify_package$();
      var p = this$3.currentURL$1;
      return $as_Lio_youi_net_URL(p.get__O())
    })
  })(this)), false, true, true);
  this.stateChange$1 = new $c_Lreactify_Channel$$anon$1().init___();
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().addEventListener("popstate", (function(arg1$2) {
    return $m_Lio_youi_History$().io$youi$History$$$anonfun$new$1__Lorg_scalajs_dom_raw_PopStateEvent__O(arg1$2)
  }));
  return this
});
$c_Lio_youi_History$.prototype.reload__Z__V = (function(force) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.reload(force)
});
$c_Lio_youi_History$.prototype.replace__Lio_youi_net_URL__sjs_js_Any__V = (function(url, state) {
  var this$1 = this.alwaysReload$1;
  if ($uZ(this$1.get__O())) {
    this.set__Lio_youi_net_URL__V(url)
  } else {
    var urlString = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
    $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.replaceState(state, urlString, urlString);
    var this$2 = this.currentURL$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, url$1) {
      return (function() {
        return url$1
      })
    })(this, url));
    this$2.replace__F0__Z__V(value, true);
    var this$3 = this.stateChange$1;
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, url$2, state$1) {
      return (function() {
        return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url$2, $m_Lio_youi_StateType$Replace$(), state$1)
      })
    })(this, url, state));
    this$3.set__F0__V(value$1)
  }
});
$c_Lio_youi_History$.prototype.back__I__V = (function(delta) {
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.go(((-delta) | 0))
});
$c_Lio_youi_History$.prototype.io$youi$History$$$anonfun$fixAnchors$2__Lorg_scalajs_dom_raw_Event__Lorg_scalajs_dom_raw_HTMLAnchorElement__V = (function(evt, anchor$1) {
  evt.preventDefault();
  evt.stopPropagation();
  var this$1 = $m_Lio_youi_net_URL$();
  var url = $as_T(anchor$1.href);
  this.push__Lio_youi_net_URL__sjs_js_Any__V(this$1.apply__T__Z__Lio_youi_net_URL(url, true), null)
});
$c_Lio_youi_History$.prototype.pushPath__T__sjs_js_Any__V = (function(path, state) {
  $m_Lreactify_package$();
  var p = this.url$1;
  var qual$2 = $as_Lio_youi_net_URL(p.get__O());
  this.push__Lio_youi_net_URL__sjs_js_Any__V(qual$2.withPath__T__Z__Lio_youi_net_URL(path, true), state)
});
$c_Lio_youi_History$.prototype.update__Lio_youi_HistoryStateChange__V = (function(change) {
  var x1 = change.stateType$1;
  var x = $m_Lio_youi_StateType$Push$();
  if ((x === x1)) {
    this.push__Lio_youi_net_URL__sjs_js_Any__V(change.url$1, change.state$1)
  } else {
    var x$3 = $m_Lio_youi_StateType$Replace$();
    if ((x$3 === x1)) {
      this.replace__Lio_youi_net_URL__sjs_js_Any__V(change.url$1, change.state$1)
    } else {
      var x$5 = $m_Lio_youi_StateType$Set$();
      if ((x$5 === x1)) {
        this.set__Lio_youi_net_URL__V(change.url$1)
      } else {
        var x$7 = $m_Lio_youi_StateType$Pop$();
        if ((x$7 === x1)) {
          this.back__I__V(1)
        } else {
          throw new $c_s_MatchError().init___O(x1)
        }
      }
    }
  }
});
$c_Lio_youi_History$.prototype.push__Lio_youi_net_URL__sjs_js_Any__V = (function(url, state) {
  var this$1 = this.alwaysReload$1;
  if ($uZ(this$1.get__O())) {
    this.set__Lio_youi_net_URL__V(url)
  } else {
    var urlString = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
    $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().history.pushState(state, urlString, urlString);
    var this$2 = this.currentURL$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, url$1) {
      return (function() {
        return url$1
      })
    })(this, url));
    this$2.replace__F0__Z__V(value, true);
    var this$3 = this.stateChange$1;
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, url$2, state$1) {
      return (function() {
        return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url$2, $m_Lio_youi_StateType$Push$(), state$1)
      })
    })(this, url, state));
    this$3.set__F0__V(value$1)
  }
});
$c_Lio_youi_History$.prototype.set__Lio_youi_net_URL__V = (function(url) {
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().location.href = url.encoded__Lio_youi_net_URL$URLParts().asString__T();
  var this$1 = this.stateChange$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, url$1) {
    return (function() {
      return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(url$1, $m_Lio_youi_StateType$Set$(), null)
    })
  })(this, url));
  this$1.set__F0__V(value)
});
$c_Lio_youi_History$.prototype.io$youi$History$$$anonfun$new$1__Lorg_scalajs_dom_raw_PopStateEvent__O = (function(evt) {
  var urlString = $as_T($m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().location.href);
  var this$1 = $m_Lio_youi_net_URL$();
  var newURL = this$1.apply__T__Z__Lio_youi_net_URL(urlString, true);
  var this$2 = this.url$1;
  var x$2 = this$2.get__O();
  if ((!((newURL === null) ? (x$2 === null) : newURL.equals__O__Z(x$2)))) {
    var this$3 = this.currentURL$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, newURL$1) {
      return (function() {
        return newURL$1
      })
    })(this, newURL));
    this$3.replace__F0__Z__V(value, true);
    var this$4 = this.stateChange$1;
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, newURL$2, evt$1) {
      return (function() {
        return new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(newURL$2, $m_Lio_youi_StateType$Pop$(), evt$1.state)
      })
    })(this, newURL, evt));
    this$4.set__F0__V(value$1);
    return (void 0)
  } else {
    return (void 0)
  }
});
$c_Lio_youi_History$.prototype.fixAnchors__V = (function() {
  var this$1 = $m_Lio_youi_dom$();
  var this$2 = this$1.bySelector__T__sci_Vector("a");
  var this$3 = this$2.iterator__sci_VectorIterator();
  while (this$3.$$undhasNext$2) {
    var arg1 = this$3.next__O();
    if ($m_s_Option$().apply__O__s_Option(arg1.onclick).isEmpty__Z()) {
      var x = this.linkType__T__Lio_youi_LinkType($as_T(arg1.href));
      var x$2 = $m_Lio_youi_LinkType$Internal$();
      var jsx$1 = ((x !== null) && (x === x$2))
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      arg1.onclick = (function(anchor$1) {
        return (function(arg1$2) {
          $m_Lio_youi_History$().io$youi$History$$$anonfun$fixAnchors$2__Lorg_scalajs_dom_raw_Event__Lorg_scalajs_dom_raw_HTMLAnchorElement__V(arg1$2, anchor$1)
        })
      })(arg1)
    }
  }
});
var $d_Lio_youi_History$ = new $TypeData().initClass({
  Lio_youi_History$: 0
}, false, "io.youi.History$", {
  Lio_youi_History$: 1,
  O: 1
});
$c_Lio_youi_History$.prototype.$classData = $d_Lio_youi_History$;
var $n_Lio_youi_History$ = (void 0);
function $m_Lio_youi_History$() {
  if ((!$n_Lio_youi_History$)) {
    $n_Lio_youi_History$ = new $c_Lio_youi_History$().init___()
  };
  return $n_Lio_youi_History$
}
/** @constructor */
function $c_Lio_youi_Unique$() {
  $c_O.call(this);
  this.LettersLower$1 = null;
  this.LettersUpper$1 = null;
  this.Numbers$1 = null;
  this.Readable$1 = null;
  this.LettersAndNumbers$1 = null;
  this.AllLettersAndNumbers$1 = null
}
$c_Lio_youi_Unique$.prototype = new $h_O();
$c_Lio_youi_Unique$.prototype.constructor = $c_Lio_youi_Unique$;
/** @constructor */
function $h_Lio_youi_Unique$() {
  /*<skip>*/
}
$h_Lio_youi_Unique$.prototype = $c_Lio_youi_Unique$.prototype;
$c_Lio_youi_Unique$.prototype.init___ = (function() {
  $n_Lio_youi_Unique$ = this;
  this.LettersLower$1 = "abcdefghijklmnopqrstuvwxyz";
  this.LettersUpper$1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  this.Numbers$1 = "0123456789";
  this.Readable$1 = "ABCDEFGHJKLMNPQRSTWXYZ23456789";
  this.LettersAndNumbers$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.LettersLower$1, this.Numbers$1]));
  this.AllLettersAndNumbers$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "", "", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.LettersLower$1, this.LettersUpper$1, this.Numbers$1]));
  return this
});
$c_Lio_youi_Unique$.prototype.apply__I__T__T = (function(length, characters) {
  var charMax = $uI(characters.length);
  var isEmpty$4 = (length <= 0);
  if (isEmpty$4) {
    var scala$collection$immutable$Range$$numRangeElements$4 = 0
  } else {
    var hi = (length >> 31);
    var scala$collection$immutable$Range$$numRangeElements$4 = (((hi === 0) ? (((-2147483648) ^ length) > (-1)) : (hi > 0)) ? (-1) : length)
  };
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + length) | 0);
  $m_sci_IndexedSeq$();
  $m_sc_IndexedSeq$();
  $m_sci_IndexedSeq$();
  $m_sci_Vector$();
  var b = new $c_sci_VectorBuilder().init___();
  if ((scala$collection$immutable$Range$$numRangeElements$4 < 0)) {
    $m_sci_Range$().scala$collection$immutable$Range$$fail__I__I__I__Z__sr_Nothing$(0, length, 1, false)
  };
  switch (scala$collection$immutable$Range$$numRangeElements$4) {
    case (-1): {
      break
    }
  };
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var arg1 = i;
      var this$8 = $m_ju_concurrent_ThreadLocalRandom$();
      var index = this$8.$$undcurrent$1.nextInt__I__I(charMax);
      var c = (65535 & $uI(characters.charCodeAt(index)));
      var elem = new $c_jl_Character().init___C(c);
      b.$$plus$eq__O__sci_VectorBuilder(elem);
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  var this$12 = b.result__sci_Vector();
  return $f_sc_TraversableOnce__mkString__T__T__T__T(this$12, "", "", "")
});
var $d_Lio_youi_Unique$ = new $TypeData().initClass({
  Lio_youi_Unique$: 0
}, false, "io.youi.Unique$", {
  Lio_youi_Unique$: 1,
  O: 1
});
$c_Lio_youi_Unique$.prototype.$classData = $d_Lio_youi_Unique$;
var $n_Lio_youi_Unique$ = (void 0);
function $m_Lio_youi_Unique$() {
  if ((!$n_Lio_youi_Unique$)) {
    $n_Lio_youi_Unique$ = new $c_Lio_youi_Unique$().init___()
  };
  return $n_Lio_youi_Unique$
}
/** @constructor */
function $c_Lio_youi_VirtualSize() {
  $c_O.call(this);
  this.screen$1 = null;
  this.width$1 = null;
  this.height$1 = null;
  this.size$1 = null;
  this.xOffset$1 = null;
  this.yOffset$1 = null;
  this.widthMultiplier$1 = null;
  this.heightMultiplier$1 = null
}
$c_Lio_youi_VirtualSize.prototype = new $h_O();
$c_Lio_youi_VirtualSize.prototype.constructor = $c_Lio_youi_VirtualSize;
/** @constructor */
function $h_Lio_youi_VirtualSize() {
  /*<skip>*/
}
$h_Lio_youi_VirtualSize.prototype = $c_Lio_youi_VirtualSize.prototype;
$c_Lio_youi_VirtualSize.prototype.init___Lio_youi_VirtualSizeSupport__Lreactify_State__Lreactify_State = (function(screen, width, height) {
  this.screen$1 = screen;
  this.width$1 = width;
  this.height$1 = height;
  this.size$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $m_Lreactify_package$();
      var p = $this.width$1;
      if (($uD(p.apply__O()) > 0.0)) {
        $m_Lreactify_package$();
        var p$1 = $this.height$1;
        var jsx$1 = ($uD(p$1.apply__O()) > 0.0)
      } else {
        var jsx$1 = false
      };
      if (jsx$1) {
        var x1 = $as_Lio_youi_VirtualMode($this.screen$1.virtualMode__Lreactify_Var().get__O());
        var x = $m_Lio_youi_VirtualMode$Bars$();
        if ((x === x1)) {
          var jsx$2 = true
        } else {
          var x$3 = $m_Lio_youi_VirtualMode$Clip$();
          if ((x$3 === x1)) {
            var jsx$2 = true
          } else {
            var x$5 = $m_Lio_youi_VirtualMode$FitWidth$();
            if ((x$5 === x1)) {
              var jsx$2 = true
            } else {
              var x$7 = $m_Lio_youi_VirtualMode$FitHeight$();
              var jsx$2 = (x$7 === x1)
            }
          }
        };
        if (jsx$2) {
          $m_Lreactify_package$();
          var p$2 = $this.width$1;
          var widthRatio = ($uD(p$2.apply__O()) / $uD($this.screen$1.virtualWidth__Lreactify_Var().get__O()));
          $m_Lreactify_package$();
          var p$3 = $this.height$1;
          var heightRatio = ($uD(p$3.apply__O()) / $uD($this.screen$1.virtualHeight__Lreactify_Var().get__O()));
          var x1$2 = $as_Lio_youi_VirtualMode($this.screen$1.virtualMode__Lreactify_Var().get__O());
          var x$9 = $m_Lio_youi_VirtualMode$Bars$();
          if ((x$9 === x1$2)) {
            var ratio = $uD($g.Math.min(widthRatio, heightRatio))
          } else {
            var x$11 = $m_Lio_youi_VirtualMode$Clip$();
            if ((x$11 === x1$2)) {
              var ratio = $uD($g.Math.max(widthRatio, heightRatio))
            } else {
              var x$13 = $m_Lio_youi_VirtualMode$FitWidth$();
              if ((x$13 === x1$2)) {
                var ratio = widthRatio
              } else {
                var x$15 = $m_Lio_youi_VirtualMode$FitHeight$();
                if ((x$15 === x1$2)) {
                  var ratio = heightRatio
                } else {
                  var ratio = 0.0
                }
              }
            }
          };
          $m_Lreactify_package$();
          var p$4 = $this.screen$1.virtualWidth__Lreactify_Var();
          var w = ($uD(p$4.get__O()) * ratio);
          $m_Lreactify_package$();
          var p$5 = $this.screen$1.virtualHeight__Lreactify_Var();
          var h = ($uD(p$5.get__O()) * ratio);
          $m_Lreactify_package$();
          var p$6 = $this.width$1;
          var jsx$3 = $uD(p$6.apply__O());
          $m_Lreactify_package$();
          var p$7 = $this.height$1;
          return new $c_T4().init___O__O__O__O(((jsx$3 - w) / 2.0), (($uD(p$7.apply__O()) - h) / 2.0), ratio, ratio)
        } else {
          var x$17 = $m_Lio_youi_VirtualMode$Stretch$();
          if ((x$17 === x1)) {
            $m_Lreactify_package$();
            var p$8 = $this.width$1;
            var jsx$6 = $uD(p$8.apply__O());
            $m_Lreactify_package$();
            var p$9 = $this.screen$1.virtualWidth__Lreactify_Var();
            var jsx$5 = $uD(p$9.get__O());
            $m_Lreactify_package$();
            var p$10 = $this.height$1;
            var jsx$4 = $uD(p$10.apply__O());
            $m_Lreactify_package$();
            var p$11 = $this.screen$1.virtualHeight__Lreactify_Var();
            return new $c_T4().init___O__O__O__O(0.0, 0.0, (jsx$6 / jsx$5), (jsx$4 / $uD(p$11.get__O())))
          } else {
            throw new $c_s_MatchError().init___O(x1)
          }
        }
      } else {
        return new $c_T4().init___O__O__O__O(0.0, 0.0, 1.0, 1.0)
      }
    })
  })(this)), false, true, true);
  this.xOffset$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$12 = this$2$1.size$1;
      return $uD($as_T4(p$12.get__O()).$$und1$1)
    })
  })(this)), false, true, true);
  this.yOffset$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$13 = this$3$1.size$1;
      return $uD($as_T4(p$13.get__O()).$$und2$1)
    })
  })(this)), false, true, true);
  this.widthMultiplier$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$14 = this$4$1.size$1;
      return $uD($as_T4(p$14.get__O()).$$und3$1)
    })
  })(this)), false, true, true);
  this.heightMultiplier$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$15 = this$5$1.size$1;
      return $uD($as_T4(p$15.get__O()).$$und4$1)
    })
  })(this)), false, true, true);
  return this
});
var $d_Lio_youi_VirtualSize = new $TypeData().initClass({
  Lio_youi_VirtualSize: 0
}, false, "io.youi.VirtualSize", {
  Lio_youi_VirtualSize: 1,
  O: 1
});
$c_Lio_youi_VirtualSize.prototype.$classData = $d_Lio_youi_VirtualSize;
/** @constructor */
function $c_Lio_youi_VirtualSize$() {
  $c_O.call(this)
}
$c_Lio_youi_VirtualSize$.prototype = new $h_O();
$c_Lio_youi_VirtualSize$.prototype.constructor = $c_Lio_youi_VirtualSize$;
/** @constructor */
function $h_Lio_youi_VirtualSize$() {
  /*<skip>*/
}
$h_Lio_youi_VirtualSize$.prototype = $c_Lio_youi_VirtualSize$.prototype;
$c_Lio_youi_VirtualSize$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_VirtualSize$.prototype.$$lessinit$greater$default$3__Lreactify_State = (function() {
  return $m_Lio_youi_UI$().size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().height$1
});
$c_Lio_youi_VirtualSize$.prototype.$$lessinit$greater$default$2__Lreactify_State = (function() {
  return $m_Lio_youi_UI$().size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().width$1
});
var $d_Lio_youi_VirtualSize$ = new $TypeData().initClass({
  Lio_youi_VirtualSize$: 0
}, false, "io.youi.VirtualSize$", {
  Lio_youi_VirtualSize$: 1,
  O: 1
});
$c_Lio_youi_VirtualSize$.prototype.$classData = $d_Lio_youi_VirtualSize$;
var $n_Lio_youi_VirtualSize$ = (void 0);
function $m_Lio_youi_VirtualSize$() {
  if ((!$n_Lio_youi_VirtualSize$)) {
    $n_Lio_youi_VirtualSize$ = new $c_Lio_youi_VirtualSize$().init___()
  };
  return $n_Lio_youi_VirtualSize$
}
/** @constructor */
function $c_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels() {
  $c_O.call(this);
  this.d$1 = 0.0;
  this.$$outer$1 = null
}
$c_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels.prototype = new $h_O();
$c_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels.prototype.constructor = $c_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels;
/** @constructor */
function $h_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels() {
  /*<skip>*/
}
$h_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels.prototype = $c_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels.prototype;
$c_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels.prototype.init___Lio_youi_VirtualSizeSupport__D = (function($$outer, d) {
  this.d$1 = d;
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels.prototype.vw__Lreactify_Val = (function() {
  return $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var jsx$1 = $this.d$1;
      $m_Lreactify_package$();
      var p = $this.$$outer$1.virtual__Lio_youi_VirtualSize().widthMultiplier$1;
      return (jsx$1 * $uD(p.get__O()))
    })
  })(this)), false, true, true)
});
var $d_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels = new $TypeData().initClass({
  Lio_youi_VirtualSizeSupport$DoubleVirtualPixels: 0
}, false, "io.youi.VirtualSizeSupport$DoubleVirtualPixels", {
  Lio_youi_VirtualSizeSupport$DoubleVirtualPixels: 1,
  O: 1
});
$c_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels.prototype.$classData = $d_Lio_youi_VirtualSizeSupport$DoubleVirtualPixels;
/** @constructor */
function $c_Lio_youi_VirtualSizeSupport$IntVirtualPixels() {
  $c_O.call(this);
  this.i$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype = new $h_O();
$c_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype.constructor = $c_Lio_youi_VirtualSizeSupport$IntVirtualPixels;
/** @constructor */
function $h_Lio_youi_VirtualSizeSupport$IntVirtualPixels() {
  /*<skip>*/
}
$h_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype = $c_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype;
$c_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype.vh__Lreactify_Val = (function() {
  return $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var jsx$1 = $this.i$1;
      $m_Lreactify_package$();
      var p = $this.$$outer$1.virtual__Lio_youi_VirtualSize().heightMultiplier$1;
      return (jsx$1 * $uD(p.get__O()))
    })
  })(this)), false, true, true)
});
$c_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype.vy__Lreactify_Val = (function() {
  return $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var this$1 = $this.vh__Lreactify_Val();
      var jsx$1 = $uD(this$1.get__O());
      var this$2 = $this.$$outer$1.virtual__Lio_youi_VirtualSize().yOffset$1;
      return (jsx$1 + $uD(this$2.get__O()))
    })
  })(this)), false, true, true)
});
$c_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype.vx__Lreactify_Val = (function() {
  return $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var this$1 = $this.vw__Lreactify_Val();
      var jsx$1 = $uD(this$1.get__O());
      var this$2 = $this.$$outer$1.virtual__Lio_youi_VirtualSize().xOffset$1;
      return (jsx$1 + $uD(this$2.get__O()))
    })
  })(this)), false, true, true)
});
$c_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype.init___Lio_youi_VirtualSizeSupport__I = (function($$outer, i) {
  this.i$1 = i;
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype.vw__Lreactify_Val = (function() {
  return $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var jsx$1 = $this.i$1;
      $m_Lreactify_package$();
      var p = $this.$$outer$1.virtual__Lio_youi_VirtualSize().widthMultiplier$1;
      return (jsx$1 * $uD(p.get__O()))
    })
  })(this)), false, true, true)
});
var $d_Lio_youi_VirtualSizeSupport$IntVirtualPixels = new $TypeData().initClass({
  Lio_youi_VirtualSizeSupport$IntVirtualPixels: 0
}, false, "io.youi.VirtualSizeSupport$IntVirtualPixels", {
  Lio_youi_VirtualSizeSupport$IntVirtualPixels: 1,
  O: 1
});
$c_Lio_youi_VirtualSizeSupport$IntVirtualPixels.prototype.$classData = $d_Lio_youi_VirtualSizeSupport$IntVirtualPixels;
/** @constructor */
function $c_Lio_youi_activate_ActivationSupport$() {
  $c_O.call(this);
  this.debug$1 = false;
  this.io$youi$activate$ActivationSupport$$global$1 = null;
  this.ConditionalRegex$1 = null;
  this.ConditionalTrueRegex$1 = null;
  this.ConditionalFalseRegex$1 = null;
  this.SetTitleRegex$1 = null;
  this.AddClassRegex$1 = null;
  this.RemoveClassRegex$1 = null;
  this.ReplaceContentRegex$1 = null;
  this.ReplaceAttributeRegex$1 = null;
  this.AlertRegex$1 = null;
  this.CallRegex$1 = null;
  this.TestRegex$1 = null;
  this.LinkRegex$1 = null;
  this.OnClickRegex$1 = null;
  this.CommentRegex$1 = null;
  this.HasClassConditionRegex$1 = null
}
$c_Lio_youi_activate_ActivationSupport$.prototype = new $h_O();
$c_Lio_youi_activate_ActivationSupport$.prototype.constructor = $c_Lio_youi_activate_ActivationSupport$;
/** @constructor */
function $h_Lio_youi_activate_ActivationSupport$() {
  /*<skip>*/
}
$h_Lio_youi_activate_ActivationSupport$.prototype = $c_Lio_youi_activate_ActivationSupport$.prototype;
$c_Lio_youi_activate_ActivationSupport$.prototype.init___ = (function() {
  $n_Lio_youi_activate_ActivationSupport$ = this;
  this.debug$1 = false;
  this.io$youi$activate$ActivationSupport$$global$1 = $m_sci_Nil$();
  var this$2 = new $c_sci_StringOps().init___T("(.+) \\? (.+) \\: (.+)");
  var groupNames = $m_sci_Nil$();
  var $$this = this$2.repr$1;
  this.ConditionalRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this, groupNames);
  var this$5 = new $c_sci_StringOps().init___T("(.+) \\? (.+)");
  var groupNames$1 = $m_sci_Nil$();
  var $$this$1 = this$5.repr$1;
  this.ConditionalTrueRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$1, groupNames$1);
  var this$8 = new $c_sci_StringOps().init___T("(.+) \\: (.+)");
  var groupNames$2 = $m_sci_Nil$();
  var $$this$2 = this$8.repr$1;
  this.ConditionalFalseRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$2, groupNames$2);
  var this$11 = new $c_sci_StringOps().init___T("title = \"(.*)\"");
  var groupNames$3 = $m_sci_Nil$();
  var $$this$3 = this$11.repr$1;
  this.SetTitleRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$3, groupNames$3);
  var this$14 = new $c_sci_StringOps().init___T("(.+)[.]addClass\\(\"(.+)\"\\)");
  var groupNames$4 = $m_sci_Nil$();
  var $$this$4 = this$14.repr$1;
  this.AddClassRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$4, groupNames$4);
  var this$17 = new $c_sci_StringOps().init___T("(.+)[.]removeClass\\(\"(.+)\"\\)");
  var groupNames$5 = $m_sci_Nil$();
  var $$this$5 = this$17.repr$1;
  this.RemoveClassRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$5, groupNames$5);
  var this$20 = new $c_sci_StringOps().init___T("(.+)[.]replaceContent\\((.+)\\)");
  var groupNames$6 = $m_sci_Nil$();
  var $$this$6 = this$20.repr$1;
  this.ReplaceContentRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$6, groupNames$6);
  var this$23 = new $c_sci_StringOps().init___T("(.+)[.]replaceAttribute\\((.+)[,] (.+)\\)");
  var groupNames$7 = $m_sci_Nil$();
  var $$this$7 = this$23.repr$1;
  this.ReplaceAttributeRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$7, groupNames$7);
  var this$26 = new $c_sci_StringOps().init___T("alert\\(\"(.+)\"\\)");
  var groupNames$8 = $m_sci_Nil$();
  var $$this$8 = this$26.repr$1;
  this.AlertRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$8, groupNames$8);
  var this$29 = new $c_sci_StringOps().init___T("call\\((.+)\\)");
  var groupNames$9 = $m_sci_Nil$();
  var $$this$9 = this$29.repr$1;
  this.CallRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$9, groupNames$9);
  var this$32 = new $c_sci_StringOps().init___T("test\\((.+)\\)");
  var groupNames$10 = $m_sci_Nil$();
  var $$this$10 = this$32.repr$1;
  this.TestRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$10, groupNames$10);
  var this$35 = new $c_sci_StringOps().init___T("link\\(\"(.+)\"\\)");
  var groupNames$11 = $m_sci_Nil$();
  var $$this$11 = this$35.repr$1;
  this.LinkRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$11, groupNames$11);
  var this$38 = new $c_sci_StringOps().init___T("(.+).onClick\\((.+)\\)");
  var groupNames$12 = $m_sci_Nil$();
  var $$this$12 = this$38.repr$1;
  this.OnClickRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$12, groupNames$12);
  var this$41 = new $c_sci_StringOps().init___T("(\\s*)//(.*)");
  var groupNames$13 = $m_sci_Nil$();
  var $$this$13 = this$41.repr$1;
  this.CommentRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$13, groupNames$13);
  var this$44 = new $c_sci_StringOps().init___T("(.+).hasClass\\(\"(.+)\"\\)");
  var groupNames$14 = $m_sci_Nil$();
  var $$this$14 = this$44.repr$1;
  this.HasClassConditionRegex$1 = new $c_s_util_matching_Regex().init___T__sc_Seq($$this$14, groupNames$14);
  return this
});
$c_Lio_youi_activate_ActivationSupport$.prototype.io$youi$activate$ActivationSupport$$parse__Z__Lorg_scalajs_dom_raw_HTMLElement__sci_List = (function(testing, root) {
  $m_Lio_youi_dom$();
  var this$2 = new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(root);
  var tags = this$2.bySelector__T__sci_Vector("activate");
  var elem = $m_sci_Nil$();
  var elem$1 = null;
  elem$1 = elem;
  var this$4 = tags.iterator__sci_VectorIterator();
  while (this$4.$$undhasNext$2) {
    var arg1 = this$4.next__O();
    var thiz = $as_T(arg1.innerHTML);
    var x = $as_T(thiz.trim());
    var this$7 = new $c_sci_StringOps().init___T(x);
    var xs = $f_sci_StringLike__split__C__AT(this$7, 10);
    var elems$2 = null;
    elems$2 = [];
    var x1 = xs.u.length;
    switch (x1) {
      case (-1): {
        break
      }
    };
    var i = 0;
    var len = xs.u.length;
    while ((i < len)) {
      var index = i;
      var arg1$1 = xs.get(index);
      var x$5 = $as_T(arg1$1);
      var elem$2 = $as_T(x$5.trim());
      var unboxedElem = ((elem$2 === null) ? null : elem$2);
      elems$2.push(unboxedElem);
      i = ((1 + i) | 0)
    };
    var xs$1 = $makeNativeArrayWrapper($d_T.getArrayOf(), elems$2);
    var this$18 = $m_sci_List$();
    var cbf = this$18.ReusableCBFInstance$2;
    var b = cbf.apply__scm_Builder();
    var x1$1 = xs$1.u.length;
    switch (x1$1) {
      case (-1): {
        break
      }
      default: {
        b.sizeHint__I__V(x1$1)
      }
    };
    b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs$1));
    var lines = $as_sci_List(b.result__O());
    var f = (function(this$2$1, testing$1) {
      return (function(i$2) {
        var i$1 = $as_T(i$2);
        var xo = this$2$1.parseInstruction__p1__Z__T__s_Option(testing$1, i$1);
        return xo.toList__sci_List()
      })
    })(this, testing);
    var this$22 = $m_sci_List$();
    var bf = this$22.ReusableCBFInstance$2;
    if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
      if ((lines === $m_sci_Nil$())) {
        var jsx$1 = $m_sci_Nil$()
      } else {
        var rest = lines;
        var found = new $c_sr_BooleanRef().init___Z(false);
        var h = new $c_sr_ObjectRef().init___O(null);
        var t = new $c_sr_ObjectRef().init___O(null);
        while ((rest !== $m_sci_Nil$())) {
          var arg1$2 = rest.head__O();
          $as_sc_GenTraversableOnce(f(arg1$2)).seq__sc_TraversableOnce().foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, found$1, h$1, t$1) {
            return (function(b$2) {
              if ((!found$1.elem$1)) {
                h$1.elem$1 = new $c_sci_$colon$colon().init___O__sci_List(b$2, $m_sci_Nil$());
                t$1.elem$1 = $as_sci_$colon$colon(h$1.elem$1);
                found$1.elem$1 = true
              } else {
                var nx = new $c_sci_$colon$colon().init___O__sci_List(b$2, $m_sci_Nil$());
                $as_sci_$colon$colon(t$1.elem$1).tl$5 = nx;
                t$1.elem$1 = nx
              }
            })
          })(lines, found, h, t)));
          rest = $as_sci_List(rest.tail__O())
        };
        var jsx$1 = ((!found.elem$1) ? $m_sci_Nil$() : $as_sci_$colon$colon(h.elem$1))
      }
    } else {
      $m_sci_List$();
      var b$1 = new $c_scm_ListBuffer().init___();
      var these = lines;
      while ((!these.isEmpty__Z())) {
        var arg1$3 = these.head__O();
        var xs$2 = $as_sc_GenTraversableOnce(f(arg1$3)).seq__sc_TraversableOnce();
        b$1.$$plus$plus$eq__sc_TraversableOnce__scm_ListBuffer(xs$2);
        these = $as_sci_List(these.tail__O())
      };
      var jsx$1 = b$1.toList__sci_List()
    };
    var instructions = $as_sci_List(jsx$1);
    if (($as_T(arg1.getAttribute("global")) === "true")) {
      var x$6 = this.io$youi$activate$ActivationSupport$$global$1;
      this.io$youi$activate$ActivationSupport$$global$1 = instructions.$$colon$colon$colon__sci_List__sci_List(x$6)
    } else {
      var x$7 = $as_sci_List(elem$1);
      elem$1 = instructions.$$colon$colon$colon__sci_List__sci_List(x$7)
    }
  };
  var this$27 = tags.iterator__sci_VectorIterator();
  while (this$27.$$undhasNext$2) {
    var arg1$4 = this$27.next__O();
    ($m_Lio_youi_dom$(), new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(arg1$4)).remove__V()
  };
  return $as_sci_List(elem$1)
});
$c_Lio_youi_activate_ActivationSupport$.prototype.parseInstruction__p1__Z__T__s_Option = (function(testing, line) {
  _parseInstruction: while (true) {
    var thiz = line;
    var x1 = $as_T(thiz.trim());
    if ((x1 === "")) {
      return $m_s_None$()
    };
    if ((($uI(x1.length) >= 0) && ($as_T(x1.substring(0, $uI("//".length))) === "//"))) {
      return $m_s_None$()
    };
    var o24 = this.TestRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o24.isEmpty__Z())) {
      if ((o24.get__O() !== null)) {
        var this$7 = $as_sc_LinearSeqOptimized(o24.get__O());
        var jsx$1 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$7, 1) === 0)
      } else {
        var jsx$1 = false
      }
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      var instruction = $as_T($as_sc_LinearSeqOptimized(o24.get__O()).apply__I__O(0));
      if (testing) {
        line = instruction;
        continue _parseInstruction
      } else {
        return $m_s_None$()
      }
    };
    var o26 = this.ConditionalRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o26.isEmpty__Z())) {
      if ((o26.get__O() !== null)) {
        var this$8 = $as_sc_LinearSeqOptimized(o26.get__O());
        var jsx$2 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$8, 3) === 0)
      } else {
        var jsx$2 = false
      }
    } else {
      var jsx$2 = false
    };
    if (jsx$2) {
      var condition = $as_T($as_sc_LinearSeqOptimized(o26.get__O()).apply__I__O(0));
      var trueInstruction = $as_T($as_sc_LinearSeqOptimized(o26.get__O()).apply__I__O(1));
      var falseInstruction = $as_T($as_sc_LinearSeqOptimized(o26.get__O()).apply__I__O(2));
      var this$9 = this.parseInstruction__p1__Z__T__s_Option(testing, trueInstruction);
      if (this$9.isEmpty__Z()) {
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Failed to parse instruction: [", "]"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([trueInstruction]))))
      };
      var ti = $as_Lio_youi_activate_ActivateInstruction(this$9.get__O());
      var this$10 = this.parseInstruction__p1__Z__T__s_Option(testing, falseInstruction);
      if (this$10.isEmpty__Z()) {
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Failed to parse instruction: [", "]"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([falseInstruction]))))
      };
      var fi = $as_Lio_youi_activate_ActivateInstruction(this$10.get__O());
      return new $c_s_Some().init___O(this.parseCondition__p1__T__s_Option__s_Option__Lio_youi_activate_ConditionalInstruction(condition, new $c_s_Some().init___O(ti), new $c_s_Some().init___O(fi)))
    };
    var o28 = this.ConditionalTrueRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o28.isEmpty__Z())) {
      if ((o28.get__O() !== null)) {
        var this$11 = $as_sc_LinearSeqOptimized(o28.get__O());
        var jsx$3 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$11, 2) === 0)
      } else {
        var jsx$3 = false
      }
    } else {
      var jsx$3 = false
    };
    if (jsx$3) {
      var condition$2 = $as_T($as_sc_LinearSeqOptimized(o28.get__O()).apply__I__O(0));
      var trueInstruction$2 = $as_T($as_sc_LinearSeqOptimized(o28.get__O()).apply__I__O(1));
      var this$12 = this.parseInstruction__p1__Z__T__s_Option(testing, trueInstruction$2);
      if (this$12.isEmpty__Z()) {
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Failed to parse instruction: [", "]"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([trueInstruction$2]))))
      };
      var ti$2 = $as_Lio_youi_activate_ActivateInstruction(this$12.get__O());
      return new $c_s_Some().init___O(this.parseCondition__p1__T__s_Option__s_Option__Lio_youi_activate_ConditionalInstruction(condition$2, new $c_s_Some().init___O(ti$2), $m_s_None$()))
    };
    var o30 = this.ConditionalFalseRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o30.isEmpty__Z())) {
      if ((o30.get__O() !== null)) {
        var this$13 = $as_sc_LinearSeqOptimized(o30.get__O());
        var jsx$4 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$13, 2) === 0)
      } else {
        var jsx$4 = false
      }
    } else {
      var jsx$4 = false
    };
    if (jsx$4) {
      var condition$3 = $as_T($as_sc_LinearSeqOptimized(o30.get__O()).apply__I__O(0));
      var falseInstruction$2 = $as_T($as_sc_LinearSeqOptimized(o30.get__O()).apply__I__O(1));
      var this$14 = this.parseInstruction__p1__Z__T__s_Option(testing, falseInstruction$2);
      if (this$14.isEmpty__Z()) {
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Failed to parse instruction: [", "]"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([falseInstruction$2]))))
      };
      var fi$2 = $as_Lio_youi_activate_ActivateInstruction(this$14.get__O());
      return new $c_s_Some().init___O(this.parseCondition__p1__T__s_Option__s_Option__Lio_youi_activate_ConditionalInstruction(condition$3, $m_s_None$(), new $c_s_Some().init___O(fi$2)))
    };
    var o32 = this.SetTitleRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o32.isEmpty__Z())) {
      if ((o32.get__O() !== null)) {
        var this$15 = $as_sc_LinearSeqOptimized(o32.get__O());
        var jsx$5 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$15, 1) === 0)
      } else {
        var jsx$5 = false
      }
    } else {
      var jsx$5 = false
    };
    if (jsx$5) {
      var title = $as_T($as_sc_LinearSeqOptimized(o32.get__O()).apply__I__O(0));
      return new $c_s_Some().init___O(new $c_Lio_youi_activate_SetTitleInstruction().init___T(title))
    };
    var o34 = this.AddClassRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o34.isEmpty__Z())) {
      if ((o34.get__O() !== null)) {
        var this$16 = $as_sc_LinearSeqOptimized(o34.get__O());
        var jsx$6 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$16, 2) === 0)
      } else {
        var jsx$6 = false
      }
    } else {
      var jsx$6 = false
    };
    if (jsx$6) {
      var selector = $as_T($as_sc_LinearSeqOptimized(o34.get__O()).apply__I__O(0));
      var className = $as_T($as_sc_LinearSeqOptimized(o34.get__O()).apply__I__O(1));
      return new $c_s_Some().init___O(new $c_Lio_youi_activate_AddClassInstruction().init___T__T(selector, className))
    };
    var o36 = this.RemoveClassRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o36.isEmpty__Z())) {
      if ((o36.get__O() !== null)) {
        var this$17 = $as_sc_LinearSeqOptimized(o36.get__O());
        var jsx$7 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$17, 2) === 0)
      } else {
        var jsx$7 = false
      }
    } else {
      var jsx$7 = false
    };
    if (jsx$7) {
      var selector$2 = $as_T($as_sc_LinearSeqOptimized(o36.get__O()).apply__I__O(0));
      var className$2 = $as_T($as_sc_LinearSeqOptimized(o36.get__O()).apply__I__O(1));
      return new $c_s_Some().init___O(new $c_Lio_youi_activate_RemoveClassInstruction().init___T__T(selector$2, className$2))
    };
    var o38 = this.ReplaceContentRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o38.isEmpty__Z())) {
      if ((o38.get__O() !== null)) {
        var this$18 = $as_sc_LinearSeqOptimized(o38.get__O());
        var jsx$8 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$18, 2) === 0)
      } else {
        var jsx$8 = false
      }
    } else {
      var jsx$8 = false
    };
    if (jsx$8) {
      var selector$3 = $as_T($as_sc_LinearSeqOptimized(o38.get__O()).apply__I__O(0));
      var content = $as_T($as_sc_LinearSeqOptimized(o38.get__O()).apply__I__O(1));
      return new $c_s_Some().init___O(new $c_Lio_youi_activate_ReplaceContentInstruction().init___T__T(selector$3, content))
    };
    var o40 = this.ReplaceAttributeRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o40.isEmpty__Z())) {
      if ((o40.get__O() !== null)) {
        var this$19 = $as_sc_LinearSeqOptimized(o40.get__O());
        var jsx$9 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$19, 3) === 0)
      } else {
        var jsx$9 = false
      }
    } else {
      var jsx$9 = false
    };
    if (jsx$9) {
      var selector$4 = $as_T($as_sc_LinearSeqOptimized(o40.get__O()).apply__I__O(0));
      var attributeName = $as_T($as_sc_LinearSeqOptimized(o40.get__O()).apply__I__O(1));
      var content$2 = $as_T($as_sc_LinearSeqOptimized(o40.get__O()).apply__I__O(2));
      return new $c_s_Some().init___O(new $c_Lio_youi_activate_ReplaceAttributeInstruction().init___T__T__T(selector$4, attributeName, content$2))
    };
    var o42 = this.AlertRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o42.isEmpty__Z())) {
      if ((o42.get__O() !== null)) {
        var this$20 = $as_sc_LinearSeqOptimized(o42.get__O());
        var jsx$10 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$20, 1) === 0)
      } else {
        var jsx$10 = false
      }
    } else {
      var jsx$10 = false
    };
    if (jsx$10) {
      var message = $as_T($as_sc_LinearSeqOptimized(o42.get__O()).apply__I__O(0));
      return new $c_s_Some().init___O(new $c_Lio_youi_activate_AlertInstruction().init___T(message))
    };
    var o44 = this.CallRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o44.isEmpty__Z())) {
      if ((o44.get__O() !== null)) {
        var this$21 = $as_sc_LinearSeqOptimized(o44.get__O());
        var jsx$11 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$21, 1) === 0)
      } else {
        var jsx$11 = false
      }
    } else {
      var jsx$11 = false
    };
    if (jsx$11) {
      var code = $as_T($as_sc_LinearSeqOptimized(o44.get__O()).apply__I__O(0));
      return new $c_s_Some().init___O(new $c_Lio_youi_activate_Call().init___T(code))
    };
    var o46 = this.LinkRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o46.isEmpty__Z())) {
      if ((o46.get__O() !== null)) {
        var this$22 = $as_sc_LinearSeqOptimized(o46.get__O());
        var jsx$12 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$22, 1) === 0)
      } else {
        var jsx$12 = false
      }
    } else {
      var jsx$12 = false
    };
    if (jsx$12) {
      var path = $as_T($as_sc_LinearSeqOptimized(o46.get__O()).apply__I__O(0));
      return new $c_s_Some().init___O(new $c_Lio_youi_activate_Link().init___T(path))
    };
    var o48 = this.OnClickRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o48.isEmpty__Z())) {
      if ((o48.get__O() !== null)) {
        var this$23 = $as_sc_LinearSeqOptimized(o48.get__O());
        var jsx$13 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$23, 2) === 0)
      } else {
        var jsx$13 = false
      }
    } else {
      var jsx$13 = false
    };
    if (jsx$13) {
      var selector$5 = $as_T($as_sc_LinearSeqOptimized(o48.get__O()).apply__I__O(0));
      var instruction$2 = $as_T($as_sc_LinearSeqOptimized(o48.get__O()).apply__I__O(1));
      var this$24 = this.parseInstruction__p1__Z__T__s_Option(testing, instruction$2);
      if (this$24.isEmpty__Z()) {
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Failed to parse instruction: [", "]"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([instruction$2]))))
      };
      var i = $as_Lio_youi_activate_ActivateInstruction(this$24.get__O());
      return new $c_s_Some().init___O(new $c_Lio_youi_activate_OnClick().init___T__Lio_youi_activate_ActivateInstruction(selector$5, i))
    };
    var o50 = this.CommentRegex$1.unapplySeq__jl_CharSequence__s_Option(x1);
    if ((!o50.isEmpty__Z())) {
      if ((o50.get__O() !== null)) {
        var this$25 = $as_sc_LinearSeqOptimized(o50.get__O());
        var jsx$14 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$25, 1) === 0)
      } else {
        var jsx$14 = false
      }
    } else {
      var jsx$14 = false
    };
    if (jsx$14) {
      return $m_s_None$()
    };
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Unknown instruction: [", "]"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([line]))))
  }
});
$c_Lio_youi_activate_ActivationSupport$.prototype.parseCondition__p1__T__s_Option__s_Option__Lio_youi_activate_ConditionalInstruction = (function(instruction, trueInstruction, falseInstruction) {
  var o7 = this.HasClassConditionRegex$1.unapplySeq__jl_CharSequence__s_Option(instruction);
  if ((!o7.isEmpty__Z())) {
    if ((o7.get__O() !== null)) {
      var this$1 = $as_sc_LinearSeqOptimized(o7.get__O());
      var jsx$1 = ($f_sc_LinearSeqOptimized__lengthCompare__I__I(this$1, 2) === 0)
    } else {
      var jsx$1 = false
    }
  } else {
    var jsx$1 = false
  };
  if (jsx$1) {
    var selector = $as_T($as_sc_LinearSeqOptimized(o7.get__O()).apply__I__O(0));
    var className = $as_T($as_sc_LinearSeqOptimized(o7.get__O()).apply__I__O(1));
    return new $c_Lio_youi_activate_HasClassInstruction().init___T__T__s_Option__s_Option(selector, className, trueInstruction, falseInstruction)
  };
  throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Unknown condition: [", "]"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([instruction]))))
});
var $d_Lio_youi_activate_ActivationSupport$ = new $TypeData().initClass({
  Lio_youi_activate_ActivationSupport$: 0
}, false, "io.youi.activate.ActivationSupport$", {
  Lio_youi_activate_ActivationSupport$: 1,
  O: 1
});
$c_Lio_youi_activate_ActivationSupport$.prototype.$classData = $d_Lio_youi_activate_ActivationSupport$;
var $n_Lio_youi_activate_ActivationSupport$ = (void 0);
function $m_Lio_youi_activate_ActivationSupport$() {
  if ((!$n_Lio_youi_activate_ActivationSupport$)) {
    $n_Lio_youi_activate_ActivationSupport$ = new $c_Lio_youi_activate_ActivationSupport$().init___()
  };
  return $n_Lio_youi_activate_ActivationSupport$
}
/** @constructor */
function $c_Lio_youi_activate_ActivationSupport$activation$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_activate_ActivationSupport$activation$.prototype = new $h_O();
$c_Lio_youi_activate_ActivationSupport$activation$.prototype.constructor = $c_Lio_youi_activate_ActivationSupport$activation$;
/** @constructor */
function $h_Lio_youi_activate_ActivationSupport$activation$() {
  /*<skip>*/
}
$h_Lio_youi_activate_ActivationSupport$activation$.prototype = $c_Lio_youi_activate_ActivationSupport$activation$.prototype;
$c_Lio_youi_activate_ActivationSupport$activation$.prototype.init___Lio_youi_activate_ActivationSupport = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_activate_ActivationSupport$activation$.prototype.deactivate__V = (function() {
  var this$1 = $m_Lio_youi_activate_ActivationSupport$().io$youi$activate$ActivationSupport$$global$1;
  var these = this$1;
  while ((!these.isEmpty__Z())) {
    var arg1 = these.head__O();
    var x$3 = $as_Lio_youi_activate_ActivateInstruction(arg1);
    x$3.deactivate__V();
    these = $as_sci_List(these.tail__O())
  };
  var this$2 = this.$$outer$1.io$youi$activate$ActivationSupport$$instructions__sci_List();
  var these$1 = this$2;
  while ((!these$1.isEmpty__Z())) {
    var arg1$1 = these$1.head__O();
    var x$4 = $as_Lio_youi_activate_ActivateInstruction(arg1$1);
    x$4.deactivate__V();
    these$1 = $as_sci_List(these$1.tail__O())
  }
});
$c_Lio_youi_activate_ActivationSupport$activation$.prototype.activate__V = (function() {
  var local = this.$$outer$1.io$youi$activate$ActivationSupport$$instructions__sci_List();
  var this$1 = $m_Lio_youi_activate_ActivationSupport$().io$youi$activate$ActivationSupport$$global$1;
  var these = this$1;
  while ((!these.isEmpty__Z())) {
    var arg1 = these.head__O();
    var x$1 = $as_Lio_youi_activate_ActivateInstruction(arg1);
    x$1.activate__V();
    these = $as_sci_List(these.tail__O())
  };
  var these$1 = local;
  while ((!these$1.isEmpty__Z())) {
    var arg1$1 = these$1.head__O();
    var x$2 = $as_Lio_youi_activate_ActivateInstruction(arg1$1);
    x$2.activate__V();
    these$1 = $as_sci_List(these$1.tail__O())
  }
});
var $d_Lio_youi_activate_ActivationSupport$activation$ = new $TypeData().initClass({
  Lio_youi_activate_ActivationSupport$activation$: 0
}, false, "io.youi.activate.ActivationSupport$activation$", {
  Lio_youi_activate_ActivationSupport$activation$: 1,
  O: 1
});
$c_Lio_youi_activate_ActivationSupport$activation$.prototype.$classData = $d_Lio_youi_activate_ActivationSupport$activation$;
/** @constructor */
function $c_Lio_youi_ajax_AjaxRequest() {
  $c_O.call(this);
  this.data$1 = null;
  this.req$1 = null;
  this.promise$1 = null;
  this.loaded$1 = null;
  this.total$1 = null;
  this.percentage$1 = null;
  this.cancelled$1 = null
}
$c_Lio_youi_ajax_AjaxRequest.prototype = new $h_O();
$c_Lio_youi_ajax_AjaxRequest.prototype.constructor = $c_Lio_youi_ajax_AjaxRequest;
/** @constructor */
function $h_Lio_youi_ajax_AjaxRequest() {
  /*<skip>*/
}
$h_Lio_youi_ajax_AjaxRequest.prototype = $c_Lio_youi_ajax_AjaxRequest.prototype;
$c_Lio_youi_ajax_AjaxRequest.prototype.io$youi$ajax$AjaxRequest$$$anonfun$new$1__Lorg_scalajs_dom_raw_Event__O = (function(e) {
  if (($uI(this.req$1.readyState) === 4)) {
    if (((($uI(this.req$1.status) >= 200) && ($uI(this.req$1.status) < 300)) || ($uI(this.req$1.status) === 304))) {
      var this$1 = this.promise$1;
      var value = this.req$1;
      return $f_s_concurrent_Promise__success__O__s_concurrent_Promise(this$1, value)
    } else {
      var this$2 = this.promise$1;
      var cause = new $c_Lorg_scalajs_dom_ext_AjaxException().init___Lorg_scalajs_dom_raw_XMLHttpRequest(this.req$1);
      return $f_s_concurrent_Promise__failure__jl_Throwable__s_concurrent_Promise(this$2, cause)
    }
  } else {
    return (void 0)
  }
});
$c_Lio_youi_ajax_AjaxRequest.prototype.send__s_concurrent_Future = (function() {
  var x1 = this.data$1;
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var formData = x2.value$2;
    this.req$1.send(formData)
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      this.req$1.send()
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  };
  var this$1 = this.promise$1;
  return this$1
});
$c_Lio_youi_ajax_AjaxRequest.prototype.io$youi$ajax$AjaxRequest$$$anonfun$new$2__Lorg_scalajs_dom_raw_ProgressEvent__V = (function(evt) {
  var this$1 = $as_Lreactify_Var(this.total$1);
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, evt$1) {
    return (function() {
      return $uD(evt$1.total)
    })
  })(this, evt));
  this$1.replace__F0__Z__V(value, true);
  var this$3 = $as_Lreactify_Var(this.loaded$1);
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, evt$2) {
    return (function() {
      return $uD(evt$2.loaded)
    })
  })(this, evt));
  this$3.replace__F0__Z__V(value$1, true);
  var x = (100 * ($uD(evt.loaded) / $uD(evt.total)));
  var x$1 = $uD($g.Math.floor(x));
  var this$8 = $m_sjsr_RuntimeLong$();
  var value$2 = $uD($g.Math.round(x$1));
  var lo = this$8.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I(value$2);
  var this$9 = $as_Lreactify_Var(this.percentage$1);
  var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, p) {
    return (function() {
      return p
    })
  })(this, lo));
  this$9.replace__F0__Z__V(value$3, true)
});
$c_Lio_youi_ajax_AjaxRequest.prototype.init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T = (function(url, data, timeout, headers, withCredentials, responseType) {
  this.data$1 = data;
  this.req$1 = new $g.XMLHttpRequest();
  this.promise$1 = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  this.loaded$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })(this)), false, true, true);
  this.total$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      return 0.0
    })
  })(this)), false, true, true);
  this.percentage$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3) {
    return (function() {
      return 0
    })
  })(this)), false, true, true);
  this.cancelled$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4) {
    return (function() {
      return false
    })
  })(this)), false, true, true);
  this.req$1.onreadystatechange = (function(arg$outer) {
    return (function(arg1$2) {
      return arg$outer.io$youi$ajax$AjaxRequest$$$anonfun$new$1__Lorg_scalajs_dom_raw_Event__O(arg1$2)
    })
  })(this);
  var qual$1 = this.req$1.upload;
  var x$2 = (function(arg$outer$1) {
    return (function(arg1$2$1) {
      arg$outer$1.io$youi$ajax$AjaxRequest$$$anonfun$new$2__Lorg_scalajs_dom_raw_ProgressEvent__V(arg1$2$1)
    })
  })(this);
  qual$1.addEventListener("progress", x$2);
  this.req$1.open("POST", url.encoded__Lio_youi_net_URL$URLParts().asString__T());
  this.req$1.responseType = responseType;
  this.req$1.timeout = timeout;
  this.req$1.withCredentials = withCredentials;
  headers.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$5) {
    return (function(x$3) {
      var x = $as_T2(x$3);
      this$5.req$1.setRequestHeader($as_T(x.$$und1__O()), $as_T(x.$$und2__O()))
    })
  })(this)));
  return this
});
var $d_Lio_youi_ajax_AjaxRequest = new $TypeData().initClass({
  Lio_youi_ajax_AjaxRequest: 0
}, false, "io.youi.ajax.AjaxRequest", {
  Lio_youi_ajax_AjaxRequest: 1,
  O: 1
});
$c_Lio_youi_ajax_AjaxRequest.prototype.$classData = $d_Lio_youi_ajax_AjaxRequest;
/** @constructor */
function $c_Lio_youi_app_ApplicationConnectivity() {
  $c_O.call(this);
  this.application$1 = null;
  this.path$1 = null;
  this.autoConnect$1 = false;
  this.activeConnections$1 = null;
  this.connections$1 = null;
  this.communicationManagers$1 = null
}
$c_Lio_youi_app_ApplicationConnectivity.prototype = new $h_O();
$c_Lio_youi_app_ApplicationConnectivity.prototype.constructor = $c_Lio_youi_app_ApplicationConnectivity;
/** @constructor */
function $h_Lio_youi_app_ApplicationConnectivity() {
  /*<skip>*/
}
$h_Lio_youi_app_ApplicationConnectivity.prototype = $c_Lio_youi_app_ApplicationConnectivity.prototype;
$c_Lio_youi_app_ApplicationConnectivity.prototype.registerCommunicationManager__Lio_youi_app_CommunicationManager__V = (function(communicationManager) {
  var this$2 = $as_Lreactify_Var(this.communicationManagers$1);
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, communicationManager$1) {
    return (function() {
      var this$1 = $this.communicationManagers$1;
      return $as_sci_Set($as_sc_SetLike(this$1.get__O()).$$plus__O__sc_Set(communicationManager$1))
    })
  })(this, communicationManager));
  this$2.replace__F0__Z__V(value, true)
});
$c_Lio_youi_app_ApplicationConnectivity.prototype.init___Lio_youi_app_YouIApplication__T__Z = (function(application, path, autoConnect) {
  this.application$1 = application;
  this.path$1 = path;
  this.autoConnect$1 = autoConnect;
  this.activeConnections$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_sci_Set$EmptySet$()
    })
  })(this)), false, true, true);
  this.connections$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      $m_Lreactify_package$();
      var p = this$2.activeConnections$1;
      return $as_sci_Set(p.get__O())
    })
  })(this)), false, true, true);
  this.communicationManagers$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      return $m_sci_Set$EmptySet$()
    })
  })(this)), false, true, true);
  if ((application === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  var entries = $as_sci_Set(application.connectivityEntries__Lreactify_State().apply__O());
  var this$5 = $as_Lreactify_Var(application.connectivityEntries__Lreactify_State());
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, entries$1) {
    return (function() {
      return $as_sci_Set(entries$1.$$plus__O__sc_Set(this$4$1))
    })
  })(this, entries));
  this$5.replace__F0__Z__V(value, true);
  return this
});
function $is_Lio_youi_app_ApplicationConnectivity(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_ApplicationConnectivity)))
}
function $as_Lio_youi_app_ApplicationConnectivity(obj) {
  return (($is_Lio_youi_app_ApplicationConnectivity(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.ApplicationConnectivity"))
}
function $isArrayOf_Lio_youi_app_ApplicationConnectivity(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_ApplicationConnectivity)))
}
function $asArrayOf_Lio_youi_app_ApplicationConnectivity(obj, depth) {
  return (($isArrayOf_Lio_youi_app_ApplicationConnectivity(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.ApplicationConnectivity;", depth))
}
var $d_Lio_youi_app_ApplicationConnectivity = new $TypeData().initClass({
  Lio_youi_app_ApplicationConnectivity: 0
}, false, "io.youi.app.ApplicationConnectivity", {
  Lio_youi_app_ApplicationConnectivity: 1,
  O: 1
});
$c_Lio_youi_app_ApplicationConnectivity.prototype.$classData = $d_Lio_youi_app_ApplicationConnectivity;
/** @constructor */
function $c_Lio_youi_app_ClientApplication$$anon$1() {
  $c_O.call(this);
  this.derive$macro$1$1 = null;
  this.derive$macro$9$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_app_ClientApplication$$anon$1.prototype = new $h_O();
$c_Lio_youi_app_ClientApplication$$anon$1.prototype.constructor = $c_Lio_youi_app_ClientApplication$$anon$1;
/** @constructor */
function $h_Lio_youi_app_ClientApplication$$anon$1() {
  /*<skip>*/
}
$h_Lio_youi_app_ClientApplication$$anon$1.prototype = $c_Lio_youi_app_ClientApplication$$anon$1.prototype;
$c_Lio_youi_app_ClientApplication$$anon$1.prototype.derive$macro$9$lzycompute__p1__Lupickle_Types$Writer = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.derive$macro$9$1 = new $c_Lupickle_Types$Knot$Writer().init___Lupickle_Types$Knot$__F0($m_Lupickle_default$().Knot__Lupickle_Types$Knot$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$10 = $m_Lupickle_default$();
        var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
          return (function(x$0$2) {
            var x$0 = $as_Lio_youi_JavaScriptPosition(x$0$2);
            return $m_Lio_youi_JavaScriptPosition$().unapply__Lio_youi_JavaScriptPosition__s_Option(x$0)
          })
        })($this));
        var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(["line", "column"]);
        var len = $uI(xs.array$6.length);
        var array = $newArrayObject($d_T.getArrayOf(), [len]);
        var elem$1 = 0;
        elem$1 = 0;
        var this$4 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
        while (this$4.hasNext__Z()) {
          var arg1 = this$4.next__O();
          array.set(elem$1, arg1);
          elem$1 = ((1 + elem$1) | 0)
        };
        var xs$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array([null, null]);
        var len$1 = $uI(xs$1.array$6.length);
        var array$1 = $newArrayObject($d_Lupickle_Js$Value.getArrayOf(), [len$1]);
        var elem$1$1 = 0;
        elem$1$1 = 0;
        var this$8 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs$1, 0, $uI(xs$1.array$6.length));
        while (this$8.hasNext__Z()) {
          var arg1$1 = this$8.next__O();
          array$1.set(elem$1$1, arg1$1);
          elem$1$1 = ((1 + elem$1$1) | 0)
        };
        var this$9 = $m_Lupickle_default$();
        var evidence$3 = $m_Lupickle_default$().IntRW$1;
        var evidence$4 = $m_Lupickle_default$().IntRW$1;
        var evidence$15 = $as_Lupickle_Types$Writer($f_Lupickle_Generated__Tuple2W__O__O__O(this$9, evidence$3, evidence$4));
        return $f_Lupickle_Implicits__CaseW__F1__AT__ALupickle_Js$Value__Lupickle_Types$Writer__Lupickle_Types$Writer(this$10, f, array, array$1, evidence$15)
      })
    })(this)));
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.derive$macro$9$1
});
$c_Lio_youi_app_ClientApplication$$anon$1.prototype.init___Lio_youi_app_ClientApplication = (function($$outer) {
  return this
});
$c_Lio_youi_app_ClientApplication$$anon$1.prototype.derive$macro$1$lzycompute__p1__Lupickle_Types$Writer = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.derive$macro$1$1 = new $c_Lupickle_Types$Knot$Writer().init___Lupickle_Types$Knot$__F0($m_Lupickle_default$().Knot__Lupickle_Types$Knot$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$12 = $m_Lupickle_default$();
        var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
          return (function(x$0$2) {
            var x$0 = $as_Lio_youi_JavaScriptError(x$0$2);
            return $m_Lio_youi_JavaScriptError$().unapply__Lio_youi_JavaScriptError__s_Option(x$0)
          })
        })($this));
        var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(["message", "source", "fileName", "jsPosition", "position", "url", "cause"]);
        var len = $uI(xs.array$6.length);
        var array = $newArrayObject($d_T.getArrayOf(), [len]);
        var elem$1 = 0;
        elem$1 = 0;
        var this$4 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
        while (this$4.hasNext__Z()) {
          var arg1 = this$4.next__O();
          array.set(elem$1, arg1);
          elem$1 = ((1 + elem$1) | 0)
        };
        var xs$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array([null, null, null, null, null, null, null]);
        var len$1 = $uI(xs$1.array$6.length);
        var array$1 = $newArrayObject($d_Lupickle_Js$Value.getArrayOf(), [len$1]);
        var elem$1$1 = 0;
        elem$1$1 = 0;
        var this$8 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs$1, 0, $uI(xs$1.array$6.length));
        while (this$8.hasNext__Z()) {
          var arg1$1 = this$8.next__O();
          array$1.set(elem$1$1, arg1$1);
          elem$1$1 = ((1 + elem$1$1) | 0)
        };
        var this$11 = $m_Lupickle_default$();
        var evidence$43 = $m_Lupickle_default$().StringRW$1;
        var evidence$44 = $m_Lupickle_default$().StringRW$1;
        var evidence$45 = $m_Lupickle_default$().StringRW$1;
        var evidence$46 = $this.derive$macro$9__Lupickle_Types$Writer();
        var evidence$47 = $this.derive$macro$9__Lupickle_Types$Writer();
        var evidence$48 = $m_Lupickle_default$().StringRW$1;
        var this$10 = $m_Lupickle_default$();
        var this$9 = new $c_Lio_youi_app_ClientApplication$$anon$1$$anon$2().init___Lio_youi_app_ClientApplication$$anon$1($this);
        var evidence$20 = this$9.derive$macro$23__Lupickle_Types$Writer();
        var evidence$49 = $f_Lupickle_Implicits__OptionW__Lupickle_Types$Writer__Lupickle_Types$Writer(this$10, evidence$20);
        var evidence$15 = $as_Lupickle_Types$Writer($f_Lupickle_Generated__Tuple7W__O__O__O__O__O__O__O__O(this$11, evidence$43, evidence$44, evidence$45, evidence$46, evidence$47, evidence$48, evidence$49));
        return $f_Lupickle_Implicits__CaseW__F1__AT__ALupickle_Js$Value__Lupickle_Types$Writer__Lupickle_Types$Writer(this$12, f, array, array$1, evidence$15)
      })
    })(this)));
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.derive$macro$1$1
});
$c_Lio_youi_app_ClientApplication$$anon$1.prototype.derive$macro$1__Lupickle_Types$Writer = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.derive$macro$1$lzycompute__p1__Lupickle_Types$Writer() : this.derive$macro$1$1)
});
$c_Lio_youi_app_ClientApplication$$anon$1.prototype.derive$macro$9__Lupickle_Types$Writer = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.derive$macro$9$lzycompute__p1__Lupickle_Types$Writer() : this.derive$macro$9$1)
});
var $d_Lio_youi_app_ClientApplication$$anon$1 = new $TypeData().initClass({
  Lio_youi_app_ClientApplication$$anon$1: 0
}, false, "io.youi.app.ClientApplication$$anon$1", {
  Lio_youi_app_ClientApplication$$anon$1: 1,
  O: 1
});
$c_Lio_youi_app_ClientApplication$$anon$1.prototype.$classData = $d_Lio_youi_app_ClientApplication$$anon$1;
/** @constructor */
function $c_Lio_youi_app_ClientApplication$$anon$1$$anon$2() {
  $c_O.call(this);
  this.derive$macro$23$1 = null;
  this.bitmap$0$1 = false;
  this.$$outer$1 = null
}
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2.prototype = new $h_O();
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2.prototype.constructor = $c_Lio_youi_app_ClientApplication$$anon$1$$anon$2;
/** @constructor */
function $h_Lio_youi_app_ClientApplication$$anon$1$$anon$2() {
  /*<skip>*/
}
$h_Lio_youi_app_ClientApplication$$anon$1$$anon$2.prototype = $c_Lio_youi_app_ClientApplication$$anon$1$$anon$2.prototype;
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2.prototype.derive$macro$23$lzycompute__p1__Lupickle_Types$Writer = (function() {
  if ((!this.bitmap$0$1)) {
    this.derive$macro$23$1 = new $c_Lupickle_Types$Knot$Writer().init___Lupickle_Types$Knot$__F0($m_Lupickle_default$().Knot__Lupickle_Types$Knot$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$17 = $m_Lupickle_default$();
        var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
          return (function(x$0$2) {
            var x$0 = $as_Lio_youi_JavaScriptCause(x$0$2);
            return $m_Lio_youi_JavaScriptCause$().unapply__Lio_youi_JavaScriptCause__s_Option(x$0)
          })
        })($this));
        var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(["message", "trace", "cause"]);
        var len = $uI(xs.array$6.length);
        var array = $newArrayObject($d_T.getArrayOf(), [len]);
        var elem$1 = 0;
        elem$1 = 0;
        var this$4 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
        while (this$4.hasNext__Z()) {
          var arg1 = this$4.next__O();
          array.set(elem$1, arg1);
          elem$1 = ((1 + elem$1) | 0)
        };
        var xs$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array([null, null, null]);
        var len$1 = $uI(xs$1.array$6.length);
        var array$1 = $newArrayObject($d_Lupickle_Js$Value.getArrayOf(), [len$1]);
        var elem$1$1 = 0;
        elem$1$1 = 0;
        var this$8 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs$1, 0, $uI(xs$1.array$6.length));
        while (this$8.hasNext__Z()) {
          var arg1$1 = this$8.next__O();
          array$1.set(elem$1$1, arg1$1);
          elem$1$1 = ((1 + elem$1$1) | 0)
        };
        var this$16 = $m_Lupickle_default$();
        var evidence$7 = $m_Lupickle_default$().StringRW$1;
        var this$10 = $m_Lupickle_default$();
        var v = $m_s_Predef$().singleton$und$less$colon$less$2;
        var this$9 = new $c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3().init___Lio_youi_app_ClientApplication$$anon$1$$anon$2($this);
        var w = this$9.derive$macro$38__Lupickle_Types$Writer();
        var this$14 = this$10.Aliases__Lupickle_Types$Aliases$().W$1;
        var _write = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$2, v$1, w$1) {
          return (function(x$2) {
            var jsx$1 = $m_s_Predef$();
            var this$11 = $as_sc_IterableLike(x$2).iterator__sc_Iterator();
            var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$3, w$1$1) {
              return (function(x$16$2) {
                return $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this$3, x$16$2, w$1$1)
              })
            })($this$2, w$1));
            var this$13 = new $c_sc_Iterator$$anon$10().init___sc_Iterator__F1(this$11, f);
            var evidence$1 = new $c_s_reflect_ClassTag$GenericClassTag().init___jl_Class($d_Lupickle_Js$Value.getClassOf());
            return new $c_Lupickle_Js$Arr().init___sc_Seq(jsx$1.genericWrapArray__O__scm_WrappedArray($f_sc_TraversableOnce__toArray__s_reflect_ClassTag__O(this$13, evidence$1)))
          })
        })(this$10, v, w));
        var src = new $c_Lsourcecode_Enclosing().init___T("upickle.Implicits#SeqishW");
        var evidence$8 = new $c_Lupickle_Types$Writer$$anon$3().init___Lupickle_Types$Writer$__F1__Lsourcecode_Enclosing(this$14, _write, src);
        var this$15 = $m_Lupickle_default$();
        var evidence$20 = $this.derive$macro$23__Lupickle_Types$Writer();
        var evidence$9 = $f_Lupickle_Implicits__OptionW__Lupickle_Types$Writer__Lupickle_Types$Writer(this$15, evidence$20);
        var evidence$15 = $as_Lupickle_Types$Writer($f_Lupickle_Generated__Tuple3W__O__O__O__O(this$16, evidence$7, evidence$8, evidence$9));
        return $f_Lupickle_Implicits__CaseW__F1__AT__ALupickle_Js$Value__Lupickle_Types$Writer__Lupickle_Types$Writer(this$17, f$1, array, array$1, evidence$15)
      })
    })(this)));
    this.bitmap$0$1 = true
  };
  return this.derive$macro$23$1
});
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2.prototype.derive$macro$23__Lupickle_Types$Writer = (function() {
  return ((!this.bitmap$0$1) ? this.derive$macro$23$lzycompute__p1__Lupickle_Types$Writer() : this.derive$macro$23$1)
});
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2.prototype.init___Lio_youi_app_ClientApplication$$anon$1 = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_app_ClientApplication$$anon$1$$anon$2 = new $TypeData().initClass({
  Lio_youi_app_ClientApplication$$anon$1$$anon$2: 0
}, false, "io.youi.app.ClientApplication$$anon$1$$anon$2", {
  Lio_youi_app_ClientApplication$$anon$1$$anon$2: 1,
  O: 1
});
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2.prototype.$classData = $d_Lio_youi_app_ClientApplication$$anon$1$$anon$2;
/** @constructor */
function $c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3() {
  $c_O.call(this);
  this.derive$macro$38$1 = null;
  this.bitmap$0$1 = false;
  this.$$outer$1 = null
}
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3.prototype = new $h_O();
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3.prototype.constructor = $c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3;
/** @constructor */
function $h_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3() {
  /*<skip>*/
}
$h_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3.prototype = $c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3.prototype;
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3.prototype.derive$macro$38__Lupickle_Types$Writer = (function() {
  return ((!this.bitmap$0$1) ? this.derive$macro$38$lzycompute__p1__Lupickle_Types$Writer() : this.derive$macro$38$1)
});
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3.prototype.init___Lio_youi_app_ClientApplication$$anon$1$$anon$2 = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3.prototype.derive$macro$38$lzycompute__p1__Lupickle_Types$Writer = (function() {
  if ((!this.bitmap$0$1)) {
    this.derive$macro$38$1 = new $c_Lupickle_Types$Knot$Writer().init___Lupickle_Types$Knot$__F0($m_Lupickle_default$().Knot__Lupickle_Types$Knot$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$10 = $m_Lupickle_default$();
        var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
          return (function(x$0$2) {
            var x$0 = $as_Lio_youi_JavaScriptTrace(x$0$2);
            return $m_Lio_youi_JavaScriptTrace$().unapply__Lio_youi_JavaScriptTrace__s_Option(x$0)
          })
        })($this));
        var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(["className", "methodName", "fileName", "source", "jsPosition", "position"]);
        var len = $uI(xs.array$6.length);
        var array = $newArrayObject($d_T.getArrayOf(), [len]);
        var elem$1 = 0;
        elem$1 = 0;
        var this$4 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
        while (this$4.hasNext__Z()) {
          var arg1 = this$4.next__O();
          array.set(elem$1, arg1);
          elem$1 = ((1 + elem$1) | 0)
        };
        var xs$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array([null, null, null, null, null, null]);
        var len$1 = $uI(xs$1.array$6.length);
        var array$1 = $newArrayObject($d_Lupickle_Js$Value.getArrayOf(), [len$1]);
        var elem$1$1 = 0;
        elem$1$1 = 0;
        var this$8 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs$1, 0, $uI(xs$1.array$6.length));
        while (this$8.hasNext__Z()) {
          var arg1$1 = this$8.next__O();
          array$1.set(elem$1$1, arg1$1);
          elem$1$1 = ((1 + elem$1$1) | 0)
        };
        var this$9 = $m_Lupickle_default$();
        var evidence$31 = $m_Lupickle_default$().StringRW$1;
        var evidence$32 = $m_Lupickle_default$().StringRW$1;
        var evidence$33 = $m_Lupickle_default$().StringRW$1;
        var evidence$34 = $m_Lupickle_default$().StringRW$1;
        var evidence$35 = $this.$$outer$1.$$outer$1.derive$macro$9__Lupickle_Types$Writer();
        var evidence$36 = $this.$$outer$1.$$outer$1.derive$macro$9__Lupickle_Types$Writer();
        var evidence$15 = $as_Lupickle_Types$Writer($f_Lupickle_Generated__Tuple6W__O__O__O__O__O__O__O(this$9, evidence$31, evidence$32, evidence$33, evidence$34, evidence$35, evidence$36));
        return $f_Lupickle_Implicits__CaseW__F1__AT__ALupickle_Js$Value__Lupickle_Types$Writer__Lupickle_Types$Writer(this$10, f, array, array$1, evidence$15)
      })
    })(this)));
    this.bitmap$0$1 = true
  };
  return this.derive$macro$38$1
});
var $d_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3 = new $TypeData().initClass({
  Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3: 0
}, false, "io.youi.app.ClientApplication$$anon$1$$anon$2$$anon$3", {
  Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3: 1,
  O: 1
});
$c_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3.prototype.$classData = $d_Lio_youi_app_ClientApplication$$anon$1$$anon$2$$anon$3;
/** @constructor */
function $c_Lio_youi_app_ClientConnectivity() {
  $c_O.call(this);
  this.connectivity$1 = null;
  this.io$youi$app$ClientConnectivity$$application$f = null;
  this.connection$1 = null;
  this.webSocket$1 = null
}
$c_Lio_youi_app_ClientConnectivity.prototype = new $h_O();
$c_Lio_youi_app_ClientConnectivity.prototype.constructor = $c_Lio_youi_app_ClientConnectivity;
/** @constructor */
function $h_Lio_youi_app_ClientConnectivity() {
  /*<skip>*/
}
$h_Lio_youi_app_ClientConnectivity.prototype = $c_Lio_youi_app_ClientConnectivity.prototype;
$c_Lio_youi_app_ClientConnectivity.prototype.init___Lio_youi_app_ApplicationConnectivity__Lio_youi_app_ClientApplication = (function(connectivity, application) {
  this.connectivity$1 = connectivity;
  this.io$youi$app$ClientConnectivity$$application$f = application;
  this.connection$1 = new $c_Lio_youi_http_Connection().init___();
  this.webSocket$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_s_None$()
    })
  })(this)), false, true, true);
  if (connectivity.autoConnect$1) {
    this.connect__V()
  };
  var this$1 = this.connection$1.connected$1;
  var listener = new $c_Lio_youi_app_ClientConnectivity$$anon$1().init___Lio_youi_app_ClientConnectivity(this);
  $f_Lreactify_State__changes__Lreactify_ChangeListener__Lreactify_Listener(this$1, listener);
  return this
});
$c_Lio_youi_app_ClientConnectivity.prototype.io$youi$app$ClientConnectivity$$$anonfun$attemptReload$2__I__O = (function(attempt$1) {
  this.io$youi$app$ClientConnectivity$$attemptReload__I__V(((1 + attempt$1) | 0))
});
$c_Lio_youi_app_ClientConnectivity.prototype.connect__V = (function() {
  var this$2 = this.connectivity$1.activeConnections$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      var array = [$this.connection$1];
      if (($uI(array.length) === 0)) {
        var jsx$1 = $m_sci_Set$EmptySet$()
      } else {
        var b = new $c_scm_SetBuilder().init___sc_Set($m_sci_Set$EmptySet$());
        var i = 0;
        var len = $uI(array.length);
        while ((i < len)) {
          var index = i;
          var arg1 = array[index];
          b.$$plus$eq__O__scm_SetBuilder(arg1);
          i = ((1 + i) | 0)
        };
        var jsx$1 = b.elems$1
      };
      return $as_sci_Set(jsx$1)
    })
  })(this));
  this$2.replace__F0__Z__V(value, true);
  this.disconnect__V();
  var protocol = (($as_T($m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.protocol) === "https:") ? "wss" : "ws");
  var this$3 = $m_Lio_youi_net_URL$();
  var url = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "://", "", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([protocol, $as_T($m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().location.host), this.connectivity$1.path$1]));
  var url$1 = this$3.apply__T__Z__Lio_youi_net_URL(url, true);
  var this$4 = this.webSocket$1;
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1, url$2) {
    return (function() {
      return new $c_s_Some().init___O($m_Lio_youi_http_WebSocketUtil$().connect__Lio_youi_net_URL__Lio_youi_http_Connection__Lorg_scalajs_dom_raw_WebSocket(url$2, this$2$1.connection$1))
    })
  })(this, url$1));
  this$4.replace__F0__Z__V(value$1, true);
  var this$6 = new $c_s_concurrent_duration_package$DurationInt().init___I(30);
  var unit = $m_ju_concurrent_TimeUnit$().SECONDS$1;
  var x$1 = $m_s_concurrent_duration_package$DurationInt$().durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration(this$6.scala$concurrent$duration$DurationInt$$n$1, unit);
  $m_Lio_youi_AnimationFrame$();
  var x$3 = $m_s_None$();
  var x$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      this$3$1.ping__p1__V()
    })
  })(this));
  var this$8 = $m_Lio_youi_AnimationFrame$();
  $f_Lio_youi_Updates__every__s_concurrent_duration_FiniteDuration__s_Option__Z__F0__V(this$8, x$1, x$3, false, x$4)
});
$c_Lio_youi_app_ClientConnectivity.prototype.io$youi$app$ClientConnectivity$$attemptReload__I__V = (function(attempt) {
  var jsx$1 = $m_Lio_youi_app_stream_StreamURL$();
  var this$1 = $m_Lio_youi_History$().url$1;
  jsx$1.stream__Lio_youi_net_URL__s_Option__I__sci_Map__Z__T__s_concurrent_Future($as_Lio_youi_net_URL(this$1.get__O()), $m_s_None$(), 0, $m_sci_Map$EmptyMap$(), true, "").onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, attempt$1) {
    return (function(x0$1$2) {
      var x0$1 = $as_s_util_Try(x0$1$2);
      if ($is_s_util_Success(x0$1)) {
        $m_Lio_youi_History$().reload__Z__V(true);
        return (void 0)
      } else if ($is_s_util_Failure(x0$1)) {
        var x3 = $as_s_util_Failure(x0$1);
        var exception = x3.exception$2;
        if ($is_Lorg_scalajs_dom_ext_AjaxException(exception)) {
          var x2 = $as_Lorg_scalajs_dom_ext_AjaxException(exception);
          if (($uI(x2.xhr$3.status) > 0)) {
            $m_Lio_youi_History$().reload__Z__V(true);
            return (void 0)
          }
        };
        var timeout = ((attempt$1 < 10) ? 2500 : ((attempt$1 < 25) ? 5000 : ((attempt$1 < 100) ? 10000 : 30000)));
        return $uI($m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().setTimeout((function(arg$outer, attempt$1$1) {
          return (function() {
            return arg$outer.io$youi$app$ClientConnectivity$$$anonfun$attemptReload$2__I__O(attempt$1$1)
          })
        })($this, attempt$1), timeout))
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })(this, attempt)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
$c_Lio_youi_app_ClientConnectivity.prototype.disconnect__V = (function() {
  var this$1 = this.webSocket$1;
  var this$2 = $as_s_Option(this$1.get__O());
  if ((!this$2.isEmpty__Z())) {
    var arg1 = this$2.get__O();
    if (($uI(arg1.readyState) === $uI($m_Lorg_scalajs_dom_package$().WebSocket__Lorg_scalajs_dom_raw_WebSocket$().OPEN))) {
      arg1.close()
    };
    var this$3 = this.webSocket$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_s_None$()
      })
    })(this));
    this$3.replace__F0__Z__V(value, true)
  }
});
$c_Lio_youi_app_ClientConnectivity.prototype.ping__p1__V = (function() {
  var this$1 = this.connection$1.send$1.text$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return "PING"
    })
  })(this));
  this$1.set__F0__V(value)
});
function $is_Lio_youi_app_ClientConnectivity(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_ClientConnectivity)))
}
function $as_Lio_youi_app_ClientConnectivity(obj) {
  return (($is_Lio_youi_app_ClientConnectivity(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.ClientConnectivity"))
}
function $isArrayOf_Lio_youi_app_ClientConnectivity(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_ClientConnectivity)))
}
function $asArrayOf_Lio_youi_app_ClientConnectivity(obj, depth) {
  return (($isArrayOf_Lio_youi_app_ClientConnectivity(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.ClientConnectivity;", depth))
}
var $d_Lio_youi_app_ClientConnectivity = new $TypeData().initClass({
  Lio_youi_app_ClientConnectivity: 0
}, false, "io.youi.app.ClientConnectivity", {
  Lio_youi_app_ClientConnectivity: 1,
  O: 1
});
$c_Lio_youi_app_ClientConnectivity.prototype.$classData = $d_Lio_youi_app_ClientConnectivity;
/** @constructor */
function $c_Lio_youi_app_CommunicationManager() {
  $c_O.call(this);
  this.connectivity$1 = null;
  this.create$1 = null;
  this.id$1 = 0;
  this.instances$1 = null
}
$c_Lio_youi_app_CommunicationManager.prototype = new $h_O();
$c_Lio_youi_app_CommunicationManager.prototype.constructor = $c_Lio_youi_app_CommunicationManager;
/** @constructor */
function $h_Lio_youi_app_CommunicationManager() {
  /*<skip>*/
}
$h_Lio_youi_app_CommunicationManager.prototype = $c_Lio_youi_app_CommunicationManager.prototype;
$c_Lio_youi_app_CommunicationManager.prototype.byConnection__Lio_youi_http_Connection__s_Option = (function(connection) {
  $m_Lreactify_package$();
  var p = this.instances$1;
  return $as_sc_IterableLike(p.get__O()).find__F1__s_Option(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, connection$1) {
    return (function(x$1$2) {
      var x$1 = $as_Lio_youi_communication_Communication(x$1$2);
      return (x$1.connection__Lio_youi_http_Connection() === connection$1)
    })
  })(this, connection)))
});
$c_Lio_youi_app_CommunicationManager.prototype.init___Lio_youi_app_ApplicationConnectivity__F1 = (function(connectivity, create) {
  this.connectivity$1 = connectivity;
  this.create$1 = create;
  var this$1 = $m_Lio_youi_app_CommunicationManager$().io$youi$app$CommunicationManager$$increment$1;
  var old = this$1.java$util$concurrent$atomic$AtomicInteger$$value$f;
  this$1.java$util$concurrent$atomic$AtomicInteger$$value$f = ((1 + old) | 0);
  this.id$1 = old;
  this.instances$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $m_Lreactify_package$();
      var p = $this.connectivity$1.connections$1;
      var this$5 = $as_sc_SetLike(p.get__O());
      var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
        return (function(connection$2) {
          var connection = $as_Lio_youi_http_Connection(connection$2);
          var this$3 = connection.store$1;
          var key = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["communicationManager", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([$this$1.id$1]));
          var x1 = this$3.map$1.get__O__s_Option(key);
          if ($is_s_Some(x1)) {
            var x2 = $as_s_Some(x1);
            var value = x2.value$2;
            var jsx$1 = value
          } else {
            var x = $m_s_None$();
            if ((!(x === x1))) {
              throw new $c_s_MatchError().init___O(x1)
            };
            var value$2 = $as_Lio_youi_communication_Communication($this$1.create$1.apply__O__O(connection));
            this$3.update__T__O__V(key, value$2);
            var jsx$1 = value$2
          };
          return $as_Lio_youi_communication_Communication(jsx$1)
        })
      })($this));
      var this$4 = $m_sci_Set$();
      var bf = new $c_scg_GenSetFactory$$anon$1().init___scg_GenSetFactory(this$4);
      return $as_sci_Set($f_sc_TraversableLike__map__F1__scg_CanBuildFrom__O(this$5, f, bf))
    })
  })(this)), false, true, true);
  connectivity.registerCommunicationManager__Lio_youi_app_CommunicationManager__V(this);
  return this
});
$c_Lio_youi_app_CommunicationManager.prototype.apply__Lio_youi_http_Connection__Lio_youi_communication_Communication = (function(connection) {
  var this$1 = this.byConnection__Lio_youi_http_Connection__s_Option(connection);
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("No CommunicationManager found for connection!"))
  };
  return $as_Lio_youi_communication_Communication(this$1.get__O())
});
var $d_Lio_youi_app_CommunicationManager = new $TypeData().initClass({
  Lio_youi_app_CommunicationManager: 0
}, false, "io.youi.app.CommunicationManager", {
  Lio_youi_app_CommunicationManager: 1,
  O: 1
});
$c_Lio_youi_app_CommunicationManager.prototype.$classData = $d_Lio_youi_app_CommunicationManager;
/** @constructor */
function $c_Lio_youi_app_CommunicationManager$() {
  $c_O.call(this);
  this.io$youi$app$CommunicationManager$$increment$1 = null
}
$c_Lio_youi_app_CommunicationManager$.prototype = new $h_O();
$c_Lio_youi_app_CommunicationManager$.prototype.constructor = $c_Lio_youi_app_CommunicationManager$;
/** @constructor */
function $h_Lio_youi_app_CommunicationManager$() {
  /*<skip>*/
}
$h_Lio_youi_app_CommunicationManager$.prototype = $c_Lio_youi_app_CommunicationManager$.prototype;
$c_Lio_youi_app_CommunicationManager$.prototype.init___ = (function() {
  $n_Lio_youi_app_CommunicationManager$ = this;
  this.io$youi$app$CommunicationManager$$increment$1 = new $c_ju_concurrent_atomic_AtomicInteger().init___I(0);
  return this
});
var $d_Lio_youi_app_CommunicationManager$ = new $TypeData().initClass({
  Lio_youi_app_CommunicationManager$: 0
}, false, "io.youi.app.CommunicationManager$", {
  Lio_youi_app_CommunicationManager$: 1,
  O: 1
});
$c_Lio_youi_app_CommunicationManager$.prototype.$classData = $d_Lio_youi_app_CommunicationManager$;
var $n_Lio_youi_app_CommunicationManager$ = (void 0);
function $m_Lio_youi_app_CommunicationManager$() {
  if ((!$n_Lio_youi_app_CommunicationManager$)) {
    $n_Lio_youi_app_CommunicationManager$ = new $c_Lio_youi_app_CommunicationManager$().init___()
  };
  return $n_Lio_youi_app_CommunicationManager$
}
/** @constructor */
function $c_Lio_youi_app_YouIApplication$() {
  $c_O.call(this);
  this.io$youi$app$YouIApplication$$instance$1 = null
}
$c_Lio_youi_app_YouIApplication$.prototype = new $h_O();
$c_Lio_youi_app_YouIApplication$.prototype.constructor = $c_Lio_youi_app_YouIApplication$;
/** @constructor */
function $h_Lio_youi_app_YouIApplication$() {
  /*<skip>*/
}
$h_Lio_youi_app_YouIApplication$.prototype = $c_Lio_youi_app_YouIApplication$.prototype;
$c_Lio_youi_app_YouIApplication$.prototype.init___ = (function() {
  $n_Lio_youi_app_YouIApplication$ = this;
  this.io$youi$app$YouIApplication$$instance$1 = $m_s_None$();
  return this
});
$c_Lio_youi_app_YouIApplication$.prototype.apply__Lio_youi_app_YouIApplication = (function() {
  var this$1 = this.io$youi$app$YouIApplication$$instance$1;
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("No YouIApplication is initialized!"))
  };
  return $as_Lio_youi_app_YouIApplication(this$1.get__O())
});
var $d_Lio_youi_app_YouIApplication$ = new $TypeData().initClass({
  Lio_youi_app_YouIApplication$: 0
}, false, "io.youi.app.YouIApplication$", {
  Lio_youi_app_YouIApplication$: 1,
  O: 1
});
$c_Lio_youi_app_YouIApplication$.prototype.$classData = $d_Lio_youi_app_YouIApplication$;
var $n_Lio_youi_app_YouIApplication$ = (void 0);
function $m_Lio_youi_app_YouIApplication$() {
  if ((!$n_Lio_youi_app_YouIApplication$)) {
    $n_Lio_youi_app_YouIApplication$ = new $c_Lio_youi_app_YouIApplication$().init___()
  };
  return $n_Lio_youi_app_YouIApplication$
}
function $f_Lio_youi_app_screen_CrossFadeSupport__beforeScreenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, oldScreen, newScreen) {
  if (($as_T($thiz.crossFadeElement$1.style.visibility) !== "visible")) {
    var this$7 = $m_Lio_youi_workflow_package$().synchronous__F0__Lio_youi_workflow_Action(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $this.crossFadeElement$1.style.visibility = "visible";
        $this.crossFadeElement$1.style.opacity = "0.0"
      })
    })($thiz)));
    var task = new $c_Lio_youi_workflow_AnimateIn().init___F0__F1__F0__s_concurrent_duration_FiniteDuration__Lio_youi_easing_Easing(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
      return (function() {
        var x = $as_T(this$2.crossFadeElement$1.style.opacity);
        var this$3 = new $c_sci_StringOps().init___T(x);
        var jsx$1 = $m_jl_Double$();
        var $$this = this$3.repr$1;
        return jsx$1.parseDouble__T__D($$this)
      })
    })($thiz)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1) {
      return (function(d$2) {
        var d = $uD(d$2);
        this$3$1.crossFadeElement$1.style.opacity = ("" + d)
      })
    })($thiz)), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1) {
      return (function() {
        return 1.0
      })
    })($thiz)), $thiz.crossFadeDuration$1, $m_Lio_youi_easing_Linear$());
    var workflow = new $c_Lio_youi_workflow_ChainedTask().init___Lio_youi_workflow_Task__Lio_youi_workflow_Task(this$7, task);
    return $f_Lio_youi_workflow_Task__start__s_concurrent_Future(workflow)
  } else {
    return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
  }
}
function $f_Lio_youi_app_screen_CrossFadeSupport__afterScreenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__s_concurrent_Future($thiz, oldScreen, newScreen) {
  if (($as_T($thiz.crossFadeElement$1.style.visibility) === "visible")) {
    var this$6 = new $c_Lio_youi_workflow_AnimateIn().init___F0__F1__F0__s_concurrent_duration_FiniteDuration__Lio_youi_easing_Easing(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var x = $as_T($this.crossFadeElement$1.style.opacity);
        var this$2 = new $c_sci_StringOps().init___T(x);
        var jsx$1 = $m_jl_Double$();
        var $$this = this$2.repr$1;
        return jsx$1.parseDouble__T__D($$this)
      })
    })($thiz)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
      return (function(d$2) {
        var d = $uD(d$2);
        this$2$1.crossFadeElement$1.style.opacity = ("" + d)
      })
    })($thiz)), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
      return (function() {
        return 0.0
      })
    })($thiz)), $thiz.crossFadeDuration$1, $m_Lio_youi_easing_Linear$());
    var task = $m_Lio_youi_workflow_package$().synchronous__F0__Lio_youi_workflow_Action(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1) {
      return (function() {
        this$4$1.crossFadeElement$1.style.visibility = "hidden"
      })
    })($thiz)));
    var this$7 = new $c_Lio_youi_workflow_ChainedTask().init___Lio_youi_workflow_Task__Lio_youi_workflow_Task(this$6, task);
    return $f_Lio_youi_workflow_Task__start__s_concurrent_Future(this$7)
  } else {
    return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
  }
}
/** @constructor */
function $c_Lio_youi_app_screen_ScreenManager$() {
  $c_O.call(this);
  this.io$youi$app$screen$ScreenManager$$instance$1 = null
}
$c_Lio_youi_app_screen_ScreenManager$.prototype = new $h_O();
$c_Lio_youi_app_screen_ScreenManager$.prototype.constructor = $c_Lio_youi_app_screen_ScreenManager$;
/** @constructor */
function $h_Lio_youi_app_screen_ScreenManager$() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_ScreenManager$.prototype = $c_Lio_youi_app_screen_ScreenManager$.prototype;
$c_Lio_youi_app_screen_ScreenManager$.prototype.init___ = (function() {
  $n_Lio_youi_app_screen_ScreenManager$ = this;
  this.io$youi$app$screen$ScreenManager$$instance$1 = $m_s_None$();
  return this
});
$c_Lio_youi_app_screen_ScreenManager$.prototype.apply__Lio_youi_app_screen_ScreenManager = (function() {
  var this$1 = this.io$youi$app$screen$ScreenManager$$instance$1;
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T("No ScreenManager is initialized!"))
  };
  return $as_Lio_youi_app_screen_ScreenManager(this$1.get__O())
});
var $d_Lio_youi_app_screen_ScreenManager$ = new $TypeData().initClass({
  Lio_youi_app_screen_ScreenManager$: 0
}, false, "io.youi.app.screen.ScreenManager$", {
  Lio_youi_app_screen_ScreenManager$: 1,
  O: 1
});
$c_Lio_youi_app_screen_ScreenManager$.prototype.$classData = $d_Lio_youi_app_screen_ScreenManager$;
var $n_Lio_youi_app_screen_ScreenManager$ = (void 0);
function $m_Lio_youi_app_screen_ScreenManager$() {
  if ((!$n_Lio_youi_app_screen_ScreenManager$)) {
    $n_Lio_youi_app_screen_ScreenManager$ = new $c_Lio_youi_app_screen_ScreenManager$().init___()
  };
  return $n_Lio_youi_app_screen_ScreenManager$
}
/** @constructor */
function $c_Lio_youi_app_screen_ScreenState() {
  $c_O.call(this);
  this.index$1 = 0;
  this.working$1 = false
}
$c_Lio_youi_app_screen_ScreenState.prototype = new $h_O();
$c_Lio_youi_app_screen_ScreenState.prototype.constructor = $c_Lio_youi_app_screen_ScreenState;
/** @constructor */
function $h_Lio_youi_app_screen_ScreenState() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_ScreenState.prototype = $c_Lio_youi_app_screen_ScreenState.prototype;
$c_Lio_youi_app_screen_ScreenState.prototype.init___I__Z = (function(index, working) {
  this.index$1 = index;
  this.working$1 = working;
  return this
});
function $is_Lio_youi_app_screen_ScreenState(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_screen_ScreenState)))
}
function $as_Lio_youi_app_screen_ScreenState(obj) {
  return (($is_Lio_youi_app_screen_ScreenState(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.screen.ScreenState"))
}
function $isArrayOf_Lio_youi_app_screen_ScreenState(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_screen_ScreenState)))
}
function $asArrayOf_Lio_youi_app_screen_ScreenState(obj, depth) {
  return (($isArrayOf_Lio_youi_app_screen_ScreenState(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.screen.ScreenState;", depth))
}
function $f_Lio_youi_app_screen_UIScreen__activate__s_concurrent_Future($thiz) {
  return $f_Lio_youi_example_ui_UIExampleScreen__activate__s_concurrent_Future($thiz).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$3$2) {
      $asUnit(x$3$2);
      var this$1 = $m_Lio_youi_app_screen_UIScreen$().canvas__Lio_youi_hypertext_Canvas().visible__Lreactify_Var();
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
        return (function() {
          return true
        })
      })($this));
      this$1.replace__F0__Z__V(value, true);
      var this$3 = $this.container__Lio_youi_component_Container().visible$1;
      var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
        return (function() {
          return true
        })
      })($this));
      this$3.replace__F0__Z__V(value$1, true)
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $f_Lio_youi_app_screen_UIScreen__deactivate__s_concurrent_Future($thiz) {
  return $f_Lio_youi_app_screen_ContentScreen__deactivate__s_concurrent_Future($thiz).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$4$2) {
      $asUnit(x$4$2);
      var this$1 = $this.container__Lio_youi_component_Container().visible$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
        return (function() {
          return false
        })
      })($this));
      this$1.replace__F0__Z__V(value, true);
      var this$3 = $m_Lio_youi_app_screen_UIScreen$().canvas__Lio_youi_hypertext_Canvas().visible__Lreactify_Var();
      var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
        return (function() {
          return false
        })
      })($this));
      this$3.replace__F0__Z__V(value$1, true)
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $f_Lio_youi_app_screen_UIScreen__init__s_concurrent_Future($thiz) {
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0)).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      $asUnit(x$1$2);
      var this$2 = $this.container__Lio_youi_component_Container().size__Lio_youi_component_Component$size$().width__Lio_youi_component_Component$size$width$();
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
        return (function() {
          $m_Lreactify_package$();
          var p = $m_Lio_youi_app_screen_UIScreen$().renderer__Lio_youi_component_Renderer().size__Lio_youi_component_Component$size$().width__Lio_youi_component_Component$size$width$();
          return $uD(p.get__O())
        })
      })($this));
      this$2.replace__F0__Z__V(value, true);
      var this$4 = $this.container__Lio_youi_component_Container().size__Lio_youi_component_Component$size$().height__Lio_youi_component_Component$size$height$();
      var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
        return (function() {
          $m_Lreactify_package$();
          var p$1 = $m_Lio_youi_app_screen_UIScreen$().renderer__Lio_youi_component_Renderer().size__Lio_youi_component_Component$size$().height__Lio_youi_component_Component$size$height$();
          return $uD(p$1.get__O())
        })
      })($this));
      this$4.replace__F0__Z__V(value$1, true);
      var this$5 = $this.container__Lio_youi_component_Container().visible$1;
      var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
        return (function() {
          return false
        })
      })($this));
      this$5.replace__F0__Z__V(value$2, true);
      $m_Lreactify_package$();
      var v = $m_Lio_youi_app_screen_UIScreen$().renderer__Lio_youi_component_Renderer().children$1;
      new $c_Lreactify_package$VectorStateChannel().init___Lreactify_StateChannel(v).$$plus$eq__O__V($this.container__Lio_youi_component_Container())
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $f_Lio_youi_app_screen_UIScreen__load__s_concurrent_Future($thiz) {
  return $f_Lio_youi_app_screen_ContentScreen__load__s_concurrent_Future($thiz).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$2$2) {
      $asUnit(x$2$2);
      $this.createUI__V()
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
/** @constructor */
function $c_Lio_youi_app_screen_UIScreen$() {
  $c_O.call(this);
  this.canvas$1 = null;
  this.renderer$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_app_screen_UIScreen$.prototype = new $h_O();
$c_Lio_youi_app_screen_UIScreen$.prototype.constructor = $c_Lio_youi_app_screen_UIScreen$;
/** @constructor */
function $h_Lio_youi_app_screen_UIScreen$() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_UIScreen$.prototype = $c_Lio_youi_app_screen_UIScreen$.prototype;
$c_Lio_youi_app_screen_UIScreen$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_app_screen_UIScreen$.prototype.canvas__Lio_youi_hypertext_Canvas = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.canvas$lzycompute__p1__Lio_youi_hypertext_Canvas() : this.canvas$1)
});
$c_Lio_youi_app_screen_UIScreen$.prototype.canvas$lzycompute__p1__Lio_youi_hypertext_Canvas = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.canvas$1 = new $c_Lio_youi_app_screen_UIScreen$$anon$1().init___();
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.canvas$1
});
$c_Lio_youi_app_screen_UIScreen$.prototype.renderer$lzycompute__p1__Lio_youi_component_Renderer = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    var canvas = this.canvas__Lio_youi_hypertext_Canvas();
    var r = new $c_Lio_youi_component_Renderer().init___Lio_youi_hypertext_Canvas(canvas);
    var this$4 = r.size__Lio_youi_component_Component$size$().width__Lio_youi_component_Component$size$width$();
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $m_Lio_youi_UI$().size__Lio_youi_hypertext_AbstractComponent$size$().width__Lreactify_Var();
        return $uD(p.get__O())
      })
    })(this));
    this$4.replace__F0__Z__V(value, true);
    var this$7 = r.size__Lio_youi_component_Component$size$().height__Lio_youi_component_Component$size$height$();
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
      return (function() {
        $m_Lreactify_package$();
        var p$1 = $m_Lio_youi_UI$().size__Lio_youi_hypertext_AbstractComponent$size$().height__Lreactify_Var();
        return $uD(p$1.get__O())
      })
    })(this));
    this$7.replace__F0__Z__V(value$1, true);
    this.renderer$1 = r;
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.renderer$1
});
$c_Lio_youi_app_screen_UIScreen$.prototype.renderer__Lio_youi_component_Renderer = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.renderer$lzycompute__p1__Lio_youi_component_Renderer() : this.renderer$1)
});
var $d_Lio_youi_app_screen_UIScreen$ = new $TypeData().initClass({
  Lio_youi_app_screen_UIScreen$: 0
}, false, "io.youi.app.screen.UIScreen$", {
  Lio_youi_app_screen_UIScreen$: 1,
  O: 1
});
$c_Lio_youi_app_screen_UIScreen$.prototype.$classData = $d_Lio_youi_app_screen_UIScreen$;
var $n_Lio_youi_app_screen_UIScreen$ = (void 0);
function $m_Lio_youi_app_screen_UIScreen$() {
  if ((!$n_Lio_youi_app_screen_UIScreen$)) {
    $n_Lio_youi_app_screen_UIScreen$ = new $c_Lio_youi_app_screen_UIScreen$().init___()
  };
  return $n_Lio_youi_app_screen_UIScreen$
}
function $f_Lio_youi_app_screen_URLActivation__activate__s_concurrent_Future($thiz) {
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0)).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      $asUnit(x$1$2);
      var this$1 = $m_Lio_youi_History$().url$1;
      var currentURL = $as_Lio_youi_net_URL(this$1.get__O());
      var this$2 = $f_Lio_youi_app_screen_PathActivation__updateURL__Lio_youi_net_URL__s_Option($this, currentURL);
      if ((!this$2.isEmpty__Z())) {
        var arg1 = this$2.get__O();
        var change = $as_Lio_youi_HistoryStateChange(arg1);
        $m_Lio_youi_History$().update__Lio_youi_HistoryStateChange__V(change)
      }
    })
  })($thiz)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
}
function $f_Lio_youi_app_screen_URLActivation__$$init$__V($thiz) {
  var this$1 = $m_Lio_youi_History$().url$1;
  var listener = new $c_Lio_youi_app_screen_URLActivation$$anon$1().init___Lio_youi_app_screen_URLActivation($thiz);
  $f_Lreactify_State__changes__Lreactify_ChangeListener__Lreactify_Listener(this$1, listener);
  var this$2 = $m_Lio_youi_History$().url$1;
  var url = $as_Lio_youi_net_URL(this$2.get__O());
  $f_Lio_youi_app_screen_URLActivation__io$youi$app$screen$URLActivation$$validateURL__Lio_youi_net_URL__V($thiz, url)
}
function $f_Lio_youi_app_screen_URLActivation__io$youi$app$screen$URLActivation$$validateURL__Lio_youi_net_URL__V($thiz, url) {
  if ($f_Lio_youi_app_screen_PathActivation__isURLMatch__Lio_youi_net_URL__Z($thiz, url)) {
    var this$1 = $thiz.state__Lreactify_Val();
    var x = this$1.get__O();
    var x$2 = $m_Lio_youi_app_screen_ScreenState$Activated$();
    if ((!((x !== null) && $objectEquals(x, x$2)))) {
      var this$2 = $m_Lio_youi_app_screen_ScreenManager$().apply__Lio_youi_app_screen_ScreenManager().active__Lreactify_Var();
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
        return (function() {
          return $this
        })
      })($thiz));
      this$2.replace__F0__Z__V(value, true)
    }
  }
}
/** @constructor */
function $c_Lio_youi_app_sourceMap_ErrorTrace$() {
  $c_O.call(this);
  this.sourceMaps$1 = null
}
$c_Lio_youi_app_sourceMap_ErrorTrace$.prototype = new $h_O();
$c_Lio_youi_app_sourceMap_ErrorTrace$.prototype.constructor = $c_Lio_youi_app_sourceMap_ErrorTrace$;
/** @constructor */
function $h_Lio_youi_app_sourceMap_ErrorTrace$() {
  /*<skip>*/
}
$h_Lio_youi_app_sourceMap_ErrorTrace$.prototype = $c_Lio_youi_app_sourceMap_ErrorTrace$.prototype;
$c_Lio_youi_app_sourceMap_ErrorTrace$.prototype.init___ = (function() {
  $n_Lio_youi_app_sourceMap_ErrorTrace$ = this;
  this.sourceMaps$1 = $m_sci_Map$EmptyMap$();
  return this
});
$c_Lio_youi_app_sourceMap_ErrorTrace$.prototype.map__p1__Lio_youi_app_sourceMap_SourceMapConsumer__I__I__Lio_youi_app_sourceMap_SourcePosition = (function(sourceMapConsumer, line, column) {
  var jsx$1 = $g.JSON;
  var this$3 = $m_Lupickle_default$();
  var expr = new $c_Lio_youi_JavaScriptPosition().init___I__I(line, column);
  $m_Lupickle_default$();
  var indent = 0;
  var this$2 = new $c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1().init___();
  var evidence$1 = this$2.derive$macro$52__Lupickle_Types$Writer();
  var position = jsx$1.parse($f_Lupickle_Types__write__O__I__Lupickle_Types$Writer__T(this$3, expr, indent, evidence$1));
  return sourceMapConsumer.originalPositionFor(position)
});
$c_Lio_youi_app_sourceMap_ErrorTrace$.prototype.sourceMapConsumerFor__p1__T__s_concurrent_Future = (function(fileName) {
  var x1 = this.sourceMaps$1.get__O__s_Option(fileName);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var sourceMapConsumer = x2.value$2;
    return $m_s_concurrent_Future$().successful__O__s_concurrent_Future(new $c_s_Some().init___O(sourceMapConsumer))
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var jsx$1 = $m_Lio_youi_app_stream_StreamURL$();
      var this$1 = $m_Lio_youi_net_URL$();
      var url = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", ".map"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([fileName]));
      return jsx$1.stream__Lio_youi_net_URL__s_Option__I__sci_Map__Z__T__s_concurrent_Future(this$1.apply__T__Z__Lio_youi_net_URL(url, true), $m_s_None$(), 0, $m_sci_Map$EmptyMap$(), true, "").map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, fileName$1) {
        return (function(jsonString$2) {
          var jsonString = $as_T(jsonString$2);
          try {
            var json = $g.JSON.parse(jsonString);
            var sourceMapConsumer$1 = new $g.window.sourceMap.SourceMapConsumer(json);
            $this.sourceMaps$1 = $this.sourceMaps$1.$$plus__T2__sci_Map(new $c_T2().init___O__O(fileName$1, sourceMapConsumer$1));
            return new $c_s_Some().init___O(sourceMapConsumer$1)
          } catch (e) {
            var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
            if ((e$2 !== null)) {
              var this$8 = $m_Lscribe_package$();
              var level = $m_Lscribe_Level$Error$();
              var message = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, t) {
                return (function() {
                  return $m_Lscribe_Logger$().throwable2String__jl_Throwable__Z__scm_StringBuilder__T(t, ($m_Lscribe_Logger$(), true), ($m_Lscribe_Logger$(), new $c_scm_StringBuilder().init___()))
                })
              })($this, e$2));
              var methodName = new $c_s_Some().init___O("sourceMapConsumerFor");
              $f_Lscribe_LoggerSupport__log__Lscribe_Level__F0__T__s_Option__I__V(this$8, level, message, "io.youi.app.sourceMap.ErrorTrace", methodName, 35);
              return $m_s_None$()
            } else {
              throw e
            }
          }
        })
      })(this, fileName)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
$c_Lio_youi_app_sourceMap_ErrorTrace$.prototype.toErrorInternal__p1__s_Option__T__T__I__I__s_Option__Lio_youi_JavaScriptError = (function(consumerOption, message, source, line, column, error) {
  if (consumerOption.isEmpty__Z()) {
    var this$3 = $m_s_None$()
  } else {
    var arg1 = consumerOption.get__O();
    var sourcePosition = this.map__p1__Lio_youi_app_sourceMap_SourceMapConsumer__I__I__Lio_youi_app_sourceMap_SourcePosition(arg1, line, column);
    var self = $as_T(sourcePosition.source);
    var y = new $c_Lio_youi_JavaScriptPosition().init___I__I($uI(sourcePosition.line), $uI(sourcePosition.column));
    var this$3 = new $c_s_Some().init___O(new $c_T2().init___O__O(self, y))
  };
  if (this$3.isEmpty__Z()) {
    var y$1 = new $c_Lio_youi_JavaScriptPosition().init___I__I((-1), (-1));
    var jsx$1 = new $c_T2().init___O__O(source, y$1)
  } else {
    var jsx$1 = this$3.get__O()
  };
  var x1 = $as_T2(jsx$1);
  if ((x1 === null)) {
    throw new $c_s_MatchError().init___O(x1)
  };
  var fileName = $as_T(x1.$$und1__O());
  var sourcePosition$1 = $as_Lio_youi_JavaScriptPosition(x1.$$und2__O());
  if (error.isEmpty__Z()) {
    var cause = $m_s_None$()
  } else {
    var arg1$1 = error.get__O();
    var x$2 = $as_jl_Throwable(arg1$1);
    var cause = new $c_s_Some().init___O(this.toCause__p1__s_Option__jl_Throwable__Lio_youi_JavaScriptCause(consumerOption, x$2))
  };
  var jsx$2 = new $c_Lio_youi_JavaScriptPosition().init___I__I(line, column);
  var this$6 = $m_Lio_youi_History$().url$1;
  var this$7 = $as_Lio_youi_net_URL(this$6.get__O());
  return new $c_Lio_youi_JavaScriptError().init___T__T__T__Lio_youi_JavaScriptPosition__Lio_youi_JavaScriptPosition__T__s_Option(message, source, fileName, jsx$2, sourcePosition$1, this$7.encoded__Lio_youi_net_URL$URLParts().asString__T(), cause)
});
$c_Lio_youi_app_sourceMap_ErrorTrace$.prototype.toError__T__T__I__I__s_Option__s_concurrent_Future = (function(message, source, line, column, error) {
  return this.sourceMapConsumerFor__p1__T__s_concurrent_Future(source).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, message$1, source$1, line$1, column$1, error$1) {
    return (function(consumerOption$2) {
      var consumerOption = $as_s_Option(consumerOption$2);
      return $this.toErrorInternal__p1__s_Option__T__T__I__I__s_Option__Lio_youi_JavaScriptError(consumerOption, message$1, source$1, line$1, column$1, error$1)
    })
  })(this, message, source, line, column, error)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
$c_Lio_youi_app_sourceMap_ErrorTrace$.prototype.toCause__p1__s_Option__jl_Throwable__Lio_youi_JavaScriptCause = (function(consumerOption, throwable) {
  if (consumerOption.isEmpty__Z()) {
    var this$13 = $m_s_None$()
  } else {
    var arg1 = consumerOption.get__O();
    var xs = throwable.getStackTrace__Ajl_StackTraceElement();
    var this$2 = $m_sci_List$();
    var cbf = this$2.ReusableCBFInstance$2;
    var b = cbf.apply__scm_Builder();
    var x1 = xs.u.length;
    switch (x1) {
      case (-1): {
        break
      }
      default: {
        b.sizeHint__I__V(x1)
      }
    };
    b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs));
    var this$10 = $as_sci_List(b.result__O());
    var f = (function($this, consumer) {
      return (function(element$2) {
        var element = $as_jl_StackTraceElement(element$2);
        var tracePosition = $this.map__p1__Lio_youi_app_sourceMap_SourceMapConsumer__I__I__Lio_youi_app_sourceMap_SourcePosition(consumer, element.lineNumber$1, $uI(element.getColumnNumber()));
        return new $c_Lio_youi_JavaScriptTrace().init___T__T__T__T__Lio_youi_JavaScriptPosition__Lio_youi_JavaScriptPosition(element.declaringClass$1, element.methodName$1, element.fileName$1, $as_T(tracePosition.source), new $c_Lio_youi_JavaScriptPosition().init___I__I(element.lineNumber$1, $uI(element.getColumnNumber())), new $c_Lio_youi_JavaScriptPosition().init___I__I($uI(tracePosition.line), $uI(tracePosition.column)))
      })
    })(this, arg1);
    var this$9 = $m_sci_List$();
    var bf = this$9.ReusableCBFInstance$2;
    if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
      if ((this$10 === $m_sci_Nil$())) {
        var jsx$3 = $m_sci_Nil$()
      } else {
        var arg1$1 = this$10.head__O();
        var h = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$1), $m_sci_Nil$());
        var t = h;
        var rest = $as_sci_List(this$10.tail__O());
        while ((rest !== $m_sci_Nil$())) {
          var arg1$2 = rest.head__O();
          var nx = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$2), $m_sci_Nil$());
          t.tl$5 = nx;
          t = nx;
          rest = $as_sci_List(rest.tail__O())
        };
        var jsx$3 = h
      }
    } else {
      var b$1 = $f_sc_TraversableLike__builder$1__psc_TraversableLike__scg_CanBuildFrom__scm_Builder(this$10, bf);
      var these = this$10;
      while ((!these.isEmpty__Z())) {
        var arg1$3 = these.head__O();
        b$1.$$plus$eq__O__scm_Builder(f(arg1$3));
        these = $as_sci_List(these.tail__O())
      };
      var jsx$3 = b$1.result__O()
    };
    var jsx$2 = $as_sci_List(jsx$3);
    var jsx$1 = new $c_Lio_youi_app_sourceMap_ErrorTrace$$anonfun$1().init___();
    var this$11 = $m_sci_List$();
    var trace = $as_sci_List(jsx$2.collect__s_PartialFunction__scg_CanBuildFrom__O(jsx$1, this$11.ReusableCBFInstance$2));
    var jsx$5 = throwable.getMessage__T();
    var this$12 = $m_s_Option$().apply__O__s_Option(throwable.e$1);
    if (this$12.isEmpty__Z()) {
      var jsx$4 = $m_s_None$()
    } else {
      var arg1$4 = this$12.get__O();
      var t$1 = $as_jl_Throwable(arg1$4);
      var jsx$4 = new $c_s_Some().init___O(this.toCause__p1__s_Option__jl_Throwable__Lio_youi_JavaScriptCause(consumerOption, t$1))
    };
    var this$13 = new $c_s_Some().init___O(new $c_Lio_youi_JavaScriptCause().init___T__sci_List__s_Option(jsx$5, trace, jsx$4))
  };
  if (this$13.isEmpty__Z()) {
    var xs$1 = throwable.getStackTrace__Ajl_StackTraceElement();
    var this$15 = $m_sci_List$();
    var cbf$1 = this$15.ReusableCBFInstance$2;
    var b$2 = cbf$1.apply__scm_Builder();
    var x1$1 = xs$1.u.length;
    switch (x1$1) {
      case (-1): {
        break
      }
      default: {
        b$2.sizeHint__I__V(x1$1)
      }
    };
    b$2.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_scm_WrappedArray$ofRef().init___AO(xs$1));
    var this$21 = $as_sci_List(b$2.result__O());
    var f$1 = (function($this$1) {
      return (function(element$2$1) {
        var element$1 = $as_jl_StackTraceElement(element$2$1);
        return new $c_Lio_youi_JavaScriptTrace().init___T__T__T__T__Lio_youi_JavaScriptPosition__Lio_youi_JavaScriptPosition(element$1.declaringClass$1, element$1.methodName$1, element$1.fileName$1, "", new $c_Lio_youi_JavaScriptPosition().init___I__I(element$1.lineNumber$1, $uI(element$1.getColumnNumber())), new $c_Lio_youi_JavaScriptPosition().init___I__I((-1), (-1)))
      })
    })(this);
    var this$20 = $m_sci_List$();
    var bf$1 = this$20.ReusableCBFInstance$2;
    if ((bf$1 === $m_sci_List$().ReusableCBFInstance$2)) {
      if ((this$21 === $m_sci_Nil$())) {
        var jsx$7 = $m_sci_Nil$()
      } else {
        var arg1$5 = this$21.head__O();
        var h$1 = new $c_sci_$colon$colon().init___O__sci_List(f$1(arg1$5), $m_sci_Nil$());
        var t$2 = h$1;
        var rest$1 = $as_sci_List(this$21.tail__O());
        while ((rest$1 !== $m_sci_Nil$())) {
          var arg1$6 = rest$1.head__O();
          var nx$1 = new $c_sci_$colon$colon().init___O__sci_List(f$1(arg1$6), $m_sci_Nil$());
          t$2.tl$5 = nx$1;
          t$2 = nx$1;
          rest$1 = $as_sci_List(rest$1.tail__O())
        };
        var jsx$7 = h$1
      }
    } else {
      var b$3 = $f_sc_TraversableLike__builder$1__psc_TraversableLike__scg_CanBuildFrom__scm_Builder(this$21, bf$1);
      var these$1 = this$21;
      while ((!these$1.isEmpty__Z())) {
        var arg1$7 = these$1.head__O();
        b$3.$$plus$eq__O__scm_Builder(f$1(arg1$7));
        these$1 = $as_sci_List(these$1.tail__O())
      };
      var jsx$7 = b$3.result__O()
    };
    var trace$1 = $as_sci_List(jsx$7);
    var jsx$6 = new $c_Lio_youi_JavaScriptCause().init___T__sci_List__s_Option(throwable.getMessage__T(), trace$1, $m_s_None$())
  } else {
    var jsx$6 = this$13.get__O()
  };
  return $as_Lio_youi_JavaScriptCause(jsx$6)
});
var $d_Lio_youi_app_sourceMap_ErrorTrace$ = new $TypeData().initClass({
  Lio_youi_app_sourceMap_ErrorTrace$: 0
}, false, "io.youi.app.sourceMap.ErrorTrace$", {
  Lio_youi_app_sourceMap_ErrorTrace$: 1,
  O: 1
});
$c_Lio_youi_app_sourceMap_ErrorTrace$.prototype.$classData = $d_Lio_youi_app_sourceMap_ErrorTrace$;
var $n_Lio_youi_app_sourceMap_ErrorTrace$ = (void 0);
function $m_Lio_youi_app_sourceMap_ErrorTrace$() {
  if ((!$n_Lio_youi_app_sourceMap_ErrorTrace$)) {
    $n_Lio_youi_app_sourceMap_ErrorTrace$ = new $c_Lio_youi_app_sourceMap_ErrorTrace$().init___()
  };
  return $n_Lio_youi_app_sourceMap_ErrorTrace$
}
/** @constructor */
function $c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1() {
  $c_O.call(this);
  this.derive$macro$52$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1.prototype = new $h_O();
$c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1.prototype.constructor = $c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1;
/** @constructor */
function $h_Lio_youi_app_sourceMap_ErrorTrace$$anon$1() {
  /*<skip>*/
}
$h_Lio_youi_app_sourceMap_ErrorTrace$$anon$1.prototype = $c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1.prototype;
$c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1.prototype.derive$macro$52$lzycompute__p1__Lupickle_Types$Writer = (function() {
  if ((!this.bitmap$0$1)) {
    this.derive$macro$52$1 = new $c_Lupickle_Types$Knot$Writer().init___Lupickle_Types$Knot$__F0($m_Lupickle_default$().Knot__Lupickle_Types$Knot$(), new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$10 = $m_Lupickle_default$();
        var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1) {
          return (function(x$0$2) {
            var x$0 = $as_Lio_youi_JavaScriptPosition(x$0$2);
            return $m_Lio_youi_JavaScriptPosition$().unapply__Lio_youi_JavaScriptPosition__s_Option(x$0)
          })
        })($this));
        var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array(["line", "column"]);
        var len = $uI(xs.array$6.length);
        var array = $newArrayObject($d_T.getArrayOf(), [len]);
        var elem$1 = 0;
        elem$1 = 0;
        var this$4 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
        while (this$4.hasNext__Z()) {
          var arg1 = this$4.next__O();
          array.set(elem$1, arg1);
          elem$1 = ((1 + elem$1) | 0)
        };
        var xs$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array([null, null]);
        var len$1 = $uI(xs$1.array$6.length);
        var array$1 = $newArrayObject($d_Lupickle_Js$Value.getArrayOf(), [len$1]);
        var elem$1$1 = 0;
        elem$1$1 = 0;
        var this$8 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs$1, 0, $uI(xs$1.array$6.length));
        while (this$8.hasNext__Z()) {
          var arg1$1 = this$8.next__O();
          array$1.set(elem$1$1, arg1$1);
          elem$1$1 = ((1 + elem$1$1) | 0)
        };
        var this$9 = $m_Lupickle_default$();
        var evidence$3 = $m_Lupickle_default$().IntRW$1;
        var evidence$4 = $m_Lupickle_default$().IntRW$1;
        var evidence$15 = $as_Lupickle_Types$Writer($f_Lupickle_Generated__Tuple2W__O__O__O(this$9, evidence$3, evidence$4));
        return $f_Lupickle_Implicits__CaseW__F1__AT__ALupickle_Js$Value__Lupickle_Types$Writer__Lupickle_Types$Writer(this$10, f, array, array$1, evidence$15)
      })
    })(this)));
    this.bitmap$0$1 = true
  };
  return this.derive$macro$52$1
});
$c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1.prototype.derive$macro$52__Lupickle_Types$Writer = (function() {
  return ((!this.bitmap$0$1) ? this.derive$macro$52$lzycompute__p1__Lupickle_Types$Writer() : this.derive$macro$52$1)
});
var $d_Lio_youi_app_sourceMap_ErrorTrace$$anon$1 = new $TypeData().initClass({
  Lio_youi_app_sourceMap_ErrorTrace$$anon$1: 0
}, false, "io.youi.app.sourceMap.ErrorTrace$$anon$1", {
  Lio_youi_app_sourceMap_ErrorTrace$$anon$1: 1,
  O: 1
});
$c_Lio_youi_app_sourceMap_ErrorTrace$$anon$1.prototype.$classData = $d_Lio_youi_app_sourceMap_ErrorTrace$$anon$1;
/** @constructor */
function $c_Lio_youi_app_stream_StreamURL$() {
  $c_O.call(this)
}
$c_Lio_youi_app_stream_StreamURL$.prototype = new $h_O();
$c_Lio_youi_app_stream_StreamURL$.prototype.constructor = $c_Lio_youi_app_stream_StreamURL$;
/** @constructor */
function $h_Lio_youi_app_stream_StreamURL$() {
  /*<skip>*/
}
$h_Lio_youi_app_stream_StreamURL$.prototype = $c_Lio_youi_app_stream_StreamURL$.prototype;
$c_Lio_youi_app_stream_StreamURL$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_app_stream_StreamURL$.prototype.stream__Lio_youi_net_URL__s_Option__I__sci_Map__Z__T__s_concurrent_Future = (function(url, data, timeout, headers, withCredentials, responseType) {
  var request = new $c_Lio_youi_ajax_AjaxRequest().init___Lio_youi_net_URL__s_Option__I__sci_Map__Z__T(url, data, timeout, headers.$$plus__T2__sci_Map(new $c_T2().init___O__O("streaming", "true")), withCredentials, responseType);
  var future = request.send__s_concurrent_Future();
  return future.map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      return $as_T(x$1$2.responseText)
    })
  })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
var $d_Lio_youi_app_stream_StreamURL$ = new $TypeData().initClass({
  Lio_youi_app_stream_StreamURL$: 0
}, false, "io.youi.app.stream.StreamURL$", {
  Lio_youi_app_stream_StreamURL$: 1,
  O: 1
});
$c_Lio_youi_app_stream_StreamURL$.prototype.$classData = $d_Lio_youi_app_stream_StreamURL$;
var $n_Lio_youi_app_stream_StreamURL$ = (void 0);
function $m_Lio_youi_app_stream_StreamURL$() {
  if ((!$n_Lio_youi_app_stream_StreamURL$)) {
    $n_Lio_youi_app_stream_StreamURL$ = new $c_Lio_youi_app_stream_StreamURL$().init___()
  };
  return $n_Lio_youi_app_stream_StreamURL$
}
function $f_Lio_youi_communication_Communication__$$init$__V($thiz) {
  $thiz.io$youi$communication$Communication$$undsetter$und$comm$und$eq__Lio_youi_communication_CommunicationInternal__V(new $c_Lio_youi_communication_CommunicationInternal().init___Lio_youi_communication_Communication($thiz));
  $thiz.comm__Lio_youi_communication_CommunicationInternal().init__V()
}
function $is_Lio_youi_communication_Communication(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_communication_Communication)))
}
function $as_Lio_youi_communication_Communication(obj) {
  return (($is_Lio_youi_communication_Communication(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.communication.Communication"))
}
function $isArrayOf_Lio_youi_communication_Communication(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_communication_Communication)))
}
function $asArrayOf_Lio_youi_communication_Communication(obj, depth) {
  return (($isArrayOf_Lio_youi_communication_Communication(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.communication.Communication;", depth))
}
/** @constructor */
function $c_Lio_youi_communication_CommunicationInternal() {
  $c_O.call(this);
  this.communication$1 = null;
  this.increment$1 = null;
  this.queue$1 = null;
  this.endPoints$1 = null;
  this.send$1 = null;
  this.receive$1 = null
}
$c_Lio_youi_communication_CommunicationInternal.prototype = new $h_O();
$c_Lio_youi_communication_CommunicationInternal.prototype.constructor = $c_Lio_youi_communication_CommunicationInternal;
/** @constructor */
function $h_Lio_youi_communication_CommunicationInternal() {
  /*<skip>*/
}
$h_Lio_youi_communication_CommunicationInternal.prototype = $c_Lio_youi_communication_CommunicationInternal.prototype;
$c_Lio_youi_communication_CommunicationInternal.prototype.init___Lio_youi_communication_Communication = (function(communication) {
  this.communication$1 = communication;
  this.increment$1 = new $c_ju_concurrent_atomic_AtomicInteger().init___I(0);
  this.queue$1 = $m_sci_Map$EmptyMap$();
  this.endPoints$1 = $m_sci_Map$EmptyMap$();
  this.send$1 = new $c_Lreactify_Channel$$anon$1().init___();
  this.receive$1 = new $c_Lreactify_Channel$$anon$1().init___();
  return this
});
$c_Lio_youi_communication_CommunicationInternal.prototype.init__V = (function() {
  this.receive$1.attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(message$2) {
      var message = $as_Lio_youi_communication_CommunicationMessage(message$2);
      if ((message.messageType$1 === $m_Lio_youi_communication_CommunicationMessage$().MethodResponse$1)) {
        var f = $this.queue$1.get__O__s_Option(message.invocationId$1);
        $this.queue$1 = $as_sci_Map($this.queue$1.$$minus__O__sc_Map(message.invocationId$1));
        if ($is_s_Some(f)) {
          var x2 = $as_s_Some(f);
          var f$2 = $as_F1(x2.value$2);
          $asUnit(f$2.apply__O__O(message))
        } else {
          var x = $m_s_None$();
          if ((x === f)) {
            var this$1 = $m_Lscribe_package$();
            var level = $m_Lscribe_Level$Debug$();
            var message$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, message$1) {
              return (function() {
                return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["No entry found for endPoint: ", ", invocationId: ", ", content: ", "."])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([message$1.endPoint$1, message$1.invocationId$1, message$1.content$1]))
              })
            })($this, message));
            var methodName = new $c_s_Some().init___O("init");
            $f_Lscribe_LoggerSupport__log__Lscribe_Level__F0__T__s_Option__I__V(this$1, level, message$3, "io.youi.communication.CommunicationInternal", methodName, 91)
          } else {
            throw new $c_s_MatchError().init___O(f)
          }
        }
      } else if ((message.messageType$1 === $m_Lio_youi_communication_CommunicationMessage$().MethodRequest$1)) {
        var this$2 = $this.endPoints$1.get__O__s_Option(message.endPoint$1);
        if ((!this$2.isEmpty__Z())) {
          var arg1 = this$2.get__O();
          var endPoint = $as_F1(arg1);
          $as_s_concurrent_Future(endPoint.apply__O__O(message)).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$2, message$2$1) {
            return (function(content$2) {
              var content = $as_T(content$2);
              var this$5 = $this$2.send$1;
              var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$3, message$2$2, content$1) {
                return (function() {
                  var jsx$3 = $m_Lio_youi_communication_CommunicationMessage$().MethodResponse$1;
                  var jsx$2 = message$2$2.endPoint$1;
                  var jsx$1 = message$2$2.invocationId$1;
                  $m_sci_List$();
                  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([content$1]);
                  var this$4 = $m_sci_List$();
                  var cbf = this$4.ReusableCBFInstance$2;
                  return new $c_Lio_youi_communication_CommunicationMessage().init___I__T__I__sci_List__s_Option(jsx$3, jsx$2, jsx$1, $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)), $m_s_None$())
                })
              })($this$2, message$2$1, content));
              this$5.set__F0__V(value)
            })
          })($this, message)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext()).failed__s_concurrent_Future().foreach__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, message$2$3) {
            return (function(t$2) {
              var t = $as_jl_Throwable(t$2);
              var this$6 = this$2$1.send$1;
              var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$4, message$2$4, t$1) {
                return (function() {
                  return new $c_Lio_youi_communication_CommunicationMessage().init___I__T__I__sci_List__s_Option($m_Lio_youi_communication_CommunicationMessage$().MethodResponse$1, message$2$4.endPoint$1, message$2$4.invocationId$1, $m_sci_Nil$(), new $c_s_Some().init___O(t$1.getMessage__T()))
                })
              })(this$2$1, message$2$3, t));
              this$6.set__F0__V(value$1);
              var this$7 = this$2$1.communication$1;
              $f_Lio_youi_ErrorSupport__error__jl_Throwable__V(this$7, t)
            })
          })($this, message)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
        }
      }
    })
  })(this)), this.receive$1.attach$default$2__D());
  var qual$1 = this.communication$1.connection__Lio_youi_http_Connection().receive$1.text$1;
  var x$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$2) {
    return (function(x0$1$2) {
      var x0$1 = $as_T(x0$1$2);
      matchEnd4: {
        var o7 = $m_Lio_youi_communication_CommunicationMessage$().unapply__T__s_Option(x0$1);
        if ((!o7.isEmpty__Z())) {
          var message$4 = $as_Lio_youi_communication_CommunicationMessage(o7.get__O());
          var this$8 = this$2$2.receive$1;
          var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$5, message$5) {
            return (function() {
              return message$5
            })
          })(this$2$2, message$4));
          this$8.set__F0__V(value$2);
          break matchEnd4
        }
      }
    })
  })(this));
  var x$2 = qual$1.attach$default$2__D();
  qual$1.attach__F1__D__Lreactify_Listener(x$1, x$2);
  this.send$1.attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1) {
    return (function(message$3$2) {
      var message$3$1 = $as_Lio_youi_communication_CommunicationMessage(message$3$2);
      var this$9 = this$3$1.communication$1.connection__Lio_youi_http_Connection().send$1.text$1;
      var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$6, message$6) {
        return (function() {
          return message$6.parsableString__T()
        })
      })(this$3$1, message$3$1));
      this$9.set__F0__V(value$3)
    })
  })(this)), this.send$1.attach$default$2__D())
});
$c_Lio_youi_communication_CommunicationInternal.prototype.onEndPoint__T__F1__V = (function(endPoint, f) {
  this.endPoints$1 = this.endPoints$1.$$plus__T2__sci_Map(new $c_T2().init___O__O(endPoint, f))
});
$c_Lio_youi_communication_CommunicationInternal.prototype.onInvocation__I__F1__s_concurrent_Future = (function(invocationId, f) {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var handler = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1, promise$1) {
    return (function(m$2) {
      var m = $as_Lio_youi_communication_CommunicationMessage(m$2);
      var x1 = m.error$1;
      if ($is_s_Some(x1)) {
        var x2 = $as_s_Some(x1);
        var error = $as_T(x2.value$2);
        var cause = new $c_Lio_youi_communication_CommunicationException().init___T(error);
        $f_s_concurrent_Promise__failure__jl_Throwable__s_concurrent_Promise(promise$1, cause)
      } else {
        var x = $m_s_None$();
        if ((x === x1)) {
          var value = f$1.apply__O__O(m);
          $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$1, value)
        } else {
          throw new $c_s_MatchError().init___O(x1)
        }
      }
    })
  })(this, f, promise));
  this.queue$1 = this.queue$1.$$plus__T2__sci_Map(new $c_T2().init___O__O(invocationId, handler));
  return promise
});
var $d_Lio_youi_communication_CommunicationInternal = new $TypeData().initClass({
  Lio_youi_communication_CommunicationInternal: 0
}, false, "io.youi.communication.CommunicationInternal", {
  Lio_youi_communication_CommunicationInternal: 1,
  O: 1
});
$c_Lio_youi_communication_CommunicationInternal.prototype.$classData = $d_Lio_youi_communication_CommunicationInternal;
function $f_Lio_youi_component_Component__parent__Lreactify_Val($thiz) {
  return $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_s_None$()
    })
  })($thiz)), false, true, true)
}
function $f_Lio_youi_component_Component__updateTransform__V($thiz) {
  var jsx$1 = $thiz.instance__Lcom_outr_pixijs_PIXI_Container();
  var this$1 = $thiz.size__Lio_youi_component_Component$size$().width__Lio_youi_component_Component$size$width$();
  jsx$1.width = $uD(this$1.get__O());
  var jsx$2 = $thiz.instance__Lcom_outr_pixijs_PIXI_Container();
  var this$2 = $thiz.size__Lio_youi_component_Component$size$().height__Lio_youi_component_Component$size$height$();
  jsx$2.height = $uD(this$2.get__O());
  var jsx$15 = $thiz.instance__Lcom_outr_pixijs_PIXI_Container();
  var this$3 = $thiz.position__Lio_youi_component_Component$position$().x__Lreactify_Var();
  var jsx$14 = $uD(this$3.get__O());
  var this$4 = $thiz.pivot__Lio_youi_component_Component$pivot$().x__Lreactify_Var();
  var jsx$13 = $uD(this$4.get__O());
  var this$5 = $thiz.position__Lio_youi_component_Component$position$().y__Lreactify_Var();
  var jsx$12 = $uD(this$5.get__O());
  var this$6 = $thiz.pivot__Lio_youi_component_Component$pivot$().y__Lreactify_Var();
  var jsx$11 = $uD(this$6.get__O());
  var this$7 = $thiz.scale__Lio_youi_component_Component$scale$().x__Lreactify_Var();
  var jsx$10 = $uD(this$7.get__O());
  var this$8 = $thiz.scale__Lio_youi_component_Component$scale$().y__Lreactify_Var();
  var jsx$9 = $uD(this$8.get__O());
  var this$9 = $thiz.rotation__Lreactify_Var();
  var jsx$8 = $uD(this$9.get__O());
  var this$10 = $thiz.skew__Lio_youi_component_Component$skew$().x__Lreactify_Var();
  var jsx$7 = $uD(this$10.get__O());
  var this$11 = $thiz.skew__Lio_youi_component_Component$skew$().y__Lreactify_Var();
  var jsx$6 = $uD(this$11.get__O());
  var this$12 = $thiz.pivot__Lio_youi_component_Component$pivot$().x__Lreactify_Var();
  var jsx$5 = $uD(this$12.get__O());
  var this$13 = $thiz.scale__Lio_youi_component_Component$scale$().x__Lreactify_Var();
  var jsx$4 = $uD(this$13.get__O());
  var this$14 = $thiz.pivot__Lio_youi_component_Component$pivot$().y__Lreactify_Var();
  var jsx$3 = $uD(this$14.get__O());
  var this$15 = $thiz.scale__Lio_youi_component_Component$scale$().y__Lreactify_Var();
  jsx$15.setTransform((jsx$14 + jsx$13), (jsx$12 + jsx$11), jsx$10, jsx$9, (6.283185307179586 * jsx$8), jsx$7, jsx$6, (jsx$5 / jsx$4), (jsx$3 / $uD(this$15.get__O())))
}
function $f_Lio_youi_component_Component__$$init$__V($thiz) {
  $thiz.io$youi$component$Component$$undsetter$und$io$youi$component$Component$$dirty$und$eq__ju_concurrent_atomic_AtomicBoolean__V(new $c_ju_concurrent_atomic_AtomicBoolean().init___Z(false));
  $thiz.io$youi$component$Component$$undsetter$und$theme$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $this.defaultTheme__Lio_youi_style_Theme()
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$component$Component$$undsetter$und$interactive$und$eq__Lreactify_Var__V($m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p = this$2.theme__Lreactify_Var();
      var p$1 = $as_Lio_youi_style_Theme(p.get__O()).interactive$1;
      return $uZ(p$1.get__O())
    })
  })($thiz)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1) {
    return (function(b$2) {
      var b = $uZ(b$2);
      this$3$1.instance__Lcom_outr_pixijs_PIXI_Container().interactive = b
    })
  })($thiz)), true, false, true, true));
  $thiz.io$youi$component$Component$$undsetter$und$visible$und$eq__Lreactify_Var__V($m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p$2 = this$4.theme__Lreactify_Var();
      var p$3 = $as_Lio_youi_style_Theme(p$2.get__O()).visible$1;
      return $uZ(p$3.get__O())
    })
  })($thiz)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$5$1) {
    return (function(b$3$2) {
      var b$3 = $uZ(b$3$2);
      this$5$1.instance__Lcom_outr_pixijs_PIXI_Container().visible = b$3
    })
  })($thiz)), false, false, true, true));
  var this$8 = $thiz.position__Lio_youi_component_Component$position$().x__Lreactify_Var();
  var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$6$1) {
    return (function() {
      this$6$1.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().value$1 = true
    })
  })($thiz));
  $thiz.position__Lio_youi_component_Component$position$().x__Lreactify_Var();
  var priority = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__on__F0__D__Lreactify_Listener(this$8, f, priority);
  var this$10 = $thiz.position__Lio_youi_component_Component$position$().y__Lreactify_Var();
  var f$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$7$1) {
    return (function() {
      this$7$1.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().value$1 = true
    })
  })($thiz));
  $thiz.position__Lio_youi_component_Component$position$().y__Lreactify_Var();
  var priority$1 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__on__F0__D__Lreactify_Listener(this$10, f$1, priority$1);
  var this$12 = $thiz.size__Lio_youi_component_Component$size$().width__Lio_youi_component_Component$size$width$();
  var f$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$8$1) {
    return (function() {
      this$8$1.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().value$1 = true
    })
  })($thiz));
  $thiz.size__Lio_youi_component_Component$size$().width__Lio_youi_component_Component$size$width$();
  var priority$2 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__on__F0__D__Lreactify_Listener(this$12, f$2, priority$2);
  var this$14 = $thiz.size__Lio_youi_component_Component$size$().height__Lio_youi_component_Component$size$height$();
  var f$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$9$1) {
    return (function() {
      this$9$1.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().value$1 = true
    })
  })($thiz));
  $thiz.size__Lio_youi_component_Component$size$().height__Lio_youi_component_Component$size$height$();
  var priority$3 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__on__F0__D__Lreactify_Listener(this$14, f$3, priority$3);
  var this$16 = $thiz.scale__Lio_youi_component_Component$scale$().x__Lreactify_Var();
  var f$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$10$1) {
    return (function() {
      this$10$1.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().value$1 = true
    })
  })($thiz));
  $thiz.scale__Lio_youi_component_Component$scale$().x__Lreactify_Var();
  var priority$4 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__on__F0__D__Lreactify_Listener(this$16, f$4, priority$4);
  var this$18 = $thiz.scale__Lio_youi_component_Component$scale$().y__Lreactify_Var();
  var f$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$11$1) {
    return (function() {
      this$11$1.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().value$1 = true
    })
  })($thiz));
  $thiz.scale__Lio_youi_component_Component$scale$().y__Lreactify_Var();
  var priority$5 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__on__F0__D__Lreactify_Listener(this$18, f$5, priority$5);
  var this$20 = $thiz.skew__Lio_youi_component_Component$skew$().x__Lreactify_Var();
  var f$6 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$12$1) {
    return (function() {
      this$12$1.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().value$1 = true
    })
  })($thiz));
  $thiz.skew__Lio_youi_component_Component$skew$().x__Lreactify_Var();
  var priority$6 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__on__F0__D__Lreactify_Listener(this$20, f$6, priority$6);
  var this$22 = $thiz.skew__Lio_youi_component_Component$skew$().y__Lreactify_Var();
  var f$7 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$13$1) {
    return (function() {
      this$13$1.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().value$1 = true
    })
  })($thiz));
  $thiz.skew__Lio_youi_component_Component$skew$().y__Lreactify_Var();
  var priority$7 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__on__F0__D__Lreactify_Listener(this$22, f$7, priority$7);
  var this$24 = $thiz.rotation__Lreactify_Var();
  var f$8 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$14$1) {
    return (function() {
      this$14$1.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().value$1 = true
    })
  })($thiz));
  $thiz.rotation__Lreactify_Var();
  var priority$8 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__on__F0__D__Lreactify_Listener(this$24, f$8, priority$8)
}
function $f_Lio_youi_component_Component__prop__F0__F1__Lreactify_Var($thiz, get, set) {
  var v = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(get, false, true, true);
  var priority = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(v, set, priority);
  return v
}
function $f_Lio_youi_component_Component__update__D__V($thiz, delta) {
  if ($thiz.io$youi$component$Component$$dirty__ju_concurrent_atomic_AtomicBoolean().compareAndSet__Z__Z__Z(true, false)) {
    $thiz.updateTransform__V()
  };
  $f_Lio_youi_Updates__update__D__V($thiz, delta)
}
function $f_Lio_youi_component_Component__rotation__Lreactify_Var($thiz) {
  return $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })($thiz)), false, true, true)
}
function $is_Lio_youi_component_Component(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_component_Component)))
}
function $as_Lio_youi_component_Component(obj) {
  return (($is_Lio_youi_component_Component(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.component.Component"))
}
function $isArrayOf_Lio_youi_component_Component(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_component_Component)))
}
function $asArrayOf_Lio_youi_component_Component(obj, depth) {
  return (($isArrayOf_Lio_youi_component_Component(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.component.Component;", depth))
}
/** @constructor */
function $c_Lio_youi_component_Component$pivot$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_component_Component$pivot$.prototype = new $h_O();
$c_Lio_youi_component_Component$pivot$.prototype.constructor = $c_Lio_youi_component_Component$pivot$;
/** @constructor */
function $h_Lio_youi_component_Component$pivot$() {
  /*<skip>*/
}
$h_Lio_youi_component_Component$pivot$.prototype = $c_Lio_youi_component_Component$pivot$.prototype;
$c_Lio_youi_component_Component$pivot$.prototype.x$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.x$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$1 = $this.$$outer$1.size__Lio_youi_component_Component$size$().center__Lreactify_Val();
        return $uD(this$1.get__O())
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.x$1
});
$c_Lio_youi_component_Component$pivot$.prototype.y__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.y$lzycompute__p1__Lreactify_Var() : this.y$1)
});
$c_Lio_youi_component_Component$pivot$.prototype.y$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.y$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        var this$1 = $this.$$outer$1.size__Lio_youi_component_Component$size$().middle__Lreactify_Val();
        return $uD(this$1.get__O())
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
$c_Lio_youi_component_Component$pivot$.prototype.init___Lio_youi_component_Component = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_Component$pivot$.prototype.x__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.x$lzycompute__p1__Lreactify_Var() : this.x$1)
});
var $d_Lio_youi_component_Component$pivot$ = new $TypeData().initClass({
  Lio_youi_component_Component$pivot$: 0
}, false, "io.youi.component.Component$pivot$", {
  Lio_youi_component_Component$pivot$: 1,
  O: 1
});
$c_Lio_youi_component_Component$pivot$.prototype.$classData = $d_Lio_youi_component_Component$pivot$;
/** @constructor */
function $c_Lio_youi_component_Component$position$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.left$1 = null;
  this.center$1 = null;
  this.right$1 = null;
  this.top$1 = null;
  this.middle$1 = null;
  this.bottom$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_component_Component$position$.prototype = new $h_O();
$c_Lio_youi_component_Component$position$.prototype.constructor = $c_Lio_youi_component_Component$position$;
/** @constructor */
function $h_Lio_youi_component_Component$position$() {
  /*<skip>*/
}
$h_Lio_youi_component_Component$position$.prototype = $c_Lio_youi_component_Component$position$.prototype;
$c_Lio_youi_component_Component$position$.prototype.center$lzycompute__p1__Lreactify_Dep = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    var variable = this.left__Lreactify_Var();
    var adjustment = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.$$outer$1.size__Lio_youi_component_Component$size$().width__Lio_youi_component_Component$size$width$();
        return ($uD(p.get__O()) / 2.0)
      })
    })(this));
    var connector = $m_Lreactify_package$().doubleConnector$1;
    this.center$1 = new $c_Lreactify_Dep().init___Lreactify_Var__F0__Z__Lreactify_DepConnector(variable, adjustment, false, connector);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.center$1
});
$c_Lio_youi_component_Component$position$.prototype.left$lzycompute__p1__Lreactify_Var = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.left$1 = this.x__Lreactify_Var();
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.left$1
});
$c_Lio_youi_component_Component$position$.prototype.top$lzycompute__p1__Lreactify_Var = (function() {
  if (((32 & this.bitmap$0$1) === 0)) {
    this.top$1 = this.y__Lreactify_Var();
    this.bitmap$0$1 = (((32 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.top$1
});
$c_Lio_youi_component_Component$position$.prototype.right__Lreactify_Dep = (function() {
  return (((16 & this.bitmap$0$1) === 0) ? this.right$lzycompute__p1__Lreactify_Dep() : this.right$1)
});
$c_Lio_youi_component_Component$position$.prototype.x$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.x$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $uD($this.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Container().x)
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.x$1
});
$c_Lio_youi_component_Component$position$.prototype.bottom$lzycompute__p1__Lreactify_Dep = (function() {
  if (((128 & this.bitmap$0$1) === 0)) {
    var variable = this.top__Lreactify_Var();
    var adjustment = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.$$outer$1.size__Lio_youi_component_Component$size$().height__Lio_youi_component_Component$size$height$();
        return $uD(p.get__O())
      })
    })(this));
    var connector = $m_Lreactify_package$().doubleConnector$1;
    this.bottom$1 = new $c_Lreactify_Dep().init___Lreactify_Var__F0__Z__Lreactify_DepConnector(variable, adjustment, false, connector);
    this.bitmap$0$1 = (((128 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottom$1
});
$c_Lio_youi_component_Component$position$.prototype.y__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.y$lzycompute__p1__Lreactify_Var() : this.y$1)
});
$c_Lio_youi_component_Component$position$.prototype.right$lzycompute__p1__Lreactify_Dep = (function() {
  if (((16 & this.bitmap$0$1) === 0)) {
    var variable = this.left__Lreactify_Var();
    var adjustment = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.$$outer$1.size__Lio_youi_component_Component$size$().width__Lio_youi_component_Component$size$width$();
        return $uD(p.get__O())
      })
    })(this));
    var connector = $m_Lreactify_package$().doubleConnector$1;
    this.right$1 = new $c_Lreactify_Dep().init___Lreactify_Var__F0__Z__Lreactify_DepConnector(variable, adjustment, false, connector);
    this.bitmap$0$1 = (((16 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.right$1
});
$c_Lio_youi_component_Component$position$.prototype.y$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.y$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $uD($this.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Container().y)
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
$c_Lio_youi_component_Component$position$.prototype.center__Lreactify_Dep = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.center$lzycompute__p1__Lreactify_Dep() : this.center$1)
});
$c_Lio_youi_component_Component$position$.prototype.init___Lio_youi_component_Component = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_Component$position$.prototype.bottom__Lreactify_Dep = (function() {
  return (((128 & this.bitmap$0$1) === 0) ? this.bottom$lzycompute__p1__Lreactify_Dep() : this.bottom$1)
});
$c_Lio_youi_component_Component$position$.prototype.x__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.x$lzycompute__p1__Lreactify_Var() : this.x$1)
});
$c_Lio_youi_component_Component$position$.prototype.left__Lreactify_Var = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.left$lzycompute__p1__Lreactify_Var() : this.left$1)
});
$c_Lio_youi_component_Component$position$.prototype.middle__Lreactify_Dep = (function() {
  return (((64 & this.bitmap$0$1) === 0) ? this.middle$lzycompute__p1__Lreactify_Dep() : this.middle$1)
});
$c_Lio_youi_component_Component$position$.prototype.middle$lzycompute__p1__Lreactify_Dep = (function() {
  if (((64 & this.bitmap$0$1) === 0)) {
    var variable = this.top__Lreactify_Var();
    var adjustment = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.$$outer$1.size__Lio_youi_component_Component$size$().height__Lio_youi_component_Component$size$height$();
        return ($uD(p.get__O()) / 2.0)
      })
    })(this));
    var connector = $m_Lreactify_package$().doubleConnector$1;
    this.middle$1 = new $c_Lreactify_Dep().init___Lreactify_Var__F0__Z__Lreactify_DepConnector(variable, adjustment, false, connector);
    this.bitmap$0$1 = (((64 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.middle$1
});
$c_Lio_youi_component_Component$position$.prototype.top__Lreactify_Var = (function() {
  return (((32 & this.bitmap$0$1) === 0) ? this.top$lzycompute__p1__Lreactify_Var() : this.top$1)
});
var $d_Lio_youi_component_Component$position$ = new $TypeData().initClass({
  Lio_youi_component_Component$position$: 0
}, false, "io.youi.component.Component$position$", {
  Lio_youi_component_Component$position$: 1,
  O: 1
});
$c_Lio_youi_component_Component$position$.prototype.$classData = $d_Lio_youi_component_Component$position$;
/** @constructor */
function $c_Lio_youi_component_Component$scale$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_Component$scale$.prototype = new $h_O();
$c_Lio_youi_component_Component$scale$.prototype.constructor = $c_Lio_youi_component_Component$scale$;
/** @constructor */
function $h_Lio_youi_component_Component$scale$() {
  /*<skip>*/
}
$h_Lio_youi_component_Component$scale$.prototype = $c_Lio_youi_component_Component$scale$.prototype;
$c_Lio_youi_component_Component$scale$.prototype.x$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.x$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 1.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.x$1
});
$c_Lio_youi_component_Component$scale$.prototype.y__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.y$lzycompute__p1__Lreactify_Var() : this.y$1)
});
$c_Lio_youi_component_Component$scale$.prototype.y$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.y$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 1.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
$c_Lio_youi_component_Component$scale$.prototype.init___Lio_youi_component_Component = (function($$outer) {
  return this
});
$c_Lio_youi_component_Component$scale$.prototype.x__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.x$lzycompute__p1__Lreactify_Var() : this.x$1)
});
var $d_Lio_youi_component_Component$scale$ = new $TypeData().initClass({
  Lio_youi_component_Component$scale$: 0
}, false, "io.youi.component.Component$scale$", {
  Lio_youi_component_Component$scale$: 1,
  O: 1
});
$c_Lio_youi_component_Component$scale$.prototype.$classData = $d_Lio_youi_component_Component$scale$;
/** @constructor */
function $c_Lio_youi_component_Component$size$() {
  $c_O.call(this);
  this.measured$module$1 = null;
  this.width$module$1 = null;
  this.height$module$1 = null;
  this.center$1 = null;
  this.middle$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_Component$size$.prototype = new $h_O();
$c_Lio_youi_component_Component$size$.prototype.constructor = $c_Lio_youi_component_Component$size$;
/** @constructor */
function $h_Lio_youi_component_Component$size$() {
  /*<skip>*/
}
$h_Lio_youi_component_Component$size$.prototype = $c_Lio_youi_component_Component$size$.prototype;
$c_Lio_youi_component_Component$size$.prototype.width__Lio_youi_component_Component$size$width$ = (function() {
  if ((this.width$module$1 === null)) {
    this.width$lzycompute$1__p1__V()
  };
  return this.width$module$1
});
$c_Lio_youi_component_Component$size$.prototype.center__Lreactify_Val = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.center$lzycompute__p1__Lreactify_Val() : this.center$1)
});
$c_Lio_youi_component_Component$size$.prototype.middle__Lreactify_Val = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.middle$lzycompute__p1__Lreactify_Val() : this.middle$1)
});
$c_Lio_youi_component_Component$size$.prototype.init___Lio_youi_component_Component = (function($$outer) {
  return this
});
$c_Lio_youi_component_Component$size$.prototype.center$lzycompute__p1__Lreactify_Val = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.center$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.width__Lio_youi_component_Component$size$width$();
        return ($uD(p.get__O()) / 2.0)
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.center$1
});
$c_Lio_youi_component_Component$size$.prototype.middle$lzycompute__p1__Lreactify_Val = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.middle$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.height__Lio_youi_component_Component$size$height$();
        return ($uD(p.get__O()) / 2.0)
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.middle$1
});
$c_Lio_youi_component_Component$size$.prototype.height__Lio_youi_component_Component$size$height$ = (function() {
  if ((this.height$module$1 === null)) {
    this.height$lzycompute$1__p1__V()
  };
  return this.height$module$1
});
$c_Lio_youi_component_Component$size$.prototype.measured$lzycompute$1__p1__V = (function() {
  if ((this.measured$module$1 === null)) {
    this.measured$module$1 = new $c_Lio_youi_component_Component$size$measured$().init___Lio_youi_component_Component$size$(this)
  }
});
$c_Lio_youi_component_Component$size$.prototype.height$lzycompute$1__p1__V = (function() {
  if ((this.height$module$1 === null)) {
    this.height$module$1 = new $c_Lio_youi_component_Component$size$height$().init___Lio_youi_component_Component$size$(this)
  }
});
$c_Lio_youi_component_Component$size$.prototype.width$lzycompute$1__p1__V = (function() {
  if ((this.width$module$1 === null)) {
    this.width$module$1 = new $c_Lio_youi_component_Component$size$width$().init___Lio_youi_component_Component$size$(this)
  }
});
$c_Lio_youi_component_Component$size$.prototype.measured__Lio_youi_component_Component$size$measured$ = (function() {
  if ((this.measured$module$1 === null)) {
    this.measured$lzycompute$1__p1__V()
  };
  return this.measured$module$1
});
var $d_Lio_youi_component_Component$size$ = new $TypeData().initClass({
  Lio_youi_component_Component$size$: 0
}, false, "io.youi.component.Component$size$", {
  Lio_youi_component_Component$size$: 1,
  O: 1
});
$c_Lio_youi_component_Component$size$.prototype.$classData = $d_Lio_youi_component_Component$size$;
/** @constructor */
function $c_Lio_youi_component_Component$size$measured$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_Component$size$measured$.prototype = new $h_O();
$c_Lio_youi_component_Component$size$measured$.prototype.constructor = $c_Lio_youi_component_Component$size$measured$;
/** @constructor */
function $h_Lio_youi_component_Component$size$measured$() {
  /*<skip>*/
}
$h_Lio_youi_component_Component$size$measured$.prototype = $c_Lio_youi_component_Component$size$measured$.prototype;
$c_Lio_youi_component_Component$size$measured$.prototype.init___Lio_youi_component_Component$size$ = (function($$outer) {
  return this
});
$c_Lio_youi_component_Component$size$measured$.prototype.width$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.width$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.width$1
});
$c_Lio_youi_component_Component$size$measured$.prototype.height$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.height$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_component_Component$size$measured$.prototype.width__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.width$lzycompute__p1__Lreactify_Var() : this.width$1)
});
$c_Lio_youi_component_Component$size$measured$.prototype.height__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.height$lzycompute__p1__Lreactify_Var() : this.height$1)
});
var $d_Lio_youi_component_Component$size$measured$ = new $TypeData().initClass({
  Lio_youi_component_Component$size$measured$: 0
}, false, "io.youi.component.Component$size$measured$", {
  Lio_youi_component_Component$size$measured$: 1,
  O: 1
});
$c_Lio_youi_component_Component$size$measured$.prototype.$classData = $d_Lio_youi_component_Component$size$measured$;
/** @constructor */
function $c_Lio_youi_component_Component$skew$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_Component$skew$.prototype = new $h_O();
$c_Lio_youi_component_Component$skew$.prototype.constructor = $c_Lio_youi_component_Component$skew$;
/** @constructor */
function $h_Lio_youi_component_Component$skew$() {
  /*<skip>*/
}
$h_Lio_youi_component_Component$skew$.prototype = $c_Lio_youi_component_Component$skew$.prototype;
$c_Lio_youi_component_Component$skew$.prototype.x$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.x$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.x$1
});
$c_Lio_youi_component_Component$skew$.prototype.y__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.y$lzycompute__p1__Lreactify_Var() : this.y$1)
});
$c_Lio_youi_component_Component$skew$.prototype.y$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.y$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
$c_Lio_youi_component_Component$skew$.prototype.init___Lio_youi_component_Component = (function($$outer) {
  return this
});
$c_Lio_youi_component_Component$skew$.prototype.x__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.x$lzycompute__p1__Lreactify_Var() : this.x$1)
});
var $d_Lio_youi_component_Component$skew$ = new $TypeData().initClass({
  Lio_youi_component_Component$skew$: 0
}, false, "io.youi.component.Component$skew$", {
  Lio_youi_component_Component$skew$: 1,
  O: 1
});
$c_Lio_youi_component_Component$skew$.prototype.$classData = $d_Lio_youi_component_Component$skew$;
/** @constructor */
function $c_Lio_youi_component_Text$dropShadow$() {
  $c_O.call(this);
  this.enabled$1 = null;
  this.angle$1 = null;
  this.blur$1 = null;
  this.color$1 = null;
  this.distance$1 = null;
  this.$$outer$1 = null
}
$c_Lio_youi_component_Text$dropShadow$.prototype = new $h_O();
$c_Lio_youi_component_Text$dropShadow$.prototype.constructor = $c_Lio_youi_component_Text$dropShadow$;
/** @constructor */
function $h_Lio_youi_component_Text$dropShadow$() {
  /*<skip>*/
}
$h_Lio_youi_component_Text$dropShadow$.prototype = $c_Lio_youi_component_Text$dropShadow$.prototype;
$c_Lio_youi_component_Text$dropShadow$.prototype.init___Lio_youi_component_Text = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  this.enabled$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p = $this.$$outer$1.theme$1;
      var p$1 = $as_Lio_youi_style_Theme(p.get__O()).dropShadow__Lio_youi_style_Theme$dropShadow$().enabled$1;
      return $uZ(p$1.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(b$2) {
      var b = $uZ(b$2);
      this$2$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style.dropShadow = b
    })
  })(this)), true, false, true, true);
  this.angle$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p$2 = this$3$1.$$outer$1.theme$1;
      var p$3 = $as_Lio_youi_style_Theme(p$2.get__O()).dropShadow__Lio_youi_style_Theme$dropShadow$().angle$1;
      return $uD(p$3.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
    return (function(d$2) {
      var d = $uD(d$2);
      this$4$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style.dropShadowAngle = d
    })
  })(this)), true, false, true, true);
  this.blur$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p$4 = this$5$1.$$outer$1.theme$1;
      var p$5 = $as_Lio_youi_style_Theme(p$4.get__O()).dropShadow__Lio_youi_style_Theme$dropShadow$().blur$1;
      return $uD(p$5.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$6$1) {
    return (function(d$3$2) {
      var d$3 = $uD(d$3$2);
      this$6$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style.dropShadowBlur = d$3
    })
  })(this)), true, false, true, true);
  this.color$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$7$1) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p$6 = this$7$1.$$outer$1.theme$1;
      var p$7 = $as_Lio_youi_style_Theme(p$6.get__O()).dropShadow__Lio_youi_style_Theme$dropShadow$().color$1;
      return $as_Lio_youi_Color(p$7.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$8$1) {
    return (function(c$2) {
      var c = $as_Lio_youi_Color(c$2);
      var jsx$1 = this$8$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style;
      var value = $m_Lio_youi_Color$().toHex__D__D__D__s_Option__Z__T(c.red$1, c.green$1, c.blue$1, $m_s_None$(), true);
      jsx$1.dropShadowColor = value
    })
  })(this)), true, false, true, true);
  this.distance$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$9$1) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p$8 = this$9$1.$$outer$1.theme$1;
      var p$9 = $as_Lio_youi_style_Theme(p$8.get__O()).dropShadow__Lio_youi_style_Theme$dropShadow$().distance$1;
      return $uD(p$9.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$10$1) {
    return (function(d$4$2) {
      var d$4 = $uD(d$4$2);
      this$10$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style.dropShadowDistance = d$4
    })
  })(this)), true, false, true, true);
  return this
});
var $d_Lio_youi_component_Text$dropShadow$ = new $TypeData().initClass({
  Lio_youi_component_Text$dropShadow$: 0
}, false, "io.youi.component.Text$dropShadow$", {
  Lio_youi_component_Text$dropShadow$: 1,
  O: 1
});
$c_Lio_youi_component_Text$dropShadow$.prototype.$classData = $d_Lio_youi_component_Text$dropShadow$;
/** @constructor */
function $c_Lio_youi_component_Text$font$() {
  $c_O.call(this);
  this.family$1 = null;
  this.size$1 = null;
  this.style$1 = null;
  this.variant$1 = null;
  this.weight$1 = null;
  this.$$outer$1 = null
}
$c_Lio_youi_component_Text$font$.prototype = new $h_O();
$c_Lio_youi_component_Text$font$.prototype.constructor = $c_Lio_youi_component_Text$font$;
/** @constructor */
function $h_Lio_youi_component_Text$font$() {
  /*<skip>*/
}
$h_Lio_youi_component_Text$font$.prototype = $c_Lio_youi_component_Text$font$.prototype;
$c_Lio_youi_component_Text$font$.prototype.init___Lio_youi_component_Text = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  this.family$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p = $this.$$outer$1.theme$1;
      var p$1 = $as_Lio_youi_style_Theme(p.get__O()).font__Lio_youi_style_Theme$font$().family$1;
      return $as_T(p$1.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(s$2) {
      var s = $as_T(s$2);
      this$2$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style.fontFamily = s
    })
  })(this)), true, false, true, true);
  this.size$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p$2 = this$3$1.$$outer$1.theme$1;
      var p$3 = $as_Lio_youi_style_Theme(p$2.get__O()).font__Lio_youi_style_Theme$font$().size$1;
      return $uD(p$3.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
    return (function(d$2) {
      var d = $uD(d$2);
      this$4$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style.fontSize = d
    })
  })(this)), true, false, true, true);
  this.style$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p$4 = this$5$1.$$outer$1.theme$1;
      var p$5 = $as_Lio_youi_style_Theme(p$4.get__O()).font__Lio_youi_style_Theme$font$().style$1;
      return $as_T(p$5.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$6$1) {
    return (function(s$3$2) {
      var s$3 = $as_T(s$3$2);
      this$6$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style.fontStyle = s$3
    })
  })(this)), true, false, true, true);
  this.variant$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$7$1) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p$6 = this$7$1.$$outer$1.theme$1;
      var p$7 = $as_Lio_youi_style_Theme(p$6.get__O()).font__Lio_youi_style_Theme$font$().variant$1;
      return $as_T(p$7.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$8$1) {
    return (function(s$4$2) {
      var s$4 = $as_T(s$4$2);
      this$8$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style.fontVariant = s$4
    })
  })(this)), true, false, true, true);
  this.weight$1 = $m_Lreactify_Var$().bound__F0__F1__Z__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$9$1) {
    return (function() {
      $m_Lreactify_package$();
      $m_Lreactify_package$();
      var p$8 = this$9$1.$$outer$1.theme$1;
      var p$9 = $as_Lio_youi_style_Theme(p$8.get__O()).font__Lio_youi_style_Theme$font$().weight$1;
      return $as_T(p$9.get__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$10$1) {
    return (function(s$5$2) {
      var s$5 = $as_T(s$5$2);
      this$10$1.$$outer$1.instance__Lcom_outr_pixijs_PIXI_Text().style.fontWeight = s$5
    })
  })(this)), true, false, true, true);
  return this
});
var $d_Lio_youi_component_Text$font$ = new $TypeData().initClass({
  Lio_youi_component_Text$font$: 0
}, false, "io.youi.component.Text$font$", {
  Lio_youi_component_Text$font$: 1,
  O: 1
});
$c_Lio_youi_component_Text$font$.prototype.$classData = $d_Lio_youi_component_Text$font$;
/** @constructor */
function $c_Lio_youi_component_Texture() {
  $c_O.call(this);
  this.instance$1 = null;
  this.update$1 = null;
  this.width$1 = null;
  this.height$1 = null
}
$c_Lio_youi_component_Texture.prototype = new $h_O();
$c_Lio_youi_component_Texture.prototype.constructor = $c_Lio_youi_component_Texture;
/** @constructor */
function $h_Lio_youi_component_Texture() {
  /*<skip>*/
}
$h_Lio_youi_component_Texture.prototype = $c_Lio_youi_component_Texture.prototype;
$c_Lio_youi_component_Texture.prototype.init___Lcom_outr_pixijs_PIXI_Texture = (function(instance) {
  this.instance$1 = instance;
  this.update$1 = new $c_Lreactify_Trigger().init___();
  this.width$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $uD($this.instance$1.width)
    })
  })(this)), false, true, true);
  this.height$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      return $uD(this$2.instance$1.height)
    })
  })(this)), false, true, true);
  instance.on("update", (function(this$3) {
    return (function() {
      var this$4 = $as_Lreactify_Var(this$3.width$1);
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
        return (function() {
          return $uD($this$1.instance$1.width)
        })
      })(this$3));
      this$4.replace__F0__Z__V(value, true);
      var this$5 = $as_Lreactify_Var(this$3.height$1);
      var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
        return (function() {
          return $uD(this$2$1.instance$1.height)
        })
      })(this$3));
      this$5.replace__F0__Z__V(value$1, true);
      var this$6 = this$3.update$1;
      this$6.channel$1.fire__O__V((void 0))
    })
  })(this));
  return this
});
function $is_Lio_youi_component_Texture(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_component_Texture)))
}
function $as_Lio_youi_component_Texture(obj) {
  return (($is_Lio_youi_component_Texture(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.component.Texture"))
}
function $isArrayOf_Lio_youi_component_Texture(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_component_Texture)))
}
function $asArrayOf_Lio_youi_component_Texture(obj, depth) {
  return (($isArrayOf_Lio_youi_component_Texture(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.component.Texture;", depth))
}
var $d_Lio_youi_component_Texture = new $TypeData().initClass({
  Lio_youi_component_Texture: 0
}, false, "io.youi.component.Texture", {
  Lio_youi_component_Texture: 1,
  O: 1
});
$c_Lio_youi_component_Texture.prototype.$classData = $d_Lio_youi_component_Texture;
/** @constructor */
function $c_Lio_youi_component_Texture$() {
  $c_O.call(this);
  this.Empty$1 = null;
  this.White$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_component_Texture$.prototype = new $h_O();
$c_Lio_youi_component_Texture$.prototype.constructor = $c_Lio_youi_component_Texture$;
/** @constructor */
function $h_Lio_youi_component_Texture$() {
  /*<skip>*/
}
$h_Lio_youi_component_Texture$.prototype = $c_Lio_youi_component_Texture$.prototype;
$c_Lio_youi_component_Texture$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_component_Texture$.prototype.Empty__Lio_youi_component_Texture = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.Empty$lzycompute__p1__Lio_youi_component_Texture() : this.Empty$1)
});
$c_Lio_youi_component_Texture$.prototype.Empty$lzycompute__p1__Lio_youi_component_Texture = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.Empty$1 = new $c_Lio_youi_component_Texture().init___Lcom_outr_pixijs_PIXI_Texture($g.PIXI.Texture.EMPTY);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.Empty$1
});
$c_Lio_youi_component_Texture$.prototype.apply__Lio_youi_net_URL__Lio_youi_component_Texture = (function(url) {
  return new $c_Lio_youi_component_Texture().init___Lcom_outr_pixijs_PIXI_Texture($g.PIXI.Texture.fromImage(url.encoded__Lio_youi_net_URL$URLParts().asString__T()))
});
$c_Lio_youi_component_Texture$.prototype.apply__T__Lio_youi_component_Texture = (function(path) {
  var this$1 = $m_Lio_youi_History$().url$1;
  var qual$1 = $as_Lio_youi_net_URL(this$1.get__O());
  return this.apply__Lio_youi_net_URL__Lio_youi_component_Texture(qual$1.withPath__T__Z__Lio_youi_net_URL(path, true))
});
var $d_Lio_youi_component_Texture$ = new $TypeData().initClass({
  Lio_youi_component_Texture$: 0
}, false, "io.youi.component.Texture$", {
  Lio_youi_component_Texture$: 1,
  O: 1
});
$c_Lio_youi_component_Texture$.prototype.$classData = $d_Lio_youi_component_Texture$;
var $n_Lio_youi_component_Texture$ = (void 0);
function $m_Lio_youi_component_Texture$() {
  if ((!$n_Lio_youi_component_Texture$)) {
    $n_Lio_youi_component_Texture$ = new $c_Lio_youi_component_Texture$().init___()
  };
  return $n_Lio_youi_component_Texture$
}
/** @constructor */
function $c_Lio_youi_easing_Bounce$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Bounce$.prototype = new $h_O();
$c_Lio_youi_easing_Bounce$.prototype.constructor = $c_Lio_youi_easing_Bounce$;
/** @constructor */
function $h_Lio_youi_easing_Bounce$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Bounce$.prototype = $c_Lio_youi_easing_Bounce$.prototype;
$c_Lio_youi_easing_Bounce$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Bounce$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  return ((time < (duration / 2.0)) ? ((0.5 * this.easeIn__D__D__D__D__D((2.0 * time), 0.0, change, duration)) + start) : (((0.5 * this.easeOut__D__D__D__D__D(((2.0 * time) - duration), 0.0, change, duration)) + (0.5 * change)) + start))
});
$c_Lio_youi_easing_Bounce$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  if ((t < 0.36363636363636365)) {
    return ((change * ((7.5625 * t) * t)) + start)
  } else if ((t < 0.7272727272727273)) {
    var t2 = ((-0.5454545454545454) + t);
    return ((change * (0.75 + ((7.5625 * t2) * t2))) + start)
  } else if ((t < 0.9090909090909091)) {
    var t3 = ((-0.8181818181818182) + t);
    return ((change * (0.9375 + ((7.5625 * t3) * t3))) + start)
  } else {
    var t4 = ((-0.9545454545454546) + t);
    return ((change * (0.984375 + ((7.5625 * t4) * t4))) + start)
  }
});
$c_Lio_youi_easing_Bounce$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  return ((change - this.easeOut__D__D__D__D__D((duration - time), 0.0, change, duration)) + start)
});
var $d_Lio_youi_easing_Bounce$ = new $TypeData().initClass({
  Lio_youi_easing_Bounce$: 0
}, false, "io.youi.easing.Bounce$", {
  Lio_youi_easing_Bounce$: 1,
  O: 1
});
$c_Lio_youi_easing_Bounce$.prototype.$classData = $d_Lio_youi_easing_Bounce$;
var $n_Lio_youi_easing_Bounce$ = (void 0);
function $m_Lio_youi_easing_Bounce$() {
  if ((!$n_Lio_youi_easing_Bounce$)) {
    $n_Lio_youi_easing_Bounce$ = new $c_Lio_youi_easing_Bounce$().init___()
  };
  return $n_Lio_youi_easing_Bounce$
}
/** @constructor */
function $c_Lio_youi_easing_Circular$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Circular$.prototype = new $h_O();
$c_Lio_youi_easing_Circular$.prototype.constructor = $c_Lio_youi_easing_Circular$;
/** @constructor */
function $h_Lio_youi_easing_Circular$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Circular$.prototype = $c_Lio_youi_easing_Circular$.prototype;
$c_Lio_youi_easing_Circular$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Circular$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2));
  if ((t < 1)) {
    var x = (1.0 - (t * t));
    return ((((-change) / 2.0) * ((-1.0) + $uD($g.Math.sqrt(x)))) + start)
  } else {
    var t2 = ((-2.0) + t);
    var x$1 = (1.0 - (t2 * t2));
    return (((change / 2.0) * (1.0 + $uD($g.Math.sqrt(x$1)))) + start)
  }
});
$c_Lio_youi_easing_Circular$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  var x = (1.0 - (t * t));
  return ((change * $uD($g.Math.sqrt(x))) + start)
});
$c_Lio_youi_easing_Circular$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  var x = (1.0 - (t * t));
  return (((-change) * ((-1.0) + $uD($g.Math.sqrt(x)))) + start)
});
var $d_Lio_youi_easing_Circular$ = new $TypeData().initClass({
  Lio_youi_easing_Circular$: 0
}, false, "io.youi.easing.Circular$", {
  Lio_youi_easing_Circular$: 1,
  O: 1
});
$c_Lio_youi_easing_Circular$.prototype.$classData = $d_Lio_youi_easing_Circular$;
var $n_Lio_youi_easing_Circular$ = (void 0);
function $m_Lio_youi_easing_Circular$() {
  if ((!$n_Lio_youi_easing_Circular$)) {
    $n_Lio_youi_easing_Circular$ = new $c_Lio_youi_easing_Circular$().init___()
  };
  return $n_Lio_youi_easing_Circular$
}
/** @constructor */
function $c_Lio_youi_easing_Cubic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Cubic$.prototype = new $h_O();
$c_Lio_youi_easing_Cubic$.prototype.constructor = $c_Lio_youi_easing_Cubic$;
/** @constructor */
function $h_Lio_youi_easing_Cubic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Cubic$.prototype = $c_Lio_youi_easing_Cubic$.prototype;
$c_Lio_youi_easing_Cubic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Cubic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return (((((change / 2.0) * t) * t) * t) + start)
  } else {
    var t2 = ((-2.0) + t);
    return (((change / 2.0) * (2.0 + ((t2 * t2) * t2))) + start)
  }
});
$c_Lio_youi_easing_Cubic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  return ((change * (1.0 + ((t * t) * t))) + start)
});
$c_Lio_youi_easing_Cubic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return ((((change * t) * t) * t) + start)
});
var $d_Lio_youi_easing_Cubic$ = new $TypeData().initClass({
  Lio_youi_easing_Cubic$: 0
}, false, "io.youi.easing.Cubic$", {
  Lio_youi_easing_Cubic$: 1,
  O: 1
});
$c_Lio_youi_easing_Cubic$.prototype.$classData = $d_Lio_youi_easing_Cubic$;
var $n_Lio_youi_easing_Cubic$ = (void 0);
function $m_Lio_youi_easing_Cubic$() {
  if ((!$n_Lio_youi_easing_Cubic$)) {
    $n_Lio_youi_easing_Cubic$ = new $c_Lio_youi_easing_Cubic$().init___()
  };
  return $n_Lio_youi_easing_Cubic$
}
/** @constructor */
function $c_Lio_youi_easing_Easing$() {
  $c_O.call(this);
  this.map$1 = null;
  this.all$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_easing_Easing$.prototype = new $h_O();
$c_Lio_youi_easing_Easing$.prototype.constructor = $c_Lio_youi_easing_Easing$;
/** @constructor */
function $h_Lio_youi_easing_Easing$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Easing$.prototype = $c_Lio_youi_easing_Easing$.prototype;
$c_Lio_youi_easing_Easing$.prototype.cubicInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Cubic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.map__sci_Map = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.map$lzycompute__p1__sci_Map() : this.map$1)
});
$c_Lio_youi_easing_Easing$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Easing$.prototype.cubicOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Cubic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.exponentialIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Exponential$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.sineIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Sine$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.exponentialOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Exponential$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quarticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quartic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.circularIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Circular$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quinticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quintic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quadraticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quadratic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.bounceIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Bounce$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quinticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quintic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.sineOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Sine$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.elasticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Elastic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.circularInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Circular$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.sineInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Sine$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.elasticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Elastic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quadraticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quadratic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quarticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quartic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.exponentialInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Exponential$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.bounceOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Bounce$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.bounceInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Bounce$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.circularOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Circular$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quarticIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quartic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quadraticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quadratic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.cubicIn__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Cubic$().easeIn__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.quinticOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Quintic$().easeOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.elasticInOut__Lio_youi_easing_Easing = (function() {
  var f = new $c_sjsr_AnonFunction4().init___sjs_js_Function4((function($this) {
    return (function(time$2, start$2, change$2, duration$2) {
      var time = $uD(time$2);
      var start = $uD(start$2);
      var change = $uD(change$2);
      var duration = $uD(duration$2);
      return $m_Lio_youi_easing_Elastic$().easeInOut__D__D__D__D__D(time, start, change, duration)
    })
  })(this));
  return new $c_Lio_youi_easing_Easing$$anon$1().init___F4(f)
});
$c_Lio_youi_easing_Easing$.prototype.map$lzycompute__p1__sci_Map = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    var y = new $c_Lio_youi_easing_BackIn().init___D(1.70158);
    var jsx$30 = new $c_T2().init___O__O("BackIn", y);
    var y$1 = new $c_Lio_youi_easing_BackOut().init___D(1.70158);
    var jsx$29 = new $c_T2().init___O__O("BackOut", y$1);
    var y$2 = new $c_Lio_youi_easing_BackInOut().init___D(1.70158);
    var jsx$28 = new $c_T2().init___O__O("BackInOut", y$2);
    var y$3 = $m_Lio_youi_easing_Linear$();
    var jsx$27 = new $c_T2().init___O__O("Linear", y$3);
    var y$4 = $m_Lio_youi_easing_Easing$().bounceIn__Lio_youi_easing_Easing();
    var jsx$26 = new $c_T2().init___O__O("BounceIn", y$4);
    var y$5 = $m_Lio_youi_easing_Easing$().bounceOut__Lio_youi_easing_Easing();
    var jsx$25 = new $c_T2().init___O__O("BounceOut", y$5);
    var y$6 = $m_Lio_youi_easing_Easing$().bounceInOut__Lio_youi_easing_Easing();
    var jsx$24 = new $c_T2().init___O__O("BounceInOut", y$6);
    var y$7 = $m_Lio_youi_easing_Easing$().circularIn__Lio_youi_easing_Easing();
    var jsx$23 = new $c_T2().init___O__O("CircularIn", y$7);
    var y$8 = $m_Lio_youi_easing_Easing$().circularOut__Lio_youi_easing_Easing();
    var jsx$22 = new $c_T2().init___O__O("CircularOut", y$8);
    var y$9 = $m_Lio_youi_easing_Easing$().circularInOut__Lio_youi_easing_Easing();
    var jsx$21 = new $c_T2().init___O__O("CircularInOut", y$9);
    var y$10 = $m_Lio_youi_easing_Easing$().cubicIn__Lio_youi_easing_Easing();
    var jsx$20 = new $c_T2().init___O__O("CubicIn", y$10);
    var y$11 = $m_Lio_youi_easing_Easing$().cubicOut__Lio_youi_easing_Easing();
    var jsx$19 = new $c_T2().init___O__O("CubicOut", y$11);
    var y$12 = $m_Lio_youi_easing_Easing$().cubicInOut__Lio_youi_easing_Easing();
    var jsx$18 = new $c_T2().init___O__O("CubicInOut", y$12);
    var y$13 = $m_Lio_youi_easing_Easing$().elasticIn__Lio_youi_easing_Easing();
    var jsx$17 = new $c_T2().init___O__O("ElasticIn", y$13);
    var y$14 = $m_Lio_youi_easing_Easing$().elasticOut__Lio_youi_easing_Easing();
    var jsx$16 = new $c_T2().init___O__O("ElasticOut", y$14);
    var y$15 = $m_Lio_youi_easing_Easing$().elasticInOut__Lio_youi_easing_Easing();
    var jsx$15 = new $c_T2().init___O__O("ElasticInOut", y$15);
    var y$16 = $m_Lio_youi_easing_Easing$().exponentialIn__Lio_youi_easing_Easing();
    var jsx$14 = new $c_T2().init___O__O("ExponentialIn", y$16);
    var y$17 = $m_Lio_youi_easing_Easing$().exponentialOut__Lio_youi_easing_Easing();
    var jsx$13 = new $c_T2().init___O__O("ExponentialOut", y$17);
    var y$18 = $m_Lio_youi_easing_Easing$().exponentialInOut__Lio_youi_easing_Easing();
    var jsx$12 = new $c_T2().init___O__O("ExponentialInOut", y$18);
    var y$19 = $m_Lio_youi_easing_Easing$().quadraticIn__Lio_youi_easing_Easing();
    var jsx$11 = new $c_T2().init___O__O("QuadraticIn", y$19);
    var y$20 = $m_Lio_youi_easing_Easing$().quadraticOut__Lio_youi_easing_Easing();
    var jsx$10 = new $c_T2().init___O__O("QuadraticOut", y$20);
    var y$21 = $m_Lio_youi_easing_Easing$().quadraticInOut__Lio_youi_easing_Easing();
    var jsx$9 = new $c_T2().init___O__O("QuadraticInOut", y$21);
    var y$22 = $m_Lio_youi_easing_Easing$().quarticIn__Lio_youi_easing_Easing();
    var jsx$8 = new $c_T2().init___O__O("QuarticIn", y$22);
    var y$23 = $m_Lio_youi_easing_Easing$().quarticOut__Lio_youi_easing_Easing();
    var jsx$7 = new $c_T2().init___O__O("QuarticOut", y$23);
    var y$24 = $m_Lio_youi_easing_Easing$().quarticInOut__Lio_youi_easing_Easing();
    var jsx$6 = new $c_T2().init___O__O("QuarticInOut", y$24);
    var y$25 = $m_Lio_youi_easing_Easing$().quinticIn__Lio_youi_easing_Easing();
    var jsx$5 = new $c_T2().init___O__O("QuinticIn", y$25);
    var y$26 = $m_Lio_youi_easing_Easing$().quinticOut__Lio_youi_easing_Easing();
    var jsx$4 = new $c_T2().init___O__O("QuinticOut", y$26);
    var y$27 = $m_Lio_youi_easing_Easing$().quinticInOut__Lio_youi_easing_Easing();
    var jsx$3 = new $c_T2().init___O__O("QuinticInOut", y$27);
    var y$28 = $m_Lio_youi_easing_Easing$().sineIn__Lio_youi_easing_Easing();
    var jsx$2 = new $c_T2().init___O__O("SineIn", y$28);
    var y$29 = $m_Lio_youi_easing_Easing$().sineOut__Lio_youi_easing_Easing();
    var jsx$1 = new $c_T2().init___O__O("SineOut", y$29);
    var y$30 = $m_Lio_youi_easing_Easing$().sineInOut__Lio_youi_easing_Easing();
    var array = [jsx$30, jsx$29, jsx$28, jsx$27, jsx$26, jsx$25, jsx$24, jsx$23, jsx$22, jsx$21, jsx$20, jsx$19, jsx$18, jsx$17, jsx$16, jsx$15, jsx$14, jsx$13, jsx$12, jsx$11, jsx$10, jsx$9, jsx$8, jsx$7, jsx$6, jsx$5, jsx$4, jsx$3, jsx$2, jsx$1, new $c_T2().init___O__O("SineInOut", y$30)];
    var this$68 = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
    var i = 0;
    var len = $uI(array.length);
    while ((i < len)) {
      var index = i;
      var arg1 = array[index];
      this$68.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1));
      i = ((1 + i) | 0)
    };
    this.map$1 = $as_sci_Map(this$68.elems$1);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.map$1
});
var $d_Lio_youi_easing_Easing$ = new $TypeData().initClass({
  Lio_youi_easing_Easing$: 0
}, false, "io.youi.easing.Easing$", {
  Lio_youi_easing_Easing$: 1,
  O: 1
});
$c_Lio_youi_easing_Easing$.prototype.$classData = $d_Lio_youi_easing_Easing$;
var $n_Lio_youi_easing_Easing$ = (void 0);
function $m_Lio_youi_easing_Easing$() {
  if ((!$n_Lio_youi_easing_Easing$)) {
    $n_Lio_youi_easing_Easing$ = new $c_Lio_youi_easing_Easing$().init___()
  };
  return $n_Lio_youi_easing_Easing$
}
/** @constructor */
function $c_Lio_youi_easing_Elastic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Elastic$.prototype = new $h_O();
$c_Lio_youi_easing_Elastic$.prototype.constructor = $c_Lio_youi_easing_Elastic$;
/** @constructor */
function $h_Lio_youi_easing_Elastic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Elastic$.prototype = $c_Lio_youi_easing_Elastic$.prototype;
$c_Lio_youi_easing_Elastic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Elastic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((time === 0.0)) {
    return start
  } else if ((t === 2.0)) {
    return (start + change)
  } else {
    var period = (0.44999999999999996 * duration);
    var s = (period / 4.0);
    var t2 = ((-1.0) + t);
    if ((t < 1.0)) {
      var y = (10.0 * t2);
      var jsx$1 = $uD($g.Math.pow(2.0, y));
      var x = ((6.283185307179586 * ((t2 * duration) - s)) / period);
      return (((-0.5) * ((change * jsx$1) * $uD($g.Math.sin(x)))) + start)
    } else {
      var y$1 = ((-10.0) * t2);
      var jsx$2 = $uD($g.Math.pow(2.0, y$1));
      var x$1 = ((6.283185307179586 * ((t2 * duration) - s)) / period);
      return (((0.5 * ((change * jsx$2) * $uD($g.Math.sin(x$1)))) + change) + start)
    }
  }
});
$c_Lio_youi_easing_Elastic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  if ((time === 0.0)) {
    return start
  } else if ((t === 1.0)) {
    return (start + change)
  } else {
    var period = (0.3 * duration);
    var s = (period / 4.0);
    var y = ((-10.0) * t);
    var jsx$1 = $uD($g.Math.pow(2.0, y));
    var x = ((6.283185307179586 * ((t * duration) - s)) / period);
    return ((((change * jsx$1) * $uD($g.Math.sin(x))) + change) + start)
  }
});
$c_Lio_youi_easing_Elastic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  if ((time === 0.0)) {
    return start
  } else if ((t === 1.0)) {
    return (start + change)
  } else {
    var period = (0.3 * duration);
    var s = (period / 4.0);
    var t2 = ((-1.0) + t);
    var y = (10.0 * t2);
    var jsx$1 = $uD($g.Math.pow(2.0, y));
    var x = ((6.283185307179586 * ((t2 * duration) - s)) / period);
    return ((-((change * jsx$1) * $uD($g.Math.sin(x)))) + start)
  }
});
var $d_Lio_youi_easing_Elastic$ = new $TypeData().initClass({
  Lio_youi_easing_Elastic$: 0
}, false, "io.youi.easing.Elastic$", {
  Lio_youi_easing_Elastic$: 1,
  O: 1
});
$c_Lio_youi_easing_Elastic$.prototype.$classData = $d_Lio_youi_easing_Elastic$;
var $n_Lio_youi_easing_Elastic$ = (void 0);
function $m_Lio_youi_easing_Elastic$() {
  if ((!$n_Lio_youi_easing_Elastic$)) {
    $n_Lio_youi_easing_Elastic$ = new $c_Lio_youi_easing_Elastic$().init___()
  };
  return $n_Lio_youi_easing_Elastic$
}
/** @constructor */
function $c_Lio_youi_easing_Exponential$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Exponential$.prototype = new $h_O();
$c_Lio_youi_easing_Exponential$.prototype.constructor = $c_Lio_youi_easing_Exponential$;
/** @constructor */
function $h_Lio_youi_easing_Exponential$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Exponential$.prototype = $c_Lio_youi_easing_Exponential$.prototype;
$c_Lio_youi_easing_Exponential$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Exponential$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((time === 0.0)) {
    return start
  } else if ((time === duration)) {
    return (start + change)
  } else if ((t < 1.0)) {
    var y = (10.0 * ((-1.0) + t));
    return (((change / 2.0) * $uD($g.Math.pow(2.0, y))) + start)
  } else {
    var y$1 = ((-10.0) * ((-1.0) + t));
    return (((change / 2.0) * (2.0 - $uD($g.Math.pow(2.0, y$1)))) + start)
  }
});
$c_Lio_youi_easing_Exponential$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  if ((time === duration)) {
    return (start + change)
  } else {
    var y = (((-10.0) * time) / duration);
    return ((change * (1.0 - $uD($g.Math.pow(2.0, y)))) + start)
  }
});
$c_Lio_youi_easing_Exponential$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  if ((time === 0.0)) {
    return start
  } else {
    var y = (10.0 * ((-1.0) + (time / duration)));
    return ((change * $uD($g.Math.pow(2.0, y))) + start)
  }
});
var $d_Lio_youi_easing_Exponential$ = new $TypeData().initClass({
  Lio_youi_easing_Exponential$: 0
}, false, "io.youi.easing.Exponential$", {
  Lio_youi_easing_Exponential$: 1,
  O: 1
});
$c_Lio_youi_easing_Exponential$.prototype.$classData = $d_Lio_youi_easing_Exponential$;
var $n_Lio_youi_easing_Exponential$ = (void 0);
function $m_Lio_youi_easing_Exponential$() {
  if ((!$n_Lio_youi_easing_Exponential$)) {
    $n_Lio_youi_easing_Exponential$ = new $c_Lio_youi_easing_Exponential$().init___()
  };
  return $n_Lio_youi_easing_Exponential$
}
/** @constructor */
function $c_Lio_youi_easing_Quadratic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Quadratic$.prototype = new $h_O();
$c_Lio_youi_easing_Quadratic$.prototype.constructor = $c_Lio_youi_easing_Quadratic$;
/** @constructor */
function $h_Lio_youi_easing_Quadratic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Quadratic$.prototype = $c_Lio_youi_easing_Quadratic$.prototype;
$c_Lio_youi_easing_Quadratic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Quadratic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return ((((change / 2.0) * t) * t) + start)
  } else {
    var t2 = ((-1.0) + t);
    return ((((-change) / 2.0) * ((-1.0) + (t2 * ((-2.0) + t2)))) + start)
  }
});
$c_Lio_youi_easing_Quadratic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return ((((-change) * t) * ((-2.0) + t)) + start)
});
$c_Lio_youi_easing_Quadratic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return (((change * t) * t) + start)
});
var $d_Lio_youi_easing_Quadratic$ = new $TypeData().initClass({
  Lio_youi_easing_Quadratic$: 0
}, false, "io.youi.easing.Quadratic$", {
  Lio_youi_easing_Quadratic$: 1,
  O: 1
});
$c_Lio_youi_easing_Quadratic$.prototype.$classData = $d_Lio_youi_easing_Quadratic$;
var $n_Lio_youi_easing_Quadratic$ = (void 0);
function $m_Lio_youi_easing_Quadratic$() {
  if ((!$n_Lio_youi_easing_Quadratic$)) {
    $n_Lio_youi_easing_Quadratic$ = new $c_Lio_youi_easing_Quadratic$().init___()
  };
  return $n_Lio_youi_easing_Quadratic$
}
/** @constructor */
function $c_Lio_youi_easing_Quartic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Quartic$.prototype = new $h_O();
$c_Lio_youi_easing_Quartic$.prototype.constructor = $c_Lio_youi_easing_Quartic$;
/** @constructor */
function $h_Lio_youi_easing_Quartic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Quartic$.prototype = $c_Lio_youi_easing_Quartic$.prototype;
$c_Lio_youi_easing_Quartic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Quartic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return ((((((change / 2.0) * t) * t) * t) * t) + start)
  } else {
    var t2 = ((-2.0) + t);
    return ((((-change) / 2.0) * ((-2.0) + (((t2 * t2) * t2) * t2))) + start)
  }
});
$c_Lio_youi_easing_Quartic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  return (((-change) * ((-1.0) + (((t * t) * t) * t))) + start)
});
$c_Lio_youi_easing_Quartic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return (((((change * t) * t) * t) * t) + start)
});
var $d_Lio_youi_easing_Quartic$ = new $TypeData().initClass({
  Lio_youi_easing_Quartic$: 0
}, false, "io.youi.easing.Quartic$", {
  Lio_youi_easing_Quartic$: 1,
  O: 1
});
$c_Lio_youi_easing_Quartic$.prototype.$classData = $d_Lio_youi_easing_Quartic$;
var $n_Lio_youi_easing_Quartic$ = (void 0);
function $m_Lio_youi_easing_Quartic$() {
  if ((!$n_Lio_youi_easing_Quartic$)) {
    $n_Lio_youi_easing_Quartic$ = new $c_Lio_youi_easing_Quartic$().init___()
  };
  return $n_Lio_youi_easing_Quartic$
}
/** @constructor */
function $c_Lio_youi_easing_Quintic$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Quintic$.prototype = new $h_O();
$c_Lio_youi_easing_Quintic$.prototype.constructor = $c_Lio_youi_easing_Quintic$;
/** @constructor */
function $h_Lio_youi_easing_Quintic$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Quintic$.prototype = $c_Lio_youi_easing_Quintic$.prototype;
$c_Lio_youi_easing_Quintic$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Quintic$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / (duration / 2.0));
  if ((t < 1.0)) {
    return (((((((change / 2.0) * t) * t) * t) * t) * t) + start)
  } else {
    var t2 = ((-2.0) + t);
    return (((change / 2.0) * (2.0 + ((((t2 * t2) * t2) * t2) * t2))) + start)
  }
});
$c_Lio_youi_easing_Quintic$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var t = ((-1.0) + (time / duration));
  return ((change * (1.0 + ((((t * t) * t) * t) * t))) + start)
});
$c_Lio_youi_easing_Quintic$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var t = (time / duration);
  return ((((((change * t) * t) * t) * t) * t) + start)
});
var $d_Lio_youi_easing_Quintic$ = new $TypeData().initClass({
  Lio_youi_easing_Quintic$: 0
}, false, "io.youi.easing.Quintic$", {
  Lio_youi_easing_Quintic$: 1,
  O: 1
});
$c_Lio_youi_easing_Quintic$.prototype.$classData = $d_Lio_youi_easing_Quintic$;
var $n_Lio_youi_easing_Quintic$ = (void 0);
function $m_Lio_youi_easing_Quintic$() {
  if ((!$n_Lio_youi_easing_Quintic$)) {
    $n_Lio_youi_easing_Quintic$ = new $c_Lio_youi_easing_Quintic$().init___()
  };
  return $n_Lio_youi_easing_Quintic$
}
/** @constructor */
function $c_Lio_youi_easing_Sine$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Sine$.prototype = new $h_O();
$c_Lio_youi_easing_Sine$.prototype.constructor = $c_Lio_youi_easing_Sine$;
/** @constructor */
function $h_Lio_youi_easing_Sine$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Sine$.prototype = $c_Lio_youi_easing_Sine$.prototype;
$c_Lio_youi_easing_Sine$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Sine$.prototype.easeInOut__D__D__D__D__D = (function(time, start, change, duration) {
  var x = ((3.141592653589793 * time) / duration);
  return ((((-change) / 2.0) * ((-1.0) + $uD($g.Math.cos(x)))) + start)
});
$c_Lio_youi_easing_Sine$.prototype.easeOut__D__D__D__D__D = (function(time, start, change, duration) {
  var x = (1.5707963267948966 * (time / duration));
  return ((change * $uD($g.Math.sin(x))) + start)
});
$c_Lio_youi_easing_Sine$.prototype.easeIn__D__D__D__D__D = (function(time, start, change, duration) {
  var x = (1.5707963267948966 * (time / duration));
  return ((((-change) * $uD($g.Math.cos(x))) + change) + start)
});
var $d_Lio_youi_easing_Sine$ = new $TypeData().initClass({
  Lio_youi_easing_Sine$: 0
}, false, "io.youi.easing.Sine$", {
  Lio_youi_easing_Sine$: 1,
  O: 1
});
$c_Lio_youi_easing_Sine$.prototype.$classData = $d_Lio_youi_easing_Sine$;
var $n_Lio_youi_easing_Sine$ = (void 0);
function $m_Lio_youi_easing_Sine$() {
  if ((!$n_Lio_youi_easing_Sine$)) {
    $n_Lio_youi_easing_Sine$ = new $c_Lio_youi_easing_Sine$().init___()
  };
  return $n_Lio_youi_easing_Sine$
}
/** @constructor */
function $c_Lio_youi_http_Connection() {
  $c_O.call(this);
  this.$$undconnected$1 = null;
  this.connected$1 = null;
  this.send$1 = null;
  this.receive$1 = null;
  this.error$1 = null;
  this.store$1 = null;
  this.io$youi$http$Connection$$backlog$1 = null
}
$c_Lio_youi_http_Connection.prototype = new $h_O();
$c_Lio_youi_http_Connection.prototype.constructor = $c_Lio_youi_http_Connection;
/** @constructor */
function $h_Lio_youi_http_Connection() {
  /*<skip>*/
}
$h_Lio_youi_http_Connection.prototype = $c_Lio_youi_http_Connection.prototype;
$c_Lio_youi_http_Connection.prototype.init___ = (function() {
  this.$$undconnected$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return false
    })
  })(this)), false, true, true);
  this.connected$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      $m_Lreactify_package$();
      var p = this$2.$$undconnected$1;
      return $uZ(p.get__O())
    })
  })(this)), false, true, true);
  this.send$1 = new $c_Lio_youi_http_WebSocketChannels().init___();
  this.receive$1 = new $c_Lio_youi_http_WebSocketChannels().init___();
  this.error$1 = new $c_Lreactify_Channel$$anon$1().init___();
  this.store$1 = new $c_Lio_youi_MapStore().init___sci_Map($m_sci_Map$EmptyMap$());
  $m_scm_ListBuffer$();
  var this$7 = new $c_scm_GrowingBuilder().init___scg_Growable(new $c_scm_ListBuffer().init___());
  this.io$youi$http$Connection$$backlog$1 = $as_scm_ListBuffer($as_sc_GenTraversable(this$7.elems$1));
  this.init__p1__V();
  return this
});
$c_Lio_youi_http_Connection.prototype.init__p1__V = (function() {
  var textListener = new $c_Lio_youi_http_Connection$$anonfun$1().init___Lio_youi_http_Connection(this);
  var binaryListener = new $c_Lio_youi_http_Connection$$anonfun$2().init___Lio_youi_http_Connection(this);
  var this$1 = this.send$1.text$1;
  $f_Lreactify_Observable__observe__Lreactify_Listener__Lreactify_Listener(this$1, textListener);
  var this$2 = this.send$1.binary$1;
  $f_Lreactify_Observable__observe__Lreactify_Listener__Lreactify_Listener(this$2, binaryListener);
  this.send$1.text$1.attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(s$2) {
      var s = $as_T(s$2);
      if ($m_Lio_youi_http_Connection$().debug$1) {
        var this$3 = $m_Lscribe_package$();
        var level = $m_Lscribe_Level$Info$();
        var message = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, s$1) {
          return (function() {
            return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Send: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([s$1]))
          })
        })($this, s));
        var methodName = new $c_s_Some().init___O("init");
        $f_Lscribe_LoggerSupport__log__Lscribe_Level__F0__T__s_Option__I__V(this$3, level, message, "io.youi.http.Connection", methodName, 35)
      }
    })
  })(this)), this.send$1.text$1.attach$default$2__D());
  this.receive$1.text$1.attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(s$3$2) {
      var s$3 = $as_T(s$3$2);
      if ($m_Lio_youi_http_Connection$().debug$1) {
        var this$4 = $m_Lscribe_package$();
        var level$1 = $m_Lscribe_Level$Info$();
        var message$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$2, s$4) {
          return (function() {
            return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Receive: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([s$4]))
          })
        })(this$2$1, s$3));
        var methodName$1 = new $c_s_Some().init___O("init");
        $f_Lscribe_LoggerSupport__log__Lscribe_Level__F0__T__s_Option__I__V(this$4, level$1, message$1, "io.youi.http.Connection", methodName$1, 38)
      }
    })
  })(this)), this.receive$1.text$1.attach$default$2__D());
  var this$12 = this.connected$1;
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, textListener$1, binaryListener$1) {
    return (function(b$2) {
      var b = $uZ(b$2);
      this$3$1.send$1.text$1.detach__Lreactify_Listener__V(textListener$1);
      this$3$1.send$1.binary$1.detach__Lreactify_Listener__V(binaryListener$1);
      if (b) {
        var this$5 = this$3$1.io$youi$http$Connection$$backlog$1;
        var this$6 = this$5.scala$collection$mutable$ListBuffer$$start$6;
        var these = this$6;
        while ((!these.isEmpty__Z())) {
          var arg1 = these.head__O();
          if ($is_T(arg1)) {
            var x2 = $as_T(arg1);
            var this$7 = this$3$1.send$1.text$1;
            var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$3, x2$1) {
              return (function() {
                return x2$1
              })
            })(this$3$1, x2));
            this$7.set__F0__V(value)
          } else if ($isArrayOf_Ljava_nio_ByteBuffer(arg1, 1)) {
            var x3 = $asArrayOf_Ljava_nio_ByteBuffer(arg1, 1);
            var this$8 = this$3$1.send$1.binary$1;
            var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$2, x3$1) {
              return (function() {
                return x3$1
              })
            })(this$3$1, x3));
            this$8.set__F0__V(value$1)
          } else {
            throw new $c_s_MatchError().init___O(arg1)
          };
          these = $as_sci_List(these.tail__O())
        };
        this$3$1.io$youi$http$Connection$$backlog$1.clear__V()
      } else {
        var this$9 = this$3$1.send$1.text$1;
        $f_Lreactify_Observable__observe__Lreactify_Listener__Lreactify_Listener(this$9, textListener$1);
        var this$10 = this$3$1.send$1.binary$1;
        $f_Lreactify_Observable__observe__Lreactify_Listener__Lreactify_Listener(this$10, binaryListener$1)
      }
    })
  })(this, textListener, binaryListener));
  var priority = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$12, f, priority)
});
$c_Lio_youi_http_Connection.prototype.close__V = (function() {
  var this$1 = this.connected$1;
  if ($uZ(this$1.get__O())) {
    var this$2 = this.send$1.close$1;
    var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return (void 0)
      })
    })(this));
    this$2.set__F0__V(value);
    var this$3 = this.$$undconnected$1;
    var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
      return (function() {
        return false
      })
    })(this));
    this$3.replace__F0__Z__V(value$1, true)
  }
});
function $is_Lio_youi_http_Connection(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_http_Connection)))
}
function $as_Lio_youi_http_Connection(obj) {
  return (($is_Lio_youi_http_Connection(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.http.Connection"))
}
function $isArrayOf_Lio_youi_http_Connection(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_http_Connection)))
}
function $asArrayOf_Lio_youi_http_Connection(obj, depth) {
  return (($isArrayOf_Lio_youi_http_Connection(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.http.Connection;", depth))
}
var $d_Lio_youi_http_Connection = new $TypeData().initClass({
  Lio_youi_http_Connection: 0
}, false, "io.youi.http.Connection", {
  Lio_youi_http_Connection: 1,
  O: 1
});
$c_Lio_youi_http_Connection.prototype.$classData = $d_Lio_youi_http_Connection;
/** @constructor */
function $c_Lio_youi_http_Connection$() {
  $c_O.call(this);
  this.debug$1 = false;
  this.key$1 = null
}
$c_Lio_youi_http_Connection$.prototype = new $h_O();
$c_Lio_youi_http_Connection$.prototype.constructor = $c_Lio_youi_http_Connection$;
/** @constructor */
function $h_Lio_youi_http_Connection$() {
  /*<skip>*/
}
$h_Lio_youi_http_Connection$.prototype = $c_Lio_youi_http_Connection$.prototype;
$c_Lio_youi_http_Connection$.prototype.init___ = (function() {
  this.debug$1 = false;
  this.key$1 = "webSocketConnection";
  return this
});
$c_Lio_youi_http_Connection$.prototype.backlog__Lio_youi_http_Connection__O__V = (function(listener, message) {
  if ((listener === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  listener.io$youi$http$Connection$$backlog$1.$$plus$eq__O__scm_ListBuffer(message)
});
var $d_Lio_youi_http_Connection$ = new $TypeData().initClass({
  Lio_youi_http_Connection$: 0
}, false, "io.youi.http.Connection$", {
  Lio_youi_http_Connection$: 1,
  O: 1
});
$c_Lio_youi_http_Connection$.prototype.$classData = $d_Lio_youi_http_Connection$;
var $n_Lio_youi_http_Connection$ = (void 0);
function $m_Lio_youi_http_Connection$() {
  if ((!$n_Lio_youi_http_Connection$)) {
    $n_Lio_youi_http_Connection$ = new $c_Lio_youi_http_Connection$().init___()
  };
  return $n_Lio_youi_http_Connection$
}
/** @constructor */
function $c_Lio_youi_http_WebSocketChannels() {
  $c_O.call(this);
  this.text$1 = null;
  this.binary$1 = null;
  this.close$1 = null
}
$c_Lio_youi_http_WebSocketChannels.prototype = new $h_O();
$c_Lio_youi_http_WebSocketChannels.prototype.constructor = $c_Lio_youi_http_WebSocketChannels;
/** @constructor */
function $h_Lio_youi_http_WebSocketChannels() {
  /*<skip>*/
}
$h_Lio_youi_http_WebSocketChannels.prototype = $c_Lio_youi_http_WebSocketChannels.prototype;
$c_Lio_youi_http_WebSocketChannels.prototype.init___ = (function() {
  this.text$1 = new $c_Lreactify_Channel$$anon$1().init___();
  this.binary$1 = new $c_Lreactify_Channel$$anon$1().init___();
  this.close$1 = new $c_Lreactify_Channel$$anon$1().init___();
  return this
});
var $d_Lio_youi_http_WebSocketChannels = new $TypeData().initClass({
  Lio_youi_http_WebSocketChannels: 0
}, false, "io.youi.http.WebSocketChannels", {
  Lio_youi_http_WebSocketChannels: 1,
  O: 1
});
$c_Lio_youi_http_WebSocketChannels.prototype.$classData = $d_Lio_youi_http_WebSocketChannels;
/** @constructor */
function $c_Lio_youi_http_WebSocketUtil$() {
  $c_O.call(this)
}
$c_Lio_youi_http_WebSocketUtil$.prototype = new $h_O();
$c_Lio_youi_http_WebSocketUtil$.prototype.constructor = $c_Lio_youi_http_WebSocketUtil$;
/** @constructor */
function $h_Lio_youi_http_WebSocketUtil$() {
  /*<skip>*/
}
$h_Lio_youi_http_WebSocketUtil$.prototype = $c_Lio_youi_http_WebSocketUtil$.prototype;
$c_Lio_youi_http_WebSocketUtil$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_http_WebSocketUtil$.prototype.connect__Lio_youi_net_URL__Lio_youi_http_Connection__Lorg_scalajs_dom_raw_WebSocket = (function(socketURL, listener) {
  var ws = new $g.WebSocket(socketURL.encoded__Lio_youi_net_URL$URLParts().asString__T());
  listener.send$1.text$1.attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, listener$1, ws$1) {
    return (function(message$2) {
      var message = $as_T(message$2);
      if (($uI(ws$1.readyState) >= $uI($m_Lorg_scalajs_dom_package$().WebSocket__Lorg_scalajs_dom_raw_WebSocket$().CLOSING))) {
        listener$1.close__V();
        $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V(listener$1, message)
      } else if (($uI(ws$1.readyState) === $uI($m_Lorg_scalajs_dom_package$().WebSocket__Lorg_scalajs_dom_raw_WebSocket$().OPEN))) {
        ws$1.send(message)
      } else {
        $m_Lio_youi_http_Connection$().backlog__Lio_youi_http_Connection__O__V(listener$1, message)
      }
    })
  })(this, listener, ws)), listener.send$1.text$1.attach$default$2__D());
  ws.onopen = (function(listener$1$1) {
    return (function(arg1$2) {
      $m_Lio_youi_http_WebSocketUtil$().io$youi$http$WebSocketUtil$$$anonfun$connect$2__Lorg_scalajs_dom_raw_Event__Lio_youi_http_Connection__V(arg1$2, listener$1$1)
    })
  })(listener);
  ws.onerror = (function(listener$1$2) {
    return (function(arg1$2$1) {
      $m_Lio_youi_http_WebSocketUtil$().io$youi$http$WebSocketUtil$$$anonfun$connect$4__Lorg_scalajs_dom_raw_ErrorEvent__Lio_youi_http_Connection__V(arg1$2$1, listener$1$2)
    })
  })(listener);
  ws.onclose = (function(listener$1$3) {
    return (function(arg1$2$2) {
      listener$1$3.close__V()
    })
  })(listener);
  ws.onmessage = (function(listener$1$4) {
    return (function(arg1$2$3) {
      $m_Lio_youi_http_WebSocketUtil$().io$youi$http$WebSocketUtil$$$anonfun$connect$7__Lorg_scalajs_dom_raw_MessageEvent__Lio_youi_http_Connection__V(arg1$2$3, listener$1$4)
    })
  })(listener);
  return ws
});
$c_Lio_youi_http_WebSocketUtil$.prototype.io$youi$http$WebSocketUtil$$$anonfun$connect$4__Lorg_scalajs_dom_raw_ErrorEvent__Lio_youi_http_Connection__V = (function(evt, listener$1) {
  var this$1 = listener$1.error$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return new $c_jl_RuntimeException().init___T("WebSocket error!")
    })
  })(this));
  this$1.set__F0__V(value);
  listener$1.close__V()
});
$c_Lio_youi_http_WebSocketUtil$.prototype.io$youi$http$WebSocketUtil$$$anonfun$connect$7__Lorg_scalajs_dom_raw_MessageEvent__Lio_youi_http_Connection__V = (function(evt, listener$1) {
  var message = $objectToString(evt.data);
  var this$1 = listener$1.receive$1.text$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, message$1) {
    return (function() {
      return message$1
    })
  })(this, message));
  this$1.set__F0__V(value)
});
$c_Lio_youi_http_WebSocketUtil$.prototype.io$youi$http$WebSocketUtil$$$anonfun$connect$2__Lorg_scalajs_dom_raw_Event__Lio_youi_http_Connection__V = (function(evt, listener$1) {
  var this$1 = listener$1.$$undconnected$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return true
    })
  })(this));
  this$1.replace__F0__Z__V(value, true)
});
var $d_Lio_youi_http_WebSocketUtil$ = new $TypeData().initClass({
  Lio_youi_http_WebSocketUtil$: 0
}, false, "io.youi.http.WebSocketUtil$", {
  Lio_youi_http_WebSocketUtil$: 1,
  O: 1
});
$c_Lio_youi_http_WebSocketUtil$.prototype.$classData = $d_Lio_youi_http_WebSocketUtil$;
var $n_Lio_youi_http_WebSocketUtil$ = (void 0);
function $m_Lio_youi_http_WebSocketUtil$() {
  if ((!$n_Lio_youi_http_WebSocketUtil$)) {
    $n_Lio_youi_http_WebSocketUtil$ = new $c_Lio_youi_http_WebSocketUtil$().init___()
  };
  return $n_Lio_youi_http_WebSocketUtil$
}
function $f_Lio_youi_hypertext_AbstractComponent__id__Lreactify_Var($thiz) {
  return $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_Lio_youi_Unique$().apply__I__T__T(8, $m_Lio_youi_Unique$().LettersLower$1)
    })
  })($thiz)), false, true, true)
}
function $f_Lio_youi_hypertext_AbstractComponent__toString__T($thiz) {
  var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", ":", ""]));
  var jsx$1 = $objectGetClass($thiz).getSimpleName__T();
  var this$1 = $thiz.id__Lreactify_Var();
  return jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([jsx$1, this$1.get__O()]))
}
function $f_Lio_youi_hypertext_AbstractComponent__parent__Lreactify_State($thiz) {
  return $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_s_None$()
    })
  })($thiz)), false, true, true)
}
function $f_Lio_youi_hypertext_AbstractComponent__$$init$__V($thiz) {
  $thiz.io$youi$hypertext$AbstractComponent$$undsetter$und$actualWidth$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$hypertext$AbstractComponent$$undsetter$und$actualHeight$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      return 0.0
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$hypertext$AbstractComponent$$undsetter$und$innerWidth$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3) {
    return (function() {
      return 0.0
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$hypertext$AbstractComponent$$undsetter$und$innerHeight$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4) {
    return (function() {
      return 0.0
    })
  })($thiz)), false, true, true))
}
function $f_Lio_youi_hypertext_AbstractComponent__opacity__Lreactify_Var($thiz) {
  return $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 1.0
    })
  })($thiz)), false, true, true)
}
function $f_Lio_youi_hypertext_AbstractComponent__visible__Lreactify_Var($thiz) {
  return $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return true
    })
  })($thiz)), false, true, true)
}
function $f_Lio_youi_hypertext_AbstractComponent__rotation__Lreactify_Var($thiz) {
  return $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })($thiz)), false, true, true)
}
function $is_Lio_youi_hypertext_AbstractComponent(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_hypertext_AbstractComponent)))
}
function $as_Lio_youi_hypertext_AbstractComponent(obj) {
  return (($is_Lio_youi_hypertext_AbstractComponent(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.hypertext.AbstractComponent"))
}
function $isArrayOf_Lio_youi_hypertext_AbstractComponent(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_hypertext_AbstractComponent)))
}
function $asArrayOf_Lio_youi_hypertext_AbstractComponent(obj, depth) {
  return (($isArrayOf_Lio_youi_hypertext_AbstractComponent(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.hypertext.AbstractComponent;", depth))
}
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$margin$() {
  $c_O.call(this);
  this.left$1 = null;
  this.right$1 = null;
  this.top$1 = null;
  this.bottom$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$margin$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$margin$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$margin$.prototype = $c_Lio_youi_hypertext_AbstractComponent$margin$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.right$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.right$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.right$1
});
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.bottom$lzycompute__p1__Lreactify_Var = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    this.bottom$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottom$1
});
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.left$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.left$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.left$1
});
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.top$lzycompute__p1__Lreactify_Var = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.top$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.top$1
});
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.bottom__Lreactify_Var = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.bottom$lzycompute__p1__Lreactify_Var() : this.bottom$1)
});
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.left__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.left$lzycompute__p1__Lreactify_Var() : this.left$1)
});
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.init___Lio_youi_hypertext_AbstractComponent = (function($$outer) {
  return this
});
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.right__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.right$lzycompute__p1__Lreactify_Var() : this.right$1)
});
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.top__Lreactify_Var = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.top$lzycompute__p1__Lreactify_Var() : this.top$1)
});
var $d_Lio_youi_hypertext_AbstractComponent$margin$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$margin$: 0
}, false, "io.youi.hypertext.AbstractComponent$margin$", {
  Lio_youi_hypertext_AbstractComponent$margin$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$margin$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$margin$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$padding$() {
  $c_O.call(this);
  this.left$1 = null;
  this.right$1 = null;
  this.top$1 = null;
  this.bottom$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$padding$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$padding$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$padding$.prototype = $c_Lio_youi_hypertext_AbstractComponent$padding$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.right$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.right$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.right$1
});
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.bottom$lzycompute__p1__Lreactify_Var = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    this.bottom$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.bottom$1
});
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.left$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.left$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.left$1
});
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.top$lzycompute__p1__Lreactify_Var = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.top$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.top$1
});
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.bottom__Lreactify_Var = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.bottom$lzycompute__p1__Lreactify_Var() : this.bottom$1)
});
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.left__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.left$lzycompute__p1__Lreactify_Var() : this.left$1)
});
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.init___Lio_youi_hypertext_AbstractComponent = (function($$outer) {
  return this
});
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.right__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.right$lzycompute__p1__Lreactify_Var() : this.right$1)
});
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.top__Lreactify_Var = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.top$lzycompute__p1__Lreactify_Var() : this.top$1)
});
var $d_Lio_youi_hypertext_AbstractComponent$padding$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$padding$: 0
}, false, "io.youi.hypertext.AbstractComponent$padding$", {
  Lio_youi_hypertext_AbstractComponent$padding$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$padding$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$padding$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$position$() {
  $c_O.call(this);
  this.type$1 = null;
  this.x$1 = null;
  this.y$1 = null;
  this.left$1 = null;
  this.center$1 = null;
  this.right$1 = null;
  this.top$1 = null;
  this.middle$1 = null;
  this.bottom$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$position$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$position$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$position$.prototype = $c_Lio_youi_hypertext_AbstractComponent$position$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.center$lzycompute__p1__Lreactify_Dep = (function() {
  if (((16 & this.bitmap$0$1) === 0)) {
    var variable = this.left__Lreactify_Var();
    var adjustment = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.$$outer$1.size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().width$1;
        return ($uD(p.get__O()) / 2.0)
      })
    })(this));
    var connector = $m_Lreactify_package$().doubleConnector$1;
    this.center$1 = new $c_Lreactify_Dep().init___Lreactify_Var__F0__Z__Lreactify_DepConnector(variable, adjustment, false, connector);
    this.bitmap$0$1 = (16 | this.bitmap$0$1)
  };
  return this.center$1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.top$lzycompute__p1__Lreactify_Var = (function() {
  if (((64 & this.bitmap$0$1) === 0)) {
    this.top$1 = this.y__Lreactify_Var();
    this.bitmap$0$1 = (64 | this.bitmap$0$1)
  };
  return this.top$1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.left$lzycompute__p1__Lreactify_Var = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    this.left$1 = this.x__Lreactify_Var();
    this.bitmap$0$1 = (8 | this.bitmap$0$1)
  };
  return this.left$1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.right__Lreactify_Dep = (function() {
  return (((32 & this.bitmap$0$1) === 0) ? this.right$lzycompute__p1__Lreactify_Dep() : this.right$1)
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.type$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.type$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_Lio_youi_hypertext_style_Position$Absolute$()
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (1 | this.bitmap$0$1)
  };
  return this.type$1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.x$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.x$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (2 | this.bitmap$0$1)
  };
  return this.x$1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.y__Lreactify_Var = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.y$lzycompute__p1__Lreactify_Var() : this.y$1)
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.right$lzycompute__p1__Lreactify_Dep = (function() {
  if (((32 & this.bitmap$0$1) === 0)) {
    var variable = this.left__Lreactify_Var();
    var adjustment = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.$$outer$1.size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().width$1;
        return $uD(p.get__O())
      })
    })(this));
    var connector = $m_Lreactify_package$().doubleConnector$1;
    this.right$1 = new $c_Lreactify_Dep().init___Lreactify_Var__F0__Z__Lreactify_DepConnector(variable, adjustment, false, connector);
    this.bitmap$0$1 = (32 | this.bitmap$0$1)
  };
  return this.right$1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.bottom$lzycompute__p1__Lreactify_Dep = (function() {
  if (((256 & this.bitmap$0$1) === 0)) {
    var variable = this.top__Lreactify_Var();
    var adjustment = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.$$outer$1.size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().height$1;
        return $uD(p.get__O())
      })
    })(this));
    var connector = $m_Lreactify_package$().doubleConnector$1;
    this.bottom$1 = new $c_Lreactify_Dep().init___Lreactify_Var__F0__Z__Lreactify_DepConnector(variable, adjustment, false, connector);
    this.bitmap$0$1 = (256 | this.bitmap$0$1)
  };
  return this.bottom$1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.y$lzycompute__p1__Lreactify_Var = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.y$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (4 | this.bitmap$0$1)
  };
  return this.y$1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.type__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.type$lzycompute__p1__Lreactify_Var() : this.type$1)
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.center__Lreactify_Dep = (function() {
  return (((16 & this.bitmap$0$1) === 0) ? this.center$lzycompute__p1__Lreactify_Dep() : this.center$1)
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.bottom__Lreactify_Dep = (function() {
  return (((256 & this.bitmap$0$1) === 0) ? this.bottom$lzycompute__p1__Lreactify_Dep() : this.bottom$1)
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.x__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.x$lzycompute__p1__Lreactify_Var() : this.x$1)
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.left__Lreactify_Var = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.left$lzycompute__p1__Lreactify_Var() : this.left$1)
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.middle__Lreactify_Dep = (function() {
  return (((128 & this.bitmap$0$1) === 0) ? this.middle$lzycompute__p1__Lreactify_Dep() : this.middle$1)
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.init___Lio_youi_hypertext_AbstractComponent = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.middle$lzycompute__p1__Lreactify_Dep = (function() {
  if (((128 & this.bitmap$0$1) === 0)) {
    var variable = this.top__Lreactify_Var();
    var adjustment = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        $m_Lreactify_package$();
        var p = $this.$$outer$1.size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().height$1;
        return ($uD(p.get__O()) / 2.0)
      })
    })(this));
    var connector = $m_Lreactify_package$().doubleConnector$1;
    this.middle$1 = new $c_Lreactify_Dep().init___Lreactify_Var__F0__Z__Lreactify_DepConnector(variable, adjustment, false, connector);
    this.bitmap$0$1 = (128 | this.bitmap$0$1)
  };
  return this.middle$1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.top__Lreactify_Var = (function() {
  return (((64 & this.bitmap$0$1) === 0) ? this.top$lzycompute__p1__Lreactify_Var() : this.top$1)
});
var $d_Lio_youi_hypertext_AbstractComponent$position$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$position$: 0
}, false, "io.youi.hypertext.AbstractComponent$position$", {
  Lio_youi_hypertext_AbstractComponent$position$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$position$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$position$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$scale$() {
  $c_O.call(this);
  this.x$1 = null;
  this.y$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_hypertext_AbstractComponent$scale$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$scale$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$scale$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$scale$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$scale$.prototype = $c_Lio_youi_hypertext_AbstractComponent$scale$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$scale$.prototype.x$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.x$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 1.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.x$1
});
$c_Lio_youi_hypertext_AbstractComponent$scale$.prototype.y__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.y$lzycompute__p1__Lreactify_Var() : this.y$1)
});
$c_Lio_youi_hypertext_AbstractComponent$scale$.prototype.y$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.y$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 1.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.y$1
});
$c_Lio_youi_hypertext_AbstractComponent$scale$.prototype.x__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.x$lzycompute__p1__Lreactify_Var() : this.x$1)
});
$c_Lio_youi_hypertext_AbstractComponent$scale$.prototype.init___Lio_youi_hypertext_AbstractComponent = (function($$outer) {
  return this
});
var $d_Lio_youi_hypertext_AbstractComponent$scale$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$scale$: 0
}, false, "io.youi.hypertext.AbstractComponent$scale$", {
  Lio_youi_hypertext_AbstractComponent$scale$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$scale$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$scale$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$scrollbar$() {
  $c_O.call(this);
  this.horizontal$module$1 = null;
  this.vertical$module$1 = null
}
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$scrollbar$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$scrollbar$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype = $c_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype.horizontal__Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$ = (function() {
  if ((this.horizontal$module$1 === null)) {
    this.horizontal$lzycompute$1__p1__V()
  };
  return this.horizontal$module$1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype.vertical$lzycompute$1__p1__V = (function() {
  if ((this.vertical$module$1 === null)) {
    this.vertical$module$1 = new $c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$().init___Lio_youi_hypertext_AbstractComponent$scrollbar$(this)
  }
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype.vertical__Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$ = (function() {
  if ((this.vertical$module$1 === null)) {
    this.vertical$lzycompute$1__p1__V()
  };
  return this.vertical$module$1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype.init___Lio_youi_hypertext_AbstractComponent = (function($$outer) {
  return this
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype.horizontal$lzycompute$1__p1__V = (function() {
  if ((this.horizontal$module$1 === null)) {
    this.horizontal$module$1 = new $c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$().init___Lio_youi_hypertext_AbstractComponent$scrollbar$(this)
  }
});
var $d_Lio_youi_hypertext_AbstractComponent$scrollbar$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$scrollbar$: 0
}, false, "io.youi.hypertext.AbstractComponent$scrollbar$", {
  Lio_youi_hypertext_AbstractComponent$scrollbar$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$scrollbar$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$() {
  $c_O.call(this);
  this.size$1 = null;
  this.visible$1 = null;
  this.position$1 = null;
  this.percentage$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype = $c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype.percentage$lzycompute__p1__Lreactify_Var = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    this.percentage$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.percentage$1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype.position$lzycompute__p1__Lreactify_Var = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.position$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.position$1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype.position__Lreactify_Var = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.position$lzycompute__p1__Lreactify_Var() : this.position$1)
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype.size__Lreactify_State = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.size$lzycompute__p1__Lreactify_State() : this.size$1)
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype.percentage__Lreactify_Var = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.percentage$lzycompute__p1__Lreactify_Var() : this.percentage$1)
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype.size$lzycompute__p1__Lreactify_State = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.size$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.size$1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype.init___Lio_youi_hypertext_AbstractComponent$scrollbar$ = (function($$outer) {
  return this
});
var $d_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$: 0
}, false, "io.youi.hypertext.AbstractComponent$scrollbar$horizontal$", {
  Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$() {
  $c_O.call(this);
  this.size$1 = null;
  this.visible$1 = null;
  this.position$1 = null;
  this.percentage$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype = $c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype.percentage$lzycompute__p1__Lreactify_Var = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    this.percentage$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.percentage$1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype.position$lzycompute__p1__Lreactify_Var = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.position$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.position$1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype.position__Lreactify_Var = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.position$lzycompute__p1__Lreactify_Var() : this.position$1)
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype.size__Lreactify_State = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.size$lzycompute__p1__Lreactify_State() : this.size$1)
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype.percentage__Lreactify_Var = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.percentage$lzycompute__p1__Lreactify_Var() : this.percentage$1)
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype.size$lzycompute__p1__Lreactify_State = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.size$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.size$1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype.init___Lio_youi_hypertext_AbstractComponent$scrollbar$ = (function($$outer) {
  return this
});
var $d_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$: 0
}, false, "io.youi.hypertext.AbstractComponent$scrollbar$vertical$", {
  Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$size$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.center$1 = null;
  this.middle$1 = null;
  this.min$module$1 = null;
  this.max$module$1 = null;
  this.preferred$module$1 = null;
  this.actual$module$1 = null;
  this.inner$module$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$size$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$size$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$size$.prototype = $c_Lio_youi_hypertext_AbstractComponent$size$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.min$lzycompute$1__p1__V = (function() {
  if ((this.min$module$1 === null)) {
    this.min$module$1 = new $c_Lio_youi_hypertext_AbstractComponent$size$min$().init___Lio_youi_hypertext_AbstractComponent$size$(this)
  }
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.actual__Lio_youi_hypertext_AbstractComponent$size$actual$ = (function() {
  if ((this.actual$module$1 === null)) {
    this.actual$lzycompute$1__p1__V()
  };
  return this.actual$module$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.width$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.width$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.width$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.max$lzycompute$1__p1__V = (function() {
  if ((this.max$module$1 === null)) {
    this.max$module$1 = new $c_Lio_youi_hypertext_AbstractComponent$size$max$().init___Lio_youi_hypertext_AbstractComponent$size$(this)
  }
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.actual$lzycompute$1__p1__V = (function() {
  if ((this.actual$module$1 === null)) {
    this.actual$module$1 = new $c_Lio_youi_hypertext_AbstractComponent$size$actual$().init___Lio_youi_hypertext_AbstractComponent$size$(this)
  }
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.height$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.height$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.max__Lio_youi_hypertext_AbstractComponent$size$max$ = (function() {
  if ((this.max$module$1 === null)) {
    this.max$lzycompute$1__p1__V()
  };
  return this.max$module$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.width__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.width$lzycompute__p1__Lreactify_Var() : this.width$1)
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.init___Lio_youi_hypertext_AbstractComponent = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.height__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.height$lzycompute__p1__Lreactify_Var() : this.height$1)
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.min__Lio_youi_hypertext_AbstractComponent$size$min$ = (function() {
  if ((this.min$module$1 === null)) {
    this.min$lzycompute$1__p1__V()
  };
  return this.min$module$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.inner__Lio_youi_hypertext_AbstractComponent$size$inner$ = (function() {
  if ((this.inner$module$1 === null)) {
    this.inner$lzycompute$1__p1__V()
  };
  return this.inner$module$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.inner$lzycompute$1__p1__V = (function() {
  if ((this.inner$module$1 === null)) {
    this.inner$module$1 = new $c_Lio_youi_hypertext_AbstractComponent$size$inner$().init___Lio_youi_hypertext_AbstractComponent$size$(this)
  }
});
var $d_Lio_youi_hypertext_AbstractComponent$size$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$size$: 0
}, false, "io.youi.hypertext.AbstractComponent$size$", {
  Lio_youi_hypertext_AbstractComponent$size$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$size$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$size$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$size$actual$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_AbstractComponent$size$actual$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$size$actual$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$size$actual$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$size$actual$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$size$actual$.prototype = $c_Lio_youi_hypertext_AbstractComponent$size$actual$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$size$actual$.prototype.init___Lio_youi_hypertext_AbstractComponent$size$ = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  this.width$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $m_Lreactify_package$();
      var p = $this.$$outer$1.$$outer$1.actualWidth__Lreactify_Var();
      return $uD(p.get__O())
    })
  })(this)), false, true, true);
  this.height$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      $m_Lreactify_package$();
      var p$1 = this$2.$$outer$1.$$outer$1.actualHeight__Lreactify_Var();
      return $uD(p$1.get__O())
    })
  })(this)), false, true, true);
  return this
});
var $d_Lio_youi_hypertext_AbstractComponent$size$actual$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$size$actual$: 0
}, false, "io.youi.hypertext.AbstractComponent$size$actual$", {
  Lio_youi_hypertext_AbstractComponent$size$actual$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$size$actual$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$size$actual$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$size$inner$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_AbstractComponent$size$inner$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$size$inner$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$size$inner$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$size$inner$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$size$inner$.prototype = $c_Lio_youi_hypertext_AbstractComponent$size$inner$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$size$inner$.prototype.init___Lio_youi_hypertext_AbstractComponent$size$ = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  this.width$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $m_Lreactify_package$();
      var p = $this.$$outer$1.$$outer$1.innerWidth__Lreactify_Var();
      return $uD(p.get__O())
    })
  })(this)), false, true, true);
  this.height$1 = $m_Lreactify_Val$().apply__F0__Z__Z__Z__Lreactify_Val(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      $m_Lreactify_package$();
      var p$1 = this$2.$$outer$1.$$outer$1.innerHeight__Lreactify_Var();
      return $uD(p$1.get__O())
    })
  })(this)), false, true, true);
  return this
});
var $d_Lio_youi_hypertext_AbstractComponent$size$inner$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$size$inner$: 0
}, false, "io.youi.hypertext.AbstractComponent$size$inner$", {
  Lio_youi_hypertext_AbstractComponent$size$inner$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$size$inner$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$size$inner$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$size$max$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_hypertext_AbstractComponent$size$max$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$size$max$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$size$max$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$size$max$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$size$max$.prototype = $c_Lio_youi_hypertext_AbstractComponent$size$max$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$size$max$.prototype.width$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.width$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 1.7976931348623157E308
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.width$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$max$.prototype.height$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.height$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 1.7976931348623157E308
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$max$.prototype.width__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.width$lzycompute__p1__Lreactify_Var() : this.width$1)
});
$c_Lio_youi_hypertext_AbstractComponent$size$max$.prototype.height__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.height$lzycompute__p1__Lreactify_Var() : this.height$1)
});
$c_Lio_youi_hypertext_AbstractComponent$size$max$.prototype.init___Lio_youi_hypertext_AbstractComponent$size$ = (function($$outer) {
  return this
});
var $d_Lio_youi_hypertext_AbstractComponent$size$max$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$size$max$: 0
}, false, "io.youi.hypertext.AbstractComponent$size$max$", {
  Lio_youi_hypertext_AbstractComponent$size$max$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$size$max$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$size$max$;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractComponent$size$min$() {
  $c_O.call(this);
  this.width$1 = null;
  this.height$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_hypertext_AbstractComponent$size$min$.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractComponent$size$min$.prototype.constructor = $c_Lio_youi_hypertext_AbstractComponent$size$min$;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractComponent$size$min$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractComponent$size$min$.prototype = $c_Lio_youi_hypertext_AbstractComponent$size$min$.prototype;
$c_Lio_youi_hypertext_AbstractComponent$size$min$.prototype.width$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.width$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.width$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$min$.prototype.height$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.height$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this)), false, true, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.height$1
});
$c_Lio_youi_hypertext_AbstractComponent$size$min$.prototype.width__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.width$lzycompute__p1__Lreactify_Var() : this.width$1)
});
$c_Lio_youi_hypertext_AbstractComponent$size$min$.prototype.height__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.height$lzycompute__p1__Lreactify_Var() : this.height$1)
});
$c_Lio_youi_hypertext_AbstractComponent$size$min$.prototype.init___Lio_youi_hypertext_AbstractComponent$size$ = (function($$outer) {
  return this
});
var $d_Lio_youi_hypertext_AbstractComponent$size$min$ = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractComponent$size$min$: 0
}, false, "io.youi.hypertext.AbstractComponent$size$min$", {
  Lio_youi_hypertext_AbstractComponent$size$min$: 1,
  O: 1
});
$c_Lio_youi_hypertext_AbstractComponent$size$min$.prototype.$classData = $d_Lio_youi_hypertext_AbstractComponent$size$min$;
/** @constructor */
function $c_Lio_youi_hypertext_Component$() {
  $c_O.call(this);
  this.cache$1 = null
}
$c_Lio_youi_hypertext_Component$.prototype = new $h_O();
$c_Lio_youi_hypertext_Component$.prototype.constructor = $c_Lio_youi_hypertext_Component$;
/** @constructor */
function $h_Lio_youi_hypertext_Component$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_Component$.prototype = $c_Lio_youi_hypertext_Component$.prototype;
$c_Lio_youi_hypertext_Component$.prototype.init___ = (function() {
  $n_Lio_youi_hypertext_Component$ = this;
  this.cache$1 = $m_sci_Map$EmptyMap$();
  return this
});
var $d_Lio_youi_hypertext_Component$ = new $TypeData().initClass({
  Lio_youi_hypertext_Component$: 0
}, false, "io.youi.hypertext.Component$", {
  Lio_youi_hypertext_Component$: 1,
  O: 1
});
$c_Lio_youi_hypertext_Component$.prototype.$classData = $d_Lio_youi_hypertext_Component$;
var $n_Lio_youi_hypertext_Component$ = (void 0);
function $m_Lio_youi_hypertext_Component$() {
  if ((!$n_Lio_youi_hypertext_Component$)) {
    $n_Lio_youi_hypertext_Component$ = new $c_Lio_youi_hypertext_Component$().init___()
  };
  return $n_Lio_youi_hypertext_Component$
}
/** @constructor */
function $c_Lio_youi_hypertext_Component$event$() {
  $c_O.call(this);
  this.change$1 = null;
  this.click$1 = null;
  this.doubleClick$1 = null;
  this.contextMenu$1 = null;
  this.focus$1 = null;
  this.blur$1 = null;
  this.key$module$1 = null;
  this.mouse$module$1 = null;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_Component$event$.prototype = new $h_O();
$c_Lio_youi_hypertext_Component$event$.prototype.constructor = $c_Lio_youi_hypertext_Component$event$;
/** @constructor */
function $h_Lio_youi_hypertext_Component$event$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_Component$event$.prototype = $c_Lio_youi_hypertext_Component$event$.prototype;
$c_Lio_youi_hypertext_Component$event$.prototype.init___Lio_youi_hypertext_Component = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_hypertext_Component$event$.prototype.click$lzycompute__p1__Lreactify_Channel = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    var this$2 = this.$$outer$1;
    this.click$1 = $f_Lio_youi_hypertext_Component__events__T__Z__Lreactify_Channel(this$2, "click", false);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.click$1
});
$c_Lio_youi_hypertext_Component$event$.prototype.click__Lreactify_Channel = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.click$lzycompute__p1__Lreactify_Channel() : this.click$1)
});
var $d_Lio_youi_hypertext_Component$event$ = new $TypeData().initClass({
  Lio_youi_hypertext_Component$event$: 0
}, false, "io.youi.hypertext.Component$event$", {
  Lio_youi_hypertext_Component$event$: 1,
  O: 1
});
$c_Lio_youi_hypertext_Component$event$.prototype.$classData = $d_Lio_youi_hypertext_Component$event$;
/** @constructor */
function $c_Lio_youi_hypertext_Container$() {
  $c_O.call(this)
}
$c_Lio_youi_hypertext_Container$.prototype = new $h_O();
$c_Lio_youi_hypertext_Container$.prototype.constructor = $c_Lio_youi_hypertext_Container$;
/** @constructor */
function $h_Lio_youi_hypertext_Container$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_Container$.prototype = $c_Lio_youi_hypertext_Container$.prototype;
$c_Lio_youi_hypertext_Container$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_hypertext_Container$.prototype.cached__Lorg_scalajs_dom_raw_HTMLElement__Lio_youi_hypertext_Container = (function(element) {
  var this$1 = $m_Lio_youi_hypertext_Component$();
  var x1 = this$1.cache$1.get__O__s_Option(element);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var c = $as_Lio_youi_hypertext_Component(x2.value$2);
    var jsx$1 = c
  } else {
    var x = $m_s_None$();
    if ((!(x === x1))) {
      throw new $c_s_MatchError().init___O(x1)
    };
    var c$2 = new $c_Lio_youi_hypertext_Container().init___Lorg_scalajs_dom_raw_HTMLElement(element);
    this$1.cache$1 = this$1.cache$1.$$plus__T2__sci_Map(new $c_T2().init___O__O(element, c$2));
    var jsx$1 = c$2
  };
  return $as_Lio_youi_hypertext_Container(jsx$1)
});
var $d_Lio_youi_hypertext_Container$ = new $TypeData().initClass({
  Lio_youi_hypertext_Container$: 0
}, false, "io.youi.hypertext.Container$", {
  Lio_youi_hypertext_Container$: 1,
  O: 1
});
$c_Lio_youi_hypertext_Container$.prototype.$classData = $d_Lio_youi_hypertext_Container$;
var $n_Lio_youi_hypertext_Container$ = (void 0);
function $m_Lio_youi_hypertext_Container$() {
  if ((!$n_Lio_youi_hypertext_Container$)) {
    $n_Lio_youi_hypertext_Container$ = new $c_Lio_youi_hypertext_Container$().init___()
  };
  return $n_Lio_youi_hypertext_Container$
}
/** @constructor */
function $c_Lio_youi_hypertext_border_Border() {
  $c_O.call(this);
  this.color$1 = null;
  this.style$1 = null;
  this.size$1 = null;
  this.component$1 = null;
  this.updateColor$1 = null;
  this.updateStyle$1 = null;
  this.updateWidth$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_hypertext_border_Border.prototype = new $h_O();
$c_Lio_youi_hypertext_border_Border.prototype.constructor = $c_Lio_youi_hypertext_border_Border;
/** @constructor */
function $h_Lio_youi_hypertext_border_Border() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_border_Border.prototype = $c_Lio_youi_hypertext_border_Border.prototype;
$c_Lio_youi_hypertext_border_Border.prototype.style__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.style$lzycompute__p1__Lreactify_Var() : this.style$1)
});
$c_Lio_youi_hypertext_border_Border.prototype.size__Lreactify_Var = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.size$lzycompute__p1__Lreactify_Var() : this.size$1)
});
$c_Lio_youi_hypertext_border_Border.prototype.init___Lio_youi_hypertext_Component__F1__F1__F1 = (function(component, updateColor, updateStyle, updateWidth) {
  this.component$1 = component;
  this.updateColor$1 = updateColor;
  this.updateStyle$1 = updateStyle;
  this.updateWidth$1 = updateWidth;
  return this
});
$c_Lio_youi_hypertext_border_Border.prototype.color$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    var this$3 = this.component$1;
    var get = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_s_None$()
      })
    })(this));
    var set = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
      return (function(o$2) {
        var o = $as_s_Option(o$2);
        var jsx$1 = this$2.updateColor$1;
        if (o.isEmpty__Z()) {
          var this$1 = $m_s_None$()
        } else {
          var arg1 = o.get__O();
          var x$1 = $as_Lio_youi_Color(arg1);
          var this$1 = new $c_s_Some().init___O($m_Lio_youi_Color$().toCSS__D__D__D__D__T(x$1.red$1, x$1.green$1, x$1.blue$1, x$1.alpha$1))
        };
        jsx$1.apply__O__O((this$1.isEmpty__Z() ? "" : this$1.get__O()))
      })
    })(this));
    this.color$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(this$3, get, set, false);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.color$1
});
$c_Lio_youi_hypertext_border_Border.prototype.style$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    var this$3 = this.component$1;
    var get = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_s_None$()
      })
    })(this));
    var set = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
      return (function(o$2) {
        var o = $as_s_Option(o$2);
        var jsx$1 = this$2.updateStyle$1;
        if (o.isEmpty__Z()) {
          var this$1 = $m_s_None$()
        } else {
          var arg1 = o.get__O();
          var x$2 = $as_Lio_youi_hypertext_border_BorderStyle(arg1);
          var this$1 = new $c_s_Some().init___O(x$2.value$1)
        };
        jsx$1.apply__O__O((this$1.isEmpty__Z() ? "" : this$1.get__O()))
      })
    })(this));
    this.style$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(this$3, get, set, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.style$1
});
$c_Lio_youi_hypertext_border_Border.prototype.size$lzycompute__p1__Lreactify_Var = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    var this$3 = this.component$1;
    var get = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return $m_s_None$()
      })
    })(this));
    var set = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
      return (function(o$2) {
        var o = $as_s_Option(o$2);
        var jsx$1 = this$2.updateWidth$1;
        if (o.isEmpty__Z()) {
          var this$1 = $m_s_None$()
        } else {
          var arg1 = o.get__O();
          var d = $uD(arg1);
          var this$1 = new $c_s_Some().init___O(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d])))
        };
        jsx$1.apply__O__O((this$1.isEmpty__Z() ? "" : this$1.get__O()))
      })
    })(this));
    this.size$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(this$3, get, set, true);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.size$1
});
$c_Lio_youi_hypertext_border_Border.prototype.color__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.color$lzycompute__p1__Lreactify_Var() : this.color$1)
});
/** @constructor */
function $c_Lio_youi_hypertext_border_BorderStyle() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_hypertext_border_BorderStyle.prototype = new $h_O();
$c_Lio_youi_hypertext_border_BorderStyle.prototype.constructor = $c_Lio_youi_hypertext_border_BorderStyle;
/** @constructor */
function $h_Lio_youi_hypertext_border_BorderStyle() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_border_BorderStyle.prototype = $c_Lio_youi_hypertext_border_BorderStyle.prototype;
$c_Lio_youi_hypertext_border_BorderStyle.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_hypertext_border_BorderStyle(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_hypertext_border_BorderStyle)))
}
function $as_Lio_youi_hypertext_border_BorderStyle(obj) {
  return (($is_Lio_youi_hypertext_border_BorderStyle(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.hypertext.border.BorderStyle"))
}
function $isArrayOf_Lio_youi_hypertext_border_BorderStyle(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_hypertext_border_BorderStyle)))
}
function $asArrayOf_Lio_youi_hypertext_border_BorderStyle(obj, depth) {
  return (($isArrayOf_Lio_youi_hypertext_border_BorderStyle(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.hypertext.border.BorderStyle;", depth))
}
/** @constructor */
function $c_Lio_youi_hypertext_border_ComponentBorders() {
  $c_O.call(this);
  this.io$youi$hypertext$border$ComponentBorders$$topLeftRadius$1 = null;
  this.io$youi$hypertext$border$ComponentBorders$$topRightRadius$1 = null;
  this.io$youi$hypertext$border$ComponentBorders$$bottomLeftRadius$1 = null;
  this.io$youi$hypertext$border$ComponentBorders$$bottomRightRadius$1 = null;
  this.top$module$1 = null;
  this.bottom$module$1 = null;
  this.left$module$1 = null;
  this.right$module$1 = null;
  this.color$module$1 = null;
  this.style$module$1 = null;
  this.size$module$1 = null;
  this.radius$module$1 = null;
  this.io$youi$hypertext$border$ComponentBorders$$component$f = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_hypertext_border_ComponentBorders.prototype = new $h_O();
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.constructor = $c_Lio_youi_hypertext_border_ComponentBorders;
/** @constructor */
function $h_Lio_youi_hypertext_border_ComponentBorders() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_border_ComponentBorders.prototype = $c_Lio_youi_hypertext_border_ComponentBorders.prototype;
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.io$youi$hypertext$border$ComponentBorders$$bottomLeftRadius__Lreactify_Var = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.bottomLeftRadius$lzycompute__p1__Lreactify_Var() : this.io$youi$hypertext$border$ComponentBorders$$bottomLeftRadius$1)
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.io$youi$hypertext$border$ComponentBorders$$bottomRightRadius__Lreactify_Var = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.bottomRightRadius$lzycompute__p1__Lreactify_Var() : this.io$youi$hypertext$border$ComponentBorders$$bottomRightRadius$1)
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.style$lzycompute$1__p1__V = (function() {
  if ((this.style$module$1 === null)) {
    this.style$module$1 = new $c_Lio_youi_hypertext_border_ComponentBorders$style$().init___Lio_youi_hypertext_border_ComponentBorders(this)
  }
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.topLeftRadius$lzycompute__p1__Lreactify_Var = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    var this$1 = this.io$youi$hypertext$border$ComponentBorders$$component$f;
    var get = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var set = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
      return (function(d$2) {
        var d = $uD(d$2);
        this$2.io$youi$hypertext$border$ComponentBorders$$component$f.element__Lorg_scalajs_dom_raw_HTMLElement().style.borderTopLeftRadius = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d]))
      })
    })(this));
    this.io$youi$hypertext$border$ComponentBorders$$topLeftRadius$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(this$1, get, set, true);
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.io$youi$hypertext$border$ComponentBorders$$topLeftRadius$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.io$youi$hypertext$border$ComponentBorders$$topRightRadius__Lreactify_Var = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.topRightRadius$lzycompute__p1__Lreactify_Var() : this.io$youi$hypertext$border$ComponentBorders$$topRightRadius$1)
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.size__Lio_youi_hypertext_border_ComponentBorders$size$ = (function() {
  if ((this.size$module$1 === null)) {
    this.size$lzycompute$1__p1__V()
  };
  return this.size$module$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.color$lzycompute$1__p1__V = (function() {
  if ((this.color$module$1 === null)) {
    this.color$module$1 = new $c_Lio_youi_hypertext_border_ComponentBorders$color$().init___Lio_youi_hypertext_border_ComponentBorders(this)
  }
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.top__Lio_youi_hypertext_border_ComponentBorders$top$ = (function() {
  if ((this.top$module$1 === null)) {
    this.top$lzycompute$1__p1__V()
  };
  return this.top$module$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.bottomRightRadius$lzycompute__p1__Lreactify_Var = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    var this$1 = this.io$youi$hypertext$border$ComponentBorders$$component$f;
    var get = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var set = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
      return (function(d$2) {
        var d = $uD(d$2);
        this$2.io$youi$hypertext$border$ComponentBorders$$component$f.element__Lorg_scalajs_dom_raw_HTMLElement().style.borderBottomRightRadius = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d]))
      })
    })(this));
    this.io$youi$hypertext$border$ComponentBorders$$bottomRightRadius$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(this$1, get, set, true);
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.io$youi$hypertext$border$ComponentBorders$$bottomRightRadius$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.bottom__Lio_youi_hypertext_border_ComponentBorders$bottom$ = (function() {
  if ((this.bottom$module$1 === null)) {
    this.bottom$lzycompute$1__p1__V()
  };
  return this.bottom$module$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.color__Lio_youi_hypertext_border_ComponentBorders$color$ = (function() {
  if ((this.color$module$1 === null)) {
    this.color$lzycompute$1__p1__V()
  };
  return this.color$module$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.right$lzycompute$1__p1__V = (function() {
  if ((this.right$module$1 === null)) {
    this.right$module$1 = new $c_Lio_youi_hypertext_border_ComponentBorders$right$().init___Lio_youi_hypertext_border_ComponentBorders(this)
  }
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.right__Lio_youi_hypertext_border_ComponentBorders$right$ = (function() {
  if ((this.right$module$1 === null)) {
    this.right$lzycompute$1__p1__V()
  };
  return this.right$module$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.init___Lio_youi_hypertext_Component = (function(component) {
  this.io$youi$hypertext$border$ComponentBorders$$component$f = component;
  return this
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.left$lzycompute$1__p1__V = (function() {
  if ((this.left$module$1 === null)) {
    this.left$module$1 = new $c_Lio_youi_hypertext_border_ComponentBorders$left$().init___Lio_youi_hypertext_border_ComponentBorders(this)
  }
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.style__Lio_youi_hypertext_border_ComponentBorders$style$ = (function() {
  if ((this.style$module$1 === null)) {
    this.style$lzycompute$1__p1__V()
  };
  return this.style$module$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.left__Lio_youi_hypertext_border_ComponentBorders$left$ = (function() {
  if ((this.left$module$1 === null)) {
    this.left$lzycompute$1__p1__V()
  };
  return this.left$module$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.bottom$lzycompute$1__p1__V = (function() {
  if ((this.bottom$module$1 === null)) {
    this.bottom$module$1 = new $c_Lio_youi_hypertext_border_ComponentBorders$bottom$().init___Lio_youi_hypertext_border_ComponentBorders(this)
  }
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.io$youi$hypertext$border$ComponentBorders$$topLeftRadius__Lreactify_Var = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.topLeftRadius$lzycompute__p1__Lreactify_Var() : this.io$youi$hypertext$border$ComponentBorders$$topLeftRadius$1)
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.radius__Lio_youi_hypertext_border_ComponentBorders$radius$ = (function() {
  if ((this.radius$module$1 === null)) {
    this.radius$lzycompute$1__p1__V()
  };
  return this.radius$module$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.bottomLeftRadius$lzycompute__p1__Lreactify_Var = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    var this$1 = this.io$youi$hypertext$border$ComponentBorders$$component$f;
    var get = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var set = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
      return (function(d$2) {
        var d = $uD(d$2);
        this$2.io$youi$hypertext$border$ComponentBorders$$component$f.element__Lorg_scalajs_dom_raw_HTMLElement().style.borderBottomLeftRadius = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d]))
      })
    })(this));
    this.io$youi$hypertext$border$ComponentBorders$$bottomLeftRadius$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(this$1, get, set, true);
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.io$youi$hypertext$border$ComponentBorders$$bottomLeftRadius$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.topRightRadius$lzycompute__p1__Lreactify_Var = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    var this$1 = this.io$youi$hypertext$border$ComponentBorders$$component$f;
    var get = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
      return (function() {
        return 0.0
      })
    })(this));
    var set = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
      return (function(d$2) {
        var d = $uD(d$2);
        this$2.io$youi$hypertext$border$ComponentBorders$$component$f.element__Lorg_scalajs_dom_raw_HTMLElement().style.borderTopRightRadius = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d]))
      })
    })(this));
    this.io$youi$hypertext$border$ComponentBorders$$topRightRadius$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(this$1, get, set, true);
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.io$youi$hypertext$border$ComponentBorders$$topRightRadius$1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.top$lzycompute$1__p1__V = (function() {
  if ((this.top$module$1 === null)) {
    this.top$module$1 = new $c_Lio_youi_hypertext_border_ComponentBorders$top$().init___Lio_youi_hypertext_border_ComponentBorders(this)
  }
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.size$lzycompute$1__p1__V = (function() {
  if ((this.size$module$1 === null)) {
    this.size$module$1 = new $c_Lio_youi_hypertext_border_ComponentBorders$size$().init___Lio_youi_hypertext_border_ComponentBorders(this)
  }
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.radius$lzycompute$1__p1__V = (function() {
  if ((this.radius$module$1 === null)) {
    this.radius$module$1 = new $c_Lio_youi_hypertext_border_ComponentBorders$radius$().init___Lio_youi_hypertext_border_ComponentBorders(this)
  }
});
var $d_Lio_youi_hypertext_border_ComponentBorders = new $TypeData().initClass({
  Lio_youi_hypertext_border_ComponentBorders: 0
}, false, "io.youi.hypertext.border.ComponentBorders", {
  Lio_youi_hypertext_border_ComponentBorders: 1,
  O: 1
});
$c_Lio_youi_hypertext_border_ComponentBorders.prototype.$classData = $d_Lio_youi_hypertext_border_ComponentBorders;
/** @constructor */
function $c_Lio_youi_hypertext_border_ComponentBorders$bottom$right$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_border_ComponentBorders$bottom$right$.prototype = new $h_O();
$c_Lio_youi_hypertext_border_ComponentBorders$bottom$right$.prototype.constructor = $c_Lio_youi_hypertext_border_ComponentBorders$bottom$right$;
/** @constructor */
function $h_Lio_youi_hypertext_border_ComponentBorders$bottom$right$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_border_ComponentBorders$bottom$right$.prototype = $c_Lio_youi_hypertext_border_ComponentBorders$bottom$right$.prototype;
$c_Lio_youi_hypertext_border_ComponentBorders$bottom$right$.prototype.radius__Lreactify_Var = (function() {
  return this.$$outer$1.$$outer$2.io$youi$hypertext$border$ComponentBorders$$bottomRightRadius__Lreactify_Var()
});
$c_Lio_youi_hypertext_border_ComponentBorders$bottom$right$.prototype.init___Lio_youi_hypertext_border_ComponentBorders$bottom$ = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_hypertext_border_ComponentBorders$bottom$right$ = new $TypeData().initClass({
  Lio_youi_hypertext_border_ComponentBorders$bottom$right$: 0
}, false, "io.youi.hypertext.border.ComponentBorders$bottom$right$", {
  Lio_youi_hypertext_border_ComponentBorders$bottom$right$: 1,
  O: 1
});
$c_Lio_youi_hypertext_border_ComponentBorders$bottom$right$.prototype.$classData = $d_Lio_youi_hypertext_border_ComponentBorders$bottom$right$;
/** @constructor */
function $c_Lio_youi_hypertext_border_ComponentBorders$color$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_border_ComponentBorders$color$.prototype = new $h_O();
$c_Lio_youi_hypertext_border_ComponentBorders$color$.prototype.constructor = $c_Lio_youi_hypertext_border_ComponentBorders$color$;
/** @constructor */
function $h_Lio_youi_hypertext_border_ComponentBorders$color$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_border_ComponentBorders$color$.prototype = $c_Lio_youi_hypertext_border_ComponentBorders$color$.prototype;
$c_Lio_youi_hypertext_border_ComponentBorders$color$.prototype.init___Lio_youi_hypertext_border_ComponentBorders = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_hypertext_border_ComponentBorders$color$.prototype.set__s_Option__V = (function(value) {
  var this$1 = this.$$outer$1.top__Lio_youi_hypertext_border_ComponentBorders$top$().color__Lreactify_Var();
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, value$1) {
    return (function() {
      return value$1
    })
  })(this, value));
  this$1.replace__F0__Z__V(value$2, true);
  var this$3 = this.$$outer$1.bottom__Lio_youi_hypertext_border_ComponentBorders$bottom$().color__Lreactify_Var();
  var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, value$3) {
    return (function() {
      return value$3
    })
  })(this, value));
  this$3.replace__F0__Z__V(value$4, true);
  var this$4 = this.$$outer$1.left__Lio_youi_hypertext_border_ComponentBorders$left$().color__Lreactify_Var();
  var value$6 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, value$5) {
    return (function() {
      return value$5
    })
  })(this, value));
  this$4.replace__F0__Z__V(value$6, true);
  var this$5 = this.$$outer$1.right__Lio_youi_hypertext_border_ComponentBorders$right$().color__Lreactify_Var();
  var value$8 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, value$7) {
    return (function() {
      return value$7
    })
  })(this, value));
  this$5.replace__F0__Z__V(value$8, true)
});
var $d_Lio_youi_hypertext_border_ComponentBorders$color$ = new $TypeData().initClass({
  Lio_youi_hypertext_border_ComponentBorders$color$: 0
}, false, "io.youi.hypertext.border.ComponentBorders$color$", {
  Lio_youi_hypertext_border_ComponentBorders$color$: 1,
  O: 1
});
$c_Lio_youi_hypertext_border_ComponentBorders$color$.prototype.$classData = $d_Lio_youi_hypertext_border_ComponentBorders$color$;
/** @constructor */
function $c_Lio_youi_hypertext_border_ComponentBorders$radius$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_border_ComponentBorders$radius$.prototype = new $h_O();
$c_Lio_youi_hypertext_border_ComponentBorders$radius$.prototype.constructor = $c_Lio_youi_hypertext_border_ComponentBorders$radius$;
/** @constructor */
function $h_Lio_youi_hypertext_border_ComponentBorders$radius$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_border_ComponentBorders$radius$.prototype = $c_Lio_youi_hypertext_border_ComponentBorders$radius$.prototype;
$c_Lio_youi_hypertext_border_ComponentBorders$radius$.prototype.init___Lio_youi_hypertext_border_ComponentBorders = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_hypertext_border_ComponentBorders$radius$.prototype.set__D__V = (function(value) {
  var this$1 = this.$$outer$1.io$youi$hypertext$border$ComponentBorders$$topLeftRadius__Lreactify_Var();
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, value$1) {
    return (function() {
      return value$1
    })
  })(this, value));
  this$1.replace__F0__Z__V(value$2, true);
  var this$3 = this.$$outer$1.io$youi$hypertext$border$ComponentBorders$$topRightRadius__Lreactify_Var();
  var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, value$3) {
    return (function() {
      return value$3
    })
  })(this, value));
  this$3.replace__F0__Z__V(value$4, true);
  var this$4 = this.$$outer$1.io$youi$hypertext$border$ComponentBorders$$bottomLeftRadius__Lreactify_Var();
  var value$6 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, value$5) {
    return (function() {
      return value$5
    })
  })(this, value));
  this$4.replace__F0__Z__V(value$6, true);
  var this$5 = this.$$outer$1.io$youi$hypertext$border$ComponentBorders$$bottomRightRadius__Lreactify_Var();
  var value$8 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, value$7) {
    return (function() {
      return value$7
    })
  })(this, value));
  this$5.replace__F0__Z__V(value$8, true)
});
var $d_Lio_youi_hypertext_border_ComponentBorders$radius$ = new $TypeData().initClass({
  Lio_youi_hypertext_border_ComponentBorders$radius$: 0
}, false, "io.youi.hypertext.border.ComponentBorders$radius$", {
  Lio_youi_hypertext_border_ComponentBorders$radius$: 1,
  O: 1
});
$c_Lio_youi_hypertext_border_ComponentBorders$radius$.prototype.$classData = $d_Lio_youi_hypertext_border_ComponentBorders$radius$;
/** @constructor */
function $c_Lio_youi_hypertext_border_ComponentBorders$size$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_border_ComponentBorders$size$.prototype = new $h_O();
$c_Lio_youi_hypertext_border_ComponentBorders$size$.prototype.constructor = $c_Lio_youi_hypertext_border_ComponentBorders$size$;
/** @constructor */
function $h_Lio_youi_hypertext_border_ComponentBorders$size$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_border_ComponentBorders$size$.prototype = $c_Lio_youi_hypertext_border_ComponentBorders$size$.prototype;
$c_Lio_youi_hypertext_border_ComponentBorders$size$.prototype.init___Lio_youi_hypertext_border_ComponentBorders = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_hypertext_border_ComponentBorders$size$.prototype.set__s_Option__V = (function(value) {
  var this$1 = this.$$outer$1.top__Lio_youi_hypertext_border_ComponentBorders$top$().size__Lreactify_Var();
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, value$1) {
    return (function() {
      return value$1
    })
  })(this, value));
  this$1.replace__F0__Z__V(value$2, true);
  var this$3 = this.$$outer$1.bottom__Lio_youi_hypertext_border_ComponentBorders$bottom$().size__Lreactify_Var();
  var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, value$3) {
    return (function() {
      return value$3
    })
  })(this, value));
  this$3.replace__F0__Z__V(value$4, true);
  var this$4 = this.$$outer$1.left__Lio_youi_hypertext_border_ComponentBorders$left$().size__Lreactify_Var();
  var value$6 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, value$5) {
    return (function() {
      return value$5
    })
  })(this, value));
  this$4.replace__F0__Z__V(value$6, true);
  var this$5 = this.$$outer$1.right__Lio_youi_hypertext_border_ComponentBorders$right$().size__Lreactify_Var();
  var value$8 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, value$7) {
    return (function() {
      return value$7
    })
  })(this, value));
  this$5.replace__F0__Z__V(value$8, true)
});
var $d_Lio_youi_hypertext_border_ComponentBorders$size$ = new $TypeData().initClass({
  Lio_youi_hypertext_border_ComponentBorders$size$: 0
}, false, "io.youi.hypertext.border.ComponentBorders$size$", {
  Lio_youi_hypertext_border_ComponentBorders$size$: 1,
  O: 1
});
$c_Lio_youi_hypertext_border_ComponentBorders$size$.prototype.$classData = $d_Lio_youi_hypertext_border_ComponentBorders$size$;
/** @constructor */
function $c_Lio_youi_hypertext_border_ComponentBorders$style$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_border_ComponentBorders$style$.prototype = new $h_O();
$c_Lio_youi_hypertext_border_ComponentBorders$style$.prototype.constructor = $c_Lio_youi_hypertext_border_ComponentBorders$style$;
/** @constructor */
function $h_Lio_youi_hypertext_border_ComponentBorders$style$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_border_ComponentBorders$style$.prototype = $c_Lio_youi_hypertext_border_ComponentBorders$style$.prototype;
$c_Lio_youi_hypertext_border_ComponentBorders$style$.prototype.init___Lio_youi_hypertext_border_ComponentBorders = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_hypertext_border_ComponentBorders$style$.prototype.set__s_Option__V = (function(value) {
  var this$1 = this.$$outer$1.top__Lio_youi_hypertext_border_ComponentBorders$top$().style__Lreactify_Var();
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, value$1) {
    return (function() {
      return value$1
    })
  })(this, value));
  this$1.replace__F0__Z__V(value$2, true);
  var this$3 = this.$$outer$1.bottom__Lio_youi_hypertext_border_ComponentBorders$bottom$().style__Lreactify_Var();
  var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, value$3) {
    return (function() {
      return value$3
    })
  })(this, value));
  this$3.replace__F0__Z__V(value$4, true);
  var this$4 = this.$$outer$1.left__Lio_youi_hypertext_border_ComponentBorders$left$().style__Lreactify_Var();
  var value$6 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, value$5) {
    return (function() {
      return value$5
    })
  })(this, value));
  this$4.replace__F0__Z__V(value$6, true);
  var this$5 = this.$$outer$1.right__Lio_youi_hypertext_border_ComponentBorders$right$().style__Lreactify_Var();
  var value$8 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, value$7) {
    return (function() {
      return value$7
    })
  })(this, value));
  this$5.replace__F0__Z__V(value$8, true)
});
var $d_Lio_youi_hypertext_border_ComponentBorders$style$ = new $TypeData().initClass({
  Lio_youi_hypertext_border_ComponentBorders$style$: 0
}, false, "io.youi.hypertext.border.ComponentBorders$style$", {
  Lio_youi_hypertext_border_ComponentBorders$style$: 1,
  O: 1
});
$c_Lio_youi_hypertext_border_ComponentBorders$style$.prototype.$classData = $d_Lio_youi_hypertext_border_ComponentBorders$style$;
/** @constructor */
function $c_Lio_youi_hypertext_layout_Layout() {
  $c_O.call(this)
}
$c_Lio_youi_hypertext_layout_Layout.prototype = new $h_O();
$c_Lio_youi_hypertext_layout_Layout.prototype.constructor = $c_Lio_youi_hypertext_layout_Layout;
/** @constructor */
function $h_Lio_youi_hypertext_layout_Layout() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_layout_Layout.prototype = $c_Lio_youi_hypertext_layout_Layout.prototype;
function $is_Lio_youi_hypertext_layout_Layout(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_hypertext_layout_Layout)))
}
function $as_Lio_youi_hypertext_layout_Layout(obj) {
  return (($is_Lio_youi_hypertext_layout_Layout(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.hypertext.layout.Layout"))
}
function $isArrayOf_Lio_youi_hypertext_layout_Layout(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_hypertext_layout_Layout)))
}
function $asArrayOf_Lio_youi_hypertext_layout_Layout(obj, depth) {
  return (($isArrayOf_Lio_youi_hypertext_layout_Layout(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.hypertext.layout.Layout;", depth))
}
/** @constructor */
function $c_Lio_youi_hypertext_style_ColorProperties() {
  $c_O.call(this);
  this.initialRed$1 = 0.0;
  this.initialGreen$1 = 0.0;
  this.initialBlue$1 = 0.0;
  this.initialAlpha$1 = 0.0;
  this.red$1 = null;
  this.green$1 = null;
  this.blue$1 = null;
  this.alpha$1 = null
}
$c_Lio_youi_hypertext_style_ColorProperties.prototype = new $h_O();
$c_Lio_youi_hypertext_style_ColorProperties.prototype.constructor = $c_Lio_youi_hypertext_style_ColorProperties;
/** @constructor */
function $h_Lio_youi_hypertext_style_ColorProperties() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_style_ColorProperties.prototype = $c_Lio_youi_hypertext_style_ColorProperties.prototype;
$c_Lio_youi_hypertext_style_ColorProperties.prototype.init___D__D__D__D = (function(initialRed, initialGreen, initialBlue, initialAlpha) {
  this.initialRed$1 = initialRed;
  this.initialGreen$1 = initialGreen;
  this.initialBlue$1 = initialBlue;
  this.initialAlpha$1 = initialAlpha;
  this.red$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $this.initialRed$1
    })
  })(this)), false, true, true);
  this.green$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      return this$2.initialGreen$1
    })
  })(this)), false, true, true);
  this.blue$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3) {
    return (function() {
      return this$3.initialBlue$1
    })
  })(this)), false, true, true);
  this.alpha$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4) {
    return (function() {
      return this$4.initialAlpha$1
    })
  })(this)), false, true, true);
  return this
});
$c_Lio_youi_hypertext_style_ColorProperties.prototype.$$colon$eq__Lio_youi_Color__V = (function(c) {
  var this$1 = this.red$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, c$1) {
    return (function() {
      return c$1.red$1
    })
  })(this, c));
  this$1.replace__F0__Z__V(value, true);
  var this$3 = this.green$1;
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2, c$2) {
    return (function() {
      return c$2.green$1
    })
  })(this, c));
  this$3.replace__F0__Z__V(value$1, true);
  var this$4 = this.blue$1;
  var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1, c$3) {
    return (function() {
      return c$3.blue$1
    })
  })(this, c));
  this$4.replace__F0__Z__V(value$2, true);
  var this$5 = this.alpha$1;
  var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1, c$4) {
    return (function() {
      return c$4.alpha$1
    })
  })(this, c));
  this$5.replace__F0__Z__V(value$3, true)
});
$c_Lio_youi_hypertext_style_ColorProperties.prototype.isDefault__Z = (function() {
  var this$1 = this.red$1;
  if (($uD(this$1.get__O()) === this.initialRed$1)) {
    var this$2 = this.green$1;
    var jsx$2 = ($uD(this$2.get__O()) === this.initialGreen$1)
  } else {
    var jsx$2 = false
  };
  if (jsx$2) {
    var this$3 = this.blue$1;
    var jsx$1 = ($uD(this$3.get__O()) === this.initialBlue$1)
  } else {
    var jsx$1 = false
  };
  if (jsx$1) {
    var this$4 = this.alpha$1;
    return ($uD(this$4.get__O()) === this.initialAlpha$1)
  } else {
    return false
  }
});
var $d_Lio_youi_hypertext_style_ColorProperties = new $TypeData().initClass({
  Lio_youi_hypertext_style_ColorProperties: 0
}, false, "io.youi.hypertext.style.ColorProperties", {
  Lio_youi_hypertext_style_ColorProperties: 1,
  O: 1
});
$c_Lio_youi_hypertext_style_ColorProperties.prototype.$classData = $d_Lio_youi_hypertext_style_ColorProperties;
/** @constructor */
function $c_Lio_youi_hypertext_style_ComponentOverflow() {
  $c_O.call(this);
  this.component$1 = null;
  this.x$1 = null;
  this.y$1 = null
}
$c_Lio_youi_hypertext_style_ComponentOverflow.prototype = new $h_O();
$c_Lio_youi_hypertext_style_ComponentOverflow.prototype.constructor = $c_Lio_youi_hypertext_style_ComponentOverflow;
/** @constructor */
function $h_Lio_youi_hypertext_style_ComponentOverflow() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_style_ComponentOverflow.prototype = $c_Lio_youi_hypertext_style_ComponentOverflow.prototype;
$c_Lio_youi_hypertext_style_ComponentOverflow.prototype.init___Lio_youi_hypertext_Component = (function(component) {
  this.component$1 = component;
  var get = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_Lio_youi_hypertext_style_Overflow$Unset$()
    })
  })(this));
  var set = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(o$2) {
      var o = $as_Lio_youi_hypertext_style_Overflow(o$2);
      this$2.component$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.overflowX = o.value$1
    })
  })(this));
  this.x$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(component, get, set, true);
  var get$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3) {
    return (function() {
      return $m_Lio_youi_hypertext_style_Overflow$Unset$()
    })
  })(this));
  var set$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4) {
    return (function(o$3$2) {
      var o$3 = $as_Lio_youi_hypertext_style_Overflow(o$3$2);
      this$4.component$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.overflowY = o$3.value$1
    })
  })(this));
  this.y$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(component, get$1, set$1, true);
  return this
});
var $d_Lio_youi_hypertext_style_ComponentOverflow = new $TypeData().initClass({
  Lio_youi_hypertext_style_ComponentOverflow: 0
}, false, "io.youi.hypertext.style.ComponentOverflow", {
  Lio_youi_hypertext_style_ComponentOverflow: 1,
  O: 1
});
$c_Lio_youi_hypertext_style_ComponentOverflow.prototype.$classData = $d_Lio_youi_hypertext_style_ComponentOverflow;
/** @constructor */
function $c_Lio_youi_hypertext_style_FontProperties() {
  $c_O.call(this);
  this.component$1 = null;
  this.family$1 = null;
  this.style$1 = null;
  this.size$1 = null
}
$c_Lio_youi_hypertext_style_FontProperties.prototype = new $h_O();
$c_Lio_youi_hypertext_style_FontProperties.prototype.constructor = $c_Lio_youi_hypertext_style_FontProperties;
/** @constructor */
function $h_Lio_youi_hypertext_style_FontProperties() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_style_FontProperties.prototype = $c_Lio_youi_hypertext_style_FontProperties.prototype;
$c_Lio_youi_hypertext_style_FontProperties.prototype.init___Lio_youi_hypertext_Component = (function(component) {
  this.component$1 = component;
  var get = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $as_T($this.component$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.fontFamily)
    })
  })(this));
  var set = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(x$1$2) {
      var x$1 = $as_T(x$1$2);
      this$2.component$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.fontFamily = x$1
    })
  })(this));
  this.family$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(component, get, set, true);
  var get$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3) {
    return (function() {
      return $as_T(this$3.component$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.fontStyle)
    })
  })(this));
  var set$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4) {
    return (function(x$2$2) {
      var x$2 = $as_T(x$2$2);
      this$4.component$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.fontStyle = x$2
    })
  })(this));
  this.style$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(component, get$1, set$1, true);
  var get$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5) {
    return (function() {
      return 12.0
    })
  })(this));
  var set$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$6) {
    return (function(d$2) {
      var d = $uD(d$2);
      this$6.component$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.fontSize = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d]))
    })
  })(this));
  this.size$1 = $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var(component, get$2, set$2, true);
  return this
});
var $d_Lio_youi_hypertext_style_FontProperties = new $TypeData().initClass({
  Lio_youi_hypertext_style_FontProperties: 0
}, false, "io.youi.hypertext.style.FontProperties", {
  Lio_youi_hypertext_style_FontProperties: 1,
  O: 1
});
$c_Lio_youi_hypertext_style_FontProperties.prototype.$classData = $d_Lio_youi_hypertext_style_FontProperties;
/** @constructor */
function $c_Lio_youi_hypertext_style_Overflow() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_hypertext_style_Overflow.prototype = new $h_O();
$c_Lio_youi_hypertext_style_Overflow.prototype.constructor = $c_Lio_youi_hypertext_style_Overflow;
/** @constructor */
function $h_Lio_youi_hypertext_style_Overflow() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_style_Overflow.prototype = $c_Lio_youi_hypertext_style_Overflow.prototype;
$c_Lio_youi_hypertext_style_Overflow.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_hypertext_style_Overflow(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_hypertext_style_Overflow)))
}
function $as_Lio_youi_hypertext_style_Overflow(obj) {
  return (($is_Lio_youi_hypertext_style_Overflow(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.hypertext.style.Overflow"))
}
function $isArrayOf_Lio_youi_hypertext_style_Overflow(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_hypertext_style_Overflow)))
}
function $asArrayOf_Lio_youi_hypertext_style_Overflow(obj, depth) {
  return (($isArrayOf_Lio_youi_hypertext_style_Overflow(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.hypertext.style.Overflow;", depth))
}
/** @constructor */
function $c_Lio_youi_hypertext_style_TextOverflow() {
  $c_O.call(this);
  this.value$1 = null
}
$c_Lio_youi_hypertext_style_TextOverflow.prototype = new $h_O();
$c_Lio_youi_hypertext_style_TextOverflow.prototype.constructor = $c_Lio_youi_hypertext_style_TextOverflow;
/** @constructor */
function $h_Lio_youi_hypertext_style_TextOverflow() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_style_TextOverflow.prototype = $c_Lio_youi_hypertext_style_TextOverflow.prototype;
$c_Lio_youi_hypertext_style_TextOverflow.prototype.init___T = (function(value) {
  this.value$1 = value;
  return this
});
function $is_Lio_youi_hypertext_style_TextOverflow(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_hypertext_style_TextOverflow)))
}
function $as_Lio_youi_hypertext_style_TextOverflow(obj) {
  return (($is_Lio_youi_hypertext_style_TextOverflow(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.hypertext.style.TextOverflow"))
}
function $isArrayOf_Lio_youi_hypertext_style_TextOverflow(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_hypertext_style_TextOverflow)))
}
function $asArrayOf_Lio_youi_hypertext_style_TextOverflow(obj, depth) {
  return (($isArrayOf_Lio_youi_hypertext_style_TextOverflow(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.hypertext.style.TextOverflow;", depth))
}
/** @constructor */
function $c_Lio_youi_net_URL$URLParts() {
  $c_O.call(this);
  this.pathAndArgs$1 = null;
  this.asString$1 = null;
  this.encoded$1 = false;
  this.bitmap$0$1 = 0;
  this.$$outer$1 = null
}
$c_Lio_youi_net_URL$URLParts.prototype = new $h_O();
$c_Lio_youi_net_URL$URLParts.prototype.constructor = $c_Lio_youi_net_URL$URLParts;
/** @constructor */
function $h_Lio_youi_net_URL$URLParts() {
  /*<skip>*/
}
$h_Lio_youi_net_URL$URLParts.prototype = $c_Lio_youi_net_URL$URLParts.prototype;
$c_Lio_youi_net_URL$URLParts.prototype.asString__T = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.asString$lzycompute__p1__T() : this.asString$1)
});
$c_Lio_youi_net_URL$URLParts.prototype.toString__T = (function() {
  return this.asString__T()
});
$c_Lio_youi_net_URL$URLParts.prototype.pathAndArgs__T = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.pathAndArgs$lzycompute__p1__T() : this.pathAndArgs$1)
});
$c_Lio_youi_net_URL$URLParts.prototype.asString$lzycompute__p1__T = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.asString$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.$$outer$1.base__T(), this.pathAndArgs__T()]));
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.asString$1
});
$c_Lio_youi_net_URL$URLParts.prototype.init___Lio_youi_net_URL__Z = (function($$outer, encoded) {
  this.encoded$1 = encoded;
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_net_URL$URLParts.prototype.pathAndArgs$lzycompute__p1__T = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    var b = new $c_scm_StringBuilder().init___();
    b.append__O__scm_StringBuilder(this.$$outer$1.path$1);
    b.append__T__scm_StringBuilder((this.encoded$1 ? this.$$outer$1.parameters$1.encoded__T() : this.$$outer$1.parameters$1.decoded__T()));
    var this$1 = b.underlying$5;
    this.pathAndArgs$1 = this$1.content$1;
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.pathAndArgs$1
});
var $d_Lio_youi_net_URL$URLParts = new $TypeData().initClass({
  Lio_youi_net_URL$URLParts: 0
}, false, "io.youi.net.URL$URLParts", {
  Lio_youi_net_URL$URLParts: 1,
  O: 1
});
$c_Lio_youi_net_URL$URLParts.prototype.$classData = $d_Lio_youi_net_URL$URLParts;
/** @constructor */
function $c_Lio_youi_style_Paint$() {
  $c_O.call(this);
  this.canvas$1 = null;
  this.io$youi$style$Paint$$context$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lio_youi_style_Paint$.prototype = new $h_O();
$c_Lio_youi_style_Paint$.prototype.constructor = $c_Lio_youi_style_Paint$;
/** @constructor */
function $h_Lio_youi_style_Paint$() {
  /*<skip>*/
}
$h_Lio_youi_style_Paint$.prototype = $c_Lio_youi_style_Paint$.prototype;
$c_Lio_youi_style_Paint$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_style_Paint$.prototype.canvas$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLCanvasElement = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.canvas$1 = $m_Lio_youi_dom$().create__T__Lorg_scalajs_dom_raw_Element("canvas");
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.canvas$1
});
$c_Lio_youi_style_Paint$.prototype.context$lzycompute__p1__Lorg_scalajs_dom_raw_CanvasRenderingContext2D = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.io$youi$style$Paint$$context$1 = this.canvas__p1__Lorg_scalajs_dom_raw_HTMLCanvasElement().getContext("2d");
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.io$youi$style$Paint$$context$1
});
$c_Lio_youi_style_Paint$.prototype.io$youi$style$Paint$$context__Lorg_scalajs_dom_raw_CanvasRenderingContext2D = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.context$lzycompute__p1__Lorg_scalajs_dom_raw_CanvasRenderingContext2D() : this.io$youi$style$Paint$$context$1)
});
$c_Lio_youi_style_Paint$.prototype.canvas__p1__Lorg_scalajs_dom_raw_HTMLCanvasElement = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.canvas$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLCanvasElement() : this.canvas$1)
});
var $d_Lio_youi_style_Paint$ = new $TypeData().initClass({
  Lio_youi_style_Paint$: 0
}, false, "io.youi.style.Paint$", {
  Lio_youi_style_Paint$: 1,
  O: 1
});
$c_Lio_youi_style_Paint$.prototype.$classData = $d_Lio_youi_style_Paint$;
var $n_Lio_youi_style_Paint$ = (void 0);
function $m_Lio_youi_style_Paint$() {
  if ((!$n_Lio_youi_style_Paint$)) {
    $n_Lio_youi_style_Paint$ = new $c_Lio_youi_style_Paint$().init___()
  };
  return $n_Lio_youi_style_Paint$
}
/** @constructor */
function $c_Lio_youi_style_Theme() {
  $c_O.call(this);
  this.dropShadow$module$1 = null;
  this.font$module$1 = null;
  this.parent$1 = null;
  this.breakWords$1 = null;
  this.fill$1 = null;
  this.letterSpacing$1 = null;
  this.lineHeight$1 = null;
  this.lineJoin$1 = null;
  this.miterLimit$1 = null;
  this.padding$1 = null;
  this.stroke$1 = null;
  this.strokeThickness$1 = null;
  this.textBaseline$1 = null;
  this.wordWrap$1 = null;
  this.interactive$1 = null;
  this.visible$1 = null
}
$c_Lio_youi_style_Theme.prototype = new $h_O();
$c_Lio_youi_style_Theme.prototype.constructor = $c_Lio_youi_style_Theme;
/** @constructor */
function $h_Lio_youi_style_Theme() {
  /*<skip>*/
}
$h_Lio_youi_style_Theme.prototype = $c_Lio_youi_style_Theme.prototype;
$c_Lio_youi_style_Theme.prototype.font$lzycompute$1__p1__V = (function() {
  if ((this.font$module$1 === null)) {
    this.font$module$1 = new $c_Lio_youi_style_Theme$font$().init___Lio_youi_style_Theme(this)
  }
});
$c_Lio_youi_style_Theme.prototype.dropShadow$lzycompute$1__p1__V = (function() {
  if ((this.dropShadow$module$1 === null)) {
    this.dropShadow$module$1 = new $c_Lio_youi_style_Theme$dropShadow$().init___Lio_youi_style_Theme(this)
  }
});
$c_Lio_youi_style_Theme.prototype.init___ = (function() {
  this.parent$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_s_None$()
    })
  })(this)), false, true, true);
  this.breakWords$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      $m_Lreactify_package$();
      var p = this$2.parent$1;
      var this$3 = $as_s_Option(p.get__O());
      if (this$3.isEmpty__Z()) {
        var this$5 = $m_s_None$()
      } else {
        var arg1 = this$3.get__O();
        var x$1 = $as_Lio_youi_style_Theme(arg1);
        var this$4 = x$1.breakWords$1;
        var this$5 = new $c_s_Some().init___O($uZ(this$4.get__O()))
      };
      return $uZ((this$5.isEmpty__Z() ? false : this$5.get__O()))
    })
  })(this)), false, true, true);
  this.fill$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$1 = this$3$1.parent$1;
      var this$7 = $as_s_Option(p$1.get__O());
      if (this$7.isEmpty__Z()) {
        var this$9 = $m_s_None$()
      } else {
        var arg1$1 = this$7.get__O();
        var x$7 = $as_Lio_youi_style_Theme(arg1$1);
        var this$8 = x$7.fill$1;
        var this$9 = new $c_s_Some().init___O($as_Lio_youi_style_Paint(this$8.get__O()))
      };
      if (this$9.isEmpty__Z()) {
        var color = $m_Lio_youi_Color$().Black__Lio_youi_Color();
        var jsx$1 = new $c_Lio_youi_style_ColorPaint().init___Lio_youi_Color(color)
      } else {
        var jsx$1 = this$9.get__O()
      };
      return $as_Lio_youi_style_Paint(jsx$1)
    })
  })(this)), false, true, true);
  this.letterSpacing$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$2 = this$4$1.parent$1;
      var this$13 = $as_s_Option(p$2.get__O());
      if (this$13.isEmpty__Z()) {
        var this$15 = $m_s_None$()
      } else {
        var arg1$2 = this$13.get__O();
        var x$13 = $as_Lio_youi_style_Theme(arg1$2);
        var this$14 = x$13.letterSpacing$1;
        var this$15 = new $c_s_Some().init___O($uD(this$14.get__O()))
      };
      return $uD((this$15.isEmpty__Z() ? 0.0 : this$15.get__O()))
    })
  })(this)), false, true, true);
  this.lineHeight$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$3 = this$5$1.parent$1;
      var this$17 = $as_s_Option(p$3.get__O());
      if (this$17.isEmpty__Z()) {
        var this$19 = $m_s_None$()
      } else {
        var arg1$3 = this$17.get__O();
        var x$14 = $as_Lio_youi_style_Theme(arg1$3);
        var this$18 = x$14.lineHeight$1;
        var this$19 = new $c_s_Some().init___O($uD(this$18.get__O()))
      };
      return $uD((this$19.isEmpty__Z() ? 0.0 : this$19.get__O()))
    })
  })(this)), false, true, true);
  this.lineJoin$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$6$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$4 = this$6$1.parent$1;
      var this$21 = $as_s_Option(p$4.get__O());
      if (this$21.isEmpty__Z()) {
        var this$23 = $m_s_None$()
      } else {
        var arg1$4 = this$21.get__O();
        var x$15 = $as_Lio_youi_style_Theme(arg1$4);
        var this$22 = x$15.lineJoin$1;
        var this$23 = new $c_s_Some().init___O($as_T(this$22.get__O()))
      };
      return $as_T((this$23.isEmpty__Z() ? "miter" : this$23.get__O()))
    })
  })(this)), false, true, true);
  this.miterLimit$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$7$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$5 = this$7$1.parent$1;
      var this$25 = $as_s_Option(p$5.get__O());
      if (this$25.isEmpty__Z()) {
        var this$27 = $m_s_None$()
      } else {
        var arg1$5 = this$25.get__O();
        var x$16 = $as_Lio_youi_style_Theme(arg1$5);
        var this$26 = x$16.miterLimit$1;
        var this$27 = new $c_s_Some().init___O($uD(this$26.get__O()))
      };
      return $uD((this$27.isEmpty__Z() ? 10.0 : this$27.get__O()))
    })
  })(this)), false, true, true);
  this.padding$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$8$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$6 = this$8$1.parent$1;
      var this$29 = $as_s_Option(p$6.get__O());
      if (this$29.isEmpty__Z()) {
        var this$31 = $m_s_None$()
      } else {
        var arg1$6 = this$29.get__O();
        var x$17 = $as_Lio_youi_style_Theme(arg1$6);
        var this$30 = x$17.padding$1;
        var this$31 = new $c_s_Some().init___O($uD(this$30.get__O()))
      };
      return $uD((this$31.isEmpty__Z() ? 0.0 : this$31.get__O()))
    })
  })(this)), false, true, true);
  this.stroke$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$9$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$7 = this$9$1.parent$1;
      var this$33 = $as_s_Option(p$7.get__O());
      if (this$33.isEmpty__Z()) {
        var this$35 = $m_s_None$()
      } else {
        var arg1$7 = this$33.get__O();
        var x$18 = $as_Lio_youi_style_Theme(arg1$7);
        var this$34 = x$18.stroke$1;
        var this$35 = new $c_s_Some().init___O($as_Lio_youi_Color(this$34.get__O()))
      };
      return $as_Lio_youi_Color((this$35.isEmpty__Z() ? $m_Lio_youi_Color$().Clear__Lio_youi_Color() : this$35.get__O()))
    })
  })(this)), false, true, true);
  this.strokeThickness$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$10$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$8 = this$10$1.parent$1;
      var this$37 = $as_s_Option(p$8.get__O());
      if (this$37.isEmpty__Z()) {
        var this$39 = $m_s_None$()
      } else {
        var arg1$8 = this$37.get__O();
        var x$19 = $as_Lio_youi_style_Theme(arg1$8);
        var this$38 = x$19.strokeThickness$1;
        var this$39 = new $c_s_Some().init___O($uD(this$38.get__O()))
      };
      return $uD((this$39.isEmpty__Z() ? 0.0 : this$39.get__O()))
    })
  })(this)), false, true, true);
  this.textBaseline$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$11$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$9 = this$11$1.parent$1;
      var this$41 = $as_s_Option(p$9.get__O());
      if (this$41.isEmpty__Z()) {
        var this$43 = $m_s_None$()
      } else {
        var arg1$9 = this$41.get__O();
        var x$20 = $as_Lio_youi_style_Theme(arg1$9);
        var this$42 = x$20.textBaseline$1;
        var this$43 = new $c_s_Some().init___O($as_T(this$42.get__O()))
      };
      return $as_T((this$43.isEmpty__Z() ? "alphabetic" : this$43.get__O()))
    })
  })(this)), false, true, true);
  this.wordWrap$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$12$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$10 = this$12$1.parent$1;
      var this$45 = $as_s_Option(p$10.get__O());
      if (this$45.isEmpty__Z()) {
        var this$47 = $m_s_None$()
      } else {
        var arg1$10 = this$45.get__O();
        var x$21 = $as_Lio_youi_style_Theme(arg1$10);
        var this$46 = x$21.wordWrap$1;
        var this$47 = new $c_s_Some().init___O($uZ(this$46.get__O()))
      };
      return $uZ((this$47.isEmpty__Z() ? false : this$47.get__O()))
    })
  })(this)), false, true, true);
  this.interactive$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$13$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$11 = this$13$1.parent$1;
      var this$49 = $as_s_Option(p$11.get__O());
      if (this$49.isEmpty__Z()) {
        var this$51 = $m_s_None$()
      } else {
        var arg1$11 = this$49.get__O();
        var x$22 = $as_Lio_youi_style_Theme(arg1$11);
        var this$50 = x$22.interactive$1;
        var this$51 = new $c_s_Some().init___O($uZ(this$50.get__O()))
      };
      return $uZ((this$51.isEmpty__Z() || this$51.get__O()))
    })
  })(this)), false, true, true);
  this.visible$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$14$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$12 = this$14$1.parent$1;
      var this$53 = $as_s_Option(p$12.get__O());
      if (this$53.isEmpty__Z()) {
        var this$55 = $m_s_None$()
      } else {
        var arg1$12 = this$53.get__O();
        var x$23 = $as_Lio_youi_style_Theme(arg1$12);
        var this$54 = x$23.visible$1;
        var this$55 = new $c_s_Some().init___O($uZ(this$54.get__O()))
      };
      return $uZ((this$55.isEmpty__Z() || this$55.get__O()))
    })
  })(this)), false, true, true);
  return this
});
$c_Lio_youi_style_Theme.prototype.dropShadow__Lio_youi_style_Theme$dropShadow$ = (function() {
  if ((this.dropShadow$module$1 === null)) {
    this.dropShadow$lzycompute$1__p1__V()
  };
  return this.dropShadow$module$1
});
$c_Lio_youi_style_Theme.prototype.init___Lio_youi_style_Theme = (function(parent) {
  $c_Lio_youi_style_Theme.prototype.init___.call(this);
  var this$1 = this.parent$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, parent$1) {
    return (function() {
      return new $c_s_Some().init___O(parent$1)
    })
  })(this, parent));
  this$1.replace__F0__Z__V(value, true);
  return this
});
$c_Lio_youi_style_Theme.prototype.font__Lio_youi_style_Theme$font$ = (function() {
  if ((this.font$module$1 === null)) {
    this.font$lzycompute$1__p1__V()
  };
  return this.font$module$1
});
function $is_Lio_youi_style_Theme(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_style_Theme)))
}
function $as_Lio_youi_style_Theme(obj) {
  return (($is_Lio_youi_style_Theme(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.style.Theme"))
}
function $isArrayOf_Lio_youi_style_Theme(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_style_Theme)))
}
function $asArrayOf_Lio_youi_style_Theme(obj, depth) {
  return (($isArrayOf_Lio_youi_style_Theme(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.style.Theme;", depth))
}
/** @constructor */
function $c_Lio_youi_style_Theme$dropShadow$() {
  $c_O.call(this);
  this.enabled$1 = null;
  this.angle$1 = null;
  this.blur$1 = null;
  this.color$1 = null;
  this.distance$1 = null;
  this.$$outer$1 = null
}
$c_Lio_youi_style_Theme$dropShadow$.prototype = new $h_O();
$c_Lio_youi_style_Theme$dropShadow$.prototype.constructor = $c_Lio_youi_style_Theme$dropShadow$;
/** @constructor */
function $h_Lio_youi_style_Theme$dropShadow$() {
  /*<skip>*/
}
$h_Lio_youi_style_Theme$dropShadow$.prototype = $c_Lio_youi_style_Theme$dropShadow$.prototype;
$c_Lio_youi_style_Theme$dropShadow$.prototype.init___Lio_youi_style_Theme = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  this.enabled$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $m_Lreactify_package$();
      var p = $this.$$outer$1.parent$1;
      var this$2 = $as_s_Option(p.get__O());
      if (this$2.isEmpty__Z()) {
        var this$4 = $m_s_None$()
      } else {
        var arg1 = this$2.get__O();
        var x$2 = $as_Lio_youi_style_Theme(arg1);
        var this$3 = x$2.dropShadow__Lio_youi_style_Theme$dropShadow$().enabled$1;
        var this$4 = new $c_s_Some().init___O($uZ(this$3.get__O()))
      };
      return $uZ((this$4.isEmpty__Z() ? false : this$4.get__O()))
    })
  })(this)), false, true, true);
  this.angle$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$1 = this$2$1.$$outer$1.parent$1;
      var this$6 = $as_s_Option(p$1.get__O());
      if (this$6.isEmpty__Z()) {
        var this$8 = $m_s_None$()
      } else {
        var arg1$1 = this$6.get__O();
        var x$3 = $as_Lio_youi_style_Theme(arg1$1);
        var this$7 = x$3.dropShadow__Lio_youi_style_Theme$dropShadow$().angle$1;
        var this$8 = new $c_s_Some().init___O($uD(this$7.get__O()))
      };
      return $uD((this$8.isEmpty__Z() ? 0.0 : this$8.get__O()))
    })
  })(this)), false, true, true);
  this.blur$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$2 = this$3$1.$$outer$1.parent$1;
      var this$10 = $as_s_Option(p$2.get__O());
      if (this$10.isEmpty__Z()) {
        var this$12 = $m_s_None$()
      } else {
        var arg1$2 = this$10.get__O();
        var x$4 = $as_Lio_youi_style_Theme(arg1$2);
        var this$11 = x$4.dropShadow__Lio_youi_style_Theme$dropShadow$().blur$1;
        var this$12 = new $c_s_Some().init___O($uD(this$11.get__O()))
      };
      return $uD((this$12.isEmpty__Z() ? 0.0 : this$12.get__O()))
    })
  })(this)), false, true, true);
  this.color$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$3 = this$4$1.$$outer$1.parent$1;
      var this$14 = $as_s_Option(p$3.get__O());
      if (this$14.isEmpty__Z()) {
        var this$16 = $m_s_None$()
      } else {
        var arg1$3 = this$14.get__O();
        var x$5 = $as_Lio_youi_style_Theme(arg1$3);
        var this$15 = x$5.dropShadow__Lio_youi_style_Theme$dropShadow$().color$1;
        var this$16 = new $c_s_Some().init___O($as_Lio_youi_Color(this$15.get__O()))
      };
      return $as_Lio_youi_Color((this$16.isEmpty__Z() ? $m_Lio_youi_Color$().Black__Lio_youi_Color() : this$16.get__O()))
    })
  })(this)), false, true, true);
  this.distance$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$4 = this$5$1.$$outer$1.parent$1;
      var this$18 = $as_s_Option(p$4.get__O());
      if (this$18.isEmpty__Z()) {
        var this$20 = $m_s_None$()
      } else {
        var arg1$4 = this$18.get__O();
        var x$6 = $as_Lio_youi_style_Theme(arg1$4);
        var this$19 = x$6.dropShadow__Lio_youi_style_Theme$dropShadow$().distance$1;
        var this$20 = new $c_s_Some().init___O($uD(this$19.get__O()))
      };
      return $uD((this$20.isEmpty__Z() ? 0.0 : this$20.get__O()))
    })
  })(this)), false, true, true);
  return this
});
var $d_Lio_youi_style_Theme$dropShadow$ = new $TypeData().initClass({
  Lio_youi_style_Theme$dropShadow$: 0
}, false, "io.youi.style.Theme$dropShadow$", {
  Lio_youi_style_Theme$dropShadow$: 1,
  O: 1
});
$c_Lio_youi_style_Theme$dropShadow$.prototype.$classData = $d_Lio_youi_style_Theme$dropShadow$;
/** @constructor */
function $c_Lio_youi_style_Theme$font$() {
  $c_O.call(this);
  this.family$1 = null;
  this.size$1 = null;
  this.style$1 = null;
  this.variant$1 = null;
  this.weight$1 = null;
  this.$$outer$1 = null
}
$c_Lio_youi_style_Theme$font$.prototype = new $h_O();
$c_Lio_youi_style_Theme$font$.prototype.constructor = $c_Lio_youi_style_Theme$font$;
/** @constructor */
function $h_Lio_youi_style_Theme$font$() {
  /*<skip>*/
}
$h_Lio_youi_style_Theme$font$.prototype = $c_Lio_youi_style_Theme$font$.prototype;
$c_Lio_youi_style_Theme$font$.prototype.init___Lio_youi_style_Theme = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  this.family$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      $m_Lreactify_package$();
      var p = $this.$$outer$1.parent$1;
      var this$2 = $as_s_Option(p.get__O());
      if (this$2.isEmpty__Z()) {
        var this$4 = $m_s_None$()
      } else {
        var arg1 = this$2.get__O();
        var x$8 = $as_Lio_youi_style_Theme(arg1);
        var this$3 = x$8.font__Lio_youi_style_Theme$font$().family$1;
        var this$4 = new $c_s_Some().init___O($as_T(this$3.get__O()))
      };
      return $as_T((this$4.isEmpty__Z() ? "Arial" : this$4.get__O()))
    })
  })(this)), false, true, true);
  this.size$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$1 = this$2$1.$$outer$1.parent$1;
      var this$6 = $as_s_Option(p$1.get__O());
      if (this$6.isEmpty__Z()) {
        var this$8 = $m_s_None$()
      } else {
        var arg1$1 = this$6.get__O();
        var x$9 = $as_Lio_youi_style_Theme(arg1$1);
        var this$7 = x$9.font__Lio_youi_style_Theme$font$().size$1;
        var this$8 = new $c_s_Some().init___O($uD(this$7.get__O()))
      };
      return $uD((this$8.isEmpty__Z() ? 26.0 : this$8.get__O()))
    })
  })(this)), false, true, true);
  this.style$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$2 = this$3$1.$$outer$1.parent$1;
      var this$10 = $as_s_Option(p$2.get__O());
      if (this$10.isEmpty__Z()) {
        var this$12 = $m_s_None$()
      } else {
        var arg1$2 = this$10.get__O();
        var x$10 = $as_Lio_youi_style_Theme(arg1$2);
        var this$11 = x$10.font__Lio_youi_style_Theme$font$().style$1;
        var this$12 = new $c_s_Some().init___O($as_T(this$11.get__O()))
      };
      return $as_T((this$12.isEmpty__Z() ? "normal" : this$12.get__O()))
    })
  })(this)), false, true, true);
  this.variant$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$3 = this$4$1.$$outer$1.parent$1;
      var this$14 = $as_s_Option(p$3.get__O());
      if (this$14.isEmpty__Z()) {
        var this$16 = $m_s_None$()
      } else {
        var arg1$3 = this$14.get__O();
        var x$11 = $as_Lio_youi_style_Theme(arg1$3);
        var this$15 = x$11.font__Lio_youi_style_Theme$font$().variant$1;
        var this$16 = new $c_s_Some().init___O($as_T(this$15.get__O()))
      };
      return $as_T((this$16.isEmpty__Z() ? "normal" : this$16.get__O()))
    })
  })(this)), false, true, true);
  this.weight$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1) {
    return (function() {
      $m_Lreactify_package$();
      var p$4 = this$5$1.$$outer$1.parent$1;
      var this$18 = $as_s_Option(p$4.get__O());
      if (this$18.isEmpty__Z()) {
        var this$20 = $m_s_None$()
      } else {
        var arg1$4 = this$18.get__O();
        var x$12 = $as_Lio_youi_style_Theme(arg1$4);
        var this$19 = x$12.font__Lio_youi_style_Theme$font$().weight$1;
        var this$20 = new $c_s_Some().init___O($as_T(this$19.get__O()))
      };
      return $as_T((this$20.isEmpty__Z() ? "normal" : this$20.get__O()))
    })
  })(this)), false, true, true);
  return this
});
var $d_Lio_youi_style_Theme$font$ = new $TypeData().initClass({
  Lio_youi_style_Theme$font$: 0
}, false, "io.youi.style.Theme$font$", {
  Lio_youi_style_Theme$font$: 1,
  O: 1
});
$c_Lio_youi_style_Theme$font$.prototype.$classData = $d_Lio_youi_style_Theme$font$;
function $f_Lio_youi_workflow_Temporal__io$youi$workflow$Temporal$$$anonfun$run$1__D__s_concurrent_Promise__sr_ObjectRef__sr_DoubleRef__sr_DoubleRef__V($thiz, delta, promise$1, listener$1, elapsed$1, step$1) {
  elapsed$1.elem$1 = (elapsed$1.elem$1 + delta);
  step$1.elem$1 = (step$1.elem$1 + delta);
  if ((step$1.elem$1 >= 0.0)) {
    var elapsed = elapsed$1.elem$1;
    var x1 = $f_Lio_youi_workflow_DurationTemporal__update__D__D__Lio_youi_workflow_Conclusion($thiz, delta, elapsed);
    var x = $m_Lio_youi_workflow_Conclusion$Continue$();
    if ((!(x === x1))) {
      var x$3 = $m_Lio_youi_workflow_Conclusion$Finished$();
      if ((x$3 === x1)) {
        $m_Lio_youi_AnimationFrame$().delta__Lreactify_Channel().detach__Lreactify_Listener__V($as_Lreactify_Listener(listener$1.elem$1));
        $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$1, (void 0))
      } else {
        throw new $c_s_MatchError().init___O(x1)
      }
    };
    step$1.elem$1 = 0.0
  }
}
function $f_Lio_youi_workflow_Temporal__run__s_concurrent_Future($thiz) {
  var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
  var listener = new $c_sr_ObjectRef().init___O(null);
  var elapsed = new $c_sr_DoubleRef().init___D(0.0);
  var step = new $c_sr_DoubleRef().init___D(0.0);
  listener.elem$1 = new $c_Lio_youi_workflow_Temporal$$anonfun$run$2().init___Lio_youi_workflow_Temporal__s_concurrent_Promise__sr_ObjectRef__sr_DoubleRef__sr_DoubleRef($thiz, promise, listener, elapsed, step);
  var this$5 = $m_Lio_youi_AnimationFrame$().delta__Lreactify_Channel();
  var listener$1 = $as_Lreactify_Listener(listener.elem$1);
  $f_Lreactify_Observable__observe__Lreactify_Listener__Lreactify_Listener(this$5, listener$1);
  return promise
}
/** @constructor */
function $c_Lio_youi_workflow_package$() {
  $c_O.call(this)
}
$c_Lio_youi_workflow_package$.prototype = new $h_O();
$c_Lio_youi_workflow_package$.prototype.constructor = $c_Lio_youi_workflow_package$;
/** @constructor */
function $h_Lio_youi_workflow_package$() {
  /*<skip>*/
}
$h_Lio_youi_workflow_package$.prototype = $c_Lio_youi_workflow_package$.prototype;
$c_Lio_youi_workflow_package$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_workflow_package$.prototype.synchronous__F0__Lio_youi_workflow_Action = (function(f) {
  var f$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, f$1) {
    return (function() {
      f$1.apply__O();
      return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
    })
  })(this, f));
  return new $c_Lio_youi_workflow_Action().init___F0(f$2)
});
var $d_Lio_youi_workflow_package$ = new $TypeData().initClass({
  Lio_youi_workflow_package$: 0
}, false, "io.youi.workflow.package$", {
  Lio_youi_workflow_package$: 1,
  O: 1
});
$c_Lio_youi_workflow_package$.prototype.$classData = $d_Lio_youi_workflow_package$;
var $n_Lio_youi_workflow_package$ = (void 0);
function $m_Lio_youi_workflow_package$() {
  if ((!$n_Lio_youi_workflow_package$)) {
    $n_Lio_youi_workflow_package$ = new $c_Lio_youi_workflow_package$().init___()
  };
  return $n_Lio_youi_workflow_package$
}
/** @constructor */
function $c_Lio_youi_workflow_package$StateChannelWorkflow() {
  $c_O.call(this);
  this.state$1 = null
}
$c_Lio_youi_workflow_package$StateChannelWorkflow.prototype = new $h_O();
$c_Lio_youi_workflow_package$StateChannelWorkflow.prototype.constructor = $c_Lio_youi_workflow_package$StateChannelWorkflow;
/** @constructor */
function $h_Lio_youi_workflow_package$StateChannelWorkflow() {
  /*<skip>*/
}
$h_Lio_youi_workflow_package$StateChannelWorkflow.prototype = $c_Lio_youi_workflow_package$StateChannelWorkflow.prototype;
$c_Lio_youi_workflow_package$StateChannelWorkflow.prototype.init___Lreactify_StateChannel = (function(state) {
  this.state$1 = state;
  return this
});
$c_Lio_youi_workflow_package$StateChannelWorkflow.prototype.to__F0__Lio_youi_workflow_PartialAnimate = (function(destination) {
  return new $c_Lio_youi_workflow_PartialAnimate().init___F0__F1__F0(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $uD($this.state$1.apply__O())
    })
  })(this)), new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(d$2) {
      var d = $uD(d$2);
      var this$1 = this$2.state$1;
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, d$1) {
        return (function() {
          return d$1
        })
      })(this$2, d));
      this$1.set__F0__V(value)
    })
  })(this)), destination)
});
var $d_Lio_youi_workflow_package$StateChannelWorkflow = new $TypeData().initClass({
  Lio_youi_workflow_package$StateChannelWorkflow: 0
}, false, "io.youi.workflow.package$StateChannelWorkflow", {
  Lio_youi_workflow_package$StateChannelWorkflow: 1,
  O: 1
});
$c_Lio_youi_workflow_package$StateChannelWorkflow.prototype.$classData = $d_Lio_youi_workflow_package$StateChannelWorkflow;
/** @constructor */
function $c_Ljava_math_BigInteger$QuotAndRem() {
  $c_O.call(this);
  this.quot$1 = null;
  this.rem$1 = null
}
$c_Ljava_math_BigInteger$QuotAndRem.prototype = new $h_O();
$c_Ljava_math_BigInteger$QuotAndRem.prototype.constructor = $c_Ljava_math_BigInteger$QuotAndRem;
/** @constructor */
function $h_Ljava_math_BigInteger$QuotAndRem() {
  /*<skip>*/
}
$h_Ljava_math_BigInteger$QuotAndRem.prototype = $c_Ljava_math_BigInteger$QuotAndRem.prototype;
$c_Ljava_math_BigInteger$QuotAndRem.prototype.toArray__ALjava_math_BigInteger = (function() {
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.quot$1, this.rem$1]);
  var len = $uI(xs.array$6.length);
  var array = $newArrayObject($d_Ljava_math_BigInteger.getArrayOf(), [len]);
  var elem$1 = 0;
  elem$1 = 0;
  var this$4 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
  while (this$4.hasNext__Z()) {
    var arg1 = this$4.next__O();
    array.set(elem$1, arg1);
    elem$1 = ((1 + elem$1) | 0)
  };
  return array
});
$c_Ljava_math_BigInteger$QuotAndRem.prototype.init___Ljava_math_BigInteger__Ljava_math_BigInteger = (function(quot, rem) {
  this.quot$1 = quot;
  this.rem$1 = rem;
  return this
});
var $d_Ljava_math_BigInteger$QuotAndRem = new $TypeData().initClass({
  Ljava_math_BigInteger$QuotAndRem: 0
}, false, "java.math.BigInteger$QuotAndRem", {
  Ljava_math_BigInteger$QuotAndRem: 1,
  O: 1
});
$c_Ljava_math_BigInteger$QuotAndRem.prototype.$classData = $d_Ljava_math_BigInteger$QuotAndRem;
/** @constructor */
function $c_Ljava_math_BitLevel$() {
  $c_O.call(this)
}
$c_Ljava_math_BitLevel$.prototype = new $h_O();
$c_Ljava_math_BitLevel$.prototype.constructor = $c_Ljava_math_BitLevel$;
/** @constructor */
function $h_Ljava_math_BitLevel$() {
  /*<skip>*/
}
$h_Ljava_math_BitLevel$.prototype = $c_Ljava_math_BitLevel$.prototype;
$c_Ljava_math_BitLevel$.prototype.init___ = (function() {
  return this
});
$c_Ljava_math_BitLevel$.prototype.shiftLeftOneBit__AI__AI__I__V = (function(result, source, srcLen) {
  var elem$1 = 0;
  elem$1 = 0;
  var isEmpty$4 = (srcLen <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + srcLen) | 0);
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      var iVal = source.get(v1);
      result.set(v1, ((iVal << 1) | elem$1));
      elem$1 = ((iVal >>> 31) | 0);
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  if ((elem$1 !== 0)) {
    result.set(srcLen, elem$1)
  }
});
$c_Ljava_math_BitLevel$.prototype.shiftLeft__Ljava_math_BigInteger__I__Ljava_math_BigInteger = (function(source, count) {
  var intCount = (count >> 5);
  var andCount = (31 & count);
  var offset = ((andCount === 0) ? 0 : 1);
  var resLength = ((((source.numberLength$2 + intCount) | 0) + offset) | 0);
  var resDigits = $newArrayObject($d_I.getArrayOf(), [resLength]);
  this.shiftLeft__AI__AI__I__I__V(resDigits, source.digits$2, intCount, andCount);
  var result = new $c_Ljava_math_BigInteger().init___I__I__AI(source.sign$2, resLength, resDigits);
  result.cutOffLeadingZeroes__V();
  return result
});
$c_Ljava_math_BitLevel$.prototype.shiftRight__Ljava_math_BigInteger__I__Ljava_math_BigInteger = (function(source, count) {
  var intCount = (count >> 5);
  var andCount = (31 & count);
  if ((intCount >= source.numberLength$2)) {
    return ((source.sign$2 < 0) ? $m_Ljava_math_BigInteger$().MINUS$undONE$1 : $m_Ljava_math_BigInteger$().ZERO$1)
  } else {
    var resLength = ((source.numberLength$2 - intCount) | 0);
    var resDigits = $newArrayObject($d_I.getArrayOf(), [((1 + resLength) | 0)]);
    this.shiftRight__AI__I__AI__I__I__Z(resDigits, resLength, source.digits$2, intCount, andCount);
    if ((source.sign$2 < 0)) {
      var i = 0;
      while (((i < intCount) && (source.digits$2.get(i) === 0))) {
        i = ((1 + i) | 0)
      };
      var cmp = ((source.digits$2.get(i) << ((32 - andCount) | 0)) !== 0);
      if (((i < intCount) || ((andCount > 0) && cmp))) {
        i = 0;
        while (((i < resLength) && (resDigits.get(i) === (-1)))) {
          resDigits.set(i, 0);
          i = ((1 + i) | 0)
        };
        if ((i === resLength)) {
          resLength = ((1 + resLength) | 0)
        };
        var ev$6 = i;
        resDigits.set(ev$6, ((1 + resDigits.get(ev$6)) | 0))
      }
    };
    var result = new $c_Ljava_math_BigInteger().init___I__I__AI(source.sign$2, resLength, resDigits);
    result.cutOffLeadingZeroes__V();
    return result
  }
});
$c_Ljava_math_BitLevel$.prototype.shiftLeftOneBit__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(source) {
  var srcLen = source.numberLength$2;
  var resLen = ((1 + srcLen) | 0);
  var resDigits = $newArrayObject($d_I.getArrayOf(), [resLen]);
  this.shiftLeftOneBit__AI__AI__I__V(resDigits, source.digits$2, srcLen);
  var result = new $c_Ljava_math_BigInteger().init___I__I__AI(source.sign$2, resLen, resDigits);
  result.cutOffLeadingZeroes__V();
  return result
});
$c_Ljava_math_BitLevel$.prototype.bitLength__Ljava_math_BigInteger__I = (function(bi) {
  if ((bi.sign$2 === 0)) {
    return 0
  } else {
    var bLength = (bi.numberLength$2 << 5);
    var highDigit = bi.digits$2.get((((-1) + bi.numberLength$2) | 0));
    if ((bi.sign$2 < 0)) {
      var i = bi.getFirstNonzeroDigit__I();
      if ((i === (((-1) + bi.numberLength$2) | 0))) {
        highDigit = (((-1) + highDigit) | 0)
      }
    };
    bLength = ((bLength - $clz32(highDigit)) | 0);
    return bLength
  }
});
$c_Ljava_math_BitLevel$.prototype.shiftRight__AI__I__AI__I__I__Z = (function(result, resultLen, source, intCount, count) {
  var i = 0;
  var allZero = true;
  while ((i < intCount)) {
    allZero = (!(!(allZero & (source.get(i) === 0))));
    i = ((1 + i) | 0)
  };
  if ((count === 0)) {
    $systemArraycopy(source, intCount, result, 0, resultLen)
  } else {
    var leftShiftCount = ((32 - count) | 0);
    allZero = (!(!(allZero & ((source.get(i) << leftShiftCount) === 0))));
    i = 0;
    while ((i < (((-1) + resultLen) | 0))) {
      result.set(i, (((source.get(((i + intCount) | 0)) >>> count) | 0) | (source.get(((1 + ((i + intCount) | 0)) | 0)) << leftShiftCount)));
      i = ((1 + i) | 0)
    };
    result.set(i, ((source.get(((i + intCount) | 0)) >>> count) | 0));
    i = ((1 + i) | 0)
  };
  return allZero
});
$c_Ljava_math_BitLevel$.prototype.shiftLeft__AI__AI__I__I__V = (function(result, source, intCount, count) {
  if ((count === 0)) {
    $systemArraycopy(source, 0, result, intCount, ((result.u.length - intCount) | 0))
  } else {
    var rightShiftCount = ((32 - count) | 0);
    result.set((((-1) + result.u.length) | 0), 0);
    var i = (((-1) + result.u.length) | 0);
    while ((i > intCount)) {
      var ev$5 = i;
      result.set(ev$5, (result.get(ev$5) | ((source.get((((-1) + ((i - intCount) | 0)) | 0)) >>> rightShiftCount) | 0)));
      result.set((((-1) + i) | 0), (source.get((((-1) + ((i - intCount) | 0)) | 0)) << count));
      i = (((-1) + i) | 0)
    }
  };
  var isEmpty$4 = (intCount <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + intCount) | 0);
  if ((!isEmpty$4)) {
    var i$1 = 0;
    while (true) {
      var v1 = i$1;
      result.set(v1, 0);
      if ((i$1 === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i$1 = ((1 + i$1) | 0)
    }
  }
});
var $d_Ljava_math_BitLevel$ = new $TypeData().initClass({
  Ljava_math_BitLevel$: 0
}, false, "java.math.BitLevel$", {
  Ljava_math_BitLevel$: 1,
  O: 1
});
$c_Ljava_math_BitLevel$.prototype.$classData = $d_Ljava_math_BitLevel$;
var $n_Ljava_math_BitLevel$ = (void 0);
function $m_Ljava_math_BitLevel$() {
  if ((!$n_Ljava_math_BitLevel$)) {
    $n_Ljava_math_BitLevel$ = new $c_Ljava_math_BitLevel$().init___()
  };
  return $n_Ljava_math_BitLevel$
}
/** @constructor */
function $c_Ljava_math_Conversion$() {
  $c_O.call(this);
  this.DigitFitInInt$1 = null;
  this.BigRadices$1 = null
}
$c_Ljava_math_Conversion$.prototype = new $h_O();
$c_Ljava_math_Conversion$.prototype.constructor = $c_Ljava_math_Conversion$;
/** @constructor */
function $h_Ljava_math_Conversion$() {
  /*<skip>*/
}
$h_Ljava_math_Conversion$.prototype = $c_Ljava_math_Conversion$.prototype;
$c_Ljava_math_Conversion$.prototype.init___ = (function() {
  $n_Ljava_math_Conversion$ = this;
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([(-1), (-1), 31, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5]);
  var len = $uI(xs.array$6.length);
  var array = $newArrayObject($d_I.getArrayOf(), [len]);
  var elem$1 = 0;
  elem$1 = 0;
  var this$5 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs, 0, $uI(xs.array$6.length));
  while (this$5.hasNext__Z()) {
    var arg1 = this$5.next__O();
    array.set(elem$1, $uI(arg1));
    elem$1 = ((1 + elem$1) | 0)
  };
  this.DigitFitInInt$1 = array;
  var xs$1 = new $c_sjs_js_WrappedArray().init___sjs_js_Array([(-2147483648), 1162261467, 1073741824, 1220703125, 362797056, 1977326743, 1073741824, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 268435456, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 1073741824, 1291467969, 1544804416, 1838265625, 60466176]);
  var len$1 = $uI(xs$1.array$6.length);
  var array$1 = $newArrayObject($d_I.getArrayOf(), [len$1]);
  var elem$1$1 = 0;
  elem$1$1 = 0;
  var this$10 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(xs$1, 0, $uI(xs$1.array$6.length));
  while (this$10.hasNext__Z()) {
    var arg1$1 = this$10.next__O();
    array$1.set(elem$1$1, $uI(arg1$1));
    elem$1$1 = ((1 + elem$1$1) | 0)
  };
  this.BigRadices$1 = array$1;
  return this
});
$c_Ljava_math_Conversion$.prototype.toDecimalScaledString__J__I__T = (function(value, scale) {
  if (((value.lo$2 === 0) && (value.hi$2 === 0))) {
    switch (scale) {
      case 0: {
        return "0";
        break
      }
      case 1: {
        return "0.0";
        break
      }
      case 2: {
        return "0.00";
        break
      }
      case 3: {
        return "0.000";
        break
      }
      case 4: {
        return "0.0000";
        break
      }
      case 5: {
        return "0.00000";
        break
      }
      case 6: {
        return "0.000000";
        break
      }
      default: {
        if ((scale === (-2147483648))) {
          var scaleVal = "2147483648"
        } else {
          var i = ((-scale) | 0);
          var scaleVal = ("" + i)
        };
        var result = ((scale < 0) ? "0E+" : "0E");
        return (result + scaleVal)
      }
    }
  } else {
    var ahi = value.hi$2;
    var negNumber = (ahi < 0);
    var elem$1 = null;
    elem$1 = "";
    var currentChar = 18;
    if (negNumber) {
      var lo = value.lo$2;
      var hi = value.hi$2;
      var lo$1 = ((-lo) | 0);
      var hi$1 = ((lo !== 0) ? (~hi) : ((-hi) | 0));
      var x_$_lo$2 = lo$1;
      var x_$_hi$2 = hi$1;
      var t = new $c_sjsr_RuntimeLong().init___I__I(x_$_lo$2, x_$_hi$2)
    } else {
      var t = value
    };
    var lo$2 = t.lo$2;
    var hi$2 = t.hi$2;
    var v_$_lo$2 = lo$2;
    var v_$_hi$2 = hi$2;
    while (true) {
      var prev_$_lo$2 = v_$_lo$2;
      var prev_$_hi$2 = v_$_hi$2;
      var this$5_$_lo$2 = v_$_lo$2;
      var this$5_$_hi$2 = v_$_hi$2;
      var this$6 = $m_sjsr_RuntimeLong$();
      var lo$3 = this$6.divideImpl__I__I__I__I__I(this$5_$_lo$2, this$5_$_hi$2, 10, 0);
      var hi$3 = this$6.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
      var jsx$1_$_lo$2 = lo$3;
      var jsx$1_$_hi$2 = hi$3;
      v_$_lo$2 = jsx$1_$_lo$2;
      v_$_hi$2 = jsx$1_$_hi$2;
      currentChar = (((-1) + currentChar) | 0);
      var b_$_lo$2 = v_$_lo$2;
      var b_$_hi$2 = v_$_hi$2;
      var blo = b_$_lo$2;
      var b0 = (65535 & blo);
      var b1 = ((blo >>> 16) | 0);
      var a0b0 = $imul(10, b0);
      var a0b1 = $imul(10, b1);
      var lo$4 = ((a0b0 + (a0b1 << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (($imul(10, b_$_hi$2) + ((c1part >>> 16) | 0)) | 0);
      var alo = prev_$_lo$2;
      var ahi$1 = prev_$_hi$2;
      var lo$5 = ((alo - lo$4) | 0);
      var hi$5 = ((((-2147483648) ^ lo$5) > ((-2147483648) ^ alo)) ? (((-1) + ((ahi$1 - hi$4) | 0)) | 0) : ((ahi$1 - hi$4) | 0));
      var lo$6 = ((48 + lo$5) | 0);
      var c = (65535 & lo$6);
      elem$1 = (("" + new $c_jl_Character().init___C(c)) + $as_T(elem$1));
      var this$11_$_lo$2 = v_$_lo$2;
      var this$11_$_hi$2 = v_$_hi$2;
      if ((!((this$11_$_lo$2 === 0) && (this$11_$_hi$2 === 0)))) {
        /*<skip>*/
      } else {
        break
      }
    };
    var exponent = (((-1) + ((((18 - currentChar) | 0) - scale) | 0)) | 0);
    if (((scale > 0) && (exponent >= (-6)))) {
      var index = ((1 + exponent) | 0);
      if ((index > 0)) {
        var thiz = $as_T(elem$1);
        var jsx$2 = $as_T(thiz.substring(0, index));
        var thiz$1 = $as_T(elem$1);
        elem$1 = ((jsx$2 + ".") + $as_T(thiz$1.substring(index)))
      } else {
        var end = ((-index) | 0);
        var isEmpty$4 = (end <= 0);
        var scala$collection$immutable$Range$$lastElement$4 = (((-1) + end) | 0);
        if ((!isEmpty$4)) {
          var i$1 = 0;
          while (true) {
            var v1 = i$1;
            elem$1 = (("" + new $c_jl_Character().init___C(48)) + $as_T(elem$1));
            if ((i$1 === scala$collection$immutable$Range$$lastElement$4)) {
              break
            };
            i$1 = ((1 + i$1) | 0)
          }
        };
        elem$1 = ("0." + $as_T(elem$1))
      }
    } else if ((scale !== 0)) {
      var result1 = ("" + exponent);
      if ((exponent > 0)) {
        result1 = (("" + new $c_jl_Character().init___C(43)) + result1)
      };
      result1 = (("" + new $c_jl_Character().init___C(69)) + result1);
      if ((((18 - currentChar) | 0) > 1)) {
        var x$1 = $as_T(elem$1);
        var c$1 = (65535 & $uI(x$1.charCodeAt(0)));
        var jsx$3 = new $c_jl_Character().init___C(c$1);
        var thiz$2 = $as_T(elem$1);
        elem$1 = (((jsx$3 + ".") + $as_T(thiz$2.substring(1))) + result1)
      } else {
        elem$1 = (("" + $as_T(elem$1)) + result1)
      }
    };
    return (negNumber ? (("" + new $c_jl_Character().init___C(45)) + $as_T(elem$1)) : $as_T(elem$1))
  }
});
$c_Ljava_math_Conversion$.prototype.dropLeadingZeros__p1__T__T = (function(s) {
  var zeroPrefixLength = 0;
  var len = $uI(s.length);
  while (true) {
    if ((zeroPrefixLength < len)) {
      var index = zeroPrefixLength;
      var jsx$1 = ((65535 & $uI(s.charCodeAt(index))) === 48)
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      zeroPrefixLength = ((1 + zeroPrefixLength) | 0)
    } else {
      break
    }
  };
  var beginIndex = zeroPrefixLength;
  return $as_T(s.substring(beginIndex))
});
$c_Ljava_math_Conversion$.prototype.toDecimalScaledString__Ljava_math_BigInteger__T = (function(bi) {
  var sign = bi.sign$2;
  var numberLength = bi.numberLength$2;
  var digits = bi.digits$2;
  if ((sign === 0)) {
    return "0"
  } else if ((numberLength === 1)) {
    var i = digits.get(0);
    var x = $uD((i >>> 0));
    var jsx$1 = x.toString(10);
    var absStr = $as_T(jsx$1);
    return ((sign < 0) ? ("-" + absStr) : absStr)
  } else {
    var result = "";
    var temp = $newArrayObject($d_I.getArrayOf(), [numberLength]);
    var tempLen = numberLength;
    $systemArraycopy(digits, 0, temp, 0, tempLen);
    do {
      var rem = 0;
      var i$1 = (((-1) + tempLen) | 0);
      while ((i$1 >= 0)) {
        var value = rem;
        var value$1 = temp.get(i$1);
        var this$8 = $m_sjsr_RuntimeLong$();
        var lo = this$8.divideUnsignedImpl__I__I__I__I__I(value$1, value, 1000000000, 0);
        temp.set(i$1, lo);
        var hi$3 = (lo >> 31);
        var b0 = (65535 & lo);
        var b1 = ((lo >>> 16) | 0);
        var a0b0 = $imul(51712, b0);
        var a1b0 = $imul(15258, b0);
        var a0b1 = $imul(51712, b1);
        var lo$1 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
        var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
        var hi$4 = (((((($imul(1000000000, hi$3) + $imul(15258, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
        var lo$2 = ((value$1 - lo$1) | 0);
        rem = lo$2;
        i$1 = (((-1) + i$1) | 0)
      };
      var this$10 = rem;
      var remStr = ("" + this$10);
      var beginIndex = $uI(remStr.length);
      var padding = $as_T("000000000".substring(beginIndex));
      result = ((padding + remStr) + result);
      while (((tempLen !== 0) && (temp.get((((-1) + tempLen) | 0)) === 0))) {
        tempLen = (((-1) + tempLen) | 0)
      }
    } while ((tempLen !== 0));
    result = this.dropLeadingZeros__p1__T__T(result);
    return ((sign < 0) ? (("" + new $c_jl_Character().init___C(45)) + result) : result)
  }
});
var $d_Ljava_math_Conversion$ = new $TypeData().initClass({
  Ljava_math_Conversion$: 0
}, false, "java.math.Conversion$", {
  Ljava_math_Conversion$: 1,
  O: 1
});
$c_Ljava_math_Conversion$.prototype.$classData = $d_Ljava_math_Conversion$;
var $n_Ljava_math_Conversion$ = (void 0);
function $m_Ljava_math_Conversion$() {
  if ((!$n_Ljava_math_Conversion$)) {
    $n_Ljava_math_Conversion$ = new $c_Ljava_math_Conversion$().init___()
  };
  return $n_Ljava_math_Conversion$
}
/** @constructor */
function $c_Ljava_math_Division$() {
  $c_O.call(this)
}
$c_Ljava_math_Division$.prototype = new $h_O();
$c_Ljava_math_Division$.prototype.constructor = $c_Ljava_math_Division$;
/** @constructor */
function $h_Ljava_math_Division$() {
  /*<skip>*/
}
$h_Ljava_math_Division$.prototype = $c_Ljava_math_Division$.prototype;
$c_Ljava_math_Division$.prototype.init___ = (function() {
  return this
});
$c_Ljava_math_Division$.prototype.divide__AI__I__AI__I__AI__I__AI = (function(quot, quotLength, a, aLength, b, bLength) {
  var normA = $newArrayObject($d_I.getArrayOf(), [((1 + aLength) | 0)]);
  var normB = $newArrayObject($d_I.getArrayOf(), [((1 + bLength) | 0)]);
  var divisorShift = $clz32(b.get((((-1) + bLength) | 0)));
  if ((divisorShift !== 0)) {
    $m_Ljava_math_BitLevel$().shiftLeft__AI__AI__I__I__V(normB, b, 0, divisorShift);
    $m_Ljava_math_BitLevel$().shiftLeft__AI__AI__I__I__V(normA, a, 0, divisorShift)
  } else {
    $systemArraycopy(a, 0, normA, 0, aLength);
    $systemArraycopy(b, 0, normB, 0, bLength)
  };
  var firstDivisorDigit = normB.get((((-1) + bLength) | 0));
  var i = (((-1) + quotLength) | 0);
  var elem$1 = 0;
  elem$1 = aLength;
  while ((i >= 0)) {
    var elem$1$1 = 0;
    elem$1$1 = 0;
    if ((normA.get(elem$1) === firstDivisorDigit)) {
      elem$1$1 = (-1)
    } else {
      var value = normA.get(elem$1);
      var value$1 = normA.get((((-1) + elem$1) | 0));
      var this$5 = $m_sjsr_RuntimeLong$();
      var lo = this$5.divideUnsignedImpl__I__I__I__I__I(value$1, value, firstDivisorDigit, 0);
      var hi$3 = this$5.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
      elem$1$1 = lo;
      var a0 = (65535 & lo);
      var a1 = ((lo >>> 16) | 0);
      var b0 = (65535 & firstDivisorDigit);
      var b1 = ((firstDivisorDigit >>> 16) | 0);
      var a0b0 = $imul(a0, b0);
      var a1b0 = $imul(a1, b0);
      var a0b1 = $imul(a0, b1);
      var lo$1 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (((((($imul(hi$3, firstDivisorDigit) + $imul(a1, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
      var lo$2 = ((value$1 - lo$1) | 0);
      var elem$1$2 = 0;
      elem$1$2 = lo$2;
      if ((elem$1$1 !== 0)) {
        elem$1$1 = ((1 + elem$1$1) | 0);
        _loop: while (true) {
          elem$1$1 = (((-1) + elem$1$1) | 0);
          var value$2 = elem$1$1;
          var value$3 = normB.get((((-2) + bLength) | 0));
          var a0$1 = (65535 & value$2);
          var a1$1 = ((value$2 >>> 16) | 0);
          var b0$1 = (65535 & value$3);
          var b1$1 = ((value$3 >>> 16) | 0);
          var a0b0$1 = $imul(a0$1, b0$1);
          var a1b0$1 = $imul(a1$1, b0$1);
          var a0b1$1 = $imul(a0$1, b1$1);
          var lo$3 = ((a0b0$1 + (((a1b0$1 + a0b1$1) | 0) << 16)) | 0);
          var c1part$1 = ((((a0b0$1 >>> 16) | 0) + a0b1$1) | 0);
          var hi$8 = (((($imul(a1$1, b1$1) + ((c1part$1 >>> 16) | 0)) | 0) + (((((65535 & c1part$1) + a1b0$1) | 0) >>> 16) | 0)) | 0);
          var value$4 = elem$1$2;
          var value$5 = normA.get((((-2) + elem$1) | 0));
          var value$6 = elem$1$2;
          var lo$4 = ((value$6 + firstDivisorDigit) | 0);
          var hi$13 = ((((-2147483648) ^ lo$4) < ((-2147483648) ^ value$6)) ? 1 : 0);
          if ((hi$13 === 0)) {
            elem$1$2 = lo$4;
            var hi$14 = ((-2147483648) ^ hi$8);
            var hi$15 = ((-2147483648) ^ value$4);
            if (((hi$14 === hi$15) ? (((-2147483648) ^ lo$3) > ((-2147483648) ^ value$5)) : (hi$14 > hi$15))) {
              continue _loop
            }
          };
          break
        }
      }
    };
    if ((elem$1$1 !== 0)) {
      var borrow = $m_Ljava_math_Division$().multiplyAndSubtract__AI__I__AI__I__I__I(normA, ((elem$1 - bLength) | 0), normB, bLength, elem$1$1);
      if ((borrow !== 0)) {
        elem$1$1 = (((-1) + elem$1$1) | 0);
        var elem$1$3_$_lo$2 = 0;
        var elem$1$3_$_hi$2 = 0;
        var jsx$1_$_lo$2 = 0;
        var jsx$1_$_hi$2 = 0;
        elem$1$3_$_lo$2 = jsx$1_$_lo$2;
        elem$1$3_$_hi$2 = jsx$1_$_hi$2;
        var isEmpty$4 = (bLength <= 0);
        var scala$collection$immutable$Range$$lastElement$4 = (((-1) + bLength) | 0);
        if ((!isEmpty$4)) {
          var i$1 = 0;
          while (true) {
            var v1 = i$1;
            var this$15_$_lo$2 = elem$1$3_$_lo$2;
            var this$15_$_hi$2 = elem$1$3_$_hi$2;
            var value$7 = normA.get(((((elem$1 - bLength) | 0) + v1) | 0));
            var value$8 = normB.get(v1);
            var lo$5 = ((value$7 + value$8) | 0);
            var hi$20 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ value$7)) ? 1 : 0);
            var alo = this$15_$_lo$2;
            var ahi = this$15_$_hi$2;
            var lo$6 = ((alo + lo$5) | 0);
            var hi$21 = ((((-2147483648) ^ lo$6) < ((-2147483648) ^ alo)) ? ((1 + ((ahi + hi$20) | 0)) | 0) : ((ahi + hi$20) | 0));
            var jsx$2_$_lo$2 = lo$6;
            var jsx$2_$_hi$2 = hi$21;
            elem$1$3_$_lo$2 = jsx$2_$_lo$2;
            elem$1$3_$_hi$2 = jsx$2_$_hi$2;
            var jsx$3 = elem$1;
            var this$17_$_lo$2 = elem$1$3_$_lo$2;
            var this$17_$_hi$2 = elem$1$3_$_hi$2;
            normA.set(((((jsx$3 - bLength) | 0) + v1) | 0), this$17_$_lo$2);
            var this$18_$_lo$2 = elem$1$3_$_lo$2;
            var this$18_$_hi$2 = elem$1$3_$_hi$2;
            var lo$7 = this$18_$_hi$2;
            var jsx$4_$_lo$2 = lo$7;
            var jsx$4_$_hi$2 = 0;
            elem$1$3_$_lo$2 = jsx$4_$_lo$2;
            elem$1$3_$_hi$2 = jsx$4_$_hi$2;
            if ((i$1 === scala$collection$immutable$Range$$lastElement$4)) {
              break
            };
            i$1 = ((1 + i$1) | 0)
          }
        }
      }
    };
    if ((quot !== null)) {
      quot.set(i, elem$1$1)
    };
    elem$1 = (((-1) + elem$1) | 0);
    i = (((-1) + i) | 0)
  };
  return ((divisorShift !== 0) ? ($m_Ljava_math_BitLevel$().shiftRight__AI__I__AI__I__I__Z(normB, bLength, normA, 0, divisorShift), normB) : ($systemArraycopy(normA, 0, normB, 0, bLength), normA))
});
$c_Ljava_math_Division$.prototype.divideAndRemainderByInteger__Ljava_math_BigInteger__I__I__Ljava_math_BigInteger$QuotAndRem = (function(bi, divisor, divisorSign) {
  var valDigits = bi.digits$2;
  var valLen = bi.numberLength$2;
  var valSign = bi.sign$2;
  if ((valLen === 1)) {
    var valDigit = valDigits.get(0);
    var n = ($uD((valDigit >>> 0)) / $uD((divisor >>> 0)));
    var value = $uI((n | 0));
    var quo_$_lo$2 = value;
    var quo_$_hi$2 = 0;
    var n$1 = ($uD((valDigit >>> 0)) % $uD((divisor >>> 0)));
    var value$1 = $uI((n$1 | 0));
    var rem_$_lo$2 = value$1;
    var rem_$_hi$2 = 0;
    if ((valSign !== divisorSign)) {
      var this$13_$_lo$2 = quo_$_lo$2;
      var this$13_$_hi$2 = quo_$_hi$2;
      var lo = this$13_$_lo$2;
      var hi$2 = this$13_$_hi$2;
      var lo$1 = ((-lo) | 0);
      var hi$3 = ((lo !== 0) ? (~hi$2) : ((-hi$2) | 0));
      var jsx$1_$_lo$2 = lo$1;
      var jsx$1_$_hi$2 = hi$3;
      quo_$_lo$2 = jsx$1_$_lo$2;
      quo_$_hi$2 = jsx$1_$_hi$2
    };
    if ((valSign < 0)) {
      var this$16_$_lo$2 = rem_$_lo$2;
      var this$16_$_hi$2 = rem_$_hi$2;
      var lo$2 = this$16_$_lo$2;
      var hi$4 = this$16_$_hi$2;
      var lo$3 = ((-lo$2) | 0);
      var hi$5 = ((lo$2 !== 0) ? (~hi$4) : ((-hi$4) | 0));
      var jsx$2_$_lo$2 = lo$3;
      var jsx$2_$_hi$2 = hi$5;
      rem_$_lo$2 = jsx$2_$_lo$2;
      rem_$_hi$2 = jsx$2_$_hi$2
    };
    return new $c_Ljava_math_BigInteger$QuotAndRem().init___Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_BigInteger$().valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(quo_$_lo$2, quo_$_hi$2)), $m_Ljava_math_BigInteger$().valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(rem_$_lo$2, rem_$_hi$2)))
  } else {
    var quotientSign = ((valSign === divisorSign) ? 1 : (-1));
    var quotientDigits = $newArrayObject($d_I.getArrayOf(), [valLen]);
    var div = this.divideArrayByInt__AI__AI__I__I__I(quotientDigits, valDigits, valLen, divisor);
    var remainderDigits = $m_s_Array$().apply__I__sc_Seq__AI(div, new $c_sjs_js_WrappedArray().init___sjs_js_Array([]));
    var result0 = new $c_Ljava_math_BigInteger().init___I__I__AI(quotientSign, valLen, quotientDigits);
    var result1 = new $c_Ljava_math_BigInteger().init___I__I__AI(valSign, 1, remainderDigits);
    result0.cutOffLeadingZeroes__V();
    result1.cutOffLeadingZeroes__V();
    return new $c_Ljava_math_BigInteger$QuotAndRem().init___Ljava_math_BigInteger__Ljava_math_BigInteger(result0, result1)
  }
});
$c_Ljava_math_Division$.prototype.multiplyAndSubtract__AI__I__AI__I__I__I = (function(a, start, b, bLen, c) {
  var elem$1 = 0;
  elem$1 = 0;
  var elem$1$1 = 0;
  elem$1$1 = 0;
  var isEmpty$4 = (bLen <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + bLen) | 0);
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      $m_Ljava_math_Multiplication$();
      var a$1 = b.get(v1);
      var c$1 = elem$1;
      var a0 = (65535 & a$1);
      var a1 = ((a$1 >>> 16) | 0);
      var b0 = (65535 & c);
      var b1 = ((c >>> 16) | 0);
      var a0b0 = $imul(a0, b0);
      var a1b0 = $imul(a1, b0);
      var a0b1 = $imul(a0, b1);
      var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
      var lo$1 = ((lo + c$1) | 0);
      var hi$6 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + hi$4) | 0) : hi$4);
      var value = a.get(((start + v1) | 0));
      var lo$2 = ((value - lo$1) | 0);
      var hi$8 = ((((-2147483648) ^ lo$2) > ((-2147483648) ^ value)) ? (-1) : 0);
      var value$1 = elem$1$1;
      var hi$9 = (value$1 >> 31);
      var lo$3 = ((lo$2 + value$1) | 0);
      var hi$10 = ((((-2147483648) ^ lo$3) < ((-2147483648) ^ lo$2)) ? ((1 + ((hi$8 + hi$9) | 0)) | 0) : ((hi$8 + hi$9) | 0));
      a.set(((start + v1) | 0), lo$3);
      elem$1$1 = hi$10;
      elem$1 = hi$6;
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  var value$2 = a.get(((start + bLen) | 0));
  var value$3 = elem$1;
  var lo$4 = ((value$2 - value$3) | 0);
  var hi$15 = ((((-2147483648) ^ lo$4) > ((-2147483648) ^ value$2)) ? (-1) : 0);
  var value$4 = elem$1$1;
  var hi$16 = (value$4 >> 31);
  var lo$5 = ((lo$4 + value$4) | 0);
  var hi$17 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ lo$4)) ? ((1 + ((hi$15 + hi$16) | 0)) | 0) : ((hi$15 + hi$16) | 0));
  a.set(((start + bLen) | 0), lo$5);
  return hi$17
});
$c_Ljava_math_Division$.prototype.divideArrayByInt__AI__AI__I__I__I = (function(dest, src, srcLength, divisor) {
  var rem = 0;
  var i = (((-1) + srcLength) | 0);
  while ((i >= 0)) {
    var value = rem;
    var value$1 = src.get(i);
    var this$2 = $m_sjsr_RuntimeLong$();
    var lo = this$2.divideUnsignedImpl__I__I__I__I__I(value$1, value, divisor, 0);
    var hi$3 = this$2.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
    var a0 = (65535 & lo);
    var a1 = ((lo >>> 16) | 0);
    var b0 = (65535 & divisor);
    var b1 = ((divisor >>> 16) | 0);
    var a0b0 = $imul(a0, b0);
    var a1b0 = $imul(a1, b0);
    var a0b1 = $imul(a0, b1);
    var lo$1 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
    var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
    var hi$4 = (((((($imul(hi$3, divisor) + $imul(a1, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
    var lo$2 = ((value$1 - lo$1) | 0);
    rem = lo$2;
    dest.set(i, lo);
    i = (((-1) + i) | 0)
  };
  return rem
});
var $d_Ljava_math_Division$ = new $TypeData().initClass({
  Ljava_math_Division$: 0
}, false, "java.math.Division$", {
  Ljava_math_Division$: 1,
  O: 1
});
$c_Ljava_math_Division$.prototype.$classData = $d_Ljava_math_Division$;
var $n_Ljava_math_Division$ = (void 0);
function $m_Ljava_math_Division$() {
  if ((!$n_Ljava_math_Division$)) {
    $n_Ljava_math_Division$ = new $c_Ljava_math_Division$().init___()
  };
  return $n_Ljava_math_Division$
}
/** @constructor */
function $c_Ljava_math_Elementary$() {
  $c_O.call(this)
}
$c_Ljava_math_Elementary$.prototype = new $h_O();
$c_Ljava_math_Elementary$.prototype.constructor = $c_Ljava_math_Elementary$;
/** @constructor */
function $h_Ljava_math_Elementary$() {
  /*<skip>*/
}
$h_Ljava_math_Elementary$.prototype = $c_Ljava_math_Elementary$.prototype;
$c_Ljava_math_Elementary$.prototype.init___ = (function() {
  return this
});
$c_Ljava_math_Elementary$.prototype.subtract__p1__AI__I__AI__I__AI = (function(a, aSize, b, bSize) {
  var res = $newArrayObject($d_I.getArrayOf(), [aSize]);
  this.subtract__p1__AI__AI__I__AI__I__V(res, a, aSize, b, bSize);
  return res
});
$c_Ljava_math_Elementary$.prototype.compareArrays__AI__AI__I__I = (function(a, b, size) {
  var i = (((-1) + size) | 0);
  while (((i >= 0) && (a.get(i) === b.get(i)))) {
    i = (((-1) + i) | 0)
  };
  if ((i < 0)) {
    return 0
  } else {
    var value = a.get(i);
    var value$1 = b.get(i);
    if ((((-2147483648) ^ value) < ((-2147483648) ^ value$1))) {
      return (-1)
    } else {
      return 1
    }
  }
});
$c_Ljava_math_Elementary$.prototype.inplaceAdd__AI__I__I__I = (function(a, aSize, addend) {
  var carry = addend;
  var i = 0;
  while (((carry !== 0) && (i < aSize))) {
    var value = carry;
    var value$1 = a.get(i);
    var lo = ((value + value$1) | 0);
    var hi$2 = ((((-2147483648) ^ lo) < ((-2147483648) ^ value)) ? 1 : 0);
    a.set(i, lo);
    carry = hi$2;
    i = ((1 + i) | 0)
  };
  return carry
});
$c_Ljava_math_Elementary$.prototype.add__p1__AI__I__AI__I__AI = (function(a, aSize, b, bSize) {
  var res = $newArrayObject($d_I.getArrayOf(), [((1 + aSize) | 0)]);
  this.add__p1__AI__AI__I__AI__I__V(res, a, aSize, b, bSize);
  return res
});
$c_Ljava_math_Elementary$.prototype.add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(op1, op2) {
  var op1Sign = op1.sign$2;
  var op2Sign = op2.sign$2;
  var op1Len = op1.numberLength$2;
  var op2Len = op2.numberLength$2;
  if ((op1Sign === 0)) {
    return op2
  } else if ((op2Sign === 0)) {
    return op1
  } else if ((((op1Len + op2Len) | 0) === 2)) {
    var value = op1.digits$2.get(0);
    var value$1 = op2.digits$2.get(0);
    if ((op1Sign === op2Sign)) {
      var lo = ((value + value$1) | 0);
      var hi$2 = ((((-2147483648) ^ lo) < ((-2147483648) ^ value)) ? 1 : 0);
      return ((hi$2 === 0) ? new $c_Ljava_math_BigInteger().init___I__I(op1Sign, lo) : new $c_Ljava_math_BigInteger().init___I__I__AI(op1Sign, 2, $m_s_Array$().apply__I__sc_Seq__AI(lo, new $c_sjs_js_WrappedArray().init___sjs_js_Array([hi$2]))))
    } else {
      var jsx$1 = $m_Ljava_math_BigInteger$();
      if ((op1Sign < 0)) {
        var lo$1 = ((value$1 - value) | 0);
        var hi$3 = ((((-2147483648) ^ lo$1) > ((-2147483648) ^ value$1)) ? (-1) : 0);
        var x_$_lo$2 = lo$1;
        var x_$_hi$2 = hi$3
      } else {
        var lo$2 = ((value - value$1) | 0);
        var hi$4 = ((((-2147483648) ^ lo$2) > ((-2147483648) ^ value)) ? (-1) : 0);
        var x_$_lo$2 = lo$2;
        var x_$_hi$2 = hi$4
      };
      return jsx$1.valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(x_$_lo$2, x_$_hi$2))
    }
  } else {
    if ((op1Sign === op2Sign)) {
      var res$2 = ((op1Len >= op2Len) ? this.add__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len) : this.add__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len));
      var x1_$_$$und1$f = op1Sign;
      var x1_$_$$und2$f = res$2
    } else {
      var cmp = ((op1Len !== op2Len) ? ((op1Len > op2Len) ? 1 : (-1)) : this.compareArrays__AI__AI__I__I(op1.digits$2, op2.digits$2, op1Len));
      if ((cmp === 0)) {
        return $m_Ljava_math_BigInteger$().ZERO$1
      };
      if ((cmp === 1)) {
        var _2 = this.subtract__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len);
        var x1_$_$$und1$f = op1Sign;
        var x1_$_$$und2$f = _2
      } else {
        var _2$1 = this.subtract__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len);
        var x1_$_$$und1$f = op2Sign;
        var x1_$_$$und2$f = _2$1
      }
    };
    var resSign = $uI(x1_$_$$und1$f);
    var resDigits = $asArrayOf_I(x1_$_$$und2$f, 1);
    var res$3 = new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, resDigits.u.length, resDigits);
    res$3.cutOffLeadingZeroes__V();
    return res$3
  }
});
$c_Ljava_math_Elementary$.prototype.subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(op1, op2) {
  var op1Sign = op1.sign$2;
  var op2Sign = op2.sign$2;
  var op1Len = op1.numberLength$2;
  var op2Len = op2.numberLength$2;
  if ((op2Sign === 0)) {
    return op1
  } else if ((op1Sign === 0)) {
    return op2.negate__Ljava_math_BigInteger()
  } else if ((((op1Len + op2Len) | 0) === 2)) {
    var value = op1.digits$2.get(0);
    var a_$_lo$2 = value;
    var a_$_hi$2 = 0;
    var value$1 = op2.digits$2.get(0);
    var b_$_lo$2 = value$1;
    var b_$_hi$2 = 0;
    if ((op1Sign < 0)) {
      var this$1_$_lo$2 = a_$_lo$2;
      var this$1_$_hi$2 = a_$_hi$2;
      var lo = this$1_$_lo$2;
      var hi$2 = this$1_$_hi$2;
      var lo$1 = ((-lo) | 0);
      var hi$3 = ((lo !== 0) ? (~hi$2) : ((-hi$2) | 0));
      var jsx$1_$_lo$2 = lo$1;
      var jsx$1_$_hi$2 = hi$3;
      a_$_lo$2 = jsx$1_$_lo$2;
      a_$_hi$2 = jsx$1_$_hi$2
    };
    if ((op2Sign < 0)) {
      var this$4_$_lo$2 = b_$_lo$2;
      var this$4_$_hi$2 = b_$_hi$2;
      var lo$2 = this$4_$_lo$2;
      var hi$4 = this$4_$_hi$2;
      var lo$3 = ((-lo$2) | 0);
      var hi$5 = ((lo$2 !== 0) ? (~hi$4) : ((-hi$4) | 0));
      var jsx$2_$_lo$2 = lo$3;
      var jsx$2_$_hi$2 = hi$5;
      b_$_lo$2 = jsx$2_$_lo$2;
      b_$_hi$2 = jsx$2_$_hi$2
    };
    var jsx$3 = $m_Ljava_math_BigInteger$();
    var this$7_$_lo$2 = a_$_lo$2;
    var this$7_$_hi$2 = a_$_hi$2;
    var b$1_$_lo$2 = b_$_lo$2;
    var b$1_$_hi$2 = b_$_hi$2;
    var alo = this$7_$_lo$2;
    var ahi = this$7_$_hi$2;
    var bhi = b$1_$_hi$2;
    var lo$4 = ((alo - b$1_$_lo$2) | 0);
    var hi$6 = ((((-2147483648) ^ lo$4) > ((-2147483648) ^ alo)) ? (((-1) + ((ahi - bhi) | 0)) | 0) : ((ahi - bhi) | 0));
    return jsx$3.valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(lo$4, hi$6))
  } else {
    var cmp = ((op1Len !== op2Len) ? ((op1Len > op2Len) ? 1 : (-1)) : $m_Ljava_math_Elementary$().compareArrays__AI__AI__I__I(op1.digits$2, op2.digits$2, op1Len));
    if (((op1Sign === op2Sign) && (cmp === 0))) {
      return $m_Ljava_math_BigInteger$().ZERO$1
    };
    if ((cmp === (-1))) {
      var res = ((op1Sign === op2Sign) ? this.subtract__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len) : this.add__p1__AI__I__AI__I__AI(op2.digits$2, op2Len, op1.digits$2, op1Len));
      var _1 = ((-op2Sign) | 0);
      var x1_$_$$und1$f = _1;
      var x1_$_$$und2$f = res
    } else if ((op1Sign === op2Sign)) {
      var _2 = this.subtract__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len);
      var x1_$_$$und1$f = op1Sign;
      var x1_$_$$und2$f = _2
    } else {
      var _2$1 = this.add__p1__AI__I__AI__I__AI(op1.digits$2, op1Len, op2.digits$2, op2Len);
      var x1_$_$$und1$f = op1Sign;
      var x1_$_$$und2$f = _2$1
    };
    var resSign = $uI(x1_$_$$und1$f);
    var resDigits = $asArrayOf_I(x1_$_$$und2$f, 1);
    var res$2 = new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, resDigits.u.length, resDigits);
    res$2.cutOffLeadingZeroes__V();
    return res$2
  }
});
$c_Ljava_math_Elementary$.prototype.subtract__p1__AI__AI__I__AI__I__V = (function(res, a, aSize, b, bSize) {
  var i = 0;
  var borrow = 0;
  while ((i < bSize)) {
    var value = a.get(i);
    var value$1 = b.get(i);
    var lo = ((value - value$1) | 0);
    var hi$2 = ((((-2147483648) ^ lo) > ((-2147483648) ^ value)) ? (-1) : 0);
    var value$2 = borrow;
    var hi$3 = (value$2 >> 31);
    var lo$1 = ((lo + value$2) | 0);
    var hi$4 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + ((hi$2 + hi$3) | 0)) | 0) : ((hi$2 + hi$3) | 0));
    res.set(i, lo$1);
    borrow = hi$4;
    i = ((1 + i) | 0)
  };
  while ((i < aSize)) {
    var value$3 = a.get(i);
    var value$4 = borrow;
    var hi$7 = (value$4 >> 31);
    var lo$2 = ((value$3 + value$4) | 0);
    var hi$8 = ((((-2147483648) ^ lo$2) < ((-2147483648) ^ value$3)) ? ((1 + hi$7) | 0) : hi$7);
    res.set(i, lo$2);
    borrow = hi$8;
    i = ((1 + i) | 0)
  }
});
$c_Ljava_math_Elementary$.prototype.add__p1__AI__AI__I__AI__I__V = (function(res, a, aSize, b, bSize) {
  var i = 1;
  var value = a.get(0);
  var value$1 = b.get(0);
  var lo = ((value + value$1) | 0);
  var hi$2 = ((((-2147483648) ^ lo) < ((-2147483648) ^ value)) ? 1 : 0);
  res.set(0, lo);
  var carry = hi$2;
  if ((aSize >= bSize)) {
    while ((i < bSize)) {
      var value$2 = a.get(i);
      var value$3 = b.get(i);
      var lo$1 = ((value$2 + value$3) | 0);
      var hi$6 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ value$2)) ? 1 : 0);
      var value$4 = carry;
      var lo$2 = ((lo$1 + value$4) | 0);
      var hi$8 = ((((-2147483648) ^ lo$2) < ((-2147483648) ^ lo$1)) ? ((1 + hi$6) | 0) : hi$6);
      res.set(i, lo$2);
      carry = hi$8;
      i = ((1 + i) | 0)
    };
    while ((i < aSize)) {
      var value$5 = a.get(i);
      var value$6 = carry;
      var lo$3 = ((value$5 + value$6) | 0);
      var hi$12 = ((((-2147483648) ^ lo$3) < ((-2147483648) ^ value$5)) ? 1 : 0);
      res.set(i, lo$3);
      carry = hi$12;
      i = ((1 + i) | 0)
    }
  } else {
    while ((i < aSize)) {
      var value$7 = a.get(i);
      var value$8 = b.get(i);
      var lo$4 = ((value$7 + value$8) | 0);
      var hi$16 = ((((-2147483648) ^ lo$4) < ((-2147483648) ^ value$7)) ? 1 : 0);
      var value$9 = carry;
      var lo$5 = ((lo$4 + value$9) | 0);
      var hi$18 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ lo$4)) ? ((1 + hi$16) | 0) : hi$16);
      res.set(i, lo$5);
      carry = hi$18;
      i = ((1 + i) | 0)
    };
    while ((i < bSize)) {
      var value$10 = b.get(i);
      var value$11 = carry;
      var lo$6 = ((value$10 + value$11) | 0);
      var hi$22 = ((((-2147483648) ^ lo$6) < ((-2147483648) ^ value$10)) ? 1 : 0);
      res.set(i, lo$6);
      carry = hi$22;
      i = ((1 + i) | 0)
    }
  };
  if ((carry !== 0)) {
    res.set(i, carry)
  }
});
var $d_Ljava_math_Elementary$ = new $TypeData().initClass({
  Ljava_math_Elementary$: 0
}, false, "java.math.Elementary$", {
  Ljava_math_Elementary$: 1,
  O: 1
});
$c_Ljava_math_Elementary$.prototype.$classData = $d_Ljava_math_Elementary$;
var $n_Ljava_math_Elementary$ = (void 0);
function $m_Ljava_math_Elementary$() {
  if ((!$n_Ljava_math_Elementary$)) {
    $n_Ljava_math_Elementary$ = new $c_Ljava_math_Elementary$().init___()
  };
  return $n_Ljava_math_Elementary$
}
/** @constructor */
function $c_Ljava_math_MathContext() {
  $c_O.call(this);
  this.precision$1 = 0;
  this.roundingMode$1 = null
}
$c_Ljava_math_MathContext.prototype = new $h_O();
$c_Ljava_math_MathContext.prototype.constructor = $c_Ljava_math_MathContext;
/** @constructor */
function $h_Ljava_math_MathContext() {
  /*<skip>*/
}
$h_Ljava_math_MathContext.prototype = $c_Ljava_math_MathContext.prototype;
$c_Ljava_math_MathContext.prototype.equals__O__Z = (function(x) {
  if ($is_Ljava_math_MathContext(x)) {
    var x2 = $as_Ljava_math_MathContext(x);
    if ((this.precision$1 === x2.precision$1)) {
      var x$2 = this.roundingMode$1;
      var x$3 = x2.roundingMode$1;
      return (x$2 === x$3)
    } else {
      return false
    }
  } else {
    return false
  }
});
$c_Ljava_math_MathContext.prototype.toString__T = (function() {
  return ((("precision=" + this.precision$1) + " roundingMode=") + this.roundingMode$1)
});
$c_Ljava_math_MathContext.prototype.init___I__Ljava_math_RoundingMode = (function(setPrecision, setRoundingMode) {
  this.precision$1 = setPrecision;
  this.roundingMode$1 = setRoundingMode;
  return this
});
$c_Ljava_math_MathContext.prototype.hashCode__I = (function() {
  return ((this.precision$1 << 3) | this.roundingMode$1.$$undordinal$1)
});
function $is_Ljava_math_MathContext(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Ljava_math_MathContext)))
}
function $as_Ljava_math_MathContext(obj) {
  return (($is_Ljava_math_MathContext(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.math.MathContext"))
}
function $isArrayOf_Ljava_math_MathContext(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Ljava_math_MathContext)))
}
function $asArrayOf_Ljava_math_MathContext(obj, depth) {
  return (($isArrayOf_Ljava_math_MathContext(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.math.MathContext;", depth))
}
var $d_Ljava_math_MathContext = new $TypeData().initClass({
  Ljava_math_MathContext: 0
}, false, "java.math.MathContext", {
  Ljava_math_MathContext: 1,
  O: 1
});
$c_Ljava_math_MathContext.prototype.$classData = $d_Ljava_math_MathContext;
/** @constructor */
function $c_Ljava_math_MathContext$() {
  $c_O.call(this);
  this.DECIMAL128$1 = null;
  this.DECIMAL32$1 = null;
  this.DECIMAL64$1 = null;
  this.UNLIMITED$1 = null
}
$c_Ljava_math_MathContext$.prototype = new $h_O();
$c_Ljava_math_MathContext$.prototype.constructor = $c_Ljava_math_MathContext$;
/** @constructor */
function $h_Ljava_math_MathContext$() {
  /*<skip>*/
}
$h_Ljava_math_MathContext$.prototype = $c_Ljava_math_MathContext$.prototype;
$c_Ljava_math_MathContext$.prototype.init___ = (function() {
  $n_Ljava_math_MathContext$ = this;
  $m_Ljava_math_MathContext$();
  var roundingMode = $m_Ljava_math_RoundingMode$().HALF$undEVEN$1;
  this.DECIMAL128$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(34, roundingMode);
  $m_Ljava_math_MathContext$();
  var roundingMode$1 = $m_Ljava_math_RoundingMode$().HALF$undEVEN$1;
  this.DECIMAL32$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(7, roundingMode$1);
  $m_Ljava_math_MathContext$();
  var roundingMode$2 = $m_Ljava_math_RoundingMode$().HALF$undEVEN$1;
  this.DECIMAL64$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(16, roundingMode$2);
  $m_Ljava_math_MathContext$();
  var roundingMode$3 = $m_Ljava_math_RoundingMode$().HALF$undUP$1;
  this.UNLIMITED$1 = new $c_Ljava_math_MathContext().init___I__Ljava_math_RoundingMode(0, roundingMode$3);
  return this
});
var $d_Ljava_math_MathContext$ = new $TypeData().initClass({
  Ljava_math_MathContext$: 0
}, false, "java.math.MathContext$", {
  Ljava_math_MathContext$: 1,
  O: 1
});
$c_Ljava_math_MathContext$.prototype.$classData = $d_Ljava_math_MathContext$;
var $n_Ljava_math_MathContext$ = (void 0);
function $m_Ljava_math_MathContext$() {
  if ((!$n_Ljava_math_MathContext$)) {
    $n_Ljava_math_MathContext$ = new $c_Ljava_math_MathContext$().init___()
  };
  return $n_Ljava_math_MathContext$
}
/** @constructor */
function $c_Ljava_math_Multiplication$() {
  $c_O.call(this);
  this.TenPows$1 = null;
  this.FivePows$1 = null;
  this.BigTenPows$1 = null;
  this.BigFivePows$1 = null
}
$c_Ljava_math_Multiplication$.prototype = new $h_O();
$c_Ljava_math_Multiplication$.prototype.constructor = $c_Ljava_math_Multiplication$;
/** @constructor */
function $h_Ljava_math_Multiplication$() {
  /*<skip>*/
}
$h_Ljava_math_Multiplication$.prototype = $c_Ljava_math_Multiplication$.prototype;
$c_Ljava_math_Multiplication$.prototype.multiplyPAP__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(a, b) {
  var aLen = a.numberLength$2;
  var bLen = b.numberLength$2;
  var resLength = ((aLen + bLen) | 0);
  var resSign = ((a.sign$2 !== b.sign$2) ? (-1) : 1);
  if ((resLength === 2)) {
    var a$1 = a.digits$2.get(0);
    var b$1 = b.digits$2.get(0);
    var a0 = (65535 & a$1);
    var a1 = ((a$1 >>> 16) | 0);
    var b0 = (65535 & b$1);
    var b1 = ((b$1 >>> 16) | 0);
    var a0b0 = $imul(a0, b0);
    var a1b0 = $imul(a1, b0);
    var a0b1 = $imul(a0, b1);
    var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
    var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
    var hi$2 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
    return ((hi$2 === 0) ? new $c_Ljava_math_BigInteger().init___I__I(resSign, lo) : new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, 2, $m_s_Array$().apply__I__sc_Seq__AI(lo, new $c_sjs_js_WrappedArray().init___sjs_js_Array([hi$2]))))
  } else {
    var aDigits = a.digits$2;
    var bDigits = b.digits$2;
    var resDigits = $newArrayObject($d_I.getArrayOf(), [resLength]);
    this.multArraysPAP__AI__I__AI__I__AI__V(aDigits, aLen, bDigits, bLen, resDigits);
    var result = new $c_Ljava_math_BigInteger().init___I__I__AI(resSign, resLength, resDigits);
    result.cutOffLeadingZeroes__V();
    return result
  }
});
$c_Ljava_math_Multiplication$.prototype.init___ = (function() {
  $n_Ljava_math_Multiplication$ = this;
  this.TenPows$1 = this.newArrayOfPows__p1__I__I__AI(10, 10);
  this.FivePows$1 = this.newArrayOfPows__p1__I__I__AI(14, 5);
  this.BigTenPows$1 = $newArrayObject($d_Ljava_math_BigInteger.getArrayOf(), [32]);
  this.BigFivePows$1 = $newArrayObject($d_Ljava_math_BigInteger.getArrayOf(), [32]);
  this.initialiseArrays__p1__V();
  return this
});
$c_Ljava_math_Multiplication$.prototype.square__AI__I__AI__AI = (function(a, aLen, res) {
  var elem$1 = 0;
  elem$1 = 0;
  var isEmpty$4 = (aLen <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + aLen) | 0);
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      elem$1 = 0;
      var x = ((1 + v1) | 0);
      var isEmpty$4$1 = (x >= aLen);
      var scala$collection$immutable$Range$$lastElement$4$1 = (((-1) + aLen) | 0);
      if ((!isEmpty$4$1)) {
        var i$1 = x;
        while (true) {
          var v1$1 = i$1;
          var a$1 = a.get(v1);
          var b = a.get(v1$1);
          var c = res.get(((v1 + v1$1) | 0));
          var d = elem$1;
          var a0 = (65535 & a$1);
          var a1 = ((a$1 >>> 16) | 0);
          var b0 = (65535 & b);
          var b1 = ((b >>> 16) | 0);
          var a0b0 = $imul(a0, b0);
          var a1b0 = $imul(a1, b0);
          var a0b1 = $imul(a0, b1);
          var lo$4 = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
          var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
          var hi$13 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
          var lo$5 = ((lo$4 + c) | 0);
          var hi$15 = ((((-2147483648) ^ lo$5) < ((-2147483648) ^ lo$4)) ? ((1 + hi$13) | 0) : hi$13);
          var lo$6 = ((lo$5 + d) | 0);
          var hi$17 = ((((-2147483648) ^ lo$6) < ((-2147483648) ^ lo$5)) ? ((1 + hi$15) | 0) : hi$15);
          res.set(((v1 + v1$1) | 0), lo$6);
          elem$1 = hi$17;
          if ((i$1 === scala$collection$immutable$Range$$lastElement$4$1)) {
            break
          };
          i$1 = ((1 + i$1) | 0)
        }
      };
      res.set(((v1 + aLen) | 0), elem$1);
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  $m_Ljava_math_BitLevel$().shiftLeftOneBit__AI__AI__I__V(res, res, (aLen << 1));
  elem$1 = 0;
  var i$3 = 0;
  var index = 0;
  while ((i$3 < aLen)) {
    var a$2 = a.get(i$3);
    var b$1 = a.get(i$3);
    var c$1 = res.get(index);
    var d$1 = elem$1;
    var a0$1 = (65535 & a$2);
    var a1$1 = ((a$2 >>> 16) | 0);
    var b0$1 = (65535 & b$1);
    var b1$1 = ((b$1 >>> 16) | 0);
    var a0b0$1 = $imul(a0$1, b0$1);
    var a1b0$1 = $imul(a1$1, b0$1);
    var a0b1$1 = $imul(a0$1, b1$1);
    var lo$7 = ((a0b0$1 + (((a1b0$1 + a0b1$1) | 0) << 16)) | 0);
    var c1part$1 = ((((a0b0$1 >>> 16) | 0) + a0b1$1) | 0);
    var hi$20 = (((($imul(a1$1, b1$1) + ((c1part$1 >>> 16) | 0)) | 0) + (((((65535 & c1part$1) + a1b0$1) | 0) >>> 16) | 0)) | 0);
    var lo$8 = ((lo$7 + c$1) | 0);
    var hi$22 = ((((-2147483648) ^ lo$8) < ((-2147483648) ^ lo$7)) ? ((1 + hi$20) | 0) : hi$20);
    var lo$9 = ((lo$8 + d$1) | 0);
    var hi$24 = ((((-2147483648) ^ lo$9) < ((-2147483648) ^ lo$8)) ? ((1 + hi$22) | 0) : hi$22);
    res.set(index, lo$9);
    index = ((1 + index) | 0);
    var value$1 = res.get(index);
    var lo$10 = ((hi$24 + value$1) | 0);
    var hi$26 = ((((-2147483648) ^ lo$10) < ((-2147483648) ^ hi$24)) ? 1 : 0);
    res.set(index, lo$10);
    elem$1 = hi$26;
    i$3 = ((1 + i$3) | 0);
    index = ((1 + index) | 0)
  };
  return res
});
$c_Ljava_math_Multiplication$.prototype.pow__Ljava_math_BigInteger__I__Ljava_math_BigInteger = (function(base, exponent) {
  var exp = exponent;
  var res = $m_Ljava_math_BigInteger$().ONE$1;
  var acc = base;
  _loop: while (true) {
    if ((exp > 1)) {
      var res2 = (((1 & exp) !== 0) ? res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(acc) : res);
      if ((acc.numberLength$2 === 1)) {
        var acc2 = acc.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(acc)
      } else {
        var a = $newArrayObject($d_I.getArrayOf(), [(acc.numberLength$2 << 1)]);
        var sq = this.square__AI__I__AI__AI(acc.digits$2, acc.numberLength$2, a);
        var acc2 = new $c_Ljava_math_BigInteger().init___I__AI(1, sq)
      };
      var temp$exp = (exp >> 1);
      exp = temp$exp;
      res = res2;
      acc = acc2;
      continue _loop
    } else {
      return res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(acc)
    }
  }
});
$c_Ljava_math_Multiplication$.prototype.multPAP__p1__AI__AI__AI__I__I__V = (function(a, b, t, aLen, bLen) {
  if (((a === b) && (aLen === bLen))) {
    this.square__AI__I__AI__AI(a, aLen, t)
  } else {
    var isEmpty$4 = (aLen <= 0);
    var scala$collection$immutable$Range$$lastElement$4 = (((-1) + aLen) | 0);
    if ((!isEmpty$4)) {
      var i = 0;
      while (true) {
        var v1 = i;
        var elem$1 = 0;
        elem$1 = 0;
        var aI = a.get(v1);
        var isEmpty$4$1 = (bLen <= 0);
        var scala$collection$immutable$Range$$lastElement$4$1 = (((-1) + bLen) | 0);
        if ((!isEmpty$4$1)) {
          var i$1 = 0;
          while (true) {
            var v1$1 = i$1;
            var b$1 = b.get(v1$1);
            var c = t.get(((v1 + v1$1) | 0));
            var d = elem$1;
            var a0 = (65535 & aI);
            var a1 = ((aI >>> 16) | 0);
            var b0 = (65535 & b$1);
            var b1 = ((b$1 >>> 16) | 0);
            var a0b0 = $imul(a0, b0);
            var a1b0 = $imul(a1, b0);
            var a0b1 = $imul(a0, b1);
            var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
            var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
            var hi$6 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
            var lo$1 = ((lo + c) | 0);
            var hi$8 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + hi$6) | 0) : hi$6);
            var lo$2 = ((lo$1 + d) | 0);
            var hi$10 = ((((-2147483648) ^ lo$2) < ((-2147483648) ^ lo$1)) ? ((1 + hi$8) | 0) : hi$8);
            t.set(((v1 + v1$1) | 0), lo$2);
            elem$1 = hi$10;
            if ((i$1 === scala$collection$immutable$Range$$lastElement$4$1)) {
              break
            };
            i$1 = ((1 + i$1) | 0)
          }
        };
        t.set(((v1 + bLen) | 0), elem$1);
        if ((i === scala$collection$immutable$Range$$lastElement$4)) {
          break
        };
        i = ((1 + i) | 0)
      }
    }
  }
});
$c_Ljava_math_Multiplication$.prototype.initialiseArrays__p1__V = (function() {
  var elem$1_$_lo$2 = 0;
  var elem$1_$_hi$2 = 0;
  var jsx$1_$_lo$2 = 1;
  var jsx$1_$_hi$2 = 0;
  elem$1_$_lo$2 = jsx$1_$_lo$2;
  elem$1_$_hi$2 = jsx$1_$_hi$2;
  var i = 0;
  while (true) {
    var v1 = i;
    if ((v1 <= 18)) {
      this.BigFivePows$1.set(v1, $m_Ljava_math_BigInteger$().valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(elem$1_$_lo$2, elem$1_$_hi$2)));
      var jsx$3 = this.BigTenPows$1;
      var jsx$2 = $m_Ljava_math_BigInteger$();
      var this$5_$_lo$2 = elem$1_$_lo$2;
      var this$5_$_hi$2 = elem$1_$_hi$2;
      var lo = (((32 & v1) === 0) ? (this$5_$_lo$2 << v1) : 0);
      var hi = (((32 & v1) === 0) ? (((((this$5_$_lo$2 >>> 1) | 0) >>> ((31 - v1) | 0)) | 0) | (this$5_$_hi$2 << v1)) : (this$5_$_lo$2 << v1));
      jsx$3.set(v1, jsx$2.valueOf__J__Ljava_math_BigInteger(new $c_sjsr_RuntimeLong().init___I__I(lo, hi)));
      var b_$_lo$2 = elem$1_$_lo$2;
      var b_$_hi$2 = elem$1_$_hi$2;
      var blo = b_$_lo$2;
      var b0 = (65535 & blo);
      var b1 = ((blo >>> 16) | 0);
      var a0b0 = $imul(5, b0);
      var a0b1 = $imul(5, b1);
      var lo$1 = ((a0b0 + (a0b1 << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$1 = (($imul(5, b_$_hi$2) + ((c1part >>> 16) | 0)) | 0);
      var jsx$4_$_lo$2 = lo$1;
      var jsx$4_$_hi$2 = hi$1;
      elem$1_$_lo$2 = jsx$4_$_lo$2;
      elem$1_$_hi$2 = jsx$4_$_hi$2
    } else {
      this.BigFivePows$1.set(v1, this.BigFivePows$1.get((((-1) + v1) | 0)).multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(this.BigFivePows$1.get(1)));
      this.BigTenPows$1.set(v1, this.BigTenPows$1.get((((-1) + v1) | 0)).multiply__Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_BigInteger$().TEN$1))
    };
    if ((i === 31)) {
      break
    };
    i = ((1 + i) | 0)
  }
});
$c_Ljava_math_Multiplication$.prototype.newArrayOfPows__p1__I__I__AI = (function(len, pow) {
  var xs = $newArrayObject($d_I.getArrayOf(), [(((-1) + len) | 0)]);
  var elems$2 = null;
  elems$2 = [];
  var x1 = xs.u.length;
  switch (x1) {
    case (-1): {
      break
    }
  };
  var elem$1 = null;
  elem$1 = 1;
  var elem = elem$1;
  var unboxedElem = ((elem === null) ? 0 : elem);
  elems$2.push(unboxedElem);
  var i = 0;
  var len$1 = xs.u.length;
  while ((i < len$1)) {
    var idx = i;
    var arg1 = xs.get(idx);
    var arg1$1 = elem$1;
    var z = $uI(arg1$1);
    elem$1 = $imul(z, pow);
    var elem$2 = elem$1;
    var unboxedElem$1 = ((elem$2 === null) ? 0 : elem$2);
    elems$2.push(unboxedElem$1);
    i = ((1 + i) | 0)
  };
  return $makeNativeArrayWrapper($d_I.getArrayOf(), elems$2)
});
$c_Ljava_math_Multiplication$.prototype.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger = (function(val1, val2) {
  if ((val2.numberLength$2 > val1.numberLength$2)) {
    var x1_$_$$und1$f = val2;
    var x1_$_$$und2$f = val1
  } else {
    var x1_$_$$und1$f = val1;
    var x1_$_$$und2$f = val2
  };
  var op1 = $as_Ljava_math_BigInteger(x1_$_$$und1$f);
  var op2 = $as_Ljava_math_BigInteger(x1_$_$$und2$f);
  if ((op2.numberLength$2 < 63)) {
    return this.multiplyPAP__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(op1, op2)
  } else {
    var ndiv2 = (((-2) & op1.numberLength$2) << 4);
    var upperOp1 = op1.shiftRight__I__Ljava_math_BigInteger(ndiv2);
    var upperOp2 = op2.shiftRight__I__Ljava_math_BigInteger(ndiv2);
    var bi = upperOp1.shiftLeft__I__Ljava_math_BigInteger(ndiv2);
    var lowerOp1 = $m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(op1, bi);
    var bi$1 = upperOp2.shiftLeft__I__Ljava_math_BigInteger(ndiv2);
    var lowerOp2 = $m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(op2, bi$1);
    var upper = this.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(upperOp1, upperOp2);
    var lower = this.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(lowerOp1, lowerOp2);
    var middle = this.karatsuba__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger($m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(upperOp1, lowerOp1), $m_Ljava_math_Elementary$().subtract__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(lowerOp2, upperOp2));
    var this$1 = middle;
    var bi$2 = upper;
    var this$2 = $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$1, bi$2);
    middle = $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$2, lower);
    middle = middle.shiftLeft__I__Ljava_math_BigInteger(ndiv2);
    upper = upper.shiftLeft__I__Ljava_math_BigInteger((ndiv2 << 1));
    var this$3 = upper;
    var bi$3 = middle;
    var this$4 = $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$3, bi$3);
    return $m_Ljava_math_Elementary$().add__Ljava_math_BigInteger__Ljava_math_BigInteger__Ljava_math_BigInteger(this$4, lower)
  }
});
$c_Ljava_math_Multiplication$.prototype.multiplyByInt__p1__AI__AI__I__I__I = (function(res, a, aSize, factor) {
  var elem$1 = 0;
  elem$1 = 0;
  var isEmpty$4 = (aSize <= 0);
  var scala$collection$immutable$Range$$lastElement$4 = (((-1) + aSize) | 0);
  if ((!isEmpty$4)) {
    var i = 0;
    while (true) {
      var v1 = i;
      var a$1 = a.get(v1);
      var c = elem$1;
      var a0 = (65535 & a$1);
      var a1 = ((a$1 >>> 16) | 0);
      var b0 = (65535 & factor);
      var b1 = ((factor >>> 16) | 0);
      var a0b0 = $imul(a0, b0);
      var a1b0 = $imul(a1, b0);
      var a0b1 = $imul(a0, b1);
      var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
      var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
      var hi$4 = (((($imul(a1, b1) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
      var lo$1 = ((lo + c) | 0);
      var hi$6 = ((((-2147483648) ^ lo$1) < ((-2147483648) ^ lo)) ? ((1 + hi$4) | 0) : hi$4);
      res.set(v1, lo$1);
      elem$1 = hi$6;
      if ((i === scala$collection$immutable$Range$$lastElement$4)) {
        break
      };
      i = ((1 + i) | 0)
    }
  };
  return elem$1
});
$c_Ljava_math_Multiplication$.prototype.multArraysPAP__AI__I__AI__I__AI__V = (function(aDigits, aLen, bDigits, bLen, resDigits) {
  if ((!((aLen === 0) || (bLen === 0)))) {
    if ((aLen === 1)) {
      resDigits.set(bLen, this.multiplyByInt__p1__AI__AI__I__I__I(resDigits, bDigits, bLen, aDigits.get(0)))
    } else if ((bLen === 1)) {
      resDigits.set(aLen, this.multiplyByInt__p1__AI__AI__I__I__I(resDigits, aDigits, aLen, bDigits.get(0)))
    } else {
      this.multPAP__p1__AI__AI__AI__I__I__V(aDigits, bDigits, resDigits, aLen, bLen)
    }
  }
});
$c_Ljava_math_Multiplication$.prototype.powerOf10__J__Ljava_math_BigInteger = (function(exp) {
  var value = this.BigTenPows$1.u.length;
  var hi = (value >> 31);
  var ahi = exp.hi$2;
  if (((ahi === hi) ? (((-2147483648) ^ exp.lo$2) < ((-2147483648) ^ value)) : (ahi < hi))) {
    return this.BigTenPows$1.get(exp.lo$2)
  } else {
    var ahi$1 = exp.hi$2;
    if (((ahi$1 === 0) ? (((-2147483648) ^ exp.lo$2) <= (-2147483598)) : (ahi$1 < 0))) {
      return $m_Ljava_math_BigInteger$().TEN$1.pow__I__Ljava_math_BigInteger(exp.lo$2)
    } else {
      var ahi$2 = exp.hi$2;
      if (((ahi$2 === 0) ? (((-2147483648) ^ exp.lo$2) <= (-1)) : (ahi$2 < 0))) {
        return this.BigFivePows$1.get(1).pow__I__Ljava_math_BigInteger(exp.lo$2).shiftLeft__I__Ljava_math_BigInteger(exp.lo$2)
      } else {
        var powerOfFive = this.BigFivePows$1.get(1).pow__I__Ljava_math_BigInteger(2147483647);
        var res = powerOfFive;
        var bhi = exp.hi$2;
        var lo = (((-2147483647) + exp.lo$2) | 0);
        var hi$1 = ((((-2147483648) ^ lo) < 1) ? bhi : (((-1) + bhi) | 0));
        var longExp_$_lo$2 = lo;
        var longExp_$_hi$2 = hi$1;
        var this$2 = $m_sjsr_RuntimeLong$();
        var lo$1 = this$2.remainderImpl__I__I__I__I__I(exp.lo$2, exp.hi$2, 2147483647, 0);
        while (true) {
          var this$3_$_lo$2 = longExp_$_lo$2;
          var this$3_$_hi$2 = longExp_$_hi$2;
          var ahi$3 = this$3_$_hi$2;
          if (((ahi$3 === 0) ? (((-2147483648) ^ this$3_$_lo$2) > (-1)) : (ahi$3 > 0))) {
            res = res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(powerOfFive);
            var b_$_lo$2 = longExp_$_lo$2;
            var b_$_hi$2 = longExp_$_hi$2;
            var bhi$1 = b_$_hi$2;
            var lo$2 = (((-2147483647) + b_$_lo$2) | 0);
            var hi$3 = ((((-2147483648) ^ lo$2) < 1) ? bhi$1 : (((-1) + bhi$1) | 0));
            var jsx$1_$_lo$2 = lo$2;
            var jsx$1_$_hi$2 = hi$3;
            longExp_$_lo$2 = jsx$1_$_lo$2;
            longExp_$_hi$2 = jsx$1_$_hi$2
          } else {
            break
          }
        };
        res = res.multiply__Ljava_math_BigInteger__Ljava_math_BigInteger(this.BigFivePows$1.get(1).pow__I__Ljava_math_BigInteger(lo$1));
        res = res.shiftLeft__I__Ljava_math_BigInteger(2147483647);
        var bhi$2 = exp.hi$2;
        var lo$3 = (((-2147483647) + exp.lo$2) | 0);
        var hi$4 = ((((-2147483648) ^ lo$3) < 1) ? bhi$2 : (((-1) + bhi$2) | 0));
        var jsx$2_$_lo$2 = lo$3;
        var jsx$2_$_hi$2 = hi$4;
        longExp_$_lo$2 = jsx$2_$_lo$2;
        longExp_$_hi$2 = jsx$2_$_hi$2;
        while (true) {
          var this$6_$_lo$2 = longExp_$_lo$2;
          var this$6_$_hi$2 = longExp_$_hi$2;
          var ahi$4 = this$6_$_hi$2;
          if (((ahi$4 === 0) ? (((-2147483648) ^ this$6_$_lo$2) > (-1)) : (ahi$4 > 0))) {
            res = res.shiftLeft__I__Ljava_math_BigInteger(2147483647);
            var b$1_$_lo$2 = longExp_$_lo$2;
            var b$1_$_hi$2 = longExp_$_hi$2;
            var bhi$3 = b$1_$_hi$2;
            var lo$4 = (((-2147483647) + b$1_$_lo$2) | 0);
            var hi$5 = ((((-2147483648) ^ lo$4) < 1) ? bhi$3 : (((-1) + bhi$3) | 0));
            var jsx$3_$_lo$2 = lo$4;
            var jsx$3_$_hi$2 = hi$5;
            longExp_$_lo$2 = jsx$3_$_lo$2;
            longExp_$_hi$2 = jsx$3_$_hi$2
          } else {
            break
          }
        };
        return res.shiftLeft__I__Ljava_math_BigInteger(lo$1)
      }
    }
  }
});
var $d_Ljava_math_Multiplication$ = new $TypeData().initClass({
  Ljava_math_Multiplication$: 0
}, false, "java.math.Multiplication$", {
  Ljava_math_Multiplication$: 1,
  O: 1
});
$c_Ljava_math_Multiplication$.prototype.$classData = $d_Ljava_math_Multiplication$;
var $n_Ljava_math_Multiplication$ = (void 0);
function $m_Ljava_math_Multiplication$() {
  if ((!$n_Ljava_math_Multiplication$)) {
    $n_Ljava_math_Multiplication$ = new $c_Ljava_math_Multiplication$().init___()
  };
  return $n_Ljava_math_Multiplication$
}
/** @constructor */
function $c_Lorg_scalajs_dom_package$() {
  $c_O.call(this);
  this.ApplicationCache$1 = null;
  this.Blob$1 = null;
  this.BlobPropertyBag$1 = null;
  this.ClipboardEventInit$1 = null;
  this.DOMException$1 = null;
  this.Event$1 = null;
  this.EventException$1 = null;
  this.EventSource$1 = null;
  this.FileReader$1 = null;
  this.FormData$1 = null;
  this.KeyboardEvent$1 = null;
  this.MediaError$1 = null;
  this.MutationEvent$1 = null;
  this.MutationObserverInit$1 = null;
  this.Node$1 = null;
  this.NodeFilter$1 = null;
  this.PerformanceNavigation$1 = null;
  this.PositionError$1 = null;
  this.Range$1 = null;
  this.TextEvent$1 = null;
  this.TextTrack$1 = null;
  this.URL$1 = null;
  this.VisibilityState$1 = null;
  this.WebSocket$1 = null;
  this.WheelEvent$1 = null;
  this.XMLHttpRequest$1 = null;
  this.XPathResult$1 = null;
  this.window$1 = null;
  this.document$1 = null;
  this.console$1 = null;
  this.bitmap$0$1 = 0
}
$c_Lorg_scalajs_dom_package$.prototype = new $h_O();
$c_Lorg_scalajs_dom_package$.prototype.constructor = $c_Lorg_scalajs_dom_package$;
/** @constructor */
function $h_Lorg_scalajs_dom_package$() {
  /*<skip>*/
}
$h_Lorg_scalajs_dom_package$.prototype = $c_Lorg_scalajs_dom_package$.prototype;
$c_Lorg_scalajs_dom_package$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_dom_package$.prototype.document__Lorg_scalajs_dom_raw_HTMLDocument = (function() {
  return (((268435456 & this.bitmap$0$1) === 0) ? this.document$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLDocument() : this.document$1)
});
$c_Lorg_scalajs_dom_package$.prototype.window__Lorg_scalajs_dom_raw_Window = (function() {
  return (((134217728 & this.bitmap$0$1) === 0) ? this.window$lzycompute__p1__Lorg_scalajs_dom_raw_Window() : this.window$1)
});
$c_Lorg_scalajs_dom_package$.prototype.window$lzycompute__p1__Lorg_scalajs_dom_raw_Window = (function() {
  if (((134217728 & this.bitmap$0$1) === 0)) {
    this.window$1 = $g;
    this.bitmap$0$1 = (134217728 | this.bitmap$0$1)
  };
  return this.window$1
});
$c_Lorg_scalajs_dom_package$.prototype.document$lzycompute__p1__Lorg_scalajs_dom_raw_HTMLDocument = (function() {
  if (((268435456 & this.bitmap$0$1) === 0)) {
    this.document$1 = this.window__Lorg_scalajs_dom_raw_Window().document;
    this.bitmap$0$1 = (268435456 | this.bitmap$0$1)
  };
  return this.document$1
});
$c_Lorg_scalajs_dom_package$.prototype.WebSocket__Lorg_scalajs_dom_raw_WebSocket$ = (function() {
  return (((8388608 & this.bitmap$0$1) === 0) ? this.WebSocket$lzycompute__p1__Lorg_scalajs_dom_raw_WebSocket$() : this.WebSocket$1)
});
$c_Lorg_scalajs_dom_package$.prototype.WebSocket$lzycompute__p1__Lorg_scalajs_dom_raw_WebSocket$ = (function() {
  if (((8388608 & this.bitmap$0$1) === 0)) {
    this.WebSocket$1 = $g.WebSocket;
    this.bitmap$0$1 = (8388608 | this.bitmap$0$1)
  };
  return this.WebSocket$1
});
var $d_Lorg_scalajs_dom_package$ = new $TypeData().initClass({
  Lorg_scalajs_dom_package$: 0
}, false, "org.scalajs.dom.package$", {
  Lorg_scalajs_dom_package$: 1,
  O: 1
});
$c_Lorg_scalajs_dom_package$.prototype.$classData = $d_Lorg_scalajs_dom_package$;
var $n_Lorg_scalajs_dom_package$ = (void 0);
function $m_Lorg_scalajs_dom_package$() {
  if ((!$n_Lorg_scalajs_dom_package$)) {
    $n_Lorg_scalajs_dom_package$ = new $c_Lorg_scalajs_dom_package$().init___()
  };
  return $n_Lorg_scalajs_dom_package$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$() {
  $c_O.call(this);
  this.org$scalajs$testinterface$HTMLRunner$EventCounter$$isErrorStatus$1 = null;
  this.counts$1 = null
}
$c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype.constructor = $c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype = $c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype;
$c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype.init___ = (function() {
  $n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$ = this;
  var array = [$m_Lsbt_testing_Status$().Error$1, $m_Lsbt_testing_Status$().Failure$1];
  if (($uI(array.length) === 0)) {
    var jsx$1 = $m_sci_Set$EmptySet$()
  } else {
    var b = new $c_scm_SetBuilder().init___sc_Set($m_sci_Set$EmptySet$());
    var i = 0;
    var len = $uI(array.length);
    while ((i < len)) {
      var index = i;
      var arg1 = array[index];
      b.$$plus$eq__O__scm_SetBuilder(arg1);
      i = ((1 + i) | 0)
    };
    var jsx$1 = b.elems$1
  };
  this.org$scalajs$testinterface$HTMLRunner$EventCounter$$isErrorStatus$1 = $as_sci_Set(jsx$1);
  var this$3 = new $c_scm_HashMap().init___();
  this.counts$1 = $f_scm_Map__withDefaultValue__O__scm_Map(this$3, 0);
  return this
});
var $d_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_HTMLRunner$EventCounter$: 0
}, false, "org.scalajs.testinterface.HTMLRunner$EventCounter$", {
  Lorg_scalajs_testinterface_HTMLRunner$EventCounter$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$.prototype.$classData = $d_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$;
var $n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$ = (void 0);
function $m_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$() {
  if ((!$n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$)) {
    $n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$ = new $c_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$().init___()
  };
  return $n_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_HTMLRunner$UI() {
  $c_O.call(this);
  this.org$scalajs$testinterface$HTMLRunner$UI$$excludedTaskDefs$f = null;
  this.$$unddone$1 = false;
  this.org$scalajs$testinterface$HTMLRunner$UI$$runningTests$1 = null;
  this.org$scalajs$testinterface$HTMLRunner$UI$$excludedTests$1 = null;
  this.org$scalajs$testinterface$HTMLRunner$UI$$container$1 = null;
  this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1 = null;
  this.org$scalajs$testinterface$HTMLRunner$UI$$nextFailureLocation$f = null
}
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.constructor = $c_Lorg_scalajs_testinterface_HTMLRunner$UI;
/** @constructor */
function $h_Lorg_scalajs_testinterface_HTMLRunner$UI() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype = $c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype;
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$$anonfun$testUpdater$1__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox__Z = (function(tests$1, checkbox$1) {
  tests$1.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, checkbox$1$1) {
    return (function(x$20$2) {
      var x$20 = $as_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(x$20$2);
      x$20.selected$und$eq__Z__V($uZ(checkbox$1$1.checked))
    })
  })(this, checkbox$1)));
  return true
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$$anonfun$checkboxUpdater$1__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox__Z = (function(tests$2, checkbox$2) {
  var all = tests$2.forall__F1__Z(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$18$2) {
      var x$18 = $as_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(x$18$2);
      return x$18.selected__Z()
    })
  })(this)));
  var indet = ((!all) && tests$2.exists__F1__Z(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(x$19$2) {
      var x$19 = $as_Lorg_scalajs_testinterface_HTMLRunner$UI$Test(x$19$2);
      return x$19.selected__Z()
    })
  })(this))));
  checkbox$2.indeterminate = indet;
  if ((!indet)) {
    checkbox$2.checked = all
  };
  return true
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$statusClass__Z__T = (function(ok) {
  return (ok ? "success" : "error")
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.warnTestSetChanged__V = (function() {
  var this$1 = this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1;
  var line = this$1.box$1.log__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element("", "warn");
  $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newTextNode$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Node(line, "There are new excluded tests in your project. You may wish to ");
  $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newLink$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element(line, "?", "Run all");
  $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newTextNode$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Node(line, " to rediscover all available tests.")
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$testUpdater__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox__sjs_js_Function0 = (function(tests, checkbox) {
  return (function(arg$outer, tests$1, checkbox$1) {
    return (function() {
      return arg$outer.org$scalajs$testinterface$HTMLRunner$UI$$$anonfun$testUpdater$1__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox__Z(tests$1, checkbox$1)
    })
  })(this, tests, checkbox)
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$updateCounts__V = (function() {
  var total = $uI($m_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$().counts$1.values__sc_Iterable().sum__s_math_Numeric__O($m_s_math_Numeric$IntIsIntegral$()));
  var x$10 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Total: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([total]));
  var xs = $m_Lsbt_testing_Status$().values__ALsbt_testing_Status();
  var elems$2 = null;
  elems$2 = [];
  var x1 = xs.u.length;
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var status = $as_Lsbt_testing_Status(arg1);
    var elem = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", ": ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([status, $m_Lorg_scalajs_testinterface_HTMLRunner$EventCounter$().counts$1.apply__O__O(status)]));
    var unboxedElem = ((elem === null) ? null : elem);
    elems$2.push(unboxedElem);
    i = ((1 + i) | 0)
  };
  var xs$1 = $makeNativeArrayWrapper($d_T.getArrayOf(), elems$2);
  var n1 = ((1 + xs$1.u.length) | 0);
  var result = $newArrayObject($d_T.getArrayOf(), [n1]);
  result.set(0, x$10);
  $m_s_Array$().copy__O__I__O__I__I__V(xs$1, 0, result, 1, xs$1.u.length);
  var b = new $c_scm_StringBuilder().init___();
  var elem$1 = false;
  elem$1 = true;
  b.append__T__scm_StringBuilder("");
  var i$1 = 0;
  var len$1 = result.u.length;
  while ((i$1 < len$1)) {
    var index$1 = i$1;
    var arg1$1 = result.get(index$1);
    if (elem$1) {
      b.append__O__scm_StringBuilder(arg1$1);
      elem$1 = false
    } else {
      b.append__T__scm_StringBuilder(", ");
      b.append__O__scm_StringBuilder(arg1$1)
    };
    i$1 = ((1 + i$1) | 0)
  };
  b.append__T__scm_StringBuilder("");
  var this$16 = b.underlying$5;
  var countStr = this$16.content$1;
  if (this.$$unddone$1) {
    this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1.counterLineText$und$eq__T__V(countStr)
  } else {
    this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1.counterLineText$und$eq__T__V(("Running... " + countStr))
  }
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.newTestTask__T__Lorg_scalajs_testinterface_HTMLRunner$UI$TestTask = (function(testName) {
  var task = new $c_Lorg_scalajs_testinterface_HTMLRunner$UI$RunningTest().init___Lorg_scalajs_testinterface_HTMLRunner$UI__T(this, testName);
  this.org$scalajs$testinterface$HTMLRunner$UI$$runningTests$1.$$plus$eq__O__scm_Buffer(task);
  return task
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.org$scalajs$testinterface$HTMLRunner$UI$$checkboxUpdater__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox__sjs_js_Function0 = (function(tests, checkbox) {
  return (function(arg$outer, tests$2, checkbox$2) {
    return (function() {
      return arg$outer.org$scalajs$testinterface$HTMLRunner$UI$$$anonfun$checkboxUpdater$1__sc_Seq__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox__Z(tests$2, checkbox$2)
    })
  })(this, tests, checkbox)
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.init___sc_Seq__I = (function(excludedTaskDefs, totalTestCount) {
  this.org$scalajs$testinterface$HTMLRunner$UI$$excludedTaskDefs$f = excludedTaskDefs;
  this.$$unddone$1 = false;
  $m_scm_Buffer$();
  var this$2 = new $c_sjs_js_WrappedArray().init___();
  this.org$scalajs$testinterface$HTMLRunner$UI$$runningTests$1 = this$2;
  $m_scm_Buffer$();
  var this$4 = new $c_sjs_js_WrappedArray().init___();
  this.org$scalajs$testinterface$HTMLRunner$UI$$excludedTests$1 = this$4;
  var element = $g.document.body;
  this.org$scalajs$testinterface$HTMLRunner$UI$$container$1 = $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newElement$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element(element, "", "", "div");
  this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1 = new $c_Lorg_scalajs_testinterface_HTMLRunner$UI$RootBox().init___Lorg_scalajs_testinterface_HTMLRunner$UI__I__I(this, excludedTaskDefs.size__I(), totalTestCount);
  this.org$scalajs$testinterface$HTMLRunner$UI$$nextFailureLocation$f = (excludedTaskDefs.nonEmpty__Z() ? new $c_Lorg_scalajs_testinterface_HTMLRunner$UI$ExcludedTestBox().init___Lorg_scalajs_testinterface_HTMLRunner$UI(this) : this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1);
  this.org$scalajs$testinterface$HTMLRunner$UI$$updateCounts__V();
  return this
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.reportFrameworkResult__Z__T__T__V = (function(ok, framework, result) {
  var this$1 = this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1;
  var msg = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", " reported ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([framework, result]));
  var clss = this.org$scalajs$testinterface$HTMLRunner$UI$$statusClass__Z__T(ok);
  this$1.box$1.log__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element(msg, clss)
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.done__s_util_Try__V = (function(ok) {
  this.$$unddone$1 = true;
  ok.failed__s_util_Try().foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(t$2) {
      var t = $as_jl_Throwable(t$2);
      var this$1 = $this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1;
      this$1.box$1.log__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element("Test framework crashed during execution:", "error");
      var this$2 = $this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1;
      var msg = t.toString__T();
      return this$2.box$1.log__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element(msg, "error")
    })
  })(this)));
  this.org$scalajs$testinterface$HTMLRunner$UI$$rootBox$1.done__Z__V($uZ(ok.getOrElse__F0__O(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      return false
    })
  })(this)))));
  this.org$scalajs$testinterface$HTMLRunner$UI$$updateCounts__V()
});
var $d_Lorg_scalajs_testinterface_HTMLRunner$UI = new $TypeData().initClass({
  Lorg_scalajs_testinterface_HTMLRunner$UI: 0
}, false, "org.scalajs.testinterface.HTMLRunner$UI", {
  Lorg_scalajs_testinterface_HTMLRunner$UI: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_HTMLRunner$UI.prototype.$classData = $d_Lorg_scalajs_testinterface_HTMLRunner$UI;
/** @constructor */
function $c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.constructor = $c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype = $c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype;
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.newCheckbox$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__Z__Lorg_scalajs_testinterface_HTMLRunner$dom$Checkbox = (function($$this, checked) {
  var el = $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newElement$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element($$this, "", "", "input");
  el.setAttribute("type", "checkbox");
  el.checked = checked;
  return el
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.newElement$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element = (function($$this, clss, text, tpe) {
  var el = $g.document.createElement(tpe);
  var this$2 = new $c_sci_StringOps().init___T(clss);
  if ($f_sc_TraversableOnce__nonEmpty__Z(this$2)) {
    el.className = clss
  };
  var this$4 = new $c_sci_StringOps().init___T(text);
  if ($f_sc_TraversableOnce__nonEmpty__Z(this$4)) {
    el.textContent = text
  };
  $$this.appendChild(el);
  return el
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.newTextNode$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Node = (function($$this, text) {
  var n = $g.document.createTextNode(text);
  $$this.appendChild(n);
  return n
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.newLink$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element = (function($$this, href, text) {
  var el = $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().newElement$extension__Lorg_scalajs_testinterface_HTMLRunner$dom$Element__T__T__T__Lorg_scalajs_testinterface_HTMLRunner$dom$Element($$this, "", text, "a");
  el.setAttribute("href", href);
  return el
});
var $d_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$: 0
}, false, "org.scalajs.testinterface.HTMLRunner$dom$RichElement$", {
  Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$.prototype.$classData = $d_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$;
var $n_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$ = (void 0);
function $m_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$() {
  if ((!$n_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$)) {
    $n_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$ = new $c_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$().init___()
  };
  return $n_Lorg_scalajs_testinterface_HTMLRunner$dom$RichElement$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_TestDetector$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_TestDetector$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.constructor = $c_Lorg_scalajs_testinterface_TestDetector$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_TestDetector$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_TestDetector$.prototype = $c_Lorg_scalajs_testinterface_TestDetector$.prototype;
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.fingerprintMatches__p1__Lsbt_testing_Fingerprint__Lsbt_testing_Fingerprint__Z = (function(a, b) {
  if ($is_Lsbt_testing_SubclassFingerprint(a)) {
    var x2 = $as_Lsbt_testing_SubclassFingerprint(a);
    if ($is_Lsbt_testing_SubclassFingerprint(b)) {
      var x3 = $as_Lsbt_testing_SubclassFingerprint(b);
      return ((x2.isModule$1 === x3.isModule$1) && (x2.superclassName$1 === x3.superclassName$1))
    }
  };
  if ($is_Lsbt_testing_AnnotatedFingerprint(a)) {
    var x4 = $as_Lsbt_testing_AnnotatedFingerprint(a);
    if ($is_Lsbt_testing_AnnotatedFingerprint(b)) {
      var x5 = $as_Lsbt_testing_AnnotatedFingerprint(b);
      return ((x4.isModule$1 === x5.isModule$1) && (x4.annotationName$1 === x5.annotationName$1))
    }
  };
  return false
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.tryLoadFromReflect$1__p1__T__s_Option = (function(name) {
  var this$1 = $m_sjs_reflect_Reflect$();
  var this$2 = this$1.instantiatableClasses$1.get__O__s_Option(name);
  var pf = new $c_Lorg_scalajs_testinterface_TestDetector$$anonfun$tryLoadFromReflect$1$1().init___();
  if ((!this$2.isEmpty__Z())) {
    var this$3 = new $c_s_PartialFunction$Lifted().init___s_PartialFunction(pf);
    var v1 = this$2.get__O();
    return this$3.apply__O__s_Option(v1)
  } else {
    return $m_s_None$()
  }
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.tryLoadFramework__p1__sjs_js_Array__s_Option = (function(names) {
  var this$2 = new $c_sjs_js_ArrayOps().init___sjs_js_Array(names);
  var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, $uI(this$2.scala$scalajs$js$ArrayOps$$array$f.length));
  var this$6 = $as_sci_Stream($f_sc_Iterator__toStream__sci_Stream(this$3).map__F1__scg_CanBuildFrom__O(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(name$2) {
      var name = $as_T(name$2);
      return $this.tryLoad$1__p1__T__s_Option(name)
    })
  })(this)), ($m_sci_Stream$(), new $c_sci_Stream$StreamCanBuildFrom().init___()))).flatten__F1__sci_Stream(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(xo$2) {
      var xo = $as_s_Option(xo$2);
      return xo.toList__sci_List()
    })
  })(this)));
  return $f_sc_TraversableLike__headOption__s_Option(this$6)
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.tryLoad$1__p1__T__s_Option = (function(name) {
  var this$1 = this.tryLoadFromReflect$1__p1__T__s_Option(name);
  return (this$1.isEmpty__Z() ? this.tryLoadFromExportsNamespace$1__p1__T__s_Option(name) : this$1)
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.tryLoadFromExportsNamespace$1__p1__T__s_Option = (function(name) {
  var exportsNamespace = $env.exportsNamespace;
  var this$2 = new $c_sci_StringOps().init___T(name);
  var parts = $f_sci_StringLike__split__C__AT(this$2, 46);
  var start = 0;
  var end = parts.u.length;
  var z = exportsNamespace;
  var start$1 = start;
  var z$1 = z;
  var ctor;
  _foldl: while (true) {
    if ((start$1 !== end)) {
      var temp$start = ((1 + start$1) | 0);
      var arg1 = z$1;
      var index = start$1;
      var arg2 = parts.get(index);
      var name$2 = $as_T(arg2);
      if ((arg1 === (void 0))) {
        var temp$z = (void 0)
      } else {
        var value = arg1[name$2];
        var temp$z = value
      };
      start$1 = temp$start;
      z$1 = temp$z;
      continue _foldl
    };
    var ctor = z$1;
    break
  };
  if ((ctor === (void 0))) {
    var value$2 = (void 0)
  } else {
    var value$1 = new ctor();
    var value$2 = value$1
  };
  new $c_Lorg_scalajs_testinterface_TestDetector$$anonfun$tryLoadFromExportsNamespace$1$1().init___();
  var value$3 = ((value$2 === (void 0)) ? (void 0) : ($is_Lsbt_testing_Framework(value$2) ? value$2 : (void 0)));
  return ((value$3 === (void 0)) ? $m_s_None$() : new $c_s_Some().init___O(value$3))
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.detectTests__sc_Seq = (function() {
  var array = $g.definedTests;
  var array$1 = [];
  var x1 = $uI(array.length);
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = $uI(array.length);
  while ((i < len)) {
    var index = i;
    var arg1 = array[index];
    var elem = $m_Lorg_scalajs_testinterface_internal_TaskDefSerializer$().deserialize__sjs_js_Dynamic__Lsbt_testing_TaskDef(arg1);
    array$1.push(elem);
    i = ((1 + i) | 0)
  };
  var array$2 = $g.testFrameworkNames;
  var array$3 = [];
  var i$1 = 0;
  var len$1 = $uI(array$2.length);
  while ((i$1 < len$1)) {
    var index$1 = i$1;
    var arg1$1 = array$2[index$1];
    var xo = this.tryLoadFramework__p1__sjs_js_Array__s_Option(arg1$1);
    var this$6 = xo.toList__sci_List();
    if ((this$6 !== null)) {
      var xs = this$6;
      var xs$1 = xs;
      _loop: while (true) {
        var this$7 = xs$1;
        if ($f_sc_TraversableOnce__nonEmpty__Z(this$7)) {
          var elem$1 = xs$1.head__O();
          array$3.push(elem$1);
          xs$1 = $as_sc_LinearSeq(xs$1.tail__O());
          continue _loop
        };
        break
      }
    } else {
      var these = this$6;
      while ((!these.isEmpty__Z())) {
        var arg1$2 = these.head__O();
        array$3.push(arg1$2);
        these = $as_sci_List(these.tail__O())
      }
    };
    i$1 = ((1 + i$1) | 0)
  };
  var this$9 = $m_sci_List$();
  var cbf = this$9.ReusableCBFInstance$2;
  var b = cbf.apply__scm_Builder();
  var x1$1 = $uI(array$3.length);
  switch (x1$1) {
    case (-1): {
      break
    }
    default: {
      b.sizeHint__I__V(x1$1)
    }
  };
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$3));
  var frameworks = $as_sci_List(b.result__O());
  var f = (function(this$3$1, taskDefs) {
    return (function(framework$2) {
      var framework = $as_Lsbt_testing_Framework(framework$2);
      var fingerprints = framework.fingerprints__ALsbt_testing_Fingerprint();
      var array$4 = [];
      var i$2 = 0;
      var len$2 = $uI(taskDefs.length);
      while ((i$2 < len$2)) {
        var index$2 = i$2;
        var arg1$3 = taskDefs[index$2];
        var taskDef = $as_Lsbt_testing_TaskDef(arg1$3);
        var i$3 = 0;
        while (true) {
          if ((i$3 < fingerprints.u.length)) {
            var index$3 = i$3;
            var arg1$4 = fingerprints.get(index$3);
            var x$1 = $as_Lsbt_testing_Fingerprint(arg1$4);
            var jsx$1 = (this$3$1.fingerprintMatches__p1__Lsbt_testing_Fingerprint__Lsbt_testing_Fingerprint__Z(x$1, taskDef.$$undfingerprint$1) === false)
          } else {
            var jsx$1 = false
          };
          if (jsx$1) {
            i$3 = ((1 + i$3) | 0)
          } else {
            break
          }
        };
        if (((i$3 !== fingerprints.u.length) !== false)) {
          array$4.push(arg1$3)
        };
        i$2 = ((1 + i$2) | 0)
      };
      return new $c_T2().init___O__O(framework, new $c_sjs_js_WrappedArray().init___sjs_js_Array(array$4))
    })
  })(this, array$1);
  var this$16 = $m_sci_List$();
  var bf = this$16.ReusableCBFInstance$2;
  if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
    if ((frameworks === $m_sci_Nil$())) {
      var jsx$2 = $m_sci_Nil$()
    } else {
      var arg1$5 = frameworks.head__O();
      var h = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$5), $m_sci_Nil$());
      var t = h;
      var rest = $as_sci_List(frameworks.tail__O());
      while ((rest !== $m_sci_Nil$())) {
        var arg1$6 = rest.head__O();
        var nx = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$6), $m_sci_Nil$());
        t.tl$5 = nx;
        t = nx;
        rest = $as_sci_List(rest.tail__O())
      };
      var jsx$2 = h
    }
  } else {
    var b$1 = $f_sc_TraversableLike__builder$1__psc_TraversableLike__scg_CanBuildFrom__scm_Builder(frameworks, bf);
    var these$1 = frameworks;
    while ((!these$1.isEmpty__Z())) {
      var arg1$7 = these$1.head__O();
      b$1.$$plus$eq__O__scm_Builder(f(arg1$7));
      these$1 = $as_sci_List(these$1.tail__O())
    };
    var jsx$2 = b$1.result__O()
  };
  return $as_sc_Seq(jsx$2)
});
var $d_Lorg_scalajs_testinterface_TestDetector$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_TestDetector$: 0
}, false, "org.scalajs.testinterface.TestDetector$", {
  Lorg_scalajs_testinterface_TestDetector$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_TestDetector$.prototype.$classData = $d_Lorg_scalajs_testinterface_TestDetector$;
var $n_Lorg_scalajs_testinterface_TestDetector$ = (void 0);
function $m_Lorg_scalajs_testinterface_TestDetector$() {
  if ((!$n_Lorg_scalajs_testinterface_TestDetector$)) {
    $n_Lorg_scalajs_testinterface_TestDetector$ = new $c_Lorg_scalajs_testinterface_TestDetector$().init___()
  };
  return $n_Lorg_scalajs_testinterface_TestDetector$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_BridgeBase() {
  $c_O.call(this);
  this.framework$1 = null
}
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_BridgeBase;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_BridgeBase() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_BridgeBase.prototype = $c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype;
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype.init__V = (function() {
  $g.scalajsCom.init((function(arg$outer) {
    return (function(arg1$2) {
      var arg1 = $as_T(arg1$2);
      arg$outer.handleMsg__p1__T__V(arg1)
    })
  })(this))
});
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype.strArg$1__p1__T__I__T__T = (function(msg$1, pos$1, cmd$1) {
  if ((pos$1 === (-1))) {
    throw new $c_jl_IllegalArgumentException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", " needs args"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([cmd$1])))
  } else {
    var beginIndex = ((1 + pos$1) | 0);
    return $as_T(msg$1.substring(beginIndex))
  }
});
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype.reply__s_util_Try__V = (function(result) {
  var rc8 = false;
  var x2 = null;
  matchEnd9: {
    if ($is_s_util_Success(result)) {
      rc8 = true;
      x2 = $as_s_util_Success(result);
      var p3 = x2.value$2;
      if ((p3 === (void 0))) {
        $g.scalajsCom.send("ok:");
        break matchEnd9
      }
    };
    if (rc8) {
      var v = x2.value$2;
      $g.scalajsCom.send(("ok:" + v));
      break matchEnd9
    };
    if ($is_s_util_Failure(result)) {
      var x5 = $as_s_util_Failure(result);
      var e = x5.exception$2;
      var data = $as_T($g.JSON.stringify($m_Lorg_scalajs_testinterface_internal_ThrowableSerializer$().serialize__jl_Throwable__sjs_js_Dynamic(e)));
      $g.scalajsCom.send(("fail:" + data));
      break matchEnd9
    };
    throw new $c_s_MatchError().init___O(result)
  }
});
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype.$$js$exported$meth$init__O = (function() {
  this.init__V()
});
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype.init___T = (function(frameworkName) {
  this.framework$1 = $m_Lorg_scalajs_testinterface_internal_FrameworkLoader$().loadFramework__T__Lsbt_testing_Framework(frameworkName);
  return this
});
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype.tasks2TaskInfos__ALsbt_testing_Task__Lsbt_testing_Runner__sjs_js_Any = (function(tasks, runner) {
  var elems$2 = null;
  elems$2 = [];
  var x1 = tasks.u.length;
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = tasks.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = tasks.get(index);
    var task = $as_Lsbt_testing_Task(arg1);
    var serTask = runner.serializeTask__Lsbt_testing_Task__F1__T(task, new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
      return (function(taskDef$2) {
        var taskDef = $as_Lsbt_testing_TaskDef(taskDef$2);
        return $as_T($g.JSON.stringify($m_Lorg_scalajs_testinterface_internal_TaskDefSerializer$().serialize__Lsbt_testing_TaskDef__sjs_js_Dynamic(taskDef)))
      })
    })(this)));
    var jsx$2 = $m_Lorg_scalajs_testinterface_internal_TaskDefSerializer$().serialize__Lsbt_testing_TaskDef__sjs_js_Dynamic(task.taskDef__Lsbt_testing_TaskDef());
    var arr = task.tags__AT();
    var $$this = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(arr);
    if ($is_sjs_js_ArrayOps($$this)) {
      var x2 = $as_sjs_js_ArrayOps($$this);
      var jsx$1 = x2.scala$scalajs$js$ArrayOps$$array$f
    } else if ($is_sjs_js_WrappedArray($$this)) {
      var x3 = $as_sjs_js_WrappedArray($$this);
      var jsx$1 = x3.array$6
    } else {
      var result = [];
      var i$1 = 0;
      var len$1 = $$this.length__I();
      while ((i$1 < len$1)) {
        var arg1$1 = $$this.apply__I__O(i$1);
        $uI(result.push(arg1$1));
        i$1 = ((1 + i$1) | 0)
      };
      var jsx$1 = result
    };
    var elem = {
      "serializedTask": serTask,
      "taskDef": jsx$2,
      "tags": jsx$1
    };
    var unboxedElem = ((elem === null) ? null : elem);
    elems$2.push(unboxedElem);
    i = ((1 + i) | 0)
  };
  var arr$1 = $makeNativeArrayWrapper($d_sjs_js_Object.getArrayOf(), elems$2);
  var $$this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(arr$1);
  if ($is_sjs_js_ArrayOps($$this$1)) {
    var x2$1 = $as_sjs_js_ArrayOps($$this$1);
    return x2$1.scala$scalajs$js$ArrayOps$$array$f
  } else if ($is_sjs_js_WrappedArray($$this$1)) {
    var x3$1 = $as_sjs_js_WrappedArray($$this$1);
    return x3$1.array$6
  } else {
    var result$1 = [];
    var i$2 = 0;
    var len$2 = $$this$1.length__I();
    while ((i$2 < len$2)) {
      var arg1$2 = $$this$1.apply__I__O(i$2);
      $uI(result$1.push(arg1$2));
      i$2 = ((1 + i$2) | 0)
    };
    return result$1
  }
});
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype.handleMsg__p1__T__V = (function(msg) {
  var pos = $m_sjsr_RuntimeString$().indexOf__T__I__I(msg, 58);
  var cmd = ((pos === (-1)) ? msg : $as_T(msg.substring(0, pos)));
  try {
    this.handleMsgImpl__T__F0__V(cmd, new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, msg$1, pos$1, cmd$1) {
      return (function() {
        return $this.strArg$1__p1__T__I__T__T(msg$1, pos$1, cmd$1)
      })
    })(this, msg, pos, cmd)))
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      matchEnd8: {
        var o11 = $m_s_util_control_NonFatal$().unapply__jl_Throwable__s_Option(e$2);
        if ((!o11.isEmpty__Z())) {
          var t = $as_jl_Throwable(o11.get__O());
          var data = $as_T($g.JSON.stringify($m_Lorg_scalajs_testinterface_internal_ThrowableSerializer$().serialize__jl_Throwable__sjs_js_Dynamic(t)));
          $g.scalajsCom.send(("bad:" + data));
          break matchEnd8
        };
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
      }
    } else {
      throw e
    }
  }
});
$c_Lorg_scalajs_testinterface_internal_BridgeBase.prototype.init = (function() {
  return this.$$js$exported$meth$init__O()
});
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_FingerprintSerializer$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_FingerprintSerializer$.prototype = $c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$.prototype;
$c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$.prototype.deserialize__sjs_js_Dynamic__Lsbt_testing_Fingerprint = (function(obj) {
  var x1 = $as_T(obj.fpType);
  if ((x1 === "AnnotatedFingerprint")) {
    return new $c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$DeserializedAnnotatedFingerprint().init___Z__T($uZ(obj.isModule), $as_T(obj.annotationName))
  } else if ((x1 === "SubclassFingerprint")) {
    return new $c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$DeserializedSubclassFingerprint().init___Z__T__Z($uZ(obj.isModule), $as_T(obj.superclassName), $uZ(obj.requireNoArgConstructor))
  } else {
    throw new $c_jl_IllegalArgumentException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Unknown Fingerprint type: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([x1])))
  }
});
$c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$.prototype.serialize__Lsbt_testing_Fingerprint__sjs_js_Dynamic = (function(fp) {
  if ($is_Lsbt_testing_AnnotatedFingerprint(fp)) {
    var x2 = $as_Lsbt_testing_AnnotatedFingerprint(fp);
    var value = x2.isModule$1;
    var s = x2.annotationName$1;
    return {
      "fpType": "AnnotatedFingerprint",
      "isModule": value,
      "annotationName": s
    }
  } else if ($is_Lsbt_testing_SubclassFingerprint(fp)) {
    var x3 = $as_Lsbt_testing_SubclassFingerprint(fp);
    var value$1 = x3.isModule$1;
    var s$1 = x3.superclassName$1;
    var value$2 = x3.requireNoArgConstructor$1;
    return {
      "fpType": "SubclassFingerprint",
      "isModule": value$1,
      "superclassName": s$1,
      "requireNoArgConstructor": value$2
    }
  } else {
    throw new $c_jl_IllegalArgumentException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Unknown Fingerprint type: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([$objectGetClass(fp)])))
  }
});
var $d_Lorg_scalajs_testinterface_internal_FingerprintSerializer$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_FingerprintSerializer$: 0
}, false, "org.scalajs.testinterface.internal.FingerprintSerializer$", {
  Lorg_scalajs_testinterface_internal_FingerprintSerializer$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_FingerprintSerializer$;
var $n_Lorg_scalajs_testinterface_internal_FingerprintSerializer$ = (void 0);
function $m_Lorg_scalajs_testinterface_internal_FingerprintSerializer$() {
  if ((!$n_Lorg_scalajs_testinterface_internal_FingerprintSerializer$)) {
    $n_Lorg_scalajs_testinterface_internal_FingerprintSerializer$ = new $c_Lorg_scalajs_testinterface_internal_FingerprintSerializer$().init___()
  };
  return $n_Lorg_scalajs_testinterface_internal_FingerprintSerializer$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_FrameworkDetector$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_FrameworkDetector$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_FrameworkDetector$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype = $c_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype;
$c_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype.frameworkExistsInReflect$1__p1__T__Z = (function(name) {
  var this$1 = $m_sjs_reflect_Reflect$();
  var this$2 = this$1.instantiatableClasses$1.get__O__s_Option(name);
  if ((!this$2.isEmpty__Z())) {
    var arg1 = this$2.get__O();
    var clazz = $as_sjs_reflect_InstantiatableClass(arg1);
    return $d_Lsbt_testing_Framework.getClassOf().isAssignableFrom__jl_Class__Z(clazz.runtimeClass__jl_Class())
  } else {
    return false
  }
});
$c_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype.frameworkExists$1__p1__T__Z = (function(name) {
  return (this.frameworkExistsInReflect$1__p1__T__Z(name) || this.frameworkExistsInExportsNamespace$1__p1__T__Z(name))
});
$c_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype.frameworkExistsInExportsNamespace$1__p1__T__Z = (function(name) {
  var exportsNamespace = $env.exportsNamespace;
  var this$3 = new $c_sci_StringOps().init___T(name);
  var xs = $f_sci_StringLike__split__C__AT(this$3, 46);
  var start = 0;
  var end = xs.u.length;
  var z = exportsNamespace;
  var start$1 = start;
  var z$1 = z;
  var value$1;
  _foldl: while (true) {
    if ((start$1 !== end)) {
      var temp$start = ((1 + start$1) | 0);
      var arg1 = z$1;
      var index = start$1;
      var arg2 = xs.get(index);
      var part = $as_T(arg2);
      if ((arg1 === (void 0))) {
        var temp$z = (void 0)
      } else {
        var value = arg1[part];
        var temp$z = value
      };
      start$1 = temp$start;
      z$1 = temp$z;
      continue _foldl
    };
    var value$1 = z$1;
    break
  };
  return (value$1 !== (void 0))
});
$c_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype.detectFrameworks__sjs_js_Array__sjs_js_Array = (function(frameworksData) {
  var array = [];
  var x1 = $uI(frameworksData.length);
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = $uI(frameworksData.length);
  while ((i < len)) {
    var index = i;
    var arg1 = frameworksData[index];
    var len$1 = $uI(arg1.length);
    var i$1 = 0;
    while (true) {
      if ((i$1 < len$1)) {
        var index$1 = i$1;
        var arg1$1 = arg1[index$1];
        var x$2 = $as_T(arg1$1);
        var jsx$1 = (!this.frameworkExists$1__p1__T__Z(x$2))
      } else {
        var jsx$1 = false
      };
      if (jsx$1) {
        i$1 = ((1 + i$1) | 0)
      } else {
        break
      }
    };
    var i$2 = i$1;
    var opt = ((i$2 < $uI(arg1.length)) ? new $c_s_Some().init___O(arg1[i$2]) : $m_s_None$());
    if (opt.isEmpty__Z()) {
      var elem = (void 0)
    } else {
      var arg1$2 = opt.get__O();
      var elem = arg1$2
    };
    array.push(elem);
    i = ((1 + i) | 0)
  };
  return array
});
var $d_Lorg_scalajs_testinterface_internal_FrameworkDetector$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_FrameworkDetector$: 0
}, false, "org.scalajs.testinterface.internal.FrameworkDetector$", {
  Lorg_scalajs_testinterface_internal_FrameworkDetector$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_FrameworkDetector$.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_FrameworkDetector$;
var $n_Lorg_scalajs_testinterface_internal_FrameworkDetector$ = (void 0);
function $m_Lorg_scalajs_testinterface_internal_FrameworkDetector$() {
  if ((!$n_Lorg_scalajs_testinterface_internal_FrameworkDetector$)) {
    $n_Lorg_scalajs_testinterface_internal_FrameworkDetector$ = new $c_Lorg_scalajs_testinterface_internal_FrameworkDetector$().init___()
  };
  return $n_Lorg_scalajs_testinterface_internal_FrameworkDetector$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_FrameworkLoader$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_FrameworkLoader$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_FrameworkLoader$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype = $c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype;
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.loadFramework__T__Lsbt_testing_Framework = (function(frameworkName) {
  var this$1 = $m_sjs_reflect_Reflect$();
  var this$2 = this$1.instantiatableClasses$1.get__O__s_Option(frameworkName);
  if (this$2.isEmpty__Z()) {
    var exportsNamespace = $env.exportsNamespace;
    var this$5 = new $c_sci_StringOps().init___T(frameworkName);
    var parts = $f_sci_StringLike__split__C__AT(this$5, 46);
    var start = 0;
    var end = parts.u.length;
    var z = exportsNamespace;
    var start$1 = start;
    var z$1 = z;
    var ctor;
    _foldl: while (true) {
      if ((start$1 !== end)) {
        var temp$start = ((1 + start$1) | 0);
        var arg1 = z$1;
        var index = start$1;
        var arg2 = parts.get(index);
        var x$2 = $as_T(arg2);
        var temp$z = arg1[x$2];
        start$1 = temp$start;
        z$1 = temp$z;
        continue _foldl
      };
      var ctor = z$1;
      break
    };
    return $as_Lsbt_testing_Framework(new ctor())
  } else {
    var arg1$1 = this$2.get__O();
    var clazz = $as_sjs_reflect_InstantiatableClass(arg1$1);
    return $as_Lsbt_testing_Framework(clazz.newInstance__O())
  }
});
var $d_Lorg_scalajs_testinterface_internal_FrameworkLoader$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_FrameworkLoader$: 0
}, false, "org.scalajs.testinterface.internal.FrameworkLoader$", {
  Lorg_scalajs_testinterface_internal_FrameworkLoader$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_FrameworkLoader$.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_FrameworkLoader$;
var $n_Lorg_scalajs_testinterface_internal_FrameworkLoader$ = (void 0);
function $m_Lorg_scalajs_testinterface_internal_FrameworkLoader$() {
  if ((!$n_Lorg_scalajs_testinterface_internal_FrameworkLoader$)) {
    $n_Lorg_scalajs_testinterface_internal_FrameworkLoader$ = new $c_Lorg_scalajs_testinterface_internal_FrameworkLoader$().init___()
  };
  return $n_Lorg_scalajs_testinterface_internal_FrameworkLoader$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_InfoSender() {
  $c_O.call(this);
  this.frameworkName$1 = null
}
$c_Lorg_scalajs_testinterface_internal_InfoSender.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_InfoSender.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_InfoSender;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_InfoSender() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_InfoSender.prototype = $c_Lorg_scalajs_testinterface_internal_InfoSender.prototype;
$c_Lorg_scalajs_testinterface_internal_InfoSender.prototype.sendFrameworkInfo__p1__V = (function() {
  var framework = $m_Lorg_scalajs_testinterface_internal_FrameworkLoader$().loadFramework__T__Lsbt_testing_Framework(this.frameworkName$1);
  var xs = framework.fingerprints__ALsbt_testing_Fingerprint();
  var elems$2 = null;
  elems$2 = [];
  var x1 = xs.u.length;
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var fp = $as_Lsbt_testing_Fingerprint(arg1);
    var elem = $m_Lorg_scalajs_testinterface_internal_FingerprintSerializer$().serialize__Lsbt_testing_Fingerprint__sjs_js_Dynamic(fp);
    var unboxedElem = ((elem === null) ? null : elem);
    elems$2.push(unboxedElem);
    i = ((1 + i) | 0)
  };
  var arr = $makeNativeArrayWrapper($d_sjs_js_Dynamic.getArrayOf(), elems$2);
  var $$this = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(arr);
  if ($is_sjs_js_ArrayOps($$this)) {
    var x2 = $as_sjs_js_ArrayOps($$this);
    var fingerprints = x2.scala$scalajs$js$ArrayOps$$array$f
  } else if ($is_sjs_js_WrappedArray($$this)) {
    var x3 = $as_sjs_js_WrappedArray($$this);
    var fingerprints = x3.array$6
  } else {
    var result = [];
    var i$1 = 0;
    var len$1 = $$this.length__I();
    while ((i$1 < len$1)) {
      var arg1$1 = $$this.apply__I__O(i$1);
      $uI(result.push(arg1$1));
      i$1 = ((1 + i$1) | 0)
    };
    var fingerprints = result
  };
  var s = framework.name__T();
  var data = {
    "name": s,
    "fingerprints": fingerprints
  };
  $g.scalajsCom.send($as_T($g.JSON.stringify(data)))
});
$c_Lorg_scalajs_testinterface_internal_InfoSender.prototype.$$js$exported$meth$initAndSend__O = (function() {
  this.initAndSend__V()
});
$c_Lorg_scalajs_testinterface_internal_InfoSender.prototype.initAndSend__V = (function() {
  $g.scalajsCom.init((function(arg$outer) {
    return (function(arg1$2) {
      $as_T(arg1$2)
    })
  })(this));
  this.sendFrameworkInfo__p1__V();
  $g.scalajsCom.close()
});
$c_Lorg_scalajs_testinterface_internal_InfoSender.prototype.init___T = (function(frameworkName) {
  this.frameworkName$1 = frameworkName;
  return this
});
$c_Lorg_scalajs_testinterface_internal_InfoSender.prototype.initAndSend = (function() {
  return this.$$js$exported$meth$initAndSend__O()
});
var $d_Lorg_scalajs_testinterface_internal_InfoSender = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_InfoSender: 0
}, false, "org.scalajs.testinterface.internal.InfoSender", {
  Lorg_scalajs_testinterface_internal_InfoSender: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_InfoSender.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_InfoSender;
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_SelectorSerializer$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_internal_SelectorSerializer$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_SelectorSerializer$.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_SelectorSerializer$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_SelectorSerializer$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_SelectorSerializer$.prototype = $c_Lorg_scalajs_testinterface_internal_SelectorSerializer$.prototype;
$c_Lorg_scalajs_testinterface_internal_SelectorSerializer$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_internal_SelectorSerializer$.prototype.serialize__Lsbt_testing_Selector__sjs_js_Dynamic = (function(sel) {
  if ($is_Lsbt_testing_SuiteSelector(sel)) {
    return {
      "selType": "SuiteSelector"
    }
  } else if ($is_Lsbt_testing_TestSelector(sel)) {
    var x3 = $as_Lsbt_testing_TestSelector(sel);
    var s = x3.$$undtestName$2;
    return {
      "selType": "TestSelector",
      "testName": s
    }
  } else if ($is_Lsbt_testing_NestedSuiteSelector(sel)) {
    var x4 = $as_Lsbt_testing_NestedSuiteSelector(sel);
    var s$1 = x4.$$undsuiteId$2;
    return {
      "selType": "NestedSuiteSelector",
      "suiteId": s$1
    }
  } else if ($is_Lsbt_testing_NestedTestSelector(sel)) {
    var x5 = $as_Lsbt_testing_NestedTestSelector(sel);
    var s$2 = x5.$$undsuiteId$2;
    var s$3 = x5.$$undtestName$2;
    return {
      "selType": "NestedTestSelector",
      "suiteId": s$2,
      "testName": s$3
    }
  } else if ($is_Lsbt_testing_TestWildcardSelector(sel)) {
    var x6 = $as_Lsbt_testing_TestWildcardSelector(sel);
    var s$4 = x6.$$undtestWildcard$2;
    return {
      "selType": "TestWildcardSelector",
      "testWildcard": s$4
    }
  } else {
    throw new $c_jl_IllegalArgumentException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Unknown Selector type: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([$objectGetClass(sel)])))
  }
});
$c_Lorg_scalajs_testinterface_internal_SelectorSerializer$.prototype.deserialize__sjs_js_Dynamic__Lsbt_testing_Selector = (function(obj) {
  var x1 = $as_T(obj.selType);
  if ((x1 === "SuiteSelector")) {
    return new $c_Lsbt_testing_SuiteSelector().init___()
  } else if ((x1 === "TestSelector")) {
    return new $c_Lsbt_testing_TestSelector().init___T($as_T(obj.testName))
  } else if ((x1 === "NestedSuiteSelector")) {
    return new $c_Lsbt_testing_NestedSuiteSelector().init___T($as_T(obj.suiteId))
  } else if ((x1 === "NestedTestSelector")) {
    return new $c_Lsbt_testing_NestedTestSelector().init___T__T($as_T(obj.suiteId), $as_T(obj.testName))
  } else if ((x1 === "TestWildcardSelector")) {
    return new $c_Lsbt_testing_TestWildcardSelector().init___T($as_T(obj.testWildcard))
  } else {
    throw new $c_jl_IllegalArgumentException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Unknown Selector type: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([x1])))
  }
});
var $d_Lorg_scalajs_testinterface_internal_SelectorSerializer$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_SelectorSerializer$: 0
}, false, "org.scalajs.testinterface.internal.SelectorSerializer$", {
  Lorg_scalajs_testinterface_internal_SelectorSerializer$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_SelectorSerializer$.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_SelectorSerializer$;
var $n_Lorg_scalajs_testinterface_internal_SelectorSerializer$ = (void 0);
function $m_Lorg_scalajs_testinterface_internal_SelectorSerializer$() {
  if ((!$n_Lorg_scalajs_testinterface_internal_SelectorSerializer$)) {
    $n_Lorg_scalajs_testinterface_internal_SelectorSerializer$ = new $c_Lorg_scalajs_testinterface_internal_SelectorSerializer$().init___()
  };
  return $n_Lorg_scalajs_testinterface_internal_SelectorSerializer$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_Slave$Invalidatable() {
  $c_O.call(this);
  this.valid$1 = false;
  this.$$outer$1 = null
}
$c_Lorg_scalajs_testinterface_internal_Slave$Invalidatable.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_Slave$Invalidatable.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_Slave$Invalidatable;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_Slave$Invalidatable() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_Slave$Invalidatable.prototype = $c_Lorg_scalajs_testinterface_internal_Slave$Invalidatable.prototype;
$c_Lorg_scalajs_testinterface_internal_Slave$Invalidatable.prototype.ensureValid__V = (function() {
  if ((!this.valid$1)) {
    throw new $c_jl_IllegalStateException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", " has been invalidated"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this])))
  }
});
$c_Lorg_scalajs_testinterface_internal_Slave$Invalidatable.prototype.org$scalajs$testinterface$internal$Slave$$invalidate__V = (function() {
  this.valid$1 = false
});
$c_Lorg_scalajs_testinterface_internal_Slave$Invalidatable.prototype.init___Lorg_scalajs_testinterface_internal_Slave = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  this.valid$1 = true;
  return this
});
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_TaskDefSerializer$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_TaskDefSerializer$.prototype = $c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$.prototype;
$c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$.prototype.deserialize__sjs_js_Dynamic__Lsbt_testing_TaskDef = (function(obj) {
  var array = obj.selectors;
  var array$1 = [];
  var x1 = $uI(array.length);
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = $uI(array.length);
  while ((i < len)) {
    var index = i;
    var arg1 = array[index];
    var elem = $m_Lorg_scalajs_testinterface_internal_SelectorSerializer$().deserialize__sjs_js_Dynamic__Lsbt_testing_Selector(arg1);
    array$1.push(elem);
    i = ((1 + i) | 0)
  };
  var len$1 = $uI(array$1.length);
  var result = $newArrayObject($d_Lsbt_testing_Selector.getArrayOf(), [len$1]);
  var len$2 = result.u.length;
  var i$1 = 0;
  var j = 0;
  var x = $uI(array$1.length);
  var x$1 = ((x < len$2) ? x : len$2);
  var that = result.u.length;
  var end = ((x$1 < that) ? x$1 : that);
  while ((i$1 < end)) {
    var jsx$1 = j;
    var index$1 = i$1;
    result.set(jsx$1, array$1[index$1]);
    i$1 = ((1 + i$1) | 0);
    j = ((1 + j) | 0)
  };
  return new $c_Lsbt_testing_TaskDef().init___T__Lsbt_testing_Fingerprint__Z__ALsbt_testing_Selector($as_T(obj.fullyQualifiedName), $m_Lorg_scalajs_testinterface_internal_FingerprintSerializer$().deserialize__sjs_js_Dynamic__Lsbt_testing_Fingerprint(obj.fingerprint), $uZ(obj.explicitlySpecified), result)
});
$c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$.prototype.serialize__Lsbt_testing_TaskDef__sjs_js_Dynamic = (function(td) {
  var s = td.$$undfullyQualifiedName$1;
  var jsx$2 = $m_Lorg_scalajs_testinterface_internal_FingerprintSerializer$().serialize__Lsbt_testing_Fingerprint__sjs_js_Dynamic(td.$$undfingerprint$1);
  var value = td.$$undexplicitlySpecified$1;
  var xs = td.$$undselectors$1;
  var elems$2 = null;
  elems$2 = [];
  var x1 = xs.u.length;
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var sel = $as_Lsbt_testing_Selector(arg1);
    var elem = $m_Lorg_scalajs_testinterface_internal_SelectorSerializer$().serialize__Lsbt_testing_Selector__sjs_js_Dynamic(sel);
    var unboxedElem = ((elem === null) ? null : elem);
    elems$2.push(unboxedElem);
    i = ((1 + i) | 0)
  };
  var arr = $makeNativeArrayWrapper($d_sjs_js_Dynamic.getArrayOf(), elems$2);
  var $$this = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(arr);
  if ($is_sjs_js_ArrayOps($$this)) {
    var x2 = $as_sjs_js_ArrayOps($$this);
    var jsx$1 = x2.scala$scalajs$js$ArrayOps$$array$f
  } else if ($is_sjs_js_WrappedArray($$this)) {
    var x3 = $as_sjs_js_WrappedArray($$this);
    var jsx$1 = x3.array$6
  } else {
    var result = [];
    var i$1 = 0;
    var len$1 = $$this.length__I();
    while ((i$1 < len$1)) {
      var arg1$1 = $$this.apply__I__O(i$1);
      $uI(result.push(arg1$1));
      i$1 = ((1 + i$1) | 0)
    };
    var jsx$1 = result
  };
  return {
    "fullyQualifiedName": s,
    "fingerprint": jsx$2,
    "explicitlySpecified": value,
    "selectors": jsx$1
  }
});
var $d_Lorg_scalajs_testinterface_internal_TaskDefSerializer$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_TaskDefSerializer$: 0
}, false, "org.scalajs.testinterface.internal.TaskDefSerializer$", {
  Lorg_scalajs_testinterface_internal_TaskDefSerializer$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_TaskDefSerializer$;
var $n_Lorg_scalajs_testinterface_internal_TaskDefSerializer$ = (void 0);
function $m_Lorg_scalajs_testinterface_internal_TaskDefSerializer$() {
  if ((!$n_Lorg_scalajs_testinterface_internal_TaskDefSerializer$)) {
    $n_Lorg_scalajs_testinterface_internal_TaskDefSerializer$ = new $c_Lorg_scalajs_testinterface_internal_TaskDefSerializer$().init___()
  };
  return $n_Lorg_scalajs_testinterface_internal_TaskDefSerializer$
}
/** @constructor */
function $c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$() {
  $c_O.call(this)
}
$c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$.prototype = new $h_O();
$c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$.prototype.constructor = $c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$;
/** @constructor */
function $h_Lorg_scalajs_testinterface_internal_ThrowableSerializer$() {
  /*<skip>*/
}
$h_Lorg_scalajs_testinterface_internal_ThrowableSerializer$.prototype = $c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$.prototype;
$c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$.prototype.init___ = (function() {
  return this
});
$c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$.prototype.serialize__jl_Throwable__sjs_js_Dynamic = (function(t) {
  var s = $objectGetClass(t).toString__T();
  var s$1 = t.getMessage__T();
  var s$2 = t.toString__T();
  var xs = t.getStackTrace__Ajl_StackTraceElement();
  var elems$2 = null;
  elems$2 = [];
  var x1 = xs.u.length;
  switch (x1) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = xs.u.length;
  while ((i < len)) {
    var index = i;
    var arg1 = xs.get(index);
    var e = $as_jl_StackTraceElement(arg1);
    var elem = this.serializeTraceElem__p1__jl_StackTraceElement__sjs_js_Dynamic(e);
    var unboxedElem = ((elem === null) ? null : elem);
    elems$2.push(unboxedElem);
    i = ((1 + i) | 0)
  };
  var arr = $makeNativeArrayWrapper($d_sjs_js_Dynamic.getArrayOf(), elems$2);
  var $$this = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(arr);
  if ($is_sjs_js_ArrayOps($$this)) {
    var x2 = $as_sjs_js_ArrayOps($$this);
    var jsx$1 = x2.scala$scalajs$js$ArrayOps$$array$f
  } else if ($is_sjs_js_WrappedArray($$this)) {
    var x3 = $as_sjs_js_WrappedArray($$this);
    var jsx$1 = x3.array$6
  } else {
    var result = [];
    var i$1 = 0;
    var len$1 = $$this.length__I();
    while ((i$1 < len$1)) {
      var arg1$1 = $$this.apply__I__O(i$1);
      $uI(result.push(arg1$1));
      i$1 = ((1 + i$1) | 0)
    };
    var jsx$1 = result
  };
  var res = {
    "class": s,
    "message": s$1,
    "toString": s$2,
    "stackTrace": jsx$1
  };
  if ((t.e$1 !== null)) {
    res.cause = this.serialize__jl_Throwable__sjs_js_Dynamic(t.e$1)
  };
  return res
});
$c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$.prototype.serializeTraceElem__p1__jl_StackTraceElement__sjs_js_Dynamic = (function(e) {
  var s = e.declaringClass$1;
  var s$1 = e.methodName$1;
  var s$2 = e.fileName$1;
  var value = e.lineNumber$1;
  return {
    "className": s,
    "methodName": s$1,
    "fileName": s$2,
    "lineNumber": value
  }
});
var $d_Lorg_scalajs_testinterface_internal_ThrowableSerializer$ = new $TypeData().initClass({
  Lorg_scalajs_testinterface_internal_ThrowableSerializer$: 0
}, false, "org.scalajs.testinterface.internal.ThrowableSerializer$", {
  Lorg_scalajs_testinterface_internal_ThrowableSerializer$: 1,
  O: 1
});
$c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$.prototype.$classData = $d_Lorg_scalajs_testinterface_internal_ThrowableSerializer$;
var $n_Lorg_scalajs_testinterface_internal_ThrowableSerializer$ = (void 0);
function $m_Lorg_scalajs_testinterface_internal_ThrowableSerializer$() {
  if ((!$n_Lorg_scalajs_testinterface_internal_ThrowableSerializer$)) {
    $n_Lorg_scalajs_testinterface_internal_ThrowableSerializer$ = new $c_Lorg_scalajs_testinterface_internal_ThrowableSerializer$().init___()
  };
  return $n_Lorg_scalajs_testinterface_internal_ThrowableSerializer$
}
/** @constructor */
function $c_Lreactify_AbstractState$() {
  $c_O.call(this);
  this.reactify$AbstractState$$observables$1 = null
}
$c_Lreactify_AbstractState$.prototype = new $h_O();
$c_Lreactify_AbstractState$.prototype.constructor = $c_Lreactify_AbstractState$;
/** @constructor */
function $h_Lreactify_AbstractState$() {
  /*<skip>*/
}
$h_Lreactify_AbstractState$.prototype = $c_Lreactify_AbstractState$.prototype;
$c_Lreactify_AbstractState$.prototype.init___ = (function() {
  $n_Lreactify_AbstractState$ = this;
  this.reactify$AbstractState$$observables$1 = new $c_jl_ThreadLocal().init___();
  return this
});
$c_Lreactify_AbstractState$.prototype.reference__Lreactify_Observable__V = (function(observable) {
  var x1 = $m_s_Option$().apply__O__s_Option(this.reactify$AbstractState$$observables$1.get__O());
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var obs = $as_sci_Set(x2.value$2);
    this.reactify$AbstractState$$observables$1.set__O__V(obs.$$plus__O__sc_Set(observable))
  } else {
    var x = $m_s_None$();
    if ((!(x === x1))) {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
var $d_Lreactify_AbstractState$ = new $TypeData().initClass({
  Lreactify_AbstractState$: 0
}, false, "reactify.AbstractState$", {
  Lreactify_AbstractState$: 1,
  O: 1
});
$c_Lreactify_AbstractState$.prototype.$classData = $d_Lreactify_AbstractState$;
var $n_Lreactify_AbstractState$ = (void 0);
function $m_Lreactify_AbstractState$() {
  if ((!$n_Lreactify_AbstractState$)) {
    $n_Lreactify_AbstractState$ = new $c_Lreactify_AbstractState$().init___()
  };
  return $n_Lreactify_AbstractState$
}
/** @constructor */
function $c_Lreactify_ChangeListener$() {
  $c_O.call(this)
}
$c_Lreactify_ChangeListener$.prototype = new $h_O();
$c_Lreactify_ChangeListener$.prototype.constructor = $c_Lreactify_ChangeListener$;
/** @constructor */
function $h_Lreactify_ChangeListener$() {
  /*<skip>*/
}
$h_Lreactify_ChangeListener$.prototype = $c_Lreactify_ChangeListener$.prototype;
$c_Lreactify_ChangeListener$.prototype.init___ = (function() {
  return this
});
$c_Lreactify_ChangeListener$.prototype.createFunction__Lreactify_ChangeListener__s_Option__F1 = (function(listener, initialValue) {
  var previous = new $c_sr_ObjectRef().init___O(initialValue);
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, listener$1, previous$1) {
    return (function(t$2) {
      var this$2 = $as_s_Option(previous$1.elem$1);
      if ((!this$2.isEmpty__Z())) {
        var arg1 = this$2.get__O();
        listener$1.change__O__O__V(arg1, t$2)
      };
      previous$1.elem$1 = new $c_s_Some().init___O(t$2)
    })
  })(this, listener, previous))
});
var $d_Lreactify_ChangeListener$ = new $TypeData().initClass({
  Lreactify_ChangeListener$: 0
}, false, "reactify.ChangeListener$", {
  Lreactify_ChangeListener$: 1,
  O: 1
});
$c_Lreactify_ChangeListener$.prototype.$classData = $d_Lreactify_ChangeListener$;
var $n_Lreactify_ChangeListener$ = (void 0);
function $m_Lreactify_ChangeListener$() {
  if ((!$n_Lreactify_ChangeListener$)) {
    $n_Lreactify_ChangeListener$ = new $c_Lreactify_ChangeListener$().init___()
  };
  return $n_Lreactify_ChangeListener$
}
/** @constructor */
function $c_Lreactify_Invocation() {
  $c_O.call(this);
  this.stopped$1 = false
}
$c_Lreactify_Invocation.prototype = new $h_O();
$c_Lreactify_Invocation.prototype.constructor = $c_Lreactify_Invocation;
/** @constructor */
function $h_Lreactify_Invocation() {
  /*<skip>*/
}
$h_Lreactify_Invocation.prototype = $c_Lreactify_Invocation.prototype;
$c_Lreactify_Invocation.prototype.init___ = (function() {
  this.stopped$1 = false;
  return this
});
function $is_Lreactify_Invocation(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_Invocation)))
}
function $as_Lreactify_Invocation(obj) {
  return (($is_Lreactify_Invocation(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.Invocation"))
}
function $isArrayOf_Lreactify_Invocation(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_Invocation)))
}
function $asArrayOf_Lreactify_Invocation(obj, depth) {
  return (($isArrayOf_Lreactify_Invocation(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.Invocation;", depth))
}
var $d_Lreactify_Invocation = new $TypeData().initClass({
  Lreactify_Invocation: 0
}, false, "reactify.Invocation", {
  Lreactify_Invocation: 1,
  O: 1
});
$c_Lreactify_Invocation.prototype.$classData = $d_Lreactify_Invocation;
/** @constructor */
function $c_Lreactify_Invocation$() {
  $c_O.call(this);
  this.instances$1 = null
}
$c_Lreactify_Invocation$.prototype = new $h_O();
$c_Lreactify_Invocation$.prototype.constructor = $c_Lreactify_Invocation$;
/** @constructor */
function $h_Lreactify_Invocation$() {
  /*<skip>*/
}
$h_Lreactify_Invocation$.prototype = $c_Lreactify_Invocation$.prototype;
$c_Lreactify_Invocation$.prototype.init___ = (function() {
  $n_Lreactify_Invocation$ = this;
  this.instances$1 = new $c_Lreactify_Invocation$$anon$1().init___();
  return this
});
var $d_Lreactify_Invocation$ = new $TypeData().initClass({
  Lreactify_Invocation$: 0
}, false, "reactify.Invocation$", {
  Lreactify_Invocation$: 1,
  O: 1
});
$c_Lreactify_Invocation$.prototype.$classData = $d_Lreactify_Invocation$;
var $n_Lreactify_Invocation$ = (void 0);
function $m_Lreactify_Invocation$() {
  if ((!$n_Lreactify_Invocation$)) {
    $n_Lreactify_Invocation$ = new $c_Lreactify_Invocation$().init___()
  };
  return $n_Lreactify_Invocation$
}
/** @constructor */
function $c_Lreactify_Listener$Priority$() {
  $c_O.call(this);
  this.Lowest$1 = 0.0;
  this.Low$1 = 0.0;
  this.Normal$1 = 0.0;
  this.High$1 = 0.0;
  this.Highest$1 = 0.0
}
$c_Lreactify_Listener$Priority$.prototype = new $h_O();
$c_Lreactify_Listener$Priority$.prototype.constructor = $c_Lreactify_Listener$Priority$;
/** @constructor */
function $h_Lreactify_Listener$Priority$() {
  /*<skip>*/
}
$h_Lreactify_Listener$Priority$.prototype = $c_Lreactify_Listener$Priority$.prototype;
$c_Lreactify_Listener$Priority$.prototype.init___ = (function() {
  $n_Lreactify_Listener$Priority$ = this;
  this.Lowest$1 = $m_s_Double$().MinValue$1;
  this.Low$1 = (-100.0);
  this.Normal$1 = 0.0;
  this.High$1 = 100.0;
  this.Highest$1 = 1.7976931348623157E308;
  return this
});
var $d_Lreactify_Listener$Priority$ = new $TypeData().initClass({
  Lreactify_Listener$Priority$: 0
}, false, "reactify.Listener$Priority$", {
  Lreactify_Listener$Priority$: 1,
  O: 1
});
$c_Lreactify_Listener$Priority$.prototype.$classData = $d_Lreactify_Listener$Priority$;
var $n_Lreactify_Listener$Priority$ = (void 0);
function $m_Lreactify_Listener$Priority$() {
  if ((!$n_Lreactify_Listener$Priority$)) {
    $n_Lreactify_Listener$Priority$ = new $c_Lreactify_Listener$Priority$().init___()
  };
  return $n_Lreactify_Listener$Priority$
}
/** @constructor */
function $c_Lreactify_PreviousFunction() {
  $c_O.call(this);
  this.function$1 = null;
  this.previous$1 = null
}
$c_Lreactify_PreviousFunction.prototype = new $h_O();
$c_Lreactify_PreviousFunction.prototype.constructor = $c_Lreactify_PreviousFunction;
/** @constructor */
function $h_Lreactify_PreviousFunction() {
  /*<skip>*/
}
$h_Lreactify_PreviousFunction.prototype = $c_Lreactify_PreviousFunction.prototype;
$c_Lreactify_PreviousFunction.prototype.init___F0__s_Option = (function($function, previous) {
  this.function$1 = $function;
  this.previous$1 = previous;
  return this
});
function $is_Lreactify_PreviousFunction(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lreactify_PreviousFunction)))
}
function $as_Lreactify_PreviousFunction(obj) {
  return (($is_Lreactify_PreviousFunction(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "reactify.PreviousFunction"))
}
function $isArrayOf_Lreactify_PreviousFunction(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lreactify_PreviousFunction)))
}
function $asArrayOf_Lreactify_PreviousFunction(obj, depth) {
  return (($isArrayOf_Lreactify_PreviousFunction(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lreactify.PreviousFunction;", depth))
}
var $d_Lreactify_PreviousFunction = new $TypeData().initClass({
  Lreactify_PreviousFunction: 0
}, false, "reactify.PreviousFunction", {
  Lreactify_PreviousFunction: 1,
  O: 1
});
$c_Lreactify_PreviousFunction.prototype.$classData = $d_Lreactify_PreviousFunction;
function $f_Lreactify_State__attachAndFire__F1__Lreactify_Listener($thiz, f) {
  var listener = $thiz.attach__F1__D__Lreactify_Listener(f, $thiz.attach$default$2__D());
  $thiz.fire__O__V($thiz.get__O());
  return listener
}
function $f_Lreactify_State__changes__Lreactify_ChangeListener__Lreactify_Listener($thiz, listener) {
  return $thiz.attach__F1__D__Lreactify_Listener($m_Lreactify_ChangeListener$().createFunction__Lreactify_ChangeListener__s_Option__F1(listener, new $c_s_Some().init___O($thiz.get__O())), $thiz.attach$default$2__D())
}
/** @constructor */
function $c_Lreactify_Trigger() {
  $c_O.call(this);
  this.channel$1 = null
}
$c_Lreactify_Trigger.prototype = new $h_O();
$c_Lreactify_Trigger.prototype.constructor = $c_Lreactify_Trigger;
/** @constructor */
function $h_Lreactify_Trigger() {
  /*<skip>*/
}
$h_Lreactify_Trigger.prototype = $c_Lreactify_Trigger.prototype;
$c_Lreactify_Trigger.prototype.init___ = (function() {
  this.channel$1 = new $c_Lreactify_Channel$$anon$1().init___();
  return this
});
var $d_Lreactify_Trigger = new $TypeData().initClass({
  Lreactify_Trigger: 0
}, false, "reactify.Trigger", {
  Lreactify_Trigger: 1,
  O: 1
});
$c_Lreactify_Trigger.prototype.$classData = $d_Lreactify_Trigger;
/** @constructor */
function $c_Lreactify_Val$() {
  $c_O.call(this)
}
$c_Lreactify_Val$.prototype = new $h_O();
$c_Lreactify_Val$.prototype.constructor = $c_Lreactify_Val$;
/** @constructor */
function $h_Lreactify_Val$() {
  /*<skip>*/
}
$h_Lreactify_Val$.prototype = $c_Lreactify_Val$.prototype;
$c_Lreactify_Val$.prototype.init___ = (function() {
  return this
});
$c_Lreactify_Val$.prototype.apply__F0__Z__Z__Z__Lreactify_Val = (function(value, $static, distinct, cache) {
  if ($static) {
    var v = value.apply__O();
    var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, v$1) {
      return (function() {
        return v$1
      })
    })(this, v))
  } else {
    var f = value
  };
  return new $c_Lreactify_Val().init___F0__Z__Z(f, distinct, cache)
});
var $d_Lreactify_Val$ = new $TypeData().initClass({
  Lreactify_Val$: 0
}, false, "reactify.Val$", {
  Lreactify_Val$: 1,
  O: 1
});
$c_Lreactify_Val$.prototype.$classData = $d_Lreactify_Val$;
var $n_Lreactify_Val$ = (void 0);
function $m_Lreactify_Val$() {
  if ((!$n_Lreactify_Val$)) {
    $n_Lreactify_Val$ = new $c_Lreactify_Val$().init___()
  };
  return $n_Lreactify_Val$
}
/** @constructor */
function $c_Lreactify_Var$() {
  $c_O.call(this)
}
$c_Lreactify_Var$.prototype = new $h_O();
$c_Lreactify_Var$.prototype.constructor = $c_Lreactify_Var$;
/** @constructor */
function $h_Lreactify_Var$() {
  /*<skip>*/
}
$h_Lreactify_Var$.prototype = $c_Lreactify_Var$.prototype;
$c_Lreactify_Var$.prototype.init___ = (function() {
  return this
});
$c_Lreactify_Var$.prototype.apply__F0__Z__Z__Z__Lreactify_Var = (function(value, $static, distinct, cache) {
  if ($static) {
    var v = value.apply__O();
    var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, v$1) {
      return (function() {
        return v$1
      })
    })(this, v))
  } else {
    var f = value
  };
  return new $c_Lreactify_Var().init___F0__Z__Z(f, distinct, cache)
});
$c_Lreactify_Var$.prototype.bound__F0__F1__Z__Z__Z__Z__Lreactify_Var = (function(get, set, setImmediately, $static, distinct, cache) {
  var v = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(get, $static, distinct, cache);
  if (setImmediately) {
    set.apply__O__O(v.get__O())
  };
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, set$1) {
    return (function(t$2) {
      set$1.apply__O__O(t$2)
    })
  })(this, set));
  var priority = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(v, f, priority);
  return v
});
var $d_Lreactify_Var$ = new $TypeData().initClass({
  Lreactify_Var$: 0
}, false, "reactify.Var$", {
  Lreactify_Var$: 1,
  O: 1
});
$c_Lreactify_Var$.prototype.$classData = $d_Lreactify_Var$;
var $n_Lreactify_Var$ = (void 0);
function $m_Lreactify_Var$() {
  if ((!$n_Lreactify_Var$)) {
    $n_Lreactify_Var$ = new $c_Lreactify_Var$().init___()
  };
  return $n_Lreactify_Var$
}
/** @constructor */
function $c_Lreactify_package$() {
  $c_O.call(this);
  this.intConnector$1 = null;
  this.doubleConnector$1 = null
}
$c_Lreactify_package$.prototype = new $h_O();
$c_Lreactify_package$.prototype.constructor = $c_Lreactify_package$;
/** @constructor */
function $h_Lreactify_package$() {
  /*<skip>*/
}
$h_Lreactify_package$.prototype = $c_Lreactify_package$.prototype;
$c_Lreactify_package$.prototype.init___ = (function() {
  $n_Lreactify_package$ = this;
  this.intConnector$1 = new $c_Lreactify_package$$anon$1().init___();
  this.doubleConnector$1 = new $c_Lreactify_package$$anon$2().init___();
  return this
});
var $d_Lreactify_package$ = new $TypeData().initClass({
  Lreactify_package$: 0
}, false, "reactify.package$", {
  Lreactify_package$: 1,
  O: 1
});
$c_Lreactify_package$.prototype.$classData = $d_Lreactify_package$;
var $n_Lreactify_package$ = (void 0);
function $m_Lreactify_package$() {
  if ((!$n_Lreactify_package$)) {
    $n_Lreactify_package$ = new $c_Lreactify_package$().init___()
  };
  return $n_Lreactify_package$
}
/** @constructor */
function $c_Lreactify_package$VectorStateChannel() {
  $c_O.call(this);
  this.v$1 = null
}
$c_Lreactify_package$VectorStateChannel.prototype = new $h_O();
$c_Lreactify_package$VectorStateChannel.prototype.constructor = $c_Lreactify_package$VectorStateChannel;
/** @constructor */
function $h_Lreactify_package$VectorStateChannel() {
  /*<skip>*/
}
$h_Lreactify_package$VectorStateChannel.prototype = $c_Lreactify_package$VectorStateChannel.prototype;
$c_Lreactify_package$VectorStateChannel.prototype.init___Lreactify_StateChannel = (function(v) {
  this.v$1 = v;
  return this
});
$c_Lreactify_package$VectorStateChannel.prototype.$$plus$eq__O__V = (function(t) {
  var this$2 = this.v$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, t$1) {
    return (function() {
      return $as_sci_Vector($as_sci_Vector($this.v$1.apply__O()).$$colon$plus__O__scg_CanBuildFrom__O(t$1, ($m_sci_Vector$(), $m_sc_IndexedSeq$().ReusableCBF$6)))
    })
  })(this, t));
  this$2.set__F0__V(value)
});
var $d_Lreactify_package$VectorStateChannel = new $TypeData().initClass({
  Lreactify_package$VectorStateChannel: 0
}, false, "reactify.package$VectorStateChannel", {
  Lreactify_package$VectorStateChannel: 1,
  O: 1
});
$c_Lreactify_package$VectorStateChannel.prototype.$classData = $d_Lreactify_package$VectorStateChannel;
function $is_Lsbt_testing_AnnotatedFingerprint(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_AnnotatedFingerprint)))
}
function $as_Lsbt_testing_AnnotatedFingerprint(obj) {
  return (($is_Lsbt_testing_AnnotatedFingerprint(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.AnnotatedFingerprint"))
}
function $isArrayOf_Lsbt_testing_AnnotatedFingerprint(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_AnnotatedFingerprint)))
}
function $asArrayOf_Lsbt_testing_AnnotatedFingerprint(obj, depth) {
  return (($isArrayOf_Lsbt_testing_AnnotatedFingerprint(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.AnnotatedFingerprint;", depth))
}
/** @constructor */
function $c_Lsbt_testing_Selector() {
  $c_O.call(this)
}
$c_Lsbt_testing_Selector.prototype = new $h_O();
$c_Lsbt_testing_Selector.prototype.constructor = $c_Lsbt_testing_Selector;
/** @constructor */
function $h_Lsbt_testing_Selector() {
  /*<skip>*/
}
$h_Lsbt_testing_Selector.prototype = $c_Lsbt_testing_Selector.prototype;
function $is_Lsbt_testing_Selector(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_Selector)))
}
function $as_Lsbt_testing_Selector(obj) {
  return (($is_Lsbt_testing_Selector(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.Selector"))
}
function $isArrayOf_Lsbt_testing_Selector(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_Selector)))
}
function $asArrayOf_Lsbt_testing_Selector(obj, depth) {
  return (($isArrayOf_Lsbt_testing_Selector(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.Selector;", depth))
}
var $d_Lsbt_testing_Selector = new $TypeData().initClass({
  Lsbt_testing_Selector: 0
}, false, "sbt.testing.Selector", {
  Lsbt_testing_Selector: 1,
  O: 1
});
$c_Lsbt_testing_Selector.prototype.$classData = $d_Lsbt_testing_Selector;
function $is_Lsbt_testing_SubclassFingerprint(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lsbt_testing_SubclassFingerprint)))
}
function $as_Lsbt_testing_SubclassFingerprint(obj) {
  return (($is_Lsbt_testing_SubclassFingerprint(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "sbt.testing.SubclassFingerprint"))
}
function $isArrayOf_Lsbt_testing_SubclassFingerprint(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lsbt_testing_SubclassFingerprint)))
}
function $asArrayOf_Lsbt_testing_SubclassFingerprint(obj, depth) {
  return (($isArrayOf_Lsbt_testing_SubclassFingerprint(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lsbt.testing.SubclassFingerprint;", depth))
}
/** @constructor */
function $c_Lscribe_Level() {
  $c_O.call(this);
  this.name$1 = null;
  this.value$1 = 0.0
}
$c_Lscribe_Level.prototype = new $h_O();
$c_Lscribe_Level.prototype.constructor = $c_Lscribe_Level;
/** @constructor */
function $h_Lscribe_Level() {
  /*<skip>*/
}
$h_Lscribe_Level.prototype = $c_Lscribe_Level.prototype;
$c_Lscribe_Level.prototype.init___T__D = (function(name, value) {
  this.name$1 = name;
  this.value$1 = value;
  var jsx$1 = $m_Lscribe_Level$();
  var x = $m_Lscribe_Level$().scribe$Level$$maxLength$1;
  var y = $uI(name.length);
  jsx$1.scribe$Level$$maxLength$1 = ((x > y) ? x : y);
  return this
});
$c_Lscribe_Level.prototype.namePaddedRight__T = (function() {
  var x = this.name$1;
  var this$3 = new $c_sci_StringOps().init___T(x);
  var len = $m_Lscribe_Level$().scribe$Level$$maxLength$1;
  var this$2 = $m_s_Predef$();
  var bf = new $c_s_LowPriorityImplicits$$anon$4().init___s_LowPriorityImplicits(this$2);
  return $as_sc_TraversableOnce($f_sc_SeqLike__padTo__I__O__scg_CanBuildFrom__O(this$3, len, " ", bf)).mkString__T()
});
/** @constructor */
function $c_Lscribe_Level$() {
  $c_O.call(this);
  this.scribe$Level$$maxLength$1 = 0
}
$c_Lscribe_Level$.prototype = new $h_O();
$c_Lscribe_Level$.prototype.constructor = $c_Lscribe_Level$;
/** @constructor */
function $h_Lscribe_Level$() {
  /*<skip>*/
}
$h_Lscribe_Level$.prototype = $c_Lscribe_Level$.prototype;
$c_Lscribe_Level$.prototype.init___ = (function() {
  this.scribe$Level$$maxLength$1 = 0;
  return this
});
var $d_Lscribe_Level$ = new $TypeData().initClass({
  Lscribe_Level$: 0
}, false, "scribe.Level$", {
  Lscribe_Level$: 1,
  O: 1
});
$c_Lscribe_Level$.prototype.$classData = $d_Lscribe_Level$;
var $n_Lscribe_Level$ = (void 0);
function $m_Lscribe_Level$() {
  if ((!$n_Lscribe_Level$)) {
    $n_Lscribe_Level$ = new $c_Lscribe_Level$().init___()
  };
  return $n_Lscribe_Level$
}
/** @constructor */
function $c_Lscribe_LogRecord() {
  $c_O.call(this);
  this.scribe$LogRecord$$$undlevel$1 = null;
  this.scribe$LogRecord$$$undvalue$1 = 0.0;
  this.scribe$LogRecord$$$undmessageFunction$1 = null;
  this.scribe$LogRecord$$$undclassName$1 = null;
  this.scribe$LogRecord$$$undmethodName$1 = null;
  this.scribe$LogRecord$$$undlineNumber$1 = 0;
  this.scribe$LogRecord$$$undthreadId$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.scribe$LogRecord$$$undthreadName$1 = null;
  this.scribe$LogRecord$$$undtimestamp$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.scribe$LogRecord$$$undmessage$1 = null
}
$c_Lscribe_LogRecord.prototype = new $h_O();
$c_Lscribe_LogRecord.prototype.constructor = $c_Lscribe_LogRecord;
/** @constructor */
function $h_Lscribe_LogRecord() {
  /*<skip>*/
}
$h_Lscribe_LogRecord.prototype = $c_Lscribe_LogRecord.prototype;
$c_Lscribe_LogRecord.prototype.init___ = (function() {
  this.scribe$LogRecord$$$undmethodName$1 = $m_s_None$();
  this.scribe$LogRecord$$$undmessage$1 = $m_s_None$();
  return this
});
$c_Lscribe_LogRecord.prototype.updateValue__D__Lscribe_LogRecord = (function(value) {
  this.scribe$LogRecord$$$undvalue$1 = value;
  return this
});
$c_Lscribe_LogRecord.prototype.toString__T = (function() {
  $m_sci_List$();
  var y = this.scribe$LogRecord$$$undlevel$1.name$1;
  var jsx$5 = new $c_T2().init___O__O("level", y);
  var this$4 = this.scribe$LogRecord$$$undvalue$1;
  var y$1 = ("" + this$4);
  var jsx$4 = new $c_T2().init___O__O("value", y$1);
  var y$2 = this.scribe$LogRecord$$$undclassName$1;
  var jsx$3 = new $c_T2().init___O__O("class", y$2);
  var this$10 = this.scribe$LogRecord$$$undmethodName$1;
  var y$3 = (this$10.isEmpty__Z() ? "???" : this$10.get__O());
  var jsx$2 = new $c_T2().init___O__O("method", y$3);
  var this$13 = this.scribe$LogRecord$$$undlineNumber$1;
  var y$4 = ("" + this$13);
  var jsx$1 = new $c_T2().init___O__O("line", y$4);
  var y$5 = this.message__T();
  var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([jsx$5, jsx$4, jsx$3, jsx$2, jsx$1, new $c_T2().init___O__O("message", y$5)]);
  var this$19 = $m_sci_List$();
  var cbf = this$19.ReusableCBFInstance$2;
  var list = $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf));
  var f = (function(this$2$1) {
    return (function(x0$1$2) {
      var x0$1 = $as_T2(x0$1$2);
      if ((x0$1 !== null)) {
        var key = $as_T(x0$1.$$und1__O());
        var value = $as_T(x0$1.$$und2__O());
        return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", ": ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([key, value]))
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })(this);
  var this$20 = $m_sci_List$();
  var bf = this$20.ReusableCBFInstance$2;
  if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
    if ((list === $m_sci_Nil$())) {
      var jsx$6 = $m_sci_Nil$()
    } else {
      var arg1 = list.head__O();
      var h = new $c_sci_$colon$colon().init___O__sci_List(f(arg1), $m_sci_Nil$());
      var t = h;
      var rest = $as_sci_List(list.tail__O());
      while ((rest !== $m_sci_Nil$())) {
        var arg1$1 = rest.head__O();
        var nx = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$1), $m_sci_Nil$());
        t.tl$5 = nx;
        t = nx;
        rest = $as_sci_List(rest.tail__O())
      };
      var jsx$6 = h
    }
  } else {
    var b = $f_sc_TraversableLike__builder$1__psc_TraversableLike__scg_CanBuildFrom__scm_Builder(list, bf);
    var these = list;
    while ((!these.isEmpty__Z())) {
      var arg1$2 = these.head__O();
      b.$$plus$eq__O__scm_Builder(f(arg1$2));
      these = $as_sci_List(these.tail__O())
    };
    var jsx$6 = b.result__O()
  };
  return $as_sc_TraversableOnce(jsx$6).mkString__T__T__T__T("LogRecord(", ", ", ")")
});
$c_Lscribe_LogRecord.prototype.message__T = (function() {
  var x1 = this.scribe$LogRecord$$$undmessage$1;
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var m = $as_T(x2.value$2);
    return m
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var m$2 = $m_sjsr_RuntimeString$().valueOf__O__T(this.scribe$LogRecord$$$undmessageFunction$1.apply__O());
      this.scribe$LogRecord$$$undmessage$1 = $m_s_Option$().apply__O__s_Option(m$2);
      return m$2
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
function $is_Lscribe_LogRecord(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lscribe_LogRecord)))
}
function $as_Lscribe_LogRecord(obj) {
  return (($is_Lscribe_LogRecord(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scribe.LogRecord"))
}
function $isArrayOf_Lscribe_LogRecord(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lscribe_LogRecord)))
}
function $asArrayOf_Lscribe_LogRecord(obj, depth) {
  return (($isArrayOf_Lscribe_LogRecord(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscribe.LogRecord;", depth))
}
var $d_Lscribe_LogRecord = new $TypeData().initClass({
  Lscribe_LogRecord: 0
}, false, "scribe.LogRecord", {
  Lscribe_LogRecord: 1,
  O: 1
});
$c_Lscribe_LogRecord.prototype.$classData = $d_Lscribe_LogRecord;
/** @constructor */
function $c_Lscribe_LogRecord$() {
  $c_O.call(this);
  this.instance$1 = null
}
$c_Lscribe_LogRecord$.prototype = new $h_O();
$c_Lscribe_LogRecord$.prototype.constructor = $c_Lscribe_LogRecord$;
/** @constructor */
function $h_Lscribe_LogRecord$() {
  /*<skip>*/
}
$h_Lscribe_LogRecord$.prototype = $c_Lscribe_LogRecord$.prototype;
$c_Lscribe_LogRecord$.prototype.init___ = (function() {
  $n_Lscribe_LogRecord$ = this;
  this.instance$1 = new $c_Lscribe_LogRecord$$anon$1().init___();
  return this
});
$c_Lscribe_LogRecord$.prototype.apply__Lscribe_Level__D__F0__T__s_Option__I__J__T__J__Lscribe_LogRecord = (function(level, value, message, className, methodName, lineNumber, threadId, threadName, timestamp) {
  var r = $as_Lscribe_LogRecord(this.instance$1.get__O());
  r.scribe$LogRecord$$$undlevel$1 = level;
  r.scribe$LogRecord$$$undvalue$1 = value;
  r.scribe$LogRecord$$$undmessageFunction$1 = message;
  r.scribe$LogRecord$$$undclassName$1 = className;
  r.scribe$LogRecord$$$undmethodName$1 = methodName;
  r.scribe$LogRecord$$$undlineNumber$1 = lineNumber;
  r.scribe$LogRecord$$$undthreadId$1 = threadId;
  r.scribe$LogRecord$$$undthreadName$1 = threadName;
  r.scribe$LogRecord$$$undtimestamp$1 = timestamp;
  r.scribe$LogRecord$$$undmessage$1 = $m_s_None$();
  return r
});
var $d_Lscribe_LogRecord$ = new $TypeData().initClass({
  Lscribe_LogRecord$: 0
}, false, "scribe.LogRecord$", {
  Lscribe_LogRecord$: 1,
  O: 1
});
$c_Lscribe_LogRecord$.prototype.$classData = $d_Lscribe_LogRecord$;
var $n_Lscribe_LogRecord$ = (void 0);
function $m_Lscribe_LogRecord$() {
  if ((!$n_Lscribe_LogRecord$)) {
    $n_Lscribe_LogRecord$ = new $c_Lscribe_LogRecord$().init___()
  };
  return $n_Lscribe_LogRecord$
}
/** @constructor */
function $c_Lscribe_Platform$() {
  $c_O.call(this);
  this.lineSeparator$1 = null;
  this.replacements$1 = null
}
$c_Lscribe_Platform$.prototype = new $h_O();
$c_Lscribe_Platform$.prototype.constructor = $c_Lscribe_Platform$;
/** @constructor */
function $h_Lscribe_Platform$() {
  /*<skip>*/
}
$h_Lscribe_Platform$.prototype = $c_Lscribe_Platform$.prototype;
$c_Lscribe_Platform$.prototype.init___ = (function() {
  $n_Lscribe_Platform$ = this;
  this.lineSeparator$1 = "\n";
  var y = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(d$2) {
      var this$2 = $uI(d$2.getFullYear());
      return ("" + this$2)
    })
  })(this));
  var jsx$4 = new $c_T2().init___O__O("%1$tY", y);
  var y$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(d$3$2) {
      var this$6 = ((1 + $uI(d$3$2.getMonth())) | 0);
      return ("" + this$6)
    })
  })(this));
  var jsx$3 = new $c_T2().init___O__O("%1$tm", y$1);
  var y$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1) {
    return (function(d$4$2) {
      var this$10 = $uI(d$4$2.getDate());
      return ("" + this$10)
    })
  })(this));
  var jsx$2 = new $c_T2().init___O__O("%1$td", y$2);
  var y$3 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
    return (function(d$5$2) {
      return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", ":", ":", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([$uI(d$5$2.getHours()), $uI(d$5$2.getMinutes()), $uI(d$5$2.getSeconds())]))
    })
  })(this));
  var jsx$1 = new $c_T2().init___O__O("%1$tT", y$3);
  var y$4 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$5$1) {
    return (function(d$6$2) {
      var this$16 = $uI(d$6$2.getMilliseconds());
      return ("" + this$16)
    })
  })(this));
  var array = [jsx$4, jsx$3, jsx$2, jsx$1, new $c_T2().init___O__O("%1$tL", y$4)];
  var this$20 = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  var i = 0;
  var len = $uI(array.length);
  while ((i < len)) {
    var index = i;
    var arg1 = array[index];
    this$20.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1));
    i = ((1 + i) | 0)
  };
  this.replacements$1 = $as_sci_Map(this$20.elems$1);
  return this
});
$c_Lscribe_Platform$.prototype.formatDate__T__J__T = (function(pattern, timestamp) {
  var date = new $g.Date($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(timestamp.lo$2, timestamp.hi$2));
  var this$6 = this.replacements$1;
  var op = new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this, date$1) {
    return (function(x0$1$2, x1$1$2) {
      var x0$1 = $as_T(x0$1$2);
      var x1$1 = $as_T2(x1$1$2);
      var x1 = new $c_T2().init___O__O(x0$1, x1$1);
      var p = $as_T(x1.$$und1$f);
      var p2 = $as_T2(x1.$$und2$f);
      if ((p2 !== null)) {
        var original = $as_T(p2.$$und1__O());
        var update = $as_F1(p2.$$und2__O());
        var this$2 = new $c_sci_StringOps().init___T(p);
        var replacement = $as_T(update.apply__O__O(date$1));
        var $$this = this$2.repr$1;
        return $as_T($$this.split(original).join(replacement))
      };
      throw new $c_s_MatchError().init___O(x1)
    })
  })(this, date));
  var standardPattern = $as_T($f_sc_TraversableOnce__foldLeft__O__F2__O(this$6, pattern, op));
  var this$10 = new $c_sci_StringOps().init___T(standardPattern);
  var array = [date];
  var jsx$2 = $m_sjsr_RuntimeString$();
  var $$this$1 = this$10.repr$1;
  $m_sc_Seq$();
  $m_sjs_js_WrappedArray$();
  var array$1 = [];
  var x1$2 = $uI(array.length);
  switch (x1$2) {
    case (-1): {
      break
    }
  };
  var i = 0;
  var len = $uI(array.length);
  while ((i < len)) {
    var index = i;
    var arg1 = array[index];
    var elem = $f_sci_StringLike__unwrapArg__psci_StringLike__O__O(this$10, arg1);
    array$1.push(elem);
    i = ((1 + i) | 0)
  };
  $m_s_reflect_ManifestFactory$ObjectManifest$();
  var len$1 = $uI(array$1.length);
  var result = $newArrayObject($d_O.getArrayOf(), [len$1]);
  var len$2 = result.u.length;
  var i$1 = 0;
  var j = 0;
  var x = $uI(array$1.length);
  var x$1 = ((x < len$2) ? x : len$2);
  var that = result.u.length;
  var end = ((x$1 < that) ? x$1 : that);
  while ((i$1 < end)) {
    var jsx$1 = j;
    var index$1 = i$1;
    result.set(jsx$1, array$1[index$1]);
    i$1 = ((1 + i$1) | 0);
    j = ((1 + j) | 0)
  };
  return jsx$2.format__T__AO__T($$this$1, result)
});
var $d_Lscribe_Platform$ = new $TypeData().initClass({
  Lscribe_Platform$: 0
}, false, "scribe.Platform$", {
  Lscribe_Platform$: 1,
  O: 1
});
$c_Lscribe_Platform$.prototype.$classData = $d_Lscribe_Platform$;
var $n_Lscribe_Platform$ = (void 0);
function $m_Lscribe_Platform$() {
  if ((!$n_Lscribe_Platform$)) {
    $n_Lscribe_Platform$ = new $c_Lscribe_Platform$().init___()
  };
  return $n_Lscribe_Platform$
}
/** @constructor */
function $c_Lscribe_formatter_Formatter$() {
  $c_O.call(this);
  this.simple$1 = null;
  this.default$1 = null;
  this.trace$1 = null
}
$c_Lscribe_formatter_Formatter$.prototype = new $h_O();
$c_Lscribe_formatter_Formatter$.prototype.constructor = $c_Lscribe_formatter_Formatter$;
/** @constructor */
function $h_Lscribe_formatter_Formatter$() {
  /*<skip>*/
}
$h_Lscribe_formatter_Formatter$.prototype = $c_Lscribe_formatter_Formatter$.prototype;
$c_Lscribe_formatter_Formatter$.prototype.init___ = (function() {
  $n_Lscribe_formatter_Formatter$ = this;
  this.simple$1 = new $c_Lscribe_formatter_FormatterBuilder().init___sci_List($m_sci_Nil$()).message__Lscribe_formatter_FormatterBuilder().newLine__Lscribe_formatter_FormatterBuilder();
  var qual$1 = new $c_Lscribe_formatter_FormatterBuilder().init___sci_List($m_sci_Nil$());
  this.default$1 = qual$1.date__T__Lscribe_formatter_FormatterBuilder("%1$tY.%1$tm.%1$td %1$tT:%1$tL").string__T__Lscribe_formatter_FormatterBuilder(" [").threadName__Lscribe_formatter_FormatterBuilder().string__T__Lscribe_formatter_FormatterBuilder("] ").levelPaddedRight__Lscribe_formatter_FormatterBuilder().string__T__Lscribe_formatter_FormatterBuilder(" ").positionAbbreviated__Lscribe_formatter_FormatterBuilder().string__T__Lscribe_formatter_FormatterBuilder(" - ").message__Lscribe_formatter_FormatterBuilder().newLine__Lscribe_formatter_FormatterBuilder();
  this.trace$1 = new $c_Lscribe_formatter_FormatterBuilder().init___sci_List($m_sci_Nil$()).threadName__Lscribe_formatter_FormatterBuilder().string__T__Lscribe_formatter_FormatterBuilder("-").levelPaddedRight__Lscribe_formatter_FormatterBuilder().string__T__Lscribe_formatter_FormatterBuilder("-").positionAbbreviated__Lscribe_formatter_FormatterBuilder().string__T__Lscribe_formatter_FormatterBuilder("-").message__Lscribe_formatter_FormatterBuilder().newLine__Lscribe_formatter_FormatterBuilder();
  return this
});
var $d_Lscribe_formatter_Formatter$ = new $TypeData().initClass({
  Lscribe_formatter_Formatter$: 0
}, false, "scribe.formatter.Formatter$", {
  Lscribe_formatter_Formatter$: 1,
  O: 1
});
$c_Lscribe_formatter_Formatter$.prototype.$classData = $d_Lscribe_formatter_Formatter$;
var $n_Lscribe_formatter_Formatter$ = (void 0);
function $m_Lscribe_formatter_Formatter$() {
  if ((!$n_Lscribe_formatter_Formatter$)) {
    $n_Lscribe_formatter_Formatter$ = new $c_Lscribe_formatter_Formatter$().init___()
  };
  return $n_Lscribe_formatter_Formatter$
}
/** @constructor */
function $c_Lsourcecode_SourceValue() {
  $c_O.call(this)
}
$c_Lsourcecode_SourceValue.prototype = new $h_O();
$c_Lsourcecode_SourceValue.prototype.constructor = $c_Lsourcecode_SourceValue;
/** @constructor */
function $h_Lsourcecode_SourceValue() {
  /*<skip>*/
}
$h_Lsourcecode_SourceValue.prototype = $c_Lsourcecode_SourceValue.prototype;
function $f_Lupickle_Generated__Tuple3W__O__O__O__O($thiz, evidence$7, evidence$8, evidence$9) {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, evidence$7$1, evidence$8$1, evidence$9$1) {
    return (function(x$2) {
      var x = $as_T3(x$2);
      var jsx$3 = $m_s_Predef$();
      var t = x.$$und1$1;
      var evidence$2 = $as_Lupickle_Types$Writer(evidence$7$1);
      var jsx$2 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t, evidence$2);
      var t$1 = x.$$und2$1;
      var evidence$2$1 = $as_Lupickle_Types$Writer(evidence$8$1);
      var jsx$1 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$1, evidence$2$1);
      var t$2 = x.$$und3$1;
      var evidence$2$2 = $as_Lupickle_Types$Writer(evidence$9$1);
      return new $c_Lupickle_Js$Arr().init___sc_Seq(jsx$3.genericWrapArray__O__scm_WrappedArray($makeNativeArrayWrapper($d_Lupickle_Js$Value.getArrayOf(), [jsx$2, jsx$1, $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$2, evidence$2$2)])))
    })
  })($thiz, evidence$7, evidence$8, evidence$9));
  return $f_Lupickle_Implicits__makeWriter__F1__Lupickle_Types$Writer($thiz, f)
}
function $f_Lupickle_Generated__Tuple7W__O__O__O__O__O__O__O__O($thiz, evidence$43, evidence$44, evidence$45, evidence$46, evidence$47, evidence$48, evidence$49) {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, evidence$43$1, evidence$44$1, evidence$45$1, evidence$46$1, evidence$47$1, evidence$48$1, evidence$49$1) {
    return (function(x$2) {
      var x = $as_T7(x$2);
      var jsx$7 = $m_s_Predef$();
      var t = x.$$und1$1;
      var evidence$2 = $as_Lupickle_Types$Writer(evidence$43$1);
      var jsx$6 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t, evidence$2);
      var t$1 = x.$$und2$1;
      var evidence$2$1 = $as_Lupickle_Types$Writer(evidence$44$1);
      var jsx$5 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$1, evidence$2$1);
      var t$2 = x.$$und3$1;
      var evidence$2$2 = $as_Lupickle_Types$Writer(evidence$45$1);
      var jsx$4 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$2, evidence$2$2);
      var t$3 = x.$$und4$1;
      var evidence$2$3 = $as_Lupickle_Types$Writer(evidence$46$1);
      var jsx$3 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$3, evidence$2$3);
      var t$4 = x.$$und5$1;
      var evidence$2$4 = $as_Lupickle_Types$Writer(evidence$47$1);
      var jsx$2 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$4, evidence$2$4);
      var t$5 = x.$$und6$1;
      var evidence$2$5 = $as_Lupickle_Types$Writer(evidence$48$1);
      var jsx$1 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$5, evidence$2$5);
      var t$6 = x.$$und7$1;
      var evidence$2$6 = $as_Lupickle_Types$Writer(evidence$49$1);
      return new $c_Lupickle_Js$Arr().init___sc_Seq(jsx$7.genericWrapArray__O__scm_WrappedArray($makeNativeArrayWrapper($d_Lupickle_Js$Value.getArrayOf(), [jsx$6, jsx$5, jsx$4, jsx$3, jsx$2, jsx$1, $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$6, evidence$2$6)])))
    })
  })($thiz, evidence$43, evidence$44, evidence$45, evidence$46, evidence$47, evidence$48, evidence$49));
  return $f_Lupickle_Implicits__makeWriter__F1__Lupickle_Types$Writer($thiz, f)
}
function $f_Lupickle_Generated__Tuple6W__O__O__O__O__O__O__O($thiz, evidence$31, evidence$32, evidence$33, evidence$34, evidence$35, evidence$36) {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, evidence$31$1, evidence$32$1, evidence$33$1, evidence$34$1, evidence$35$1, evidence$36$1) {
    return (function(x$2) {
      var x = $as_T6(x$2);
      var jsx$6 = $m_s_Predef$();
      var t = x.$$und1$1;
      var evidence$2 = $as_Lupickle_Types$Writer(evidence$31$1);
      var jsx$5 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t, evidence$2);
      var t$1 = x.$$und2$1;
      var evidence$2$1 = $as_Lupickle_Types$Writer(evidence$32$1);
      var jsx$4 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$1, evidence$2$1);
      var t$2 = x.$$und3$1;
      var evidence$2$2 = $as_Lupickle_Types$Writer(evidence$33$1);
      var jsx$3 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$2, evidence$2$2);
      var t$3 = x.$$und4$1;
      var evidence$2$3 = $as_Lupickle_Types$Writer(evidence$34$1);
      var jsx$2 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$3, evidence$2$3);
      var t$4 = x.$$und5$1;
      var evidence$2$4 = $as_Lupickle_Types$Writer(evidence$35$1);
      var jsx$1 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$4, evidence$2$4);
      var t$5 = x.$$und6$1;
      var evidence$2$5 = $as_Lupickle_Types$Writer(evidence$36$1);
      return new $c_Lupickle_Js$Arr().init___sc_Seq(jsx$6.genericWrapArray__O__scm_WrappedArray($makeNativeArrayWrapper($d_Lupickle_Js$Value.getArrayOf(), [jsx$5, jsx$4, jsx$3, jsx$2, jsx$1, $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$5, evidence$2$5)])))
    })
  })($thiz, evidence$31, evidence$32, evidence$33, evidence$34, evidence$35, evidence$36));
  return $f_Lupickle_Implicits__makeWriter__F1__Lupickle_Types$Writer($thiz, f)
}
function $f_Lupickle_Generated__Tuple2W__O__O__O($thiz, evidence$3, evidence$4) {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, evidence$3$1, evidence$4$1) {
    return (function(x$2) {
      var x = $as_T2(x$2);
      var jsx$2 = $m_s_Predef$();
      var t = x.$$und1__O();
      var evidence$2 = $as_Lupickle_Types$Writer(evidence$3$1);
      var jsx$1 = $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t, evidence$2);
      var t$1 = x.$$und2__O();
      var evidence$2$1 = $as_Lupickle_Types$Writer(evidence$4$1);
      return new $c_Lupickle_Js$Arr().init___sc_Seq(jsx$2.genericWrapArray__O__scm_WrappedArray($makeNativeArrayWrapper($d_Lupickle_Js$Value.getArrayOf(), [jsx$1, $f_Lupickle_Types__writeJs__O__Lupickle_Types$Writer__Lupickle_Js$Value($this, t$1, evidence$2$1)])))
    })
  })($thiz, evidence$3, evidence$4));
  return $f_Lupickle_Implicits__makeWriter__F1__Lupickle_Types$Writer($thiz, f)
}
/** @constructor */
function $c_Lupickle_Implicits$Internal$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lupickle_Implicits$Internal$.prototype = new $h_O();
$c_Lupickle_Implicits$Internal$.prototype.constructor = $c_Lupickle_Implicits$Internal$;
/** @constructor */
function $h_Lupickle_Implicits$Internal$() {
  /*<skip>*/
}
$h_Lupickle_Implicits$Internal$.prototype = $c_Lupickle_Implicits$Internal$.prototype;
$c_Lupickle_Implicits$Internal$.prototype.init___Lupickle_Implicits = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lupickle_Implicits$Internal$ = new $TypeData().initClass({
  Lupickle_Implicits$Internal$: 0
}, false, "upickle.Implicits$Internal$", {
  Lupickle_Implicits$Internal$: 1,
  O: 1
});
$c_Lupickle_Implicits$Internal$.prototype.$classData = $d_Lupickle_Implicits$Internal$;
/** @constructor */
function $c_Lupickle_Types$Aliases$() {
  $c_O.call(this);
  this.R$1 = null;
  this.W$1 = null;
  this.RW$1 = null
}
$c_Lupickle_Types$Aliases$.prototype = new $h_O();
$c_Lupickle_Types$Aliases$.prototype.constructor = $c_Lupickle_Types$Aliases$;
/** @constructor */
function $h_Lupickle_Types$Aliases$() {
  /*<skip>*/
}
$h_Lupickle_Types$Aliases$.prototype = $c_Lupickle_Types$Aliases$.prototype;
$c_Lupickle_Types$Aliases$.prototype.init___Lupickle_Types = (function($$outer) {
  this.R$1 = $$outer.Reader__Lupickle_Types$Reader$();
  this.W$1 = $$outer.Writer__Lupickle_Types$Writer$();
  this.RW$1 = $$outer.ReadWriter__Lupickle_Types$ReadWriter$();
  return this
});
var $d_Lupickle_Types$Aliases$ = new $TypeData().initClass({
  Lupickle_Types$Aliases$: 0
}, false, "upickle.Types$Aliases$", {
  Lupickle_Types$Aliases$: 1,
  O: 1
});
$c_Lupickle_Types$Aliases$.prototype.$classData = $d_Lupickle_Types$Aliases$;
/** @constructor */
function $c_Lupickle_Types$Knot$() {
  $c_O.call(this);
  this.Reader$module$1 = null;
  this.Writer$module$1 = null;
  this.$$outer$1 = null
}
$c_Lupickle_Types$Knot$.prototype = new $h_O();
$c_Lupickle_Types$Knot$.prototype.constructor = $c_Lupickle_Types$Knot$;
/** @constructor */
function $h_Lupickle_Types$Knot$() {
  /*<skip>*/
}
$h_Lupickle_Types$Knot$.prototype = $c_Lupickle_Types$Knot$.prototype;
$c_Lupickle_Types$Knot$.prototype.init___Lupickle_Types = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lupickle_Types$Knot$ = new $TypeData().initClass({
  Lupickle_Types$Knot$: 0
}, false, "upickle.Types$Knot$", {
  Lupickle_Types$Knot$: 1,
  O: 1
});
$c_Lupickle_Types$Knot$.prototype.$classData = $d_Lupickle_Types$Knot$;
/** @constructor */
function $c_Lupickle_Types$ReadWriter$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lupickle_Types$ReadWriter$.prototype = new $h_O();
$c_Lupickle_Types$ReadWriter$.prototype.constructor = $c_Lupickle_Types$ReadWriter$;
/** @constructor */
function $h_Lupickle_Types$ReadWriter$() {
  /*<skip>*/
}
$h_Lupickle_Types$ReadWriter$.prototype = $c_Lupickle_Types$ReadWriter$.prototype;
$c_Lupickle_Types$ReadWriter$.prototype.init___Lupickle_Types = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lupickle_Types$ReadWriter$ = new $TypeData().initClass({
  Lupickle_Types$ReadWriter$: 0
}, false, "upickle.Types$ReadWriter$", {
  Lupickle_Types$ReadWriter$: 1,
  O: 1
});
$c_Lupickle_Types$ReadWriter$.prototype.$classData = $d_Lupickle_Types$ReadWriter$;
/** @constructor */
function $c_Lupickle_Types$Reader$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lupickle_Types$Reader$.prototype = new $h_O();
$c_Lupickle_Types$Reader$.prototype.constructor = $c_Lupickle_Types$Reader$;
/** @constructor */
function $h_Lupickle_Types$Reader$() {
  /*<skip>*/
}
$h_Lupickle_Types$Reader$.prototype = $c_Lupickle_Types$Reader$.prototype;
$c_Lupickle_Types$Reader$.prototype.init___Lupickle_Types = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lupickle_Types$Reader$ = new $TypeData().initClass({
  Lupickle_Types$Reader$: 0
}, false, "upickle.Types$Reader$", {
  Lupickle_Types$Reader$: 1,
  O: 1
});
$c_Lupickle_Types$Reader$.prototype.$classData = $d_Lupickle_Types$Reader$;
/** @constructor */
function $c_Lupickle_Types$Writer$() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lupickle_Types$Writer$.prototype = new $h_O();
$c_Lupickle_Types$Writer$.prototype.constructor = $c_Lupickle_Types$Writer$;
/** @constructor */
function $h_Lupickle_Types$Writer$() {
  /*<skip>*/
}
$h_Lupickle_Types$Writer$.prototype = $c_Lupickle_Types$Writer$.prototype;
$c_Lupickle_Types$Writer$.prototype.init___Lupickle_Types = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lupickle_Types$Writer$ = new $TypeData().initClass({
  Lupickle_Types$Writer$: 0
}, false, "upickle.Types$Writer$", {
  Lupickle_Types$Writer$: 1,
  O: 1
});
$c_Lupickle_Types$Writer$.prototype.$classData = $d_Lupickle_Types$Writer$;
/** @constructor */
function $c_Lupickle_json_package$() {
  $c_O.call(this)
}
$c_Lupickle_json_package$.prototype = new $h_O();
$c_Lupickle_json_package$.prototype.constructor = $c_Lupickle_json_package$;
/** @constructor */
function $h_Lupickle_json_package$() {
  /*<skip>*/
}
$h_Lupickle_json_package$.prototype = $c_Lupickle_json_package$.prototype;
$c_Lupickle_json_package$.prototype.init___ = (function() {
  return this
});
$c_Lupickle_json_package$.prototype.write__Lupickle_Js$Value__I__T = (function(v, indent) {
  return $as_T($g.JSON.stringify(this.writeJs__Lupickle_Js$Value__O(v), null, indent))
});
$c_Lupickle_json_package$.prototype.readJs__O__Lupickle_Js$Value = (function(value) {
  if ($is_T(value)) {
    var x2 = $as_T(value);
    return new $c_Lupickle_Js$Str().init___T(x2)
  } else if (((typeof value) === "number")) {
    var x3 = $uD(value);
    return new $c_Lupickle_Js$Num().init___D(x3)
  } else if ($m_sr_BoxesRunTime$().equals__O__O__Z(true, value)) {
    return $m_Lupickle_Js$True$()
  } else if ($m_sr_BoxesRunTime$().equals__O__O__Z(false, value)) {
    return $m_Lupickle_Js$False$()
  } else if ((value === null)) {
    return $m_Lupickle_Js$Null$()
  } else if ($uZ((value instanceof $g.Array))) {
    var array = [];
    var x1 = $uI(value.length);
    switch (x1) {
      case (-1): {
        break
      }
    };
    var i = 0;
    var len = $uI(value.length);
    while ((i < len)) {
      var index = i;
      var arg1 = value[index];
      var elem = this.readJs__O__Lupickle_Js$Value(arg1);
      array.push(elem);
      i = ((1 + i) | 0)
    };
    return new $c_Lupickle_Js$Arr().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(array))
  } else if ($uZ((value instanceof $g.Object))) {
    var this$5 = new $c_sjs_js_WrappedDictionary().init___sjs_js_Dictionary(value);
    var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
      return (function(value$2$2) {
        return this$2$1.readJs__O__Lupickle_Js$Value(value$2$2)
      })
    })(this));
    var this$6 = new $c_sc_MapLike$MappedValues().init___sc_MapLike__F1(this$5, f);
    return new $c_Lupickle_Js$Obj().init___sc_Seq($f_sc_MapLike__toSeq__sc_Seq(this$6))
  } else {
    throw new $c_s_MatchError().init___O(value)
  }
});
$c_Lupickle_json_package$.prototype.read__T__Lupickle_Js$Value = (function(s) {
  try {
    var parsed = $g.JSON.parse(s)
  } catch (e) {
    var parsed;
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      if ($is_sjs_js_JavaScriptException(e$2)) {
        var x6 = $as_sjs_js_JavaScriptException(e$2);
        var e$3 = x6.exception$4;
        if ($uZ((e$3 instanceof $g.SyntaxError))) {
          throw new $c_Lupickle_Invalid$Json().init___T__T($as_T(e$3.message), s)
        }
      };
      throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
    } else {
      throw e
    }
  };
  return this.readJs__O__Lupickle_Js$Value(parsed)
});
$c_Lupickle_json_package$.prototype.writeJs__Lupickle_Js$Value__O = (function(value) {
  if ($is_Lupickle_Js$Str(value)) {
    var x2 = ((value === null) ? null : $as_Lupickle_Js$Str(value).value$1);
    return x2
  } else if ($is_Lupickle_Js$Num(value)) {
    var x3 = $as_Lupickle_Js$Num(value).value$1;
    return x3
  } else {
    var x = $m_Lupickle_Js$True$();
    if ((x === value)) {
      return true
    } else {
      var x$3 = $m_Lupickle_Js$False$();
      if ((x$3 === value)) {
        return false
      } else {
        var x$5 = $m_Lupickle_Js$Null$();
        if ((x$5 === value)) {
          return null
        } else if ($is_Lupickle_Js$Arr(value)) {
          var x4 = ((value === null) ? null : $as_Lupickle_Js$Arr(value).value$1);
          var this$2 = $m_sjsr_package$();
          var jsx$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
            return (function(x$2$2$2) {
              var x$2$2 = $as_Lupickle_Js$Value(x$2$2$2);
              return $this.writeJs__Lupickle_Js$Value__O(x$2$2)
            })
          })(this));
          var this$1 = $m_sc_Seq$();
          var col = $as_sc_Seq(x4.map__F1__scg_CanBuildFrom__O(jsx$1, this$1.ReusableCBFInstance$2));
          if ($is_sjs_js_ArrayOps(col)) {
            var x2$1 = $as_sjs_js_ArrayOps(col);
            return x2$1.scala$scalajs$js$ArrayOps$$array$f
          } else if ($is_sjs_js_WrappedArray(col)) {
            var x3$1 = $as_sjs_js_WrappedArray(col);
            return x3$1.array$6
          } else {
            var result = [];
            col.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1, result$1) {
              return (function(x$2) {
                return $uI(result$1.push(x$2))
              })
            })(this$2, result)));
            return result
          }
        } else if ($is_Lupickle_Js$Obj(value)) {
          var x5 = ((value === null) ? null : $as_Lupickle_Js$Obj(value).value$1);
          var jsx$3 = $m_sjs_js_Dictionary$();
          var jsx$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
            return (function(x0$1$2) {
              var x0$1 = $as_T2(x0$1$2);
              if ((x0$1 !== null)) {
                var k = $as_T(x0$1.$$und1__O());
                var v = $as_Lupickle_Js$Value(x0$1.$$und2__O());
                return new $c_T2().init___O__O(k, this$2$1.writeJs__Lupickle_Js$Value__O(v))
              } else {
                throw new $c_s_MatchError().init___O(x0$1)
              }
            })
          })(this));
          var this$3 = $m_sc_Seq$();
          return jsx$3.apply__sc_Seq__sjs_js_Dictionary($as_sc_Seq(x5.map__F1__scg_CanBuildFrom__O(jsx$2, this$3.ReusableCBFInstance$2)))
        } else {
          throw new $c_s_MatchError().init___O(value)
        }
      }
    }
  }
});
var $d_Lupickle_json_package$ = new $TypeData().initClass({
  Lupickle_json_package$: 0
}, false, "upickle.json.package$", {
  Lupickle_json_package$: 1,
  O: 1
});
$c_Lupickle_json_package$.prototype.$classData = $d_Lupickle_json_package$;
var $n_Lupickle_json_package$ = (void 0);
function $m_Lupickle_json_package$() {
  if ((!$n_Lupickle_json_package$)) {
    $n_Lupickle_json_package$ = new $c_Lupickle_json_package$().init___()
  };
  return $n_Lupickle_json_package$
}
/** @constructor */
function $c_jl_Class() {
  $c_O.call(this);
  this.data$1 = null
}
$c_jl_Class.prototype = new $h_O();
$c_jl_Class.prototype.constructor = $c_jl_Class;
/** @constructor */
function $h_jl_Class() {
  /*<skip>*/
}
$h_jl_Class.prototype = $c_jl_Class.prototype;
$c_jl_Class.prototype.getName__T = (function() {
  return $as_T(this.data$1.name)
});
$c_jl_Class.prototype.getComponentType__jl_Class = (function() {
  return $as_jl_Class(this.data$1.getComponentType())
});
$c_jl_Class.prototype.isPrimitive__Z = (function() {
  return $uZ(this.data$1.isPrimitive)
});
$c_jl_Class.prototype.toString__T = (function() {
  return ((this.isInterface__Z() ? "interface " : (this.isPrimitive__Z() ? "" : "class ")) + this.getName__T())
});
$c_jl_Class.prototype.isAssignableFrom__jl_Class__Z = (function(that) {
  return ((this.isPrimitive__Z() || that.isPrimitive__Z()) ? ((this === that) || ((this === $d_S.getClassOf()) ? (that === $d_B.getClassOf()) : ((this === $d_I.getClassOf()) ? ((that === $d_B.getClassOf()) || (that === $d_S.getClassOf())) : ((this === $d_F.getClassOf()) ? (((that === $d_B.getClassOf()) || (that === $d_S.getClassOf())) || (that === $d_I.getClassOf())) : ((this === $d_D.getClassOf()) && ((((that === $d_B.getClassOf()) || (that === $d_S.getClassOf())) || (that === $d_I.getClassOf())) || (that === $d_F.getClassOf()))))))) : this.isInstance__O__Z(that.getFakeInstance__p1__O()))
});
$c_jl_Class.prototype.isInstance__O__Z = (function(obj) {
  return $uZ(this.data$1.isInstance(obj))
});
$c_jl_Class.prototype.init___jl_ScalaJSClassData = (function(data) {
  this.data$1 = data;
  return this
});
$c_jl_Class.prototype.getFakeInstance__p1__O = (function() {
  return this.data$1.getFakeInstance()
});
$c_jl_Class.prototype.newArrayOfThisClass__sjs_js_Array__O = (function(dimensions) {
  return this.data$1.newArrayOfThisClass(dimensions)
});
$c_jl_Class.prototype.getSimpleName__T = (function() {
  var x = $as_T(this.data$1.name);
  var this$2 = new $c_sci_StringOps().init___T(x);
  var xs = $f_sci_StringLike__split__C__AT(this$2, 46);
  var this$4 = new $c_scm_ArrayOps$ofRef().init___AO(xs);
  var x$1 = $as_T($f_sc_IndexedSeqOptimized__last__O(this$4));
  var this$6 = new $c_sci_StringOps().init___T(x$1);
  var xs$1 = $f_sci_StringLike__split__C__AT(this$6, 36);
  var this$8 = new $c_scm_ArrayOps$ofRef().init___AO(xs$1);
  return $as_T($f_sc_IndexedSeqOptimized__last__O(this$8))
});
$c_jl_Class.prototype.isArray__Z = (function() {
  return $uZ(this.data$1.isArrayClass)
});
$c_jl_Class.prototype.isInterface__Z = (function() {
  return $uZ(this.data$1.isInterface)
});
function $is_jl_Class(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.jl_Class)))
}
function $as_jl_Class(obj) {
  return (($is_jl_Class(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Class"))
}
function $isArrayOf_jl_Class(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Class)))
}
function $asArrayOf_jl_Class(obj, depth) {
  return (($isArrayOf_jl_Class(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Class;", depth))
}
var $d_jl_Class = new $TypeData().initClass({
  jl_Class: 0
}, false, "java.lang.Class", {
  jl_Class: 1,
  O: 1
});
$c_jl_Class.prototype.$classData = $d_jl_Class;
/** @constructor */
function $c_jl_ClassLoader() {
  $c_O.call(this)
}
$c_jl_ClassLoader.prototype = new $h_O();
$c_jl_ClassLoader.prototype.constructor = $c_jl_ClassLoader;
/** @constructor */
function $h_jl_ClassLoader() {
  /*<skip>*/
}
$h_jl_ClassLoader.prototype = $c_jl_ClassLoader.prototype;
/** @constructor */
function $c_jl_Long$StringRadixInfo() {
  $c_O.call(this);
  this.chunkLength$1 = 0;
  this.radixPowLength$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong();
  this.paddingZeros$1 = null;
  this.overflowBarrier$1 = $m_sjsr_RuntimeLong$().Zero__sjsr_RuntimeLong()
}
$c_jl_Long$StringRadixInfo.prototype = new $h_O();
$c_jl_Long$StringRadixInfo.prototype.constructor = $c_jl_Long$StringRadixInfo;
/** @constructor */
function $h_jl_Long$StringRadixInfo() {
  /*<skip>*/
}
$h_jl_Long$StringRadixInfo.prototype = $c_jl_Long$StringRadixInfo.prototype;
$c_jl_Long$StringRadixInfo.prototype.init___I__J__T__J = (function(chunkLength, radixPowLength, paddingZeros, overflowBarrier) {
  this.chunkLength$1 = chunkLength;
  this.radixPowLength$1 = radixPowLength;
  this.paddingZeros$1 = paddingZeros;
  this.overflowBarrier$1 = overflowBarrier;
  return this
});
function $is_jl_Long$StringRadixInfo(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.jl_Long$StringRadixInfo)))
}
function $as_jl_Long$StringRadixInfo(obj) {
  return (($is_jl_Long$StringRadixInfo(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "java.lang.Long$StringRadixInfo"))
}
function $isArrayOf_jl_Long$StringRadixInfo(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.jl_Long$StringRadixInfo)))
}
function $asArrayOf_jl_Long$StringRadixInfo(obj, depth) {
  return (($isArrayOf_jl_Long$StringRadixInfo(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Ljava.lang.Long$StringRadixInfo;", depth))
}
var $d_jl_Long$StringRadixInfo = new $TypeData().initClass({
  jl_Long$StringRadixInfo: 0
}, false, "java.lang.Long$StringRadixInfo", {
  jl_Long$StringRadixInfo: 1,
  O: 1
});
$c_jl_Long$StringRadixInfo.prototype.$classData = $d_jl_Long$StringRadixInfo;
/** @constructor */
function $c_jl_System$() {
  $c_O.call(this);
  this.out$1 = null;
  this.err$1 = null;
  this.in$1 = null;
  this.getHighPrecisionTime$1 = null
}
$c_jl_System$.prototype = new $h_O();
$c_jl_System$.prototype.constructor = $c_jl_System$;
/** @constructor */
function $h_jl_System$() {
  /*<skip>*/
}
$h_jl_System$.prototype = $c_jl_System$.prototype;
$c_jl_System$.prototype.init___ = (function() {
  $n_jl_System$ = this;
  this.out$1 = new $c_jl_JSConsoleBasedPrintStream().init___jl_Boolean(false);
  this.err$1 = new $c_jl_JSConsoleBasedPrintStream().init___jl_Boolean(true);
  this.in$1 = null;
  var x = $g.performance;
  if ($uZ((!(!x)))) {
    var x$1 = $g.performance.now;
    if ($uZ((!(!x$1)))) {
      var jsx$1 = (function() {
        return $m_jl_System$().java$lang$System$$$anonfun$getHighPrecisionTime$1__D()
      })
    } else {
      var x$2 = $g.performance.webkitNow;
      if ($uZ((!(!x$2)))) {
        var jsx$1 = (function() {
          return $m_jl_System$().java$lang$System$$$anonfun$getHighPrecisionTime$2__D()
        })
      } else {
        var jsx$1 = (function() {
          return $m_jl_System$().java$lang$System$$$anonfun$getHighPrecisionTime$3__D()
        })
      }
    }
  } else {
    var jsx$1 = (function() {
      return $m_jl_System$().java$lang$System$$$anonfun$getHighPrecisionTime$4__D()
    })
  };
  this.getHighPrecisionTime$1 = jsx$1;
  return this
});
$c_jl_System$.prototype.java$lang$System$$$anonfun$getHighPrecisionTime$3__D = (function() {
  return $uD(new $g.Date().getTime())
});
$c_jl_System$.prototype.java$lang$System$$$anonfun$getHighPrecisionTime$1__D = (function() {
  return $uD($g.performance.now())
});
$c_jl_System$.prototype.java$lang$System$$$anonfun$getHighPrecisionTime$4__D = (function() {
  return $uD(new $g.Date().getTime())
});
$c_jl_System$.prototype.java$lang$System$$$anonfun$getHighPrecisionTime$2__D = (function() {
  return $uD($g.performance.webkitNow())
});
$c_jl_System$.prototype.currentTimeMillis__J = (function() {
  var this$1 = $m_sjsr_RuntimeLong$();
  var value = $uD(new $g.Date().getTime());
  var lo = this$1.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I(value);
  var hi = this$1.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
  return new $c_sjsr_RuntimeLong().init___I__I(lo, hi)
});
var $d_jl_System$ = new $TypeData().initClass({
  jl_System$: 0
}, false, "java.lang.System$", {
  jl_System$: 1,
  O: 1
});
$c_jl_System$.prototype.$classData = $d_jl_System$;
var $n_jl_System$ = (void 0);
function $m_jl_System$() {
  if ((!$n_jl_System$)) {
    $n_jl_System$ = new $c_jl_System$().init___()
  };
  return $n_jl_System$
}
/** @constructor */
function $c_jl_System$SystemProperties$() {
  $c_O.call(this);
  this.value$1 = null
}
$c_jl_System$SystemProperties$.prototype = new $h_O();
$c_jl_System$SystemProperties$.prototype.constructor = $c_jl_System$SystemProperties$;
/** @constructor */
function $h_jl_System$SystemProperties$() {
  /*<skip>*/
}
$h_jl_System$SystemProperties$.prototype = $c_jl_System$SystemProperties$.prototype;
$c_jl_System$SystemProperties$.prototype.init___ = (function() {
  $n_jl_System$SystemProperties$ = this;
  this.value$1 = this.loadSystemProperties__ju_Properties();
  return this
});
$c_jl_System$SystemProperties$.prototype.loadSystemProperties__ju_Properties = (function() {
  var sysProp = new $c_ju_Properties().init___();
  sysProp.put__O__O__O("java.version", "1.8");
  sysProp.put__O__O__O("java.vm.specification.version", "1.8");
  sysProp.put__O__O__O("java.vm.specification.vendor", "Oracle Corporation");
  sysProp.put__O__O__O("java.vm.specification.name", "Java Virtual Machine Specification");
  sysProp.put__O__O__O("java.vm.name", "Scala.js");
  var value = $linkingInfo.linkerVersion;
  if ((value !== (void 0))) {
    var v = $as_T(value);
    sysProp.put__O__O__O("java.vm.version", v)
  };
  sysProp.put__O__O__O("java.specification.version", "1.8");
  sysProp.put__O__O__O("java.specification.vendor", "Oracle Corporation");
  sysProp.put__O__O__O("java.specification.name", "Java Platform API Specification");
  sysProp.put__O__O__O("file.separator", "/");
  sysProp.put__O__O__O("path.separator", ":");
  sysProp.put__O__O__O("line.separator", "\n");
  var value$1 = $env.javaSystemProperties;
  if ((value$1 !== (void 0))) {
    var this$13 = new $c_sjs_js_WrappedDictionary().init___sjs_js_Dictionary(value$1);
    var p = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
      return (function(check$ifrefutable$1$2) {
        var check$ifrefutable$1 = $as_T2(check$ifrefutable$1$2);
        return (check$ifrefutable$1 !== null)
      })
    })(this));
    new $c_sc_TraversableLike$WithFilter().init___sc_TraversableLike__F1(this$13, p).foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1, sysProp$1) {
      return (function(x$1$2) {
        var x$1 = $as_T2(x$1$2);
        if ((x$1 !== null)) {
          var key = $as_T(x$1.$$und1__O());
          var value$2 = $as_T(x$1.$$und2__O());
          return sysProp$1.put__O__O__O(key, value$2)
        } else {
          throw new $c_s_MatchError().init___O(x$1)
        }
      })
    })(this, sysProp)))
  };
  return sysProp
});
var $d_jl_System$SystemProperties$ = new $TypeData().initClass({
  jl_System$SystemProperties$: 0
}, false, "java.lang.System$SystemProperties$", {
  jl_System$SystemProperties$: 1,
  O: 1
});
$c_jl_System$SystemProperties$.prototype.$classData = $d_jl_System$SystemProperties$;
var $n_jl_System$SystemProperties$ = (void 0);
function $m_jl_System$SystemProperties$() {
  if ((!$n_jl_System$SystemProperties$)) {
    $n_jl_System$SystemProperties$ = new $c_jl_System$SystemProperties$().init___()
  };
  return $n_jl_System$SystemProperties$
}
/** @constructor */
function $c_jl_Thread$() {
  $c_O.call(this);
  this.SingleThread$1 = null
}
$c_jl_Thread$.prototype = new $h_O();
$c_jl_Thread$.prototype.constructor = $c_jl_Thread$;
/** @constructor */
function $h_jl_Thread$() {
  /*<skip>*/
}
$h_jl_Thread$.prototype = $c_jl_Thread$.prototype;
$c_jl_Thread$.prototype.init___ = (function() {
  $n_jl_Thread$ = this;
  this.SingleThread$1 = new $c_jl_Thread().init___sr_BoxedUnit((void 0));
  return this
});
var $d_jl_Thread$ = new $TypeData().initClass({
  jl_Thread$: 0
}, false, "java.lang.Thread$", {
  jl_Thread$: 1,
  O: 1
});
$c_jl_Thread$.prototype.$classData = $d_jl_Thread$;
var $n_jl_Thread$ = (void 0);
function $m_jl_Thread$() {
  if ((!$n_jl_Thread$)) {
    $n_jl_Thread$ = new $c_jl_Thread$().init___()
  };
  return $n_jl_Thread$
}
/** @constructor */
function $c_jl_ThreadLocal() {
  $c_O.call(this);
  this.hasValue$1 = null;
  this.v$1 = null
}
$c_jl_ThreadLocal.prototype = new $h_O();
$c_jl_ThreadLocal.prototype.constructor = $c_jl_ThreadLocal;
/** @constructor */
function $h_jl_ThreadLocal() {
  /*<skip>*/
}
$h_jl_ThreadLocal.prototype = $c_jl_ThreadLocal.prototype;
$c_jl_ThreadLocal.prototype.init___ = (function() {
  this.hasValue$1 = false;
  return this
});
$c_jl_ThreadLocal.prototype.remove__V = (function() {
  this.hasValue$1 = false;
  this.v$1 = null
});
$c_jl_ThreadLocal.prototype.get__O = (function() {
  var x = this.hasValue$1;
  if ((!$uZ(x))) {
    this.set__O__V(this.initialValue__O())
  };
  return this.v$1
});
$c_jl_ThreadLocal.prototype.set__O__V = (function(o) {
  this.v$1 = o;
  this.hasValue$1 = true
});
$c_jl_ThreadLocal.prototype.initialValue__O = (function() {
  return null
});
var $d_jl_ThreadLocal = new $TypeData().initClass({
  jl_ThreadLocal: 0
}, false, "java.lang.ThreadLocal", {
  jl_ThreadLocal: 1,
  O: 1
});
$c_jl_ThreadLocal.prototype.$classData = $d_jl_ThreadLocal;
/** @constructor */
function $c_jl_reflect_Array$() {
  $c_O.call(this)
}
$c_jl_reflect_Array$.prototype = new $h_O();
$c_jl_reflect_Array$.prototype.constructor = $c_jl_reflect_Array$;
/** @constructor */
function $h_jl_reflect_Array$() {
  /*<skip>*/
}
$h_jl_reflect_Array$.prototype = $c_jl_reflect_Array$.prototype;
$c_jl_reflect_Array$.prototype.init___ = (function() {
  return this
});
$c_jl_reflect_Array$.prototype.newInstance__jl_Class__I__O = (function(componentType, length) {
  return componentType.newArrayOfThisClass__sjs_js_Array__O([length])
});
var $d_jl_reflect_Array$ = new $TypeData().initClass({
  jl_reflect_Array$: 0
}, false, "java.lang.reflect.Array$", {
  jl_reflect_Array$: 1,
  O: 1
});
$c_jl_reflect_Array$.prototype.$classData = $d_jl_reflect_Array$;
var $n_jl_reflect_Array$ = (void 0);
function $m_jl_reflect_Array$() {
  if ((!$n_jl_reflect_Array$)) {
    $n_jl_reflect_Array$ = new $c_jl_reflect_Array$().init___()
  };
  return $n_jl_reflect_Array$
}
/** @constructor */
function $c_ju_Arrays$() {
  $c_O.call(this)
}
$c_ju_Arrays$.prototype = new $h_O();
$c_ju_Arrays$.prototype.constructor = $c_ju_Arrays$;
/** @constructor */
function $h_ju_Arrays$() {
  /*<skip>*/
}
$h_ju_Arrays$.prototype = $c_ju_Arrays$.prototype;
$c_ju_Arrays$.prototype.equals__AO__AO__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.init___ = (function() {
  return this
});
$c_ju_Arrays$.prototype.binarySearch__AJ__J__I = (function(a, key) {
  var startIndex = 0;
  var endIndex = a.u.length;
  _binarySearchImpl: while (true) {
    if ((startIndex === endIndex)) {
      return (((-1) - startIndex) | 0)
    } else {
      var mid = ((((startIndex + endIndex) | 0) >>> 1) | 0);
      var elem = a.get(mid);
      var t = $uJ(elem);
      var lo = t.lo$2;
      var hi = t.hi$2;
      var ahi = key.hi$2;
      if (((ahi === hi) ? (((-2147483648) ^ key.lo$2) < ((-2147483648) ^ lo)) : (ahi < hi))) {
        endIndex = mid;
        continue _binarySearchImpl
      } else if ($m_sr_BoxesRunTime$().equals__O__O__Z(key, elem)) {
        return mid
      } else {
        startIndex = ((1 + mid) | 0);
        continue _binarySearchImpl
      }
    }
  }
});
$c_ju_Arrays$.prototype.hashCodeImpl$default$2__p1__F1 = (function() {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$2) {
      return $objectHashCode(x$2)
    })
  })(this))
});
$c_ju_Arrays$.prototype.equals__AD__AD__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AI__AI__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AF__AF__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AJ__AJ__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AB__AB__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AZ__AZ__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.java$util$Arrays$$insertionSortAnyRef__AO__I__I__s_math_Ordering__V = (function(a, start, end, ord) {
  var n = ((end - start) | 0);
  if ((n >= 2)) {
    if ((ord.compare__O__O__I(a.get(start), a.get(((1 + start) | 0))) > 0)) {
      var temp = a.get(start);
      a.set(start, a.get(((1 + start) | 0)));
      a.set(((1 + start) | 0), temp)
    };
    var m = 2;
    while ((m < n)) {
      var next = a.get(((start + m) | 0));
      if ((ord.compare__O__O__I(next, a.get((((-1) + ((start + m) | 0)) | 0))) < 0)) {
        var iA = start;
        var iB = (((-1) + ((start + m) | 0)) | 0);
        while ((((iB - iA) | 0) > 1)) {
          var ix = ((((iA + iB) | 0) >>> 1) | 0);
          if ((ord.compare__O__O__I(next, a.get(ix)) < 0)) {
            iB = ix
          } else {
            iA = ix
          }
        };
        var ix$2 = ((iA + ((ord.compare__O__O__I(next, a.get(iA)) < 0) ? 0 : 1)) | 0);
        var i = ((start + m) | 0);
        while ((i > ix$2)) {
          a.set(i, a.get((((-1) + i) | 0)));
          i = (((-1) + i) | 0)
        };
        a.set(ix$2, next)
      };
      m = ((1 + m) | 0)
    }
  }
});
$c_ju_Arrays$.prototype.fill__AI__I__V = (function(a, value) {
  var toIndex = a.u.length;
  var i = 0;
  while ((i !== toIndex)) {
    a.set(i, value);
    i = ((1 + i) | 0)
  }
});
$c_ju_Arrays$.prototype.equals__AC__AC__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(new $c_jl_Character().init___C(a.get(i)), new $c_jl_Character().init___C(b.get(i)))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.equals__AS__AS__Z = (function(a, b) {
  if ((a === b)) {
    return true
  } else if ((((a !== null) && (b !== null)) && (a.u.length === b.u.length))) {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var this$2 = $f_sc_SeqLike__indices__sci_Range(this$1);
    var this$3 = new $c_sc_IndexedSeqLike$Elements().init___sc_IndexedSeqLike__I__I(this$2, 0, this$2.length__I());
    var res = true;
    while ((res && this$3.hasNext__Z())) {
      var arg1 = this$3.next__O();
      var i = $uI(arg1);
      res = $m_sr_BoxesRunTime$().equals__O__O__Z(a.get(i), b.get(i))
    };
    return res
  } else {
    return false
  }
});
$c_ju_Arrays$.prototype.sort__AO__ju_Comparator__V = (function(array, comparator) {
  var ord = new $c_ju_Arrays$$anon$3().init___ju_Comparator(comparator);
  var end = array.u.length;
  if ((end > 16)) {
    this.java$util$Arrays$$stableSplitMergeAnyRef__AO__AO__I__I__s_math_Ordering__V(array, $newArrayObject($d_O.getArrayOf(), [array.u.length]), 0, end, ord)
  } else {
    this.java$util$Arrays$$insertionSortAnyRef__AO__I__I__s_math_Ordering__V(array, 0, end, ord)
  }
});
$c_ju_Arrays$.prototype.hashCode__AO__I = (function(a) {
  var elementHashCode = this.hashCodeImpl$default$2__p1__F1();
  if ((a === null)) {
    return 0
  } else {
    var this$1 = $m_s_Predef$().genericArrayOps__O__scm_ArrayOps(a);
    var start = 0;
    var end = this$1.length__I();
    var z = 1;
    var start$1 = start;
    var z$1 = z;
    var jsx$1;
    _foldl: while (true) {
      if ((start$1 !== end)) {
        var temp$start = ((1 + start$1) | 0);
        var arg1 = z$1;
        var arg2 = this$1.apply__I__O(start$1);
        var acc = $uI(arg1);
        var temp$z = (($imul(31, acc) + ((arg2 === null) ? 0 : $uI(elementHashCode.apply__O__O(arg2)))) | 0);
        start$1 = temp$start;
        z$1 = temp$z;
        continue _foldl
      };
      var jsx$1 = z$1;
      break
    };
    return $uI(jsx$1)
  }
});
$c_ju_Arrays$.prototype.java$util$Arrays$$stableSplitMergeAnyRef__AO__AO__I__I__s_math_Ordering__V = (function(a, temp, start, end, ord) {
  var length = ((end - start) | 0);
  if ((length > 16)) {
    var middle = ((start + ((length / 2) | 0)) | 0);
    this.java$util$Arrays$$stableSplitMergeAnyRef__AO__AO__I__I__s_math_Ordering__V(a, temp, start, middle, ord);
    this.java$util$Arrays$$stableSplitMergeAnyRef__AO__AO__I__I__s_math_Ordering__V(a, temp, middle, end, ord);
    var outIndex = start;
    var leftInIndex = start;
    var rightInIndex = middle;
    while ((outIndex < end)) {
      if (((leftInIndex < middle) && ((rightInIndex >= end) || ord.lteq__O__O__Z(a.get(leftInIndex), a.get(rightInIndex))))) {
        temp.set(outIndex, a.get(leftInIndex));
        leftInIndex = ((1 + leftInIndex) | 0)
      } else {
        temp.set(outIndex, a.get(rightInIndex));
        rightInIndex = ((1 + rightInIndex) | 0)
      };
      outIndex = ((1 + outIndex) | 0)
    };
    $systemArraycopy(temp, start, a, start, length)
  } else {
    this.java$util$Arrays$$insertionSortAnyRef__AO__I__I__s_math_Ordering__V(a, start, end, ord)
  }
});
var $d_ju_Arrays$ = new $TypeData().initClass({
  ju_Arrays$: 0
}, false, "java.util.Arrays$", {
  ju_Arrays$: 1,
  O: 1
});
$c_ju_Arrays$.prototype.$classData = $d_ju_Arrays$;
var $n_ju_Arrays$ = (void 0);
function $m_ju_Arrays$() {
  if ((!$n_ju_Arrays$)) {
    $n_ju_Arrays$ = new $c_ju_Arrays$().init___()
  };
  return $n_ju_Arrays$
}
/** @constructor */
function $c_ju_Dictionary() {
  $c_O.call(this)
}
$c_ju_Dictionary.prototype = new $h_O();
$c_ju_Dictionary.prototype.constructor = $c_ju_Dictionary;
/** @constructor */
function $h_ju_Dictionary() {
  /*<skip>*/
}
$h_ju_Dictionary.prototype = $c_ju_Dictionary.prototype;
/** @constructor */
function $c_ju_Formatter$() {
  $c_O.call(this);
  this.java$util$Formatter$$RegularChunk$1 = null;
  this.java$util$Formatter$$DoublePercent$1 = null;
  this.java$util$Formatter$$EOLChunk$1 = null;
  this.java$util$Formatter$$FormattedChunk$1 = null
}
$c_ju_Formatter$.prototype = new $h_O();
$c_ju_Formatter$.prototype.constructor = $c_ju_Formatter$;
/** @constructor */
function $h_ju_Formatter$() {
  /*<skip>*/
}
$h_ju_Formatter$.prototype = $c_ju_Formatter$.prototype;
$c_ju_Formatter$.prototype.init___ = (function() {
  $n_ju_Formatter$ = this;
  this.java$util$Formatter$$RegularChunk$1 = new $c_ju_Formatter$RegExpExtractor().init___sjs_js_RegExp(new $g.RegExp("^[^\\x25]+"));
  this.java$util$Formatter$$DoublePercent$1 = new $c_ju_Formatter$RegExpExtractor().init___sjs_js_RegExp(new $g.RegExp("^\\x25{2}"));
  this.java$util$Formatter$$EOLChunk$1 = new $c_ju_Formatter$RegExpExtractor().init___sjs_js_RegExp(new $g.RegExp("^\\x25n"));
  this.java$util$Formatter$$FormattedChunk$1 = new $c_ju_Formatter$RegExpExtractor().init___sjs_js_RegExp(new $g.RegExp("^\\x25(?:([1-9]\\d*)\\$)?([-#+ 0,\\(<]*)(\\d*)(?:\\.(\\d+))?([A-Za-z])"));
  return this
});
var $d_ju_Formatter$ = new $TypeData().initClass({
  ju_Formatter$: 0
}, false, "java.util.Formatter$", {
  ju_Formatter$: 1,
  O: 1
});
$c_ju_Formatter$.prototype.$classData = $d_ju_Formatter$;
var $n_ju_Formatter$ = (void 0);
function $m_ju_Formatter$() {
  if ((!$n_ju_Formatter$)) {
    $n_ju_Formatter$ = new $c_ju_Formatter$().init___()
  };
  return $n_ju_Formatter$
}
/** @constructor */
function $c_ju_Formatter$RegExpExtractor() {
  $c_O.call(this);
  this.regexp$1 = null
}
$c_ju_Formatter$RegExpExtractor.prototype = new $h_O();
$c_ju_Formatter$RegExpExtractor.prototype.constructor = $c_ju_Formatter$RegExpExtractor;
/** @constructor */
function $h_ju_Formatter$RegExpExtractor() {
  /*<skip>*/
}
$h_ju_Formatter$RegExpExtractor.prototype = $c_ju_Formatter$RegExpExtractor.prototype;
$c_ju_Formatter$RegExpExtractor.prototype.unapply__T__s_Option = (function(str) {
  return $m_s_Option$().apply__O__s_Option(this.regexp$1.exec(str))
});
$c_ju_Formatter$RegExpExtractor.prototype.init___sjs_js_RegExp = (function(regexp) {
  this.regexp$1 = regexp;
  return this
});
var $d_ju_Formatter$RegExpExtractor = new $TypeData().initClass({
  ju_Formatter$RegExpExtractor: 0
}, false, "java.util.Formatter$RegExpExtractor", {
  ju_Formatter$RegExpExtractor: 1,
  O: 1
});
$c_ju_Formatter$RegExpExtractor.prototype.$classData = $d_ju_Formatter$RegExpExtractor;
/** @constructor */
function $c_s_DeprecatedConsole() {
  $c_O.call(this)
}
$c_s_DeprecatedConsole.prototype = new $h_O();
$c_s_DeprecatedConsole.prototype.constructor = $c_s_DeprecatedConsole;
/** @constructor */
function $h_s_DeprecatedConsole() {
  /*<skip>*/
}
$h_s_DeprecatedConsole.prototype = $c_s_DeprecatedConsole.prototype;
/** @constructor */
function $c_s_FallbackArrayBuilding() {
  $c_O.call(this)
}
$c_s_FallbackArrayBuilding.prototype = new $h_O();
$c_s_FallbackArrayBuilding.prototype.constructor = $c_s_FallbackArrayBuilding;
/** @constructor */
function $h_s_FallbackArrayBuilding() {
  /*<skip>*/
}
$h_s_FallbackArrayBuilding.prototype = $c_s_FallbackArrayBuilding.prototype;
/** @constructor */
function $c_s_JSUniquenessCache() {
  $c_O.call(this);
  this.cache$1 = null
}
$c_s_JSUniquenessCache.prototype = new $h_O();
$c_s_JSUniquenessCache.prototype.constructor = $c_s_JSUniquenessCache;
/** @constructor */
function $h_s_JSUniquenessCache() {
  /*<skip>*/
}
$h_s_JSUniquenessCache.prototype = $c_s_JSUniquenessCache.prototype;
$c_s_JSUniquenessCache.prototype.init___ = (function() {
  this.cache$1 = {};
  return this
});
$c_s_JSUniquenessCache.prototype.apply__T__O = (function(name) {
  var dict = this.cache$1;
  var x1 = ($uZ($m_sjs_js_WrappedDictionary$Cache$().safeHasOwnProperty$1.call(dict, name)) ? new $c_s_Some().init___O(dict[name]) : $m_s_None$());
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var v = x2.value$2;
    return v
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var d = new $c_s_Symbol().init___T(name);
      dict[name] = d;
      return d
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
/** @constructor */
function $c_s_LowPriorityImplicits() {
  $c_O.call(this)
}
$c_s_LowPriorityImplicits.prototype = new $h_O();
$c_s_LowPriorityImplicits.prototype.constructor = $c_s_LowPriorityImplicits;
/** @constructor */
function $h_s_LowPriorityImplicits() {
  /*<skip>*/
}
$h_s_LowPriorityImplicits.prototype = $c_s_LowPriorityImplicits.prototype;
$c_s_LowPriorityImplicits.prototype.wrapRefArray__AO__scm_WrappedArray = (function(xs) {
  if ((xs === null)) {
    return null
  } else if ((xs.u.length === 0)) {
    var this$1 = $m_scm_WrappedArray$();
    return this$1.EmptyWrappedArray$1
  } else {
    return new $c_scm_WrappedArray$ofRef().init___AO(xs)
  }
});
$c_s_LowPriorityImplicits.prototype.genericWrapArray__O__scm_WrappedArray = (function(xs) {
  return ((xs === null) ? null : $m_scm_WrappedArray$().make__O__scm_WrappedArray(xs))
});
$c_s_LowPriorityImplicits.prototype.unwrapString__sci_WrappedString__T = (function(ws) {
  return ((ws !== null) ? ws.self$4 : null)
});
function $f_s_PartialFunction__runWith__F1__F1($thiz, action) {
  return new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, action$1) {
    return (function(x$2) {
      var z = $this.applyOrElse__O__F1__O(x$2, $m_s_PartialFunction$().scala$PartialFunction$$fallback$undpf$f);
      return ((!$m_s_PartialFunction$().scala$PartialFunction$$fallbackOccurred__O__Z(z)) && (action$1.apply__O__O(z), true))
    })
  })($thiz, action))
}
function $f_s_PartialFunction__applyOrElse__O__F1__O($thiz, x, $default) {
  return ($thiz.isDefinedAt__O__Z(x) ? $thiz.apply__O__O(x) : $default.apply__O__O(x))
}
/** @constructor */
function $c_s_PartialFunction$() {
  $c_O.call(this);
  this.scala$PartialFunction$$fallback$undpf$f = null;
  this.scala$PartialFunction$$constFalse$f = null;
  this.empty$undpf$1 = null
}
$c_s_PartialFunction$.prototype = new $h_O();
$c_s_PartialFunction$.prototype.constructor = $c_s_PartialFunction$;
/** @constructor */
function $h_s_PartialFunction$() {
  /*<skip>*/
}
$h_s_PartialFunction$.prototype = $c_s_PartialFunction$.prototype;
$c_s_PartialFunction$.prototype.init___ = (function() {
  $n_s_PartialFunction$ = this;
  this.scala$PartialFunction$$fallback$undpf$f = new $c_s_PartialFunction$$anonfun$1().init___();
  this.scala$PartialFunction$$constFalse$f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      return false
    })
  })(this));
  this.empty$undpf$1 = new $c_s_PartialFunction$$anon$1().init___();
  return this
});
$c_s_PartialFunction$.prototype.scala$PartialFunction$$fallbackOccurred__O__Z = (function(x) {
  return (this.scala$PartialFunction$$fallback$undpf$f === x)
});
var $d_s_PartialFunction$ = new $TypeData().initClass({
  s_PartialFunction$: 0
}, false, "scala.PartialFunction$", {
  s_PartialFunction$: 1,
  O: 1
});
$c_s_PartialFunction$.prototype.$classData = $d_s_PartialFunction$;
var $n_s_PartialFunction$ = (void 0);
function $m_s_PartialFunction$() {
  if ((!$n_s_PartialFunction$)) {
    $n_s_PartialFunction$ = new $c_s_PartialFunction$().init___()
  };
  return $n_s_PartialFunction$
}
/** @constructor */
function $c_s_Predef$any2stringadd$() {
  $c_O.call(this)
}
$c_s_Predef$any2stringadd$.prototype = new $h_O();
$c_s_Predef$any2stringadd$.prototype.constructor = $c_s_Predef$any2stringadd$;
/** @constructor */
function $h_s_Predef$any2stringadd$() {
  /*<skip>*/
}
$h_s_Predef$any2stringadd$.prototype = $c_s_Predef$any2stringadd$.prototype;
$c_s_Predef$any2stringadd$.prototype.init___ = (function() {
  return this
});
$c_s_Predef$any2stringadd$.prototype.$$plus$extension__O__T__T = (function($$this, other) {
  return (("" + $m_sjsr_RuntimeString$().valueOf__O__T($$this)) + other)
});
var $d_s_Predef$any2stringadd$ = new $TypeData().initClass({
  s_Predef$any2stringadd$: 0
}, false, "scala.Predef$any2stringadd$", {
  s_Predef$any2stringadd$: 1,
  O: 1
});
$c_s_Predef$any2stringadd$.prototype.$classData = $d_s_Predef$any2stringadd$;
var $n_s_Predef$any2stringadd$ = (void 0);
function $m_s_Predef$any2stringadd$() {
  if ((!$n_s_Predef$any2stringadd$)) {
    $n_s_Predef$any2stringadd$ = new $c_s_Predef$any2stringadd$().init___()
  };
  return $n_s_Predef$any2stringadd$
}
function $f_s_concurrent_BatchingExecutor__batchable__jl_Runnable__Z($thiz, runnable) {
  return $is_s_concurrent_OnCompleteRunnable(runnable)
}
function $f_s_concurrent_BatchingExecutor__execute__jl_Runnable__V($thiz, runnable) {
  if ($f_s_concurrent_BatchingExecutor__batchable__jl_Runnable__Z($thiz, runnable)) {
    var x1 = $as_sci_List($thiz.scala$concurrent$BatchingExecutor$$$undtasksLocal$1.get__O());
    if ((x1 === null)) {
      var this$1 = $m_sci_Nil$();
      var r = new $c_s_concurrent_BatchingExecutor$Batch().init___s_concurrent_BatchingExecutor__sci_List($thiz, new $c_sci_$colon$colon().init___O__sci_List(runnable, this$1));
      r.run__V()
    } else {
      $thiz.scala$concurrent$BatchingExecutor$$$undtasksLocal$1.set__O__V(new $c_sci_$colon$colon().init___O__sci_List(runnable, x1))
    }
  } else {
    runnable.run__V()
  }
}
/** @constructor */
function $c_s_concurrent_BlockContext$() {
  $c_O.call(this);
  this.contextLocal$1 = null
}
$c_s_concurrent_BlockContext$.prototype = new $h_O();
$c_s_concurrent_BlockContext$.prototype.constructor = $c_s_concurrent_BlockContext$;
/** @constructor */
function $h_s_concurrent_BlockContext$() {
  /*<skip>*/
}
$h_s_concurrent_BlockContext$.prototype = $c_s_concurrent_BlockContext$.prototype;
$c_s_concurrent_BlockContext$.prototype.init___ = (function() {
  $n_s_concurrent_BlockContext$ = this;
  this.contextLocal$1 = new $c_jl_ThreadLocal().init___();
  return this
});
$c_s_concurrent_BlockContext$.prototype.current__s_concurrent_BlockContext = (function() {
  var x1 = $as_s_concurrent_BlockContext(this.contextLocal$1.get__O());
  if ((x1 === null)) {
    var x1$2 = $m_jl_Thread$().SingleThread$1;
    return ($is_s_concurrent_BlockContext(x1$2) ? $as_s_concurrent_BlockContext(x1$2) : $m_s_concurrent_BlockContext$DefaultBlockContext$())
  } else {
    return x1
  }
});
var $d_s_concurrent_BlockContext$ = new $TypeData().initClass({
  s_concurrent_BlockContext$: 0
}, false, "scala.concurrent.BlockContext$", {
  s_concurrent_BlockContext$: 1,
  O: 1
});
$c_s_concurrent_BlockContext$.prototype.$classData = $d_s_concurrent_BlockContext$;
var $n_s_concurrent_BlockContext$ = (void 0);
function $m_s_concurrent_BlockContext$() {
  if ((!$n_s_concurrent_BlockContext$)) {
    $n_s_concurrent_BlockContext$ = new $c_s_concurrent_BlockContext$().init___()
  };
  return $n_s_concurrent_BlockContext$
}
/** @constructor */
function $c_s_concurrent_ExecutionContext$Implicits$() {
  $c_O.call(this);
  this.global$1 = null;
  this.bitmap$0$1 = false
}
$c_s_concurrent_ExecutionContext$Implicits$.prototype = new $h_O();
$c_s_concurrent_ExecutionContext$Implicits$.prototype.constructor = $c_s_concurrent_ExecutionContext$Implicits$;
/** @constructor */
function $h_s_concurrent_ExecutionContext$Implicits$() {
  /*<skip>*/
}
$h_s_concurrent_ExecutionContext$Implicits$.prototype = $c_s_concurrent_ExecutionContext$Implicits$.prototype;
$c_s_concurrent_ExecutionContext$Implicits$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_ExecutionContext$Implicits$.prototype.global$lzycompute__p1__s_concurrent_ExecutionContext = (function() {
  if ((!this.bitmap$0$1)) {
    this.global$1 = $m_sjs_concurrent_JSExecutionContext$().queue$1;
    this.bitmap$0$1 = true
  };
  return this.global$1
});
$c_s_concurrent_ExecutionContext$Implicits$.prototype.global__s_concurrent_ExecutionContext = (function() {
  return ((!this.bitmap$0$1) ? this.global$lzycompute__p1__s_concurrent_ExecutionContext() : this.global$1)
});
var $d_s_concurrent_ExecutionContext$Implicits$ = new $TypeData().initClass({
  s_concurrent_ExecutionContext$Implicits$: 0
}, false, "scala.concurrent.ExecutionContext$Implicits$", {
  s_concurrent_ExecutionContext$Implicits$: 1,
  O: 1
});
$c_s_concurrent_ExecutionContext$Implicits$.prototype.$classData = $d_s_concurrent_ExecutionContext$Implicits$;
var $n_s_concurrent_ExecutionContext$Implicits$ = (void 0);
function $m_s_concurrent_ExecutionContext$Implicits$() {
  if ((!$n_s_concurrent_ExecutionContext$Implicits$)) {
    $n_s_concurrent_ExecutionContext$Implicits$ = new $c_s_concurrent_ExecutionContext$Implicits$().init___()
  };
  return $n_s_concurrent_ExecutionContext$Implicits$
}
function $f_s_concurrent_Future__foreach__F1__s_concurrent_ExecutionContext__V($thiz, f, executor) {
  $thiz.onComplete__F1__s_concurrent_ExecutionContext__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1) {
    return (function(x$1$2) {
      var x$1 = $as_s_util_Try(x$1$2);
      x$1.foreach__F1__V(f$1)
    })
  })($thiz, f)), executor)
}
function $f_s_concurrent_Future__flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f, executor) {
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1) {
    return (function(x0$5$2) {
      var x0$5 = $as_s_util_Try(x0$5$2);
      if ($is_s_util_Success(x0$5)) {
        var x2 = $as_s_util_Success(x0$5);
        var s = x2.value$2;
        return $as_s_concurrent_Future(f$1.apply__O__O(s))
      } else if ($is_s_util_Failure(x0$5)) {
        return $this
      } else {
        throw new $c_s_MatchError().init___O(x0$5)
      }
    })
  })($thiz, f));
  return $f_s_concurrent_impl_Promise__transformWith__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f$2, executor)
}
function $f_s_concurrent_Future__map__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f, executor) {
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, f$1) {
    return (function(x$2$2) {
      var x$2 = $as_s_util_Try(x$2$2);
      return x$2.map__F1__s_util_Try(f$1)
    })
  })($thiz, f));
  return $f_s_concurrent_impl_Promise__transform__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f$2, executor)
}
function $f_s_concurrent_Future__zipWith__s_concurrent_Future__F2__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, that, f, executor) {
  return $thiz.flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, that$1, f$1, executor$1) {
    return (function(r1$2) {
      return that$1.map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this$1, f$5, r1) {
        return (function(r2$2) {
          return f$5.apply__O__O__O(r1, r2$2)
        })
      })($this, f$1, r1$2)), executor$1)
    })
  })($thiz, that, f, executor)), $m_s_concurrent_Future$InternalCallbackExecutor$())
}
function $f_s_concurrent_Future__filter__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, p, executor) {
  return $thiz.map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, p$1) {
    return (function(r$2) {
      if ($uZ(p$1.apply__O__O(r$2))) {
        return r$2
      } else {
        throw new $c_ju_NoSuchElementException().init___T("Future.filter predicate is not satisfied")
      }
    })
  })($thiz, p)), executor)
}
function $f_s_concurrent_Future__recover__s_PartialFunction__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, pf, executor) {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, pf$1) {
    return (function(x$3$2) {
      var x$3 = $as_s_util_Try(x$3$2);
      return x$3.recover__s_PartialFunction__s_util_Try(pf$1)
    })
  })($thiz, pf));
  return $f_s_concurrent_impl_Promise__transform__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f, executor)
}
function $f_s_concurrent_Future__failed__s_concurrent_Future($thiz) {
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x0$3$2) {
      var x0$3 = $as_s_util_Try(x0$3$2);
      if ($is_s_util_Failure(x0$3)) {
        var x2 = $as_s_util_Failure(x0$3);
        var t = x2.exception$2;
        return new $c_s_util_Success().init___O(t)
      } else if ($is_s_util_Success(x0$3)) {
        return new $c_s_util_Failure().init___jl_Throwable(new $c_ju_NoSuchElementException().init___T("Future.failed not completed with a throwable."))
      } else {
        throw new $c_s_MatchError().init___O(x0$3)
      }
    })
  })($thiz));
  var executor = $m_s_concurrent_Future$InternalCallbackExecutor$();
  return $f_s_concurrent_impl_Promise__transform__F1__s_concurrent_ExecutionContext__s_concurrent_Future($thiz, f, executor)
}
function $is_s_concurrent_Future(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_concurrent_Future)))
}
function $as_s_concurrent_Future(obj) {
  return (($is_s_concurrent_Future(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.concurrent.Future"))
}
function $isArrayOf_s_concurrent_Future(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_concurrent_Future)))
}
function $asArrayOf_s_concurrent_Future(obj, depth) {
  return (($isArrayOf_s_concurrent_Future(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.concurrent.Future;", depth))
}
/** @constructor */
function $c_s_concurrent_Future$() {
  $c_O.call(this);
  this.toBoxed$1 = null;
  this.unit$1 = null
}
$c_s_concurrent_Future$.prototype = new $h_O();
$c_s_concurrent_Future$.prototype.constructor = $c_s_concurrent_Future$;
/** @constructor */
function $h_s_concurrent_Future$() {
  /*<skip>*/
}
$h_s_concurrent_Future$.prototype = $c_s_concurrent_Future$.prototype;
$c_s_concurrent_Future$.prototype.init___ = (function() {
  $n_s_concurrent_Future$ = this;
  var array = [new $c_T2().init___O__O($d_Z.getClassOf(), $d_jl_Boolean.getClassOf()), new $c_T2().init___O__O($d_B.getClassOf(), $d_jl_Byte.getClassOf()), new $c_T2().init___O__O($d_C.getClassOf(), $d_jl_Character.getClassOf()), new $c_T2().init___O__O($d_S.getClassOf(), $d_jl_Short.getClassOf()), new $c_T2().init___O__O($d_I.getClassOf(), $d_jl_Integer.getClassOf()), new $c_T2().init___O__O($d_J.getClassOf(), $d_jl_Long.getClassOf()), new $c_T2().init___O__O($d_F.getClassOf(), $d_jl_Float.getClassOf()), new $c_T2().init___O__O($d_D.getClassOf(), $d_jl_Double.getClassOf()), new $c_T2().init___O__O($d_V.getClassOf(), $d_sr_BoxedUnit.getClassOf())];
  var this$20 = new $c_scm_MapBuilder().init___sc_GenMap($m_sci_Map$EmptyMap$());
  var i = 0;
  var len = $uI(array.length);
  while ((i < len)) {
    var index = i;
    var arg1 = array[index];
    this$20.$$plus$eq__T2__scm_MapBuilder($as_T2(arg1));
    i = ((1 + i) | 0)
  };
  this.toBoxed$1 = $as_sci_Map(this$20.elems$1);
  this.unit$1 = this.successful__O__s_concurrent_Future((void 0));
  return this
});
$c_s_concurrent_Future$.prototype.sequence__sc_TraversableOnce__scg_CanBuildFrom__s_concurrent_ExecutionContext__s_concurrent_Future = (function($in, cbf, executor) {
  return $as_s_concurrent_Future($in.foldLeft__O__F2__O(this.successful__O__s_concurrent_Future(cbf.apply__O__scm_Builder($in)), new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this, executor$1) {
    return (function(fr$2, fa$2) {
      var fr = $as_s_concurrent_Future(fr$2);
      var fa = $as_s_concurrent_Future(fa$2);
      return fr.zipWith__s_concurrent_Future__F2__s_concurrent_ExecutionContext__s_concurrent_Future(fa, new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this$1) {
        return (function(x$6$2, x$7$2) {
          var x$6 = $as_scm_Builder(x$6$2);
          return x$6.$$plus$eq__O__scm_Builder(x$7$2)
        })
      })($this)), executor$1)
    })
  })(this, executor)))).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(x$8$2) {
      var x$8 = $as_scm_Builder(x$8$2);
      return $as_sc_TraversableOnce(x$8.result__O())
    })
  })(this)), $m_s_concurrent_Future$InternalCallbackExecutor$())
});
$c_s_concurrent_Future$.prototype.successful__O__s_concurrent_Future = (function(result) {
  var this$1 = $m_s_concurrent_Promise$().successful__O__s_concurrent_Promise(result);
  return this$1
});
$c_s_concurrent_Future$.prototype.apply__F0__s_concurrent_ExecutionContext__s_concurrent_Future = (function(body, executor) {
  return this.unit$1.map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, body$1) {
    return (function(x$5$2) {
      $asUnit(x$5$2);
      return body$1.apply__O()
    })
  })(this, body)), executor)
});
var $d_s_concurrent_Future$ = new $TypeData().initClass({
  s_concurrent_Future$: 0
}, false, "scala.concurrent.Future$", {
  s_concurrent_Future$: 1,
  O: 1
});
$c_s_concurrent_Future$.prototype.$classData = $d_s_concurrent_Future$;
var $n_s_concurrent_Future$ = (void 0);
function $m_s_concurrent_Future$() {
  if ((!$n_s_concurrent_Future$)) {
    $n_s_concurrent_Future$ = new $c_s_concurrent_Future$().init___()
  };
  return $n_s_concurrent_Future$
}
/** @constructor */
function $c_s_concurrent_Promise$() {
  $c_O.call(this)
}
$c_s_concurrent_Promise$.prototype = new $h_O();
$c_s_concurrent_Promise$.prototype.constructor = $c_s_concurrent_Promise$;
/** @constructor */
function $h_s_concurrent_Promise$() {
  /*<skip>*/
}
$h_s_concurrent_Promise$.prototype = $c_s_concurrent_Promise$.prototype;
$c_s_concurrent_Promise$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_Promise$.prototype.successful__O__s_concurrent_Promise = (function(result) {
  var result$1 = new $c_s_util_Success().init___O(result);
  return $m_s_concurrent_impl_Promise$KeptPromise$().apply__s_util_Try__s_concurrent_Promise(result$1)
});
var $d_s_concurrent_Promise$ = new $TypeData().initClass({
  s_concurrent_Promise$: 0
}, false, "scala.concurrent.Promise$", {
  s_concurrent_Promise$: 1,
  O: 1
});
$c_s_concurrent_Promise$.prototype.$classData = $d_s_concurrent_Promise$;
var $n_s_concurrent_Promise$ = (void 0);
function $m_s_concurrent_Promise$() {
  if ((!$n_s_concurrent_Promise$)) {
    $n_s_concurrent_Promise$ = new $c_s_concurrent_Promise$().init___()
  };
  return $n_s_concurrent_Promise$
}
/** @constructor */
function $c_s_concurrent_duration_package$DurationInt$() {
  $c_O.call(this)
}
$c_s_concurrent_duration_package$DurationInt$.prototype = new $h_O();
$c_s_concurrent_duration_package$DurationInt$.prototype.constructor = $c_s_concurrent_duration_package$DurationInt$;
/** @constructor */
function $h_s_concurrent_duration_package$DurationInt$() {
  /*<skip>*/
}
$h_s_concurrent_duration_package$DurationInt$.prototype = $c_s_concurrent_duration_package$DurationInt$.prototype;
$c_s_concurrent_duration_package$DurationInt$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_duration_package$DurationInt$.prototype.equals$extension__I__O__Z = (function($$this, x$1) {
  if ($is_s_concurrent_duration_package$DurationInt(x$1)) {
    var DurationInt$1 = $as_s_concurrent_duration_package$DurationInt(x$1).scala$concurrent$duration$DurationInt$$n$1;
    return ($$this === DurationInt$1)
  } else {
    return false
  }
});
$c_s_concurrent_duration_package$DurationInt$.prototype.durationIn$extension__I__ju_concurrent_TimeUnit__s_concurrent_duration_FiniteDuration = (function($$this, unit) {
  $m_s_concurrent_duration_Duration$();
  var hi = ($$this >> 31);
  return new $c_s_concurrent_duration_FiniteDuration().init___J__ju_concurrent_TimeUnit(new $c_sjsr_RuntimeLong().init___I__I($$this, hi), unit)
});
var $d_s_concurrent_duration_package$DurationInt$ = new $TypeData().initClass({
  s_concurrent_duration_package$DurationInt$: 0
}, false, "scala.concurrent.duration.package$DurationInt$", {
  s_concurrent_duration_package$DurationInt$: 1,
  O: 1
});
$c_s_concurrent_duration_package$DurationInt$.prototype.$classData = $d_s_concurrent_duration_package$DurationInt$;
var $n_s_concurrent_duration_package$DurationInt$ = (void 0);
function $m_s_concurrent_duration_package$DurationInt$() {
  if ((!$n_s_concurrent_duration_package$DurationInt$)) {
    $n_s_concurrent_duration_package$DurationInt$ = new $c_s_concurrent_duration_package$DurationInt$().init___()
  };
  return $n_s_concurrent_duration_package$DurationInt$
}
/** @constructor */
function $c_s_concurrent_impl_Promise$() {
  $c_O.call(this)
}
$c_s_concurrent_impl_Promise$.prototype = new $h_O();
$c_s_concurrent_impl_Promise$.prototype.constructor = $c_s_concurrent_impl_Promise$;
/** @constructor */
function $h_s_concurrent_impl_Promise$() {
  /*<skip>*/
}
$h_s_concurrent_impl_Promise$.prototype = $c_s_concurrent_impl_Promise$.prototype;
$c_s_concurrent_impl_Promise$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_impl_Promise$.prototype.scala$concurrent$impl$Promise$$resolveTry__s_util_Try__s_util_Try = (function(source) {
  if ($is_s_util_Failure(source)) {
    var x2 = $as_s_util_Failure(source);
    var t = x2.exception$2;
    return this.resolver__p1__jl_Throwable__s_util_Try(t)
  } else {
    return source
  }
});
$c_s_concurrent_impl_Promise$.prototype.resolver__p1__jl_Throwable__s_util_Try = (function(throwable) {
  if ($is_sr_NonLocalReturnControl(throwable)) {
    var x2 = $as_sr_NonLocalReturnControl(throwable);
    return new $c_s_util_Success().init___O(x2.value$f)
  } else if ($is_s_util_control_ControlThrowable(throwable)) {
    var x3 = $as_s_util_control_ControlThrowable(throwable);
    return new $c_s_util_Failure().init___jl_Throwable(new $c_ju_concurrent_ExecutionException().init___T__jl_Throwable("Boxed ControlThrowable", $as_jl_Throwable(x3)))
  } else if ($is_jl_InterruptedException(throwable)) {
    var x4 = $as_jl_InterruptedException(throwable);
    return new $c_s_util_Failure().init___jl_Throwable(new $c_ju_concurrent_ExecutionException().init___T__jl_Throwable("Boxed InterruptedException", x4))
  } else if ($is_jl_Error(throwable)) {
    var x5 = $as_jl_Error(throwable);
    return new $c_s_util_Failure().init___jl_Throwable(new $c_ju_concurrent_ExecutionException().init___T__jl_Throwable("Boxed Error", x5))
  } else {
    return new $c_s_util_Failure().init___jl_Throwable(throwable)
  }
});
var $d_s_concurrent_impl_Promise$ = new $TypeData().initClass({
  s_concurrent_impl_Promise$: 0
}, false, "scala.concurrent.impl.Promise$", {
  s_concurrent_impl_Promise$: 1,
  O: 1
});
$c_s_concurrent_impl_Promise$.prototype.$classData = $d_s_concurrent_impl_Promise$;
var $n_s_concurrent_impl_Promise$ = (void 0);
function $m_s_concurrent_impl_Promise$() {
  if ((!$n_s_concurrent_impl_Promise$)) {
    $n_s_concurrent_impl_Promise$ = new $c_s_concurrent_impl_Promise$().init___()
  };
  return $n_s_concurrent_impl_Promise$
}
/** @constructor */
function $c_s_concurrent_impl_Promise$KeptPromise$() {
  $c_O.call(this)
}
$c_s_concurrent_impl_Promise$KeptPromise$.prototype = new $h_O();
$c_s_concurrent_impl_Promise$KeptPromise$.prototype.constructor = $c_s_concurrent_impl_Promise$KeptPromise$;
/** @constructor */
function $h_s_concurrent_impl_Promise$KeptPromise$() {
  /*<skip>*/
}
$h_s_concurrent_impl_Promise$KeptPromise$.prototype = $c_s_concurrent_impl_Promise$KeptPromise$.prototype;
$c_s_concurrent_impl_Promise$KeptPromise$.prototype.init___ = (function() {
  return this
});
$c_s_concurrent_impl_Promise$KeptPromise$.prototype.apply__s_util_Try__s_concurrent_Promise = (function(result) {
  var x1 = $m_s_concurrent_impl_Promise$().scala$concurrent$impl$Promise$$resolveTry__s_util_Try__s_util_Try(result);
  if ($is_s_util_Success(x1)) {
    var x2 = $as_s_util_Success(x1);
    return new $c_s_concurrent_impl_Promise$KeptPromise$Successful().init___s_util_Success(x2)
  } else if ($is_s_util_Failure(x1)) {
    var x4 = $as_s_util_Failure(x1);
    return new $c_s_concurrent_impl_Promise$KeptPromise$Failed().init___s_util_Failure(x4)
  } else {
    throw new $c_s_MatchError().init___O(x1)
  }
});
var $d_s_concurrent_impl_Promise$KeptPromise$ = new $TypeData().initClass({
  s_concurrent_impl_Promise$KeptPromise$: 0
}, false, "scala.concurrent.impl.Promise$KeptPromise$", {
  s_concurrent_impl_Promise$KeptPromise$: 1,
  O: 1
});
$c_s_concurrent_impl_Promise$KeptPromise$.prototype.$classData = $d_s_concurrent_impl_Promise$KeptPromise$;
var $n_s_concurrent_impl_Promise$KeptPromise$ = (void 0);
function $m_s_concurrent_impl_Promise$KeptPromise$() {
  if ((!$n_s_concurrent_impl_Promise$KeptPromise$)) {
    $n_s_concurrent_impl_Promise$KeptPromise$ = new $c_s_concurrent_impl_Promise$KeptPromise$().init___()
  };
  return $n_s_concurrent_impl_Promise$KeptPromise$
}
function $f_s_math_Ordered__$$less$eq__O__Z($thiz, that) {
  return ($thiz.compare__O__I(that) <= 0)
}
function $f_s_math_Ordered__$$greater$eq__O__Z($thiz, that) {
  return ($thiz.compare__O__I(that) >= 0)
}
/** @constructor */
function $c_s_math_Ordered$() {
  $c_O.call(this)
}
$c_s_math_Ordered$.prototype = new $h_O();
$c_s_math_Ordered$.prototype.constructor = $c_s_math_Ordered$;
/** @constructor */
function $h_s_math_Ordered$() {
  /*<skip>*/
}
$h_s_math_Ordered$.prototype = $c_s_math_Ordered$.prototype;
$c_s_math_Ordered$.prototype.init___ = (function() {
  return this
});
var $d_s_math_Ordered$ = new $TypeData().initClass({
  s_math_Ordered$: 0
}, false, "scala.math.Ordered$", {
  s_math_Ordered$: 1,
  O: 1
});
$c_s_math_Ordered$.prototype.$classData = $d_s_math_Ordered$;
var $n_s_math_Ordered$ = (void 0);
function $m_s_math_Ordered$() {
  if ((!$n_s_math_Ordered$)) {
    $n_s_math_Ordered$ = new $c_s_math_Ordered$().init___()
  };
  return $n_s_math_Ordered$
}
/** @constructor */
function $c_s_package$() {
  $c_O.call(this);
  this.BigDecimal$1 = null;
  this.BigInt$1 = null;
  this.AnyRef$1 = null;
  this.Traversable$1 = null;
  this.Iterable$1 = null;
  this.Seq$1 = null;
  this.IndexedSeq$1 = null;
  this.Iterator$1 = null;
  this.List$1 = null;
  this.Nil$1 = null;
  this.$$colon$colon$1 = null;
  this.$$plus$colon$1 = null;
  this.$$colon$plus$1 = null;
  this.Stream$1 = null;
  this.$$hash$colon$colon$1 = null;
  this.Vector$1 = null;
  this.StringBuilder$1 = null;
  this.Range$1 = null;
  this.Equiv$1 = null;
  this.Fractional$1 = null;
  this.Integral$1 = null;
  this.Numeric$1 = null;
  this.Ordered$1 = null;
  this.Ordering$1 = null;
  this.Either$1 = null;
  this.Left$1 = null;
  this.Right$1 = null;
  this.bitmap$0$1 = 0
}
$c_s_package$.prototype = new $h_O();
$c_s_package$.prototype.constructor = $c_s_package$;
/** @constructor */
function $h_s_package$() {
  /*<skip>*/
}
$h_s_package$.prototype = $c_s_package$.prototype;
$c_s_package$.prototype.init___ = (function() {
  $n_s_package$ = this;
  this.AnyRef$1 = new $c_s_package$$anon$1().init___();
  this.Traversable$1 = $m_sc_Traversable$();
  this.Iterable$1 = $m_sc_Iterable$();
  this.Seq$1 = $m_sc_Seq$();
  this.IndexedSeq$1 = $m_sc_IndexedSeq$();
  this.Iterator$1 = $m_sc_Iterator$();
  this.List$1 = $m_sci_List$();
  this.Nil$1 = $m_sci_Nil$();
  this.$$colon$colon$1 = $m_sci_$colon$colon$();
  this.$$plus$colon$1 = $m_sc_$plus$colon$();
  this.$$colon$plus$1 = $m_sc_$colon$plus$();
  this.Stream$1 = $m_sci_Stream$();
  this.$$hash$colon$colon$1 = $m_sci_Stream$$hash$colon$colon$();
  this.Vector$1 = $m_sci_Vector$();
  this.StringBuilder$1 = $m_scm_StringBuilder$();
  this.Range$1 = $m_sci_Range$();
  this.Equiv$1 = $m_s_math_Equiv$();
  this.Fractional$1 = $m_s_math_Fractional$();
  this.Integral$1 = $m_s_math_Integral$();
  this.Numeric$1 = $m_s_math_Numeric$();
  this.Ordered$1 = $m_s_math_Ordered$();
  this.Ordering$1 = $m_s_math_Ordering$();
  this.Either$1 = $m_s_util_Either$();
  this.Left$1 = $m_s_util_Left$();
  this.Right$1 = $m_s_util_Right$();
  return this
});
$c_s_package$.prototype.BigInt__s_math_BigInt$ = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.BigInt$lzycompute__p1__s_math_BigInt$() : this.BigInt$1)
});
$c_s_package$.prototype.BigInt$lzycompute__p1__s_math_BigInt$ = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    this.BigInt$1 = $m_s_math_BigInt$();
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.BigInt$1
});
$c_s_package$.prototype.BigDecimal__s_math_BigDecimal$ = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.BigDecimal$lzycompute__p1__s_math_BigDecimal$() : this.BigDecimal$1)
});
$c_s_package$.prototype.BigDecimal$lzycompute__p1__s_math_BigDecimal$ = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.BigDecimal$1 = $m_s_math_BigDecimal$();
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.BigDecimal$1
});
var $d_s_package$ = new $TypeData().initClass({
  s_package$: 0
}, false, "scala.package$", {
  s_package$: 1,
  O: 1
});
$c_s_package$.prototype.$classData = $d_s_package$;
var $n_s_package$ = (void 0);
function $m_s_package$() {
  if ((!$n_s_package$)) {
    $n_s_package$ = new $c_s_package$().init___()
  };
  return $n_s_package$
}
/** @constructor */
function $c_s_reflect_ClassManifestFactory$() {
  $c_O.call(this);
  this.Byte$1 = null;
  this.Short$1 = null;
  this.Char$1 = null;
  this.Int$1 = null;
  this.Long$1 = null;
  this.Float$1 = null;
  this.Double$1 = null;
  this.Boolean$1 = null;
  this.Unit$1 = null;
  this.Any$1 = null;
  this.Object$1 = null;
  this.AnyVal$1 = null;
  this.Nothing$1 = null;
  this.Null$1 = null
}
$c_s_reflect_ClassManifestFactory$.prototype = new $h_O();
$c_s_reflect_ClassManifestFactory$.prototype.constructor = $c_s_reflect_ClassManifestFactory$;
/** @constructor */
function $h_s_reflect_ClassManifestFactory$() {
  /*<skip>*/
}
$h_s_reflect_ClassManifestFactory$.prototype = $c_s_reflect_ClassManifestFactory$.prototype;
$c_s_reflect_ClassManifestFactory$.prototype.init___ = (function() {
  $n_s_reflect_ClassManifestFactory$ = this;
  this.Byte$1 = $m_s_reflect_ManifestFactory$ByteManifest$();
  this.Short$1 = $m_s_reflect_ManifestFactory$ShortManifest$();
  this.Char$1 = $m_s_reflect_ManifestFactory$CharManifest$();
  this.Int$1 = $m_s_reflect_ManifestFactory$IntManifest$();
  this.Long$1 = $m_s_reflect_ManifestFactory$LongManifest$();
  this.Float$1 = $m_s_reflect_ManifestFactory$FloatManifest$();
  this.Double$1 = $m_s_reflect_ManifestFactory$DoubleManifest$();
  this.Boolean$1 = $m_s_reflect_ManifestFactory$BooleanManifest$();
  this.Unit$1 = $m_s_reflect_ManifestFactory$UnitManifest$();
  this.Any$1 = $m_s_reflect_ManifestFactory$AnyManifest$();
  this.Object$1 = $m_s_reflect_ManifestFactory$ObjectManifest$();
  this.AnyVal$1 = $m_s_reflect_ManifestFactory$AnyValManifest$();
  this.Nothing$1 = $m_s_reflect_ManifestFactory$NothingManifest$();
  this.Null$1 = $m_s_reflect_ManifestFactory$NullManifest$();
  return this
});
var $d_s_reflect_ClassManifestFactory$ = new $TypeData().initClass({
  s_reflect_ClassManifestFactory$: 0
}, false, "scala.reflect.ClassManifestFactory$", {
  s_reflect_ClassManifestFactory$: 1,
  O: 1
});
$c_s_reflect_ClassManifestFactory$.prototype.$classData = $d_s_reflect_ClassManifestFactory$;
var $n_s_reflect_ClassManifestFactory$ = (void 0);
function $m_s_reflect_ClassManifestFactory$() {
  if ((!$n_s_reflect_ClassManifestFactory$)) {
    $n_s_reflect_ClassManifestFactory$ = new $c_s_reflect_ClassManifestFactory$().init___()
  };
  return $n_s_reflect_ClassManifestFactory$
}
/** @constructor */
function $c_s_reflect_ManifestFactory$() {
  $c_O.call(this)
}
$c_s_reflect_ManifestFactory$.prototype = new $h_O();
$c_s_reflect_ManifestFactory$.prototype.constructor = $c_s_reflect_ManifestFactory$;
/** @constructor */
function $h_s_reflect_ManifestFactory$() {
  /*<skip>*/
}
$h_s_reflect_ManifestFactory$.prototype = $c_s_reflect_ManifestFactory$.prototype;
$c_s_reflect_ManifestFactory$.prototype.init___ = (function() {
  return this
});
var $d_s_reflect_ManifestFactory$ = new $TypeData().initClass({
  s_reflect_ManifestFactory$: 0
}, false, "scala.reflect.ManifestFactory$", {
  s_reflect_ManifestFactory$: 1,
  O: 1
});
$c_s_reflect_ManifestFactory$.prototype.$classData = $d_s_reflect_ManifestFactory$;
var $n_s_reflect_ManifestFactory$ = (void 0);
function $m_s_reflect_ManifestFactory$() {
  if ((!$n_s_reflect_ManifestFactory$)) {
    $n_s_reflect_ManifestFactory$ = new $c_s_reflect_ManifestFactory$().init___()
  };
  return $n_s_reflect_ManifestFactory$
}
/** @constructor */
function $c_s_reflect_package$() {
  $c_O.call(this);
  this.ClassManifest$1 = null;
  this.Manifest$1 = null
}
$c_s_reflect_package$.prototype = new $h_O();
$c_s_reflect_package$.prototype.constructor = $c_s_reflect_package$;
/** @constructor */
function $h_s_reflect_package$() {
  /*<skip>*/
}
$h_s_reflect_package$.prototype = $c_s_reflect_package$.prototype;
$c_s_reflect_package$.prototype.init___ = (function() {
  $n_s_reflect_package$ = this;
  this.ClassManifest$1 = $m_s_reflect_ClassManifestFactory$();
  this.Manifest$1 = $m_s_reflect_ManifestFactory$();
  return this
});
var $d_s_reflect_package$ = new $TypeData().initClass({
  s_reflect_package$: 0
}, false, "scala.reflect.package$", {
  s_reflect_package$: 1,
  O: 1
});
$c_s_reflect_package$.prototype.$classData = $d_s_reflect_package$;
var $n_s_reflect_package$ = (void 0);
function $m_s_reflect_package$() {
  if ((!$n_s_reflect_package$)) {
    $n_s_reflect_package$ = new $c_s_reflect_package$().init___()
  };
  return $n_s_reflect_package$
}
/** @constructor */
function $c_s_sys_package$() {
  $c_O.call(this)
}
$c_s_sys_package$.prototype = new $h_O();
$c_s_sys_package$.prototype.constructor = $c_s_sys_package$;
/** @constructor */
function $h_s_sys_package$() {
  /*<skip>*/
}
$h_s_sys_package$.prototype = $c_s_sys_package$.prototype;
$c_s_sys_package$.prototype.init___ = (function() {
  return this
});
$c_s_sys_package$.prototype.error__T__sr_Nothing$ = (function(message) {
  throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(message))
});
var $d_s_sys_package$ = new $TypeData().initClass({
  s_sys_package$: 0
}, false, "scala.sys.package$", {
  s_sys_package$: 1,
  O: 1
});
$c_s_sys_package$.prototype.$classData = $d_s_sys_package$;
var $n_s_sys_package$ = (void 0);
function $m_s_sys_package$() {
  if ((!$n_s_sys_package$)) {
    $n_s_sys_package$ = new $c_s_sys_package$().init___()
  };
  return $n_s_sys_package$
}
/** @constructor */
function $c_s_util_DynamicVariable() {
  $c_O.call(this);
  this.v$1 = null
}
$c_s_util_DynamicVariable.prototype = new $h_O();
$c_s_util_DynamicVariable.prototype.constructor = $c_s_util_DynamicVariable;
/** @constructor */
function $h_s_util_DynamicVariable() {
  /*<skip>*/
}
$h_s_util_DynamicVariable.prototype = $c_s_util_DynamicVariable.prototype;
$c_s_util_DynamicVariable.prototype.toString__T = (function() {
  return (("DynamicVariable(" + this.v$1) + ")")
});
$c_s_util_DynamicVariable.prototype.init___O = (function(init) {
  this.v$1 = init;
  return this
});
var $d_s_util_DynamicVariable = new $TypeData().initClass({
  s_util_DynamicVariable: 0
}, false, "scala.util.DynamicVariable", {
  s_util_DynamicVariable: 1,
  O: 1
});
$c_s_util_DynamicVariable.prototype.$classData = $d_s_util_DynamicVariable;
/** @constructor */
function $c_s_util_control_Breaks() {
  $c_O.call(this);
  this.scala$util$control$Breaks$$breakException$1 = null
}
$c_s_util_control_Breaks.prototype = new $h_O();
$c_s_util_control_Breaks.prototype.constructor = $c_s_util_control_Breaks;
/** @constructor */
function $h_s_util_control_Breaks() {
  /*<skip>*/
}
$h_s_util_control_Breaks.prototype = $c_s_util_control_Breaks.prototype;
$c_s_util_control_Breaks.prototype.init___ = (function() {
  this.scala$util$control$Breaks$$breakException$1 = new $c_s_util_control_BreakControl().init___();
  return this
});
var $d_s_util_control_Breaks = new $TypeData().initClass({
  s_util_control_Breaks: 0
}, false, "scala.util.control.Breaks", {
  s_util_control_Breaks: 1,
  O: 1
});
$c_s_util_control_Breaks.prototype.$classData = $d_s_util_control_Breaks;
function $is_s_util_control_ControlThrowable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.s_util_control_ControlThrowable)))
}
function $as_s_util_control_ControlThrowable(obj) {
  return (($is_s_util_control_ControlThrowable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.util.control.ControlThrowable"))
}
function $isArrayOf_s_util_control_ControlThrowable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.s_util_control_ControlThrowable)))
}
function $asArrayOf_s_util_control_ControlThrowable(obj, depth) {
  return (($isArrayOf_s_util_control_ControlThrowable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.util.control.ControlThrowable;", depth))
}
/** @constructor */
function $c_s_util_control_NonFatal$() {
  $c_O.call(this)
}
$c_s_util_control_NonFatal$.prototype = new $h_O();
$c_s_util_control_NonFatal$.prototype.constructor = $c_s_util_control_NonFatal$;
/** @constructor */
function $h_s_util_control_NonFatal$() {
  /*<skip>*/
}
$h_s_util_control_NonFatal$.prototype = $c_s_util_control_NonFatal$.prototype;
$c_s_util_control_NonFatal$.prototype.init___ = (function() {
  return this
});
$c_s_util_control_NonFatal$.prototype.apply__jl_Throwable__Z = (function(t) {
  return (!($is_jl_VirtualMachineError(t) || ($is_jl_ThreadDeath(t) || ($is_jl_InterruptedException(t) || ($is_jl_LinkageError(t) || $is_s_util_control_ControlThrowable(t))))))
});
$c_s_util_control_NonFatal$.prototype.unapply__jl_Throwable__s_Option = (function(t) {
  return (this.apply__jl_Throwable__Z(t) ? new $c_s_Some().init___O(t) : $m_s_None$())
});
var $d_s_util_control_NonFatal$ = new $TypeData().initClass({
  s_util_control_NonFatal$: 0
}, false, "scala.util.control.NonFatal$", {
  s_util_control_NonFatal$: 1,
  O: 1
});
$c_s_util_control_NonFatal$.prototype.$classData = $d_s_util_control_NonFatal$;
var $n_s_util_control_NonFatal$ = (void 0);
function $m_s_util_control_NonFatal$() {
  if ((!$n_s_util_control_NonFatal$)) {
    $n_s_util_control_NonFatal$ = new $c_s_util_control_NonFatal$().init___()
  };
  return $n_s_util_control_NonFatal$
}
/** @constructor */
function $c_s_util_hashing_MurmurHash3() {
  $c_O.call(this)
}
$c_s_util_hashing_MurmurHash3.prototype = new $h_O();
$c_s_util_hashing_MurmurHash3.prototype.constructor = $c_s_util_hashing_MurmurHash3;
/** @constructor */
function $h_s_util_hashing_MurmurHash3() {
  /*<skip>*/
}
$h_s_util_hashing_MurmurHash3.prototype = $c_s_util_hashing_MurmurHash3.prototype;
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mVc$sp__Asr_BoxedUnit__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, 0);
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.mixLast__I__I__I = (function(hash, data) {
  var k = data;
  k = $imul((-862048943), k);
  var i = k;
  k = ((i << 15) | ((i >>> 17) | 0));
  k = $imul(461845907, k);
  return (hash ^ k)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mDc$sp__AD__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, $m_sr_Statics$().doubleHash__D__I(a.get(i)));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mJc$sp__AJ__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, $m_sr_Statics$().longHash__J__I(a.get(i)));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mZc$sp__AZ__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, (a.get(i) ? 1231 : 1237));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.mix__I__I__I = (function(hash, data) {
  var h = this.mixLast__I__I__I(hash, data);
  var i = h;
  h = ((i << 13) | ((i >>> 19) | 0));
  return (((-430675100) + $imul(5, h)) | 0)
});
$c_s_util_hashing_MurmurHash3.prototype.bytesHash__AB__I__I = (function(data, seed) {
  var len = data.u.length;
  var h = seed;
  var i = 0;
  while ((len >= 4)) {
    var k = (255 & data.get(i));
    k = (k | ((255 & data.get(((1 + i) | 0))) << 8));
    k = (k | ((255 & data.get(((2 + i) | 0))) << 16));
    k = (k | ((255 & data.get(((3 + i) | 0))) << 24));
    h = this.mix__I__I__I(h, k);
    i = ((4 + i) | 0);
    len = (((-4) + len) | 0)
  };
  var k$2 = 0;
  if ((len === 3)) {
    k$2 = (k$2 ^ ((255 & data.get(((2 + i) | 0))) << 16))
  };
  if ((len >= 2)) {
    k$2 = (k$2 ^ ((255 & data.get(((1 + i) | 0))) << 8))
  };
  if ((len >= 1)) {
    k$2 = (k$2 ^ (255 & data.get(i)));
    h = this.mixLast__I__I__I(h, k$2)
  };
  return this.finalizeHash__I__I__I(h, data.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.avalanche__p1__I__I = (function(hash) {
  var h = hash;
  h = (h ^ ((h >>> 16) | 0));
  h = $imul((-2048144789), h);
  h = (h ^ ((h >>> 13) | 0));
  h = $imul((-1028477387), h);
  h = (h ^ ((h >>> 16) | 0));
  return h
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mSc$sp__AS__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, a.get(i));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash__O__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < $m_sr_ScalaRunTime$().array$undlength__O__I(a))) {
    h = this.mix__I__I__I(h, $m_sr_Statics$().anyHash__O__I($m_sr_ScalaRunTime$().array$undapply__O__I__O(a, i)));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, $m_sr_ScalaRunTime$().array$undlength__O__I(a))
});
$c_s_util_hashing_MurmurHash3.prototype.productHash__s_Product__I__I = (function(x, seed) {
  var arr = x.productArity__I();
  if ((arr === 0)) {
    var this$1 = x.productPrefix__T();
    return $m_sjsr_RuntimeString$().hashCode__T__I(this$1)
  } else {
    var h = seed;
    var i = 0;
    while ((i < arr)) {
      h = this.mix__I__I__I(h, $m_sr_Statics$().anyHash__O__I(x.productElement__I__O(i)));
      i = ((1 + i) | 0)
    };
    return this.finalizeHash__I__I__I(h, arr)
  }
});
$c_s_util_hashing_MurmurHash3.prototype.unorderedHash__sc_TraversableOnce__I__I = (function(xs, seed) {
  var a = new $c_sr_IntRef().init___I(0);
  var b = new $c_sr_IntRef().init___I(0);
  var n = new $c_sr_IntRef().init___I(0);
  var c = new $c_sr_IntRef().init___I(1);
  xs.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, a$1, b$1, n$1, c$1) {
    return (function(x$2) {
      var h = $m_sr_Statics$().anyHash__O__I(x$2);
      a$1.elem$1 = ((a$1.elem$1 + h) | 0);
      b$1.elem$1 = (b$1.elem$1 ^ h);
      if ((h !== 0)) {
        c$1.elem$1 = $imul(c$1.elem$1, h)
      };
      n$1.elem$1 = ((1 + n$1.elem$1) | 0)
    })
  })(this, a, b, n, c)));
  var h$1 = seed;
  h$1 = this.mix__I__I__I(h$1, a.elem$1);
  h$1 = this.mix__I__I__I(h$1, b.elem$1);
  h$1 = this.mixLast__I__I__I(h$1, c.elem$1);
  return this.finalizeHash__I__I__I(h$1, n.elem$1)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mCc$sp__AC__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, a.get(i));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mFc$sp__AF__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    var jsx$1 = h;
    var this$1 = $m_sr_Statics$();
    var fv = a.get(i);
    h = this.mix__I__I__I(jsx$1, this$1.doubleHash__D__I(fv));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.finalizeHash__I__I__I = (function(hash, length) {
  return this.avalanche__p1__I__I((hash ^ length))
});
$c_s_util_hashing_MurmurHash3.prototype.arrayHash$mIc$sp__AI__I__I = (function(a, seed) {
  var h = seed;
  var i = 0;
  while ((i < a.u.length)) {
    h = this.mix__I__I__I(h, a.get(i));
    i = ((1 + i) | 0)
  };
  return this.finalizeHash__I__I__I(h, a.u.length)
});
$c_s_util_hashing_MurmurHash3.prototype.orderedHash__sc_TraversableOnce__I__I = (function(xs, seed) {
  var n = new $c_sr_IntRef().init___I(0);
  var h = new $c_sr_IntRef().init___I(seed);
  xs.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, n$1, h$1) {
    return (function(x$2) {
      h$1.elem$1 = $this.mix__I__I__I(h$1.elem$1, $m_sr_Statics$().anyHash__O__I(x$2));
      n$1.elem$1 = ((1 + n$1.elem$1) | 0)
    })
  })(this, n, h)));
  return this.finalizeHash__I__I__I(h.elem$1, n.elem$1)
});
$c_s_util_hashing_MurmurHash3.prototype.listHash__sci_List__I__I = (function(xs, seed) {
  var n = 0;
  var h = seed;
  var elems = xs;
  while ((!elems.isEmpty__Z())) {
    var head = elems.head__O();
    var tail = $as_sci_List(elems.tail__O());
    h = this.mix__I__I__I(h, $m_sr_Statics$().anyHash__O__I(head));
    n = ((1 + n) | 0);
    elems = tail
  };
  return this.finalizeHash__I__I__I(h, n)
});
/** @constructor */
function $c_s_util_hashing_package$() {
  $c_O.call(this)
}
$c_s_util_hashing_package$.prototype = new $h_O();
$c_s_util_hashing_package$.prototype.constructor = $c_s_util_hashing_package$;
/** @constructor */
function $h_s_util_hashing_package$() {
  /*<skip>*/
}
$h_s_util_hashing_package$.prototype = $c_s_util_hashing_package$.prototype;
$c_s_util_hashing_package$.prototype.init___ = (function() {
  return this
});
$c_s_util_hashing_package$.prototype.byteswap32__I__I = (function(v) {
  var hc = $imul((-1640532531), v);
  hc = $m_jl_Integer$().reverseBytes__I__I(hc);
  return $imul((-1640532531), hc)
});
var $d_s_util_hashing_package$ = new $TypeData().initClass({
  s_util_hashing_package$: 0
}, false, "scala.util.hashing.package$", {
  s_util_hashing_package$: 1,
  O: 1
});
$c_s_util_hashing_package$.prototype.$classData = $d_s_util_hashing_package$;
var $n_s_util_hashing_package$ = (void 0);
function $m_s_util_hashing_package$() {
  if ((!$n_s_util_hashing_package$)) {
    $n_s_util_hashing_package$ = new $c_s_util_hashing_package$().init___()
  };
  return $n_s_util_hashing_package$
}
/** @constructor */
function $c_sc_$colon$plus$() {
  $c_O.call(this)
}
$c_sc_$colon$plus$.prototype = new $h_O();
$c_sc_$colon$plus$.prototype.constructor = $c_sc_$colon$plus$;
/** @constructor */
function $h_sc_$colon$plus$() {
  /*<skip>*/
}
$h_sc_$colon$plus$.prototype = $c_sc_$colon$plus$.prototype;
$c_sc_$colon$plus$.prototype.init___ = (function() {
  return this
});
var $d_sc_$colon$plus$ = new $TypeData().initClass({
  sc_$colon$plus$: 0
}, false, "scala.collection.$colon$plus$", {
  sc_$colon$plus$: 1,
  O: 1
});
$c_sc_$colon$plus$.prototype.$classData = $d_sc_$colon$plus$;
var $n_sc_$colon$plus$ = (void 0);
function $m_sc_$colon$plus$() {
  if ((!$n_sc_$colon$plus$)) {
    $n_sc_$colon$plus$ = new $c_sc_$colon$plus$().init___()
  };
  return $n_sc_$colon$plus$
}
/** @constructor */
function $c_sc_$plus$colon$() {
  $c_O.call(this)
}
$c_sc_$plus$colon$.prototype = new $h_O();
$c_sc_$plus$colon$.prototype.constructor = $c_sc_$plus$colon$;
/** @constructor */
function $h_sc_$plus$colon$() {
  /*<skip>*/
}
$h_sc_$plus$colon$.prototype = $c_sc_$plus$colon$.prototype;
$c_sc_$plus$colon$.prototype.init___ = (function() {
  return this
});
var $d_sc_$plus$colon$ = new $TypeData().initClass({
  sc_$plus$colon$: 0
}, false, "scala.collection.$plus$colon$", {
  sc_$plus$colon$: 1,
  O: 1
});
$c_sc_$plus$colon$.prototype.$classData = $d_sc_$plus$colon$;
var $n_sc_$plus$colon$ = (void 0);
function $m_sc_$plus$colon$() {
  if ((!$n_sc_$plus$colon$)) {
    $n_sc_$plus$colon$ = new $c_sc_$plus$colon$().init___()
  };
  return $n_sc_$plus$colon$
}
/** @constructor */
function $c_sc_Iterator$() {
  $c_O.call(this);
  this.empty$1 = null
}
$c_sc_Iterator$.prototype = new $h_O();
$c_sc_Iterator$.prototype.constructor = $c_sc_Iterator$;
/** @constructor */
function $h_sc_Iterator$() {
  /*<skip>*/
}
$h_sc_Iterator$.prototype = $c_sc_Iterator$.prototype;
$c_sc_Iterator$.prototype.init___ = (function() {
  $n_sc_Iterator$ = this;
  this.empty$1 = new $c_sc_Iterator$$anon$2().init___();
  return this
});
var $d_sc_Iterator$ = new $TypeData().initClass({
  sc_Iterator$: 0
}, false, "scala.collection.Iterator$", {
  sc_Iterator$: 1,
  O: 1
});
$c_sc_Iterator$.prototype.$classData = $d_sc_Iterator$;
var $n_sc_Iterator$ = (void 0);
function $m_sc_Iterator$() {
  if ((!$n_sc_Iterator$)) {
    $n_sc_Iterator$ = new $c_sc_Iterator$().init___()
  };
  return $n_sc_Iterator$
}
function $f_sc_TraversableOnce__copyToArray__O__I__V($thiz, xs, start) {
  $thiz.copyToArray__O__I__I__V(xs, start, (($m_sr_ScalaRunTime$().array$undlength__O__I(xs) - start) | 0))
}
function $f_sc_TraversableOnce__to__scg_CanBuildFrom__O($thiz, cbf) {
  var b = cbf.apply__scm_Builder();
  b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable($thiz.seq__sc_TraversableOnce());
  return b.result__O()
}
function $f_sc_TraversableOnce__mkString__T__T__T__T($thiz, start, sep, end) {
  var this$1 = $thiz.addString__scm_StringBuilder__T__T__T__scm_StringBuilder(new $c_scm_StringBuilder().init___(), start, sep, end);
  var this$2 = this$1.underlying$5;
  return this$2.content$1
}
function $f_sc_TraversableOnce__foldLeft__O__F2__O($thiz, z, op) {
  var result = new $c_sr_ObjectRef().init___O(z);
  $thiz.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, op$1, result$1) {
    return (function(x$2) {
      result$1.elem$1 = op$1.apply__O__O__O(result$1.elem$1, x$2)
    })
  })($thiz, op, result)));
  return result.elem$1
}
function $f_sc_TraversableOnce__size__I($thiz) {
  var result = new $c_sr_IntRef().init___I(0);
  $thiz.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, result$1) {
    return (function(x$2) {
      result$1.elem$1 = ((1 + result$1.elem$1) | 0)
    })
  })($thiz, result)));
  return result.elem$1
}
function $f_sc_TraversableOnce__collectFirst__s_PartialFunction__s_Option($thiz, pf) {
  var nonLocalReturnKey1 = new $c_O().init___();
  try {
    if ($is_sc_Iterator($thiz)) {
      var x2 = $as_sc_Iterator($thiz);
      var i = x2
    } else {
      if ((!$is_sc_GenIterable($thiz))) {
        $thiz.foreach__F1__V(pf.runWith__F1__F1(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, nonLocalReturnKey1$1) {
          return (function(b$2) {
            throw new $c_sr_NonLocalReturnControl().init___O__O(nonLocalReturnKey1$1, new $c_s_Some().init___O(b$2))
          })
        })($thiz, nonLocalReturnKey1))));
        return $m_s_None$()
      };
      var i = $thiz.toIterator__sc_Iterator()
    };
    var sentinel = new $c_sc_TraversableOnce$$anon$2().init___sc_TraversableOnce($thiz);
    while (i.hasNext__Z()) {
      var x = pf.applyOrElse__O__F1__O(i.next__O(), sentinel);
      if ((x !== sentinel)) {
        return new $c_s_Some().init___O(x)
      }
    };
    return $m_s_None$()
  } catch (e) {
    if ($is_sr_NonLocalReturnControl(e)) {
      var ex = $as_sr_NonLocalReturnControl(e);
      if ((ex.key$2 === nonLocalReturnKey1)) {
        return $as_s_Option(ex.value$f)
      } else {
        throw ex
      }
    } else {
      throw e
    }
  }
}
function $f_sc_TraversableOnce__addString__scm_StringBuilder__T__T__T__scm_StringBuilder($thiz, b, start, sep, end) {
  var first = new $c_sr_BooleanRef().init___Z(true);
  b.append__T__scm_StringBuilder(start);
  $thiz.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, b$1, sep$1, first$1) {
    return (function(x$2) {
      if (first$1.elem$1) {
        b$1.append__O__scm_StringBuilder(x$2);
        first$1.elem$1 = false;
        return (void 0)
      } else {
        b$1.append__T__scm_StringBuilder(sep$1);
        return b$1.append__O__scm_StringBuilder(x$2)
      }
    })
  })($thiz, b, sep, first)));
  b.append__T__scm_StringBuilder(end);
  return b
}
function $f_sc_TraversableOnce__max__s_math_Ordering__O($thiz, cmp) {
  if ($thiz.isEmpty__Z()) {
    throw new $c_jl_UnsupportedOperationException().init___T("empty.max")
  };
  return $thiz.reduceLeft__F2__O(new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this, cmp$1) {
    return (function(x$2, y$2) {
      return (cmp$1.gteq__O__O__Z(x$2, y$2) ? x$2 : y$2)
    })
  })($thiz, cmp)))
}
function $f_sc_TraversableOnce__sum__s_math_Numeric__O($thiz, num) {
  return $thiz.foldLeft__O__F2__O(num.fromInt__I__O(0), new $c_sjsr_AnonFunction2().init___sjs_js_Function2((function($this, num$1) {
    return (function(x$2, y$2) {
      return num$1.plus__O__O__O(x$2, y$2)
    })
  })($thiz, num)))
}
function $f_sc_TraversableOnce__toArray__s_reflect_ClassTag__O($thiz, evidence$1) {
  if ($thiz.isTraversableAgain__Z()) {
    var result = evidence$1.newArray__I__O($thiz.size__I());
    $thiz.copyToArray__O__I__V(result, 0);
    return result
  } else {
    return $thiz.toBuffer__scm_Buffer().toArray__s_reflect_ClassTag__O(evidence$1)
  }
}
function $f_sc_TraversableOnce__nonEmpty__Z($thiz) {
  return (!$thiz.isEmpty__Z())
}
function $f_sc_TraversableOnce__reduceLeft__F2__O($thiz, op) {
  if ($thiz.isEmpty__Z()) {
    throw new $c_jl_UnsupportedOperationException().init___T("empty.reduceLeft")
  };
  var first = new $c_sr_BooleanRef().init___Z(true);
  var acc = new $c_sr_ObjectRef().init___O(0);
  $thiz.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, op$1, first$1, acc$1) {
    return (function(x$2) {
      if (first$1.elem$1) {
        acc$1.elem$1 = x$2;
        first$1.elem$1 = false
      } else {
        acc$1.elem$1 = op$1.apply__O__O__O(acc$1.elem$1, x$2)
      }
    })
  })($thiz, op, first, acc)));
  return acc.elem$1
}
function $is_sc_TraversableOnce(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.sc_TraversableOnce)))
}
function $as_sc_TraversableOnce(obj) {
  return (($is_sc_TraversableOnce(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.collection.TraversableOnce"))
}
function $isArrayOf_sc_TraversableOnce(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.sc_TraversableOnce)))
}
function $asArrayOf_sc_TraversableOnce(obj, depth) {
  return (($isArrayOf_sc_TraversableOnce(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.collection.TraversableOnce;", depth))
}
/** @constructor */
function $c_scg_GenMapFactory() {
  $c_O.call(this)
}
$c_scg_GenMapFactory.prototype = new $h_O();
$c_scg_GenMapFactory.prototype.constructor = $c_scg_GenMapFactory;
/** @constructor */
function $h_scg_GenMapFactory() {
  /*<skip>*/
}
$h_scg_GenMapFactory.prototype = $c_scg_GenMapFactory.prototype;
$c_scg_GenMapFactory.prototype.apply__sc_Seq__sc_GenMap = (function(elems) {
  return $as_sc_GenMap($as_scm_Builder(this.newBuilder__scm_Builder().$$plus$plus$eq__sc_TraversableOnce__scg_Growable(elems)).result__O())
});
$c_scg_GenMapFactory.prototype.newBuilder__scm_Builder = (function() {
  return new $c_scm_MapBuilder().init___sc_GenMap(this.empty__sc_GenMap())
});
/** @constructor */
function $c_scg_GenericCompanion() {
  $c_O.call(this)
}
$c_scg_GenericCompanion.prototype = new $h_O();
$c_scg_GenericCompanion.prototype.constructor = $c_scg_GenericCompanion;
/** @constructor */
function $h_scg_GenericCompanion() {
  /*<skip>*/
}
$h_scg_GenericCompanion.prototype = $c_scg_GenericCompanion.prototype;
$c_scg_GenericCompanion.prototype.apply__sc_Seq__sc_GenTraversable = (function(elems) {
  if (elems.isEmpty__Z()) {
    return this.empty__sc_GenTraversable()
  } else {
    var b = this.newBuilder__scm_Builder();
    b.$$plus$plus$eq__sc_TraversableOnce__scg_Growable(elems);
    return $as_sc_GenTraversable(b.result__O())
  }
});
$c_scg_GenericCompanion.prototype.empty__sc_GenTraversable = (function() {
  return $as_sc_GenTraversable(this.newBuilder__scm_Builder().result__O())
});
function $f_scg_Growable__loop$1__pscg_Growable__sc_LinearSeq__V($thiz, xs) {
  _loop: while (true) {
    var this$1 = xs;
    if ($f_sc_TraversableOnce__nonEmpty__Z(this$1)) {
      $thiz.$$plus$eq__O__scg_Growable(xs.head__O());
      xs = $as_sc_LinearSeq(xs.tail__O());
      continue _loop
    };
    break
  }
}
function $f_scg_Growable__$$plus$plus$eq__sc_TraversableOnce__scg_Growable($thiz, xs) {
  if ($is_sc_LinearSeq(xs)) {
    var x2 = $as_sc_LinearSeq(xs);
    var xs$1 = x2;
    $f_scg_Growable__loop$1__pscg_Growable__sc_LinearSeq__V($thiz, xs$1)
  } else {
    xs.foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
      return (function(elem$2) {
        return $this.$$plus$eq__O__scg_Growable(elem$2)
      })
    })($thiz)))
  };
  return $thiz
}
function $is_scg_Growable(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.scg_Growable)))
}
function $as_scg_Growable(obj) {
  return (($is_scg_Growable(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.collection.generic.Growable"))
}
function $isArrayOf_scg_Growable(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.scg_Growable)))
}
function $asArrayOf_scg_Growable(obj, depth) {
  return (($isArrayOf_scg_Growable(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.collection.generic.Growable;", depth))
}
/** @constructor */
function $c_sci_HashMap$Merger() {
  $c_O.call(this)
}
$c_sci_HashMap$Merger.prototype = new $h_O();
$c_sci_HashMap$Merger.prototype.constructor = $c_sci_HashMap$Merger;
/** @constructor */
function $h_sci_HashMap$Merger() {
  /*<skip>*/
}
$h_sci_HashMap$Merger.prototype = $c_sci_HashMap$Merger.prototype;
/** @constructor */
function $c_sci_Stream$$hash$colon$colon$() {
  $c_O.call(this)
}
$c_sci_Stream$$hash$colon$colon$.prototype = new $h_O();
$c_sci_Stream$$hash$colon$colon$.prototype.constructor = $c_sci_Stream$$hash$colon$colon$;
/** @constructor */
function $h_sci_Stream$$hash$colon$colon$() {
  /*<skip>*/
}
$h_sci_Stream$$hash$colon$colon$.prototype = $c_sci_Stream$$hash$colon$colon$.prototype;
$c_sci_Stream$$hash$colon$colon$.prototype.init___ = (function() {
  return this
});
var $d_sci_Stream$$hash$colon$colon$ = new $TypeData().initClass({
  sci_Stream$$hash$colon$colon$: 0
}, false, "scala.collection.immutable.Stream$$hash$colon$colon$", {
  sci_Stream$$hash$colon$colon$: 1,
  O: 1
});
$c_sci_Stream$$hash$colon$colon$.prototype.$classData = $d_sci_Stream$$hash$colon$colon$;
var $n_sci_Stream$$hash$colon$colon$ = (void 0);
function $m_sci_Stream$$hash$colon$colon$() {
  if ((!$n_sci_Stream$$hash$colon$colon$)) {
    $n_sci_Stream$$hash$colon$colon$ = new $c_sci_Stream$$hash$colon$colon$().init___()
  };
  return $n_sci_Stream$$hash$colon$colon$
}
/** @constructor */
function $c_sci_Stream$ConsWrapper() {
  $c_O.call(this);
  this.tl$1 = null
}
$c_sci_Stream$ConsWrapper.prototype = new $h_O();
$c_sci_Stream$ConsWrapper.prototype.constructor = $c_sci_Stream$ConsWrapper;
/** @constructor */
function $h_sci_Stream$ConsWrapper() {
  /*<skip>*/
}
$h_sci_Stream$ConsWrapper.prototype = $c_sci_Stream$ConsWrapper.prototype;
$c_sci_Stream$ConsWrapper.prototype.init___F0 = (function(tl) {
  this.tl$1 = tl;
  return this
});
$c_sci_Stream$ConsWrapper.prototype.$$hash$colon$colon$colon__sci_Stream__sci_Stream = (function(prefix) {
  return prefix.append__F0__sci_Stream(this.tl$1)
});
var $d_sci_Stream$ConsWrapper = new $TypeData().initClass({
  sci_Stream$ConsWrapper: 0
}, false, "scala.collection.immutable.Stream$ConsWrapper", {
  sci_Stream$ConsWrapper: 1,
  O: 1
});
$c_sci_Stream$ConsWrapper.prototype.$classData = $d_sci_Stream$ConsWrapper;
/** @constructor */
function $c_sci_StreamIterator$LazyCell() {
  $c_O.call(this);
  this.v$1 = null;
  this.st$1 = null;
  this.bitmap$0$1 = false;
  this.$$outer$1 = null
}
$c_sci_StreamIterator$LazyCell.prototype = new $h_O();
$c_sci_StreamIterator$LazyCell.prototype.constructor = $c_sci_StreamIterator$LazyCell;
/** @constructor */
function $h_sci_StreamIterator$LazyCell() {
  /*<skip>*/
}
$h_sci_StreamIterator$LazyCell.prototype = $c_sci_StreamIterator$LazyCell.prototype;
$c_sci_StreamIterator$LazyCell.prototype.init___sci_StreamIterator__F0 = (function($$outer, st) {
  this.st$1 = st;
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_sci_StreamIterator$LazyCell.prototype.v$lzycompute__p1__sci_Stream = (function() {
  if ((!this.bitmap$0$1)) {
    this.v$1 = $as_sci_Stream(this.st$1.apply__O());
    this.bitmap$0$1 = true
  };
  this.st$1 = null;
  return this.v$1
});
$c_sci_StreamIterator$LazyCell.prototype.v__sci_Stream = (function() {
  return ((!this.bitmap$0$1) ? this.v$lzycompute__p1__sci_Stream() : this.v$1)
});
var $d_sci_StreamIterator$LazyCell = new $TypeData().initClass({
  sci_StreamIterator$LazyCell: 0
}, false, "scala.collection.immutable.StreamIterator$LazyCell", {
  sci_StreamIterator$LazyCell: 1,
  O: 1
});
$c_sci_StreamIterator$LazyCell.prototype.$classData = $d_sci_StreamIterator$LazyCell;
/** @constructor */
function $c_sci_StringOps$() {
  $c_O.call(this)
}
$c_sci_StringOps$.prototype = new $h_O();
$c_sci_StringOps$.prototype.constructor = $c_sci_StringOps$;
/** @constructor */
function $h_sci_StringOps$() {
  /*<skip>*/
}
$h_sci_StringOps$.prototype = $c_sci_StringOps$.prototype;
$c_sci_StringOps$.prototype.init___ = (function() {
  return this
});
$c_sci_StringOps$.prototype.equals$extension__T__O__Z = (function($$this, x$1) {
  if ($is_sci_StringOps(x$1)) {
    var StringOps$1 = ((x$1 === null) ? null : $as_sci_StringOps(x$1).repr$1);
    return ($$this === StringOps$1)
  } else {
    return false
  }
});
$c_sci_StringOps$.prototype.slice$extension__T__I__I__T = (function($$this, from, until) {
  var start = ((from < 0) ? 0 : from);
  if (((until <= start) || (start >= $uI($$this.length)))) {
    return ""
  };
  var end = ((until > $uI($$this.length)) ? $uI($$this.length) : until);
  return $as_T($$this.substring(start, end))
});
var $d_sci_StringOps$ = new $TypeData().initClass({
  sci_StringOps$: 0
}, false, "scala.collection.immutable.StringOps$", {
  sci_StringOps$: 1,
  O: 1
});
$c_sci_StringOps$.prototype.$classData = $d_sci_StringOps$;
var $n_sci_StringOps$ = (void 0);
function $m_sci_StringOps$() {
  if ((!$n_sci_StringOps$)) {
    $n_sci_StringOps$ = new $c_sci_StringOps$().init___()
  };
  return $n_sci_StringOps$
}
/** @constructor */
function $c_sci_WrappedString$() {
  $c_O.call(this)
}
$c_sci_WrappedString$.prototype = new $h_O();
$c_sci_WrappedString$.prototype.constructor = $c_sci_WrappedString$;
/** @constructor */
function $h_sci_WrappedString$() {
  /*<skip>*/
}
$h_sci_WrappedString$.prototype = $c_sci_WrappedString$.prototype;
$c_sci_WrappedString$.prototype.init___ = (function() {
  return this
});
$c_sci_WrappedString$.prototype.newBuilder__scm_Builder = (function() {
  var this$2 = new $c_scm_StringBuilder().init___();
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$2) {
      var x = $as_T(x$2);
      return new $c_sci_WrappedString().init___T(x)
    })
  })(this));
  return new $c_scm_Builder$$anon$1().init___scm_Builder__F1(this$2, f)
});
var $d_sci_WrappedString$ = new $TypeData().initClass({
  sci_WrappedString$: 0
}, false, "scala.collection.immutable.WrappedString$", {
  sci_WrappedString$: 1,
  O: 1
});
$c_sci_WrappedString$.prototype.$classData = $d_sci_WrappedString$;
var $n_sci_WrappedString$ = (void 0);
function $m_sci_WrappedString$() {
  if ((!$n_sci_WrappedString$)) {
    $n_sci_WrappedString$ = new $c_sci_WrappedString$().init___()
  };
  return $n_sci_WrappedString$
}
/** @constructor */
function $c_scm_ArrayOps$ofBoolean$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofBoolean$.prototype = new $h_O();
$c_scm_ArrayOps$ofBoolean$.prototype.constructor = $c_scm_ArrayOps$ofBoolean$;
/** @constructor */
function $h_scm_ArrayOps$ofBoolean$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofBoolean$.prototype = $c_scm_ArrayOps$ofBoolean$.prototype;
$c_scm_ArrayOps$ofBoolean$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofBoolean$.prototype.equals$extension__AZ__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofBoolean(x$1)) {
    var ofBoolean$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofBoolean(x$1).repr$1);
    return ($$this === ofBoolean$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofBoolean$ = new $TypeData().initClass({
  scm_ArrayOps$ofBoolean$: 0
}, false, "scala.collection.mutable.ArrayOps$ofBoolean$", {
  scm_ArrayOps$ofBoolean$: 1,
  O: 1
});
$c_scm_ArrayOps$ofBoolean$.prototype.$classData = $d_scm_ArrayOps$ofBoolean$;
var $n_scm_ArrayOps$ofBoolean$ = (void 0);
function $m_scm_ArrayOps$ofBoolean$() {
  if ((!$n_scm_ArrayOps$ofBoolean$)) {
    $n_scm_ArrayOps$ofBoolean$ = new $c_scm_ArrayOps$ofBoolean$().init___()
  };
  return $n_scm_ArrayOps$ofBoolean$
}
/** @constructor */
function $c_scm_ArrayOps$ofByte$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofByte$.prototype = new $h_O();
$c_scm_ArrayOps$ofByte$.prototype.constructor = $c_scm_ArrayOps$ofByte$;
/** @constructor */
function $h_scm_ArrayOps$ofByte$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofByte$.prototype = $c_scm_ArrayOps$ofByte$.prototype;
$c_scm_ArrayOps$ofByte$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofByte$.prototype.equals$extension__AB__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofByte(x$1)) {
    var ofByte$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofByte(x$1).repr$1);
    return ($$this === ofByte$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofByte$ = new $TypeData().initClass({
  scm_ArrayOps$ofByte$: 0
}, false, "scala.collection.mutable.ArrayOps$ofByte$", {
  scm_ArrayOps$ofByte$: 1,
  O: 1
});
$c_scm_ArrayOps$ofByte$.prototype.$classData = $d_scm_ArrayOps$ofByte$;
var $n_scm_ArrayOps$ofByte$ = (void 0);
function $m_scm_ArrayOps$ofByte$() {
  if ((!$n_scm_ArrayOps$ofByte$)) {
    $n_scm_ArrayOps$ofByte$ = new $c_scm_ArrayOps$ofByte$().init___()
  };
  return $n_scm_ArrayOps$ofByte$
}
/** @constructor */
function $c_scm_ArrayOps$ofChar$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofChar$.prototype = new $h_O();
$c_scm_ArrayOps$ofChar$.prototype.constructor = $c_scm_ArrayOps$ofChar$;
/** @constructor */
function $h_scm_ArrayOps$ofChar$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofChar$.prototype = $c_scm_ArrayOps$ofChar$.prototype;
$c_scm_ArrayOps$ofChar$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofChar$.prototype.equals$extension__AC__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofChar(x$1)) {
    var ofChar$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofChar(x$1).repr$1);
    return ($$this === ofChar$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofChar$ = new $TypeData().initClass({
  scm_ArrayOps$ofChar$: 0
}, false, "scala.collection.mutable.ArrayOps$ofChar$", {
  scm_ArrayOps$ofChar$: 1,
  O: 1
});
$c_scm_ArrayOps$ofChar$.prototype.$classData = $d_scm_ArrayOps$ofChar$;
var $n_scm_ArrayOps$ofChar$ = (void 0);
function $m_scm_ArrayOps$ofChar$() {
  if ((!$n_scm_ArrayOps$ofChar$)) {
    $n_scm_ArrayOps$ofChar$ = new $c_scm_ArrayOps$ofChar$().init___()
  };
  return $n_scm_ArrayOps$ofChar$
}
/** @constructor */
function $c_scm_ArrayOps$ofDouble$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofDouble$.prototype = new $h_O();
$c_scm_ArrayOps$ofDouble$.prototype.constructor = $c_scm_ArrayOps$ofDouble$;
/** @constructor */
function $h_scm_ArrayOps$ofDouble$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofDouble$.prototype = $c_scm_ArrayOps$ofDouble$.prototype;
$c_scm_ArrayOps$ofDouble$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofDouble$.prototype.equals$extension__AD__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofDouble(x$1)) {
    var ofDouble$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofDouble(x$1).repr$1);
    return ($$this === ofDouble$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofDouble$ = new $TypeData().initClass({
  scm_ArrayOps$ofDouble$: 0
}, false, "scala.collection.mutable.ArrayOps$ofDouble$", {
  scm_ArrayOps$ofDouble$: 1,
  O: 1
});
$c_scm_ArrayOps$ofDouble$.prototype.$classData = $d_scm_ArrayOps$ofDouble$;
var $n_scm_ArrayOps$ofDouble$ = (void 0);
function $m_scm_ArrayOps$ofDouble$() {
  if ((!$n_scm_ArrayOps$ofDouble$)) {
    $n_scm_ArrayOps$ofDouble$ = new $c_scm_ArrayOps$ofDouble$().init___()
  };
  return $n_scm_ArrayOps$ofDouble$
}
/** @constructor */
function $c_scm_ArrayOps$ofFloat$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofFloat$.prototype = new $h_O();
$c_scm_ArrayOps$ofFloat$.prototype.constructor = $c_scm_ArrayOps$ofFloat$;
/** @constructor */
function $h_scm_ArrayOps$ofFloat$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofFloat$.prototype = $c_scm_ArrayOps$ofFloat$.prototype;
$c_scm_ArrayOps$ofFloat$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofFloat$.prototype.equals$extension__AF__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofFloat(x$1)) {
    var ofFloat$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofFloat(x$1).repr$1);
    return ($$this === ofFloat$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofFloat$ = new $TypeData().initClass({
  scm_ArrayOps$ofFloat$: 0
}, false, "scala.collection.mutable.ArrayOps$ofFloat$", {
  scm_ArrayOps$ofFloat$: 1,
  O: 1
});
$c_scm_ArrayOps$ofFloat$.prototype.$classData = $d_scm_ArrayOps$ofFloat$;
var $n_scm_ArrayOps$ofFloat$ = (void 0);
function $m_scm_ArrayOps$ofFloat$() {
  if ((!$n_scm_ArrayOps$ofFloat$)) {
    $n_scm_ArrayOps$ofFloat$ = new $c_scm_ArrayOps$ofFloat$().init___()
  };
  return $n_scm_ArrayOps$ofFloat$
}
/** @constructor */
function $c_scm_ArrayOps$ofInt$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofInt$.prototype = new $h_O();
$c_scm_ArrayOps$ofInt$.prototype.constructor = $c_scm_ArrayOps$ofInt$;
/** @constructor */
function $h_scm_ArrayOps$ofInt$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofInt$.prototype = $c_scm_ArrayOps$ofInt$.prototype;
$c_scm_ArrayOps$ofInt$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofInt$.prototype.equals$extension__AI__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofInt(x$1)) {
    var ofInt$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofInt(x$1).repr$1);
    return ($$this === ofInt$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofInt$ = new $TypeData().initClass({
  scm_ArrayOps$ofInt$: 0
}, false, "scala.collection.mutable.ArrayOps$ofInt$", {
  scm_ArrayOps$ofInt$: 1,
  O: 1
});
$c_scm_ArrayOps$ofInt$.prototype.$classData = $d_scm_ArrayOps$ofInt$;
var $n_scm_ArrayOps$ofInt$ = (void 0);
function $m_scm_ArrayOps$ofInt$() {
  if ((!$n_scm_ArrayOps$ofInt$)) {
    $n_scm_ArrayOps$ofInt$ = new $c_scm_ArrayOps$ofInt$().init___()
  };
  return $n_scm_ArrayOps$ofInt$
}
/** @constructor */
function $c_scm_ArrayOps$ofLong$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofLong$.prototype = new $h_O();
$c_scm_ArrayOps$ofLong$.prototype.constructor = $c_scm_ArrayOps$ofLong$;
/** @constructor */
function $h_scm_ArrayOps$ofLong$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofLong$.prototype = $c_scm_ArrayOps$ofLong$.prototype;
$c_scm_ArrayOps$ofLong$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofLong$.prototype.equals$extension__AJ__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofLong(x$1)) {
    var ofLong$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofLong(x$1).repr$1);
    return ($$this === ofLong$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofLong$ = new $TypeData().initClass({
  scm_ArrayOps$ofLong$: 0
}, false, "scala.collection.mutable.ArrayOps$ofLong$", {
  scm_ArrayOps$ofLong$: 1,
  O: 1
});
$c_scm_ArrayOps$ofLong$.prototype.$classData = $d_scm_ArrayOps$ofLong$;
var $n_scm_ArrayOps$ofLong$ = (void 0);
function $m_scm_ArrayOps$ofLong$() {
  if ((!$n_scm_ArrayOps$ofLong$)) {
    $n_scm_ArrayOps$ofLong$ = new $c_scm_ArrayOps$ofLong$().init___()
  };
  return $n_scm_ArrayOps$ofLong$
}
/** @constructor */
function $c_scm_ArrayOps$ofRef$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofRef$.prototype = new $h_O();
$c_scm_ArrayOps$ofRef$.prototype.constructor = $c_scm_ArrayOps$ofRef$;
/** @constructor */
function $h_scm_ArrayOps$ofRef$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofRef$.prototype = $c_scm_ArrayOps$ofRef$.prototype;
$c_scm_ArrayOps$ofRef$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofRef$.prototype.equals$extension__AO__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofRef(x$1)) {
    var ofRef$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofRef(x$1).repr$1);
    return ($$this === ofRef$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofRef$ = new $TypeData().initClass({
  scm_ArrayOps$ofRef$: 0
}, false, "scala.collection.mutable.ArrayOps$ofRef$", {
  scm_ArrayOps$ofRef$: 1,
  O: 1
});
$c_scm_ArrayOps$ofRef$.prototype.$classData = $d_scm_ArrayOps$ofRef$;
var $n_scm_ArrayOps$ofRef$ = (void 0);
function $m_scm_ArrayOps$ofRef$() {
  if ((!$n_scm_ArrayOps$ofRef$)) {
    $n_scm_ArrayOps$ofRef$ = new $c_scm_ArrayOps$ofRef$().init___()
  };
  return $n_scm_ArrayOps$ofRef$
}
/** @constructor */
function $c_scm_ArrayOps$ofShort$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofShort$.prototype = new $h_O();
$c_scm_ArrayOps$ofShort$.prototype.constructor = $c_scm_ArrayOps$ofShort$;
/** @constructor */
function $h_scm_ArrayOps$ofShort$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofShort$.prototype = $c_scm_ArrayOps$ofShort$.prototype;
$c_scm_ArrayOps$ofShort$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofShort$.prototype.equals$extension__AS__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofShort(x$1)) {
    var ofShort$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofShort(x$1).repr$1);
    return ($$this === ofShort$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofShort$ = new $TypeData().initClass({
  scm_ArrayOps$ofShort$: 0
}, false, "scala.collection.mutable.ArrayOps$ofShort$", {
  scm_ArrayOps$ofShort$: 1,
  O: 1
});
$c_scm_ArrayOps$ofShort$.prototype.$classData = $d_scm_ArrayOps$ofShort$;
var $n_scm_ArrayOps$ofShort$ = (void 0);
function $m_scm_ArrayOps$ofShort$() {
  if ((!$n_scm_ArrayOps$ofShort$)) {
    $n_scm_ArrayOps$ofShort$ = new $c_scm_ArrayOps$ofShort$().init___()
  };
  return $n_scm_ArrayOps$ofShort$
}
/** @constructor */
function $c_scm_ArrayOps$ofUnit$() {
  $c_O.call(this)
}
$c_scm_ArrayOps$ofUnit$.prototype = new $h_O();
$c_scm_ArrayOps$ofUnit$.prototype.constructor = $c_scm_ArrayOps$ofUnit$;
/** @constructor */
function $h_scm_ArrayOps$ofUnit$() {
  /*<skip>*/
}
$h_scm_ArrayOps$ofUnit$.prototype = $c_scm_ArrayOps$ofUnit$.prototype;
$c_scm_ArrayOps$ofUnit$.prototype.init___ = (function() {
  return this
});
$c_scm_ArrayOps$ofUnit$.prototype.equals$extension__Asr_BoxedUnit__O__Z = (function($$this, x$1) {
  if ($is_scm_ArrayOps$ofUnit(x$1)) {
    var ofUnit$1 = ((x$1 === null) ? null : $as_scm_ArrayOps$ofUnit(x$1).repr$1);
    return ($$this === ofUnit$1)
  } else {
    return false
  }
});
var $d_scm_ArrayOps$ofUnit$ = new $TypeData().initClass({
  scm_ArrayOps$ofUnit$: 0
}, false, "scala.collection.mutable.ArrayOps$ofUnit$", {
  scm_ArrayOps$ofUnit$: 1,
  O: 1
});
$c_scm_ArrayOps$ofUnit$.prototype.$classData = $d_scm_ArrayOps$ofUnit$;
var $n_scm_ArrayOps$ofUnit$ = (void 0);
function $m_scm_ArrayOps$ofUnit$() {
  if ((!$n_scm_ArrayOps$ofUnit$)) {
    $n_scm_ArrayOps$ofUnit$ = new $c_scm_ArrayOps$ofUnit$().init___()
  };
  return $n_scm_ArrayOps$ofUnit$
}
function $f_scm_HashTable__calcSizeMapSize__I__I($thiz, tableLength) {
  return ((1 + (tableLength >> 5)) | 0)
}
function $f_scm_HashTable__tableSizeSeed__I($thiz) {
  return $m_jl_Integer$().bitCount__I__I((((-1) + $thiz.table$5.u.length) | 0))
}
function $f_scm_HashTable__findEntry0__pscm_HashTable__O__I__scm_HashEntry($thiz, key, h) {
  var e = $thiz.table$5.get(h);
  while (true) {
    if ((e !== null)) {
      var key1 = e.key$1;
      var jsx$1 = (!$m_sr_BoxesRunTime$().equals__O__O__Z(key1, key))
    } else {
      var jsx$1 = false
    };
    if (jsx$1) {
      var this$1 = e;
      e = this$1.next$1
    } else {
      break
    }
  };
  return e
}
function $f_scm_HashTable__initWithContents__scm_HashTable$Contents__V($thiz, c) {
  if ((c !== null)) {
    $thiz.$$undloadFactor$5 = c.loadFactor__I();
    $thiz.table$5 = c.table__Ascm_HashEntry();
    $thiz.tableSize$5 = c.tableSize__I();
    $thiz.threshold$5 = c.threshold__I();
    $thiz.seedvalue$5 = c.seedvalue__I();
    $thiz.sizemap$5 = c.sizemap__AI()
  }
}
function $f_scm_HashTable__index__I__I($thiz, hcode) {
  var ones = (((-1) + $thiz.table$5.u.length) | 0);
  var exponent = $clz32(ones);
  var seed = $thiz.seedvalue$5;
  return ((($f_scm_HashTable$HashUtils__improve__I__I__I($thiz, hcode, seed) >>> exponent) | 0) & ones)
}
function $f_scm_HashTable__removeEntry__O__scm_HashEntry($thiz, key) {
  var hcode = $m_sr_Statics$().anyHash__O__I(key);
  var h = $f_scm_HashTable__index__I__I($thiz, hcode);
  var e = $thiz.table$5.get(h);
  if ((e !== null)) {
    var key1 = e.key$1;
    if ($m_sr_BoxesRunTime$().equals__O__O__Z(key1, key)) {
      var jsx$1 = $thiz.table$5;
      var this$1 = e;
      jsx$1.set(h, this$1.next$1);
      $thiz.tableSize$5 = (((-1) + $thiz.tableSize$5) | 0);
      $f_scm_HashTable__nnSizeMapRemove__I__V($thiz, h);
      var this$2 = e;
      this$2.next$1 = null;
      return e
    } else {
      var this$3 = e;
      var e1 = this$3.next$1;
      while (true) {
        if ((e1 !== null)) {
          var key1$1 = e1.key$1;
          var jsx$2 = (!$m_sr_BoxesRunTime$().equals__O__O__Z(key1$1, key))
        } else {
          var jsx$2 = false
        };
        if (jsx$2) {
          e = e1;
          var this$4 = e1;
          e1 = this$4.next$1
        } else {
          break
        }
      };
      if ((e1 !== null)) {
        var this$6 = e;
        var this$5 = e1;
        var x$1 = this$5.next$1;
        this$6.next$1 = x$1;
        $thiz.tableSize$5 = (((-1) + $thiz.tableSize$5) | 0);
        $f_scm_HashTable__nnSizeMapRemove__I__V($thiz, h);
        var this$7 = e1;
        this$7.next$1 = null;
        return e1
      }
    }
  };
  return null
}
function $f_scm_HashTable__$$init$__V($thiz) {
  $thiz.$$undloadFactor$5 = 750;
  var this$1 = $m_scm_HashTable$();
  $thiz.table$5 = $newArrayObject($d_scm_HashEntry.getArrayOf(), [this$1.nextPositivePowerOfTwo__I__I(16)]);
  $thiz.tableSize$5 = 0;
  var _loadFactor = $thiz.$$undloadFactor$5;
  var jsx$1 = $m_scm_HashTable$();
  var this$2 = $m_scm_HashTable$();
  $thiz.threshold$5 = jsx$1.newThreshold__I__I__I(_loadFactor, this$2.nextPositivePowerOfTwo__I__I(16));
  $thiz.sizemap$5 = null;
  $thiz.seedvalue$5 = $f_scm_HashTable__tableSizeSeed__I($thiz)
}
function $f_scm_HashTable__scala$collection$mutable$HashTable$$lastPopulatedIndex__I($thiz) {
  var idx = (((-1) + $thiz.table$5.u.length) | 0);
  while ((($thiz.table$5.get(idx) === null) && (idx > 0))) {
    idx = (((-1) + idx) | 0)
  };
  return idx
}
function $f_scm_HashTable__findOrAddEntry__O__O__scm_HashEntry($thiz, key, value) {
  var hcode = $m_sr_Statics$().anyHash__O__I(key);
  var h = $f_scm_HashTable__index__I__I($thiz, hcode);
  var e = $f_scm_HashTable__findEntry0__pscm_HashTable__O__I__scm_HashEntry($thiz, key, h);
  if ((e !== null)) {
    return e
  } else {
    var e$1 = new $c_scm_DefaultEntry().init___O__O(key, value);
    $f_scm_HashTable__addEntry0__pscm_HashTable__scm_HashEntry__I__V($thiz, e$1, h);
    return null
  }
}
function $f_scm_HashTable__findEntry__O__scm_HashEntry($thiz, key) {
  var hcode = $m_sr_Statics$().anyHash__O__I(key);
  var h = $f_scm_HashTable__index__I__I($thiz, hcode);
  return $f_scm_HashTable__findEntry0__pscm_HashTable__O__I__scm_HashEntry($thiz, key, h)
}
function $f_scm_HashTable__addEntry0__pscm_HashTable__scm_HashEntry__I__V($thiz, e, h) {
  var x$1 = $thiz.table$5.get(h);
  e.next$1 = $as_scm_DefaultEntry(x$1);
  $thiz.table$5.set(h, e);
  $thiz.tableSize$5 = ((1 + $thiz.tableSize$5) | 0);
  $f_scm_HashTable__nnSizeMapAdd__I__V($thiz, h);
  if (($thiz.tableSize$5 > $thiz.threshold$5)) {
    var newSize = ($thiz.table$5.u.length << 1);
    $f_scm_HashTable__resize__pscm_HashTable__I__V($thiz, newSize)
  }
}
function $f_scm_HashTable__nnSizeMapRemove__I__V($thiz, h) {
  if (($thiz.sizemap$5 !== null)) {
    var ev$3 = $thiz.sizemap$5;
    var ev$4 = (h >> 5);
    ev$3.set(ev$4, (((-1) + ev$3.get(ev$4)) | 0))
  }
}
function $f_scm_HashTable__nnSizeMapReset__I__V($thiz, tableLength) {
  if (($thiz.sizemap$5 !== null)) {
    var nsize = $f_scm_HashTable__calcSizeMapSize__I__I($thiz, tableLength);
    if (($thiz.sizemap$5.u.length !== nsize)) {
      $thiz.sizemap$5 = $newArrayObject($d_I.getArrayOf(), [nsize])
    } else {
      $m_ju_Arrays$().fill__AI__I__V($thiz.sizemap$5, 0)
    }
  }
}
function $f_scm_HashTable__nnSizeMapAdd__I__V($thiz, h) {
  if (($thiz.sizemap$5 !== null)) {
    var ev$1 = $thiz.sizemap$5;
    var ev$2 = (h >> 5);
    ev$1.set(ev$2, ((1 + ev$1.get(ev$2)) | 0))
  }
}
function $f_scm_HashTable__resize__pscm_HashTable__I__V($thiz, newSize) {
  var oldTable = $thiz.table$5;
  $thiz.table$5 = $newArrayObject($d_scm_HashEntry.getArrayOf(), [newSize]);
  var tableLength = $thiz.table$5.u.length;
  $f_scm_HashTable__nnSizeMapReset__I__V($thiz, tableLength);
  var i = (((-1) + oldTable.u.length) | 0);
  while ((i >= 0)) {
    var e = oldTable.get(i);
    while ((e !== null)) {
      var key = e.key$1;
      var hcode = $m_sr_Statics$().anyHash__O__I(key);
      var h = $f_scm_HashTable__index__I__I($thiz, hcode);
      var this$1 = e;
      var e1 = this$1.next$1;
      var this$2 = e;
      var x$1 = $thiz.table$5.get(h);
      this$2.next$1 = $as_scm_DefaultEntry(x$1);
      $thiz.table$5.set(h, e);
      e = e1;
      $f_scm_HashTable__nnSizeMapAdd__I__V($thiz, h)
    };
    i = (((-1) + i) | 0)
  };
  $thiz.threshold$5 = $m_scm_HashTable$().newThreshold__I__I__I($thiz.$$undloadFactor$5, newSize)
}
/** @constructor */
function $c_scm_HashTable$() {
  $c_O.call(this)
}
$c_scm_HashTable$.prototype = new $h_O();
$c_scm_HashTable$.prototype.constructor = $c_scm_HashTable$;
/** @constructor */
function $h_scm_HashTable$() {
  /*<skip>*/
}
$h_scm_HashTable$.prototype = $c_scm_HashTable$.prototype;
$c_scm_HashTable$.prototype.init___ = (function() {
  return this
});
$c_scm_HashTable$.prototype.nextPositivePowerOfTwo__I__I = (function(target) {
  return (1 << ((-$clz32((((-1) + target) | 0))) | 0))
});
$c_scm_HashTable$.prototype.newThreshold__I__I__I = (function(_loadFactor, size) {
  var hi = (size >> 31);
  var hi$1 = (_loadFactor >> 31);
  var a0 = (65535 & size);
  var a1 = ((size >>> 16) | 0);
  var b0 = (65535 & _loadFactor);
  var b1 = ((_loadFactor >>> 16) | 0);
  var a0b0 = $imul(a0, b0);
  var a1b0 = $imul(a1, b0);
  var a0b1 = $imul(a0, b1);
  var lo = ((a0b0 + (((a1b0 + a0b1) | 0) << 16)) | 0);
  var c1part = ((((a0b0 >>> 16) | 0) + a0b1) | 0);
  var hi$2 = (((((((($imul(size, hi$1) + $imul(hi, _loadFactor)) | 0) + $imul(a1, b1)) | 0) + ((c1part >>> 16) | 0)) | 0) + (((((65535 & c1part) + a1b0) | 0) >>> 16) | 0)) | 0);
  var this$1 = $m_sjsr_RuntimeLong$();
  var lo$1 = this$1.divideImpl__I__I__I__I__I(lo, hi$2, 1000, 0);
  return lo$1
});
var $d_scm_HashTable$ = new $TypeData().initClass({
  scm_HashTable$: 0
}, false, "scala.collection.mutable.HashTable$", {
  scm_HashTable$: 1,
  O: 1
});
$c_scm_HashTable$.prototype.$classData = $d_scm_HashTable$;
var $n_scm_HashTable$ = (void 0);
function $m_scm_HashTable$() {
  if ((!$n_scm_HashTable$)) {
    $n_scm_HashTable$ = new $c_scm_HashTable$().init___()
  };
  return $n_scm_HashTable$
}
/** @constructor */
function $c_scm_WrappedArray$() {
  $c_O.call(this);
  this.EmptyWrappedArray$1 = null
}
$c_scm_WrappedArray$.prototype = new $h_O();
$c_scm_WrappedArray$.prototype.constructor = $c_scm_WrappedArray$;
/** @constructor */
function $h_scm_WrappedArray$() {
  /*<skip>*/
}
$h_scm_WrappedArray$.prototype = $c_scm_WrappedArray$.prototype;
$c_scm_WrappedArray$.prototype.init___ = (function() {
  $n_scm_WrappedArray$ = this;
  this.EmptyWrappedArray$1 = new $c_scm_WrappedArray$ofRef().init___AO($newArrayObject($d_O.getArrayOf(), [0]));
  return this
});
$c_scm_WrappedArray$.prototype.make__O__scm_WrappedArray = (function(x) {
  if ((x === null)) {
    return null
  } else if ($isArrayOf_O(x, 1)) {
    var x3 = $asArrayOf_O(x, 1);
    return new $c_scm_WrappedArray$ofRef().init___AO(x3)
  } else if ($isArrayOf_I(x, 1)) {
    var x4 = $asArrayOf_I(x, 1);
    return new $c_scm_WrappedArray$ofInt().init___AI(x4)
  } else if ($isArrayOf_D(x, 1)) {
    var x5 = $asArrayOf_D(x, 1);
    return new $c_scm_WrappedArray$ofDouble().init___AD(x5)
  } else if ($isArrayOf_J(x, 1)) {
    var x6 = $asArrayOf_J(x, 1);
    return new $c_scm_WrappedArray$ofLong().init___AJ(x6)
  } else if ($isArrayOf_F(x, 1)) {
    var x7 = $asArrayOf_F(x, 1);
    return new $c_scm_WrappedArray$ofFloat().init___AF(x7)
  } else if ($isArrayOf_C(x, 1)) {
    var x8 = $asArrayOf_C(x, 1);
    return new $c_scm_WrappedArray$ofChar().init___AC(x8)
  } else if ($isArrayOf_B(x, 1)) {
    var x9 = $asArrayOf_B(x, 1);
    return new $c_scm_WrappedArray$ofByte().init___AB(x9)
  } else if ($isArrayOf_S(x, 1)) {
    var x10 = $asArrayOf_S(x, 1);
    return new $c_scm_WrappedArray$ofShort().init___AS(x10)
  } else if ($isArrayOf_Z(x, 1)) {
    var x11 = $asArrayOf_Z(x, 1);
    return new $c_scm_WrappedArray$ofBoolean().init___AZ(x11)
  } else if ($isArrayOf_sr_BoxedUnit(x, 1)) {
    var x12 = $asArrayOf_sr_BoxedUnit(x, 1);
    return new $c_scm_WrappedArray$ofUnit().init___Asr_BoxedUnit(x12)
  } else {
    throw new $c_s_MatchError().init___O(x)
  }
});
var $d_scm_WrappedArray$ = new $TypeData().initClass({
  scm_WrappedArray$: 0
}, false, "scala.collection.mutable.WrappedArray$", {
  scm_WrappedArray$: 1,
  O: 1
});
$c_scm_WrappedArray$.prototype.$classData = $d_scm_WrappedArray$;
var $n_scm_WrappedArray$ = (void 0);
function $m_scm_WrappedArray$() {
  if ((!$n_scm_WrappedArray$)) {
    $n_scm_WrappedArray$ = new $c_scm_WrappedArray$().init___()
  };
  return $n_scm_WrappedArray$
}
/** @constructor */
function $c_sjs_concurrent_JSExecutionContext$() {
  $c_O.call(this);
  this.runNow$1 = null;
  this.queue$1 = null
}
$c_sjs_concurrent_JSExecutionContext$.prototype = new $h_O();
$c_sjs_concurrent_JSExecutionContext$.prototype.constructor = $c_sjs_concurrent_JSExecutionContext$;
/** @constructor */
function $h_sjs_concurrent_JSExecutionContext$() {
  /*<skip>*/
}
$h_sjs_concurrent_JSExecutionContext$.prototype = $c_sjs_concurrent_JSExecutionContext$.prototype;
$c_sjs_concurrent_JSExecutionContext$.prototype.init___ = (function() {
  $n_sjs_concurrent_JSExecutionContext$ = this;
  this.runNow$1 = $m_sjs_concurrent_RunNowExecutionContext$();
  this.queue$1 = $m_sjs_concurrent_QueueExecutionContext$().apply__s_concurrent_ExecutionContextExecutor();
  return this
});
var $d_sjs_concurrent_JSExecutionContext$ = new $TypeData().initClass({
  sjs_concurrent_JSExecutionContext$: 0
}, false, "scala.scalajs.concurrent.JSExecutionContext$", {
  sjs_concurrent_JSExecutionContext$: 1,
  O: 1
});
$c_sjs_concurrent_JSExecutionContext$.prototype.$classData = $d_sjs_concurrent_JSExecutionContext$;
var $n_sjs_concurrent_JSExecutionContext$ = (void 0);
function $m_sjs_concurrent_JSExecutionContext$() {
  if ((!$n_sjs_concurrent_JSExecutionContext$)) {
    $n_sjs_concurrent_JSExecutionContext$ = new $c_sjs_concurrent_JSExecutionContext$().init___()
  };
  return $n_sjs_concurrent_JSExecutionContext$
}
/** @constructor */
function $c_sjs_concurrent_QueueExecutionContext$() {
  $c_O.call(this)
}
$c_sjs_concurrent_QueueExecutionContext$.prototype = new $h_O();
$c_sjs_concurrent_QueueExecutionContext$.prototype.constructor = $c_sjs_concurrent_QueueExecutionContext$;
/** @constructor */
function $h_sjs_concurrent_QueueExecutionContext$() {
  /*<skip>*/
}
$h_sjs_concurrent_QueueExecutionContext$.prototype = $c_sjs_concurrent_QueueExecutionContext$.prototype;
$c_sjs_concurrent_QueueExecutionContext$.prototype.init___ = (function() {
  return this
});
$c_sjs_concurrent_QueueExecutionContext$.prototype.apply__s_concurrent_ExecutionContextExecutor = (function() {
  var v = $g.Promise;
  if ((v === (void 0))) {
    return new $c_sjs_concurrent_QueueExecutionContext$TimeoutsExecutionContext().init___()
  } else {
    return new $c_sjs_concurrent_QueueExecutionContext$PromisesExecutionContext().init___()
  }
});
var $d_sjs_concurrent_QueueExecutionContext$ = new $TypeData().initClass({
  sjs_concurrent_QueueExecutionContext$: 0
}, false, "scala.scalajs.concurrent.QueueExecutionContext$", {
  sjs_concurrent_QueueExecutionContext$: 1,
  O: 1
});
$c_sjs_concurrent_QueueExecutionContext$.prototype.$classData = $d_sjs_concurrent_QueueExecutionContext$;
var $n_sjs_concurrent_QueueExecutionContext$ = (void 0);
function $m_sjs_concurrent_QueueExecutionContext$() {
  if ((!$n_sjs_concurrent_QueueExecutionContext$)) {
    $n_sjs_concurrent_QueueExecutionContext$ = new $c_sjs_concurrent_QueueExecutionContext$().init___()
  };
  return $n_sjs_concurrent_QueueExecutionContext$
}
/** @constructor */
function $c_sjs_js_ArrayOps$() {
  $c_O.call(this)
}
$c_sjs_js_ArrayOps$.prototype = new $h_O();
$c_sjs_js_ArrayOps$.prototype.constructor = $c_sjs_js_ArrayOps$;
/** @constructor */
function $h_sjs_js_ArrayOps$() {
  /*<skip>*/
}
$h_sjs_js_ArrayOps$.prototype = $c_sjs_js_ArrayOps$.prototype;
$c_sjs_js_ArrayOps$.prototype.init___ = (function() {
  return this
});
$c_sjs_js_ArrayOps$.prototype.scala$scalajs$js$ArrayOps$$throwUnsupported__T__sr_Nothing$ = (function(msg) {
  throw new $c_jl_UnsupportedOperationException().init___T(msg)
});
var $d_sjs_js_ArrayOps$ = new $TypeData().initClass({
  sjs_js_ArrayOps$: 0
}, false, "scala.scalajs.js.ArrayOps$", {
  sjs_js_ArrayOps$: 1,
  O: 1
});
$c_sjs_js_ArrayOps$.prototype.$classData = $d_sjs_js_ArrayOps$;
var $n_sjs_js_ArrayOps$ = (void 0);
function $m_sjs_js_ArrayOps$() {
  if ((!$n_sjs_js_ArrayOps$)) {
    $n_sjs_js_ArrayOps$ = new $c_sjs_js_ArrayOps$().init___()
  };
  return $n_sjs_js_ArrayOps$
}
/** @constructor */
function $c_sjs_js_Dictionary$() {
  $c_O.call(this)
}
$c_sjs_js_Dictionary$.prototype = new $h_O();
$c_sjs_js_Dictionary$.prototype.constructor = $c_sjs_js_Dictionary$;
/** @constructor */
function $h_sjs_js_Dictionary$() {
  /*<skip>*/
}
$h_sjs_js_Dictionary$.prototype = $c_sjs_js_Dictionary$.prototype;
$c_sjs_js_Dictionary$.prototype.init___ = (function() {
  return this
});
$c_sjs_js_Dictionary$.prototype.apply__sc_Seq__sjs_js_Dictionary = (function(properties) {
  var result = {};
  properties.withFilter__F1__scg_FilterMonadic(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(check$ifrefutable$1$2) {
      var check$ifrefutable$1 = $as_T2(check$ifrefutable$1$2);
      return (check$ifrefutable$1 !== null)
    })
  })(this))).foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2, result$1) {
    return (function(x$1$2) {
      var x$1 = $as_T2(x$1$2);
      if ((x$1 !== null)) {
        var key = $as_T(x$1.$$und1__O());
        var value = x$1.$$und2__O();
        result$1[key] = value
      } else {
        throw new $c_s_MatchError().init___O(x$1)
      }
    })
  })(this, result)));
  return result
});
var $d_sjs_js_Dictionary$ = new $TypeData().initClass({
  sjs_js_Dictionary$: 0
}, false, "scala.scalajs.js.Dictionary$", {
  sjs_js_Dictionary$: 1,
  O: 1
});
$c_sjs_js_Dictionary$.prototype.$classData = $d_sjs_js_Dictionary$;
var $n_sjs_js_Dictionary$ = (void 0);
function $m_sjs_js_Dictionary$() {
  if ((!$n_sjs_js_Dictionary$)) {
    $n_sjs_js_Dictionary$ = new $c_sjs_js_Dictionary$().init___()
  };
  return $n_sjs_js_Dictionary$
}
/** @constructor */
function $c_sjs_js_WrappedDictionary$Cache$() {
  $c_O.call(this);
  this.safeHasOwnProperty$1 = null
}
$c_sjs_js_WrappedDictionary$Cache$.prototype = new $h_O();
$c_sjs_js_WrappedDictionary$Cache$.prototype.constructor = $c_sjs_js_WrappedDictionary$Cache$;
/** @constructor */
function $h_sjs_js_WrappedDictionary$Cache$() {
  /*<skip>*/
}
$h_sjs_js_WrappedDictionary$Cache$.prototype = $c_sjs_js_WrappedDictionary$Cache$.prototype;
$c_sjs_js_WrappedDictionary$Cache$.prototype.init___ = (function() {
  $n_sjs_js_WrappedDictionary$Cache$ = this;
  this.safeHasOwnProperty$1 = $g.Object.prototype.hasOwnProperty;
  return this
});
var $d_sjs_js_WrappedDictionary$Cache$ = new $TypeData().initClass({
  sjs_js_WrappedDictionary$Cache$: 0
}, false, "scala.scalajs.js.WrappedDictionary$Cache$", {
  sjs_js_WrappedDictionary$Cache$: 1,
  O: 1
});
$c_sjs_js_WrappedDictionary$Cache$.prototype.$classData = $d_sjs_js_WrappedDictionary$Cache$;
var $n_sjs_js_WrappedDictionary$Cache$ = (void 0);
function $m_sjs_js_WrappedDictionary$Cache$() {
  if ((!$n_sjs_js_WrappedDictionary$Cache$)) {
    $n_sjs_js_WrappedDictionary$Cache$ = new $c_sjs_js_WrappedDictionary$Cache$().init___()
  };
  return $n_sjs_js_WrappedDictionary$Cache$
}
function $is_sjs_reflect_InstantiatableClass(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.sjs_reflect_InstantiatableClass)))
}
function $as_sjs_reflect_InstantiatableClass(obj) {
  return (($is_sjs_reflect_InstantiatableClass(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "scala.scalajs.reflect.InstantiatableClass"))
}
function $isArrayOf_sjs_reflect_InstantiatableClass(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.sjs_reflect_InstantiatableClass)))
}
function $asArrayOf_sjs_reflect_InstantiatableClass(obj, depth) {
  return (($isArrayOf_sjs_reflect_InstantiatableClass(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lscala.scalajs.reflect.InstantiatableClass;", depth))
}
/** @constructor */
function $c_sjs_reflect_Reflect$() {
  $c_O.call(this);
  this.loadableModuleClasses$1 = null;
  this.instantiatableClasses$1 = null
}
$c_sjs_reflect_Reflect$.prototype = new $h_O();
$c_sjs_reflect_Reflect$.prototype.constructor = $c_sjs_reflect_Reflect$;
/** @constructor */
function $h_sjs_reflect_Reflect$() {
  /*<skip>*/
}
$h_sjs_reflect_Reflect$.prototype = $c_sjs_reflect_Reflect$.prototype;
$c_sjs_reflect_Reflect$.prototype.init___ = (function() {
  $n_sjs_reflect_Reflect$ = this;
  this.loadableModuleClasses$1 = new $c_scm_HashMap().init___();
  this.instantiatableClasses$1 = new $c_scm_HashMap().init___();
  return this
});
var $d_sjs_reflect_Reflect$ = new $TypeData().initClass({
  sjs_reflect_Reflect$: 0
}, false, "scala.scalajs.reflect.Reflect$", {
  sjs_reflect_Reflect$: 1,
  O: 1
});
$c_sjs_reflect_Reflect$.prototype.$classData = $d_sjs_reflect_Reflect$;
var $n_sjs_reflect_Reflect$ = (void 0);
function $m_sjs_reflect_Reflect$() {
  if ((!$n_sjs_reflect_Reflect$)) {
    $n_sjs_reflect_Reflect$ = new $c_sjs_reflect_Reflect$().init___()
  };
  return $n_sjs_reflect_Reflect$
}
/** @constructor */
function $c_sjsr_Bits$() {
  $c_O.call(this);
  this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f = false;
  this.arrayBuffer$1 = null;
  this.int32Array$1 = null;
  this.float32Array$1 = null;
  this.float64Array$1 = null;
  this.areTypedArraysBigEndian$1 = false;
  this.highOffset$1 = 0;
  this.lowOffset$1 = 0
}
$c_sjsr_Bits$.prototype = new $h_O();
$c_sjsr_Bits$.prototype.constructor = $c_sjsr_Bits$;
/** @constructor */
function $h_sjsr_Bits$() {
  /*<skip>*/
}
$h_sjsr_Bits$.prototype = $c_sjsr_Bits$.prototype;
$c_sjsr_Bits$.prototype.init___ = (function() {
  $n_sjsr_Bits$ = this;
  var x = ((($g.ArrayBuffer && $g.Int32Array) && $g.Float32Array) && $g.Float64Array);
  this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f = $uZ((!(!x)));
  this.arrayBuffer$1 = (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f ? new $g.ArrayBuffer(8) : null);
  this.int32Array$1 = (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f ? new $g.Int32Array(this.arrayBuffer$1, 0, 2) : null);
  this.float32Array$1 = (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f ? new $g.Float32Array(this.arrayBuffer$1, 0, 2) : null);
  this.float64Array$1 = (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f ? new $g.Float64Array(this.arrayBuffer$1, 0, 1) : null);
  if ((!this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f)) {
    var jsx$1 = true
  } else {
    this.int32Array$1[0] = 16909060;
    var jsx$1 = ($uB(new $g.Int8Array(this.arrayBuffer$1, 0, 8)[0]) === 1)
  };
  this.areTypedArraysBigEndian$1 = jsx$1;
  this.highOffset$1 = (this.areTypedArraysBigEndian$1 ? 0 : 1);
  this.lowOffset$1 = (this.areTypedArraysBigEndian$1 ? 1 : 0);
  return this
});
$c_sjsr_Bits$.prototype.numberHashCode__D__I = (function(value) {
  var iv = $uI((value | 0));
  if (((iv === value) && ((1.0 / value) !== (-Infinity)))) {
    return iv
  } else {
    var t = this.doubleToLongBits__D__J(value);
    var lo = t.lo$2;
    var hi = t.hi$2;
    return (lo ^ hi)
  }
});
$c_sjsr_Bits$.prototype.doubleToLongBitsPolyfill__p1__D__J = (function(value) {
  if ((value !== value)) {
    var _3 = $uD($g.Math.pow(2.0, 51));
    var x1_$_$$und1$1 = false;
    var x1_$_$$und2$1 = 2047;
    var x1_$_$$und3$1 = _3
  } else if (((value === Infinity) || (value === (-Infinity)))) {
    var _1 = (value < 0);
    var x1_$_$$und1$1 = _1;
    var x1_$_$$und2$1 = 2047;
    var x1_$_$$und3$1 = 0.0
  } else if ((value === 0.0)) {
    var _1$1 = ((1 / value) === (-Infinity));
    var x1_$_$$und1$1 = _1$1;
    var x1_$_$$und2$1 = 0;
    var x1_$_$$und3$1 = 0.0
  } else {
    var s = (value < 0);
    var av = (s ? (-value) : value);
    if ((av >= $uD($g.Math.pow(2.0, (-1022))))) {
      var twoPowFbits = $uD($g.Math.pow(2.0, 52));
      var a = ($uD($g.Math.log(av)) / 0.6931471805599453);
      var x = $uD($g.Math.floor(a));
      var a$1 = $uI((x | 0));
      var e = ((a$1 < 1023) ? a$1 : 1023);
      var b = e;
      var twoPowE = $uD($g.Math.pow(2.0, b));
      if ((twoPowE > av)) {
        e = (((-1) + e) | 0);
        twoPowE = (twoPowE / 2)
      };
      var n = ((av / twoPowE) * twoPowFbits);
      var w = $uD($g.Math.floor(n));
      var f = (n - w);
      var f$1 = ((f < 0.5) ? w : ((f > 0.5) ? (1 + w) : (((w % 2) !== 0) ? (1 + w) : w)));
      if (((f$1 / twoPowFbits) >= 2)) {
        e = ((1 + e) | 0);
        f$1 = 1.0
      };
      if ((e > 1023)) {
        e = 2047;
        f$1 = 0.0
      } else {
        e = ((1023 + e) | 0);
        f$1 = (f$1 - twoPowFbits)
      };
      var _2 = e;
      var _3$1 = f$1;
      var x1_$_$$und1$1 = s;
      var x1_$_$$und2$1 = _2;
      var x1_$_$$und3$1 = _3$1
    } else {
      var n$1 = (av / $uD($g.Math.pow(2.0, (-1074))));
      var w$1 = $uD($g.Math.floor(n$1));
      var f$2 = (n$1 - w$1);
      var _3$2 = ((f$2 < 0.5) ? w$1 : ((f$2 > 0.5) ? (1 + w$1) : (((w$1 % 2) !== 0) ? (1 + w$1) : w$1)));
      var x1_$_$$und1$1 = s;
      var x1_$_$$und2$1 = 0;
      var x1_$_$$und3$1 = _3$2
    }
  };
  var s$1 = $uZ(x1_$_$$und1$1);
  var e$1 = $uI(x1_$_$$und2$1);
  var f$3 = $uD(x1_$_$$und3$1);
  var x$1 = (f$3 / 4.294967296E9);
  var hif = $uI((x$1 | 0));
  var hi = (((s$1 ? (-2147483648) : 0) | (e$1 << 20)) | hif);
  var lo = $uI((f$3 | 0));
  return new $c_sjsr_RuntimeLong().init___I__I(lo, hi)
});
$c_sjsr_Bits$.prototype.longBitsToDoublePolyfill__p1__J__D = (function(bits) {
  var lo = bits.hi$2;
  var x = bits.lo$2;
  var lo$1 = $uD((x >>> 0));
  var s = (lo < 0);
  var e = (2047 & (lo >> 20));
  var f = ((4.294967296E9 * (1048575 & lo)) + lo$1);
  if ((e === 2047)) {
    return ((f !== 0.0) ? (NaN) : (s ? (-Infinity) : Infinity))
  } else if ((e > 0)) {
    var b = (((-1023) + e) | 0);
    var x$1 = ($uD($g.Math.pow(2.0, b)) * (1 + (f / $uD($g.Math.pow(2.0, 52)))));
    return (s ? (-x$1) : x$1)
  } else if ((f !== 0.0)) {
    var x$2 = ($uD($g.Math.pow(2.0, (-1022))) * (f / $uD($g.Math.pow(2.0, 52))));
    return (s ? (-x$2) : x$2)
  } else {
    return (s ? (-0) : 0.0)
  }
});
$c_sjsr_Bits$.prototype.longBitsToDouble__J__D = (function(bits) {
  if (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f) {
    var jsx$2 = this.int32Array$1;
    var jsx$1 = this.highOffset$1;
    var lo = bits.hi$2;
    jsx$2[jsx$1] = lo;
    this.int32Array$1[this.lowOffset$1] = bits.lo$2;
    return $uD(this.float64Array$1[0])
  } else {
    return this.longBitsToDoublePolyfill__p1__J__D(bits)
  }
});
$c_sjsr_Bits$.prototype.doubleToLongBits__D__J = (function(value) {
  if (this.scala$scalajs$runtime$Bits$$$undareTypedArraysSupported$f) {
    this.float64Array$1[0] = value;
    var value$1 = $uI(this.int32Array$1[this.highOffset$1]);
    var value$2 = $uI(this.int32Array$1[this.lowOffset$1]);
    return new $c_sjsr_RuntimeLong().init___I__I(value$2, value$1)
  } else {
    return this.doubleToLongBitsPolyfill__p1__D__J(value)
  }
});
var $d_sjsr_Bits$ = new $TypeData().initClass({
  sjsr_Bits$: 0
}, false, "scala.scalajs.runtime.Bits$", {
  sjsr_Bits$: 1,
  O: 1
});
$c_sjsr_Bits$.prototype.$classData = $d_sjsr_Bits$;
var $n_sjsr_Bits$ = (void 0);
function $m_sjsr_Bits$() {
  if ((!$n_sjsr_Bits$)) {
    $n_sjsr_Bits$ = new $c_sjsr_Bits$().init___()
  };
  return $n_sjsr_Bits$
}
/** @constructor */
function $c_sjsr_RuntimeString$() {
  $c_O.call(this);
  this.CASE$undINSENSITIVE$undORDER$1 = null;
  this.bitmap$0$1 = false
}
$c_sjsr_RuntimeString$.prototype = new $h_O();
$c_sjsr_RuntimeString$.prototype.constructor = $c_sjsr_RuntimeString$;
/** @constructor */
function $h_sjsr_RuntimeString$() {
  /*<skip>*/
}
$h_sjsr_RuntimeString$.prototype = $c_sjsr_RuntimeString$.prototype;
$c_sjsr_RuntimeString$.prototype.endsWith__T__T__Z = (function(thiz, suffix) {
  return ($as_T(thiz.substring((($uI(thiz.length) - $uI(suffix.length)) | 0))) === suffix)
});
$c_sjsr_RuntimeString$.prototype.init___ = (function() {
  return this
});
$c_sjsr_RuntimeString$.prototype.indexOf__T__I__I__I = (function(thiz, ch, fromIndex) {
  var str = this.fromCodePoint__p1__I__T(ch);
  return $uI(thiz.indexOf(str, fromIndex))
});
$c_sjsr_RuntimeString$.prototype.valueOf__C__T = (function(value) {
  return $as_T($g.String.fromCharCode(value))
});
$c_sjsr_RuntimeString$.prototype.split__T__T__I__AT = (function(thiz, regex, limit) {
  if ((thiz === null)) {
    throw new $c_jl_NullPointerException().init___()
  };
  var this$1 = $m_ju_regex_Pattern$();
  return this$1.compile__T__I__ju_regex_Pattern(regex, 0).split__jl_CharSequence__I__AT(thiz, limit)
});
$c_sjsr_RuntimeString$.prototype.toCharArray__T__AC = (function(thiz) {
  var length = $uI(thiz.length);
  var result = $newArrayObject($d_C.getArrayOf(), [length]);
  var i = 0;
  while ((i < length)) {
    var jsx$1 = i;
    var index = i;
    result.set(jsx$1, (65535 & $uI(thiz.charCodeAt(index))));
    i = ((1 + i) | 0)
  };
  return result
});
$c_sjsr_RuntimeString$.prototype.valueOf__O__T = (function(value) {
  return ((value === null) ? "null" : $objectToString(value))
});
$c_sjsr_RuntimeString$.prototype.indexOf__T__I__I = (function(thiz, ch) {
  var str = this.fromCodePoint__p1__I__T(ch);
  return $uI(thiz.indexOf(str))
});
$c_sjsr_RuntimeString$.prototype.newString__AC__I__I__T = (function(value, offset, count) {
  var end = ((offset + count) | 0);
  if ((((offset < 0) || (end < offset)) || (end > value.u.length))) {
    throw new $c_jl_StringIndexOutOfBoundsException().init___()
  };
  var result = "";
  var i = offset;
  while ((i !== end)) {
    var jsx$1 = result;
    var c = value.get(i);
    result = (("" + jsx$1) + $as_T($g.String.fromCharCode(c)));
    i = ((1 + i) | 0)
  };
  return result
});
$c_sjsr_RuntimeString$.prototype.fromCodePoint__p1__I__T = (function(codePoint) {
  if ((((-65536) & codePoint) === 0)) {
    return $as_T($g.String.fromCharCode(codePoint))
  } else if (((codePoint < 0) || (codePoint > 1114111))) {
    throw new $c_jl_IllegalArgumentException().init___()
  } else {
    var offsetCp = (((-65536) + codePoint) | 0);
    return $as_T($g.String.fromCharCode((55296 | (offsetCp >> 10)), (56320 | (1023 & offsetCp))))
  }
});
$c_sjsr_RuntimeString$.prototype.hashCode__T__I = (function(thiz) {
  var res = 0;
  var mul = 1;
  var i = (((-1) + $uI(thiz.length)) | 0);
  while ((i >= 0)) {
    var jsx$1 = res;
    var index = i;
    res = ((jsx$1 + $imul((65535 & $uI(thiz.charCodeAt(index))), mul)) | 0);
    mul = $imul(31, mul);
    i = (((-1) + i) | 0)
  };
  return res
});
$c_sjsr_RuntimeString$.prototype.format__T__AO__T = (function(format, args) {
  var frm = new $c_ju_Formatter().init___();
  var this$1 = frm.format__T__AO__ju_Formatter(format, args);
  var res = this$1.out__jl_Appendable().toString__T();
  frm.close__V();
  return res
});
var $d_sjsr_RuntimeString$ = new $TypeData().initClass({
  sjsr_RuntimeString$: 0
}, false, "scala.scalajs.runtime.RuntimeString$", {
  sjsr_RuntimeString$: 1,
  O: 1
});
$c_sjsr_RuntimeString$.prototype.$classData = $d_sjsr_RuntimeString$;
var $n_sjsr_RuntimeString$ = (void 0);
function $m_sjsr_RuntimeString$() {
  if ((!$n_sjsr_RuntimeString$)) {
    $n_sjsr_RuntimeString$ = new $c_sjsr_RuntimeString$().init___()
  };
  return $n_sjsr_RuntimeString$
}
/** @constructor */
function $c_sjsr_StackTrace$() {
  $c_O.call(this);
  this.isRhino$1 = false;
  this.decompressedClasses$1 = null;
  this.decompressedPrefixes$1 = null;
  this.compressedPrefixes$1 = null;
  this.bitmap$0$1 = 0
}
$c_sjsr_StackTrace$.prototype = new $h_O();
$c_sjsr_StackTrace$.prototype.constructor = $c_sjsr_StackTrace$;
/** @constructor */
function $h_sjsr_StackTrace$() {
  /*<skip>*/
}
$h_sjsr_StackTrace$.prototype = $c_sjsr_StackTrace$.prototype;
$c_sjsr_StackTrace$.prototype.compressedPrefixes$lzycompute__p1__sjs_js_Array = (function() {
  if (((8 & this.bitmap$0$1) === 0)) {
    this.compressedPrefixes$1 = $g.Object.keys(this.decompressedPrefixes__p1__sjs_js_Dictionary());
    this.bitmap$0$1 = (((8 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.compressedPrefixes$1
});
$c_sjsr_StackTrace$.prototype.extractFirefox__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = $as_T(e.stack);
  var jsx$2 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("(?:\\n@:0)?\\s+$", "m"), "");
  var x$1 = $as_T(jsx$2);
  var jsx$1 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^(?:\\((\\S*)\\))?@", "gm"), "{anonymous}($1)@");
  var x$2 = $as_T(jsx$1);
  return x$2.split("\n")
});
$c_sjsr_StackTrace$.prototype.extractOpera10a__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var lineRE = $m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("Line (\\d+).*script (?:in )?(\\S+)(?:: In function (\\S+))?$", "i");
  var x = $as_T(e.stacktrace);
  var lines = x.split("\n");
  var result = [];
  var i = 0;
  var len = $uI(lines.length);
  while ((i < len)) {
    var mtch = lineRE.exec($as_T(lines[i]));
    if ((mtch !== null)) {
      var value = mtch[3];
      var fnName = $as_T(((value === (void 0)) ? "{anonymous}" : value));
      var value$1 = mtch[2];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var value$2 = mtch[1];
      if ((value$2 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var jsx$1 = result.push(((((fnName + "()@") + value$1) + ":") + value$2));
      $uI(jsx$1)
    };
    i = ((2 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.init___ = (function() {
  return this
});
$c_sjsr_StackTrace$.prototype.isRhino__p1__Z = (function() {
  return (((1 & this.bitmap$0$1) === 0) ? this.isRhino$lzycompute__p1__Z() : this.isRhino$1)
});
$c_sjsr_StackTrace$.prototype.decodeClassName__p1__T__T = (function(encodedName) {
  var encoded = (((65535 & $uI(encodedName.charCodeAt(0))) === 36) ? $as_T(encodedName.substring(1)) : encodedName);
  var dict = this.decompressedClasses__p1__sjs_js_Dictionary();
  if ($uZ($m_sjs_js_WrappedDictionary$Cache$().safeHasOwnProperty$1.call(dict, encoded))) {
    var dict$1 = this.decompressedClasses__p1__sjs_js_Dictionary();
    if ((!$uZ($m_sjs_js_WrappedDictionary$Cache$().safeHasOwnProperty$1.call(dict$1, encoded)))) {
      throw new $c_ju_NoSuchElementException().init___T(("key not found: " + encoded))
    };
    var base = $as_T(dict$1[encoded])
  } else {
    var base = this.loop$1__p1__I__T__T(0, encoded)
  };
  var thiz = $as_T(base.split("_").join("."));
  return $as_T(thiz.split("$und").join("_"))
});
$c_sjsr_StackTrace$.prototype.extractOpera10b__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var lineRE = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^(.*)@(.+):(\\d+)$");
  var x = $as_T(e.stacktrace);
  var lines = x.split("\n");
  var result = [];
  var i = 0;
  var len = $uI(lines.length);
  while ((i < len)) {
    var mtch = lineRE.exec($as_T(lines[i]));
    if ((mtch !== null)) {
      var value = mtch[1];
      if ((value === (void 0))) {
        var fnName = "global code"
      } else {
        var x$3 = $as_T(value);
        var fnName = (x$3 + "()")
      };
      var value$1 = mtch[2];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var value$2 = mtch[3];
      if ((value$2 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var jsx$1 = result.push(((((fnName + "@") + value$1) + ":") + value$2));
      $uI(jsx$1)
    };
    i = ((1 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.extractChrome__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = ($as_T(e.stack) + "\n");
  var jsx$6 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^[\\s\\S]+?\\s+at\\s+"), " at ");
  var x$1 = $as_T(jsx$6);
  var jsx$5 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^\\s+(at eval )?at\\s+", "gm"), "");
  var x$2 = $as_T(jsx$5);
  var jsx$4 = x$2.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^([^\\(]+?)([\\n])", "gm"), "{anonymous}() ($1)$2");
  var x$3 = $as_T(jsx$4);
  var jsx$3 = x$3.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^Object.<anonymous>\\s*\\(([^\\)]+)\\)", "gm"), "{anonymous}() ($1)");
  var x$4 = $as_T(jsx$3);
  var jsx$2 = x$4.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^([^\\(]+|\\{anonymous\\}\\(\\)) \\((.+)\\)$", "gm"), "$1@$2");
  var x$5 = $as_T(jsx$2);
  var jsx$1 = x$5.split("\n");
  return jsx$1.slice(0, (-1))
});
$c_sjsr_StackTrace$.prototype.extract__sjs_js_Dynamic__Ajl_StackTraceElement = (function(stackdata) {
  var lines = this.normalizeStackTraceLines__p1__sjs_js_Dynamic__sjs_js_Array(stackdata);
  return this.normalizedLinesToStackTrace__p1__sjs_js_Array__Ajl_StackTraceElement(lines)
});
$c_sjsr_StackTrace$.prototype.compressedPrefixes__p1__sjs_js_Array = (function() {
  return (((8 & this.bitmap$0$1) === 0) ? this.compressedPrefixes$lzycompute__p1__sjs_js_Array() : this.compressedPrefixes$1)
});
$c_sjsr_StackTrace$.prototype.decompressedClasses__p1__sjs_js_Dictionary = (function() {
  return (((2 & this.bitmap$0$1) === 0) ? this.decompressedClasses$lzycompute__p1__sjs_js_Dictionary() : this.decompressedClasses$1)
});
$c_sjsr_StackTrace$.prototype.extractClassMethod__p1__T__T2 = (function(functionName) {
  var PatC = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^(?:Object\\.|\\[object Object\\]\\.)?(?:ScalaJS\\.c\\.|\\$c_)([^\\.]+)(?:\\.prototype)?\\.([^\\.]+)$");
  var PatS = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^(?:Object\\.|\\[object Object\\]\\.)?(?:ScalaJS\\.(?:s|f)\\.|\\$(?:s|f)_)((?:_[^_]|[^_])+)__([^\\.]+)$");
  var PatM = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^(?:Object\\.|\\[object Object\\]\\.)?(?:ScalaJS\\.m\\.|\\$m_)([^\\.]+)$");
  var isModule = false;
  var mtch = PatC.exec(functionName);
  if ((mtch === null)) {
    mtch = PatS.exec(functionName);
    if ((mtch === null)) {
      mtch = PatM.exec(functionName);
      isModule = true
    }
  };
  if ((mtch !== null)) {
    var value = mtch[1];
    if ((value === (void 0))) {
      throw new $c_ju_NoSuchElementException().init___T("undefined.get")
    };
    var className = this.decodeClassName__p1__T__T($as_T(value));
    if (isModule) {
      var methodName = "<clinit>"
    } else {
      var value$1 = mtch[2];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var methodName = this.decodeMethodName__p1__T__T($as_T(value$1))
    };
    return new $c_T2().init___O__O(className, methodName)
  } else {
    return new $c_T2().init___O__O("<jscode>", functionName)
  }
});
$c_sjsr_StackTrace$.prototype.isRhino$lzycompute__p1__Z = (function() {
  if (((1 & this.bitmap$0$1) === 0)) {
    this.isRhino$1 = this.liftedTree1$1__p1__Z();
    this.bitmap$0$1 = (((1 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.isRhino$1
});
$c_sjsr_StackTrace$.prototype.decompressedPrefixes$lzycompute__p1__sjs_js_Dictionary = (function() {
  if (((4 & this.bitmap$0$1) === 0)) {
    this.decompressedPrefixes$1 = {
      "sjsr_": "scala_scalajs_runtime_",
      "sjs_": "scala_scalajs_",
      "sci_": "scala_collection_immutable_",
      "scm_": "scala_collection_mutable_",
      "scg_": "scala_collection_generic_",
      "sc_": "scala_collection_",
      "sr_": "scala_runtime_",
      "s_": "scala_",
      "jl_": "java_lang_",
      "ju_": "java_util_"
    };
    this.bitmap$0$1 = (((4 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.decompressedPrefixes$1
});
$c_sjsr_StackTrace$.prototype.extract__jl_Throwable__Ajl_StackTraceElement = (function(throwable) {
  return this.extract__sjs_js_Dynamic__Ajl_StackTraceElement(throwable.stackdata)
});
$c_sjsr_StackTrace$.prototype.decompressedClasses$lzycompute__p1__sjs_js_Dictionary = (function() {
  if (((2 & this.bitmap$0$1) === 0)) {
    var dict = {
      "O": "java_lang_Object",
      "T": "java_lang_String",
      "V": "scala_Unit",
      "Z": "scala_Boolean",
      "C": "scala_Char",
      "B": "scala_Byte",
      "S": "scala_Short",
      "I": "scala_Int",
      "J": "scala_Long",
      "F": "scala_Float",
      "D": "scala_Double"
    };
    var index = 0;
    while ((index <= 22)) {
      if ((index >= 2)) {
        dict[("T" + index)] = ("scala_Tuple" + index)
      };
      dict[("F" + index)] = ("scala_Function" + index);
      index = ((1 + index) | 0)
    };
    this.decompressedClasses$1 = dict;
    this.bitmap$0$1 = (((2 | this.bitmap$0$1) << 24) >> 24)
  };
  return this.decompressedClasses$1
});
$c_sjsr_StackTrace$.prototype.normalizeStackTraceLines__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = (!e);
  if ($uZ((!(!x)))) {
    return []
  } else if (this.isRhino__p1__Z()) {
    return this.extractRhino__p1__sjs_js_Dynamic__sjs_js_Array(e)
  } else {
    var x$1 = (e.arguments && e.stack);
    if ($uZ((!(!x$1)))) {
      return this.extractChrome__p1__sjs_js_Dynamic__sjs_js_Array(e)
    } else {
      var x$2 = (e.stack && e.sourceURL);
      if ($uZ((!(!x$2)))) {
        return this.extractSafari__p1__sjs_js_Dynamic__sjs_js_Array(e)
      } else {
        var x$3 = (e.stack && e.number);
        if ($uZ((!(!x$3)))) {
          return this.extractIE__p1__sjs_js_Dynamic__sjs_js_Array(e)
        } else {
          var x$4 = (e.stack && e.fileName);
          if ($uZ((!(!x$4)))) {
            return this.extractFirefox__p1__sjs_js_Dynamic__sjs_js_Array(e)
          } else {
            var x$5 = (e.message && e["opera#sourceloc"]);
            if ($uZ((!(!x$5)))) {
              var x$6 = (!e.stacktrace);
              if ($uZ((!(!x$6)))) {
                return this.extractOpera9__p1__sjs_js_Dynamic__sjs_js_Array(e)
              } else {
                var x$7 = ((e.message.indexOf("\n") > (-1)) && (e.message.split("\n").length > e.stacktrace.split("\n").length));
                if ($uZ((!(!x$7)))) {
                  return this.extractOpera9__p1__sjs_js_Dynamic__sjs_js_Array(e)
                } else {
                  return this.extractOpera10a__p1__sjs_js_Dynamic__sjs_js_Array(e)
                }
              }
            } else {
              var x$8 = ((e.message && e.stack) && e.stacktrace);
              if ($uZ((!(!x$8)))) {
                var x$9 = (e.stacktrace.indexOf("called from line") < 0);
                if ($uZ((!(!x$9)))) {
                  return this.extractOpera10b__p1__sjs_js_Dynamic__sjs_js_Array(e)
                } else {
                  return this.extractOpera11__p1__sjs_js_Dynamic__sjs_js_Array(e)
                }
              } else {
                var x$10 = (e.stack && (!e.fileName));
                if ($uZ((!(!x$10)))) {
                  return this.extractChrome__p1__sjs_js_Dynamic__sjs_js_Array(e)
                } else {
                  return this.extractOther__p1__sjs_js_Dynamic__sjs_js_Array(e)
                }
              }
            }
          }
        }
      }
    }
  }
});
$c_sjsr_StackTrace$.prototype.extractOpera9__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var lineRE = $m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("Line (\\d+).*script (?:in )?(\\S+)", "i");
  var x = $as_T(e.message);
  var lines = x.split("\n");
  var result = [];
  var i = 2;
  var len = $uI(lines.length);
  while ((i < len)) {
    var mtch = lineRE.exec($as_T(lines[i]));
    if ((mtch !== null)) {
      var value = mtch[2];
      if ((value === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var value$1 = mtch[1];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var jsx$1 = result.push(((("{anonymous}()@" + value) + ":") + value$1));
      $uI(jsx$1)
    };
    i = ((2 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.normalizedLinesToStackTrace__p1__sjs_js_Array__Ajl_StackTraceElement = (function(lines) {
  var NormalizedFrameLine = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^([^\\@]*)\\@(.*):([0-9]+)$");
  var NormalizedFrameLineWithColumn = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^([^\\@]*)\\@(.*):([0-9]+):([0-9]+)$");
  var trace = [];
  var i = 0;
  while ((i < $uI(lines.length))) {
    var line = $as_T(lines[i]);
    if ((line === null)) {
      throw new $c_jl_NullPointerException().init___()
    };
    if ((line !== "")) {
      var mtch1 = NormalizedFrameLineWithColumn.exec(line);
      if ((mtch1 !== null)) {
        var value = mtch1[1];
        if ((value === (void 0))) {
          throw new $c_ju_NoSuchElementException().init___T("undefined.get")
        };
        var x1 = this.extractClassMethod__p1__T__T2($as_T(value));
        if ((x1 === null)) {
          throw new $c_s_MatchError().init___O(x1)
        };
        var className = $as_T(x1.$$und1__O());
        var methodName = $as_T(x1.$$und2__O());
        var value$1 = mtch1[2];
        if ((value$1 === (void 0))) {
          throw new $c_ju_NoSuchElementException().init___T("undefined.get")
        };
        var fileName = $as_T(value$1);
        var value$2 = mtch1[3];
        if ((value$2 === (void 0))) {
          throw new $c_ju_NoSuchElementException().init___T("undefined.get")
        };
        var x = $as_T(value$2);
        var this$15 = new $c_sci_StringOps().init___T(x);
        var this$17 = $m_jl_Integer$();
        var $$this = this$15.repr$1;
        var lineNumber = this$17.parseInt__T__I__I($$this, 10);
        var value$3 = mtch1[4];
        if ((value$3 === (void 0))) {
          throw new $c_ju_NoSuchElementException().init___T("undefined.get")
        };
        var x$1 = $as_T(value$3);
        var this$23 = new $c_sci_StringOps().init___T(x$1);
        var this$25 = $m_jl_Integer$();
        var $$this$1 = this$23.repr$1;
        var value$4 = this$25.parseInt__T__I__I($$this$1, 10);
        var jsx$1 = trace.push({
          "declaringClass": className,
          "methodName": methodName,
          "fileName": fileName,
          "lineNumber": lineNumber,
          "columnNumber": ((value$4 === (void 0)) ? (void 0) : value$4)
        });
        $uI(jsx$1)
      } else {
        var mtch2 = NormalizedFrameLine.exec(line);
        if ((mtch2 !== null)) {
          var value$5 = mtch2[1];
          if ((value$5 === (void 0))) {
            throw new $c_ju_NoSuchElementException().init___T("undefined.get")
          };
          var x1$2 = this.extractClassMethod__p1__T__T2($as_T(value$5));
          if ((x1$2 === null)) {
            throw new $c_s_MatchError().init___O(x1$2)
          };
          var className$3 = $as_T(x1$2.$$und1__O());
          var methodName$3 = $as_T(x1$2.$$und2__O());
          var value$6 = mtch2[2];
          if ((value$6 === (void 0))) {
            throw new $c_ju_NoSuchElementException().init___T("undefined.get")
          };
          var fileName$1 = $as_T(value$6);
          var value$7 = mtch2[3];
          if ((value$7 === (void 0))) {
            throw new $c_ju_NoSuchElementException().init___T("undefined.get")
          };
          var x$2 = $as_T(value$7);
          var this$52 = new $c_sci_StringOps().init___T(x$2);
          var this$54 = $m_jl_Integer$();
          var $$this$2 = this$52.repr$1;
          var lineNumber$1 = this$54.parseInt__T__I__I($$this$2, 10);
          var jsx$2 = trace.push({
            "declaringClass": className$3,
            "methodName": methodName$3,
            "fileName": fileName$1,
            "lineNumber": lineNumber$1,
            "columnNumber": (void 0)
          });
          $uI(jsx$2)
        } else {
          $uI(trace.push({
            "declaringClass": "<jscode>",
            "methodName": line,
            "fileName": null,
            "lineNumber": (-1),
            "columnNumber": (void 0)
          }))
        }
      }
    };
    i = ((1 + i) | 0)
  };
  var value$8 = $env.sourceMapper;
  var mappedTrace = ((value$8 === (void 0)) ? trace : value$8(trace));
  var result = $newArrayObject($d_jl_StackTraceElement.getArrayOf(), [$uI(mappedTrace.length)]);
  i = 0;
  while ((i < $uI(mappedTrace.length))) {
    var jsSte = mappedTrace[i];
    var ste = new $c_jl_StackTraceElement().init___T__T__T__I($as_T(jsSte.declaringClass), $as_T(jsSte.methodName), $as_T(jsSte.fileName), $uI(jsSte.lineNumber));
    var value$9 = jsSte.columnNumber;
    if ((value$9 !== (void 0))) {
      var columnNumber = $uI(value$9);
      ste.setColumnNumber(columnNumber)
    };
    result.set(i, ste);
    i = ((1 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.extractOpera11__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var lineRE = $m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("^.*line (\\d+), column (\\d+)(?: in (.+))? in (\\S+):$");
  var x = $as_T(e.stacktrace);
  var lines = x.split("\n");
  var result = [];
  var i = 0;
  var len = $uI(lines.length);
  while ((i < len)) {
    var mtch = lineRE.exec($as_T(lines[i]));
    if ((mtch !== null)) {
      var value = mtch[4];
      if ((value === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var jsx$1 = $as_T(value);
      var value$1 = mtch[1];
      if ((value$1 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var value$2 = mtch[2];
      if ((value$2 === (void 0))) {
        throw new $c_ju_NoSuchElementException().init___T("undefined.get")
      };
      var location = ((((jsx$1 + ":") + value$1) + ":") + value$2);
      var value$3 = mtch[2];
      var fnName0 = $as_T(((value$3 === (void 0)) ? "global code" : value$3));
      var x$1 = $as_T(fnName0.replace($m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("<anonymous function: (\\S+)>"), "$1"));
      var jsx$2 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension0__T__sjs_js_RegExp("<anonymous function>"), "{anonymous}");
      var fnName = $as_T(jsx$2);
      $uI(result.push(((fnName + "@") + location)))
    };
    i = ((2 + i) | 0)
  };
  return result
});
$c_sjsr_StackTrace$.prototype.extractSafari__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = $as_T(e.stack);
  var jsx$3 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("\\[native code\\]\\n", "m"), "");
  var x$1 = $as_T(jsx$3);
  var jsx$2 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^(?=\\w+Error\\:).*$\\n", "m"), "");
  var x$2 = $as_T(jsx$2);
  var jsx$1 = x$2.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^@", "gm"), "{anonymous}()@");
  var x$3 = $as_T(jsx$1);
  return x$3.split("\n")
});
$c_sjsr_StackTrace$.prototype.loop$1__p1__I__T__T = (function(i, encoded$1) {
  _loop: while (true) {
    if ((i < $uI(this.compressedPrefixes__p1__sjs_js_Array().length))) {
      var prefix = $as_T(this.compressedPrefixes__p1__sjs_js_Array()[i]);
      if ((($uI(encoded$1.length) >= 0) && ($as_T(encoded$1.substring(0, $uI(prefix.length))) === prefix))) {
        var dict = this.decompressedPrefixes__p1__sjs_js_Dictionary();
        if ((!$uZ($m_sjs_js_WrappedDictionary$Cache$().safeHasOwnProperty$1.call(dict, prefix)))) {
          throw new $c_ju_NoSuchElementException().init___T(("key not found: " + prefix))
        };
        var jsx$1 = $as_T(dict[prefix]);
        var beginIndex = $uI(prefix.length);
        return (("" + jsx$1) + $as_T(encoded$1.substring(beginIndex)))
      } else {
        i = ((1 + i) | 0);
        continue _loop
      }
    } else {
      return ((($uI(encoded$1.length) >= 0) && ($as_T(encoded$1.substring(0, $uI("L".length))) === "L")) ? $as_T(encoded$1.substring(1)) : encoded$1)
    }
  }
});
$c_sjsr_StackTrace$.prototype.liftedTree1$1__p1__Z = (function() {
  try {
    $g.Packages.org.mozilla.javascript.JavaScriptException;
    return true
  } catch (e) {
    var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
    if ((e$2 !== null)) {
      if ($is_sjs_js_JavaScriptException(e$2)) {
        return false
      } else {
        throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(e$2)
      }
    } else {
      throw e
    }
  }
});
$c_sjsr_StackTrace$.prototype.decompressedPrefixes__p1__sjs_js_Dictionary = (function() {
  return (((4 & this.bitmap$0$1) === 0) ? this.decompressedPrefixes$lzycompute__p1__sjs_js_Dictionary() : this.decompressedPrefixes$1)
});
$c_sjsr_StackTrace$.prototype.extractRhino__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var value = e.stack;
  var x = $as_T(((value === (void 0)) ? "" : value));
  var jsx$3 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^\\s+at\\s+", "gm"), "");
  var x$1 = $as_T(jsx$3);
  var jsx$2 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^(.+?)(?: \\((.+)\\))?$", "gm"), "$2@$1");
  var x$2 = $as_T(jsx$2);
  var jsx$1 = x$2.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("\\r\\n?", "gm"), "\n");
  var x$3 = $as_T(jsx$1);
  return x$3.split("\n")
});
$c_sjsr_StackTrace$.prototype.extractOther__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  return []
});
$c_sjsr_StackTrace$.prototype.extractIE__p1__sjs_js_Dynamic__sjs_js_Array = (function(e) {
  var x = $as_T(e.stack);
  var jsx$3 = x.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^\\s*at\\s+(.*)$", "gm"), "$1");
  var x$1 = $as_T(jsx$3);
  var jsx$2 = x$1.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^Anonymous function\\s+", "gm"), "{anonymous}() ");
  var x$2 = $as_T(jsx$2);
  var jsx$1 = x$2.replace($m_sjsr_StackTrace$StringRE$().re$extension1__T__T__sjs_js_RegExp("^([^\\(]+|\\{anonymous\\}\\(\\))\\s+\\((.+)\\)$", "gm"), "$1@$2");
  var x$3 = $as_T(jsx$1);
  var qual$1 = x$3.split("\n");
  return qual$1.slice(1)
});
$c_sjsr_StackTrace$.prototype.decodeMethodName__p1__T__T = (function(encodedName) {
  if ((($uI(encodedName.length) >= 0) && ($as_T(encodedName.substring(0, $uI("init___".length))) === "init___"))) {
    return "<init>"
  } else {
    var methodNameLen = $uI(encodedName.indexOf("__"));
    return ((methodNameLen < 0) ? encodedName : $as_T(encodedName.substring(0, methodNameLen)))
  }
});
var $d_sjsr_StackTrace$ = new $TypeData().initClass({
  sjsr_StackTrace$: 0
}, false, "scala.scalajs.runtime.StackTrace$", {
  sjsr_StackTrace$: 1,
  O: 1
});
$c_sjsr_StackTrace$.prototype.$classData = $d_sjsr_StackTrace$;
var $n_sjsr_StackTrace$ = (void 0);
function $m_sjsr_StackTrace$() {
  if ((!$n_sjsr_StackTrace$)) {
    $n_sjsr_StackTrace$ = new $c_sjsr_StackTrace$().init___()
  };
  return $n_sjsr_StackTrace$
}
/** @constructor */
function $c_sjsr_StackTrace$StringRE$() {
  $c_O.call(this)
}
$c_sjsr_StackTrace$StringRE$.prototype = new $h_O();
$c_sjsr_StackTrace$StringRE$.prototype.constructor = $c_sjsr_StackTrace$StringRE$;
/** @constructor */
function $h_sjsr_StackTrace$StringRE$() {
  /*<skip>*/
}
$h_sjsr_StackTrace$StringRE$.prototype = $c_sjsr_StackTrace$StringRE$.prototype;
$c_sjsr_StackTrace$StringRE$.prototype.init___ = (function() {
  return this
});
$c_sjsr_StackTrace$StringRE$.prototype.re$extension1__T__T__sjs_js_RegExp = (function($$this, mods) {
  return new $g.RegExp($$this, mods)
});
$c_sjsr_StackTrace$StringRE$.prototype.re$extension0__T__sjs_js_RegExp = (function($$this) {
  return new $g.RegExp($$this)
});
var $d_sjsr_StackTrace$StringRE$ = new $TypeData().initClass({
  sjsr_StackTrace$StringRE$: 0
}, false, "scala.scalajs.runtime.StackTrace$StringRE$", {
  sjsr_StackTrace$StringRE$: 1,
  O: 1
});
$c_sjsr_StackTrace$StringRE$.prototype.$classData = $d_sjsr_StackTrace$StringRE$;
var $n_sjsr_StackTrace$StringRE$ = (void 0);
function $m_sjsr_StackTrace$StringRE$() {
  if ((!$n_sjsr_StackTrace$StringRE$)) {
    $n_sjsr_StackTrace$StringRE$ = new $c_sjsr_StackTrace$StringRE$().init___()
  };
  return $n_sjsr_StackTrace$StringRE$
}
/** @constructor */
function $c_sjsr_package$() {
  $c_O.call(this)
}
$c_sjsr_package$.prototype = new $h_O();
$c_sjsr_package$.prototype.constructor = $c_sjsr_package$;
/** @constructor */
function $h_sjsr_package$() {
  /*<skip>*/
}
$h_sjsr_package$.prototype = $c_sjsr_package$.prototype;
$c_sjsr_package$.prototype.init___ = (function() {
  return this
});
$c_sjsr_package$.prototype.unwrapJavaScriptException__jl_Throwable__O = (function(th) {
  if ($is_sjs_js_JavaScriptException(th)) {
    var x2 = $as_sjs_js_JavaScriptException(th);
    var e = x2.exception$4;
    return e
  } else {
    return th
  }
});
$c_sjsr_package$.prototype.wrapJavaScriptException__O__jl_Throwable = (function(e) {
  if ($is_jl_Throwable(e)) {
    var x2 = $as_jl_Throwable(e);
    return x2
  } else {
    return new $c_sjs_js_JavaScriptException().init___O(e)
  }
});
var $d_sjsr_package$ = new $TypeData().initClass({
  sjsr_package$: 0
}, false, "scala.scalajs.runtime.package$", {
  sjsr_package$: 1,
  O: 1
});
$c_sjsr_package$.prototype.$classData = $d_sjsr_package$;
var $n_sjsr_package$ = (void 0);
function $m_sjsr_package$() {
  if ((!$n_sjsr_package$)) {
    $n_sjsr_package$ = new $c_sjsr_package$().init___()
  };
  return $n_sjsr_package$
}
/** @constructor */
function $c_sr_BoxesRunTime$() {
  $c_O.call(this)
}
$c_sr_BoxesRunTime$.prototype = new $h_O();
$c_sr_BoxesRunTime$.prototype.constructor = $c_sr_BoxesRunTime$;
/** @constructor */
function $h_sr_BoxesRunTime$() {
  /*<skip>*/
}
$h_sr_BoxesRunTime$.prototype = $c_sr_BoxesRunTime$.prototype;
$c_sr_BoxesRunTime$.prototype.init___ = (function() {
  return this
});
$c_sr_BoxesRunTime$.prototype.equalsCharObject__jl_Character__O__Z = (function(xc, y) {
  if ($is_jl_Character(y)) {
    var x2 = $as_jl_Character(y);
    return (xc.value$1 === x2.value$1)
  } else if ($is_jl_Number(y)) {
    var x3 = $as_jl_Number(y);
    if (((typeof x3) === "number")) {
      var x2$1 = $uD(x3);
      return (x2$1 === xc.value$1)
    } else if ($is_sjsr_RuntimeLong(x3)) {
      var t = $uJ(x3);
      var lo = t.lo$2;
      var hi = t.hi$2;
      var value = xc.value$1;
      var hi$1 = (value >> 31);
      return ((lo === value) && (hi === hi$1))
    } else {
      return ((x3 === null) ? (xc === null) : $objectEquals(x3, xc))
    }
  } else {
    return ((xc === null) && (y === null))
  }
});
$c_sr_BoxesRunTime$.prototype.equalsNumObject__jl_Number__O__Z = (function(xn, y) {
  if ($is_jl_Number(y)) {
    var x2 = $as_jl_Number(y);
    return this.equalsNumNum__jl_Number__jl_Number__Z(xn, x2)
  } else if ($is_jl_Character(y)) {
    var x3 = $as_jl_Character(y);
    if (((typeof xn) === "number")) {
      var x2$1 = $uD(xn);
      return (x2$1 === x3.value$1)
    } else if ($is_sjsr_RuntimeLong(xn)) {
      var t = $uJ(xn);
      var lo = t.lo$2;
      var hi = t.hi$2;
      var value = x3.value$1;
      var hi$1 = (value >> 31);
      return ((lo === value) && (hi === hi$1))
    } else {
      return ((xn === null) ? (x3 === null) : $objectEquals(xn, x3))
    }
  } else {
    return ((xn === null) ? (y === null) : $objectEquals(xn, y))
  }
});
$c_sr_BoxesRunTime$.prototype.equals__O__O__Z = (function(x, y) {
  if ((x === y)) {
    return true
  } else if ($is_jl_Number(x)) {
    var x2 = $as_jl_Number(x);
    return this.equalsNumObject__jl_Number__O__Z(x2, y)
  } else if ($is_jl_Character(x)) {
    var x3 = $as_jl_Character(x);
    return this.equalsCharObject__jl_Character__O__Z(x3, y)
  } else {
    return ((x === null) ? (y === null) : $objectEquals(x, y))
  }
});
$c_sr_BoxesRunTime$.prototype.equalsNumNum__jl_Number__jl_Number__Z = (function(xn, yn) {
  if (((typeof xn) === "number")) {
    var x2 = $uD(xn);
    if (((typeof yn) === "number")) {
      var x2$2 = $uD(yn);
      return (x2 === x2$2)
    } else if ($is_sjsr_RuntimeLong(yn)) {
      var t = $uJ(yn);
      var lo = t.lo$2;
      var hi = t.hi$2;
      return (x2 === $m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo, hi))
    } else if ($is_s_math_ScalaNumber(yn)) {
      var x4 = $as_s_math_ScalaNumber(yn);
      return x4.equals__O__Z(x2)
    } else {
      return false
    }
  } else if ($is_sjsr_RuntimeLong(xn)) {
    var t$1 = $uJ(xn);
    var lo$1 = t$1.lo$2;
    var hi$1 = t$1.hi$2;
    if ($is_sjsr_RuntimeLong(yn)) {
      var t$2 = $uJ(yn);
      var lo$2 = t$2.lo$2;
      var hi$2 = t$2.hi$2;
      return ((lo$1 === lo$2) && (hi$1 === hi$2))
    } else if (((typeof yn) === "number")) {
      var x3$3 = $uD(yn);
      return ($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo$1, hi$1) === x3$3)
    } else if ($is_s_math_ScalaNumber(yn)) {
      var x4$2 = $as_s_math_ScalaNumber(yn);
      return x4$2.equals__O__Z(new $c_sjsr_RuntimeLong().init___I__I(lo$1, hi$1))
    } else {
      return false
    }
  } else {
    return ((xn === null) ? (yn === null) : $objectEquals(xn, yn))
  }
});
var $d_sr_BoxesRunTime$ = new $TypeData().initClass({
  sr_BoxesRunTime$: 0
}, false, "scala.runtime.BoxesRunTime$", {
  sr_BoxesRunTime$: 1,
  O: 1
});
$c_sr_BoxesRunTime$.prototype.$classData = $d_sr_BoxesRunTime$;
var $n_sr_BoxesRunTime$ = (void 0);
function $m_sr_BoxesRunTime$() {
  if ((!$n_sr_BoxesRunTime$)) {
    $n_sr_BoxesRunTime$ = new $c_sr_BoxesRunTime$().init___()
  };
  return $n_sr_BoxesRunTime$
}
/** @constructor */
function $c_sr_LazyBoolean() {
  $c_O.call(this);
  this.$$undinitialized$1 = false;
  this.$$undvalue$1 = false
}
$c_sr_LazyBoolean.prototype = new $h_O();
$c_sr_LazyBoolean.prototype.constructor = $c_sr_LazyBoolean;
/** @constructor */
function $h_sr_LazyBoolean() {
  /*<skip>*/
}
$h_sr_LazyBoolean.prototype = $c_sr_LazyBoolean.prototype;
$c_sr_LazyBoolean.prototype.init___ = (function() {
  return this
});
$c_sr_LazyBoolean.prototype.toString__T = (function() {
  return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["LazyBoolean ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([(this.$$undinitialized$1 ? new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["of: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.$$undvalue$1])) : "thunk")]))
});
$c_sr_LazyBoolean.prototype.initialize__Z__Z = (function(value) {
  this.$$undvalue$1 = value;
  this.$$undinitialized$1 = true;
  return value
});
var $d_sr_LazyBoolean = new $TypeData().initClass({
  sr_LazyBoolean: 0
}, false, "scala.runtime.LazyBoolean", {
  sr_LazyBoolean: 1,
  O: 1
});
$c_sr_LazyBoolean.prototype.$classData = $d_sr_LazyBoolean;
/** @constructor */
function $c_sr_LazyInt() {
  $c_O.call(this);
  this.$$undinitialized$1 = false;
  this.$$undvalue$1 = 0
}
$c_sr_LazyInt.prototype = new $h_O();
$c_sr_LazyInt.prototype.constructor = $c_sr_LazyInt;
/** @constructor */
function $h_sr_LazyInt() {
  /*<skip>*/
}
$h_sr_LazyInt.prototype = $c_sr_LazyInt.prototype;
$c_sr_LazyInt.prototype.init___ = (function() {
  return this
});
$c_sr_LazyInt.prototype.toString__T = (function() {
  return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["LazyInt ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([(this.$$undinitialized$1 ? new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["of: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.$$undvalue$1])) : "thunk")]))
});
$c_sr_LazyInt.prototype.initialize__I__I = (function(value) {
  this.$$undvalue$1 = value;
  this.$$undinitialized$1 = true;
  return value
});
var $d_sr_LazyInt = new $TypeData().initClass({
  sr_LazyInt: 0
}, false, "scala.runtime.LazyInt", {
  sr_LazyInt: 1,
  O: 1
});
$c_sr_LazyInt.prototype.$classData = $d_sr_LazyInt;
var $d_sr_Null$ = new $TypeData().initClass({
  sr_Null$: 0
}, false, "scala.runtime.Null$", {
  sr_Null$: 1,
  O: 1
});
/** @constructor */
function $c_sr_RichDouble$() {
  $c_O.call(this)
}
$c_sr_RichDouble$.prototype = new $h_O();
$c_sr_RichDouble$.prototype.constructor = $c_sr_RichDouble$;
/** @constructor */
function $h_sr_RichDouble$() {
  /*<skip>*/
}
$h_sr_RichDouble$.prototype = $c_sr_RichDouble$.prototype;
$c_sr_RichDouble$.prototype.equals$extension__D__O__Z = (function($$this, x$1) {
  if ($is_sr_RichDouble(x$1)) {
    var RichDouble$1 = $as_sr_RichDouble(x$1).self$1;
    return ($$this === RichDouble$1)
  } else {
    return false
  }
});
$c_sr_RichDouble$.prototype.init___ = (function() {
  return this
});
$c_sr_RichDouble$.prototype.floatValue$extension__D__F = (function($$this) {
  return $fround($$this)
});
$c_sr_RichDouble$.prototype.isValidByte$extension__D__Z = (function($$this) {
  return ((($$this << 24) >> 24) === $$this)
});
$c_sr_RichDouble$.prototype.intValue$extension__D__I = (function($$this) {
  return $doubleToInt($$this)
});
$c_sr_RichDouble$.prototype.isValidChar$extension__D__Z = (function($$this) {
  return ((65535 & $doubleToInt($$this)) === $$this)
});
$c_sr_RichDouble$.prototype.isValidShort$extension__D__Z = (function($$this) {
  return ((($$this << 16) >> 16) === $$this)
});
$c_sr_RichDouble$.prototype.byteValue$extension__D__B = (function($$this) {
  return (($$this << 24) >> 24)
});
$c_sr_RichDouble$.prototype.isValidInt$extension__D__Z = (function($$this) {
  return ($doubleToInt($$this) === $$this)
});
$c_sr_RichDouble$.prototype.shortValue$extension__D__S = (function($$this) {
  return (($$this << 16) >> 16)
});
$c_sr_RichDouble$.prototype.longValue$extension__D__J = (function($$this) {
  var this$1 = $m_sjsr_RuntimeLong$();
  var lo = this$1.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I($$this);
  var hi = this$1.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
  return new $c_sjsr_RuntimeLong().init___I__I(lo, hi)
});
var $d_sr_RichDouble$ = new $TypeData().initClass({
  sr_RichDouble$: 0
}, false, "scala.runtime.RichDouble$", {
  sr_RichDouble$: 1,
  O: 1
});
$c_sr_RichDouble$.prototype.$classData = $d_sr_RichDouble$;
var $n_sr_RichDouble$ = (void 0);
function $m_sr_RichDouble$() {
  if ((!$n_sr_RichDouble$)) {
    $n_sr_RichDouble$ = new $c_sr_RichDouble$().init___()
  };
  return $n_sr_RichDouble$
}
/** @constructor */
function $c_sr_RichLong$() {
  $c_O.call(this)
}
$c_sr_RichLong$.prototype = new $h_O();
$c_sr_RichLong$.prototype.constructor = $c_sr_RichLong$;
/** @constructor */
function $h_sr_RichLong$() {
  /*<skip>*/
}
$h_sr_RichLong$.prototype = $c_sr_RichLong$.prototype;
$c_sr_RichLong$.prototype.intValue$extension__J__I = (function($$this) {
  return $$this.lo$2
});
$c_sr_RichLong$.prototype.init___ = (function() {
  return this
});
$c_sr_RichLong$.prototype.floatValue$extension__J__F = (function($$this) {
  return $fround($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D($$this.lo$2, $$this.hi$2))
});
$c_sr_RichLong$.prototype.equals$extension__J__O__Z = (function($$this, x$1) {
  if ($is_sr_RichLong(x$1)) {
    var t = $as_sr_RichLong(x$1).self$1;
    var lo = t.lo$2;
    var hi = t.hi$2;
    return (($$this.lo$2 === lo) && ($$this.hi$2 === hi))
  } else {
    return false
  }
});
$c_sr_RichLong$.prototype.isValidChar$extension__J__Z = (function($$this) {
  var value = (65535 & $$this.lo$2);
  var hi = (value >> 31);
  return ((value === $$this.lo$2) && (hi === $$this.hi$2))
});
$c_sr_RichLong$.prototype.byteValue$extension__J__B = (function($$this) {
  return (($$this.lo$2 << 24) >> 24)
});
$c_sr_RichLong$.prototype.isValidShort$extension__J__Z = (function($$this) {
  var value = (($$this.lo$2 << 16) >> 16);
  var hi = (value >> 31);
  return ((value === $$this.lo$2) && (hi === $$this.hi$2))
});
$c_sr_RichLong$.prototype.doubleValue$extension__J__D = (function($$this) {
  return $m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D($$this.lo$2, $$this.hi$2)
});
$c_sr_RichLong$.prototype.isValidInt$extension__J__Z = (function($$this) {
  var value = $$this.lo$2;
  var hi = (value >> 31);
  return ((value === $$this.lo$2) && (hi === $$this.hi$2))
});
$c_sr_RichLong$.prototype.shortValue$extension__J__S = (function($$this) {
  return (($$this.lo$2 << 16) >> 16)
});
$c_sr_RichLong$.prototype.isValidByte$extension__J__Z = (function($$this) {
  var value = (($$this.lo$2 << 24) >> 24);
  var hi = (value >> 31);
  return ((value === $$this.lo$2) && (hi === $$this.hi$2))
});
var $d_sr_RichLong$ = new $TypeData().initClass({
  sr_RichLong$: 0
}, false, "scala.runtime.RichLong$", {
  sr_RichLong$: 1,
  O: 1
});
$c_sr_RichLong$.prototype.$classData = $d_sr_RichLong$;
var $n_sr_RichLong$ = (void 0);
function $m_sr_RichLong$() {
  if ((!$n_sr_RichLong$)) {
    $n_sr_RichLong$ = new $c_sr_RichLong$().init___()
  };
  return $n_sr_RichLong$
}
/** @constructor */
function $c_sr_ScalaRunTime$() {
  $c_O.call(this)
}
$c_sr_ScalaRunTime$.prototype = new $h_O();
$c_sr_ScalaRunTime$.prototype.constructor = $c_sr_ScalaRunTime$;
/** @constructor */
function $h_sr_ScalaRunTime$() {
  /*<skip>*/
}
$h_sr_ScalaRunTime$.prototype = $c_sr_ScalaRunTime$.prototype;
$c_sr_ScalaRunTime$.prototype.init___ = (function() {
  return this
});
$c_sr_ScalaRunTime$.prototype.array$undlength__O__I = (function(xs) {
  if ($isArrayOf_O(xs, 1)) {
    var x2 = $asArrayOf_O(xs, 1);
    return x2.u.length
  } else if ($isArrayOf_I(xs, 1)) {
    var x3 = $asArrayOf_I(xs, 1);
    return x3.u.length
  } else if ($isArrayOf_D(xs, 1)) {
    var x4 = $asArrayOf_D(xs, 1);
    return x4.u.length
  } else if ($isArrayOf_J(xs, 1)) {
    var x5 = $asArrayOf_J(xs, 1);
    return x5.u.length
  } else if ($isArrayOf_F(xs, 1)) {
    var x6 = $asArrayOf_F(xs, 1);
    return x6.u.length
  } else if ($isArrayOf_C(xs, 1)) {
    var x7 = $asArrayOf_C(xs, 1);
    return x7.u.length
  } else if ($isArrayOf_B(xs, 1)) {
    var x8 = $asArrayOf_B(xs, 1);
    return x8.u.length
  } else if ($isArrayOf_S(xs, 1)) {
    var x9 = $asArrayOf_S(xs, 1);
    return x9.u.length
  } else if ($isArrayOf_Z(xs, 1)) {
    var x10 = $asArrayOf_Z(xs, 1);
    return x10.u.length
  } else if ($isArrayOf_sr_BoxedUnit(xs, 1)) {
    var x11 = $asArrayOf_sr_BoxedUnit(xs, 1);
    return x11.u.length
  } else if ((xs === null)) {
    throw new $c_jl_NullPointerException().init___()
  } else {
    throw new $c_s_MatchError().init___O(xs)
  }
});
$c_sr_ScalaRunTime$.prototype.array$undupdate__O__I__O__V = (function(xs, idx, value) {
  if ($isArrayOf_O(xs, 1)) {
    var x2 = $asArrayOf_O(xs, 1);
    x2.set(idx, value)
  } else if ($isArrayOf_I(xs, 1)) {
    var x3 = $asArrayOf_I(xs, 1);
    x3.set(idx, $uI(value))
  } else if ($isArrayOf_D(xs, 1)) {
    var x4 = $asArrayOf_D(xs, 1);
    x4.set(idx, $uD(value))
  } else if ($isArrayOf_J(xs, 1)) {
    var x5 = $asArrayOf_J(xs, 1);
    x5.set(idx, $uJ(value))
  } else if ($isArrayOf_F(xs, 1)) {
    var x6 = $asArrayOf_F(xs, 1);
    x6.set(idx, $uF(value))
  } else if ($isArrayOf_C(xs, 1)) {
    var x7 = $asArrayOf_C(xs, 1);
    if ((value === null)) {
      var jsx$1 = 0
    } else {
      var this$2 = $as_jl_Character(value);
      var jsx$1 = this$2.value$1
    };
    x7.set(idx, jsx$1)
  } else if ($isArrayOf_B(xs, 1)) {
    var x8 = $asArrayOf_B(xs, 1);
    x8.set(idx, $uB(value))
  } else if ($isArrayOf_S(xs, 1)) {
    var x9 = $asArrayOf_S(xs, 1);
    x9.set(idx, $uS(value))
  } else if ($isArrayOf_Z(xs, 1)) {
    var x10 = $asArrayOf_Z(xs, 1);
    x10.set(idx, $uZ(value))
  } else if ($isArrayOf_sr_BoxedUnit(xs, 1)) {
    var x11 = $asArrayOf_sr_BoxedUnit(xs, 1);
    x11.set(idx, (void 0))
  } else if ((xs === null)) {
    throw new $c_jl_NullPointerException().init___()
  } else {
    throw new $c_s_MatchError().init___O(xs)
  }
});
$c_sr_ScalaRunTime$.prototype.$$undtoString__s_Product__T = (function(x) {
  var this$1 = x.productIterator__sc_Iterator();
  var start = (x.productPrefix__T() + "(");
  return $f_sc_TraversableOnce__mkString__T__T__T__T(this$1, start, ",", ")")
});
$c_sr_ScalaRunTime$.prototype.array$undapply__O__I__O = (function(xs, idx) {
  if ($isArrayOf_O(xs, 1)) {
    var x2 = $asArrayOf_O(xs, 1);
    return x2.get(idx)
  } else if ($isArrayOf_I(xs, 1)) {
    var x3 = $asArrayOf_I(xs, 1);
    return x3.get(idx)
  } else if ($isArrayOf_D(xs, 1)) {
    var x4 = $asArrayOf_D(xs, 1);
    return x4.get(idx)
  } else if ($isArrayOf_J(xs, 1)) {
    var x5 = $asArrayOf_J(xs, 1);
    return x5.get(idx)
  } else if ($isArrayOf_F(xs, 1)) {
    var x6 = $asArrayOf_F(xs, 1);
    return x6.get(idx)
  } else if ($isArrayOf_C(xs, 1)) {
    var x7 = $asArrayOf_C(xs, 1);
    var c = x7.get(idx);
    return new $c_jl_Character().init___C(c)
  } else if ($isArrayOf_B(xs, 1)) {
    var x8 = $asArrayOf_B(xs, 1);
    return x8.get(idx)
  } else if ($isArrayOf_S(xs, 1)) {
    var x9 = $asArrayOf_S(xs, 1);
    return x9.get(idx)
  } else if ($isArrayOf_Z(xs, 1)) {
    var x10 = $asArrayOf_Z(xs, 1);
    return x10.get(idx)
  } else if ($isArrayOf_sr_BoxedUnit(xs, 1)) {
    var x11 = $asArrayOf_sr_BoxedUnit(xs, 1);
    return x11.get(idx)
  } else if ((xs === null)) {
    throw new $c_jl_NullPointerException().init___()
  } else {
    throw new $c_s_MatchError().init___O(xs)
  }
});
var $d_sr_ScalaRunTime$ = new $TypeData().initClass({
  sr_ScalaRunTime$: 0
}, false, "scala.runtime.ScalaRunTime$", {
  sr_ScalaRunTime$: 1,
  O: 1
});
$c_sr_ScalaRunTime$.prototype.$classData = $d_sr_ScalaRunTime$;
var $n_sr_ScalaRunTime$ = (void 0);
function $m_sr_ScalaRunTime$() {
  if ((!$n_sr_ScalaRunTime$)) {
    $n_sr_ScalaRunTime$ = new $c_sr_ScalaRunTime$().init___()
  };
  return $n_sr_ScalaRunTime$
}
/** @constructor */
function $c_sr_Statics$() {
  $c_O.call(this)
}
$c_sr_Statics$.prototype = new $h_O();
$c_sr_Statics$.prototype.constructor = $c_sr_Statics$;
/** @constructor */
function $h_sr_Statics$() {
  /*<skip>*/
}
$h_sr_Statics$.prototype = $c_sr_Statics$.prototype;
$c_sr_Statics$.prototype.init___ = (function() {
  return this
});
$c_sr_Statics$.prototype.mixLast__I__I__I = (function(hash, data) {
  var k = data;
  k = $imul((-862048943), k);
  var i = k;
  k = ((i << 15) | ((i >>> 17) | 0));
  k = $imul(461845907, k);
  return (hash ^ k)
});
$c_sr_Statics$.prototype.doubleHash__D__I = (function(dv) {
  var iv = $doubleToInt(dv);
  if ((iv === dv)) {
    return iv
  } else {
    var this$1 = $m_sjsr_RuntimeLong$();
    var lo = this$1.scala$scalajs$runtime$RuntimeLong$$fromDoubleImpl__D__I(dv);
    var hi = this$1.scala$scalajs$runtime$RuntimeLong$$hiReturn$f;
    return (($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo, hi) === dv) ? (lo ^ hi) : $m_sjsr_Bits$().numberHashCode__D__I(dv))
  }
});
$c_sr_Statics$.prototype.anyHash__O__I = (function(x) {
  if ((x === null)) {
    return 0
  } else if (((typeof x) === "number")) {
    var x3 = $uD(x);
    return this.doubleHash__D__I(x3)
  } else if ($is_sjsr_RuntimeLong(x)) {
    var t = $uJ(x);
    var lo = t.lo$2;
    var hi = t.hi$2;
    return this.longHash__J__I(new $c_sjsr_RuntimeLong().init___I__I(lo, hi))
  } else {
    return $objectHashCode(x)
  }
});
$c_sr_Statics$.prototype.avalanche__I__I = (function(h0) {
  var h = h0;
  h = (h ^ ((h >>> 16) | 0));
  h = $imul((-2048144789), h);
  h = (h ^ ((h >>> 13) | 0));
  h = $imul((-1028477387), h);
  h = (h ^ ((h >>> 16) | 0));
  return h
});
$c_sr_Statics$.prototype.mix__I__I__I = (function(hash, data) {
  var h = this.mixLast__I__I__I(hash, data);
  var i = h;
  h = ((i << 13) | ((i >>> 19) | 0));
  return (((-430675100) + $imul(5, h)) | 0)
});
$c_sr_Statics$.prototype.longHash__J__I = (function(lv) {
  var lo = lv.lo$2;
  var lo$1 = lv.hi$2;
  return ((lo$1 === (lo >> 31)) ? lo : (lo ^ lo$1))
});
$c_sr_Statics$.prototype.finalizeHash__I__I__I = (function(hash, length) {
  return this.avalanche__I__I((hash ^ length))
});
var $d_sr_Statics$ = new $TypeData().initClass({
  sr_Statics$: 0
}, false, "scala.runtime.Statics$", {
  sr_Statics$: 1,
  O: 1
});
$c_sr_Statics$.prototype.$classData = $d_sr_Statics$;
var $n_sr_Statics$ = (void 0);
function $m_sr_Statics$() {
  if ((!$n_sr_Statics$)) {
    $n_sr_Statics$ = new $c_sr_Statics$().init___()
  };
  return $n_sr_Statics$
}
/** @constructor */
function $c_Lio_youi_AnimationFrame$() {
  $c_O.call(this);
  this.lastUpdate$1 = 0.0;
  this.timeStamp$1 = null;
  this.updateFunction$1 = null;
  this.delta$1 = null;
  this.bitmap$0$1 = false
}
$c_Lio_youi_AnimationFrame$.prototype = new $h_O();
$c_Lio_youi_AnimationFrame$.prototype.constructor = $c_Lio_youi_AnimationFrame$;
/** @constructor */
function $h_Lio_youi_AnimationFrame$() {
  /*<skip>*/
}
$h_Lio_youi_AnimationFrame$.prototype = $c_Lio_youi_AnimationFrame$.prototype;
$c_Lio_youi_AnimationFrame$.prototype.init___ = (function() {
  $n_Lio_youi_AnimationFrame$ = this;
  this.lastUpdate$1 = 0.0;
  this.timeStamp$1 = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 0.0
    })
  })(this)), false, true, true);
  this.updateFunction$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2) {
    return (function(highResTimeStamp$2) {
      var highResTimeStamp = $uD(highResTimeStamp$2);
      var delta = ((this$2.lastUpdate$1 === 0.0) ? 0.0 : ((highResTimeStamp - this$2.lastUpdate$1) / 1000.0));
      try {
        var this$1 = $as_Lreactify_Var(this$2.timeStamp$1);
        var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, highResTimeStamp$1) {
          return (function() {
            return highResTimeStamp$1
          })
        })(this$2, highResTimeStamp));
        this$1.replace__F0__Z__V(value, true);
        $f_Lio_youi_Updates__update__D__V(this$2, delta)
      } finally {
        this$2.lastUpdate$1 = highResTimeStamp;
        $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().requestAnimationFrame((function(f) {
          return (function(arg1) {
            return f.apply__O__O(arg1)
          })
        })(this$2.updateFunction$1))
      }
    })
  })(this));
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().requestAnimationFrame((function(f$1) {
    return (function(arg1$1) {
      return f$1.apply__O__O(arg1$1)
    })
  })(this.updateFunction$1));
  return this
});
$c_Lio_youi_AnimationFrame$.prototype.delta__Lreactify_Channel = (function() {
  return ((!this.bitmap$0$1) ? this.delta$lzycompute__p1__Lreactify_Channel() : this.delta$1)
});
$c_Lio_youi_AnimationFrame$.prototype.delta$lzycompute__p1__Lreactify_Channel = (function() {
  if ((!this.bitmap$0$1)) {
    this.delta$1 = new $c_Lreactify_Channel$$anon$1().init___();
    this.bitmap$0$1 = true
  };
  return this.delta$1
});
var $d_Lio_youi_AnimationFrame$ = new $TypeData().initClass({
  Lio_youi_AnimationFrame$: 0
}, false, "io.youi.AnimationFrame$", {
  Lio_youi_AnimationFrame$: 1,
  O: 1,
  Lio_youi_Updates: 1
});
$c_Lio_youi_AnimationFrame$.prototype.$classData = $d_Lio_youi_AnimationFrame$;
var $n_Lio_youi_AnimationFrame$ = (void 0);
function $m_Lio_youi_AnimationFrame$() {
  if ((!$n_Lio_youi_AnimationFrame$)) {
    $n_Lio_youi_AnimationFrame$ = new $c_Lio_youi_AnimationFrame$().init___()
  };
  return $n_Lio_youi_AnimationFrame$
}
/** @constructor */
function $c_Lio_youi_MapStore() {
  $c_O.call(this);
  this.map$1 = null
}
$c_Lio_youi_MapStore.prototype = new $h_O();
$c_Lio_youi_MapStore.prototype.constructor = $c_Lio_youi_MapStore;
/** @constructor */
function $h_Lio_youi_MapStore() {
  /*<skip>*/
}
$h_Lio_youi_MapStore.prototype = $c_Lio_youi_MapStore.prototype;
$c_Lio_youi_MapStore.prototype.init___sci_Map = (function(map) {
  this.map$1 = map;
  return this
});
$c_Lio_youi_MapStore.prototype.update__T__O__V = (function(key, value) {
  this.map$1 = this.map$1.$$plus__T2__sci_Map(new $c_T2().init___O__O(key, value))
});
var $d_Lio_youi_MapStore = new $TypeData().initClass({
  Lio_youi_MapStore: 0
}, false, "io.youi.MapStore", {
  Lio_youi_MapStore: 1,
  O: 1,
  Lio_youi_Store: 1
});
$c_Lio_youi_MapStore.prototype.$classData = $d_Lio_youi_MapStore;
/** @constructor */
function $c_Lio_youi_activate_AddClassInstruction() {
  $c_O.call(this);
  this.selector$1 = null;
  this.className$1 = null;
  this.activated$1 = null
}
$c_Lio_youi_activate_AddClassInstruction.prototype = new $h_O();
$c_Lio_youi_activate_AddClassInstruction.prototype.constructor = $c_Lio_youi_activate_AddClassInstruction;
/** @constructor */
function $h_Lio_youi_activate_AddClassInstruction() {
  /*<skip>*/
}
$h_Lio_youi_activate_AddClassInstruction.prototype = $c_Lio_youi_activate_AddClassInstruction.prototype;
$c_Lio_youi_activate_AddClassInstruction.prototype.init___T__T = (function(selector, className) {
  this.selector$1 = selector;
  this.className$1 = className;
  var this$1 = $m_s_package$().Vector$1;
  this.activated$1 = this$1.NIL$6;
  return this
});
$c_Lio_youi_activate_AddClassInstruction.prototype.deactivate__V = (function() {
  var this$1 = this.activated$1;
  var this$2 = this$1.iterator__sci_VectorIterator();
  while (this$2.$$undhasNext$2) {
    var arg1 = this$2.next__O();
    arg1.classList.remove(this.className$1)
  };
  var this$3 = $m_s_package$().Vector$1;
  this.activated$1 = this$3.NIL$6
});
$c_Lio_youi_activate_AddClassInstruction.prototype.activate__V = (function() {
  if ($m_Lio_youi_activate_ActivationSupport$().debug$1) {
    var x = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["AddClass(selector: ", ", className: ", ")"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.selector$1, this.className$1]));
    var this$2 = $m_s_Console$();
    var this$3 = $as_Ljava_io_PrintStream(this$2.outVar$2.v$1);
    this$3.java$lang$JSConsoleBasedPrintStream$$printString__T__V((x + "\n"))
  };
  var this$4 = $m_Lio_youi_dom$().bySelector__T__sci_Vector(this.selector$1);
  $m_sci_Vector$();
  var b = new $c_sci_VectorBuilder().init___();
  var this$6 = this$4.iterator__sci_VectorIterator();
  while (this$6.$$undhasNext$2) {
    var arg1 = this$6.next__O();
    if (((!$uZ(arg1.classList.contains(this.className$1))) !== false)) {
      b.$$plus$eq__O__sci_VectorBuilder(arg1)
    }
  };
  this.activated$1 = b.result__sci_Vector();
  var this$7 = this.activated$1;
  var this$8 = this$7.iterator__sci_VectorIterator();
  while (this$8.$$undhasNext$2) {
    var arg1$1 = this$8.next__O();
    arg1$1.classList.add(this.className$1)
  }
});
var $d_Lio_youi_activate_AddClassInstruction = new $TypeData().initClass({
  Lio_youi_activate_AddClassInstruction: 0
}, false, "io.youi.activate.AddClassInstruction", {
  Lio_youi_activate_AddClassInstruction: 1,
  O: 1,
  Lio_youi_activate_ActivateInstruction: 1
});
$c_Lio_youi_activate_AddClassInstruction.prototype.$classData = $d_Lio_youi_activate_AddClassInstruction;
/** @constructor */
function $c_Lio_youi_activate_AlertInstruction() {
  $c_O.call(this);
  this.message$1 = null
}
$c_Lio_youi_activate_AlertInstruction.prototype = new $h_O();
$c_Lio_youi_activate_AlertInstruction.prototype.constructor = $c_Lio_youi_activate_AlertInstruction;
/** @constructor */
function $h_Lio_youi_activate_AlertInstruction() {
  /*<skip>*/
}
$h_Lio_youi_activate_AlertInstruction.prototype = $c_Lio_youi_activate_AlertInstruction.prototype;
$c_Lio_youi_activate_AlertInstruction.prototype.deactivate__V = (function() {
  /*<skip>*/
});
$c_Lio_youi_activate_AlertInstruction.prototype.init___T = (function(message) {
  this.message$1 = message;
  return this
});
$c_Lio_youi_activate_AlertInstruction.prototype.activate__V = (function() {
  if ($m_Lio_youi_activate_ActivationSupport$().debug$1) {
    var x = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Alert(message: ", ")"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.message$1]));
    var this$2 = $m_s_Console$();
    var this$3 = $as_Ljava_io_PrintStream(this$2.outVar$2.v$1);
    this$3.java$lang$JSConsoleBasedPrintStream$$printString__T__V((x + "\n"))
  };
  $m_Lorg_scalajs_dom_package$().window__Lorg_scalajs_dom_raw_Window().alert(this.message$1)
});
var $d_Lio_youi_activate_AlertInstruction = new $TypeData().initClass({
  Lio_youi_activate_AlertInstruction: 0
}, false, "io.youi.activate.AlertInstruction", {
  Lio_youi_activate_AlertInstruction: 1,
  O: 1,
  Lio_youi_activate_ActivateInstruction: 1
});
$c_Lio_youi_activate_AlertInstruction.prototype.$classData = $d_Lio_youi_activate_AlertInstruction;
/** @constructor */
function $c_Lio_youi_activate_Call() {
  $c_O.call(this);
  this.code$1 = null
}
$c_Lio_youi_activate_Call.prototype = new $h_O();
$c_Lio_youi_activate_Call.prototype.constructor = $c_Lio_youi_activate_Call;
/** @constructor */
function $h_Lio_youi_activate_Call() {
  /*<skip>*/
}
$h_Lio_youi_activate_Call.prototype = $c_Lio_youi_activate_Call.prototype;
$c_Lio_youi_activate_Call.prototype.deactivate__V = (function() {
  /*<skip>*/
});
$c_Lio_youi_activate_Call.prototype.init___T = (function(code) {
  this.code$1 = code;
  return this
});
$c_Lio_youi_activate_Call.prototype.activate__V = (function() {
  var x = this.code$1;
  $g["eval"](x)
});
var $d_Lio_youi_activate_Call = new $TypeData().initClass({
  Lio_youi_activate_Call: 0
}, false, "io.youi.activate.Call", {
  Lio_youi_activate_Call: 1,
  O: 1,
  Lio_youi_activate_ActivateInstruction: 1
});
$c_Lio_youi_activate_Call.prototype.$classData = $d_Lio_youi_activate_Call;
/** @constructor */
function $c_Lio_youi_activate_ConditionalInstruction() {
  $c_O.call(this);
  this.trueInstruction$1 = null;
  this.falseInstruction$1 = null
}
$c_Lio_youi_activate_ConditionalInstruction.prototype = new $h_O();
$c_Lio_youi_activate_ConditionalInstruction.prototype.constructor = $c_Lio_youi_activate_ConditionalInstruction;
/** @constructor */
function $h_Lio_youi_activate_ConditionalInstruction() {
  /*<skip>*/
}
$h_Lio_youi_activate_ConditionalInstruction.prototype = $c_Lio_youi_activate_ConditionalInstruction.prototype;
$c_Lio_youi_activate_ConditionalInstruction.prototype.deactivate__V = (function() {
  if (this.condition__Z()) {
    var this$1 = this.trueInstruction$1;
    if ((!this$1.isEmpty__Z())) {
      var arg1 = this$1.get__O();
      var x$3 = $as_Lio_youi_activate_ActivateInstruction(arg1);
      x$3.deactivate__V()
    }
  } else {
    var this$2 = this.falseInstruction$1;
    if ((!this$2.isEmpty__Z())) {
      var arg1$1 = this$2.get__O();
      var x$4 = $as_Lio_youi_activate_ActivateInstruction(arg1$1);
      x$4.deactivate__V()
    }
  }
});
$c_Lio_youi_activate_ConditionalInstruction.prototype.init___s_Option__s_Option = (function(trueInstruction, falseInstruction) {
  this.trueInstruction$1 = trueInstruction;
  this.falseInstruction$1 = falseInstruction;
  return this
});
$c_Lio_youi_activate_ConditionalInstruction.prototype.activate__V = (function() {
  if (this.condition__Z()) {
    var this$1 = this.trueInstruction$1;
    if ((!this$1.isEmpty__Z())) {
      var arg1 = this$1.get__O();
      var x$1 = $as_Lio_youi_activate_ActivateInstruction(arg1);
      x$1.activate__V()
    }
  } else {
    var this$2 = this.falseInstruction$1;
    if ((!this$2.isEmpty__Z())) {
      var arg1$1 = this$2.get__O();
      var x$2 = $as_Lio_youi_activate_ActivateInstruction(arg1$1);
      x$2.activate__V()
    }
  }
});
/** @constructor */
function $c_Lio_youi_activate_Link() {
  $c_O.call(this);
  this.path$1 = null
}
$c_Lio_youi_activate_Link.prototype = new $h_O();
$c_Lio_youi_activate_Link.prototype.constructor = $c_Lio_youi_activate_Link;
/** @constructor */
function $h_Lio_youi_activate_Link() {
  /*<skip>*/
}
$h_Lio_youi_activate_Link.prototype = $c_Lio_youi_activate_Link.prototype;
$c_Lio_youi_activate_Link.prototype.deactivate__V = (function() {
  /*<skip>*/
});
$c_Lio_youi_activate_Link.prototype.init___T = (function(path) {
  this.path$1 = path;
  return this
});
$c_Lio_youi_activate_Link.prototype.activate__V = (function() {
  $m_Lio_youi_History$().pushPath__T__sjs_js_Any__V(this.path$1, ($m_Lio_youi_History$(), null))
});
var $d_Lio_youi_activate_Link = new $TypeData().initClass({
  Lio_youi_activate_Link: 0
}, false, "io.youi.activate.Link", {
  Lio_youi_activate_Link: 1,
  O: 1,
  Lio_youi_activate_ActivateInstruction: 1
});
$c_Lio_youi_activate_Link.prototype.$classData = $d_Lio_youi_activate_Link;
/** @constructor */
function $c_Lio_youi_activate_OnClick() {
  $c_O.call(this);
  this.selector$1 = null;
  this.instruction$1 = null;
  this.listener$1 = null
}
$c_Lio_youi_activate_OnClick.prototype = new $h_O();
$c_Lio_youi_activate_OnClick.prototype.constructor = $c_Lio_youi_activate_OnClick;
/** @constructor */
function $h_Lio_youi_activate_OnClick() {
  /*<skip>*/
}
$h_Lio_youi_activate_OnClick.prototype = $c_Lio_youi_activate_OnClick.prototype;
$c_Lio_youi_activate_OnClick.prototype.deactivate__V = (function() {
  var qual$2 = $m_Lio_youi_dom$().bySelector__T__sci_Vector(this.selector$1).head__O();
  var x$18 = (function(f) {
    return (function(arg1) {
      return f.apply__O__O(arg1)
    })
  })(this.listener$1);
  qual$2.removeEventListener("click", x$18)
});
$c_Lio_youi_activate_OnClick.prototype.activate__V = (function() {
  var qual$1 = $m_Lio_youi_dom$().bySelector__T__sci_Vector(this.selector$1).head__O();
  var x$15 = (function(f) {
    return (function(arg1) {
      return f.apply__O__O(arg1)
    })
  })(this.listener$1);
  qual$1.addEventListener("click", x$15)
});
$c_Lio_youi_activate_OnClick.prototype.init___T__Lio_youi_activate_ActivateInstruction = (function(selector, instruction) {
  this.selector$1 = selector;
  this.instruction$1 = instruction;
  this.listener$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(evt$2) {
      evt$2.preventDefault();
      evt$2.stopPropagation();
      $this.instruction$1.activate__V()
    })
  })(this));
  return this
});
var $d_Lio_youi_activate_OnClick = new $TypeData().initClass({
  Lio_youi_activate_OnClick: 0
}, false, "io.youi.activate.OnClick", {
  Lio_youi_activate_OnClick: 1,
  O: 1,
  Lio_youi_activate_ActivateInstruction: 1
});
$c_Lio_youi_activate_OnClick.prototype.$classData = $d_Lio_youi_activate_OnClick;
/** @constructor */
function $c_Lio_youi_activate_RemoveClassInstruction() {
  $c_O.call(this);
  this.selector$1 = null;
  this.className$1 = null;
  this.activated$1 = null
}
$c_Lio_youi_activate_RemoveClassInstruction.prototype = new $h_O();
$c_Lio_youi_activate_RemoveClassInstruction.prototype.constructor = $c_Lio_youi_activate_RemoveClassInstruction;
/** @constructor */
function $h_Lio_youi_activate_RemoveClassInstruction() {
  /*<skip>*/
}
$h_Lio_youi_activate_RemoveClassInstruction.prototype = $c_Lio_youi_activate_RemoveClassInstruction.prototype;
$c_Lio_youi_activate_RemoveClassInstruction.prototype.init___T__T = (function(selector, className) {
  this.selector$1 = selector;
  this.className$1 = className;
  var this$1 = $m_s_package$().Vector$1;
  this.activated$1 = this$1.NIL$6;
  return this
});
$c_Lio_youi_activate_RemoveClassInstruction.prototype.deactivate__V = (function() {
  var this$1 = this.activated$1;
  var this$2 = this$1.iterator__sci_VectorIterator();
  while (this$2.$$undhasNext$2) {
    var arg1 = this$2.next__O();
    arg1.classList.add(this.className$1)
  };
  var this$3 = $m_s_package$().Vector$1;
  this.activated$1 = this$3.NIL$6
});
$c_Lio_youi_activate_RemoveClassInstruction.prototype.activate__V = (function() {
  if ($m_Lio_youi_activate_ActivationSupport$().debug$1) {
    var x = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["RemoveClass(selector: ", ", className: ", ")"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.selector$1, this.className$1]));
    var this$2 = $m_s_Console$();
    var this$3 = $as_Ljava_io_PrintStream(this$2.outVar$2.v$1);
    this$3.java$lang$JSConsoleBasedPrintStream$$printString__T__V((x + "\n"))
  };
  var this$4 = $m_Lio_youi_dom$().bySelector__T__sci_Vector(this.selector$1);
  $m_sci_Vector$();
  var b = new $c_sci_VectorBuilder().init___();
  var this$6 = this$4.iterator__sci_VectorIterator();
  while (this$6.$$undhasNext$2) {
    var arg1 = this$6.next__O();
    if (($uZ(arg1.classList.contains(this.className$1)) !== false)) {
      b.$$plus$eq__O__sci_VectorBuilder(arg1)
    }
  };
  this.activated$1 = b.result__sci_Vector();
  var this$7 = this.activated$1;
  var this$8 = this$7.iterator__sci_VectorIterator();
  while (this$8.$$undhasNext$2) {
    var arg1$1 = this$8.next__O();
    arg1$1.classList.remove(this.className$1)
  }
});
var $d_Lio_youi_activate_RemoveClassInstruction = new $TypeData().initClass({
  Lio_youi_activate_RemoveClassInstruction: 0
}, false, "io.youi.activate.RemoveClassInstruction", {
  Lio_youi_activate_RemoveClassInstruction: 1,
  O: 1,
  Lio_youi_activate_ActivateInstruction: 1
});
$c_Lio_youi_activate_RemoveClassInstruction.prototype.$classData = $d_Lio_youi_activate_RemoveClassInstruction;
/** @constructor */
function $c_Lio_youi_activate_ReplaceAttributeInstruction() {
  $c_O.call(this);
  this.selector$1 = null;
  this.attributeName$1 = null;
  this.content$1 = null;
  this.activated$1 = null
}
$c_Lio_youi_activate_ReplaceAttributeInstruction.prototype = new $h_O();
$c_Lio_youi_activate_ReplaceAttributeInstruction.prototype.constructor = $c_Lio_youi_activate_ReplaceAttributeInstruction;
/** @constructor */
function $h_Lio_youi_activate_ReplaceAttributeInstruction() {
  /*<skip>*/
}
$h_Lio_youi_activate_ReplaceAttributeInstruction.prototype = $c_Lio_youi_activate_ReplaceAttributeInstruction.prototype;
$c_Lio_youi_activate_ReplaceAttributeInstruction.prototype.deactivate__V = (function() {
  var this$1 = this.activated$1;
  var this$2 = this$1.iterator__sci_VectorIterator();
  while (this$2.$$undhasNext$2) {
    var arg1 = this$2.next__O();
    var e = $as_T2(arg1);
    e.$$und1__O().setAttribute(this.attributeName$1, $as_T(e.$$und2__O()))
  };
  var this$3 = $m_s_package$().Vector$1;
  this.activated$1 = this$3.NIL$6
});
$c_Lio_youi_activate_ReplaceAttributeInstruction.prototype.init___T__T__T = (function(selector, attributeName, content) {
  this.selector$1 = selector;
  this.attributeName$1 = attributeName;
  this.content$1 = content;
  var this$1 = $m_s_package$().Vector$1;
  this.activated$1 = this$1.NIL$6;
  return this
});
$c_Lio_youi_activate_ReplaceAttributeInstruction.prototype.activate__V = (function() {
  if ($m_Lio_youi_activate_ActivationSupport$().debug$1) {
    var x = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["ReplaceAttribute(selector: ", ", attributeName: ", ", content: ", ")"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.selector$1, this.attributeName$1, this.content$1]));
    var this$2 = $m_s_Console$();
    var this$3 = $as_Ljava_io_PrintStream(this$2.outVar$2.v$1);
    this$3.java$lang$JSConsoleBasedPrintStream$$printString__T__V((x + "\n"))
  };
  var this$5 = $m_Lio_youi_dom$().bySelector__T__sci_Vector(this.selector$1);
  $m_sci_Vector$();
  var bf = $m_sc_IndexedSeq$().ReusableCBF$6;
  var b = $f_sc_TraversableLike__builder$1__psc_TraversableLike__scg_CanBuildFrom__scm_Builder(this$5, bf);
  var this$6 = this$5.iterator__sci_VectorIterator();
  while (this$6.$$undhasNext$2) {
    var arg1 = this$6.next__O();
    var y = $as_T(arg1.getAttribute(this.attributeName$1));
    b.$$plus$eq__O__scm_Builder(new $c_T2().init___O__O(arg1, y))
  };
  this.activated$1 = $as_sci_Vector(b.result__O());
  var this$9 = this.activated$1;
  var this$10 = this$9.iterator__sci_VectorIterator();
  while (this$10.$$undhasNext$2) {
    var arg1$1 = this$10.next__O();
    var x$13 = $as_T2(arg1$1);
    x$13.$$und1__O().setAttribute(this.attributeName$1, this.content$1)
  }
});
var $d_Lio_youi_activate_ReplaceAttributeInstruction = new $TypeData().initClass({
  Lio_youi_activate_ReplaceAttributeInstruction: 0
}, false, "io.youi.activate.ReplaceAttributeInstruction", {
  Lio_youi_activate_ReplaceAttributeInstruction: 1,
  O: 1,
  Lio_youi_activate_ActivateInstruction: 1
});
$c_Lio_youi_activate_ReplaceAttributeInstruction.prototype.$classData = $d_Lio_youi_activate_ReplaceAttributeInstruction;
/** @constructor */
function $c_Lio_youi_activate_ReplaceContentInstruction() {
  $c_O.call(this);
  this.selector$1 = null;
  this.content$1 = null;
  this.activated$1 = null
}
$c_Lio_youi_activate_ReplaceContentInstruction.prototype = new $h_O();
$c_Lio_youi_activate_ReplaceContentInstruction.prototype.constructor = $c_Lio_youi_activate_ReplaceContentInstruction;
/** @constructor */
function $h_Lio_youi_activate_ReplaceContentInstruction() {
  /*<skip>*/
}
$h_Lio_youi_activate_ReplaceContentInstruction.prototype = $c_Lio_youi_activate_ReplaceContentInstruction.prototype;
$c_Lio_youi_activate_ReplaceContentInstruction.prototype.init___T__T = (function(selector, content) {
  this.selector$1 = selector;
  this.content$1 = content;
  var this$1 = $m_s_package$().Vector$1;
  this.activated$1 = this$1.NIL$6;
  return this
});
$c_Lio_youi_activate_ReplaceContentInstruction.prototype.deactivate__V = (function() {
  var this$1 = this.activated$1;
  var this$2 = this$1.iterator__sci_VectorIterator();
  while (this$2.$$undhasNext$2) {
    var arg1 = this$2.next__O();
    var e = $as_T2(arg1);
    e.$$und1__O().innerHTML = $as_T(e.$$und2__O())
  };
  var this$3 = $m_s_package$().Vector$1;
  this.activated$1 = this$3.NIL$6
});
$c_Lio_youi_activate_ReplaceContentInstruction.prototype.activate__V = (function() {
  if ($m_Lio_youi_activate_ActivationSupport$().debug$1) {
    var x = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["ReplaceContent(selector: ", ", content: ", ")"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.selector$1, this.content$1]));
    var this$2 = $m_s_Console$();
    var this$3 = $as_Ljava_io_PrintStream(this$2.outVar$2.v$1);
    this$3.java$lang$JSConsoleBasedPrintStream$$printString__T__V((x + "\n"))
  };
  var this$5 = $m_Lio_youi_dom$().bySelector__T__sci_Vector(this.selector$1);
  $m_sci_Vector$();
  var bf = $m_sc_IndexedSeq$().ReusableCBF$6;
  var b = $f_sc_TraversableLike__builder$1__psc_TraversableLike__scg_CanBuildFrom__scm_Builder(this$5, bf);
  var this$6 = this$5.iterator__sci_VectorIterator();
  while (this$6.$$undhasNext$2) {
    var arg1 = this$6.next__O();
    var y = $as_T(arg1.innerHTML);
    b.$$plus$eq__O__scm_Builder(new $c_T2().init___O__O(arg1, y))
  };
  this.activated$1 = $as_sci_Vector(b.result__O());
  var this$9 = this.activated$1;
  var this$10 = this$9.iterator__sci_VectorIterator();
  while (this$10.$$undhasNext$2) {
    var arg1$1 = this$10.next__O();
    var x$12 = $as_T2(arg1$1);
    x$12.$$und1__O().innerHTML = this.content$1
  }
});
var $d_Lio_youi_activate_ReplaceContentInstruction = new $TypeData().initClass({
  Lio_youi_activate_ReplaceContentInstruction: 0
}, false, "io.youi.activate.ReplaceContentInstruction", {
  Lio_youi_activate_ReplaceContentInstruction: 1,
  O: 1,
  Lio_youi_activate_ActivateInstruction: 1
});
$c_Lio_youi_activate_ReplaceContentInstruction.prototype.$classData = $d_Lio_youi_activate_ReplaceContentInstruction;
/** @constructor */
function $c_Lio_youi_activate_SetTitleInstruction() {
  $c_O.call(this);
  this.title$1 = null;
  this.previousTitle$1 = null
}
$c_Lio_youi_activate_SetTitleInstruction.prototype = new $h_O();
$c_Lio_youi_activate_SetTitleInstruction.prototype.constructor = $c_Lio_youi_activate_SetTitleInstruction;
/** @constructor */
function $h_Lio_youi_activate_SetTitleInstruction() {
  /*<skip>*/
}
$h_Lio_youi_activate_SetTitleInstruction.prototype = $c_Lio_youi_activate_SetTitleInstruction.prototype;
$c_Lio_youi_activate_SetTitleInstruction.prototype.deactivate__V = (function() {
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().title = this.previousTitle$1
});
$c_Lio_youi_activate_SetTitleInstruction.prototype.init___T = (function(title) {
  this.title$1 = title;
  this.previousTitle$1 = $as_T($m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().title);
  return this
});
$c_Lio_youi_activate_SetTitleInstruction.prototype.activate__V = (function() {
  if ($m_Lio_youi_activate_ActivationSupport$().debug$1) {
    var x = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["SetTitle(title: ", ")"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this.title$1]));
    var this$2 = $m_s_Console$();
    var this$3 = $as_Ljava_io_PrintStream(this$2.outVar$2.v$1);
    this$3.java$lang$JSConsoleBasedPrintStream$$printString__T__V((x + "\n"))
  };
  this.previousTitle$1 = $as_T($m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().title);
  $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().title = this.title$1
});
var $d_Lio_youi_activate_SetTitleInstruction = new $TypeData().initClass({
  Lio_youi_activate_SetTitleInstruction: 0
}, false, "io.youi.activate.SetTitleInstruction", {
  Lio_youi_activate_SetTitleInstruction: 1,
  O: 1,
  Lio_youi_activate_ActivateInstruction: 1
});
$c_Lio_youi_activate_SetTitleInstruction.prototype.$classData = $d_Lio_youi_activate_SetTitleInstruction;
/** @constructor */
function $c_Lio_youi_app_ClientConnectivity$$anon$1() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_app_ClientConnectivity$$anon$1.prototype = new $h_O();
$c_Lio_youi_app_ClientConnectivity$$anon$1.prototype.constructor = $c_Lio_youi_app_ClientConnectivity$$anon$1;
/** @constructor */
function $h_Lio_youi_app_ClientConnectivity$$anon$1() {
  /*<skip>*/
}
$h_Lio_youi_app_ClientConnectivity$$anon$1.prototype = $c_Lio_youi_app_ClientConnectivity$$anon$1.prototype;
$c_Lio_youi_app_ClientConnectivity$$anon$1.prototype.change__O__O__V = (function(oldValue, newValue) {
  this.change__Z__Z__V($uZ(oldValue), $uZ(newValue))
});
$c_Lio_youi_app_ClientConnectivity$$anon$1.prototype.change__Z__Z__V = (function(oldValue, newValue) {
  if ((oldValue && (!newValue))) {
    this.$$outer$1.io$youi$app$ClientConnectivity$$attemptReload__I__V(0)
  }
});
$c_Lio_youi_app_ClientConnectivity$$anon$1.prototype.init___Lio_youi_app_ClientConnectivity = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_app_ClientConnectivity$$anon$1 = new $TypeData().initClass({
  Lio_youi_app_ClientConnectivity$$anon$1: 0
}, false, "io.youi.app.ClientConnectivity$$anon$1", {
  Lio_youi_app_ClientConnectivity$$anon$1: 1,
  O: 1,
  Lreactify_ChangeListener: 1
});
$c_Lio_youi_app_ClientConnectivity$$anon$1.prototype.$classData = $d_Lio_youi_app_ClientConnectivity$$anon$1;
function $f_Lio_youi_app_YouIApplication__$$init$__V($thiz) {
  $m_Lio_youi_Cache$().implementation$1 = $thiz;
  $m_Lio_youi_app_YouIApplication$().io$youi$app$YouIApplication$$instance$1 = new $c_s_Some().init___O($thiz);
  $thiz.io$youi$app$YouIApplication$$undsetter$und$connectivityEntries$und$eq__Lreactify_State__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_sci_Set$EmptySet$()
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$app$YouIApplication$$undsetter$und$connectivity$und$eq__Lio_youi_app_ApplicationConnectivity__V(new $c_Lio_youi_app_ApplicationConnectivity().init___Lio_youi_app_YouIApplication__T__Z($thiz, "/communication", true))
}
function $is_Lio_youi_app_YouIApplication(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_app_YouIApplication)))
}
function $as_Lio_youi_app_YouIApplication(obj) {
  return (($is_Lio_youi_app_YouIApplication(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.app.YouIApplication"))
}
function $isArrayOf_Lio_youi_app_YouIApplication(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_app_YouIApplication)))
}
function $asArrayOf_Lio_youi_app_YouIApplication(obj, depth) {
  return (($isArrayOf_Lio_youi_app_YouIApplication(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.app.YouIApplication;", depth))
}
/** @constructor */
function $c_Lio_youi_app_screen_EmptyScreen$() {
  $c_O.call(this);
  this.currentState$1 = null;
  this.state$1 = null
}
$c_Lio_youi_app_screen_EmptyScreen$.prototype = new $h_O();
$c_Lio_youi_app_screen_EmptyScreen$.prototype.constructor = $c_Lio_youi_app_screen_EmptyScreen$;
/** @constructor */
function $h_Lio_youi_app_screen_EmptyScreen$() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_EmptyScreen$.prototype = $c_Lio_youi_app_screen_EmptyScreen$.prototype;
$c_Lio_youi_app_screen_EmptyScreen$.prototype.init___ = (function() {
  $n_Lio_youi_app_screen_EmptyScreen$ = this;
  $f_Lio_youi_app_screen_Screen__$$init$__V(this);
  return this
});
$c_Lio_youi_app_screen_EmptyScreen$.prototype.activate__s_concurrent_Future = (function() {
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
});
$c_Lio_youi_app_screen_EmptyScreen$.prototype.io$youi$app$screen$Screen$$undsetter$und$currentState$und$eq__Lreactify_Var__V = (function(x$1) {
  this.currentState$1 = x$1
});
$c_Lio_youi_app_screen_EmptyScreen$.prototype.deactivate__s_concurrent_Future = (function() {
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
});
$c_Lio_youi_app_screen_EmptyScreen$.prototype.io$youi$app$screen$Screen$$undsetter$und$state$und$eq__Lreactify_Val__V = (function(x$1) {
  this.state$1 = x$1
});
$c_Lio_youi_app_screen_EmptyScreen$.prototype.init__s_concurrent_Future = (function() {
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
});
$c_Lio_youi_app_screen_EmptyScreen$.prototype.load__s_concurrent_Future = (function() {
  return $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0))
});
$c_Lio_youi_app_screen_EmptyScreen$.prototype.state__Lreactify_Val = (function() {
  return this.state$1
});
$c_Lio_youi_app_screen_EmptyScreen$.prototype.currentState__Lreactify_Var = (function() {
  return this.currentState$1
});
var $d_Lio_youi_app_screen_EmptyScreen$ = new $TypeData().initClass({
  Lio_youi_app_screen_EmptyScreen$: 0
}, false, "io.youi.app.screen.EmptyScreen$", {
  Lio_youi_app_screen_EmptyScreen$: 1,
  O: 1,
  Lio_youi_app_screen_Screen: 1
});
$c_Lio_youi_app_screen_EmptyScreen$.prototype.$classData = $d_Lio_youi_app_screen_EmptyScreen$;
var $n_Lio_youi_app_screen_EmptyScreen$ = (void 0);
function $m_Lio_youi_app_screen_EmptyScreen$() {
  if ((!$n_Lio_youi_app_screen_EmptyScreen$)) {
    $n_Lio_youi_app_screen_EmptyScreen$ = new $c_Lio_youi_app_screen_EmptyScreen$().init___()
  };
  return $n_Lio_youi_app_screen_EmptyScreen$
}
function $f_Lio_youi_app_screen_PathActivation__updateURL__Lio_youi_net_URL__s_Option($thiz, current) {
  return ((current.path$1.decoded__T() !== $thiz.path__T()) ? (current.withPath__T__Z__Lio_youi_net_URL($thiz.path__T(), true), new $c_s_Some().init___O(new $c_Lio_youi_HistoryStateChange().init___Lio_youi_net_URL__Lio_youi_StateType__sjs_js_Any(current.withPath__T__Z__Lio_youi_net_URL($thiz.path__T(), true), $m_Lio_youi_StateType$Push$(), null))) : $m_s_None$())
}
function $f_Lio_youi_app_screen_PathActivation__isURLMatch__Lio_youi_net_URL__Z($thiz, url) {
  return (url.path$1.decoded__T() === $thiz.path__T())
}
/** @constructor */
function $c_Lio_youi_app_screen_ScreenManager$$anon$1() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_app_screen_ScreenManager$$anon$1.prototype = new $h_O();
$c_Lio_youi_app_screen_ScreenManager$$anon$1.prototype.constructor = $c_Lio_youi_app_screen_ScreenManager$$anon$1;
/** @constructor */
function $h_Lio_youi_app_screen_ScreenManager$$anon$1() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_ScreenManager$$anon$1.prototype = $c_Lio_youi_app_screen_ScreenManager$$anon$1.prototype;
$c_Lio_youi_app_screen_ScreenManager$$anon$1.prototype.change__O__O__V = (function(oldValue, newValue) {
  this.change__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__V($as_Lio_youi_app_screen_Screen(oldValue), $as_Lio_youi_app_screen_Screen(newValue))
});
$c_Lio_youi_app_screen_ScreenManager$$anon$1.prototype.init___Lio_youi_app_screen_ScreenManager = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_app_screen_ScreenManager$$anon$1.prototype.change__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__V = (function(oldScreen, newScreen) {
  var this$1 = this.$$outer$1;
  $f_Lio_youi_app_screen_ScreenManager__io$youi$app$screen$ScreenManager$$screenChange__Lio_youi_app_screen_Screen__Lio_youi_app_screen_Screen__V(this$1, oldScreen, newScreen)
});
var $d_Lio_youi_app_screen_ScreenManager$$anon$1 = new $TypeData().initClass({
  Lio_youi_app_screen_ScreenManager$$anon$1: 0
}, false, "io.youi.app.screen.ScreenManager$$anon$1", {
  Lio_youi_app_screen_ScreenManager$$anon$1: 1,
  O: 1,
  Lreactify_ChangeListener: 1
});
$c_Lio_youi_app_screen_ScreenManager$$anon$1.prototype.$classData = $d_Lio_youi_app_screen_ScreenManager$$anon$1;
/** @constructor */
function $c_Lio_youi_app_screen_URLActivation$$anon$1() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_app_screen_URLActivation$$anon$1.prototype = new $h_O();
$c_Lio_youi_app_screen_URLActivation$$anon$1.prototype.constructor = $c_Lio_youi_app_screen_URLActivation$$anon$1;
/** @constructor */
function $h_Lio_youi_app_screen_URLActivation$$anon$1() {
  /*<skip>*/
}
$h_Lio_youi_app_screen_URLActivation$$anon$1.prototype = $c_Lio_youi_app_screen_URLActivation$$anon$1.prototype;
$c_Lio_youi_app_screen_URLActivation$$anon$1.prototype.change__O__O__V = (function(oldValue, newValue) {
  this.change__Lio_youi_net_URL__Lio_youi_net_URL__V($as_Lio_youi_net_URL(oldValue), $as_Lio_youi_net_URL(newValue))
});
$c_Lio_youi_app_screen_URLActivation$$anon$1.prototype.init___Lio_youi_app_screen_URLActivation = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_app_screen_URLActivation$$anon$1.prototype.change__Lio_youi_net_URL__Lio_youi_net_URL__V = (function(oldValue, newValue) {
  var this$1 = this.$$outer$1;
  $f_Lio_youi_app_screen_URLActivation__io$youi$app$screen$URLActivation$$validateURL__Lio_youi_net_URL__V(this$1, newValue)
});
var $d_Lio_youi_app_screen_URLActivation$$anon$1 = new $TypeData().initClass({
  Lio_youi_app_screen_URLActivation$$anon$1: 0
}, false, "io.youi.app.screen.URLActivation$$anon$1", {
  Lio_youi_app_screen_URLActivation$$anon$1: 1,
  O: 1,
  Lreactify_ChangeListener: 1
});
$c_Lio_youi_app_screen_URLActivation$$anon$1.prototype.$classData = $d_Lio_youi_app_screen_URLActivation$$anon$1;
/** @constructor */
function $c_Lio_youi_component_Container$() {
  $c_Lio_youi_style_Theme.call(this)
}
$c_Lio_youi_component_Container$.prototype = new $h_Lio_youi_style_Theme();
$c_Lio_youi_component_Container$.prototype.constructor = $c_Lio_youi_component_Container$;
/** @constructor */
function $h_Lio_youi_component_Container$() {
  /*<skip>*/
}
$h_Lio_youi_component_Container$.prototype = $c_Lio_youi_component_Container$.prototype;
$c_Lio_youi_component_Container$.prototype.init___ = (function() {
  $c_Lio_youi_style_Theme.prototype.init___Lio_youi_style_Theme.call(this, $m_Lio_youi_style_Theme$());
  return this
});
var $d_Lio_youi_component_Container$ = new $TypeData().initClass({
  Lio_youi_component_Container$: 0
}, false, "io.youi.component.Container$", {
  Lio_youi_component_Container$: 1,
  Lio_youi_style_Theme: 1,
  O: 1
});
$c_Lio_youi_component_Container$.prototype.$classData = $d_Lio_youi_component_Container$;
var $n_Lio_youi_component_Container$ = (void 0);
function $m_Lio_youi_component_Container$() {
  if ((!$n_Lio_youi_component_Container$)) {
    $n_Lio_youi_component_Container$ = new $c_Lio_youi_component_Container$().init___()
  };
  return $n_Lio_youi_component_Container$
}
/** @constructor */
function $c_Lio_youi_component_Container$$anon$1() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_component_Container$$anon$1.prototype = new $h_O();
$c_Lio_youi_component_Container$$anon$1.prototype.constructor = $c_Lio_youi_component_Container$$anon$1;
/** @constructor */
function $h_Lio_youi_component_Container$$anon$1() {
  /*<skip>*/
}
$h_Lio_youi_component_Container$$anon$1.prototype = $c_Lio_youi_component_Container$$anon$1.prototype;
$c_Lio_youi_component_Container$$anon$1.prototype.change__O__O__V = (function(oldValue, newValue) {
  this.change__sci_Vector__sci_Vector__V($as_sci_Vector(oldValue), $as_sci_Vector(newValue))
});
$c_Lio_youi_component_Container$$anon$1.prototype.init___Lio_youi_component_Container = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
$c_Lio_youi_component_Container$$anon$1.prototype.change__sci_Vector__sci_Vector__V = (function(oldValue, newValue) {
  var modifiedOld = new $c_sr_ObjectRef().init___O(oldValue);
  var this$2 = oldValue.iterator__sci_VectorIterator();
  while (this$2.$$undhasNext$2) {
    var arg1 = this$2.next__O();
    var c = $as_Lio_youi_component_Component(arg1);
    if ((!$f_sc_SeqLike__contains__O__Z(newValue, c))) {
      var this$3 = $as_sci_Vector(modifiedOld.elem$1);
      $m_sci_Vector$();
      var b = new $c_sci_VectorBuilder().init___();
      var this$5 = this$3.iterator__sci_VectorIterator();
      while (this$5.$$undhasNext$2) {
        var arg1$1 = this$5.next__O();
        var x$1 = $as_Lio_youi_component_Component(arg1$1);
        if (((x$1 === c) !== true)) {
          b.$$plus$eq__O__sci_VectorBuilder(arg1$1)
        }
      };
      modifiedOld.elem$1 = b.result__sci_Vector();
      this.$$outer$1.remove__Lio_youi_component_Component__V(c);
      var this$6 = $as_Lreactify_Var(c.parent__Lreactify_Val());
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
        return (function() {
          return $m_s_None$()
        })
      })(this));
      this$6.replace__F0__Z__V(value, true)
    }
  };
  var elem = $m_s_None$();
  var previous = new $c_sr_ObjectRef().init___O(elem);
  $m_sci_Vector$();
  var bf = $m_sc_IndexedSeq$().ReusableCBF$6;
  $as_sc_IterableLike($f_sc_IterableLike__zipWithIndex__scg_CanBuildFrom__O(newValue, bf)).foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$2, modifiedOld$1, previous$1) {
    return (function(x0$1$2) {
      var x0$1 = $as_T2(x0$1$2);
      if ((x0$1 !== null)) {
        var c$1 = $as_Lio_youi_component_Component(x0$1.$$und1__O());
        var index = x0$1.$$und2$mcI$sp__I();
        var this$9 = $as_sci_Vector(modifiedOld$1.elem$1);
        if ((!$f_sc_SeqLike__contains__O__Z(this$9, c$1))) {
          var shouldAdd = true
        } else {
          var this$10 = $as_sci_Vector(modifiedOld$1.elem$1);
          if (($f_sc_GenSeqLike__indexOf__O__I__I(this$10, c$1, 0) !== index)) {
            this$2$2.$$outer$1.remove__Lio_youi_component_Component__V(c$1);
            var shouldAdd = true
          } else {
            var shouldAdd = false
          }
        };
        if (shouldAdd) {
          this$2$2.$$outer$1.addAfter__Lio_youi_component_Component__s_Option__V(c$1, $as_s_Option(previous$1.elem$1));
          var this$11 = $as_Lreactify_Var(c$1.parent__Lreactify_Val());
          var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
            return (function() {
              return new $c_s_Some().init___O($this.$$outer$1)
            })
          })(this$2$2));
          this$11.replace__F0__Z__V(value$1, true)
        };
        previous$1.elem$1 = new $c_s_Some().init___O(c$1)
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })(this, modifiedOld, previous)))
});
var $d_Lio_youi_component_Container$$anon$1 = new $TypeData().initClass({
  Lio_youi_component_Container$$anon$1: 0
}, false, "io.youi.component.Container$$anon$1", {
  Lio_youi_component_Container$$anon$1: 1,
  O: 1,
  Lreactify_ChangeListener: 1
});
$c_Lio_youi_component_Container$$anon$1.prototype.$classData = $d_Lio_youi_component_Container$$anon$1;
/** @constructor */
function $c_Lio_youi_component_Graphics$() {
  $c_Lio_youi_style_Theme.call(this)
}
$c_Lio_youi_component_Graphics$.prototype = new $h_Lio_youi_style_Theme();
$c_Lio_youi_component_Graphics$.prototype.constructor = $c_Lio_youi_component_Graphics$;
/** @constructor */
function $h_Lio_youi_component_Graphics$() {
  /*<skip>*/
}
$h_Lio_youi_component_Graphics$.prototype = $c_Lio_youi_component_Graphics$.prototype;
$c_Lio_youi_component_Graphics$.prototype.init___ = (function() {
  $c_Lio_youi_style_Theme.prototype.init___Lio_youi_style_Theme.call(this, $m_Lio_youi_style_Theme$());
  return this
});
var $d_Lio_youi_component_Graphics$ = new $TypeData().initClass({
  Lio_youi_component_Graphics$: 0
}, false, "io.youi.component.Graphics$", {
  Lio_youi_component_Graphics$: 1,
  Lio_youi_style_Theme: 1,
  O: 1
});
$c_Lio_youi_component_Graphics$.prototype.$classData = $d_Lio_youi_component_Graphics$;
var $n_Lio_youi_component_Graphics$ = (void 0);
function $m_Lio_youi_component_Graphics$() {
  if ((!$n_Lio_youi_component_Graphics$)) {
    $n_Lio_youi_component_Graphics$ = new $c_Lio_youi_component_Graphics$().init___()
  };
  return $n_Lio_youi_component_Graphics$
}
/** @constructor */
function $c_Lio_youi_component_Image$() {
  $c_Lio_youi_style_Theme.call(this)
}
$c_Lio_youi_component_Image$.prototype = new $h_Lio_youi_style_Theme();
$c_Lio_youi_component_Image$.prototype.constructor = $c_Lio_youi_component_Image$;
/** @constructor */
function $h_Lio_youi_component_Image$() {
  /*<skip>*/
}
$h_Lio_youi_component_Image$.prototype = $c_Lio_youi_component_Image$.prototype;
$c_Lio_youi_component_Image$.prototype.init___ = (function() {
  $c_Lio_youi_style_Theme.prototype.init___Lio_youi_style_Theme.call(this, $m_Lio_youi_style_Theme$());
  return this
});
var $d_Lio_youi_component_Image$ = new $TypeData().initClass({
  Lio_youi_component_Image$: 0
}, false, "io.youi.component.Image$", {
  Lio_youi_component_Image$: 1,
  Lio_youi_style_Theme: 1,
  O: 1
});
$c_Lio_youi_component_Image$.prototype.$classData = $d_Lio_youi_component_Image$;
var $n_Lio_youi_component_Image$ = (void 0);
function $m_Lio_youi_component_Image$() {
  if ((!$n_Lio_youi_component_Image$)) {
    $n_Lio_youi_component_Image$ = new $c_Lio_youi_component_Image$().init___()
  };
  return $n_Lio_youi_component_Image$
}
/** @constructor */
function $c_Lio_youi_component_Text$() {
  $c_Lio_youi_style_Theme.call(this)
}
$c_Lio_youi_component_Text$.prototype = new $h_Lio_youi_style_Theme();
$c_Lio_youi_component_Text$.prototype.constructor = $c_Lio_youi_component_Text$;
/** @constructor */
function $h_Lio_youi_component_Text$() {
  /*<skip>*/
}
$h_Lio_youi_component_Text$.prototype = $c_Lio_youi_component_Text$.prototype;
$c_Lio_youi_component_Text$.prototype.init___ = (function() {
  $c_Lio_youi_style_Theme.prototype.init___Lio_youi_style_Theme.call(this, $m_Lio_youi_style_Theme$());
  return this
});
var $d_Lio_youi_component_Text$ = new $TypeData().initClass({
  Lio_youi_component_Text$: 0
}, false, "io.youi.component.Text$", {
  Lio_youi_component_Text$: 1,
  Lio_youi_style_Theme: 1,
  O: 1
});
$c_Lio_youi_component_Text$.prototype.$classData = $d_Lio_youi_component_Text$;
var $n_Lio_youi_component_Text$ = (void 0);
function $m_Lio_youi_component_Text$() {
  if ((!$n_Lio_youi_component_Text$)) {
    $n_Lio_youi_component_Text$ = new $c_Lio_youi_component_Text$().init___()
  };
  return $n_Lio_youi_component_Text$
}
/** @constructor */
function $c_Lio_youi_dom$() {
  $c_Lio_youi_ExtendedElement.call(this);
  this.addedScripts$2 = null;
  this.bitmap$0$2 = false
}
$c_Lio_youi_dom$.prototype = new $h_Lio_youi_ExtendedElement();
$c_Lio_youi_dom$.prototype.constructor = $c_Lio_youi_dom$;
/** @constructor */
function $h_Lio_youi_dom$() {
  /*<skip>*/
}
$h_Lio_youi_dom$.prototype = $c_Lio_youi_dom$.prototype;
$c_Lio_youi_dom$.prototype.init___ = (function() {
  $c_Lio_youi_ExtendedElement.prototype.init___s_Option.call(this, $m_s_None$());
  return this
});
$c_Lio_youi_dom$.prototype.addedScripts__p2__scm_Map = (function() {
  return ((!this.bitmap$0$2) ? this.addedScripts$lzycompute__p2__scm_Map() : this.addedScripts$2)
});
$c_Lio_youi_dom$.prototype.bySelector__T__s_Option__sci_Vector = (function(selectors, root) {
  if (root.isEmpty__Z()) {
    var this$1 = $m_s_None$()
  } else {
    var arg1 = root.get__O();
    var this$1 = new $c_s_Some().init___O(arg1.querySelectorAll(selectors))
  };
  var nodes = (this$1.isEmpty__Z() ? $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().querySelectorAll(selectors) : this$1.get__O());
  var this$3 = new $c_Lorg_scalajs_dom_ext_package$PimpedNodeList().init___Lorg_scalajs_dom_raw_NodeList(nodes);
  $m_sci_Vector$();
  var cbf = $m_sc_IndexedSeq$().ReusableCBF$6;
  return $as_sci_Vector($f_sc_TraversableLike__to__scg_CanBuildFrom__O(this$3, cbf))
});
$c_Lio_youi_dom$.prototype.create__T__Lorg_scalajs_dom_raw_Element = (function(tagName) {
  return $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().createElement(tagName)
});
$c_Lio_youi_dom$.prototype.oneBySelector__T__s_Option__Lorg_scalajs_dom_raw_Element = (function(selectors, root) {
  var this$1 = this.firstBySelector__T__s_Option__s_Option(selectors, root);
  if (this$1.isEmpty__Z()) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(new $c_jl_RuntimeException().init___T(new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Unable to find element by selector: ", "."])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([selectors]))))
  } else {
    return this$1.get__O()
  }
});
$c_Lio_youi_dom$.prototype.addScript__T__Z__s_concurrent_Future = (function(url, addToHead) {
  var x1 = this.addedScripts__p2__scm_Map().get__O__s_Option(url);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var f = $as_s_concurrent_Future(x2.value$2);
    return f
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      var promise = new $c_s_concurrent_impl_Promise$DefaultPromise().init___();
      var script = this.create__T__Lorg_scalajs_dom_raw_Element("script");
      script.addEventListener("load", (function(promise$1) {
        return (function(arg1$2) {
          $m_Lio_youi_dom$();
          return $f_s_concurrent_Promise__success__O__s_concurrent_Promise(promise$1, (void 0))
        })
      })(promise));
      script.src = url;
      if (addToHead) {
        $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().head.appendChild(script)
      } else {
        $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().body.appendChild(script)
      };
      this.addedScripts__p2__scm_Map().$$plus$eq__T2__scm_MapLike(new $c_T2().init___O__O(url, promise));
      return promise
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
$c_Lio_youi_dom$.prototype.fromString__T__sci_List = (function(htmlString) {
  var container = this.create__T__Lorg_scalajs_dom_raw_Element("div");
  container.innerHTML = htmlString;
  var nodes = container.childNodes;
  var this$2 = new $c_Lorg_scalajs_dom_ext_package$PimpedNodeList().init___Lorg_scalajs_dom_raw_NodeList(nodes);
  var this$3 = $m_sci_List$();
  var cbf = this$3.ReusableCBFInstance$2;
  var jsx$2 = $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(this$2, cbf));
  var jsx$1 = new $c_Lio_youi_dom$$anonfun$fromString$1().init___Lorg_scalajs_dom_raw_HTMLDivElement(container);
  var this$4 = $m_sci_List$();
  return $as_sci_List(jsx$2.collect__s_PartialFunction__scg_CanBuildFrom__O(jsx$1, this$4.ReusableCBFInstance$2))
});
$c_Lio_youi_dom$.prototype.firstBySelector__T__s_Option__s_Option = (function(selectors, root) {
  var this$1 = this.bySelector__T__s_Option__sci_Vector(selectors, root);
  return $f_sc_TraversableLike__headOption__s_Option(this$1)
});
$c_Lio_youi_dom$.prototype.addedScripts$lzycompute__p2__scm_Map = (function() {
  if ((!this.bitmap$0$2)) {
    var jsx$4 = $m_scm_Map$();
    var e = $m_Lorg_scalajs_dom_package$().document__Lorg_scalajs_dom_raw_HTMLDocument().head;
    var this$1 = new $c_Lio_youi_dom$ElementExtras().init___Lorg_scalajs_dom_raw_Element(e);
    var this$2 = this$1.bySelector__T__sci_Vector("script");
    var this$3 = $m_sci_List$();
    var cbf = this$3.ReusableCBFInstance$2;
    var x$2 = $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(this$2, cbf));
    var this$4 = this.bySelector__T__sci_Vector("script");
    var this$5 = $m_sci_List$();
    var cbf$1 = this$5.ReusableCBFInstance$2;
    var jsx$2 = $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(this$4, cbf$1)).$$colon$colon$colon__sci_List__sci_List(x$2);
    var jsx$1 = new $c_Lio_youi_dom$$anonfun$addedScripts$lzycompute$1().init___();
    var this$6 = $m_sci_List$();
    var this$10 = $as_sci_List(jsx$2.collect__s_PartialFunction__scg_CanBuildFrom__O(jsx$1, this$6.ReusableCBFInstance$2));
    var f = (function($this) {
      return (function(x$3$2) {
        var x$3 = $as_T(x$3$2);
        var y = $m_s_concurrent_Future$().successful__O__s_concurrent_Future((void 0));
        return new $c_T2().init___O__O(x$3, y)
      })
    })(this);
    var this$9 = $m_sci_List$();
    var bf = this$9.ReusableCBFInstance$2;
    if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
      if ((this$10 === $m_sci_Nil$())) {
        var jsx$3 = $m_sci_Nil$()
      } else {
        var arg1 = this$10.head__O();
        var h = new $c_sci_$colon$colon().init___O__sci_List(f(arg1), $m_sci_Nil$());
        var t = h;
        var rest = $as_sci_List(this$10.tail__O());
        while ((rest !== $m_sci_Nil$())) {
          var arg1$1 = rest.head__O();
          var nx = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$1), $m_sci_Nil$());
          t.tl$5 = nx;
          t = nx;
          rest = $as_sci_List(rest.tail__O())
        };
        var jsx$3 = h
      }
    } else {
      var b = $f_sc_TraversableLike__builder$1__psc_TraversableLike__scg_CanBuildFrom__scm_Builder(this$10, bf);
      var these = this$10;
      while ((!these.isEmpty__Z())) {
        var arg1$2 = these.head__O();
        b.$$plus$eq__O__scm_Builder(f(arg1$2));
        these = $as_sci_List(these.tail__O())
      };
      var jsx$3 = b.result__O()
    };
    this.addedScripts$2 = $as_scm_Map(jsx$4.apply__sc_Seq__sc_GenMap($as_sc_Seq(jsx$3)));
    this.bitmap$0$2 = true
  };
  return this.addedScripts$2
});
var $d_Lio_youi_dom$ = new $TypeData().initClass({
  Lio_youi_dom$: 0
}, false, "io.youi.dom$", {
  Lio_youi_dom$: 1,
  Lio_youi_ExtendedElement: 1,
  O: 1
});
$c_Lio_youi_dom$.prototype.$classData = $d_Lio_youi_dom$;
var $n_Lio_youi_dom$ = (void 0);
function $m_Lio_youi_dom$() {
  if ((!$n_Lio_youi_dom$)) {
    $n_Lio_youi_dom$ = new $c_Lio_youi_dom$().init___()
  };
  return $n_Lio_youi_dom$
}
/** @constructor */
function $c_Lio_youi_dom$ElementExtras() {
  $c_Lio_youi_ExtendedElement.call(this);
  this.e$2 = null
}
$c_Lio_youi_dom$ElementExtras.prototype = new $h_Lio_youi_ExtendedElement();
$c_Lio_youi_dom$ElementExtras.prototype.constructor = $c_Lio_youi_dom$ElementExtras;
/** @constructor */
function $h_Lio_youi_dom$ElementExtras() {
  /*<skip>*/
}
$h_Lio_youi_dom$ElementExtras.prototype = $c_Lio_youi_dom$ElementExtras.prototype;
$c_Lio_youi_dom$ElementExtras.prototype.remove__V = (function() {
  var this$1 = $m_s_Option$().apply__O__s_Option(this.e$2.parentNode);
  if ((!this$1.isEmpty__Z())) {
    var arg1 = this$1.get__O();
    arg1.removeChild(this.e$2)
  }
});
$c_Lio_youi_dom$ElementExtras.prototype.insertAfter__Lorg_scalajs_dom_raw_Element__V = (function(previous) {
  var x1 = $m_s_Option$().apply__O__s_Option(previous.nextElementSibling);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var next = x2.value$2;
    previous.parentNode.insertBefore(this.e$2, next)
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      previous.parentNode.appendChild(this.e$2)
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
$c_Lio_youi_dom$ElementExtras.prototype.insertFirst__Lorg_scalajs_dom_raw_Element__V = (function(parent) {
  var x1 = $m_s_Option$().apply__O__s_Option(parent.firstElementChild);
  if ($is_s_Some(x1)) {
    var x2 = $as_s_Some(x1);
    var first = x2.value$2;
    parent.insertBefore(this.e$2, first)
  } else {
    var x = $m_s_None$();
    if ((x === x1)) {
      parent.appendChild(this.e$2)
    } else {
      throw new $c_s_MatchError().init___O(x1)
    }
  }
});
$c_Lio_youi_dom$ElementExtras.prototype.init___Lorg_scalajs_dom_raw_Element = (function(e) {
  this.e$2 = e;
  $c_Lio_youi_ExtendedElement.prototype.init___s_Option.call(this, new $c_s_Some().init___O(e));
  return this
});
var $d_Lio_youi_dom$ElementExtras = new $TypeData().initClass({
  Lio_youi_dom$ElementExtras: 0
}, false, "io.youi.dom$ElementExtras", {
  Lio_youi_dom$ElementExtras: 1,
  Lio_youi_ExtendedElement: 1,
  O: 1
});
$c_Lio_youi_dom$ElementExtras.prototype.$classData = $d_Lio_youi_dom$ElementExtras;
/** @constructor */
function $c_Lio_youi_easing_Easing$$anon$1() {
  $c_O.call(this);
  this.f$1$1 = null
}
$c_Lio_youi_easing_Easing$$anon$1.prototype = new $h_O();
$c_Lio_youi_easing_Easing$$anon$1.prototype.constructor = $c_Lio_youi_easing_Easing$$anon$1;
/** @constructor */
function $h_Lio_youi_easing_Easing$$anon$1() {
  /*<skip>*/
}
$h_Lio_youi_easing_Easing$$anon$1.prototype = $c_Lio_youi_easing_Easing$$anon$1.prototype;
$c_Lio_youi_easing_Easing$$anon$1.prototype.init___F4 = (function(f$1) {
  this.f$1$1 = f$1;
  return this
});
$c_Lio_youi_easing_Easing$$anon$1.prototype.calculate__D__D = (function(progress) {
  return $uD(this.f$1$1.apply__O__O__O__O__O(progress, 0.0, 1.0, 1.0))
});
var $d_Lio_youi_easing_Easing$$anon$1 = new $TypeData().initClass({
  Lio_youi_easing_Easing$$anon$1: 0
}, false, "io.youi.easing.Easing$$anon$1", {
  Lio_youi_easing_Easing$$anon$1: 1,
  O: 1,
  Lio_youi_easing_Easing: 1
});
$c_Lio_youi_easing_Easing$$anon$1.prototype.$classData = $d_Lio_youi_easing_Easing$$anon$1;
/** @constructor */
function $c_Lio_youi_easing_Linear$() {
  $c_O.call(this)
}
$c_Lio_youi_easing_Linear$.prototype = new $h_O();
$c_Lio_youi_easing_Linear$.prototype.constructor = $c_Lio_youi_easing_Linear$;
/** @constructor */
function $h_Lio_youi_easing_Linear$() {
  /*<skip>*/
}
$h_Lio_youi_easing_Linear$.prototype = $c_Lio_youi_easing_Linear$.prototype;
$c_Lio_youi_easing_Linear$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_easing_Linear$.prototype.calculate__D__D = (function(progress) {
  return progress
});
var $d_Lio_youi_easing_Linear$ = new $TypeData().initClass({
  Lio_youi_easing_Linear$: 0
}, false, "io.youi.easing.Linear$", {
  Lio_youi_easing_Linear$: 1,
  O: 1,
  Lio_youi_easing_Easing: 1
});
$c_Lio_youi_easing_Linear$.prototype.$classData = $d_Lio_youi_easing_Linear$;
var $n_Lio_youi_easing_Linear$ = (void 0);
function $m_Lio_youi_easing_Linear$() {
  if ((!$n_Lio_youi_easing_Linear$)) {
    $n_Lio_youi_easing_Linear$ = new $c_Lio_youi_easing_Linear$().init___()
  };
  return $n_Lio_youi_easing_Linear$
}
function $f_Lio_youi_example_ExampleCommunication__$$init$__V($thiz) {
  var v = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_s_None$()
    })
  })($thiz)), false, true, true);
  var modifying = new $c_Lio_youi_example_ExampleCommunication$$anon$1().init___Lio_youi_example_ExampleCommunication($thiz);
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2, modifying$1) {
    return (function(value$2) {
      var value = $as_s_Option(value$2);
      if ((!$uZ(modifying$1.get__O()))) {
        var this$4 = $m_Lupickle_default$();
        $m_Lupickle_default$();
        var indent = 0;
        var this$3 = $m_Lupickle_default$();
        var evidence$20 = $m_Lupickle_default$().StringRW$1;
        var evidence$1 = $f_Lupickle_Implicits__OptionW__Lupickle_Types$Writer__Lupickle_Types$Writer(this$3, evidence$20);
        var json = $f_Lupickle_Types__write__O__I__Lupickle_Types$Writer__T(this$4, value, indent, evidence$1);
        var jsx$1 = $m_Lio_youi_communication_CommunicationMessage$().SharedVariable$1;
        $m_sci_List$();
        var xs = new $c_sjs_js_WrappedArray().init___sjs_js_Array([json]);
        var this$6 = $m_sci_List$();
        var cbf = this$6.ReusableCBFInstance$2;
        var message = new $c_Lio_youi_communication_CommunicationMessage().init___I__T__I__sci_List__s_Option(jsx$1, "0", 0, $as_sci_List($f_sc_TraversableLike__to__scg_CanBuildFrom__O(xs, cbf)), $m_s_None$());
        var this$7 = this$2.comm$1.send$1;
        var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1, message$1) {
          return (function() {
            return message$1
          })
        })(this$2, message));
        this$7.set__F0__V(value$1)
      }
    })
  })($thiz, modifying));
  var priority = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(v, f, priority);
  $thiz.comm$1.receive$1.attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1, v$1, modifying$2) {
    return (function(message$2) {
      var message$3 = $as_Lio_youi_communication_CommunicationMessage(message$2);
      if (((message$3.endPoint$1 === "0") && (message$3.messageType$1 === $m_Lio_youi_communication_CommunicationMessage$().SharedVariable$1))) {
        var this$9 = $m_Lupickle_default$();
        var expr = $as_T(message$3.content$1.head__O());
        var this$8 = $m_Lupickle_default$();
        var evidence$22 = $as_Lupickle_Types$Reader($m_Lupickle_default$().StringRW$1);
        var evidence$3 = $f_Lupickle_Implicits__OptionR__Lupickle_Types$Reader__Lupickle_Types$Reader(this$8, evidence$22);
        var value$3 = $as_s_Option($f_Lupickle_Types__read__T__Lupickle_Types$Reader__O(this$9, expr, evidence$3));
        modifying$2.set__O__V(true);
        try {
          var value$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$2, value$4) {
            return (function() {
              return value$4
            })
          })(this$3$1, value$3));
          v$1.replace__F0__Z__V(value$5, true)
        } finally {
          modifying$2.set__O__V(false)
        }
      }
    })
  })($thiz, v, modifying)), $thiz.comm$1.receive$1.attach$default$2__D());
  $thiz.name$1 = v;
  var this$12 = $thiz.name$1;
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
    return (function(value$3$2) {
      var value$3$1 = $as_s_Option(value$3$2);
      var this$10 = $m_Lscribe_package$();
      var level = $m_Lscribe_Level$Info$();
      var message$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$3, value$6) {
        return (function() {
          return new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["Name changed: ", ""])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([value$6]))
        })
      })(this$4$1, value$3$1));
      var methodName = $m_s_None$();
      $f_Lscribe_LoggerSupport__log__Lscribe_Level__F0__T__s_Option__I__V(this$10, level, message$4, "io.youi.example.ExampleCommunication.<local ExampleCommunication>", methodName, 19)
    })
  })($thiz));
  var priority$1 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$12, f$1, priority$1)
}
function $is_Lio_youi_example_ExampleCommunication(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_example_ExampleCommunication)))
}
function $as_Lio_youi_example_ExampleCommunication(obj) {
  return (($is_Lio_youi_example_ExampleCommunication(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.example.ExampleCommunication"))
}
function $isArrayOf_Lio_youi_example_ExampleCommunication(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_example_ExampleCommunication)))
}
function $asArrayOf_Lio_youi_example_ExampleCommunication(obj, depth) {
  return (($isArrayOf_Lio_youi_example_ExampleCommunication(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.example.ExampleCommunication;", depth))
}
/** @constructor */
function $c_Lio_youi_example_ExampleCommunication$$anon$1() {
  $c_jl_ThreadLocal.call(this)
}
$c_Lio_youi_example_ExampleCommunication$$anon$1.prototype = new $h_jl_ThreadLocal();
$c_Lio_youi_example_ExampleCommunication$$anon$1.prototype.constructor = $c_Lio_youi_example_ExampleCommunication$$anon$1;
/** @constructor */
function $h_Lio_youi_example_ExampleCommunication$$anon$1() {
  /*<skip>*/
}
$h_Lio_youi_example_ExampleCommunication$$anon$1.prototype = $c_Lio_youi_example_ExampleCommunication$$anon$1.prototype;
$c_Lio_youi_example_ExampleCommunication$$anon$1.prototype.init___Lio_youi_example_ExampleCommunication = (function($$outer) {
  $c_jl_ThreadLocal.prototype.init___.call(this);
  return this
});
$c_Lio_youi_example_ExampleCommunication$$anon$1.prototype.initialValue__O = (function() {
  return false
});
var $d_Lio_youi_example_ExampleCommunication$$anon$1 = new $TypeData().initClass({
  Lio_youi_example_ExampleCommunication$$anon$1: 0
}, false, "io.youi.example.ExampleCommunication$$anon$1", {
  Lio_youi_example_ExampleCommunication$$anon$1: 1,
  jl_ThreadLocal: 1,
  O: 1
});
$c_Lio_youi_example_ExampleCommunication$$anon$1.prototype.$classData = $d_Lio_youi_example_ExampleCommunication$$anon$1;
function $is_Lio_youi_example_SimpleCommunication(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_example_SimpleCommunication)))
}
function $as_Lio_youi_example_SimpleCommunication(obj) {
  return (($is_Lio_youi_example_SimpleCommunication(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.example.SimpleCommunication"))
}
function $isArrayOf_Lio_youi_example_SimpleCommunication(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_example_SimpleCommunication)))
}
function $asArrayOf_Lio_youi_example_SimpleCommunication(obj, depth) {
  return (($isArrayOf_Lio_youi_example_SimpleCommunication(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.example.SimpleCommunication;", depth))
}
/** @constructor */
function $c_Lio_youi_example_ui_TextExample$$anon$6() {
  $c_Lio_youi_style_Theme.call(this)
}
$c_Lio_youi_example_ui_TextExample$$anon$6.prototype = new $h_Lio_youi_style_Theme();
$c_Lio_youi_example_ui_TextExample$$anon$6.prototype.constructor = $c_Lio_youi_example_ui_TextExample$$anon$6;
/** @constructor */
function $h_Lio_youi_example_ui_TextExample$$anon$6() {
  /*<skip>*/
}
$h_Lio_youi_example_ui_TextExample$$anon$6.prototype = $c_Lio_youi_example_ui_TextExample$$anon$6.prototype;
$c_Lio_youi_example_ui_TextExample$$anon$6.prototype.init___ = (function() {
  $c_Lio_youi_style_Theme.prototype.init___Lio_youi_style_Theme.call(this, $m_Lio_youi_component_Text$());
  var this$1 = this.font__Lio_youi_style_Theme$font$().size$1;
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return 48.0
    })
  })(this));
  this$1.replace__F0__Z__V(value, true);
  var this$5 = this.fill$1;
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      var color = $m_Lio_youi_Color$().Black__Lio_youi_Color();
      return new $c_Lio_youi_style_ColorPaint().init___Lio_youi_Color(color)
    })
  })(this));
  this$5.replace__F0__Z__V(value$1, true);
  return this
});
var $d_Lio_youi_example_ui_TextExample$$anon$6 = new $TypeData().initClass({
  Lio_youi_example_ui_TextExample$$anon$6: 0
}, false, "io.youi.example.ui.TextExample$$anon$6", {
  Lio_youi_example_ui_TextExample$$anon$6: 1,
  Lio_youi_style_Theme: 1,
  O: 1
});
$c_Lio_youi_example_ui_TextExample$$anon$6.prototype.$classData = $d_Lio_youi_example_ui_TextExample$$anon$6;
function $f_Lio_youi_hypertext_AbstractContainer__$$init$__V($thiz) {
  $thiz.io$youi$hypertext$AbstractContainer$$undsetter$und$layoutManager$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      return $m_s_None$()
    })
  })($thiz)), false, true, true));
  $thiz.io$youi$hypertext$AbstractContainer$$undsetter$und$children$und$eq__Lreactify_Var__V($m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2) {
    return (function() {
      var this$1 = $m_s_package$().Vector$1;
      return this$1.NIL$6
    })
  })($thiz)), false, true, true));
  var this$3 = $thiz.layoutManager__Lreactify_Var();
  var listener = new $c_Lio_youi_hypertext_AbstractContainer$$anon$1().init___Lio_youi_hypertext_AbstractContainer($thiz);
  $f_Lreactify_State__changes__Lreactify_ChangeListener__Lreactify_Listener(this$3, listener);
  var this$4 = $thiz.children__Lreactify_Var();
  var listener$1 = new $c_Lio_youi_hypertext_AbstractContainer$$anon$2().init___Lio_youi_hypertext_AbstractContainer($thiz);
  $f_Lreactify_State__changes__Lreactify_ChangeListener__Lreactify_Listener(this$4, listener$1)
}
function $f_Lio_youi_hypertext_AbstractContainer__update__D__V($thiz, delta) {
  $f_Lio_youi_Updates__update__D__V($thiz, delta);
  var this$1 = $thiz.children__Lreactify_Var();
  $as_sc_IterableLike(this$1.get__O()).foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, delta$1) {
    return (function(x$2$2) {
      var x$2 = $as_Lio_youi_hypertext_AbstractComponent(x$2$2);
      x$2.update__D__V(delta$1)
    })
  })($thiz, delta)))
}
function $is_Lio_youi_hypertext_AbstractContainer(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_hypertext_AbstractContainer)))
}
function $as_Lio_youi_hypertext_AbstractContainer(obj) {
  return (($is_Lio_youi_hypertext_AbstractContainer(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.hypertext.AbstractContainer"))
}
function $isArrayOf_Lio_youi_hypertext_AbstractContainer(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_hypertext_AbstractContainer)))
}
function $asArrayOf_Lio_youi_hypertext_AbstractContainer(obj, depth) {
  return (($isArrayOf_Lio_youi_hypertext_AbstractContainer(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.hypertext.AbstractContainer;", depth))
}
/** @constructor */
function $c_Lio_youi_hypertext_AbstractContainer$$anon$1() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_AbstractContainer$$anon$1.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractContainer$$anon$1.prototype.constructor = $c_Lio_youi_hypertext_AbstractContainer$$anon$1;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractContainer$$anon$1() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractContainer$$anon$1.prototype = $c_Lio_youi_hypertext_AbstractContainer$$anon$1.prototype;
$c_Lio_youi_hypertext_AbstractContainer$$anon$1.prototype.change__O__O__V = (function(oldValue, newValue) {
  this.change__s_Option__s_Option__V($as_s_Option(oldValue), $as_s_Option(newValue))
});
$c_Lio_youi_hypertext_AbstractContainer$$anon$1.prototype.change__s_Option__s_Option__V = (function(oldValue, newValue) {
  if ((!oldValue.isEmpty__Z())) {
    var arg1 = oldValue.get__O();
    var l = $as_Lio_youi_hypertext_layout_Layout(arg1);
    var container = this.$$outer$1;
    l.disconnect__Lio_youi_hypertext_AbstractContainer__V(container)
  };
  if ((!newValue.isEmpty__Z())) {
    var arg1$1 = newValue.get__O();
    var l$3 = $as_Lio_youi_hypertext_layout_Layout(arg1$1);
    var container$1 = this.$$outer$1;
    l$3.connect__Lio_youi_hypertext_AbstractContainer__V(container$1)
  }
});
$c_Lio_youi_hypertext_AbstractContainer$$anon$1.prototype.init___Lio_youi_hypertext_AbstractContainer = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_hypertext_AbstractContainer$$anon$1 = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractContainer$$anon$1: 0
}, false, "io.youi.hypertext.AbstractContainer$$anon$1", {
  Lio_youi_hypertext_AbstractContainer$$anon$1: 1,
  O: 1,
  Lreactify_ChangeListener: 1
});
$c_Lio_youi_hypertext_AbstractContainer$$anon$1.prototype.$classData = $d_Lio_youi_hypertext_AbstractContainer$$anon$1;
/** @constructor */
function $c_Lio_youi_hypertext_AbstractContainer$$anon$2() {
  $c_O.call(this);
  this.$$outer$1 = null
}
$c_Lio_youi_hypertext_AbstractContainer$$anon$2.prototype = new $h_O();
$c_Lio_youi_hypertext_AbstractContainer$$anon$2.prototype.constructor = $c_Lio_youi_hypertext_AbstractContainer$$anon$2;
/** @constructor */
function $h_Lio_youi_hypertext_AbstractContainer$$anon$2() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_AbstractContainer$$anon$2.prototype = $c_Lio_youi_hypertext_AbstractContainer$$anon$2.prototype;
$c_Lio_youi_hypertext_AbstractContainer$$anon$2.prototype.change__O__O__V = (function(oldValue, newValue) {
  this.change__sci_Vector__sci_Vector__V($as_sci_Vector(oldValue), $as_sci_Vector(newValue))
});
$c_Lio_youi_hypertext_AbstractContainer$$anon$2.prototype.change__sci_Vector__sci_Vector__V = (function(oldValue, newValue) {
  var modifiedOld = new $c_sr_ObjectRef().init___O(oldValue);
  var this$2 = oldValue.iterator__sci_VectorIterator();
  while (this$2.$$undhasNext$2) {
    var arg1 = this$2.next__O();
    var c = $as_Lio_youi_hypertext_AbstractComponent(arg1);
    if ((!$f_sc_SeqLike__contains__O__Z(newValue, c))) {
      var this$3 = $as_sci_Vector(modifiedOld.elem$1);
      $m_sci_Vector$();
      var b = new $c_sci_VectorBuilder().init___();
      var this$5 = this$3.iterator__sci_VectorIterator();
      while (this$5.$$undhasNext$2) {
        var arg1$1 = this$5.next__O();
        var x$1 = $as_Lio_youi_hypertext_AbstractComponent(arg1$1);
        if (((x$1 === c) !== true)) {
          b.$$plus$eq__O__sci_VectorBuilder(arg1$1)
        }
      };
      modifiedOld.elem$1 = b.result__sci_Vector();
      var this$6 = this.$$outer$1;
      var c$1 = $as_Lio_youi_hypertext_Component(c);
      $f_Lio_youi_hypertext_HTMLContainer__remove__Lio_youi_hypertext_Component__V(this$6, c$1);
      var this$7 = $as_Lreactify_Var(c.parent__Lreactify_State());
      var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
        return (function() {
          return $m_s_None$()
        })
      })(this));
      this$7.replace__F0__Z__V(value, true)
    }
  };
  var elem = $m_s_None$();
  var previous = new $c_sr_ObjectRef().init___O(elem);
  $m_sci_Vector$();
  var bf = $m_sc_IndexedSeq$().ReusableCBF$6;
  $as_sc_IterableLike($f_sc_IterableLike__zipWithIndex__scg_CanBuildFrom__O(newValue, bf)).foreach__F1__V(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$2, modifiedOld$1, previous$1) {
    return (function(x0$1$2) {
      var x0$1 = $as_T2(x0$1$2);
      if ((x0$1 !== null)) {
        var c$2 = $as_Lio_youi_hypertext_AbstractComponent(x0$1.$$und1__O());
        var index = x0$1.$$und2$mcI$sp__I();
        var this$10 = $as_sci_Vector(modifiedOld$1.elem$1);
        if ((!$f_sc_SeqLike__contains__O__Z(this$10, c$2))) {
          var shouldAdd = true
        } else {
          var this$11 = $as_sci_Vector(modifiedOld$1.elem$1);
          if (($f_sc_GenSeqLike__indexOf__O__I__I(this$11, c$2, 0) !== index)) {
            var this$12 = this$2$2.$$outer$1;
            var c$3 = $as_Lio_youi_hypertext_Component(c$2);
            $f_Lio_youi_hypertext_HTMLContainer__remove__Lio_youi_hypertext_Component__V(this$12, c$3);
            var shouldAdd = true
          } else {
            var shouldAdd = false
          }
        };
        if (shouldAdd) {
          var this$13 = this$2$2.$$outer$1;
          var previous$2 = $as_s_Option(previous$1.elem$1);
          var c$4 = $as_Lio_youi_hypertext_Component(c$2);
          $f_Lio_youi_hypertext_HTMLContainer__addAfter__Lio_youi_hypertext_Component__s_Option__V(this$13, c$4, previous$2);
          var this$14 = $as_Lreactify_Var(c$2.parent__Lreactify_State());
          var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
            return (function() {
              return new $c_s_Some().init___O($this.$$outer$1)
            })
          })(this$2$2));
          this$14.replace__F0__Z__V(value$1, true)
        };
        previous$1.elem$1 = new $c_s_Some().init___O(c$2)
      } else {
        throw new $c_s_MatchError().init___O(x0$1)
      }
    })
  })(this, modifiedOld, previous)))
});
$c_Lio_youi_hypertext_AbstractContainer$$anon$2.prototype.init___Lio_youi_hypertext_AbstractContainer = (function($$outer) {
  if (($$outer === null)) {
    throw $m_sjsr_package$().unwrapJavaScriptException__jl_Throwable__O(null)
  } else {
    this.$$outer$1 = $$outer
  };
  return this
});
var $d_Lio_youi_hypertext_AbstractContainer$$anon$2 = new $TypeData().initClass({
  Lio_youi_hypertext_AbstractContainer$$anon$2: 0
}, false, "io.youi.hypertext.AbstractContainer$$anon$2", {
  Lio_youi_hypertext_AbstractContainer$$anon$2: 1,
  O: 1,
  Lreactify_ChangeListener: 1
});
$c_Lio_youi_hypertext_AbstractContainer$$anon$2.prototype.$classData = $d_Lio_youi_hypertext_AbstractContainer$$anon$2;
function $f_Lio_youi_hypertext_Component__init__V($thiz) {
  var this$4 = $thiz.opacity__Lreactify_Var();
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
    return (function() {
      try {
        var x = $as_T($this.element__Lorg_scalajs_dom_raw_HTMLElement().style.opacity);
        var this$2 = new $c_sci_StringOps().init___T(x);
        var jsx$1 = $m_jl_Double$();
        var $$this = this$2.repr$1;
        return jsx$1.parseDouble__T__D($$this)
      } catch (e) {
        var e$2 = $m_sjsr_package$().wrapJavaScriptException__O__jl_Throwable(e);
        if ((e$2 !== null)) {
          return 1.0
        } else {
          throw e
        }
      }
    })
  })($thiz));
  this$4.replace__F0__Z__V(value, true);
  var this$5 = $thiz.visible__Lreactify_Var();
  var value$1 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
    return (function() {
      return ($as_T(this$2$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.visibility) !== "hidden")
    })
  })($thiz));
  this$5.replace__F0__Z__V(value$1, true);
  var this$7 = $thiz.position__Lio_youi_hypertext_AbstractComponent$position$().type__Lreactify_Var();
  var f = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$3$1) {
    return (function(p$2) {
      $as_Lio_youi_hypertext_style_Position(p$2);
      this$3$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.position = $as_T("Absolute".toLowerCase())
    })
  })($thiz));
  $f_Lreactify_State__attachAndFire__F1__Lreactify_Listener(this$7, f);
  var this$9 = $thiz.position__Lio_youi_hypertext_AbstractComponent$position$().x__Lreactify_Var();
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$4$1) {
    return (function(d$2) {
      var d = $uD(d$2);
      this$4$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.left = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d]))
    })
  })($thiz));
  $thiz.position__Lio_youi_hypertext_AbstractComponent$position$().x__Lreactify_Var();
  var priority = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$9, f$1, priority);
  var this$11 = $thiz.position__Lio_youi_hypertext_AbstractComponent$position$().y__Lreactify_Var();
  var f$2 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$5$1) {
    return (function(d$3$2) {
      var d$3 = $uD(d$3$2);
      this$5$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.top = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$3]))
    })
  })($thiz));
  $thiz.position__Lio_youi_hypertext_AbstractComponent$position$().y__Lreactify_Var();
  var priority$1 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$11, f$2, priority$1);
  var this$13 = $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().width__Lreactify_Var();
  var f$4 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$6$1) {
    return (function(d$4$2) {
      var d$4 = $uD(d$4$2);
      this$6$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.width = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$4]));
      var f$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
        return (function() {
          $f_Lio_youi_hypertext_Component__updateSize__V($this$1)
        })
      })(this$6$1));
      $f_Lio_youi_Updates__nextFrame__F0__V(this$6$1, f$3)
    })
  })($thiz));
  $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().width__Lreactify_Var();
  var priority$2 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$13, f$4, priority$2);
  var this$15 = $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().height__Lreactify_Var();
  var f$6 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$7$1) {
    return (function(d$5$2) {
      var d$5 = $uD(d$5$2);
      this$7$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.height = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$5]));
      var f$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$2) {
        return (function() {
          $f_Lio_youi_hypertext_Component__updateSize__V($this$2)
        })
      })(this$7$1));
      $f_Lio_youi_Updates__nextFrame__F0__V(this$7$1, f$5)
    })
  })($thiz));
  $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().height__Lreactify_Var();
  var priority$3 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$15, f$6, priority$3);
  var this$17 = $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().min__Lio_youi_hypertext_AbstractComponent$size$min$().width__Lreactify_Var();
  var f$8 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$8$1) {
    return (function(d$6$2) {
      var d$6 = $uD(d$6$2);
      this$8$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.minWidth = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$6]));
      var f$7 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$3) {
        return (function() {
          $f_Lio_youi_hypertext_Component__updateSize__V($this$3)
        })
      })(this$8$1));
      $f_Lio_youi_Updates__nextFrame__F0__V(this$8$1, f$7)
    })
  })($thiz));
  $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().min__Lio_youi_hypertext_AbstractComponent$size$min$().width__Lreactify_Var();
  var priority$4 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$17, f$8, priority$4);
  var this$19 = $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().min__Lio_youi_hypertext_AbstractComponent$size$min$().height__Lreactify_Var();
  var f$10 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$9$1) {
    return (function(d$7$2) {
      var d$7 = $uD(d$7$2);
      this$9$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.minHeight = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$7]));
      var f$9 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$4) {
        return (function() {
          $f_Lio_youi_hypertext_Component__updateSize__V($this$4)
        })
      })(this$9$1));
      $f_Lio_youi_Updates__nextFrame__F0__V(this$9$1, f$9)
    })
  })($thiz));
  $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().min__Lio_youi_hypertext_AbstractComponent$size$min$().height__Lreactify_Var();
  var priority$5 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$19, f$10, priority$5);
  var this$21 = $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().max__Lio_youi_hypertext_AbstractComponent$size$max$().width__Lreactify_Var();
  var f$12 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$10$1) {
    return (function(d$8$2) {
      var d$8 = $uD(d$8$2);
      this$10$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.maxWidth = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$8]));
      var f$11 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$5) {
        return (function() {
          $f_Lio_youi_hypertext_Component__updateSize__V($this$5)
        })
      })(this$10$1));
      $f_Lio_youi_Updates__nextFrame__F0__V(this$10$1, f$11)
    })
  })($thiz));
  $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().max__Lio_youi_hypertext_AbstractComponent$size$max$().width__Lreactify_Var();
  var priority$6 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$21, f$12, priority$6);
  var this$23 = $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().max__Lio_youi_hypertext_AbstractComponent$size$max$().height__Lreactify_Var();
  var f$14 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$11$1) {
    return (function(d$9$2) {
      var d$9 = $uD(d$9$2);
      this$11$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.maxHeight = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$9]));
      var f$13 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$6) {
        return (function() {
          $f_Lio_youi_hypertext_Component__updateSize__V($this$6)
        })
      })(this$11$1));
      $f_Lio_youi_Updates__nextFrame__F0__V(this$11$1, f$13)
    })
  })($thiz));
  $thiz.size__Lio_youi_hypertext_AbstractComponent$size$().max__Lio_youi_hypertext_AbstractComponent$size$max$().height__Lreactify_Var();
  var priority$7 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$23, f$14, priority$7);
  $thiz.parent__Lreactify_State().attach__F1__D__Lreactify_Listener(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$12$1) {
    return (function(p$3$2) {
      $as_s_Option(p$3$2);
      var f$15 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$7) {
        return (function() {
          $f_Lio_youi_hypertext_Component__updateSize__V($this$7)
        })
      })(this$12$1));
      $f_Lio_youi_Updates__nextFrame__F0__V(this$12$1, f$15)
    })
  })($thiz)), $thiz.parent__Lreactify_State().attach$default$2__D());
  var this$25 = $thiz.rotation__Lreactify_Var();
  var f$16 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$13$1) {
    return (function(d$10$2) {
      $uD(d$10$2);
      $f_Lio_youi_hypertext_Component__updateTransform__V(this$13$1)
    })
  })($thiz));
  $thiz.rotation__Lreactify_Var();
  var priority$8 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$25, f$16, priority$8);
  var this$27 = $thiz.scale__Lio_youi_hypertext_AbstractComponent$scale$().x__Lreactify_Var();
  var f$17 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$14$1) {
    return (function(d$11$2) {
      $uD(d$11$2);
      $f_Lio_youi_hypertext_Component__updateTransform__V(this$14$1)
    })
  })($thiz));
  $thiz.scale__Lio_youi_hypertext_AbstractComponent$scale$().x__Lreactify_Var();
  var priority$9 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$27, f$17, priority$9);
  var this$29 = $thiz.scale__Lio_youi_hypertext_AbstractComponent$scale$().y__Lreactify_Var();
  var f$18 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$15$1) {
    return (function(d$12$2) {
      $uD(d$12$2);
      $f_Lio_youi_hypertext_Component__updateTransform__V(this$15$1)
    })
  })($thiz));
  $thiz.scale__Lio_youi_hypertext_AbstractComponent$scale$().y__Lreactify_Var();
  var priority$10 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$29, f$18, priority$10);
  var this$32 = $thiz.opacity__Lreactify_Var();
  var f$19 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$16$1) {
    return (function(d$13$2) {
      var d$13 = $uD(d$13$2);
      this$16$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.opacity = ("" + d$13)
    })
  })($thiz));
  $thiz.opacity__Lreactify_Var();
  var priority$11 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$32, f$19, priority$11);
  var this$34 = $thiz.visible__Lreactify_Var();
  var f$20 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$17$1) {
    return (function(b$2) {
      var b = $uZ(b$2);
      this$17$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.visibility = (b ? "visible" : "hidden")
    })
  })($thiz));
  $thiz.visible__Lreactify_Var();
  var priority$12 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$34, f$20, priority$12);
  var this$36 = $thiz.color__Lio_youi_hypertext_style_ColorProperties().red$1;
  var f$21 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$18$1) {
    return (function(d$14$2) {
      $uD(d$14$2);
      $f_Lio_youi_hypertext_Component__updateColor__V(this$18$1)
    })
  })($thiz));
  $thiz.color__Lio_youi_hypertext_style_ColorProperties();
  var priority$13 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$36, f$21, priority$13);
  var this$38 = $thiz.color__Lio_youi_hypertext_style_ColorProperties().green$1;
  var f$22 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$19$1) {
    return (function(d$15$2) {
      $uD(d$15$2);
      $f_Lio_youi_hypertext_Component__updateColor__V(this$19$1)
    })
  })($thiz));
  $thiz.color__Lio_youi_hypertext_style_ColorProperties();
  var priority$14 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$38, f$22, priority$14);
  var this$40 = $thiz.color__Lio_youi_hypertext_style_ColorProperties().blue$1;
  var f$23 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$20$1) {
    return (function(d$16$2) {
      $uD(d$16$2);
      $f_Lio_youi_hypertext_Component__updateColor__V(this$20$1)
    })
  })($thiz));
  $thiz.color__Lio_youi_hypertext_style_ColorProperties();
  var priority$15 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$40, f$23, priority$15);
  var this$42 = $thiz.color__Lio_youi_hypertext_style_ColorProperties().alpha$1;
  var f$24 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$21$1) {
    return (function(d$17$2) {
      $uD(d$17$2);
      $f_Lio_youi_hypertext_Component__updateColor__V(this$21$1)
    })
  })($thiz));
  $thiz.color__Lio_youi_hypertext_style_ColorProperties();
  var priority$16 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$42, f$24, priority$16);
  var this$44 = $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties().red$1;
  var f$25 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$22$1) {
    return (function(d$18$2) {
      $uD(d$18$2);
      $f_Lio_youi_hypertext_Component__updateBackgroundColor__V(this$22$1)
    })
  })($thiz));
  $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties();
  var priority$17 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$44, f$25, priority$17);
  var this$46 = $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties().green$1;
  var f$26 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$23$1) {
    return (function(d$19$2) {
      $uD(d$19$2);
      $f_Lio_youi_hypertext_Component__updateBackgroundColor__V(this$23$1)
    })
  })($thiz));
  $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties();
  var priority$18 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$46, f$26, priority$18);
  var this$48 = $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties().blue$1;
  var f$27 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$24$1) {
    return (function(d$20$2) {
      $uD(d$20$2);
      $f_Lio_youi_hypertext_Component__updateBackgroundColor__V(this$24$1)
    })
  })($thiz));
  $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties();
  var priority$19 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$48, f$27, priority$19);
  var this$50 = $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties().alpha$1;
  var f$28 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$25$1) {
    return (function(d$21$2) {
      $uD(d$21$2);
      $f_Lio_youi_hypertext_Component__updateBackgroundColor__V(this$25$1)
    })
  })($thiz));
  $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties();
  var priority$20 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$50, f$28, priority$20);
  var this$52 = $thiz.padding__Lio_youi_hypertext_AbstractComponent$padding$().left__Lreactify_Var();
  var f$29 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$26$1) {
    return (function(d$22$2) {
      var d$22 = $uD(d$22$2);
      this$26$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.paddingLeft = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$22]))
    })
  })($thiz));
  $thiz.padding__Lio_youi_hypertext_AbstractComponent$padding$().left__Lreactify_Var();
  var priority$21 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$52, f$29, priority$21);
  var this$54 = $thiz.padding__Lio_youi_hypertext_AbstractComponent$padding$().right__Lreactify_Var();
  var f$30 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$27$1) {
    return (function(d$23$2) {
      var d$23 = $uD(d$23$2);
      this$27$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.paddingRight = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$23]))
    })
  })($thiz));
  $thiz.padding__Lio_youi_hypertext_AbstractComponent$padding$().right__Lreactify_Var();
  var priority$22 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$54, f$30, priority$22);
  var this$56 = $thiz.padding__Lio_youi_hypertext_AbstractComponent$padding$().top__Lreactify_Var();
  var f$31 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$28$1) {
    return (function(d$24$2) {
      var d$24 = $uD(d$24$2);
      this$28$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.paddingTop = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$24]))
    })
  })($thiz));
  $thiz.padding__Lio_youi_hypertext_AbstractComponent$padding$().top__Lreactify_Var();
  var priority$23 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$56, f$31, priority$23);
  var this$58 = $thiz.padding__Lio_youi_hypertext_AbstractComponent$padding$().bottom__Lreactify_Var();
  var f$32 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$29$1) {
    return (function(d$25$2) {
      var d$25 = $uD(d$25$2);
      this$29$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.paddingBottom = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$25]))
    })
  })($thiz));
  $thiz.padding__Lio_youi_hypertext_AbstractComponent$padding$().bottom__Lreactify_Var();
  var priority$24 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$58, f$32, priority$24);
  var this$60 = $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().left__Lreactify_Var();
  var f$33 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$30$1) {
    return (function(d$26$2) {
      var d$26 = $uD(d$26$2);
      this$30$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.marginLeft = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$26]))
    })
  })($thiz));
  $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().left__Lreactify_Var();
  var priority$25 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$60, f$33, priority$25);
  var this$62 = $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().right__Lreactify_Var();
  var f$34 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$31$1) {
    return (function(d$27$2) {
      var d$27 = $uD(d$27$2);
      this$31$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.marginRight = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$27]))
    })
  })($thiz));
  $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().right__Lreactify_Var();
  var priority$26 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$62, f$34, priority$26);
  var this$64 = $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().top__Lreactify_Var();
  var f$35 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$32$1) {
    return (function(d$28$2) {
      var d$28 = $uD(d$28$2);
      this$32$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.marginTop = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$28]))
    })
  })($thiz));
  $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().top__Lreactify_Var();
  var priority$27 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$64, f$35, priority$27);
  var this$66 = $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().bottom__Lreactify_Var();
  var f$36 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$33$1) {
    return (function(d$29$2) {
      var d$29 = $uD(d$29$2);
      this$33$1.element__Lorg_scalajs_dom_raw_HTMLElement().style.marginBottom = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["", "px"])).s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([d$29]))
    })
  })($thiz));
  $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().bottom__Lreactify_Var();
  var priority$28 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$66, f$36, priority$28);
  $thiz.element__Lorg_scalajs_dom_raw_HTMLElement().addEventListener("scroll", (function(arg$outer) {
    return (function(arg1$2) {
      $f_Lio_youi_hypertext_Component__updateSize__V(arg$outer)
    })
  })($thiz));
  var this$68 = $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().vertical__Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$().position__Lreactify_Var();
  var f$37 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$34$1) {
    return (function(p$4$2) {
      var p$4 = $uD(p$4$2);
      if ((!this$34$1.io$youi$hypertext$Component$$updatingSize__Z())) {
        this$34$1.element__Lorg_scalajs_dom_raw_HTMLElement().scrollTop = p$4;
        $f_Lio_youi_hypertext_Component__updateSize__V(this$34$1)
      }
    })
  })($thiz));
  $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().vertical__Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$().position__Lreactify_Var();
  var priority$29 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$68, f$37, priority$29);
  var this$70 = $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().horizontal__Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$().position__Lreactify_Var();
  var f$38 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$35$1) {
    return (function(p$5$2) {
      var p$5 = $uD(p$5$2);
      if ((!this$35$1.io$youi$hypertext$Component$$updatingSize__Z())) {
        this$35$1.element__Lorg_scalajs_dom_raw_HTMLElement().scrollLeft = p$5;
        $f_Lio_youi_hypertext_Component__updateSize__V(this$35$1)
      }
    })
  })($thiz));
  $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().horizontal__Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$().position__Lreactify_Var();
  var priority$30 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$70, f$38, priority$30);
  var this$74 = $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().vertical__Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$().percentage__Lreactify_Var();
  var f$39 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$36$1) {
    return (function(p$6$2) {
      var p$6 = $uD(p$6$2);
      if ((!this$36$1.io$youi$hypertext$Component$$updatingSize__Z())) {
        var jsx$3 = this$36$1.element__Lorg_scalajs_dom_raw_HTMLElement();
        var this$71 = this$36$1.size__Lio_youi_hypertext_AbstractComponent$size$().inner__Lio_youi_hypertext_AbstractComponent$size$inner$().height$1;
        var jsx$2 = $uD(this$71.get__O());
        var this$72 = this$36$1.size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().height$1;
        jsx$3.scrollTop = ((jsx$2 - $uD(this$72.get__O())) * p$6);
        $f_Lio_youi_hypertext_Component__updateSize__V(this$36$1)
      }
    })
  })($thiz));
  $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().vertical__Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$().percentage__Lreactify_Var();
  var priority$31 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$74, f$39, priority$31);
  var this$78 = $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().horizontal__Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$().percentage__Lreactify_Var();
  var f$40 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$37$1) {
    return (function(p$7$2) {
      var p$7 = $uD(p$7$2);
      if ((!this$37$1.io$youi$hypertext$Component$$updatingSize__Z())) {
        var jsx$5 = this$37$1.element__Lorg_scalajs_dom_raw_HTMLElement();
        var this$75 = this$37$1.size__Lio_youi_hypertext_AbstractComponent$size$().inner__Lio_youi_hypertext_AbstractComponent$size$inner$().width$1;
        var jsx$4 = $uD(this$75.get__O());
        var this$76 = this$37$1.size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().width$1;
        jsx$5.scrollLeft = ((jsx$4 - $uD(this$76.get__O())) * p$7);
        $f_Lio_youi_hypertext_Component__updateSize__V(this$37$1)
      }
    })
  })($thiz));
  $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().horizontal__Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$().percentage__Lreactify_Var();
  var priority$32 = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(this$78, f$40, priority$32);
  if ((!$thiz.color__Lio_youi_hypertext_style_ColorProperties().isDefault__Z())) {
    $f_Lio_youi_hypertext_Component__updateColor__V($thiz)
  };
  if ((!$thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties().isDefault__Z())) {
    $f_Lio_youi_hypertext_Component__updateBackgroundColor__V($thiz)
  };
  $f_Lio_youi_hypertext_Component__updateSize__V($thiz)
}
function $f_Lio_youi_hypertext_Component__prop__F0__F1__Z__Lreactify_Var($thiz, get, set, mayCauseResize) {
  var v = $m_Lreactify_Var$().apply__F0__Z__Z__Z__Lreactify_Var(get, false, true, true);
  var f$1 = new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this, set$1, mayCauseResize$1) {
    return (function(value$2) {
      set$1.apply__O__O(value$2);
      if (mayCauseResize$1) {
        var f = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this$1) {
          return (function() {
            $f_Lio_youi_hypertext_Component__updateSize__V($this$1)
          })
        })($this));
        $f_Lio_youi_Updates__nextFrame__F0__V($this, f)
      }
    })
  })($thiz, set, mayCauseResize));
  var priority = $m_Lreactify_Listener$Priority$().Normal$1;
  $f_Lreactify_Observable__attach__F1__D__Lreactify_Listener(v, f$1, priority);
  return v
}
function $f_Lio_youi_hypertext_Component__updateBackgroundColor__V($thiz) {
  var jsx$4 = $m_Lio_youi_Color$();
  var this$1 = $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties().red$1;
  var jsx$3 = $uD(this$1.get__O());
  var this$2 = $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties().green$1;
  var jsx$2 = $uD(this$2.get__O());
  var this$3 = $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties().blue$1;
  var jsx$1 = $uD(this$3.get__O());
  var this$4 = $thiz.backgroundColor__Lio_youi_hypertext_style_ColorProperties().alpha$1;
  var css = jsx$4.toCSS__D__D__D__D__T(jsx$3, jsx$2, jsx$1, $uD(this$4.get__O()));
  $thiz.element__Lorg_scalajs_dom_raw_HTMLElement().style.backgroundColor = css
}
function $f_Lio_youi_hypertext_Component__updateSize__V($thiz) {
  if ((!$thiz.io$youi$hypertext$Component$$updatingSize__Z())) {
    $thiz.io$youi$hypertext$Component$$updatingSize$und$eq__Z__V(true);
    try {
      var this$1 = $thiz.actualWidth__Lreactify_Var();
      if (($uD(this$1.get__O()) !== $thiz.determineActualWidth__D())) {
        var this$2 = $thiz.actualWidth__Lreactify_Var();
        var value = $thiz.determineActualWidth__D();
        $c_Lreactify_AbstractState.prototype.setStatic__O__V.call(this$2, value)
      };
      var this$3 = $thiz.actualHeight__Lreactify_Var();
      if (($uD(this$3.get__O()) !== $thiz.determineActualHeight__D())) {
        var this$4 = $thiz.actualHeight__Lreactify_Var();
        var value$1 = $thiz.determineActualHeight__D();
        $c_Lreactify_AbstractState.prototype.setStatic__O__V.call(this$4, value$1)
      };
      var h = $as_Lreactify_Var($thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().horizontal__Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$().size__Lreactify_State());
      var v = $as_Lreactify_Var($thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().vertical__Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$().size__Lreactify_State());
      var value$2 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this) {
        return (function() {
          var jsx$3 = $uD($this.element__Lorg_scalajs_dom_raw_HTMLElement().offsetHeight);
          var jsx$2 = $uI($this.element__Lorg_scalajs_dom_raw_HTMLElement().clientHeight);
          var this$5 = $this.border__Lio_youi_hypertext_border_ComponentBorders().top__Lio_youi_hypertext_border_ComponentBorders$top$().size__Lreactify_Var();
          var this$6 = $as_s_Option(this$5.get__O());
          var jsx$1 = $uD((this$6.isEmpty__Z() ? 0.0 : this$6.get__O()));
          var this$7 = $this.border__Lio_youi_hypertext_border_ComponentBorders().bottom__Lio_youi_hypertext_border_ComponentBorders$bottom$().size__Lreactify_Var();
          var this$8 = $as_s_Option(this$7.get__O());
          var y = (((jsx$3 - jsx$2) - jsx$1) - $uD((this$8.isEmpty__Z() ? 0.0 : this$8.get__O())));
          return $uD($g.Math.max(0.0, y))
        })
      })($thiz));
      h.replace__F0__Z__V(value$2, true);
      var value$3 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$2$1) {
        return (function() {
          var jsx$6 = $uD(this$2$1.element__Lorg_scalajs_dom_raw_HTMLElement().offsetWidth);
          var jsx$5 = $uI(this$2$1.element__Lorg_scalajs_dom_raw_HTMLElement().clientWidth);
          var this$11 = this$2$1.border__Lio_youi_hypertext_border_ComponentBorders().left__Lio_youi_hypertext_border_ComponentBorders$left$().size__Lreactify_Var();
          var this$12 = $as_s_Option(this$11.get__O());
          var jsx$4 = $uD((this$12.isEmpty__Z() ? 0.0 : this$12.get__O()));
          var this$13 = this$2$1.border__Lio_youi_hypertext_border_ComponentBorders().right__Lio_youi_hypertext_border_ComponentBorders$right$().size__Lreactify_Var();
          var this$14 = $as_s_Option(this$13.get__O());
          var y$1 = (((jsx$6 - jsx$5) - jsx$4) - $uD((this$14.isEmpty__Z() ? 0.0 : this$14.get__O())));
          return $uD($g.Math.max(0.0, y$1))
        })
      })($thiz));
      v.replace__F0__Z__V(value$3, true);
      var this$17 = $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().horizontal__Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$().position__Lreactify_Var();
      var value$4 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$3$1) {
        return (function() {
          return $uD(this$3$1.element__Lorg_scalajs_dom_raw_HTMLElement().scrollLeft)
        })
      })($thiz));
      this$17.replace__F0__Z__V(value$4, true);
      var this$18 = $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().vertical__Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$().position__Lreactify_Var();
      var value$5 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$4$1) {
        return (function() {
          return $uD(this$4$1.element__Lorg_scalajs_dom_raw_HTMLElement().scrollTop)
        })
      })($thiz));
      this$18.replace__F0__Z__V(value$5, true);
      var this$19 = $thiz.innerWidth__Lreactify_Var();
      var value$6 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$5$1) {
        return (function() {
          return $uI(this$5$1.element__Lorg_scalajs_dom_raw_HTMLElement().scrollWidth)
        })
      })($thiz));
      this$19.replace__F0__Z__V(value$6, true);
      var this$20 = $thiz.innerHeight__Lreactify_Var();
      var value$7 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$6$1) {
        return (function() {
          return $uI(this$6$1.element__Lorg_scalajs_dom_raw_HTMLElement().scrollHeight)
        })
      })($thiz));
      this$20.replace__F0__Z__V(value$7, true);
      var this$24 = $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().vertical__Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$().percentage__Lreactify_Var();
      var value$8 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$7$1) {
        return (function() {
          $m_Lreactify_package$();
          var p = this$7$1.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().vertical__Lio_youi_hypertext_AbstractComponent$scrollbar$vertical$().position__Lreactify_Var();
          var jsx$8 = $uD(p.get__O());
          var this$22 = this$7$1.size__Lio_youi_hypertext_AbstractComponent$size$().inner__Lio_youi_hypertext_AbstractComponent$size$inner$().height$1;
          var jsx$7 = $uD(this$22.get__O());
          var this$23 = this$7$1.size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().height$1;
          return (jsx$8 / (jsx$7 - $uD(this$23.get__O())))
        })
      })($thiz));
      this$24.replace__F0__Z__V(value$8, true);
      var this$28 = $thiz.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().horizontal__Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$().percentage__Lreactify_Var();
      var value$9 = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function(this$8$1) {
        return (function() {
          $m_Lreactify_package$();
          var p$1 = this$8$1.scrollbar__Lio_youi_hypertext_AbstractComponent$scrollbar$().horizontal__Lio_youi_hypertext_AbstractComponent$scrollbar$horizontal$().position__Lreactify_Var();
          var jsx$10 = $uD(p$1.get__O());
          $m_Lreactify_package$();
          var p$2 = this$8$1.size__Lio_youi_hypertext_AbstractComponent$size$().inner__Lio_youi_hypertext_AbstractComponent$size$inner$().width$1;
          var jsx$9 = $uD(p$2.get__O());
          $m_Lreactify_package$();
          var p$3 = this$8$1.size__Lio_youi_hypertext_AbstractComponent$size$().actual__Lio_youi_hypertext_AbstractComponent$size$actual$().height$1;
          return (jsx$10 / (jsx$9 - $uD(p$3.get__O())))
        })
      })($thiz));
      this$28.replace__F0__Z__V(value$9, true)
    } finally {
      $thiz.io$youi$hypertext$Component$$updatingSize$und$eq__Z__V(false)
    }
  }
}
function $f_Lio_youi_hypertext_Component__determineActualHeight__D($thiz) {
  var jsx$2 = $uD($thiz.element__Lorg_scalajs_dom_raw_HTMLElement().offsetHeight);
  var this$1 = $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().top__Lreactify_Var();
  var jsx$1 = $uD(this$1.get__O());
  var this$2 = $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().bottom__Lreactify_Var();
  return ((jsx$2 + jsx$1) + $uD(this$2.get__O()))
}
function $f_Lio_youi_hypertext_Component__updateTransform__V($thiz) {
  $m_scm_ListBuffer$();
  var this$2 = new $c_scm_GrowingBuilder().init___scg_Growable(new $c_scm_ListBuffer().init___());
  var b = $as_scm_ListBuffer($as_sc_GenTraversable(this$2.elems$1));
  var this$3 = $thiz.rotation__Lreactify_Var();
  if (($uD(this$3.get__O()) !== 0.0)) {
    var jsx$1 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["rotate(", "deg)"]));
    var this$4 = $thiz.rotation__Lreactify_Var();
    b.$$plus$eq__O__scm_ListBuffer(jsx$1.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([(360.0 * $uD(this$4.get__O()))])))
  };
  var this$5 = $thiz.scale__Lio_youi_hypertext_AbstractComponent$scale$().x__Lreactify_Var();
  if (($uD(this$5.get__O()) !== 1.0)) {
    var jsx$2 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["scaleX(", ")"]));
    var this$6 = $thiz.scale__Lio_youi_hypertext_AbstractComponent$scale$().x__Lreactify_Var();
    b.$$plus$eq__O__scm_ListBuffer(jsx$2.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this$6.get__O()])))
  };
  var this$7 = $thiz.scale__Lio_youi_hypertext_AbstractComponent$scale$().y__Lreactify_Var();
  if (($uD(this$7.get__O()) !== 1.0)) {
    var jsx$3 = new $c_s_StringContext().init___sc_Seq(new $c_sjs_js_WrappedArray().init___sjs_js_Array(["scaleY(", ")"]));
    var this$8 = $thiz.scale__Lio_youi_hypertext_AbstractComponent$scale$().y__Lreactify_Var();
    b.$$plus$eq__O__scm_ListBuffer(jsx$3.s__sc_Seq__T(new $c_sjs_js_WrappedArray().init___sjs_js_Array([this$8.get__O()])))
  };
  var jsx$4 = $thiz.element__Lorg_scalajs_dom_raw_HTMLElement().style;
  var this$9 = b.scala$collection$mutable$ListBuffer$$start$6;
  jsx$4.transform = $f_sc_TraversableOnce__mkString__T__T__T__T(this$9, "", " ", "")
}
function $f_Lio_youi_hypertext_Component__updateColor__V($thiz) {
  var jsx$5 = $thiz.element__Lorg_scalajs_dom_raw_HTMLElement().style;
  var jsx$4 = $m_Lio_youi_Color$();
  var this$1 = $thiz.color__Lio_youi_hypertext_style_ColorProperties().red$1;
  var jsx$3 = $uD(this$1.get__O());
  var this$2 = $thiz.color__Lio_youi_hypertext_style_ColorProperties().green$1;
  var jsx$2 = $uD(this$2.get__O());
  var this$3 = $thiz.color__Lio_youi_hypertext_style_ColorProperties().blue$1;
  var jsx$1 = $uD(this$3.get__O());
  var this$4 = $thiz.color__Lio_youi_hypertext_style_ColorProperties().alpha$1;
  jsx$5.color = jsx$4.toCSS__D__D__D__D__T(jsx$3, jsx$2, jsx$1, $uD(this$4.get__O()))
}
function $f_Lio_youi_hypertext_Component__events__T__Z__Lreactify_Channel($thiz, eventType, stopPropagation) {
  var channel = new $c_Lreactify_Channel$$anon$1().init___();
  $thiz.element__Lorg_scalajs_dom_raw_HTMLElement().addEventListener(eventType, (function(arg$outer, stopPropagation$1, channel$1) {
    return (function(arg1$2) {
      $f_Lio_youi_hypertext_Component__io$youi$hypertext$Component$$$anonfun$events$1__Lorg_scalajs_dom_raw_Event__Z__Lreactify_Channel__V(arg$outer, arg1$2, stopPropagation$1, channel$1)
    })
  })($thiz, stopPropagation, channel));
  return channel
}
function $f_Lio_youi_hypertext_Component__determineActualWidth__D($thiz) {
  var jsx$2 = $uD($thiz.element__Lorg_scalajs_dom_raw_HTMLElement().offsetWidth);
  var this$1 = $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().left__Lreactify_Var();
  var jsx$1 = $uD(this$1.get__O());
  var this$2 = $thiz.margin__Lio_youi_hypertext_AbstractComponent$margin$().right__Lreactify_Var();
  return ((jsx$2 + jsx$1) + $uD(this$2.get__O()))
}
function $f_Lio_youi_hypertext_Component__io$youi$hypertext$Component$$$anonfun$events$1__Lorg_scalajs_dom_raw_Event__Z__Lreactify_Channel__V($thiz, evt, stopPropagation$1, channel$1) {
  if (stopPropagation$1) {
    evt.preventDefault();
    evt.stopPropagation()
  };
  var value = new $c_sjsr_AnonFunction0().init___sjs_js_Function0((function($this, evt$1) {
    return (function() {
      return evt$1
    })
  })($thiz, evt));
  channel$1.set__F0__V(value)
}
function $is_Lio_youi_hypertext_Component(obj) {
  return (!(!((obj && obj.$classData) && obj.$classData.ancestors.Lio_youi_hypertext_Component)))
}
function $as_Lio_youi_hypertext_Component(obj) {
  return (($is_Lio_youi_hypertext_Component(obj) || (obj === null)) ? obj : $throwClassCastException(obj, "io.youi.hypertext.Component"))
}
function $isArrayOf_Lio_youi_hypertext_Component(obj, depth) {
  return (!(!(((obj && obj.$classData) && (obj.$classData.arrayDepth === depth)) && obj.$classData.arrayBase.ancestors.Lio_youi_hypertext_Component)))
}
function $asArrayOf_Lio_youi_hypertext_Component(obj, depth) {
  return (($isArrayOf_Lio_youi_hypertext_Component(obj, depth) || (obj === null)) ? obj : $throwArrayCastException(obj, "Lio.youi.hypertext.Component;", depth))
}
/** @constructor */
function $c_Lio_youi_hypertext_style_EmptyImage$() {
  $c_O.call(this)
}
$c_Lio_youi_hypertext_style_EmptyImage$.prototype = new $h_O();
$c_Lio_youi_hypertext_style_EmptyImage$.prototype.constructor = $c_Lio_youi_hypertext_style_EmptyImage$;
/** @constructor */
function $h_Lio_youi_hypertext_style_EmptyImage$() {
  /*<skip>*/
}
$h_Lio_youi_hypertext_style_EmptyImage$.prototype = $c_Lio_youi_hypertext_style_EmptyImage$.prototype;
$c_Lio_youi_hypertext_style_EmptyImage$.prototype.init___ = (function() {
  return this
});
$c_Lio_youi_hypertext_style_EmptyImage$.prototype.src__T = (function() {
  return ""
});
var $d_Lio_youi_hypertext_style_EmptyImage$ = new $TypeData().initClass({
  Lio_youi_hypertext_style_EmptyImage$: 0
}, false, "io.youi.hypertext.style.EmptyImage$", {
  Lio_youi_hypertext_style_EmptyImage$: 1,
  O: 1,
  Lio_youi_hypertext_style_Image: 1
});
$c_Lio_youi_hypertext_style_EmptyImage$.prototype.$classData = $d_Lio_youi_hypertext_style_EmptyImage$;
var $n_Lio_youi_hypertext_style_EmptyImage$ = (void 0);
function $m_Lio_youi_hypertext_style_EmptyImage$() {
  if ((!$n_Lio_youi_hypertext_style_EmptyImage$)) {
    $n_Lio_youi_hypertext_style_EmptyImage$ = new $c_Lio_youi_hypertext_style_EmptyImage$().init___()
  };
  return $n_Lio_youi_hypertext_style_EmptyImage$
}
/** @constructor */
function $c_Lio_youi_style_ColorPaint() {
  $c_O.call(this);
  this.color$1 = null
}
$c_Lio_youi_style_ColorPaint.prototype = new $h_O();
$c_Lio_youi_style_ColorPaint.prototype.constructor = $c_Lio_youi_style_ColorPaint;
/** @constructor */
function $h_Lio_youi_style_ColorPaint() {
  /*<skip>*/
}
$h_Lio_youi_style_ColorPaint.prototype = $c_Lio_youi_style_ColorPaint.prototype;
$c_Lio_youi_style_ColorPaint.prototype.value__Lio_youi_component_Component__Lorg_scalajs_dom_raw_CanvasRenderingContext2D__sjs_js_UndefOr = (function(component, context) {
  var this$1 = this.color$1;
  var a = $m_Lio_youi_Color$().toHex__D__D__D__s_Option__Z__T(this$1.red$1, this$1.green$1, this$1.blue$1, $m_s_None$(), true);
  return a
});
$c_Lio_youi_style_ColorPaint.prototype.init___Lio_youi_Color = (function(color) {
  this.color$1 = color;
  return this
});
var $d_Lio_youi_style_ColorPaint = new $TypeData().initClass({
  Lio_youi_style_ColorPaint: 0
}, false, "io.youi.style.ColorPaint", {
  Lio_youi_style_ColorPaint: 1,
  O: 1,
  Lio_youi_style_Paint: 1
});
$c_Lio_youi_style_ColorPaint.prototype.$classData = $d_Lio_youi_style_ColorPaint;
/** @constructor */
function $c_Lio_youi_style_Theme$() {
  $c_Lio_youi_style_Theme.call(this)
}
$c_Lio_youi_style_Theme$.prototype = new $h_Lio_youi_style_Theme();
$c_Lio_youi_style_Theme$.prototype.constructor = $c_Lio_youi_style_Theme$;
/** @constructor */
function $h_Lio_youi_style_Theme$() {
  /*<skip>*/
}
$h_Lio_youi_style_Theme$.prototype = $c_Lio_youi_style_Theme$.prototype;
$c_Lio_youi_style_Theme$.prototype.init___ = (function() {
  $c_Lio_youi_style_Theme.prototype.init___.call(this);
  return this
});
var $d_Lio_youi_style_Theme$ = new $TypeData().initClass({
  Lio_youi_style_Theme$: 0
}, false, "io.youi.style.Theme$", {
  Lio_youi_style_Theme$: 1,
  Lio_youi_style_Theme: 1,
  O: 1
});
$c_Lio_youi_style_Theme$.prototype.$classData = $d_Lio_youi_style_Theme$;
var $n_Lio_youi_style_Theme$ = (void 0);
function $m_Lio_youi_style_Theme$() {
  if ((!$n_Lio_youi_style_Theme$)) {
    $n_Lio_youi_style_Theme$ = new $c_Lio_youi_style_Theme$().init___()
  };
  return $n_Lio_youi_style_Theme$
}
/** @constructor */
function $c_Lio_youi_workflow_Action() {
  $c_O.call(this);
  this.action$1 = null
}
$c_Lio_youi_workflow_Action.prototype = new $h_O();
$c_Lio_youi_workflow_Action.prototype.constructor = $c_Lio_youi_workflow_Action;
/** @constructor */
function $h_Lio_youi_workflow_Action() {
  /*<skip>*/
}
$h_Lio_youi_workflow_Action.prototype = $c_Lio_youi_workflow_Action.prototype;
$c_Lio_youi_workflow_Action.prototype.init___F0 = (function(action) {
  this.action$1 = action;
  return this
});
$c_Lio_youi_workflow_Action.prototype.run__s_concurrent_Future = (function() {
  return $as_s_concurrent_Future(this.action$1.apply__O())
});
$c_Lio_youi_workflow_Action.prototype.starting__V = (function() {
  /*<skip>*/
});
var $d_Lio_youi_workflow_Action = new $TypeData().initClass({
  Lio_youi_workflow_Action: 0
}, false, "io.youi.workflow.Action", {
  Lio_youi_workflow_Action: 1,
  O: 1,
  Lio_youi_workflow_Task: 1
});
$c_Lio_youi_workflow_Action.prototype.$classData = $d_Lio_youi_workflow_Action;
/** @constructor */
function $c_Lio_youi_workflow_ChainedTask() {
  $c_O.call(this);
  this.first$1 = null;
  this.second$1 = null
}
$c_Lio_youi_workflow_ChainedTask.prototype = new $h_O();
$c_Lio_youi_workflow_ChainedTask.prototype.constructor = $c_Lio_youi_workflow_ChainedTask;
/** @constructor */
function $h_Lio_youi_workflow_ChainedTask() {
  /*<skip>*/
}
$h_Lio_youi_workflow_ChainedTask.prototype = $c_Lio_youi_workflow_ChainedTask.prototype;
$c_Lio_youi_workflow_ChainedTask.prototype.run__s_concurrent_Future = (function() {
  var this$1 = this.first$1;
  return $f_Lio_youi_workflow_Task__start__s_concurrent_Future(this$1).flatMap__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function($this) {
    return (function(x$1$2) {
      $asUnit(x$1$2);
      var this$2 = $this.second$1;
      return $f_Lio_youi_workflow_Task__start__s_concurrent_Future(this$2)
    })
  })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
$c_Lio_youi_workflow_ChainedTask.prototype.starting__V = (function() {
  /*<skip>*/
});
$c_Lio_youi_workflow_ChainedTask.prototype.init___Lio_youi_workflow_Task__Lio_youi_workflow_Task = (function(first, second) {
  this.first$1 = first;
  this.second$1 = second;
  return this
});
var $d_Lio_youi_workflow_ChainedTask = new $TypeData().initClass({
  Lio_youi_workflow_ChainedTask: 0
}, false, "io.youi.workflow.ChainedTask", {
  Lio_youi_workflow_ChainedTask: 1,
  O: 1,
  Lio_youi_workflow_Task: 1
});
$c_Lio_youi_workflow_ChainedTask.prototype.$classData = $d_Lio_youi_workflow_ChainedTask;
function $f_Lio_youi_workflow_DurationTemporal__update__D__D__Lio_youi_workflow_Conclusion($thiz, delta, elapsed) {
  var this$1 = $thiz.time__s_concurrent_duration_FiniteDuration();
  var t = this$1.unit$2.toMillis__J__J(this$1.length$2);
  var lo = t.lo$2;
  var hi = t.hi$2;
  var duration = ($m_sjsr_RuntimeLong$().scala$scalajs$runtime$RuntimeLong$$toDouble__I__I__D(lo, hi) / 1000.0);
  var x = (elapsed / duration);
  var progress = $uD($g.Math.min(x, 1.0));
  $thiz.act__D__D__D__V(delta, elapsed, progress);
  return ((elapsed >= duration) ? $m_Lio_youi_workflow_Conclusion$Finished$() : $m_Lio_youi_workflow_Conclusion$Continue$())
}
/** @constructor */
function $c_Lio_youi_workflow_Parallel() {
  $c_O.call(this);
  this.tasks$1 = null
}
$c_Lio_youi_workflow_Parallel.prototype = new $h_O();
$c_Lio_youi_workflow_Parallel.prototype.constructor = $c_Lio_youi_workflow_Parallel;
/** @constructor */
function $h_Lio_youi_workflow_Parallel() {
  /*<skip>*/
}
$h_Lio_youi_workflow_Parallel.prototype = $c_Lio_youi_workflow_Parallel.prototype;
$c_Lio_youi_workflow_Parallel.prototype.run__s_concurrent_Future = (function() {
  var jsx$3 = $m_s_concurrent_Future$();
  var this$2 = this.tasks$1;
  var f = (function($this) {
    return (function(x$1$2) {
      var x$1 = $as_Lio_youi_workflow_Task(x$1$2);
      return $f_Lio_youi_workflow_Task__start__s_concurrent_Future(x$1)
    })
  })(this);
  var this$1 = $m_sci_List$();
  var bf = this$1.ReusableCBFInstance$2;
  if ((bf === $m_sci_List$().ReusableCBFInstance$2)) {
    if ((this$2 === $m_sci_Nil$())) {
      var jsx$2 = $m_sci_Nil$()
    } else {
      var arg1 = this$2.head__O();
      var h = new $c_sci_$colon$colon().init___O__sci_List(f(arg1), $m_sci_Nil$());
      var t = h;
      var rest = $as_sci_List(this$2.tail__O());
      while ((rest !== $m_sci_Nil$())) {
        var arg1$1 = rest.head__O();
        var nx = new $c_sci_$colon$colon().init___O__sci_List(f(arg1$1), $m_sci_Nil$());
        t.tl$5 = nx;
        t = nx;
        rest = $as_sci_List(rest.tail__O())
      };
      var jsx$2 = h
    }
  } else {
    var b = $f_sc_TraversableLike__builder$1__psc_TraversableLike__scg_CanBuildFrom__scm_Builder(this$2, bf);
    var these = this$2;
    while ((!these.isEmpty__Z())) {
      var arg1$2 = these.head__O();
      b.$$plus$eq__O__scm_Builder(f(arg1$2));
      these = $as_sci_List(these.tail__O())
    };
    var jsx$2 = b.result__O()
  };
  var jsx$1 = $as_sc_TraversableOnce(jsx$2);
  var this$3 = $m_sci_List$();
  return jsx$3.sequence__sc_TraversableOnce__scg_CanBuildFrom__s_concurrent_ExecutionContext__s_concurrent_Future(jsx$1, this$3.ReusableCBFInstance$2, $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext()).map__F1__s_concurrent_ExecutionContext__s_concurrent_Future(new $c_sjsr_AnonFunction1().init___sjs_js_Function1((function(this$2$1) {
    return (function(x$2$2) {
      $as_sci_List(x$2$2)
    })
  })(this)), $m_s_concurrent_ExecutionContext$Implicits$().global__s_concurrent_ExecutionContext())
});
$c_Lio_youi_workflow_Parallel.prototype.starting__V = (function() {
  /*<skip>*/
});
$c_Lio_youi_workflow_Parallel.prototype.init___sci_List = (function(tasks) {
  this.tasks$1 = tasks;
  return this
});
var $d_Lio_youi_workflow_Parallel = new $TypeData().initClass({
  Lio_youi_workflow_Parallel: 0
}, false, "io.youi.workflow.Parallel", {
  Lio_youi_workflow_Parallel: 1,
  O: 1,
  Lio_youi_workflow_Task: 1
});
$c_Lio_youi_workflow_Parallel.prototype.$classData = $d_Lio_youi_workflow_Parallel;
/** @constructor */
function $c_Lio_youi_workflow_Repeat() {
  $c_O.call(this);
  this.task$1 = null;
  this.times$1 = 0
}
$c_Lio_youi_workflow_Repeat.prototype = new $h_O();
$c_Lio_youi_workflow_Repeat.prototype.constructor = $c_Lio_youi_workflow_Repeat;
/** @constructor */
function $h_Lio_youi_workflow_Repeat() {
  /*<sk