/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.tools.ascii2svg;

import io.yupiik.tools.ascii2svg.Char;
import io.yupiik.tools.ascii2svg.Object;
import io.yupiik.tools.ascii2svg.Point;
import io.yupiik.tools.ascii2svg.json.BufferProvider;
import io.yupiik.tools.ascii2svg.json.JsonParser;
import io.yupiik.tools.ascii2svg.json.ObjectJsonCodec;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;

public class Canvas {
    static final BufferProvider BUFFER_PROVIDER = new BufferProvider(8096, 8);
    static final Pattern OBJ_TAG_RE = Pattern.compile("(\\d+)\\s*,\\s*(\\d+)$");
    private final char[] grid;
    private final int[] size;
    private final boolean[] visited;
    private final Object.List objects;
    private final Map<String, java.lang.Object> options;

    static Canvas newInstance(String data, int tabWidth, boolean noBlur) {
        Map<String, Map<String, String>> options = Map.of("__a2s__closed__options__", noBlur ? Map.of("fill", "#fff") : Map.of("fill", "#fff", "filter", "url(#dsFilter)"));
        String[] lines = (String[])Stream.of(data.split("\n")).map(it -> it.replace("\n", IntStream.range(0, tabWidth).mapToObj(i -> " ").collect(Collectors.joining()))).toArray(String[]::new);
        int[] size = new int[]{Stream.of(lines).mapToInt(String::length).max().orElse(0), lines.length};
        char[] grid = new char[size[0] * size[1]];
        boolean[] visited = new boolean[size[0] * size[1]];
        int y = 0;
        for (String line : lines) {
            int x;
            int padding = y * size[0];
            for (x = 0; x < line.length(); ++x) {
                grid[padding + x] = line.charAt(x);
            }
            if (line.length() < size[1]) {
                for (x = line.length(); x < size[1]; ++x) {
                    grid[padding + x] = 32;
                }
            }
            ++y;
        }
        Canvas from = new Canvas(grid, size, visited, new Object.List(new Object[0]), new HashMap<String, java.lang.Object>(options));
        Object[] found = from.findObjects();
        return new Canvas(from.grid(), from.size(), from.visited(), new Object.List(found), from.options());
    }

    private boolean isVisited(int x, int y) {
        return this.visited[y * this.size[0] + x];
    }

    private void visit(int x, int y) {
        this.visited[y * this.size[0] + x] = true;
    }

    private void unvisit(int x, int y) {
        int idx = y * this.size[0] + x;
        if (!this.visited[idx]) {
            throw new IllegalStateException("Can't unvisit a cell you didn't visit: #" + idx);
        }
        this.visited[idx] = false;
    }

    private boolean canLeft(int x) {
        return x > 0;
    }

    private boolean canRight(int x) {
        return x < this.size[0] - 1;
    }

    private boolean canUp(int y) {
        return y > 0;
    }

    private boolean canDown(int y) {
        return y < this.size[1] - 1;
    }

    private boolean canDiagonal(int x, int y) {
        return !(!this.canLeft(x) && !this.canRight(x) || !this.canUp(y) && !this.canDown(y));
    }

    private Point[] next(Point pos) {
        if (!this.isVisited(pos.x(), pos.y())) {
            throw new IllegalStateException("internal error; revisiting " + String.valueOf(pos));
        }
        AtomicReference out = new AtomicReference();
        Char ch = this.at(pos);
        if (ch.canHorizontal()) {
            Consumer<Point> nextHorizontal = p -> {
                if (!this.isVisited(p.x(), p.y()) && this.at((Point)p).canHorizontal()) {
                    Point[] current = (Point[])out.get();
                    out.set(this.append(current == null ? new Point[]{} : current, (Point)p));
                }
            };
            if (this.canLeft(pos.x())) {
                nextHorizontal.accept(new Point(pos.x() - 1, pos.y(), pos.hint()));
            }
            if (this.canRight(pos.x())) {
                nextHorizontal.accept(new Point(pos.x() + 1, pos.y(), pos.hint()));
            }
        }
        if (ch.canVertical()) {
            Consumer<Point> nextVertical = p -> {
                if (!this.isVisited(p.x(), p.y()) && this.at((Point)p).canVertical()) {
                    Point[] current = (Point[])out.get();
                    out.set(this.append(current == null ? new Point[]{} : current, (Point)p));
                }
            };
            if (this.canUp(pos.y())) {
                nextVertical.accept(new Point(pos.x(), pos.y() - 1, pos.hint()));
            }
            if (this.canDown(pos.y())) {
                nextVertical.accept(new Point(pos.x(), pos.y() + 1, pos.hint()));
            }
        }
        if (this.canDiagonal(pos.x(), pos.y())) {
            BiConsumer<Point, Point> nextDiagonal = (from, to) -> {
                if (!this.isVisited(to.x(), to.y()) && this.at((Point)to).canDiagonalFrom(this.at((Point)from))) {
                    Point[] current = (Point[])out.get();
                    out.set(this.append(current == null ? new Point[]{} : current, (Point)to));
                }
            };
            if (this.canUp(pos.y())) {
                if (this.canLeft(pos.x())) {
                    nextDiagonal.accept(pos, new Point(pos.x() - 1, pos.y() - 1, pos.hint()));
                }
                if (this.canRight(pos.x())) {
                    nextDiagonal.accept(pos, new Point(pos.x() + 1, pos.y() - 1, pos.hint()));
                }
            }
            if (this.canDown(pos.y())) {
                if (this.canLeft(pos.x())) {
                    nextDiagonal.accept(pos, new Point(pos.x() - 1, pos.y() + 1, pos.hint()));
                }
                if (this.canRight(pos.x())) {
                    nextDiagonal.accept(pos, new Point(pos.x() + 1, pos.y() + 1, pos.hint()));
                }
            }
        }
        return (Point[])out.get();
    }

    private Object.List scanPath(Point[] points) {
        Point cur = points[points.length - 1];
        Point[] next = this.next(cur);
        if (next == null || next.length == 0) {
            if (points.length == 1) {
                this.unvisit(cur.x(), cur.y());
                return null;
            }
            Object o = new Object(points, null, false, false, false, false, null, null).seal(this);
            return new Object.List(new Object[]{o});
        }
        if (cur.x() == points[0].x() && cur.y() == points[0].y() + 1) {
            Object[] out = new Object[]{new Object(points, null, false, false, false, false, null, null).seal(this)};
            Object.List list = this.scanPath(new Point[]{cur});
            if (list != null) {
                for (Object it : list.value()) {
                    out = this.append(out, it);
                }
            }
            return new Object.List(out);
        }
        Object[] objs = null;
        for (Point n : next) {
            if (this.isVisited(n.x(), n.y())) continue;
            this.visit(n.x(), n.y());
            Point[] p2 = new Point[points.length + 1];
            System.arraycopy(points, 0, p2, 0, points.length);
            p2[p2.length - 1] = n;
            Object.List list = this.scanPath(p2);
            if (list == null) continue;
            for (Object it : list.value()) {
                objs = this.append(objs == null ? new Object[]{} : objs, it);
            }
        }
        return objs == null ? null : new Object.List(objs);
    }

    public Object.List enclosingObjects(Object[] objects, Point p) {
        int[] maxTL = new int[]{-1, -1};
        Object[] q = null;
        for (Object o : objects) {
            if (!o.isClosed() || !o.hasPoint(p) || o.corners()[0].x() <= maxTL[0] || o.corners()[0].y() <= maxTL[1]) continue;
            q = this.append(q == null ? new Object[]{} : q, o);
            maxTL[0] = o.corners()[0].x();
            maxTL[1] = o.corners()[0].y();
        }
        return q == null ? null : new Object.List(q);
    }

    private Object scanText(Object[] objects, int x, int y) {
        String t;
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(x, y, null));
        int whiteSpaceStreak = 0;
        int[] cur = new int[]{x, y};
        int tagged = 0;
        char[] tag = new char[]{};
        char[] tagDef = new char[]{};
        while (this.canRight(cur[0])) {
            Char ch;
            if (cur[0] == x && this.at(cur[0], cur[1]).isObjectStartTag()) {
                ++tagged;
            } else if (cur[0] > x && this.at(cur[0], cur[1]).isObjectEndTag()) {
                ++tagged;
            }
            cur[0] = cur[0] + 1;
            if (this.isVisited(cur[0], cur[1]) && (tagDef.length == 0 || tagDef[tagDef.length - 1] == '}') || !(ch = this.at(cur[0], cur[1])).isTextCont()) break;
            if (tagged == 0 && ch.isSpace()) {
                if (++whiteSpaceStreak > 2) {
                    break;
                }
            } else {
                whiteSpaceStreak = 0;
            }
            switch (tagged) {
                case 1: {
                    if (this.at(cur[0], cur[1]).isObjectEndTag()) break;
                    tag = this.append(tag, ch.value());
                    break;
                }
                case 2: {
                    if (this.at(cur[0], cur[1]).isTagDefinitionSeparator()) {
                        ++tagged;
                        break;
                    }
                    tagged = -1;
                    break;
                }
                case 3: {
                    tagDef = this.append(tagDef, ch.value());
                    break;
                }
            }
            points.add(new Point(cur[0], cur[1], null));
        }
        if (tagged == 2 || tagged < 0 && tag.length > 0) {
            t = new String(tag);
            Object.List container = this.enclosingObjects(objects, new Point(x, y, null));
            if (container != null && container.value().length > 0) {
                Object from = container.value()[0];
                int idx = List.of(objects).indexOf(from);
                objects[idx] = new Object(from.points(), from.corners(), from.isText(), from.isTagDefinition(), from.isClosed(), from.isDashed(), from.text(), t);
            }
        } else if (tagged == 3) {
            t = new String(tag);
            Matcher matcher = OBJ_TAG_RE.matcher(t);
            if (matcher.matches()) {
                int targetX = Integer.parseInt(matcher.group(1), 10);
                int targetY = Integer.parseInt(matcher.group(2), 10);
                int idx = 0;
                for (Object o : objects) {
                    Point corner = o.corners()[0];
                    if (corner.x() == targetX && corner.y() == targetY) {
                        objects[idx] = new Object(o.points(), o.corners(), o.isText(), o.isTagDefinition(), o.isClosed(), o.isDashed(), o.text(), new String(tag));
                        break;
                    }
                    ++idx;
                }
            }
            String jsonValue = new String(tagDef).strip();
            try (JsonParser json = new JsonParser(new StringReader(jsonValue), BUFFER_PROVIDER);){
                Map m = (Map)new ObjectJsonCodec().read(json);
                tag = t.toCharArray();
                this.options().put(t, m);
            }
            catch (IOException | RuntimeException e) {
                throw new IllegalArgumentException("Can't read json: '" + jsonValue + "' (" + x + "," + y + ")", e);
            }
        }
        while (!points.isEmpty() && this.at((Point)points.get(points.size() - 1)).isSpace()) {
            points.remove(points.size() - 1);
        }
        return new Object((Point[])points.toArray(Point[]::new), null, true, tagDef.length > 0, false, false, null, new String(tag)).seal(this);
    }

    private <T> T[] append(T[] collector, T value, IntFunction<T[]> allocator) {
        T[] out = allocator.apply(collector.length + 1);
        System.arraycopy(collector, 0, out, 0, collector.length);
        out[collector.length] = value;
        return out;
    }

    private char[] append(char[] src, char value) {
        char[] out = new char[src.length + 1];
        System.arraycopy(src, 0, out, 0, src.length);
        out[src.length] = value;
        return out;
    }

    private Object[] append(Object[] src, Object value) {
        return this.append(src, value, Object[]::new);
    }

    private Point[] append(Point[] src, Point value) {
        return this.append(src, value, Point[]::new);
    }

    private Object[] findObjects() {
        Char ch;
        int x;
        int y;
        Object[] objects = this.objects().value();
        for (y = 0; y < this.size[1]; ++y) {
            for (x = 0; x < this.size[0]; ++x) {
                if (this.isVisited(x, y) || !(ch = this.at(x, y)).isPathStart()) continue;
                this.visit(x, y);
                Object.List objs = this.scanPath(new Point[]{new Point(x, y, null)});
                if (objs == null) continue;
                for (Object object : objs.value()) {
                    for (Point p : object.points()) {
                        this.visit(p.x(), p.y());
                    }
                }
                for (Object object : objs.value()) {
                    objects = this.append(objects, object);
                }
            }
        }
        for (y = 0; y < this.size[1]; ++y) {
            for (x = 0; x < this.size[0]; ++x) {
                Object obj;
                if (this.isVisited(x, y) || !(ch = this.at(x, y)).isTextStart() || (obj = this.scanText(objects, x, y)) == null) continue;
                for (Point point : obj.points()) {
                    this.visit(point.x(), point.y());
                }
                objects = this.append(objects, obj);
            }
        }
        return (Object[])Stream.of(objects).sorted().toArray(Object[]::new);
    }

    public Char at(Point p) {
        return this.at(p.x(), p.y());
    }

    public Char at(int x, int y) {
        return new Char(this.grid[y * this.size[0] + x]);
    }

    @Generated
    public Canvas(char[] grid, int[] size, boolean[] visited, Object.List objects, Map<String, java.lang.Object> options) {
        this.grid = grid;
        this.size = size;
        this.visited = visited;
        this.objects = objects;
        this.options = options;
    }

    @Generated
    public char[] grid() {
        return this.grid;
    }

    @Generated
    public int[] size() {
        return this.size;
    }

    @Generated
    public boolean[] visited() {
        return this.visited;
    }

    @Generated
    public Object.List objects() {
        return this.objects;
    }

    @Generated
    public Map<String, java.lang.Object> options() {
        return this.options;
    }

    @Generated
    public boolean equals(java.lang.Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Canvas)) {
            return false;
        }
        Canvas other = (Canvas)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.grid(), other.grid())) {
            return false;
        }
        if (!Arrays.equals(this.size(), other.size())) {
            return false;
        }
        if (!Arrays.equals(this.visited(), other.visited())) {
            return false;
        }
        Object.List this$objects = this.objects();
        Object.List other$objects = other.objects();
        if (this$objects == null ? other$objects != null : !((java.lang.Object)this$objects).equals(other$objects)) {
            return false;
        }
        Map<String, java.lang.Object> this$options = this.options();
        Map<String, java.lang.Object> other$options = other.options();
        return !(this$options == null ? other$options != null : !((java.lang.Object)this$options).equals(other$options));
    }

    @Generated
    protected boolean canEqual(java.lang.Object other) {
        return other instanceof Canvas;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.grid());
        result = result * 59 + Arrays.hashCode(this.size());
        result = result * 59 + Arrays.hashCode(this.visited());
        Object.List $objects = this.objects();
        result = result * 59 + ($objects == null ? 43 : ((java.lang.Object)$objects).hashCode());
        Map<String, java.lang.Object> $options = this.options();
        result = result * 59 + ($options == null ? 43 : ((java.lang.Object)$options).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Canvas(grid=" + Arrays.toString(this.grid()) + ", size=" + Arrays.toString(this.size()) + ", visited=" + Arrays.toString(this.visited()) + ", objects=" + String.valueOf(this.objects()) + ", options=" + String.valueOf(this.options()) + ")";
    }
}

