/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.tools.ascii2svg;

import lombok.Generated;

public class Char {
    private final char value;

    public boolean isObjectStartTag() {
        return this.value == '[';
    }

    public boolean isObjectEndTag() {
        return this.value == ']';
    }

    public boolean isTagDefinitionSeparator() {
        return this.value == ':';
    }

    public boolean isTextStart() {
        return this.isObjectStartTag() || Character.isLetter(this.value) || Character.isDigit(this.value) || Character.getType(this.value) == 28;
    }

    public boolean isTextCont() {
        Character.UnicodeBlock unicode = Character.UnicodeBlock.of(this.value);
        return !Character.isISOControl(this.value) && this.value != '\uffff' && unicode != null && unicode != Character.UnicodeBlock.SPECIALS;
    }

    public boolean isSpace() {
        return Character.isSpaceChar(this.value);
    }

    public boolean isPathStart() {
        return (this.isCorner() || this.isHorizontal() || this.isVertical() || this.isArrowHorizontalLeft() || this.isArrowVerticalUp() || this.isDiagonal()) && !this.isTick() && !this.isDot();
    }

    public boolean isCorner() {
        return this.value == '.' || this.value == '\'' || this.value == '+';
    }

    public boolean isRoundedCorner() {
        return this.value == '.' || this.value == '\'';
    }

    public boolean isDashedHorizontal() {
        return this.value == '=';
    }

    public boolean isHorizontal() {
        return this.isDashedHorizontal() || this.isTick() || this.isDot() || this.value == '-';
    }

    public boolean isDashedVertical() {
        return this.value == ':';
    }

    public boolean isVertical() {
        return this.isDashedVertical() || this.isTick() || this.isDot() || this.value == '|';
    }

    public boolean isDashed() {
        return this.isDashedHorizontal() || this.isDashedVertical();
    }

    public boolean isArrowHorizontalLeft() {
        return this.value == '<';
    }

    public boolean isArrowHorizontal() {
        return this.isArrowHorizontalLeft() || this.value == '>';
    }

    public boolean isArrowVerticalUp() {
        return this.value == '^';
    }

    public boolean isArrowVertical() {
        return this.isArrowVerticalUp() || this.value == 'v';
    }

    public boolean isArrow() {
        return this.isArrowHorizontal() || this.isArrowVertical();
    }

    public boolean isDiagonalNorthEast() {
        return this.value == '/';
    }

    public boolean isDiagonalSouthEast() {
        return this.value == '\\';
    }

    public boolean isDiagonal() {
        return this.isDiagonalNorthEast() || this.isDiagonalSouthEast();
    }

    public boolean isTick() {
        return this.value == 'x';
    }

    public boolean isDot() {
        return this.value == 'o';
    }

    public boolean canDiagonalFrom(Char from) {
        if (from.isArrowVertical() || from.isCorner()) {
            return this.isDiagonal();
        }
        if (from.isDiagonal()) {
            return this.isDiagonal() || this.isCorner() || this.isArrowVertical() || this.isHorizontal() || this.isVertical();
        }
        if (from.isHorizontal() || from.isVertical()) {
            return this.isDiagonal();
        }
        return false;
    }

    public boolean canHorizontal() {
        return this.isHorizontal() || this.isCorner() || this.isArrowHorizontal();
    }

    public boolean canVertical() {
        return this.isVertical() || this.isCorner() || this.isArrowVertical();
    }

    @Generated
    public Char(char value) {
        this.value = value;
    }

    @Generated
    public char value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Char)) {
            return false;
        }
        Char other = (Char)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.value() == other.value();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Char;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.value();
        return result;
    }

    @Generated
    public String toString() {
        return "Char(value=" + this.value() + ")";
    }
}

