/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.tools.ascii2svg;

import java.util.stream.IntStream;

public class Color {
    private final String c;

    public Color(String c) {
        this.c = c;
    }

    public int[] parseHexColor() {
        switch (this.c.length()) {
            case 3: {
                return new int[]{Integer.parseInt(this.c.substring(0, 1), 16) * 17, Integer.parseInt(this.c.substring(1, 2), 16) * 17, Integer.parseInt(this.c.substring(2, 3), 16) * 17};
            }
            case 6: {
                return new int[]{Integer.parseInt(this.c.substring(0, 2), 16), Integer.parseInt(this.c.substring(2, 4), 16), Integer.parseInt(this.c.substring(4, 6), 16)};
            }
        }
        throw new IllegalArgumentException("unknown color: '" + this.c + "'");
    }

    public int[] colorToRGB() {
        if (this.c.charAt(0) == '#') {
            return new Color(this.c.substring(1)).parseHexColor();
        }
        throw new IllegalArgumentException("unknown color type: '" + this.c + "'");
    }

    public String textColor() {
        int[] rgb = new Color(this.c).colorToRGB();
        int brightness = (rgb[0] * 299 + rgb[1] * 587 + rgb[2] * 114) / 1000;
        int difference = IntStream.of(rgb).sum();
        if (brightness < 125 && difference < 500) {
            return "#fff";
        }
        return "#000";
    }
}

