/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.tools.ascii2svg;

import io.yupiik.tools.ascii2svg.Canvas;
import io.yupiik.tools.ascii2svg.Point;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;

public class Object
implements Comparable<Object> {
    private final Point[] points;
    private final Point[] corners;
    private final boolean isText;
    private final boolean isTagDefinition;
    private final boolean isClosed;
    private final boolean isDashed;
    private final char[] text;
    private final String tag;

    public boolean hasPoint(Point p) {
        boolean hasPoint = false;
        int ncorners = this.corners.length;
        int j = ncorners - 1;
        int i = 0;
        while (i < ncorners) {
            if ((this.corners[i].y() < p.y() && this.corners[j].y() >= p.y() || this.corners[j].y() < p.y() && this.corners[i].y() >= p.y()) && (this.corners[i].x() <= p.x() || this.corners[j].x() <= p.x()) && this.corners[i].x() + (p.y() - this.corners[i].y()) / (this.corners[j].y() - this.corners[i].y()) * (this.corners[j].x() - this.corners[i].x()) < p.x()) {
                hasPoint = !hasPoint;
            }
            j = i++;
        }
        return hasPoint;
    }

    public Object seal(Canvas c) {
        Point[] points = (Point[])Stream.of(this.points()).toArray(Point[]::new);
        char[] text = new char[this.points().length];
        if (c.at(points[0]).isArrow()) {
            points[0] = new Point(points[0].x(), points[0].y(), Point.Hint.START_MARKER);
        }
        if (c.at(points[points.length - 1]).isArrow()) {
            points[points.length - 1] = new Point(points[points.length - 1].x(), points[points.length - 1].y(), Point.Hint.END_MARKER);
        }
        PointState cornersAndClosed = this.pointsToCorners(points);
        int i = 0;
        boolean isDashed = false;
        for (Point p : points) {
            if (!this.isText()) {
                if (c.at(p).isTick()) {
                    points[i] = new Point(p.x(), p.y(), Point.Hint.TICK);
                } else if (c.at(p).isDot()) {
                    points[i] = new Point(p.x(), p.y(), Point.Hint.DOT);
                }
                if (c.at(p).isDashed()) {
                    isDashed = true;
                }
                for (Point corner : cornersAndClosed.points()) {
                    if (corner.x() != p.x() || corner.y() != p.y() || !c.at(p).isRoundedCorner()) continue;
                    points[i] = new Point(p.x(), p.y(), Point.Hint.ROUNDED_CORNER);
                }
            }
            text[i] = c.at(p).value();
            ++i;
        }
        return new Object(points, cornersAndClosed.points(), this.isText, this.isTagDefinition, cornersAndClosed.closed(), isDashed, text, this.tag);
    }

    public PointState pointsToCorners(Point[] points) {
        if (points.length < 3) {
            return new PointState(points, false);
        }
        AtomicReference<Point[]> out = new AtomicReference<Point[]>(new Point[]{points[0]});
        AtomicReference<Dir> dir = new AtomicReference<Dir>(Dir.NONE);
        if (points[0].isHorizontal(points[1])) {
            dir.set(Dir.H);
        } else if (points[0].isVertical(points[1])) {
            dir.set(Dir.V);
        } else if (points[0].isDiagonalSE(points[1])) {
            dir.set(Dir.SE);
        } else if (points[0].isDiagonalSW(points[1])) {
            dir.set(Dir.SW);
        } else if (points[0].isDiagonalNW(points[1])) {
            dir.set(Dir.NW);
        } else if (points[0].isDiagonalNE(points[1])) {
            dir.set(Dir.NE);
        } else {
            throw new IllegalArgumentException("discontiguous points: " + String.valueOf(java.util.List.of(points)));
        }
        for (int i = 2; i < points.length; ++i) {
            BiConsumer<Integer, Dir> cornerFunc = (idx, newDir) -> {
                if (dir.get() != newDir) {
                    out.set((Point[])Stream.concat(Stream.of((Point[])out.get()), Stream.of(points[idx - 1])).toArray(Point[]::new));
                    dir.set((Dir)((java.lang.Object)newDir));
                }
            };
            if (points[i - 1].isHorizontal(points[i])) {
                cornerFunc.accept(i, Dir.H);
                continue;
            }
            if (points[i - 1].isVertical(points[i])) {
                cornerFunc.accept(i, Dir.V);
                continue;
            }
            if (points[i - 1].isDiagonalSE(points[i])) {
                cornerFunc.accept(i, Dir.SE);
                continue;
            }
            if (points[i - 1].isDiagonalSW(points[i])) {
                cornerFunc.accept(i, Dir.SW);
                continue;
            }
            if (points[i - 1].isDiagonalNW(points[i])) {
                cornerFunc.accept(i, Dir.NW);
                continue;
            }
            if (points[i - 1].isDiagonalNE(points[i])) {
                cornerFunc.accept(i, Dir.NE);
                continue;
            }
            throw new IllegalArgumentException("discontiguous points: " + String.valueOf(java.util.List.of(points)));
        }
        Point last = points[points.length - 1];
        AtomicBoolean closed = new AtomicBoolean(true);
        Consumer<Dir> closedFunc = newDir -> {
            if (dir.get() != newDir) {
                closed.set(false);
                out.set((Point[])Stream.concat(Stream.of((Point[])out.get()), Stream.of(last)).toArray(Point[]::new));
            }
        };
        if (points[0].isHorizontal(last)) {
            closedFunc.accept(Dir.H);
        } else if (points[0].isVertical(last)) {
            closedFunc.accept(Dir.V);
        } else if (last.isDiagonalNE(points[0])) {
            closedFunc.accept(Dir.NE);
        } else {
            closed.set(false);
            out.set((Point[])Stream.concat(Stream.of(out.get()), Stream.of(last)).toArray(Point[]::new));
        }
        return new PointState(out.get(), closed.get());
    }

    @Override
    public int compareTo(Object o) {
        if (this.isText() != o.isText()) {
            return this.isText() ? 1 : -1;
        }
        int topDiff = this.points()[0].y() - o.points()[0].y();
        if (topDiff != 0) {
            return topDiff;
        }
        return this.points()[0].x() - o.points()[0].x();
    }

    public boolean isTagDefinition() {
        return this.isTagDefinition;
    }

    @Generated
    public Object(Point[] points, Point[] corners, boolean isText, boolean isTagDefinition, boolean isClosed, boolean isDashed, char[] text, String tag) {
        this.points = points;
        this.corners = corners;
        this.isText = isText;
        this.isTagDefinition = isTagDefinition;
        this.isClosed = isClosed;
        this.isDashed = isDashed;
        this.text = text;
        this.tag = tag;
    }

    @Generated
    public Point[] points() {
        return this.points;
    }

    @Generated
    public Point[] corners() {
        return this.corners;
    }

    @Generated
    public boolean isText() {
        return this.isText;
    }

    @Generated
    public boolean isClosed() {
        return this.isClosed;
    }

    @Generated
    public boolean isDashed() {
        return this.isDashed;
    }

    @Generated
    public char[] text() {
        return this.text;
    }

    @Generated
    public String tag() {
        return this.tag;
    }

    @Generated
    public boolean equals(java.lang.Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Object)) {
            return false;
        }
        Object other = (Object)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.text(), other.text())) {
            return false;
        }
        if (this.isTagDefinition() != other.isTagDefinition()) {
            return false;
        }
        if (this.isClosed() != other.isClosed()) {
            return false;
        }
        if (this.isDashed() != other.isDashed()) {
            return false;
        }
        if (!Arrays.deepEquals(this.points(), other.points())) {
            return false;
        }
        if (!Arrays.deepEquals(this.corners(), other.corners())) {
            return false;
        }
        if (!Arrays.equals(this.text(), other.text())) {
            return false;
        }
        String this$tag = this.tag();
        String other$tag = other.tag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    @Generated
    protected boolean canEqual(java.lang.Object other) {
        return other instanceof Object;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.text());
        result = result * 59 + (this.isTagDefinition() ? 79 : 97);
        result = result * 59 + (this.isClosed() ? 79 : 97);
        result = result * 59 + (this.isDashed() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.points());
        result = result * 59 + Arrays.deepHashCode(this.corners());
        result = result * 59 + Arrays.hashCode(this.text());
        String $tag = this.tag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Object(points=" + Arrays.deepToString(this.points()) + ", corners=" + Arrays.deepToString(this.corners()) + ", isText=" + Arrays.toString(this.text()) + ", isTagDefinition=" + this.isTagDefinition() + ", isClosed=" + this.isClosed() + ", isDashed=" + this.isDashed() + ", text=" + Arrays.toString(this.text()) + ", tag=" + this.tag() + ")";
    }

    public static class PointState {
        private final Point[] points;
        private final boolean closed;

        @Generated
        public PointState(Point[] points, boolean closed) {
            this.points = points;
            this.closed = closed;
        }

        @Generated
        public Point[] points() {
            return this.points;
        }

        @Generated
        public boolean closed() {
            return this.closed;
        }

        @Generated
        public boolean equals(java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PointState)) {
                return false;
            }
            PointState other = (PointState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.closed() != other.closed()) {
                return false;
            }
            return Arrays.deepEquals(this.points(), other.points());
        }

        @Generated
        protected boolean canEqual(java.lang.Object other) {
            return other instanceof PointState;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.closed() ? 79 : 97);
            result = result * 59 + Arrays.deepHashCode(this.points());
            return result;
        }

        @Generated
        public String toString() {
            return "Object.PointState(points=" + Arrays.deepToString(this.points()) + ", closed=" + this.closed() + ")";
        }
    }

    public static enum Dir {
        NONE,
        H,
        V,
        SE,
        SW,
        NW,
        NE;

    }

    public static class List {
        private final Object[] value;

        @Generated
        public List(Object[] value) {
            this.value = value;
        }

        @Generated
        public Object[] value() {
            return this.value;
        }

        @Generated
        public boolean equals(java.lang.Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            List other = (List)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.value(), other.value());
        }

        @Generated
        protected boolean canEqual(java.lang.Object other) {
            return other instanceof List;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.value());
            return result;
        }

        @Generated
        public String toString() {
            return "Object.List(value=" + Arrays.deepToString(this.value()) + ")";
        }
    }
}

