/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.tools.ascii2svg;

import io.yupiik.tools.ascii2svg.Canvas;
import io.yupiik.tools.ascii2svg.Color;
import io.yupiik.tools.ascii2svg.Object;
import io.yupiik.tools.ascii2svg.Point;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class Svg {
    public String convert(String text, int tabWidth, boolean noBlur, String font, int scaleX, int scaleY) {
        return this.convert(Canvas.newInstance(text, tabWidth, noBlur), noBlur, font, scaleX, scaleY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String convert(Canvas c, boolean noBlur, String font, int scaleX, int scaleY) {
        float[] sp;
        String s;
        java.lang.Object link;
        String endLink;
        StringBuilder result = new StringBuilder().append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n").append("<svg width=\"").append((c.size()[0] + 1) * scaleX).append("px\" height=\"").append((c.size()[1] + 1) * scaleY).append("px\" ").append("version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n").append("<defs>\n    <filter id=\"dsFilter\" width=\"150%\" height=\"150%\">\n      <feOffset result=\"offOut\" in=\"SourceGraphic\" dx=\"2\" dy=\"2\"/>\n      <feColorMatrix result=\"matrixOut\" in=\"offOut\" type=\"matrix\" values=\"0.2 0 0 0 0 0 0.2 0 0 0 0 0 0.2 0 0 0 0 0 1 0\"/>\n      <feGaussianBlur result=\"blurOut\" in=\"matrixOut\" stdDeviation=\"3\"/>\n      <feBlend in=\"SourceGraphic\" in2=\"blurOut\" mode=\"normal\"/>\n    </filter>\n    <marker id=\"iPointer\"\n      viewBox=\"0 0 10 10\" refX=\"5\" refY=\"5\"\n      markerUnits=\"strokeWidth\"\n      markerWidth=\"").append(scaleX - 1).append("\" markerHeight=\"").append(scaleY - 1).append("\"\n").append("    orient=\"auto\">\n").append("    <path d=\"M 10 0 L 10 10 L 0 5 z\" />\n").append("  </marker>\n").append("  <marker id=\"Pointer\"\n").append("    viewBox=\"0 0 10 10\" refX=\"5\" refY=\"5\"\n").append("    markerUnits=\"strokeWidth\"\n").append("    markerWidth=\"").append(scaleX - 1).append("\" markerHeight=\"").append(scaleY - 1).append("\"\n").append("    orient=\"auto\">\n").append("    <path d=\"M 0 0 L 10 5 L 0 10 z\" />\n").append("  </marker>\n").append("</defs>");
        Function<String, String> getOpts = tag -> {
            java.lang.Object value = c.options().get(tag);
            if (value == null) {
                return "";
            }
            if (value instanceof Map) {
                Map casted = (Map)value;
                return casted.entrySet().stream().filter(Predicate.not(it -> ((String)it.getKey()).startsWith("a2s:"))).map(it -> (String)it.getKey() + "=\"" + String.valueOf(it.getValue()) + "\"").collect(Collectors.joining(" "));
            }
            return value.toString();
        };
        if (noBlur) {
            result.append("  <g id=\"closed\" stroke=\"#000\" stroke-width=\"2\" fill=\"none\">\n");
        } else {
            result.append("  <g id=\"closed\" filter=\"url(#dsFilter)\" stroke=\"#000\" stroke-width=\"2\" fill=\"none\">\n");
        }
        int i = 0;
        for (Object obj : c.objects().value()) {
            if (obj.isClosed() && !obj.isText()) {
                void var15_17;
                String tag2;
                java.lang.Object opts = "";
                if (obj.isDashed()) {
                    opts = "stroke-dasharray=\"5 5\" ";
                }
                if ((tag2 = obj.tag()) == null || tag2.isEmpty()) {
                    tag2 = "__a2s__closed__options__";
                }
                opts = (String)opts + getOpts.apply(tag2);
                String string = "";
                endLink = "";
                link = c.options().get("a2s:link");
                if (link != null && !(s = link.toString()).isBlank()) {
                    String string2 = "<a href=\"" + s + "\">";
                    endLink = "</a>";
                }
                result.append("    ").append((String)var15_17).append("<path id=\"closed").append(i).append("\" ").append((String)(!((String)opts).isEmpty() ? (String)opts + " " : "")).append("d=\"").append((CharSequence)this.flatten(obj.points(), scaleX, scaleY)).append("Z\" />").append(endLink).append("\n");
            }
            ++i;
        }
        result.append("  </g>\n");
        result.append("  <g id=\"lines\" stroke=\"#000\" stroke-width=\"2\" fill=\"none\">\n");
        i = 0;
        for (Object obj : c.objects().value()) {
            try {
                void var15_24;
                if (obj.isClosed() || obj.isText()) continue;
                Point[] points = obj.points();
                java.lang.Object opts = "";
                if (obj.isDashed()) {
                    opts = (String)opts + "stroke-dasharray=\"5 5\" ";
                }
                if (points[0].hint() == Point.Hint.START_MARKER) {
                    opts = (String)opts + "marker-start=\"url(#iPointer)\" ";
                }
                if (points[points.length - 1].hint() == Point.Hint.END_MARKER) {
                    opts = (String)opts + "marker-end=\"url(#Pointer)\" ";
                }
                block13: for (Point p : points) {
                    if (p.hint() == null) continue;
                    switch (p.hint()) {
                        case DOT: {
                            sp = this.scale(p, scaleX, scaleY);
                            result.append("    <circle cx=\"").append(sp[0]).append("\" cy=\"").append(sp[1]).append("\" r=\"3\" fill=\"#000\" />\n");
                            continue block13;
                        }
                        case TICK: {
                            sp = this.scale(p, scaleX, scaleY);
                            result.append("    <line x1=\"").append(sp[0] - 4.0f).append("\" y1=\"").append(sp[1] - 4.0f).append("\" x2=\"").append(sp[0] + 4.0f).append("\" y2=\"").append(sp[1] + 4.0f).append("\" stroke-width=\"1\" />\n").append("    <line x1=\"").append(sp[0] + 4.0f).append("\" y1=\"").append(sp[1] - 4.0f).append("\" x2=\"").append(sp[0] - 4.0f).append("\" y2=\"").append(sp[1] + 4.0f).append("\" stroke-width=\"1\" />\n");
                            continue block13;
                        }
                    }
                }
                opts = (String)opts + getOpts.apply(obj.tag());
                String string = "";
                endLink = "";
                link = c.options().get("a2s:link");
                if (link != null && !(s = link.toString()).isBlank()) {
                    String string3 = "<a href=\"" + s + "\">";
                    endLink = "</a>";
                }
                result.append("    ").append((String)var15_24).append("<path id=\"open").append(i).append("\" ").append((String)(!((String)opts).isEmpty() ? (String)opts + " " : "")).append("d=\"").append((CharSequence)this.flatten(obj.points(), scaleX, scaleY)).append("\" />").append(endLink).append("\n");
            }
            finally {
                ++i;
            }
        }
        result.append("  </g>\n");
        result.append("  <g id=\"text\" stroke=\"none\" style=\"font-family:").append(font).append(";font-size:15.2px\" >\n");
        Function<Object, String> findTextColor = o -> {
            String s;
            java.lang.Object value;
            Matcher matcher = Canvas.OBJ_TAG_RE.matcher(o.tag());
            if (matcher.matches() && (value = c.options().get(o.tag())) != null && !(s = value.toString()).isBlank()) {
                return s;
            }
            Object.List containers = c.enclosingObjects(c.objects().value(), o.points()[0]);
            if (containers != null && containers.value() != null) {
                for (Object container : containers.value()) {
                    String v;
                    java.lang.Object value2 = c.options().get(container.tag());
                    if (value2 == null) continue;
                    String string = v = value2 instanceof Map ? ((Map)value2).getOrDefault("fill", "none") : value2.toString();
                    if ("none".equals(v) || v.isBlank()) continue;
                    return new Color(v).textColor();
                }
            }
            return "#000";
        };
        i = 0;
        for (Object obj : c.objects().value()) {
            try {
                void var15_28;
                if (!obj.isText() || obj.isTagDefinition()) continue;
                String color = findTextColor.apply(obj);
                String string = "";
                endLink = "";
                String text = new String(obj.text());
                String tag3 = obj.tag();
                if (!tag3.isEmpty()) {
                    java.lang.Object opt;
                    java.lang.Object label = c.options().get("a2s:label");
                    if (label != null) {
                        text = label.toString();
                    }
                    if (obj.corners()[0].x() == 0 && (opt = c.options().get("a2s:delref")) != null) continue;
                    java.lang.Object link2 = c.options().get("a2s:link");
                    if (link2 != null) {
                        String string4 = "<a href=\"" + String.valueOf(link2) + "\">";
                        endLink = "</a>";
                    }
                }
                sp = this.scale(obj.points()[0], scaleX, scaleY);
                result.append("    ").append((String)var15_28).append("<text id=\"obj").append(i).append("\" x=\"").append(sp[0]).append("\" y=\"").append(sp[1]).append("\" fill=\"").append(color).append("\">").append(text.replace("\"", "&#34;")).append("</text>").append(endLink).append("\n");
            }
            finally {
                ++i;
            }
        }
        result.append("  </g>\n");
        result.append("</svg>\n");
        return result.toString();
    }

    private float[] scale(Point p, int scaleX, int scaleY) {
        return new float[]{(float)scaleX * (0.5f + (float)p.x()), (float)scaleY * (0.5f + (float)p.y())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder flatten(Point[] points, int scaleX, int scaleY) {
        float[] sp;
        StringBuilder out = new StringBuilder();
        float[] pp = sp = this.scale(points[0], scaleX, scaleY);
        int i = 0;
        for (Point cp : points) {
            try {
                float[] p = this.scale(cp, scaleX, scaleY);
                if (i == 0) {
                    if (cp.hint() == Point.Hint.ROUNDED_CORNER) {
                        out.append("M ").append(p[0]).append(" ").append(p[1] + 10.0f).append(" Q ").append(p[0]).append(" ").append(p[1]).append(' ').append(p[0] + 10.0f).append(" ").append(p[1]);
                        continue;
                    }
                    out.append("M ").append(p[0]).append(" ").append(p[1]);
                    continue;
                }
                if (cp.hint() == Point.Hint.ROUNDED_CORNER) {
                    float[] np;
                    float cx = p[0];
                    float cy = p[1];
                    float sx = 0.0f;
                    float sy = 0.0f;
                    float ex = 0.0f;
                    float ey = 0.0f;
                    float[] fArray = np = i == points.length - 1 ? sp : this.scale(points[i + 1], scaleX, scaleY);
                    if (pp[0] == p[0]) {
                        sx = p[0];
                        sy = pp[1] < p[1] ? p[1] - 10.0f : p[1] + 10.0f;
                        ey = p[1];
                        ex = np[0] < p[0] ? p[0] - 10.0f : p[0] + 10.0f;
                    } else if (pp[1] == p[1]) {
                        sy = p[1];
                        sx = pp[0] < p[0] ? p[0] - 10.0f : p[0] + 10.0f;
                        ex = p[0];
                        ey = np[1] <= p[1] ? p[1] - 10.0f : p[1] + 10.0f;
                    }
                    out.append(" L ").append(sx).append(' ').append(sy).append(" Q ").append(cx).append(' ').append(cy).append(' ').append(ex).append(' ').append(ey).append(' ');
                } else {
                    out.append(" L ").append(p[0]).append(' ').append(p[1]).append(' ');
                }
                pp = p;
            }
            finally {
                ++i;
            }
        }
        return out;
    }
}

