/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.tools.ascii2svg.json;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferProvider {
    private final int size;
    private final int max;
    private final AtomicInteger counter = new AtomicInteger();
    private final ConcurrentLinkedQueue<char[]> queue = new ConcurrentLinkedQueue();

    public BufferProvider(int size, int maxBuffers) {
        this.size = size;
        this.max = maxBuffers;
    }

    public char[] newBuffer() {
        char[] buffer = this.queue.poll();
        if (buffer == null) {
            return new char[this.size];
        }
        if (this.max >= 0) {
            this.counter.decrementAndGet();
        }
        return buffer;
    }

    public void release(char[] value) {
        if (this.max < 0) {
            this.queue.offer(value);
            return;
        }
        if (this.counter.getAndUpdate(operand -> {
            int incr = operand + 1;
            return Math.min(this.max, incr);
        }) < this.max) {
            this.queue.offer(value);
        }
    }
}

