/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.tools.ascii2svg.json;

import io.yupiik.tools.ascii2svg.json.BufferProvider;
import io.yupiik.tools.ascii2svg.json.JsonStrings;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.NoSuchElementException;
import lombok.Generated;

public class JsonParser
implements AutoCloseable {
    private static final Event[] EVT_MAP = Event.values();
    private final boolean autoAdjust;
    private final char[] buffer;
    private int bufferPos = Integer.MIN_VALUE;
    private int bufferLeft = 0;
    private int availableCharsInBuffer;
    private int startOfValueInBuffer = -1;
    private int endOfValueInBuffer = -1;
    private final Reader in;
    private final BufferProvider bufferProvider;
    private byte previousEvent = (byte)-1;
    private char[] fallBackCopyBuffer;
    private boolean releaseFallBackCopyBufferLength = true;
    private int fallBackCopyBufferLength;
    private long currentLine = 1L;
    private long lastLineBreakPosition;
    private long pastBufferReadCount;
    private boolean isCurrentNumberIntegral = true;
    private int currentIntegralNumber = Integer.MIN_VALUE;
    private StructureElement currentStructureElement = null;
    private boolean closed;
    private Event rewindedEvent;

    public JsonParser(Reader reader, BufferProvider bufferProvider) {
        this.autoAdjust = true;
        this.bufferProvider = bufferProvider;
        this.in = reader;
        this.buffer = bufferProvider.newBuffer();
        this.fallBackCopyBuffer = bufferProvider.newBuffer();
    }

    private void appendToCopyBuffer(char c) {
        if (this.fallBackCopyBufferLength >= this.fallBackCopyBuffer.length - 1) {
            this.doAutoAdjust(1);
        }
        this.fallBackCopyBuffer[this.fallBackCopyBufferLength++] = c;
    }

    private void copyCurrentValue() {
        int length = this.endOfValueInBuffer - this.startOfValueInBuffer;
        if (length > 0) {
            if (this.fallBackCopyBufferLength >= this.fallBackCopyBuffer.length - length) {
                this.doAutoAdjust(length);
            } else {
                System.arraycopy(this.buffer, this.startOfValueInBuffer, this.fallBackCopyBuffer, this.fallBackCopyBufferLength, length);
            }
            this.fallBackCopyBufferLength += length;
        }
        this.endOfValueInBuffer = -1;
        this.startOfValueInBuffer = -1;
    }

    private void doAutoAdjust(int length) {
        if (!this.autoAdjust) {
            throw new ArrayIndexOutOfBoundsException("Buffer too small for such a long string");
        }
        char[] newArray = new char[this.fallBackCopyBuffer.length + Math.max(this.getBufferExtends(this.fallBackCopyBuffer.length), length)];
        System.arraycopy(this.fallBackCopyBuffer, 0, newArray, 0, this.fallBackCopyBufferLength);
        if (this.startOfValueInBuffer != -1) {
            System.arraycopy(this.buffer, this.startOfValueInBuffer, newArray, this.fallBackCopyBufferLength, length);
        }
        if (this.releaseFallBackCopyBufferLength) {
            this.bufferProvider.release(this.fallBackCopyBuffer);
            this.releaseFallBackCopyBufferLength = false;
        }
        this.fallBackCopyBuffer = newArray;
    }

    protected int getBufferExtends(int currentLength) {
        return Math.min(1024, currentLength / 4);
    }

    public boolean hasNext() {
        if (this.rewindedEvent != null) {
            return true;
        }
        if (this.currentStructureElement != null || this.previousEvent == 0) {
            return true;
        }
        if (this.previousEvent != Event.END_ARRAY.ordinal() && this.previousEvent != Event.END_OBJECT.ordinal() && this.previousEvent != Event.VALUE_STRING.ordinal() && this.previousEvent != Event.VALUE_FALSE.ordinal() && this.previousEvent != Event.VALUE_TRUE.ordinal() && this.previousEvent != Event.VALUE_NULL.ordinal() && this.previousEvent != Event.VALUE_NUMBER.ordinal()) {
            if (this.bufferPos < 0) {
                char c = this.readNextChar();
                this.unreadChar();
                return c != '\u0000';
            }
            return true;
        }
        if (this.bufferPos < this.availableCharsInBuffer) {
            char c = this.readNextNonWhitespaceChar(this.readNextChar());
            if (c == '\u0000') {
                return false;
            }
            if (this.bufferPos < this.availableCharsInBuffer) {
                throw this.unexpectedChar("EOF expected");
            }
        }
        return false;
    }

    private static boolean isAsciiDigit(char value) {
        return value <= '9' && value >= '0';
    }

    private int parseHexDigit(char value) {
        if (JsonParser.isAsciiDigit(value)) {
            return value - 48;
        }
        if (value <= 'f' && value >= 'a') {
            return value - 87;
        }
        if (value <= 'F' && value >= 'A') {
            return value - 55;
        }
        throw this.unexpectedChar("Invalid hex character");
    }

    private String createLocation() {
        long column = 1L;
        long charOffset = 0L;
        if (this.bufferPos >= -1) {
            charOffset = this.pastBufferReadCount + (long)this.bufferPos + 1L;
            column = this.lastLineBreakPosition == 0L ? charOffset + 1L : charOffset - this.lastLineBreakPosition;
        }
        return "currentLine=" + this.currentLine + ",column=" + column + ",charOffset=" + charOffset;
    }

    protected final char readNextChar() {
        if (this.bufferLeft == 0) {
            if (this.startOfValueInBuffer > -1 && this.endOfValueInBuffer == -1) {
                this.endOfValueInBuffer = this.availableCharsInBuffer;
                this.copyCurrentValue();
                this.startOfValueInBuffer = 0;
            }
            if (this.bufferPos >= -1) {
                this.pastBufferReadCount += (long)this.availableCharsInBuffer;
            }
            try {
                this.availableCharsInBuffer = this.in.read(this.buffer, 0, this.buffer.length);
                if (this.availableCharsInBuffer <= 0) {
                    return '\u0000';
                }
            }
            catch (IOException e) {
                this.close();
                throw new IllegalStateException("Unexpected IO exception on " + this.createLocation(), e);
            }
            this.bufferPos = 0;
            this.bufferLeft = this.availableCharsInBuffer - 1;
        } else {
            ++this.bufferPos;
            --this.bufferLeft;
        }
        return this.buffer[this.bufferPos];
    }

    protected final char readNextNonWhitespaceChar(char c) {
        while (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
            if (c == '\n') {
                ++this.currentLine;
                this.lastLineBreakPosition = this.pastBufferReadCount + (long)this.bufferPos;
            }
            c = this.readNextChar();
        }
        return c;
    }

    private void unreadChar() {
        --this.bufferPos;
        ++this.bufferLeft;
    }

    public void rewind(Event event) {
        this.rewindedEvent = event;
    }

    public Event next() {
        if (this.rewindedEvent != null) {
            Event event = this.rewindedEvent;
            this.rewindedEvent = null;
            return event;
        }
        if (!this.hasNext()) {
            char c = this.readNextChar();
            this.unreadChar();
            if (c != '\u0000') {
                throw this.unexpectedChar("No available event");
            }
            throw new NoSuchElementException();
        }
        if (this.previousEvent > 0 && this.currentStructureElement == null) {
            throw this.unexpectedChar("Unexpected end of structure");
        }
        char c = this.readNextNonWhitespaceChar(this.readNextChar());
        if (c == ',') {
            if (this.previousEvent == -128 || this.previousEvent == Event.START_ARRAY.ordinal() || this.previousEvent == Event.START_OBJECT.ordinal() || this.previousEvent == 127 || this.previousEvent == Event.KEY_NAME.ordinal()) {
                throw this.unexpectedChar("Expected \" ] } LITERAL");
            }
            this.previousEvent = (byte)127;
            return this.next();
        }
        if (c == ':') {
            if (this.previousEvent != Event.KEY_NAME.ordinal()) {
                throw this.unexpectedChar("A : can only follow a key name");
            }
            this.previousEvent = (byte)-128;
            return this.next();
        }
        if (!this.isCurrentNumberIntegral) {
            this.isCurrentNumberIntegral = true;
        }
        if (this.currentIntegralNumber != Integer.MIN_VALUE) {
            this.currentIntegralNumber = Integer.MIN_VALUE;
        }
        if (this.fallBackCopyBufferLength != 0) {
            this.fallBackCopyBufferLength = 0;
        }
        this.endOfValueInBuffer = -1;
        this.startOfValueInBuffer = -1;
        switch (c) {
            case '{': {
                return this.handleStartObject();
            }
            case '}': {
                return this.handleEndObject();
            }
            case '[': {
                return this.handleStartArray();
            }
            case ']': {
                return this.handleEndArray();
            }
            case '\"': {
                return this.handleQuote();
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'f': 
            case 'n': 
            case 't': {
                return this.handleLiteral();
            }
        }
        return this.defaultHandling(c);
    }

    protected Event defaultHandling(char c) {
        throw c == '\u0000' ? this.unexpectedChar("End of file hit too early") : this.unexpectedChar("Expected structural character or digit or 't' or 'n' or 'f' or '-'");
    }

    private Event handleStartObject() {
        if (this.previousEvent > 0 && this.previousEvent != 127) {
            throw this.unexpectedChar("Expected : , [");
        }
        if (this.currentStructureElement == null) {
            this.currentStructureElement = new StructureElement(null, false);
        } else {
            if (!this.currentStructureElement.isArray && this.previousEvent != -128) {
                throw this.unexpectedChar("Expected :");
            }
            this.currentStructureElement = new StructureElement(this.currentStructureElement, false);
        }
        this.previousEvent = (byte)Event.START_OBJECT.ordinal();
        return EVT_MAP[this.previousEvent];
    }

    private Event handleEndObject() {
        if (this.previousEvent == Event.START_ARRAY.ordinal() || this.previousEvent == 127 || this.previousEvent == Event.KEY_NAME.ordinal() || this.previousEvent == -128 || this.currentStructureElement == null) {
            throw this.unexpectedChar("Expected \" ] { } LITERAL");
        }
        if (this.currentStructureElement.isArray) {
            throw this.unexpectedChar("Expected : ]");
        }
        this.currentStructureElement = this.currentStructureElement.previous;
        this.previousEvent = (byte)Event.END_OBJECT.ordinal();
        return EVT_MAP[this.previousEvent];
    }

    private Event handleStartArray() {
        if (this.previousEvent > 0 && this.previousEvent != 127) {
            throw this.unexpectedChar("Expected : , [");
        }
        if (this.currentStructureElement == null) {
            this.currentStructureElement = new StructureElement(null, true);
        } else {
            if (!this.currentStructureElement.isArray && this.previousEvent != -128) {
                throw this.unexpectedChar("Expected \"");
            }
            this.currentStructureElement = new StructureElement(this.currentStructureElement, true);
        }
        this.previousEvent = (byte)Event.START_ARRAY.ordinal();
        return EVT_MAP[this.previousEvent];
    }

    private Event handleEndArray() {
        if (this.previousEvent == Event.START_OBJECT.ordinal() || this.previousEvent == 127 || this.previousEvent == -128 || this.currentStructureElement == null) {
            throw this.unexpectedChar("Expected [ ] } \" LITERAL");
        }
        if (!this.currentStructureElement.isArray) {
            throw this.unexpectedChar("Expected : }");
        }
        this.currentStructureElement = this.currentStructureElement.previous;
        this.previousEvent = (byte)Event.END_ARRAY.ordinal();
        return EVT_MAP[this.previousEvent];
    }

    private void readString() {
        while (true) {
            char n;
            if ((n = this.readNextChar()) == '\"') {
                this.endOfValueInBuffer = this.startOfValueInBuffer = this.bufferPos;
                return;
            }
            if (n == '\n') {
                throw this.unexpectedChar("Unexpected linebreak");
            }
            if (n <= '\u001f') {
                throw this.unexpectedChar("Unescaped control character");
            }
            if (n == '\\') {
                n = this.readNextChar();
                if (this.fallBackCopyBuffer == null) {
                    this.fallBackCopyBuffer = this.bufferProvider.newBuffer();
                }
                if (n == 'u') {
                    n = this.parseUnicodeHexChars();
                    this.appendToCopyBuffer(n);
                    continue;
                }
                if (n == '\\') {
                    this.appendToCopyBuffer(n);
                    continue;
                }
                this.appendToCopyBuffer(JsonStrings.asEscapedChar(n));
                continue;
            }
            this.startOfValueInBuffer = this.bufferPos;
            this.endOfValueInBuffer = -1;
            while ((n = this.readNextChar()) > '\u001f' && n != '\\' && n != '\"') {
            }
            this.endOfValueInBuffer = this.bufferPos;
            if (n == '\"') {
                if (this.fallBackCopyBufferLength > 0) {
                    this.copyCurrentValue();
                }
                return;
            }
            if (n == '\n') {
                throw this.unexpectedChar("Unexpected linebreak");
            }
            if (n <= '\u001f') {
                throw this.unexpectedChar("Unescaped control character");
            }
            this.copyCurrentValue();
            this.unreadChar();
        }
    }

    private char parseUnicodeHexChars() {
        return (char)(this.parseHexDigit(this.readNextChar()) * 4096 + this.parseHexDigit(this.readNextChar()) * 256 + this.parseHexDigit(this.readNextChar()) * 16 + this.parseHexDigit(this.readNextChar()));
    }

    private Event handleQuote() {
        if (this.previousEvent != -1 && this.previousEvent != -128 && this.previousEvent != Event.START_OBJECT.ordinal() && this.previousEvent != Event.START_ARRAY.ordinal() && this.previousEvent != 127) {
            throw this.unexpectedChar("Expected : { [ ,");
        }
        this.readString();
        if (this.previousEvent == -128) {
            if (this.currentStructureElement != null && this.currentStructureElement.isArray) {
                throw this.unexpectedChar("Key value pair not allowed in an array");
            }
            this.previousEvent = (byte)Event.VALUE_STRING.ordinal();
            return EVT_MAP[this.previousEvent];
        }
        if (this.currentStructureElement == null || this.currentStructureElement.isArray) {
            this.previousEvent = (byte)Event.VALUE_STRING.ordinal();
            return EVT_MAP[this.previousEvent];
        }
        this.previousEvent = (byte)Event.KEY_NAME.ordinal();
        return EVT_MAP[this.previousEvent];
    }

    private void readNumber() {
        char y;
        char c = this.buffer[this.bufferPos];
        this.startOfValueInBuffer = this.bufferPos;
        this.endOfValueInBuffer = -1;
        int cumulatedDigitValue = 0;
        while (JsonParser.isAsciiDigit(y = this.readNextChar())) {
            if (c == '0') {
                throw this.unexpectedChar("Leading zeros not allowed");
            }
            if (c == '-' && cumulatedDigitValue == 48) {
                throw this.unexpectedChar("Leading zeros after minus not allowed");
            }
            cumulatedDigitValue += y;
        }
        if (c == '-' && cumulatedDigitValue == 0) {
            throw this.unexpectedChar("Unexpected premature end of number");
        }
        if (y == '.') {
            this.isCurrentNumberIntegral = false;
            cumulatedDigitValue = 0;
            while (JsonParser.isAsciiDigit(y = this.readNextChar())) {
                ++cumulatedDigitValue;
            }
            if (cumulatedDigitValue == 0) {
                throw this.unexpectedChar("Unexpected premature end of number");
            }
        }
        if (y == 'e' || y == 'E') {
            this.isCurrentNumberIntegral = false;
            y = this.readNextChar();
            if (!JsonParser.isAsciiDigit(y) && y != '-' && y != '+') {
                throw this.unexpectedChar("Expected DIGIT or + or -");
            }
            if (!(y != '-' && y != '+' || JsonParser.isAsciiDigit(y = this.readNextChar()))) {
                throw this.unexpectedChar("Unexpected premature end of number");
            }
            while (JsonParser.isAsciiDigit(y = this.readNextChar())) {
            }
        }
        int n = this.endOfValueInBuffer = y == '\u0000' && this.endOfValueInBuffer < 0 ? -1 : this.bufferPos;
        if (y == ',' || y == ']' || y == '}' || y == '\n' || y == ' ' || y == '\t' || y == '\r' || y == '\u0000') {
            this.unreadChar();
            if (this.isCurrentNumberIntegral && c == '-' && cumulatedDigitValue >= 48 && cumulatedDigitValue <= 57) {
                this.currentIntegralNumber = -(cumulatedDigitValue - 48);
                return;
            }
            if (this.isCurrentNumberIntegral && c != '-' && cumulatedDigitValue == 0) {
                this.currentIntegralNumber = c - 48;
                return;
            }
            if (this.fallBackCopyBufferLength > 0) {
                this.copyCurrentValue();
            }
            return;
        }
        throw this.unexpectedChar("Unexpected premature end of number");
    }

    private Event handleLiteral() {
        if (this.previousEvent != -1 && this.previousEvent != -128 && this.previousEvent != Event.START_ARRAY.ordinal() && this.previousEvent != 127) {
            throw this.unexpectedChar("Expected : , [");
        }
        if (this.previousEvent == 127 && !this.currentStructureElement.isArray) {
            throw this.unexpectedChar("Not in an array context");
        }
        char c = this.buffer[this.bufferPos];
        switch (c) {
            case 't': {
                if (this.readNextChar() != 'r' || this.readNextChar() != 'u' || this.readNextChar() != 'e') {
                    throw this.unexpectedChar("Expected LITERAL: true");
                }
                this.previousEvent = (byte)Event.VALUE_TRUE.ordinal();
                return EVT_MAP[this.previousEvent];
            }
            case 'f': {
                if (this.readNextChar() != 'a' || this.readNextChar() != 'l' || this.readNextChar() != 's' || this.readNextChar() != 'e') {
                    throw this.unexpectedChar("Expected LITERAL: false");
                }
                this.previousEvent = (byte)Event.VALUE_FALSE.ordinal();
                return EVT_MAP[this.previousEvent];
            }
            case 'n': {
                if (this.readNextChar() != 'u' || this.readNextChar() != 'l' || this.readNextChar() != 'l') {
                    throw this.unexpectedChar("Expected LITERAL: null");
                }
                this.previousEvent = (byte)Event.VALUE_NULL.ordinal();
                return EVT_MAP[this.previousEvent];
            }
        }
        this.readNumber();
        this.previousEvent = (byte)Event.VALUE_NUMBER.ordinal();
        return EVT_MAP[this.previousEvent];
    }

    public String getString() {
        if (this.previousEvent == Event.KEY_NAME.ordinal() || this.previousEvent == Event.VALUE_STRING.ordinal() || this.previousEvent == Event.VALUE_NUMBER.ordinal()) {
            return this.fallBackCopyBufferLength > 0 ? new String(this.fallBackCopyBuffer, 0, this.fallBackCopyBufferLength) : new String(this.buffer, this.startOfValueInBuffer, this.endOfValueInBuffer - this.startOfValueInBuffer);
        }
        throw new IllegalStateException(String.valueOf((Object)EVT_MAP[this.previousEvent]) + " doesn't support getString()");
    }

    public void enforceNext(Event event) {
        if (!this.hasNext()) {
            throw new IllegalStateException("Expected " + String.valueOf((Object)event) + " stream is finished.");
        }
        Event next = this.next();
        if (next != event) {
            throw new IllegalStateException("Expected " + String.valueOf((Object)event) + " but got " + String.valueOf((Object)next));
        }
    }

    public BigDecimal getBigDecimal() {
        if (this.previousEvent != Event.VALUE_NUMBER.ordinal()) {
            throw new IllegalStateException(String.valueOf((Object)EVT_MAP[this.previousEvent]) + " doesn't support getBigDecimal()");
        }
        if (this.isCurrentNumberIntegral && this.currentIntegralNumber != Integer.MIN_VALUE) {
            return new BigDecimal(this.currentIntegralNumber);
        }
        return this.fallBackCopyBufferLength > 0 ? new BigDecimal(this.fallBackCopyBuffer, 0, this.fallBackCopyBufferLength) : new BigDecimal(this.buffer, this.startOfValueInBuffer, this.endOfValueInBuffer - this.startOfValueInBuffer);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.bufferProvider.release(this.buffer);
        if (this.releaseFallBackCopyBufferLength && this.fallBackCopyBuffer != null) {
            this.bufferProvider.release(this.fallBackCopyBuffer);
        }
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO exception " + e.getMessage(), e);
        }
        finally {
            this.closed = true;
        }
    }

    private IllegalStateException unexpectedChar(String message) {
        char c = this.bufferPos < 0 ? (char)'\u0000' : this.buffer[this.bufferPos];
        return new IllegalStateException("Unexpected character '" + c + "' (Codepoint: " + String.valueOf(c).codePointAt(0) + ") on " + this.createLocation() + ". Reason is [[" + message + "]]");
    }

    private static class StructureElement {
        private final StructureElement previous;
        private final boolean isArray;

        @Generated
        public StructureElement(StructureElement previous, boolean isArray) {
            this.previous = previous;
            this.isArray = isArray;
        }

        @Generated
        public StructureElement previous() {
            return this.previous;
        }

        @Generated
        public boolean isArray() {
            return this.isArray;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StructureElement)) {
                return false;
            }
            StructureElement other = (StructureElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isArray() != other.isArray()) {
                return false;
            }
            StructureElement this$previous = this.previous();
            StructureElement other$previous = other.previous();
            return !(this$previous == null ? other$previous != null : !((Object)this$previous).equals(other$previous));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StructureElement;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isArray() ? 79 : 97);
            StructureElement $previous = this.previous();
            result = result * 59 + ($previous == null ? 43 : ((Object)$previous).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JsonParser.StructureElement(previous=" + String.valueOf(this.previous()) + ", isArray=" + this.isArray() + ")";
        }
    }

    public static enum Event {
        START_ARRAY,
        START_OBJECT,
        KEY_NAME,
        VALUE_STRING,
        VALUE_NUMBER,
        VALUE_TRUE,
        VALUE_FALSE,
        VALUE_NULL,
        END_OBJECT,
        END_ARRAY;

    }
}

