/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.tools.ascii2svg.json;

import io.yupiik.tools.ascii2svg.json.JsonParser;
import io.yupiik.tools.ascii2svg.json.ObjectJsonCodec;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapJsonCodec {
    private final ObjectJsonCodec delegate;

    public MapJsonCodec(ObjectJsonCodec delegate) {
        this.delegate = delegate;
    }

    public Map<String, Object> read(JsonParser reader) throws IOException {
        JsonParser.Event event;
        reader.enforceNext(JsonParser.Event.START_OBJECT);
        LinkedHashMap<String, Object> instance = new LinkedHashMap<String, Object>();
        while (reader.hasNext() && (event = reader.next()) != JsonParser.Event.END_OBJECT) {
            reader.rewind(event);
            JsonParser.Event keyEvent = reader.next();
            if (keyEvent != JsonParser.Event.KEY_NAME) {
                throw new IllegalStateException("Expected=KEY_NAME, but got " + String.valueOf((Object)keyEvent));
            }
            instance.put(reader.getString(), this.delegate.read(reader));
        }
        return instance;
    }
}

