/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.maven.shade.transformer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ReproducibleResourceTransformer;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class RelocationTransformer
implements ReproducibleResourceTransformer {
    private Collection<ResourceTransformer> delegates;
    private boolean transformed;

    public boolean canTransformResource(String resource) {
        if (this.delegates == null) {
            return false;
        }
        for (ResourceTransformer transformer : this.delegates) {
            if (!transformer.canTransformResource(resource)) continue;
            return true;
        }
        return false;
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        this.processResource(resource, is, relocators, 0L);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        byte[] relocated = null;
        for (ResourceTransformer transformer : this.delegates) {
            if (!transformer.canTransformResource(resource)) continue;
            this.transformed = true;
            if (relocated == null) {
                relocated = this.relocate(IOUtil.toString((InputStream)is), relocators).getBytes(StandardCharsets.UTF_8);
            }
            if (ReproducibleResourceTransformer.class.isInstance(transformer)) {
                ((ReproducibleResourceTransformer)ReproducibleResourceTransformer.class.cast(transformer)).processResource(resource, (InputStream)new ByteArrayInputStream(relocated), relocators, time);
                continue;
            }
            transformer.processResource(resource, (InputStream)new ByteArrayInputStream(relocated), relocators);
        }
    }

    protected String relocate(String string, List<Relocator> relocators) {
        String newValue = string;
        for (Relocator relocator : relocators) {
            String value;
            while (!(value = newValue).equals(newValue = relocator.relocateClass(value))) {
            }
        }
        return newValue;
    }

    public boolean hasTransformedResource() {
        return this.transformed;
    }

    public void modifyOutputStream(JarOutputStream os) throws IOException {
        if (!this.transformed) {
            return;
        }
        for (ResourceTransformer transformer : this.delegates) {
            if (!transformer.hasTransformedResource()) continue;
            transformer.modifyOutputStream(os);
        }
    }

    public void setDelegates(Collection<ResourceTransformer> delegates) {
        this.delegates = delegates;
    }
}

