/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.maven.shade.transformer;

import io.yupiik.maven.shade.transformer.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ReproducibleResourceTransformer;

public abstract class BaseMergerTransformer
implements ReproducibleResourceTransformer {
    protected final List<String> files = new ArrayList<String>();
    private final String path;

    protected BaseMergerTransformer(String path) {
        this.path = path;
    }

    public boolean canTransformResource(String resource) {
        return this.path.equals(resource);
    }

    protected abstract String merge();

    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        this.files.add(IOUtil.slurp(is, StandardCharsets.UTF_8));
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        this.processResource(resource, is, relocators, 0L);
    }

    public void modifyOutputStream(JarOutputStream os) throws IOException {
        os.putNextEntry(new JarEntry(this.path));
        os.write(this.merge().getBytes(StandardCharsets.UTF_8));
        os.closeEntry();
    }

    public boolean hasTransformedResource() {
        return !this.files.isEmpty();
    }
}

