/*
 * Decompiled with CFR 0.152.
 */
package io.zatarox.squiggle;

import io.zatarox.squiggle.Literal;
import io.zatarox.squiggle.ValueSet;
import io.zatarox.squiggle.literal.BigDecimalLiteral;
import io.zatarox.squiggle.literal.DateTimeLiteral;
import io.zatarox.squiggle.literal.FloatLiteral;
import io.zatarox.squiggle.literal.IntegerLiteral;
import io.zatarox.squiggle.literal.StringLiteral;
import io.zatarox.squiggle.output.Output;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class LiteralValueSet
implements ValueSet {
    private final Collection<Literal> literals;

    public LiteralValueSet(Collection<Literal> literals) {
        this.literals = literals;
    }

    public LiteralValueSet(String ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        for (String value : values) {
            this.literals.add(new StringLiteral(value));
        }
    }

    public LiteralValueSet(long ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        for (long value : values) {
            this.literals.add(new IntegerLiteral(value));
        }
    }

    public LiteralValueSet(double ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        for (double value : values) {
            this.literals.add(new FloatLiteral(value));
        }
    }

    public LiteralValueSet(BigDecimal ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        for (BigDecimal value : values) {
            this.literals.add(new BigDecimalLiteral(value));
        }
    }

    public LiteralValueSet(Date ... values) {
        this.literals = new ArrayList<Literal>(values.length);
        for (Date value : values) {
            this.literals.add(new DateTimeLiteral(value));
        }
    }

    @Override
    public void write(Output out) {
        Iterator<Literal> it = this.literals.iterator();
        while (it.hasNext()) {
            Literal literal = it.next();
            literal.write(out);
            if (!it.hasNext()) continue;
            out.print(", ");
        }
    }
}

