/*
 * Decompiled with CFR 0.152.
 */
package io.zatarox.squiggle;

import io.zatarox.squiggle.Column;
import io.zatarox.squiggle.Table;
import io.zatarox.squiggle.output.Output;

public class ModifiedColumn
extends Column {
    private final ColumnOperator operator;

    public ModifiedColumn(Table table, String name, ColumnOperator operator) {
        super(table, name);
        this.operator = operator;
    }

    public ColumnOperator getOperator() {
        return this.operator;
    }

    @Override
    public void write(Output out) {
        out.print(this.getOperator().getSqlName() + "(").print(this.getTable().getAlias()).print('.').print(this.getName()).print(")");
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && ((ModifiedColumn)o).getOperator().equals((Object)this.getOperator());
    }

    public static enum ColumnOperator {
        COUNT("count"),
        DISTINCT("distinct");

        private final String sqlName;

        private ColumnOperator(String sqlName) {
            this.sqlName = sqlName;
        }

        public String getSqlName() {
            return this.sqlName;
        }
    }
}

