/*
 * Decompiled with CFR 0.152.
 */
package io.zatarox.squiggle;

import io.zatarox.squiggle.Criteria;
import io.zatarox.squiggle.Matchable;
import io.zatarox.squiggle.Order;
import io.zatarox.squiggle.Selectable;
import io.zatarox.squiggle.Table;
import io.zatarox.squiggle.ValueSet;
import io.zatarox.squiggle.criteria.MatchCriteria;
import io.zatarox.squiggle.output.Output;
import io.zatarox.squiggle.output.Outputable;
import io.zatarox.squiggle.output.ToStringer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SelectQuery
implements Outputable,
ValueSet {
    protected static final int INDENT_SIZE = 4;
    private final List<Selectable> selection = new ArrayList<Selectable>();
    private final List<Criteria> criteria = new ArrayList<Criteria>();
    private final List<Order> order = new ArrayList<Order>();
    private boolean isDistinct = false;

    public List<Table> listTables() {
        LinkedHashSet<Table> tables = new LinkedHashSet<Table>();
        this.addReferencedTablesTo(tables);
        return new ArrayList<Table>(tables);
    }

    public void addToSelection(Selectable selectable) {
        this.selection.add(selectable);
    }

    public void addColumn(Table table, String columname) {
        this.addToSelection(table.getColumn(columname));
    }

    public void removeFromSelection(Selectable selectable) {
        this.selection.remove(selectable);
    }

    public List<Selectable> listSelection() {
        return Collections.unmodifiableList(this.selection);
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean distinct) {
        this.isDistinct = distinct;
    }

    public void addCriteria(Criteria criteria) {
        this.criteria.add(criteria);
    }

    public void removeCriteria(Criteria criteria) {
        this.criteria.remove(criteria);
    }

    public List<Criteria> listCriteria() {
        return Collections.unmodifiableList(this.criteria);
    }

    public void addJoin(Table srcTable, String srcColumnname, Table destTable, String destColumnname) {
        this.addCriteria(new MatchCriteria((Matchable)srcTable.getColumn(srcColumnname), "=", destTable.getColumn(destColumnname)));
    }

    public void addJoin(Table srcTable, String srcColumnName, String operator, Table destTable, String destColumnName) {
        this.addCriteria(new MatchCriteria((Matchable)srcTable.getColumn(srcColumnName), operator, destTable.getColumn(destColumnName)));
    }

    public void addOrder(Order order) {
        this.order.add(order);
    }

    public void addOrder(Table table, String columnname, boolean ascending) {
        this.addOrder(new Order(table.getColumn(columnname), ascending));
    }

    public void removeOrder(Order order) {
        this.order.remove(order);
    }

    public List<Order> listOrder() {
        return Collections.unmodifiableList(this.order);
    }

    public String toString() {
        return ToStringer.toString(this);
    }

    @Override
    public void write(Output out) {
        out.print("SELECT");
        if (this.isDistinct) {
            out.print(" DISTINCT");
        }
        out.println();
        this.appendIndentedList(out, this.selection, ",");
        Set<Table> tables = this.findAllUsedTables();
        if (!tables.isEmpty()) {
            out.println("FROM");
            this.appendIndentedList(out, tables, ",");
        }
        if (this.criteria.size() > 0) {
            out.println("WHERE");
            this.appendIndentedList(out, this.criteria, "AND");
        }
        if (this.order.size() > 0) {
            out.println("ORDER BY");
            this.appendIndentedList(out, this.order, ",");
        }
    }

    private void appendIndentedList(Output out, Collection<? extends Outputable> things, String seperator) {
        out.indent();
        this.appendList(out, things, seperator);
        out.unindent();
    }

    private void appendList(Output out, Collection<? extends Outputable> collection, String seperator) {
        Iterator<? extends Outputable> i = collection.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Outputable curr = i.next();
            hasNext = i.hasNext();
            curr.write(out);
            out.print(' ');
            if (hasNext) {
                out.print(seperator);
            }
            out.println();
        }
    }

    private Set<Table> findAllUsedTables() {
        LinkedHashSet<Table> tables = new LinkedHashSet<Table>();
        this.addReferencedTablesTo(tables);
        return tables;
    }

    public void addReferencedTablesTo(Set<Table> tables) {
        for (Selectable s : this.selection) {
            s.addReferencedTablesTo(tables);
        }
        for (Criteria c : this.criteria) {
            c.addReferencedTablesTo(tables);
        }
        for (Order o : this.order) {
            o.addReferencedTablesTo(tables);
        }
    }
}

