/*
 * Decompiled with CFR 0.152.
 */
package io.zatarox.squiggle;

import io.zatarox.squiggle.Column;
import io.zatarox.squiggle.WildCardColumn;
import io.zatarox.squiggle.output.Output;
import io.zatarox.squiggle.output.Outputable;

public class Table
implements Outputable {
    private final String name;
    private final String alias;

    public Table(String name) {
        this(name, null);
    }

    public Table(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    private boolean hasAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        return this.alias != null ? this.alias : this.name;
    }

    public Column getColumn(String columnName) {
        return new Column(this, columnName);
    }

    public WildCardColumn getWildcard() {
        return new WildCardColumn(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Table that = (Table)o;
        return this.getAlias().equals(that.getAlias());
    }

    public int hashCode() {
        return this.getAlias().hashCode();
    }

    @Override
    public void write(Output out) {
        out.print(this.getName());
        if (this.hasAlias()) {
            out.print(' ');
            out.print(this.getAlias());
        }
    }
}

