/*
 * Decompiled with CFR 0.152.
 */
package io.zatarox.squiggle.criteria;

import io.zatarox.squiggle.Criteria;
import io.zatarox.squiggle.Table;
import io.zatarox.squiggle.criteria.AND;
import io.zatarox.squiggle.criteria.OR;
import io.zatarox.squiggle.output.Output;
import java.util.List;
import java.util.Set;

public class CriteriaExpression
implements Criteria {
    private CriteriaExpression expression;
    private Operator operator;
    private Criteria term;

    public CriteriaExpression(Criteria term) {
        this.term = term;
    }

    public CriteriaExpression(Criteria term, Operator operator, CriteriaExpression expression) {
        this(term);
        this.operator = operator;
        this.expression = expression;
    }

    public CriteriaExpression(List<Criteria> terms, Operator operator) {
        this.operator = operator;
        if (!terms.isEmpty()) {
            this.term = terms.get(0);
            if (terms.size() > 1) {
                this.expression = new CriteriaExpression(terms.subList(1, terms.size()), operator);
            }
        }
    }

    public CriteriaExpression getExpression() {
        return this.expression;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Criteria getTerm() {
        return this.term;
    }

    @Override
    public void write(Output out) {
        if (this.term != null || this.expression != null) {
            if (this.expression == null) {
                this.term.write(out);
            } else if (this.operator == Operator.AND) {
                new AND(this.term, this.expression).write(out);
            } else if (this.operator == Operator.OR) {
                new OR(this.term, this.expression).write(out);
            }
        }
    }

    @Override
    public void addReferencedTablesTo(Set<Table> tables) {
        this.term.addReferencedTablesTo(tables);
        if (this.expression != null) {
            this.expression.addReferencedTablesTo(tables);
        }
    }

    public static enum Operator {
        AND,
        OR;

    }
}

