/*
 * Decompiled with CFR 0.152.
 */
package io.zatarox.squiggle.criteria;

import io.zatarox.squiggle.Criteria;
import io.zatarox.squiggle.LiteralValueSet;
import io.zatarox.squiggle.Matchable;
import io.zatarox.squiggle.Table;
import io.zatarox.squiggle.ValueSet;
import io.zatarox.squiggle.output.Output;
import java.util.Set;

public class InCriteria
implements Criteria {
    private final Matchable matched;
    private final ValueSet valueSet;

    public InCriteria(Matchable matchable, ValueSet valueSet) {
        this.matched = matchable;
        this.valueSet = valueSet;
    }

    public InCriteria(Matchable column, String ... values) {
        this.matched = column;
        this.valueSet = new LiteralValueSet(values);
    }

    public InCriteria(Matchable column, long ... values) {
        this.matched = column;
        this.valueSet = new LiteralValueSet(values);
    }

    public InCriteria(Matchable column, double ... values) {
        this.matched = column;
        this.valueSet = new LiteralValueSet(values);
    }

    public InCriteria(Table table, String columnname, ValueSet valueSet) {
        this((Matchable)table.getColumn(columnname), valueSet);
    }

    public InCriteria(Table table, String columnname, String[] values) {
        this((Matchable)table.getColumn(columnname), values);
    }

    public InCriteria(Table table, String columnname, double[] values) {
        this((Matchable)table.getColumn(columnname), values);
    }

    public InCriteria(Table table, String columnname, long[] values) {
        this((Matchable)table.getColumn(columnname), values);
    }

    public Matchable getMatched() {
        return this.matched;
    }

    @Override
    public void write(Output out) {
        this.matched.write(out);
        out.println(" IN (");
        out.indent();
        this.valueSet.write(out);
        out.println();
        out.unindent();
        out.print(")");
    }

    @Override
    public void addReferencedTablesTo(Set<Table> tables) {
        this.matched.addReferencedTablesTo(tables);
    }
}

