/*
 * Decompiled with CFR 0.152.
 */
package io.zatarox.squiggle.criteria;

import io.zatarox.squiggle.Column;
import io.zatarox.squiggle.Criteria;
import io.zatarox.squiggle.Literal;
import io.zatarox.squiggle.Matchable;
import io.zatarox.squiggle.Table;
import io.zatarox.squiggle.criteria.CriteriaExpression;
import io.zatarox.squiggle.criteria.MatchCriteria;
import io.zatarox.squiggle.output.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MultiAndCriteria
implements Criteria {
    private final List<Column> columnList = new ArrayList<Column>();
    private final Collection<List<Literal>> valueLists;

    public MultiAndCriteria(Table table, List<String> columnNames, Collection<List<Literal>> values) {
        for (String columnName : columnNames) {
            this.columnList.add(table.getColumn(columnName));
        }
        this.valueLists = values;
    }

    @Override
    public void write(Output out) {
        if (!this.valueLists.isEmpty()) {
            ArrayList<Criteria> orClauses = new ArrayList<Criteria>();
            for (List<Literal> values : this.valueLists) {
                ArrayList<Criteria> orClause = new ArrayList<Criteria>();
                for (int i = 0; i < values.size(); ++i) {
                    orClause.add(new MatchCriteria((Matchable)this.columnList.get(i), "=", values.get(i)));
                }
                orClauses.add(new CriteriaExpression(orClause, CriteriaExpression.Operator.AND));
            }
            CriteriaExpression finalCriteria = new CriteriaExpression(orClauses, CriteriaExpression.Operator.OR);
            finalCriteria.write(out);
        } else {
            out.println(" ( ");
            for (int i = 0; i < this.columnList.size(); ++i) {
                this.columnList.get(i).write(out);
                if (i == this.columnList.size() - 1) continue;
                out.print(", ");
            }
            out.println(" ) IN () ");
        }
    }

    @Override
    public void addReferencedTablesTo(Set<Table> tables) {
        for (Column col : this.columnList) {
            col.addReferencedTablesTo(tables);
        }
    }
}

