/*
 * Decompiled with CFR 0.152.
 */
package io.zatarox.squiggle.criteria;

import io.zatarox.squiggle.Column;
import io.zatarox.squiggle.Criteria;
import io.zatarox.squiggle.Literal;
import io.zatarox.squiggle.LiteralValueSet;
import io.zatarox.squiggle.Table;
import io.zatarox.squiggle.output.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MultiInCriteria
implements Criteria {
    private final Collection<List<Literal>> valueSets;
    private final ArrayList<Column> columnList;

    public MultiInCriteria(Table table, List<String> columnNames, Collection<List<Literal>> valueSets) {
        this.valueSets = valueSets;
        this.columnList = new ArrayList();
        for (String columnName : columnNames) {
            this.columnList.add(table.getColumn(columnName));
        }
    }

    @Override
    public void write(Output out) {
        out.print("(");
        for (int i = 0; i < this.columnList.size(); ++i) {
            this.columnList.get(i).write(out);
            if (i == this.columnList.size() - 1) continue;
            out.print(", ");
        }
        out.println(")");
        out.println(" IN (");
        out.indent();
        Iterator<List<Literal>> valueSetsIterator = this.valueSets.iterator();
        while (valueSetsIterator.hasNext()) {
            out.print("( ");
            LiteralValueSet valueSet = new LiteralValueSet((Collection<Literal>)valueSetsIterator.next());
            valueSet.write(out);
            out.print(" )");
            if (!valueSetsIterator.hasNext()) continue;
            out.print(", ");
        }
        out.println();
        out.unindent();
        out.print(")");
    }

    @Override
    public void addReferencedTablesTo(Set<Table> tables) {
        for (Column col : this.columnList) {
            col.addReferencedTablesTo(tables);
        }
    }
}

