/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import io.atomix.utils.serializer.BufferAwareByteArrayOutputStream;
import io.atomix.utils.serializer.ByteArrayOutput;
import io.atomix.utils.serializer.KryoIOPool;

class KryoOutputPool
extends KryoIOPool<ByteArrayOutput> {
    private static final int MAX_BUFFER_SIZE = 786432;
    static final int MAX_POOLED_BUFFER_SIZE = 524288;

    KryoOutputPool() {
    }

    @Override
    protected ByteArrayOutput create(int bufferSize) {
        return new ByteArrayOutput(bufferSize, 786432, new BufferAwareByteArrayOutputStream(bufferSize));
    }

    @Override
    protected boolean recycle(ByteArrayOutput output) {
        if (output.getByteArrayOutputStream().getBufferSize() < 524288) {
            output.getByteArrayOutputStream().reset();
            output.clear();
            return true;
        }
        return false;
    }
}

