/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.Position;
import io.atomix.utils.serializer.Namespace;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.zip.CRC32;

class MappedJournalSegmentReader<E>
implements JournalReader<E> {
    private final ByteBuffer buffer;
    private final int maxEntrySize;
    private final JournalIndex index;
    private final Namespace namespace;
    private final long firstIndex;
    private Indexed<E> currentEntry;
    private Indexed<E> nextEntry;

    MappedJournalSegmentReader(ByteBuffer buffer, JournalSegment<E> segment, int maxEntrySize, JournalIndex index, Namespace namespace) {
        this.buffer = buffer.slice();
        this.maxEntrySize = maxEntrySize;
        this.index = index;
        this.namespace = namespace;
        this.firstIndex = segment.index();
        this.reset();
    }

    @Override
    public long getFirstIndex() {
        return this.firstIndex;
    }

    @Override
    public long getCurrentIndex() {
        return this.currentEntry != null ? this.currentEntry.index() : 0L;
    }

    @Override
    public Indexed<E> getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public long getNextIndex() {
        return this.currentEntry != null ? this.currentEntry.index() + 1L : this.firstIndex;
    }

    @Override
    public void reset(long index) {
        this.reset();
        Position position = this.index.lookup(index - 1L);
        if (position != null) {
            this.currentEntry = new Indexed<Object>(position.index() - 1L, null, 0);
            this.buffer.position(position.position());
            this.readNext();
        }
        while (this.getNextIndex() < index && this.hasNext()) {
            this.next();
        }
    }

    @Override
    public void reset() {
        this.buffer.position(64);
        this.currentEntry = null;
        this.nextEntry = null;
        this.readNext();
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry == null) {
            this.readNext();
        }
        return this.nextEntry != null;
    }

    @Override
    public Indexed<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEntry = this.nextEntry;
        this.nextEntry = null;
        this.readNext();
        return this.currentEntry;
    }

    private void readNext() {
        long index = this.getNextIndex();
        this.buffer.mark();
        try {
            int length = this.buffer.getInt();
            if (length <= 0 || length > this.maxEntrySize) {
                this.buffer.reset();
                this.nextEntry = null;
                return;
            }
            long checksum = (long)this.buffer.getInt() & 0xFFFFFFFFL;
            CRC32 crc32 = new CRC32();
            ByteBuffer slice = this.buffer.slice();
            slice.limit(length);
            crc32.update(slice);
            if (checksum == crc32.getValue()) {
                slice.rewind();
                Object entry = this.namespace.deserialize(slice);
                this.nextEntry = new Indexed<Object>(index, entry, length);
                this.buffer.position(this.buffer.position() + length);
            } else {
                this.buffer.reset();
                this.nextEntry = null;
            }
        }
        catch (BufferUnderflowException e) {
            this.buffer.reset();
            this.nextEntry = null;
        }
    }

    @Override
    public void close() {
    }
}

