/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.protocols.raft.storage.snapshot.SnapshotStore;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.buffer.HeapBuffer;

final class MemorySnapshot
extends Snapshot {
    private final HeapBuffer buffer;
    private final SnapshotDescriptor descriptor;
    private final SnapshotStore store;

    MemorySnapshot(HeapBuffer buffer, SnapshotDescriptor descriptor, SnapshotStore store) {
        super(descriptor, store);
        buffer.mark();
        this.buffer = (HeapBuffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null");
        this.buffer.position(64).mark();
        this.descriptor = (SnapshotDescriptor)Preconditions.checkNotNull((Object)descriptor, (Object)"descriptor cannot be null");
        this.store = (SnapshotStore)Preconditions.checkNotNull((Object)store, (Object)"store cannot be null");
    }

    @Override
    public SnapshotWriter openWriter() {
        this.checkWriter();
        return new SnapshotWriter(this.buffer.reset().slice(), this);
    }

    @Override
    protected void closeWriter(SnapshotWriter writer) {
        this.buffer.skip(writer.buffer.position()).mark();
        super.closeWriter(writer);
    }

    @Override
    public synchronized SnapshotReader openReader() {
        return this.openReader(new SnapshotReader(this.buffer.reset().slice(), this), this.descriptor);
    }

    @Override
    public Snapshot persist() {
        if (this.store.storage.storageLevel() != StorageLevel.MEMORY) {
            try (Snapshot newSnapshot = this.store.newSnapshot(this.index(), this.term(), this.timestamp());){
                try (SnapshotWriter newSnapshotWriter = newSnapshot.openWriter();){
                    this.buffer.flip().skip(64);
                    newSnapshotWriter.write(this.buffer.array(), this.buffer.position(), this.buffer.remaining());
                }
                Snapshot snapshot = newSnapshot;
                return snapshot;
            }
        }
        return this;
    }

    @Override
    public boolean isPersisted() {
        return this.store.storage.storageLevel() == StorageLevel.MEMORY;
    }

    @Override
    public Snapshot complete() {
        this.buffer.flip().skip(64).mark();
        this.descriptor.lock();
        return super.complete();
    }

    @Override
    public void close() {
        this.buffer.close();
    }
}

