/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.protocols.raft.storage.snapshot.FileSnapshot;
import io.atomix.protocols.raft.storage.snapshot.MemorySnapshot;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotFile;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.storage.buffer.HeapBuffer;
import io.atomix.utils.time.WallClockTimestamp;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotStore
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final RaftStorage storage;
    private final NavigableMap<Long, Snapshot> snapshots = new ConcurrentSkipListMap<Long, Snapshot>();

    public SnapshotStore(RaftStorage storage) {
        this.storage = (RaftStorage)Preconditions.checkNotNull((Object)storage, (Object)"storage cannot be null");
        this.open();
    }

    private void open() {
        for (Snapshot snapshot : this.loadSnapshots()) {
            this.completeSnapshot(snapshot);
        }
    }

    public Snapshot getCurrentSnapshot() {
        Map.Entry<Long, Snapshot> entry = this.snapshots.lastEntry();
        return entry != null ? entry.getValue() : null;
    }

    public long getCurrentSnapshotIndex() {
        Snapshot snapshot = this.getCurrentSnapshot();
        return snapshot != null ? snapshot.index() : 0L;
    }

    public Snapshot getSnapshot(long index) {
        return (Snapshot)this.snapshots.get(index);
    }

    private Collection<Snapshot> loadSnapshots() {
        this.storage.directory().mkdirs();
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        for (File file : this.storage.directory().listFiles(File::isFile)) {
            if (!SnapshotFile.isSnapshotFile(file)) continue;
            SnapshotFile snapshotFile = new SnapshotFile(file);
            SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)FileBuffer.allocate((File)file, (int)64));
            if (descriptor.isLocked()) {
                this.log.debug("Loaded disk snapshot: {} ({})", (Object)descriptor.index(), (Object)snapshotFile.file().getName());
                snapshots.add(new FileSnapshot(snapshotFile, descriptor, this));
                descriptor.close();
                continue;
            }
            this.log.debug("Deleting partial snapshot: {} ({})", (Object)descriptor.index(), (Object)snapshotFile.file().getName());
            descriptor.close();
            descriptor.delete();
        }
        return snapshots;
    }

    public Snapshot newTemporarySnapshot(long index, long term, WallClockTimestamp timestamp) {
        SnapshotDescriptor descriptor = SnapshotDescriptor.builder().withIndex(index).withTerm(term).withTimestamp(timestamp.unixTimestamp()).build();
        return this.newSnapshot(descriptor, StorageLevel.MEMORY);
    }

    public Snapshot newSnapshot(long index, long term, WallClockTimestamp timestamp) {
        SnapshotDescriptor descriptor = SnapshotDescriptor.builder().withIndex(index).withTerm(term).withTimestamp(timestamp.unixTimestamp()).build();
        return this.newSnapshot(descriptor, this.storage.storageLevel());
    }

    private Snapshot newSnapshot(SnapshotDescriptor descriptor, StorageLevel storageLevel) {
        if (storageLevel == StorageLevel.MEMORY) {
            return this.createMemorySnapshot(descriptor);
        }
        return this.createDiskSnapshot(descriptor);
    }

    private Snapshot createMemorySnapshot(SnapshotDescriptor descriptor) {
        HeapBuffer buffer = HeapBuffer.allocate((int)64, (int)Integer.MAX_VALUE);
        MemorySnapshot snapshot = new MemorySnapshot(buffer, descriptor.copyTo((Buffer)buffer), this);
        this.log.debug("Created memory snapshot: {}", (Object)snapshot);
        return snapshot;
    }

    private Snapshot createDiskSnapshot(SnapshotDescriptor descriptor) {
        SnapshotFile file = new SnapshotFile(SnapshotFile.createSnapshotFile(this.storage.directory(), this.storage.prefix(), descriptor.index()));
        FileSnapshot snapshot = new FileSnapshot(file, descriptor, this);
        this.log.debug("Created disk snapshot: {}", (Object)snapshot);
        return snapshot;
    }

    protected synchronized void completeSnapshot(Snapshot snapshot) {
        Preconditions.checkNotNull((Object)snapshot, (Object)"snapshot cannot be null");
        Map.Entry<Long, Snapshot> lastEntry = this.snapshots.lastEntry();
        if (lastEntry == null) {
            this.snapshots.put(snapshot.index(), snapshot);
        } else if (lastEntry.getValue().index() < snapshot.index()) {
            this.snapshots.put(snapshot.index(), snapshot);
            Snapshot lastSnapshot = lastEntry.getValue();
            lastSnapshot.close();
            lastSnapshot.delete();
        } else if (this.storage.isRetainStaleSnapshots()) {
            this.snapshots.put(snapshot.index(), snapshot);
        } else {
            snapshot.close();
            snapshot.delete();
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

