/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.barrier.impl;

import io.atomix.core.barrier.AsyncDistributedCyclicBarrier;
import io.atomix.core.barrier.DistributedCyclicBarrier;
import io.atomix.core.barrier.impl.BlockingDistributedCyclicBarrier;
import io.atomix.core.barrier.impl.CyclicBarrierResult;
import io.atomix.core.barrier.impl.DistributedCyclicBarrierClient;
import io.atomix.core.barrier.impl.DistributedCyclicBarrierService;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.proxy.ProxyClient;
import java.time.Duration;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CompletableFuture;

public class DistributedCyclicBarrierProxy
extends AbstractAsyncPrimitive<AsyncDistributedCyclicBarrier, DistributedCyclicBarrierService>
implements AsyncDistributedCyclicBarrier,
DistributedCyclicBarrierClient {
    private final Runnable barrierAction;
    private volatile CompletableFuture<Integer> awaitFuture;
    private volatile long barrierId;

    public DistributedCyclicBarrierProxy(ProxyClient<DistributedCyclicBarrierService> client, PrimitiveRegistry registry, Runnable barrierAction) {
        super(client, registry);
        this.barrierAction = barrierAction;
    }

    @Override
    public synchronized void broken(long id) {
        if (this.barrierId == id) {
            CompletableFuture<Integer> awaitFuture = this.awaitFuture;
            if (awaitFuture != null) {
                awaitFuture.completeExceptionally(new BrokenBarrierException());
            }
            this.barrierId = 0L;
            this.awaitFuture = null;
        }
    }

    @Override
    public synchronized void release(long id, int index) {
        if (this.barrierId == id) {
            CompletableFuture<Integer> awaitFuture = this.awaitFuture;
            if (awaitFuture != null) {
                awaitFuture.complete(index);
            }
            this.barrierId = 0L;
            this.awaitFuture = null;
        }
    }

    @Override
    public void runAction() {
        this.barrierAction.run();
    }

    @Override
    public CompletableFuture<Integer> await() {
        return this.await(Duration.ofMillis(0L));
    }

    @Override
    public synchronized CompletableFuture<Integer> await(Duration timeout) {
        if (this.awaitFuture == null) {
            CompletableFuture awaitFuture = new CompletableFuture();
            this.awaitFuture = awaitFuture;
            this.getProxyClient().applyBy(this.name(), service -> service.await(timeout.toMillis())).thenAccept(result -> {
                if (result.status() == CyclicBarrierResult.Status.OK) {
                    this.barrierId = (Long)result.result();
                } else if (result.status() == CyclicBarrierResult.Status.BROKEN) {
                    DistributedCyclicBarrierProxy distributedCyclicBarrierProxy = this;
                    synchronized (distributedCyclicBarrierProxy) {
                        this.awaitFuture = null;
                    }
                    awaitFuture.completeExceptionally(new BrokenBarrierException());
                }
            });
        }
        return this.awaitFuture;
    }

    @Override
    public CompletableFuture<Integer> getNumberWaiting() {
        return this.getProxyClient().applyBy(this.name(), service -> service.getNumberWaiting());
    }

    @Override
    public CompletableFuture<Integer> getParties() {
        return this.getProxyClient().applyBy(this.name(), service -> service.getParties());
    }

    @Override
    public CompletableFuture<Boolean> isBroken() {
        return this.getProxyClient().applyBy(this.name(), service -> service.isBroken(this.barrierId));
    }

    @Override
    public CompletableFuture<Void> reset() {
        return this.getProxyClient().acceptBy(this.name(), service -> service.reset(this.barrierId));
    }

    public CompletableFuture<AsyncDistributedCyclicBarrier> connect() {
        return ((CompletableFuture)((CompletableFuture)super.connect().thenCompose(v -> this.getProxyClient().getPartition(this.name()).connect())).thenCompose(v -> this.getProxyClient().acceptBy(this.name(), service -> service.join()))).thenApply(v -> this);
    }

    @Override
    public DistributedCyclicBarrier sync(Duration operationTimeout) {
        return new BlockingDistributedCyclicBarrier(this, operationTimeout.toMillis());
    }
}

