/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.impl.CollectionUpdateResult;
import io.atomix.core.collection.impl.DistributedCollectionClient;
import io.atomix.core.collection.impl.DistributedCollectionService;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.IterableService;
import io.atomix.core.iterator.impl.ProxyIterator;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.proxy.ProxySession;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public abstract class DistributedCollectionProxy<A extends AsyncDistributedCollection<E>, S extends DistributedCollectionService<E>, E>
extends AbstractAsyncPrimitive<A, S>
implements AsyncDistributedCollection<E>,
DistributedCollectionClient<E> {
    private final Map<CollectionEventListener<E>, Executor> eventListeners = Maps.newConcurrentMap();

    public DistributedCollectionProxy(ProxyClient<S> client, PrimitiveRegistry registry) {
        super(client, registry);
    }

    @Override
    public void onEvent(CollectionEvent<E> event) {
        this.eventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event((Event)event)));
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.getProxyClient().applyBy(this.name(), service -> service.size());
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.getProxyClient().applyBy(this.name(), service -> service.isEmpty());
    }

    @Override
    public CompletableFuture<Boolean> add(E element) {
        return this.getProxyClient().applyBy(this.name(), service -> service.add(element)).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result));
    }

    @Override
    public CompletableFuture<Boolean> remove(E element) {
        return this.getProxyClient().applyBy(this.name(), service -> service.remove(element)).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result));
    }

    @Override
    public CompletableFuture<Boolean> contains(E element) {
        return this.getProxyClient().applyBy(this.name(), service -> service.contains(element));
    }

    @Override
    public CompletableFuture<Boolean> addAll(Collection<? extends E> c) {
        return this.getProxyClient().applyBy(this.name(), service -> service.addAll(c)).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result));
    }

    @Override
    public CompletableFuture<Boolean> containsAll(Collection<? extends E> c) {
        return this.getProxyClient().applyBy(this.name(), service -> service.containsAll(c));
    }

    @Override
    public CompletableFuture<Boolean> retainAll(Collection<? extends E> c) {
        return this.getProxyClient().applyBy(this.name(), service -> service.removeAll(c)).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Collection<? extends E> c) {
        return this.getProxyClient().applyBy(this.name(), service -> service.removeAll(c)).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result));
    }

    protected <T> CompletableFuture<T> checkLocked(CollectionUpdateResult<T> result) {
        if (result.status() == CollectionUpdateResult.Status.WRITE_LOCK_CONFLICT) {
            return Futures.exceptionalFuture((Throwable)new PrimitiveException.ConcurrentModification());
        }
        return CompletableFuture.completedFuture(result.result());
    }

    @Override
    public synchronized CompletableFuture<Void> addListener(CollectionEventListener<E> listener, Executor executor) {
        if (this.eventListeners.putIfAbsent(listener, executor) == null) {
            return this.getProxyClient().acceptBy(this.name(), service -> service.listen()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> removeListener(CollectionEventListener<E> listener) {
        this.eventListeners.remove(listener);
        if (this.eventListeners.isEmpty()) {
            return this.getProxyClient().acceptAll(service -> service.unlisten()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean isListening() {
        return !this.eventListeners.isEmpty();
    }

    @Override
    public AsyncIterator<E> iterator() {
        return new ProxyIterator(this.getProxyClient(), this.getProxyClient().getPartitionId(this.name()), IterableService::iterate, IterableService::next, IterableService::close);
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.getProxyClient().acceptBy(this.name(), service -> service.clear());
    }

    public CompletableFuture<A> connect() {
        return ((CompletableFuture)((CompletableFuture)super.connect().thenCompose(v -> this.getProxyClient().getPartition(this.name()).connect())).thenRun(() -> {
            ProxySession partition = this.getProxyClient().getPartition(this.name());
            partition.addStateChangeListener(state -> {
                if (state == PrimitiveState.CONNECTED && this.isListening()) {
                    partition.accept(service -> service.listen());
                }
            });
        })).thenApply(v -> this);
    }
}

