/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.counter.impl;

import io.atomix.core.counter.AsyncAtomicCounter;
import io.atomix.core.counter.AtomicCounter;
import io.atomix.core.counter.impl.AtomicCounterService;
import io.atomix.core.counter.impl.BlockingAtomicCounter;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.proxy.ProxyClient;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class AtomicCounterProxy
extends AbstractAsyncPrimitive<AsyncAtomicCounter, AtomicCounterService>
implements AsyncAtomicCounter {
    public AtomicCounterProxy(ProxyClient<AtomicCounterService> client, PrimitiveRegistry registry) {
        super(client, registry);
    }

    @Override
    public CompletableFuture<Long> get() {
        return this.getProxyClient().applyBy(this.name(), service -> service.get());
    }

    @Override
    public CompletableFuture<Void> set(long value) {
        return this.getProxyClient().acceptBy(this.name(), service -> service.set(value));
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(long expectedValue, long updateValue) {
        return this.getProxyClient().applyBy(this.name(), service -> service.compareAndSet(expectedValue, updateValue));
    }

    @Override
    public CompletableFuture<Long> addAndGet(long delta) {
        return this.getProxyClient().applyBy(this.name(), service -> service.addAndGet(delta));
    }

    @Override
    public CompletableFuture<Long> getAndAdd(long delta) {
        return this.getProxyClient().applyBy(this.name(), service -> service.getAndAdd(delta));
    }

    @Override
    public CompletableFuture<Long> incrementAndGet() {
        return this.getProxyClient().applyBy(this.name(), service -> service.incrementAndGet());
    }

    @Override
    public CompletableFuture<Long> getAndIncrement() {
        return this.getProxyClient().applyBy(this.name(), service -> service.getAndIncrement());
    }

    @Override
    public CompletableFuture<Long> decrementAndGet() {
        return this.getProxyClient().applyBy(this.name(), service -> service.decrementAndGet());
    }

    @Override
    public CompletableFuture<Long> getAndDecrement() {
        return this.getProxyClient().applyBy(this.name(), service -> service.getAndDecrement());
    }

    public CompletableFuture<AsyncAtomicCounter> connect() {
        return ((CompletableFuture)super.connect().thenCompose(v -> this.getProxyClient().getPartition(this.name()).connect())).thenApply(v -> this);
    }

    @Override
    public AtomicCounter sync(Duration operationTimeout) {
        return new BlockingAtomicCounter(this, operationTimeout.toMillis());
    }
}

