/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.iterator;

import io.atomix.core.iterator.impl.BlockingIterator;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;

public interface AsyncIterator<T> {
    public CompletableFuture<Boolean> hasNext();

    public CompletableFuture<T> next();

    public CompletableFuture<Void> close();

    default public Iterator<T> sync() {
        return this.sync(Duration.ofMillis(5000L));
    }

    default public Iterator<T> sync(Duration timeout) {
        return new BlockingIterator(this, timeout.toMillis());
    }
}

