/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.iterator.impl;

import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.CloseFunction;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.iterator.impl.NextFunction;
import io.atomix.core.iterator.impl.OpenFunction;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.OrderedFuture;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ProxyIterator<S, T>
implements AsyncIterator<T> {
    private final ProxyClient<S> client;
    private final PartitionId partitionId;
    private final NextFunction<S, T> nextFunction;
    private final CloseFunction<S> closeFunction;
    private final CompletableFuture<IteratorBatch<T>> openFuture;
    private volatile CompletableFuture<IteratorBatch<T>> batch;
    private volatile CompletableFuture<Void> closeFuture;

    public ProxyIterator(ProxyClient<S> client, PartitionId partitionId, OpenFunction<S, T> openFunction, NextFunction<S, T> nextFunction, CloseFunction<S> closeFunction) {
        this.client = client;
        this.partitionId = partitionId;
        this.nextFunction = nextFunction;
        this.closeFunction = closeFunction;
        this.openFuture = OrderedFuture.wrap((CompletableFuture)client.applyOn(partitionId, openFunction::open));
        this.batch = this.openFuture;
    }

    private CompletableFuture<Iterator<T>> batch() {
        return this.batch.thenCompose(iterator -> {
            if (iterator != null && !iterator.hasNext()) {
                this.batch = this.fetch(iterator.position());
                return this.batch.thenApply(Function.identity());
            }
            return CompletableFuture.completedFuture(iterator);
        });
    }

    private CompletableFuture<IteratorBatch<T>> fetch(int position) {
        return this.openFuture.thenCompose(initialBatch -> {
            if (!initialBatch.complete()) {
                return this.client.applyOn(this.partitionId, service -> this.nextFunction.next(service, initialBatch.id(), position)).thenCompose(nextBatch -> {
                    if (nextBatch == null) {
                        return this.close().thenApply(v -> null);
                    }
                    return CompletableFuture.completedFuture(nextBatch);
                });
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close() {
        if (this.closeFuture == null) {
            ProxyIterator proxyIterator = this;
            synchronized (proxyIterator) {
                if (this.closeFuture == null) {
                    this.closeFuture = this.openFuture.thenCompose(initialBatch -> {
                        if (initialBatch != null && !initialBatch.complete()) {
                            return this.client.acceptOn(this.partitionId, service -> this.closeFunction.close(service, initialBatch.id()));
                        }
                        return CompletableFuture.completedFuture(null);
                    });
                }
            }
        }
        return this.closeFuture;
    }

    @Override
    public CompletableFuture<Boolean> hasNext() {
        return this.batch().thenApply(iterator -> iterator != null && iterator.hasNext());
    }

    @Override
    public CompletableFuture<T> next() {
        return this.batch().thenCompose(iterator -> {
            if (iterator == null) {
                return Futures.exceptionalFuture((Throwable)new NoSuchElementException());
            }
            return CompletableFuture.completedFuture(iterator.next());
        });
    }
}

