/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.DistributedCollectionType;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.TranscodingIterator;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.map.AtomicMapEvent;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.DistributedMapType;
import io.atomix.core.map.MapEvent;
import io.atomix.core.map.MapEventListener;
import io.atomix.core.map.impl.BlockingDistributedMap;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.DistributedSetType;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DelegatingAsyncDistributedMap<K, V>
extends DelegatingAsyncPrimitive
implements AsyncDistributedMap<K, V> {
    private final AsyncAtomicMap<K, V> atomicMap;
    private final Map<MapEventListener<K, V>, AtomicMapEventListener<K, V>> listenerMap = Maps.newConcurrentMap();

    public DelegatingAsyncDistributedMap(AsyncAtomicMap<K, V> atomicMap) {
        super(atomicMap);
        this.atomicMap = atomicMap;
    }

    public PrimitiveType type() {
        return DistributedMapType.instance();
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.atomicMap.size();
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.atomicMap.isEmpty();
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.atomicMap.containsKey(key);
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V value) {
        return this.atomicMap.containsValue(value);
    }

    @Override
    public CompletableFuture<V> get(K key) {
        return this.atomicMap.get(key).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<V> put(K key, V value) {
        return this.atomicMap.put(key, value).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<V> remove(K key) {
        return this.atomicMap.remove(key).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> m) {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.atomicMap.clear();
    }

    @Override
    public AsyncDistributedSet<K> keySet() {
        return this.atomicMap.keySet();
    }

    @Override
    public AsyncDistributedCollection<V> values() {
        return new UnwrappedValues(this.atomicMap.values());
    }

    @Override
    public AsyncDistributedSet<Map.Entry<K, V>> entrySet() {
        return new UnwrappedEntrySet(this.atomicMap.entrySet());
    }

    @Override
    public CompletableFuture<V> getOrDefault(K key, V defaultValue) {
        return this.atomicMap.getOrDefault(key, defaultValue).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.atomicMap.putIfAbsent(key, value).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.atomicMap.remove(key, value);
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.atomicMap.replace(key, oldValue, newValue);
    }

    @Override
    public CompletableFuture<V> replace(K key, V value) {
        return this.atomicMap.replace(key, value).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.atomicMap.computeIfAbsent((K)key, mappingFunction).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.atomicMap.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.atomicMap.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        InternalAtomicMapEventListener<K, V> atomicListener = new InternalAtomicMapEventListener<K, V>(listener);
        if (this.listenerMap.putIfAbsent(listener, atomicListener) == null) {
            return this.atomicMap.addListener(atomicListener, executor);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        AtomicMapEventListener<K, V> atomicListener = this.listenerMap.remove(listener);
        if (atomicListener != null) {
            return this.atomicMap.removeListener(atomicListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public DistributedMap<K, V> sync(Duration operationTimeout) {
        return new BlockingDistributedMap(this, operationTimeout.toMillis());
    }

    private class InternalAtomicMapEventListener<K, V>
    implements AtomicMapEventListener<K, V> {
        private final MapEventListener<K, V> mapListener;

        InternalAtomicMapEventListener(MapEventListener<K, V> mapListener) {
            this.mapListener = mapListener;
        }

        public void event(AtomicMapEvent<K, V> event) {
            switch ((AtomicMapEvent.Type)event.type()) {
                case INSERT: {
                    this.mapListener.event((Event)new MapEvent<K, Object>(MapEvent.Type.INSERT, event.key(), Versioned.valueOrNull(event.newValue()), Versioned.valueOrNull(event.oldValue())));
                    break;
                }
                case UPDATE: {
                    this.mapListener.event((Event)new MapEvent<K, Object>(MapEvent.Type.UPDATE, event.key(), Versioned.valueOrNull(event.newValue()), Versioned.valueOrNull(event.oldValue())));
                    break;
                }
                case REMOVE: {
                    this.mapListener.event((Event)new MapEvent<K, Object>(MapEvent.Type.REMOVE, event.key(), Versioned.valueOrNull(event.newValue()), Versioned.valueOrNull(event.oldValue())));
                }
            }
        }
    }

    private class UnwrappedEntrySet
    implements AsyncDistributedSet<Map.Entry<K, V>> {
        private final AsyncDistributedSet<Map.Entry<K, Versioned<V>>> entries;
        private final Map<CollectionEventListener<Map.Entry<K, V>>, CollectionEventListener<Map.Entry<K, Versioned<V>>>> listenerMap = Maps.newConcurrentMap();

        UnwrappedEntrySet(AsyncDistributedSet<Map.Entry<K, Versioned<V>>> entries) {
            this.entries = entries;
        }

        public String name() {
            return DelegatingAsyncDistributedMap.this.name();
        }

        public PrimitiveType type() {
            return DistributedSetType.instance();
        }

        public PrimitiveProtocol protocol() {
            return DelegatingAsyncDistributedMap.this.protocol();
        }

        @Override
        public CompletableFuture<Boolean> add(Map.Entry<K, V> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(Map.Entry<K, V> element) {
            return DelegatingAsyncDistributedMap.this.remove(element.getKey(), element.getValue());
        }

        @Override
        public CompletableFuture<Integer> size() {
            return this.entries.size();
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return this.entries.clear();
        }

        @Override
        public CompletableFuture<Boolean> contains(Map.Entry<K, V> element) {
            return DelegatingAsyncDistributedMap.this.get(element.getKey()).thenApply(value -> Objects.equals(value, element.getValue()));
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends Map.Entry<K, V>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends Map.Entry<K, V>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends Map.Entry<K, V>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends Map.Entry<K, V>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> addListener(CollectionEventListener<Map.Entry<K, V>> listener, Executor executor) {
            VersionedCollectionEventListener atomicListener = new VersionedCollectionEventListener(listener);
            if (this.listenerMap.putIfAbsent(listener, atomicListener) == null) {
                return this.entries.addListener(atomicListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> removeListener(CollectionEventListener<Map.Entry<K, V>> listener) {
            CollectionEventListener atomicListener = this.listenerMap.remove(listener);
            if (atomicListener != null) {
                return this.entries.removeListener(atomicListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public AsyncIterator<Map.Entry<K, V>> iterator() {
            return new TranscodingIterator<Map.Entry, Map.Entry>(this.entries.iterator(), entry -> Maps.immutableEntry(entry.getKey(), (Object)Versioned.valueOrNull((Versioned)((Versioned)entry.getValue()))));
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<Map.Entry<K, V>>> transactionLog) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        public CompletableFuture<Void> close() {
            return this.entries.close();
        }

        public CompletableFuture<Void> delete() {
            return this.entries.delete();
        }

        @Override
        public DistributedSet<Map.Entry<K, V>> sync(Duration operationTimeout) {
            return new BlockingDistributedSet(this, operationTimeout.toMillis());
        }

        private class VersionedCollectionEventListener
        implements CollectionEventListener<Map.Entry<K, Versioned<V>>> {
            private final CollectionEventListener<Map.Entry<K, V>> listener;

            VersionedCollectionEventListener(CollectionEventListener<Map.Entry<K, V>> listener) {
                this.listener = listener;
            }

            public void event(CollectionEvent<Map.Entry<K, Versioned<V>>> event) {
                this.listener.event((Event)new CollectionEvent<Object>((CollectionEvent.Type)event.type(), (event.element() == null ? null : Maps.immutableEntry(event.element().getKey(), (Object)Versioned.valueOrNull(event.element().getValue())))));
            }
        }
    }

    private class UnwrappedValues
    implements AsyncDistributedCollection<V> {
        private final AsyncDistributedCollection<Versioned<V>> values;
        private final Map<CollectionEventListener<V>, CollectionEventListener<Versioned<V>>> listenerMap = Maps.newConcurrentMap();

        UnwrappedValues(AsyncDistributedCollection<Versioned<V>> values) {
            this.values = values;
        }

        public String name() {
            return DelegatingAsyncDistributedMap.this.name();
        }

        public PrimitiveType type() {
            return DistributedCollectionType.instance();
        }

        public PrimitiveProtocol protocol() {
            return DelegatingAsyncDistributedMap.this.protocol();
        }

        @Override
        public CompletableFuture<Boolean> add(V element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(V element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> size() {
            return this.values.size();
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return this.values.clear();
        }

        @Override
        public CompletableFuture<Boolean> contains(V element) {
            return this.values.contains(new Versioned(element, 0L));
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends V> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends V> c) {
            return this.values.containsAll(c.stream().map(value -> new Versioned(value, 0L)).collect(Collectors.toList()));
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends V> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends V> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> addListener(CollectionEventListener<V> listener, Executor executor) {
            VersionedCollectionEventListener atomicListener = new VersionedCollectionEventListener(listener);
            if (this.listenerMap.putIfAbsent(listener, atomicListener) == null) {
                return this.values.addListener(atomicListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> removeListener(CollectionEventListener<V> listener) {
            CollectionEventListener atomicListener = this.listenerMap.remove(listener);
            if (atomicListener != null) {
                return this.values.removeListener(atomicListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public AsyncIterator<V> iterator() {
            return new TranscodingIterator<Object, Versioned>(this.values.iterator(), Versioned::valueOrNull);
        }

        public CompletableFuture<Void> close() {
            return this.values.close();
        }

        public CompletableFuture<Void> delete() {
            return this.values.delete();
        }

        @Override
        public DistributedCollection<V> sync(Duration operationTimeout) {
            return new BlockingDistributedCollection(this, operationTimeout.toMillis());
        }

        private class VersionedCollectionEventListener
        implements CollectionEventListener<Versioned<V>> {
            private final CollectionEventListener<V> listener;

            VersionedCollectionEventListener(CollectionEventListener<V> listener) {
                this.listener = listener;
            }

            public void event(CollectionEvent<Versioned<V>> event) {
                this.listener.event((Event)new CollectionEvent<Object>((CollectionEvent.Type)event.type(), Versioned.valueOrNull(event.element())));
            }
        }
    }
}

