/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.google.common.io.BaseEncoding;
import io.atomix.core.multimap.AsyncAtomicMultimap;
import io.atomix.core.multimap.AtomicMultimap;
import io.atomix.core.multimap.AtomicMultimapBuilder;
import io.atomix.core.multimap.AtomicMultimapConfig;
import io.atomix.core.multimap.impl.AtomicMultimapProxy;
import io.atomix.core.multimap.impl.AtomicMultimapService;
import io.atomix.core.multimap.impl.CachingAsyncAtomicMultimap;
import io.atomix.core.multimap.impl.TranscodingAsyncAtomicMultimap;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultAtomicMultimapBuilder<K, V>
extends AtomicMultimapBuilder<K, V> {
    public DefaultAtomicMultimapBuilder(String name, AtomicMultimapConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<AtomicMultimap<K, V>> buildAsync() {
        return ((CompletableFuture)this.newProxy(AtomicMultimapService.class, new ServiceConfig()).thenCompose(proxy -> new AtomicMultimapProxy((ProxyClient<AtomicMultimapService>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(rawMultimap -> {
            Serializer serializer = this.serializer();
            DelegatingAsyncPrimitive multimap = new TranscodingAsyncAtomicMultimap<Object, Object, String, byte[]>((AsyncAtomicMultimap<String, byte[]>)rawMultimap, key -> BaseEncoding.base16().encode(serializer.encode(key)), string -> serializer.decode(BaseEncoding.base16().decode((CharSequence)string)), value -> serializer.encode(value), bytes -> serializer.decode(bytes));
            if (((AtomicMultimapConfig)this.config).getCacheConfig().isEnabled()) {
                multimap = new CachingAsyncAtomicMultimap(multimap, ((AtomicMultimapConfig)this.config).getCacheConfig());
            }
            return multimap.sync();
        });
    }
}

