/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.registry;

import com.google.common.collect.Maps;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.core.AtomixRegistry;
import io.atomix.core.profile.Profile;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.utils.NamedType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class SimpleRegistry
implements AtomixRegistry {
    private final Map<Class<?>, Map<String, NamedType>> registrations;

    public static Builder builder() {
        return new Builder();
    }

    private SimpleRegistry(Map<Class<?>, Map<String, NamedType>> registrations) {
        this.registrations = registrations;
    }

    @Override
    public <T extends NamedType> Collection<T> getTypes(Class<T> type) {
        Map<String, NamedType> types = this.registrations.get(type);
        return types != null ? types.values() : Collections.emptyList();
    }

    @Override
    public <T extends NamedType> T getType(Class<T> type, String name) {
        Map<String, NamedType> types = this.registrations.get(type);
        return (T)(types != null ? types.get(name) : null);
    }

    public static class Builder
    implements io.atomix.utils.Builder<AtomixRegistry> {
        private final Map<Class<?>, Map<String, NamedType>> registrations = Maps.newHashMap();

        public Builder addProfileType(Profile.Type profileType) {
            this.registrations.computeIfAbsent(Profile.Type.class, t -> Maps.newHashMap()).put(profileType.name(), profileType);
            return this;
        }

        public Builder addDiscoveryProviderType(NodeDiscoveryProvider.Type discoveryProviderType) {
            this.registrations.computeIfAbsent(NodeDiscoveryProvider.Type.class, t -> Maps.newHashMap()).put(discoveryProviderType.name(), discoveryProviderType);
            return this;
        }

        public Builder addPrimitiveType(PrimitiveType primitiveType) {
            this.registrations.computeIfAbsent(PrimitiveType.class, t -> Maps.newHashMap()).put(primitiveType.name(), primitiveType);
            return this;
        }

        public Builder addProtocolType(PrimitiveProtocol.Type protocolType) {
            this.registrations.computeIfAbsent(PrimitiveProtocol.Type.class, t -> Maps.newHashMap()).put(protocolType.name(), protocolType);
            return this;
        }

        public Builder addPartitionGroupType(PartitionGroup.Type partitionGroupType) {
            this.registrations.computeIfAbsent(PartitionGroup.Type.class, t -> Maps.newHashMap()).put(partitionGroupType.name(), partitionGroupType);
            return this;
        }

        public AtomixRegistry build() {
            return new SimpleRegistry(this.registrations);
        }
    }
}

