/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.semaphore.impl;

import com.google.common.base.Throwables;
import io.atomix.core.semaphore.AsyncAtomicSemaphore;
import io.atomix.core.semaphore.AtomicSemaphore;
import io.atomix.core.semaphore.QueueStatus;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import io.atomix.utils.time.Version;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class BlockingAtomicSemaphore
extends Synchronous<AsyncAtomicSemaphore>
implements AtomicSemaphore {
    private final AsyncAtomicSemaphore asyncSemaphore;
    private final Duration timeout;

    public BlockingAtomicSemaphore(AsyncAtomicSemaphore asyncAtomicSemaphore, Duration timeout) {
        super((AsyncPrimitive)asyncAtomicSemaphore);
        this.asyncSemaphore = asyncAtomicSemaphore;
        this.timeout = timeout;
    }

    @Override
    public Version acquire() {
        return this.complete(this.asyncSemaphore.acquire(), 1);
    }

    @Override
    public Version acquire(int permits) {
        return this.complete(this.asyncSemaphore.acquire(permits), permits);
    }

    @Override
    public Optional<Version> tryAcquire() {
        return this.complete(this.asyncSemaphore.tryAcquire(), 1);
    }

    @Override
    public Optional<Version> tryAcquire(int permits) {
        return this.complete(this.asyncSemaphore.tryAcquire(permits), permits);
    }

    @Override
    public Optional<Version> tryAcquire(Duration timeout) {
        return this.complete(this.asyncSemaphore.tryAcquire(timeout), 1);
    }

    @Override
    public Optional<Version> tryAcquire(int permits, Duration timeout) {
        return this.complete(this.asyncSemaphore.tryAcquire(permits, timeout), permits);
    }

    @Override
    public void release() {
        this.complete(this.asyncSemaphore.release());
    }

    @Override
    public void release(int permits) {
        this.complete(this.asyncSemaphore.release(permits));
    }

    @Override
    public int availablePermits() {
        return this.complete(this.asyncSemaphore.availablePermits());
    }

    @Override
    public int drainPermits() {
        return this.complete(this.asyncSemaphore.drainPermits());
    }

    @Override
    public int increasePermits(int permits) {
        return this.complete(this.asyncSemaphore.increasePermits(permits));
    }

    @Override
    public int reducePermits(int permits) {
        return this.complete(this.asyncSemaphore.reducePermits(permits));
    }

    @Override
    public QueueStatus queueStatus() {
        return this.complete(this.asyncSemaphore.queueStatus());
    }

    @Override
    public AsyncAtomicSemaphore async() {
        return this.asyncSemaphore;
    }

    private <T> T complete(CompletableFuture<T> future) {
        return this.complete(future, 0);
    }

    private <T> T complete(CompletableFuture<T> future, int acquirePermits) {
        AtomicBoolean needRelease = new AtomicBoolean(false);
        try {
            return ((CompletableFuture)future.thenApply(version -> {
                if (needRelease.get() && version != null && acquirePermits > 0) {
                    this.asyncSemaphore.release(acquirePermits);
                }
                return version;
            })).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            needRelease.set(acquirePermits > 0);
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            needRelease.set(acquirePermits > 0);
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            needRelease.set(acquirePermits > 0);
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }
}

