/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import io.atomix.core.collection.impl.DefaultDistributedCollectionService;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.set.DistributedNavigableSetType;
import io.atomix.core.set.impl.AbstractDistributedSetService;
import io.atomix.core.set.impl.DistributedTreeSetService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import java.util.function.Function;

public class DefaultDistributedNavigableSetService<E extends Comparable<E>>
extends AbstractDistributedSetService<NavigableSet<E>, E>
implements DistributedTreeSetService<E> {
    private final Serializer serializer = Serializer.using((Namespace)Namespace.builder().register(DistributedNavigableSetType.instance().namespace()).register(new Class[]{SessionId.class}).register(new Class[]{DefaultDistributedCollectionService.IteratorContext.class}).register(new Class[]{SubSetIteratorContext.class}).register(new Class[]{DescendingIteratorContext.class}).register(new Class[]{DescendingSubSetIteratorContext.class}).build());

    public DefaultDistributedNavigableSetService() {
        super((PrimitiveType)DistributedNavigableSetType.instance(), new ConcurrentSkipListSet());
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    public E lower(E e) {
        return (E)((Comparable)((NavigableSet)this.set()).lower(e));
    }

    @Override
    public E floor(E e) {
        return (E)((Comparable)((NavigableSet)this.set()).floor(e));
    }

    @Override
    public E ceiling(E e) {
        return (E)((Comparable)((NavigableSet)this.set()).ceiling(e));
    }

    @Override
    public E higher(E e) {
        return (E)((Comparable)((NavigableSet)this.set()).higher(e));
    }

    @Override
    public E pollFirst() {
        return (E)((Comparable)((NavigableSet)this.set()).pollFirst());
    }

    @Override
    public E pollLast() {
        return (E)((Comparable)((NavigableSet)this.set()).pollLast());
    }

    @Override
    public E first() {
        return (E)(!((NavigableSet)this.set()).isEmpty() ? (Comparable)((NavigableSet)this.set()).first() : null);
    }

    @Override
    public E last() {
        return (E)(!((NavigableSet)this.set()).isEmpty() ? (Comparable)((NavigableSet)this.set()).last() : null);
    }

    @Override
    public E subSetFirst(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return (E)this.subSetApply(set -> !set.isEmpty() ? (Comparable)set.first() : null, fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public E subSetLast(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return (E)this.subSetApply(set -> !set.isEmpty() ? (Comparable)set.last() : null, fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public E subSetLower(E e, E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return (E)this.subSetApply(set -> set.lower(e), fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public E subSetFloor(E e, E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return (E)this.subSetApply(set -> set.floor(e), fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public E subSetCeiling(E e, E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return (E)this.subSetApply(set -> set.ceiling(e), fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public E subSetHigher(E e, E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return (E)this.subSetApply(set -> set.higher(e), fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public E subSetPollFirst(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return (E)this.subSetApply(set -> (Comparable)set.pollFirst(), fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public E subSetPollLast(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return (E)this.subSetApply(set -> (Comparable)set.pollLast(), fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public int subSetSize(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.subSetApply(set -> set.size(), fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public void subSetClear(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        this.subSetAccept(set -> set.clear(), fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public IteratorBatch<E> subSetIterate(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.iterate(sessionId -> new SubSetIteratorContext(this, sessionId.longValue(), fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public IteratorBatch<E> subSetIterateDescending(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.iterate(sessionId -> new DescendingSubSetIteratorContext(this, sessionId.longValue(), fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public IteratorBatch<E> iterateDescending() {
        return this.iterate(x$0 -> new DescendingIteratorContext((long)x$0));
    }

    private void subSetAccept(Consumer<NavigableSet<E>> function, E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        if (fromElement != null && toElement != null) {
            function.accept(((NavigableSet)this.set()).subSet(fromElement, fromInclusive, toElement, toInclusive));
        } else if (fromElement != null) {
            function.accept(((NavigableSet)this.set()).tailSet(fromElement, fromInclusive));
        } else if (toElement != null) {
            function.accept(((NavigableSet)this.set()).headSet(toElement, toInclusive));
        } else {
            function.accept((NavigableSet<E>)this.set());
        }
    }

    private <T> T subSetApply(Function<NavigableSet<E>, T> function, E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        if (fromElement != null && toElement != null) {
            return function.apply(((NavigableSet)this.set()).subSet(fromElement, fromInclusive, toElement, toInclusive));
        }
        if (fromElement != null) {
            return function.apply(((NavigableSet)this.set()).tailSet(fromElement, fromInclusive));
        }
        if (toElement != null) {
            return function.apply(((NavigableSet)this.set()).headSet(toElement, toInclusive));
        }
        return function.apply((NavigableSet<E>)this.set());
    }

    protected class DescendingSubSetIteratorContext
    extends DefaultDistributedCollectionService.AbstractIteratorContext {
        private final E fromElement;
        private final boolean fromInclusive;
        private final E toElement;
        private final boolean toInclusive;
        final /* synthetic */ DefaultDistributedNavigableSetService this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        DescendingSubSetIteratorContext(long fromElement, E toElement, boolean toInclusive, E e, boolean bl) {
            void fromInclusive;
            void sessionId;
            this.this$0 = (DefaultDistributedNavigableSetService)this$0;
            super((long)sessionId);
            this.fromElement = fromElement;
            this.fromInclusive = fromInclusive;
            this.toElement = toElement;
            this.toInclusive = toInclusive;
        }

        @Override
        protected Iterator<E> create() {
            return (Iterator)this.this$0.subSetApply(set -> set.descendingIterator(), this.fromElement, this.fromInclusive, this.toElement, this.toInclusive);
        }
    }

    protected class SubSetIteratorContext
    extends DefaultDistributedCollectionService.AbstractIteratorContext {
        private final E fromElement;
        private final boolean fromInclusive;
        private final E toElement;
        private final boolean toInclusive;
        final /* synthetic */ DefaultDistributedNavigableSetService this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        SubSetIteratorContext(long fromElement, E toElement, boolean toInclusive, E e, boolean bl) {
            void fromInclusive;
            void sessionId;
            this.this$0 = (DefaultDistributedNavigableSetService)this$0;
            super((long)sessionId);
            this.fromElement = fromElement;
            this.fromInclusive = fromInclusive;
            this.toElement = toElement;
            this.toInclusive = toInclusive;
        }

        @Override
        protected Iterator<E> create() {
            return (Iterator)this.this$0.subSetApply(set -> set.iterator(), this.fromElement, this.fromInclusive, this.toElement, this.toInclusive);
        }
    }

    protected class DescendingIteratorContext
    extends DefaultDistributedCollectionService.AbstractIteratorContext {
        public DescendingIteratorContext(long sessionId) {
            super(sessionId);
        }

        @Override
        protected Iterator<E> create() {
            return ((NavigableSet)DefaultDistributedNavigableSetService.this.collection()).descendingIterator();
        }
    }
}

