/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import com.google.common.base.Throwables;
import io.atomix.core.transaction.AsyncTransactionalSet;
import io.atomix.core.transaction.TransactionalSet;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingTransactionalSet<E>
implements TransactionalSet<E> {
    private final AsyncTransactionalSet<E> asyncSet;
    private final long operationTimeoutMillis;

    public BlockingTransactionalSet(AsyncTransactionalSet<E> asyncSet, long operationTimeoutMillis) {
        this.asyncSet = asyncSet;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    public String name() {
        return this.asyncSet.name();
    }

    public PrimitiveType type() {
        return this.asyncSet.type();
    }

    public PrimitiveProtocol protocol() {
        return this.asyncSet.protocol();
    }

    @Override
    public boolean add(E element) {
        return this.complete(this.asyncSet.add(element));
    }

    @Override
    public boolean remove(E element) {
        return this.complete(this.asyncSet.remove(element));
    }

    @Override
    public boolean contains(E element) {
        return this.complete(this.asyncSet.contains(element));
    }

    public void close() {
        this.complete(this.asyncSet.close());
    }

    @Override
    public AsyncTransactionalSet<E> async() {
        return this.asyncSet;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new PrimitiveException(e.getCause());
        }
    }
}

