/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.core.transaction.impl.TransactionalSetParticipant;
import io.atomix.primitive.protocol.ProxyProtocol;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class RepeatableReadsTransactionalSet<E>
extends TransactionalSetParticipant<E> {
    private final Map<E, CompletableFuture<Boolean>> cache = Maps.newConcurrentMap();
    private final Map<E, SetUpdate<E>> updates = Maps.newConcurrentMap();

    public RepeatableReadsTransactionalSet(TransactionId transactionId, AsyncDistributedSet<E> set) {
        super(transactionId, set);
    }

    @Override
    public ProxyProtocol protocol() {
        return (ProxyProtocol)this.set.protocol();
    }

    private CompletableFuture<Boolean> read(E element) {
        return this.cache.computeIfAbsent(element, this.set::contains);
    }

    @Override
    public CompletableFuture<Boolean> add(E e) {
        SetUpdate<E> update = this.updates.get(e);
        if (update != null) {
            switch (update.type()) {
                case ADD: {
                    return CompletableFuture.completedFuture(false);
                }
                case REMOVE: 
                case NOT_CONTAINS: {
                    this.updates.put(e, new SetUpdate<E>(SetUpdate.Type.ADD, e));
                    return CompletableFuture.completedFuture(true);
                }
                case CONTAINS: {
                    return CompletableFuture.completedFuture(false);
                }
            }
            throw new AssertionError();
        }
        return this.read(e).thenApply(exists -> {
            if (exists.booleanValue()) {
                this.updates.put(e, new SetUpdate<Object>(SetUpdate.Type.CONTAINS, e));
                return false;
            }
            this.updates.put(e, new SetUpdate<Object>(SetUpdate.Type.ADD, e));
            return true;
        });
    }

    @Override
    public CompletableFuture<Boolean> remove(E e) {
        SetUpdate<E> update = this.updates.get(e);
        if (update != null) {
            switch (update.type()) {
                case ADD: {
                    this.updates.put(e, new SetUpdate<E>(SetUpdate.Type.NOT_CONTAINS, e));
                    return CompletableFuture.completedFuture(true);
                }
                case REMOVE: 
                case NOT_CONTAINS: {
                    return CompletableFuture.completedFuture(false);
                }
                case CONTAINS: {
                    this.updates.put(e, new SetUpdate<E>(SetUpdate.Type.REMOVE, e));
                    return CompletableFuture.completedFuture(true);
                }
            }
            throw new AssertionError();
        }
        return this.read(e).thenApply(exists -> {
            if (exists.booleanValue()) {
                this.updates.put(e, new SetUpdate<Object>(SetUpdate.Type.REMOVE, e));
                return true;
            }
            this.updates.put(e, new SetUpdate<Object>(SetUpdate.Type.NOT_CONTAINS, e));
            return false;
        });
    }

    @Override
    public CompletableFuture<Boolean> contains(E e) {
        SetUpdate<E> update = this.updates.get(e);
        if (update != null) {
            switch (update.type()) {
                case ADD: 
                case CONTAINS: {
                    return CompletableFuture.completedFuture(true);
                }
                case REMOVE: 
                case NOT_CONTAINS: {
                    return CompletableFuture.completedFuture(false);
                }
            }
            throw new AssertionError();
        }
        return this.read(e);
    }

    @Override
    public TransactionLog<SetUpdate<E>> log() {
        return new TransactionLog<SetUpdate<E>>(this.transactionId, 0L, Lists.newArrayList(this.updates.values()));
    }
}

