/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.workqueue;

import com.google.common.base.MoreObjects;
import java.util.function.Function;

public class Task<E> {
    private final E payload;
    private final String taskId;

    private Task() {
        this.payload = null;
        this.taskId = null;
    }

    public Task(String taskId, E payload) {
        this.taskId = taskId;
        this.payload = payload;
    }

    public String taskId() {
        return this.taskId;
    }

    public E payload() {
        return this.payload;
    }

    public <F> Task<F> map(Function<E, F> mapper) {
        return new Task<F>(this.taskId, mapper.apply(this.payload));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("taskId", (Object)this.taskId).add("payload", this.payload).toString();
    }
}

